/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.7.9
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/clntdata.h>



PyDoc_STRVAR(doc_wxSharedClientDataContainer_GetClientData, "GetClientData() -> void\n"
"\n"
"Get the untyped client data.");

extern "C" {static PyObject *meth_wxSharedClientDataContainer_GetClientData(PyObject *, PyObject *);}
static PyObject *meth_wxSharedClientDataContainer_GetClientData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxSharedClientDataContainer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSharedClientDataContainer, &sipCpp))
        {
            void*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetClientData();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_SharedClientDataContainer, sipName_GetClientData, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSharedClientDataContainer_GetClientObject, "GetClientObject() -> ClientData\n"
"\n"
"Get a pointer to the client data object.");

extern "C" {static PyObject *meth_wxSharedClientDataContainer_GetClientObject(PyObject *, PyObject *);}
static PyObject *meth_wxSharedClientDataContainer_GetClientObject(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxSharedClientDataContainer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSharedClientDataContainer, &sipCpp))
        {
             ::wxClientData*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetClientObject();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxClientData,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_SharedClientDataContainer, sipName_GetClientObject, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSharedClientDataContainer_SetClientData, "SetClientData(data)\n"
"\n"
"Set the untyped client data.");

extern "C" {static PyObject *meth_wxSharedClientDataContainer_SetClientData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSharedClientDataContainer_SetClientData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        void* data;
         ::wxSharedClientDataContainer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bv", &sipSelf, sipType_wxSharedClientDataContainer, &sipCpp, &data))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetClientData(data);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_SharedClientDataContainer, sipName_SetClientData, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSharedClientDataContainer_SetClientObject, "SetClientObject(data)\n"
"\n"
"Set the client data object.");

extern "C" {static PyObject *meth_wxSharedClientDataContainer_SetClientObject(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSharedClientDataContainer_SetClientObject(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxClientData* data;
        int dataState = 0;
         ::wxSharedClientDataContainer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ0", &sipSelf, sipType_wxSharedClientDataContainer, &sipCpp, sipType_wxClientData, &data, &dataState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetClientObject(data);
            Py_END_ALLOW_THREADS
            sipReleaseType(data, sipType_wxClientData, dataState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_SharedClientDataContainer, sipName_SetClientObject, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxSharedClientDataContainer(void *, int);}
static void release_wxSharedClientDataContainer(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxSharedClientDataContainer *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxSharedClientDataContainer(Py_ssize_t);}
static void *array_wxSharedClientDataContainer(Py_ssize_t sipNrElem)
{
    return new  ::wxSharedClientDataContainer[sipNrElem];
}


extern "C" {static void assign_wxSharedClientDataContainer(void *, Py_ssize_t, void *);}
static void assign_wxSharedClientDataContainer(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxSharedClientDataContainer *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxSharedClientDataContainer *>(sipSrc);
}


extern "C" {static void *copy_wxSharedClientDataContainer(const void *, Py_ssize_t);}
static void *copy_wxSharedClientDataContainer(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::wxSharedClientDataContainer(reinterpret_cast<const  ::wxSharedClientDataContainer *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxSharedClientDataContainer(sipSimpleWrapper *);}
static void dealloc_wxSharedClientDataContainer(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxSharedClientDataContainer(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxSharedClientDataContainer(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxSharedClientDataContainer(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxSharedClientDataContainer *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxSharedClientDataContainer();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const  ::wxSharedClientDataContainer* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxSharedClientDataContainer, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxSharedClientDataContainer(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxSharedClientDataContainer[] = {
    {sipName_GetClientData, meth_wxSharedClientDataContainer_GetClientData, METH_VARARGS, doc_wxSharedClientDataContainer_GetClientData},
    {sipName_GetClientObject, meth_wxSharedClientDataContainer_GetClientObject, METH_VARARGS, doc_wxSharedClientDataContainer_GetClientObject},
    {sipName_SetClientData, SIP_MLMETH_CAST(meth_wxSharedClientDataContainer_SetClientData), METH_VARARGS|METH_KEYWORDS, doc_wxSharedClientDataContainer_SetClientData},
    {sipName_SetClientObject, SIP_MLMETH_CAST(meth_wxSharedClientDataContainer_SetClientObject), METH_VARARGS|METH_KEYWORDS, doc_wxSharedClientDataContainer_SetClientObject}
};

sipVariableDef variables_wxSharedClientDataContainer[] = {
    {PropertyVariable, sipName_ClientObject, &methods_wxSharedClientDataContainer[1], &methods_wxSharedClientDataContainer[3], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ClientData, &methods_wxSharedClientDataContainer[0], &methods_wxSharedClientDataContainer[2], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxSharedClientDataContainer, "This class is a replacement for wxClientDataContainer, and unlike\n"
"wxClientDataContainer the wxSharedClientDataContainer client data is\n"
"copiable, so it can be copied when objects containing it are cloned.");


sipClassTypeDef sipTypeDef__core_wxSharedClientDataContainer = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxSharedClientDataContainer,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_SharedClientDataContainer,
        {0, 0, 1},
        4, methods_wxSharedClientDataContainer,
        0, SIP_NULLPTR,
        2, variables_wxSharedClientDataContainer,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxSharedClientDataContainer,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxSharedClientDataContainer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxSharedClientDataContainer,
    assign_wxSharedClientDataContainer,
    array_wxSharedClientDataContainer,
    copy_wxSharedClientDataContainer,
    release_wxSharedClientDataContainer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
