/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.7.9
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/bitmap.h>
        #include <wx/gdicmn.h>
        #include <wx/dc.h>
        #include <wx/image.h>
        #include <wx/colour.h>
        #include <wx/palette.h>
        #include <wx/bitmap.h>
        #include <wx/gdicmn.h>
        #include <wx/icon.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
        //--------------------------------------------------------------------------
        // Name:        src/bitmap_ex.h
        // Purpose:     Helper functions and etc. for copying bitmap data to/from
        //              buffer objects.  This file is included in etg/bitmap.py and
        //              used in the wxBitmap wrapper.
        //
        // Author:      Robin Dunn
        //
        // Created:     27-Apr-2012
        // Copyright:   (c) 2012-2020 by Total Control Software
        // Licence:     wxWindows license
        //--------------------------------------------------------------------------
        
        
        #include <wx/rawbmp.h>
        
        // TODO: Switch these APIs to use the new wxPyBuffer class
        
        void wxPyCopyBitmapFromBuffer(wxBitmap* bmp,
                                      buffer data, Py_ssize_t DATASIZE,
                                      wxBitmapBufferFormat format, int stride)
        {
            int height = bmp->GetHeight();
            int width = bmp->GetWidth();
        
            switch (format) {
                // A simple sequence of RGB bytes
                case wxBitmapBufferFormat_RGB:
                {
                    if (DATASIZE < width * height * 3) {
                        wxPyErr_SetString(PyExc_ValueError, "Invalid data buffer size.");
                        return;
                    }
                    wxNativePixelData pixData(*bmp, wxPoint(0,0), wxSize(width, height));
                    if (! pixData) {
                        wxPyErr_SetString(PyExc_RuntimeError,
                                          "Failed to gain raw access to bitmap data.");
                        return;
                    }
        
                    wxNativePixelData::Iterator p(pixData);
                    for (int y=0; y<height; y++) {
                        wxNativePixelData::Iterator rowStart = p;
                        for (int x=0; x<width; x++) {
                            p.Red()   = *(data++);
                            p.Green() = *(data++);
                            p.Blue()  = *(data++);
                            ++p;
                        }
                        p = rowStart;
                        p.OffsetY(pixData, 1);
                    }
                    break;
                }
        
                // A simple sequence of RGBA bytes
                case wxBitmapBufferFormat_RGBA:
                {
                    if (DATASIZE < width * height * 4) {
                        wxPyErr_SetString(PyExc_ValueError, "Invalid data buffer size.");
                        return;
                    }
                    wxAlphaPixelData pixData(*bmp, wxPoint(0,0), wxSize(width, height));
                    if (! pixData) {
                        wxPyErr_SetString(PyExc_RuntimeError,
                                          "Failed to gain raw access to bitmap data.");
                        return;
                    }
                    wxAlphaPixelData::Iterator p(pixData);
                    for (int y=0; y<height; y++) {
                        wxAlphaPixelData::Iterator rowStart = p;
                        for (int x=0; x<width; x++) {
                            byte a = data[3];
                            p.Red()   = wxPy_premultiply(*(data++), a);
                            p.Green() = wxPy_premultiply(*(data++), a);
                            p.Blue()  = wxPy_premultiply(*(data++), a);
                            p.Alpha() = a; data++;
                            ++p;
                        }
                        p = rowStart;
                        p.OffsetY(pixData, 1);
                    }
                    break;
                }
        
                // A sequence of 32-bit values in native endian order,
                // where the alpha is in the upper 8 bits, then red, then
                // green, then blue.  The stride is the distance in bytes
                // from the beginning of one row of the image data to the
                // beginning of the next row.  This may not be the same as
                // width*4 if alignment or platform specific optimizations
                // have been utilized.
        
                // NOTE: This is normally used with Cairo, which seems to
                // already have the values premultiplied.  Should we have
                // a way to optionally do it anyway?
        
                case wxBitmapBufferFormat_RGB32:
                case wxBitmapBufferFormat_ARGB32:
                {
                    bool useAlpha = (format == wxBitmapBufferFormat_ARGB32);
                    byte* rowStart = data;
                    wxUint32* bufptr;
                    wxUint32  value;
        
                    if (stride == -1)
                        stride = width * 4;
        
                    if (DATASIZE < stride * height) {
                        wxPyErr_SetString(PyExc_ValueError, "Invalid data buffer size.");
                        return;
                    }
        
                    wxAlphaPixelData pixData(*bmp, wxPoint(0,0), wxSize(width,height));
                    if (! pixData) {
                        wxPyErr_SetString(PyExc_RuntimeError,
                                          "Failed to gain raw access to bitmap data.");
                        return;
                    }
        
                    wxAlphaPixelData::Iterator pix(pixData);
                    for (int y=0; y<height; y++) {
                        pix.MoveTo(pixData, 0, y);
                        bufptr = (wxUint32*)rowStart;
                        for (int x=0; x<width; x++) {
                            value = *bufptr;
                            pix.Alpha() = useAlpha ? (value >> 24) & 0xFF : 255;
                            pix.Red()   = (value >> 16) & 0xFF;
                            pix.Green() = (value >>  8) & 0xFF;
                            pix.Blue()  = (value >>  0) & 0xFF;
                            ++pix;
                            ++bufptr;
                        }
                        rowStart += stride;
                    }
                    break;
                }
            }
        }
        
        
        // Some helper macros used below to help declutter the code
        #define MAKE_PIXDATA(type) \
            type pixData(*bmp, wxPoint(0,0), wxSize(width, height)); \
            if (! pixData) { \
                wxPyErr_SetString(PyExc_RuntimeError, "Failed to gain raw access to bitmap data."); \
                return; \
            } \
            type::Iterator p(pixData); \
            type::Iterator rowStart
        
        #define CHECK_BUFFERSIZE(size_needed) \
            if (DATASIZE < size_needed) { \
                wxPyErr_SetString(PyExc_ValueError, "Invalid data buffer size."); \
                return; \
            }
        
        
        void wxPyCopyBitmapToBuffer(wxBitmap* bmp,
                                    buffer data, Py_ssize_t DATASIZE,
                                    wxBitmapBufferFormat format, int stride)
        {
            int height = bmp->GetHeight();
            int width = bmp->GetWidth();
            int depth = bmp->GetDepth();
        
            // images loaded from a file may not have set the depth, at least on Mac...
            if (depth == -1) {
                if (bmp->HasAlpha())
                    depth = 32;
                else
                    depth = 24;
            }
        
            switch (format) {
                // A simple sequence of RGB bytes
                case wxBitmapBufferFormat_RGB:
                {
                    CHECK_BUFFERSIZE(width * height * 3);
                    if (depth == 24) {
                        MAKE_PIXDATA(wxNativePixelData);
        
                        for (int y=0; y<height; y++) {
                            rowStart = p;
                            for (int x=0; x<width; x++) {
                                *(data++) = p.Red();
                                *(data++) = p.Green();
                                *(data++) = p.Blue();
                                ++p;
                            }
                            p = rowStart;
                            p.OffsetY(pixData, 1);
                        }
                    }
                    if (depth == 32) {
                        // Source has alpha, but we won't be using it because the
                        // destination buffer doesn't
                        MAKE_PIXDATA(wxAlphaPixelData);
        
                        for (int y=0; y<height; y++) {
                            rowStart = p;
                            for (int x=0; x<width; x++) {
                                *(data++) = p.Red();
                                *(data++) = p.Green();
                                *(data++) = p.Blue();
                                ++p;
                            }
                            p = rowStart;
                            p.OffsetY(pixData, 1);
                        }
                    }
                    break;
                }
        
                // A simple sequence of RGBA bytes
                case wxBitmapBufferFormat_RGBA:
                {
                    CHECK_BUFFERSIZE(width * height * 4);
                    if (depth == 24) {
                        MAKE_PIXDATA(wxNativePixelData);
                        for (int y=0; y<height; y++) {
                            rowStart = p;
                            for (int x=0; x<width; x++) {
                                byte a = wxALPHA_OPAQUE;
                                *(data++) = wxPy_unpremultiply(p.Red(), a);
                                *(data++) = wxPy_unpremultiply(p.Green(), a);
                                *(data++) = wxPy_unpremultiply(p.Blue(), a);
                                *(data++) = a;
                                ++p;
                            }
                            p = rowStart;
                            p.OffsetY(pixData, 1);
                        }
                    }
                    if (depth == 32) {
                        MAKE_PIXDATA(wxAlphaPixelData);
                        for (int y=0; y<height; y++) {
                            rowStart = p;
                            for (int x=0; x<width; x++) {
                                byte a = p.Alpha();
                                *(data++) = wxPy_unpremultiply(p.Red(), a);
                                *(data++) = wxPy_unpremultiply(p.Green(), a);
                                *(data++) = wxPy_unpremultiply(p.Blue(), a);
                                *(data++) = a;
                                ++p;
                            }
                            p = rowStart;
                            p.OffsetY(pixData, 1);
                        }
                    }
                    break;
                }
        
                // A sequence of 32-bit values in native endian order,
                // where the alpha is in the upper 8 bits, then red, then
                // green, then blue.  The stride is the distance in bytes
                // from the beginning of one row of the image data to the
                // beginning of the next row.  This may not be the same as
                // width*4 if alignment or platform specific optimizations
                // have been utilized.
        
                // NOTE: This is normally used with Cairo, which seems to
                // already have the values premultiplied.  Should we have
                // a way to optionally do it anyway?
        
                case wxBitmapBufferFormat_RGB32:
                case wxBitmapBufferFormat_ARGB32:
                {
                    bool useAlpha = (format == wxBitmapBufferFormat_ARGB32);
                    byte* dataRow = data;
                    wxUint32* bufptr;
                    wxUint32  value;
        
                    if (stride == -1)
                        stride = width * 4;
        
                    CHECK_BUFFERSIZE(stride * height);
        
                    if (useAlpha && depth == 32) {
                        MAKE_PIXDATA(wxAlphaPixelData);
                        for (int y=0; y<height; y++) {
                            p.MoveTo(pixData, 0, y);
                            bufptr = (wxUint32*)dataRow;
                            for (int x=0; x<width; x++) {
                                value =
                                    (p.Alpha() << 24) |
                                    (p.Red() << 16) |
                                    (p.Green() << 8) |
                                    (p.Blue());
                                *bufptr = value;
                                ++p;
                                ++bufptr;
                            }
                            dataRow += stride;
                        }
                    }
                    else // if (!useAlpha /*depth == 24*/)
                    {
                        MAKE_PIXDATA(wxNativePixelData);
                        for (int y=0; y<height; y++) {
                            p.MoveTo(pixData, 0, y);
                            bufptr = (wxUint32*)dataRow;
                            for (int x=0; x<width; x++) {
                                value =
                                    (wxALPHA_OPAQUE << 24) |
                                    (p.Red() << 16) |
                                    (p.Green() << 8) |
                                    (p.Blue());
                                *bufptr = value;
                                ++p;
                                ++bufptr;
                            }
                            dataRow += stride;
                        }
                    }
                    break;
                }
            }
        }
        
        //--------------------------------------------------------------------------
    wxBitmap* _wxBitmap_ctor(PyObject* listOfBytes)
    {
        wxPyThreadBlocker blocker;
        char**    cArray = NULL;
        int       count;
        char      errMsg[] = "Expected a list of bytes objects.";
        
        if (!PyList_Check(listOfBytes)) {
            PyErr_SetString(PyExc_TypeError, errMsg);
            return NULL;
        }
        count = PyList_Size(listOfBytes);
        cArray = new char*[count];
        
        for(int x=0; x<count; x++) {
            PyObject* item = PyList_GET_ITEM(listOfBytes, x);
            if (!PyBytes_Check(item)) {
                PyErr_SetString(PyExc_TypeError, errMsg);
                delete [] cArray;
                return NULL;
            }
            cArray[x] = PyBytes_AsString(item);
        }
        wxBitmap* bmp = new wxBitmap(cArray);
        delete [] cArray;
        return bmp;
    }
    void _wxBitmap_SetMaskColour(wxBitmap* self, const wxColour* colour)
    {
        wxMask* mask = new wxMask(*self, *colour);
        self->SetMask(mask);
    }
    int _wxBitmap___nonzero__(wxBitmap* self)
    {
        return self->IsOk();
    }
    int _wxBitmap___bool__(wxBitmap* self)
    {
        return self->IsOk();
    }
    long _wxBitmap_GetHandle(wxBitmap* self)
    {
        #ifdef __WXMSW__
            return HandleToLong(self->GetHandle());
        #else
            return 0;
        #endif
    }
    void _wxBitmap_SetHandle(wxBitmap* self, long handle)
    {
        #ifdef __WXMSW__
            self->SetHandle((WXHANDLE)LongToHandle(handle));
        #endif
    }
    void _wxBitmap_SetSize(wxBitmap* self, const wxSize* size)
    {
        self->SetWidth(size->x);
        self->SetHeight(size->y);
    }
    void _wxBitmap_CopyFromBuffer(wxBitmap* self, wxPyBuffer* data, wxBitmapBufferFormat format, int stride)
    {
        wxPyCopyBitmapFromBuffer(self, (byte*)data->m_ptr, data->m_len, format, stride);
    }
    void _wxBitmap_CopyToBuffer(wxBitmap* self, wxPyBuffer* data, wxBitmapBufferFormat format, int stride)
    {
        wxPyCopyBitmapToBuffer(self, (byte*)data->m_ptr, data->m_len, format, stride);
    }
    wxBitmap* _wxBitmap_FromBufferAndAlpha(int width, int height, wxPyBuffer* data, wxPyBuffer* alpha)
    {
        if (!data->checkSize(width*height*3) || !alpha->checkSize(width*height))
            return NULL;
        
        byte* ddata = (byte*)data->m_ptr;
        byte* adata = (byte*)alpha->m_ptr;
        wxBitmap* bmp = new wxBitmap(width, height, 32);
        
        wxAlphaPixelData pixData(*bmp, wxPoint(0,0), wxSize(width,height));
        if (! pixData) {
            wxPyErr_SetString(PyExc_RuntimeError, "Failed to gain raw access to bitmap data.");
            return NULL;
        }
        
        wxAlphaPixelData::Iterator p(pixData);
        for (int y=0; y<height; y++) {
            wxAlphaPixelData::Iterator rowStart = p;
            for (int x=0; x<width; x++) {
                byte a = *(adata++);
                p.Red()   = wxPy_premultiply(*(ddata++), a);
                p.Green() = wxPy_premultiply(*(ddata++), a);
                p.Blue()  = wxPy_premultiply(*(ddata++), a);
                p.Alpha() = a;
                ++p;
            }
            p = rowStart;
            p.OffsetY(pixData, 1);
        }
        return bmp;
    }
    wxBitmap* _wxBitmap_FromBuffer(int width, int height, wxPyBuffer* data)
    {
        wxBitmap* bmp = new wxBitmap(width, height, 24);
        wxPyCopyBitmapFromBuffer(bmp, (byte*)data->m_ptr, data->m_len, wxBitmapBufferFormat_RGB);
        wxPyThreadBlocker blocker;
        if (PyErr_Occurred()) {
            delete bmp;
            bmp = NULL;
        }
        return bmp;
    }
    wxBitmap* _wxBitmap_FromBufferRGBA(int width, int height, wxPyBuffer* data)
    {
        wxBitmap* bmp = new wxBitmap(width, height, 32);
        wxPyCopyBitmapFromBuffer(bmp, (byte*)data->m_ptr, data->m_len, wxBitmapBufferFormat_RGBA);
        wxPyThreadBlocker blocker;
        if (PyErr_Occurred()) {
            delete bmp;
            bmp = NULL;
        }
        return bmp;
    }
    wxBitmap* _wxBitmap_FromRGBA(int width, int height, byte red, byte green, byte blue, byte alpha)
    {
        if ( !(width > 0 && height > 0) ) {
            wxPyErr_SetString(PyExc_ValueError, "Width and height must be greater than zero");
            return NULL;
        }
        
        wxBitmap* bmp = new wxBitmap(width, height, 32);
        wxAlphaPixelData pixData(*bmp, wxPoint(0,0), wxSize(width,height));
        if (! pixData) {
            wxPyErr_SetString(PyExc_RuntimeError, "Failed to gain raw access to bitmap data.");
            return NULL;
        }
        
        wxAlphaPixelData::Iterator p(pixData);
        for (int y=0; y<height; y++) {
            wxAlphaPixelData::Iterator rowStart = p;
            for (int x=0; x<width; x++) {
                p.Red()   = wxPy_premultiply(red, alpha);
                p.Green() = wxPy_premultiply(green, alpha);
                p.Blue()  = wxPy_premultiply(blue, alpha);
                p.Alpha() = alpha;
                ++p;
            }
            p = rowStart;
            p.OffsetY(pixData, 1);
        }
        return bmp;
    }
    wxBitmap* _wxBitmap_FromPNGData(wxPyBuffer* data)
    {
        wxBitmap bmp = wxBitmap::NewFromPNGData(data->m_ptr, data->m_len);
        return new wxBitmap(bmp);
    }


PyDoc_STRVAR(doc_wxBitmap_ConvertToDisabled, "ConvertToDisabled(brightness=255) -> Bitmap\n"
"\n"
"Returns disabled (dimmed) version of the bitmap.");

extern "C" {static PyObject *meth_wxBitmap_ConvertToDisabled(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_ConvertToDisabled(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        unsigned char brightness = 255;
        const  ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_brightness,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|c", &sipSelf, sipType_wxBitmap, &sipCpp, &brightness))
        {
             ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxBitmap(sipCpp->ConvertToDisabled(brightness));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_ConvertToDisabled, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_ConvertToImage, "ConvertToImage() -> Image\n"
"\n"
"Creates an image from a platform-dependent bitmap.");

extern "C" {static PyObject *meth_wxBitmap_ConvertToImage(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_ConvertToImage(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage(sipCpp->ConvertToImage());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_ConvertToImage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_CopyFromIcon, "CopyFromIcon(icon) -> bool\n"
"\n"
"Creates the bitmap from an icon.");

extern "C" {static PyObject *meth_wxBitmap_CopyFromIcon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_CopyFromIcon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxIcon* icon;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_icon,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxBitmap, &sipCpp, sipType_wxIcon, &icon))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CopyFromIcon(*icon);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_CopyFromIcon, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_Create, "Create(width, height, depth=BITMAP_SCREEN_DEPTH) -> bool\n"
"Create(sz, depth=BITMAP_SCREEN_DEPTH) -> bool\n"
"Create(width, height, dc) -> bool\n"
"\n"
"Creates a fresh bitmap.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxBitmap_Create(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_Create(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int width;
        int height;
        int depth = wxBITMAP_SCREEN_DEPTH;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_depth,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii|i", &sipSelf, sipType_wxBitmap, &sipCpp, &width, &height, &depth))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Create(width,height,depth);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::wxSize* sz;
        int szState = 0;
        int depth = wxBITMAP_SCREEN_DEPTH;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sz,
            sipName_depth,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|i", &sipSelf, sipType_wxBitmap, &sipCpp, sipType_wxSize, &sz, &szState, &depth))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Create(*sz,depth);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(sz), sipType_wxSize, szState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        int width;
        int height;
        const  ::wxDC* dc;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_dc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiiJ9", &sipSelf, sipType_wxBitmap, &sipCpp, &width, &height, sipType_wxDC, &dc))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Create(width,height,*dc);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_Create, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_CreateWithDIPSize, "CreateWithDIPSize(size, scale, depth=BITMAP_SCREEN_DEPTH) -> bool\n"
"CreateWithDIPSize(width, height, scale, depth=BITMAP_SCREEN_DEPTH) -> bool\n"
"\n"
"Create a bitmap specifying its size in DPI-independent pixels and the\n"
"scale factor to use.\n"
"");

extern "C" {static PyObject *meth_wxBitmap_CreateWithDIPSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_CreateWithDIPSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxSize* size;
        int sizeState = 0;
        double scale;
        int depth = wxBITMAP_SCREEN_DEPTH;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
            sipName_scale,
            sipName_depth,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1d|i", &sipSelf, sipType_wxBitmap, &sipCpp, sipType_wxSize, &size, &sizeState, &scale, &depth))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CreateWithDIPSize(*size,scale,depth);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size), sipType_wxSize, sizeState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        int width;
        int height;
        double scale;
        int depth = wxBITMAP_SCREEN_DEPTH;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_scale,
            sipName_depth,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biid|i", &sipSelf, sipType_wxBitmap, &sipCpp, &width, &height, &scale, &depth))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CreateWithDIPSize(width,height,scale,depth);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_CreateWithDIPSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_CreateScaled, "CreateScaled(width, height, depth, logicalScale) -> bool\n"
"\n"
"Create a bitmap with a scale factor.");

extern "C" {static PyObject *meth_wxBitmap_CreateScaled(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_CreateScaled(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int width;
        int height;
        int depth;
        double logicalScale;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_depth,
            sipName_logicalScale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiid", &sipSelf, sipType_wxBitmap, &sipCpp, &width, &height, &depth, &logicalScale))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CreateScaled(width,height,depth,logicalScale);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_CreateScaled, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_GetDepth, "GetDepth() -> int\n"
"\n"
"Gets the colour depth of the bitmap.");

extern "C" {static PyObject *meth_wxBitmap_GetDepth(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_GetDepth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDepth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_GetDepth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_GetDIPSize, "GetDIPSize() -> Size\n"
"\n"
"Returns the size of bitmap in DPI-independent units.");

extern "C" {static PyObject *meth_wxBitmap_GetDIPSize(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_GetDIPSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
             ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxSize(sipCpp->GetDIPSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxSize,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_GetDIPSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_GetHeight, "GetHeight() -> int\n"
"\n"
"Returns the height of the bitmap in physical pixels.");

extern "C" {static PyObject *meth_wxBitmap_GetHeight(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_GetHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetHeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_GetHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_GetLogicalHeight, "GetLogicalHeight() -> double\n"
"\n"
"Returns the height of the bitmap in logical pixels.");

extern "C" {static PyObject *meth_wxBitmap_GetLogicalHeight(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_GetLogicalHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLogicalHeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_GetLogicalHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_GetLogicalSize, "GetLogicalSize() -> Size\n"
"\n"
"Returns the size of the bitmap in logical pixels.");

extern "C" {static PyObject *meth_wxBitmap_GetLogicalSize(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_GetLogicalSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
             ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxSize(sipCpp->GetLogicalSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxSize,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_GetLogicalSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_GetLogicalWidth, "GetLogicalWidth() -> double\n"
"\n"
"Returns the width of the bitmap in logical pixels.");

extern "C" {static PyObject *meth_wxBitmap_GetLogicalWidth(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_GetLogicalWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLogicalWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_GetLogicalWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_GetMask, "GetMask() -> Mask\n"
"\n"
"Gets the associated mask (if any) which may have been loaded from a\n"
"file or set for the bitmap.");

extern "C" {static PyObject *meth_wxBitmap_GetMask(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_GetMask(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
             ::wxMask*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMask();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxMask,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_GetMask, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_GetPalette, "GetPalette() -> Palette\n"
"\n"
"Gets the associated palette (if any) which may have been loaded from a\n"
"file or set for the bitmap.");

extern "C" {static PyObject *meth_wxBitmap_GetPalette(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_GetPalette(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
             ::wxPalette*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPalette();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxPalette,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_GetPalette, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_GetSubBitmap, "GetSubBitmap(rect) -> Bitmap\n"
"\n"
"Returns a sub bitmap of the current one as long as the rect belongs\n"
"entirely to the bitmap.");

extern "C" {static PyObject *meth_wxBitmap_GetSubBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_GetSubBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRect* rect;
        int rectState = 0;
        const  ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxBitmap, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
             ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxBitmap(sipCpp->GetSubBitmap(*rect));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_GetSubBitmap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_GetScaleFactor, "GetScaleFactor() -> double\n"
"\n"
"Returns the scale factor of this bitmap.");

extern "C" {static PyObject *meth_wxBitmap_GetScaleFactor(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_GetScaleFactor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetScaleFactor();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_GetScaleFactor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_GetScaledHeight, "GetScaledHeight() -> double\n"
"\n"
"Returns the height of the bitmap in logical pixels.");

extern "C" {static PyObject *meth_wxBitmap_GetScaledHeight(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_GetScaledHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetScaledHeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_GetScaledHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_GetScaledSize, "GetScaledSize() -> Size\n"
"\n"
"Returns the size of the bitmap in logical pixels.");

extern "C" {static PyObject *meth_wxBitmap_GetScaledSize(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_GetScaledSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
             ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxSize(sipCpp->GetScaledSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxSize,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_GetScaledSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_GetScaledWidth, "GetScaledWidth() -> double\n"
"\n"
"Returns the width of the bitmap in logical pixels.");

extern "C" {static PyObject *meth_wxBitmap_GetScaledWidth(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_GetScaledWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetScaledWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_GetScaledWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_GetSize, "GetSize() -> Size\n"
"\n"
"Returns the size of the bitmap in physical pixels.");

extern "C" {static PyObject *meth_wxBitmap_GetSize(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_GetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
             ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxSize(sipCpp->GetSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxSize,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_GetSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_GetWidth, "GetWidth() -> int\n"
"\n"
"Returns the width of the bitmap in physical pixels.");

extern "C" {static PyObject *meth_wxBitmap_GetWidth(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_GetWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_GetWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_HasAlpha, "HasAlpha() -> bool\n"
"\n"
"Returns true if the bitmap has an alpha channel.");

extern "C" {static PyObject *meth_wxBitmap_HasAlpha(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_HasAlpha(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasAlpha();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_HasAlpha, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if bitmap data is present.");

extern "C" {static PyObject *meth_wxBitmap_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_LoadFile, "LoadFile(name, type=BITMAP_TYPE_ANY) -> bool\n"
"\n"
"Loads a bitmap from a file or resource.");

extern "C" {static PyObject *meth_wxBitmap_LoadFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_LoadFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxBitmapType type = wxBITMAP_TYPE_ANY;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|E", &sipSelf, sipType_wxBitmap, &sipCpp, sipType_wxString, &name, &nameState, sipType_wxBitmapType, &type))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadFile(*name,type);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_LoadFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_ResetAlpha, "ResetAlpha()\n"
"\n"
"Remove alpha channel from the bitmap.");

extern "C" {static PyObject *meth_wxBitmap_ResetAlpha(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_ResetAlpha(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ResetAlpha();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_ResetAlpha, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_SaveFile, "SaveFile(name, type, palette=None) -> bool\n"
"\n"
"Saves a bitmap in the named file.");

extern "C" {static PyObject *meth_wxBitmap_SaveFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_SaveFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxBitmapType type;
        const  ::wxPalette* palette = 0;
        const  ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_type,
            sipName_palette,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1E|J8", &sipSelf, sipType_wxBitmap, &sipCpp, sipType_wxString, &name, &nameState, sipType_wxBitmapType, &type, sipType_wxPalette, &palette))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SaveFile(*name,type,palette);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_SaveFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_SetDepth, "SetDepth(depth)");

extern "C" {static PyObject *meth_wxBitmap_SetDepth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_SetDepth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int depth;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_depth,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxBitmap, &sipCpp, &depth))
        {
            if (sipDeprecated(sipName_Bitmap,sipName_SetDepth) < 0)
                return SIP_NULLPTR;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDepth(depth);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_SetDepth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_SetHeight, "SetHeight(height)");

extern "C" {static PyObject *meth_wxBitmap_SetHeight(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_SetHeight(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int height;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxBitmap, &sipCpp, &height))
        {
            if (sipDeprecated(sipName_Bitmap,sipName_SetHeight) < 0)
                return SIP_NULLPTR;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHeight(height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_SetHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_SetScaleFactor, "SetScaleFactor(scale)\n"
"\n"
"Sets the bitmap scale factor.");

extern "C" {static PyObject *meth_wxBitmap_SetScaleFactor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_SetScaleFactor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double scale;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_scale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bd", &sipSelf, sipType_wxBitmap, &sipCpp, &scale))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetScaleFactor(scale);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_SetScaleFactor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_SetMask, "SetMask(mask)\n"
"\n"
"Sets the mask for this bitmap.");

extern "C" {static PyObject *meth_wxBitmap_SetMask(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_SetMask(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxMask* mask;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_wxBitmap, &sipCpp, sipType_wxMask, &mask))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMask(mask);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_SetMask, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_SetPalette, "SetPalette(palette)\n"
"\n"
"Sets the associated palette.");

extern "C" {static PyObject *meth_wxBitmap_SetPalette(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_SetPalette(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPalette* palette;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_palette,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxBitmap, &sipCpp, sipType_wxPalette, &palette))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPalette(*palette);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_SetPalette, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_SetWidth, "SetWidth(width)");

extern "C" {static PyObject *meth_wxBitmap_SetWidth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_SetWidth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int width;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxBitmap, &sipCpp, &width))
        {
            if (sipDeprecated(sipName_Bitmap,sipName_SetWidth) < 0)
                return SIP_NULLPTR;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetWidth(width);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_SetWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_UseAlpha, "UseAlpha(use=True)\n"
"\n"
"Enable or disable use of alpha channel in this bitmap.");

extern "C" {static PyObject *meth_wxBitmap_UseAlpha(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_UseAlpha(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool use = 1;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_use,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxBitmap, &sipCpp, &use))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->UseAlpha(use);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_UseAlpha, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_NewFromPNGData, "NewFromPNGData(data, size) -> Bitmap\n"
"\n"
"Loads a bitmap from the memory containing image data in PNG format.");

extern "C" {static PyObject *meth_wxBitmap_NewFromPNGData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_NewFromPNGData(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const void* data;
        size_t size;

        static const char *sipKwdList[] = {
            sipName_data,
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "v=", &data, &size))
        {
             ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxBitmap( ::wxBitmap::NewFromPNGData(data,size));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_NewFromPNGData, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_Rescale, "Rescale(bmp, sizeNeeded)\n"
"\n"
"Rescale the given bitmap to the requested size.");

extern "C" {static PyObject *meth_wxBitmap_Rescale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_Rescale(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxBitmap* bmp;
        const  ::wxSize* sizeNeeded;
        int sizeNeededState = 0;

        static const char *sipKwdList[] = {
            sipName_bmp,
            sipName_sizeNeeded,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J9J1", sipType_wxBitmap, &bmp, sipType_wxSize, &sizeNeeded, &sizeNeededState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxBitmap::Rescale(*bmp,*sizeNeeded);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(sizeNeeded), sipType_wxSize, sizeNeededState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_Rescale, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_SetMaskColour, "SetMaskColour(colour)\n"
"\n"
"Create a mask for this bitmap based on the pixels with the given\n"
"colour.");

extern "C" {static PyObject *meth_wxBitmap_SetMaskColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_SetMaskColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxColour* colour;
        int colourState = 0;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxBitmap, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxBitmap_SetMaskColour(sipCpp, colour);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_SetMaskColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap___nonzero__, "__nonzero__() -> int");

extern "C" {static PyObject *meth_wxBitmap___nonzero__(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap___nonzero__(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxBitmap___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName___nonzero__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_GetHandle, "GetHandle() -> long\n"
"\n"
"MSW-only method to fetch the windows handle for the bitmap.");

extern "C" {static PyObject *meth_wxBitmap_GetHandle(PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_GetHandle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxBitmap *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmap, &sipCpp))
        {
            long sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxBitmap_GetHandle(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_GetHandle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_SetHandle, "SetHandle(handle)\n"
"\n"
"MSW-only method to set the windows handle for the bitmap.");

extern "C" {static PyObject *meth_wxBitmap_SetHandle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_SetHandle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long handle;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_handle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bl", &sipSelf, sipType_wxBitmap, &sipCpp, &handle))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxBitmap_SetHandle(sipCpp, handle);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_SetHandle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_SetSize, "SetSize(size)\n"
"\n"
"Set the bitmap size (does not alter the existing native bitmap data or\n"
"image size).");

extern "C" {static PyObject *meth_wxBitmap_SetSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_SetSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxSize* size;
        int sizeState = 0;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxBitmap, &sipCpp, sipType_wxSize, &size, &sizeState))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxBitmap_SetSize(sipCpp, size);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxSize *>(size), sipType_wxSize, sizeState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_SetSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_CopyFromBuffer, "CopyFromBuffer(data, format=BitmapBufferFormat_RGB, stride=-1)\n"
"\n"
"Copy data from a buffer object to replace the bitmap pixel data.\n"
"Default format is plain RGB, but other formats are now supported as\n"
"well.  The following symbols are used to specify the format of the\n"
"bytes in the buffer:\n"
"\n"
"    =============================  ================================\n"
"    wx.BitmapBufferFormat_RGB      A simple sequence of RGB bytes\n"
"    wx.BitmapBufferFormat_RGBA     A simple sequence of RGBA bytes\n"
"    wx.BitmapBufferFormat_ARGB32   A sequence of 32-bit values in\n"
"native endian order, with alpha in the upper 8 bits, followed by red,\n"
"green, and blue.\n"
"    wx.BitmapBufferFormat_RGB32    Same as above but the alpha byte is\n"
"ignored.\n"
"    =============================  ================================");

extern "C" {static PyObject *meth_wxBitmap_CopyFromBuffer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_CopyFromBuffer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxPyBuffer* data;
        int dataState = 0;
         ::wxBitmapBufferFormat format = wxBitmapBufferFormat_RGB;
        int stride = -1;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
            sipName_format,
            sipName_stride,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ0|Ei", &sipSelf, sipType_wxBitmap, &sipCpp, sipType_wxPyBuffer, &data, &dataState, sipType_wxBitmapBufferFormat, &format, &stride))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxBitmap_CopyFromBuffer(sipCpp, data, format, stride);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(data, sipType_wxPyBuffer, dataState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_CopyFromBuffer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_CopyToBuffer, "CopyToBuffer(data, format=BitmapBufferFormat_RGB, stride=-1)\n"
"\n"
"Copy pixel data to a buffer object.  See :meth:`CopyFromBuffer` for\n"
"buffer\n"
"format details.");

extern "C" {static PyObject *meth_wxBitmap_CopyToBuffer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_CopyToBuffer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxPyBuffer* data;
        int dataState = 0;
         ::wxBitmapBufferFormat format = wxBitmapBufferFormat_RGB;
        int stride = -1;
         ::wxBitmap *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
            sipName_format,
            sipName_stride,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ0|Ei", &sipSelf, sipType_wxBitmap, &sipCpp, sipType_wxPyBuffer, &data, &dataState, sipType_wxBitmapBufferFormat, &format, &stride))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxBitmap_CopyToBuffer(sipCpp, data, format, stride);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(data, sipType_wxPyBuffer, dataState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_CopyToBuffer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_FromBufferAndAlpha, "FromBufferAndAlpha(width, height, data, alpha) -> Bitmap\n"
"\n"
"Creates a :class:`wx.Bitmap` from in-memory data.  The data and alpha\n"
"parameters must be a Python object that implements the buffer\n"
"interface, such as a string, bytearray, etc.  The data object\n"
"is expected to contain a series of RGB bytes and be at least\n"
"``(width * height * 3)`` bytes long, while the alpha object is\n"
"expected\n"
"to be ``(width * height)`` bytes long and represents the image's alpha\n"
"channel.  On Windows and Mac the RGB values will be\n"
"'premultiplied' by the alpha values.  (The other platforms do\n"
"the multiplication themselves.)\n"
"\n"
"Unlike :func:`wx.ImageFromBuffer` the bitmap created with this\n"
"function\n"
"does not share the memory block with the buffer object.  This is\n"
"because the native pixel buffer format varies on different\n"
"platforms, and so instead an efficient as possible copy of the\n"
"data is made from the buffer object to the bitmap's native pixel\n"
"buffer.");

extern "C" {static PyObject *meth_wxBitmap_FromBufferAndAlpha(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_FromBufferAndAlpha(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int width;
        int height;
         ::wxPyBuffer* data;
        int dataState = 0;
         ::wxPyBuffer* alpha;
        int alphaState = 0;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_data,
            sipName_alpha,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "iiJ0J0", &width, &height, sipType_wxPyBuffer, &data, &dataState, sipType_wxPyBuffer, &alpha, &alphaState))
        {
             ::wxBitmap*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxBitmap_FromBufferAndAlpha(width, height, data, alpha);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(data, sipType_wxPyBuffer, dataState);
            sipReleaseType(alpha, sipType_wxPyBuffer, alphaState);

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_FromBufferAndAlpha, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_FromBuffer, "FromBuffer(width, height, data) -> Bitmap\n"
"\n"
"Creates a :class:`wx.Bitmap` from in-memory data.  The data parameter\n"
"must be a Python object that implements the buffer interface, such\n"
"as a string, bytearray, etc.  The data object is expected to contain\n"
"a series of RGB bytes and be at least ``(width * height * 3)`` bytes\n"
"long.\n"
"\n"
"Unlike :func:`wx.ImageFromBuffer` the bitmap created with this\n"
"function\n"
"does not share the memory block with the buffer object.  This is\n"
"because the native pixel buffer format varies on different\n"
"platforms, and so instead an efficient as possible copy of the\n"
"data is made from the buffer object to the bitmap's native pixel\n"
"buffer.");

extern "C" {static PyObject *meth_wxBitmap_FromBuffer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_FromBuffer(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int width;
        int height;
         ::wxPyBuffer* data;
        int dataState = 0;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "iiJ0", &width, &height, sipType_wxPyBuffer, &data, &dataState))
        {
             ::wxBitmap*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxBitmap_FromBuffer(width, height, data);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(data, sipType_wxPyBuffer, dataState);

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_FromBuffer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_FromBufferRGBA, "FromBufferRGBA(width, height, data) -> Bitmap\n"
"\n"
"Creates a :class:`wx.Bitmap` from in-memory data.  The data parameter\n"
"must be a Python object that implements the buffer interface, such\n"
"as a string, bytearray, etc.  The data object is expected to contain\n"
"a series of RGBA bytes and be at least ``(width * height * 4)`` bytes\n"
"long.\n"
"On Windows and Mac the RGB values will be 'premultiplied' by the\n"
"alpha values.  (The other platforms do the multiplication themselves.)\n"
"\n"
"Unlike :func:`wx.ImageFromBuffer` the bitmap created with this\n"
"function\n"
"does not share the memory block with the buffer object.  This is\n"
"because the native pixel buffer format varies on different\n"
"platforms, and so instead an efficient as possible copy of the\n"
"data is made from the buffer object to the bitmap's native pixel\n"
"buffer.");

extern "C" {static PyObject *meth_wxBitmap_FromBufferRGBA(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_FromBufferRGBA(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int width;
        int height;
         ::wxPyBuffer* data;
        int dataState = 0;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "iiJ0", &width, &height, sipType_wxPyBuffer, &data, &dataState))
        {
             ::wxBitmap*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxBitmap_FromBufferRGBA(width, height, data);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(data, sipType_wxPyBuffer, dataState);

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_FromBufferRGBA, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_FromRGBA, "FromRGBA(width, height, red=0, green=0, blue=0, alpha=0) -> Bitmap\n"
"\n"
"Creates a new empty 32-bit :class:`wx.Bitmap` where every pixel has\n"
"been\n"
"initialized with the given RGBA values.");

extern "C" {static PyObject *meth_wxBitmap_FromRGBA(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_FromRGBA(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int width;
        int height;
         ::byte red = 0;
         ::byte green = 0;
         ::byte blue = 0;
         ::byte alpha = 0;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_red,
            sipName_green,
            sipName_blue,
            sipName_alpha,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "ii|MMMM", &width, &height, &red, &green, &blue, &alpha))
        {
             ::wxBitmap*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxBitmap_FromRGBA(width, height, red, green, blue, alpha);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_FromRGBA, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmap_FromPNGData, "FromPNGData(data) -> Bitmap\n"
"\n"
"Like :meth:`NewFromPNGData`, but with a simpler API accepting a Python\n"
"buffer-compatible object.");

extern "C" {static PyObject *meth_wxBitmap_FromPNGData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmap_FromPNGData(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxPyBuffer* data;
        int dataState = 0;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J0", sipType_wxPyBuffer, &data, &dataState))
        {
             ::wxBitmap*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxBitmap_FromPNGData(data);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(data, sipType_wxPyBuffer, dataState);

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxBitmap,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Bitmap, sipName_FromPNGData, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static int slot_wxBitmap___bool__(PyObject *);}
static int slot_wxBitmap___bool__(PyObject *sipSelf)
{
     ::wxBitmap *sipCpp = reinterpret_cast< ::wxBitmap *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxBitmap));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxBitmap___bool__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxBitmap(void *, const sipTypeDef *);}
static void *cast_wxBitmap(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxBitmap *sipCpp = reinterpret_cast< ::wxBitmap *>(sipCppV);

    if (targetType == sipType_wxBitmap)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxGDIObject)->ctd_cast(static_cast< ::wxGDIObject *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxBitmap(void *, int);}
static void release_wxBitmap(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxBitmap *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxBitmap(Py_ssize_t);}
static void *array_wxBitmap(Py_ssize_t sipNrElem)
{
    return new  ::wxBitmap[sipNrElem];
}


extern "C" {static void assign_wxBitmap(void *, Py_ssize_t, void *);}
static void assign_wxBitmap(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxBitmap *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxBitmap *>(sipSrc);
}


extern "C" {static void *copy_wxBitmap(const void *, Py_ssize_t);}
static void *copy_wxBitmap(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::wxBitmap(reinterpret_cast<const  ::wxBitmap *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxBitmap(sipSimpleWrapper *);}
static void dealloc_wxBitmap(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxBitmap(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxBitmap(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxBitmap(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxBitmap *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxBitmap();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxBitmap* bitmap;

        static const char *sipKwdList[] = {
            sipName_bitmap,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxBitmap, &bitmap))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxBitmap(*bitmap);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const char* bits;
        int width;
        int height;
        int depth = 1;

        static const char *sipKwdList[] = {
            sipName_bits,
            sipName_width,
            sipName_height,
            sipName_depth,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "sii|i", &bits, &width, &height, &depth))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxBitmap(bits,width,height,depth);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        int width;
        int height;
        int depth = wxBITMAP_SCREEN_DEPTH;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_depth,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "ii|i", &width, &height, &depth))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxBitmap(width,height,depth);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxSize* sz;
        int szState = 0;
        int depth = wxBITMAP_SCREEN_DEPTH;

        static const char *sipKwdList[] = {
            sipName_sz,
            sipName_depth,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|i", sipType_wxSize, &sz, &szState, &depth))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxBitmap(*sz,depth);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(sz), sipType_wxSize, szState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        int width;
        int height;
        const  ::wxDC* dc;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
            sipName_dc,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "iiJ9", &width, &height, sipType_wxDC, &dc))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxBitmap(width,height,*dc);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxBitmapType type = wxBITMAP_TYPE_ANY;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_type,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|E", sipType_wxString, &name, &nameState, sipType_wxBitmapType, &type))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxBitmap(*name,type);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxImage* img;
        int depth = wxBITMAP_SCREEN_DEPTH;

        static const char *sipKwdList[] = {
            sipName_img,
            sipName_depth,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9|i", sipType_wxImage, &img, &depth))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxBitmap(*img,depth);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxImage* img;
        const  ::wxDC* dc;

        static const char *sipKwdList[] = {
            sipName_img,
            sipName_dc,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9J9", sipType_wxImage, &img, sipType_wxDC, &dc))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxBitmap(*img,*dc);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        PyObject * listOfBytes;

        static const char *sipKwdList[] = {
            sipName_listOfBytes,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "P0", &listOfBytes))
        {
        PyErr_Clear();
        sipCpp = _wxBitmap_ctor(listOfBytes);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxBitmap[] = {{226, 255, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxBitmap[] = {
    {(void *)slot_wxBitmap___bool__, bool_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxBitmap[] = {
    {sipName_ConvertToDisabled, SIP_MLMETH_CAST(meth_wxBitmap_ConvertToDisabled), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_ConvertToDisabled},
    {sipName_ConvertToImage, meth_wxBitmap_ConvertToImage, METH_VARARGS, doc_wxBitmap_ConvertToImage},
    {sipName_CopyFromBuffer, SIP_MLMETH_CAST(meth_wxBitmap_CopyFromBuffer), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_CopyFromBuffer},
    {sipName_CopyFromIcon, SIP_MLMETH_CAST(meth_wxBitmap_CopyFromIcon), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_CopyFromIcon},
    {sipName_CopyToBuffer, SIP_MLMETH_CAST(meth_wxBitmap_CopyToBuffer), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_CopyToBuffer},
    {sipName_Create, SIP_MLMETH_CAST(meth_wxBitmap_Create), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_Create},
    {sipName_CreateScaled, SIP_MLMETH_CAST(meth_wxBitmap_CreateScaled), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_CreateScaled},
    {sipName_CreateWithDIPSize, SIP_MLMETH_CAST(meth_wxBitmap_CreateWithDIPSize), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_CreateWithDIPSize},
    {sipName_FromBuffer, SIP_MLMETH_CAST(meth_wxBitmap_FromBuffer), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_FromBuffer},
    {sipName_FromBufferAndAlpha, SIP_MLMETH_CAST(meth_wxBitmap_FromBufferAndAlpha), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_FromBufferAndAlpha},
    {sipName_FromBufferRGBA, SIP_MLMETH_CAST(meth_wxBitmap_FromBufferRGBA), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_FromBufferRGBA},
    {sipName_FromPNGData, SIP_MLMETH_CAST(meth_wxBitmap_FromPNGData), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_FromPNGData},
    {sipName_FromRGBA, SIP_MLMETH_CAST(meth_wxBitmap_FromRGBA), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_FromRGBA},
    {sipName_GetDIPSize, meth_wxBitmap_GetDIPSize, METH_VARARGS, doc_wxBitmap_GetDIPSize},
    {sipName_GetDepth, meth_wxBitmap_GetDepth, METH_VARARGS, doc_wxBitmap_GetDepth},
    {sipName_GetHandle, meth_wxBitmap_GetHandle, METH_VARARGS, doc_wxBitmap_GetHandle},
    {sipName_GetHeight, meth_wxBitmap_GetHeight, METH_VARARGS, doc_wxBitmap_GetHeight},
    {sipName_GetLogicalHeight, meth_wxBitmap_GetLogicalHeight, METH_VARARGS, doc_wxBitmap_GetLogicalHeight},
    {sipName_GetLogicalSize, meth_wxBitmap_GetLogicalSize, METH_VARARGS, doc_wxBitmap_GetLogicalSize},
    {sipName_GetLogicalWidth, meth_wxBitmap_GetLogicalWidth, METH_VARARGS, doc_wxBitmap_GetLogicalWidth},
    {sipName_GetMask, meth_wxBitmap_GetMask, METH_VARARGS, doc_wxBitmap_GetMask},
    {sipName_GetPalette, meth_wxBitmap_GetPalette, METH_VARARGS, doc_wxBitmap_GetPalette},
    {sipName_GetScaleFactor, meth_wxBitmap_GetScaleFactor, METH_VARARGS, doc_wxBitmap_GetScaleFactor},
    {sipName_GetScaledHeight, meth_wxBitmap_GetScaledHeight, METH_VARARGS, doc_wxBitmap_GetScaledHeight},
    {sipName_GetScaledSize, meth_wxBitmap_GetScaledSize, METH_VARARGS, doc_wxBitmap_GetScaledSize},
    {sipName_GetScaledWidth, meth_wxBitmap_GetScaledWidth, METH_VARARGS, doc_wxBitmap_GetScaledWidth},
    {sipName_GetSize, meth_wxBitmap_GetSize, METH_VARARGS, doc_wxBitmap_GetSize},
    {sipName_GetSubBitmap, SIP_MLMETH_CAST(meth_wxBitmap_GetSubBitmap), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_GetSubBitmap},
    {sipName_GetWidth, meth_wxBitmap_GetWidth, METH_VARARGS, doc_wxBitmap_GetWidth},
    {sipName_HasAlpha, meth_wxBitmap_HasAlpha, METH_VARARGS, doc_wxBitmap_HasAlpha},
    {sipName_IsOk, meth_wxBitmap_IsOk, METH_VARARGS, doc_wxBitmap_IsOk},
    {sipName_LoadFile, SIP_MLMETH_CAST(meth_wxBitmap_LoadFile), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_LoadFile},
    {sipName_NewFromPNGData, SIP_MLMETH_CAST(meth_wxBitmap_NewFromPNGData), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_NewFromPNGData},
    {sipName_Rescale, SIP_MLMETH_CAST(meth_wxBitmap_Rescale), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_Rescale},
    {sipName_ResetAlpha, meth_wxBitmap_ResetAlpha, METH_VARARGS, doc_wxBitmap_ResetAlpha},
    {sipName_SaveFile, SIP_MLMETH_CAST(meth_wxBitmap_SaveFile), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_SaveFile},
    {sipName_SetDepth, SIP_MLMETH_CAST(meth_wxBitmap_SetDepth), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_SetDepth},
    {sipName_SetHandle, SIP_MLMETH_CAST(meth_wxBitmap_SetHandle), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_SetHandle},
    {sipName_SetHeight, SIP_MLMETH_CAST(meth_wxBitmap_SetHeight), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_SetHeight},
    {sipName_SetMask, SIP_MLMETH_CAST(meth_wxBitmap_SetMask), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_SetMask},
    {sipName_SetMaskColour, SIP_MLMETH_CAST(meth_wxBitmap_SetMaskColour), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_SetMaskColour},
    {sipName_SetPalette, SIP_MLMETH_CAST(meth_wxBitmap_SetPalette), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_SetPalette},
    {sipName_SetScaleFactor, SIP_MLMETH_CAST(meth_wxBitmap_SetScaleFactor), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_SetScaleFactor},
    {sipName_SetSize, SIP_MLMETH_CAST(meth_wxBitmap_SetSize), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_SetSize},
    {sipName_SetWidth, SIP_MLMETH_CAST(meth_wxBitmap_SetWidth), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_SetWidth},
    {sipName_UseAlpha, SIP_MLMETH_CAST(meth_wxBitmap_UseAlpha), METH_VARARGS|METH_KEYWORDS, doc_wxBitmap_UseAlpha},
    {sipName___nonzero__, meth_wxBitmap___nonzero__, METH_VARARGS, doc_wxBitmap___nonzero__}
};

sipVariableDef variables_wxBitmap[] = {
    {PropertyVariable, sipName_Width, &methods_wxBitmap[28], &methods_wxBitmap[44], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Size, &methods_wxBitmap[26], &methods_wxBitmap[43], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ScaledWidth, &methods_wxBitmap[25], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ScaledSize, &methods_wxBitmap[24], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ScaledHeight, &methods_wxBitmap[23], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ScaleFactor, &methods_wxBitmap[22], &methods_wxBitmap[42], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Palette, &methods_wxBitmap[21], &methods_wxBitmap[41], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Mask, &methods_wxBitmap[20], &methods_wxBitmap[39], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LogicalWidth, &methods_wxBitmap[19], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LogicalSize, &methods_wxBitmap[18], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LogicalHeight, &methods_wxBitmap[17], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Height, &methods_wxBitmap[16], &methods_wxBitmap[38], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Handle, &methods_wxBitmap[15], &methods_wxBitmap[37], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Depth, &methods_wxBitmap[14], &methods_wxBitmap[36], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_DIPSize, &methods_wxBitmap[13], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxBitmap, "Bitmap()\n"
"Bitmap(bitmap)\n"
"Bitmap(bits, width, height, depth=1)\n"
"Bitmap(width, height, depth=BITMAP_SCREEN_DEPTH)\n"
"Bitmap(sz, depth=BITMAP_SCREEN_DEPTH)\n"
"Bitmap(width, height, dc)\n"
"Bitmap(name, type=BITMAP_TYPE_ANY)\n"
"Bitmap(img, depth=BITMAP_SCREEN_DEPTH)\n"
"Bitmap(img, dc)\n"
"Bitmap(listOfBytes)\n"
"\n"
"This class encapsulates the concept of a platform-dependent bitmap,\n"
"either monochrome or colour or colour with alpha channel support.");


sipClassTypeDef sipTypeDef__core_wxBitmap = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxBitmap,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_Bitmap,
        {0, 0, 1},
        47, methods_wxBitmap,
        0, SIP_NULLPTR,
        15, variables_wxBitmap,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxBitmap,
    -1,
    -1,
    supers_wxBitmap,
    slots_wxBitmap,
    init_type_wxBitmap,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxBitmap,
    assign_wxBitmap,
    array_wxBitmap,
    copy_wxBitmap,
    release_wxBitmap,
    cast_wxBitmap,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
