/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.7.9
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/affinematrix2d.h>
        #include <wx/geometry.h>
        #include <wx/affinematrix2dbase.h>
        #include <wx/affinematrix2dbase.h>


class sipwxAffineMatrix2D : public  ::wxAffineMatrix2D
{
public:
    sipwxAffineMatrix2D();
    sipwxAffineMatrix2D(const  ::wxAffineMatrix2D&);
    virtual ~sipwxAffineMatrix2D();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    void Set(const  ::wxMatrix2D&,const  ::wxPoint2DDouble&) SIP_OVERRIDE;
    void Get( ::wxMatrix2D*, ::wxPoint2DDouble*) const SIP_OVERRIDE;
    void Concat(const  ::wxAffineMatrix2DBase&) SIP_OVERRIDE;
    bool Invert() SIP_OVERRIDE;
    bool IsIdentity() const SIP_OVERRIDE;
    void Translate( ::wxDouble, ::wxDouble) SIP_OVERRIDE;
    void Scale( ::wxDouble, ::wxDouble) SIP_OVERRIDE;
    void Rotate( ::wxDouble) SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxAffineMatrix2D(const sipwxAffineMatrix2D &);
    sipwxAffineMatrix2D &operator = (const sipwxAffineMatrix2D &);

    char sipPyMethods[8];
};

sipwxAffineMatrix2D::sipwxAffineMatrix2D():  ::wxAffineMatrix2D(), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxAffineMatrix2D::sipwxAffineMatrix2D(const  ::wxAffineMatrix2D& a0):  ::wxAffineMatrix2D(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxAffineMatrix2D::~sipwxAffineMatrix2D()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

void sipwxAffineMatrix2D::Set(const  ::wxMatrix2D& mat2D,const  ::wxPoint2DDouble& tr)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_Set);

    if (!sipMeth)
    {
         ::wxAffineMatrix2D::Set(mat2D,tr);
        return;
    }

    extern void sipVH__core_3(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxMatrix2D&,const  ::wxPoint2DDouble&);

    sipVH__core_3(sipGILState, 0, sipPySelf, sipMeth, mat2D, tr);
}

void sipwxAffineMatrix2D::Get( ::wxMatrix2D*mat2D, ::wxPoint2DDouble*tr) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_Get);

    if (!sipMeth)
    {
         ::wxAffineMatrix2D::Get(mat2D,tr);
        return;
    }

    extern void sipVH__core_4(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxMatrix2D*, ::wxPoint2DDouble*);

    sipVH__core_4(sipGILState, 0, sipPySelf, sipMeth, mat2D, tr);
}

void sipwxAffineMatrix2D::Concat(const  ::wxAffineMatrix2DBase& t)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_Concat);

    if (!sipMeth)
    {
         ::wxAffineMatrix2D::Concat(t);
        return;
    }

    extern void sipVH__core_5(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxAffineMatrix2DBase&);

    sipVH__core_5(sipGILState, 0, sipPySelf, sipMeth, t);
}

bool sipwxAffineMatrix2D::Invert()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_Invert);

    if (!sipMeth)
        return  ::wxAffineMatrix2D::Invert();

    extern bool sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_6(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxAffineMatrix2D::IsIdentity() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[4]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_IsIdentity);

    if (!sipMeth)
        return  ::wxAffineMatrix2D::IsIdentity();

    extern bool sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_6(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxAffineMatrix2D::Translate( ::wxDouble dx, ::wxDouble dy)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[5], &sipPySelf, SIP_NULLPTR, sipName_Translate);

    if (!sipMeth)
    {
         ::wxAffineMatrix2D::Translate(dx,dy);
        return;
    }

    extern void sipVH__core_7(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxDouble, ::wxDouble);

    sipVH__core_7(sipGILState, 0, sipPySelf, sipMeth, dx, dy);
}

void sipwxAffineMatrix2D::Scale( ::wxDouble xScale, ::wxDouble yScale)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[6], &sipPySelf, SIP_NULLPTR, sipName_Scale);

    if (!sipMeth)
    {
         ::wxAffineMatrix2D::Scale(xScale,yScale);
        return;
    }

    extern void sipVH__core_7(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxDouble, ::wxDouble);

    sipVH__core_7(sipGILState, 0, sipPySelf, sipMeth, xScale, yScale);
}

void sipwxAffineMatrix2D::Rotate( ::wxDouble cRadians)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[7], &sipPySelf, SIP_NULLPTR, sipName_Rotate);

    if (!sipMeth)
    {
         ::wxAffineMatrix2D::Rotate(cRadians);
        return;
    }

    extern void sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxDouble);

    sipVH__core_8(sipGILState, 0, sipPySelf, sipMeth, cRadians);
}


PyDoc_STRVAR(doc_wxAffineMatrix2D_IsEqual, "IsEqual(t)\n"
"\n"
"Check that this matrix is identical with t.");

extern "C" {static PyObject *meth_wxAffineMatrix2D_IsEqual(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2D_IsEqual(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAffineMatrix2DBase* t;
         ::wxAffineMatrix2D *sipCpp;

        static const char *sipKwdList[] = {
            sipName_t,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxAffineMatrix2D, &sipCpp, sipType_wxAffineMatrix2DBase, &t))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->IsEqual(*t);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2D, sipName_IsEqual, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2D_Get, "Get() -> (mat2D, tr)\n"
"\n"
"Get the component values of the matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2D_Get(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2D_Get(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxMatrix2D* mat2D;
         ::wxPoint2DDouble* tr;
        const  ::wxAffineMatrix2D *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxAffineMatrix2D, &sipCpp))
        {
            mat2D = new  ::wxMatrix2D();
            tr = new  ::wxPoint2DDouble();

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxAffineMatrix2D::Get(mat2D,tr) : sipCpp->Get(mat2D,tr));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(NN)",mat2D,sipType_wxMatrix2D,SIP_NULLPTR,tr,sipType_wxPoint2DDouble,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2D, sipName_Get, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2D_Set, "Set(mat2D, tr)\n"
"\n"
"Set all elements of this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2D_Set(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2D_Set(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxMatrix2D* mat2D;
        const  ::wxPoint2DDouble* tr;
        int trState = 0;
         ::wxAffineMatrix2D *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mat2D,
            sipName_tr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J1", &sipSelf, sipType_wxAffineMatrix2D, &sipCpp, sipType_wxMatrix2D, &mat2D, sipType_wxPoint2DDouble, &tr, &trState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxAffineMatrix2D::Set(*mat2D,*tr) : sipCpp->Set(*mat2D,*tr));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint2DDouble *>(tr), sipType_wxPoint2DDouble, trState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2D, sipName_Set, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2D_Concat, "Concat(t)\n"
"\n"
"Concatenate this matrix with another one.");

extern "C" {static PyObject *meth_wxAffineMatrix2D_Concat(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2D_Concat(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxAffineMatrix2DBase* t;
         ::wxAffineMatrix2D *sipCpp;

        static const char *sipKwdList[] = {
            sipName_t,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxAffineMatrix2D, &sipCpp, sipType_wxAffineMatrix2DBase, &t))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxAffineMatrix2D::Concat(*t) : sipCpp->Concat(*t));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2D, sipName_Concat, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2D_Invert, "Invert() -> bool\n"
"\n"
"Invert this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2D_Invert(PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2D_Invert(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxAffineMatrix2D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAffineMatrix2D, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxAffineMatrix2D::Invert() : sipCpp->Invert());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2D, sipName_Invert, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2D_IsIdentity, "IsIdentity() -> bool\n"
"\n"
"Check if this is the identity matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2D_IsIdentity(PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2D_IsIdentity(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxAffineMatrix2D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAffineMatrix2D, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxAffineMatrix2D::IsIdentity() : sipCpp->IsIdentity());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2D, sipName_IsIdentity, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2D_Translate, "Translate(dx, dy)\n"
"\n"
"Add the translation to this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2D_Translate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2D_Translate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxDouble dx;
         ::wxDouble dy;
         ::wxAffineMatrix2D *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dx,
            sipName_dy,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdd", &sipSelf, sipType_wxAffineMatrix2D, &sipCpp, &dx, &dy))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxAffineMatrix2D::Translate(dx,dy) : sipCpp->Translate(dx,dy));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2D, sipName_Translate, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2D_Scale, "Scale(xScale, yScale)\n"
"\n"
"Add scaling to this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2D_Scale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2D_Scale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxDouble xScale;
         ::wxDouble yScale;
         ::wxAffineMatrix2D *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xScale,
            sipName_yScale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdd", &sipSelf, sipType_wxAffineMatrix2D, &sipCpp, &xScale, &yScale))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxAffineMatrix2D::Scale(xScale,yScale) : sipCpp->Scale(xScale,yScale));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2D, sipName_Scale, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2D_Mirror, "Mirror(direction=HORIZONTAL)\n"
"\n"
"Add mirroring to this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2D_Mirror(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2D_Mirror(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int direction = wxHORIZONTAL;
         ::wxAffineMatrix2D *sipCpp;

        static const char *sipKwdList[] = {
            sipName_direction,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_wxAffineMatrix2D, &sipCpp, &direction))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Mirror(direction);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2D, sipName_Mirror, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2D_Rotate, "Rotate(cRadians)\n"
"\n"
"Add clockwise rotation to this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2D_Rotate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2D_Rotate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
         ::wxDouble cRadians;
         ::wxAffineMatrix2D *sipCpp;

        static const char *sipKwdList[] = {
            sipName_cRadians,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bd", &sipSelf, sipType_wxAffineMatrix2D, &sipCpp, &cRadians))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp-> ::wxAffineMatrix2D::Rotate(cRadians) : sipCpp->Rotate(cRadians));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2D, sipName_Rotate, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2D_TransformPoint, "TransformPoint(p) -> Point2DDouble\n"
"TransformPoint(x, y) -> (x, y)\n"
"\n"
"Applies this matrix to the point.\n"
"");

extern "C" {static PyObject *meth_wxAffineMatrix2D_TransformPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2D_TransformPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPoint2DDouble* p;
        int pState = 0;
        const  ::wxAffineMatrix2D *sipCpp;

        static const char *sipKwdList[] = {
            sipName_p,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAffineMatrix2D, &sipCpp, sipType_wxPoint2DDouble, &p, &pState))
        {
             ::wxPoint2DDouble*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPoint2DDouble(sipCpp->TransformPoint(*p));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint2DDouble *>(p), sipType_wxPoint2DDouble, pState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPoint2DDouble,SIP_NULLPTR);
        }
    }

    {
         ::wxDouble x;
         ::wxDouble y;
        const  ::wxAffineMatrix2D *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdd", &sipSelf, sipType_wxAffineMatrix2D, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->TransformPoint(&x,&y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(dd)",x,y);
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2D, sipName_TransformPoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2D_TransformDistance, "TransformDistance(p) -> Point2DDouble\n"
"TransformDistance(dx, dy) -> (dx, dy)\n"
"\n"
"Applies the linear part of this matrix, i.e. without translation.\n"
"");

extern "C" {static PyObject *meth_wxAffineMatrix2D_TransformDistance(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2D_TransformDistance(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPoint2DDouble* p;
        int pState = 0;
        const  ::wxAffineMatrix2D *sipCpp;

        static const char *sipKwdList[] = {
            sipName_p,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAffineMatrix2D, &sipCpp, sipType_wxPoint2DDouble, &p, &pState))
        {
             ::wxPoint2DDouble*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPoint2DDouble(sipCpp->TransformDistance(*p));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint2DDouble *>(p), sipType_wxPoint2DDouble, pState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPoint2DDouble,SIP_NULLPTR);
        }
    }

    {
         ::wxDouble dx;
         ::wxDouble dy;
        const  ::wxAffineMatrix2D *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dx,
            sipName_dy,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdd", &sipSelf, sipType_wxAffineMatrix2D, &sipCpp, &dx, &dy))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->TransformDistance(&dx,&dy);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(dd)",dx,dy);
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2D, sipName_TransformDistance, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_wxAffineMatrix2D___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxAffineMatrix2D___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxAffineMatrix2D *sipCpp = reinterpret_cast< ::wxAffineMatrix2D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxAffineMatrix2D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAffineMatrix2DBase* t;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxAffineMatrix2DBase, &t))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxAffineMatrix2D::operator!=(*t);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxAffineMatrix2D, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxAffineMatrix2D___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxAffineMatrix2D___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxAffineMatrix2D *sipCpp = reinterpret_cast< ::wxAffineMatrix2D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxAffineMatrix2D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAffineMatrix2DBase* t;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxAffineMatrix2DBase, &t))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxAffineMatrix2D::operator==(*t);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxAffineMatrix2D, sipSelf, sipArg);
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxAffineMatrix2D(void *, const sipTypeDef *);}
static void *cast_wxAffineMatrix2D(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxAffineMatrix2D *sipCpp = reinterpret_cast< ::wxAffineMatrix2D *>(sipCppV);

    if (targetType == sipType_wxAffineMatrix2D)
        return sipCppV;

    if (targetType == sipType_wxAffineMatrix2DBase)
        return static_cast< ::wxAffineMatrix2DBase *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxAffineMatrix2D(void *, int);}
static void release_wxAffineMatrix2D(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxAffineMatrix2D *>(sipCppV);
    else
        delete reinterpret_cast< ::wxAffineMatrix2D *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxAffineMatrix2D(Py_ssize_t);}
static void *array_wxAffineMatrix2D(Py_ssize_t sipNrElem)
{
    return new  ::wxAffineMatrix2D[sipNrElem];
}


extern "C" {static void assign_wxAffineMatrix2D(void *, Py_ssize_t, void *);}
static void assign_wxAffineMatrix2D(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxAffineMatrix2D *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxAffineMatrix2D *>(sipSrc);
}


extern "C" {static void *copy_wxAffineMatrix2D(const void *, Py_ssize_t);}
static void *copy_wxAffineMatrix2D(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::wxAffineMatrix2D(reinterpret_cast<const  ::wxAffineMatrix2D *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxAffineMatrix2D(sipSimpleWrapper *);}
static void dealloc_wxAffineMatrix2D(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxAffineMatrix2D *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxAffineMatrix2D(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxAffineMatrix2D(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxAffineMatrix2D(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxAffineMatrix2D *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxAffineMatrix2D();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxAffineMatrix2D* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxAffineMatrix2D, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxAffineMatrix2D(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxAffineMatrix2D[] = {{13, 255, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxAffineMatrix2D[] = {
    {(void *)slot_wxAffineMatrix2D___ne__, ne_slot},
    {(void *)slot_wxAffineMatrix2D___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxAffineMatrix2D[] = {
    {sipName_Concat, SIP_MLMETH_CAST(meth_wxAffineMatrix2D_Concat), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2D_Concat},
    {sipName_Get, SIP_MLMETH_CAST(meth_wxAffineMatrix2D_Get), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2D_Get},
    {sipName_Invert, meth_wxAffineMatrix2D_Invert, METH_VARARGS, doc_wxAffineMatrix2D_Invert},
    {sipName_IsEqual, SIP_MLMETH_CAST(meth_wxAffineMatrix2D_IsEqual), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2D_IsEqual},
    {sipName_IsIdentity, meth_wxAffineMatrix2D_IsIdentity, METH_VARARGS, doc_wxAffineMatrix2D_IsIdentity},
    {sipName_Mirror, SIP_MLMETH_CAST(meth_wxAffineMatrix2D_Mirror), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2D_Mirror},
    {sipName_Rotate, SIP_MLMETH_CAST(meth_wxAffineMatrix2D_Rotate), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2D_Rotate},
    {sipName_Scale, SIP_MLMETH_CAST(meth_wxAffineMatrix2D_Scale), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2D_Scale},
    {sipName_Set, SIP_MLMETH_CAST(meth_wxAffineMatrix2D_Set), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2D_Set},
    {sipName_TransformDistance, SIP_MLMETH_CAST(meth_wxAffineMatrix2D_TransformDistance), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2D_TransformDistance},
    {sipName_TransformPoint, SIP_MLMETH_CAST(meth_wxAffineMatrix2D_TransformPoint), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2D_TransformPoint},
    {sipName_Translate, SIP_MLMETH_CAST(meth_wxAffineMatrix2D_Translate), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2D_Translate}
};

PyDoc_STRVAR(doc_wxAffineMatrix2D, "AffineMatrix2D()\n"
"\n"
"A 3x2 matrix representing an affine 2D transformation.");


sipClassTypeDef sipTypeDef__core_wxAffineMatrix2D = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxAffineMatrix2D,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_AffineMatrix2D,
        {0, 0, 1},
        12, methods_wxAffineMatrix2D,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxAffineMatrix2D,
    -1,
    -1,
    supers_wxAffineMatrix2D,
    slots_wxAffineMatrix2D,
    init_type_wxAffineMatrix2D,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxAffineMatrix2D,
    assign_wxAffineMatrix2D,
    array_wxAffineMatrix2D,
    copy_wxAffineMatrix2D,
    release_wxAffineMatrix2D,
    cast_wxAffineMatrix2D,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
