# dnf

> Менеджер пакетов для Fedora 41+ и RHEL 10.
> Эквивалентные команды в других менеджерах пакетов смотрите в <https://wiki.archlinux.org/title/Pacman/Rosetta>.
> Больше информации: <https://dnf5.readthedocs.io/en/latest/commands/index.html>.

- Обновить установленные пакеты до новейших доступных версий:

`sudo dnf {{[up|upgrade]}}`

- Искать пакеты по ключевым словам:

`dnf {{[se|search]}} {{ключевое_слово1 ключевое_слово2 ...}}`

- Отобразить подробную информацию о пакете:

`dnf {{[if|info]}} {{пакет}}`

- Установить новые пакеты (используйте `--assumeyes` для автоматического подтверждения всех запросов):

`sudo dnf {{[in|install]}} {{пакет1 пакет2 ...}}`

- Удалить пакеты:

`sudo dnf {{[rm|remove]}} {{пакет1 пакет2 ...}}`

- Вывести список установленных пакетов:

`dnf {{[ls|list]}} --installed`

- Найти, какие пакеты предоставляют данную команду:

`dnf provides {{команда}}`

- Очистить кэшированные данные:

`sudo dnf clean {{all|dbcache|expire-cache|metadata|packages}}`
