# sed

> 스크립트로 텍스트를 편집합니다.
> 같이 보기: `awk`, `ed`.
> 더 많은 정보: <https://man.freebsd.org/cgi/man.cgi?sed>.

- 모든 입력 라인에서 `apple` (기본 `regex`)을 `mango` (기본 `regex`)로 대체하고 결과를 `stdout`에 인쇄:

`{{명령}} | sed 's/apple/mango/g'`

- 특정 스크립트 [f]파일을 실행하고 결과를 `stdout`에 인쇄:

`{{명령}} | sed -f {{경로/대상/스크립트.sed}}`

- 관련 `w` 함수 또는 플래그가 포함된 명령이 입력 줄에 적용될 때까지 각 파일 열기 지연:

`{{명령}} | sed -fa {{경로/대상/스크립트.sed}}`

- 모든 입력 라인에서 `apple` (확장 `regex`)을 `APPLE` (확장 `regex`)로 대체하고 결과를 `stdout`에 인쇄:

`{{명령}} | sed -E 's/(apple)/\U\1/g'`

- 첫 번째 줄만 `stdout`에 인쇄:

`{{명령}} | sed -n '1p'`

- 특정 파일에서 `apple` (기본 `regex`)을 `mango` (기본 `regex`)로 모두 대체하고 원본 파일 덮어쓰기:

`sed -i 's/apple/mango/g' {{경로/대상/파일}}`
