# semanage

> SELinux persistent policy management tool.
> Some subcommands such as `boolean`, `fcontext`, `port`, etc. have their own usage documentation.
> More information: <https://manned.org/semanage>.

- Set or unset a SELinux boolean. Booleans allow the administrator to customize how policy rules affect confined process types (a.k.a domains):

`sudo semanage boolean {{[-m|--modify]}} {{--on|--off}} {{haproxy_connect_any}}`

- Add a user-defined file context labeling rule. File contexts define what files confined domains are allowed to access:

`sudo semanage fcontext {{[-a|--add]}} {{[-t|--type]}} {{samba_share_t}} '/mnt/share(/.*)?'`

- Add a user-defined port labeling rule. Port labels define what ports confined domains are allowed to listen on:

`sudo semanage port {{[-a|--add]}} {{[-t|--type]}} {{ssh_port_t}} {{[-p|--proto]}} {{tcp}} {{22000}}`

- Set or unset permissive mode for a confined domain. Per-domain permissive mode allows more granular control compared to `setenforce`:

`sudo semanage permissive {{--add|--delete}} {{httpd_t}}`

- Output local customizations in the default store:

`sudo semanage export {{[-f|--output_file]}} {{path/to/file}}`

- Import a file generated by `semanage export` into local customizations (CAREFUL: may remove current customizations!):

`sudo semanage import {{[-f|--input_file]}} {{path/to/file}}`
