# flex

> Lexical analyzer generator.
> Given the specification for a lexical analyzer, generates C code implementing it.
> More information: <https://manned.org/flex>.

- Generate an analyzer from a Lex file, storing it to the file `lex.yy.c`:

`flex {{analyzer.l}}`

- Write analyzer to `stdout`:

`flex {{[-t|--stdout]}} {{analyzer.l}}`

- Specify the output file:

`flex {{analyzer.l}} {{[-o|--outfile]}} {{analyzer.c}}`

- Generate a batch scanner instead of an interactive scanner:

`flex {{[-B|--batch]}} {{analyzer.l}}`

- Compile a C file generated by Lex:

`cc {{path/to/lex.yy.c}} -o {{executable}}`
