/* i386-linux.elf-so_fold.h
   created from i386-linux.elf-so_fold.bin, 18659 (0x48e3) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_I386_LINUX_ELF_SO_FOLD_SIZE    18659
#define STUB_I386_LINUX_ELF_SO_FOLD_ADLER32 0x6872bdac
#define STUB_I386_LINUX_ELF_SO_FOLD_CRC32   0xb8d3d309

unsigned char stub_i386_linux_elf_so_fold[18659] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 136, 40,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */  34,  0, 31,  0,233,252,255,255,255,233,252,255,255,255,  0,  0,
/* 0x0040 */  85,137,229, 87, 86, 83,129,236, 68, 16,  0,  0,186,  0,  0,  0,
/* 0x0050 */   0,232,  4,  0,  0,  0,117,112,120,  0, 95,185, 16,  0,  0,  0,
/* 0x0060 */ 184,100,  1,  0,  0,137,251,205,128,137,198,131,248,234,117, 13,
/* 0x0070 */ 184,100,  1,  0,  0,137,251,137,209,205,128,137,198,133,246,121,
/* 0x0080 */  66,232,  9,  0,  0,  0, 47,100,101,118, 47,115,104,109,  0, 94,
/* 0x0090 */ 185,  2,  0, 65,  0,186,192,  1,  0,  0,137,243,106,  5, 88,205,
/* 0x00a0 */ 128,137,198,133,192,121, 28,232, 13,  0,  0,  0,109,101,109,102,
/* 0x00b0 */ 100, 95, 99,114,101, 97,116,101,  0, 88, 80,232,252,255,255,255,
/* 0x00c0 */ 131,196,  4,141,189,244,239,255,255,137,251,106,122, 88,205,128,
/* 0x00d0 */ 199,133,220,239,255,255,  0,  0,  0,  0,232,  4,  0,  0,  0, 97,
/* 0x00e0 */ 110,100,  0, 88,106,  3, 87, 80,232,216,  3,  0,  0,131,196, 12,
/* 0x00f0 */ 133,192,116, 45,232,  4,  0,  0,  0, 76,105,110,  0, 88,106,  3,
/* 0x0100 */  87, 80,232,190,  3,  0,  0,131,196, 12,133,192,117, 19,128,189,
/* 0x0110 */ 118,240,255,255, 52,126, 10,199,133,220,239,255,255,  1,  0,  0,
/* 0x0120 */   0,131,189,220,239,255,255,  0,117,126,131,125, 16,  0,117, 28,
/* 0x0130 */ 232,252,255,255,255,137, 69, 16,133,192,117, 16,141,133,244,239,
/* 0x0140 */ 255,255,137, 69, 16,198,133,244,239,255,255,  0,131,189,220,239,
/* 0x0150 */ 255,255,  0,117, 83,131,254,218,117, 78,131,125, 16,  0,116, 72,
/* 0x0160 */ 139, 85, 16,128, 58,  0,117, 26,141,133,244,247,255,255, 80, 82,
/* 0x0170 */ 232,150,  1,  0,  0,131,196,  8,137,193,133,192, 15,136,233,  0,
/* 0x0180 */   0,  0,185,194,  0,  0,  0,186,192,  1,  0,  0,139, 93, 16,106,
/* 0x0190 */   5, 88,205,128,137,198,137,193,133,192, 15,136,203,  0,  0,  0,
/* 0x01a0 */ 139, 93, 16,106, 10, 88,205,128,131,125,  8,  0,116, 16,232,252,
/* 0x01b0 */ 255,255,255,247,208, 35, 69,  8, 41, 69,  8,  1, 69, 12,131,125,
/* 0x01c0 */  12,  0,116, 85,131,189,220,239,255,255,  0,116, 22,137,243,139,
/* 0x01d0 */  77, 12,106, 93, 88,205,128,137,193,133,192, 15,136,138,  0,  0,
/* 0x01e0 */   0,235, 54,139, 77, 12, 73,191,  0,  0,  0,  0,137,243,137,250,
/* 0x01f0 */ 106, 19, 88,205,128,198,133,243,239,255,255,  0,141,141,243,239,
/* 0x0200 */ 255,255,186,  1,  0,  0,  0,137,243,106,  4, 88,205,128,137,243,
/* 0x0210 */ 137,249,137,250,106, 19, 88,205,128,131,125,  8,  0,116, 26,232,
/* 0x0220 */ 252,255,255,255,137,194,247,208,133, 69,  8,116, 12,247,218,137,
/* 0x0230 */ 243,139, 77,  8,106,  4, 88,205,128,106,  0, 86,131,125,  8,  1,
/* 0x0240 */  25,192,131,224,240,131,192, 17, 80,106,  3,255,117, 12,255,117,
/* 0x0250 */   8,232,252,255,255,255,137,194,131,196, 24,137,193, 61,  0,240,
/* 0x0260 */ 255,255,119,  7,141, 70,  1,137,193,  9,209,137,200,141,101,244,
/* 0x0270 */  91, 94, 95,201,195, 85,137,229, 86, 83,131,236, 72,106, 64,104,
/* 0x0280 */ 255,  0,  0,  0,141,117,184, 86,232,252,255,255,255,131,196, 12,
/* 0x0290 */ 139, 93,  8,137,241,106,106, 88,205,128,137,198,133,192,120, 21,
/* 0x02a0 */  15,183, 69,192, 37,  0,240,  0,  0,186,  0,  0,  0,  0, 61,  0,
/* 0x02b0 */  64,  0,  0,116, 44,131,254,254,117, 15,185,192,  1,  0,  0,139,
/* 0x02c0 */  93,  8,106, 39, 88,205,128,137,198,133,246,121, 18,131,125, 12,
/* 0x02d0 */   0,116, 12, 86,255,117,  8,232,252,255,255,255,131,196,  8,137,
/* 0x02e0 */ 242,137,208,141,101,248, 91, 94,201,195,139, 68, 36,  4,137,194,
/* 0x02f0 */ 131,226, 31,131,224, 63,131,250, 26,118, 12,168, 32,116,  5,131,
/* 0x0300 */ 232, 70,235,  3,131,232, 43,131,192, 64,195, 85,137,229, 87, 86,
/* 0x0310 */  83,131,236, 32,232, 12,  0,  0,  0, 47,100, 97,116, 97, 47,100,
/* 0x0320 */  97,116, 97, 47,  0, 90,139,  2,139, 77,  8,137,  1,139, 66,  4,
/* 0x0330 */ 137, 65,  4,102,139, 66,  8,102,137, 65,  8,138, 66, 10,136, 65,
/* 0x0340 */  10,198, 65, 11,  0,106,  1, 81,232, 40,255,255,255,131,196,  8,
/* 0x0350 */ 232, 19,  0,  0,  0, 47,112,114,111, 99, 47,115,101,108,102, 47,
/* 0x0360 */  99,109,100,108,105,110,101,  0, 91,137, 93,220,185,  0,  0,  0,
/* 0x0370 */   0,137,202,106,  5, 88,205,128,137, 69,240,139,117, 12,186,255,
/* 0x0380 */  15,  0,  0,137,195,137,241,106,  3, 88,205,128,137,199,139, 93,
/* 0x0390 */ 240,106,  6, 88,205,128,133,255,121, 11,255,117,220,232,252,255,
/* 0x03a0 */ 255,255,131,196,  4,198,  4, 62,  0,128, 62,  0,116,  6, 70,128,
/* 0x03b0 */  62,  0,117,250,137,247,128, 62, 47,116,  6, 78,128, 62, 47,117,
/* 0x03c0 */ 250,137,117,224,137,248, 41,240, 80, 86,139, 69,  8,131,192, 10,
/* 0x03d0 */  80,232,252,255,255,255,137,195,198,  0,  0,106,  0,255,117,  8,
/* 0x03e0 */ 232,144,254,255,255,131,196, 20,131,248,243,117, 87,232, 17,  0,
/* 0x03f0 */   0,  0, 99,111,109, 46,116,101,114,109,117,120, 47,102,105,108,
/* 0x0400 */ 101,115,  0, 90,139,  2,139, 77,  8,137, 65, 11,139, 66,  4,137,
/* 0x0410 */  65, 15,139, 66,  8,137, 65, 19,139, 66, 12,137, 65, 23,137,202,
/* 0x0420 */ 131,194, 27,137,248, 43, 69,224, 80,255,117,224, 82,232,252,255,
/* 0x0430 */ 255,255,137,195,198,  0,  0,106,  1,255,117,  8,232, 52,254,255,
/* 0x0440 */ 255,131,196, 20,232,  7,  0,  0,  0, 47, 99, 97, 99,104,101,  0,
/* 0x0450 */  90,139,  2,137,  3,102,139, 66,  4,102,137, 67,  4,141,115,  6,
/* 0x0460 */ 198,  6,  0,106,  1,255,117,  8,232,  8,254,255,255,131,196,  8,
/* 0x0470 */ 232,  5,  0,  0,  0, 47,117,112,120,  0, 88,139,  0,137,  6,141,
/* 0x0480 */ 126,  4,106, 20, 88,205,128,137,198, 80,232, 91,254,255,255,136,
/* 0x0490 */   7,137,240,193,232,  6,137,  4, 36,232, 76,254,255,255,136, 71,
/* 0x04a0 */   1,137,240,193,232, 12,137,  4, 36,232, 60,254,255,255,131,196,
/* 0x04b0 */   4,136, 71,  2,198, 71,  3,  0,184,  0,  0,  0,  0,141,101,244,
/* 0x04c0 */  91, 94, 95,201,195, 86, 83,139,116, 36, 12,139, 92, 36, 16,139,
/* 0x04d0 */  76, 36, 20, 73,131,249,255,116, 30,138, 22,131,202, 32, 15,190,
/* 0x04e0 */ 210,138,  3,131,200, 32, 15,190,192, 67, 70, 41,194,137,208,117,
/* 0x04f0 */  11, 73,131,249,255,117,226,184,  0,  0,  0,  0, 91, 94,195,  0,
/* 0x0500 */  85,137,229, 87, 86, 83,131,236, 24,139,125, 12,232,  4,  0,  0,
/* 0x0510 */   0,117,112,120,  0, 90,185, 16,  0,  0,  0,184,100,  1,  0,  0,
/* 0x0520 */ 137,211,205,128,137,198,131,248,234,117, 16,185,  0,  0,  0,  0,
/* 0x0530 */ 184,100,  1,  0,  0,137,211,205,128,137,198,133,246, 15,137,148,
/* 0x0540 */   0,  0,  0,232,  9,  0,  0,  0, 47,100,101,118, 47,115,104,109,
/* 0x0550 */   0, 94,185,  2,  0, 65,  0,186,192,  1,  0,  0,137,243,106,  5,
/* 0x0560 */  88,205,128,137,198,133,192,121,110,137,194,131,248,235, 15,133,
/* 0x0570 */ 161,  0,  0,  0,184,  2,  0,  0,  0,232, 62,  0,  0,  0, 85, 80,
/* 0x0580 */  88, 45, 53, 46, 48, 32,119, 97,110,116,115, 32,109,101,109,102,
/* 0x0590 */ 100, 95, 99,114,101, 97,116,101, 40, 41, 44, 32,111,114, 32,110,
/* 0x05a0 */ 101,101,100,115, 32, 47,100,101,118, 47,115,104,109, 40, 44, 79,
/* 0x05b0 */  95, 84, 77, 80, 70, 73, 76, 69, 44, 41, 10,  0, 89,186, 61,  0,
/* 0x05c0 */   0,  0,137,195,106,  4, 88,205,128,184,127,  0,  0,  0,137,195,
/* 0x05d0 */ 106,  1, 88,205,128,235,254,137,243,137,249,106, 93, 88,205,128,
/* 0x05e0 */ 137,194,133,192,120, 47,106,  0, 86,131,125,  8,  1, 25,192,131,
/* 0x05f0 */ 224,240,131,192, 17, 80,106,  3, 87,255,117,  8,232,252,255,255,
/* 0x0600 */ 255,137,195,232,252,255,255,255,131,196, 24,137,218, 57,195,115,
/* 0x0610 */   4,141, 84, 30,  1,137,208,141,101,244, 91, 94, 95,201,195,  0,
/* 0x0620 */  85,137,229, 83,255,117,  8,232,252,255,255,255,131,196,  4,187,
/* 0x0630 */ 127,  0,  0,  0,106,  1, 88,205,128,235,254, 85,137,229, 87, 86,
/* 0x0640 */  83,139,125,  8,139,119,  4,139, 93, 12,139, 69, 16, 57,  7,115,
/* 0x0650 */  10,106,  8,232,200,255,255,255,131,196,  4,139, 85, 16, 74,131,
/* 0x0660 */ 250,255,116, 12,138,  6,136,  3, 70, 67, 74,131,250,255,117,244,
/* 0x0670 */ 139, 69, 16,  1, 71,  4, 41,  7,141,101,244, 91, 94, 95,201,195,
/* 0x0680 */  85,137,229, 86, 83,131,236, 20,139,117,  8,139, 93, 12,131, 59,
/* 0x0690 */   0, 15,132,223,  0,  0,  0,106, 12,141, 69,232, 80, 86,232,152,
/* 0x06a0 */ 255,255,255,131,196, 12,131,125,232,  0,117, 43,129,125,236, 85,
/* 0x06b0 */  80, 88, 33,116, 10,106,  2,232,100,255,255,255,131,196,  4,131,
/* 0x06c0 */  62,  0, 15,132,174,  0,  0,  0,106,  3,232, 81,255,255,255,131,
/* 0x06d0 */ 196,  4,233,159,  0,  0,  0,131,125,236,  0,117, 10,106,  4,232,
/* 0x06e0 */  60,255,255,255,131,196,  4,139, 69,236, 59, 69,232,119,  7,139,
/* 0x06f0 */  69,232, 59,  3,118, 10,106,  5,232, 35,255,255,255,131,196,  4,
/* 0x0700 */ 139, 69,236, 59, 69,232,115, 68,139, 69,232,137, 69,228,141, 69,
/* 0x0710 */ 228, 80,255,115,  4,139, 70,  4,131,232, 12, 80,232,252,255,255,
/* 0x0720 */ 255,131,196, 12,133,192,117,  8,139, 69,232, 59, 69,228,116, 10,
/* 0x0730 */ 106,  7,232,233,254,255,255,131,196,  4,139, 70,  4,  3, 69,236,
/* 0x0740 */ 137, 70,  4,139,  6, 43, 69,236,137,  6,235, 18,131,  6, 12,255,
/* 0x0750 */ 117,236,255,115,  4, 86,232,224,254,255,255,131,196, 12,139, 67,
/* 0x0760 */   4,  3, 69,232,137, 67,  4,139,  3, 43, 69,232,137,  3,133,192,
/* 0x0770 */  15,133, 33,255,255,255,141,101,248, 91, 94,201,195, 85,137,229,
/* 0x0780 */  86, 83,131,236, 16,139, 85,  8,185,  0,  0,  0,  0,131, 58,  1,
/* 0x0790 */ 117,118,246, 66, 24,  1,116,112,139, 66, 20, 43, 66, 16,139, 85,
/* 0x07a0 */  12,  1,194,137,208,247,216, 35, 69, 16,199, 69,244,205,128, 97,
/* 0x07b0 */ 195,131,248,  3,118, 11,137,209,184,205,128, 97,195,137,  2,235,
/* 0x07c0 */  71,232,  4,  0,  0,  0,117,112,120,  0, 90,185,  0,  0,  0,  0,
/* 0x07d0 */ 190,100,  1,  0,  0,137,240,137,211,205,128,137,198,141, 77,244,
/* 0x07e0 */ 186,  4,  0,  0,  0,137,195,106,  4, 88,205,128,106,  0, 86,106,
/* 0x07f0 */   2,106,  5,106,  4,106,  0,232,252,255,255,255,137,193,131,196,
/* 0x0800 */  24,137,243,106,  6, 88,205,128,137,200,141,101,248, 91, 94,201,
/* 0x0810 */ 195, 85,137,229, 87, 86, 83,129,236,  0, 64,  0,  0,139, 85, 12,
/* 0x0820 */ 139, 69, 16,247,208,137,199, 33,215,116, 55,137,211, 41,251,141,
/* 0x0830 */ 181,244,191,255,255, 87, 83, 86,232,252,255,255,255,106,  0,106,
/* 0x0840 */ 255,106, 50,106,  3,139, 85,  8,141,  4, 23, 80, 83,232,252,255,
/* 0x0850 */ 255,255,131,196, 36, 87, 86, 83,232,252,255,255,255,131,196, 12,
/* 0x0860 */ 235, 24,106,  0,106,255,106, 50,106,  3,139, 77,  8,141,  4, 15,
/* 0x0870 */  80, 82,232,252,255,255,255,131,196, 24,141,101,244, 91, 94, 95,
/* 0x0880 */ 201,195,232,  9,  0,  0,  0, 64,  4,  2,  6,  1,  5,  3,  7,  0,
/* 0x0890 */  90,139, 68, 36,  4,139, 64, 24,131,224,  7, 15,190,  4,  2,131,
/* 0x08a0 */ 224,  7,195, 85,137,229, 87, 86, 83,139,125,  8,139,117, 16,139,
/* 0x08b0 */  93, 20,246, 70, 24,  1,116, 53,106,  4, 87,255,117, 12,232,252,
/* 0x08c0 */ 255,255,255, 87,255,117, 12,232,252,255,255,255,106,  0, 83,106,
/* 0x08d0 */  18, 86,232,252,255,255,255,137,  4, 36, 87,255,117, 12,232,252,
/* 0x08e0 */ 255,255,255,131,196, 44,106,  6, 88,205,128,235, 27, 86,232,252,
/* 0x08f0 */ 255,255,255,137,  4, 36,255,118, 20,139, 69, 24,  3, 70,  8, 80,
/* 0x0900 */ 232,252,255,255,255,131,196, 12,184,  0,  0,  0,  0,141,101,244,
/* 0x0910 */  91, 94, 95,201,195, 85,137,229, 87, 86, 83,129,236,  8, 64,  0,
/* 0x0920 */   0,139,125, 12, 35,125, 16,139, 69, 12, 41,248,137,133,240,191,
/* 0x0930 */ 255,255,116, 22,141,133,244,191,255,255,255,181,240,191,255,255,
/* 0x0940 */  87, 80,232,252,255,255,255,131,196, 12,106,  0,139,133,240,191,
/* 0x0950 */ 255,255,  3, 69,  8, 80, 87,232,252,255,255,255,137,194,129,226,
/* 0x0960 */ 255, 15,  0,  0, 41,208,141,114,255,131,196, 12, 57,248,116, 24,
/* 0x0970 */ 255,181,240,191,255,255,255,117, 12, 87, 80,104, 98, 18,  0,  0,
/* 0x0980 */ 232,252,255,255,255,131,196, 20,131,189,240,191,255,255,  0,116,
/* 0x0990 */  19,141,141,244,191,255,255,137,243,139,149,240,191,255,255,106,
/* 0x09a0 */   4, 88,205,128,137,240,141,101,244, 91, 94, 95,201,195, 85,137,
/* 0x09b0 */ 229, 87, 86, 83,131,236, 92,139, 93,  8,139,125, 16,232,252,255,
/* 0x09c0 */ 255,255,137, 69,192,139,  3,137,218, 41,194,137, 85,188,137, 69,
/* 0x09d0 */ 228,139, 83,  4,137, 85,232,139, 67,  8,137, 69,236,139,115, 12,
/* 0x09e0 */ 137,117,240,137, 69,184,  3,117,188, 41,243,137, 93,180,  3, 85,
/* 0x09f0 */ 188,137, 85,176,106,  0,106,255,106, 34,106,  3, 83,106,  0,232,
/* 0x0a00 */ 252,255,255,255,137, 69,172, 83, 86, 80,232,252,255,255,255,139,
/* 0x0a10 */  77,172,131,193, 24,139, 93,172,139, 67, 24,137, 69,204,137,125,
/* 0x0a20 */ 208,139, 65,  4,131,192, 12,137, 69,196,137, 77,200,131,196, 36,
/* 0x0a30 */ 141, 69,204, 80,141, 69,196, 80,232, 67,252,255,255,141,119, 52,
/* 0x0a40 */  15,183, 71, 44,193,224,  5,141, 60, 48,199, 69,168,  0,  0,  0,
/* 0x0a50 */   0,199, 69,164,  0,  0,  0,  0,199, 69,160,  0,  0,  0,  0,131,
/* 0x0a60 */ 196,  8, 57,254, 15,131,  3,  1,  0,  0,131, 62,  1, 15,133,239,
/* 0x0a70 */   0,  0,  0,246, 70, 24,  2, 15,133,229,  0,  0,  0,131,125,164,
/* 0x0a80 */   0,117,  9,139, 69,188, 43, 70,  8,137, 69,164,139, 94, 16,  3,
/* 0x0a90 */  94,  8,199, 69,196, 12,  0,  0,  0,255,117,196,141, 69,212, 80,
/* 0x0aa0 */ 141, 85,196, 82,232,146,251,255,255,131,109,200, 12,139, 69,216,
/* 0x0ab0 */ 137, 69,196,139, 69,212,137, 69,204,  3, 93,164, 41,195,137, 93,
/* 0x0ac0 */ 208,139, 70, 16,  3, 70,  4,131,196, 12, 59, 69,184,119, 18,131,
/* 0x0ad0 */ 125,160,  0,117, 12,199, 69,160,  1,  0,  0,  0,233,129,  0,  0,
/* 0x0ae0 */   0,187,  0,  0,  0,  0,246, 70, 24,  1,116, 21,255,117,192,255,
/* 0x0af0 */ 117,208,255,117,204,232,252,255,255,255,137,195,131,196, 12,235,
/* 0x0b00 */  17,255,117,192,255,117,208,255,117,204,232,  2,253,255,255,131,
/* 0x0b10 */ 196, 12,139, 69,204,139, 85,208,137, 69,152,137, 85,156,141, 85,
/* 0x0b20 */ 204, 82,141, 69,196, 80,232, 85,251,255,255,131,196,  8,131,125,
/* 0x0b30 */ 168,  0,117, 43,246, 70, 24,  1,116, 37,139, 69,192,247,208, 80,
/* 0x0b40 */ 255,117,208, 86,232, 52,252,255,255,137, 69,168,255,117,164, 83,
/* 0x0b50 */  86,255,117,156,255,117,152,232,252,255,255,255,131,196, 32,255,
/* 0x0b60 */  69,160,131,198, 32, 57,254, 15,130,253,254,255,255,255,117,180,
/* 0x0b70 */ 255,117,172,232,252,255,255,255,139, 85, 12,255,114,  8,255,114,
/* 0x0b80 */   4,255, 50,255, 85,176,131,196, 20,139, 69,168,141,101,244, 91,
/* 0x0b90 */  94, 95,201,195,  0,240,255,255,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ba0 */ 235, 35,232,  0,  0,  0,  0, 88,139,128,237,255,255,255,195,232,
/* 0x0bb0 */   0,  0,  0,  0, 89,141,137,224,255,255,255,139, 65,  8,133,192,
/* 0x0bc0 */ 116,  2,  1,200,195, 89,141, 68, 36, 48,129,236,  0,  2,  0,  0,
/* 0x0bd0 */  84, 80, 81,232,252,255,255,255,129,196, 16,  2,  0,  0,137,197,
/* 0x0be0 */  91, 89,104, 91,  0,  0,  0, 88,255,229, 88,255,208, 89,137,240,
/* 0x0bf0 */  41,200, 90, 41,215, 89,137, 57, 91, 93,195,204,195, 87,137,240,
/* 0x0c00 */ 137,209,243,170, 88,195, 89,137,248, 95,137,242, 94,135, 12, 36,
/* 0x0c10 */  87,209,233,115,  1,164,209,233,115,  2,102,165,116,  2,243,165,
/* 0x0c20 */ 137,199,137,214, 88, 90,131,236, 12, 82,195, 85,137,229, 87, 86,
/* 0x0c30 */ 139, 77, 16,139,117, 12,139,125,  8,243,164,137,248, 94, 95, 93,
/* 0x0c40 */ 195, 83,141, 92, 36,  8,139,  3, 37,255, 15,  0,  0, 41,  3,  1,
/* 0x0c50 */  67,  4,176, 90,232,155,  0,  0,  0,139, 11,133,201,116, 11,246,
/* 0x0c60 */  67, 12, 16,116,  5, 57,200,116,  1,244, 91,195,135, 92, 36,  4,
/* 0x0c70 */ 137,217,129,227,  0,240,255,255, 41,217,  3, 76, 36,  8,139, 84,
/* 0x0c80 */  36, 12,176,125,232,107,  0,  0,  0,139, 92, 36,  4,195,135, 92,
/* 0x0c90 */  36,  4,137,217,129,227,  0,240,255,255, 41,217,  3, 76, 36,  8,
/* 0x0ca0 */ 139, 84, 36, 12,176,144,232, 73,  0,  0,  0,139, 92, 36,  4,195,
/* 0x0cb0 */  85,137,229, 83,139, 93,  8,137,216, 37,255, 15,  0,  0, 41,195,
/* 0x0cc0 */ 139, 77, 12,  1,193,176, 91,232, 40,  0,  0,  0, 91, 93,195,184,
/* 0x0cd0 */ 100,  1,  0,  0,235, 33,137,216, 37,255, 15,  0,  0, 41,195,  1,
/* 0x0ce0 */ 193,176,125,235,  2,176,  1,235,  2,176,  6,235,  2,176, 91,235,
/* 0x0cf0 */   3,204,176,  4, 15,182,192, 80,205,128, 90, 61,  0,240,255,255,
/* 0x0d00 */ 115,  1,195,244,139, 68, 36, 16,131,248, 73,116,  7,131,248, 70,
/* 0x0d10 */ 116,  2,235, 86, 85,137,229, 83, 86, 87,139,117,  8,139, 77, 12,
/* 0x0d20 */ 139, 85, 16,136,198,141, 76, 14,253,137,243,235, 50, 57,206,115,
/* 0x0d30 */  53, 86, 94,172,128,254, 73,117, 14, 60,128,114, 10, 60,143,119,
/* 0x0d40 */   6,128,126,254, 15,116,  6, 44,232, 60,  1,119,224, 57,206,115,
/* 0x0d50 */  21, 86,173, 40,208,117,219, 95, 15,200, 41,248,  1,216,171, 57,
/* 0x0d60 */ 206,115,  3,172,235,225, 95, 94, 91, 93,195, 85,137,229, 87, 86,
/* 0x0d70 */  83,232,117,  0,  0,  0, 80,139,117,  8, 15,182, 70,  9,133,192,
/* 0x0d80 */ 116, 19, 80, 15,182, 70, 10, 80,255, 54,255,117, 12,232,114,255,
/* 0x0d90 */ 255,255,131,196, 16, 88, 91, 94, 95, 93,195,204,195,139, 30,131,
/* 0x0da0 */ 238,252, 17,219, 15,182, 22,243,195,243, 15, 30,251,  1,219,116,
/* 0x0db0 */ 236,243,195,141,  4, 47,131,249,  5, 15,182, 16,118, 31,131,253,
/* 0x0dc0 */ 252,119, 26,131,233,  4,139, 16,131,192,  4,131,233,  4,137, 23,
/* 0x0dd0 */ 141,127,  4,115,241,131,193,  4, 15,182, 16,116, 12, 64,136, 23,
/* 0x0de0 */  73, 15,182, 16,141,127,  1,117,244,243,195,139,117,  8,139,125,
/* 0x0df0 */  12,173,139, 85, 16,137,  2, 82,173,145,173, 15,182,208,  1,241,
/* 0x0e00 */  81, 87, 85, 49,219, 49,201,131,205,255,252, 15,182, 86,252,  0,
/* 0x0e10 */ 204,244, 93, 88, 41,199, 88, 89,137, 57, 41,240,195,  0,  0,  0,
/* 0x0e20 */ 128,250,  8, 15,133,203,  0,  0,  0,235,  4, 70,136, 23, 71, 15,
/* 0x0e30 */ 182, 22,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,182, 22,
/* 0x0e40 */ 114,233,106,  1, 88,235, 17, 72,  1,219,117, 10,139, 30,131,238,
/* 0x0e50 */ 252, 17,219, 15,182, 22, 17,192,  1,219,117, 10,139, 30,131,238,
/* 0x0e60 */ 252, 17,219, 15,182, 22, 17,192,  1,219,117, 10,139, 30,131,238,
/* 0x0e70 */ 252, 17,219, 15,182, 22,115,207,131,232,  3,114, 23,193,224,  8,
/* 0x0e80 */  70,  9,208,131,240,255, 15,132,254,255,255,255,209,248,137,197,
/* 0x0e90 */ 114, 63,235, 13,  1,219,117,  7,139, 30,131,238,252, 17,219,114,
/* 0x0ea0 */  48, 65,  1,219,117,  7,139, 30,131,238,252, 17,219,114, 34,  1,
/* 0x0eb0 */ 219,117, 10,139, 30,131,238,252, 17,219, 15,182, 22, 17,201,  1,
/* 0x0ec0 */ 219,117,  7,139, 30,131,238,252, 17,219,115,227,131,193,  2,235,
/* 0x0ed0 */  16,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,182, 22, 17,
/* 0x0ee0 */ 201,129,253,  0,251,255,255,131,209,  2,232,171,  0,  0,  0,233,
/* 0x0ef0 */  59,255,255,255,128,250,  5, 15,133,191,  0,  0,  0,235,  4, 70,
/* 0x0f00 */ 136, 23, 71, 15,182, 22,  1,219,117, 10,139, 30,131,238,252, 17,
/* 0x0f10 */ 219, 15,182, 22,114,233,106,  1, 88,235, 17, 72,  1,219,117, 10,
/* 0x0f20 */ 139, 30,131,238,252, 17,219, 15,182, 22, 17,192,  1,219,117, 10,
/* 0x0f30 */ 139, 30,131,238,252, 17,219, 15,182, 22, 17,192,  1,219,117, 10,
/* 0x0f40 */ 139, 30,131,238,252, 17,219, 15,182, 22,115,207,131,232,  3,114,
/* 0x0f50 */  21,193,224,  8, 70,  9,208,131,240,255, 15,132,254,255,255,255,
/* 0x0f60 */ 209,248,137,197,235, 14,  1,219,117, 10,139, 30,131,238,252, 17,
/* 0x0f70 */ 219, 15,182, 22, 17,201,  1,219,117, 10,139, 30,131,238,252, 17,
/* 0x0f80 */ 219, 15,182, 22, 17,201,117, 33, 65,  1,219,117, 10,139, 30,131,
/* 0x0f90 */ 238,252, 17,219, 15,182, 22, 17,201,  1,219,117,  7,139, 30,131,
/* 0x0fa0 */ 238,252, 17,219,115,227,131,193,  2,129,253,  0,251,255,255,131,
/* 0x0fb0 */ 209,  1,232,171,  0,  0,  0,233, 71,255,255,255,128,250,  2, 15,
/* 0x0fc0 */ 133,171,  0,  0,  0,235,  4, 70,136, 23, 71, 15,182, 22,  1,219,
/* 0x0fd0 */ 117, 10,139, 30,131,238,252, 17,219, 15,182, 22,114,233,106,  1,
/* 0x0fe0 */  88,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,182, 22, 17,
/* 0x0ff0 */ 192,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,182, 22,115,
/* 0x1000 */ 224,131,232,  3,114, 17,193,224,  8, 70,  9,208,131,240,255, 15,
/* 0x1010 */ 132,254,255,255,255,137,197,106,  1, 88,  1,219,117, 10,139, 30,
/* 0x1020 */ 131,238,252, 17,219, 15,182, 22, 17,201,  1,219,117, 10,139, 30,
/* 0x1030 */ 131,238,252, 17,219, 15,182, 22, 17,201,117, 34,137,193,131,192,
/* 0x1040 */   2,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,182, 22, 17,
/* 0x1050 */ 201,  1,219,117,  7,139, 30,131,238,252, 17,219,115,227,129,253,
/* 0x1060 */   0,243,255,255, 17,193,232,171,  0,  0,  0,233, 91,255,255,255,
/* 0x1070 */ 128,250, 14, 15,133, 28,  0,  0,  0,255,118,248,128,126,252, 14,
/* 0x1080 */ 116,  1,244,137,229,141,156, 36,  0,  0,  0,  0, 49,192, 80, 57,
/* 0x1090 */ 220,117,251, 83,255,118,244, 87,131,195,  4, 83,139, 70,248, 72,
/* 0x10a0 */  72, 80, 70, 70, 86,131,195,  4, 83, 41,192, 80,199,  3,  0,  0,
/* 0x10b0 */   0,  0,137,229,139, 85,  0,172, 74,136,193, 36,  7,192,233,  3,
/* 0x10c0 */ 187,  0,253,255,255,211,227,141,164, 92,144,241,255,255,131,228,
/* 0x10d0 */ 224,106,  0,106,  0,137,227, 83,131,195,  4,139, 77, 16,255, 49,
/* 0x10e0 */  87, 83,131,195,  4,136, 67,  2,172, 74,136,193, 36, 15,136,  3,
/* 0x10f0 */ 192,233,  4,136, 75,  1, 82, 86, 83, 80, 85, 87,191,  0,  0,  0,
/* 0x1100 */   0, 86, 83,131,236,100,139, 84, 36,120,199, 68, 36, 92,  0,  0,
/* 0x1110 */   0,  0,141, 66,  4,137, 68, 36, 96,184,  1,  0,  0,  0, 15,182,
/* 0x1120 */  74,  2,137,195,211,227,137,217, 73,137, 76, 36, 88, 15,182, 74,
/* 0x1130 */   1,211,224,139,140, 36,144,  0,  0,  0, 72,137, 68, 36, 84,139,
/* 0x1140 */ 132, 36,132,  0,  0,  0, 15,182, 50,199, 68, 36, 76,  0,  0,  0,
/* 0x1150 */   0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,  0,199, 68, 36, 72,
/* 0x1160 */   1,  0,  0,  0,137,116, 36, 80,199, 68, 36, 68,  1,  0,  0,  0,
/* 0x1170 */ 199, 68, 36, 64,  1,  0,  0,  0,199, 68, 36, 60,  1,  0,  0,  0,
/* 0x1180 */ 199,  1,  0,  0,  0,  0, 15,182, 74,  1,  1,241,211,224,141,136,
/* 0x1190 */  54,  7,  0,  0, 57, 76, 36, 92,115, 14,139, 68, 36, 96,102,199,
/* 0x11a0 */   0,  0,  4,131,192,  2,226,246,139,108, 36,124,199, 68, 36, 48,
/* 0x11b0 */   0,  0,  0,  0,199, 68, 36, 52,255,255,255,255,186,  0,  0,  0,
/* 0x11c0 */   0,137,235,  3,156, 36,128,  0,  0,  0,137, 92, 36, 56, 59,108,
/* 0x11d0 */  36, 56, 15,132,128,  8,  0,  0,193,100, 36, 48,  8, 66, 15,182,
/* 0x11e0 */  69,  0, 69,  9, 68, 36, 48,131,250,  4,126,226,139,180, 36,140,
/* 0x11f0 */   0,  0,  0, 57,116, 36, 92, 15,131,226,  1,  0,  0,139,132, 36,
/* 0x1200 */ 136,  0,  0,  0,137, 68, 36, 24,139, 84, 36, 92, 35, 84, 36, 88,
/* 0x1210 */ 139, 68, 36, 76,139, 76, 36, 96,193,224,  4,137, 84, 36, 44,  1,
/* 0x1220 */ 208,129,124, 36, 52,255,255,255,  0,141, 52, 65,119, 29, 59,108,
/* 0x1230 */  36, 56, 15,132, 32,  8,  0,  0,193,100, 36, 48,  8,193,100, 36,
/* 0x1240 */  52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,
/* 0x1250 */ 139, 22,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,
/* 0x1260 */ 131, 80,  2,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,
/* 0x1270 */ 138, 76, 36, 80,193,248,  5,187,  1,  0,  0,  0,141,  4,  2,102,
/* 0x1280 */ 137,  6,139, 68, 36, 92, 35, 68, 36, 84,139,116, 36, 96,211,224,
/* 0x1290 */ 137,249, 15,182,209,185,  8,  0,  0,  0, 43, 76, 36, 80,211,250,
/* 0x12a0 */   1,208,105,192,  0,  6,  0,  0,131,124, 36, 76,  6,141,132, 48,
/* 0x12b0 */ 108, 14,  0,  0,137, 68, 36, 20, 15,142, 72,  1,  0,  0,139, 68,
/* 0x12c0 */  36, 92, 43, 68, 36, 72,139,148, 36,136,  0,  0,  0, 15,182,  4,
/* 0x12d0 */  16,137, 68, 36, 40,235, 46,137, 68, 36, 52,184,  0,  8,  0,  0,
/* 0x12e0 */  41,216,137,251,193,248,  5,133,210,141,  4,  1,102,137,134,  0,
/* 0x12f0 */   2,  0,  0, 15,133,106,  1,  0,  0,129,251,255,  0,  0,  0, 15,
/* 0x1300 */ 143,143,  0,  0,  0,209,100, 36, 40,139, 84, 36, 40,141, 60, 27,
/* 0x1310 */ 139, 76, 36, 20,129,226,  0,  1,  0,  0,129,124, 36, 52,255,255,
/* 0x1320 */ 255,  0,141,  4, 81,141, 52, 56,119, 29, 59,108, 36, 56, 15,132,
/* 0x1330 */  36,  7,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182,
/* 0x1340 */  69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139,142,  0,  2,
/* 0x1350 */   0,  0,193,232, 11, 15,183,217, 15,175,195, 57, 68, 36, 48, 15,
/* 0x1360 */ 130,114,255,255,255, 41, 68, 36, 52, 41, 68, 36, 48,137,200,102,
/* 0x1370 */ 193,232,  5,141, 95,  1,102, 41,193,133,210,102,137,142,  0,  2,
/* 0x1380 */   0,  0, 15,132,219,  0,  0,  0,129,251,255,  0,  0,  0, 15,142,
/* 0x1390 */ 113,255,255,255,139, 84, 36, 24,137,223,136, 26, 66,255, 68, 36,
/* 0x13a0 */  92,131,124, 36, 76,  3,137, 84, 36, 24, 15,143,215,  0,  0,  0,
/* 0x13b0 */ 199, 68, 36, 76,  0,  0,  0,  0,139,132, 36,140,  0,  0,  0, 57,
/* 0x13c0 */  68, 36, 92, 15,130, 63,254,255,255,129,124, 36, 52,255,255,255,
/* 0x13d0 */   0,119, 12, 59,108, 36, 56,184,  1,  0,  0,  0,116, 32, 69, 43,
/* 0x13e0 */ 108, 36,124,184,  0,  0,  0,  0,139,148, 36,132,  0,  0,  0,139,
/* 0x13f0 */  92, 36, 92,139,140, 36,144,  0,  0,  0,137, 42,137, 25,131,196,
/* 0x1400 */ 100,233, 46,  8,  0,  0,129,124, 36, 52,255,255,255,  0,141, 52,
/* 0x1410 */  27,139, 68, 36, 20,141, 28,  6,119, 29, 59,108, 36, 56, 15,132,
/* 0x1420 */  52,  6,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182,
/* 0x1430 */  69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 11,193,232,
/* 0x1440 */  11, 15,183,209, 15,175,194, 57, 68, 36, 48,115, 79,137, 68, 36,
/* 0x1450 */  52,184,  0,  8,  0,  0, 41,208,193,248,  5,141,  4,  1,102,137,
/* 0x1460 */   3,137,243,129,251,255,  0,  0,  0,126,155,139, 84, 36, 24,137,
/* 0x1470 */ 223,136, 26, 66,255, 68, 36, 92,131,124, 36, 76,  3,137, 84, 36,
/* 0x1480 */  24, 15,142, 41,255,255,255,131,124, 36, 76,  9, 15,143,107,  6,
/* 0x1490 */   0,  0,131,108, 36, 76,  3,233, 28,255,255,255, 41, 68, 36, 52,
/* 0x14a0 */  41, 68, 36, 48,137,200,102,193,232,  5,102, 41,193,102,137, 11,
/* 0x14b0 */ 141, 94,  1,235,174,139, 92, 36, 52, 41, 68, 36, 48, 41,195,137,
/* 0x14c0 */ 208,102,193,232,  5,139, 76, 36, 76,102, 41,194,129,251,255,255,
/* 0x14d0 */ 255,  0,102,137, 22,139,116, 36, 96,141, 60, 78,119, 27, 59,108,
/* 0x14e0 */  36, 56, 15,132,112,  5,  0,  0,193,100, 36, 48,  8, 15,182, 69,
/* 0x14f0 */   0,193,227,  8,  9, 68, 36, 48, 69,102,139,151,128,  1,  0,  0,
/* 0x1500 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,
/* 0x1510 */ 131,228,  2,  0,  0,137,198,184,  0,  8,  0,  0, 41,200,139, 92,
/* 0x1520 */  36, 96,193,248,  5,131,124, 36, 76,  6,141,  4,  2,139, 76, 36,
/* 0x1530 */  72,139, 84, 36, 68,102,137,135,128,  1,  0,  0,139, 68, 36, 64,
/* 0x1540 */ 137, 76, 36, 68,137, 68, 36, 60,184,  0,  0,  0,  0, 15,159,192,
/* 0x1550 */ 137, 84, 36, 64,141,  4, 64,129,195,100,  6,  0,  0,137, 68, 36,
/* 0x1560 */  76,129,254,255,255,255,  0,119, 27, 59,108, 36, 56, 15,132,229,
/* 0x1570 */   4,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,230,  8,  9,
/* 0x1580 */  68, 36, 48, 69,102,139, 19,137,240,193,232, 11, 15,183,202, 15,
/* 0x1590 */ 175,193, 57, 68, 36, 48, 15,131,102,  3,  0,  0,137, 68, 36, 52,
/* 0x15a0 */ 184,  0,  8,  0,  0, 41,200,193,100, 36, 44,  4,193,248,  5,139,
/* 0x15b0 */  76, 36, 44,141,  4,  2,199, 68, 36, 32,  0,  0,  0,  0,102,137,
/* 0x15c0 */   3,141, 92, 25,  4,137, 92, 36, 16,199, 68, 36, 36,  3,  0,  0,
/* 0x15d0 */   0,139,124, 36, 36,186,  1,  0,  0,  0,235, 25,137, 68, 36, 52,
/* 0x15e0 */ 184,  0,  8,  0,  0, 41,200,193,248,  5, 79,141,  4,  2,137,242,
/* 0x15f0 */ 102,137,  3,116, 97,129,124, 36, 52,255,255,255,  0,141, 52, 18,
/* 0x1600 */ 139, 68, 36, 16,141, 28,  6,119, 29, 59,108, 36, 56, 15,132, 69,
/* 0x1610 */   4,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,
/* 0x1620 */   0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 19,193,232, 11,
/* 0x1630 */  15,183,202, 15,175,193, 57, 68, 36, 48,114,160, 41, 68, 36, 52,
/* 0x1640 */  41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194, 79,102,137,
/* 0x1650 */  19,141, 86,  1,117,159,138, 76, 36, 36,184,  1,  0,  0,  0,211,
/* 0x1660 */ 224, 41,194,  3, 84, 36, 32,131,124, 36, 76,  3,137, 84, 36, 12,
/* 0x1670 */  15,143,254,  3,  0,  0,131, 68, 36, 76,  7,131,250,  3,137,208,
/* 0x1680 */ 126,  5,184,  3,  0,  0,  0,139, 92, 36, 96,193,224,  7,191,  6,
/* 0x1690 */   0,  0,  0,141,132, 24, 96,  3,  0,  0,137, 68, 36,  8,184,  1,
/* 0x16a0 */   0,  0,  0,235, 25,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,
/* 0x16b0 */ 193,248,  5, 79,141,  4,  2,102,137,  3,137,240,116, 97,129,124,
/* 0x16c0 */  36, 52,255,255,255,  0,141, 52,  0,139, 68, 36,  8,141, 28,  6,
/* 0x16d0 */ 119, 29, 59,108, 36, 56, 15,132,124,  3,  0,  0,193,100, 36, 48,
/* 0x16e0 */   8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139,
/* 0x16f0 */  68, 36, 52,102,139, 19,193,232, 11, 15,183,202, 15,175,193, 57,
/* 0x1700 */  68, 36, 48,114,160, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,
/* 0x1710 */ 193,232,  5,102, 41,194, 79,102,137, 19,141, 70,  1,117,159,141,
/* 0x1720 */  80,192,131,250,  3,137, 84, 36,  4, 15,142, 54,  3,  0,  0,137,
/* 0x1730 */ 211,137,208,131,227,  1,209,248,131,203,  2,131,250, 13,141,120,
/* 0x1740 */ 255, 15,143, 66,  4,  0,  0,137,249,139,116, 36, 96,211,227,  1,
/* 0x1750 */ 210,141,  4, 94,137, 92, 36,  4, 41,208,  5, 94,  5,  0,  0,137,
/* 0x1760 */   4, 36,184,  1,  0,  0,  0,199, 68, 36, 28,  1,  0,  0,  0,235,
/* 0x1770 */  33,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,141,
/* 0x1780 */   4,  2,102,137,  3,137,240,209,100, 36, 28, 79, 15,132,211,  2,
/* 0x1790 */   0,  0,129,124, 36, 52,255,255,255,  0,141, 52,  0,139, 12, 36,
/* 0x17a0 */ 141, 28, 14,119, 29, 59,108, 36, 56, 15,132,169,  2,  0,  0,193,
/* 0x17b0 */ 100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68,
/* 0x17c0 */  36, 48,139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,202, 15,
/* 0x17d0 */ 175,193, 57, 68, 36, 48,114,153, 41, 68, 36, 52, 41, 68, 36, 48,
/* 0x17e0 */ 137,208,102,193,232,  5,102, 41,194,141, 70,  1,102,137, 19,139,
/* 0x17f0 */  92, 36, 28,  9, 92, 36,  4,235,142, 41,195, 41, 68, 36, 48,137,
/* 0x1800 */ 208,102,193,232,  5,102, 41,194,129,251,255,255,255,  0,102,137,
/* 0x1810 */ 151,128,  1,  0,  0, 15,134,107,  1,  0,  0,102,139,143,152,  1,
/* 0x1820 */   0,  0,137,218,193,234, 11, 15,183,193, 15,175,208, 57, 84, 36,
/* 0x1830 */  48, 15,131,134,  1,  0,  0,190,  0,  8,  0,  0,137,211, 41,198,
/* 0x1840 */ 137,240,193,248,  5,141,  4,  1,139, 76, 36, 44,102,137,135,152,
/* 0x1850 */   1,  0,  0,139, 68, 36, 76,193,224,  5,  3, 68, 36, 96,129,250,
/* 0x1860 */ 255,255,255,  0,141, 60, 72,119, 27, 59,108, 36, 56, 15,132,229,
/* 0x1870 */   1,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9,
/* 0x1880 */  68, 36, 48, 69,102,139,151,224,  1,  0,  0,137,216,193,232, 11,
/* 0x1890 */  15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,103,  2,  0,  0,
/* 0x18a0 */ 137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,
/* 0x18b0 */   2,102,137,135,224,  1,  0,  0,139, 68, 36, 92,133,192, 15,132,
/* 0x18c0 */ 148,  1,  0,  0,131,124, 36, 76,  6,184,  0,  0,  0,  0,139,156,
/* 0x18d0 */  36,136,  0,  0,  0,139, 84, 36, 24, 15,159,192,141, 68,  0,  9,
/* 0x18e0 */ 137, 68, 36, 76,139, 68, 36, 92, 43, 68, 36, 72, 15,182, 60, 24,
/* 0x18f0 */ 137,248,136,  2, 66,255, 68, 36, 92,137, 84, 36, 24,233,182,250,
/* 0x1900 */ 255,255, 41,198, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,
/* 0x1910 */ 194,129,254,255,255,255,  0,102,137, 19,119, 27, 59,108, 36, 56,
/* 0x1920 */  15,132, 50,  1,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,
/* 0x1930 */ 230,  8,  9, 68, 36, 48, 69,102,139, 83,  2,137,240,193,232, 11,
/* 0x1940 */  15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,119,  1,  0,  0,
/* 0x1950 */ 137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,100, 36, 44,  4,
/* 0x1960 */ 193,248,  5,139,116, 36, 44,141,  4,  2,199, 68, 36, 32,  8,  0,
/* 0x1970 */   0,  0,102,137, 67,  2,141,156, 30,  4,  1,  0,  0,137, 92, 36,
/* 0x1980 */  16,233, 67,252,255,255, 59,108, 36, 56, 15,132,200,  0,  0,  0,
/* 0x1990 */ 193,100, 36, 48,  8,193,227,  8,102,139,143,152,  1,  0,  0, 15,
/* 0x19a0 */ 182, 69,  0,137,218,  9, 68, 36, 48,193,234, 11, 15,183,193, 69,
/* 0x19b0 */  15,175,208, 57, 84, 36, 48, 15,130,122,254,255,255,137,200, 41,
/* 0x19c0 */ 211,102,193,232,  5, 41, 84, 36, 48,102, 41,193,129,251,255,255,
/* 0x19d0 */ 255,  0,102,137,143,152,  1,  0,  0,119, 23, 59,108, 36, 56,116,
/* 0x19e0 */ 119,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36,
/* 0x19f0 */  48, 69,102,139,151,176,  1,  0,  0,137,216,193,232, 11, 15,183,
/* 0x1a00 */ 202, 15,175,193, 57, 68, 36, 48, 15,131, 22,  1,  0,  0,137,198,
/* 0x1a10 */ 184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,135,
/* 0x1a20 */ 176,  1,  0,  0,139, 68, 36, 68,139, 84, 36, 72,137, 68, 36, 72,
/* 0x1a30 */ 137, 84, 36, 68,131,124, 36, 76,  6,184,  0,  0,  0,  0,139, 92,
/* 0x1a40 */  36, 96, 15,159,192,129,195,104, 10,  0,  0,141, 68, 64,  8,137,
/* 0x1a50 */  68, 36, 76,233,  9,251,255,255,131,196,100,184,  1,  0,  0,  0,
/* 0x1a60 */ 233,207,  1,  0,  0,139,116, 36,  4, 70,137,116, 36, 72, 15,132,
/* 0x1a70 */  85,249,255,255,139, 76, 36, 12,139, 68, 36, 92,131,193,  2, 57,
/* 0x1a80 */  68, 36, 72,119,211,137,194,139,132, 36,136,  0,  0,  0, 43, 68,
/* 0x1a90 */  36, 72,  3,148, 36,136,  0,  0,  0,  3, 68, 36, 92, 15,182, 56,
/* 0x1aa0 */  64,137,251,136, 26, 66,255, 68, 36, 92,255, 68, 36, 24, 73, 15,
/* 0x1ab0 */ 132,  3,249,255,255,139,180, 36,140,  0,  0,  0, 57,116, 36, 92,
/* 0x1ac0 */ 114,219,233,  2,249,255,255, 41,198, 41, 68, 36, 48,137,208,137,
/* 0x1ad0 */ 116, 36, 52,102,193,232,  5,199, 68, 36, 32, 16,  0,  0,  0,102,
/* 0x1ae0 */  41,194,199, 68, 36, 36,  8,  0,  0,  0,102,137, 83,  2,129,195,
/* 0x1af0 */   4,  2,  0,  0,137, 92, 36, 16,233,212,250,255,255,131,108, 36,
/* 0x1b00 */  76,  6,233,177,248,255,255,137,222, 41, 68, 36, 48, 41,198,137,
/* 0x1b10 */ 208,102,193,232,  5,102, 41,194,102,137,151,224,  1,  0,  0,233,
/* 0x1b20 */  16,255,255,255, 41,195, 41, 68, 36, 48,137,208,102,193,232,  5,
/* 0x1b30 */ 102, 41,194,129,251,255,255,255,  0,102,137,151,176,  1,  0,  0,
/* 0x1b40 */  15,134,165,  0,  0,  0,102,139,151,200,  1,  0,  0,137,216,193,
/* 0x1b50 */ 232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,169,  0,
/* 0x1b60 */   0,  0,137,198,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,
/* 0x1b70 */   2,102,137,135,200,  1,  0,  0,139, 68, 36, 64,139, 92, 36, 68,
/* 0x1b80 */ 137, 92, 36, 64,233,159,254,255,255,141, 80,251,129,124, 36, 52,
/* 0x1b90 */ 255,255,255,  0,119, 29, 59,108, 36, 56, 15,132,184,254,255,255,
/* 0x1ba0 */ 193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9,
/* 0x1bb0 */  68, 36, 48,209,108, 36, 52,  1,219,139, 68, 36, 52, 57, 68, 36,
/* 0x1bc0 */  48,114,  7, 41, 68, 36, 48,131,203,  1, 74,117,191,139, 84, 36,
/* 0x1bd0 */  96,193,227,  4,191,  4,  0,  0,  0,137, 92, 36,  4,129,194, 68,
/* 0x1be0 */   6,  0,  0,137, 20, 36,233,119,251,255,255, 59,108, 36, 56, 15,
/* 0x1bf0 */ 132, 99,254,255,255,193,100, 36, 48,  8, 15,182, 69,  0,193,227,
/* 0x1c00 */   8,  9, 68, 36, 48, 69,233, 59,255,255,255,137,222, 41, 68, 36,
/* 0x1c10 */  48, 41,198,137,208,102,193,232,  5,139, 76, 36, 64,102, 41,194,
/* 0x1c20 */ 139, 68, 36, 60,102,137,151,200,  1,  0,  0,137, 76, 36, 60,233,
/* 0x1c30 */  72,255,255,255, 91, 94, 95, 93, 85, 87,191,  0,  0,  0,  0, 86,
/* 0x1c40 */  83,131,236,100,139, 84, 36,120,199, 68, 36, 92,  0,  0,  0,  0,
/* 0x1c50 */ 141, 66,  4,137, 68, 36, 96,184,  1,  0,  0,  0, 15,182, 74,  2,
/* 0x1c60 */ 137,195,211,227,137,217, 73,137, 76, 36, 88, 15,182, 74,  1,211,
/* 0x1c70 */ 224,139,140, 36,144,  0,  0,  0, 72,137, 68, 36, 84,139,132, 36,
/* 0x1c80 */ 132,  0,  0,  0, 15,182, 50,199, 68, 36, 76,  0,  0,  0,  0,199,
/* 0x1c90 */   0,  0,  0,  0,  0,184,  0,  3,  0,  0,199, 68, 36, 72,  1,  0,
/* 0x1ca0 */   0,  0,137,116, 36, 80,199, 68, 36, 68,  1,  0,  0,  0,199, 68,
/* 0x1cb0 */  36, 64,  1,  0,  0,  0,199, 68, 36, 60,  1,  0,  0,  0,199,  1,
/* 0x1cc0 */   0,  0,  0,  0, 15,182, 74,  1,  1,241,211,224,141,136, 54,  7,
/* 0x1cd0 */   0,  0, 57, 76, 36, 92,115, 14,139, 68, 36, 96,102,199,  0,  0,
/* 0x1ce0 */   4,131,192,  2,226,246,139,108, 36,124,199, 68, 36, 48,  0,  0,
/* 0x1cf0 */   0,  0,199, 68, 36, 52,255,255,255,255,186,  0,  0,  0,  0,137,
/* 0x1d00 */ 235,  3,156, 36,128,  0,  0,  0,137, 92, 36, 56, 59,108, 36, 56,
/* 0x1d10 */  15,132,128,  8,  0,  0,193,100, 36, 48,  8, 66, 15,182, 69,  0,
/* 0x1d20 */  69,  9, 68, 36, 48,131,250,  4,126,226,139,180, 36,140,  0,  0,
/* 0x1d30 */   0, 57,116, 36, 92, 15,131,226,  1,  0,  0,139,132, 36,136,  0,
/* 0x1d40 */   0,  0,137, 68, 36, 24,139, 84, 36, 92, 35, 84, 36, 88,139, 68,
/* 0x1d50 */  36, 76,139, 76, 36, 96,193,224,  4,137, 84, 36, 44,  1,208,129,
/* 0x1d60 */ 124, 36, 52,255,255,255,  0,141, 52, 65,119, 29, 59,108, 36, 56,
/* 0x1d70 */  15,132, 32,  8,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8,
/* 0x1d80 */  15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 22,
/* 0x1d90 */ 193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131, 80,
/* 0x1da0 */   2,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,138, 76,
/* 0x1db0 */  36, 80,193,248,  5,187,  1,  0,  0,  0,141,  4,  2,102,137,  6,
/* 0x1dc0 */ 139, 68, 36, 92, 35, 68, 36, 84,139,116, 36, 96,211,224,137,249,
/* 0x1dd0 */  15,182,209,185,  8,  0,  0,  0, 43, 76, 36, 80,211,250,  1,208,
/* 0x1de0 */ 105,192,  0,  6,  0,  0,131,124, 36, 76,  6,141,132, 48,108, 14,
/* 0x1df0 */   0,  0,137, 68, 36, 20, 15,142, 72,  1,  0,  0,139, 68, 36, 92,
/* 0x1e00 */  43, 68, 36, 72,139,148, 36,136,  0,  0,  0, 15,182,  4, 16,137,
/* 0x1e10 */  68, 36, 40,235, 46,137, 68, 36, 52,184,  0,  8,  0,  0, 41,216,
/* 0x1e20 */ 137,251,193,248,  5,133,210,141,  4,  1,102,137,134,  0,  2,  0,
/* 0x1e30 */   0, 15,133,106,  1,  0,  0,129,251,255,  0,  0,  0, 15,143,143,
/* 0x1e40 */   0,  0,  0,209,100, 36, 40,139, 84, 36, 40,141, 60, 27,139, 76,
/* 0x1e50 */  36, 20,129,226,  0,  1,  0,  0,129,124, 36, 52,255,255,255,  0,
/* 0x1e60 */ 141,  4, 81,141, 52, 56,119, 29, 59,108, 36, 56, 15,132, 36,  7,
/* 0x1e70 */   0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0,
/* 0x1e80 */  69,  9, 68, 36, 48,139, 68, 36, 52,102,139,142,  0,  2,  0,  0,
/* 0x1e90 */ 193,232, 11, 15,183,217, 15,175,195, 57, 68, 36, 48, 15,130,114,
/* 0x1ea0 */ 255,255,255, 41, 68, 36, 52, 41, 68, 36, 48,137,200,102,193,232,
/* 0x1eb0 */   5,141, 95,  1,102, 41,193,133,210,102,137,142,  0,  2,  0,  0,
/* 0x1ec0 */  15,132,219,  0,  0,  0,129,251,255,  0,  0,  0, 15,142,113,255,
/* 0x1ed0 */ 255,255,139, 84, 36, 24,137,223,136, 26, 66,255, 68, 36, 92,131,
/* 0x1ee0 */ 124, 36, 76,  3,137, 84, 36, 24, 15,143,215,  0,  0,  0,199, 68,
/* 0x1ef0 */  36, 76,  0,  0,  0,  0,139,132, 36,140,  0,  0,  0, 57, 68, 36,
/* 0x1f00 */  92, 15,130, 63,254,255,255,129,124, 36, 52,255,255,255,  0,119,
/* 0x1f10 */  12, 59,108, 36, 56,184,  1,  0,  0,  0,116, 32, 69, 43,108, 36,
/* 0x1f20 */ 124,184,  0,  0,  0,  0,139,148, 36,132,  0,  0,  0,139, 92, 36,
/* 0x1f30 */  92,139,140, 36,144,  0,  0,  0,137, 42,137, 25,131,196,100,233,
/* 0x1f40 */  46,  8,  0,  0,129,124, 36, 52,255,255,255,  0,141, 52, 27,139,
/* 0x1f50 */  68, 36, 20,141, 28,  6,119, 29, 59,108, 36, 56, 15,132, 52,  6,
/* 0x1f60 */   0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0,
/* 0x1f70 */  69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 11,193,232, 11, 15,
/* 0x1f80 */ 183,209, 15,175,194, 57, 68, 36, 48,115, 79,137, 68, 36, 52,184,
/* 0x1f90 */   0,  8,  0,  0, 41,208,193,248,  5,141,  4,  1,102,137,  3,137,
/* 0x1fa0 */ 243,129,251,255,  0,  0,  0,126,155,139, 84, 36, 24,137,223,136,
/* 0x1fb0 */  26, 66,255, 68, 36, 92,131,124, 36, 76,  3,137, 84, 36, 24, 15,
/* 0x1fc0 */ 142, 41,255,255,255,131,124, 36, 76,  9, 15,143,107,  6,  0,  0,
/* 0x1fd0 */ 131,108, 36, 76,  3,233, 28,255,255,255, 41, 68, 36, 52, 41, 68,
/* 0x1fe0 */  36, 48,137,200,102,193,232,  5,102, 41,193,102,137, 11,141, 94,
/* 0x1ff0 */   1,235,174,139, 92, 36, 52, 41, 68, 36, 48, 41,195,137,208,102,
/* 0x2000 */ 193,232,  5,139, 76, 36, 76,102, 41,194,129,251,255,255,255,  0,
/* 0x2010 */ 102,137, 22,139,116, 36, 96,141, 60, 78,119, 27, 59,108, 36, 56,
/* 0x2020 */  15,132,112,  5,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,
/* 0x2030 */ 227,  8,  9, 68, 36, 48, 69,102,139,151,128,  1,  0,  0,137,216,
/* 0x2040 */ 193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,228,
/* 0x2050 */   2,  0,  0,137,198,184,  0,  8,  0,  0, 41,200,139, 92, 36, 96,
/* 0x2060 */ 193,248,  5,131,124, 36, 76,  6,141,  4,  2,139, 76, 36, 72,139,
/* 0x2070 */  84, 36, 68,102,137,135,128,  1,  0,  0,139, 68, 36, 64,137, 76,
/* 0x2080 */  36, 68,137, 68, 36, 60,184,  0,  0,  0,  0, 15,159,192,137, 84,
/* 0x2090 */  36, 64,141,  4, 64,129,195,100,  6,  0,  0,137, 68, 36, 76,129,
/* 0x20a0 */ 254,255,255,255,  0,119, 27, 59,108, 36, 56, 15,132,229,  4,  0,
/* 0x20b0 */   0,193,100, 36, 48,  8, 15,182, 69,  0,193,230,  8,  9, 68, 36,
/* 0x20c0 */  48, 69,102,139, 19,137,240,193,232, 11, 15,183,202, 15,175,193,
/* 0x20d0 */  57, 68, 36, 48, 15,131,102,  3,  0,  0,137, 68, 36, 52,184,  0,
/* 0x20e0 */   8,  0,  0, 41,200,193,100, 36, 44,  4,193,248,  5,139, 76, 36,
/* 0x20f0 */  44,141,  4,  2,199, 68, 36, 32,  0,  0,  0,  0,102,137,  3,141,
/* 0x2100 */  92, 25,  4,137, 92, 36, 16,199, 68, 36, 36,  3,  0,  0,  0,139,
/* 0x2110 */ 124, 36, 36,186,  1,  0,  0,  0,235, 25,137, 68, 36, 52,184,  0,
/* 0x2120 */   8,  0,  0, 41,200,193,248,  5, 79,141,  4,  2,137,242,102,137,
/* 0x2130 */   3,116, 97,129,124, 36, 52,255,255,255,  0,141, 52, 18,139, 68,
/* 0x2140 */  36, 16,141, 28,  6,119, 29, 59,108, 36, 56, 15,132, 69,  4,  0,
/* 0x2150 */   0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,
/* 0x2160 */   9, 68, 36, 48,139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,
/* 0x2170 */ 202, 15,175,193, 57, 68, 36, 48,114,160, 41, 68, 36, 52, 41, 68,
/* 0x2180 */  36, 48,137,208,102,193,232,  5,102, 41,194, 79,102,137, 19,141,
/* 0x2190 */  86,  1,117,159,138, 76, 36, 36,184,  1,  0,  0,  0,211,224, 41,
/* 0x21a0 */ 194,  3, 84, 36, 32,131,124, 36, 76,  3,137, 84, 36, 12, 15,143,
/* 0x21b0 */ 254,  3,  0,  0,131, 68, 36, 76,  7,131,250,  3,137,208,126,  5,
/* 0x21c0 */ 184,  3,  0,  0,  0,139, 92, 36, 96,193,224,  7,191,  6,  0,  0,
/* 0x21d0 */   0,141,132, 24, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,
/* 0x21e0 */   0,235, 25,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,
/* 0x21f0 */   5, 79,141,  4,  2,102,137,  3,137,240,116, 97,129,124, 36, 52,
/* 0x2200 */ 255,255,255,  0,141, 52,  0,139, 68, 36,  8,141, 28,  6,119, 29,
/* 0x2210 */  59,108, 36, 56, 15,132,124,  3,  0,  0,193,100, 36, 48,  8,193,
/* 0x2220 */ 100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36,
/* 0x2230 */  52,102,139, 19,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36,
/* 0x2240 */  48,114,160, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,193,232,
/* 0x2250 */   5,102, 41,194, 79,102,137, 19,141, 70,  1,117,159,141, 80,192,
/* 0x2260 */ 131,250,  3,137, 84, 36,  4, 15,142, 54,  3,  0,  0,137,211,137,
/* 0x2270 */ 208,131,227,  1,209,248,131,203,  2,131,250, 13,141,120,255, 15,
/* 0x2280 */ 143, 66,  4,  0,  0,137,249,139,116, 36, 96,211,227,  1,210,141,
/* 0x2290 */   4, 94,137, 92, 36,  4, 41,208,  5, 94,  5,  0,  0,137,  4, 36,
/* 0x22a0 */ 184,  1,  0,  0,  0,199, 68, 36, 28,  1,  0,  0,  0,235, 33,137,
/* 0x22b0 */  68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,
/* 0x22c0 */ 102,137,  3,137,240,209,100, 36, 28, 79, 15,132,211,  2,  0,  0,
/* 0x22d0 */ 129,124, 36, 52,255,255,255,  0,141, 52,  0,139, 12, 36,141, 28,
/* 0x22e0 */  14,119, 29, 59,108, 36, 56, 15,132,169,  2,  0,  0,193,100, 36,
/* 0x22f0 */  48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,
/* 0x2300 */ 139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,202, 15,175,193,
/* 0x2310 */  57, 68, 36, 48,114,153, 41, 68, 36, 52, 41, 68, 36, 48,137,208,
/* 0x2320 */ 102,193,232,  5,102, 41,194,141, 70,  1,102,137, 19,139, 92, 36,
/* 0x2330 */  28,  9, 92, 36,  4,235,142, 41,195, 41, 68, 36, 48,137,208,102,
/* 0x2340 */ 193,232,  5,102, 41,194,129,251,255,255,255,  0,102,137,151,128,
/* 0x2350 */   1,  0,  0, 15,134,107,  1,  0,  0,102,139,143,152,  1,  0,  0,
/* 0x2360 */ 137,218,193,234, 11, 15,183,193, 15,175,208, 57, 84, 36, 48, 15,
/* 0x2370 */ 131,134,  1,  0,  0,190,  0,  8,  0,  0,137,211, 41,198,137,240,
/* 0x2380 */ 193,248,  5,141,  4,  1,139, 76, 36, 44,102,137,135,152,  1,  0,
/* 0x2390 */   0,139, 68, 36, 76,193,224,  5,  3, 68, 36, 96,129,250,255,255,
/* 0x23a0 */ 255,  0,141, 60, 72,119, 27, 59,108, 36, 56, 15,132,229,  1,  0,
/* 0x23b0 */   0,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36,
/* 0x23c0 */  48, 69,102,139,151,224,  1,  0,  0,137,216,193,232, 11, 15,183,
/* 0x23d0 */ 202, 15,175,193, 57, 68, 36, 48, 15,131,103,  2,  0,  0,137, 68,
/* 0x23e0 */  36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,
/* 0x23f0 */ 137,135,224,  1,  0,  0,139, 68, 36, 92,133,192, 15,132,148,  1,
/* 0x2400 */   0,  0,131,124, 36, 76,  6,184,  0,  0,  0,  0,139,156, 36,136,
/* 0x2410 */   0,  0,  0,139, 84, 36, 24, 15,159,192,141, 68,  0,  9,137, 68,
/* 0x2420 */  36, 76,139, 68, 36, 92, 43, 68, 36, 72, 15,182, 60, 24,137,248,
/* 0x2430 */ 136,  2, 66,255, 68, 36, 92,137, 84, 36, 24,233,182,250,255,255,
/* 0x2440 */  41,198, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,129,
/* 0x2450 */ 254,255,255,255,  0,102,137, 19,119, 27, 59,108, 36, 56, 15,132,
/* 0x2460 */  50,  1,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,230,  8,
/* 0x2470 */   9, 68, 36, 48, 69,102,139, 83,  2,137,240,193,232, 11, 15,183,
/* 0x2480 */ 202, 15,175,193, 57, 68, 36, 48, 15,131,119,  1,  0,  0,137, 68,
/* 0x2490 */  36, 52,184,  0,  8,  0,  0, 41,200,193,100, 36, 44,  4,193,248,
/* 0x24a0 */   5,139,116, 36, 44,141,  4,  2,199, 68, 36, 32,  8,  0,  0,  0,
/* 0x24b0 */ 102,137, 67,  2,141,156, 30,  4,  1,  0,  0,137, 92, 36, 16,233,
/* 0x24c0 */  67,252,255,255, 59,108, 36, 56, 15,132,200,  0,  0,  0,193,100,
/* 0x24d0 */  36, 48,  8,193,227,  8,102,139,143,152,  1,  0,  0, 15,182, 69,
/* 0x24e0 */   0,137,218,  9, 68, 36, 48,193,234, 11, 15,183,193, 69, 15,175,
/* 0x24f0 */ 208, 57, 84, 36, 48, 15,130,122,254,255,255,137,200, 41,211,102,
/* 0x2500 */ 193,232,  5, 41, 84, 36, 48,102, 41,193,129,251,255,255,255,  0,
/* 0x2510 */ 102,137,143,152,  1,  0,  0,119, 23, 59,108, 36, 56,116,119,193,
/* 0x2520 */ 100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,
/* 0x2530 */ 102,139,151,176,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,
/* 0x2540 */ 175,193, 57, 68, 36, 48, 15,131, 22,  1,  0,  0,137,198,184,  0,
/* 0x2550 */   8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,135,176,  1,
/* 0x2560 */   0,  0,139, 68, 36, 68,139, 84, 36, 72,137, 68, 36, 72,137, 84,
/* 0x2570 */  36, 68,131,124, 36, 76,  6,184,  0,  0,  0,  0,139, 92, 36, 96,
/* 0x2580 */  15,159,192,129,195,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36,
/* 0x2590 */  76,233,  9,251,255,255,131,196,100,184,  1,  0,  0,  0,233,207,
/* 0x25a0 */   1,  0,  0,139,116, 36,  4, 70,137,116, 36, 72, 15,132, 85,249,
/* 0x25b0 */ 255,255,139, 76, 36, 12,139, 68, 36, 92,131,193,  2, 57, 68, 36,
/* 0x25c0 */  72,119,211,137,194,139,132, 36,136,  0,  0,  0, 43, 68, 36, 72,
/* 0x25d0 */   3,148, 36,136,  0,  0,  0,  3, 68, 36, 92, 15,182, 56, 64,137,
/* 0x25e0 */ 251,136, 26, 66,255, 68, 36, 92,255, 68, 36, 24, 73, 15,132,  3,
/* 0x25f0 */ 249,255,255,139,180, 36,140,  0,  0,  0, 57,116, 36, 92,114,219,
/* 0x2600 */ 233,  2,249,255,255, 41,198, 41, 68, 36, 48,137,208,137,116, 36,
/* 0x2610 */  52,102,193,232,  5,199, 68, 36, 32, 16,  0,  0,  0,102, 41,194,
/* 0x2620 */ 199, 68, 36, 36,  8,  0,  0,  0,102,137, 83,  2,129,195,  4,  2,
/* 0x2630 */   0,  0,137, 92, 36, 16,233,212,250,255,255,131,108, 36, 76,  6,
/* 0x2640 */ 233,177,248,255,255,137,222, 41, 68, 36, 48, 41,198,137,208,102,
/* 0x2650 */ 193,232,  5,102, 41,194,102,137,151,224,  1,  0,  0,233, 16,255,
/* 0x2660 */ 255,255, 41,195, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,
/* 0x2670 */ 194,129,251,255,255,255,  0,102,137,151,176,  1,  0,  0, 15,134,
/* 0x2680 */ 165,  0,  0,  0,102,139,151,200,  1,  0,  0,137,216,193,232, 11,
/* 0x2690 */  15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,169,  0,  0,  0,
/* 0x26a0 */ 137,198,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,
/* 0x26b0 */ 137,135,200,  1,  0,  0,139, 68, 36, 64,139, 92, 36, 68,137, 92,
/* 0x26c0 */  36, 64,233,159,254,255,255,141, 80,251,129,124, 36, 52,255,255,
/* 0x26d0 */ 255,  0,119, 29, 59,108, 36, 56, 15,132,184,254,255,255,193,100,
/* 0x26e0 */  36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36,
/* 0x26f0 */  48,209,108, 36, 52,  1,219,139, 68, 36, 52, 57, 68, 36, 48,114,
/* 0x2700 */   7, 41, 68, 36, 48,131,203,  1, 74,117,191,139, 84, 36, 96,193,
/* 0x2710 */ 227,  4,191,  4,  0,  0,  0,137, 92, 36,  4,129,194, 68,  6,  0,
/* 0x2720 */   0,137, 20, 36,233,119,251,255,255, 59,108, 36, 56, 15,132, 99,
/* 0x2730 */ 254,255,255,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9,
/* 0x2740 */  68, 36, 48, 69,233, 59,255,255,255,137,222, 41, 68, 36, 48, 41,
/* 0x2750 */ 198,137,208,102,193,232,  5,139, 76, 36, 64,102, 41,194,139, 68,
/* 0x2760 */  36, 60,102,137,151,200,  1,  0,  0,137, 76, 36, 60,233, 72,255,
/* 0x2770 */ 255,255, 91, 94, 95, 93,  3,115,252,  3,123,248, 49,192,141,140,
/* 0x2780 */  36,  0,255,255,255,137,236, 80, 57,204,117,251,137,236, 49,201,
/* 0x2790 */  90, 93,131,196, 12,195,  0, 46,115,121,109,116, 97, 98,  0, 46,
/* 0x27a0 */ 115,116,114,116, 97, 98,  0, 46,115,104,115,116,114,116, 97, 98,
/* 0x27b0 */   0, 46,114,101,108, 72, 85, 77, 70, 95, 65,  0, 46,114,101,108,
/* 0x27c0 */  72, 85, 77, 70, 95, 76,  0, 46,114,101,108, 85, 77, 70, 95, 65,
/* 0x27d0 */  78, 68, 82, 79, 73, 68,  0, 46,114,101,108, 85, 77, 70, 95, 76,
/* 0x27e0 */  73, 78, 85, 88,  0, 46,114,101,108, 83, 79, 95, 77, 65, 73, 78,
/* 0x27f0 */   0, 46,114,101,108, 83, 79, 95, 72, 69, 65, 68,  0,112,116,114,
/* 0x2800 */  95, 78, 69, 88, 84,  0, 83, 79, 95, 84, 65, 73, 76,  0, 69, 88,
/* 0x2810 */  80, 95, 72, 69, 65, 68,  0, 69, 88, 80, 95, 84, 65, 73, 76,  0,
/* 0x2820 */  46,114,101,108, 78, 82, 86, 50, 69,  0, 46,114,101,108, 78, 82,
/* 0x2830 */  86, 50, 68,  0, 46,114,101,108, 78, 82, 86, 50, 66,  0, 46,114,
/* 0x2840 */ 101,108, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89,  0, 46,114,101,
/* 0x2850 */ 108, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48,  0, 76, 90, 77, 65,
/* 0x2860 */  95, 69, 76, 70, 48, 48,  0, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x2870 */  48,  0, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  0, 76, 90, 77,
/* 0x2880 */  65, 95, 68, 69, 67, 51, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2890 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x28a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x28b0 */  31,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x28c0 */  52,  0,  0,  0,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x28d0 */   1,  0,  0,  0,  0,  0,  0,  0, 27,  0,  0,  0,  9,  0,  0,  0,
/* 0x28e0 */   0,  0,  0,  0,  0,  0,  0,  0, 80, 50,  0,  0,  8,  0,  0,  0,
/* 0x28f0 */  32,  0,  0,  0,  1,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,
/* 0x2900 */  42,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x2910 */  57,  0,  0,  0,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2920 */   1,  0,  0,  0,  0,  0,  0,  0, 38,  0,  0,  0,  9,  0,  0,  0,
/* 0x2930 */   0,  0,  0,  0,  0,  0,  0,  0, 88, 50,  0,  0,  8,  0,  0,  0,
/* 0x2940 */  32,  0,  0,  0,  3,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,
/* 0x2950 */  53,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x2960 */  64,  0,  0,  0,191,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2970 */   4,  0,  0,  0,  0,  0,  0,  0, 49,  0,  0,  0,  9,  0,  0,  0,
/* 0x2980 */   0,  0,  0,  0,  0,  0,  0,  0, 96, 50,  0,  0, 80,  0,  0,  0,
/* 0x2990 */  32,  0,  0,  0,  5,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,
/* 0x29a0 */  69,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x29b0 */   0,  5,  0,  0, 31,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x29c0 */   4,  0,  0,  0,  0,  0,  0,  0, 65,  0,  0,  0,  9,  0,  0,  0,
/* 0x29d0 */   0,  0,  0,  0,  0,  0,  0,  0,176, 50,  0,  0, 16,  0,  0,  0,
/* 0x29e0 */  32,  0,  0,  0,  7,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,
/* 0x29f0 */  83,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a00 */  32,  6,  0,  0,116,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a10 */   4,  0,  0,  0,  0,  0,  0,  0, 79,  0,  0,  0,  9,  0,  0,  0,
/* 0x2a20 */   0,  0,  0,  0,  0,  0,  0,  0,192, 50,  0,  0,176,  0,  0,  0,
/* 0x2a30 */  32,  0,  0,  0,  9,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,
/* 0x2a40 */  95,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a50 */ 148, 11,  0,  0, 86,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a60 */   1,  0,  0,  0,  0,  0,  0,  0, 91,  0,  0,  0,  9,  0,  0,  0,
/* 0x2a70 */   0,  0,  0,  0,  0,  0,  0,  0,112, 51,  0,  0,  8,  0,  0,  0,
/* 0x2a80 */  32,  0,  0,  0, 11,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,
/* 0x2a90 */ 103,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2aa0 */ 234, 11,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ab0 */   1,  0,  0,  0,  0,  0,  0,  0,112,  0,  0,  0,  1,  0,  0,  0,
/* 0x2ac0 */   0,  0,  0,  0,  0,  0,  0,  0,237, 11,  0,  0, 23,  1,  0,  0,
/* 0x2ad0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ae0 */ 120,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2af0 */   4, 13,  0,  0, 11,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b00 */   1,  0,  0,  0,  0,  0,  0,  0,129,  0,  0,  0,  1,  0,  0,  0,
/* 0x2b10 */   0,  0,  0,  0,  0,  0,  0,  0, 16, 14,  0,  0, 16,  0,  0,  0,
/* 0x2b20 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b30 */ 142,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b40 */  32, 14,  0,  0,212,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b50 */   1,  0,  0,  0,  0,  0,  0,  0,138,  0,  0,  0,  9,  0,  0,  0,
/* 0x2b60 */   0,  0,  0,  0,  0,  0,  0,  0,120, 51,  0,  0, 16,  0,  0,  0,
/* 0x2b70 */  32,  0,  0,  0, 17,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,
/* 0x2b80 */ 152,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b90 */ 244, 14,  0,  0,200,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ba0 */   1,  0,  0,  0,  0,  0,  0,  0,148,  0,  0,  0,  9,  0,  0,  0,
/* 0x2bb0 */   0,  0,  0,  0,  0,  0,  0,  0,136, 51,  0,  0, 16,  0,  0,  0,
/* 0x2bc0 */  32,  0,  0,  0, 19,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,
/* 0x2bd0 */ 162,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2be0 */ 188, 15,  0,  0,180,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2bf0 */   1,  0,  0,  0,  0,  0,  0,  0,158,  0,  0,  0,  9,  0,  0,  0,
/* 0x2c00 */   0,  0,  0,  0,  0,  0,  0,  0,152, 51,  0,  0, 16,  0,  0,  0,
/* 0x2c10 */  32,  0,  0,  0, 21,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,
/* 0x2c20 */ 172,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c30 */ 112, 16,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c40 */   1,  0,  0,  0,  0,  0,  0,  0,168,  0,  0,  0,  9,  0,  0,  0,
/* 0x2c50 */   0,  0,  0,  0,  0,  0,  0,  0,168, 51,  0,  0,  8,  0,  0,  0,
/* 0x2c60 */  32,  0,  0,  0, 23,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,
/* 0x2c70 */ 187,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c80 */ 124, 16,  0,  0, 54,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c90 */   1,  0,  0,  0,  0,  0,  0,  0,183,  0,  0,  0,  9,  0,  0,  0,
/* 0x2ca0 */   0,  0,  0,  0,  0,  0,  0,  0,176, 51,  0,  0, 16,  0,  0,  0,
/* 0x2cb0 */  32,  0,  0,  0, 25,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,
/* 0x2cc0 */ 198,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2cd0 */ 178, 16,  0,  0, 72,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ce0 */   1,  0,  0,  0,  0,  0,  0,  0,209,  0,  0,  0,  1,  0,  0,  0,
/* 0x2cf0 */   0,  0,  0,  0,  0,  0,  0,  0,250, 16,  0,  0, 62, 11,  0,  0,
/* 0x2d00 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d10 */ 220,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d20 */  56, 28,  0,  0, 62, 11,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d30 */   1,  0,  0,  0,  0,  0,  0,  0,231,  0,  0,  0,  1,  0,  0,  0,
/* 0x2d40 */   0,  0,  0,  0,  0,  0,  0,  0,118, 39,  0,  0, 32,  0,  0,  0,
/* 0x2d50 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d60 */  17,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d70 */ 150, 39,  0,  0,242,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d80 */   1,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,
/* 0x2d90 */   0,  0,  0,  0,  0,  0,  0,  0,216, 45,  0,  0, 48,  3,  0,  0,
/* 0x2da0 */  33,  0,  0,  0, 20,  0,  0,  0,  4,  0,  0,  0, 16,  0,  0,  0,
/* 0x2db0 */   9,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2dc0 */   8, 49,  0,  0, 72,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2dd0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2de0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2df0 */   0,  0,  0,  0,  3,  0, 15,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e00 */   0,  0,  0,  0,  3,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e10 */   0,  0,  0,  0,  3,  0, 30,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e20 */   0,  0,  0,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e30 */   0,  0,  0,  0,  3,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e40 */   0,  0,  0,  0,  3,  0,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e50 */   0,  0,  0,  0,  3,  0,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e60 */   0,  0,  0,  0,  3,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e70 */   0,  0,  0,  0,  3,  0, 11,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e80 */   0,  0,  0,  0,  3,  0, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e90 */   0,  0,  0,  0,  3,  0, 14,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ea0 */   0,  0,  0,  0,  3,  0, 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2eb0 */   0,  0,  0,  0,  3,  0, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ec0 */   0,  0,  0,  0,  3,  0, 21,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ed0 */   0,  0,  0,  0,  3,  0, 23,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ee0 */   0,  0,  0,  0,  3,  0, 25,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ef0 */   0,  0,  0,  0,  3,  0, 27,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f00 */   0,  0,  0,  0,  3,  0, 28,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f10 */   0,  0,  0,  0,  3,  0, 29,  0,  1,  0,  0,  0, 84,  0,  0,  0,
/* 0x2f20 */   0,  0,  0,  0, 16,  0, 14,  0,  6,  0,  0,  0,103,  0,  0,  0,
/* 0x2f30 */   0,  0,  0,  0, 16,  0, 15,  0, 15,  0,  0,  0, 12,  0,  0,  0,
/* 0x2f40 */   0,  0,  0,  0, 16,  0, 11,  0, 26,  0,  0,  0, 14,  0,  0,  0,
/* 0x2f50 */   0,  0,  0,  0, 16,  0, 11,  0, 40,  0,  0,  0,  0,  1,  0,  0,
/* 0x2f60 */   0,  0,  0,  0, 16,  0, 14,  0, 47,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f70 */   0,  0,  0,  0, 16,  0,  0,  0, 65,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f80 */   0,  0,  0,  0, 16,  0,  0,  0, 81,  0,  0,  0, 16,  0,  0,  0,
/* 0x2f90 */   0,  0,  0,  0, 16,  0, 16,  0, 97,  0,  0,  0,131,  2,  0,  0,
/* 0x2fa0 */ 114,  0,  0,  0, 18,  0,  9,  0,110,  0,  0,  0, 25,  0,  0,  0,
/* 0x2fb0 */   0,  0,  0,  0, 16,  0, 14,  0,117,  0,  0,  0,161,  0,  0,  0,
/* 0x2fc0 */   0,  0,  0,  0, 16,  0, 14,  0,123,  0,  0,  0, 62,  0,  0,  0,
/* 0x2fd0 */   0,  0,  0,  0, 16,  0, 14,  0,131,  0,  0,  0,  0,  0,  0,  0,
/* 0x2fe0 */  53,  2,  0,  0, 18,  0,  5,  0,155,  0,  0,  0, 84,  0,  0,  0,
/* 0x2ff0 */   0,  0,  0,  0, 16,  0, 14,  0,160,  0,  0,  0,151,  0,  0,  0,
/* 0x3000 */   0,  0,  0,  0, 16,  0, 15,  0,174,  0,  0,  0,  0,  0,  0,  0,
/* 0x3010 */  31,  1,  0,  0, 18,  0,  7,  0,196,  0,  0,  0,  0,  0,  0,  0,
/* 0x3020 */   0,  0,  0,  0, 18,  0, 14,  0,200,  0,  0,  0,245,  2,  0,  0,
/* 0x3030 */ 153,  0,  0,  0, 18,  0,  9,  0,213,  0,  0,  0,  5,  1,  0,  0,
/* 0x3040 */   0,  0,  0,  0, 16,  0, 14,  0,219,  0,  0,  0, 98,  2,  0,  0,
/* 0x3050 */  33,  0,  0,  0, 18,  0,  9,  0,230,  0,  0,  0, 27,  0,  0,  0,
/* 0x3060 */   0,  0,  0,  0, 16,  0, 11,  0,245,  0,  0,  0,226,  0,  0,  0,
/* 0x3070 */   0,  0,  0,  0, 16,  0, 14,  0,  2,  1,  0,  0, 16,  0,  0,  0,
/* 0x3080 */   0,  0,  0,  0, 16,  0, 14,  0,  9,  1,  0,  0, 14,  0,  0,  0,
/* 0x3090 */   0,  0,  0,  0, 16,  0, 14,  0, 17,  1,  0,  0,127,  0,  0,  0,
/* 0x30a0 */   0,  0,  0,  0, 16,  0, 14,  0, 26,  1,  0,  0,  4,  1,  0,  0,
/* 0x30b0 */   0,  0,  0,  0, 16,  0, 14,  0, 33,  1,  0,  0,195,  0,  0,  0,
/* 0x30c0 */   0,  0,  0,  0, 16,  0, 14,  0, 40,  1,  0,  0,248,  0,  0,  0,
/* 0x30d0 */   0,  0,  0,  0, 16,  0, 14,  0, 45,  1,  0,  0,233,  0,  0,  0,
/* 0x30e0 */   0,  0,  0,  0, 16,  0, 14,  0, 54,  1,  0,  0,252,  0,  0,  0,
/* 0x30f0 */   0,  0,  0,  0, 16,  0, 14,  0, 60,  1,  0,  0,142,  3,  0,  0,
/* 0x3100 */ 230,  1,  0,  0, 18,  0,  9,  0,  0, 80,109, 97,112,  0,102, 95,
/* 0x3110 */ 101,120,112, 97,110,100,  0,102,111,108,100, 95, 98,101,103,105,
/* 0x3120 */ 110,  0,103,101,116, 95,112, 97,103,101, 95,109, 97,115,107,  0,
/* 0x3130 */ 109,117,110,109, 97,112,  0,108,122,109, 97, 95,115,116, 97, 99,
/* 0x3140 */ 107, 95, 97,100,106,117,115,116,  0,108,122,109, 97, 95,112,114,
/* 0x3150 */ 111,112,101,114,116,105,101,115,  0,117,112,120, 95,109,109, 97,
/* 0x3160 */ 112, 95, 97,110,100, 95,102,100,  0,102,105,110,105, 95, 83, 69,
/* 0x3170 */  76,105,110,117,120,  0,109,101,109, 99,112,121,  0, 80,115,121,
/* 0x3180 */ 110, 99,  0,109,101,109,112, 99,112,121,  0,117,112,120, 95,109,
/* 0x3190 */ 109, 97,112, 95, 97,110,100, 95,102,100, 95, 97,110,100,114,111,
/* 0x31a0 */ 105,100,  0,109,109, 97,112,  0, 95, 95, 99,108,101, 97,114, 95,
/* 0x31b0 */  99, 97, 99,104,101,  0,117,112,120, 95,109,109, 97,112, 95, 97,
/* 0x31c0 */ 110,100, 95,102,100, 95,108,105,110,117,120,  0,101,111,102,  0,
/* 0x31d0 */ 112,114,101,112, 95, 83, 69, 76,105,110,117,120,  0,119,114,105,
/* 0x31e0 */ 116,101,  0, 80, 70, 95,116,111, 95, 80, 82, 79, 84,  0,103,101,
/* 0x31f0 */ 116, 95,117,112,120,102,110, 95,112, 97,116,104,  0,109,101,109,
/* 0x3200 */ 102,100, 95, 99,114,101, 97,116,101,  0,109,101,109,115,101,116,
/* 0x3210 */   0,109,121, 95, 98,107,112,116,  0, 80,112,114,111,116,101, 99,
/* 0x3220 */ 116,  0, 80,119,114,105,116,101,  0, 80,117,110,109, 97,112,  0,
/* 0x3230 */ 101,120,105,116,  0,109,112,114,111,116,101, 99,116,  0, 99,108,
/* 0x3240 */ 111,115,101,  0,117,112,120, 95,115,111, 95,109, 97,105,110,  0,
/* 0x3250 */   1,  0,  0,  0,  2, 32,  0,  0,  1,  0,  0,  0,  2, 35,  0,  0,
/* 0x3260 */ 124,  0,  0,  0,  2, 43,  0,  0,241,  0,  0,  0,  2, 40,  0,  0,
/* 0x3270 */ 111,  1,  0,  0,  2, 23,  0,  0,224,  1,  0,  0,  2, 23,  0,  0,
/* 0x3280 */  18,  2,  0,  0,  2, 33,  0,  0, 73,  2,  0,  0,  2, 42,  0,  0,
/* 0x3290 */ 152,  2,  0,  0,  2, 43,  0,  0, 94,  3,  0,  0,  2, 43,  0,  0,
/* 0x32a0 */ 146,  3,  0,  0,  2, 31,  0,  0,238,  3,  0,  0,  2, 31,  0,  0,
/* 0x32b0 */ 253,  0,  0,  0,  2, 33,  0,  0,  4,  1,  0,  0,  2, 23,  0,  0,
/* 0x32c0 */   8,  0,  0,  0,  2, 43,  0,  0,253,  0,  0,  0,  2, 21,  0,  0,
/* 0x32d0 */ 216,  1,  0,  0,  2, 33,  0,  0, 25,  2,  0,  0,  2, 29,  0,  0,
/* 0x32e0 */  46,  2,  0,  0,  2, 33,  0,  0, 57,  2,  0,  0,  2, 29,  0,  0,
/* 0x32f0 */  83,  2,  0,  0,  2, 33,  0,  0,159,  2,  0,  0,  2, 30,  0,  0,
/* 0x3300 */ 168,  2,  0,  0,  2, 46,  0,  0,179,  2,  0,  0,  2, 39,  0,  0,
/* 0x3310 */ 191,  2,  0,  0,  2, 20,  0,  0,207,  2,  0,  0,  2, 39,  0,  0,
/* 0x3320 */ 225,  2,  0,  0,  2, 44,  0,  0, 35,  3,  0,  0,  2, 29,  0,  0,
/* 0x3330 */  56,  3,  0,  0,  2, 27,  0,  0, 97,  3,  0,  0,  2, 43,  0,  0,
/* 0x3340 */ 158,  3,  0,  0,  2, 23,  0,  0,224,  3,  0,  0,  2, 33,  0,  0,
/* 0x3350 */ 235,  3,  0,  0,  2, 29,  0,  0,214,  4,  0,  0,  2, 37,  0,  0,
/* 0x3360 */  56,  5,  0,  0,  2, 28,  0,  0, 84,  5,  0,  0,  2, 46,  0,  0,
/* 0x3370 */  64,  0,  0,  0,  2, 50,  0,  0,203,  0,  0,  0,  2,  1,  0,  0,
/* 0x3380 */ 104,  0,  0,  0,  2,  2,  0,  0,191,  0,  0,  0,  2,  1,  0,  0,
/* 0x3390 */ 104,  0,  0,  0,  2,  2,  0,  0,171,  0,  0,  0,  2,  1,  0,  0,
/* 0x33a0 */  85,  0,  0,  0,  2,  2,  0,  0,  5,  0,  0,  0,  2,  3,  0,  0,
/* 0x33b0 */  12,  0,  0,  0,  1, 25,  0,  0, 50,  0,  0,  0,  1, 26,  0,  0,
/* 0x33c0 */ 102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,102, 51,
/* 0x33d0 */  50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,116,105,111,110,115,
/* 0x33e0 */  58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32,
/* 0x33f0 */  32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77,
/* 0x3400 */  65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32,
/* 0x3410 */  32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,110,
/* 0x3420 */  32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 72, 85, 77, 70,
/* 0x3430 */  95, 65, 32, 32, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32,
/* 0x3440 */  32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3450 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 72, 85, 77, 70,
/* 0x3460 */  95, 76, 32, 32, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32,
/* 0x3470 */  32, 48, 32, 32, 48, 51, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3480 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 85, 77, 70, 95,
/* 0x3490 */  65, 78, 68, 82, 79, 73, 68, 32, 32, 32, 48, 52, 98,102, 32, 32,
/* 0x34a0 */  48, 32, 32, 48, 32, 32, 48, 52, 48, 32, 32, 50, 42, 42, 50, 32,
/* 0x34b0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 85, 77,
/* 0x34c0 */  70, 95, 76, 73, 78, 85, 88, 32, 32, 32, 32, 32, 48, 49, 49,102,
/* 0x34d0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 53, 48, 48, 32, 32, 50, 42,
/* 0x34e0 */  42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52,
/* 0x34f0 */  32, 83, 79, 95, 77, 65, 73, 78, 32, 32, 32, 32, 32, 32, 32, 48,
/* 0x3500 */  53, 55, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 54, 50, 48, 32,
/* 0x3510 */  32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3520 */  32, 32, 53, 32, 83, 79, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32,
/* 0x3530 */  32, 32, 48, 53, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 98, 57,
/* 0x3540 */  52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3550 */  83, 10, 32, 32, 54, 32,112,116,114, 95, 78, 69, 88, 84, 32, 32,
/* 0x3560 */  32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 98,
/* 0x3570 */ 101, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3580 */  84, 83, 10, 32, 32, 55, 32, 83, 79, 95, 84, 65, 73, 76, 32, 32,
/* 0x3590 */  32, 32, 32, 32, 32, 48, 49, 49, 55, 32, 32, 48, 32, 32, 48, 32,
/* 0x35a0 */  32, 48, 98,101,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x35b0 */  84, 69, 78, 84, 83, 10, 32, 32, 56, 32, 69, 88, 80, 95, 72, 69,
/* 0x35c0 */  65, 68, 32, 32, 32, 32, 32, 32, 48, 49, 48, 98, 32, 32, 48, 32,
/* 0x35d0 */  32, 48, 32, 32, 48,100, 48, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x35e0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 57, 32, 69, 88, 80,
/* 0x35f0 */  95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32, 48, 49, 48, 32, 32,
/* 0x3600 */  48, 32, 32, 48, 32, 32, 48,101, 49, 48, 32, 32, 50, 42, 42, 50,
/* 0x3610 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48, 32, 78,
/* 0x3620 */  82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,100, 52,
/* 0x3630 */  32, 32, 48, 32, 32, 48, 32, 32, 48,101, 50, 48, 32, 32, 50, 42,
/* 0x3640 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 49,
/* 0x3650 */  32, 78, 82, 86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,
/* 0x3660 */  99, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48,101,102, 52, 32, 32,
/* 0x3670 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x3680 */  49, 50, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3690 */  32, 48, 98, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48,102, 98, 99,
/* 0x36a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x36b0 */  10, 32, 49, 51, 32, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89, 32,
/* 0x36c0 */  32, 32, 32, 48, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 48,
/* 0x36d0 */  55, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x36e0 */  84, 83, 10, 32, 49, 52, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48,
/* 0x36f0 */  48, 32, 32, 32, 32, 48, 51, 54, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x3700 */  48, 49, 48, 55, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3710 */  84, 69, 78, 84, 83, 10, 32, 49, 53, 32, 76, 90, 77, 65, 95, 69,
/* 0x3720 */  76, 70, 48, 48, 32, 32, 32, 32, 48, 52, 56, 32, 32, 48, 32, 32,
/* 0x3730 */  48, 32, 32, 48, 49, 48, 98, 50, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3740 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 54, 32, 76, 90, 77,
/* 0x3750 */  65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 98, 51,101, 32,
/* 0x3760 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 48,102, 97, 32, 32, 50, 42,
/* 0x3770 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 55,
/* 0x3780 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48,
/* 0x3790 */  98, 51,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 51, 56,
/* 0x37a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x37b0 */  10, 32, 49, 56, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32,
/* 0x37c0 */  32, 32, 32, 48, 50, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50,
/* 0x37d0 */  55, 55, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x37e0 */  78, 84, 83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69,
/* 0x37f0 */  58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3800 */ 100, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32, 48, 32, 69, 88,
/* 0x3810 */  80, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3820 */ 108, 32, 32, 32, 32,100, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76,
/* 0x3830 */  32, 48, 32, 69, 88, 80, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48,
/* 0x3840 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77,
/* 0x3850 */  65, 95, 68, 69, 67, 51, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68,
/* 0x3860 */  69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3870 */  32, 32, 32,100, 32, 32, 72, 85, 77, 70, 95, 65, 32, 48, 32, 72,
/* 0x3880 */  85, 77, 70, 95, 65, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3890 */  32, 32, 32, 32,100, 32, 32, 72, 85, 77, 70, 95, 76, 32, 48, 32,
/* 0x38a0 */  72, 85, 77, 70, 95, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x38b0 */ 108, 32, 32, 32, 32,100, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x38c0 */  79, 73, 68, 32, 48, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x38d0 */  68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x38e0 */ 100, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 48, 32, 85,
/* 0x38f0 */  77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3900 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 79, 95, 77, 65, 73,
/* 0x3910 */  78, 32, 48, 32, 83, 79, 95, 77, 65, 73, 78, 10, 48, 48, 48, 48,
/* 0x3920 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 79, 95,
/* 0x3930 */  72, 69, 65, 68, 32, 48, 32, 83, 79, 95, 72, 69, 65, 68, 10, 48,
/* 0x3940 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3950 */ 112,116,114, 95, 78, 69, 88, 84, 32, 48, 32,112,116,114, 95, 78,
/* 0x3960 */  69, 88, 84, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3970 */  32, 32,100, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32, 83,
/* 0x3980 */  79, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3990 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69, 32, 48, 32,
/* 0x39a0 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x39b0 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68, 32, 48, 32, 78,
/* 0x39c0 */  82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x39d0 */  32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66, 32, 48, 32, 78, 82,
/* 0x39e0 */  86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x39f0 */  32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89, 32,
/* 0x3a00 */  48, 32, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89, 10, 48, 48, 48,
/* 0x3a10 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x3a20 */  77, 65, 95, 68, 69, 67, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95,
/* 0x3a30 */  68, 69, 67, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3a40 */  32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x3a50 */  48, 32, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48,
/* 0x3a60 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3a70 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90, 77,
/* 0x3a80 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a90 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3aa0 */  67, 50, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x3ab0 */  10, 48, 48, 48, 48, 48, 48, 53, 52, 32,103, 32, 32, 32, 32, 32,
/* 0x3ac0 */  32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32, 80,109, 97,112,
/* 0x3ad0 */  10, 48, 48, 48, 48, 48, 48, 54, 55, 32,103, 32, 32, 32, 32, 32,
/* 0x3ae0 */  32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32, 48, 32,102, 95,101,
/* 0x3af0 */ 120,112, 97,110,100, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32,103,
/* 0x3b00 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 72, 69, 65, 68, 32, 48,
/* 0x3b10 */  32,102,111,108,100, 95, 98,101,103,105,110, 10, 48, 48, 48, 48,
/* 0x3b20 */  48, 48, 48,101, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x3b30 */  72, 69, 65, 68, 32, 48, 32,103,101,116, 95,112, 97,103,101, 95,
/* 0x3b40 */ 109, 97,115,107, 10, 48, 48, 48, 48, 48, 49, 48, 48, 32,103, 32,
/* 0x3b50 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,
/* 0x3b60 */ 109,117,110,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3b70 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,
/* 0x3b80 */ 108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,117,115,
/* 0x3b90 */ 116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x3ba0 */  32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,122,109, 97, 95,
/* 0x3bb0 */ 112,114,111,112,101,114,116,105,101,115, 10, 48, 48, 48, 48, 48,
/* 0x3bc0 */  48, 49, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95,
/* 0x3bd0 */  84, 65, 73, 76, 32, 48, 32,117,112,120, 95,109,109, 97,112, 95,
/* 0x3be0 */  97,110,100, 95,102,100, 10, 48, 48, 48, 48, 48, 50, 56, 51, 32,
/* 0x3bf0 */ 103, 32, 32, 32, 32, 32, 70, 32, 83, 79, 95, 77, 65, 73, 78, 32,
/* 0x3c00 */  48, 55, 50, 32,102,105,110,105, 95, 83, 69, 76,105,110,117,120,
/* 0x3c10 */  10, 48, 48, 48, 48, 48, 48, 49, 57, 32,103, 32, 32, 32, 32, 32,
/* 0x3c20 */  32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,109,101,109, 99,
/* 0x3c30 */ 112,121, 10, 48, 48, 48, 48, 48, 48, 97, 49, 32,103, 32, 32, 32,
/* 0x3c40 */  32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32, 80,115,
/* 0x3c50 */ 121,110, 99, 10, 48, 48, 48, 48, 48, 48, 51,101, 32,103, 32, 32,
/* 0x3c60 */  32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,109,
/* 0x3c70 */ 101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3c80 */ 103, 32, 32, 32, 32, 32, 70, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x3c90 */  79, 73, 68, 32, 48, 50, 51, 53, 32,117,112,120, 95,109,109, 97,
/* 0x3ca0 */ 112, 95, 97,110,100, 95,102,100, 95, 97,110,100,114,111,105,100,
/* 0x3cb0 */  10, 48, 48, 48, 48, 48, 48, 53, 52, 32,103, 32, 32, 32, 32, 32,
/* 0x3cc0 */  32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,109,109, 97,112,
/* 0x3cd0 */  10, 48, 48, 48, 48, 48, 48, 57, 55, 32,103, 32, 32, 32, 32, 32,
/* 0x3ce0 */  32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32, 48, 32, 95, 95, 99,
/* 0x3cf0 */ 108,101, 97,114, 95, 99, 97, 99,104,101, 10, 48, 48, 48, 48, 48,
/* 0x3d00 */  48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 85, 77, 70, 95,
/* 0x3d10 */  76, 73, 78, 85, 88, 32, 48, 49, 49,102, 32,117,112,120, 95,109,
/* 0x3d20 */ 109, 97,112, 95, 97,110,100, 95,102,100, 95,108,105,110,117,120,
/* 0x3d30 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x3d40 */  70, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,101,111,102, 10,
/* 0x3d50 */  48, 48, 48, 48, 48, 50,102, 53, 32,103, 32, 32, 32, 32, 32, 70,
/* 0x3d60 */  32, 83, 79, 95, 77, 65, 73, 78, 32, 48, 57, 57, 32,112,114,101,
/* 0x3d70 */ 112, 95, 83, 69, 76,105,110,117,120, 10, 48, 48, 48, 48, 48, 49,
/* 0x3d80 */  48, 53, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65,
/* 0x3d90 */  73, 76, 32, 48, 32,119,114,105,116,101, 10, 48, 48, 48, 48, 48,
/* 0x3da0 */  50, 54, 50, 32,103, 32, 32, 32, 32, 32, 70, 32, 83, 79, 95, 77,
/* 0x3db0 */  65, 73, 78, 32, 48, 50, 49, 32, 80, 70, 95,116,111, 95, 80, 82,
/* 0x3dc0 */  79, 84, 10, 48, 48, 48, 48, 48, 48, 49, 98, 32,103, 32, 32, 32,
/* 0x3dd0 */  32, 32, 32, 32, 83, 79, 95, 72, 69, 65, 68, 32, 48, 32,103,101,
/* 0x3de0 */ 116, 95,117,112,120,102,110, 95,112, 97,116,104, 10, 48, 48, 48,
/* 0x3df0 */  48, 48, 48,101, 50, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79,
/* 0x3e00 */  95, 84, 65, 73, 76, 32, 48, 32,109,101,109,102,100, 95, 99,114,
/* 0x3e10 */ 101, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32,103, 32,
/* 0x3e20 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,
/* 0x3e30 */ 109,101,109,115,101,116, 10, 48, 48, 48, 48, 48, 48, 48,101, 32,
/* 0x3e40 */ 103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32,
/* 0x3e50 */  48, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x3e60 */  55,102, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65,
/* 0x3e70 */  73, 76, 32, 48, 32, 80,112,114,111,116,101, 99,116, 10, 48, 48,
/* 0x3e80 */  48, 48, 48, 49, 48, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x3e90 */  79, 95, 84, 65, 73, 76, 32, 48, 32, 80,119,114,105,116,101, 10,
/* 0x3ea0 */  48, 48, 48, 48, 48, 48, 99, 51, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x3eb0 */  32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32, 80,117,110,109, 97,
/* 0x3ec0 */ 112, 10, 48, 48, 48, 48, 48, 48,102, 56, 32,103, 32, 32, 32, 32,
/* 0x3ed0 */  32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,101,120,105,
/* 0x3ee0 */ 116, 10, 48, 48, 48, 48, 48, 48,101, 57, 32,103, 32, 32, 32, 32,
/* 0x3ef0 */  32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,109,112,114,
/* 0x3f00 */ 111,116,101, 99,116, 10, 48, 48, 48, 48, 48, 48,102, 99, 32,103,
/* 0x3f10 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48,
/* 0x3f20 */  32, 99,108,111,115,101, 10, 48, 48, 48, 48, 48, 51, 56,101, 32,
/* 0x3f30 */ 103, 32, 32, 32, 32, 32, 70, 32, 83, 79, 95, 77, 65, 73, 78, 32,
/* 0x3f40 */  48, 49,101, 54, 32,117,112,120, 95,115,111, 95,109, 97,105,110,
/* 0x3f50 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x3f60 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 72, 85, 77, 70, 95, 65,
/* 0x3f70 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x3f80 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x3f90 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x3fa0 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,117,
/* 0x3fb0 */ 112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95, 97,
/* 0x3fc0 */ 110,100,114,111,105,100, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x3fd0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x3fe0 */  72, 85, 77, 70, 95, 76, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x3ff0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4000 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4010 */  48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x4020 */  32, 32, 32, 32, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,
/* 0x4030 */ 100, 95,102,100, 95,108,105,110,117,120, 10, 10, 82, 69, 76, 79,
/* 0x4040 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x4050 */  79, 82, 32, 91, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 93,
/* 0x4060 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x4070 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4080 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 55, 99, 32, 82, 95, 51, 56,
/* 0x4090 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,121,
/* 0x40a0 */  95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 48,102, 49, 32, 82,
/* 0x40b0 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x40c0 */  32,103,101,116, 95,117,112,120,102,110, 95,112, 97,116,104, 10,
/* 0x40d0 */  48, 48, 48, 48, 48, 49, 54,102, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x40e0 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,103,101,116, 95,112,
/* 0x40f0 */  97,103,101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 49,101,
/* 0x4100 */  48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x4110 */  32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,
/* 0x4120 */ 107, 10, 48, 48, 48, 48, 48, 50, 49, 50, 32, 82, 95, 51, 56, 54,
/* 0x4130 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,109, 97,
/* 0x4140 */ 112, 10, 48, 48, 48, 48, 48, 50, 52, 57, 32, 82, 95, 51, 56, 54,
/* 0x4150 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,
/* 0x4160 */ 115,101,116, 10, 48, 48, 48, 48, 48, 50, 57, 56, 32, 82, 95, 51,
/* 0x4170 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,
/* 0x4180 */ 121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 51, 53,101, 32,
/* 0x4190 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x41a0 */  32, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 51,
/* 0x41b0 */  57, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x41c0 */  32, 32, 32, 32, 32,109,101,109,112, 99,112,121, 10, 48, 48, 48,
/* 0x41d0 */  48, 48, 51,101,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,
/* 0x41e0 */  32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112, 99,112,121, 10,
/* 0x41f0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x4200 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 85, 77, 70, 95, 76, 73, 78,
/* 0x4210 */  85, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x4220 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4230 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,102,100, 32, 82,
/* 0x4240 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x4250 */  32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 49, 48, 52, 32, 82,
/* 0x4260 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x4270 */  32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10, 10,
/* 0x4280 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4290 */  68, 83, 32, 70, 79, 82, 32, 91, 83, 79, 95, 77, 65, 73, 78, 93,
/* 0x42a0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x42b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x42c0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56,
/* 0x42d0 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,121,
/* 0x42e0 */  95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 48,102,100, 32, 82,
/* 0x42f0 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x4300 */  32,102, 95,101,120,112, 97,110,100, 10, 48, 48, 48, 48, 48, 49,
/* 0x4310 */ 100, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x4320 */  32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 50,
/* 0x4330 */  49, 57, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x4340 */  32, 32, 32, 32, 32,109,101,109, 99,112,121, 10, 48, 48, 48, 48,
/* 0x4350 */  48, 50, 50,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x4360 */  32, 32, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48,
/* 0x4370 */  48, 50, 51, 57, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x4380 */  32, 32, 32, 32, 32, 32, 32,109,101,109, 99,112,121, 10, 48, 48,
/* 0x4390 */  48, 48, 48, 50, 53, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x43a0 */  50, 32, 32, 32, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48,
/* 0x43b0 */  48, 48, 48, 50, 57,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x43c0 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 80,115,121,110, 99, 10, 48,
/* 0x43d0 */  48, 48, 48, 48, 50, 97, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x43e0 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 80,117,110,109, 97,112,
/* 0x43f0 */  10, 48, 48, 48, 48, 48, 50, 98, 51, 32, 82, 95, 51, 56, 54, 95,
/* 0x4400 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 80, 70, 95,116,
/* 0x4410 */ 111, 95, 80, 82, 79, 84, 10, 48, 48, 48, 48, 48, 50, 98,102, 32,
/* 0x4420 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x4430 */  32, 32, 80,109, 97,112, 10, 48, 48, 48, 48, 48, 50, 99,102, 32,
/* 0x4440 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x4450 */  32, 32, 80, 70, 95,116,111, 95, 80, 82, 79, 84, 10, 48, 48, 48,
/* 0x4460 */  48, 48, 50,101, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,
/* 0x4470 */  32, 32, 32, 32, 32, 32, 32, 32, 80,112,114,111,116,101, 99,116,
/* 0x4480 */  10, 48, 48, 48, 48, 48, 51, 50, 51, 32, 82, 95, 51, 56, 54, 95,
/* 0x4490 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109, 99,
/* 0x44a0 */ 112,121, 10, 48, 48, 48, 48, 48, 51, 51, 56, 32, 82, 95, 51, 56,
/* 0x44b0 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,117,112,
/* 0x44c0 */ 120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 10, 48, 48,
/* 0x44d0 */  48, 48, 48, 51, 54, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x44e0 */  50, 32, 32, 32, 32, 32, 32, 32, 32,109,121, 95, 98,107,112,116,
/* 0x44f0 */  10, 48, 48, 48, 48, 48, 51, 57,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x4500 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,103,101,116, 95,
/* 0x4510 */ 112, 97,103,101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 51,
/* 0x4520 */ 101, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x4530 */  32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 51,
/* 0x4540 */ 101, 98, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x4550 */  32, 32, 32, 32, 32,109,101,109, 99,112,121, 10, 48, 48, 48, 48,
/* 0x4560 */  48, 52,100, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x4570 */  32, 32, 32, 32, 32, 32, 32,112,114,101,112, 95, 83, 69, 76,105,
/* 0x4580 */ 110,117,120, 10, 48, 48, 48, 48, 48, 53, 51, 56, 32, 82, 95, 51,
/* 0x4590 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,102,
/* 0x45a0 */ 105,110,105, 95, 83, 69, 76,105,110,117,120, 10, 48, 48, 48, 48,
/* 0x45b0 */  48, 53, 53, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x45c0 */  32, 32, 32, 32, 32, 32, 32, 80,117,110,109, 97,112, 10, 10, 82,
/* 0x45d0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x45e0 */  83, 32, 70, 79, 82, 32, 91, 83, 79, 95, 72, 69, 65, 68, 93, 58,
/* 0x45f0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x4600 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x4610 */  69, 10, 48, 48, 48, 48, 48, 48, 52, 48, 32, 82, 95, 51, 56, 54,
/* 0x4620 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,117,112,120,
/* 0x4630 */  95,115,111, 95,109, 97,105,110, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x4640 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x4650 */  32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x4660 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4670 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x4680 */  48, 99, 98, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32,
/* 0x4690 */  32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 10, 48,
/* 0x46a0 */  48, 48, 48, 48, 48, 54, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x46b0 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 84, 65,
/* 0x46c0 */  73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x46d0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50,
/* 0x46e0 */  68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x46f0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x4700 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 98,102, 32, 82, 95,
/* 0x4710 */  51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4720 */  69, 88, 80, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 54,
/* 0x4730 */  56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x4740 */  32, 32, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 10, 10, 82, 69,
/* 0x4750 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x4760 */  32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58, 10, 79, 70,
/* 0x4770 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x4780 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x4790 */  48, 48, 48, 48, 48, 97, 98, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x47a0 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 72, 69,
/* 0x47b0 */  65, 68, 10, 48, 48, 48, 48, 48, 48, 53, 53, 32, 82, 95, 51, 56,
/* 0x47c0 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 69, 88,
/* 0x47d0 */  80, 95, 84, 65, 73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x47e0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x47f0 */  76, 90, 77, 65, 95, 68, 65, 73, 83, 89, 93, 58, 10, 79, 70, 70,
/* 0x4800 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4810 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4820 */  48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x4830 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x4840 */  67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x4850 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77,
/* 0x4860 */  65, 95, 68, 69, 67, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x4870 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4880 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x4890 */  48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,
/* 0x48a0 */  32, 32, 32, 32, 32, 32,108,122,109, 97, 95,115,116, 97, 99,107,
/* 0x48b0 */  95, 97,100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 51, 50,
/* 0x48c0 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x48d0 */  32, 32, 32,108,122,109, 97, 95,112,114,111,112,101,114,116,105,
/* 0x48e0 */ 101,115, 10
};
