/* i386-linux.elf-fold.h
   created from i386-linux.elf-fold.bin, 18753 (0x4941) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_I386_LINUX_ELF_FOLD_SIZE    18753
#define STUB_I386_LINUX_ELF_FOLD_ADLER32 0xc703dcd3
#define STUB_I386_LINUX_ELF_FOLD_CRC32   0x2a924d9d

unsigned char stub_i386_linux_elf_fold[18753] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 212, 43,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */  32,  0, 29,  0,243, 15, 30,251, 91, 83,235, 37,232,  0,  0,  0,
/* 0x0040 */   0, 88,139,128,231,255,255,255,195,232,  0,  0,  0,  0, 89,139,
/* 0x0050 */ 129,222,255,255,255,133,192,116,  7,141,132,  8,218,255,255,255,
/* 0x0060 */ 195,137,230,246,195,  2,117,  6,129,236,  0, 16,  0,  0,137,231,
/* 0x0070 */ 106,  8, 89,243,165, 85,137,229,173,133,192,171,117,250, 87,246,
/* 0x0080 */ 195,  2,117,  1,171,173,133,192,171,117,250, 87,173,133,192,171,
/* 0x0090 */ 165,117,249,246,195,  2,116, 13, 95, 89,106,255,143, 68, 36, 24,
/* 0x00a0 */ 233,150,  0,  0,  0, 64,131,239,  8,185, 10,  0,  0,  0,243,171,
/* 0x00b0 */  72,171,171, 41,125,248, 87, 86,232, 15,  0,  0,  0, 47,112,114,
/* 0x00c0 */ 111, 99, 47,115,101,108,102, 47,101,120,101,  0, 91, 41,201,106,
/* 0x00d0 */   5, 88,205,128,137, 68, 36, 40,186,215, 15,  0,  0,137,249,106,
/* 0x00e0 */  85, 88,205,128,133,192,121,  7,137,217,184, 14,  0,  0,  0,141,
/* 0x00f0 */ 116,  1,255,145,253, 95, 79,176,  0,170,243,164,184, 32, 32, 32,
/* 0x0100 */  61,131,239,  3,137,  7,139, 69,252,137, 56,131,231,252, 94,137,
/* 0x0110 */ 241, 41,225,137,200, 49,248,131,224,  4, 41,199, 90,  1,250,175,
/* 0x0120 */ 173,193,233,  2, 73,243,165,252,141, 79,  4, 49,192, 41,225,137,
/* 0x0130 */ 231,193,233,  2,243,171,137,252,137,215, 88, 93, 88,131,224,252,
/* 0x0140 */  94, 93,129,236,  0, 10,  0,  0, 84, 87, 85, 86, 80,232,252,255,
/* 0x0150 */ 255,255,137,198,139, 77,104,137,235,102,131,125, 16,  2,117,  7,
/* 0x0160 */ 176, 45,232,113,  0,  0,  0,176, 91,232,113,  0,  0,  0,137,250,
/* 0x0170 */ 137,231,185,133,  2,  0,  0, 49,192,243,171,137,252, 88, 89, 95,
/* 0x0180 */  91, 86, 81, 80, 82, 87, 91,133,255,120, 35, 83, 41,237,106,  2,
/* 0x0190 */  94,106,  1, 90,232,252,255,255,255, 49,201, 41,193, 41,219,176,
/* 0x01a0 */ 192,232,113,  0,  0,  0, 91,176,  6,232,113,  0,  0,  0, 95, 41,
/* 0x01b0 */ 192, 60,175,175,117,252, 91, 89, 80, 80, 80, 80, 80, 80, 80, 80,
/* 0x01c0 */ 176, 91,255, 39, 87, 86, 83,137,195,139,124, 36, 16,139, 11,139,
/* 0x01d0 */  64,  4, 57,249,137,198,115, 10,106,127, 91,106,  1, 88,205,128,
/* 0x01e0 */ 235,254,133,255,116, 15,137,249,138,  6, 70,136,  2, 66,226,248,
/* 0x01f0 */ 139, 67,  4,139, 11,  1,248, 41,249,137, 67,  4,137, 11, 91, 94,
/* 0x0200 */  95,195, 85,137,229, 87, 86,137,214, 83,137,195,131,236, 20,139,
/* 0x0210 */  58,133,255, 15,132,132,  0,  0,  0,141,125,228,235, 58,137, 69,
/* 0x0220 */ 224,141, 69,224, 80,139, 67,  4,255,118,  4,131,232, 12, 80,232,
/* 0x0230 */ 252,255,255,255,131,196, 12,133,192,117,121,139, 85,228, 59, 85,
/* 0x0240 */ 224,117,113,139, 69,232, 41,  3,  1, 67,  4,139,  6,  1, 86,  4,
/* 0x0250 */  41,208,133,192,137,  6,116, 69,106, 12,137,216,137,250,232, 97,
/* 0x0260 */ 255,255,255,139, 69,228, 89,133,192,116, 58,139, 77,232,133,201,
/* 0x0270 */ 116, 66, 57,193,119, 62, 59,  6,119, 58, 57,193,114,160,131,  3,
/* 0x0280 */  12,137,216,139, 86,  4, 81,232, 56,255,255,255,139, 85,228, 88,
/* 0x0290 */ 139,  6,  1, 86,  4, 41,208,133,192,137,  6,117,187,141,101,244,
/* 0x02a0 */  91, 94, 95,201,195,129,125,232, 85, 80, 88, 33,117,  6,139, 19,
/* 0x02b0 */ 133,210,116,233,106,127, 91,106,  1, 88,205,128,235,254, 85,133,
/* 0x02c0 */ 192, 87, 86, 83,139,116, 36, 20,116, 60,168,  1,117, 56,189,  0,
/* 0x02d0 */   0,  0,  0,187,  0,  0,  0,  0,139,  8, 57,209,116, 18,131,249,
/* 0x02e0 */   1,116, 40,133,201,116, 17,131,192,  8,139,  8, 57,209,117,238,
/* 0x02f0 */  67,133,201,137,112,  4,117,239,133,219,117, 10,133,237,116, 18,
/* 0x0300 */ 137, 85,  0,137,117,  4, 91, 94, 95, 93,195,137,197,131,192,  8,
/* 0x0310 */ 235,216,106,127, 91,106,  1, 88,205,128,235,254, 85,137,229, 87,
/* 0x0320 */  86, 83,129,236,  0, 16,  0,  0,141,189,244,239,255,255,139,117,
/* 0x0330 */  16,139, 93, 12, 86, 83, 87,232,252,255,255,255,106,  0,106,255,
/* 0x0340 */ 106, 50,106,  3,255,117,  8, 83,232,252,255,255,255,131,196, 36,
/* 0x0350 */  86, 87, 83,232,252,255,255,255,131,196, 12,141,101,244, 91, 94,
/* 0x0360 */  95,201,195, 85,137,229, 87, 86, 83,131,236,120,137, 69,220,137,
/* 0x0370 */  85,216,139,125,220,139, 93,216,199, 69,200,  0,  0,  0,  0,139,
/* 0x0380 */  69,  8,139, 85, 12,139, 77, 16,137, 69,212,  3,127, 28,133,219,
/* 0x0390 */ 137, 85,208,137, 77,204,199, 69,240,  0,  0,  0,  0, 15,132, 16,
/* 0x03a0 */   3,  0,  0,139,  1,141, 80, 52,137,195,139, 69,220, 43, 90, 40,
/* 0x03b0 */ 102,131,120, 16,  2, 15,132,240,  2,  0,  0,137, 93,200,139, 74,
/* 0x03c0 */  20,141,  4, 25,137, 69,240,106, 91, 88,205,128,232,252,255,255,
/* 0x03d0 */ 255,139, 77,220,199, 69,176,  0,  0,  0,  0,102,139, 81, 44,102,
/* 0x03e0 */ 133,210, 15,132,127,  1,  0,  0,247,208,137, 69,148,235, 18,255,
/* 0x03f0 */  69,176, 15,183,194,131,199, 32, 59, 69,176, 15,142,102,  1,  0,
/* 0x0400 */   0,139, 77,216,133,201, 15,132,126,  1,  0,  0,139,  7,131,248,
/* 0x0410 */   6, 15,132,122,  1,  0,  0, 72,117,213,139, 95, 20,133,219,116,
/* 0x0420 */ 206,139, 79, 24,199, 69,172, 64, 98, 81,115,139, 69,216,131,225,
/* 0x0430 */   7,193,225,  2,211,109,172,131,101,172,  7,133,192,116, 11,139,
/* 0x0440 */  71,  4,133,192, 15,132,  0,  2,  0,  0,139, 69,200,199, 69,136,
/* 0x0450 */   0,  0,  0,  0,  3, 71,  8,139, 87, 16,141, 12, 16,  1,195,137,
/* 0x0460 */ 198,137, 69,236,137, 77,160,139, 77,148,137, 85,232, 33,193,139,
/* 0x0470 */  69,216,  1,202, 41,206,133,192,137, 93,164,137, 85,168, 15,132,
/* 0x0480 */  66,  3,  0,  0,246, 71, 24,  1, 15,133,153,  1,  0,  0,139, 69,
/* 0x0490 */ 216,133,192, 15,132, 45,  3,  0,  0,139, 69,172,106,  0,106,255,
/* 0x04a0 */ 131,200,  2,106, 50,131,224,251, 80,255,117,168, 86,232,252,255,
/* 0x04b0 */ 255,255,131,196, 24, 57,240, 15,133, 96,  1,  0,  0,139, 93,216,
/* 0x04c0 */ 133,219,116, 11,141, 85,232,139, 69,216,232, 51,253,255,255,246,
/* 0x04d0 */  69,172,  2, 15,133,255,  0,  0,  0,139, 77,216,133,201, 15,132,
/* 0x04e0 */  24,  1,  0,  0,246, 71, 24,  1, 15,132, 14,  1,  0,  0,199, 69,
/* 0x04f0 */ 224,205,128, 97, 88,139, 85,236,199, 69,228, 62,255,224,144,131,
/* 0x0500 */  63,  1, 15,132,229,  2,  0,  0,106,  4,137,243,255,117,168, 86,
/* 0x0510 */ 232,252,255,255,255,131,196, 12,139, 77,168,106, 91, 88,205,128,
/* 0x0520 */ 106,  0,255,117,136,106, 17,255,117,172,255,117,168, 86,232,252,
/* 0x0530 */ 255,255,255,131,196, 24, 57,240, 15,133,223,  0,  0,  0,139, 93,
/* 0x0540 */ 136,106,  6, 88,205,128,139, 69,164, 57, 69,160,114, 97,139, 93,
/* 0x0550 */ 220,131,199, 32,255, 69,176,102,139, 83, 44, 15,183,194, 59, 69,
/* 0x0560 */ 176, 15,143,154,254,255,255,139, 69,204,133,192,116,  8,139, 85,
/* 0x0570 */ 200,139, 69,204,137, 16,139, 77,220,139, 73, 24,  1, 77,200,139,
/* 0x0580 */  69,200,141,101,244, 91, 94, 95,201,195,139,  7,233,134,254,255,
/* 0x0590 */ 255,139, 69,200,186,  0,  0,  0,  0,  3, 71,  8, 82,186,  3,  0,
/* 0x05a0 */   0,  0, 80,139, 69,208,232, 19,253,255,255, 88, 90,235,159,106,
/* 0x05b0 */   0,139, 85,160,106,255,106, 50, 41,208,255,117,172, 80, 82,232,
/* 0x05c0 */ 252,255,255,255,131,196, 24, 59, 69,160,117, 81,139, 77,220,102,
/* 0x05d0 */ 139, 81, 44,233, 23,254,255,255,139, 93,160,247,219, 35, 93,148,
/* 0x05e0 */  83,106,  0,255,117,160,232,252,255,255,255,139, 77,216,  1, 93,
/* 0x05f0 */ 160,131,196, 12,133,201, 15,133,232,254,255,255,131,125,172,  3,
/* 0x0600 */  15,132, 64,255,255,255,255,117,172,255,117,168, 86,232,252,255,
/* 0x0610 */ 255,255,131,196, 12,133,192, 15,132, 41,255,255,255,106,127, 91,
/* 0x0620 */ 106,  1, 88,205,128,235,254,106,  0, 82, 86,232,252,255,255,255,
/* 0x0630 */ 131,196, 12,137,194,129,226,255, 15,  0,  0, 41,208, 57,240,117,
/* 0x0640 */ 220, 74,137, 85,136,233,115,254,255,255,139, 85,220,139, 69,200,
/* 0x0650 */   3, 71,  8,  3, 66, 28,186,  0,  0,  0,  0, 82,186,  3,  0,  0,
/* 0x0660 */   0, 80,139, 69,208,232, 84,252,255,255,139, 77,220,186,  0,  0,
/* 0x0670 */   0,  0, 15,183, 65, 44, 82,186,  5,  0,  0,  0, 80,139, 69,208,
/* 0x0680 */ 232, 57,252,255,255,139, 93,220,186,  0,  0,  0,  0, 15,183, 67,
/* 0x0690 */  42, 82,186,  4,  0,  0,  0, 80,139, 69,208,232, 30,252,255,255,
/* 0x06a0 */ 139, 95, 20,131,196, 24,233,159,253,255,255,139, 90,  8,233, 11,
/* 0x06b0 */ 253,255,255,139, 85,220,184,  0,  0,  0,  0,137,251,102,131,122,
/* 0x06c0 */  16,  3, 15,183,114, 44, 15,149,192,193,224,  4,137, 69,140,232,
/* 0x06d0 */ 252,255,255,255,137,241,199, 69,196,255,255,255,255, 73,199, 69,
/* 0x06e0 */ 192,  0,  0,  0,  0,199, 69,188,  0, 16,  0,  0,120, 16,137,241,
/* 0x06f0 */ 131, 59,  1, 15,132,163,  0,  0,  0,131,195, 32,226,242,139, 93,
/* 0x0700 */ 196,137,193,247,217, 33,195, 41, 93,192,139, 85,192,137, 93,144,
/* 0x0710 */ 141, 84, 10,255, 33,194, 59, 77,188,137, 85,184,186,  1,  0,  0,
/* 0x0720 */   0,235, 10,  1,210,137,208, 15,175,193, 59, 69,188,114,244,141,
/* 0x0730 */  90,255,106,  0,137,216,106,255, 15,175,193,131, 77,140, 34,  3,
/* 0x0740 */  69,184,255,117,140,106,  0, 80,255,117,144,137, 69,180,232,252,
/* 0x0750 */ 255,255,255,139, 77,184,131,196, 24,133,219,137,198,141, 20,  8,
/* 0x0760 */ 116, 44,139, 85,188,247,216, 74, 33,194,116, 14,137,243,137,209,
/* 0x0770 */ 106, 91, 88,205,128,  1,214, 41, 85,180,139, 69,184,139, 77,180,
/* 0x0780 */ 141, 20,  6, 41,193,116,  7,137,211,106, 91, 88,205,128, 43,117,
/* 0x0790 */ 144,137, 85,240,137,117,200,233, 48,252,255,255,139, 83,  8, 59,
/* 0x07a0 */  85,196,115,  3,137, 85,196,  3, 83, 20, 59, 85,192,118,  3,137,
/* 0x07b0 */  85,192,139, 83, 28, 59, 85,188, 15,134, 59,255,255,255,137, 85,
/* 0x07c0 */ 188,233, 51,255,255,255,139, 71,  4, 41,200, 80,255,117,212,106,
/* 0x07d0 */  18,255,117,172,255,117,168, 86,232,252,255,255,255,131,196, 24,
/* 0x07e0 */  57,240, 15,132,231,252,255,255,233, 48,254,255,255,139, 71, 20,
/* 0x07f0 */  43, 71, 16,  1,194,137,208,247,216, 35, 69,148,131,248,  7,118,
/* 0x0800 */  50,199,  2,205,128, 97, 88,139, 69,228,137, 66,  4,133,210, 15,
/* 0x0810 */ 132,243,252,255,255,139, 69,208,185,  0,  0,  0,  0, 81, 82,131,
/* 0x0820 */ 224,254,186,  0,  0,  0,  0,232,146,250,255,255, 88, 90,233,213,
/* 0x0830 */ 252,255,255,106,  0,106,  8,106,  0,232,252,255,255,255,131,196,
/* 0x0840 */  12,137,195,137,133,124,255,255,255,129,227,255, 15,  0,  0,186,
/* 0x0850 */   8,  0,  0,  0, 75,141, 77,224,137, 93,132,106,  4, 88,205,128,
/* 0x0860 */ 106,  0,255,117,132,106,  2,106,  5,106,  8,129,165,124,255,255,
/* 0x0870 */ 255,  0,240,255,255,255,181,124,255,255,255,232,252,255,255,255,
/* 0x0880 */ 131,196, 24,137,194,139, 93,132,106,  6, 88,205,128,233,123,255,
/* 0x0890 */ 255,255, 85,137,229, 87, 86, 83,131,236, 56,139, 85,  8,139, 69,
/* 0x08a0 */  20,139, 77, 24,137, 85,232,137, 69,216,139,  2,137, 85,224,137,
/* 0x08b0 */  69,236,139, 66,  4,141, 85,236,131,192, 12,137, 77,212,137, 69,
/* 0x08c0 */ 228,139, 69, 12,137, 77,240,137, 69,220,141, 69,228,232, 48,249,
/* 0x08d0 */ 255,255,232,252,255,255,255,141, 69, 16,139, 93,212,141, 85,220,
/* 0x08e0 */  80,139, 69,212,255,117,216,131,195, 52,106,  0,137, 93,208,232,
/* 0x08f0 */ 111,250,255,255,186,  0,  0,  0,  0,137, 69,204,139, 69,204, 82,
/* 0x0900 */ 186,  9,  0,  0,  0, 80,139, 69,216,232,176,249,255,255,139, 77,
/* 0x0910 */ 212,131,196, 20,199, 69,200,  0,  0,  0,  0,102,139, 81, 44,102,
/* 0x0920 */ 133,210, 15,132,169,  0,  0,  0,191,  0,  0,  0,  0,235, 19,255,
/* 0x0930 */  69,200, 15,183,194,131, 69,208, 32, 59, 69,200, 15,134,143,  0,
/* 0x0940 */   0,  0,139, 93,208,131, 59,  3,117,229,139, 69,208,137,249,139,
/* 0x0950 */  93, 16,137,250,  3, 88,  8,106,  5, 88,205,128,133,192,137,198,
/* 0x0960 */ 120,122,186,  0,  2,  0,  0,137,195,139, 77,212,106,  3, 88,205,
/* 0x0970 */ 128, 61,  0,  2,  0,  0,117,100,141, 69, 16,186,  0,  0,  0,  0,
/* 0x0980 */ 199, 69, 16,  0,  0,  0,  0,137,243, 80,139, 69,212,106,  0, 86,
/* 0x0990 */ 232,206,249,255,255,186,  0,  0,  0,  0,137, 69,204,139, 69, 16,
/* 0x09a0 */  82,186,  7,  0,  0,  0, 80,139, 69,216,232, 15,249,255,255,131,
/* 0x09b0 */ 196, 20,106,  6, 88,205,128,139, 69,212,255, 69,200,102,139, 80,
/* 0x09c0 */  44,131, 69,208, 32, 15,183,194, 59, 69,200, 15,135,113,255,255,
/* 0x09d0 */ 255,139, 69,204,141,101,244, 91, 94, 95,201,195,106,127, 91,106,
/* 0x09e0 */   1, 88,205,128,235,254,233,252,255,255,255,233,252,255,255,255,
/* 0x09f0 */  85,137,229, 87, 86, 83,129,236, 68, 16,  0,  0,186,  0,  0,  0,
/* 0x0a00 */   0,232,  4,  0,  0,  0,117,112,120,  0, 95,185, 16,  0,  0,  0,
/* 0x0a10 */ 184,100,  1,  0,  0,137,251,205,128,137,198,131,248,234,117, 13,
/* 0x0a20 */ 184,100,  1,  0,  0,137,251,137,209,205,128,137,198,133,246,121,
/* 0x0a30 */  66,232,  9,  0,  0,  0, 47,100,101,118, 47,115,104,109,  0, 94,
/* 0x0a40 */ 185,  2,  0, 65,  0,186,192,  1,  0,  0,137,243,106,  5, 88,205,
/* 0x0a50 */ 128,137,198,133,192,121, 28,232, 13,  0,  0,  0,109,101,109,102,
/* 0x0a60 */ 100, 95, 99,114,101, 97,116,101,  0, 88, 80,232,252,255,255,255,
/* 0x0a70 */ 131,196,  4,141,189,244,239,255,255,137,251,106,122, 88,205,128,
/* 0x0a80 */ 199,133,220,239,255,255,  0,  0,  0,  0,232,  4,  0,  0,  0, 97,
/* 0x0a90 */ 110,100,  0, 88,106,  3, 87, 80,232,216,  3,  0,  0,131,196, 12,
/* 0x0aa0 */ 133,192,116, 45,232,  4,  0,  0,  0, 76,105,110,  0, 88,106,  3,
/* 0x0ab0 */  87, 80,232,190,  3,  0,  0,131,196, 12,133,192,117, 19,128,189,
/* 0x0ac0 */ 118,240,255,255, 52,126, 10,199,133,220,239,255,255,  1,  0,  0,
/* 0x0ad0 */   0,131,189,220,239,255,255,  0,117,126,131,125, 16,  0,117, 28,
/* 0x0ae0 */ 232,252,255,255,255,137, 69, 16,133,192,117, 16,141,133,244,239,
/* 0x0af0 */ 255,255,137, 69, 16,198,133,244,239,255,255,  0,131,189,220,239,
/* 0x0b00 */ 255,255,  0,117, 83,131,254,218,117, 78,131,125, 16,  0,116, 72,
/* 0x0b10 */ 139, 85, 16,128, 58,  0,117, 26,141,133,244,247,255,255, 80, 82,
/* 0x0b20 */ 232,150,  1,  0,  0,131,196,  8,137,193,133,192, 15,136,233,  0,
/* 0x0b30 */   0,  0,185,194,  0,  0,  0,186,192,  1,  0,  0,139, 93, 16,106,
/* 0x0b40 */   5, 88,205,128,137,198,137,193,133,192, 15,136,203,  0,  0,  0,
/* 0x0b50 */ 139, 93, 16,106, 10, 88,205,128,131,125,  8,  0,116, 16,232,252,
/* 0x0b60 */ 255,255,255,247,208, 35, 69,  8, 41, 69,  8,  1, 69, 12,131,125,
/* 0x0b70 */  12,  0,116, 85,131,189,220,239,255,255,  0,116, 22,137,243,139,
/* 0x0b80 */  77, 12,106, 93, 88,205,128,137,193,133,192, 15,136,138,  0,  0,
/* 0x0b90 */   0,235, 54,139, 77, 12, 73,191,  0,  0,  0,  0,137,243,137,250,
/* 0x0ba0 */ 106, 19, 88,205,128,198,133,243,239,255,255,  0,141,141,243,239,
/* 0x0bb0 */ 255,255,186,  1,  0,  0,  0,137,243,106,  4, 88,205,128,137,243,
/* 0x0bc0 */ 137,249,137,250,106, 19, 88,205,128,131,125,  8,  0,116, 26,232,
/* 0x0bd0 */ 252,255,255,255,137,194,247,208,133, 69,  8,116, 12,247,218,137,
/* 0x0be0 */ 243,139, 77,  8,106,  4, 88,205,128,106,  0, 86,131,125,  8,  1,
/* 0x0bf0 */  25,192,131,224,240,131,192, 17, 80,106,  3,255,117, 12,255,117,
/* 0x0c00 */   8,232,252,255,255,255,137,194,131,196, 24,137,193, 61,  0,240,
/* 0x0c10 */ 255,255,119,  7,141, 70,  1,137,193,  9,209,137,200,141,101,244,
/* 0x0c20 */  91, 94, 95,201,195, 85,137,229, 86, 83,131,236, 72,106, 64,104,
/* 0x0c30 */ 255,  0,  0,  0,141,117,184, 86,232,252,255,255,255,131,196, 12,
/* 0x0c40 */ 139, 93,  8,137,241,106,106, 88,205,128,137,198,133,192,120, 21,
/* 0x0c50 */  15,183, 69,192, 37,  0,240,  0,  0,186,  0,  0,  0,  0, 61,  0,
/* 0x0c60 */  64,  0,  0,116, 44,131,254,254,117, 15,185,192,  1,  0,  0,139,
/* 0x0c70 */  93,  8,106, 39, 88,205,128,137,198,133,246,121, 18,131,125, 12,
/* 0x0c80 */   0,116, 12, 86,255,117,  8,232,252,255,255,255,131,196,  8,137,
/* 0x0c90 */ 242,137,208,141,101,248, 91, 94,201,195,139, 68, 36,  4,137,194,
/* 0x0ca0 */ 131,226, 31,131,224, 63,131,250, 26,118, 12,168, 32,116,  5,131,
/* 0x0cb0 */ 232, 70,235,  3,131,232, 43,131,192, 64,195, 85,137,229, 87, 86,
/* 0x0cc0 */  83,131,236, 32,232, 12,  0,  0,  0, 47,100, 97,116, 97, 47,100,
/* 0x0cd0 */  97,116, 97, 47,  0, 90,139,  2,139, 77,  8,137,  1,139, 66,  4,
/* 0x0ce0 */ 137, 65,  4,102,139, 66,  8,102,137, 65,  8,138, 66, 10,136, 65,
/* 0x0cf0 */  10,198, 65, 11,  0,106,  1, 81,232, 40,255,255,255,131,196,  8,
/* 0x0d00 */ 232, 19,  0,  0,  0, 47,112,114,111, 99, 47,115,101,108,102, 47,
/* 0x0d10 */  99,109,100,108,105,110,101,  0, 91,137, 93,220,185,  0,  0,  0,
/* 0x0d20 */   0,137,202,106,  5, 88,205,128,137, 69,240,139,117, 12,186,255,
/* 0x0d30 */  15,  0,  0,137,195,137,241,106,  3, 88,205,128,137,199,139, 93,
/* 0x0d40 */ 240,106,  6, 88,205,128,133,255,121, 11,255,117,220,232,252,255,
/* 0x0d50 */ 255,255,131,196,  4,198,  4, 62,  0,128, 62,  0,116,  6, 70,128,
/* 0x0d60 */  62,  0,117,250,137,247,128, 62, 47,116,  6, 78,128, 62, 47,117,
/* 0x0d70 */ 250,137,117,224,137,248, 41,240, 80, 86,139, 69,  8,131,192, 10,
/* 0x0d80 */  80,232,252,255,255,255,137,195,198,  0,  0,106,  0,255,117,  8,
/* 0x0d90 */ 232,144,254,255,255,131,196, 20,131,248,243,117, 87,232, 17,  0,
/* 0x0da0 */   0,  0, 99,111,109, 46,116,101,114,109,117,120, 47,102,105,108,
/* 0x0db0 */ 101,115,  0, 90,139,  2,139, 77,  8,137, 65, 11,139, 66,  4,137,
/* 0x0dc0 */  65, 15,139, 66,  8,137, 65, 19,139, 66, 12,137, 65, 23,137,202,
/* 0x0dd0 */ 131,194, 27,137,248, 43, 69,224, 80,255,117,224, 82,232,252,255,
/* 0x0de0 */ 255,255,137,195,198,  0,  0,106,  1,255,117,  8,232, 52,254,255,
/* 0x0df0 */ 255,131,196, 20,232,  7,  0,  0,  0, 47, 99, 97, 99,104,101,  0,
/* 0x0e00 */  90,139,  2,137,  3,102,139, 66,  4,102,137, 67,  4,141,115,  6,
/* 0x0e10 */ 198,  6,  0,106,  1,255,117,  8,232,  8,254,255,255,131,196,  8,
/* 0x0e20 */ 232,  5,  0,  0,  0, 47,117,112,120,  0, 88,139,  0,137,  6,141,
/* 0x0e30 */ 126,  4,106, 20, 88,205,128,137,198, 80,232, 91,254,255,255,136,
/* 0x0e40 */   7,137,240,193,232,  6,137,  4, 36,232, 76,254,255,255,136, 71,
/* 0x0e50 */   1,137,240,193,232, 12,137,  4, 36,232, 60,254,255,255,131,196,
/* 0x0e60 */   4,136, 71,  2,198, 71,  3,  0,184,  0,  0,  0,  0,141,101,244,
/* 0x0e70 */  91, 94, 95,201,195, 86, 83,139,116, 36, 12,139, 92, 36, 16,139,
/* 0x0e80 */  76, 36, 20, 73,131,249,255,116, 30,138, 22,131,202, 32, 15,190,
/* 0x0e90 */ 210,138,  3,131,200, 32, 15,190,192, 67, 70, 41,194,137,208,117,
/* 0x0ea0 */  11, 73,131,249,255,117,226,184,  0,  0,  0,  0, 91, 94,195,  0,
/* 0x0eb0 */  85,137,229, 87, 86, 83,131,236, 20,139,125, 12,232,  4,  0,  0,
/* 0x0ec0 */   0,117,112,120,  0, 90,185, 16,  0,  0,  0,184,100,  1,  0,  0,
/* 0x0ed0 */ 137,211,205,128,137,198,131,248,234,117, 16,185,  0,  0,  0,  0,
/* 0x0ee0 */ 184,100,  1,  0,  0,137,211,205,128,137,198,133,246,121, 40,232,
/* 0x0ef0 */   9,  0,  0,  0, 47,100,101,118, 47,115,104,109,  0, 94,185,  2,
/* 0x0f00 */   0, 65,  0,186,192,  1,  0,  0,137,243,106,  5, 88,205,128,137,
/* 0x0f10 */ 198,137,194,133,192,120, 62,137,243,137,249,106, 93, 88,205,128,
/* 0x0f20 */ 137,194,133,192,120, 47,106,  0, 86,131,125,  8,  1, 25,192,131,
/* 0x0f30 */ 224,240,131,192, 17, 80,106,  3, 87,255,117,  8,232,252,255,255,
/* 0x0f40 */ 255,137,195,232,252,255,255,255,131,196, 24,137,218, 57,195,115,
/* 0x0f50 */   4,141, 84, 30,  1,137,208,141,101,244, 91, 94, 95,201,195,  0,
/* 0x0f60 */ 135, 92, 36,  4,137,217,232,252,255,255,255, 33,195, 41,217,  3,
/* 0x0f70 */  76, 36,  8,139, 84, 36, 12,176,125,232, 87,  0,  0,  0, 61,  0,
/* 0x0f80 */ 240,255,255,118,  1,244,139, 92, 36,  4,195,135, 92, 36,  4,137,
/* 0x0f90 */ 217,232,252,255,255,255, 33,195, 41,217,  3, 76, 36,  8,139, 84,
/* 0x0fa0 */  36, 12,176,144,232, 44,  0,  0,  0, 61,  0,240,255,255,118,  1,
/* 0x0fb0 */ 244,139, 92, 36,  4,195, 83,141, 92, 36,  8,176, 90,232, 19,  0,
/* 0x0fc0 */   0,  0,139, 11,133,201,116, 11,246, 67, 12, 16,116,  5, 57,193,
/* 0x0fd0 */ 116,  1,244, 91,195, 15,182,192, 80,205,128, 90, 61,  0,240,255,
/* 0x0fe0 */ 255,115,  1,195,244, 85,137,229, 83,139, 93,  8,139, 77, 12,176,
/* 0x0ff0 */ 106,232,223,255,255,255, 91, 93,195, 85,137,229, 83,139, 93,  8,
/* 0x1000 */ 176,122,232,206,255,255,255, 91, 93,195, 85,137,229, 83,139, 93,
/* 0x1010 */   8,139, 77, 12,176, 39,232,186,255,255,255, 91, 93,195, 85,137,
/* 0x1020 */ 229, 87,139, 77, 16,139, 69, 12,139,125,  8, 82,243,170, 88, 95,
/* 0x1030 */  93,195, 85,137,229, 87, 86,139, 77, 16,139, 69, 12,139,125,  8,
/* 0x1040 */  87,243,164, 88, 94, 95, 93,195, 85,137,229, 87, 86,139, 77, 16,
/* 0x1050 */ 139, 69, 12,139,125,  8,243,164,137,248, 94, 95, 93,195,204,195,
/* 0x1060 */ 139, 68, 36, 16,131,248, 73,116,  7,131,248, 70,116,  2,235, 86,
/* 0x1070 */  85,137,229, 83, 86, 87,139,117,  8,139, 77, 12,139, 85, 16,136,
/* 0x1080 */ 198,141, 76, 14,253,137,243,235, 50, 57,206,115, 53, 86, 94,172,
/* 0x1090 */ 128,254, 73,117, 14, 60,128,114, 10, 60,143,119,  6,128,126,254,
/* 0x10a0 */  15,116,  6, 44,232, 60,  1,119,224, 57,206,115, 21, 86,173, 40,
/* 0x10b0 */ 208,117,219, 95, 15,200, 41,248,  1,216,171, 57,206,115,  3,172,
/* 0x10c0 */ 235,225, 95, 94, 91, 93,195, 85,137,229, 87, 86, 83,232,117,  0,
/* 0x10d0 */   0,  0, 80,139,117,  8, 15,182, 70,  9,133,192,116, 19, 80, 15,
/* 0x10e0 */ 182, 70, 10, 80,255, 54,255,117, 12,232,114,255,255,255,131,196,
/* 0x10f0 */  16, 88, 91, 94, 95, 93,195,204,195,139, 30,131,238,252, 17,219,
/* 0x1100 */  15,182, 22,243,195,243, 15, 30,251,  1,219,116,236,243,195,141,
/* 0x1110 */   4, 47,131,249,  5, 15,182, 16,118, 31,131,253,252,119, 26,131,
/* 0x1120 */ 233,  4,139, 16,131,192,  4,131,233,  4,137, 23,141,127,  4,115,
/* 0x1130 */ 241,131,193,  4, 15,182, 16,116, 12, 64,136, 23, 73, 15,182, 16,
/* 0x1140 */ 141,127,  1,117,244,243,195,139,117,  8,139,125, 12,173,139, 85,
/* 0x1150 */  16,137,  2, 82,173,145,173, 15,182,208,  1,241, 81, 87, 85, 49,
/* 0x1160 */ 219, 49,201,131,205,255,252, 15,182, 86,252,  0,204,244, 93, 88,
/* 0x1170 */  41,199, 88, 89,137, 57, 41,240,195,  0,  0,  0,128,250,  8, 15,
/* 0x1180 */ 133,203,  0,  0,  0,235,  4, 70,136, 23, 71, 15,182, 22,  1,219,
/* 0x1190 */ 117, 10,139, 30,131,238,252, 17,219, 15,182, 22,114,233,106,  1,
/* 0x11a0 */  88,235, 17, 72,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,
/* 0x11b0 */ 182, 22, 17,192,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,
/* 0x11c0 */ 182, 22, 17,192,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,
/* 0x11d0 */ 182, 22,115,207,131,232,  3,114, 23,193,224,  8, 70,  9,208,131,
/* 0x11e0 */ 240,255, 15,132,254,255,255,255,209,248,137,197,114, 63,235, 13,
/* 0x11f0 */   1,219,117,  7,139, 30,131,238,252, 17,219,114, 48, 65,  1,219,
/* 0x1200 */ 117,  7,139, 30,131,238,252, 17,219,114, 34,  1,219,117, 10,139,
/* 0x1210 */  30,131,238,252, 17,219, 15,182, 22, 17,201,  1,219,117,  7,139,
/* 0x1220 */  30,131,238,252, 17,219,115,227,131,193,  2,235, 16,  1,219,117,
/* 0x1230 */  10,139, 30,131,238,252, 17,219, 15,182, 22, 17,201,129,253,  0,
/* 0x1240 */ 251,255,255,131,209,  2,232,171,  0,  0,  0,233, 59,255,255,255,
/* 0x1250 */ 128,250,  5, 15,133,191,  0,  0,  0,235,  4, 70,136, 23, 71, 15,
/* 0x1260 */ 182, 22,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,182, 22,
/* 0x1270 */ 114,233,106,  1, 88,235, 17, 72,  1,219,117, 10,139, 30,131,238,
/* 0x1280 */ 252, 17,219, 15,182, 22, 17,192,  1,219,117, 10,139, 30,131,238,
/* 0x1290 */ 252, 17,219, 15,182, 22, 17,192,  1,219,117, 10,139, 30,131,238,
/* 0x12a0 */ 252, 17,219, 15,182, 22,115,207,131,232,  3,114, 21,193,224,  8,
/* 0x12b0 */  70,  9,208,131,240,255, 15,132,254,255,255,255,209,248,137,197,
/* 0x12c0 */ 235, 14,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,182, 22,
/* 0x12d0 */  17,201,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,182, 22,
/* 0x12e0 */  17,201,117, 33, 65,  1,219,117, 10,139, 30,131,238,252, 17,219,
/* 0x12f0 */  15,182, 22, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x1300 */ 115,227,131,193,  2,129,253,  0,251,255,255,131,209,  1,232,171,
/* 0x1310 */   0,  0,  0,233, 71,255,255,255,128,250,  2, 15,133,171,  0,  0,
/* 0x1320 */   0,235,  4, 70,136, 23, 71, 15,182, 22,  1,219,117, 10,139, 30,
/* 0x1330 */ 131,238,252, 17,219, 15,182, 22,114,233,106,  1, 88,  1,219,117,
/* 0x1340 */  10,139, 30,131,238,252, 17,219, 15,182, 22, 17,192,  1,219,117,
/* 0x1350 */  10,139, 30,131,238,252, 17,219, 15,182, 22,115,224,131,232,  3,
/* 0x1360 */ 114, 17,193,224,  8, 70,  9,208,131,240,255, 15,132,254,255,255,
/* 0x1370 */ 255,137,197,106,  1, 88,  1,219,117, 10,139, 30,131,238,252, 17,
/* 0x1380 */ 219, 15,182, 22, 17,201,  1,219,117, 10,139, 30,131,238,252, 17,
/* 0x1390 */ 219, 15,182, 22, 17,201,117, 34,137,193,131,192,  2,  1,219,117,
/* 0x13a0 */  10,139, 30,131,238,252, 17,219, 15,182, 22, 17,201,  1,219,117,
/* 0x13b0 */   7,139, 30,131,238,252, 17,219,115,227,129,253,  0,243,255,255,
/* 0x13c0 */  17,193,232,171,  0,  0,  0,233, 91,255,255,255,128,250, 14, 15,
/* 0x13d0 */ 133, 28,  0,  0,  0,255,118,248,128,126,252, 14,116,  1,244,137,
/* 0x13e0 */ 229,141,156, 36,  0,  0,  0,  0, 49,192, 80, 57,220,117,251, 83,
/* 0x13f0 */ 255,118,244, 87,131,195,  4, 83,139, 70,248, 72, 72, 80, 70, 70,
/* 0x1400 */  86,131,195,  4, 83, 41,192, 80,199,  3,  0,  0,  0,  0,137,229,
/* 0x1410 */ 139, 85,  0,172, 74,136,193, 36,  7,192,233,  3,187,  0,253,255,
/* 0x1420 */ 255,211,227,141,164, 92,144,241,255,255,131,228,224,106,  0,106,
/* 0x1430 */   0,137,227, 83,131,195,  4,139, 77, 16,255, 49, 87, 83,131,195,
/* 0x1440 */   4,136, 67,  2,172, 74,136,193, 36, 15,136,  3,192,233,  4,136,
/* 0x1450 */  75,  1, 82, 86, 83, 80, 85, 87,191,  0,  0,  0,  0, 86, 83,131,
/* 0x1460 */ 236,100,139, 84, 36,120,199, 68, 36, 92,  0,  0,  0,  0,141, 66,
/* 0x1470 */   4,137, 68, 36, 96,184,  1,  0,  0,  0, 15,182, 74,  2,137,195,
/* 0x1480 */ 211,227,137,217, 73,137, 76, 36, 88, 15,182, 74,  1,211,224,139,
/* 0x1490 */ 140, 36,144,  0,  0,  0, 72,137, 68, 36, 84,139,132, 36,132,  0,
/* 0x14a0 */   0,  0, 15,182, 50,199, 68, 36, 76,  0,  0,  0,  0,199,  0,  0,
/* 0x14b0 */   0,  0,  0,184,  0,  3,  0,  0,199, 68, 36, 72,  1,  0,  0,  0,
/* 0x14c0 */ 137,116, 36, 80,199, 68, 36, 68,  1,  0,  0,  0,199, 68, 36, 64,
/* 0x14d0 */   1,  0,  0,  0,199, 68, 36, 60,  1,  0,  0,  0,199,  1,  0,  0,
/* 0x14e0 */   0,  0, 15,182, 74,  1,  1,241,211,224,141,136, 54,  7,  0,  0,
/* 0x14f0 */  57, 76, 36, 92,115, 14,139, 68, 36, 96,102,199,  0,  0,  4,131,
/* 0x1500 */ 192,  2,226,246,139,108, 36,124,199, 68, 36, 48,  0,  0,  0,  0,
/* 0x1510 */ 199, 68, 36, 52,255,255,255,255,186,  0,  0,  0,  0,137,235,  3,
/* 0x1520 */ 156, 36,128,  0,  0,  0,137, 92, 36, 56, 59,108, 36, 56, 15,132,
/* 0x1530 */ 128,  8,  0,  0,193,100, 36, 48,  8, 66, 15,182, 69,  0, 69,  9,
/* 0x1540 */  68, 36, 48,131,250,  4,126,226,139,180, 36,140,  0,  0,  0, 57,
/* 0x1550 */ 116, 36, 92, 15,131,226,  1,  0,  0,139,132, 36,136,  0,  0,  0,
/* 0x1560 */ 137, 68, 36, 24,139, 84, 36, 92, 35, 84, 36, 88,139, 68, 36, 76,
/* 0x1570 */ 139, 76, 36, 96,193,224,  4,137, 84, 36, 44,  1,208,129,124, 36,
/* 0x1580 */  52,255,255,255,  0,141, 52, 65,119, 29, 59,108, 36, 56, 15,132,
/* 0x1590 */  32,  8,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182,
/* 0x15a0 */  69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 22,193,232,
/* 0x15b0 */  11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131, 80,  2,  0,
/* 0x15c0 */   0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,138, 76, 36, 80,
/* 0x15d0 */ 193,248,  5,187,  1,  0,  0,  0,141,  4,  2,102,137,  6,139, 68,
/* 0x15e0 */  36, 92, 35, 68, 36, 84,139,116, 36, 96,211,224,137,249, 15,182,
/* 0x15f0 */ 209,185,  8,  0,  0,  0, 43, 76, 36, 80,211,250,  1,208,105,192,
/* 0x1600 */   0,  6,  0,  0,131,124, 36, 76,  6,141,132, 48,108, 14,  0,  0,
/* 0x1610 */ 137, 68, 36, 20, 15,142, 72,  1,  0,  0,139, 68, 36, 92, 43, 68,
/* 0x1620 */  36, 72,139,148, 36,136,  0,  0,  0, 15,182,  4, 16,137, 68, 36,
/* 0x1630 */  40,235, 46,137, 68, 36, 52,184,  0,  8,  0,  0, 41,216,137,251,
/* 0x1640 */ 193,248,  5,133,210,141,  4,  1,102,137,134,  0,  2,  0,  0, 15,
/* 0x1650 */ 133,106,  1,  0,  0,129,251,255,  0,  0,  0, 15,143,143,  0,  0,
/* 0x1660 */   0,209,100, 36, 40,139, 84, 36, 40,141, 60, 27,139, 76, 36, 20,
/* 0x1670 */ 129,226,  0,  1,  0,  0,129,124, 36, 52,255,255,255,  0,141,  4,
/* 0x1680 */  81,141, 52, 56,119, 29, 59,108, 36, 56, 15,132, 36,  7,  0,  0,
/* 0x1690 */ 193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9,
/* 0x16a0 */  68, 36, 48,139, 68, 36, 52,102,139,142,  0,  2,  0,  0,193,232,
/* 0x16b0 */  11, 15,183,217, 15,175,195, 57, 68, 36, 48, 15,130,114,255,255,
/* 0x16c0 */ 255, 41, 68, 36, 52, 41, 68, 36, 48,137,200,102,193,232,  5,141,
/* 0x16d0 */  95,  1,102, 41,193,133,210,102,137,142,  0,  2,  0,  0, 15,132,
/* 0x16e0 */ 219,  0,  0,  0,129,251,255,  0,  0,  0, 15,142,113,255,255,255,
/* 0x16f0 */ 139, 84, 36, 24,137,223,136, 26, 66,255, 68, 36, 92,131,124, 36,
/* 0x1700 */  76,  3,137, 84, 36, 24, 15,143,215,  0,  0,  0,199, 68, 36, 76,
/* 0x1710 */   0,  0,  0,  0,139,132, 36,140,  0,  0,  0, 57, 68, 36, 92, 15,
/* 0x1720 */ 130, 63,254,255,255,129,124, 36, 52,255,255,255,  0,119, 12, 59,
/* 0x1730 */ 108, 36, 56,184,  1,  0,  0,  0,116, 32, 69, 43,108, 36,124,184,
/* 0x1740 */   0,  0,  0,  0,139,148, 36,132,  0,  0,  0,139, 92, 36, 92,139,
/* 0x1750 */ 140, 36,144,  0,  0,  0,137, 42,137, 25,131,196,100,233, 46,  8,
/* 0x1760 */   0,  0,129,124, 36, 52,255,255,255,  0,141, 52, 27,139, 68, 36,
/* 0x1770 */  20,141, 28,  6,119, 29, 59,108, 36, 56, 15,132, 52,  6,  0,  0,
/* 0x1780 */ 193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9,
/* 0x1790 */  68, 36, 48,139, 68, 36, 52,102,139, 11,193,232, 11, 15,183,209,
/* 0x17a0 */  15,175,194, 57, 68, 36, 48,115, 79,137, 68, 36, 52,184,  0,  8,
/* 0x17b0 */   0,  0, 41,208,193,248,  5,141,  4,  1,102,137,  3,137,243,129,
/* 0x17c0 */ 251,255,  0,  0,  0,126,155,139, 84, 36, 24,137,223,136, 26, 66,
/* 0x17d0 */ 255, 68, 36, 92,131,124, 36, 76,  3,137, 84, 36, 24, 15,142, 41,
/* 0x17e0 */ 255,255,255,131,124, 36, 76,  9, 15,143,107,  6,  0,  0,131,108,
/* 0x17f0 */  36, 76,  3,233, 28,255,255,255, 41, 68, 36, 52, 41, 68, 36, 48,
/* 0x1800 */ 137,200,102,193,232,  5,102, 41,193,102,137, 11,141, 94,  1,235,
/* 0x1810 */ 174,139, 92, 36, 52, 41, 68, 36, 48, 41,195,137,208,102,193,232,
/* 0x1820 */   5,139, 76, 36, 76,102, 41,194,129,251,255,255,255,  0,102,137,
/* 0x1830 */  22,139,116, 36, 96,141, 60, 78,119, 27, 59,108, 36, 56, 15,132,
/* 0x1840 */ 112,  5,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,
/* 0x1850 */   9, 68, 36, 48, 69,102,139,151,128,  1,  0,  0,137,216,193,232,
/* 0x1860 */  11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,228,  2,  0,
/* 0x1870 */   0,137,198,184,  0,  8,  0,  0, 41,200,139, 92, 36, 96,193,248,
/* 0x1880 */   5,131,124, 36, 76,  6,141,  4,  2,139, 76, 36, 72,139, 84, 36,
/* 0x1890 */  68,102,137,135,128,  1,  0,  0,139, 68, 36, 64,137, 76, 36, 68,
/* 0x18a0 */ 137, 68, 36, 60,184,  0,  0,  0,  0, 15,159,192,137, 84, 36, 64,
/* 0x18b0 */ 141,  4, 64,129,195,100,  6,  0,  0,137, 68, 36, 76,129,254,255,
/* 0x18c0 */ 255,255,  0,119, 27, 59,108, 36, 56, 15,132,229,  4,  0,  0,193,
/* 0x18d0 */ 100, 36, 48,  8, 15,182, 69,  0,193,230,  8,  9, 68, 36, 48, 69,
/* 0x18e0 */ 102,139, 19,137,240,193,232, 11, 15,183,202, 15,175,193, 57, 68,
/* 0x18f0 */  36, 48, 15,131,102,  3,  0,  0,137, 68, 36, 52,184,  0,  8,  0,
/* 0x1900 */   0, 41,200,193,100, 36, 44,  4,193,248,  5,139, 76, 36, 44,141,
/* 0x1910 */   4,  2,199, 68, 36, 32,  0,  0,  0,  0,102,137,  3,141, 92, 25,
/* 0x1920 */   4,137, 92, 36, 16,199, 68, 36, 36,  3,  0,  0,  0,139,124, 36,
/* 0x1930 */  36,186,  1,  0,  0,  0,235, 25,137, 68, 36, 52,184,  0,  8,  0,
/* 0x1940 */   0, 41,200,193,248,  5, 79,141,  4,  2,137,242,102,137,  3,116,
/* 0x1950 */  97,129,124, 36, 52,255,255,255,  0,141, 52, 18,139, 68, 36, 16,
/* 0x1960 */ 141, 28,  6,119, 29, 59,108, 36, 56, 15,132, 69,  4,  0,  0,193,
/* 0x1970 */ 100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68,
/* 0x1980 */  36, 48,139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,202, 15,
/* 0x1990 */ 175,193, 57, 68, 36, 48,114,160, 41, 68, 36, 52, 41, 68, 36, 48,
/* 0x19a0 */ 137,208,102,193,232,  5,102, 41,194, 79,102,137, 19,141, 86,  1,
/* 0x19b0 */ 117,159,138, 76, 36, 36,184,  1,  0,  0,  0,211,224, 41,194,  3,
/* 0x19c0 */  84, 36, 32,131,124, 36, 76,  3,137, 84, 36, 12, 15,143,254,  3,
/* 0x19d0 */   0,  0,131, 68, 36, 76,  7,131,250,  3,137,208,126,  5,184,  3,
/* 0x19e0 */   0,  0,  0,139, 92, 36, 96,193,224,  7,191,  6,  0,  0,  0,141,
/* 0x19f0 */ 132, 24, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,  0,235,
/* 0x1a00 */  25,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5, 79,
/* 0x1a10 */ 141,  4,  2,102,137,  3,137,240,116, 97,129,124, 36, 52,255,255,
/* 0x1a20 */ 255,  0,141, 52,  0,139, 68, 36,  8,141, 28,  6,119, 29, 59,108,
/* 0x1a30 */  36, 56, 15,132,124,  3,  0,  0,193,100, 36, 48,  8,193,100, 36,
/* 0x1a40 */  52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,
/* 0x1a50 */ 139, 19,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,114,
/* 0x1a60 */ 160, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,193,232,  5,102,
/* 0x1a70 */  41,194, 79,102,137, 19,141, 70,  1,117,159,141, 80,192,131,250,
/* 0x1a80 */   3,137, 84, 36,  4, 15,142, 54,  3,  0,  0,137,211,137,208,131,
/* 0x1a90 */ 227,  1,209,248,131,203,  2,131,250, 13,141,120,255, 15,143, 66,
/* 0x1aa0 */   4,  0,  0,137,249,139,116, 36, 96,211,227,  1,210,141,  4, 94,
/* 0x1ab0 */ 137, 92, 36,  4, 41,208,  5, 94,  5,  0,  0,137,  4, 36,184,  1,
/* 0x1ac0 */   0,  0,  0,199, 68, 36, 28,  1,  0,  0,  0,235, 33,137, 68, 36,
/* 0x1ad0 */  52,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,
/* 0x1ae0 */   3,137,240,209,100, 36, 28, 79, 15,132,211,  2,  0,  0,129,124,
/* 0x1af0 */  36, 52,255,255,255,  0,141, 52,  0,139, 12, 36,141, 28, 14,119,
/* 0x1b00 */  29, 59,108, 36, 56, 15,132,169,  2,  0,  0,193,100, 36, 48,  8,
/* 0x1b10 */ 193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68,
/* 0x1b20 */  36, 52,102,139, 19,193,232, 11, 15,183,202, 15,175,193, 57, 68,
/* 0x1b30 */  36, 48,114,153, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,193,
/* 0x1b40 */ 232,  5,102, 41,194,141, 70,  1,102,137, 19,139, 92, 36, 28,  9,
/* 0x1b50 */  92, 36,  4,235,142, 41,195, 41, 68, 36, 48,137,208,102,193,232,
/* 0x1b60 */   5,102, 41,194,129,251,255,255,255,  0,102,137,151,128,  1,  0,
/* 0x1b70 */   0, 15,134,107,  1,  0,  0,102,139,143,152,  1,  0,  0,137,218,
/* 0x1b80 */ 193,234, 11, 15,183,193, 15,175,208, 57, 84, 36, 48, 15,131,134,
/* 0x1b90 */   1,  0,  0,190,  0,  8,  0,  0,137,211, 41,198,137,240,193,248,
/* 0x1ba0 */   5,141,  4,  1,139, 76, 36, 44,102,137,135,152,  1,  0,  0,139,
/* 0x1bb0 */  68, 36, 76,193,224,  5,  3, 68, 36, 96,129,250,255,255,255,  0,
/* 0x1bc0 */ 141, 60, 72,119, 27, 59,108, 36, 56, 15,132,229,  1,  0,  0,193,
/* 0x1bd0 */ 100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,
/* 0x1be0 */ 102,139,151,224,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,
/* 0x1bf0 */ 175,193, 57, 68, 36, 48, 15,131,103,  2,  0,  0,137, 68, 36, 52,
/* 0x1c00 */ 184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,135,
/* 0x1c10 */ 224,  1,  0,  0,139, 68, 36, 92,133,192, 15,132,148,  1,  0,  0,
/* 0x1c20 */ 131,124, 36, 76,  6,184,  0,  0,  0,  0,139,156, 36,136,  0,  0,
/* 0x1c30 */   0,139, 84, 36, 24, 15,159,192,141, 68,  0,  9,137, 68, 36, 76,
/* 0x1c40 */ 139, 68, 36, 92, 43, 68, 36, 72, 15,182, 60, 24,137,248,136,  2,
/* 0x1c50 */  66,255, 68, 36, 92,137, 84, 36, 24,233,182,250,255,255, 41,198,
/* 0x1c60 */  41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,129,254,255,
/* 0x1c70 */ 255,255,  0,102,137, 19,119, 27, 59,108, 36, 56, 15,132, 50,  1,
/* 0x1c80 */   0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,230,  8,  9, 68,
/* 0x1c90 */  36, 48, 69,102,139, 83,  2,137,240,193,232, 11, 15,183,202, 15,
/* 0x1ca0 */ 175,193, 57, 68, 36, 48, 15,131,119,  1,  0,  0,137, 68, 36, 52,
/* 0x1cb0 */ 184,  0,  8,  0,  0, 41,200,193,100, 36, 44,  4,193,248,  5,139,
/* 0x1cc0 */ 116, 36, 44,141,  4,  2,199, 68, 36, 32,  8,  0,  0,  0,102,137,
/* 0x1cd0 */  67,  2,141,156, 30,  4,  1,  0,  0,137, 92, 36, 16,233, 67,252,
/* 0x1ce0 */ 255,255, 59,108, 36, 56, 15,132,200,  0,  0,  0,193,100, 36, 48,
/* 0x1cf0 */   8,193,227,  8,102,139,143,152,  1,  0,  0, 15,182, 69,  0,137,
/* 0x1d00 */ 218,  9, 68, 36, 48,193,234, 11, 15,183,193, 69, 15,175,208, 57,
/* 0x1d10 */  84, 36, 48, 15,130,122,254,255,255,137,200, 41,211,102,193,232,
/* 0x1d20 */   5, 41, 84, 36, 48,102, 41,193,129,251,255,255,255,  0,102,137,
/* 0x1d30 */ 143,152,  1,  0,  0,119, 23, 59,108, 36, 56,116,119,193,100, 36,
/* 0x1d40 */  48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,102,139,
/* 0x1d50 */ 151,176,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x1d60 */  57, 68, 36, 48, 15,131, 22,  1,  0,  0,137,198,184,  0,  8,  0,
/* 0x1d70 */   0, 41,200,193,248,  5,141,  4,  2,102,137,135,176,  1,  0,  0,
/* 0x1d80 */ 139, 68, 36, 68,139, 84, 36, 72,137, 68, 36, 72,137, 84, 36, 68,
/* 0x1d90 */ 131,124, 36, 76,  6,184,  0,  0,  0,  0,139, 92, 36, 96, 15,159,
/* 0x1da0 */ 192,129,195,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36, 76,233,
/* 0x1db0 */   9,251,255,255,131,196,100,184,  1,  0,  0,  0,233,207,  1,  0,
/* 0x1dc0 */   0,139,116, 36,  4, 70,137,116, 36, 72, 15,132, 85,249,255,255,
/* 0x1dd0 */ 139, 76, 36, 12,139, 68, 36, 92,131,193,  2, 57, 68, 36, 72,119,
/* 0x1de0 */ 211,137,194,139,132, 36,136,  0,  0,  0, 43, 68, 36, 72,  3,148,
/* 0x1df0 */  36,136,  0,  0,  0,  3, 68, 36, 92, 15,182, 56, 64,137,251,136,
/* 0x1e00 */  26, 66,255, 68, 36, 92,255, 68, 36, 24, 73, 15,132,  3,249,255,
/* 0x1e10 */ 255,139,180, 36,140,  0,  0,  0, 57,116, 36, 92,114,219,233,  2,
/* 0x1e20 */ 249,255,255, 41,198, 41, 68, 36, 48,137,208,137,116, 36, 52,102,
/* 0x1e30 */ 193,232,  5,199, 68, 36, 32, 16,  0,  0,  0,102, 41,194,199, 68,
/* 0x1e40 */  36, 36,  8,  0,  0,  0,102,137, 83,  2,129,195,  4,  2,  0,  0,
/* 0x1e50 */ 137, 92, 36, 16,233,212,250,255,255,131,108, 36, 76,  6,233,177,
/* 0x1e60 */ 248,255,255,137,222, 41, 68, 36, 48, 41,198,137,208,102,193,232,
/* 0x1e70 */   5,102, 41,194,102,137,151,224,  1,  0,  0,233, 16,255,255,255,
/* 0x1e80 */  41,195, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,129,
/* 0x1e90 */ 251,255,255,255,  0,102,137,151,176,  1,  0,  0, 15,134,165,  0,
/* 0x1ea0 */   0,  0,102,139,151,200,  1,  0,  0,137,216,193,232, 11, 15,183,
/* 0x1eb0 */ 202, 15,175,193, 57, 68, 36, 48, 15,131,169,  0,  0,  0,137,198,
/* 0x1ec0 */ 184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,135,
/* 0x1ed0 */ 200,  1,  0,  0,139, 68, 36, 64,139, 92, 36, 68,137, 92, 36, 64,
/* 0x1ee0 */ 233,159,254,255,255,141, 80,251,129,124, 36, 52,255,255,255,  0,
/* 0x1ef0 */ 119, 29, 59,108, 36, 56, 15,132,184,254,255,255,193,100, 36, 48,
/* 0x1f00 */   8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,209,
/* 0x1f10 */ 108, 36, 52,  1,219,139, 68, 36, 52, 57, 68, 36, 48,114,  7, 41,
/* 0x1f20 */  68, 36, 48,131,203,  1, 74,117,191,139, 84, 36, 96,193,227,  4,
/* 0x1f30 */ 191,  4,  0,  0,  0,137, 92, 36,  4,129,194, 68,  6,  0,  0,137,
/* 0x1f40 */  20, 36,233,119,251,255,255, 59,108, 36, 56, 15,132, 99,254,255,
/* 0x1f50 */ 255,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36,
/* 0x1f60 */  48, 69,233, 59,255,255,255,137,222, 41, 68, 36, 48, 41,198,137,
/* 0x1f70 */ 208,102,193,232,  5,139, 76, 36, 64,102, 41,194,139, 68, 36, 60,
/* 0x1f80 */ 102,137,151,200,  1,  0,  0,137, 76, 36, 60,233, 72,255,255,255,
/* 0x1f90 */  91, 94, 95, 93, 85, 87,191,  0,  0,  0,  0, 86, 83,131,236,100,
/* 0x1fa0 */ 139, 84, 36,120,199, 68, 36, 92,  0,  0,  0,  0,141, 66,  4,137,
/* 0x1fb0 */  68, 36, 96,184,  1,  0,  0,  0, 15,182, 74,  2,137,195,211,227,
/* 0x1fc0 */ 137,217, 73,137, 76, 36, 88, 15,182, 74,  1,211,224,139,140, 36,
/* 0x1fd0 */ 144,  0,  0,  0, 72,137, 68, 36, 84,139,132, 36,132,  0,  0,  0,
/* 0x1fe0 */  15,182, 50,199, 68, 36, 76,  0,  0,  0,  0,199,  0,  0,  0,  0,
/* 0x1ff0 */   0,184,  0,  3,  0,  0,199, 68, 36, 72,  1,  0,  0,  0,137,116,
/* 0x2000 */  36, 80,199, 68, 36, 68,  1,  0,  0,  0,199, 68, 36, 64,  1,  0,
/* 0x2010 */   0,  0,199, 68, 36, 60,  1,  0,  0,  0,199,  1,  0,  0,  0,  0,
/* 0x2020 */  15,182, 74,  1,  1,241,211,224,141,136, 54,  7,  0,  0, 57, 76,
/* 0x2030 */  36, 92,115, 14,139, 68, 36, 96,102,199,  0,  0,  4,131,192,  2,
/* 0x2040 */ 226,246,139,108, 36,124,199, 68, 36, 48,  0,  0,  0,  0,199, 68,
/* 0x2050 */  36, 52,255,255,255,255,186,  0,  0,  0,  0,137,235,  3,156, 36,
/* 0x2060 */ 128,  0,  0,  0,137, 92, 36, 56, 59,108, 36, 56, 15,132,128,  8,
/* 0x2070 */   0,  0,193,100, 36, 48,  8, 66, 15,182, 69,  0, 69,  9, 68, 36,
/* 0x2080 */  48,131,250,  4,126,226,139,180, 36,140,  0,  0,  0, 57,116, 36,
/* 0x2090 */  92, 15,131,226,  1,  0,  0,139,132, 36,136,  0,  0,  0,137, 68,
/* 0x20a0 */  36, 24,139, 84, 36, 92, 35, 84, 36, 88,139, 68, 36, 76,139, 76,
/* 0x20b0 */  36, 96,193,224,  4,137, 84, 36, 44,  1,208,129,124, 36, 52,255,
/* 0x20c0 */ 255,255,  0,141, 52, 65,119, 29, 59,108, 36, 56, 15,132, 32,  8,
/* 0x20d0 */   0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0,
/* 0x20e0 */  69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 22,193,232, 11, 15,
/* 0x20f0 */ 183,202, 15,175,193, 57, 68, 36, 48, 15,131, 80,  2,  0,  0,137,
/* 0x2100 */  68, 36, 52,184,  0,  8,  0,  0, 41,200,138, 76, 36, 80,193,248,
/* 0x2110 */   5,187,  1,  0,  0,  0,141,  4,  2,102,137,  6,139, 68, 36, 92,
/* 0x2120 */  35, 68, 36, 84,139,116, 36, 96,211,224,137,249, 15,182,209,185,
/* 0x2130 */   8,  0,  0,  0, 43, 76, 36, 80,211,250,  1,208,105,192,  0,  6,
/* 0x2140 */   0,  0,131,124, 36, 76,  6,141,132, 48,108, 14,  0,  0,137, 68,
/* 0x2150 */  36, 20, 15,142, 72,  1,  0,  0,139, 68, 36, 92, 43, 68, 36, 72,
/* 0x2160 */ 139,148, 36,136,  0,  0,  0, 15,182,  4, 16,137, 68, 36, 40,235,
/* 0x2170 */  46,137, 68, 36, 52,184,  0,  8,  0,  0, 41,216,137,251,193,248,
/* 0x2180 */   5,133,210,141,  4,  1,102,137,134,  0,  2,  0,  0, 15,133,106,
/* 0x2190 */   1,  0,  0,129,251,255,  0,  0,  0, 15,143,143,  0,  0,  0,209,
/* 0x21a0 */ 100, 36, 40,139, 84, 36, 40,141, 60, 27,139, 76, 36, 20,129,226,
/* 0x21b0 */   0,  1,  0,  0,129,124, 36, 52,255,255,255,  0,141,  4, 81,141,
/* 0x21c0 */  52, 56,119, 29, 59,108, 36, 56, 15,132, 36,  7,  0,  0,193,100,
/* 0x21d0 */  36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36,
/* 0x21e0 */  48,139, 68, 36, 52,102,139,142,  0,  2,  0,  0,193,232, 11, 15,
/* 0x21f0 */ 183,217, 15,175,195, 57, 68, 36, 48, 15,130,114,255,255,255, 41,
/* 0x2200 */  68, 36, 52, 41, 68, 36, 48,137,200,102,193,232,  5,141, 95,  1,
/* 0x2210 */ 102, 41,193,133,210,102,137,142,  0,  2,  0,  0, 15,132,219,  0,
/* 0x2220 */   0,  0,129,251,255,  0,  0,  0, 15,142,113,255,255,255,139, 84,
/* 0x2230 */  36, 24,137,223,136, 26, 66,255, 68, 36, 92,131,124, 36, 76,  3,
/* 0x2240 */ 137, 84, 36, 24, 15,143,215,  0,  0,  0,199, 68, 36, 76,  0,  0,
/* 0x2250 */   0,  0,139,132, 36,140,  0,  0,  0, 57, 68, 36, 92, 15,130, 63,
/* 0x2260 */ 254,255,255,129,124, 36, 52,255,255,255,  0,119, 12, 59,108, 36,
/* 0x2270 */  56,184,  1,  0,  0,  0,116, 32, 69, 43,108, 36,124,184,  0,  0,
/* 0x2280 */   0,  0,139,148, 36,132,  0,  0,  0,139, 92, 36, 92,139,140, 36,
/* 0x2290 */ 144,  0,  0,  0,137, 42,137, 25,131,196,100,233, 46,  8,  0,  0,
/* 0x22a0 */ 129,124, 36, 52,255,255,255,  0,141, 52, 27,139, 68, 36, 20,141,
/* 0x22b0 */  28,  6,119, 29, 59,108, 36, 56, 15,132, 52,  6,  0,  0,193,100,
/* 0x22c0 */  36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36,
/* 0x22d0 */  48,139, 68, 36, 52,102,139, 11,193,232, 11, 15,183,209, 15,175,
/* 0x22e0 */ 194, 57, 68, 36, 48,115, 79,137, 68, 36, 52,184,  0,  8,  0,  0,
/* 0x22f0 */  41,208,193,248,  5,141,  4,  1,102,137,  3,137,243,129,251,255,
/* 0x2300 */   0,  0,  0,126,155,139, 84, 36, 24,137,223,136, 26, 66,255, 68,
/* 0x2310 */  36, 92,131,124, 36, 76,  3,137, 84, 36, 24, 15,142, 41,255,255,
/* 0x2320 */ 255,131,124, 36, 76,  9, 15,143,107,  6,  0,  0,131,108, 36, 76,
/* 0x2330 */   3,233, 28,255,255,255, 41, 68, 36, 52, 41, 68, 36, 48,137,200,
/* 0x2340 */ 102,193,232,  5,102, 41,193,102,137, 11,141, 94,  1,235,174,139,
/* 0x2350 */  92, 36, 52, 41, 68, 36, 48, 41,195,137,208,102,193,232,  5,139,
/* 0x2360 */  76, 36, 76,102, 41,194,129,251,255,255,255,  0,102,137, 22,139,
/* 0x2370 */ 116, 36, 96,141, 60, 78,119, 27, 59,108, 36, 56, 15,132,112,  5,
/* 0x2380 */   0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68,
/* 0x2390 */  36, 48, 69,102,139,151,128,  1,  0,  0,137,216,193,232, 11, 15,
/* 0x23a0 */ 183,202, 15,175,193, 57, 68, 36, 48, 15,131,228,  2,  0,  0,137,
/* 0x23b0 */ 198,184,  0,  8,  0,  0, 41,200,139, 92, 36, 96,193,248,  5,131,
/* 0x23c0 */ 124, 36, 76,  6,141,  4,  2,139, 76, 36, 72,139, 84, 36, 68,102,
/* 0x23d0 */ 137,135,128,  1,  0,  0,139, 68, 36, 64,137, 76, 36, 68,137, 68,
/* 0x23e0 */  36, 60,184,  0,  0,  0,  0, 15,159,192,137, 84, 36, 64,141,  4,
/* 0x23f0 */  64,129,195,100,  6,  0,  0,137, 68, 36, 76,129,254,255,255,255,
/* 0x2400 */   0,119, 27, 59,108, 36, 56, 15,132,229,  4,  0,  0,193,100, 36,
/* 0x2410 */  48,  8, 15,182, 69,  0,193,230,  8,  9, 68, 36, 48, 69,102,139,
/* 0x2420 */  19,137,240,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,
/* 0x2430 */  15,131,102,  3,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,
/* 0x2440 */ 200,193,100, 36, 44,  4,193,248,  5,139, 76, 36, 44,141,  4,  2,
/* 0x2450 */ 199, 68, 36, 32,  0,  0,  0,  0,102,137,  3,141, 92, 25,  4,137,
/* 0x2460 */  92, 36, 16,199, 68, 36, 36,  3,  0,  0,  0,139,124, 36, 36,186,
/* 0x2470 */   1,  0,  0,  0,235, 25,137, 68, 36, 52,184,  0,  8,  0,  0, 41,
/* 0x2480 */ 200,193,248,  5, 79,141,  4,  2,137,242,102,137,  3,116, 97,129,
/* 0x2490 */ 124, 36, 52,255,255,255,  0,141, 52, 18,139, 68, 36, 16,141, 28,
/* 0x24a0 */   6,119, 29, 59,108, 36, 56, 15,132, 69,  4,  0,  0,193,100, 36,
/* 0x24b0 */  48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,
/* 0x24c0 */ 139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,202, 15,175,193,
/* 0x24d0 */  57, 68, 36, 48,114,160, 41, 68, 36, 52, 41, 68, 36, 48,137,208,
/* 0x24e0 */ 102,193,232,  5,102, 41,194, 79,102,137, 19,141, 86,  1,117,159,
/* 0x24f0 */ 138, 76, 36, 36,184,  1,  0,  0,  0,211,224, 41,194,  3, 84, 36,
/* 0x2500 */  32,131,124, 36, 76,  3,137, 84, 36, 12, 15,143,254,  3,  0,  0,
/* 0x2510 */ 131, 68, 36, 76,  7,131,250,  3,137,208,126,  5,184,  3,  0,  0,
/* 0x2520 */   0,139, 92, 36, 96,193,224,  7,191,  6,  0,  0,  0,141,132, 24,
/* 0x2530 */  96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,  0,235, 25,137,
/* 0x2540 */  68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5, 79,141,  4,
/* 0x2550 */   2,102,137,  3,137,240,116, 97,129,124, 36, 52,255,255,255,  0,
/* 0x2560 */ 141, 52,  0,139, 68, 36,  8,141, 28,  6,119, 29, 59,108, 36, 56,
/* 0x2570 */  15,132,124,  3,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8,
/* 0x2580 */  15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 19,
/* 0x2590 */ 193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,114,160, 41,
/* 0x25a0 */  68, 36, 52, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,
/* 0x25b0 */  79,102,137, 19,141, 70,  1,117,159,141, 80,192,131,250,  3,137,
/* 0x25c0 */  84, 36,  4, 15,142, 54,  3,  0,  0,137,211,137,208,131,227,  1,
/* 0x25d0 */ 209,248,131,203,  2,131,250, 13,141,120,255, 15,143, 66,  4,  0,
/* 0x25e0 */   0,137,249,139,116, 36, 96,211,227,  1,210,141,  4, 94,137, 92,
/* 0x25f0 */  36,  4, 41,208,  5, 94,  5,  0,  0,137,  4, 36,184,  1,  0,  0,
/* 0x2600 */   0,199, 68, 36, 28,  1,  0,  0,  0,235, 33,137, 68, 36, 52,184,
/* 0x2610 */   0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,  3,137,
/* 0x2620 */ 240,209,100, 36, 28, 79, 15,132,211,  2,  0,  0,129,124, 36, 52,
/* 0x2630 */ 255,255,255,  0,141, 52,  0,139, 12, 36,141, 28, 14,119, 29, 59,
/* 0x2640 */ 108, 36, 56, 15,132,169,  2,  0,  0,193,100, 36, 48,  8,193,100,
/* 0x2650 */  36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,
/* 0x2660 */ 102,139, 19,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,
/* 0x2670 */ 114,153, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,193,232,  5,
/* 0x2680 */ 102, 41,194,141, 70,  1,102,137, 19,139, 92, 36, 28,  9, 92, 36,
/* 0x2690 */   4,235,142, 41,195, 41, 68, 36, 48,137,208,102,193,232,  5,102,
/* 0x26a0 */  41,194,129,251,255,255,255,  0,102,137,151,128,  1,  0,  0, 15,
/* 0x26b0 */ 134,107,  1,  0,  0,102,139,143,152,  1,  0,  0,137,218,193,234,
/* 0x26c0 */  11, 15,183,193, 15,175,208, 57, 84, 36, 48, 15,131,134,  1,  0,
/* 0x26d0 */   0,190,  0,  8,  0,  0,137,211, 41,198,137,240,193,248,  5,141,
/* 0x26e0 */   4,  1,139, 76, 36, 44,102,137,135,152,  1,  0,  0,139, 68, 36,
/* 0x26f0 */  76,193,224,  5,  3, 68, 36, 96,129,250,255,255,255,  0,141, 60,
/* 0x2700 */  72,119, 27, 59,108, 36, 56, 15,132,229,  1,  0,  0,193,100, 36,
/* 0x2710 */  48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,102,139,
/* 0x2720 */ 151,224,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x2730 */  57, 68, 36, 48, 15,131,103,  2,  0,  0,137, 68, 36, 52,184,  0,
/* 0x2740 */   8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,135,224,  1,
/* 0x2750 */   0,  0,139, 68, 36, 92,133,192, 15,132,148,  1,  0,  0,131,124,
/* 0x2760 */  36, 76,  6,184,  0,  0,  0,  0,139,156, 36,136,  0,  0,  0,139,
/* 0x2770 */  84, 36, 24, 15,159,192,141, 68,  0,  9,137, 68, 36, 76,139, 68,
/* 0x2780 */  36, 92, 43, 68, 36, 72, 15,182, 60, 24,137,248,136,  2, 66,255,
/* 0x2790 */  68, 36, 92,137, 84, 36, 24,233,182,250,255,255, 41,198, 41, 68,
/* 0x27a0 */  36, 48,137,208,102,193,232,  5,102, 41,194,129,254,255,255,255,
/* 0x27b0 */   0,102,137, 19,119, 27, 59,108, 36, 56, 15,132, 50,  1,  0,  0,
/* 0x27c0 */ 193,100, 36, 48,  8, 15,182, 69,  0,193,230,  8,  9, 68, 36, 48,
/* 0x27d0 */  69,102,139, 83,  2,137,240,193,232, 11, 15,183,202, 15,175,193,
/* 0x27e0 */  57, 68, 36, 48, 15,131,119,  1,  0,  0,137, 68, 36, 52,184,  0,
/* 0x27f0 */   8,  0,  0, 41,200,193,100, 36, 44,  4,193,248,  5,139,116, 36,
/* 0x2800 */  44,141,  4,  2,199, 68, 36, 32,  8,  0,  0,  0,102,137, 67,  2,
/* 0x2810 */ 141,156, 30,  4,  1,  0,  0,137, 92, 36, 16,233, 67,252,255,255,
/* 0x2820 */  59,108, 36, 56, 15,132,200,  0,  0,  0,193,100, 36, 48,  8,193,
/* 0x2830 */ 227,  8,102,139,143,152,  1,  0,  0, 15,182, 69,  0,137,218,  9,
/* 0x2840 */  68, 36, 48,193,234, 11, 15,183,193, 69, 15,175,208, 57, 84, 36,
/* 0x2850 */  48, 15,130,122,254,255,255,137,200, 41,211,102,193,232,  5, 41,
/* 0x2860 */  84, 36, 48,102, 41,193,129,251,255,255,255,  0,102,137,143,152,
/* 0x2870 */   1,  0,  0,119, 23, 59,108, 36, 56,116,119,193,100, 36, 48,  8,
/* 0x2880 */  15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,102,139,151,176,
/* 0x2890 */   1,  0,  0,137,216,193,232, 11, 15,183,202, 15,175,193, 57, 68,
/* 0x28a0 */  36, 48, 15,131, 22,  1,  0,  0,137,198,184,  0,  8,  0,  0, 41,
/* 0x28b0 */ 200,193,248,  5,141,  4,  2,102,137,135,176,  1,  0,  0,139, 68,
/* 0x28c0 */  36, 68,139, 84, 36, 72,137, 68, 36, 72,137, 84, 36, 68,131,124,
/* 0x28d0 */  36, 76,  6,184,  0,  0,  0,  0,139, 92, 36, 96, 15,159,192,129,
/* 0x28e0 */ 195,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36, 76,233,  9,251,
/* 0x28f0 */ 255,255,131,196,100,184,  1,  0,  0,  0,233,207,  1,  0,  0,139,
/* 0x2900 */ 116, 36,  4, 70,137,116, 36, 72, 15,132, 85,249,255,255,139, 76,
/* 0x2910 */  36, 12,139, 68, 36, 92,131,193,  2, 57, 68, 36, 72,119,211,137,
/* 0x2920 */ 194,139,132, 36,136,  0,  0,  0, 43, 68, 36, 72,  3,148, 36,136,
/* 0x2930 */   0,  0,  0,  3, 68, 36, 92, 15,182, 56, 64,137,251,136, 26, 66,
/* 0x2940 */ 255, 68, 36, 92,255, 68, 36, 24, 73, 15,132,  3,249,255,255,139,
/* 0x2950 */ 180, 36,140,  0,  0,  0, 57,116, 36, 92,114,219,233,  2,249,255,
/* 0x2960 */ 255, 41,198, 41, 68, 36, 48,137,208,137,116, 36, 52,102,193,232,
/* 0x2970 */   5,199, 68, 36, 32, 16,  0,  0,  0,102, 41,194,199, 68, 36, 36,
/* 0x2980 */   8,  0,  0,  0,102,137, 83,  2,129,195,  4,  2,  0,  0,137, 92,
/* 0x2990 */  36, 16,233,212,250,255,255,131,108, 36, 76,  6,233,177,248,255,
/* 0x29a0 */ 255,137,222, 41, 68, 36, 48, 41,198,137,208,102,193,232,  5,102,
/* 0x29b0 */  41,194,102,137,151,224,  1,  0,  0,233, 16,255,255,255, 41,195,
/* 0x29c0 */  41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,129,251,255,
/* 0x29d0 */ 255,255,  0,102,137,151,176,  1,  0,  0, 15,134,165,  0,  0,  0,
/* 0x29e0 */ 102,139,151,200,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,
/* 0x29f0 */ 175,193, 57, 68, 36, 48, 15,131,169,  0,  0,  0,137,198,184,  0,
/* 0x2a00 */   8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,135,200,  1,
/* 0x2a10 */   0,  0,139, 68, 36, 64,139, 92, 36, 68,137, 92, 36, 64,233,159,
/* 0x2a20 */ 254,255,255,141, 80,251,129,124, 36, 52,255,255,255,  0,119, 29,
/* 0x2a30 */  59,108, 36, 56, 15,132,184,254,255,255,193,100, 36, 48,  8,193,
/* 0x2a40 */ 100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,209,108, 36,
/* 0x2a50 */  52,  1,219,139, 68, 36, 52, 57, 68, 36, 48,114,  7, 41, 68, 36,
/* 0x2a60 */  48,131,203,  1, 74,117,191,139, 84, 36, 96,193,227,  4,191,  4,
/* 0x2a70 */   0,  0,  0,137, 92, 36,  4,129,194, 68,  6,  0,  0,137, 20, 36,
/* 0x2a80 */ 233,119,251,255,255, 59,108, 36, 56, 15,132, 99,254,255,255,193,
/* 0x2a90 */ 100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,
/* 0x2aa0 */ 233, 59,255,255,255,137,222, 41, 68, 36, 48, 41,198,137,208,102,
/* 0x2ab0 */ 193,232,  5,139, 76, 36, 64,102, 41,194,139, 68, 36, 60,102,137,
/* 0x2ac0 */ 151,200,  1,  0,  0,137, 76, 36, 60,233, 72,255,255,255, 91, 94,
/* 0x2ad0 */  95, 93,  3,115,252,  3,123,248, 49,192,141,140, 36,  0,255,255,
/* 0x2ae0 */ 255,137,236, 80, 57,204,117,251,137,236, 49,201, 90, 93,131,196,
/* 0x2af0 */  12,195,  0, 46,115,121,109,116, 97, 98,  0, 46,115,116,114,116,
/* 0x2b00 */  97, 98,  0, 46,115,104,115,116,114,116, 97, 98,  0, 46,114,101,
/* 0x2b10 */ 108, 46,116,101,120,116,  0, 46,114,101,108, 72, 85, 77, 70, 95,
/* 0x2b20 */  65,  0, 46,114,101,108, 72, 85, 77, 70, 95, 76,  0, 46,114,101,
/* 0x2b30 */ 108, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,  0, 46,114,101,
/* 0x2b40 */ 108, 85, 77, 70, 95, 76, 73, 78, 85, 88,  0, 46,114,101,108, 83,
/* 0x2b50 */  89, 83, 67, 65, 76, 76, 83,  0, 69, 88, 80, 95, 72, 69, 65, 68,
/* 0x2b60 */   0, 69, 88, 80, 95, 84, 65, 73, 76,  0, 46,114,101,108, 78, 82,
/* 0x2b70 */  86, 50, 69,  0, 46,114,101,108, 78, 82, 86, 50, 68,  0, 46,114,
/* 0x2b80 */ 101,108, 78, 82, 86, 50, 66,  0, 46,114,101,108, 76, 90, 77, 65,
/* 0x2b90 */  95, 68, 65, 73, 83, 89,  0, 46,114,101,108, 76, 90, 77, 65, 95,
/* 0x2ba0 */  68, 69, 67, 48, 48,  0, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,
/* 0x2bb0 */   0, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  0, 76, 90, 77, 65,
/* 0x2bc0 */  95, 68, 69, 67, 50, 48,  0, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x2bd0 */  48,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2be0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2bf0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 31,  0,  0,  0,
/* 0x2c00 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,
/* 0x2c10 */ 178,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,
/* 0x2c20 */   0,  0,  0,  0, 27,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c30 */   0,  0,  0,  0, 48, 52,  0,  0,192,  0,  0,  0, 30,  0,  0,  0,
/* 0x2c40 */   1,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 41,  0,  0,  0,
/* 0x2c50 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,230,  9,  0,  0,
/* 0x2c60 */   5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2c70 */   0,  0,  0,  0, 37,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c80 */   0,  0,  0,  0,240, 52,  0,  0,  8,  0,  0,  0, 30,  0,  0,  0,
/* 0x2c90 */   3,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 52,  0,  0,  0,
/* 0x2ca0 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,235,  9,  0,  0,
/* 0x2cb0 */   5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2cc0 */   0,  0,  0,  0, 48,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2cd0 */   0,  0,  0,  0,248, 52,  0,  0,  8,  0,  0,  0, 30,  0,  0,  0,
/* 0x2ce0 */   5,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 63,  0,  0,  0,
/* 0x2cf0 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,240,  9,  0,  0,
/* 0x2d00 */ 191,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,
/* 0x2d10 */   0,  0,  0,  0, 59,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d20 */   0,  0,  0,  0,  0, 53,  0,  0, 80,  0,  0,  0, 30,  0,  0,  0,
/* 0x2d30 */   7,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 79,  0,  0,  0,
/* 0x2d40 */   1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,176, 14,  0,  0,
/* 0x2d50 */ 175,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,
/* 0x2d60 */   0,  0,  0,  0, 75,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d70 */   0,  0,  0,  0, 80, 53,  0,  0, 16,  0,  0,  0, 30,  0,  0,  0,
/* 0x2d80 */   9,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 93,  0,  0,  0,
/* 0x2d90 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 96, 15,  0,  0,
/* 0x2da0 */   0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,
/* 0x2db0 */   0,  0,  0,  0, 89,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2dc0 */   0,  0,  0,  0, 96, 53,  0,  0, 16,  0,  0,  0, 30,  0,  0,  0,
/* 0x2dd0 */  11,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,102,  0,  0,  0,
/* 0x2de0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 96, 16,  0,  0,
/* 0x2df0 */  11,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2e00 */   0,  0,  0,  0,111,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e10 */   0,  0,  0,  0,108, 17,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e20 */   0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,124,  0,  0,  0,
/* 0x2e30 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,124, 17,  0,  0,
/* 0x2e40 */ 212,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2e50 */   0,  0,  0,  0,120,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e60 */   0,  0,  0,  0,112, 53,  0,  0, 16,  0,  0,  0, 30,  0,  0,  0,
/* 0x2e70 */  15,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,134,  0,  0,  0,
/* 0x2e80 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 80, 18,  0,  0,
/* 0x2e90 */ 200,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2ea0 */   0,  0,  0,  0,130,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2eb0 */   0,  0,  0,  0,128, 53,  0,  0, 16,  0,  0,  0, 30,  0,  0,  0,
/* 0x2ec0 */  17,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,144,  0,  0,  0,
/* 0x2ed0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 24, 19,  0,  0,
/* 0x2ee0 */ 180,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2ef0 */   0,  0,  0,  0,140,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f00 */   0,  0,  0,  0,144, 53,  0,  0, 16,  0,  0,  0, 30,  0,  0,  0,
/* 0x2f10 */  19,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,154,  0,  0,  0,
/* 0x2f20 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,204, 19,  0,  0,
/* 0x2f30 */  12,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2f40 */   0,  0,  0,  0,150,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f50 */   0,  0,  0,  0,160, 53,  0,  0,  8,  0,  0,  0, 30,  0,  0,  0,
/* 0x2f60 */  21,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,169,  0,  0,  0,
/* 0x2f70 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,216, 19,  0,  0,
/* 0x2f80 */  54,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2f90 */   0,  0,  0,  0,165,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x2fa0 */   0,  0,  0,  0,168, 53,  0,  0, 16,  0,  0,  0, 30,  0,  0,  0,
/* 0x2fb0 */  23,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,180,  0,  0,  0,
/* 0x2fc0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 14, 20,  0,  0,
/* 0x2fd0 */  72,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x2fe0 */   0,  0,  0,  0,191,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ff0 */   0,  0,  0,  0, 86, 20,  0,  0, 62, 11,  0,  0,  0,  0,  0,  0,
/* 0x3000 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,202,  0,  0,  0,
/* 0x3010 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,148, 31,  0,  0,
/* 0x3020 */  62, 11,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x3030 */   0,  0,  0,  0,213,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x3040 */   0,  0,  0,  0,210, 42,  0,  0, 32,  0,  0,  0,  0,  0,  0,  0,
/* 0x3050 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 17,  0,  0,  0,
/* 0x3060 */   3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,242, 42,  0,  0,
/* 0x3070 */ 224,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x3080 */   0,  0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,
/* 0x3090 */   0,  0,  0,  0,212, 48,  0,  0,112,  2,  0,  0, 31,  0,  0,  0,
/* 0x30a0 */  18,  0,  0,  0,  4,  0,  0,  0, 16,  0,  0,  0,  9,  0,  0,  0,
/* 0x30b0 */   3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 68, 51,  0,  0,
/* 0x30c0 */ 234,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x30d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x30e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x30f0 */   3,  0, 11,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3100 */   3,  0, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3110 */   3,  0, 14,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3120 */   3,  0, 28,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3130 */   3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3140 */   3,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3150 */   3,  0,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3160 */   3,  0,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3170 */   3,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3180 */   3,  0, 15,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3190 */   3,  0, 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x31a0 */   3,  0, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x31b0 */   3,  0, 21,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x31c0 */   3,  0, 23,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x31d0 */   3,  0, 25,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x31e0 */   3,  0, 26,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x31f0 */   3,  0, 27,  0,  1,  0,  0,  0,103,  0,  0,  0,  0,  0,  0,  0,
/* 0x3200 */  16,  0, 13,  0, 10,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x3210 */  16,  0,  1,  0, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3220 */  16,  0,  0,  0, 42,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3230 */  16,  0,  0,  0, 58,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,
/* 0x3240 */  16,  0, 14,  0, 74,  0,  0,  0,210,  0,  0,  0,  0,  0,  0,  0,
/* 0x3250 */  16,  0, 11,  0, 81,  0,  0,  0, 43,  0,  0,  0,  0,  0,  0,  0,
/* 0x3260 */  16,  0, 11,  0, 87,  0,  0,  0,232,  0,  0,  0,  0,  0,  0,  0,
/* 0x3270 */  16,  0, 11,  0, 95,  0,  0,  0,  0,  0,  0,  0, 53,  2,  0,  0,
/* 0x3280 */  18,  0,  7,  0,119,  0,  0,  0, 86,  0,  0,  0,  0,  0,  0,  0,
/* 0x3290 */  16,  0, 11,  0,124,  0,  0,  0,151,  0,  0,  0,  0,  0,  0,  0,
/* 0x32a0 */  16,  0, 13,  0,138,  0,  0,  0,  0,  0,  0,  0,175,  0,  0,  0,
/* 0x32b0 */  18,  0,  9,  0,160,  0,  0,  0,153,  0,  0,  0,  0,  0,  0,  0,
/* 0x32c0 */  16,  0, 11,  0,166,  0,  0,  0, 21,  0,  0,  0,  0,  0,  0,  0,
/* 0x32d0 */  16,  0,  1,  0,181,  0,  0,  0,232,  2,  0,  0, 71,  0,  0,  0,
/* 0x32e0 */  18,  0,  1,  0,190,  0,  0,  0,190,  0,  0,  0,  0,  0,  0,  0,
/* 0x32f0 */  16,  0, 11,  0,197,  0,  0,  0,254,  0,  0,  0,  0,  0,  0,  0,
/* 0x3300 */  16,  0, 11,  0,205,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3310 */  16,  0, 11,  0,214,  0,  0,  0,133,  0,  0,  0,  0,  0,  0,  0,
/* 0x3320 */  16,  0, 11,  0,219,  0,  0,  0, 94,  8,  0,  0, 84,  1,  0,  0,
/* 0x3330 */  18,  0,  1,  0,228,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0,
/* 0x3340 */  16,  0, 11,  0,  0,102, 95,101,120,112, 97,110,100,  0,103,101,
/* 0x3350 */ 116, 95,112, 97,103,101, 95,109, 97,115,107,  0,108,122,109, 97,
/* 0x3360 */  95,115,116, 97, 99,107, 95, 97,100,106,117,115,116,  0,108,122,
/* 0x3370 */ 109, 97, 95,112,114,111,112,101,114,116,105,101,115,  0,117,112,
/* 0x3380 */ 120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100,  0,109,101,
/* 0x3390 */ 109, 99,112,121,  0, 80,115,121,110, 99,  0,109,101,109,112, 99,
/* 0x33a0 */ 112,121,  0,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,
/* 0x33b0 */ 102,100, 95, 97,110,100,114,111,105,100,  0,109,109, 97,112,  0,
/* 0x33c0 */  95, 95, 99,108,101, 97,114, 95, 99, 97, 99,104,101,  0,117,112,
/* 0x33d0 */ 120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95,108,105,
/* 0x33e0 */ 110,117,120,  0,117,110, 97,109,101,  0,103,101,116, 95,117,112,
/* 0x33f0 */ 120,102,110, 95,112, 97,116,104,  0,117,110,100,101,114,108, 97,
/* 0x3400 */ 121,  0,109,101,109,115,101,116,  0,109,121, 95, 98,107,112,116,
/* 0x3410 */   0, 80,112,114,111,116,101, 99,116,  0,115,116, 97,116,  0,117,
/* 0x3420 */ 112,120, 95,109, 97,105,110,  0,109,107,100,105,114,  0,  0,  0,
/* 0x3430 */  26,  1,  0,  0,  2, 37,  0,  0, 47,  1,  0,  0,  2,  1,  0,  0,
/* 0x3440 */  54,  1,  0,  0,  2,  1,  0,  0, 97,  1,  0,  0,  2, 19,  0,  0,
/* 0x3450 */ 110,  1,  0,  0,  2,  1,  0,  0,118,  1,  0,  0,  2,  1,  0,  0,
/* 0x3460 */ 252,  1,  0,  0,  2, 18,  0,  0,  4,  3,  0,  0,  2, 23,  0,  0,
/* 0x3470 */  21,  3,  0,  0,  2, 27,  0,  0, 32,  3,  0,  0,  2, 23,  0,  0,
/* 0x3480 */ 153,  3,  0,  0,  2, 19,  0,  0,122,  4,  0,  0,  2, 27,  0,  0,
/* 0x3490 */ 221,  4,  0,  0,  2, 24,  0,  0,251,  4,  0,  0,  2, 27,  0,  0,
/* 0x34a0 */ 140,  5,  0,  0,  2, 27,  0,  0,179,  5,  0,  0,  2, 33,  0,  0,
/* 0x34b0 */ 218,  5,  0,  0,  2, 35,  0,  0,248,  5,  0,  0,  2, 22,  0,  0,
/* 0x34c0 */ 156,  6,  0,  0,  2, 19,  0,  0, 27,  7,  0,  0,  2, 27,  0,  0,
/* 0x34d0 */ 165,  7,  0,  0,  2, 27,  0,  0,  6,  8,  0,  0,  2, 22,  0,  0,
/* 0x34e0 */  72,  8,  0,  0,  2, 27,  0,  0,159,  8,  0,  0,  2, 19,  0,  0,
/* 0x34f0 */   1,  0,  0,  0,  2, 26,  0,  0,  1,  0,  0,  0,  2, 29,  0,  0,
/* 0x3500 */ 124,  0,  0,  0,  2, 34,  0,  0,241,  0,  0,  0,  2, 31,  0,  0,
/* 0x3510 */ 111,  1,  0,  0,  2, 19,  0,  0,224,  1,  0,  0,  2, 19,  0,  0,
/* 0x3520 */  18,  2,  0,  0,  2, 27,  0,  0, 73,  2,  0,  0,  2, 33,  0,  0,
/* 0x3530 */ 152,  2,  0,  0,  2, 34,  0,  0, 94,  3,  0,  0,  2, 34,  0,  0,
/* 0x3540 */ 146,  3,  0,  0,  2, 25,  0,  0,238,  3,  0,  0,  2, 25,  0,  0,
/* 0x3550 */ 141,  0,  0,  0,  2, 27,  0,  0,148,  0,  0,  0,  2, 19,  0,  0,
/* 0x3560 */   7,  0,  0,  0,  2, 19,  0,  0, 50,  0,  0,  0,  2, 19,  0,  0,
/* 0x3570 */ 203,  0,  0,  0,  2,  2,  0,  0,104,  0,  0,  0,  2,  3,  0,  0,
/* 0x3580 */ 191,  0,  0,  0,  2,  2,  0,  0,104,  0,  0,  0,  2,  3,  0,  0,
/* 0x3590 */ 171,  0,  0,  0,  2,  2,  0,  0, 85,  0,  0,  0,  2,  3,  0,  0,
/* 0x35a0 */   5,  0,  0,  0,  2,  4,  0,  0, 12,  0,  0,  0,  1, 20,  0,  0,
/* 0x35b0 */  50,  0,  0,  0,  1, 21,  0,  0,102,105,108,101, 32,102,111,114,
/* 0x35c0 */ 109, 97,116, 32,101,108,102, 51, 50, 45,105, 51, 56, 54, 10, 10,
/* 0x35d0 */  83,101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,
/* 0x35e0 */ 109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101,
/* 0x35f0 */  32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32,
/* 0x3600 */  76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,
/* 0x3610 */ 102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10,
/* 0x3620 */  32, 32, 48, 32, 46,116,101,120,116, 32, 32, 32, 32, 32, 32, 32,
/* 0x3630 */  32, 32, 48, 57, 98, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,
/* 0x3640 */  52, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3650 */  83, 10, 32, 32, 49, 32, 72, 85, 77, 70, 95, 65, 32, 32, 32, 32,
/* 0x3660 */  32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 57,
/* 0x3670 */ 101, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3680 */  84, 83, 10, 32, 32, 50, 32, 72, 85, 77, 70, 95, 76, 32, 32, 32,
/* 0x3690 */  32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x36a0 */  57,101, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x36b0 */  78, 84, 83, 10, 32, 32, 51, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x36c0 */  79, 73, 68, 32, 32, 32, 48, 52, 98,102, 32, 32, 48, 32, 32, 48,
/* 0x36d0 */  32, 32, 48, 57,102, 48, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79,
/* 0x36e0 */  78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32, 85, 77, 70, 95, 76,
/* 0x36f0 */  73, 78, 85, 88, 32, 32, 32, 32, 32, 48, 97,102, 32, 32, 48, 32,
/* 0x3700 */  32, 48, 32, 32, 48,101, 98, 48, 32, 32, 50, 42, 42, 50, 32, 32,
/* 0x3710 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32, 83, 89, 83,
/* 0x3720 */  67, 65, 76, 76, 83, 32, 32, 32, 32, 32, 32, 48, 49, 48, 48, 32,
/* 0x3730 */  32, 48, 32, 32, 48, 32, 32, 48,102, 54, 48, 32, 32, 50, 42, 42,
/* 0x3740 */  50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 54, 32,
/* 0x3750 */  69, 88, 80, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 49,
/* 0x3760 */  48, 98, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 48, 54, 48, 32,
/* 0x3770 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3780 */  32, 32, 55, 32, 69, 88, 80, 95, 84, 65, 73, 76, 32, 32, 32, 32,
/* 0x3790 */  32, 32, 48, 49, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 49,
/* 0x37a0 */  54, 99, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x37b0 */  84, 83, 10, 32, 32, 56, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32,
/* 0x37c0 */  32, 32, 32, 32, 32, 48,100, 52, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x37d0 */  48, 49, 49, 55, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x37e0 */  84, 69, 78, 84, 83, 10, 32, 32, 57, 32, 78, 82, 86, 50, 68, 32,
/* 0x37f0 */  32, 32, 32, 32, 32, 32, 32, 32, 48, 99, 56, 32, 32, 48, 32, 32,
/* 0x3800 */  48, 32, 32, 48, 49, 50, 53, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3810 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48, 32, 78, 82, 86,
/* 0x3820 */  50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 98, 52, 32, 32,
/* 0x3830 */  48, 32, 32, 48, 32, 32, 48, 49, 51, 49, 56, 32, 32, 50, 42, 42,
/* 0x3840 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 49, 32,
/* 0x3850 */  76, 90, 77, 65, 95, 68, 65, 73, 83, 89, 32, 32, 32, 32, 48, 99,
/* 0x3860 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 51, 99, 99, 32, 32, 50,
/* 0x3870 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49,
/* 0x3880 */  50, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 32, 32, 32, 32,
/* 0x3890 */  48, 51, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 51,100, 56,
/* 0x38a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x38b0 */  10, 32, 49, 51, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32,
/* 0x38c0 */  32, 32, 32, 48, 52, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x38d0 */  52, 48,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x38e0 */  78, 84, 83, 10, 32, 49, 52, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x38f0 */  49, 48, 32, 32, 32, 32, 48, 98, 51,101, 32, 32, 48, 32, 32, 48,
/* 0x3900 */  32, 32, 48, 49, 52, 53, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3910 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 53, 32, 76, 90, 77, 65,
/* 0x3920 */  95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 98, 51,101, 32, 32,
/* 0x3930 */  48, 32, 32, 48, 32, 32, 48, 49,102, 57, 52, 32, 32, 50, 42, 42,
/* 0x3940 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 54, 32,
/* 0x3950 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 50,
/* 0x3960 */  48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 97,100, 50, 32, 32,
/* 0x3970 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83,
/* 0x3980 */  89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48,
/* 0x3990 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 89,
/* 0x39a0 */  83, 67, 65, 76, 76, 83, 32, 48, 32, 83, 89, 83, 67, 65, 76, 76,
/* 0x39b0 */  83, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x39c0 */ 100, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32, 48, 32, 69, 88,
/* 0x39d0 */  80, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x39e0 */ 108, 32, 32, 32, 32,100, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76,
/* 0x39f0 */  32, 48, 32, 69, 88, 80, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48,
/* 0x3a00 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77,
/* 0x3a10 */  65, 95, 68, 69, 67, 51, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68,
/* 0x3a20 */  69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3a30 */  32, 32, 32,100, 32, 32, 46,116,101,120,116, 32, 48, 32, 46,116,
/* 0x3a40 */ 101,120,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3a50 */  32, 32,100, 32, 32, 72, 85, 77, 70, 95, 65, 32, 48, 32, 72, 85,
/* 0x3a60 */  77, 70, 95, 65, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3a70 */  32, 32, 32,100, 32, 32, 72, 85, 77, 70, 95, 76, 32, 48, 32, 72,
/* 0x3a80 */  85, 77, 70, 95, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3a90 */  32, 32, 32, 32,100, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x3aa0 */  73, 68, 32, 48, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x3ab0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3ac0 */  32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 48, 32, 85, 77,
/* 0x3ad0 */  70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ae0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69, 32, 48,
/* 0x3af0 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3b00 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68, 32, 48, 32,
/* 0x3b10 */  78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3b20 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66, 32, 48, 32, 78,
/* 0x3b30 */  82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3b40 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89,
/* 0x3b50 */  32, 48, 32, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89, 10, 48, 48,
/* 0x3b60 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x3b70 */  90, 77, 65, 95, 68, 69, 67, 48, 48, 32, 48, 32, 76, 90, 77, 65,
/* 0x3b80 */  95, 68, 69, 67, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3b90 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70,
/* 0x3ba0 */  48, 48, 32, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10,
/* 0x3bb0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3bc0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90,
/* 0x3bd0 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3be0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3bf0 */  69, 67, 50, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x3c00 */  48, 10, 48, 48, 48, 48, 48, 48, 54, 55, 32,103, 32, 32, 32, 32,
/* 0x3c10 */  32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32, 48, 32,102, 95,
/* 0x3c20 */ 101,120,112, 97,110,100, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32,
/* 0x3c30 */ 103, 32, 32, 32, 32, 32, 32, 32, 46,116,101,120,116, 32, 48, 32,
/* 0x3c40 */ 103,101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10, 48, 48,
/* 0x3c50 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x3c60 */  85, 78, 68, 42, 32, 48, 32,108,122,109, 97, 95,115,116, 97, 99,
/* 0x3c70 */ 107, 95, 97,100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c80 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x3c90 */  48, 32,108,122,109, 97, 95,112,114,111,112,101,114,116,105,101,
/* 0x3ca0 */ 115, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32,103, 32, 32, 32, 32,
/* 0x3cb0 */  32, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 32, 48, 32,117,112,
/* 0x3cc0 */ 120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 10, 48, 48,
/* 0x3cd0 */  48, 48, 48, 48,100, 50, 32,103, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x3ce0 */  89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,101,109, 99,112,121,
/* 0x3cf0 */  10, 48, 48, 48, 48, 48, 48, 50, 98, 32,103, 32, 32, 32, 32, 32,
/* 0x3d00 */  32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32, 80,115,121,
/* 0x3d10 */ 110, 99, 10, 48, 48, 48, 48, 48, 48,101, 56, 32,103, 32, 32, 32,
/* 0x3d20 */  32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,
/* 0x3d30 */ 101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3d40 */ 103, 32, 32, 32, 32, 32, 70, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x3d50 */  79, 73, 68, 32, 48, 50, 51, 53, 32,117,112,120, 95,109,109, 97,
/* 0x3d60 */ 112, 95, 97,110,100, 95,102,100, 95, 97,110,100,114,111,105,100,
/* 0x3d70 */  10, 48, 48, 48, 48, 48, 48, 53, 54, 32,103, 32, 32, 32, 32, 32,
/* 0x3d80 */  32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,109, 97,
/* 0x3d90 */ 112, 10, 48, 48, 48, 48, 48, 48, 57, 55, 32,103, 32, 32, 32, 32,
/* 0x3da0 */  32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32, 48, 32, 95, 95,
/* 0x3db0 */  99,108,101, 97,114, 95, 99, 97, 99,104,101, 10, 48, 48, 48, 48,
/* 0x3dc0 */  48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 85, 77, 70,
/* 0x3dd0 */  95, 76, 73, 78, 85, 88, 32, 48, 97,102, 32,117,112,120, 95,109,
/* 0x3de0 */ 109, 97,112, 95, 97,110,100, 95,102,100, 95,108,105,110,117,120,
/* 0x3df0 */  10, 48, 48, 48, 48, 48, 48, 57, 57, 32,103, 32, 32, 32, 32, 32,
/* 0x3e00 */  32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,117,110, 97,
/* 0x3e10 */ 109,101, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32,103, 32, 32, 32,
/* 0x3e20 */  32, 32, 32, 32, 46,116,101,120,116, 32, 48, 32,103,101,116, 95,
/* 0x3e30 */ 117,112,120,102,110, 95,112, 97,116,104, 10, 48, 48, 48, 48, 48,
/* 0x3e40 */  50,101, 56, 32,103, 32, 32, 32, 32, 32, 70, 32, 46,116,101,120,
/* 0x3e50 */ 116, 32, 48, 52, 55, 32,117,110,100,101,114,108, 97,121, 10, 48,
/* 0x3e60 */  48, 48, 48, 48, 48, 98,101, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x3e70 */  83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,101,109,115,101,
/* 0x3e80 */ 116, 10, 48, 48, 48, 48, 48, 48,102,101, 32,103, 32, 32, 32, 32,
/* 0x3e90 */  32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,121,
/* 0x3ea0 */  95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103,
/* 0x3eb0 */  32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32,
/* 0x3ec0 */  48, 32, 80,112,114,111,116,101, 99,116, 10, 48, 48, 48, 48, 48,
/* 0x3ed0 */  48, 56, 53, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67,
/* 0x3ee0 */  65, 76, 76, 83, 32, 48, 32,115,116, 97,116, 10, 48, 48, 48, 48,
/* 0x3ef0 */  48, 56, 53,101, 32,103, 32, 32, 32, 32, 32, 70, 32, 46,116,101,
/* 0x3f00 */ 120,116, 32, 48, 49, 53, 52, 32,117,112,120, 95,109, 97,105,110,
/* 0x3f10 */  10, 48, 48, 48, 48, 48, 48, 97, 97, 32,103, 32, 32, 32, 32, 32,
/* 0x3f20 */  32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,107,100,
/* 0x3f30 */ 105,114, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x3f40 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 46,116,101,120,
/* 0x3f50 */ 116, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x3f60 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x3f70 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 49, 49, 97, 32, 82, 95,
/* 0x3f80 */  51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3f90 */ 117,112,120, 95,109, 97,105,110, 10, 48, 48, 48, 48, 48, 49, 50,
/* 0x3fa0 */ 102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x3fb0 */  32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 10, 48, 48, 48,
/* 0x3fc0 */  48, 48, 49, 51, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,
/* 0x3fd0 */  32, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83,
/* 0x3fe0 */  10, 48, 48, 48, 48, 48, 49, 54, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x3ff0 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,103,101,116, 95,
/* 0x4000 */ 112, 97,103,101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 49,
/* 0x4010 */  54,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x4020 */  32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 10, 48, 48,
/* 0x4030 */  48, 48, 48, 49, 55, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x4040 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76,
/* 0x4050 */  83, 10, 48, 48, 48, 48, 48, 49,102, 99, 32, 82, 95, 51, 56, 54,
/* 0x4060 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,102, 95,101,
/* 0x4070 */ 120,112, 97,110,100, 10, 48, 48, 48, 48, 48, 51, 48, 52, 32, 82,
/* 0x4080 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x4090 */  32,109,101,109, 99,112,121, 10, 48, 48, 48, 48, 48, 51, 49, 53,
/* 0x40a0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x40b0 */  32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 51, 50, 48,
/* 0x40c0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x40d0 */  32, 32, 32,109,101,109, 99,112,121, 10, 48, 48, 48, 48, 48, 51,
/* 0x40e0 */  57, 57, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x40f0 */  32, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,
/* 0x4100 */ 115,107, 10, 48, 48, 48, 48, 48, 52, 55, 97, 32, 82, 95, 51, 56,
/* 0x4110 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,109,
/* 0x4120 */  97,112, 10, 48, 48, 48, 48, 48, 52,100,100, 32, 82, 95, 51, 56,
/* 0x4130 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 80,115,
/* 0x4140 */ 121,110, 99, 10, 48, 48, 48, 48, 48, 52,102, 98, 32, 82, 95, 51,
/* 0x4150 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,
/* 0x4160 */ 109, 97,112, 10, 48, 48, 48, 48, 48, 53, 56, 99, 32, 82, 95, 51,
/* 0x4170 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,
/* 0x4180 */ 109, 97,112, 10, 48, 48, 48, 48, 48, 53, 98, 51, 32, 82, 95, 51,
/* 0x4190 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,
/* 0x41a0 */ 101,109,115,101,116, 10, 48, 48, 48, 48, 48, 53,100, 97, 32, 82,
/* 0x41b0 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x41c0 */  32, 80,112,114,111,116,101, 99,116, 10, 48, 48, 48, 48, 48, 53,
/* 0x41d0 */ 102, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x41e0 */  32, 32, 32, 32, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,
/* 0x41f0 */ 100, 95,102,100, 10, 48, 48, 48, 48, 48, 54, 57, 99, 32, 82, 95,
/* 0x4200 */  51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4210 */ 103,101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10, 48, 48,
/* 0x4220 */  48, 48, 48, 55, 49, 98, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x4230 */  50, 32, 32, 32, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48,
/* 0x4240 */  48, 48, 48, 55, 97, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x4250 */  50, 32, 32, 32, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48,
/* 0x4260 */  48, 48, 48, 56, 48, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x4270 */  50, 32, 32, 32, 32, 32, 32, 32, 32,117,112,120, 95,109,109, 97,
/* 0x4280 */ 112, 95, 97,110,100, 95,102,100, 10, 48, 48, 48, 48, 48, 56, 52,
/* 0x4290 */  56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x42a0 */  32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 56, 57,
/* 0x42b0 */ 102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x42c0 */  32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,
/* 0x42d0 */ 107, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x42e0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 72, 85, 77, 70, 95,
/* 0x42f0 */  65, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x4300 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x4310 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,
/* 0x4320 */  51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4330 */ 117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95,
/* 0x4340 */  97,110,100,114,111,105,100, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4350 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4360 */  91, 72, 85, 77, 70, 95, 76, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x4370 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4380 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x4390 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32,
/* 0x43a0 */  32, 32, 32, 32, 32, 32,117,112,120, 95,109,109, 97,112, 95, 97,
/* 0x43b0 */ 110,100, 95,102,100, 95,108,105,110,117,120, 10, 10, 82, 69, 76,
/* 0x43c0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x43d0 */  70, 79, 82, 32, 91, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x43e0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x43f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4400 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 55, 99, 32, 82, 95, 51,
/* 0x4410 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,
/* 0x4420 */ 121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 48,102, 49, 32,
/* 0x4430 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x4440 */  32, 32,103,101,116, 95,117,112,120,102,110, 95,112, 97,116,104,
/* 0x4450 */  10, 48, 48, 48, 48, 48, 49, 54,102, 32, 82, 95, 51, 56, 54, 95,
/* 0x4460 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,103,101,116, 95,
/* 0x4470 */ 112, 97,103,101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 49,
/* 0x4480 */ 101, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x4490 */  32, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,
/* 0x44a0 */ 115,107, 10, 48, 48, 48, 48, 48, 50, 49, 50, 32, 82, 95, 51, 56,
/* 0x44b0 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,109,
/* 0x44c0 */  97,112, 10, 48, 48, 48, 48, 48, 50, 52, 57, 32, 82, 95, 51, 56,
/* 0x44d0 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,101,
/* 0x44e0 */ 109,115,101,116, 10, 48, 48, 48, 48, 48, 50, 57, 56, 32, 82, 95,
/* 0x44f0 */  51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4500 */ 109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 51, 53,101,
/* 0x4510 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x4520 */  32, 32, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48,
/* 0x4530 */  51, 57, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32,
/* 0x4540 */  32, 32, 32, 32, 32, 32,109,101,109,112, 99,112,121, 10, 48, 48,
/* 0x4550 */  48, 48, 48, 51,101,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x4560 */  50, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112, 99,112,121,
/* 0x4570 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x4580 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 85, 77, 70, 95, 76, 73,
/* 0x4590 */  78, 85, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x45a0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x45b0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 56,100, 32,
/* 0x45c0 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x45d0 */  32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32,
/* 0x45e0 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x45f0 */  32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10,
/* 0x4600 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x4610 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 83, 89, 83, 67, 65, 76, 76,
/* 0x4620 */  83, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x4630 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x4640 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 55, 32, 82, 95,
/* 0x4650 */  51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4660 */ 103,101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10, 48, 48,
/* 0x4670 */  48, 48, 48, 48, 51, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x4680 */  50, 32, 32, 32, 32, 32, 32, 32, 32,103,101,116, 95,112, 97,103,
/* 0x4690 */ 101, 95,109, 97,115,107, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x46a0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x46b0 */  78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x46c0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x46d0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 99,
/* 0x46e0 */  98, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x46f0 */  32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 10, 48, 48, 48,
/* 0x4700 */  48, 48, 48, 54, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,
/* 0x4710 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76,
/* 0x4720 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x4730 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93,
/* 0x4740 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x4750 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4760 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 98,102, 32, 82, 95, 51, 56,
/* 0x4770 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 69, 88,
/* 0x4780 */  80, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 54, 56, 32,
/* 0x4790 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x47a0 */  32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 10, 10, 82, 69, 76, 79,
/* 0x47b0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x47c0 */  79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83,
/* 0x47d0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x47e0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x47f0 */  48, 48, 48, 97, 98, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,
/* 0x4800 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68,
/* 0x4810 */  10, 48, 48, 48, 48, 48, 48, 53, 53, 32, 82, 95, 51, 56, 54, 95,
/* 0x4820 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95,
/* 0x4830 */  84, 65, 73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4840 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90,
/* 0x4850 */  77, 65, 95, 68, 65, 73, 83, 89, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x4860 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4870 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x4880 */  48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x4890 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x48a0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x48b0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95,
/* 0x48c0 */  68, 69, 67, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x48d0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x48e0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x48f0 */  99, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x4900 */  32, 32, 32, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,
/* 0x4910 */ 100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 51, 50, 32, 82,
/* 0x4920 */  95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4930 */  32,108,122,109, 97, 95,112,114,111,112,101,114,116,105,101,115,
/* 0x4940 */  10
};
