---
title: 0.14.0
description: Changes in Typst 0.14.0
---

# Version 0.14.0 (October 24, 2025) { #v0.14.0 }

## Highlights
- Typst now produces [_accessible_ PDFs]($guides/accessibility) out of the box, with opt-in support for stricter checks and conformance to PDF/UA-1
- Typst now supports all [PDF/A standards]($pdf/#pdf-a)
- PDFs can now be used as [images]($image.format) (thanks to [@LaurenzV](https://github.com/LaurenzV))
- Added support for [character-level justification]($par.justification-limits) (can significantly improve the appearance of justified text)
- Added support for many more built-in elements in HTML export
- Added typed HTML API (e.g. [`html.div`]) with individually typed attributes
- Added support for multiple [headers]($table.header) and subheaders in tables
- Added [`title`] element for displaying the document title
- Added [`frac.style`]($math.frac.style) property for producing skewed and inline fractions

## PDF export
PDF export was fully rewritten to use the new [`krilla`](https://github.com/LaurenzV/krilla) library, fixing various bugs and enabling many improvements. Known fixes are listed below, but there will likely be other changes in how the output behaves. If you spot any regressions, please [report them on GitHub](https://github.com/typst/typst/issues). _(Thanks to [@LaurenzV](https://github.com/LaurenzV) for creating krilla!)_ [#5420]

- Typst now produces _accessible_ PDFs out of the box. Such documents are suitable for consumption in a wide range of circumstances. That not only includes consumption by people with permanent or temporary disabilities, but also by those with different devices or preferences.
  - Typst PDFs are now _tagged_ by default. _Tags_ are rich metadata that PDF viewers can use to make the document consumable in other ways than visually (e.g., through a screen reader).
  - In addition, Typst can now emit documents conforming to the PDF/UA-1 standard. (PDF/UA-2 is not yet supported, but planned.)
  - There is an increasing amount of existing and upcoming legislation requiring documents to be accessible, for instance, the European Accessibility Act and the Americans with Disabilities Act.
  - For more details on all of this, read the new [Accessibility Guide]($guides/accessibility).
- Typst now supports all PDF/A standards: PDF/A-1b, PDF/A-1a, PDF/A-2b, PDF/A-2u, PDF/A-2a, PDF/A-3b, PDF/A-3u, PDF/A-3a, PDF/A-4, PDF/A-4f, and PDF/A-4e. See the [expanded PDF/A documentation]($pdf/#pdf-a) for guidance on how to select a suitable standard. [#5420] [#7038]
- Typst now supports the PDF versions 1.4, 1.5, 1.6, and 2.0 in addition to PDF 1.7. See the [relevant section of the PDF documentation]($pdf/#pdf-versions) for details. [#5420]
- Added [`pdf.artifact`] function for marking content as not semantically meaningful [#6619]
- Added experimental [`pdf.header-cell`], [`pdf.data-cell`], and [`pdf.table-summary`] functions for enhancing accessibility of documents with complex tables. These functions are guarded by the `a11y-extras` feature. They do not have a final interface and will be removed in the future, either through integration into table functions or through full removal. [#6619]
- PDF heading bookmarks now contain the heading's numbering [#6622]
- [Attachments]($pdf.attach)
  - Renamed `pdf.embed` to [`pdf.attach`] (the old name will remain as a deprecated alias until Typst 0.15) [#6705]
  - The [`mime`]($pdf.attach.mime-type) property of `pdf.attach` is now checked for syntactical correctness **(Minor breaking change)**
  - Fixed parsing of the [`data`]($pdf.attach.data) argument of `pdf.attach` [#6435]
  - Attachments now smartly determine whether they should be compressed [#6256]
- Text extraction (i.e. copy paste)
  - Now works correctly even when multiple different characters result in the same glyph [#5420]
  - Spaces between words at which a natural line break occurred are now correctly retained for text extraction [#6866]
  - Fixed mapping of hyphenation artifacts to Unicode text [#6799]
- Images
  - CMYK images now work properly in PDF export [#5420]
  - Improved export of text in SVG images with a filter [#5420]
  - Improved compatibility of SVG images with Quartz rendering engine (the engine used in Apple Preview) [#5420]
  - Improved handling of SVG images with high group nesting depth [#5420]
- Fixed a bug with text in patterns [#5420]
- Fixed gradients with transparency [#5420]

## HTML export
- Added support for many more built-in elements (the [_Model_ category]($category/model) is now fully covered)
  - The [`image`] element [#6578]
  - The [`footnote`] and [`footnote.entry`] element [#6917]
  - The [`outline`] and [`outline.entry`] element [#6606]
  - The [`bibliography`] element [#6952]
  - The [`smartquote`] element [#6710]
  - The [`sub`] and [`super`] elements [#6422]
  - The [`underline`], [`overline`], [`strike`], and [`highlight`] elements [#6510]
  - The [`smallcaps`] element [#6600]
  - The [`lower`] and [`upper`] functions [#6585]
- Added typed HTML API (e.g. [`html.div`]) with individually typed attributes [#6476]
  - For example, to generate a `video` element you can now write `[#html.video(width: 400, src: "sunrise.mp4")]` instead of `[#html.elem("video", attrs: (width: "400", src: "sunrise.mp4"))]`. Note how the `width` attribute takes an integer instead of a string.
- Added support for intra-doc [`link`] targets [#6602]
- The [`raw`] element
  - Added syntax highlighting support [#6691]
  - Block-level `raw` elements now emit both a `<code>` and a `<pre>` tag [#6701]
  - The [language tag]($raw.lang) of `raw` elements is now preserved as a `data-lang` attribute on the `<code>` tag [#6702]
- The [`authors`]($document.author) and [`keywords`]($document.keywords) properties of the `document` function now yield corresponding HTML `<meta>` tags [#6134]
- The [`html.elem`] function now supports custom HTML element names [#6676]
- Improved encoding of [`html.frame`] [#6605]
- Empty attributes are now encoded with shorthand syntax (e.g. `<div hidden></div>`) [#6479]
- Zero-sized horizontal weak spacing (`{h(0pt, weak: true)}`) does not cause a "was ignored during HTML export" warning anymore, so it can be used to destruct surrounding spaces without producing any output, as in paged export [#6917]
- Fixed encoding of `<pre>` and `<textarea>` elements that start with a newline [#6487] [#6497]
- Fixed encoding of [raw text elements](https://html.spec.whatwg.org/#raw-text-elements) [#6487] [#6720]
- Fixed sizing of [`html.frame`] [#6505]
- Fixed [`measure`] in HTML export [#7186]
- Fixed nested [`html.frame`s]($html.frame) [#6509]
- Fixed that a [`box`] without a body was ignored in HTML export [#6709]
- Fixed encoding of whitespace in HTML [#6750]

## SVG export
- Added support for COLR-flavored color glyphs [#6693]
- Reduced amount of `<g>` grouping elements that are generated [#6247]

## PNG export
- Fixed crash when [text size]($text.size) is negative [#5940]

## Visualize
- Added support for using PDFs as [images]($image) using the new [`hayro`](https://github.com/LaurenzV/hayro) library. PDFs will be embedded directly in PDF export, rasterized in PNG export, and turned into SVGs in SVG and HTML export. _(Thanks to [@LaurenzV](https://github.com/LaurenzV) for creating hayro!)_ [#6623]
- Added support for WebP images [#6311]
- Various minor improvements for SVG images (see the [resvg 0.44 and 0.45 changelogs](https://github.com/linebender/resvg/blob/v0.45.1/CHANGELOG.md#0450---2025-02-26))
- SVG images can now refer to external image files [#6794]
- Clip paths are now properly anti-aliased [#6570]
- Fixed gradients on curves where the last segment is [`curve.line`] [#6647]
- Fixed stroke cap handling of shapes with partial strokes [#5688]
- Fixed corner radius handling of shapes with partial strokes [#6976]
- Fixed crash when sampling across two coinciding gradient stops [#6166]

## Layout
- Added opt-in support for character-level justification in addition to word-level justification, configured via the new [`par.justification-limits`] property. This is an impactful microtypographical technique that can significantly improve the appearance of justified text. [#6161]
- Fixed wrong linebreak opportunities related to object replacement characters [#6251]
- Fixed an issue where a breakable block would still produce an empty segment even if nothing fit into the first segment, leading to various undesirable behaviors in combination with fills, strokes, and [stickiness]($block.sticky) [#6335]
- Fixed crash with set rule for column or rowspan on a grid cell [#6401]
- Fixed [CJK-Latin-spacing]($text.cjk-latin-spacing) at manual line breaks [#6700] and at sub- and superscript boundaries [#7175]

## Math
- Added [`frac.style`]($math.frac.style) property with new options for skewed and inline fractions [#6672]
- Added [`math.equation.alt`] property for setting an alternative description for an equation [#6619]
- Text handling
  - A single equation can now use multiple fonts [#6365]
  - Glyph layout in math now uses proper text shaping, leading to better handling of more complex Unicode features [#6336]
  - Generated characters in an equation (e.g. the `√` produced by `sqrt`) can now be targeted by text show rules [#6365]
  - Added [`scr`]($math.scr) function for roundhand script font style [#6309]
  - Added `dotless` parameter to [`accent`]($math.accent) (typically for rendering a dotless accented i or j) [#5939]
  - Script-style glyphs are now preferred at reduced math sizes [#6320]
  - Fixed [`text.stroke`] in math [#6243]
  - Broken glyph assemblies are now prevented even when font data is incorrect [#6688]
- Layout
  - Fixed a bug with vertical accent positioning [#5941]
  - Fixed positioning of bottom accents [#6187]
  - Fixed a bug with layout of roots [#6021]
  - Improved layout of [`vec`]($math.vec) and [`cases`]($math.cases), making it consistent with [`mat`]($math.mat) [#5934]
  - Removed linebreak opportunity before closing bracket in inline math [#6216]
- An [`augment`]($math.mat.augment) line can now exist at the start and end of a matrix, not only in between columns and rows [#5806]
- Shorthands and multi-character numbers do not bind more tightly than fractions anymore in cases like `[$x>=(y)/z$]` [#5925] [#5996] **(Minor breaking change)**
- Named arguments passed to symbols used as function now raise an error instead of being silently ignored [#6192] **(Minor breaking change)**
- The [`mid`]($math.mid) element does not force the [`{"large"}` math class]($math.class) upon its contents anymore and instead defaults to `{"relation"}` [#5980]
- Fixed error in math parsing when `..` isn't followed by anything [#7105]
- Fixed the default math class of ⅋, ⎰, ⟅, ⎱, ⟆, ⟇, and ، [#5949] [#6537]

_Thanks to [@mkorje](https://github.com/mkorje) for his work on math!_

## Model
- Tables
  - Added support for multiple [headers]($table.header) and subheaders in tables [#6168]
  - Table headers now force a rowbreak, i.e. an incomplete row before a header will not be filled with cells after the header [#6687]
  - Fixed a bug where [headers]($table.header) and footers could accidentally expand to contain non-header cells [#5919]
- Added [`title`] element for displaying the document title [#5618]
- Added [`figure.alt`] property for setting an alternative description for a figure [#6619]
- [Link]($link) hit boxes for text are now vertically a bit larger to avoid issues with automatic link detection in PDF viewers [#6252]
- The [`link`] function will now produce an error when passed an empty string as a URL [#7049] **(Minor breaking change)**
- The value of the [`number`]($enum.item.number) argument of `enum.item` now takes `{auto}` instead of `{none}` for automatic numbering [#6609] **(Minor breaking change)**
- Improved spacing of nested tight lists [#6242]
- Fixed that `{quotes: false}` was ignored for [inline-level quotes]($quote.block) [#5991]
- Fixed [hanging indent]($heading.hanging-indent) for centered, numbered headings [#6839]
- Fixed [`footnote.entry`] show rules breaking links from footnote to entry [#6912]
- Hebrew numbering does not add Geresh and Gershayim anymore [#6122]

## Bibliography
- Built-in styles
  - Updated styles to their latest upstream CSL versions [typst/hayagriva#350]
  - Renamed `{"chicago-fullnotes"}` to `{"chicago-notes"}` (the old name remains as a deprecated alias) [#6920]
  - Renamed `{"modern-humanities-research-association"}` to `{"modern-humanities-research-association-notes"}` (the old name remains as a deprecated alias) [#6994]
  - Added support for locator/supplement in alphanumeric style [typst/hayagriva#307]

- Hayagriva format
  - Added [`chapter` field](https://github.com/typst/hayagriva/blob/v0.9.1/docs/file-format.md#chapter) corresponding to CSL `chapter-number` and BibLaTeX `chapter` [typst/hayagriva#383]

- BibLaTeX format
  - Fixed parsing of alphanumeric page ranges [typst/biblatex#86]
  - Added support for `%` comment syntax [typst/biblatex#80]
  - Fixed parsing of space-separated single character commands [typst/biblatex#71]
  - Added "primaryclass" alias for "eprintclass" field [typst/biblatex#75]
  - Added support for BibLaTeX `language` field [typst/hayagriva#317]
  - Improved translation of BibLaTeX fields to `genre` and `serial-number` [typst/hayagriva#296] [typst/hayagriva#369]

- CSL handling
  - The bibliography rendering now uses [`strong`], [`emph`], and [`smallcaps`] to express CSL font styling instead of directly adjusting the [`text`] style, making styling easier [#6984]
  - Added support for date seasons, which are displayed when the month is missing [typst/hayagriva#391]
  - Terms for "AD" and "BC" are now correctly used from the chosen locale [typst/hayagriva#364]
  - Fixed how subsequent citations with differing supplements translate into CSL `ibid` and `ibid-with-locator` positions [#6171]
  - Fixed handling of `ibid` and `ibid-with-locator` positions in styles [typst/hayagriva#301]
  - Fixed the `location` conditional in CSL styles for citations with no locator [typst/hayagriva#399]
  - Fixed accesses of the year suffix resulting in wrong CSL renders [typst/hayagriva#400]
  - Fixed regression where page variables were no longer supported in styles' `<number>` elements [typst/hayagriva#289]
  - Fixed sorting and formatting of name parts [typst/hayagriva#287] [typst/hayagriva#313]
  - Fixed year suffix collapsing [typst/hayagriva#367]
  - Fixed delimiters in locale-specific date formatting [typst/hayagriva#385]
  - Fixed rendering of date ordinals [typst/hayagriva#366]
  - Fixed rendering and sorting of dates with BC years [typst/hayagriva#334] [typst/hayagriva#368]
  - Fixed sorting for empty sort values [typst/hayagriva#390]

## Text
- The [`sub`] and [`super`] functions now use the `subs` and `sups` OpenType font features instead of special Unicode characters for typographic scripts, fixing semantical, sizing, and positioning issues [#5777]
- The [`raw`] element
  - Tweaked default syntax-highlighting color scheme of [`raw`] text to make the colors more accessible [#6754]
  - JSON keys and string values now use different colors in the default `raw` syntax highlighting [theme]($raw.theme) [#6873]
  - Fixed a crash when a `raw` [syntax]($raw.syntaxes) contains an unescaped trailing backslash [#6883]
  - Fixed tab indentation in [`raw`] text with CRLF line terminators [#6961]
- Translations
  - Added term translations (a term being the "Section" in "Section 1") for many new languages by importing pre-existing translations from LaTeX packages [#6852]
  - Added term translations for Indonesian [#6108], Latvian [#6348], Croatian [#6413], Lithuanian [#6587], French [#7010], French (Canada) [#7098], Galician [#7019], Dutch [#7026], Danish [#7031], Slovenian [#7032], Italian [#7050], Chinese [#7044], Spanish [#7051], and Irish (Gaeilge) [#7024]
  - Improved term translations for Czech [#6101], Swedish [#6519], Galician [#7019], Dutch [#7026], Chinese [#7044], Spanish [#7051], Irish (Gaeilge) [#7024], and German [#7082]
  - Improved smart quotes for French [#5976], Ukrainian [#6372], Russian [#6331], and Arabic [#6626]
- An empty font list is not allowed anymore in [`text.font`] [#6049] **(Minor breaking change)**
- Added a warning when using a variable font as those are not currently supported [#6425]
- Fixed usage of the same font with different [coverage]($text.font) settings [#6604]
- Fixed hyphens not showing up when hyphenating at specific positions (where invisible metadata exists) [#6807]
- Fixed styling of repeated hyphens in languages with hyphen repetition [#6798]
- Last resort font fallback does not consider default ignorable characters anymore during font selection [#6805]
- Updated New Computer Modern fonts to version 7.0.4 [#6376]
- Updated data and shaper to Unicode 16.0.0 [#5407]

## Scripting
- The `{in}` operator can now be used to check whether a definition is present in a module [#6498]
- Added `default` parameter to [`array.first`], [`array.last`] [#5970], [`array.join`] [#6932], [`str.first`], and [`str.last`] [#6554] methods
- Added `by` parameter to [`array.sorted`] for sorting with a comparison function [#5627]
- Added [`str.normalize`] function for Unicode normalization [#5631]
- Added [`from`]($direction.from), [`to`]($direction.to), and [`sign`]($direction.sign) methods to `direction` type [#5893]
- [Labels]($label) cannot be empty anymore [#6332] **(Minor breaking change)**
- The WebAssembly runtime used by the [`plugin`] system was updated and now supports SIMD [#6997]
- Numberings and counters now use 64-bit numbers instead of platform-dependant numbers for consistency across platforms [#6026]
- Improved consistency of how large numbers are handled in data loading functions [#6836]
- The [`toml`] function is now guaranteed to return a [dictionary] and [`toml.encode`] must receive a dictionary (it already errored before when passed something else, but the new function signature makes the error clearer) [#6743]
- Serialization of [`bytes`] in human-readable formats now uses [`repr`] [#6743]
- Fixed slicing of last N elements of an array using the [`count`]($array.slice.count) parameter [#6838]
- Fixed crash when the expression wrapped in a `{context}` expression is an anonymous function [#6975]
- Fixed equality check between [`raw.line`] elements [#6560]
- Fixed [`repr`] of [labels]($label) being potentially syntactically invalid [#6456]
- Fixed [`repr`] of functions modified through [`with`]($function.with) [#6773]

## Introspection
- The following elements are newly locatable (i.e. they can be discovered with [`query`], [`locate`], etc. without having a label): `par`, `table`, `enum`, `list`, `terms`, `title`, `figure.caption`, `footnote.entry`, `outline.entry`, `image`, `emph`, `strong`, `link`, `cite`, `raw`, `underline`, `overline`, `strike`, and `highlight` [#6619]
- Fixed issues with logical order in bidirectional text [#5887] [#6796]
- Fixed logical order of cells in right-to-left [`grid`] [#6232]
- Fixed logical order of elements in [`grid`] cells that span multiple pages [#7198]
- Fixed logical order of metadata at the starts and ends of paragraphs [#6881] [#6909]
- Fixed introspection [positions]($location.position) of inline elements at the very start of a paragraph (previously the Y position of an element at the very start would differ from one in the middle of the first line) [#6881]

## Styling
- Fixed rare infinite loop in show rule application [#6259]

## Performance
- Optimized incremental compilation with a new algorithm that, in particular, eliminates cases of very slow compilation with heavy context usage [#6683]

## Command Line Interface
- Added `typst info` subcommand for emitting build and environment information [#6761]
- Added `typst completions` subcommand for retrieving shell completions [#6568]
- Added `TYPST_IGNORE_SYSTEM_FONTS` environment variable [#6092]
- Added `--ignore-embedded-fonts` flag and `TYPST_IGNORE_EMBEDDED_FONTS` environment variable for disabling the use of fonts embedded into the Typst binary [#7037]
- Added `--no-pdf-tags` flag for disabling the automatic generation of accessibility tags. These are emitted when no particular standard like PDF/UA-1 is selected to provide a baseline of accessibility. [#6619]
- Added `--target` parameter to `typst query` [#6405]
- Added `--deps` and `--deps-format` parameters for emitting a list of files compilation depends on. Supports the three formats `json`, `zero`, and `make`. [#7022]
- Deprecated the `--make-deps` flag in favor of `--deps` with `--deps-format make` [#7022]
- On Linux, the font search will now fall back to known font directories if none were loaded via Fontconfig. [RazrFalcon/fontdb#71]
- The CLI will now warn when trying to watch the standard input [#6381]
- Fixed race condition when two separate Typst CLI processes concurrently try to install a package [#5979]
- Fixed incremental SVG export not writing output SVGs on changes that only affect the page (e.g. changing `page.fill`) [#6810]
- Fixed a rare potential crash when stack space couldn't be grown as expected [#6969]

## Tooling and Diagnostics
- Errors in many kinds of external text files (e.g., bibliographies, JSON files, etc.) are now annotated within these files instead of at the positions where the files are loaded from a Typst file [#6308]
- Warnings originating from within [`eval`] are now correctly emitted [#6100]
- Diagnostic messages and hints
  - Improved error messages related to parsing of numbers [#5969]
  - The error message for an unsuitable CSL style now mentions the name of the style [#6306]
  - Added hints to various deprecated items with the removal timeline [#6617]
  - Added hint for the error message when an X/Y pair is expected [#6476]
  - Added hint for a label that appears in both the document and the bibliography [#6457]
  - Added additional hint for show rule recursion depth error [#5856]
  - Fixed inconsistent formatting of code points and strings in error messages [#6487]
- Autocompletion
  - Labels will now be deduplicated in completions [#6516]
  - Math font autocompletions are now based on the presence of an OpenType MATH table instead of the word "Math" in the name [#6316]
  - Autocompletion immediately after a comma in a parameter list is now supported for explicitly triggered completions (e.g. via Ctrl/Cmd+Space) [#6550]
  - Citation style aliases are now displayed as autocompletions [#6696]
  - Fixed autocompletion false positives with cursor after parameter list [#6475]
  - Fixed autocompletion after partial identifier in math [#6415]
  - Fixed which definitions are suggested in math [#6415]
  - Fixed inapplicable method autocompletions being listed [#5824]
- Tooltips
  - Fixed tooltip for scoped functions (e.g. `calc.round`) [#6234]
  - Fixed tooltip and details for figure references [#6580]
  - Expression tooltips now use `×` instead of `x` to indicate a repeated value [#6163]
- Fixed jump from click (jumping to the source panel with a click in the preview) in presence of transformations and clipping [#6037]

## Symbols
- Added many new symbols and variants; many more than could be listed here. View [the dedicated changelog](https://github.com/typst/codex/blob/v0.2.0/CHANGELOG.md#version-020-october-7-2025) for a full listing.
- Code points that have a symbol and emoji presentation now have the correct variation selector attached depending on whether they appear in `sym` or `emoji`. That said, they still don't render consistently in Typst due to how font fallback works. [typst/codex#114]
- The [`symbol`] function can now be used to create symbols that comprise not just one character, but one full grapheme cluster [#6489]

## Deprecations
- The name `pdf.embed` in favor of the new name [`pdf.attach`] [#6705]
- The `{"chicago-fullnotes"}` bibliography style in favor of `{"chicago-notes"}` [#6920]
- The `{"modern-humanities-research-association"}` bibliography style in favor of `{"modern-humanities-research-association-notes"}` [#6994]
- The `--make-deps` CLI flag in favor of `--deps` with `--deps-format make` [#7022]
- Various symbols, see the [deprecation section in the dedicated changelog](https://github.com/typst/codex/blob/v0.2.0/CHANGELOG.md#deprecated) for a full listing

## Development
- The `Default` impl for `Library` had to be removed for crate splitting and trait coherence reasons, but you can get a drop-in replacement via `use typst::LibraryExt` [#6576]
- The `PdfOptions` struct has a new `tagged` field, which defaults to `{true}` [#6619] [#7046]
- Fixed a potential panic in `World::font` implementations. Downstream `World` implementations might need to apply [the same fix](https://github.com/typst/typst/pull/6117). [#6117]
- Increased minimum supported Rust version to 1.88 [#6637]
- The Docker container now has the optional non-root user `typst` [#7058]

## Contributors
<contributors from="v0.13.0" to="v0.14.0" />
