---
title: Using the `TFELSystem` library to retrieve metada about material properties and behaviours generated by `MFront`
author: Thomas Helfer
date: 2022
lang: en-EN
numbersections: true
documentclass: article
from: markdown+tex_math_single_backslash
geometry:
  - margin=2cm
papersize: a4
link-citations: true
colorlinks: true
figPrefixTemplate: "$$i$$"
tblPrefixTemplate: "$$i$$"
secPrefixTemplate: "$$i$$"
eqnPrefixTemplate: "($$i$$)"
---

The `TFELSystem` library provide several functionnalities to retrieve
metada about material properties and behaviours generated by `MFront`.
This functionnalities are also available in `python` thanks to the
`tfel.system` module.

Such functionnalities are helpful for creating tools interacting with
shared libraries generated by `MFront`. Examples of such tools are:

- [`MTest`](mtest.html), which is build on top of the `TFELMTest`
  library. For `python`, the [`mtest` module](mtest-python.html) is also
  available.
- [`mfm`](mfm.html)
- [`tfel-plot`](https://github.com/thelfer/tfel-plot).
- [`tfel-editor`](https://github.com/thelfer/tfel-editor).

Those functionnalities are already used by several solvers to easily
integrate material properties and behaviours generated by `MFront`, such
as:

- [`Cyrano`](cyrano.html) (see @petry_advanced_2015)
- `Licos` (see @helfer_licos_2015)

> **Notes for propriary softwares**
>
> The `TFELSystem` library is released under the `GPL` licence.
> The [`MGIS` project](https://github.com/thelfer/MFontGenericInterfaceSupport)
> provides similar features under the `LGPL` licence but is focused on 
> the `generic` interface.

# Overview of the  functionnalities provided by the`TFEL/System` library

This page mostly discusses four classes:

- the `ExternalLibraryManager` class provides a low level API to
  retrieve individual data.
- the `ExternalMaterialKnowledgeDescription`, which is built on top of
  the `ExternalLibraryManager` class, gathers generic metadata about a
  material property or a behaviour.
- the `ExternalMaterialPropertyDescription`, which is built on top of
  the `ExternalLibraryManager` class and inherits from the
  `ExternalMaterialKnowledgeDescription` class, gathers generic metadata
  about a material property.
- the `ExternalBehaviourDescription`, which is also built on top of the
  `ExternalLibraryManager` class and also inherits from the
  `ExternalMaterialKnowledgeDescription` class, gathers generic metadata
  about a behaviour.

<!--
For complete documentation of those classes, the reader may refer to the
[doxygen documentation](http://tfel.sourceforge.net/doxygen/index.html).
-->

> **About the `mtest::Behaviour` class**
>
> The `ExternalBehaviourDescription` reads general information about the
> behaviours but don't take into account specificities related to interfaces 
> or modelling hypothesis.
>
> The `mtest::Behaviour` class, which takes the interface and the
> modelling hypothesis into account, do provide a much more reliable way
> retrieving information about a mechanical behaviour

# The `ExternalMaterialKnowledgeDescription` class

## Overview of the `ExternalMaterialKnowledgeDescription` class

The `ExternalMaterialKnowledgeDescription` gathers information exported
by `MFront` about an entry point (material property or behaviour). This
class has been introduced as a base class for the
`ExternalMaterialPropertyDescription` and `ExternalBehaviourDescription`
classes.

This class exposes the following data members:

- `library`: the name of the library
- `entry_point`: the name of the entry point
- `tfel_version`: the version of TFEL used to generate the entry point
- `build_id`: the build identifier (if any)
- `source`: the MFront source file
- `mfront_interface`: the name of the interface used to generate the
  entry point.
- `material`: the name of the material, as introduced by
  the `@Material` keyword in `MFront`.
- `author`: the author of the implementation, as introduced by
  the `@Author` keyword in `MFront`.
- `date`: the date of the implementation, as introduced by
  the `@Date` keyword in `MFront`.
- `description`: the description of the entry point, as introduced by
  the `@Description` keyword in `MFront`.

# The `ExternalMaterialPropertyDescription` class

## Overview of the `ExternalMaterialPropertyDescription` class

The `ExternalMaterialPropertyDescription` gathers the information about
a material property generated by `MFront`. It inherits from the
`ExternalMaterialKnowledgeDescription` class.

## Example of usage

# The `ExternalBehaviourDescription` class

## Overview of the `ExternalBehaviourDescription` class

## Example of usage

# The `ExternalLibraryManager` class

## Overview of the `ExternalLibraryManager` class

## Example of usage

# References
