/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
**
** This version of "lempar.c" is modified, slightly, for use by SQLite.
** The only modifications are the addition of a couple of NEVER()
** macros to disable tests that are needed in the case of a general
** LALR(1) grammar but which are always false in the
** specific grammar used by SQLite.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>

#include "token.h"
#include "parsercontext.h"
#include "parser_helper_stubs.h"
#include "common/utils_sql.h"
#include "common/global.h"
#include "common/unused.h"
#include "parser/ast/sqlitealtertable.h"
#include "parser/ast/sqliteanalyze.h"
#include "parser/ast/sqliteattach.h"
#include "parser/ast/sqlitebegintrans.h"
#include "parser/ast/sqlitecommittrans.h"
#include "parser/ast/sqlitecreateindex.h"
#include "parser/ast/sqlitecreatetable.h"
#include "parser/ast/sqlitecreatetrigger.h"
#include "parser/ast/sqlitecreateview.h"
#include "parser/ast/sqlitecreatevirtualtable.h"
#include "parser/ast/sqlitedelete.h"
#include "parser/ast/sqlitedetach.h"
#include "parser/ast/sqlitedropindex.h"
#include "parser/ast/sqlitedroptable.h"
#include "parser/ast/sqlitedroptrigger.h"
#include "parser/ast/sqlitedropview.h"
#include "parser/ast/sqliteemptyquery.h"
#include "parser/ast/sqliteinsert.h"
#include "parser/ast/sqlitepragma.h"
#include "parser/ast/sqlitereindex.h"
#include "parser/ast/sqliterelease.h"
#include "parser/ast/sqliterollback.h"
#include "parser/ast/sqlitesavepoint.h"
#include "parser/ast/sqliteselect.h"
#include "parser/ast/sqliteupdate.h"
#include "parser/ast/sqlitevacuum.h"
#include "parser/ast/sqliteexpr.h"
#include "parser/ast/sqlitecolumntype.h"
#include "parser/ast/sqliteconflictalgo.h"
#include "parser/ast/sqlitesortorder.h"
#include "parser/ast/sqliteindexedcolumn.h"
#include "parser/ast/sqliteforeignkey.h"
#include "parser/ast/sqlitewith.h"
#include "parser/ast/sqliteupsert.h"
#include "parser/ast/sqlitewindowdefinition.h"
#include "parser/ast/sqlitefilterover.h"
#include "parser/ast/sqlitenulls.h"
#include <QObject>
#include <QDebug>
#include <limits.h>

#define assert(X) Q_ASSERT(X)
#define UNUSED_PARAMETER(X) (void)(X)
#define DONT_INHERIT_TOKENS(X) noTokenInheritanceFields << X

/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/*
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands.
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3_parseTOKENTYPE     is the data type used for minor tokens given
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3_parseTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3_parseARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3_parseARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3_parseARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3_parseARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned short int
#define YYNOCODE 331
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 78
#define sqlite3_parseTOKENTYPE Token*
typedef union {
  int yyinit;
  sqlite3_parseTOKENTYPE yy0;
  ParserOtherSourceList* yy11;
  SqliteWindowDefinition::Window::Frame* yy41;
  ParserCreateTableColumnList* yy42;
  ParserFullName* yy60;
  SqliteWindowDefinition::Window::Frame::Bound* yy81;
  SqliteSelect::Core::JoinSource* yy91;
  SqliteNulls* yy99;
  SqliteExpr::LikeOp* yy100;
  SqliteCreateTable::Constraint* yy106;
  ParserXFullName* yy116;
  ParserIndexedColumnList* yy123;
  SqliteForeignKey::Condition::Reaction* yy124;
  ParserCreateTableColumnConstraintList* yy131;
  SqliteInitially* yy192;
  QStringList* yy215;
  SqliteWindowDefinition::Window* yy234;
  SqliteFilterOver* yy247;
  QVariant* yy249;
  SqliteExpr* yy252;
  QString* yy259;
  ParserStubCreateTableOption* yy287;
  SqliteFilterOver::Over* yy288;
  bool* yy291;
  ParserIndexedBy* yy312;
  ParserSetValueList* yy321;
  SqliteCreateTrigger::Scope* yy323;
  ParserFkConditionList* yy324;
  ParserQueryList* yy330;
  SqliteCreateTrigger::Event* yy331;
  ParserCteList* yy332;
  SqliteSelect::Core::JoinConstraint* yy335;
  int* yy346;
  ParserTermOrLiteral* yy350;
  ParserExprList* yy351;
  SqliteWindowDefinition::Window::Frame::RangeOrRows* yy358;
  SqliteSelect::Core::SingleSource* yy361;
  SqliteCreateTrigger::Time* yy372;
  ParserCreateTableConstraintList* yy373;
  SqliteSelect::CompoundOperator* yy382;
  SqliteSortOrder* yy389;
  SqliteQuery* yy443;
  SqliteLimit* yy444;
  SqliteWith::CommonTableExpression* yy446;
  ParserDeferSubClause* yy449;
  SqliteSelect::Core* yy450;
  SqliteSelect* yy453;
  ParserStubAlias* yy460;
  ParserStubTransDetails* yy464;
  SqliteColumnType* yy477;
  SqliteConflictAlgo* yy478;
  SqliteUpsert* yy500;
  ParserStubExplain* yy511;
  SqliteSelect::Core::JoinOp* yy521;
  ParserCreateTableOptionList* yy533;
  ParserOrderByList* yy543;
  ParserExprNestedList* yy546;
  SqliteCreateTable::Column* yy567;
  ParserStubInsertOrReplace* yy584;
  SqliteWindowDefinition::Window::Frame::Exclude* yy603;
  SqliteCreateTable::Column::Constraint* yy604;
  SqliteForeignKey::Condition* yy607;
  SqliteIndexedColumn* yy608;
  ParserResultColumnList* yy633;
  ParserWindowDefList* yy639;
  SqliteWith::CommonTableExpression::AsMode* yy640;
  SqliteWith* yy641;
  SqliteWindowDefinition* yy646;
  SqliteFilterOver::Filter* yy657;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3_parseARG_SDECL ParserContext* parserContext;
#define sqlite3_parseARG_PDECL ,ParserContext* parserContext
#define sqlite3_parseARG_FETCH ParserContext* parserContext = yypParser->parserContext
#define sqlite3_parseARG_STORE yypParser->parserContext = parserContext
#define YYNSTATE 884
#define YYNRULE 499
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

#define GET_CONTEXT yyParser* yypParser = pParser; sqlite3_parseARG_FETCH

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
#define YY_ACTTAB_COUNT (3319)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   876,  881,  835,  260,  719,   27,  479,  696,   67,   68,
 /*    10 */   537,  285,  529,  411,  831,  831,   65,   65,   66,   66,
 /*    20 */    66,   66,  695,   64,   64,   64,   64,   63,   63,   62,
 /*    30 */    62,   62,   61,   59,  268,  363,   67,   68,  537,  285,
 /*    40 */   822,   81,  831,  831,   65,   65,   66,   66,   66,   66,
 /*    50 */   534,   64,   64,   64,   64,   63,   63,   62,   62,   62,
 /*    60 */    61,   59,  268,  596, 1306,  822,  256,  255,  254,  876,
 /*    70 */   700,  821,  107,   66,   66,   66,   66,   56,   64,   64,
 /*    80 */    64,   64,   63,   63,   62,   62,   62,   61,   59,  268,
 /*    90 */   183,  876,  288,  699,   53,   54,  727,  822,  436,  369,
 /*   100 */  1333,  608,   55, 1057,  875, 1333,  609,   78,  876,  200,
 /*   110 */     2, 1057,   51,  269,  167,  829, 1057,  183,  138,  526,
 /*   120 */   529,  876,  876,  844,  873,  834,  734,  627, 1131,  847,
 /*   130 */   289,  875,  427,  876,  165,  820,  829,  846,  845,  844,
 /*   140 */    58, 1057,   64,   64,   64,   64,   63,   63,   62,   62,
 /*   150 */    62,   61,   59,  268, 1057,  830, 1057, 1057,  534,  160,
 /*   160 */  1057,  747,  464,  461,  460, 1057, 1057, 1057, 1057, 1057,
 /*   170 */  1057,  829,  733,  729,  829,  170,  819,   12,  835,  821,
 /*   180 */   459,  605,  622,  410,  669,   56,  794,  423, 1057,  668,
 /*   190 */   876,  876,  874,  873,  854,   92,  160,  135,  875,  464,
 /*   200 */   461,  460,   53,   54,  259,  592,  592,  508,  759,    4,
 /*   210 */    55, 1131,  876,  876,  874,  873,  876,  459,    2, 1131,
 /*   220 */   275,  645,  656,  829, 1131,  523,  876,  526,  529,  876,
 /*   230 */   876,  844,  873,  337,  475,  759,    4,  847,   62,   62,
 /*   240 */    62,   61,   59,  268,  829,  846,  845,  844,  556, 1131,
 /*   250 */    23,  336,  600,  400,  876,  876,  874,  873,  616,   83,
 /*   260 */   848,  882, 1131,  849, 1131, 1131,  534,  169,  557,  556,
 /*   270 */   305,  448,  315, 1131, 1131, 1131, 1131,  264, 1131,  829,
 /*   280 */   287,  481,  829,  296,  819,   12,  298,  821,  980,  617,
 /*   290 */   876,  619,  746,   56,  618,  745, 1131,  556,  465,  822,
 /*   300 */   568,  834, 1241,  172,  126,  338,  470,  333,  469,  162,
 /*   310 */    53,   54,  818,  833,  875,   21,  432,   90,   55, 1116,
 /*   320 */   569,  570,  323,  331,  822,  325,    2, 1116,  803,  530,
 /*   330 */   299,  829, 1116,  115,   74,  526,  876,  876,  876,  844,
 /*   340 */   873,  606,  835,  835,  872,  847,  876,  876,  876,  874,
 /*   350 */   873,  870,  829,  846,  845,  844,  822, 1116,  115,  871,
 /*   360 */    73,   63,   63,   62,   62,   62,   61,   59,  268,  361,
 /*   370 */  1116,  842, 1116, 1116,  406,  816,  815,  801, 1221, 1221,
 /*   380 */   825, 1116,  693, 1116, 1116,  538, 1116,  829,  764,  800,
 /*   390 */   829,  784,  819,   12,  843,  123,  571,  811,  659,  783,
 /*   400 */     1,  689,  297,  536, 1116,  841,  716,  716,  660,  764,
 /*   410 */   606,  876,  876,  874,  873,  764,  876,   67,   68,  537,
 /*   420 */   285, 1221, 1221,  831,  831,   65,   65,   66,   66,   66,
 /*   430 */    66,  824,   64,   64,   64,   64,   63,   63,   62,   62,
 /*   440 */    62,   61,   59,  268,  823,  512,   72,  684,  685,   39,
 /*   450 */   139,  735,  811,   91,  167,   57,  788,  876,  876,  874,
 /*   460 */   873,  579,  876, 1221, 1221,  834,  834,  876,  876,  874,
 /*   470 */   873,  817,  736,   69,   68,  537,  285,  813,  812,  831,
 /*   480 */   831,   65,   65,   66,   66,   66,   66,  735,   64,   64,
 /*   490 */    64,   64,   63,   63,   62,   62,   62,   61,   59,  268,
 /*   500 */   806,  747,   67,   68,  537,  285, 1221, 1221,  831,  831,
 /*   510 */    65,   65,   66,   66,   66,   66,  876,   64,   64,   64,
 /*   520 */    64,   63,   63,   62,   62,   62,   61,   59,  268,  801,
 /*   530 */   568,  579,  152,  154,  528,  816,  815,  876,  876,  874,
 /*   540 */   873,  800,  202,   45,  875,  284,  283,   61,   59,  268,
 /*   550 */   569,  414,  828,  340,  610,  611,  429,  537,  285, 1221,
 /*   560 */  1221,  831,  831,   65,   65,   66,   66,   66,   66,  472,
 /*   570 */    64,   64,   64,   64,   63,   63,   62,   62,   62,   61,
 /*   580 */    59,  268,  805,  876,  876,  874,  873,  828,  813,  812,
 /*   590 */   755,  480,  876,  721,  720,  168,  851,   58,   67,   68,
 /*   600 */   537,  285, 1221, 1221,  831,  831,   65,   65,   66,   66,
 /*   610 */    66,   66,  811,   64,   64,   64,   64,   63,   63,   62,
 /*   620 */    62,   62,   61,   59,  268,  723,  415,  811,  848,  844,
 /*   630 */    58,  849,  596,  758,  835,  847,  835,  876,  876, 1221,
 /*   640 */  1221,  715,  835,  846,  845,  844,  513,   66,   66,   66,
 /*   650 */    66,   40,   64,   64,   64,   64,   63,   63,   62,   62,
 /*   660 */    62,   61,   59,  268,  435,  876,  329, 1226,  369, 1332,
 /*   670 */   319,  115,  876,  745, 1332,  339,  711,   79,   67,   68,
 /*   680 */   537,  285, 1221, 1221,  831,  831,   65,   65,   66,   66,
 /*   690 */    66,   66,  117,   64,   64,   64,   64,   63,   63,   62,
 /*   700 */    62,   62,   61,   59,  268,  876,  377,  601,  286,  876,
 /*   710 */   808,  670,  266,  876,  876,  874,  873,  529,   22,  457,
 /*   720 */    67,   68,  537,  285,  115,  516,  831,  831,   65,   65,
 /*   730 */    66,   66,   66,   66,  505,   64,   64,   64,   64,   63,
 /*   740 */    63,   62,   62,   62,   61,   59,  268,  876,  510,  128,
 /*   750 */    52,  293,   50,  270,   14,  534,  510,  834,  506,  834,
 /*   760 */    80,  726,  875,  292,  764,  834,  365,  807,  876,  797,
 /*   770 */   875,  675,   80,  876,  601,  709,  821,  877,  152,  151,
 /*   780 */   771,  500,   56,  161,  341,  764,  876,  876,  874,  873,
 /*   790 */   351,  764,  132,  876,  876,  874,  873,  362,  875,   53,
 /*   800 */    54,  828,  364,  175,  875,  857,  514,   55,  109,  339,
 /*   810 */   711,   80,  539,  127,  855,    2, 1233,  443,  793,  875,
 /*   820 */   829,  434,  168, 1226,  526, 1226,  876,  876,  844,  873,
 /*   830 */   876,  876,  874,  873,  847,  201,  828,  876,  808,  527,
 /*   840 */   266,  829,  846,  845,  844,  740,  853, 1227,  757,  373,
 /*   850 */   366,  842,  189,  351,  677,  467,  446, 1341, 1341, 1235,
 /*   860 */   739,  651,  651,  511,  781,  538,   22,  875,  876,  876,
 /*   870 */   874,  873,  780,  865,  843,  220,  829,  792,  863,  829,
 /*   880 */  1235,  819,   12,  536,  455,  772, 1235,  383,  408,  876,
 /*   890 */   876,  874,  873,  379,  876,  876,  874,  873,  875,  499,
 /*   900 */    67,   68,  537,  285,  804,  789,  831,  831,   65,   65,
 /*   910 */    66,   66,   66,   66,  764,   64,   64,   64,   64,   63,
 /*   920 */    63,   62,   62,   62,   61,   59,  268,  876,  441,  787,
 /*   930 */   413,  876, 1235,  168,  350,  764,  788,  350,  135,  529,
 /*   940 */  1235,  764,  502,  152,  150, 1235,  515,  113,  875,  842,
 /*   950 */   350,  875,  876,  386,  252,  842, 1230,  477,  876,  876,
 /*   960 */   874,  873,  876,  538,  875,  520,  857,  791,  876,  538,
 /*   970 */  1235,  504,  843,  235,  766,  860,  405,  534,  843,  235,
 /*   980 */   875,  536,   79, 1235,  683, 1235, 1235,  536,  876,  274,
 /*   990 */   501,  883,    3,  442, 1235,  122, 1235, 1235,  821, 1235,
 /*  1000 */    44,  876,  704, 1227,   56, 1227,    6,  875,  634,  491,
 /*  1010 */   478,  876,  468,  778,    4,  491,  476, 1235,  764,  295,
 /*  1020 */    47,   53,   54,  529,   46,  251,  250,  802,  682,   55,
 /*  1030 */   795,  307,   20,  875,  378,  507,   44,    2,   42,  764,
 /*  1040 */   378,   71,  829,  795,  593,  764,  526,  876,  876,  876,
 /*  1050 */   844,  873,  876,  876,  844,  876,  847,  593,  495,  525,
 /*  1060 */   847,  534,  521,  829,  846,  845,  844,  647,  846,  845,
 /*  1070 */   844,  621,  273,  876,  876,  874,  873,  562,   80,  884,
 /*  1080 */   368,  595,  821,  876,  876,  874,  873,  161,   56,  876,
 /*  1090 */   876,  874,  873,  368,  594,  284,  283,  122,  829,  654,
 /*  1100 */   122,  829,  647,  819,   12,   53,   54,  493,  410,  876,
 /*  1110 */   876,  874,  873,   55,  574,  173,   80,  395,  354,  398,
 /*  1120 */   347,    2,  876,  876,  874,  873,  829,  456,  876,  565,
 /*  1130 */   526,  875,  876,  876,  844,  873,  649,  122,  813,  812,
 /*  1140 */   847,  350,  567,  532,  566,  562,  777,  829,  846,  845,
 /*  1150 */   844,  494, 1277,  498, 1292,  875, 1384,  193,  543,    3,
 /*  1160 */   861,  763,    4, 1341, 1341,  856,  509,  777,  876,  876,
 /*  1170 */   874,  873,  876,  702,  122,  701,  876,  876,  874,  873,
 /*  1180 */   397,  637,  829,  701,  442,  829,  882,  819,   12,  196,
 /*  1190 */    44,  383,  876,   67,   68,  537,  285,  331,  875,  831,
 /*  1200 */   831,   65,   65,   66,   66,   66,   66,  116,   64,   64,
 /*  1210 */    64,   64,   63,   63,   62,   62,   62,   61,   59,  268,
 /*  1220 */    67,   68,  537,  285,  876,   77,  831,  831,   65,   65,
 /*  1230 */    66,   66,   66,   66,  795,   64,   64,   64,   64,   63,
 /*  1240 */    63,   62,   62,   62,   61,   59,  268,  876, 1292,  876,
 /*  1250 */   876,  874,  873,  674,  673,  302,  752,  779,  445,  529,
 /*  1260 */    44,  745,  502,  271,  559,   67,   68,  537,  285,   19,
 /*  1270 */   875,  831,  831,   65,   65,   66,   66,   66,   66,  474,
 /*  1280 */    64,   64,   64,   64,   63,   63,   62,   62,   62,   61,
 /*  1290 */    59,  268,  559,  876,  876,  874,  873,  534,  260,  719,
 /*  1300 */   598,  479,  119,  261,  384,  370,  752,  553,  555,  341,
 /*  1310 */   501,  774,  309,  876,  876,  874,  873,  490,  821,  876,
 /*  1320 */   875,  420,  561,  875,   56,  591,  350,  402,  553,  876,
 /*  1330 */   762,    4,  773,  440,  748,  875,  555, 1228, 1001,  638,
 /*  1340 */   875,   53,   54,  657,  876,  876,  876,  874,  873,   55,
 /*  1350 */   122,  876,  760,    4,  439,  122,  553,    2,  752,  168,
 /*  1360 */   638,  752,  829,    5,  351,  396,  526,  876,  876,  876,
 /*  1370 */   844,  873,  875,  489,  373,  875,  847,  393,  875,  529,
 /*  1380 */   705,  728,  502,  829,  846,  845,  844,  768,  748,  850,
 /*  1390 */    67,   68,  537,  285,  426,  163,  831,  831,   65,   65,
 /*  1400 */    66,   66,   66,   66,  261,   64,   64,   64,   64,   63,
 /*  1410 */    63,   62,   62,   62,   61,   59,  268,  534,  829,  795,
 /*  1420 */   767,  829,  842,  819,   12,  513,  761,    4,   80,  392,
 /*  1430 */   503,  765,  272,  451,  632,  741,  538,  324,  821,  112,
 /*  1440 */   876,  876,  874,  873,   56,  843,  220,  875,   89,  341,
 /*  1450 */   876,  876,  874,  873,  536,  632,  421,  547,   18,  624,
 /*  1460 */   876,   53,   54,  875,  614,  876,  876,  874,  873,   55,
 /*  1470 */   875,  875,  876,  876,  874,  873,  524,    2,  791,  418,
 /*  1480 */   624,   17,  829,  587,  669,   16,  526,  839,  876,  876,
 /*  1490 */   844,  873,  748,  875,  549,   92,  847,   11,  875,   58,
 /*  1500 */   633,  748,  114,  829,  846,  845,  844,  788,  287,  481,
 /*  1510 */    67,   68,  537,  285,  278,  166,  831,  831,   65,   65,
 /*  1520 */    66,   66,   66,   66,  876,   64,   64,   64,   64,   63,
 /*  1530 */    63,   62,   62,   62,   61,   59,  268,  742,  829,  738,
 /*  1540 */   878,  829,  343,  819,   12,  766,  730,  186,  737,   67,
 /*  1550 */    68,  537,  285,  748,  875,  831,  831,   65,   65,   66,
 /*  1560 */    66,   66,   66,  185,   64,   64,   64,   64,   63,   63,
 /*  1570 */    62,   62,   62,   61,   59,  268,  417,  858,  184,  129,
 /*  1580 */   583,  876,  876,  874,  873,  710,   67,   68,  537,  285,
 /*  1590 */   875,  485,  831,  831,   65,   65,   66,   66,   66,   66,
 /*  1600 */   197,   64,   64,   64,   64,   63,   63,   62,   62,   62,
 /*  1610 */    61,   59,  268,  725,   48,  483,  345,    7,   67,   68,
 /*  1620 */   537,  285,  708,  724,  831,  831,   65,   65,   66,   66,
 /*  1630 */    66,   66,   15,   64,   64,   64,   64,   63,   63,   62,
 /*  1640 */    62,   62,   61,   59,  268,  876,  876,  874,  873,   67,
 /*  1650 */    68,  537,  285,  722,  691,  831,  831,   65,   65,   66,
 /*  1660 */    66,   66,   66,  866,   64,   64,   64,   64,   63,   63,
 /*  1670 */    62,   62,   62,   61,   59,  268,  261,  875,  718,  717,
 /*  1680 */   344,   67,   68,  537,  285,  190,  121,  831,  831,   65,
 /*  1690 */    65,   66,   66,   66,   66,  827,   64,   64,   64,   64,
 /*  1700 */    63,   63,   62,   62,   62,   61,   59,  268,  713,  473,
 /*  1710 */    37,  876,  120,   67,   68,  537,  285,  328,  277,  831,
 /*  1720 */   831,   65,   65,   66,   66,   66,   66,  181,   64,   64,
 /*  1730 */    64,   64,   63,   63,   62,   62,   62,   61,   59,  268,
 /*  1740 */   261, 1256,   67,   68,  537,  285,   25,  681,  831,  831,
 /*  1750 */    65,   65,   66,   66,   66,   66,  864,   64,   64,   64,
 /*  1760 */    64,   63,   63,   62,   62,   62,   61,   59,  268,  466,
 /*  1770 */   875,   36,  672,  463,   67,   68,  537,  285,   86,   28,
 /*  1780 */   831,  831,   65,   65,   66,   66,   66,   66,  835,   64,
 /*  1790 */    64,   64,   64,   63,   63,   62,   62,   62,   61,   59,
 /*  1800 */   268,  330, 1307,   67,   68,  537,  285,  458,   85,  831,
 /*  1810 */   831,   65,   65,   66,   66,   66,   66,   24,   64,   64,
 /*  1820 */    64,   64,   63,   63,   62,   62,   62,   61,   59,  268,
 /*  1830 */   876, 1305,  876,  876,  874,  873,   84,   67,   68,  537,
 /*  1840 */   285,  159,  529,  831,  831,   65,   65,   66,   66,   66,
 /*  1850 */    66,  752,   64,   64,   64,   64,   63,   63,   62,   62,
 /*  1860 */    62,   61,   59,  268,  876,  875,   67,   38,  537,  285,
 /*  1870 */   749,  158,  831,  831,   65,   65,   66,   66,   66,   66,
 /*  1880 */   534,   64,   64,   64,   64,   63,   63,   62,   62,   62,
 /*  1890 */    61,   59,  268,  336,  453,  416,  842,  650,    8,  580,
 /*  1900 */   167,  821,  412,  669,  517,  199,  380,   56,  360,  875,
 /*  1910 */   538,  834,  105,  655,   92,  876,  875,  875,  157,  843,
 /*  1920 */   235,  862,  428,  394,   53,   54,  155,   10,  536,  859,
 /*  1930 */   852,  758,   55,  153, 1224,  875,   35,  875,   34,   33,
 /*  1940 */     2,  690,  122,  875,  875,  829,  876,  747,  842,  526,
 /*  1950 */   876,  876,  876,  844,  873,  103,  407,   32,  529,  847,
 /*  1960 */   388,  102,  538,  391,  840,  390,  829,  846,  845,  844,
 /*  1970 */   842,  843,  123,  876,   72,  626,  306,  875,  875,  735,
 /*  1980 */   536,  378,  101,  620,  538,  876,  876,  874,  873,  826,
 /*  1990 */   615,  531,  880,  843,  235,  195,  534,  542,  754,  750,
 /*  2000 */   736,  829,  536,  875,  829,  875,  819,   12,  645,  876,
 /*  2010 */   744,  430,  875,  875,  613,  735,  110,  821,  164,  607,
 /*  2020 */   876,  529,  188,   56,  875,  168, 1074, 1074,  842,  304,
 /*  2030 */   491,  492,  875,  788,   13,  310,  876,  876,  874,  873,
 /*  2040 */    53,   54,  538,  148,  488,  578,   83,  301,   55,  712,
 /*  2050 */   876,  843,  235,  179,  203,  378,    2,  327,  875,  534,
 /*  2060 */   536,  829,  146,  875,  588,  526,   96,  876,  876,  844,
 /*  2070 */   873,  876,  876,  874,  873,  847,  577,  332,  576,  743,
 /*  2080 */   821,  575,  829,  846,  845,  844,   56,  876,  491,  482,
 /*  2090 */   145,  875,  688,  144,  876,  876,  874,  873,  143,  529,
 /*  2100 */   666,  141,  326,   53,   54,  140,  875,  545,  564,  678,
 /*  2110 */   563,   55,  876,  378,  875,  652,  875,  829,  409,    2,
 /*  2120 */   829,  753,  819,   12,  829,  321,  447,  876,  526,  875,
 /*  2130 */   876,  876,  844,  873,  544,  589,  261,  534,  847,  875,
 /*  2140 */   875,  876,  876,  874,  873,  829,  846,  845,  844,   94,
 /*  2150 */   876,  257,  842,  644,  641,  424,  589,  276,  821,  118,
 /*  2160 */   879,  876,  529,  551,   56,  585,  538,  875,  875,  875,
 /*  2170 */   253,  876,  876,  874,  873,  843,  235,  875,  359,  876,
 /*  2180 */   829,   53,   54,  829,  536,  819,   12, 1231,  177,   55,
 /*  2190 */   842,  535,  875,  322,  382,  381,  176,    2, 1233,  869,
 /*  2200 */   534,  585,  829,  444,  538,  875,  526,  875,  876,  876,
 /*  2210 */   844,  873,  401,  843,  220,  868,  847,  875,  867,  541,
 /*  2220 */   108,  821,  536,  829,  846,  845,  844,   56,  876,  174,
 /*  2230 */   454,   87,  303,  876,  876,  874,  873,  378,   75,  876,
 /*  2240 */   529,  300,  582,  540,   53,   54,  875,  171,  876,  876,
 /*  2250 */   874,  873,   55,  294,  290,  875,  287,  687,  829,  837,
 /*  2260 */     2,  829,   23,  819,   12,  829,  497,  875,  875,  526,
 /*  2270 */   876,  876,  876,  844,  873,  788,  546,  356,  534,  847,
 /*  2280 */   291,  838,  876,  876,  874,  873,  829,  846,  845,  844,
 /*  2290 */   355,  582,  198,  790,  875,   43,  836,  546,   70,  821,
 /*  2300 */   876,  876,  874,  873,  268,   56,  349,   88,  282,  265,
 /*  2310 */   404,  281,  342,  769,  522,   49,  645,  346,  513,  786,
 /*  2320 */   785,  829,   53,   54,  829,  403,  819,   12,  776,  258,
 /*  2330 */    55,  782,  876,  182,  770,  137,  481,   80,    2,  484,
 /*  2340 */   163,  714,  703,  829,  698,  842,  471,  526,  697,  876,
 /*  2350 */   876,  874,  873,  616,   83,  399,  876,  847,  694,  538,
 /*  2360 */   876,  876,  874,  873,  829,  846,  845,  844,  843,  123,
 /*  2370 */   693,  334,  692,  665,  671,  106,  372,  536,  664,  663,
 /*  2380 */    72, 1067,  136,  371,  617,  735,  619,  662,  661,  618,
 /*  2390 */   156,  876,  876,  874,  873,  452,  320,  263,  876,  829,
 /*  2400 */   431,  842,  829,  876,  819,   12,  736,  449,  204,  876,
 /*  2410 */    31,  433,  842,  318,  842,  538,  104,  842,  317,  187,
 /*  2420 */   180,  735, 1341, 1341,  843,  235,  538,  876,  538,  639,
 /*  2430 */   788,  538,  876,  536,  316,  843,  235,  843,  123,  313,
 /*  2440 */   843,  123,  876,  312,  536,  311,  536,  876,  635,  536,
 /*  2450 */   194,  876,  842,  876,  876,  874,  873,  111,  876,  308,
 /*  2460 */   438,  280,  437,  876,  629,  623,  538,  134,  876,  625,
 /*  2470 */   149,  133,  279,  876,  425,  843,  235,  876,  876,  874,
 /*  2480 */   873,  147,  842,  100,  536,  876,  378,  603,  389,  422,
 /*  2490 */   876,  387,  419,   99,  732,   98,  538,  378,   97,  788,
 /*  2500 */    30,  876,  788,  385,  573,  843,  235,  876,   76,  142,
 /*  2510 */    29,  876,  560,  558,  536,   26,  876,  131,  731,  876,
 /*  2520 */   876,  874,  873,  653,  876,  876,  874,  873,  876,  554,
 /*  2530 */   876,  876,  874,  873,  130,  548,   82,  518,  876,  658,
 /*  2540 */   348,  178,  496,  876,  205,  357,  799,  876,  876,  876,
 /*  2550 */   874,  873,   60,  876,  876,  874,  873,  519,  876,  814,
 /*  2560 */   810,  192,  756,  876,  876,  874,  873,  378,  876,  876,
 /*  2570 */   874,  873,  876,  876,  874,  873,  876,  648,  612,  876,
 /*  2580 */   876,  874,  873,  642,  876,  876,  874,  873,  335,  876,
 /*  2590 */   876,  874,  873,  191,  876,  876,  874,  873,  689,  636,
 /*  2600 */   876,  249,  462,  314,  631,  628,  876,  876,  874,  873,
 /*  2610 */   643,  876,  876,  874,  873,  599,  646,  640,  876,  630,
 /*  2620 */   367,  602,  876,  876,  874,  873,  590,    9,  876,  876,
 /*  2630 */   874,  873,  876,  876,  874,  873,  262,  876,  876,  874,
 /*  2640 */   873,  832,  450,  809,  798,  676,   41,  358,  533,  876,
 /*  2650 */   876,  874,  873,  775,   95,  604,  707,  550,  586,  876,
 /*  2660 */   876,  874,  873,  597,  876,  876,  874,  873,  876,  876,
 /*  2670 */   874,  873,  686,  680,  552,  584,  876,  679,  706,  876,
 /*  2680 */   876,  874,  873,  667,   80, 1385, 1385, 1385, 1385, 1385,
 /*  2690 */  1385, 1385, 1385, 1385, 1385, 1385, 1385,  876,  876,  874,
 /*  2700 */   873,  581, 1385,  842, 1385, 1385, 1385, 1385, 1385, 1385,
 /*  2710 */  1385,  572, 1385, 1385,  790, 1385, 1385,  538,  796, 1385,
 /*  2720 */   842,  876,  876,  874,  873, 1385,  843,  228, 1385,  751,
 /*  2730 */  1385,  842, 1385, 1385,  538,  536,  842, 1385,  668,  876,
 /*  2740 */   876,  874,  873,  843,  206,  538, 1385,  842,   30, 1385,
 /*  2750 */   538,  842,  536,  842,  843,  216, 1385, 1385,  842,  843,
 /*  2760 */   238,  538, 1385,  536, 1385,  538, 1385,  538,  536, 1385,
 /*  2770 */   843,  236,  538, 1385,  843,  246,  843,  245,  842,  536,
 /*  2780 */   842,  843,  247,  536, 1385,  536, 1385, 1385,  788, 1385,
 /*  2790 */   536, 1385,  538, 1385,  538,  842, 1385,  876,  876,  874,
 /*  2800 */   873,  843,  248,  843,  267,  788, 1385, 1385, 1385,  538,
 /*  2810 */   536, 1385,  536, 1385, 1385, 1385,  788, 1385,  843,  353,
 /*  2820 */  1385,  788, 1385, 1385, 1385,  842, 1385,  536,  842, 1385,
 /*  2830 */   842, 1385,  788, 1385, 1385, 1385,  788, 1385,  788,  538,
 /*  2840 */  1385, 1385,  538,  788,  538, 1385, 1385, 1385,  843,  244,
 /*  2850 */  1385,  843,  352,  843,  215,  842, 1385,  536, 1385,  842,
 /*  2860 */   536,  842,  536,  788, 1385,  788, 1385, 1385, 1385,  538,
 /*  2870 */  1385, 1385,  842,  538,  842,  538, 1385, 1385,  843,  233,
 /*  2880 */   788, 1385,  843,  237,  843,  376,  538,  536,  538, 1385,
 /*  2890 */  1385,  536, 1385,  536, 1385,  843,  375,  843,  374, 1385,
 /*  2900 */  1385, 1385,  842, 1385,  536,  842,  536,  842, 1385, 1385,
 /*  2910 */   788, 1385, 1385,  788, 1385,  788,  538, 1385,  842,  538,
 /*  2920 */  1385,  538, 1385, 1385,  842,  843,  232, 1385,  843,  218,
 /*  2930 */   843,  231,  538, 1385,  536, 1385, 1385,  536,  538,  536,
 /*  2940 */   788,  843,  230, 1385,  788, 1385,  788,  843,  217,  842,
 /*  2950 */   536,  842, 1385, 1385,  842, 1385,  536,  788, 1385,  788,
 /*  2960 */  1385, 1385, 1385,  538, 1385,  538, 1385, 1385,  538, 1385,
 /*  2970 */  1385, 1385,  843,  243,  843,  242, 1385,  843,  214, 1385,
 /*  2980 */  1385,  536,  842,  536,  842, 1385,  536,  788, 1385, 1385,
 /*  2990 */   788, 1385,  788, 1385, 1385, 1385,  538, 1385,  538,  842,
 /*  3000 */  1385, 1385, 1385,  788, 1385,  843,  124,  843,  213,  788,
 /*  3010 */  1385, 1385, 1385,  538,  536, 1385,  536, 1385, 1385, 1385,
 /*  3020 */  1385, 1385,  843,  211, 1385, 1385, 1385, 1385, 1385,  842,
 /*  3030 */  1385,  536,  842, 1385,  788, 1385,  788, 1385, 1385,  788,
 /*  3040 */  1385, 1385, 1385,  538, 1385, 1385,  538, 1385,  842, 1385,
 /*  3050 */  1385, 1385,  843,  239, 1385,  843,  241, 1385, 1385,  842,
 /*  3060 */  1385,  536,  538,  842,  536,  842, 1385,  788, 1385,  788,
 /*  3070 */  1385,  843,  234,  538, 1385, 1385,  842,  538,  842,  538,
 /*  3080 */   536, 1385,  843,  240,  788, 1385,  843,  229,  843,  226,
 /*  3090 */   538,  536,  538, 1385, 1385,  536, 1385,  536, 1385,  843,
 /*  3100 */   210,  843,  209, 1385, 1385, 1385,  842, 1385,  536, 1385,
 /*  3110 */   536,  842, 1385, 1385,  788, 1385, 1385,  788, 1385, 1385,
 /*  3120 */   538, 1385,  842, 1385, 1385,  538, 1385, 1385,  842,  843,
 /*  3130 */   208, 1385, 1385,  788,  843,  207,  538, 1385,  536, 1385,
 /*  3140 */  1385,  842,  538,  536,  788,  843,  219, 1385,  788, 1385,
 /*  3150 */   788,  843,  224,  842,  536,  538, 1385, 1385,  842, 1385,
 /*  3160 */   536,  788, 1385,  788,  843,  223, 1385,  538, 1385,  842,
 /*  3170 */  1385, 1385,  538,  536, 1385, 1385,  843,  125, 1385, 1385,
 /*  3180 */  1385,  843,  222,  538, 1385,  536,  842, 1385,  842, 1385,
 /*  3190 */   536,  788,  843,  221, 1385, 1385,  788, 1385, 1385, 1385,
 /*  3200 */   538,  536,  538, 1385, 1385, 1385, 1385,  788, 1385,  843,
 /*  3210 */   227,  843,  225,  788, 1385, 1385, 1385,  842,  536, 1385,
 /*  3220 */   536, 1385, 1385, 1385, 1385, 1385,  788, 1385, 1385, 1385,
 /*  3230 */  1385,  538, 1385,  842, 1385, 1385, 1385, 1385,  788, 1385,
 /*  3240 */   843,  212, 1385,  788, 1385, 1385, 1385,  538, 1385,  536,
 /*  3250 */  1385, 1385, 1385, 1385,  788, 1385,  843,   93, 1385, 1385,
 /*  3260 */  1385, 1385, 1385, 1385, 1385,  487, 1385, 1385, 1385, 1385,
 /*  3270 */  1385,  788, 1385,  788, 1385, 1385, 1385, 1385, 1385, 1385,
 /*  3280 */  1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385,
 /*  3290 */  1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385,
 /*  3300 */  1385, 1385,  788, 1385, 1385, 1385, 1385, 1385, 1385, 1385,
 /*  3310 */  1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385,  788,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     4,  107,    4,  250,  251,   48,  253,   21,   79,   80,
 /*    10 */    81,   82,   16,   74,   85,   86,   87,   88,   89,   90,
 /*    20 */    91,   92,   36,   94,   95,   96,   97,   98,   99,  100,
 /*    30 */   101,  102,  103,  104,  105,  111,   79,   80,   81,   82,
 /*    40 */     5,  115,   85,   86,   87,   88,   89,   90,   91,   92,
 /*    50 */    54,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*    60 */   103,  104,  105,   78,  107,   30,  146,  147,  148,    4,
 /*    70 */    35,   75,  120,   89,   90,   91,   92,   81,   94,   95,
 /*    80 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*    90 */   203,    4,  153,   58,   98,   99,  100,   62,  148,  114,
 /*   100 */   115,    7,  106,  107,  217,  120,   12,  114,    4,  116,
 /*   110 */   114,  115,  183,  114,  116,  119,  120,  203,  117,  123,
 /*   120 */    16,  125,  126,  127,  128,  127,  120,  177,   24,  133,
 /*   130 */   191,  217,   38,    4,  128,  115,  140,  141,  142,  143,
 /*   140 */   120,  145,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   150 */   102,  103,  104,  105,  158,  133,  160,  161,   54,  131,
 /*   160 */   164,  163,  134,  135,  136,  169,  170,  171,  172,  173,
 /*   170 */   174,  175,  166,  167,  178,  117,  180,  181,    4,   75,
 /*   180 */   152,   64,   58,   29,  203,   81,   42,   70,  192,  124,
 /*   190 */   125,  126,  127,  128,  213,  214,  131,  120,  217,  134,
 /*   200 */   135,  136,   98,   99,  114,  118,  119,  320,  321,  322,
 /*   210 */   106,  107,  125,  126,  127,  128,    4,  152,  114,  115,
 /*   220 */   239,  211,  241,  119,  120,   81,    4,  123,   16,  125,
 /*   230 */   126,  127,  128,  133,  320,  321,  322,  133,  100,  101,
 /*   240 */   102,  103,  104,  105,  140,  141,  142,  143,  119,  145,
 /*   250 */   173,  151,  135,   81,  125,  126,  127,  128,  248,  249,
 /*   260 */   159,  107,  158,  162,  160,  161,   54,  120,  139,  140,
 /*   270 */   146,  147,  148,  169,  170,  171,  172,  105,  174,  175,
 /*   280 */   156,  157,  178,   66,  180,  181,   69,   75,  116,  279,
 /*   290 */     4,  281,  273,   81,  284,  276,  192,  168,  126,    5,
 /*   300 */   203,  127,  185,  131,  132,  133,  134,  135,  136,  137,
 /*   310 */    98,   99,  115,  139,  217,  305,  306,  120,  106,  107,
 /*   320 */   223,  224,   66,  151,   30,   69,  114,  115,  115,   35,
 /*   330 */   113,  119,  120,  120,   88,  123,    4,  125,  126,  127,
 /*   340 */   128,  119,    4,    4,   21,  133,    4,  125,  126,  127,
 /*   350 */   128,   28,  140,  141,  142,  143,   62,  145,  120,   36,
 /*   360 */   114,   98,   99,  100,  101,  102,  103,  104,  105,  113,
 /*   370 */   158,  203,  160,  161,  222,  223,  224,   10,   40,   41,
 /*   380 */   115,  169,  144,  171,  172,  217,  174,  175,   34,   22,
 /*   390 */   178,   31,  180,  181,  226,  227,  299,  300,  233,   39,
 /*   400 */   114,  236,  185,  235,  192,  119,   40,   41,  243,   55,
 /*   410 */   188,  125,  126,  127,  128,   61,    4,   79,   80,   81,
 /*   420 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   430 */    92,  115,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   440 */   102,  103,  104,  105,  115,  277,  114,  132,  133,   83,
 /*   450 */    84,  119,  300,  114,  116,  114,  288,  125,  126,  127,
 /*   460 */   128,  119,    4,   40,   41,  127,  127,  125,  126,  127,
 /*   470 */   128,  115,  140,   50,   80,   81,   82,  141,  142,   85,
 /*   480 */    86,   87,   88,   89,   90,   91,   92,  155,   94,   95,
 /*   490 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*   500 */   115,  163,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   510 */    87,   88,   89,   90,   91,   92,    4,   94,   95,   96,
 /*   520 */    97,   98,   99,  100,  101,  102,  103,  104,  105,   10,
 /*   530 */   203,  189,  116,  117,  222,  223,  224,  125,  126,  127,
 /*   540 */   128,   22,  114,  120,  217,   98,   99,  103,  104,  105,
 /*   550 */   223,  224,  140,  120,  146,  147,  148,   81,   82,   40,
 /*   560 */    41,   85,   86,   87,   88,   89,   90,   91,   92,  100,
 /*   570 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   580 */   104,  105,  115,  125,  126,  127,  128,  175,  141,  142,
 /*   590 */   115,  158,    4,  160,  161,  120,  138,  120,   79,   80,
 /*   600 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   610 */    91,   92,  300,   94,   95,   96,   97,   98,   99,  100,
 /*   620 */   101,  102,  103,  104,  105,  115,  299,  300,  159,  127,
 /*   630 */   120,  162,   78,  120,    4,  133,    4,  125,  126,   40,
 /*   640 */    41,  294,    4,  141,  142,  143,  169,   89,   90,   91,
 /*   650 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   660 */   102,  103,  104,  105,   24,    4,  115,   26,  114,  115,
 /*   670 */   273,  120,    4,  276,  120,  328,  329,  164,   79,   80,
 /*   680 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   690 */    91,   92,  120,   94,   95,   96,   97,   98,   99,  100,
 /*   700 */   101,  102,  103,  104,  105,    4,  215,  119,  255,    4,
 /*   710 */   219,  220,  221,  125,  126,  127,  128,   16,  265,  115,
 /*   720 */    79,   80,   81,   82,  120,   81,   85,   86,   87,   88,
 /*   730 */    89,   90,   91,   92,   19,   94,   95,   96,   97,   98,
 /*   740 */    99,  100,  101,  102,  103,  104,  105,    4,  203,    9,
 /*   750 */   182,   11,  184,   13,  114,   54,  203,  127,   43,  127,
 /*   760 */    71,  100,  217,   23,   34,  127,   26,  129,    4,  139,
 /*   770 */   217,  139,   71,    4,  186,  294,   75,  109,  116,  117,
 /*   780 */    65,   51,   81,   41,  203,   55,  125,  126,  127,  128,
 /*   790 */   203,   61,   52,  125,  126,  127,  128,   57,  217,   98,
 /*   800 */    99,  140,   62,   63,  217,  203,  162,  106,   68,  328,
 /*   810 */   329,   71,  210,   73,  212,  114,  115,  115,   42,  217,
 /*   820 */   119,  132,  120,  182,  123,  184,  125,  126,  127,  128,
 /*   830 */   125,  126,  127,  128,  133,  114,  175,    4,  219,  220,
 /*   840 */   221,  140,  141,  142,  143,  140,  225,   26,  267,  268,
 /*   850 */   110,  203,  112,  203,  233,  234,  255,  156,  157,   34,
 /*   860 */   155,  118,  119,  318,  319,  217,  265,  217,  125,  126,
 /*   870 */   127,  128,  319,  109,  226,  227,  175,  115,  109,  178,
 /*   880 */    55,  180,  181,  235,  203,  170,   61,  145,  207,  125,
 /*   890 */   126,  127,  128,  153,  125,  126,  127,  128,  217,  169,
 /*   900 */    79,   80,   81,   82,  317,   26,   85,   86,   87,   88,
 /*   910 */    89,   90,   91,   92,   34,   94,   95,   96,   97,   98,
 /*   920 */    99,  100,  101,  102,  103,  104,  105,    4,  115,  115,
 /*   930 */   190,    4,  107,  120,  203,   55,  288,  203,  120,   16,
 /*   940 */   115,   61,   19,  116,  117,  120,  162,  114,  217,  203,
 /*   950 */   203,  217,    4,  311,  312,  203,  182,  211,  125,  126,
 /*   960 */   127,  128,    4,  217,  217,  315,  203,  317,    4,  217,
 /*   970 */   145,  323,  226,  227,  326,  212,  242,   54,  226,  227,
 /*   980 */   217,  235,  164,  158,   15,  160,  161,  235,    4,  242,
 /*   990 */    67,  198,  199,  203,  169,  249,  171,  172,   75,  174,
 /*  1000 */   120,    4,   75,  182,   81,  184,   83,  217,  175,  263,
 /*  1010 */   264,    4,   43,  321,  322,  263,  264,  192,   34,  203,
 /*  1020 */   164,   98,   99,   16,  164,   98,   99,  296,   59,  106,
 /*  1030 */   296,  115,   14,  217,  288,   51,  120,  114,  145,   55,
 /*  1040 */   288,  114,  119,  296,   78,   61,  123,    4,  125,  126,
 /*  1050 */   127,  128,  125,  126,  127,    4,  133,   78,  165,  211,
 /*  1060 */   133,   54,  211,  140,  141,  142,  143,  119,  141,  142,
 /*  1070 */   143,   26,  282,  125,  126,  127,  128,  119,   71,    0,
 /*  1080 */   114,  115,   75,  125,  126,  127,  128,   41,   81,  125,
 /*  1090 */   126,  127,  128,  114,  115,   98,   99,  249,  175,  211,
 /*  1100 */   249,  178,  154,  180,  181,   98,   99,   81,   29,  125,
 /*  1110 */   126,  127,  128,  106,  298,   72,   71,  203,  260,  150,
 /*  1120 */   262,  114,  125,  126,  127,  128,  119,   81,    4,  132,
 /*  1130 */   123,  217,  125,  126,  127,  128,  211,  249,  141,  142,
 /*  1140 */   133,  203,  145,  179,  147,  187,   32,  140,  141,  142,
 /*  1150 */   143,  125,  107,  169,   13,  217,  196,  197,  198,  199,
 /*  1160 */   109,  321,  322,  156,  157,  122,  116,   53,  125,  126,
 /*  1170 */   127,  128,    4,  244,  249,  246,  125,  126,  127,  128,
 /*  1180 */   242,  244,  175,  246,  203,  178,  107,  180,  181,  275,
 /*  1190 */   120,  145,    4,   79,   80,   81,   82,  151,  217,   85,
 /*  1200 */    86,   87,   88,   89,   90,   91,   92,  120,   94,   95,
 /*  1210 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*  1220 */    79,   80,   81,   82,    4,  114,   85,   86,   87,   88,
 /*  1230 */    89,   90,   91,   92,  296,   94,   95,   96,   97,   98,
 /*  1240 */    99,  100,  101,  102,  103,  104,  105,    4,  107,  125,
 /*  1250 */   126,  127,  128,  217,  218,  115,  203,  115,  273,   16,
 /*  1260 */   120,  276,   19,  282,  140,   79,   80,   81,   82,   14,
 /*  1270 */   217,   85,   86,   87,   88,   89,   90,   91,   92,   77,
 /*  1280 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*  1290 */   104,  105,  168,  125,  126,  127,  128,   54,  250,  251,
 /*  1300 */   115,  253,  116,  289,  205,  120,  203,  119,  140,  203,
 /*  1310 */    67,   45,  211,  125,  126,  127,  128,  211,   75,    4,
 /*  1320 */   217,  203,  308,  217,   81,  207,  203,  274,  140,    4,
 /*  1330 */   321,  322,   60,  285,  219,  217,  168,   26,  115,  119,
 /*  1340 */   217,   98,   99,  120,    4,  125,  126,  127,  128,  106,
 /*  1350 */   249,    4,  321,  322,  115,  249,  168,  114,  203,  120,
 /*  1360 */   140,  203,  119,   80,  203,  242,  123,    4,  125,  126,
 /*  1370 */   127,  128,  217,  267,  268,  217,  133,  274,  217,   16,
 /*  1380 */   217,  266,   19,  140,  141,  142,  143,   32,  219,  226,
 /*  1390 */    79,   80,   81,   82,  295,  193,   85,   86,   87,   88,
 /*  1400 */    89,   90,   91,   92,  289,   94,   95,   96,   97,   98,
 /*  1410 */    99,  100,  101,  102,  103,  104,  105,   54,  175,  296,
 /*  1420 */    60,  178,  203,  180,  181,  169,  321,  322,   71,  274,
 /*  1430 */    67,   53,  274,  203,  119,  266,  217,  207,   75,  114,
 /*  1440 */   125,  126,  127,  128,   81,  226,  227,  217,  192,  203,
 /*  1450 */   125,  126,  127,  128,  235,  140,  203,  203,   14,  119,
 /*  1460 */     4,   98,   99,  217,  107,  125,  126,  127,  128,  106,
 /*  1470 */   217,  217,  125,  126,  127,  128,  315,  114,  317,  203,
 /*  1480 */   140,   14,  119,  207,  203,   14,  123,  140,  125,  126,
 /*  1490 */   127,  128,  219,  217,  213,  214,  133,   14,  217,  120,
 /*  1500 */   175,  219,  114,  140,  141,  142,  143,  288,  156,  157,
 /*  1510 */    79,   80,   81,   82,  268,   14,   85,   86,   87,   88,
 /*  1520 */    89,   90,   91,   92,    4,   94,   95,   96,   97,   98,
 /*  1530 */    99,  100,  101,  102,  103,  104,  105,  125,  175,  266,
 /*  1540 */   203,  178,  323,  180,  181,  326,  166,  115,  266,   79,
 /*  1550 */    80,   81,   82,  219,  217,   85,   86,   87,   88,   89,
 /*  1560 */    90,   91,   92,  115,   94,   95,   96,   97,   98,   99,
 /*  1570 */   100,  101,  102,  103,  104,  105,  203,  121,  115,  117,
 /*  1580 */   207,  125,  126,  127,  128,  115,   79,   80,   81,   82,
 /*  1590 */   217,  117,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  1600 */   266,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*  1610 */   103,  104,  105,  100,  183,  120,  229,  114,   79,   80,
 /*  1620 */    81,   82,  115,  115,   85,   86,   87,   88,   89,   90,
 /*  1630 */    91,   92,  114,   94,   95,   96,   97,   98,   99,  100,
 /*  1640 */   101,  102,  103,  104,  105,  125,  126,  127,  128,   79,
 /*  1650 */    80,   81,   82,  159,  115,   85,   86,   87,   88,   89,
 /*  1660 */    90,   91,   92,  203,   94,   95,   96,   97,   98,   99,
 /*  1670 */   100,  101,  102,  103,  104,  105,  289,  217,  115,  115,
 /*  1680 */   229,   79,   80,   81,   82,  115,  115,   85,   86,   87,
 /*  1690 */    88,   89,   90,   91,   92,  175,   94,   95,   96,   97,
 /*  1700 */    98,   99,  100,  101,  102,  103,  104,  105,  115,  114,
 /*  1710 */   173,    4,  115,   79,   80,   81,   82,  115,   48,   85,
 /*  1720 */    86,   87,   88,   89,   90,   91,   92,   18,   94,   95,
 /*  1730 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*  1740 */   289,  107,   79,   80,   81,   82,  114,    6,   85,   86,
 /*  1750 */    87,   88,   89,   90,   91,   92,  203,   94,   95,   96,
 /*  1760 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  116,
 /*  1770 */   217,  114,    8,   48,   79,   80,   81,   82,  114,  116,
 /*  1780 */    85,   86,   87,   88,   89,   90,   91,   92,    4,   94,
 /*  1790 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1800 */   105,  115,  107,   79,   80,   81,   82,   48,  114,   85,
 /*  1810 */    86,   87,   88,   89,   90,   91,   92,  114,   94,   95,
 /*  1820 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*  1830 */     4,  107,  125,  126,  127,  128,  114,   79,   80,   81,
 /*  1840 */    82,  137,   16,   85,   86,   87,   88,   89,   90,   91,
 /*  1850 */    92,  203,   94,   95,   96,   97,   98,   99,  100,  101,
 /*  1860 */   102,  103,  104,  105,    4,  217,   79,   80,   81,   82,
 /*  1870 */   163,  117,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  1880 */    54,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*  1890 */   103,  104,  105,  151,   81,  203,  203,  123,  114,  207,
 /*  1900 */   116,   75,  203,  203,  211,  116,  207,   81,  208,  217,
 /*  1910 */   217,  127,  164,  213,  214,    4,  217,  217,  117,  226,
 /*  1920 */   227,  203,  274,  203,   98,   99,  145,   13,  235,  203,
 /*  1930 */   203,  120,  106,  116,  107,  217,   88,  217,   88,   88,
 /*  1940 */   114,  115,  249,  217,  217,  119,    4,  163,  203,  123,
 /*  1950 */     4,  125,  126,  127,  128,  150,  263,   88,   16,  133,
 /*  1960 */    24,  176,  217,  203,  203,   18,  140,  141,  142,  143,
 /*  1970 */   203,  226,  227,    4,  114,  177,  157,  217,  217,  119,
 /*  1980 */   235,  288,  150,  107,  217,  125,  126,  127,  128,  203,
 /*  1990 */   107,  203,  195,  226,  227,  275,   54,  200,  203,  203,
 /*  2000 */   140,  175,  235,  217,  178,  217,  180,  181,  211,    4,
 /*  2010 */   203,   25,  217,  217,   60,  155,   49,   75,  203,   49,
 /*  2020 */     4,   16,  277,   81,  217,  120,  166,  167,  203,  185,
 /*  2030 */   263,  264,  217,  288,  114,  275,  125,  126,  127,  128,
 /*  2040 */    98,   99,  217,  145,  203,  248,  249,  113,  106,  203,
 /*  2050 */     4,  226,  227,  165,  114,  288,  114,  115,  217,   54,
 /*  2060 */   235,  119,  117,  217,  123,  123,  113,  125,  126,  127,
 /*  2070 */   128,  125,  126,  127,  128,  133,  279,  203,  281,  168,
 /*  2080 */    75,  284,  140,  141,  142,  143,   81,    4,  263,  264,
 /*  2090 */   117,  217,  203,  117,  125,  126,  127,  128,  117,   16,
 /*  2100 */   203,  117,  203,   98,   99,  111,  217,  310,  115,  140,
 /*  2110 */   115,  106,    4,  288,  217,  203,  217,  175,   47,  114,
 /*  2120 */   178,  175,  180,  181,  119,  203,  203,    4,  123,  217,
 /*  2130 */   125,  126,  127,  128,   46,  119,  289,   54,  133,  217,
 /*  2140 */   217,  125,  126,  127,  128,  140,  141,  142,  143,  216,
 /*  2150 */     4,  269,  203,  203,  203,  203,  140,  232,   75,  232,
 /*  2160 */   202,    4,   16,  203,   81,  119,  217,  217,  217,  217,
 /*  2170 */   312,  125,  126,  127,  128,  226,  227,  217,  203,    4,
 /*  2180 */   175,   98,   99,  178,  235,  180,  181,  182,  108,  106,
 /*  2190 */   203,  203,  217,  203,  314,  314,  204,  114,  115,  202,
 /*  2200 */    54,  155,  119,  203,  217,  217,  123,  217,  125,  126,
 /*  2210 */   127,  128,  263,  226,  227,  202,  133,  217,   63,  202,
 /*  2220 */   206,   75,  235,  140,  141,  142,  143,   81,    4,  204,
 /*  2230 */    76,   56,  203,  125,  126,  127,  128,  288,  120,    4,
 /*  2240 */    16,  203,  119,  209,   98,   99,  217,  117,  125,  126,
 /*  2250 */   127,  128,  106,  203,  203,  217,  156,  149,  175,  251,
 /*  2260 */   114,  178,  173,  180,  181,  119,  170,  217,  217,  123,
 /*  2270 */     4,  125,  126,  127,  128,  288,  119,  257,   54,  133,
 /*  2280 */   203,  272,  125,  126,  127,  128,  140,  141,  142,  143,
 /*  2290 */   258,  168,  259,  118,  217,  171,  261,  140,  172,   75,
 /*  2300 */   125,  126,  127,  128,  105,   81,  231,  114,  297,  105,
 /*  2310 */   116,  292,  325,  326,  316,  182,  211,  260,  169,  261,
 /*  2320 */   278,  175,   98,   99,  178,   44,  180,  181,  324,   27,
 /*  2330 */   106,  278,    4,  272,  324,  117,  157,   71,  114,  253,
 /*  2340 */   193,  329,  228,  119,  228,  203,  145,  123,  238,  125,
 /*  2350 */   126,  127,  128,  248,  249,   37,    4,  133,  230,  217,
 /*  2360 */   125,  126,  127,  128,  140,  141,  142,  143,  226,  227,
 /*  2370 */   144,  228,  228,  138,  238,  206,  231,  235,  228,  228,
 /*  2380 */   114,  115,  206,  231,  279,  119,  281,  228,  228,  284,
 /*  2390 */   117,  125,  126,  127,  128,  231,  303,  272,    4,  175,
 /*  2400 */    33,  203,  178,    4,  180,  181,  140,  304,  174,    4,
 /*  2410 */   182,  306,  203,  257,  203,  217,  245,  203,  280,  277,
 /*  2420 */    79,  155,  156,  157,  226,  227,  217,    4,  217,  261,
 /*  2430 */   288,  217,    4,  235,  260,  226,  227,  226,  227,  257,
 /*  2440 */   226,  227,    4,  280,  235,  260,  235,    4,  261,  235,
 /*  2450 */   283,    4,  203,  125,  126,  127,  128,  114,    4,  286,
 /*  2460 */   145,  263,  257,    4,  280,  245,  217,  206,    4,  280,
 /*  2470 */   117,  206,  263,    4,  272,  226,  227,  125,  126,  127,
 /*  2480 */   128,  117,  203,  247,  235,    4,  288,  257,  277,  272,
 /*  2490 */     4,  277,   76,  247,  166,  247,  217,  288,  247,  288,
 /*  2500 */   176,    4,  288,  272,  298,  226,  227,    4,  114,  117,
 /*  2510 */   307,    4,   20,  272,  235,  307,    4,  117,  166,  125,
 /*  2520 */   126,  127,  128,  118,  125,  126,  127,  128,    4,  272,
 /*  2530 */   125,  126,  127,  128,  117,   17,  309,  288,    4,  140,
 /*  2540 */   291,  309,  263,    4,  254,  256,  229,    4,  125,  126,
 /*  2550 */   127,  128,  289,  125,  126,  127,  128,  293,    4,  300,
 /*  2560 */   300,  260,  271,  125,  126,  127,  128,  288,  125,  126,
 /*  2570 */   127,  128,  125,  126,  127,  128,    4,  154,  140,  125,
 /*  2580 */   126,  127,  128,  140,  125,  126,  127,  128,  229,  125,
 /*  2590 */   126,  127,  128,  260,  125,  126,  127,  128,  236,  140,
 /*  2600 */     4,  240,  230,  256,  140,  257,  125,  126,  127,  128,
 /*  2610 */   163,  125,  126,  127,  128,  118,  188,  163,    4,  287,
 /*  2620 */   201,  140,  125,  126,  127,  128,  140,  254,  125,  126,
 /*  2630 */   127,  128,  125,  126,  127,  128,  301,  125,  126,  127,
 /*  2640 */   128,  219,  302,  219,  219,  219,  290,  252,  246,  125,
 /*  2650 */   126,  127,  128,  327,  270,  186,  226,  118,  155,  125,
 /*  2660 */   126,  127,  128,  313,  125,  126,  127,  128,  125,  126,
 /*  2670 */   127,  128,  237,  237,  140,  168,    4,  237,  226,  125,
 /*  2680 */   126,  127,  128,  241,   71,  330,  330,  330,  330,  330,
 /*  2690 */   330,  330,  330,  330,  330,  330,  330,  125,  126,  127,
 /*  2700 */   128,  189,  330,  203,  330,  330,  330,  330,  330,  330,
 /*  2710 */   330,  187,  330,  330,  118,  330,  330,  217,  175,  330,
 /*  2720 */   203,  125,  126,  127,  128,  330,  226,  227,  330,  175,
 /*  2730 */   330,  203,  330,  330,  217,  235,  203,  330,  124,  125,
 /*  2740 */   126,  127,  128,  226,  227,  217,  330,  203,  176,  330,
 /*  2750 */   217,  203,  235,  203,  226,  227,  330,  330,  203,  226,
 /*  2760 */   227,  217,  330,  235,  330,  217,  330,  217,  235,  330,
 /*  2770 */   226,  227,  217,  330,  226,  227,  226,  227,  203,  235,
 /*  2780 */   203,  226,  227,  235,  330,  235,  330,  330,  288,  330,
 /*  2790 */   235,  330,  217,  330,  217,  203,  330,  125,  126,  127,
 /*  2800 */   128,  226,  227,  226,  227,  288,  330,  330,  330,  217,
 /*  2810 */   235,  330,  235,  330,  330,  330,  288,  330,  226,  227,
 /*  2820 */   330,  288,  330,  330,  330,  203,  330,  235,  203,  330,
 /*  2830 */   203,  330,  288,  330,  330,  330,  288,  330,  288,  217,
 /*  2840 */   330,  330,  217,  288,  217,  330,  330,  330,  226,  227,
 /*  2850 */   330,  226,  227,  226,  227,  203,  330,  235,  330,  203,
 /*  2860 */   235,  203,  235,  288,  330,  288,  330,  330,  330,  217,
 /*  2870 */   330,  330,  203,  217,  203,  217,  330,  330,  226,  227,
 /*  2880 */   288,  330,  226,  227,  226,  227,  217,  235,  217,  330,
 /*  2890 */   330,  235,  330,  235,  330,  226,  227,  226,  227,  330,
 /*  2900 */   330,  330,  203,  330,  235,  203,  235,  203,  330,  330,
 /*  2910 */   288,  330,  330,  288,  330,  288,  217,  330,  203,  217,
 /*  2920 */   330,  217,  330,  330,  203,  226,  227,  330,  226,  227,
 /*  2930 */   226,  227,  217,  330,  235,  330,  330,  235,  217,  235,
 /*  2940 */   288,  226,  227,  330,  288,  330,  288,  226,  227,  203,
 /*  2950 */   235,  203,  330,  330,  203,  330,  235,  288,  330,  288,
 /*  2960 */   330,  330,  330,  217,  330,  217,  330,  330,  217,  330,
 /*  2970 */   330,  330,  226,  227,  226,  227,  330,  226,  227,  330,
 /*  2980 */   330,  235,  203,  235,  203,  330,  235,  288,  330,  330,
 /*  2990 */   288,  330,  288,  330,  330,  330,  217,  330,  217,  203,
 /*  3000 */   330,  330,  330,  288,  330,  226,  227,  226,  227,  288,
 /*  3010 */   330,  330,  330,  217,  235,  330,  235,  330,  330,  330,
 /*  3020 */   330,  330,  226,  227,  330,  330,  330,  330,  330,  203,
 /*  3030 */   330,  235,  203,  330,  288,  330,  288,  330,  330,  288,
 /*  3040 */   330,  330,  330,  217,  330,  330,  217,  330,  203,  330,
 /*  3050 */   330,  330,  226,  227,  330,  226,  227,  330,  330,  203,
 /*  3060 */   330,  235,  217,  203,  235,  203,  330,  288,  330,  288,
 /*  3070 */   330,  226,  227,  217,  330,  330,  203,  217,  203,  217,
 /*  3080 */   235,  330,  226,  227,  288,  330,  226,  227,  226,  227,
 /*  3090 */   217,  235,  217,  330,  330,  235,  330,  235,  330,  226,
 /*  3100 */   227,  226,  227,  330,  330,  330,  203,  330,  235,  330,
 /*  3110 */   235,  203,  330,  330,  288,  330,  330,  288,  330,  330,
 /*  3120 */   217,  330,  203,  330,  330,  217,  330,  330,  203,  226,
 /*  3130 */   227,  330,  330,  288,  226,  227,  217,  330,  235,  330,
 /*  3140 */   330,  203,  217,  235,  288,  226,  227,  330,  288,  330,
 /*  3150 */   288,  226,  227,  203,  235,  217,  330,  330,  203,  330,
 /*  3160 */   235,  288,  330,  288,  226,  227,  330,  217,  330,  203,
 /*  3170 */   330,  330,  217,  235,  330,  330,  226,  227,  330,  330,
 /*  3180 */   330,  226,  227,  217,  330,  235,  203,  330,  203,  330,
 /*  3190 */   235,  288,  226,  227,  330,  330,  288,  330,  330,  330,
 /*  3200 */   217,  235,  217,  330,  330,  330,  330,  288,  330,  226,
 /*  3210 */   227,  226,  227,  288,  330,  330,  330,  203,  235,  330,
 /*  3220 */   235,  330,  330,  330,  330,  330,  288,  330,  330,  330,
 /*  3230 */   330,  217,  330,  203,  330,  330,  330,  330,  288,  330,
 /*  3240 */   226,  227,  330,  288,  330,  330,  330,  217,  330,  235,
 /*  3250 */   330,  330,  330,  330,  288,  330,  226,  227,  330,  330,
 /*  3260 */   330,  330,  330,  330,  330,  235,  330,  330,  330,  330,
 /*  3270 */   330,  288,  330,  288,  330,  330,  330,  330,  330,  330,
 /*  3280 */   330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
 /*  3290 */   330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
 /*  3300 */   330,  330,  288,  330,  330,  330,  330,  330,  330,  330,
 /*  3310 */   330,  330,  330,  330,  330,  330,  330,  330,  288,
};
#define YY_SHIFT_USE_DFLT (-107)
#define YY_SHIFT_COUNT (542)
#define YY_SHIFT_MIN   (-106)
#define YY_SHIFT_MAX   (2672)
static const short yy_shift_ofst[] = {
 /*     0 */   154,  701, 1007,  740,  923, 1363, 1243, 2083, 2083, 2083,
 /*    10 */  1357,  212, 2005, 2146, 2146, 2146, 2224, 2146, 2146, 2146,
 /*    20 */  2146, 1045,   -4,  104, 1942, 1826, 2146, 2146, 2146, 2146,
 /*    30 */  2146, 2146, 2146, 2146, 2146, 2146, 2146, 2146, 2146, 2146,
 /*    40 */  2146, 2146, 2146, 2146, 2146, 2146, 2146, 2146, 2146, 2146,
 /*    50 */  2146, 2146, 2146, 2146, 2146, 2146, 2146, 2146, 2146, 2146,
 /*    60 */  2224, 2146, 2146, 2146, 2146, 2146, 2146, 2146, 2146, 2146,
 /*    70 */  2146, 2146, 2266,  997,  997,   65,  984,  984, 2614, 1860,
 /*    80 */  2175, 1043, 2614,  124, 2543, 2543, 2543, 2596, 2543, 2672,
 /*    90 */   447,  447,  638,  338,  172,  332, 2157,  342, 2123, 2046,
 /*   100 */  2016, 1325, 1340, 1325, 1315, 1220,  948, 1043,  743, 2572,
 /*   110 */  2554, 2554, 2554, 2554, 2554, 2543, 2672, 2672, 1046,  638,
 /*   120 */  1202, 1202, 1352,  519,  519,  -43,  927,  129, 1188,  661,
 /*   130 */  1168, 1124,  958,   87,  588,  833,  222,  705,  412,  286,
 /*   140 */  2539, 2534, 2524, 2512, 2507, 2503, 2486, 2497, 2481, 2469,
 /*   150 */  2464, 2459, 2454, 2447, 2443, 2438, 2428, 2423, 2405, 2399,
 /*   160 */  2235, 2108, 1969, 2394, 2352, 2328, 1911, 1707, 1946,  964,
 /*   170 */  1520, 1347,  458, 1456, 1051,  769,  764,  668, 2672, 2672,
 /*   180 */    35,   35, 1784,  730,   -2,   -2,   -2,  880,  880,  117,
 /*   190 */   512,  354,  354, 1079,  689, 1026, 1026, 1026, 1256, 2613,
 /*   200 */  2613, 2613, 2613, -107, -107, -107,  423,  599,  599,  599,
 /*   210 */   599,  599,  599,  599,  599,  599,  599,  821,  641, 1141,
 /*   220 */  1114, 1724, 1695, 1663, 1634, 1602, 1570, 1539, 1507, 1470,
 /*   230 */  1431, 1311,  -71, 1186, 1787, 1758,  394,  476,  476,  558,
 /*   240 */   -16,  -16,  -16,  -16,  -16,  -16,   48,  263,  138,   28,
 /*   250 */   502,  502,  554,  -15,  969,  969,  969,    6,  715,  294,
 /*   260 */   433,  366,  408,   94,  632,  630,  339,  444,  174,  469,
 /*   270 */   323,   77, 1239,  818,  238, 1223,  742,  367,  893,  477,
 /*   280 */   477,  568,  367,  336,  336,  644,  513,  101, 2518, 2518,
 /*   290 */  2417, 2400, 2492, 2492, 2392, 2324, 2416, 2416, 2416, 2416,
 /*   300 */  2364, 2154, 2089, 2353, 2154, 2341, 2234, 2089, 2234, 2315,
 /*   310 */  2343, 2126, 2149, 2234, 2089, 2341, 2126, 2149, 2234, 2089,
 /*   320 */  2228, 2367, 2273, 2154, 2193, 2154, 2193, 2201, 2201, 2201,
 /*   330 */  2201, 2318, 2193, 2201, 2226, 2201, 2318, 2201, 2201, 2147,
 /*   340 */  2179, 2218, 2302, 2302, 2281, 2281, 2126, 2149, 2133, 2194,
 /*   350 */  2204, 2193, 2199, 2199, 2126, 2124, 2096, 2089, 2100, 2130,
 /*   360 */  2118, 2154, 2155, 2155, 2080, 2080, 2080, 2080, -107, -107,
 /*   370 */  -107, -107, -107, -107, -107, -107, -107, -107,  825,  217,
 /*   380 */   -61,  979,  966,  -80,  256,  246, 1185, 1140,  -50,  916,
 /*   390 */   640,  827,  813,  702,  662,  416,  604,  551,  315,  -14,
 /*   400 */   100,  510,  475,  360,  144,  213,  197,   20,   -7, 2088,
 /*   410 */  2071, 1994, 1984, 1953, 1995, 1993, 1981, 1976, 1973, 1941,
 /*   420 */  1945, 1940, 1888, 1934, 1920, 1898, 1844, 1970, 1905, 1967,
 /*   430 */  1954, 1986, 1883, 1876, 1819, 1798, 1832, 1936, 1947, 1827,
 /*   440 */  1785, 1869, 1851, 1850, 1848, 1805, 1811, 1817, 1748, 1914,
 /*   450 */  1781, 1801, 1789, 1774, 1813, 1754, 1742, 1704, 1722, 1759,
 /*   460 */  1703, 1694, 1686, 1664, 1725, 1764, 1657, 1653, 1741, 1632,
 /*   470 */  1670, 1709, 1597, 1537, 1595, 1593, 1571, 1564, 1563, 1495,
 /*   480 */  1494, 1518, 1508, 1503, 1495, 1513, 1474, 1462, 1380, 1463,
 /*   490 */  1448, 1379, 1432, 1412, 1501, 1388, 1379, 1483, 1471, 1467,
 /*   500 */  1444, 1378, 1360, 1355, 1283, 1272, 1266, 1255, 1142, 1111,
 /*   510 */  1050, 1087, 1070, 1018,  860,  856,  784,  814,  774,  879,
 /*   520 */   572,  762,  721,  776,  572,  467,  428,  385,  356,  341,
 /*   530 */   329,  316,  265,  147,   90,   58,    1,   22,   -1,  -48,
 /*   540 */   -74,  -76, -106,
};
#define YY_REDUCE_USE_DFLT (-248)
#define YY_REDUCE_COUNT (377)
#define YY_REDUCE_MIN   (-247)
#define YY_REDUCE_MAX   (3030)
static const short yy_reduce_ofst[] = {
 /*     0 */   960,  746, 1693, 1797, 1219, 1987,  648, 1825, 1767,  752,
 /*    10 */    10, 2279, 2249, 2214, 2211, 1949, 2142, 1745, 2209, 2198,
 /*    20 */   168, 2105, 3030, 3014, 2985, 2983, 2966, 2955, 2950, 2938,
 /*    30 */  2925, 2919, 2908, 2903, 2875, 2873, 2862, 2860, 2856, 2845,
 /*    40 */  2829, 2826, 2796, 2781, 2779, 2751, 2748, 2746, 2721, 2715,
 /*    50 */  2704, 2702, 2699, 2671, 2669, 2658, 2656, 2652, 2627, 2625,
 /*    60 */  2622, 2592, 2577, 2575, 2555, 2550, 2548, 2544, 2533, 2528,
 /*    70 */  2517, 2500, 1106,  327,   97,  -19,  -86, -113, 1700,  581,
 /*    80 */  1161,  602, 1281, 1048, 1123,  938,  747,  650,  734,  545,
 /*    90 */   312,  152,  491, 1115,  621, 1246, 1699, 1692, 1373, 1276,
 /*   100 */  1118,  981, 1760,  790, 1720,  914, 1230,  763,  681,  816,
 /*   110 */  1648, 1158, 1155, 1103, 1053,  731,  553,  587,  165,  619,
 /*   120 */   481,  347, -247, 1451, 1387, 1014, 1163, 2077, 2051, 1988,
 /*   130 */  1761, 1761, 2050, 2038, 2029, 2000, 1990, 1761, 1988, 1975,
 /*   140 */  1960, 1912, 1761, 1912, 1912, 1912, 1912, 1761, 1952, 1761,
 /*   150 */  1923, 1923, 1951, 1950, 1923, 1922, 1761, 1912, 1912, 1899,
 /*   160 */  1897, 1889, 1874, 1846, 1841, 1815, 1807, 1796, 1795, 1788,
 /*   170 */  1786, 1761, 1727, 1726, 1718, 1553, 1460, 1337, 1254, 1253,
 /*   180 */   937,  929, 1334, 1105, 1282, 1273, 1169, 1031, 1009, 1099,
 /*   190 */  1036,  840,  692,  793, 1101,  985,  397,   19,  858,  925,
 /*   200 */   888,  851,  848,  642,  601,  453, 1847, 1847, 1847, 1847,
 /*   210 */  1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847,
 /*   220 */  1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847,
 /*   230 */  1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847,
 /*   240 */  1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 1847, 2442,
 /*   250 */  2452, 2430, 2350, 2350, 2440, 2436, 2435, 2384, 2326, 2402,
 /*   260 */  2395, 2356, 2340, 2335, 2426, 2425, 2424, 1847, 2422, 2373,
 /*   270 */  2419, 2348, 2332, 2347, 2372, 2361, 2362, 2359, 2291, 2333,
 /*   280 */  2301, 2264, 2317, 2260, 2259, 2263, 2289, 2290, 2232, 2227,
 /*   290 */  2257, 2241, 2208, 2203, 2231, 2206, 2251, 2248, 2246, 2236,
 /*   300 */  2217, 2265, 2230, 2202, 2261, 2220, 2189, 2205, 2184, 2173,
 /*   310 */  2167, 2187, 2185, 2163, 2182, 2171, 2168, 2174, 2138, 2156,
 /*   320 */  2103, 2093, 2125, 2176, 2164, 2169, 2152, 2160, 2159, 2151,
 /*   330 */  2150, 2136, 2145, 2144, 2128, 2143, 2110, 2116, 2114, 2012,
 /*   340 */  2086, 2061, 2010, 2004, 2053, 2042, 2058, 2057, 2019, 1998,
 /*   350 */  2011, 2075, 1847, 1847, 2035, 2033, 2032, 2020, 2008, 2009,
 /*   360 */  2034, 2014, 2025, 1992, 2017, 2013, 1997, 1958, 1881, 1880,
 /*   370 */  1858, 1927, 1925, 1882, 1847, 1847, 1847, 1933,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   889, 1219, 1219, 1341, 1219, 1219, 1219, 1219, 1219, 1219,
 /*    10 */  1341, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*    20 */  1219, 1341, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*    30 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*    40 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*    50 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*    60 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*    70 */  1219, 1219, 1074, 1383, 1383, 1383, 1360, 1360, 1383, 1067,
 /*    80 */  1383,  917, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
 /*    90 */  1383, 1383,  941, 1063,  930, 1074, 1383, 1383, 1383, 1383,
 /*   100 */  1383, 1144, 1159, 1144, 1136, 1125, 1383, 1383, 1383, 1257,
 /*   110 */  1152, 1152, 1152, 1152, 1152, 1383, 1383, 1383, 1014, 1383,
 /*   120 */  1187, 1186, 1383, 1110, 1110, 1221, 1383, 1310, 1315, 1180,
 /*   130 */  1383, 1383, 1383, 1383, 1383, 1145, 1383, 1075, 1180, 1383,
 /*   140 */  1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
 /*   150 */  1160, 1137, 1383, 1383, 1126, 1383, 1383, 1383, 1383, 1383,
 /*   160 */  1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
 /*   170 */  1182, 1383, 1383, 1383, 1383, 1383, 1383,  895, 1383, 1383,
 /*   180 */  1383, 1383, 1063, 1360, 1063, 1063, 1063, 1360, 1360,  927,
 /*   190 */   935, 1360, 1360,  889, 1341, 1099, 1099, 1099, 1104, 1341,
 /*   200 */  1341, 1341, 1341, 1334, 1053, 1053, 1120, 1143, 1142, 1141,
 /*   210 */  1140, 1080, 1130, 1118, 1122, 1234, 1121, 1221, 1221, 1221,
 /*   220 */  1221, 1221, 1221, 1221, 1221, 1221, 1221, 1221, 1221, 1221,
 /*   230 */  1221, 1221, 1221, 1221, 1221, 1221, 1189, 1203, 1188, 1196,
 /*   240 */  1208, 1197, 1202, 1201, 1200, 1191, 1190, 1192, 1193, 1383,
 /*   250 */  1383, 1383, 1383, 1383, 1383, 1383, 1383, 1066, 1383, 1383,
 /*   260 */  1036, 1383, 1383, 1284, 1383, 1383,  943, 1194, 1383, 1051,
 /*   270 */   898, 1129, 1223, 1064,  981, 1005,  965, 1110, 1082, 1104,
 /*   280 */  1104, 1229, 1110, 1383, 1383, 1221, 1064, 1051, 1325, 1325,
 /*   290 */  1083, 1083, 1309, 1309, 1083, 1257, 1027, 1027, 1027, 1027,
 /*   300 */  1083,  924, 1129, 1083,  924, 1018, 1132, 1129, 1132, 1165,
 /*   310 */  1148, 1119, 1104, 1132, 1129, 1018, 1119, 1104, 1132, 1129,
 /*   320 */  1291, 1289, 1083,  924, 1242,  924, 1242, 1016, 1016, 1016,
 /*   330 */  1016,  997, 1242, 1016,  981, 1016,  997, 1016, 1016, 1379,
 /*   340 */  1383, 1083, 1370, 1370, 1113, 1113, 1119, 1104, 1383, 1383,
 /*   350 */  1248, 1242, 1207, 1195, 1119, 1117, 1114, 1129, 1383, 1083,
 /*   360 */  1000,  924,  906,  906,  894,  894,  894,  894, 1338, 1338,
 /*   370 */  1334,  983,  983, 1069, 1206, 1205, 1204,  952, 1220, 1383,
 /*   380 */  1383, 1383, 1383, 1383, 1383, 1258, 1383, 1383, 1383, 1383,
 /*   390 */  1383, 1087, 1383, 1383, 1087, 1087, 1383, 1383, 1383, 1383,
 /*   400 */  1383, 1383, 1383, 1383, 1344, 1383, 1383, 1383, 1383, 1383,
 /*   410 */   890, 1383, 1085, 1383, 1383, 1383, 1085, 1085, 1085, 1383,
 /*   420 */  1085, 1328, 1383, 1383, 1383, 1383, 1383, 1383, 1288, 1287,
 /*   430 */  1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1149,
 /*   440 */  1383, 1383, 1383, 1383, 1383, 1383, 1133, 1088, 1383, 1276,
 /*   450 */  1383, 1085, 1383, 1383, 1383, 1085, 1383, 1383, 1383, 1383,
 /*   460 */  1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
 /*   470 */  1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1039,
 /*   480 */  1045, 1383, 1383, 1383, 1040, 1383, 1383, 1178, 1383, 1383,
 /*   490 */  1383, 1232, 1383, 1383, 1383, 1383, 1115, 1383, 1383, 1383,
 /*   500 */  1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
 /*   510 */  1383, 1376, 1105, 1383, 1383, 1383, 1222, 1383, 1220, 1383,
 /*   520 */  1343, 1383, 1383, 1383, 1342, 1383, 1383, 1383, 1383, 1383,
 /*   530 */  1383, 1383, 1383, 1383, 1383, 1179, 1178, 1222,  938,  913,
 /*   540 */  1383,  904, 1383,  886,  891, 1327, 1324, 1321, 1326, 1320,
 /*   550 */  1322, 1319, 1323, 1318, 1316, 1317, 1314, 1312, 1311, 1313,
 /*   560 */  1308, 1304, 1264, 1262, 1260, 1269, 1268, 1267, 1266, 1265,
 /*   570 */  1261, 1259, 1263, 1255, 1254, 1155, 1134, 1123, 1034, 1303,
 /*   580 */  1301, 1302, 1253, 1251, 1252, 1033, 1032, 1031, 1026, 1025,
 /*   590 */  1024, 1023, 1331, 1340, 1339, 1337, 1336, 1335, 1329, 1330,
 /*   600 */  1240, 1239, 1237, 1236, 1238,  926, 1280, 1283, 1282, 1281,
 /*   610 */  1286, 1285, 1278, 1290, 1295, 1294, 1299, 1298, 1297, 1296,
 /*   620 */  1293, 1275, 1164, 1163, 1161, 1157, 1168, 1167, 1166, 1156,
 /*   630 */  1158, 1162, 1139, 1147, 1146, 1135, 1138, 1019, 1128, 1124,
 /*   640 */  1092, 1090, 1127, 1091, 1089, 1035, 1279, 1030, 1029, 1028,
 /*   650 */   925,  916, 1086,  915,  914,  929, 1003, 1004, 1012, 1015,
 /*   660 */  1010, 1013, 1009, 1008, 1007, 1011, 1006, 1002,  932,  931,
 /*   670 */   942,  996,  979,  968,  934,  970,  967,  966,  971,  988,
 /*   680 */   987,  994,  993,  992,  991,  990,  986,  989,  985,  984,
 /*   690 */   972,  964,  963,  982,  962,  999,  998,  995,  961, 1022,
 /*   700 */  1021, 1020, 1017,  960,  959,  958,  957,  956,  955, 1218,
 /*   710 */  1382, 1378, 1381, 1380, 1377, 1217, 1225, 1211, 1209, 1037,
 /*   720 */  1048, 1047, 1046, 1043, 1044, 1058, 1056, 1055, 1054, 1098,
 /*   730 */  1097, 1096, 1095, 1094, 1093, 1079, 1077, 1072, 1071, 1078,
 /*   740 */  1076, 1073, 1102, 1103, 1101, 1100, 1070, 1062, 1060, 1061,
 /*   750 */  1059, 1154, 1151, 1153, 1150, 1081, 1068, 1065, 1052, 1358,
 /*   760 */  1356, 1359, 1357, 1355, 1363, 1365, 1364, 1369, 1367, 1366,
 /*   770 */  1362, 1375, 1374, 1373, 1372, 1371, 1361, 1368, 1354, 1353,
 /*   780 */  1352, 1351, 1107, 1112, 1111, 1106, 1042, 1210, 1220, 1214,
 /*   790 */  1349, 1347, 1350, 1346, 1345, 1245, 1247, 1250, 1249, 1246,
 /*   800 */  1109, 1108, 1244, 1243, 1348, 1213, 1185,  948,  946,  947,
 /*   810 */  1272, 1271, 1274, 1273, 1270,  950,  949,  945,  944, 1183,
 /*   820 */  1177, 1176, 1300, 1215, 1216, 1175, 1181, 1173, 1172, 1171,
 /*   830 */  1199, 1198, 1184, 1174,  937,  936, 1041, 1038, 1212, 1170,
 /*   840 */  1084, 1169,  978,  977,  976,  975,  974,  973, 1050, 1049,
 /*   850 */   954,  969,  953,  951,  928,  918,  923,  921,  922,  920,
 /*   860 */   919,  911,  908,  910,  907,  912,  909,  905,  903,  902,
 /*   870 */   901,  900,  899,  940,  939,  938,  933,  897,  896,  893,
 /*   880 */   892,  888,  887,  885,
};

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
**
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*      SPACE => nothing */
    0,  /*         ID => nothing */
    4,  /*      ABORT => ID */
    4,  /*     ACTION => ID */
    4,  /*      AFTER => ID */
    4,  /*     ALWAYS => ID */
    4,  /*    ANALYZE => ID */
    4,  /*        ASC => ID */
    4,  /*     ATTACH => ID */
    4,  /*     BEFORE => ID */
    4,  /*      BEGIN => ID */
    4,  /*         BY => ID */
    4,  /*    CASCADE => ID */
    4,  /*       CAST => ID */
    4,  /*   COLUMNKW => ID */
    4,  /*   CONFLICT => ID */
    4,  /*    CURRENT => ID */
    4,  /*   DATABASE => ID */
    4,  /*   DEFERRED => ID */
    4,  /*       DESC => ID */
    4,  /*     DETACH => ID */
    4,  /*         DO => ID */
    4,  /*       EACH => ID */
    4,  /*        END => ID */
    4,  /*    EXCLUDE => ID */
    4,  /*  EXCLUSIVE => ID */
    4,  /*    EXPLAIN => ID */
    4,  /*       FAIL => ID */
    4,  /*      FIRST => ID */
    4,  /*  FOLLOWING => ID */
    4,  /*        FOR => ID */
    4,  /*     GROUPS => ID */
    4,  /*     IGNORE => ID */
    4,  /*  IMMEDIATE => ID */
    4,  /*  INITIALLY => ID */
    4,  /*    INSTEAD => ID */
    4,  /*       LAST => ID */
    4,  /*    LIKE_KW => ID */
    4,  /*      MATCH => ID */
    4,  /* MATERIALIZED => ID */
    4,  /*         NO => ID */
    4,  /*      NULLS => ID */
    4,  /*     OTHERS => ID */
    4,  /*       PLAN => ID */
    4,  /*      QUERY => ID */
    4,  /*        KEY => ID */
    4,  /*         OF => ID */
    4,  /*     OFFSET => ID */
    4,  /*  PARTITION => ID */
    4,  /*     PRAGMA => ID */
    4,  /*  PRECEDING => ID */
    4,  /*      RAISE => ID */
    4,  /*      RANGE => ID */
    4,  /*  RECURSIVE => ID */
    4,  /*    RELEASE => ID */
    4,  /*    REPLACE => ID */
    4,  /*   RESTRICT => ID */
    4,  /*        ROW => ID */
    4,  /*       ROWS => ID */
    4,  /*   ROLLBACK => ID */
    4,  /*  SAVEPOINT => ID */
    4,  /*       TEMP => ID */
    4,  /*       TIES => ID */
    4,  /*    TRIGGER => ID */
    4,  /*  UNBOUNDED => ID */
    4,  /*     VACUUM => ID */
    4,  /*       VIEW => ID */
    4,  /*    VIRTUAL => ID */
    4,  /*       WITH => ID */
    4,  /*    WITHOUT => ID */
    4,  /*    REINDEX => ID */
    4,  /*     RENAME => ID */
    4,  /*   CTIME_KW => ID */
    4,  /*         IF => ID */
    4,  /*     FILTER => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
  QList<Token*>* tokens = nullptr;
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3_parseARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

void *sqlite3_parseCopyParserState(void* other)
{
  yyParser *pParser;
  yyParser *otherParser = (yyParser*)other;

  // Copy parser
  pParser = (yyParser*)malloc((size_t)sizeof(yyParser));
  memcpy(pParser, other, (size_t)sizeof(yyParser));

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = malloc((size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)other)->yystack, (size_t)stackSize);
#endif

  for (int i = 0; i <= pParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(otherParser->yystack[i].tokens);
  }

  return pParser;
}

void sqlite3_parseAddToken(void* other, Token* token)
{
    yyParser *otherParser = (yyParser*)other;
    if (otherParser->yyidx < 0)
        return; // Nothing on stack yet. Might happen when parsing just whitespaces, nothing else.

    otherParser->yystack[otherParser->yyidx].tokens->append(token);
}

void sqlite3_parseRestoreParserState(void* saved, void* target)
{
  yyParser *pParser = (yyParser*)target;
  yyParser *savedParser = (yyParser*)saved;

  for (int i = 0; i <= pParser->yyidx; i++)
      delete pParser->yystack[i].tokens;

  memcpy(pParser, saved, (size_t)sizeof(yyParser));

  for (int i = 0; i <= savedParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(savedParser->yystack[i].tokens);
  }

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = relloc(pParser->yystack, (size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)saved)->yystack, (size_t)stackSize);
#endif
}

void sqlite3_parseFreeSavedState(void* other)
{
    yyParser *pParser = (yyParser*)other;
    for (int i = 0; i <= pParser->yyidx; i++)
        delete pParser->yystack[i].tokens;

#if YYSTACKDEPTH<=0
    free(pParser->yystack);
#endif
    free(other);
}

#ifndef NDEBUG
/*
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3_parseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = {
  "$",             "ILLEGAL",       "COMMENT",       "SPACE",       
  "ID",            "ABORT",         "ACTION",        "AFTER",       
  "ALWAYS",        "ANALYZE",       "ASC",           "ATTACH",      
  "BEFORE",        "BEGIN",         "BY",            "CASCADE",     
  "CAST",          "COLUMNKW",      "CONFLICT",      "CURRENT",     
  "DATABASE",      "DEFERRED",      "DESC",          "DETACH",      
  "DO",            "EACH",          "END",           "EXCLUDE",     
  "EXCLUSIVE",     "EXPLAIN",       "FAIL",          "FIRST",       
  "FOLLOWING",     "FOR",           "GROUPS",        "IGNORE",      
  "IMMEDIATE",     "INITIALLY",     "INSTEAD",       "LAST",        
  "LIKE_KW",       "MATCH",         "MATERIALIZED",  "NO",          
  "NULLS",         "OTHERS",        "PLAN",          "QUERY",       
  "KEY",           "OF",            "OFFSET",        "PARTITION",   
  "PRAGMA",        "PRECEDING",     "RAISE",         "RANGE",       
  "RECURSIVE",     "RELEASE",       "REPLACE",       "RESTRICT",    
  "ROW",           "ROWS",          "ROLLBACK",      "SAVEPOINT",   
  "TEMP",          "TIES",          "TRIGGER",       "UNBOUNDED",   
  "VACUUM",        "VIEW",          "VIRTUAL",       "WITH",        
  "WITHOUT",       "REINDEX",       "RENAME",        "CTIME_KW",    
  "IF",            "FILTER",        "ANY",           "OR",          
  "AND",           "NOT",           "IS",            "BETWEEN",     
  "IN",            "ISNULL",        "NOTNULL",       "NE",          
  "EQ",            "GT",            "LE",            "LT",          
  "GE",            "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "PTR",           "COLLATE",       "BITNOT",        "SEMI",        
  "TRANSACTION",   "ID_TRANS",      "COMMIT",        "TO",          
  "CREATE",        "TABLE",         "LP",            "RP",          
  "AS",            "DOT",           "ID_TAB_NEW",    "ID_DB",       
  "COMMA",         "CTX_ROWID_KW",  "CTX_STRICT_KW",  "EXISTS",      
  "ID_COL_NEW",    "INDEXED",       "GENERATED",     "STRING",      
  "JOIN_KW",       "ID_COL_TYPE",   "RIGHT_ASSOC",   "CONSTRAINT",  
  "DEFAULT",       "NULL",          "PRIMARY",       "UNIQUE",      
  "CHECK",         "REFERENCES",    "ID_CONSTR",     "ID_COLLATE",  
  "ID_TAB",        "INTEGER",       "FLOAT",         "BLOB",        
  "AUTOINCR",      "ON",            "INSERT",        "DELETE",      
  "UPDATE",        "ID_FK_MATCH",   "SET",           "DEFERRABLE",  
  "FOREIGN",       "DROP",          "ID_VIEW_NEW",   "ID_VIEW",     
  "SELECT",        "VALUES",        "UNION",         "ALL",         
  "EXCEPT",        "INTERSECT",     "DISTINCT",      "ID_ALIAS",    
  "FROM",          "USING",         "JOIN",          "ID_JOIN_OPTS",
  "ID_IDX",        "ORDER",         "GROUP",         "HAVING",      
  "LIMIT",         "WHERE",         "RETURNING",     "ID_COL",      
  "INTO",          "NOTHING",       "ID_FN",         "ID_ERR_MSG",  
  "VARIABLE",      "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "ID_IDX_NEW",    "ID_PRAGMA",   
  "ID_TRIG_NEW",   "ID_TRIG",       "ALTER",         "ADD",         
  "WINDOW",        "OVER",          "error",         "cmd",         
  "input",         "cmdlist",       "ecmd",          "explain",     
  "cmdx",          "transtype",     "trans_opt",     "nm",          
  "savepoint_opt",  "temp",          "ifnotexists",   "fullname",    
  "columnlist",    "conslist_opt",  "table_options",  "select",      
  "table_option",  "column",        "columnid",      "type",        
  "carglist",      "id",            "id_opt",        "ids",         
  "typetoken",     "typename",      "signed",        "plus_num",    
  "minus_num",     "ccons",         "term",          "expr",        
  "onconf",        "sortorder",     "autoinc",       "idxlist_opt", 
  "refargs",       "defer_subclause",  "gen_always",    "tnm",         
  "refarg",        "refact",        "init_deferred_pred_opt",  "conslist",    
  "tconscomma",    "tcons",         "idxlist",       "defer_subclause_opt",
  "resolvetype",   "orconf",        "raisetype",     "ifexists",    
  "select_stmt",   "with",          "selectnowith",  "oneselect",   
  "multiselect_op",  "values",        "distinct",      "selcollist",  
  "from",          "where_opt",     "groupby_opt",   "having_opt",  
  "orderby_opt",   "limit_opt",     "window_clause",  "nexprlist",   
  "exprlist",      "sclp",          "as",            "joinsrc",     
  "singlesrc",     "seltablist",    "joinop",        "joinconstr_opt",
  "dbnm",          "indexed_opt",   "idlist",        "xfullname",   
  "indexed_by",    "sortlist",      "nulls",         "delete_stmt", 
  "returning",     "update_stmt",   "setlist",       "idlist_opt",  
  "insert_stmt",   "insert_cmd",    "upsert",        "rp_opt",      
  "exprx",         "not_opt",       "likeop",        "case_operand",
  "case_exprlist",  "case_else",     "filter_over",   "uniqueflag",  
  "idxlist_single",  "collate",       "vinto",         "nmnum",       
  "number",        "trigger_time",  "trigger_event",  "foreach_clause",
  "when_clause",   "trigger_cmd_list",  "trigger_cmd",   "database_kw_opt",
  "key_opt",       "kwcolumn_opt",  "create_vtab",   "vtabarglist", 
  "vtabarg",       "vtabargtoken",  "anylist",       "wqlist",      
  "wqas",          "wqcte",         "windowdefn_list",  "windowdefn",  
  "window",        "frame_opt",     "range_or_rows",  "frame_bound_s",
  "frame_exclude_opt",  "frame_bound_e",  "frame_bound",   "frame_exclude",
  "filter_clause",  "over_clause", 
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= SEMI",
 /*   4 */ "ecmd ::= explain cmdx SEMI",
 /*   5 */ "explain ::=",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   8 */ "cmdx ::= cmd",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "trans_opt ::= TRANSACTION ID_TRANS",
 /*  14 */ "transtype ::=",
 /*  15 */ "transtype ::= DEFERRED",
 /*  16 */ "transtype ::= IMMEDIATE",
 /*  17 */ "transtype ::= EXCLUSIVE",
 /*  18 */ "cmd ::= COMMIT trans_opt",
 /*  19 */ "cmd ::= END trans_opt",
 /*  20 */ "cmd ::= ROLLBACK trans_opt",
 /*  21 */ "savepoint_opt ::= SAVEPOINT",
 /*  22 */ "savepoint_opt ::=",
 /*  23 */ "cmd ::= SAVEPOINT nm",
 /*  24 */ "cmd ::= RELEASE savepoint_opt nm",
 /*  25 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt nm",
 /*  26 */ "cmd ::= SAVEPOINT ID_TRANS",
 /*  27 */ "cmd ::= RELEASE savepoint_opt ID_TRANS",
 /*  28 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt ID_TRANS",
 /*  29 */ "cmd ::= CREATE temp TABLE ifnotexists fullname LP columnlist conslist_opt RP table_options",
 /*  30 */ "cmd ::= CREATE temp TABLE ifnotexists fullname AS select",
 /*  31 */ "cmd ::= CREATE temp TABLE ifnotexists nm DOT ID_TAB_NEW",
 /*  32 */ "cmd ::= CREATE temp TABLE ifnotexists ID_DB|ID_TAB_NEW",
 /*  33 */ "table_options ::=",
 /*  34 */ "table_options ::= table_option",
 /*  35 */ "table_options ::= table_options COMMA table_option",
 /*  36 */ "table_option ::= WITHOUT nm",
 /*  37 */ "table_option ::= nm",
 /*  38 */ "table_option ::= WITHOUT CTX_ROWID_KW",
 /*  39 */ "table_option ::= CTX_STRICT_KW",
 /*  40 */ "ifnotexists ::=",
 /*  41 */ "ifnotexists ::= IF NOT EXISTS",
 /*  42 */ "temp ::= TEMP",
 /*  43 */ "temp ::=",
 /*  44 */ "columnlist ::= columnlist COMMA column",
 /*  45 */ "columnlist ::= column",
 /*  46 */ "column ::= columnid type carglist",
 /*  47 */ "columnid ::= nm",
 /*  48 */ "columnid ::= ID_COL_NEW",
 /*  49 */ "id ::= ID|INDEXED|GENERATED",
 /*  50 */ "id_opt ::= id",
 /*  51 */ "id_opt ::=",
 /*  52 */ "ids ::= ID",
 /*  53 */ "ids ::= STRING",
 /*  54 */ "nm ::= id",
 /*  55 */ "nm ::= STRING",
 /*  56 */ "nm ::= JOIN_KW",
 /*  57 */ "type ::=",
 /*  58 */ "type ::= typetoken",
 /*  59 */ "typetoken ::= typename",
 /*  60 */ "typetoken ::= typename LP signed RP",
 /*  61 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  62 */ "typename ::= ids",
 /*  63 */ "typename ::= typename ids",
 /*  64 */ "typename ::= ID_COL_TYPE",
 /*  65 */ "signed ::= plus_num",
 /*  66 */ "signed ::= minus_num",
 /*  67 */ "carglist ::= carglist ccons",
 /*  68 */ "carglist ::=",
 /*  69 */ "ccons ::= CONSTRAINT nm",
 /*  70 */ "ccons ::= DEFAULT term",
 /*  71 */ "ccons ::= DEFAULT LP expr RP",
 /*  72 */ "ccons ::= DEFAULT PLUS term",
 /*  73 */ "ccons ::= DEFAULT MINUS term",
 /*  74 */ "ccons ::= DEFAULT id",
 /*  75 */ "ccons ::= DEFAULT CTIME_KW",
 /*  76 */ "ccons ::= NULL onconf",
 /*  77 */ "ccons ::= NOT NULL onconf",
 /*  78 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  79 */ "ccons ::= UNIQUE onconf",
 /*  80 */ "ccons ::= CHECK LP expr RP",
 /*  81 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  82 */ "ccons ::= defer_subclause",
 /*  83 */ "ccons ::= COLLATE ids",
 /*  84 */ "ccons ::= gen_always AS LP expr RP id_opt",
 /*  85 */ "ccons ::= CONSTRAINT ID_CONSTR",
 /*  86 */ "ccons ::= COLLATE ID_COLLATE",
 /*  87 */ "ccons ::= REFERENCES ID_TAB",
 /*  88 */ "ccons ::= CHECK LP RP",
 /*  89 */ "term ::= NULL",
 /*  90 */ "term ::= INTEGER",
 /*  91 */ "term ::= FLOAT",
 /*  92 */ "term ::= STRING|BLOB",
 /*  93 */ "tnm ::= term",
 /*  94 */ "tnm ::= nm",
 /*  95 */ "gen_always ::= GENERATED ALWAYS",
 /*  96 */ "gen_always ::=",
 /*  97 */ "autoinc ::=",
 /*  98 */ "autoinc ::= AUTOINCR",
 /*  99 */ "refargs ::=",
 /* 100 */ "refargs ::= refargs refarg",
 /* 101 */ "refarg ::= MATCH nm",
 /* 102 */ "refarg ::= ON INSERT refact",
 /* 103 */ "refarg ::= ON DELETE refact",
 /* 104 */ "refarg ::= ON UPDATE refact",
 /* 105 */ "refarg ::= MATCH ID_FK_MATCH",
 /* 106 */ "refact ::= SET NULL",
 /* 107 */ "refact ::= SET DEFAULT",
 /* 108 */ "refact ::= CASCADE",
 /* 109 */ "refact ::= RESTRICT",
 /* 110 */ "refact ::= NO ACTION",
 /* 111 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /* 112 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /* 113 */ "init_deferred_pred_opt ::=",
 /* 114 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /* 115 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /* 116 */ "conslist_opt ::=",
 /* 117 */ "conslist_opt ::= COMMA conslist",
 /* 118 */ "conslist ::= conslist tconscomma tcons",
 /* 119 */ "conslist ::= tcons",
 /* 120 */ "tconscomma ::= COMMA",
 /* 121 */ "tconscomma ::=",
 /* 122 */ "tcons ::= CONSTRAINT nm",
 /* 123 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /* 124 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /* 125 */ "tcons ::= CHECK LP expr RP onconf",
 /* 126 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /* 127 */ "tcons ::= CONSTRAINT ID_CONSTR",
 /* 128 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB",
 /* 129 */ "tcons ::= CHECK LP RP onconf",
 /* 130 */ "defer_subclause_opt ::=",
 /* 131 */ "defer_subclause_opt ::= defer_subclause",
 /* 132 */ "onconf ::=",
 /* 133 */ "onconf ::= ON CONFLICT resolvetype",
 /* 134 */ "orconf ::=",
 /* 135 */ "orconf ::= OR resolvetype",
 /* 136 */ "resolvetype ::= raisetype",
 /* 137 */ "resolvetype ::= IGNORE",
 /* 138 */ "resolvetype ::= REPLACE",
 /* 139 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 140 */ "cmd ::= DROP TABLE ifexists nm DOT ID_TAB",
 /* 141 */ "cmd ::= DROP TABLE ifexists ID_DB|ID_TAB",
 /* 142 */ "ifexists ::= IF EXISTS",
 /* 143 */ "ifexists ::=",
 /* 144 */ "cmd ::= CREATE temp VIEW ifnotexists fullname idxlist_opt AS select",
 /* 145 */ "cmd ::= CREATE temp VIEW ifnotexists nm DOT ID_VIEW_NEW",
 /* 146 */ "cmd ::= CREATE temp VIEW ifnotexists ID_DB|ID_VIEW_NEW",
 /* 147 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 148 */ "cmd ::= DROP VIEW ifexists nm DOT ID_VIEW",
 /* 149 */ "cmd ::= DROP VIEW ifexists ID_DB|ID_VIEW",
 /* 150 */ "cmd ::= select_stmt",
 /* 151 */ "select_stmt ::= select",
 /* 152 */ "select ::= with selectnowith",
 /* 153 */ "selectnowith ::= oneselect",
 /* 154 */ "selectnowith ::= selectnowith multiselect_op oneselect",
 /* 155 */ "selectnowith ::= values",
 /* 156 */ "selectnowith ::= selectnowith COMMA values",
 /* 157 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 158 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt window_clause orderby_opt limit_opt",
 /* 159 */ "values ::= VALUES LP nexprlist RP",
 /* 160 */ "values ::= values COMMA LP exprlist RP",
 /* 161 */ "multiselect_op ::= UNION",
 /* 162 */ "multiselect_op ::= UNION ALL",
 /* 163 */ "multiselect_op ::= EXCEPT",
 /* 164 */ "multiselect_op ::= INTERSECT",
 /* 165 */ "distinct ::= DISTINCT",
 /* 166 */ "distinct ::= ALL",
 /* 167 */ "distinct ::=",
 /* 168 */ "sclp ::= selcollist COMMA",
 /* 169 */ "sclp ::=",
 /* 170 */ "selcollist ::= sclp expr as",
 /* 171 */ "selcollist ::= sclp STAR",
 /* 172 */ "selcollist ::= sclp tnm DOT STAR",
 /* 173 */ "selcollist ::= sclp",
 /* 174 */ "selcollist ::= sclp ID_TAB DOT STAR",
 /* 175 */ "as ::= AS nm",
 /* 176 */ "as ::= ids",
 /* 177 */ "as ::= AS ID_ALIAS",
 /* 178 */ "as ::= ID_ALIAS",
 /* 179 */ "as ::=",
 /* 180 */ "from ::=",
 /* 181 */ "from ::= FROM joinsrc",
 /* 182 */ "joinsrc ::= singlesrc seltablist",
 /* 183 */ "joinsrc ::=",
 /* 184 */ "seltablist ::= seltablist joinop singlesrc joinconstr_opt",
 /* 185 */ "seltablist ::=",
 /* 186 */ "singlesrc ::= nm dbnm as indexed_opt",
 /* 187 */ "singlesrc ::= LP select RP as",
 /* 188 */ "singlesrc ::= LP joinsrc RP as",
 /* 189 */ "singlesrc ::= nm dbnm LP exprlist RP as",
 /* 190 */ "singlesrc ::=",
 /* 191 */ "singlesrc ::= nm DOT",
 /* 192 */ "singlesrc ::= nm DOT ID_TAB",
 /* 193 */ "singlesrc ::= ID_DB|ID_TAB",
 /* 194 */ "singlesrc ::= nm DOT ID_VIEW",
 /* 195 */ "singlesrc ::= ID_DB|ID_VIEW",
 /* 196 */ "joinconstr_opt ::= ON expr",
 /* 197 */ "joinconstr_opt ::= USING LP idlist RP",
 /* 198 */ "joinconstr_opt ::=",
 /* 199 */ "dbnm ::=",
 /* 200 */ "dbnm ::= DOT nm",
 /* 201 */ "fullname ::= nm",
 /* 202 */ "fullname ::= nm DOT nm",
 /* 203 */ "xfullname ::= nm",
 /* 204 */ "xfullname ::= nm DOT nm",
 /* 205 */ "xfullname ::= nm DOT nm AS nm",
 /* 206 */ "xfullname ::= nm AS nm",
 /* 207 */ "xfullname ::= nm DOT nm AS ID_ALIAS",
 /* 208 */ "xfullname ::= nm AS ID_ALIAS",
 /* 209 */ "joinop ::= COMMA",
 /* 210 */ "joinop ::= JOIN",
 /* 211 */ "joinop ::= JOIN_KW JOIN",
 /* 212 */ "joinop ::= JOIN_KW nm JOIN",
 /* 213 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 214 */ "joinop ::= ID_JOIN_OPTS",
 /* 215 */ "indexed_opt ::=",
 /* 216 */ "indexed_opt ::= indexed_by",
 /* 217 */ "indexed_by ::= INDEXED BY nm",
 /* 218 */ "indexed_by ::= NOT INDEXED",
 /* 219 */ "indexed_by ::= INDEXED BY ID_IDX",
 /* 220 */ "orderby_opt ::=",
 /* 221 */ "orderby_opt ::= ORDER BY sortlist",
 /* 222 */ "sortlist ::= sortlist COMMA expr sortorder nulls",
 /* 223 */ "sortlist ::= expr sortorder nulls",
 /* 224 */ "sortorder ::= ASC",
 /* 225 */ "sortorder ::= DESC",
 /* 226 */ "sortorder ::=",
 /* 227 */ "nulls ::= NULLS FIRST",
 /* 228 */ "nulls ::= NULLS LAST",
 /* 229 */ "nulls ::=",
 /* 230 */ "groupby_opt ::=",
 /* 231 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 232 */ "groupby_opt ::= GROUP BY",
 /* 233 */ "having_opt ::=",
 /* 234 */ "having_opt ::= HAVING expr",
 /* 235 */ "limit_opt ::=",
 /* 236 */ "limit_opt ::= LIMIT expr",
 /* 237 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 238 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 239 */ "cmd ::= delete_stmt",
 /* 240 */ "delete_stmt ::= with DELETE FROM xfullname indexed_opt where_opt returning orderby_opt limit_opt",
 /* 241 */ "delete_stmt ::= with DELETE FROM",
 /* 242 */ "delete_stmt ::= with DELETE FROM nm DOT",
 /* 243 */ "delete_stmt ::= with DELETE FROM nm DOT ID_TAB",
 /* 244 */ "delete_stmt ::= with DELETE FROM ID_DB|ID_TAB",
 /* 245 */ "where_opt ::=",
 /* 246 */ "where_opt ::= WHERE expr",
 /* 247 */ "where_opt ::= WHERE",
 /* 248 */ "returning ::=",
 /* 249 */ "returning ::= RETURNING selcollist",
 /* 250 */ "cmd ::= update_stmt",
 /* 251 */ "update_stmt ::= with UPDATE orconf xfullname indexed_opt SET setlist from where_opt returning orderby_opt limit_opt",
 /* 252 */ "update_stmt ::= with UPDATE orconf",
 /* 253 */ "update_stmt ::= with UPDATE orconf nm DOT",
 /* 254 */ "update_stmt ::= with UPDATE orconf nm DOT ID_TAB",
 /* 255 */ "update_stmt ::= with UPDATE orconf ID_DB|ID_TAB",
 /* 256 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 257 */ "setlist ::= setlist COMMA LP idlist RP EQ expr",
 /* 258 */ "setlist ::= nm EQ expr",
 /* 259 */ "setlist ::= LP idlist RP EQ expr",
 /* 260 */ "setlist ::=",
 /* 261 */ "setlist ::= setlist COMMA",
 /* 262 */ "setlist ::= setlist COMMA ID_COL",
 /* 263 */ "setlist ::= ID_COL",
 /* 264 */ "idlist_opt ::=",
 /* 265 */ "idlist_opt ::= LP idlist RP",
 /* 266 */ "idlist ::= idlist COMMA nm",
 /* 267 */ "idlist ::= nm",
 /* 268 */ "idlist ::=",
 /* 269 */ "idlist ::= idlist COMMA ID_COL",
 /* 270 */ "idlist ::= ID_COL",
 /* 271 */ "cmd ::= insert_stmt",
 /* 272 */ "insert_stmt ::= with insert_cmd INTO xfullname idlist_opt select upsert returning",
 /* 273 */ "insert_stmt ::= with insert_cmd INTO xfullname idlist_opt DEFAULT VALUES returning",
 /* 274 */ "insert_stmt ::= with insert_cmd INTO xfullname LP idlist rp_opt",
 /* 275 */ "insert_stmt ::= with insert_cmd INTO",
 /* 276 */ "insert_stmt ::= with insert_cmd INTO nm DOT",
 /* 277 */ "insert_stmt ::= with insert_cmd INTO ID_DB|ID_TAB",
 /* 278 */ "insert_stmt ::= with insert_cmd INTO nm DOT ID_TAB",
 /* 279 */ "insert_cmd ::= INSERT orconf",
 /* 280 */ "insert_cmd ::= REPLACE",
 /* 281 */ "upsert ::=",
 /* 282 */ "upsert ::= ON CONFLICT LP sortlist RP where_opt DO UPDATE SET setlist where_opt",
 /* 283 */ "upsert ::= ON CONFLICT LP sortlist RP where_opt DO NOTHING",
 /* 284 */ "upsert ::= ON CONFLICT DO NOTHING",
 /* 285 */ "exprx ::= expr not_opt IN ID_DB",
 /* 286 */ "exprx ::= expr not_opt IN nm DOT ID_TAB",
 /* 287 */ "exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN",
 /* 288 */ "exprx ::= tnm DOT ID_TAB|ID_COL",
 /* 289 */ "exprx ::= tnm DOT nm DOT ID_COL",
 /* 290 */ "exprx ::= expr COLLATE ID_COLLATE",
 /* 291 */ "exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP",
 /* 292 */ "exprx ::= CTIME_KW",
 /* 293 */ "exprx ::= LP nexprlist RP",
 /* 294 */ "exprx ::= tnm",
 /* 295 */ "exprx ::= tnm DOT nm",
 /* 296 */ "exprx ::= tnm DOT",
 /* 297 */ "exprx ::= tnm DOT nm DOT nm",
 /* 298 */ "exprx ::= tnm DOT nm DOT",
 /* 299 */ "exprx ::= VARIABLE",
 /* 300 */ "exprx ::= expr COLLATE ids",
 /* 301 */ "exprx ::= CAST LP expr AS typetoken RP",
 /* 302 */ "exprx ::= id LP distinct exprlist RP",
 /* 303 */ "exprx ::= id LP STAR RP",
 /* 304 */ "exprx ::= expr AND expr",
 /* 305 */ "exprx ::= expr OR expr",
 /* 306 */ "exprx ::= expr LT|GT|GE|LE expr",
 /* 307 */ "exprx ::= expr EQ|NE expr",
 /* 308 */ "exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 309 */ "exprx ::= expr PLUS|MINUS expr",
 /* 310 */ "exprx ::= expr STAR|SLASH|REM expr",
 /* 311 */ "exprx ::= expr CONCAT expr",
 /* 312 */ "exprx ::= expr not_opt likeop expr",
 /* 313 */ "exprx ::= expr not_opt likeop expr ESCAPE expr",
 /* 314 */ "exprx ::= expr ISNULL|NOTNULL",
 /* 315 */ "exprx ::= expr NOT NULL",
 /* 316 */ "exprx ::= expr IS not_opt expr",
 /* 317 */ "exprx ::= expr IS NOT DISTINCT FROM expr",
 /* 318 */ "exprx ::= expr IS DISTINCT FROM expr",
 /* 319 */ "exprx ::= NOT expr",
 /* 320 */ "exprx ::= BITNOT expr",
 /* 321 */ "exprx ::= MINUS expr",
 /* 322 */ "exprx ::= PLUS expr",
 /* 323 */ "exprx ::= expr PTR expr",
 /* 324 */ "exprx ::= expr not_opt BETWEEN expr AND expr",
 /* 325 */ "exprx ::= expr not_opt IN LP exprlist RP",
 /* 326 */ "exprx ::= LP select RP",
 /* 327 */ "exprx ::= expr not_opt IN LP select RP",
 /* 328 */ "exprx ::= expr not_opt IN nm dbnm",
 /* 329 */ "exprx ::= EXISTS LP select RP",
 /* 330 */ "exprx ::= CASE case_operand case_exprlist case_else END",
 /* 331 */ "exprx ::= RAISE LP IGNORE RP",
 /* 332 */ "exprx ::= RAISE LP raisetype COMMA nm RP",
 /* 333 */ "exprx ::= id LP distinct exprlist RP filter_over",
 /* 334 */ "exprx ::= id LP STAR RP filter_over",
 /* 335 */ "expr ::=",
 /* 336 */ "expr ::= exprx",
 /* 337 */ "not_opt ::=",
 /* 338 */ "not_opt ::= NOT",
 /* 339 */ "rp_opt ::=",
 /* 340 */ "rp_opt ::= RP",
 /* 341 */ "likeop ::= LIKE_KW|MATCH",
 /* 342 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 343 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 344 */ "case_else ::= ELSE expr",
 /* 345 */ "case_else ::=",
 /* 346 */ "case_operand ::= exprx",
 /* 347 */ "case_operand ::=",
 /* 348 */ "exprlist ::= nexprlist",
 /* 349 */ "exprlist ::=",
 /* 350 */ "nexprlist ::= nexprlist COMMA expr",
 /* 351 */ "nexprlist ::= exprx",
 /* 352 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP sortlist RP where_opt",
 /* 353 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON ID_TAB",
 /* 354 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm DOT ID_IDX_NEW",
 /* 355 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists ID_DB|ID_IDX_NEW",
 /* 356 */ "uniqueflag ::= UNIQUE",
 /* 357 */ "uniqueflag ::=",
 /* 358 */ "idxlist_opt ::=",
 /* 359 */ "idxlist_opt ::= LP idxlist RP",
 /* 360 */ "idxlist ::= idxlist COMMA idxlist_single",
 /* 361 */ "idxlist ::= idxlist_single",
 /* 362 */ "idxlist_single ::= nm collate sortorder",
 /* 363 */ "idxlist_single ::= ID_COL",
 /* 364 */ "collate ::=",
 /* 365 */ "collate ::= COLLATE ids",
 /* 366 */ "collate ::= COLLATE ID_COLLATE",
 /* 367 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 368 */ "cmd ::= DROP INDEX ifexists nm DOT ID_IDX",
 /* 369 */ "cmd ::= DROP INDEX ifexists ID_DB|ID_IDX",
 /* 370 */ "cmd ::= VACUUM vinto",
 /* 371 */ "cmd ::= VACUUM nm vinto",
 /* 372 */ "vinto ::= INTO expr",
 /* 373 */ "vinto ::=",
 /* 374 */ "cmd ::= PRAGMA nm dbnm",
 /* 375 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 376 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 377 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 378 */ "cmd ::= PRAGMA nm dbnm LP minus_num RP",
 /* 379 */ "cmd ::= PRAGMA nm DOT ID_PRAGMA",
 /* 380 */ "cmd ::= PRAGMA ID_DB|ID_PRAGMA",
 /* 381 */ "nmnum ::= plus_num",
 /* 382 */ "nmnum ::= nm",
 /* 383 */ "nmnum ::= ON",
 /* 384 */ "nmnum ::= DELETE",
 /* 385 */ "nmnum ::= DEFAULT",
 /* 386 */ "plus_num ::= PLUS number",
 /* 387 */ "plus_num ::= number",
 /* 388 */ "minus_num ::= MINUS number",
 /* 389 */ "number ::= INTEGER",
 /* 390 */ "number ::= FLOAT",
 /* 391 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list END",
 /* 392 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause",
 /* 393 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list",
 /* 394 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON ID_TAB",
 /* 395 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm DOT ID_TRIG_NEW",
 /* 396 */ "cmd ::= CREATE temp TRIGGER ifnotexists ID_DB|ID_TRIG_NEW",
 /* 397 */ "trigger_time ::= BEFORE",
 /* 398 */ "trigger_time ::= AFTER",
 /* 399 */ "trigger_time ::= INSTEAD OF",
 /* 400 */ "trigger_time ::=",
 /* 401 */ "trigger_event ::= DELETE",
 /* 402 */ "trigger_event ::= INSERT",
 /* 403 */ "trigger_event ::= UPDATE",
 /* 404 */ "trigger_event ::= UPDATE OF idlist",
 /* 405 */ "foreach_clause ::=",
 /* 406 */ "foreach_clause ::= FOR EACH ROW",
 /* 407 */ "when_clause ::=",
 /* 408 */ "when_clause ::= WHEN expr",
 /* 409 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 410 */ "trigger_cmd_list ::= trigger_cmd SEMI",
 /* 411 */ "trigger_cmd_list ::= SEMI",
 /* 412 */ "trigger_cmd ::= update_stmt",
 /* 413 */ "trigger_cmd ::= insert_stmt",
 /* 414 */ "trigger_cmd ::= delete_stmt",
 /* 415 */ "trigger_cmd ::= select_stmt",
 /* 416 */ "raisetype ::= ROLLBACK|ABORT|FAIL",
 /* 417 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 418 */ "cmd ::= DROP TRIGGER ifexists nm DOT ID_TRIG",
 /* 419 */ "cmd ::= DROP TRIGGER ifexists ID_DB|ID_TRIG",
 /* 420 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 421 */ "cmd ::= DETACH database_kw_opt expr",
 /* 422 */ "key_opt ::=",
 /* 423 */ "key_opt ::= KEY expr",
 /* 424 */ "database_kw_opt ::= DATABASE",
 /* 425 */ "database_kw_opt ::=",
 /* 426 */ "cmd ::= REINDEX",
 /* 427 */ "cmd ::= REINDEX nm dbnm",
 /* 428 */ "cmd ::= REINDEX ID_COLLATE",
 /* 429 */ "cmd ::= REINDEX nm DOT ID_TAB|ID_IDX",
 /* 430 */ "cmd ::= REINDEX ID_DB|ID_IDX|ID_TAB",
 /* 431 */ "cmd ::= ANALYZE",
 /* 432 */ "cmd ::= ANALYZE nm dbnm",
 /* 433 */ "cmd ::= ANALYZE nm DOT ID_TAB|ID_IDX",
 /* 434 */ "cmd ::= ANALYZE ID_DB|ID_IDX|ID_TAB",
 /* 435 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 436 */ "cmd ::= ALTER TABLE fullname ADD kwcolumn_opt column",
 /* 437 */ "cmd ::= ALTER TABLE fullname DROP kwcolumn_opt nm",
 /* 438 */ "cmd ::= ALTER TABLE fullname RENAME TO ID_TAB_NEW",
 /* 439 */ "cmd ::= ALTER TABLE nm DOT ID_TAB",
 /* 440 */ "cmd ::= ALTER TABLE ID_DB|ID_TAB",
 /* 441 */ "kwcolumn_opt ::=",
 /* 442 */ "kwcolumn_opt ::= COLUMNKW",
 /* 443 */ "cmd ::= create_vtab",
 /* 444 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm",
 /* 445 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm LP vtabarglist RP",
 /* 446 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm DOT ID_TAB_NEW",
 /* 447 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists ID_DB|ID_TAB_NEW",
 /* 448 */ "vtabarglist ::= vtabarg",
 /* 449 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 450 */ "vtabarg ::=",
 /* 451 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 452 */ "vtabargtoken ::= ANY",
 /* 453 */ "vtabargtoken ::= LP anylist RP",
 /* 454 */ "anylist ::=",
 /* 455 */ "anylist ::= anylist LP anylist RP",
 /* 456 */ "anylist ::= anylist ANY",
 /* 457 */ "with ::=",
 /* 458 */ "with ::= WITH wqlist",
 /* 459 */ "with ::= WITH RECURSIVE wqlist",
 /* 460 */ "wqas ::= AS",
 /* 461 */ "wqas ::= AS MATERIALIZED",
 /* 462 */ "wqas ::= AS NOT MATERIALIZED",
 /* 463 */ "wqlist ::= wqcte",
 /* 464 */ "wqlist ::= wqlist COMMA wqcte",
 /* 465 */ "wqlist ::= ID_TAB_NEW",
 /* 466 */ "wqcte ::= nm idxlist_opt wqas LP select RP",
 /* 467 */ "windowdefn_list ::= windowdefn",
 /* 468 */ "windowdefn_list ::= windowdefn_list COMMA windowdefn",
 /* 469 */ "windowdefn ::= nm AS LP window RP",
 /* 470 */ "window ::= PARTITION BY nexprlist orderby_opt frame_opt",
 /* 471 */ "window ::= nm PARTITION BY nexprlist orderby_opt frame_opt",
 /* 472 */ "window ::= ORDER BY sortlist frame_opt",
 /* 473 */ "window ::= nm ORDER BY sortlist frame_opt",
 /* 474 */ "window ::= frame_opt",
 /* 475 */ "window ::= nm frame_opt",
 /* 476 */ "frame_opt ::=",
 /* 477 */ "frame_opt ::= range_or_rows frame_bound_s frame_exclude_opt",
 /* 478 */ "frame_opt ::= range_or_rows BETWEEN frame_bound_s AND frame_bound_e frame_exclude_opt",
 /* 479 */ "range_or_rows ::= RANGE|ROWS|GROUPS",
 /* 480 */ "frame_bound_s ::= frame_bound",
 /* 481 */ "frame_bound_s ::= UNBOUNDED PRECEDING",
 /* 482 */ "frame_bound_e ::= frame_bound",
 /* 483 */ "frame_bound_e ::= UNBOUNDED FOLLOWING",
 /* 484 */ "frame_bound ::= expr PRECEDING|FOLLOWING",
 /* 485 */ "frame_bound ::= CURRENT ROW",
 /* 486 */ "frame_exclude_opt ::=",
 /* 487 */ "frame_exclude_opt ::= EXCLUDE frame_exclude",
 /* 488 */ "frame_exclude ::= NO OTHERS",
 /* 489 */ "frame_exclude ::= CURRENT ROW",
 /* 490 */ "frame_exclude ::= GROUP",
 /* 491 */ "frame_exclude ::= TIES",
 /* 492 */ "window_clause ::= WINDOW windowdefn_list",
 /* 493 */ "filter_over ::= filter_clause over_clause",
 /* 494 */ "filter_over ::= over_clause",
 /* 495 */ "filter_over ::= filter_clause",
 /* 496 */ "over_clause ::= OVER LP window RP",
 /* 497 */ "over_clause ::= OVER nm",
 /* 498 */ "filter_clause ::= FILTER LP WHERE expr RP",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/*
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3_parse and sqlite3_parseFree.
*/
void *sqlite3_parseAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  sqlite3_parseARG_FETCH;
  if (parserContext->executeRules)
  {
      switch( yymajor ){
        /* Here is inserted the actions which take place when a
        ** terminal or non-terminal is destroyed.  This can happen
        ** when the symbol is popped from the stack during a
        ** reduce or during error processing or when a parser is
        ** being destroyed before it is finished parsing.
        **
        ** Note: during a reduce, the only symbols destroyed are those
        ** which appear on the RHS of the rule, but which are not used
        ** inside the C code.
        */
    case 195: /* cmd */
    case 198: /* ecmd */
    case 200: /* cmdx */
    case 248: /* select_stmt */
    case 279: /* delete_stmt */
    case 281: /* update_stmt */
    case 284: /* insert_stmt */
    case 306: /* trigger_cmd */
    case 310: /* create_vtab */
{
parser_safe_delete((yypminor->yy443));
}
      break;
    case 199: /* explain */
{
parser_safe_delete((yypminor->yy511));
}
      break;
    case 201: /* transtype */
    case 202: /* trans_opt */
{
parser_safe_delete((yypminor->yy464));
}
      break;
    case 203: /* nm */
    case 214: /* columnid */
    case 217: /* id */
    case 218: /* id_opt */
    case 219: /* ids */
    case 221: /* typename */
    case 272: /* dbnm */
    case 297: /* collate */
    case 312: /* vtabarg */
    case 313: /* vtabargtoken */
    case 314: /* anylist */
{
parser_safe_delete((yypminor->yy259));
}
      break;
    case 204: /* savepoint_opt */
    case 206: /* ifnotexists */
    case 230: /* autoinc */
    case 234: /* gen_always */
    case 240: /* tconscomma */
    case 247: /* ifexists */
    case 287: /* rp_opt */
    case 289: /* not_opt */
    case 295: /* uniqueflag */
    case 307: /* database_kw_opt */
    case 309: /* kwcolumn_opt */
{
parser_safe_delete((yypminor->yy291));
}
      break;
    case 205: /* temp */
    case 254: /* distinct */
{
parser_safe_delete((yypminor->yy346));
}
      break;
    case 207: /* fullname */
{
parser_safe_delete((yypminor->yy60));
}
      break;
    case 208: /* columnlist */
{
parser_safe_delete((yypminor->yy42));
}
      break;
    case 209: /* conslist_opt */
    case 239: /* conslist */
{
parser_safe_delete((yypminor->yy373));
}
      break;
    case 210: /* table_options */
{
parser_safe_delete((yypminor->yy533));
}
      break;
    case 211: /* select */
    case 250: /* selectnowith */
{
parser_safe_delete((yypminor->yy453));
}
      break;
    case 212: /* table_option */
{
parser_safe_delete((yypminor->yy287));
}
      break;
    case 213: /* column */
{
parser_safe_delete((yypminor->yy567));
}
      break;
    case 215: /* type */
    case 220: /* typetoken */
{
parser_safe_delete((yypminor->yy477));
}
      break;
    case 216: /* carglist */
{
parser_safe_delete((yypminor->yy131));
}
      break;
    case 222: /* signed */
    case 223: /* plus_num */
    case 224: /* minus_num */
    case 226: /* term */
    case 299: /* nmnum */
    case 300: /* number */
{
parser_safe_delete((yypminor->yy249));
}
      break;
    case 225: /* ccons */
{
parser_safe_delete((yypminor->yy604));
}
      break;
    case 227: /* expr */
    case 257: /* where_opt */
    case 259: /* having_opt */
    case 288: /* exprx */
    case 291: /* case_operand */
    case 293: /* case_else */
    case 298: /* vinto */
    case 304: /* when_clause */
    case 308: /* key_opt */
{
parser_safe_delete((yypminor->yy252));
}
      break;
    case 228: /* onconf */
    case 244: /* resolvetype */
    case 245: /* orconf */
{
parser_safe_delete((yypminor->yy478));
}
      break;
    case 229: /* sortorder */
{
parser_safe_delete((yypminor->yy389));
}
      break;
    case 231: /* idxlist_opt */
    case 242: /* idxlist */
{
parser_safe_delete((yypminor->yy123));
}
      break;
    case 232: /* refargs */
{
parser_safe_delete((yypminor->yy324));
}
      break;
    case 233: /* defer_subclause */
    case 243: /* defer_subclause_opt */
{
parser_safe_delete((yypminor->yy449));
}
      break;
    case 235: /* tnm */
{
parser_safe_delete((yypminor->yy350));
}
      break;
    case 236: /* refarg */
{
parser_safe_delete((yypminor->yy607));
}
      break;
    case 237: /* refact */
{
parser_safe_delete((yypminor->yy124));
}
      break;
    case 238: /* init_deferred_pred_opt */
{
parser_safe_delete((yypminor->yy192));
}
      break;
    case 241: /* tcons */
{
parser_safe_delete((yypminor->yy106));
}
      break;
    case 249: /* with */
{
parser_safe_delete((yypminor->yy641));
}
      break;
    case 251: /* oneselect */
{
parser_safe_delete((yypminor->yy450));
}
      break;
    case 252: /* multiselect_op */
{
parser_safe_delete((yypminor->yy382));
}
      break;
    case 253: /* values */
{
parser_safe_delete((yypminor->yy546));
}
      break;
    case 255: /* selcollist */
    case 265: /* sclp */
    case 280: /* returning */
{
parser_safe_delete((yypminor->yy633));
}
      break;
    case 256: /* from */
    case 267: /* joinsrc */
{
parser_safe_delete((yypminor->yy91));
}
      break;
    case 258: /* groupby_opt */
    case 263: /* nexprlist */
    case 264: /* exprlist */
    case 292: /* case_exprlist */
{
parser_safe_delete((yypminor->yy351));
}
      break;
    case 260: /* orderby_opt */
    case 277: /* sortlist */
{
parser_safe_delete((yypminor->yy543));
}
      break;
    case 261: /* limit_opt */
{
parser_safe_delete((yypminor->yy444));
}
      break;
    case 262: /* window_clause */
    case 318: /* windowdefn_list */
{
parser_safe_delete((yypminor->yy639));
}
      break;
    case 266: /* as */
{
parser_safe_delete((yypminor->yy460));
}
      break;
    case 268: /* singlesrc */
{
parser_safe_delete((yypminor->yy361));
}
      break;
    case 269: /* seltablist */
{
parser_safe_delete((yypminor->yy11));
}
      break;
    case 270: /* joinop */
{
parser_safe_delete((yypminor->yy521));
}
      break;
    case 271: /* joinconstr_opt */
{
parser_safe_delete((yypminor->yy335));
}
      break;
    case 273: /* indexed_opt */
    case 276: /* indexed_by */
{
parser_safe_delete((yypminor->yy312));
}
      break;
    case 274: /* idlist */
    case 283: /* idlist_opt */
    case 311: /* vtabarglist */
{
parser_safe_delete((yypminor->yy215));
}
      break;
    case 275: /* xfullname */
{
parser_safe_delete((yypminor->yy116));
}
      break;
    case 278: /* nulls */
{
parser_safe_delete((yypminor->yy99));
}
      break;
    case 282: /* setlist */
{
parser_safe_delete((yypminor->yy321));
}
      break;
    case 285: /* insert_cmd */
{
parser_safe_delete((yypminor->yy584));
}
      break;
    case 286: /* upsert */
{
parser_safe_delete((yypminor->yy500));
}
      break;
    case 290: /* likeop */
{
parser_safe_delete((yypminor->yy100));
}
      break;
    case 294: /* filter_over */
{
parser_safe_delete((yypminor->yy247));
}
      break;
    case 296: /* idxlist_single */
{
parser_safe_delete((yypminor->yy608));
}
      break;
    case 301: /* trigger_time */
{
parser_safe_delete((yypminor->yy372));
}
      break;
    case 302: /* trigger_event */
{
parser_safe_delete((yypminor->yy331));
}
      break;
    case 303: /* foreach_clause */
{
parser_safe_delete((yypminor->yy323));
}
      break;
    case 305: /* trigger_cmd_list */
{
parser_safe_delete((yypminor->yy330));
}
      break;
    case 315: /* wqlist */
{
parser_safe_delete((yypminor->yy332));
}
      break;
    case 316: /* wqas */
{
parser_safe_delete((yypminor->yy640));
}
      break;
    case 317: /* wqcte */
{
parser_safe_delete((yypminor->yy446));
}
      break;
    case 319: /* windowdefn */
{
parser_safe_delete((yypminor->yy646));
}
      break;
    case 320: /* window */
{
parser_safe_delete((yypminor->yy234));
}
      break;
    case 321: /* frame_opt */
{
parser_safe_delete((yypminor->yy41));
}
      break;
    case 322: /* range_or_rows */
{
parser_safe_delete((yypminor->yy358));
}
      break;
    case 323: /* frame_bound_s */
    case 325: /* frame_bound_e */
{
parser_safe_delete((yypminor->yy81));
}
      break;
    case 326: /* frame_bound */
{
parser_safe_delete((yypminor->yy81));parser_safe_delete((yypminor->yy81));parser_safe_delete((yypminor->yy81));
}
      break;
    case 328: /* filter_clause */
{
parser_safe_delete((yypminor->yy657));
}
      break;
    case 329: /* over_clause */
{
parser_safe_delete((yypminor->yy288));
}
      break;
        default:  break;   /* If no destructor action specified: do nothing */
      }
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  /* There is no mechanism by which the parser stack can be popped below
  ** empty in SQLite.  */
  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  delete yytos->tokens;
  yytos->tokens = nullptr;
  pParser->yyidx--;
  return yymajor;
}

/*
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3_parseAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3_parseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  /* In SQLite, we never try to destroy a parser that was not successfully
  ** created in the first place. */
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlite3_parseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
  GET_CONTEXT;

  if( stateno>YY_SHIFT_COUNT
   || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0
             && parserContext->doFallbacks ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if(
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   UNUSED(yypMinor);
   sqlite3_parseARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */

    parserContext->error(QObject::tr("Parser stack overflow"));
   sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
  yytos->tokens = new QList<Token*>();
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 196, 1 },
  { 197, 2 },
  { 197, 1 },
  { 198, 1 },
  { 198, 3 },
  { 199, 0 },
  { 199, 1 },
  { 199, 3 },
  { 200, 1 },
  { 195, 3 },
  { 202, 0 },
  { 202, 1 },
  { 202, 2 },
  { 202, 2 },
  { 201, 0 },
  { 201, 1 },
  { 201, 1 },
  { 201, 1 },
  { 195, 2 },
  { 195, 2 },
  { 195, 2 },
  { 204, 1 },
  { 204, 0 },
  { 195, 2 },
  { 195, 3 },
  { 195, 5 },
  { 195, 2 },
  { 195, 3 },
  { 195, 5 },
  { 195, 10 },
  { 195, 7 },
  { 195, 7 },
  { 195, 5 },
  { 210, 0 },
  { 210, 1 },
  { 210, 3 },
  { 212, 2 },
  { 212, 1 },
  { 212, 2 },
  { 212, 1 },
  { 206, 0 },
  { 206, 3 },
  { 205, 1 },
  { 205, 0 },
  { 208, 3 },
  { 208, 1 },
  { 213, 3 },
  { 214, 1 },
  { 214, 1 },
  { 217, 1 },
  { 218, 1 },
  { 218, 0 },
  { 219, 1 },
  { 219, 1 },
  { 203, 1 },
  { 203, 1 },
  { 203, 1 },
  { 215, 0 },
  { 215, 1 },
  { 220, 1 },
  { 220, 4 },
  { 220, 6 },
  { 221, 1 },
  { 221, 2 },
  { 221, 1 },
  { 222, 1 },
  { 222, 1 },
  { 216, 2 },
  { 216, 0 },
  { 225, 2 },
  { 225, 2 },
  { 225, 4 },
  { 225, 3 },
  { 225, 3 },
  { 225, 2 },
  { 225, 2 },
  { 225, 2 },
  { 225, 3 },
  { 225, 5 },
  { 225, 2 },
  { 225, 4 },
  { 225, 4 },
  { 225, 1 },
  { 225, 2 },
  { 225, 6 },
  { 225, 2 },
  { 225, 2 },
  { 225, 2 },
  { 225, 3 },
  { 226, 1 },
  { 226, 1 },
  { 226, 1 },
  { 226, 1 },
  { 235, 1 },
  { 235, 1 },
  { 234, 2 },
  { 234, 0 },
  { 230, 0 },
  { 230, 1 },
  { 232, 0 },
  { 232, 2 },
  { 236, 2 },
  { 236, 3 },
  { 236, 3 },
  { 236, 3 },
  { 236, 2 },
  { 237, 2 },
  { 237, 2 },
  { 237, 1 },
  { 237, 1 },
  { 237, 2 },
  { 233, 3 },
  { 233, 2 },
  { 238, 0 },
  { 238, 2 },
  { 238, 2 },
  { 209, 0 },
  { 209, 2 },
  { 239, 3 },
  { 239, 1 },
  { 240, 1 },
  { 240, 0 },
  { 241, 2 },
  { 241, 7 },
  { 241, 5 },
  { 241, 5 },
  { 241, 10 },
  { 241, 2 },
  { 241, 7 },
  { 241, 4 },
  { 243, 0 },
  { 243, 1 },
  { 228, 0 },
  { 228, 3 },
  { 245, 0 },
  { 245, 2 },
  { 244, 1 },
  { 244, 1 },
  { 244, 1 },
  { 195, 4 },
  { 195, 6 },
  { 195, 4 },
  { 247, 2 },
  { 247, 0 },
  { 195, 8 },
  { 195, 7 },
  { 195, 5 },
  { 195, 4 },
  { 195, 6 },
  { 195, 4 },
  { 195, 1 },
  { 248, 1 },
  { 211, 2 },
  { 250, 1 },
  { 250, 3 },
  { 250, 1 },
  { 250, 3 },
  { 251, 9 },
  { 251, 10 },
  { 253, 4 },
  { 253, 5 },
  { 252, 1 },
  { 252, 2 },
  { 252, 1 },
  { 252, 1 },
  { 254, 1 },
  { 254, 1 },
  { 254, 0 },
  { 265, 2 },
  { 265, 0 },
  { 255, 3 },
  { 255, 2 },
  { 255, 4 },
  { 255, 1 },
  { 255, 4 },
  { 266, 2 },
  { 266, 1 },
  { 266, 2 },
  { 266, 1 },
  { 266, 0 },
  { 256, 0 },
  { 256, 2 },
  { 267, 2 },
  { 267, 0 },
  { 269, 4 },
  { 269, 0 },
  { 268, 4 },
  { 268, 4 },
  { 268, 4 },
  { 268, 6 },
  { 268, 0 },
  { 268, 2 },
  { 268, 3 },
  { 268, 1 },
  { 268, 3 },
  { 268, 1 },
  { 271, 2 },
  { 271, 4 },
  { 271, 0 },
  { 272, 0 },
  { 272, 2 },
  { 207, 1 },
  { 207, 3 },
  { 275, 1 },
  { 275, 3 },
  { 275, 5 },
  { 275, 3 },
  { 275, 5 },
  { 275, 3 },
  { 270, 1 },
  { 270, 1 },
  { 270, 2 },
  { 270, 3 },
  { 270, 4 },
  { 270, 1 },
  { 273, 0 },
  { 273, 1 },
  { 276, 3 },
  { 276, 2 },
  { 276, 3 },
  { 260, 0 },
  { 260, 3 },
  { 277, 5 },
  { 277, 3 },
  { 229, 1 },
  { 229, 1 },
  { 229, 0 },
  { 278, 2 },
  { 278, 2 },
  { 278, 0 },
  { 258, 0 },
  { 258, 3 },
  { 258, 2 },
  { 259, 0 },
  { 259, 2 },
  { 261, 0 },
  { 261, 2 },
  { 261, 4 },
  { 261, 4 },
  { 195, 1 },
  { 279, 9 },
  { 279, 3 },
  { 279, 5 },
  { 279, 6 },
  { 279, 4 },
  { 257, 0 },
  { 257, 2 },
  { 257, 1 },
  { 280, 0 },
  { 280, 2 },
  { 195, 1 },
  { 281, 12 },
  { 281, 3 },
  { 281, 5 },
  { 281, 6 },
  { 281, 4 },
  { 282, 5 },
  { 282, 7 },
  { 282, 3 },
  { 282, 5 },
  { 282, 0 },
  { 282, 2 },
  { 282, 3 },
  { 282, 1 },
  { 283, 0 },
  { 283, 3 },
  { 274, 3 },
  { 274, 1 },
  { 274, 0 },
  { 274, 3 },
  { 274, 1 },
  { 195, 1 },
  { 284, 8 },
  { 284, 8 },
  { 284, 7 },
  { 284, 3 },
  { 284, 5 },
  { 284, 4 },
  { 284, 6 },
  { 285, 2 },
  { 285, 1 },
  { 286, 0 },
  { 286, 11 },
  { 286, 8 },
  { 286, 4 },
  { 288, 4 },
  { 288, 6 },
  { 288, 1 },
  { 288, 3 },
  { 288, 5 },
  { 288, 3 },
  { 288, 6 },
  { 288, 1 },
  { 288, 3 },
  { 288, 1 },
  { 288, 3 },
  { 288, 2 },
  { 288, 5 },
  { 288, 4 },
  { 288, 1 },
  { 288, 3 },
  { 288, 6 },
  { 288, 5 },
  { 288, 4 },
  { 288, 3 },
  { 288, 3 },
  { 288, 3 },
  { 288, 3 },
  { 288, 3 },
  { 288, 3 },
  { 288, 3 },
  { 288, 3 },
  { 288, 4 },
  { 288, 6 },
  { 288, 2 },
  { 288, 3 },
  { 288, 4 },
  { 288, 6 },
  { 288, 5 },
  { 288, 2 },
  { 288, 2 },
  { 288, 2 },
  { 288, 2 },
  { 288, 3 },
  { 288, 6 },
  { 288, 6 },
  { 288, 3 },
  { 288, 6 },
  { 288, 5 },
  { 288, 4 },
  { 288, 5 },
  { 288, 4 },
  { 288, 6 },
  { 288, 6 },
  { 288, 5 },
  { 227, 0 },
  { 227, 1 },
  { 289, 0 },
  { 289, 1 },
  { 287, 0 },
  { 287, 1 },
  { 290, 1 },
  { 292, 5 },
  { 292, 4 },
  { 293, 2 },
  { 293, 0 },
  { 291, 1 },
  { 291, 0 },
  { 264, 1 },
  { 264, 0 },
  { 263, 3 },
  { 263, 1 },
  { 195, 12 },
  { 195, 8 },
  { 195, 7 },
  { 195, 5 },
  { 295, 1 },
  { 295, 0 },
  { 231, 0 },
  { 231, 3 },
  { 242, 3 },
  { 242, 1 },
  { 296, 3 },
  { 296, 1 },
  { 297, 0 },
  { 297, 2 },
  { 297, 2 },
  { 195, 4 },
  { 195, 6 },
  { 195, 4 },
  { 195, 2 },
  { 195, 3 },
  { 298, 2 },
  { 298, 0 },
  { 195, 3 },
  { 195, 5 },
  { 195, 6 },
  { 195, 5 },
  { 195, 6 },
  { 195, 4 },
  { 195, 2 },
  { 299, 1 },
  { 299, 1 },
  { 299, 1 },
  { 299, 1 },
  { 299, 1 },
  { 223, 2 },
  { 223, 1 },
  { 224, 2 },
  { 300, 1 },
  { 300, 1 },
  { 195, 15 },
  { 195, 12 },
  { 195, 14 },
  { 195, 10 },
  { 195, 7 },
  { 195, 5 },
  { 301, 1 },
  { 301, 1 },
  { 301, 2 },
  { 301, 0 },
  { 302, 1 },
  { 302, 1 },
  { 302, 1 },
  { 302, 3 },
  { 303, 0 },
  { 303, 3 },
  { 304, 0 },
  { 304, 2 },
  { 305, 3 },
  { 305, 2 },
  { 305, 1 },
  { 306, 1 },
  { 306, 1 },
  { 306, 1 },
  { 306, 1 },
  { 246, 1 },
  { 195, 4 },
  { 195, 6 },
  { 195, 4 },
  { 195, 6 },
  { 195, 3 },
  { 308, 0 },
  { 308, 2 },
  { 307, 1 },
  { 307, 0 },
  { 195, 1 },
  { 195, 3 },
  { 195, 2 },
  { 195, 4 },
  { 195, 2 },
  { 195, 1 },
  { 195, 3 },
  { 195, 4 },
  { 195, 2 },
  { 195, 6 },
  { 195, 6 },
  { 195, 6 },
  { 195, 6 },
  { 195, 5 },
  { 195, 3 },
  { 309, 0 },
  { 309, 1 },
  { 195, 1 },
  { 310, 8 },
  { 310, 11 },
  { 310, 7 },
  { 310, 5 },
  { 311, 1 },
  { 311, 3 },
  { 312, 0 },
  { 312, 2 },
  { 313, 1 },
  { 313, 3 },
  { 314, 0 },
  { 314, 4 },
  { 314, 2 },
  { 249, 0 },
  { 249, 2 },
  { 249, 3 },
  { 316, 1 },
  { 316, 2 },
  { 316, 3 },
  { 315, 1 },
  { 315, 3 },
  { 315, 1 },
  { 317, 6 },
  { 318, 1 },
  { 318, 3 },
  { 319, 5 },
  { 320, 5 },
  { 320, 6 },
  { 320, 4 },
  { 320, 5 },
  { 320, 1 },
  { 320, 2 },
  { 321, 0 },
  { 321, 3 },
  { 321, 6 },
  { 322, 1 },
  { 323, 1 },
  { 323, 2 },
  { 325, 1 },
  { 325, 2 },
  { 326, 2 },
  { 326, 2 },
  { 324, 0 },
  { 324, 2 },
  { 327, 2 },
  { 327, 2 },
  { 327, 1 },
  { 327, 1 },
  { 262, 2 },
  { 294, 2 },
  { 294, 1 },
  { 294, 1 },
  { 329, 4 },
  { 329, 2 },
  { 328, 5 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3_parseARG_FETCH;
  SqliteStatement* objectForTokens = 0;
  QStringList noTokenInheritanceFields;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  if (parserContext->executeRules)
  {
      switch( yyruleno ){
      /* Beginning here are the reduction cases.  A typical example
      ** follows:
      **   case 0:
      **  #line <lineno> <grammarfile>
      **     { ... }           // User supplied code
      **  #line <lineno> <thisfile>
      **     break;
      */
      case 1: /* cmdlist ::= cmdlist ecmd */
{parserContext->addQuery(yymsp[0].minor.yy443); DONT_INHERIT_TOKENS("cmdlist");}
        break;
      case 2: /* cmdlist ::= ecmd */
{parserContext->addQuery(yymsp[0].minor.yy443);}
        break;
      case 3: /* ecmd ::= SEMI */
{yygotominor.yy443 = new SqliteEmptyQuery();}
        break;
      case 4: /* ecmd ::= explain cmdx SEMI */
{
                                                yygotominor.yy443 = yymsp[-1].minor.yy443;
                                                yygotominor.yy443->explain = yymsp[-2].minor.yy511->explain;
                                                yygotominor.yy443->queryPlan = yymsp[-2].minor.yy511->queryPlan;
                                                delete yymsp[-2].minor.yy511;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 5: /* explain ::= */
{yygotominor.yy511 = new ParserStubExplain(false, false);}
        break;
      case 6: /* explain ::= EXPLAIN */
{yygotominor.yy511 = new ParserStubExplain(true, false);}
        break;
      case 7: /* explain ::= EXPLAIN QUERY PLAN */
{yygotominor.yy511 = new ParserStubExplain(true, true);}
        break;
      case 8: /* cmdx ::= cmd */
      case 412: /* trigger_cmd ::= update_stmt */ yytestcase(yyruleno==412);
      case 413: /* trigger_cmd ::= insert_stmt */ yytestcase(yyruleno==413);
      case 414: /* trigger_cmd ::= delete_stmt */ yytestcase(yyruleno==414);
      case 415: /* trigger_cmd ::= select_stmt */ yytestcase(yyruleno==415);
      case 443: /* cmd ::= create_vtab */ yytestcase(yyruleno==443);
{yygotominor.yy443 = yymsp[0].minor.yy443;}
        break;
      case 9: /* cmd ::= BEGIN transtype trans_opt */
{
                                                yygotominor.yy443 = new SqliteBeginTrans(
                                                        yymsp[-1].minor.yy464->type,
                                                        yymsp[0].minor.yy464->transactionKw,
                                                        yymsp[0].minor.yy464->name
                                                    );
                                                delete yymsp[0].minor.yy464;
                                                delete yymsp[-1].minor.yy464;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 10: /* trans_opt ::= */
      case 14: /* transtype ::= */ yytestcase(yyruleno==14);
{yygotominor.yy464 = new ParserStubTransDetails();}
        break;
      case 11: /* trans_opt ::= TRANSACTION */
{
                                                yygotominor.yy464 = new ParserStubTransDetails();
                                                yygotominor.yy464->transactionKw = true;
                                            }
        break;
      case 12: /* trans_opt ::= TRANSACTION nm */
      case 13: /* trans_opt ::= TRANSACTION ID_TRANS */ yytestcase(yyruleno==13);
{
                                                yygotominor.yy464 = new ParserStubTransDetails();
                                                yygotominor.yy464->transactionKw = true;
                                                yygotominor.yy464->name = *(yymsp[0].minor.yy259);
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 15: /* transtype ::= DEFERRED */
{
                                                yygotominor.yy464 = new ParserStubTransDetails();
                                                yygotominor.yy464->type = SqliteBeginTrans::Type::DEFERRED;
                                            }
        break;
      case 16: /* transtype ::= IMMEDIATE */
{
                                                yygotominor.yy464 = new ParserStubTransDetails();
                                                yygotominor.yy464->type = SqliteBeginTrans::Type::IMMEDIATE;
                                            }
        break;
      case 17: /* transtype ::= EXCLUSIVE */
{
                                                yygotominor.yy464 = new ParserStubTransDetails();
                                                yygotominor.yy464->type = SqliteBeginTrans::Type::EXCLUSIVE;
                                            }
        break;
      case 18: /* cmd ::= COMMIT trans_opt */
{
                                                yygotominor.yy443 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy464->transactionKw,
                                                        yymsp[0].minor.yy464->name,
                                                        false
                                                    );
                                                delete yymsp[0].minor.yy464;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 19: /* cmd ::= END trans_opt */
{
                                                yygotominor.yy443 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy464->transactionKw,
                                                        yymsp[0].minor.yy464->name,
                                                        true
                                                    );
                                                delete yymsp[0].minor.yy464;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 20: /* cmd ::= ROLLBACK trans_opt */
{
                                                yygotominor.yy443 = new SqliteRollback(
                                                        yymsp[0].minor.yy464->transactionKw,
                                                        yymsp[0].minor.yy464->name
                                                    );
                                                delete yymsp[0].minor.yy464;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 21: /* savepoint_opt ::= SAVEPOINT */
      case 41: /* ifnotexists ::= IF NOT EXISTS */ yytestcase(yyruleno==41);
      case 95: /* gen_always ::= GENERATED ALWAYS */ yytestcase(yyruleno==95);
      case 98: /* autoinc ::= AUTOINCR */ yytestcase(yyruleno==98);
      case 120: /* tconscomma ::= COMMA */ yytestcase(yyruleno==120);
      case 142: /* ifexists ::= IF EXISTS */ yytestcase(yyruleno==142);
      case 338: /* not_opt ::= NOT */ yytestcase(yyruleno==338);
      case 340: /* rp_opt ::= RP */ yytestcase(yyruleno==340);
      case 356: /* uniqueflag ::= UNIQUE */ yytestcase(yyruleno==356);
      case 424: /* database_kw_opt ::= DATABASE */ yytestcase(yyruleno==424);
      case 441: /* kwcolumn_opt ::= */ yytestcase(yyruleno==441);
{yygotominor.yy291 = new bool(true);}
        break;
      case 22: /* savepoint_opt ::= */
      case 40: /* ifnotexists ::= */ yytestcase(yyruleno==40);
      case 96: /* gen_always ::= */ yytestcase(yyruleno==96);
      case 97: /* autoinc ::= */ yytestcase(yyruleno==97);
      case 121: /* tconscomma ::= */ yytestcase(yyruleno==121);
      case 143: /* ifexists ::= */ yytestcase(yyruleno==143);
      case 337: /* not_opt ::= */ yytestcase(yyruleno==337);
      case 339: /* rp_opt ::= */ yytestcase(yyruleno==339);
      case 357: /* uniqueflag ::= */ yytestcase(yyruleno==357);
      case 425: /* database_kw_opt ::= */ yytestcase(yyruleno==425);
      case 442: /* kwcolumn_opt ::= COLUMNKW */ yytestcase(yyruleno==442);
{yygotominor.yy291 = new bool(false);}
        break;
      case 23: /* cmd ::= SAVEPOINT nm */
{
                                                yygotominor.yy443 = new SqliteSavepoint(*(yymsp[0].minor.yy259));
                                                delete yymsp[0].minor.yy259;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 24: /* cmd ::= RELEASE savepoint_opt nm */
{
                                                yygotominor.yy443 = new SqliteRelease(*(yymsp[-1].minor.yy291), *(yymsp[0].minor.yy259));
                                                delete yymsp[0].minor.yy259;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 25: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt nm */
      case 26: /* cmd ::= SAVEPOINT ID_TRANS */ yytestcase(yyruleno==26);
{
                                                yygotominor.yy443 = new SqliteRollback(
                                                        yymsp[-3].minor.yy464->transactionKw,
                                                        *(yymsp[-1].minor.yy291),
                                                        *(yymsp[0].minor.yy259)
                                                    );
                                                delete yymsp[-1].minor.yy291;
                                                delete yymsp[-3].minor.yy464;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 27: /* cmd ::= RELEASE savepoint_opt ID_TRANS */
      case 28: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt ID_TRANS */ yytestcase(yyruleno==28);
{  yy_destructor(yypParser,204,&yymsp[-1].minor);
}
        break;
      case 29: /* cmd ::= CREATE temp TABLE ifnotexists fullname LP columnlist conslist_opt RP table_options */
{
                                                yygotominor.yy443 = new SqliteCreateTable(
                                                        *(yymsp[-6].minor.yy291),
                                                        *(yymsp[-8].minor.yy346),
                                                        yymsp[-5].minor.yy60->name1,
                                                        yymsp[-5].minor.yy60->name2,
                                                        *(yymsp[-3].minor.yy42),
                                                        *(yymsp[-2].minor.yy373),
                                                        *(yymsp[0].minor.yy533)
                                                    );
                                                delete yymsp[-6].minor.yy291;
                                                delete yymsp[-8].minor.yy346;
                                                delete yymsp[-3].minor.yy42;
                                                delete yymsp[-2].minor.yy373;
                                                delete yymsp[-5].minor.yy60;
                                                delete yymsp[0].minor.yy533;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 30: /* cmd ::= CREATE temp TABLE ifnotexists fullname AS select */
{
                                                yygotominor.yy443 = new SqliteCreateTable(
                                                        *(yymsp[-3].minor.yy291),
                                                        *(yymsp[-5].minor.yy346),
                                                        yymsp[-2].minor.yy60->name1,
                                                        yymsp[-2].minor.yy60->name2,
                                                        yymsp[0].minor.yy453
                                                    );
                                                delete yymsp[-3].minor.yy291;
                                                delete yymsp[-5].minor.yy346;
                                                delete yymsp[-2].minor.yy60;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 31: /* cmd ::= CREATE temp TABLE ifnotexists nm DOT ID_TAB_NEW */
      case 145: /* cmd ::= CREATE temp VIEW ifnotexists nm DOT ID_VIEW_NEW */ yytestcase(yyruleno==145);
      case 395: /* cmd ::= CREATE temp TRIGGER ifnotexists nm DOT ID_TRIG_NEW */ yytestcase(yyruleno==395);
{  yy_destructor(yypParser,205,&yymsp[-5].minor);
  yy_destructor(yypParser,203,&yymsp[-2].minor);
}
        break;
      case 32: /* cmd ::= CREATE temp TABLE ifnotexists ID_DB|ID_TAB_NEW */
      case 146: /* cmd ::= CREATE temp VIEW ifnotexists ID_DB|ID_VIEW_NEW */ yytestcase(yyruleno==146);
      case 396: /* cmd ::= CREATE temp TRIGGER ifnotexists ID_DB|ID_TRIG_NEW */ yytestcase(yyruleno==396);
{  yy_destructor(yypParser,205,&yymsp[-3].minor);
}
        break;
      case 33: /* table_options ::= */
{yygotominor.yy533 = new ParserCreateTableOptionList();}
        break;
      case 34: /* table_options ::= table_option */
{
                                                yygotominor.yy533 = new ParserCreateTableOptionList();
                                                yygotominor.yy533->append(yymsp[0].minor.yy287);
                                            }
        break;
      case 35: /* table_options ::= table_options COMMA table_option */
{
                                                yymsp[-2].minor.yy533->append(yymsp[0].minor.yy287);
                                                yygotominor.yy533 = yymsp[-2].minor.yy533;
                                                DONT_INHERIT_TOKENS("table_options");
                                            }
        break;
      case 36: /* table_option ::= WITHOUT nm */
{
                                                if (yymsp[0].minor.yy259->toLower() != "rowid")
                                                    parserContext->errorAtToken(QString("Invalid table option: %1").arg(*(yymsp[0].minor.yy259)));

                                                yygotominor.yy287 = new ParserStubCreateTableOption(ParserStubCreateTableOption::WITHOUT_ROWID);
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 37: /* table_option ::= nm */
      case 38: /* table_option ::= WITHOUT CTX_ROWID_KW */ yytestcase(yyruleno==38);
      case 39: /* table_option ::= CTX_STRICT_KW */ yytestcase(yyruleno==39);
{
                                                if (yymsp[0].minor.yy259->toLower() != "strict")
                                                    parserContext->errorAtToken(QString("Invalid table option: %1").arg(*(yymsp[0].minor.yy259)));

                                                yygotominor.yy287 = new ParserStubCreateTableOption(ParserStubCreateTableOption::STRICT);
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 42: /* temp ::= TEMP */
{yygotominor.yy346 = new int( (yymsp[0].minor.yy0->value.length() > 4) ? 2 : 1 );}
        break;
      case 43: /* temp ::= */
      case 167: /* distinct ::= */ yytestcase(yyruleno==167);
{yygotominor.yy346 = new int(0);}
        break;
      case 44: /* columnlist ::= columnlist COMMA column */
{
                                                yymsp[-2].minor.yy42->append(yymsp[0].minor.yy567);
                                                yygotominor.yy42 = yymsp[-2].minor.yy42;
                                                DONT_INHERIT_TOKENS("columnlist");
                                            }
        break;
      case 45: /* columnlist ::= column */
{
                                                yygotominor.yy42 = new ParserCreateTableColumnList();
                                                yygotominor.yy42->append(yymsp[0].minor.yy567);
                                            }
        break;
      case 46: /* column ::= columnid type carglist */
{
                                                yygotominor.yy567 = new SqliteCreateTable::Column(*(yymsp[-2].minor.yy259), yymsp[-1].minor.yy477, *(yymsp[0].minor.yy131));
                                                delete yymsp[-2].minor.yy259;
                                                delete yymsp[0].minor.yy131;
                                                objectForTokens = yygotominor.yy567;
                                            }
        break;
      case 47: /* columnid ::= nm */
      case 48: /* columnid ::= ID_COL_NEW */ yytestcase(yyruleno==48);
      case 54: /* nm ::= id */ yytestcase(yyruleno==54);
      case 62: /* typename ::= ids */ yytestcase(yyruleno==62);
      case 200: /* dbnm ::= DOT nm */ yytestcase(yyruleno==200);
      case 365: /* collate ::= COLLATE ids */ yytestcase(yyruleno==365);
      case 366: /* collate ::= COLLATE ID_COLLATE */ yytestcase(yyruleno==366);
{yygotominor.yy259 = yymsp[0].minor.yy259;}
        break;
      case 49: /* id ::= ID|INDEXED|GENERATED */
{
                                                yygotominor.yy259 = new QString(
                                                    stripObjName(
                                                        yymsp[0].minor.yy0->value
                                                    )
                                                );
                                            }
        break;
      case 50: /* id_opt ::= id */
{
                                                yygotominor.yy259 = yymsp[0].minor.yy259;
                                            }
        break;
      case 51: /* id_opt ::= */
{
                                                yygotominor.yy259 = new QString();
                                            }
        break;
      case 52: /* ids ::= ID */
      case 56: /* nm ::= JOIN_KW */ yytestcase(yyruleno==56);
{yygotominor.yy259 = new QString(stripObjName(yymsp[0].minor.yy0->value));}
        break;
      case 53: /* ids ::= STRING */
      case 55: /* nm ::= STRING */ yytestcase(yyruleno==55);
{yygotominor.yy259 = new QString(stripString(yymsp[0].minor.yy0->value));}
        break;
      case 57: /* type ::= */
{yygotominor.yy477 = nullptr;}
        break;
      case 58: /* type ::= typetoken */
{yygotominor.yy477 = yymsp[0].minor.yy477;}
        break;
      case 59: /* typetoken ::= typename */
{
                                                yygotominor.yy477 = new SqliteColumnType(*(yymsp[0].minor.yy259));
                                                delete yymsp[0].minor.yy259;
                                                objectForTokens = yygotominor.yy477;
                                            }
        break;
      case 60: /* typetoken ::= typename LP signed RP */
{
                                                yygotominor.yy477 = new SqliteColumnType(*(yymsp[-3].minor.yy259), *(yymsp[-1].minor.yy249));
                                                delete yymsp[-3].minor.yy259;
                                                delete yymsp[-1].minor.yy249;
                                                objectForTokens = yygotominor.yy477;
                                            }
        break;
      case 61: /* typetoken ::= typename LP signed COMMA signed RP */
{
                                                yygotominor.yy477 = new SqliteColumnType(*(yymsp[-5].minor.yy259), *(yymsp[-3].minor.yy249), *(yymsp[-1].minor.yy249));
                                                delete yymsp[-5].minor.yy259;
                                                delete yymsp[-3].minor.yy249;
                                                delete yymsp[-1].minor.yy249;
                                                objectForTokens = yygotominor.yy477;
                                            }
        break;
      case 63: /* typename ::= typename ids */
      case 64: /* typename ::= ID_COL_TYPE */ yytestcase(yyruleno==64);
{
                                                yymsp[-1].minor.yy259->append(" " + *(yymsp[0].minor.yy259));
                                                delete yymsp[0].minor.yy259;
                                                yygotominor.yy259 = yymsp[-1].minor.yy259;
                                            }
        break;
      case 65: /* signed ::= plus_num */
      case 66: /* signed ::= minus_num */ yytestcase(yyruleno==66);
      case 381: /* nmnum ::= plus_num */ yytestcase(yyruleno==381);
      case 386: /* plus_num ::= PLUS number */ yytestcase(yyruleno==386);
      case 387: /* plus_num ::= number */ yytestcase(yyruleno==387);
{yygotominor.yy249 = yymsp[0].minor.yy249;}
        break;
      case 67: /* carglist ::= carglist ccons */
{
                                                yymsp[-1].minor.yy131->append(yymsp[0].minor.yy604);
                                                yygotominor.yy131 = yymsp[-1].minor.yy131;
                                                DONT_INHERIT_TOKENS("carglist");
                                            }
        break;
      case 68: /* carglist ::= */
{yygotominor.yy131 = new ParserCreateTableColumnConstraintList();}
        break;
      case 69: /* ccons ::= CONSTRAINT nm */
{
                                                yygotominor.yy604 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy604->initDefNameOnly(*(yymsp[0].minor.yy259));
                                                delete yymsp[0].minor.yy259;
                                                objectForTokens = yygotominor.yy604;
                                            }
        break;
      case 70: /* ccons ::= DEFAULT term */
{
                                                yygotominor.yy604 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy604->initDefTerm(*(yymsp[0].minor.yy249));
                                                delete yymsp[0].minor.yy249;
                                                objectForTokens = yygotominor.yy604;
                                            }
        break;
      case 71: /* ccons ::= DEFAULT LP expr RP */
{
                                                yygotominor.yy604 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy604->initDefExpr(yymsp[-1].minor.yy252);
                                                objectForTokens = yygotominor.yy604;
                                            }
        break;
      case 72: /* ccons ::= DEFAULT PLUS term */
{
                                                yygotominor.yy604 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy604->initDefTerm(*(yymsp[0].minor.yy249), false);
                                                delete yymsp[0].minor.yy249;
                                                objectForTokens = yygotominor.yy604;
                                            }
        break;
      case 73: /* ccons ::= DEFAULT MINUS term */
{
                                                yygotominor.yy604 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy604->initDefTerm(*(yymsp[0].minor.yy249), true);
                                                delete yymsp[0].minor.yy249;
                                                objectForTokens = yygotominor.yy604;
                                            }
        break;
      case 74: /* ccons ::= DEFAULT id */
{
                                                yygotominor.yy604 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy604->initDefId(*(yymsp[0].minor.yy259));
                                                delete yymsp[0].minor.yy259;
                                                objectForTokens = yygotominor.yy604;
                                            }
        break;
      case 75: /* ccons ::= DEFAULT CTIME_KW */
{
                                                yygotominor.yy604 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy604->initDefCTime(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy604;
                                            }
        break;
      case 76: /* ccons ::= NULL onconf */
{
                                                yygotominor.yy604 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy604->initNull(*(yymsp[0].minor.yy478));
                                                delete yymsp[0].minor.yy478;
                                                objectForTokens = yygotominor.yy604;
                                            }
        break;
      case 77: /* ccons ::= NOT NULL onconf */
{
                                                yygotominor.yy604 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy604->initNotNull(*(yymsp[0].minor.yy478));
                                                delete yymsp[0].minor.yy478;
                                                objectForTokens = yygotominor.yy604;
                                            }
        break;
      case 78: /* ccons ::= PRIMARY KEY sortorder onconf autoinc */
{
                                                yygotominor.yy604 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy604->initPk(*(yymsp[-2].minor.yy389), *(yymsp[-1].minor.yy478), *(yymsp[0].minor.yy291));
                                                delete yymsp[-2].minor.yy389;
                                                delete yymsp[0].minor.yy291;
                                                delete yymsp[-1].minor.yy478;
                                                objectForTokens = yygotominor.yy604;
                                            }
        break;
      case 79: /* ccons ::= UNIQUE onconf */
{
                                                yygotominor.yy604 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy604->initUnique(*(yymsp[0].minor.yy478));
                                                delete yymsp[0].minor.yy478;
                                                objectForTokens = yygotominor.yy604;
                                            }
        break;
      case 80: /* ccons ::= CHECK LP expr RP */
{
                                                yygotominor.yy604 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy604->initCheck(yymsp[-1].minor.yy252);
                                                objectForTokens = yygotominor.yy604;
                                            }
        break;
      case 81: /* ccons ::= REFERENCES nm idxlist_opt refargs */
{
                                                yygotominor.yy604 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy604->initFk(*(yymsp[-2].minor.yy259), *(yymsp[-1].minor.yy123), *(yymsp[0].minor.yy324));
                                                delete yymsp[-2].minor.yy259;
                                                delete yymsp[0].minor.yy324;
                                                delete yymsp[-1].minor.yy123;
                                                objectForTokens = yygotominor.yy604;
                                            }
        break;
      case 82: /* ccons ::= defer_subclause */
{
                                                yygotominor.yy604 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy604->initDefer(yymsp[0].minor.yy449->initially, yymsp[0].minor.yy449->deferrable);
                                                delete yymsp[0].minor.yy449;
                                                objectForTokens = yygotominor.yy604;
                                            }
        break;
      case 83: /* ccons ::= COLLATE ids */
{
                                                yygotominor.yy604 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy604->initColl(*(yymsp[0].minor.yy259));
                                                delete yymsp[0].minor.yy259;
                                                objectForTokens = yygotominor.yy604;
                                            }
        break;
      case 84: /* ccons ::= gen_always AS LP expr RP id_opt */
      case 85: /* ccons ::= CONSTRAINT ID_CONSTR */ yytestcase(yyruleno==85);
      case 86: /* ccons ::= COLLATE ID_COLLATE */ yytestcase(yyruleno==86);
      case 87: /* ccons ::= REFERENCES ID_TAB */ yytestcase(yyruleno==87);
{
                                                if (!yymsp[0].minor.yy259->isNull() && yymsp[0].minor.yy259->toLower() != "stored" && yymsp[0].minor.yy259->toLower() != "virtual")
                                                    parserContext->errorAtToken(QString("Invalid generated column type: %1").arg(*(yymsp[0].minor.yy259)));

                                                yygotominor.yy604 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy604->initGeneratedAs(yymsp[-2].minor.yy252, *(yymsp[-5].minor.yy291), *(yymsp[0].minor.yy259));
                                                delete yymsp[-5].minor.yy291;
                                                delete yymsp[0].minor.yy259;
                                                objectForTokens = yygotominor.yy604;
                                            }
        break;
      case 88: /* ccons ::= CHECK LP RP */
{
                                                yygotominor.yy604 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy604->initCheck();
                                                objectForTokens = yygotominor.yy604;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 89: /* term ::= NULL */
{yygotominor.yy249 = new QVariant();}
        break;
      case 90: /* term ::= INTEGER */
      case 389: /* number ::= INTEGER */ yytestcase(yyruleno==389);
{yygotominor.yy249 = parserContext->handleNumberToken(yymsp[0].minor.yy0->value);}
        break;
      case 91: /* term ::= FLOAT */
      case 390: /* number ::= FLOAT */ yytestcase(yyruleno==390);
{yygotominor.yy249 = new QVariant(QVariant(yymsp[0].minor.yy0->value).toDouble());}
        break;
      case 92: /* term ::= STRING|BLOB */
{
                                                if (yymsp[0].minor.yy0->value.length() >= 3 && yymsp[0].minor.yy0->value.startsWith("x'", Qt::CaseInsensitive))
                                                    yygotominor.yy249 = new QVariant(blobFromLiteral(yymsp[0].minor.yy0->value));
                                                else
                                                    yygotominor.yy249 = new QVariant(stripString(yymsp[0].minor.yy0->value));
                                            }
        break;
      case 93: /* tnm ::= term */
{
												yygotominor.yy350 = new ParserTermOrLiteral(*(yymsp[0].minor.yy249));
												delete yymsp[0].minor.yy249;
											}
        break;
      case 94: /* tnm ::= nm */
{
												yygotominor.yy350 = new ParserTermOrLiteral(*(yymsp[0].minor.yy259));
												delete yymsp[0].minor.yy259;
											}
        break;
      case 99: /* refargs ::= */
{yygotominor.yy324 = new ParserFkConditionList();}
        break;
      case 100: /* refargs ::= refargs refarg */
{
                                                yymsp[-1].minor.yy324->append(yymsp[0].minor.yy607);
                                                yygotominor.yy324 = yymsp[-1].minor.yy324;
                                                DONT_INHERIT_TOKENS("refargs");
                                            }
        break;
      case 101: /* refarg ::= MATCH nm */
{
                                                yygotominor.yy607 = new SqliteForeignKey::Condition(*(yymsp[0].minor.yy259));
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 102: /* refarg ::= ON INSERT refact */
{yygotominor.yy607 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::INSERT, *(yymsp[0].minor.yy124)); delete yymsp[0].minor.yy124;}
        break;
      case 103: /* refarg ::= ON DELETE refact */
{yygotominor.yy607 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::DELETE, *(yymsp[0].minor.yy124)); delete yymsp[0].minor.yy124;}
        break;
      case 104: /* refarg ::= ON UPDATE refact */
      case 105: /* refarg ::= MATCH ID_FK_MATCH */ yytestcase(yyruleno==105);
{yygotominor.yy607 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::UPDATE, *(yymsp[0].minor.yy124)); delete yymsp[0].minor.yy124;}
        break;
      case 106: /* refact ::= SET NULL */
{yygotominor.yy124 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_NULL);}
        break;
      case 107: /* refact ::= SET DEFAULT */
{yygotominor.yy124 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_DEFAULT);}
        break;
      case 108: /* refact ::= CASCADE */
{yygotominor.yy124 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::CASCADE);}
        break;
      case 109: /* refact ::= RESTRICT */
{yygotominor.yy124 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::RESTRICT);}
        break;
      case 110: /* refact ::= NO ACTION */
{yygotominor.yy124 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::NO_ACTION);}
        break;
      case 111: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy449 = new ParserDeferSubClause(SqliteDeferrable::NOT_DEFERRABLE, *(yymsp[0].minor.yy192));
                                                delete yymsp[0].minor.yy192;
                                            }
        break;
      case 112: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy449 = new ParserDeferSubClause(SqliteDeferrable::DEFERRABLE, *(yymsp[0].minor.yy192));
                                                delete yymsp[0].minor.yy192;
                                            }
        break;
      case 113: /* init_deferred_pred_opt ::= */
{yygotominor.yy192 = new SqliteInitially(SqliteInitially::null);}
        break;
      case 114: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
{yygotominor.yy192 = new SqliteInitially(SqliteInitially::DEFERRED);}
        break;
      case 115: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
{yygotominor.yy192 = new SqliteInitially(SqliteInitially::IMMEDIATE);}
        break;
      case 116: /* conslist_opt ::= */
{yygotominor.yy373 = new ParserCreateTableConstraintList();}
        break;
      case 117: /* conslist_opt ::= COMMA conslist */
{yygotominor.yy373 = yymsp[0].minor.yy373;}
        break;
      case 118: /* conslist ::= conslist tconscomma tcons */
{
                                                yymsp[0].minor.yy106->afterComma = *(yymsp[-1].minor.yy291);
                                                yymsp[-2].minor.yy373->append(yymsp[0].minor.yy106);
                                                yygotominor.yy373 = yymsp[-2].minor.yy373;
                                                delete yymsp[-1].minor.yy291;
                                                DONT_INHERIT_TOKENS("conslist");
                                            }
        break;
      case 119: /* conslist ::= tcons */
{
                                                yygotominor.yy373 = new ParserCreateTableConstraintList();
                                                yygotominor.yy373->append(yymsp[0].minor.yy106);
                                            }
        break;
      case 122: /* tcons ::= CONSTRAINT nm */
{
                                                yygotominor.yy106 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy106->initNameOnly(*(yymsp[0].minor.yy259));
                                                delete yymsp[0].minor.yy259;
                                                objectForTokens = yygotominor.yy106;
                                            }
        break;
      case 123: /* tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf */
{
                                                yygotominor.yy106 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy106->initPk(*(yymsp[-3].minor.yy123), *(yymsp[-2].minor.yy291), *(yymsp[0].minor.yy478));
                                                delete yymsp[-2].minor.yy291;
                                                delete yymsp[0].minor.yy478;
                                                delete yymsp[-3].minor.yy123;
                                                objectForTokens = yygotominor.yy106;
                                            }
        break;
      case 124: /* tcons ::= UNIQUE LP idxlist RP onconf */
{
                                                yygotominor.yy106 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy106->initUnique(*(yymsp[-2].minor.yy123), *(yymsp[0].minor.yy478));
                                                delete yymsp[0].minor.yy478;
                                                delete yymsp[-2].minor.yy123;
                                                objectForTokens = yygotominor.yy106;
                                            }
        break;
      case 125: /* tcons ::= CHECK LP expr RP onconf */
{
                                                yygotominor.yy106 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy106->initCheck(yymsp[-2].minor.yy252, *(yymsp[0].minor.yy478));
                                                objectForTokens = yygotominor.yy106;
                                            }
        break;
      case 126: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
      case 127: /* tcons ::= CONSTRAINT ID_CONSTR */ yytestcase(yyruleno==127);
      case 128: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB */ yytestcase(yyruleno==128);
{
                                                yygotominor.yy106 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy106->initFk(
                                                    *(yymsp[-6].minor.yy123),
                                                    *(yymsp[-3].minor.yy259),
                                                    *(yymsp[-2].minor.yy123),
                                                    *(yymsp[-1].minor.yy324),
                                                    yymsp[0].minor.yy449->initially,
                                                    yymsp[0].minor.yy449->deferrable
                                                );
                                                delete yymsp[-3].minor.yy259;
                                                delete yymsp[-1].minor.yy324;
                                                delete yymsp[0].minor.yy449;
                                                delete yymsp[-2].minor.yy123;
                                                delete yymsp[-6].minor.yy123;
                                                objectForTokens = yygotominor.yy106;
                                            }
        break;
      case 129: /* tcons ::= CHECK LP RP onconf */
{
                                                yygotominor.yy106 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy106->initCheck();
                                                objectForTokens = yygotominor.yy106;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                              yy_destructor(yypParser,228,&yymsp[0].minor);
}
        break;
      case 130: /* defer_subclause_opt ::= */
{yygotominor.yy449 = new ParserDeferSubClause(SqliteDeferrable::null, SqliteInitially::null);}
        break;
      case 131: /* defer_subclause_opt ::= defer_subclause */
{yygotominor.yy449 = yymsp[0].minor.yy449;}
        break;
      case 132: /* onconf ::= */
      case 134: /* orconf ::= */ yytestcase(yyruleno==134);
{yygotominor.yy478 = new SqliteConflictAlgo(SqliteConflictAlgo::null);}
        break;
      case 133: /* onconf ::= ON CONFLICT resolvetype */
      case 135: /* orconf ::= OR resolvetype */ yytestcase(yyruleno==135);
{yygotominor.yy478 = yymsp[0].minor.yy478;}
        break;
      case 136: /* resolvetype ::= raisetype */
      case 137: /* resolvetype ::= IGNORE */ yytestcase(yyruleno==137);
      case 138: /* resolvetype ::= REPLACE */ yytestcase(yyruleno==138);
{yygotominor.yy478 = new SqliteConflictAlgo(sqliteConflictAlgo(yymsp[0].minor.yy0->value));}
        break;
      case 139: /* cmd ::= DROP TABLE ifexists fullname */
{
                                                yygotominor.yy443 = new SqliteDropTable(*(yymsp[-1].minor.yy291), yymsp[0].minor.yy60->name1, yymsp[0].minor.yy60->name2);
                                                delete yymsp[-1].minor.yy291;
                                                delete yymsp[0].minor.yy60;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 140: /* cmd ::= DROP TABLE ifexists nm DOT ID_TAB */
      case 141: /* cmd ::= DROP TABLE ifexists ID_DB|ID_TAB */ yytestcase(yyruleno==141);
      case 148: /* cmd ::= DROP VIEW ifexists nm DOT ID_VIEW */ yytestcase(yyruleno==148);
      case 149: /* cmd ::= DROP VIEW ifexists ID_DB|ID_VIEW */ yytestcase(yyruleno==149);
      case 192: /* singlesrc ::= nm DOT ID_TAB */ yytestcase(yyruleno==192);
      case 193: /* singlesrc ::= ID_DB|ID_TAB */ yytestcase(yyruleno==193);
      case 194: /* singlesrc ::= nm DOT ID_VIEW */ yytestcase(yyruleno==194);
      case 195: /* singlesrc ::= ID_DB|ID_VIEW */ yytestcase(yyruleno==195);
      case 354: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm DOT ID_IDX_NEW */ yytestcase(yyruleno==354);
      case 355: /* cmd ::= CREATE uniqueflag INDEX ifnotexists ID_DB|ID_IDX_NEW */ yytestcase(yyruleno==355);
      case 368: /* cmd ::= DROP INDEX ifexists nm DOT ID_IDX */ yytestcase(yyruleno==368);
      case 369: /* cmd ::= DROP INDEX ifexists ID_DB|ID_IDX */ yytestcase(yyruleno==369);
      case 379: /* cmd ::= PRAGMA nm DOT ID_PRAGMA */ yytestcase(yyruleno==379);
      case 380: /* cmd ::= PRAGMA ID_DB|ID_PRAGMA */ yytestcase(yyruleno==380);
      case 418: /* cmd ::= DROP TRIGGER ifexists nm DOT ID_TRIG */ yytestcase(yyruleno==418);
      case 419: /* cmd ::= DROP TRIGGER ifexists ID_DB|ID_TRIG */ yytestcase(yyruleno==419);
      case 429: /* cmd ::= REINDEX nm DOT ID_TAB|ID_IDX */ yytestcase(yyruleno==429);
      case 430: /* cmd ::= REINDEX ID_DB|ID_IDX|ID_TAB */ yytestcase(yyruleno==430);
      case 433: /* cmd ::= ANALYZE nm DOT ID_TAB|ID_IDX */ yytestcase(yyruleno==433);
      case 434: /* cmd ::= ANALYZE ID_DB|ID_IDX|ID_TAB */ yytestcase(yyruleno==434);
      case 439: /* cmd ::= ALTER TABLE nm DOT ID_TAB */ yytestcase(yyruleno==439);
      case 440: /* cmd ::= ALTER TABLE ID_DB|ID_TAB */ yytestcase(yyruleno==440);
      case 446: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm DOT ID_TAB_NEW */ yytestcase(yyruleno==446);
      case 447: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists ID_DB|ID_TAB_NEW */ yytestcase(yyruleno==447);
{  yy_destructor(yypParser,203,&yymsp[-2].minor);
}
        break;
      case 144: /* cmd ::= CREATE temp VIEW ifnotexists fullname idxlist_opt AS select */
{
                                                yygotominor.yy443 = new SqliteCreateView(*(yymsp[-6].minor.yy346), *(yymsp[-4].minor.yy291), yymsp[-3].minor.yy60->name1, yymsp[-3].minor.yy60->name2, yymsp[0].minor.yy453, *(yymsp[-2].minor.yy123));
                                                delete yymsp[-6].minor.yy346;
                                                delete yymsp[-4].minor.yy291;
                                                delete yymsp[-3].minor.yy60;
                                                delete yymsp[-2].minor.yy123;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 147: /* cmd ::= DROP VIEW ifexists fullname */
{
                                                yygotominor.yy443 = new SqliteDropView(*(yymsp[-1].minor.yy291), yymsp[0].minor.yy60->name1, yymsp[0].minor.yy60->name2);
                                                delete yymsp[-1].minor.yy291;
                                                delete yymsp[0].minor.yy60;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 150: /* cmd ::= select_stmt */
      case 239: /* cmd ::= delete_stmt */ yytestcase(yyruleno==239);
      case 250: /* cmd ::= update_stmt */ yytestcase(yyruleno==250);
      case 271: /* cmd ::= insert_stmt */ yytestcase(yyruleno==271);
{
                                                yygotominor.yy443 = yymsp[0].minor.yy443;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 151: /* select_stmt ::= select */
{
                                                yygotominor.yy443 = yymsp[0].minor.yy453;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 152: /* select ::= with selectnowith */
{
                                                yygotominor.yy453 = yymsp[0].minor.yy453;
                                                yymsp[0].minor.yy453->setWith(yymsp[-1].minor.yy641);
                                                objectForTokens = yygotominor.yy453;
                                            }
        break;
      case 153: /* selectnowith ::= oneselect */
{
                                                yygotominor.yy453 = SqliteSelect::append(yymsp[0].minor.yy450);
                                                objectForTokens = yygotominor.yy453;
                                            }
        break;
      case 154: /* selectnowith ::= selectnowith multiselect_op oneselect */
{
                                                yygotominor.yy453 = SqliteSelect::append(yymsp[-2].minor.yy453, *(yymsp[-1].minor.yy382), yymsp[0].minor.yy450);
                                                delete yymsp[-1].minor.yy382;
                                                objectForTokens = yygotominor.yy453;
                                            }
        break;
      case 155: /* selectnowith ::= values */
{
                                                yygotominor.yy453 = SqliteSelect::append(*(yymsp[0].minor.yy546));
                                                delete yymsp[0].minor.yy546;
                                                objectForTokens = yygotominor.yy453;
                                            }
        break;
      case 156: /* selectnowith ::= selectnowith COMMA values */
{
                                                yygotominor.yy453 = SqliteSelect::append(yymsp[-2].minor.yy453, SqliteSelect::CompoundOperator::UNION_ALL, *(yymsp[0].minor.yy546));
                                                delete yymsp[0].minor.yy546;
                                                objectForTokens = yygotominor.yy453;
                                            }
        break;
      case 157: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
{
                                                yygotominor.yy450 = new SqliteSelect::Core(
                                                        *(yymsp[-7].minor.yy346),
                                                        *(yymsp[-6].minor.yy633),
                                                        yymsp[-5].minor.yy91,
                                                        yymsp[-4].minor.yy252,
                                                        *(yymsp[-3].minor.yy351),
                                                        yymsp[-2].minor.yy252,
                                                        *(yymsp[-1].minor.yy543),
                                                        yymsp[0].minor.yy444
                                                    );
                                                delete yymsp[-6].minor.yy633;
                                                delete yymsp[-7].minor.yy346;
                                                delete yymsp[-3].minor.yy351;
                                                delete yymsp[-1].minor.yy543;
                                                objectForTokens = yygotominor.yy450;
                                            }
        break;
      case 158: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt window_clause orderby_opt limit_opt */
{
                                                yygotominor.yy450 = new SqliteSelect::Core(
                                                        *(yymsp[-8].minor.yy346),
                                                        *(yymsp[-7].minor.yy633),
                                                        yymsp[-6].minor.yy91,
                                                        yymsp[-5].minor.yy252,
                                                        *(yymsp[-4].minor.yy351),
                                                        yymsp[-3].minor.yy252,
                                                        *(yymsp[-2].minor.yy639),
                                                        *(yymsp[-1].minor.yy543),
                                                        yymsp[0].minor.yy444
                                                    );
                                                delete yymsp[-7].minor.yy633;
                                                delete yymsp[-8].minor.yy346;
                                                delete yymsp[-4].minor.yy351;
                                                delete yymsp[-1].minor.yy543;
                                                delete yymsp[-2].minor.yy639;
                                                objectForTokens = yygotominor.yy450;
                                            }
        break;
      case 159: /* values ::= VALUES LP nexprlist RP */
{
                                                yygotominor.yy546 = new ParserExprNestedList();
                                                yygotominor.yy546->append(*(yymsp[-1].minor.yy351));
                                                delete yymsp[-1].minor.yy351;
                                            }
        break;
      case 160: /* values ::= values COMMA LP exprlist RP */
{
                                                yymsp[-4].minor.yy546->append(*(yymsp[-1].minor.yy351));
                                                yygotominor.yy546 = yymsp[-4].minor.yy546;
                                                delete yymsp[-1].minor.yy351;
                                                DONT_INHERIT_TOKENS("values");
                                            }
        break;
      case 161: /* multiselect_op ::= UNION */
{yygotominor.yy382 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION);}
        break;
      case 162: /* multiselect_op ::= UNION ALL */
{yygotominor.yy382 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION_ALL);}
        break;
      case 163: /* multiselect_op ::= EXCEPT */
{yygotominor.yy382 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::EXCEPT);}
        break;
      case 164: /* multiselect_op ::= INTERSECT */
{yygotominor.yy382 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::INTERSECT);}
        break;
      case 165: /* distinct ::= DISTINCT */
{yygotominor.yy346 = new int(1);}
        break;
      case 166: /* distinct ::= ALL */
{yygotominor.yy346 = new int(2);}
        break;
      case 168: /* sclp ::= selcollist COMMA */
{yygotominor.yy633 = yymsp[-1].minor.yy633;}
        break;
      case 169: /* sclp ::= */
      case 248: /* returning ::= */ yytestcase(yyruleno==248);
{yygotominor.yy633 = new ParserResultColumnList();}
        break;
      case 170: /* selcollist ::= sclp expr as */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        yymsp[-1].minor.yy252,
                                                        yymsp[0].minor.yy460 ? yymsp[0].minor.yy460->asKw : false,
                                                        yymsp[0].minor.yy460 ? yymsp[0].minor.yy460->name : QString()
                                                    );

                                                yymsp[-2].minor.yy633->append(obj);
                                                yygotominor.yy633 = yymsp[-2].minor.yy633;
                                                delete yymsp[0].minor.yy460;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 171: /* selcollist ::= sclp STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(true);

                                                yymsp[-1].minor.yy633->append(obj);
                                                yygotominor.yy633 = yymsp[-1].minor.yy633;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 172: /* selcollist ::= sclp tnm DOT STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        true,
                                                        yymsp[-2].minor.yy350->toName()
                                                    );
													
												if (!yymsp[-2].minor.yy350->isName())
													parserContext->errorAtToken("Syntax error <expected name, not literal value>", -3);
													
                                                yymsp[-3].minor.yy633->append(obj);
                                                yygotominor.yy633 = yymsp[-3].minor.yy633;
                                                delete yymsp[-2].minor.yy350;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 173: /* selcollist ::= sclp */
      case 174: /* selcollist ::= sclp ID_TAB DOT STAR */ yytestcase(yyruleno==174);
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy633 = yymsp[0].minor.yy633;
                                            }
        break;
      case 175: /* as ::= AS nm */
{
                                                yygotominor.yy460 = new ParserStubAlias(*(yymsp[0].minor.yy259), true);
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 176: /* as ::= ids */
      case 177: /* as ::= AS ID_ALIAS */ yytestcase(yyruleno==177);
      case 178: /* as ::= ID_ALIAS */ yytestcase(yyruleno==178);
{
                                                yygotominor.yy460 = new ParserStubAlias(*(yymsp[0].minor.yy259), false);
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 179: /* as ::= */
{yygotominor.yy460 = nullptr;}
        break;
      case 180: /* from ::= */
{yygotominor.yy91 = nullptr;}
        break;
      case 181: /* from ::= FROM joinsrc */
{yygotominor.yy91 = yymsp[0].minor.yy91;}
        break;
      case 182: /* joinsrc ::= singlesrc seltablist */
{
                                                yygotominor.yy91 = new SqliteSelect::Core::JoinSource(
                                                        yymsp[-1].minor.yy361,
                                                        *(yymsp[0].minor.yy11)
                                                    );
                                                delete yymsp[0].minor.yy11;
                                                objectForTokens = yygotominor.yy91;
                                            }
        break;
      case 183: /* joinsrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy91 = new SqliteSelect::Core::JoinSource();
                                                objectForTokens = yygotominor.yy91;
                                            }
        break;
      case 184: /* seltablist ::= seltablist joinop singlesrc joinconstr_opt */
{
                                                SqliteSelect::Core::JoinSourceOther* src =
                                                    new SqliteSelect::Core::JoinSourceOther(yymsp[-2].minor.yy521, yymsp[-1].minor.yy361, yymsp[0].minor.yy335);

                                                yymsp[-3].minor.yy11->append(src);
                                                yygotominor.yy11 = yymsp[-3].minor.yy11;
                                                objectForTokens = src;
                                                DONT_INHERIT_TOKENS("seltablist");
                                            }
        break;
      case 185: /* seltablist ::= */
{
                                                yygotominor.yy11 = new ParserOtherSourceList();
                                            }
        break;
      case 186: /* singlesrc ::= nm dbnm as indexed_opt */
{
                                                yygotominor.yy361 = new SqliteSelect::Core::SingleSource(
                                                        *(yymsp[-3].minor.yy259),
                                                        *(yymsp[-2].minor.yy259),
                                                        yymsp[-1].minor.yy460 ? yymsp[-1].minor.yy460->asKw : false,
                                                        yymsp[-1].minor.yy460 ? yymsp[-1].minor.yy460->name : QString(),
                                                        yymsp[0].minor.yy312 ? yymsp[0].minor.yy312->notIndexedKw : false,
                                                        yymsp[0].minor.yy312 ? yymsp[0].minor.yy312->indexedBy : QString()
                                                    );
                                                delete yymsp[-3].minor.yy259;
                                                delete yymsp[-2].minor.yy259;
                                                delete yymsp[-1].minor.yy460;
                                                if (yymsp[0].minor.yy312)
                                                    delete yymsp[0].minor.yy312;
                                                objectForTokens = yygotominor.yy361;
                                            }
        break;
      case 187: /* singlesrc ::= LP select RP as */
{
                                                yygotominor.yy361 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy453,
                                                        yymsp[0].minor.yy460 ? yymsp[0].minor.yy460->asKw : false,
                                                        yymsp[0].minor.yy460 ? yymsp[0].minor.yy460->name : QString()
                                                    );
                                                delete yymsp[0].minor.yy460;
                                                objectForTokens = yygotominor.yy361;
                                            }
        break;
      case 188: /* singlesrc ::= LP joinsrc RP as */
{
                                                yygotominor.yy361 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy91,
                                                        yymsp[0].minor.yy460 ? yymsp[0].minor.yy460->asKw : false,
                                                        yymsp[0].minor.yy460 ? yymsp[0].minor.yy460->name : QString()
                                                    );
                                                delete yymsp[0].minor.yy460;
                                                objectForTokens = yygotominor.yy361;
                                            }
        break;
      case 189: /* singlesrc ::= nm dbnm LP exprlist RP as */
{
                                                yygotominor.yy361 = new SqliteSelect::Core::SingleSource(
                                                        *(yymsp[-5].minor.yy259),
                                                        *(yymsp[-4].minor.yy259),
                                                        yymsp[0].minor.yy460 ? yymsp[0].minor.yy460->asKw : false,
                                                        yymsp[0].minor.yy460 ? yymsp[0].minor.yy460->name : QString(),
                                                        *(yymsp[-2].minor.yy351)
                                                    );
                                                delete yymsp[-5].minor.yy259;
                                                delete yymsp[-4].minor.yy259;
                                                delete yymsp[0].minor.yy460;
                                                if (yymsp[-2].minor.yy351)
                                                    delete yymsp[-2].minor.yy351;

                                                objectForTokens = yygotominor.yy361;
                                            }
        break;
      case 190: /* singlesrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy361 = new SqliteSelect::Core::SingleSource();
                                                objectForTokens = yygotominor.yy361;
                                            }
        break;
      case 191: /* singlesrc ::= nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy361 = new SqliteSelect::Core::SingleSource();
                                                yygotominor.yy361->database = *(yymsp[-1].minor.yy259);
                                                delete yymsp[-1].minor.yy259;
                                                objectForTokens = yygotominor.yy361;
                                            }
        break;
      case 196: /* joinconstr_opt ::= ON expr */
{
                                                yygotominor.yy335 = new SqliteSelect::Core::JoinConstraint(yymsp[0].minor.yy252);
                                                objectForTokens = yygotominor.yy335;
                                            }
        break;
      case 197: /* joinconstr_opt ::= USING LP idlist RP */
{
                                                yygotominor.yy335 = new SqliteSelect::Core::JoinConstraint(*(yymsp[-1].minor.yy215));
                                                delete yymsp[-1].minor.yy215;
                                                objectForTokens = yygotominor.yy335;
                                            }
        break;
      case 198: /* joinconstr_opt ::= */
{yygotominor.yy335 = nullptr;}
        break;
      case 199: /* dbnm ::= */
      case 364: /* collate ::= */ yytestcase(yyruleno==364);
      case 450: /* vtabarg ::= */ yytestcase(yyruleno==450);
      case 454: /* anylist ::= */ yytestcase(yyruleno==454);
{yygotominor.yy259 = new QString();}
        break;
      case 201: /* fullname ::= nm */
{
                                                yygotominor.yy60 = new ParserFullName();
                                                yygotominor.yy60->name1 = *(yymsp[0].minor.yy259);
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 202: /* fullname ::= nm DOT nm */
{
                                                yygotominor.yy60 = new ParserFullName();
                                                yygotominor.yy60->name1 = *(yymsp[-2].minor.yy259);
                                                yygotominor.yy60->name2 = *(yymsp[0].minor.yy259);
                                                delete yymsp[-2].minor.yy259;
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 203: /* xfullname ::= nm */
{
                                                yygotominor.yy116 = new ParserXFullName();
                                                yygotominor.yy116->name1 = *(yymsp[0].minor.yy259);
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 204: /* xfullname ::= nm DOT nm */
{
                                                yygotominor.yy116 = new ParserXFullName();
                                                yygotominor.yy116->name1 = *(yymsp[-2].minor.yy259);
                                                yygotominor.yy116->name2 = *(yymsp[0].minor.yy259);
                                                delete yymsp[-2].minor.yy259;
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 205: /* xfullname ::= nm DOT nm AS nm */
{
                                                yygotominor.yy116 = new ParserXFullName();
                                                yygotominor.yy116->name1 = *(yymsp[-4].minor.yy259);
                                                yygotominor.yy116->name2 = *(yymsp[-2].minor.yy259);
                                                yygotominor.yy116->alias = *(yymsp[0].minor.yy259);
                                                delete yymsp[-4].minor.yy259;
                                                delete yymsp[-2].minor.yy259;
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 206: /* xfullname ::= nm AS nm */
{
                                                yygotominor.yy116 = new ParserXFullName();
                                                yygotominor.yy116->name1 = *(yymsp[-2].minor.yy259);
                                                yygotominor.yy116->alias = *(yymsp[0].minor.yy259);
                                                delete yymsp[-2].minor.yy259;
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 207: /* xfullname ::= nm DOT nm AS ID_ALIAS */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy116 = new ParserXFullName();
                                                yygotominor.yy116->name1 = *(yymsp[-4].minor.yy259);
                                                yygotominor.yy116->name2 = *(yymsp[-2].minor.yy259);
                                                delete yymsp[-4].minor.yy259;
                                                delete yymsp[-2].minor.yy259;
                                            }
        break;
      case 208: /* xfullname ::= nm AS ID_ALIAS */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy116 = new ParserXFullName();
                                                yygotominor.yy116->name1 = *(yymsp[-2].minor.yy259);
                                                delete yymsp[-2].minor.yy259;
                                            }
        break;
      case 209: /* joinop ::= COMMA */
{
                                                yygotominor.yy521 = new SqliteSelect::Core::JoinOp(true);
                                                objectForTokens = yygotominor.yy521;
                                            }
        break;
      case 210: /* joinop ::= JOIN */
{
                                                yygotominor.yy521 = new SqliteSelect::Core::JoinOp(false);
                                                objectForTokens = yygotominor.yy521;
                                            }
        break;
      case 211: /* joinop ::= JOIN_KW JOIN */
{
                                                yygotominor.yy521 = new SqliteSelect::Core::JoinOp(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy521;
                                            }
        break;
      case 212: /* joinop ::= JOIN_KW nm JOIN */
{
                                                yygotominor.yy521 = new SqliteSelect::Core::JoinOp(yymsp[-2].minor.yy0->value, *(yymsp[-1].minor.yy259));
                                                delete yymsp[-1].minor.yy259;
                                                objectForTokens = yygotominor.yy521;
                                            }
        break;
      case 213: /* joinop ::= JOIN_KW nm nm JOIN */
      case 214: /* joinop ::= ID_JOIN_OPTS */ yytestcase(yyruleno==214);
{
                                                yygotominor.yy521 = new SqliteSelect::Core::JoinOp(yymsp[-3].minor.yy0->value, *(yymsp[-2].minor.yy259), *(yymsp[-1].minor.yy259));
                                                delete yymsp[-2].minor.yy259;
                                                objectForTokens = yygotominor.yy521;
                                            }
        break;
      case 215: /* indexed_opt ::= */
{yygotominor.yy312 = nullptr;}
        break;
      case 216: /* indexed_opt ::= indexed_by */
{yygotominor.yy312 = yymsp[0].minor.yy312;}
        break;
      case 217: /* indexed_by ::= INDEXED BY nm */
{
                                                yygotominor.yy312 = new ParserIndexedBy(*(yymsp[0].minor.yy259));
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 218: /* indexed_by ::= NOT INDEXED */
{yygotominor.yy312 = new ParserIndexedBy(true);}
        break;
      case 219: /* indexed_by ::= INDEXED BY ID_IDX */
{parserContext->minorErrorBeforeNextToken("Syntax error");}
        break;
      case 220: /* orderby_opt ::= */
{yygotominor.yy543 = new ParserOrderByList();}
        break;
      case 221: /* orderby_opt ::= ORDER BY sortlist */
{yygotominor.yy543 = yymsp[0].minor.yy543;}
        break;
      case 222: /* sortlist ::= sortlist COMMA expr sortorder nulls */
{
                                                SqliteOrderBy* obj = new SqliteOrderBy(yymsp[-2].minor.yy252, *(yymsp[-1].minor.yy389), *(yymsp[0].minor.yy99));
                                                yymsp[-4].minor.yy543->append(obj);
                                                yygotominor.yy543 = yymsp[-4].minor.yy543;
                                                delete yymsp[-1].minor.yy389;
												delete yymsp[0].minor.yy99;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sortlist");
                                            }
        break;
      case 223: /* sortlist ::= expr sortorder nulls */
{
                                                SqliteOrderBy* obj = new SqliteOrderBy(yymsp[-2].minor.yy252, *(yymsp[-1].minor.yy389), *(yymsp[0].minor.yy99));
                                                yygotominor.yy543 = new ParserOrderByList();
                                                yygotominor.yy543->append(obj);
                                                delete yymsp[-1].minor.yy389;
												delete yymsp[0].minor.yy99;
                                                objectForTokens = obj;
                                            }
        break;
      case 224: /* sortorder ::= ASC */
{yygotominor.yy389 = new SqliteSortOrder(SqliteSortOrder::ASC);}
        break;
      case 225: /* sortorder ::= DESC */
{yygotominor.yy389 = new SqliteSortOrder(SqliteSortOrder::DESC);}
        break;
      case 226: /* sortorder ::= */
{yygotominor.yy389 = new SqliteSortOrder(SqliteSortOrder::null);}
        break;
      case 227: /* nulls ::= NULLS FIRST */
{yygotominor.yy99 = new SqliteNulls(SqliteNulls::FIRST);}
        break;
      case 228: /* nulls ::= NULLS LAST */
{yygotominor.yy99 = new SqliteNulls(SqliteNulls::LAST);}
        break;
      case 229: /* nulls ::= */
{yygotominor.yy99 = new SqliteNulls(SqliteNulls::null);}
        break;
      case 230: /* groupby_opt ::= */
      case 349: /* exprlist ::= */ yytestcase(yyruleno==349);
{yygotominor.yy351 = new ParserExprList();}
        break;
      case 231: /* groupby_opt ::= GROUP BY nexprlist */
      case 348: /* exprlist ::= nexprlist */ yytestcase(yyruleno==348);
{yygotominor.yy351 = yymsp[0].minor.yy351;}
        break;
      case 232: /* groupby_opt ::= GROUP BY */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy351 = new ParserExprList();
                                            }
        break;
      case 233: /* having_opt ::= */
      case 245: /* where_opt ::= */ yytestcase(yyruleno==245);
      case 345: /* case_else ::= */ yytestcase(yyruleno==345);
      case 347: /* case_operand ::= */ yytestcase(yyruleno==347);
      case 373: /* vinto ::= */ yytestcase(yyruleno==373);
      case 407: /* when_clause ::= */ yytestcase(yyruleno==407);
      case 422: /* key_opt ::= */ yytestcase(yyruleno==422);
{yygotominor.yy252 = nullptr;}
        break;
      case 234: /* having_opt ::= HAVING expr */
      case 246: /* where_opt ::= WHERE expr */ yytestcase(yyruleno==246);
      case 336: /* expr ::= exprx */ yytestcase(yyruleno==336);
      case 344: /* case_else ::= ELSE expr */ yytestcase(yyruleno==344);
      case 346: /* case_operand ::= exprx */ yytestcase(yyruleno==346);
      case 372: /* vinto ::= INTO expr */ yytestcase(yyruleno==372);
      case 408: /* when_clause ::= WHEN expr */ yytestcase(yyruleno==408);
      case 423: /* key_opt ::= KEY expr */ yytestcase(yyruleno==423);
{yygotominor.yy252 = yymsp[0].minor.yy252;}
        break;
      case 235: /* limit_opt ::= */
{yygotominor.yy444 = nullptr;}
        break;
      case 236: /* limit_opt ::= LIMIT expr */
{
                                                yygotominor.yy444 = new SqliteLimit(yymsp[0].minor.yy252);
                                                objectForTokens = yygotominor.yy444;
                                            }
        break;
      case 237: /* limit_opt ::= LIMIT expr OFFSET expr */
{
                                                yygotominor.yy444 = new SqliteLimit(yymsp[-2].minor.yy252, yymsp[0].minor.yy252, true);
                                                objectForTokens = yygotominor.yy444;
                                            }
        break;
      case 238: /* limit_opt ::= LIMIT expr COMMA expr */
{
                                                yygotominor.yy444 = new SqliteLimit(yymsp[-2].minor.yy252, yymsp[0].minor.yy252, false);
                                                objectForTokens = yygotominor.yy444;
                                            }
        break;
      case 240: /* delete_stmt ::= with DELETE FROM xfullname indexed_opt where_opt returning orderby_opt limit_opt */
{
                                                if (yymsp[-4].minor.yy312)
                                                {
                                                    if (!yymsp[-4].minor.yy312->indexedBy.isNull())
                                                    {
                                                        yygotominor.yy443 = new SqliteDelete(
                                                                yymsp[-5].minor.yy116->name1,
                                                                yymsp[-5].minor.yy116->name2,
                                                                yymsp[-5].minor.yy116->alias,
                                                                yymsp[-4].minor.yy312->indexedBy,
                                                                yymsp[-3].minor.yy252,
                                                                yymsp[-8].minor.yy641,
                                                                *(yymsp[-2].minor.yy633),
                                                                *(yymsp[-1].minor.yy543),
                                                                yymsp[0].minor.yy444
                                                            );
                                                    }
                                                    else
                                                    {
                                                        yygotominor.yy443 = new SqliteDelete(
                                                                yymsp[-5].minor.yy116->name1,
                                                                yymsp[-5].minor.yy116->name2,
                                                                yymsp[-5].minor.yy116->alias,
                                                                yymsp[-4].minor.yy312->notIndexedKw,
                                                                yymsp[-3].minor.yy252,
                                                                yymsp[-8].minor.yy641,
                                                                *(yymsp[-2].minor.yy633),
                                                                *(yymsp[-1].minor.yy543),
                                                                yymsp[0].minor.yy444
                                                            );
                                                    }
                                                    delete yymsp[-4].minor.yy312;
                                                }
                                                else
                                                {
                                                    yygotominor.yy443 = new SqliteDelete(
                                                            yymsp[-5].minor.yy116->name1,
                                                            yymsp[-5].minor.yy116->name2,
                                                            yymsp[-5].minor.yy116->alias,
                                                            false,
                                                            yymsp[-3].minor.yy252,
                                                            yymsp[-8].minor.yy641,
                                                            *(yymsp[-2].minor.yy633),
                                                            *(yymsp[-1].minor.yy543),
                                                            yymsp[0].minor.yy444
                                                        );
                                                }
                                                delete yymsp[-5].minor.yy116;
                                                delete yymsp[-2].minor.yy633;
                                                delete yymsp[-1].minor.yy543;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 241: /* delete_stmt ::= with DELETE FROM */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                q->with = yymsp[-2].minor.yy641;
                                                yygotominor.yy443 = q;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 242: /* delete_stmt ::= with DELETE FROM nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                q->with = yymsp[-4].minor.yy641;
                                                q->database = *(yymsp[-1].minor.yy259);
                                                yygotominor.yy443 = q;
                                                objectForTokens = yygotominor.yy443;
                                                delete yymsp[-1].minor.yy259;
                                            }
        break;
      case 243: /* delete_stmt ::= with DELETE FROM nm DOT ID_TAB */
      case 254: /* update_stmt ::= with UPDATE orconf nm DOT ID_TAB */ yytestcase(yyruleno==254);
{  yy_destructor(yypParser,249,&yymsp[-5].minor);
  yy_destructor(yypParser,203,&yymsp[-2].minor);
}
        break;
      case 244: /* delete_stmt ::= with DELETE FROM ID_DB|ID_TAB */
      case 255: /* update_stmt ::= with UPDATE orconf ID_DB|ID_TAB */ yytestcase(yyruleno==255);
{  yy_destructor(yypParser,249,&yymsp[-3].minor);
}
        break;
      case 247: /* where_opt ::= WHERE */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy252 = new SqliteExpr();
                                            }
        break;
      case 249: /* returning ::= RETURNING selcollist */
{yygotominor.yy633 = yymsp[0].minor.yy633;}
        break;
      case 251: /* update_stmt ::= with UPDATE orconf xfullname indexed_opt SET setlist from where_opt returning orderby_opt limit_opt */
{
                                                yygotominor.yy443 = new SqliteUpdate(
                                                        *(yymsp[-9].minor.yy478),
                                                        yymsp[-8].minor.yy116->name1,
                                                        yymsp[-8].minor.yy116->name2,
                                                        yymsp[-8].minor.yy116->alias,
                                                        yymsp[-7].minor.yy312 ? yymsp[-7].minor.yy312->notIndexedKw : false,
                                                        yymsp[-7].minor.yy312 ? yymsp[-7].minor.yy312->indexedBy : QString(),
                                                        *(yymsp[-5].minor.yy321),
                                                        yymsp[-4].minor.yy91,
                                                        yymsp[-3].minor.yy252,
                                                        yymsp[-11].minor.yy641,
                                                        *(yymsp[-2].minor.yy633),
                                                        *(yymsp[-1].minor.yy543),
                                                        yymsp[0].minor.yy444
                                                    );
                                                delete yymsp[-9].minor.yy478;
                                                delete yymsp[-8].minor.yy116;
                                                delete yymsp[-5].minor.yy321;
                                                delete yymsp[-2].minor.yy633;
                                                delete yymsp[-1].minor.yy543;
                                                if (yymsp[-7].minor.yy312)
                                                    delete yymsp[-7].minor.yy312;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 252: /* update_stmt ::= with UPDATE orconf */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteUpdate* q = new SqliteUpdate();
                                                q->with = yymsp[-2].minor.yy641;
                                                yygotominor.yy443 = q;
                                                objectForTokens = yygotominor.yy443;
                                                delete yymsp[0].minor.yy478;
                                            }
        break;
      case 253: /* update_stmt ::= with UPDATE orconf nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteUpdate* q = new SqliteUpdate();
                                                q->with = yymsp[-4].minor.yy641;
                                                q->database = *(yymsp[-1].minor.yy259);
                                                yygotominor.yy443 = q;
                                                objectForTokens = yygotominor.yy443;
                                                delete yymsp[-2].minor.yy478;
                                                delete yymsp[-1].minor.yy259;
                                            }
        break;
      case 256: /* setlist ::= setlist COMMA nm EQ expr */
{
                                                yymsp[-4].minor.yy321->append(ParserSetValue(*(yymsp[-2].minor.yy259), yymsp[0].minor.yy252));
                                                yygotominor.yy321 = yymsp[-4].minor.yy321;
                                                delete yymsp[-2].minor.yy259;
                                            }
        break;
      case 257: /* setlist ::= setlist COMMA LP idlist RP EQ expr */
{
                                                yymsp[-6].minor.yy321->append(ParserSetValue(*(yymsp[-3].minor.yy215), yymsp[0].minor.yy252));
                                                yygotominor.yy321 = yymsp[-6].minor.yy321;
                                                delete yymsp[-3].minor.yy215;
                                            }
        break;
      case 258: /* setlist ::= nm EQ expr */
{
                                                yygotominor.yy321 = new ParserSetValueList();
                                                yygotominor.yy321->append(ParserSetValue(*(yymsp[-2].minor.yy259), yymsp[0].minor.yy252));
                                                delete yymsp[-2].minor.yy259;
                                            }
        break;
      case 259: /* setlist ::= LP idlist RP EQ expr */
{
                                                yygotominor.yy321 = new ParserSetValueList();
                                                yygotominor.yy321->append(ParserSetValue(*(yymsp[-3].minor.yy215), yymsp[0].minor.yy252));
                                                delete yymsp[-3].minor.yy215;
                                            }
        break;
      case 260: /* setlist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy321 = new ParserSetValueList();
                                            }
        break;
      case 261: /* setlist ::= setlist COMMA */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy321 = yymsp[-1].minor.yy321;
                                            }
        break;
      case 262: /* setlist ::= setlist COMMA ID_COL */
      case 263: /* setlist ::= ID_COL */ yytestcase(yyruleno==263);
{  yy_destructor(yypParser,282,&yymsp[-2].minor);
}
        break;
      case 264: /* idlist_opt ::= */
{yygotominor.yy215 = new QStringList();}
        break;
      case 265: /* idlist_opt ::= LP idlist RP */
{yygotominor.yy215 = yymsp[-1].minor.yy215;}
        break;
      case 266: /* idlist ::= idlist COMMA nm */
{
                                                yygotominor.yy215 = yymsp[-2].minor.yy215;
                                                *(yygotominor.yy215) << *(yymsp[0].minor.yy259);
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 267: /* idlist ::= nm */
{
                                                yygotominor.yy215 = new QStringList();
                                                *(yygotominor.yy215) << *(yymsp[0].minor.yy259);
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 268: /* idlist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy215 = new QStringList();
                                            }
        break;
      case 269: /* idlist ::= idlist COMMA ID_COL */
      case 270: /* idlist ::= ID_COL */ yytestcase(yyruleno==270);
{  yy_destructor(yypParser,274,&yymsp[-2].minor);
}
        break;
      case 272: /* insert_stmt ::= with insert_cmd INTO xfullname idlist_opt select upsert returning */
{
                                                yygotominor.yy443 = new SqliteInsert(
                                                        yymsp[-6].minor.yy584->replace,
                                                        yymsp[-6].minor.yy584->orConflict,
                                                        yymsp[-4].minor.yy116->name1,
                                                        yymsp[-4].minor.yy116->name2,
                                                        yymsp[-4].minor.yy116->alias,
                                                        *(yymsp[-3].minor.yy215),
                                                        yymsp[-2].minor.yy453,
                                                        yymsp[-7].minor.yy641,
                                                        yymsp[-1].minor.yy500,
                                                        *(yymsp[0].minor.yy633)
                                                    );
                                                delete yymsp[-4].minor.yy116;
                                                delete yymsp[-6].minor.yy584;
                                                delete yymsp[-3].minor.yy215;
                                                delete yymsp[0].minor.yy633;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 273: /* insert_stmt ::= with insert_cmd INTO xfullname idlist_opt DEFAULT VALUES returning */
{
                                                yygotominor.yy443 = new SqliteInsert(
                                                        yymsp[-6].minor.yy584->replace,
                                                        yymsp[-6].minor.yy584->orConflict,
                                                        yymsp[-4].minor.yy116->name1,
                                                        yymsp[-4].minor.yy116->name2,
                                                        yymsp[-4].minor.yy116->alias,
                                                        *(yymsp[-3].minor.yy215),
                                                        yymsp[-7].minor.yy641,
                                                        *(yymsp[0].minor.yy633)
                                                    );
                                                delete yymsp[-4].minor.yy116;
                                                delete yymsp[-6].minor.yy584;
                                                delete yymsp[-3].minor.yy215;
                                                delete yymsp[0].minor.yy633;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 274: /* insert_stmt ::= with insert_cmd INTO xfullname LP idlist rp_opt */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy443 = new SqliteInsert(
                                                        yymsp[-5].minor.yy584->replace,
                                                        yymsp[-5].minor.yy584->orConflict,
                                                        yymsp[-3].minor.yy116->name1,
                                                        yymsp[-3].minor.yy116->name2,
                                                        yymsp[-3].minor.yy116->alias,
                                                        *(yymsp[-1].minor.yy215),
                                                        yymsp[-6].minor.yy641,
                                                        QList<SqliteResultColumn*>()
                                                    );
                                                objectForTokens = yygotominor.yy443;
                                                delete yymsp[-3].minor.yy116;
                                                delete yymsp[-1].minor.yy215;
                                                delete yymsp[-5].minor.yy584;
                                                delete yymsp[0].minor.yy291;
                                            }
        break;
      case 275: /* insert_stmt ::= with insert_cmd INTO */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-1].minor.yy584->replace;
                                                q->onConflict = yymsp[-1].minor.yy584->orConflict;
                                                q->with = yymsp[-2].minor.yy641;
                                                yygotominor.yy443 = q;
                                                objectForTokens = yygotominor.yy443;
                                                delete yymsp[-1].minor.yy584;
                                            }
        break;
      case 276: /* insert_stmt ::= with insert_cmd INTO nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-3].minor.yy584->replace;
                                                q->onConflict = yymsp[-3].minor.yy584->orConflict;
                                                q->with = yymsp[-4].minor.yy641;
                                                q->database = *(yymsp[-1].minor.yy259);
                                                yygotominor.yy443 = q;
                                                objectForTokens = yygotominor.yy443;
                                                delete yymsp[-3].minor.yy584;
                                                delete yymsp[-1].minor.yy259;
                                            }
        break;
      case 277: /* insert_stmt ::= with insert_cmd INTO ID_DB|ID_TAB */
{  yy_destructor(yypParser,249,&yymsp[-3].minor);
  yy_destructor(yypParser,285,&yymsp[-2].minor);
}
        break;
      case 278: /* insert_stmt ::= with insert_cmd INTO nm DOT ID_TAB */
{  yy_destructor(yypParser,249,&yymsp[-5].minor);
  yy_destructor(yypParser,285,&yymsp[-4].minor);
  yy_destructor(yypParser,203,&yymsp[-2].minor);
}
        break;
      case 279: /* insert_cmd ::= INSERT orconf */
{
                                                yygotominor.yy584 = new ParserStubInsertOrReplace(false, *(yymsp[0].minor.yy478));
                                                delete yymsp[0].minor.yy478;
                                            }
        break;
      case 280: /* insert_cmd ::= REPLACE */
{yygotominor.yy584 = new ParserStubInsertOrReplace(true);}
        break;
      case 281: /* upsert ::= */
{
                                                yygotominor.yy500 = nullptr;
                                            }
        break;
      case 282: /* upsert ::= ON CONFLICT LP sortlist RP where_opt DO UPDATE SET setlist where_opt */
{
                                                yygotominor.yy500 = new SqliteUpsert(*(yymsp[-7].minor.yy543), yymsp[-5].minor.yy252, *(yymsp[-1].minor.yy321), yymsp[0].minor.yy252);
                                                delete yymsp[-7].minor.yy543;
                                                delete yymsp[-1].minor.yy321;
                                                objectForTokens = yygotominor.yy500;
                                            }
        break;
      case 283: /* upsert ::= ON CONFLICT LP sortlist RP where_opt DO NOTHING */
{
                                                yygotominor.yy500 = new SqliteUpsert(*(yymsp[-4].minor.yy543), yymsp[-2].minor.yy252);
                                                delete yymsp[-4].minor.yy543;
                                                objectForTokens = yygotominor.yy500;
                                            }
        break;
      case 284: /* upsert ::= ON CONFLICT DO NOTHING */
{
                                                yygotominor.yy500 = new SqliteUpsert();
                                                objectForTokens = yygotominor.yy500;
                                            }
        break;
      case 285: /* exprx ::= expr not_opt IN ID_DB */
{  yy_destructor(yypParser,227,&yymsp[-3].minor);
}
        break;
      case 286: /* exprx ::= expr not_opt IN nm DOT ID_TAB */
      case 287: /* exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN */ yytestcase(yyruleno==287);
{  yy_destructor(yypParser,227,&yymsp[-5].minor);
  yy_destructor(yypParser,203,&yymsp[-2].minor);
}
        break;
      case 288: /* exprx ::= tnm DOT ID_TAB|ID_COL */
{  yy_destructor(yypParser,235,&yymsp[-2].minor);
}
        break;
      case 289: /* exprx ::= tnm DOT nm DOT ID_COL */
{  yy_destructor(yypParser,235,&yymsp[-4].minor);
  yy_destructor(yypParser,203,&yymsp[-2].minor);
}
        break;
      case 290: /* exprx ::= expr COLLATE ID_COLLATE */
      case 291: /* exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP */ yytestcase(yyruleno==291);
{  yy_destructor(yypParser,227,&yymsp[-2].minor);
}
        break;
      case 292: /* exprx ::= CTIME_KW */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initCTime(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 293: /* exprx ::= LP nexprlist RP */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initRowValue(*(yymsp[-1].minor.yy351));
                                                delete yymsp[-1].minor.yy351;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 294: /* exprx ::= tnm */
{
                                                yygotominor.yy252 = new SqliteExpr();
												if (yymsp[0].minor.yy350->isLiteral())
													yygotominor.yy252->initLiteral(yymsp[0].minor.yy350->toLiteral());
												else
													yygotominor.yy252->initId(yymsp[0].minor.yy350->toName());
													//parserContext->errorBeforeLastToken("Syntax error <expected literal value>");

                                                delete yymsp[0].minor.yy350;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 295: /* exprx ::= tnm DOT nm */
{
                                                yygotominor.yy252 = new SqliteExpr();
												if (yymsp[-2].minor.yy350->isName())
													yygotominor.yy252->initId(yymsp[-2].minor.yy350->toName(), *(yymsp[0].minor.yy259));
												else
													parserContext->errorAtToken("Syntax error <expected name>", -3);

                                                delete yymsp[-2].minor.yy350;
                                                delete yymsp[0].minor.yy259;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 296: /* exprx ::= tnm DOT */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy252;
                                                if (yymsp[-1].minor.yy350->isName())
                                                {
                                                    yygotominor.yy252->initId(yymsp[-1].minor.yy350->toName(), QString());
                                                    parserContext->minorErrorAfterLastToken("Syntax error <expr>");
                                                }
                                                else
                                                    parserContext->errorAtToken("Syntax error <expected name>", -3);

                                                delete yymsp[-1].minor.yy350;
                                            }
        break;
      case 297: /* exprx ::= tnm DOT nm DOT nm */
{
                                                yygotominor.yy252 = new SqliteExpr();
												if (yymsp[-4].minor.yy350->isName())
													yygotominor.yy252->initId(yymsp[-4].minor.yy350->toName(), *(yymsp[-2].minor.yy259), *(yymsp[0].minor.yy259));
												else
													parserContext->errorAtToken("Syntax error <expected name>", -5);

                                                delete yymsp[-4].minor.yy350;
                                                delete yymsp[-2].minor.yy259;
                                                delete yymsp[0].minor.yy259;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 298: /* exprx ::= tnm DOT nm DOT */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy252;
                                                if (yymsp[-3].minor.yy350->isName())
                                                {
                                                    yygotominor.yy252->initId(yymsp[-3].minor.yy350->toName(), *(yymsp[-1].minor.yy259), QString());
                                                    parserContext->minorErrorAfterLastToken("Syntax error <expr>");
                                                }
                                                else
                                                    parserContext->errorAtToken("Syntax error <expected name>", -5);

                                                delete yymsp[-3].minor.yy350;
                                                delete yymsp[-1].minor.yy259;
                                            }
        break;
      case 299: /* exprx ::= VARIABLE */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initBindParam(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 300: /* exprx ::= expr COLLATE ids */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initCollate(yymsp[-2].minor.yy252, *(yymsp[0].minor.yy259));
                                                delete yymsp[0].minor.yy259;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 301: /* exprx ::= CAST LP expr AS typetoken RP */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initCast(yymsp[-3].minor.yy252, yymsp[-1].minor.yy477);
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 302: /* exprx ::= id LP distinct exprlist RP */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initFunction(stripObjName(*(yymsp[-4].minor.yy259)), *(yymsp[-2].minor.yy346), *(yymsp[-1].minor.yy351));
                                                delete yymsp[-4].minor.yy259;
                                                delete yymsp[-2].minor.yy346;
                                                delete yymsp[-1].minor.yy351;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 303: /* exprx ::= id LP STAR RP */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initFunction(stripObjName(*(yymsp[-3].minor.yy259)), true);
                                                delete yymsp[-3].minor.yy259;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 304: /* exprx ::= expr AND expr */
      case 305: /* exprx ::= expr OR expr */ yytestcase(yyruleno==305);
      case 306: /* exprx ::= expr LT|GT|GE|LE expr */ yytestcase(yyruleno==306);
      case 307: /* exprx ::= expr EQ|NE expr */ yytestcase(yyruleno==307);
      case 308: /* exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */ yytestcase(yyruleno==308);
      case 309: /* exprx ::= expr PLUS|MINUS expr */ yytestcase(yyruleno==309);
      case 310: /* exprx ::= expr STAR|SLASH|REM expr */ yytestcase(yyruleno==310);
      case 311: /* exprx ::= expr CONCAT expr */ yytestcase(yyruleno==311);
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initBinOp(yymsp[-2].minor.yy252, yymsp[-1].minor.yy0->value, yymsp[0].minor.yy252);
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 312: /* exprx ::= expr not_opt likeop expr */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initLike(yymsp[-3].minor.yy252, *(yymsp[-2].minor.yy291), *(yymsp[-1].minor.yy100), yymsp[0].minor.yy252);
                                                delete yymsp[-2].minor.yy291;
                                                delete yymsp[-1].minor.yy100;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 313: /* exprx ::= expr not_opt likeop expr ESCAPE expr */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initLike(yymsp[-5].minor.yy252, *(yymsp[-4].minor.yy291), *(yymsp[-3].minor.yy100), yymsp[-2].minor.yy252, yymsp[0].minor.yy252);
                                                delete yymsp[-4].minor.yy291;
                                                delete yymsp[-3].minor.yy100;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 314: /* exprx ::= expr ISNULL|NOTNULL */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initNull(yymsp[-1].minor.yy252, yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 315: /* exprx ::= expr NOT NULL */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initNull(yymsp[-2].minor.yy252, "NOT NULL");
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 316: /* exprx ::= expr IS not_opt expr */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initIs(yymsp[-3].minor.yy252, *(yymsp[-1].minor.yy291), yymsp[0].minor.yy252);
                                                delete yymsp[-1].minor.yy291;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 317: /* exprx ::= expr IS NOT DISTINCT FROM expr */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initDistinct(yymsp[-5].minor.yy252, true, yymsp[0].minor.yy252);
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 318: /* exprx ::= expr IS DISTINCT FROM expr */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initDistinct(yymsp[-4].minor.yy252, false, yymsp[0].minor.yy252);
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 319: /* exprx ::= NOT expr */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initUnaryOp(yymsp[0].minor.yy252, yymsp[-1].minor.yy0->value);
                                            }
        break;
      case 320: /* exprx ::= BITNOT expr */
      case 322: /* exprx ::= PLUS expr */ yytestcase(yyruleno==322);
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initUnaryOp(yymsp[0].minor.yy252, yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 321: /* exprx ::= MINUS expr */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                if (yymsp[0].minor.yy252->mode == SqliteExpr::Mode::LITERAL_VALUE &&
                                                    parserContext->isCandidateForMaxNegativeNumber() &&
                                                    yymsp[0].minor.yy252->literalValue == static_cast<qint64>(0L))
                                                {
                                                    yygotominor.yy252->initLiteral(std::numeric_limits<qint64>::min());
                                                    delete yymsp[0].minor.yy252;
                                                }
                                                else
                                                {
                                                    yygotominor.yy252->initUnaryOp(yymsp[0].minor.yy252, yymsp[-1].minor.yy0->value);
                                                }
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 323: /* exprx ::= expr PTR expr */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initPtrOp(yymsp[-2].minor.yy252, yymsp[-1].minor.yy0->value, yymsp[0].minor.yy252);
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 324: /* exprx ::= expr not_opt BETWEEN expr AND expr */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initBetween(yymsp[-5].minor.yy252, *(yymsp[-4].minor.yy291), yymsp[-2].minor.yy252, yymsp[0].minor.yy252);
                                                delete yymsp[-4].minor.yy291;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 325: /* exprx ::= expr not_opt IN LP exprlist RP */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initIn(yymsp[-5].minor.yy252, *(yymsp[-4].minor.yy291), *(yymsp[-1].minor.yy351));
                                                delete yymsp[-4].minor.yy291;
                                                delete yymsp[-1].minor.yy351;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 326: /* exprx ::= LP select RP */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initSubSelect(yymsp[-1].minor.yy453);
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 327: /* exprx ::= expr not_opt IN LP select RP */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initIn(yymsp[-5].minor.yy252, *(yymsp[-4].minor.yy291), yymsp[-1].minor.yy453);
                                                delete yymsp[-4].minor.yy291;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 328: /* exprx ::= expr not_opt IN nm dbnm */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initIn(yymsp[-4].minor.yy252, *(yymsp[-3].minor.yy291), *(yymsp[-1].minor.yy259), *(yymsp[0].minor.yy259));
                                                delete yymsp[-3].minor.yy291;
                                                delete yymsp[-1].minor.yy259;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 329: /* exprx ::= EXISTS LP select RP */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initExists(yymsp[-1].minor.yy453);
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 330: /* exprx ::= CASE case_operand case_exprlist case_else END */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initCase(yymsp[-3].minor.yy252, *(yymsp[-2].minor.yy351), yymsp[-1].minor.yy252);
                                                delete yymsp[-2].minor.yy351;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 331: /* exprx ::= RAISE LP IGNORE RP */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initRaise(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 332: /* exprx ::= RAISE LP raisetype COMMA nm RP */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initRaise(yymsp[-3].minor.yy0->value, *(yymsp[-1].minor.yy259));
                                                delete yymsp[-1].minor.yy259;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 333: /* exprx ::= id LP distinct exprlist RP filter_over */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initWindowFunction(stripObjName(*(yymsp[-5].minor.yy259)), *(yymsp[-3].minor.yy346), *(yymsp[-2].minor.yy351), yymsp[0].minor.yy247);
                                                delete yymsp[-5].minor.yy259;
                                                delete yymsp[-3].minor.yy346;
                                                delete yymsp[-2].minor.yy351;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 334: /* exprx ::= id LP STAR RP filter_over */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                yygotominor.yy252->initWindowFunction(stripObjName(*(yymsp[-4].minor.yy259)), yymsp[0].minor.yy247);
                                                delete yymsp[-4].minor.yy259;
                                                objectForTokens = yygotominor.yy252;
                                            }
        break;
      case 335: /* expr ::= */
{
                                                yygotominor.yy252 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy252;
                                                parserContext->minorErrorAfterLastToken("Syntax error <expr>");
                                            }
        break;
      case 341: /* likeop ::= LIKE_KW|MATCH */
{yygotominor.yy100 = new SqliteExpr::LikeOp(SqliteExpr::likeOp(yymsp[0].minor.yy0->value));}
        break;
      case 342: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
{
                                                yymsp[-4].minor.yy351->append(yymsp[-2].minor.yy252);
                                                yymsp[-4].minor.yy351->append(yymsp[0].minor.yy252);
                                                yygotominor.yy351 = yymsp[-4].minor.yy351;
                                            }
        break;
      case 343: /* case_exprlist ::= WHEN expr THEN expr */
{
                                                yygotominor.yy351 = new ParserExprList();
                                                yygotominor.yy351->append(yymsp[-2].minor.yy252);
                                                yygotominor.yy351->append(yymsp[0].minor.yy252);
                                            }
        break;
      case 350: /* nexprlist ::= nexprlist COMMA expr */
{
                                                yymsp[-2].minor.yy351->append(yymsp[0].minor.yy252);
                                                yygotominor.yy351 = yymsp[-2].minor.yy351;
                                                DONT_INHERIT_TOKENS("nexprlist");
                                            }
        break;
      case 351: /* nexprlist ::= exprx */
{
                                                yygotominor.yy351 = new ParserExprList();
                                                yygotominor.yy351->append(yymsp[0].minor.yy252);
                                            }
        break;
      case 352: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP sortlist RP where_opt */
{
                                                yygotominor.yy443 = new SqliteCreateIndex(
                                                        *(yymsp[-10].minor.yy291),
                                                        *(yymsp[-8].minor.yy291),
                                                        *(yymsp[-7].minor.yy259),
                                                        *(yymsp[-6].minor.yy259),
                                                        *(yymsp[-4].minor.yy259),
                                                        *(yymsp[-2].minor.yy543),
                                                        yymsp[0].minor.yy252
                                                    );
                                                delete yymsp[-8].minor.yy291;
                                                delete yymsp[-10].minor.yy291;
                                                delete yymsp[-7].minor.yy259;
                                                delete yymsp[-6].minor.yy259;
                                                delete yymsp[-4].minor.yy259;
                                                delete yymsp[-2].minor.yy543;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 353: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON ID_TAB */
{  yy_destructor(yypParser,203,&yymsp[-3].minor);
}
        break;
      case 358: /* idxlist_opt ::= */
{yygotominor.yy123 = new ParserIndexedColumnList();}
        break;
      case 359: /* idxlist_opt ::= LP idxlist RP */
{yygotominor.yy123 = yymsp[-1].minor.yy123;}
        break;
      case 360: /* idxlist ::= idxlist COMMA idxlist_single */
{
                                                yymsp[-2].minor.yy123->append(yymsp[0].minor.yy608);
                                                yygotominor.yy123 = yymsp[-2].minor.yy123;
                                                DONT_INHERIT_TOKENS("idxlist");
                                            }
        break;
      case 361: /* idxlist ::= idxlist_single */
{
                                                yygotominor.yy123 = new ParserIndexedColumnList();
                                                yygotominor.yy123->append(yymsp[0].minor.yy608);
                                            }
        break;
      case 362: /* idxlist_single ::= nm collate sortorder */
      case 363: /* idxlist_single ::= ID_COL */ yytestcase(yyruleno==363);
{
                                                SqliteIndexedColumn* obj =
                                                    new SqliteIndexedColumn(
                                                        *(yymsp[-2].minor.yy259),
                                                        *(yymsp[-1].minor.yy259),
                                                        *(yymsp[0].minor.yy389)
                                                    );
                                                yygotominor.yy608 = obj;
                                                delete yymsp[0].minor.yy389;
                                                delete yymsp[-2].minor.yy259;
                                                delete yymsp[-1].minor.yy259;
                                                objectForTokens = yygotominor.yy608;
                                            }
        break;
      case 367: /* cmd ::= DROP INDEX ifexists fullname */
{
                                                yygotominor.yy443 = new SqliteDropIndex(*(yymsp[-1].minor.yy291), yymsp[0].minor.yy60->name1, yymsp[0].minor.yy60->name2);
                                                delete yymsp[-1].minor.yy291;
                                                delete yymsp[0].minor.yy60;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 370: /* cmd ::= VACUUM vinto */
{
                                                yygotominor.yy443 = new SqliteVacuum(yymsp[0].minor.yy252);
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 371: /* cmd ::= VACUUM nm vinto */
{
                                                yygotominor.yy443 = new SqliteVacuum(*(yymsp[-1].minor.yy259), yymsp[0].minor.yy252);
                                                delete yymsp[-1].minor.yy259;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 374: /* cmd ::= PRAGMA nm dbnm */
{
                                                yygotominor.yy443 = new SqlitePragma(*(yymsp[-1].minor.yy259), *(yymsp[0].minor.yy259));
                                                delete yymsp[-1].minor.yy259;
                                                delete yymsp[0].minor.yy259;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 375: /* cmd ::= PRAGMA nm dbnm EQ nmnum */
      case 377: /* cmd ::= PRAGMA nm dbnm EQ minus_num */ yytestcase(yyruleno==377);
{
                                                yygotominor.yy443 = new SqlitePragma(*(yymsp[-3].minor.yy259), *(yymsp[-2].minor.yy259), *(yymsp[0].minor.yy249), true);
                                                delete yymsp[-3].minor.yy259;
                                                delete yymsp[-2].minor.yy259;
                                                delete yymsp[0].minor.yy249;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 376: /* cmd ::= PRAGMA nm dbnm LP nmnum RP */
      case 378: /* cmd ::= PRAGMA nm dbnm LP minus_num RP */ yytestcase(yyruleno==378);
{
                                                yygotominor.yy443 = new SqlitePragma(*(yymsp[-4].minor.yy259), *(yymsp[-3].minor.yy259), *(yymsp[-1].minor.yy249), false);
                                                delete yymsp[-4].minor.yy259;
                                                delete yymsp[-3].minor.yy259;
                                                delete yymsp[-1].minor.yy249;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 382: /* nmnum ::= nm */
{
                                                yygotominor.yy249 = new QVariant(*(yymsp[0].minor.yy259));
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 383: /* nmnum ::= ON */
      case 384: /* nmnum ::= DELETE */ yytestcase(yyruleno==384);
      case 385: /* nmnum ::= DEFAULT */ yytestcase(yyruleno==385);
{yygotominor.yy249 = new QVariant(yymsp[0].minor.yy0->value);}
        break;
      case 388: /* minus_num ::= MINUS number */
{
                                                if (yymsp[0].minor.yy249->type() == QVariant::Double)
                                                    *(yymsp[0].minor.yy249) = -(yymsp[0].minor.yy249->toDouble());
                                                else if (yymsp[0].minor.yy249->type() == QVariant::LongLong)
                                                {
                                                    if (parserContext->isCandidateForMaxNegativeNumber())
                                                        *(yymsp[0].minor.yy249) = std::numeric_limits<qint64>::min();
                                                    else
                                                        *(yymsp[0].minor.yy249) = -(yymsp[0].minor.yy249->toLongLong());
                                                }
                                                else
                                                    Q_ASSERT_X(true, "producing minus number", "QVariant is neither of Double or LongLong.");

                                                yygotominor.yy249 = yymsp[0].minor.yy249;
                                            }
        break;
      case 391: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list END */
{
                                                yygotominor.yy443 = new SqliteCreateTrigger(
                                                        *(yymsp[-13].minor.yy346),
                                                        *(yymsp[-11].minor.yy291),
                                                        *(yymsp[-10].minor.yy259),
                                                        *(yymsp[-9].minor.yy259),
                                                        *(yymsp[-5].minor.yy259),
                                                        *(yymsp[-8].minor.yy372),
                                                        yymsp[-7].minor.yy331,
                                                        *(yymsp[-4].minor.yy323),
                                                        yymsp[-3].minor.yy252,
                                                        *(yymsp[-1].minor.yy330),
                                                        3
                                                    );
                                                delete yymsp[-11].minor.yy291;
                                                delete yymsp[-13].minor.yy346;
                                                delete yymsp[-8].minor.yy372;
                                                delete yymsp[-4].minor.yy323;
                                                delete yymsp[-10].minor.yy259;
                                                delete yymsp[-5].minor.yy259;
                                                delete yymsp[-9].minor.yy259;
                                                delete yymsp[-1].minor.yy330;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 392: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause */
{
                                                QList<SqliteQuery *> CL;

                                                yygotominor.yy443 = new SqliteCreateTrigger(
                                                        *(yymsp[-10].minor.yy346),
                                                        *(yymsp[-8].minor.yy291),
                                                        *(yymsp[-7].minor.yy259),
                                                        *(yymsp[-6].minor.yy259),
                                                        *(yymsp[-2].minor.yy259),
                                                        *(yymsp[-5].minor.yy372),
                                                        yymsp[-4].minor.yy331,
                                                        *(yymsp[-1].minor.yy323),
                                                        yymsp[0].minor.yy252,
                                                        CL,
                                                        3
                                                    );
                                                delete yymsp[-8].minor.yy291;
                                                delete yymsp[-10].minor.yy346;
                                                delete yymsp[-5].minor.yy372;
                                                delete yymsp[-1].minor.yy323;
                                                delete yymsp[-7].minor.yy259;
                                                delete yymsp[-2].minor.yy259;
                                                delete yymsp[-6].minor.yy259;
                                                objectForTokens = yygotominor.yy443;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 393: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list */
{
                                                yygotominor.yy443 = new SqliteCreateTrigger(
													*(yymsp[-12].minor.yy346),
													*(yymsp[-10].minor.yy291),
													*(yymsp[-9].minor.yy259),
													*(yymsp[-8].minor.yy259),
													*(yymsp[-4].minor.yy259),
													*(yymsp[-7].minor.yy372),
													yymsp[-6].minor.yy331,
													*(yymsp[-3].minor.yy323),
													yymsp[-2].minor.yy252,
													*(yymsp[0].minor.yy330),
													3
                                                );
                                                delete yymsp[-10].minor.yy291;
                                                delete yymsp[-12].minor.yy346;
                                                delete yymsp[-7].minor.yy372;
                                                delete yymsp[-3].minor.yy323;
                                                delete yymsp[-9].minor.yy259;
                                                delete yymsp[-4].minor.yy259;
                                                delete yymsp[-8].minor.yy259;
                                                delete yymsp[0].minor.yy330;
                                                objectForTokens = yygotominor.yy443;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 394: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON ID_TAB */
{  yy_destructor(yypParser,205,&yymsp[-8].minor);
  yy_destructor(yypParser,203,&yymsp[-5].minor);
  yy_destructor(yypParser,301,&yymsp[-3].minor);
  yy_destructor(yypParser,302,&yymsp[-2].minor);
}
        break;
      case 397: /* trigger_time ::= BEFORE */
{yygotominor.yy372 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::BEFORE);}
        break;
      case 398: /* trigger_time ::= AFTER */
{yygotominor.yy372 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::AFTER);}
        break;
      case 399: /* trigger_time ::= INSTEAD OF */
{yygotominor.yy372 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::INSTEAD_OF);}
        break;
      case 400: /* trigger_time ::= */
{yygotominor.yy372 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::null);}
        break;
      case 401: /* trigger_event ::= DELETE */
{
                                                yygotominor.yy331 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::DELETE);
                                                objectForTokens = yygotominor.yy331;
                                            }
        break;
      case 402: /* trigger_event ::= INSERT */
{
                                                yygotominor.yy331 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::INSERT);
                                                objectForTokens = yygotominor.yy331;
                                            }
        break;
      case 403: /* trigger_event ::= UPDATE */
{
                                                yygotominor.yy331 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::UPDATE);
                                                objectForTokens = yygotominor.yy331;
                                            }
        break;
      case 404: /* trigger_event ::= UPDATE OF idlist */
{
                                                yygotominor.yy331 = new SqliteCreateTrigger::Event(*(yymsp[0].minor.yy215));
                                                delete yymsp[0].minor.yy215;
                                                objectForTokens = yygotominor.yy331;
                                            }
        break;
      case 405: /* foreach_clause ::= */
{yygotominor.yy323 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::null);}
        break;
      case 406: /* foreach_clause ::= FOR EACH ROW */
{yygotominor.yy323 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::FOR_EACH_ROW);}
        break;
      case 409: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
{
                                                yymsp[-2].minor.yy330->append(yymsp[-1].minor.yy443);
                                                yygotominor.yy330 = yymsp[-2].minor.yy330;
                                                DONT_INHERIT_TOKENS("trigger_cmd_list");
                                            }
        break;
      case 410: /* trigger_cmd_list ::= trigger_cmd SEMI */
{
                                                yygotominor.yy330 = new ParserQueryList();
                                                yygotominor.yy330->append(yymsp[-1].minor.yy443);
                                            }
        break;
      case 411: /* trigger_cmd_list ::= SEMI */
{
                                                yygotominor.yy330 = new ParserQueryList();
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 416: /* raisetype ::= ROLLBACK|ABORT|FAIL */
{yygotominor.yy0 = yymsp[0].minor.yy0;}
        break;
      case 417: /* cmd ::= DROP TRIGGER ifexists fullname */
{
                                                yygotominor.yy443 = new SqliteDropTrigger(*(yymsp[-1].minor.yy291), yymsp[0].minor.yy60->name1, yymsp[0].minor.yy60->name2);
                                                delete yymsp[-1].minor.yy291;
                                                delete yymsp[0].minor.yy60;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 420: /* cmd ::= ATTACH database_kw_opt expr AS expr key_opt */
{
                                                yygotominor.yy443 = new SqliteAttach(*(yymsp[-4].minor.yy291), yymsp[-3].minor.yy252, yymsp[-1].minor.yy252, yymsp[0].minor.yy252);
                                                delete yymsp[-4].minor.yy291;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 421: /* cmd ::= DETACH database_kw_opt expr */
{
                                                yygotominor.yy443 = new SqliteDetach(*(yymsp[-1].minor.yy291), yymsp[0].minor.yy252);
                                                delete yymsp[-1].minor.yy291;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 426: /* cmd ::= REINDEX */
{yygotominor.yy443 = new SqliteReindex();}
        break;
      case 427: /* cmd ::= REINDEX nm dbnm */
      case 428: /* cmd ::= REINDEX ID_COLLATE */ yytestcase(yyruleno==428);
{
                                                yygotominor.yy443 = new SqliteReindex(*(yymsp[-1].minor.yy259), *(yymsp[0].minor.yy259));
                                                delete yymsp[-1].minor.yy259;
                                                delete yymsp[0].minor.yy259;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 431: /* cmd ::= ANALYZE */
{
                                                yygotominor.yy443 = new SqliteAnalyze();
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 432: /* cmd ::= ANALYZE nm dbnm */
{
                                                yygotominor.yy443 = new SqliteAnalyze(*(yymsp[-1].minor.yy259), *(yymsp[0].minor.yy259));
                                                delete yymsp[-1].minor.yy259;
                                                delete yymsp[0].minor.yy259;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 435: /* cmd ::= ALTER TABLE fullname RENAME TO nm */
{
                                                yygotominor.yy443 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy60->name1,
                                                        yymsp[-3].minor.yy60->name2,
                                                        *(yymsp[0].minor.yy259)
                                                    );
                                                delete yymsp[0].minor.yy259;
                                                delete yymsp[-3].minor.yy60;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 436: /* cmd ::= ALTER TABLE fullname ADD kwcolumn_opt column */
{
                                                yygotominor.yy443 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy60->name1,
                                                        yymsp[-3].minor.yy60->name2,
                                                        *(yymsp[-1].minor.yy291),
                                                        yymsp[0].minor.yy567
                                                    );
                                                delete yymsp[-1].minor.yy291;
                                                delete yymsp[-3].minor.yy60;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 437: /* cmd ::= ALTER TABLE fullname DROP kwcolumn_opt nm */
{
                                                yygotominor.yy443 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy60->name1,
                                                        yymsp[-3].minor.yy60->name2,
                                                        *(yymsp[-1].minor.yy291),
                                                        *(yymsp[0].minor.yy259)
                                                    );
                                                delete yymsp[-1].minor.yy291;
                                                delete yymsp[-3].minor.yy60;
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 438: /* cmd ::= ALTER TABLE fullname RENAME TO ID_TAB_NEW */
{  yy_destructor(yypParser,207,&yymsp[-3].minor);
}
        break;
      case 444: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm */
{
                                                yygotominor.yy443 = new SqliteCreateVirtualTable(
                                                        *(yymsp[-4].minor.yy291),
                                                        *(yymsp[-3].minor.yy259),
                                                        *(yymsp[-2].minor.yy259),
                                                        *(yymsp[0].minor.yy259)
                                                    );
                                                delete yymsp[-4].minor.yy291;
                                                delete yymsp[-3].minor.yy259;
                                                delete yymsp[-2].minor.yy259;
                                                delete yymsp[0].minor.yy259;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 445: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm LP vtabarglist RP */
{
                                                yygotominor.yy443 = new SqliteCreateVirtualTable(
                                                        *(yymsp[-7].minor.yy291),
                                                        *(yymsp[-6].minor.yy259),
                                                        *(yymsp[-5].minor.yy259),
                                                        *(yymsp[-3].minor.yy259),
                                                        *(yymsp[-1].minor.yy215)
                                                    );
                                                delete yymsp[-6].minor.yy259;
                                                delete yymsp[-5].minor.yy259;
                                                delete yymsp[-3].minor.yy259;
                                                delete yymsp[-7].minor.yy291;
                                                delete yymsp[-1].minor.yy215;
                                                objectForTokens = yygotominor.yy443;
                                            }
        break;
      case 448: /* vtabarglist ::= vtabarg */
{
                                                yygotominor.yy215 = new QStringList();
                                                yygotominor.yy215->append((yymsp[0].minor.yy259)->mid(1)); // mid(1) to skip the first whitespace added in vtabarg
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 449: /* vtabarglist ::= vtabarglist COMMA vtabarg */
{
                                                yymsp[-2].minor.yy215->append((yymsp[0].minor.yy259)->mid(1)); // mid(1) to skip the first whitespace added in vtabarg
                                                yygotominor.yy215 = yymsp[-2].minor.yy215;
                                                delete yymsp[0].minor.yy259;
                                                DONT_INHERIT_TOKENS("vtabarglist");
                                            }
        break;
      case 451: /* vtabarg ::= vtabarg vtabargtoken */
{
                                                yymsp[-1].minor.yy259->append(" "+ *(yymsp[0].minor.yy259));
                                                yygotominor.yy259 = yymsp[-1].minor.yy259;
                                                delete yymsp[0].minor.yy259;
                                            }
        break;
      case 452: /* vtabargtoken ::= ANY */
{
                                                yygotominor.yy259 = new QString(yymsp[0].minor.yy0->value);
                                            }
        break;
      case 453: /* vtabargtoken ::= LP anylist RP */
{
                                                yygotominor.yy259 = new QString("(");
                                                yygotominor.yy259->append(*(yymsp[-1].minor.yy259));
                                                yygotominor.yy259->append(")");
                                                delete yymsp[-1].minor.yy259;
                                            }
        break;
      case 455: /* anylist ::= anylist LP anylist RP */
{
                                                yygotominor.yy259 = yymsp[-3].minor.yy259;
                                                yygotominor.yy259->append("(");
                                                yygotominor.yy259->append(*(yymsp[-1].minor.yy259));
                                                yygotominor.yy259->append(")");
                                                delete yymsp[-1].minor.yy259;
                                                DONT_INHERIT_TOKENS("anylist");
                                            }
        break;
      case 456: /* anylist ::= anylist ANY */
{
                                                yygotominor.yy259 = yymsp[-1].minor.yy259;
                                                yygotominor.yy259->append(yymsp[0].minor.yy0->value);
                                                DONT_INHERIT_TOKENS("anylist");
                                            }
        break;
      case 457: /* with ::= */
{yygotominor.yy641 = nullptr;}
        break;
      case 458: /* with ::= WITH wqlist */
{
                                                yygotominor.yy641 = new SqliteWith();
												yygotominor.yy641->cteList = *(yymsp[0].minor.yy332);
												delete yymsp[0].minor.yy332;
                                                objectForTokens = yygotominor.yy641;
                                            }
        break;
      case 459: /* with ::= WITH RECURSIVE wqlist */
{
                                                yygotominor.yy641 = new SqliteWith();
												yygotominor.yy641->cteList = *(yymsp[0].minor.yy332);
                                                yygotominor.yy641->recursive = true;
												delete yymsp[0].minor.yy332;
                                                objectForTokens = yygotominor.yy641;
                                            }
        break;
      case 460: /* wqas ::= AS */
{yygotominor.yy640 = new SqliteWith::CommonTableExpression::AsMode(SqliteWith::CommonTableExpression::ANY);}
        break;
      case 461: /* wqas ::= AS MATERIALIZED */
{yygotominor.yy640 = new SqliteWith::CommonTableExpression::AsMode(SqliteWith::CommonTableExpression::MATERIALIZED);}
        break;
      case 462: /* wqas ::= AS NOT MATERIALIZED */
{yygotominor.yy640 = new SqliteWith::CommonTableExpression::AsMode(SqliteWith::CommonTableExpression::NOT_MATERIALIZED);}
        break;
      case 463: /* wqlist ::= wqcte */
{
												yygotominor.yy332 = new ParserCteList();
                                                yygotominor.yy332->append(yymsp[0].minor.yy446);
                                            }
        break;
      case 464: /* wqlist ::= wqlist COMMA wqcte */
{
                                                yygotominor.yy332 = yymsp[-2].minor.yy332;
                                                yygotominor.yy332->append(yymsp[0].minor.yy446);
                                                DONT_INHERIT_TOKENS("wqlist");
                                            }
        break;
      case 465: /* wqlist ::= ID_TAB_NEW */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                            }
        break;
      case 466: /* wqcte ::= nm idxlist_opt wqas LP select RP */
{
                                                yygotominor.yy446 = new SqliteWith::CommonTableExpression(*(yymsp[-5].minor.yy259), *(yymsp[-4].minor.yy123), yymsp[-1].minor.yy453, *(yymsp[-3].minor.yy640));
                                                delete yymsp[-5].minor.yy259;
                                                delete yymsp[-4].minor.yy123;
                                                delete yymsp[-3].minor.yy640;
												objectForTokens = yygotominor.yy446;
											}
        break;
      case 467: /* windowdefn_list ::= windowdefn */
{
												yygotominor.yy639 = new ParserWindowDefList();
												yygotominor.yy639->append(yymsp[0].minor.yy646);
											}
        break;
      case 468: /* windowdefn_list ::= windowdefn_list COMMA windowdefn */
{
												yymsp[-2].minor.yy639->append(yymsp[0].minor.yy646);
												yygotominor.yy639 = yymsp[-2].minor.yy639;
												DONT_INHERIT_TOKENS("windowdefn_list");
											}
        break;
      case 469: /* windowdefn ::= nm AS LP window RP */
{
												yygotominor.yy646 = new SqliteWindowDefinition(*(yymsp[-4].minor.yy259), yymsp[-1].minor.yy234);
												delete yymsp[-4].minor.yy259;
												objectForTokens = yygotominor.yy646;
											}
        break;
      case 470: /* window ::= PARTITION BY nexprlist orderby_opt frame_opt */
{
												yygotominor.yy234 = new SqliteWindowDefinition::Window();
												yygotominor.yy234->initPartitionBy(QString(), *(yymsp[-2].minor.yy351), *(yymsp[-1].minor.yy543), yymsp[0].minor.yy41);
												delete yymsp[-2].minor.yy351;
												delete yymsp[-1].minor.yy543;
												objectForTokens = yygotominor.yy234;
											}
        break;
      case 471: /* window ::= nm PARTITION BY nexprlist orderby_opt frame_opt */
{
												yygotominor.yy234 = new SqliteWindowDefinition::Window();
												yygotominor.yy234->initPartitionBy(*(yymsp[-5].minor.yy259), *(yymsp[-2].minor.yy351), *(yymsp[-1].minor.yy543), yymsp[0].minor.yy41);
												delete yymsp[-2].minor.yy351;
												delete yymsp[-5].minor.yy259;
												delete yymsp[-1].minor.yy543;
												objectForTokens = yygotominor.yy234;
											}
        break;
      case 472: /* window ::= ORDER BY sortlist frame_opt */
{
												yygotominor.yy234 = new SqliteWindowDefinition::Window();
												yygotominor.yy234->initOrderBy(QString(), *(yymsp[-1].minor.yy543), yymsp[0].minor.yy41);
												delete yymsp[-1].minor.yy543;
												objectForTokens = yygotominor.yy234;
											}
        break;
      case 473: /* window ::= nm ORDER BY sortlist frame_opt */
{
												yygotominor.yy234 = new SqliteWindowDefinition::Window();
												yygotominor.yy234->initOrderBy(*(yymsp[-4].minor.yy259), *(yymsp[-1].minor.yy543), yymsp[0].minor.yy41);
												delete yymsp[-1].minor.yy543;
												delete yymsp[-4].minor.yy259;
												objectForTokens = yygotominor.yy234;
											}
        break;
      case 474: /* window ::= frame_opt */
{
												yygotominor.yy234 = new SqliteWindowDefinition::Window();
												yygotominor.yy234->init(QString(), yymsp[0].minor.yy41);
												objectForTokens = yygotominor.yy234;
											}
        break;
      case 475: /* window ::= nm frame_opt */
{
												yygotominor.yy234 = new SqliteWindowDefinition::Window();
												yygotominor.yy234->init(QString(), yymsp[0].minor.yy41);
												delete yymsp[-1].minor.yy259;
												objectForTokens = yygotominor.yy234;
											}
        break;
      case 476: /* frame_opt ::= */
{yygotominor.yy41 = nullptr;}
        break;
      case 477: /* frame_opt ::= range_or_rows frame_bound_s frame_exclude_opt */
{
												yygotominor.yy41 = new SqliteWindowDefinition::Window::Frame(*(yymsp[-2].minor.yy358), yymsp[-1].minor.yy81, nullptr, *(yymsp[0].minor.yy603));
												delete yymsp[-2].minor.yy358;
												delete yymsp[0].minor.yy603;
												objectForTokens = yygotominor.yy41;
											}
        break;
      case 478: /* frame_opt ::= range_or_rows BETWEEN frame_bound_s AND frame_bound_e frame_exclude_opt */
{
												yygotominor.yy41 = new SqliteWindowDefinition::Window::Frame(*(yymsp[-5].minor.yy358), yymsp[-3].minor.yy81, yymsp[-1].minor.yy81, *(yymsp[0].minor.yy603));
												delete yymsp[-5].minor.yy358;
												delete yymsp[0].minor.yy603;
												objectForTokens = yygotominor.yy41;
											}
        break;
      case 479: /* range_or_rows ::= RANGE|ROWS|GROUPS */
{
												yygotominor.yy358 = new SqliteWindowDefinition::Window::Frame::RangeOrRows(
													SqliteWindowDefinition::Window::Frame::toRangeOrRows(yymsp[0].minor.yy0->value)
													);
											}
        break;
      case 480: /* frame_bound_s ::= frame_bound */
      case 482: /* frame_bound_e ::= frame_bound */ yytestcase(yyruleno==482);
{
												yygotominor.yy81 = yymsp[0].minor.yy81;
												objectForTokens = yygotominor.yy81;
											}
        break;
      case 481: /* frame_bound_s ::= UNBOUNDED PRECEDING */
      case 483: /* frame_bound_e ::= UNBOUNDED FOLLOWING */ yytestcase(yyruleno==483);
      case 485: /* frame_bound ::= CURRENT ROW */ yytestcase(yyruleno==485);
{
												yygotominor.yy81 = new SqliteWindowDefinition::Window::Frame::Bound(nullptr, yymsp[-1].minor.yy0->value + " " + yymsp[0].minor.yy0->value);
												objectForTokens = yygotominor.yy81;
											}
        break;
      case 484: /* frame_bound ::= expr PRECEDING|FOLLOWING */
{
												yygotominor.yy81 = new SqliteWindowDefinition::Window::Frame::Bound(yymsp[-1].minor.yy252, yymsp[0].minor.yy0->value);
												objectForTokens = yygotominor.yy81;
											}
        break;
      case 486: /* frame_exclude_opt ::= */
{
												yygotominor.yy603 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::null
													);
											}
        break;
      case 487: /* frame_exclude_opt ::= EXCLUDE frame_exclude */
{
												yygotominor.yy603 = yymsp[0].minor.yy603;
											}
        break;
      case 488: /* frame_exclude ::= NO OTHERS */
{
												yygotominor.yy603 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::NO_OTHERS
													);
											}
        break;
      case 489: /* frame_exclude ::= CURRENT ROW */
{
												yygotominor.yy603 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::CURRENT_ROW
													);
											}
        break;
      case 490: /* frame_exclude ::= GROUP */
{
												yygotominor.yy603 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::GROUP
													);
											}
        break;
      case 491: /* frame_exclude ::= TIES */
{
												yygotominor.yy603 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::TIES
													);
											}
        break;
      case 492: /* window_clause ::= WINDOW windowdefn_list */
{
												yygotominor.yy639 = yymsp[0].minor.yy639;
											}
        break;
      case 493: /* filter_over ::= filter_clause over_clause */
{
												yygotominor.yy247 = new SqliteFilterOver(yymsp[-1].minor.yy657, yymsp[0].minor.yy288);
												objectForTokens = yygotominor.yy247;
											}
        break;
      case 494: /* filter_over ::= over_clause */
{
												yygotominor.yy247 = new SqliteFilterOver(nullptr, yymsp[0].minor.yy288);
												objectForTokens = yygotominor.yy247;
											}
        break;
      case 495: /* filter_over ::= filter_clause */
{
												yygotominor.yy247 = new SqliteFilterOver(yymsp[0].minor.yy657, nullptr);
												objectForTokens = yygotominor.yy247;
											}
        break;
      case 496: /* over_clause ::= OVER LP window RP */
{
												yygotominor.yy288 = new SqliteFilterOver::Over(yymsp[-1].minor.yy234);
												objectForTokens = yygotominor.yy288;
											}
        break;
      case 497: /* over_clause ::= OVER nm */
{
												yygotominor.yy288 = new SqliteFilterOver::Over(*(yymsp[0].minor.yy259));
												delete yymsp[0].minor.yy259;
												objectForTokens = yygotominor.yy288;
											}
        break;
      case 498: /* filter_clause ::= FILTER LP WHERE expr RP */
{
												yygotominor.yy657 = new SqliteFilterOver::Filter(yymsp[-1].minor.yy252);
												objectForTokens = yygotominor.yy657;
                                            }
        break;
      default:
      /* (0) input ::= cmdlist */ yytestcase(yyruleno==0);
        break;
      };
  }
  assert( yyruleno>=0 && yyruleno<(int)(sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0])) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;

  // Store tokens for the rule in parser context
  QList<Token*> allTokens;
  QList<Token*> allTokensWithAllInherited;
  QString keyForTokensMap;
  int tokensMapKeyCnt;
  if (parserContext->setupTokens)
  {
      if (objectForTokens)
      {
          // In case this is a list with recurrent references we need
          // to clear tokens before adding the new and extended list.
          objectForTokens->tokens.clear();
      }

      QList<Token*> tokens;
      for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
      {
          tokens.clear();
          const char* fieldName = yyTokenName[yypParser->yystack[i].major];

          // Adding token being subject of this reduction. It's usually not includes in the inherited tokens,
          // although if inheriting from simple statements, like "FAIL" or "ROLLBACK", this tends to be redundant with the inherited tokens.
          // That's why we're checking if it's not contained in the inherited tokens and add it only then.
          if (parserContext->isManagedToken(yypParser->yystack[i].minor.yy0) && !yypParser->yystack[i].tokens->contains(yypParser->yystack[i].minor.yy0))
              tokens += yypParser->yystack[i].minor.yy0;

          tokens += *(yypParser->yystack[i].tokens);

          if (!noTokenInheritanceFields.contains(fieldName))
          {
              if (objectForTokens)
              {
                  keyForTokensMap = fieldName;
                  tokensMapKeyCnt = 2;
                  while (objectForTokens->tokensMap.contains(keyForTokensMap))
                      keyForTokensMap = fieldName + QString::number(tokensMapKeyCnt++);

                  objectForTokens->tokensMap[keyForTokensMap] = parserContext->getTokenPtrList(tokens);
              }

              allTokens += tokens;
          }
          else
          {
              // If field is mentioned only once, then only one occurance of it will be ignored.
              // Second one should be inherited. See "anylist" definition for explanation why.
              noTokenInheritanceFields.removeOne(fieldName);
          }
          allTokensWithAllInherited += tokens;
      }
      if (objectForTokens)
      {
          objectForTokens->tokens += parserContext->getTokenPtrList(allTokens);
      }
  }

  // Clear token lists
  for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
  {
      delete yypParser->yystack[i].tokens;
      yypParser->yystack[i].tokens = nullptr;
  }

  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
      if (parserContext->setupTokens)
          *(yypParser->yystack[yypParser->yyidx].tokens) = allTokens;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
      if (parserContext->setupTokens && yypParser->yyidx >= 0)
      {
          QList<Token*>* tokensPtr = yypParser->yystack[yypParser->yyidx].tokens;
          *tokensPtr = allTokensWithAllInherited + *tokensPtr;
      }
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3_parseARG_FETCH;
#define TOKEN (yyminor.yy0)

    UNUSED_PARAMETER(yymajor);
    parserContext->error(TOKEN, QObject::tr("Syntax error"));
    //qDebug() << "near " << TOKEN->toString() << ": syntax error";
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3_parseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3_parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3_parseTOKENTYPE yyminor       /* The value for the token */
  sqlite3_parseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
    yypParser->yystack[0].tokens = new QList<Token*>();
  }
  yyminorunion.yy0 = yyminor;
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif
  sqlite3_parseARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s [%s] (lemon type: %s)\n",
            yyTracePrompt,
            yyminor->value.toLatin1().data(),
            yyminor->typeString().toLatin1().data(),
            yyTokenName[yymajor]);  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;

#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}

int sqlite3ParserFallback(int iToken) {
    return yyFallback[iToken];
}
