! Module to contain all the Gauss-Fermi quadrature points
! It has been created by an automatic script created by:
! Nick Papior Andersen, 2013, nickpapior@gmail.com
! If you ever need to use this please contact the author for approval

! We have employed the Stieltjes and moment algorithm together with the Golub-Welsch
! for an efficient and fairly accurate stability of the orthogonal polynomials.

module m_gauss_fermi_30

  implicit none

  integer, parameter :: p = selected_real_kind(14,300)

  integer, parameter :: G_NF_MIN_N  =  2
  integer, parameter :: G_NF_MAX_N  = 17
  integer, parameter :: G_NF_MIN_kT = -20
  integer, parameter :: G_NF_MAX_kT = 5
  
  private
  public :: G_NF_MIN_N
  public :: G_NF_MAX_N
  public :: G_NF_MIN_kT
  public :: G_NF_MAX_kT
  public :: GaussFermi_30
  
contains

  ! Die routine for the Gauss-Fermi routines
  subroutine GD(NkT)
    integer, intent(in) :: NkT
    write(*,*) 'Error in Gauss-Fermi ',NkT
    call die('Error in number of points for Gauss-Fermi, see output.')
  end subroutine GD
  
  subroutine GaussFermi_30(NkT,N,x,w)
    integer, intent(in) :: NkT, N
    real(p), intent(out) :: x(N), w(N)
    
    if ( NkT == -20 ) then
       call GF_m20(N,x,w)
    else if ( NkT == -19 ) then
       call GF_m19(N,x,w)
    else if ( NkT == -18 ) then
       call GF_m18(N,x,w)
    else if ( NkT == -17 ) then
       call GF_m17(N,x,w)
    else if ( NkT == -16 ) then
       call GF_m16(N,x,w)
    else if ( NkT == -15 ) then
       call GF_m15(N,x,w)
    else if ( NkT == -14 ) then
       call GF_m14(N,x,w)
    else if ( NkT == -13 ) then
       call GF_m13(N,x,w)
    else if ( NkT == -12 ) then
       call GF_m12(N,x,w)
    else if ( NkT == -11 ) then
       call GF_m11(N,x,w)
    else if ( NkT == -10 ) then
       call GF_m10(N,x,w)
    else if ( NkT == -9 ) then
       call GF_m9(N,x,w)
    else if ( NkT == -8 ) then
       call GF_m8(N,x,w)
    else if ( NkT == -7 ) then
       call GF_m7(N,x,w)
    else if ( NkT == -6 ) then
       call GF_m6(N,x,w)
    else if ( NkT == -5 ) then
       call GF_m5(N,x,w)
    else if ( NkT == -4 ) then
       call GF_m4(N,x,w)
    else if ( NkT == -3 ) then
       call GF_m3(N,x,w)
    else if ( NkT == -2 ) then
       call GF_m2(N,x,w)
    else if ( NkT == -1 ) then
       call GF_m1(N,x,w)
    else if ( NkT == 0 ) then
       call GF_0(N,x,w)
    else if ( NkT == 1 ) then
       call GF_1(N,x,w)
    else if ( NkT == 2 ) then
       call GF_2(N,x,w)
    else if ( NkT == 3 ) then
       call GF_3(N,x,w)
    else if ( NkT == 4 ) then
       call GF_4(N,x,w)
    else if ( NkT == 5 ) then
       call GF_5(N,x,w)
    else
       call die('Could not figure out the Gauss-Fermi &
             &quadratue method you asked for.')
    end if
  end subroutine GaussFermi_30
  
  
! [-20kT;30kT]
subroutine GF_m20(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-15.59867300181854_p
w(1)=10.40132057930624_p
x(2)=-3.761795334799515_p
w(2)=9.598679422754826_p
else if(N==3)then
x(1)=-17.56069617721696_p
w(1)=6.008953676372496_p
x(2)=-9.213295995771334_p
w(2)=9.514824294517849_p
x(3)=-1.155162436879636_p
w(3)=4.476222031170715_p
else if(N==4)then
x(1)=-18.43109871372602_p
w(1)=3.928604571889245_p
x(2)=-12.55785502444921_p
w(2)=7.327554034647249_p
x(3)=-5.008576974641759_p
w(3)=7.006527640125872_p
x(4)=6.703031925418521e-1_p
w(4)=1.737313755398695_p
else if(N==5)then
x(1)=-18.89086254866168_p
w(1)=2.800001759809292_p
x(2)=-14.55265574981832_p
w(2)=5.634869062466592_p
x(3)=-8.251795194332644_p
w(3)=6.590038188756709_p
x(4)=-2.226669430392805_p
w(4)=4.558760155949858_p
x(5)=2.575330269500963_p
w(5)=4.163308350786086e-1_p
else if(N==6)then
x(1)=-19.16408407880126_p
w(1)=2.120045492325494_p
x(2)=-15.8125133039622_p
w(2)=4.449477155597918_p
x(3)=-10.62333416763314_p
w(3)=5.711099527407078_p
x(4)=-4.894454844947582_p
w(4)=5.411409797107351_p
x(5)=-2.096272220080356e-1_p
w(5)=2.254379556163499_p
x(6)=4.860742591417039_p
w(6)=5.358847345971997e-2_p
else if(N==7)then
x(1)=-19.34059287551301_p
w(1)=1.677220167456186_p
x(2)=-16.6557002965298_p
w(2)=3.612022520738478_p
x(3)=-12.33653756169281_p
w(3)=4.890438728375886_p
x(4)=-7.191344297389882_p
w(4)=5.214315538339304_p
x(5)=-2.328676988371816_p
w(5)=3.909072927166459_p
x(6)=1.650797652112673_p
w(6)=6.925381221731324e-1_p
x(7)=7.485945701558416_p
w(7)=4.391997811615229e-3_p
else if(N==8)then
x(1)=-19.46190649076413_p
w(1)=1.371292200108416_p
x(2)=-17.24841312368537_p
w(2)=3.003865144221510_p
x(3)=-13.59776746376976_p
w(3)=4.207723778237244_p
x(4)=-9.043939226533134_p
w(4)=4.778506109953163_p
x(5)=-4.321527522557919_p
w(5)=4.437182423761140_p
x(6)=-3.266585269436748e-1_p
w(6)=2.086631576692828_p
x(7)=3.764732796792604_p
w(7)=1.145242704775555e-1_p
x(8)=10.34102197593235_p
w(8)=2.744986092035447e-4_p
else if(N==9)then
x(1)=-19.5493820660264_p
w(1)=1.149917463050981_p
x(2)=-17.68239299312026_p
w(2)=2.548966524346409_p
x(3)=-14.54981393499225_p
w(3)=3.654221565722028_p
x(4)=-10.52092372698463_p
w(4)=4.318894676442568_p
x(5)=-6.105512716355030_p
w(5)=4.388895516951928_p
x(6)=-1.994608665976463_p
w(6)=3.256163914182794_p
x(7)=1.523318185968129_p
w(7)=6.712090470673485e-1_p
x(8)=6.188999502290863_p
w(8)=1.171688134695366e-2_p
x(9)=13.35097453393205_p
w(9)=1.441295004841282e-5_p
else if(N==10)then
x(1)=-19.61501504094611_p
w(1)=9.833989445826129e-1_p
x(2)=-18.01159535874405_p
w(2)=2.198709496631274_p
x(3)=-15.28762009618745_p
w(3)=3.204841089076258_p
x(4)=-11.70791515485815_p
w(4)=3.893262886931361_p
x(5)=-7.640655030682579_p
w(5)=4.159472923122234_p
x(6)=-3.577436660336574_p
w(6)=3.742855600747960_p
x(7)=-8.678180559854015e-2_p
w(7)=1.698209614544150_p
x(8)=3.576057452321776_p
w(8)=1.183300478544189e-1_p
x(9)=8.820380514345333_p
w(9)=9.187127048559699e-4_p
x(10)=16.44459116040601_p
w(10)=6.858659349411322e-7_p
else if(N==11)then
x(1)=-19.66606702876067_p
w(1)=8.536277795692950e-1_p
x(2)=-18.26977264869311_p
w(2)=1.920986162922661_p
x(3)=-15.87546376538081_p
w(3)=2.834894806151640_p
x(4)=-12.67853858833225_p
w(4)=3.513345749951904_p
x(5)=-8.952607943745722_p
w(5)=3.879224891843295_p
x(6)=-5.056371990316393_p
w(6)=3.805350623248751_p
x(7)=-1.483508918646622_p
w(7)=2.654560906459934_p
x(8)=1.726329605096814_p
w(8)=5.242061327229373e-1_p
x(9)=5.866261714355276_p
w(9)=1.373897875398385e-2_p
x(10)=11.543463874129_p
w(10)=6.393696645284492e-5_p
x(11)=19.49018534873933_p
w(11)=3.347020468836206e-8_p
else if(N==12)then
x(1)=-19.70709627161812_p
w(1)=7.491792176816797e-1_p
x(2)=-18.47859379289545_p
w(2)=1.694451039849580_p
x(3)=-16.35675663398698_p
w(3)=2.524546847923590_p
x(4)=-13.48894346954649_p
w(4)=3.176455792781303_p
x(5)=-10.08276563921637_p
w(5)=3.591232813829649_p
x(6)=-6.407908478939207_p
w(6)=3.692769289934518_p
x(7)=-2.832728855554223_p
w(7)=3.178621896847659_p
x(8)=2.869198704774886e-1_p
w(8)=1.295388962175207_p
x(9)=3.691468457798833_p
w(9)=9.600549838886380e-2_p
x(10)=8.262994516159779_p
w(10)=1.344120063990015e-3_p
x(11)=14.22577430624823_p
w(11)=4.520517837854487e-6_p
x(12)=22.25246118379632_p
w(12)=2.067182380254456e-9_p
else if(N==13)then
x(1)=-19.74090404406494_p
w(1)=6.630127557792165e-1_p
x(2)=-18.65153844988135_p
w(2)=1.505583063919902_p
x(3)=-16.75921685841664_p
w(3)=2.260131246632981_p
x(4)=-14.17700868294946_p
w(4)=2.877580873181208_p
x(5)=-11.06500706011276_p
w(5)=3.312035526218752_p
x(6)=-7.630378370903435_p
w(6)=3.511225448819251_p
x(7)=-4.145976279756095_p
w(7)=3.336700998644791_p
x(8)=-9.810410906841397e-1_p
w(8)=2.133067772730690_p
x(9)=2.005628992114605_p
w(9)=3.873509246080541e-1_p
x(10)=5.787082369341536_p
w(10)=1.318134520054402e-2_p
x(11)=10.64111778993694_p
w(11)=1.296769437553973e-4_p
x(12)=16.73477279320045_p
w(12)=3.691814531528095e-7_p
x(13)=24.4882337293925_p
w(13)=2.004612121607853e-10_p
else if(N==14)then
x(1)=-19.76920632481984_p
w(1)=5.908096906317518e-1_p
x(2)=-18.79691298779747_p
w(2)=1.345978699589648_p
x(3)=-17.10013195982662_p
w(3)=2.032845655145532_p
x(4)=-14.76691001317534_p
w(4)=2.612718688556477_p
x(5)=-11.92241048119088_p
w(5)=3.049391479044052_p
x(6)=-8.728385679643866_p
w(6)=3.304186847756365_p
x(7)=-5.392046573230308_p
w(7)=3.305214455227926_p
x(8)=-2.204928790442026_p
w(8)=2.698054697225096_p
x(9)=6.388924109575780e-1_p
w(9)=9.820226246918213e-1_p
x(10)=3.828593597878790_p
w(10)=7.709825393573635e-2_p
x(11)=7.908598309221895_p
w(11)=1.665320266659486e-3_p
x(12)=12.91430398119369_p
w(12)=1.355183345964679e-5_p
x(13)=18.9773276780593_p
w(13)=3.812344347286123e-8_p
x(14)=26.11592400886769_p
w(14)=3.309174803757364e-11_p
else if(N==15)then
x(1)=-19.79314652643795_p
w(1)=5.296877802209708e-1_p
x(2)=-18.92029051898318_p
w(2)=1.209943507855799_p
x(3)=-17.39126629436051_p
w(3)=1.836476195957353_p
x(4)=-15.27554929869979_p
w(4)=2.378427502628856_p
x(5)=-12.67222793302819_p
w(5)=2.806911324364410_p
x(6)=-9.709333178968970_p
w(6)=3.092112369054663_p
x(7)=-6.548103794254489_p
w(7)=3.190375654852316_p
x(8)=-3.406774005706915_p
w(8)=2.936800673094699_p
x(9)=-5.572898152833548e-1_p
w(9)=1.712714169473946_p
x(10)=2.247807138698980_p
w(10)=2.937144462824232e-1_p
x(11)=5.723517305489088_p
w(11)=1.261998734132266e-2_p
x(12)=9.981395778319786_p
w(12)=2.147615376164542e-4_p
x(13)=15.02833720014208_p
w(13)=1.624181314177850e-6_p
x(14)=20.90928697958195_p
w(14)=5.206646933842206e-9_p
x(15)=27.22642132570615_p
w(15)=8.723201235559536e-12_p
else if(N==16)then
x(1)=-19.81356628775791_p
w(1)=4.775209075780164e-1_p
x(2)=-19.02581223578942_p
w(2)=1.093188740960590_p
x(3)=-17.64153461675703_p
w(3)=1.666078394294640_p
x(4)=-15.71622188976884_p
w(4)=2.171307977721426_p
x(5)=-13.32923334746429_p
w(5)=2.585590590955417_p
x(6)=-10.58314137610695_p
w(6)=2.885357181123957_p
x(7)=-7.605824693614899_p
w(7)=3.040740710905510_p
x(8)=-4.563148152641521_p
w(8)=2.972288545487910_p
x(9)=-1.690388416543770_p
w(9)=2.286918360598588_p
x(10)=9.415582104259334e-1_p
w(10)=7.549498845468837e-1_p
x(11)=3.934840959748225_p
w(11)=6.405720223995602e-2_p
x(12)=7.618717399866965_p
w(12)=1.971393639652822e-3_p
x(13)=11.95845858044702_p
w(13)=2.987994333080517e-5_p
x(14)=16.95059024841674_p
w(14)=2.311125441905805e-7_p
x(15)=22.52495153863143_p
w(15)=9.493746356501779e-10_p
x(16)=27.96837938809295_p
w(16)=3.263015381400380e-12_p
else if(N==17)then
x(1)=-19.83111571205461_p
w(1)=4.326633712613467e-1_p
x(2)=-19.11670637876554_p
w(2)=9.923278487171757e-1_p
x(3)=-17.85801828892336_p
w(3)=1.517546674328865_p
x(4)=-16.09986195248382_p
w(4)=1.988049030868555_p
x(5)=-13.90647877748166_p
w(5)=2.384878864034726_p
x(6)=-11.36094640526197_p
w(6)=2.689076041826466_p
x(7)=-8.566213546431509_p
w(7)=2.878596432370438_p
x(8)=-5.651778323544118_p
w(8)=2.910203316946312_p
x(9)=-2.798350293303336_p
w(9)=2.586920025790963_p
x(10)=-1.961373757562078e-1_p
w(10)=1.377936934783700_p
x(11)=2.452957643006334_p
w(11)=2.293183064813759e-1_p
x(12)=5.663553616806945_p
w(12)=1.216200621733761e-2_p
x(13)=9.463397982220956_p
w(13)=3.164672761527722e-4_p
x(14)=13.80900831673279_p
w(14)=4.641154841741079e-6_p
x(15)=18.66467083535282_p
w(15)=3.977371033406787e-8_p
x(16)=23.84569221028669_p
w(16)=2.275370672576064e-10_p
x(17)=28.46834157006635_p
w(17)=1.557273934661452e-12_p
else
call GD(-20)
end if
end subroutine GF_m20

! [-19kT;30kT]
subroutine GF_m19(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.80201381311953_p
w(1)=9.919648068183351_p
x(2)=-3.526768404945492_p
w(2)=9.080351937419351_p
else if(N==3)then
x(1)=-16.66602162633158_p
w(1)=5.749160062836451_p
x(2)=-8.682923501160532_p
w(2)=9.091369949810147_p
x(3)=-9.856472860071410e-1_p
w(3)=4.159469992956105_p
else if(N==4)then
x(1)=-17.49427658232878_p
w(1)=3.770229294049722_p
x(2)=-11.85930459775595_p
w(2)=7.027560298211482_p
x(3)=-4.631462373256657_p
w(3)=6.664636512518911_p
x(4)=8.528756879537549e-1_p
w(4)=1.537573900822587_p
else if(N==5)then
x(1)=-17.93258390774662_p
w(1)=2.694564525067033_p
x(2)=-13.75863743555612_p
w(2)=5.420032240884422_p
x(3)=-7.703171571286409_p
w(3)=6.322857905806807_p
x(4)=-1.942134142545049_p
w(4)=4.225538799476728_p
x(5)=2.819883985142761_p
w(5)=3.370065343677137e-1_p
else if(N==6)then
x(1)=-18.19355659245488_p
w(1)=2.045218731095673_p
x(2)=-14.96088834904894_p
w(2)=4.290669985387635_p
x(3)=-9.959789988158876_p
w(3)=5.499457257318507_p
x(4)=-4.456948364254164_p
w(4)=5.154153671586699_p
x(5)=4.421461389479317e-2_p
w(5)=1.970900483832899_p
x(6)=5.178419712132249_p
w(6)=3.959987638129005e-2_p
else if(N==7)then
x(1)=-18.36247304696373_p
w(1)=1.621509441069088_p
x(2)=-15.76720090657791_p
w(2)=3.490786511089478_p
x(3)=-11.59487513769952_p
w(3)=4.721432822936128_p
x(4)=-6.634555443531013_p
w(4)=5.012597810950104_p
x(5)=-1.979223845110857_p
w(5)=3.602123016310097_p
x(6)=1.943625297672497_p
w(6)=5.485143369647261e-1_p
x(7)=7.863193094578788_p
w(7)=3.036066283082784e-3_p
else if(N==8)then
x(1)=-18.47878208691392_p
w(1)=1.328242041964581_p
x(2)=-16.33510720349712_p
w(2)=2.908625259266466_p
x(3)=-12.80152121815912_p
w(3)=4.070958159390225_p
x(4)=-8.399936044229472_p
w(4)=4.611950470813269_p
x(5)=-3.857469685471160_p
w(5)=4.212877244534504_p
x(6)=-1.772448593781056e-2_p
w(6)=1.785439549291852_p
x(7)=4.126304928542832_p
w(7)=8.172671380369964e-2_p
x(8)=10.76499085122089_p
w(8)=1.805665381078735e-4_p
else if(N==9)then
x(1)=-18.56280588626237_p
w(1)=1.115627668292227_p
x(2)=-16.75174093344573_p
w(2)=2.472242289971732_p
x(3)=-13.71441991396376_p
w(3)=3.541782420284824_p
x(4)=-9.812320207267403_p
w(4)=4.178907675689726_p
x(5)=-5.549027165965585_p
w(5)=4.216680880622659_p
x(6)=-1.612181174362640_p
w(6)=2.954052788149692_p
x(7)=1.864039220744501_p
w(7)=5.129040156759639e-1_p
x(8)=6.607548176005833_p
w(8)=7.793139851191166e-3_p
x(9)=13.81126592041098_p
w(9)=9.127064687530024e-6_p
else if(N==10)then
x(1)=-18.62598880479223_p
w(1)=9.553412913212473e-1_p
x(2)=-17.0685115737281_p
w(2)=2.135424876898873_p
x(3)=-14.4236676018297_p
w(3)=3.110766528173567_p
x(4)=-10.95103829230629_p
w(4)=3.774085555592301_p
x(5)=-7.013862877945808_p
w(5)=4.016545425173530_p
x(6)=-3.106253103686068_p
w(6)=3.521104458233465_p
x(7)=2.608890302567573e-1_p
w(7)=1.404842793016186_p
x(8)=3.978298212690925_p
w(8)=8.130367316103275e-2_p
x(9)=9.277584534609705_p
w(9)=5.849797889536498e-4_p
x(10)=16.92630323757152_p
w(10)=4.242435478002046e-7_p
else if(N==11)then
x(1)=-18.67527238518186_p
w(1)=8.300757664205246e-1_p
x(2)=-17.31765271248383_p
w(2)=1.867559681087500_p
x(3)=-14.99048520491161_p
w(3)=2.754671313326640_p
x(4)=-11.88547723083709_p
w(4)=3.410419687373336_p
x(5)=-8.272388930019090_p
w(5)=3.756132479021512_p
x(6)=-4.510466118060502_p
w(6)=3.641343468470069_p
x(7)=-1.087715594270186_p
w(7)=2.346600125669852_p
x(8)=2.105542741960257_p
w(8)=3.842698898647931e-1_p
x(9)=6.312389195703479_p
w(9)=8.887744044292682e-3_p
x(10)=12.01908790637153_p
w(10)=3.982953390179040e-5_p
x(11)=19.96276657083976_p
w(11)=2.079028069483350e-8_p
else if(N==12)then
x(1)=-18.71498972995884_p
w(1)=7.289738409442053e-1_p
x(2)=-17.51973508715876_p
w(2)=1.648426081852657_p
x(3)=-15.45594752067682_p
w(3)=2.454936199833813_p
x(4)=-12.6682713218845_p
w(4)=3.086323927967569_p
x(5)=-9.361277542378284_p
w(5)=3.483119985342191_p
x(6)=-5.803764754530369_p
w(6)=3.560058717066948_p
x(7)=-2.369698468985694_p
w(7)=2.942718897453005_p
x(8)=6.590924753254740e-1_p
w(8)=1.030376599889078_p
x(9)=4.117632964463705_p
w(9)=6.421565700839270e-2_p
x(10)=8.728399962476649_p
w(10)=8.472772498363875e-4_p
x(11)=14.69597533963633_p
w(11)=2.819652714788839e-6_p
x(12)=22.67028096279136_p
w(12)=1.342292493928808e-9_p
else if(N==13)then
x(1)=-18.74777586295597_p
w(1)=6.454160375686965e-1_p
x(2)=-17.68741077408354_p
w(2)=1.465374957002461_p
x(3)=-15.84594043355299_p
w(3)=2.198987585975044_p
x(4)=-13.33437421855134_p
w(4)=2.797860091599972_p
x(5)=-10.3103770306519_p
w(5)=3.215995159158384_p
x(6)=-6.979686423149944_p
w(6)=3.397329305853192_p
x(7)=-3.619254885561411_p
w(7)=3.167671114831840_p
x(8)=-5.818609017067311e-1_p
w(8)=1.828078364270117_p
x(9)=2.407809938008233_p
w(9)=2.747570301990989e-1_p
x(10)=6.239921730603255_p
w(10)=8.448749077910246e-3_p
x(11)=11.10653106435954_p
w(11)=8.137457461327321e-5_p
x(12)=17.17802907569335_p
w(12)=2.353511556531025e-7_p
x(13)=24.81765388609558_p
w(13)=1.402171418723039e-10_p
else if(N==14)then
x(1)=-18.77524721377678_p
w(1)=5.753362348881815e-1_p
x(2)=-17.82848651728909_p
w(2)=1.310535071060991_p
x(3)=-16.1766275265646_p
w(3)=1.978716035839994_p
x(4)=-13.90612250972423_p
w(4)=2.541748761321368_p
x(5)=-11.14018416127899_p
w(5)=2.963502700505642_p
x(6)=-8.039051949396663_p
w(6)=3.203617965852791_p
x(7)=-4.811633817697537_p
w(7)=3.174919642716172_p
x(8)=-1.753206776062685_p
w(8)=2.446393959189082_p
x(9)=1.028297281236292_p
w(9)=7.533702038260593e-1_p
x(10)=4.265593789546243_p
w(10)=5.079894546247728e-2_p
x(11)=8.369475372186496_p
w(11)=1.051872599798357e-3_p
x(12)=13.36594713064202_p
w(12)=8.587126580043699e-6_p
x(13)=19.37911131816876_p
w(13)=2.518853767701569e-8_p
x(14)=26.35513873128188_p
w(14)=2.502826498233164e-11_p
else if(N==15)then
x(1)=-18.79849593651279_p
w(1)=5.159822774298262e-1_p
x(2)=-17.94827788943871_p
w(2)=1.178486796900481_p
x(3)=-16.45919234143318_p
w(3)=1.788267817486845_p
x(4)=-14.39946277109883_p
w(4)=2.314929436984842_p
x(5)=-11.86660284791406_p
w(5)=2.729730482463700_p
x(6)=-8.987232342013302_p
w(6)=3.002071903422055_p
x(7)=-5.922905267957701_p
w(7)=3.081738408674822_p
x(8)=-2.897427118590949_p
w(8)=2.756139193676376_p
x(9)=-1.531751932884345e-1_p
w(9)=1.421299504526272_p
x(10)=2.666012228937872_p
w(10)=2.031639595335407e-1_p
x(11)=6.178366274845170_p
w(11)=8.053476563716367e-3_p
x(12)=10.43775021551173_p
w(12)=1.356946487474284e-4_p
x(13)=15.45632251582502_p
w(13)=1.049691987820969e-6_p
x(14)=21.26202981180406_p
w(14)=3.592453643611890e-9_p
x(15)=27.39407925375228_p
w(15)=7.036894662558289e-12_p
else if(N==16)then
x(1)=-18.81833387821552_p
w(1)=4.653036825163046e-1_p
x(2)=-18.05077616479906_p
w(2)=1.065101698447802_p
x(3)=-16.70221048875083_p
w(3)=1.622910088172042_p
x(4)=-14.82712989603869_p
w(4)=2.114229197471600_p
x(5)=-12.50361440169813_p
w(5)=2.515937925358735_p
x(6)=-9.832985375800231_p
w(6)=2.804098543430357_p
x(7)=-6.942794222875306_p
w(7)=2.945856768129982_p
x(8)=-4.002366501523103_p
w(8)=2.838939030292281_p
x(9)=-1.245482873813783_p
w(9)=2.024018606126182_p
x(10)=1.346711727080387_p
w(10)=5.606163678867193e-1_p
x(11)=4.379888012316374_p
w(11)=4.172294249238363e-2_p
x(12)=8.077133759727408_p
w(12)=1.245929964689472e-3_p
x(13)=12.40124866897207_p
w(13)=1.907119951450892e-5_p
x(14)=17.34795658655782_p
w(14)=1.534257146791280e-7_p
x(15)=22.82687710046891_p
w(15)=6.856355169996069e-10_p
x(16)=28.08586828611176_p
w(16)=2.759935110576442e-12_p
else if(N==17)then
x(1)=-18.8353898698674_p
w(1)=4.217088192516674e-1_p
x(2)=-18.13910198368184_p
w(2)=9.671090708312660e-1_p
x(3)=-16.91251759735399_p
w(3)=1.478693471721851_p
x(4)=-15.19964654807556_p
w(4)=1.936508859623089_p
x(5)=-13.06368335586596_p
w(5)=2.321764110643087_p
x(6)=-10.58662087865284_p
w(6)=2.615335105532639_p
x(7)=-7.870820183975161_p
w(7)=2.793719726015165_p
x(8)=-5.047452324455600_p
w(8)=2.803385928886935_p
x(9)=-2.302392390053406_p
w(9)=2.391413208482167_p
x(10)=2.156789241623378e-1_p
w(10)=1.107030358592596_p
x(11)=2.884195236595606_p
w(11)=1.553995388119641e-1_p
x(12)=6.120757254733118_p
w(12)=7.728277657261413e-3_p
x(13)=9.915599844529277_p
w(13)=2.004886394061356e-4_p
x(14)=14.23152487139805_p
w(14)=3.013497847037092e-6_p
x(15)=19.02716204859669_p
w(15)=2.724270359891426e-8_p
x(16)=24.09947701983136_p
w(16)=1.716966974929585e-10_p
x(17)=28.55221809521277_p
w(17)=1.361927786929746e-12_p
else
call GD(-19)
end if
end subroutine GF_m19

! [-18kT;30kT]
subroutine GF_m18(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.00466036074333_p
w(1)=9.439548871506219_p
x(2)=-3.289241401615386_p
w(2)=8.560451143723668_p
else if(N==3)then
x(1)=-15.77082961307913_p
w(1)=5.490612559185596_p
x(2)=-8.150660644270358_p
w(2)=8.668234971426884_p
x(3)=-8.100978692567492e-1_p
w(3)=3.841152484617407_p
else if(N==4)then
x(1)=-16.55710073225125_p
w(1)=3.612723219548835_p
x(2)=-11.1592555477473_p
w(2)=6.728671212065296_p
x(3)=-4.252903086437696_p
w(3)=6.315427455725427_p
x(4)=1.047529350655807_p
w(4)=1.343178127890327_p
else if(N==5)then
x(1)=-16.97406824913646_p
w(1)=2.589715274551301_p
x(2)=-12.96355794703055_p
w(2)=5.206113360763381_p
x(3)=-7.153077844891050_p
w(3)=6.054182740949692_p
x(4)=-1.654996179708758_p
w(4)=3.882542186840694_p
x(5)=3.082197344724704_p
w(5)=2.674464521248192e-1_p
else if(N==6)then
x(1)=-17.22287068849561_p
w(1)=1.970786883936268_p
x(2)=-14.10853536594937_p
w(2)=4.132529712890316_p
x(3)=-9.295042577634836_p
w(3)=5.287708078369282_p
x(4)=-4.019670438961691_p
w(4)=4.886033606595448_p
x(5)=3.086876452543757e-1_p
w(5)=1.694254173425488_p
x(6)=5.514734842032149_p
w(6)=2.868756001308396e-2_p
else if(N==7)then
x(1)=-17.3842474241957_p
w(1)=1.566063048246039_p
x(2)=-14.87820946773568_p
w(2)=3.370012175965174_p
x(3)=-10.85234511254595_p
w(3)=4.552551262080289_p
x(4)=-6.077620945116766_p
w(4)=4.806929249320037_p
x(5)=-1.629462609831676_p
w(5)=3.278756096632494_p
x(6)=2.255878442888552_p
w(6)=4.236274038031727e-1_p
x(7)=8.258146833637198_p
w(7)=2.060779182679515e-3_p
else if(N==8)then
x(1)=-17.49558807227357_p
w(1)=1.285365866784757_p
x(2)=-15.42147687740593_p
w(2)=2.813691159927723_p
x(3)=-12.00469347585461_p
w(3)=3.934311952321642_p
x(4)=-7.755690013130375_p
w(4)=4.443859233092740_p
x(5)=-3.395724778254281_p
w(5)=3.972250306977526_p
x(6)=3.015849710118347e-1_p
w(6)=1.493445591475530_p
x(7)=4.508528546638317_p
w(7)=5.695912688674874e-2_p
x(8)=11.20560609163672_p
w(8)=1.167777632192108e-4_p
else if(N==9)then
x(1)=-17.57618744896024_p
w(1)=1.081443212333989_p
x(2)=-15.82089442333973_p
w(2)=2.395697341628958_p
x(3)=-12.87868974282101_p
w(3)=3.429393412177969_p
x(4)=-9.103605592528849_p
w(4)=4.038130910775796_p
x(5)=-4.994306239727136_p
w(5)=4.036657147576333_p
x(6)=-1.230252993329477_p
w(6)=2.633297385998186_p
x(7)=2.225491036322955_p
w(7)=3.802916388714417e-1_p
x(8)=7.044482343743842_p
w(8)=5.083274680447503e-3_p
x(9)=14.28669795256895_p
w(9)=5.691186766499153e-6_p
else if(N==10)then
x(1)=-17.63694408243509_p
w(1)=9.273290407311892e-1_p
x(2)=-16.12534888930952_p
w(2)=2.072202690258736_p
x(3)=-13.55961386352252_p
w(3)=3.016640171465828_p
x(4)=-10.19429728087722_p
w(4)=3.654347809657568_p
x(5)=-6.388454049894899_p
w(5)=3.869959285154532_p
x(6)=-2.639547439794009_p
w(6)=3.276146811948946_p
x(7)=6.206173956119936e-1_p
w(7)=1.128522331316618_p
x(8)=4.401254669475557_p
w(8)=5.448513253294394e-2_p
x(9)=9.750365472408843_p
w(9)=3.664829385647742e-4_p
x(10)=17.41969539751253_p
w(10)=2.592249595064746e-7_p
else if(N==11)then
x(1)=-17.68447843464768_p
w(1)=8.065206726457885e-1_p
x(2)=-16.36554825910055_p
w(2)=1.814098328177634_p
x(3)=-14.10560411735312_p
w(3)=2.674297113701773_p
x(4)=-11.09280158485758_p
w(4)=3.306993652673326_p
x(5)=-7.593482650069996_p
w(5)=3.631020744829533_p
x(6)=-3.968831765396735_p
w(6)=3.463654556705736_p
x(7)=-6.914701643699994e-1_p
w(7)=2.025009094203266_p
x(8)=2.505632909560077_p
w(8)=2.727350148614361e-1_p
x(9)=6.775001486635142_p
w(9)=5.646317683631358e-3_p
x(10)=12.50636126550036_p
w(10)=2.450690841157949e-5_p
x(11)=20.43975030962829_p
w(11)=1.283934931338374e-8_p
else if(N==12)then
x(1)=-17.72289388129793_p
w(1)=7.087401620230285e-1_p
x(2)=-16.56094054212501_p
w(2)=1.602316916147167_p
x(3)=-14.55533541340302_p
w(3)=2.385129900637307_p
x(4)=-11.84809887681346_p
w(4)=2.995738855972971_p
x(5)=-8.641021397909784_p
w(5)=3.373708402549869_p
x(6)=-5.202956266432992_p
w(6)=3.420511349694449_p
x(7)=-1.912162347966579_p
w(7)=2.679378678683639_p
x(8)=1.045521502561295_p
w(8)=7.919808632623138e-1_p
x(9)=4.562366043480363_p
w(9)=4.196615401633418e-2_p
x(10)=9.206174234469364_p
w(10)=5.269865629779618e-4_p
x(11)=15.1731656406258_p
w(11)=1.744806472575416e-6_p
x(12)=23.0835250079167_p
w(12)=8.733566043646805e-10_p
else if(N==13)then
x(1)=-17.7546603726603_p
w(1)=6.277861290424185e-1_p
x(2)=-16.7233555988762_p
w(2)=1.425076404220467_p
x(3)=-14.93287033189991_p
w(3)=2.137656789300303_p
x(4)=-12.49221680346072_p
w(4)=2.717757381636395_p
x(5)=-9.556798080738888_p
w(5)=3.119048991662543_p
x(6)=-6.331489845728677_p
w(6)=3.279885969657404_p
x(7)=-3.098385566603690_p
w(7)=2.978398736846902_p
x(8)=-1.792885981903558e-1_p
w(8)=1.520167629705317_p
x(9)=2.829987670844850_p
w(9)=1.888421374878127e-1_p
x(10)=6.706946365412595_p
w(10)=5.329131035343656e-3_p
x(11)=11.5808220402238_p
w(11)=5.056509917795857e-5_p
x(12)=17.62405176760245_p
w(12)=1.494370635578514e-7_p
x(13)=25.13732642953617_p
w(13)=9.873987384891654e-11_p
else if(N==14)then
x(1)=-17.78129968417311_p
w(1)=5.598325782855222e-1_p
x(2)=-16.8601253927121_p
w(2)=1.275011045822116_p
x(3)=-15.25330505943286_p
w(3)=1.924426223404057_p
x(4)=-13.04574256202862_p
w(4)=2.470469125039140_p
x(5)=-10.3588130156314_p
w(5)=2.876952790687860_p
x(6)=-7.351588999616223_p
w(6)=3.101018377925790_p
x(7)=-4.235741275729771_p
w(7)=3.033569094619000_p
x(8)=-1.305749443517340_p
w(8)=2.168295248029406_p
x(9)=1.433918353041215_p
w(9)=5.570034002060583e-1_p
x(10)=4.719482457617939_p
w(10)=3.276019335449952e-2_p
x(11)=8.841137133088958_p
w(11)=6.565173032658179e-4_p
x(12)=13.82349505551725_p
w(12)=5.403906657573769e-6_p
x(13)=19.78037186927294_p
w(13)=1.662744444822898e-8_p
x(14)=26.58444314953357_p
w(14)=1.906882791086678e-11_p
else if(N==15)then
x(1)=-17.8038554751223_p
w(1)=5.022504025928860e-1_p
x(2)=-16.97632203170475_p
w(2)=1.146960767380824_p
x(3)=-15.5272745649262_p
w(3)=1.739924359370122_p
x(4)=-13.5237193922542_p
w(4)=2.251179240808989_p
x(5)=-11.06167549867332_p
w(5)=2.652047832933334_p
x(6)=-8.266571661633071_p
w(6)=2.910744941486828_p
x(7)=-5.300999132214996_p
w(7)=2.967362822489258_p
x(8)=-2.394332777027186_p
w(8)=2.549597640439785_p
x(9)=2.578129212268546e-1_p
w(9)=1.138426294640621_p
x(10)=3.103326326507224_p
w(10)=1.363567066526186e-1_p
x(11)=6.646169538028877_p
w(11)=5.063360873773382e-3_p
x(12)=10.9021400381683_p
w(12)=8.496762544032276e-5_p
x(13)=15.88763015112296_p
w(13)=6.754477702045278e-7_p
x(14)=21.61196413977285_p
w(14)=2.481925641334345e-9_p
x(15)=27.55394922077089_p
w(15)=5.710243258737082e-12_p
else if(N==16)then
x(1)=-17.82311041302755_p
w(1)=4.530632004683621e-1_p
x(2)=-17.0757899319239_p
w(2)=1.036954219441633_p
x(3)=-15.76302198143899_p
w(3)=1.579626333823615_p
x(4)=-13.93833092723003_p
w(4)=2.056941365764071_p
x(5)=-11.67857587699845_p
w(5)=2.445891078599191_p
x(6)=-9.083973682388947_p
w(6)=2.721953891377713_p
x(7)=-6.282202946692721_p
w(7)=2.847831146050359_p
x(8)=-3.446995334769364_p
w(8)=2.689334264598007_p
x(9)=-8.025522253837640e-1_p
w(9)=1.740194994548463_p
x(10)=1.769202272681091_p
w(10)=4.007823064213671e-1_p
x(11)=4.840549789290296_p
w(11)=2.663629838699168e-2_p
x(12)=8.545465566061550_p
w(12)=7.787214861544022e-4_p
x(13)=12.84970250518268_p
w(13)=1.209214195240837e-5_p
x(14)=17.7464722593879_p
w(14)=1.016232077423113e-7_p
x(15)=23.12470631485833_p
w(15)=4.964538480076496e-10_p
x(16)=28.19783719884737_p
w(16)=2.344251460884531e-12_p
else if(N==17)then
x(1)=-17.83967202283099_p
w(1)=4.107335050323375e-1_p
x(2)=-17.16154189101676_p
w(2)=9.418369151254934e-1_p
x(3)=-15.96713625042061_p
w(3)=1.439740180072454_p
x(4)=-14.29968508735017_p
w(4)=1.884792327938055_p
x(5)=-12.22137960725943_p
w(5)=2.258331171821811_p
x(6)=-9.813229225684445_p
w(6)=2.540944645439360_p
x(7)=-7.177295721795726_p
w(7)=2.706966582798898_p
x(8)=-4.447242369981202_p
w(8)=2.687680105475513_p
x(9)=-1.812336672532940_p
w(9)=2.166769233833950_p
x(10)=6.373600000727748e-1_p
w(10)=8.548863939187482e-1_p
x(11)=3.333500165736017_p
w(11)=1.023482918670351e-1_p
x(12)=6.589938501241790_p
w(12)=4.842755130640347e-3_p
x(13)=10.37528739177144_p
w(13)=1.259402665846909e-4_p
x(14)=14.65765547203675_p
w(14)=1.947729300785615e-6_p
x(15)=19.38911004766587_p
w(15)=1.864854369156491e-8_p
x(16)=24.34872512217352_p
w(16)=1.299673632706675e-10_p
x(17)=28.63230363853348_p
w(17)=1.194448666231945e-12_p
else
call GD(-18)
end if
end subroutine GF_m18

! [-17kT;30kT]
subroutine GF_m17(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-13.20653105302906_p
w(1)=8.961195868390877_p
x(2)=-3.048806096366389_p
w(2)=8.038804173008405_p
else if(N==3)then
x(1)=-14.8750769088098_p
w(1)=5.233410363389827_p
x(2)=-7.616418692968699_p
w(2)=8.245051535481107_p
x(3)=-6.275440727279196e-1_p
w(3)=3.521538142528349_p
else if(N==4)then
x(1)=-15.61955154820387_p
w(1)=3.456131859831282_p
x(2)=-10.45765609272275_p
w(2)=6.430831905702465_p
x(3)=-3.872959914471168_p
w(3)=5.957222600938862_p
x(4)=1.255977403742142_p
w(4)=1.155813674926675_p
else if(N==5)then
x(1)=-16.01530819811995_p
w(1)=2.485470600227905_p
x(2)=-12.16740183855073_p
w(2)=4.993086806058737_p
x(3)=-6.601664871164734_p
w(3)=5.783133242386937_p
x(4)=-1.364382557901226_p
w(4)=3.530576749403886_p
x(5)=3.363792432091148_p
w(5)=2.077326433218184e-1_p
else if(N==6)then
x(1)=-16.25202507633094_p
w(1)=1.896751975934116_p
x(2)=-13.25546003428589_p
w(2)=3.975028582470499_p
x(3)=-8.629197848988809_p
w(3)=5.075524755277645_p
x(4)=-3.582997315396002_p
w(4)=4.604223725093445_p
x(5)=5.860561404381860e-1_p
w(5)=1.428115576533217_p
x(6)=5.870628893267625_p
w(6)=2.035542609036139e-2_p
else if(N==7)then
x(1)=-16.40591771861328_p
w(1)=1.510875810179911_p
x(2)=-13.98874245571574_p
w(2)=3.249668577718874_p
x(3)=-10.10903759723592_p
w(3)=4.383623903659433_p
x(4)=-5.520975335368794_p
w(4)=4.595617617711254_p
x(5)=-1.278331838525730_p
w(5)=2.940437916202873_p
x(6)=2.589411811914713_p
w(6)=3.184036956722606e-1_p
x(7)=8.671519401569018_p
w(7)=1.372520254678072e-3_p
else if(N==8)then
x(1)=-16.51232778005772_p
w(1)=1.242654606389867_p
x(2)=-14.50754449918862_p
w(2)=2.719029796775023_p
x(3)=-11.20736896822804_p
w(3)=3.797669364736908_p
x(4)=-7.111519143664895_p
w(4)=4.273475806741761_p
x(5)=-2.936786313570747_p
w(5)=3.711457673452932_p
x(6)=6.342572579327356e-1_p
w(6)=1.216885377599811_p
x(7)=4.912115940474861_p
w(7)=3.875320501695862e-2_p
x(8)=11.66342194719117_p
w(8)=7.421068602336818e-5_p
else if(N==9)then
x(1)=-16.58953135315389_p
w(1)=1.047351952180980_p
x(2)=-14.88988082666406_p
w(2)=2.319295666440067_p
x(3)=-12.04270944830909_p
w(3)=3.316960513072401_p
x(4)=-8.395032877256572_p
w(4)=3.896171438827156_p
x(5)=-4.442094595304682_p
w(5)=3.845743454602386_p
x(6)=-8.469871704933818e-1_p
w(6)=2.298043683173288_p
x(7)=2.609509903710131_p
w(7)=2.731791247385724e-1_p
x(8)=7.500182916394336_p
w(8)=3.250715053068247e-3_p
x(9)=14.77754546647494_p
w(9)=3.493311363745292e-6_p
else if(N==10)then
x(1)=-16.64788644085283_p
w(1)=8.993476840572232e-1_p
x(2)=-15.18213865663768_p
w(2)=2.009004177211773_p
x(3)=-12.69554785619046_p
w(3)=2.922378190312483_p
x(4)=-9.437912943861779_p
w(4)=3.533803803138996_p
x(5)=-5.765037394790817_p
w(5)=3.718121343017609_p
x(6)=-2.177506883683911_p
w(6)=3.004439080894025_p
x(7)=9.958924963187370e-1_p
w(7)=8.770560855509048e-1_p
x(8)=4.845166561646362_p
w(8)=3.562363890605877e-2_p
x(9)=10.23879682322584_p
w(9)=2.258817962004828e-4_p
x(10)=17.92436134919849_p
w(10)=1.565140080191838e-7_p
else if(N==11)then
x(1)=-16.69369043801386_p
w(1)=7.829488416749001e-1_p
x(2)=-15.41348839884456_p
w(2)=1.760566893862874_p
x(3)=-13.220900085037_p
w(3)=2.593701899737631_p
x(4)=-10.30069462551911_p
w(4)=3.202899121768343_p
x(5)=-6.916341001880806_p
w(5)=3.503082224851918_p
x(6)=-3.432365161326808_p
w(6)=3.267563019823746_p
x(7)=-2.917703597552634e-1_p
w(7)=1.698317049009562_p
x(8)=2.927813342925476_p
w(8)=1.873824773553767e-1_p
x(9)=7.253983248567407_p
w(9)=3.523607978484390e-3_p
x(10)=13.00496741586623_p
w(10)=1.489744465669359e-5_p
x(11)=20.91980614873709_p
w(11)=7.891790343313038e-9_p
else if(N==12)then
x(1)=-16.7308126221139_p
w(1)=6.884680568530088e-1_p
x(2)=-15.60223178150738_p
w(2)=1.556097317837517_p
x(3)=-13.65497951851023_p
w(3)=2.315075889458060_p
x(4)=-11.02856057850775_p
w(4)=2.904584852794234_p
x(5)=-7.922312996520271_p
w(5)=3.262561380085392_p
x(6)=-4.606278564683034_p
w(6)=3.271221649625208_p
x(7)=-1.459286595926217_p
w(7)=2.388259163254816_p
x(8)=1.449516276698947_p
w(8)=5.865876428759910e-1_p
x(9)=5.025508140567581_p
w(9)=2.681953315301964e-2_p
x(10)=9.696101432215768_p
w(10)=3.234832733098922e-4_p
x(11)=15.65680263960156_p
w(11)=1.071618644003478e-6_p
x(12)=23.49071472360247_p
w(12)=5.700835988384298e-10_p
else if(N==13)then
x(1)=-16.76156036504649_p
w(1)=6.101157622948991e-1_p
x(2)=-15.75938852627164_p
w(2)=1.384668341634204_p
x(3)=-14.02004966409374_p
w(3)=2.076100656420847_p
x(4)=-11.65063447043636_p
w(4)=2.637190899101332_p
x(5)=-8.804493709570945_p
w(5)=3.020939366393972_p
x(6)=-5.686363229401064_p
w(6)=3.157374402199412_p
x(7)=-2.583952643228770_p
w(7)=2.763530780596686_p
x(8)=2.305470376850244e-1_p
w(8)=1.220866448630082_p
x(9)=3.272780898522231_p
w(9)=1.258729240816095e-1_p
x(10)=7.187927165413019_p
w(10)=3.309244543755647e-3_p
x(11)=12.06371403594017_p
w(11)=3.112087790110925e-5_p
x(12)=18.07224843212596_p
w(12)=9.455453400564066e-8_p
x(13)=25.44649423672353_p
w(13)=7.004631785389888e-11_p
else if(N==14)then
x(1)=-16.78736598249927_p
w(1)=5.442928721570196e-1_p
x(2)=-15.89184216270722_p
w(2)=1.239391307551257_p
x(3)=-14.33019911215666_p
w(3)=1.869945874692128_p
x(4)=-12.18584768700085_p
w(4)=2.398817784866539_p
x(5)=-9.578466691896775_p
w(5)=2.789574693032768_p
x(6)=-6.666409386627295_p
w(6)=2.995586075753481_p
x(7)=-3.665238514901982_p
w(7)=2.876698284452251_p
x(8)=-8.604927120582558e-1_p
w(8)=1.868272711367901_p
x(9)=1.858451470937976_p
w(9)=3.963116321089339e-1_p
x(10)=5.189959864143554_p
w(10)=2.070042187307724e-2_p
x(11)=9.323365088430254_p
w(11)=4.049942369220544e-4_p
x(12)=14.28661187023206_p
w(12)=3.378320895884532e-6_p
x(13)=20.18054928695722_p
w(13)=1.097147217066890e-8_p
x(14)=26.80372922026531_p
w(14)=1.463698570911235e-11_p
else if(N==15)then
x(1)=-16.80922709594318_p
w(1)=4.884870750118818e-1_p
x(2)=-16.00443380280808_p
w(2)=1.115352252378708_p
x(3)=-14.59554253446796_p
w(3)=1.691420333108566_p
x(4)=-12.64838409614185_p
w(4)=2.187127433277460_p
x(5)=-10.25758195273499_p
w(5)=2.573746156381972_p
x(6)=-7.547658548267930_p
w(6)=2.817679976653952_p
x(7)=-4.683123776660195_p
w(7)=2.844617628850203_p
x(8)=-1.897447594944188_p
w(8)=2.313066029193538_p
x(9)=6.798052067285798e-1_p
w(9)=8.763739806786626e-1_p
x(10)=3.559928954929277_p
w(10)=8.893810113429598e-2_p
x(11)=7.126634540646304_p
w(11)=3.137901719043727e-3_p
x(12)=11.37431351376182_p
w(12)=5.273841369501341e-5_p
x(13)=16.32188371016688_p
w(13)=4.328750476685496e-7_p
x(14)=21.95862572997395_p
w(14)=1.717596879906570e-9_p
x(15)=27.70617616478065_p
w(15)=4.660693969015741e-12_p
else if(N==16)then
x(1)=-16.82789762434885_p
w(1)=4.407949621502845e-1_p
x(2)=-16.10086311197297_p
w(2)=1.008734767997758_p
x(3)=-14.82399489138542_p
w(3)=1.536205288504079_p
x(4)=-13.04988053557926_p
w(4)=1.999403887394334_p
x(5)=-10.85423001307273_p
w(5)=2.375363003363957_p
x(6)=-8.336343680508236_p
w(6)=2.638647919260531_p
x(7)=-5.624610483736833_p
w(7)=2.745229087681949_p
x(8)=-2.897829651441899_p
w(8)=2.517772806136142_p
x(9)=-3.584586094415074e-1_p
w(9)=1.444843942160351_p
x(10)=2.210996644705837_p
w(10)=2.758281706904450e-1_p
x(11)=5.316414540389895_p
w(11)=1.668705619668164e-2_p
x(12)=9.023456362977686_p
w(12)=4.814639274476106e-4_p
x(13)=13.30353308003843_p
w(13)=7.618391689964712e-6_p
x(14)=18.14575898457688_p
w(14)=6.718112441857213e-8_p
x(15)=23.41810982223853_p
w(15)=3.605078072685822e-10_p
x(16)=28.30446066030023_p
w(16)=1.999261753803219e-12_p
else if(N==17)then
x(1)=-16.84396370996173_p
w(1)=3.997334349500840e-1_p
x(2)=-16.18403457004349_p
w(2)=9.165012336983049e-1_p
x(3)=-15.02189686148941_p
w(3)=1.400667934976971_p
x(4)=-13.40002549703256_p
w(4)=1.832865580776141_p
x(5)=-11.37966161408411_p
w(5)=2.194512751232033_p
x(6)=-9.040960108187825_p
w(6)=2.465723683719944_p
x(7)=-6.486059622750885_p
w(7)=2.617541277002107_p
x(8)=-3.852012760426406_p
w(8)=2.559058988762490_p
x(9)=-1.327227904419521_p
w(9)=1.912170686062626_p
x(10)=1.072839627708092_p
w(10)=6.325059763127810e-1_p
x(11)=3.800734518884351_p
w(11)=6.564456277186749e-2_p
x(12)=7.070748713944774_p
w(12)=2.994202992467136e-3_p
x(13)=10.84220395521464_p
w(13)=7.846181436196819e-5_p
x(14)=15.08709614696676_p
w(14)=1.253465709700943e-6_p
x(15)=19.75017212831274_p
w(15)=1.276163836448344e-8_p
x(16)=24.59323800453428_p
w(16)=9.870519978020049e-11_p
x(17)=28.70873627907914_p
w(17)=1.050381949996760e-12_p
else
call GD(-17)
end if
end subroutine GF_m17

! [-16kT;30kT]
subroutine GF_m16(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-12.40753460192587_p
w(1)=8.484775125786484_p
x(2)=-2.804962848173747_p
w(2)=7.515224986748590_p
else if(N==3)then
x(1)=-13.97871821360051_p
w(1)=4.977655048785310_p
x(2)=-7.080128266628947_p
w(2)=7.821265259218655_p
x(3)=-4.368117627684872e-1_p
w(3)=3.201079804531111_p
else if(N==4)then
x(1)=-14.68161022140649_p
w(1)=3.300497558025735_p
x(2)=-9.754470797193147_p
w(2)=6.133926363915952_p
x(3)=-3.491670886325219_p
w(3)=5.588154809692204_p
x(4)=1.480174172456870_p
w(4)=9.774213809011844e-1_p
else if(N==5)then
x(1)=-15.05629798052438_p
w(1)=2.381842454436403_p
x(2)=-11.37016738644794_p
w(2)=4.780897098327849_p
x(3)=-6.049157763802363_p
w(3)=5.508458115118708_p
x(4)=-1.069081478747142_p
w(4)=3.171145239463212_p
x(5)=3.666226168741113_p
w(5)=1.576572051889019e-1_p
else if(N==6)then
x(1)=-15.28102014891768_p
w(1)=1.823111403408455_p
x(2)=-12.40167971776755_p
w(2)=3.818119073808443_p
x(3)=-7.962416164010970_p
w(3)=4.862419832599151_p
x(4)=-3.147269081166195_p
w(4)=4.305579434094067_p
x(5)=8.789092302049932e-1_p
w(5)=1.176636564851146_p
x(6)=6.247057431825215_p
w(6)=1.413380377381415e-2_p
else if(N==7)then
x(1)=-15.42748720967626_p
w(1)=1.455938323608360_p
x(2)=-13.0988263200152_p
w(2)=3.129709861176002_p
x(3)=-9.365081441900703_p
w(3)=4.214403842517344_p
x(4)=-4.965170495497476_p
w(4)=4.376287958141580_p
x(5)=-9.241975041765933e-1_p
w(5)=2.590265325283196_p
x(6)=2.945978949353925_p
w(6)=2.324984870384156e-1_p
x(7)=9.104041523706565_p
w(7)=8.963147701774816e-4_p
else if(N==8)then
x(1)=-15.52900600067601_p
w(1)=1.200095314534421_p
x(2)=-13.59334122053412_p
w(2)=2.624595911109263_p
x(3)=-10.40966248576441_p
w(3)=3.660869516472149_p
x(4)=-6.467844636357237_p
w(4)=4.099673199096783_p
x(5)=-2.480948454116712_p
w(5)=3.426764040708338_p
x(6)=9.835910964391231e-1_p
w(6)=9.622260185441307e-1_p
x(7)=5.337720182235087_p
w(7)=2.572979811892398e-2_p
x(8)=12.13899603845879_p
w(8)=4.631395106754425e-5_p
else if(N==9)then
x(1)=-15.60284359919762_p
w(1)=1.013338050916397_p
x(2)=-13.95873563978994_p
w(2)=2.242990575960409_p
x(3)=-11.2065903188003_p
w(3)=3.204358682166732_p
x(4)=-7.686932501719981_p
w(4)=3.752449511445239_p
x(5)=-3.893250361905949_p
w(5)=3.639811564265053_p
x(6)=-4.597193573362406e-1_p
w(6)=1.955073609553438_p
x(7)=3.017621249025555_p
w(7)=1.899385224750791e-1_p
x(8)=7.975007802138524_p
w(8)=2.037485550523902e-3_p
x(9)=15.28402830891421_p
w(9)=2.110202202483048e-6_p
else if(N==10)then
x(1)=-15.65882265577579_p
w(1)=8.713795384097988e-1_p
x(2)=-14.2389191194857_p
w(2)=1.945781764376151_p
x(3)=-11.83157897609041_p
w(3)=2.827874338267741_p
x(4)=-8.682162950750289_p
w(4)=3.412106111852093_p
x(5)=-5.144373108859463_p
w(5)=3.558670793673374_p
x(6)=-1.719734053688905_p
w(6)=2.704160743463557_p
x(7)=1.390225757979961_p
w(7)=6.571564103065032e-1_p
x(8)=5.310152547017629_p
w(8)=2.273335400307294e-2_p
x(9)=10.74288896772619_p
w(9)=1.369647632642182e-4_p
x(10)=18.43971936126953_p
w(10)=9.341951868580475e-8_p
else if(N==11)then
x(1)=-15.70291446080909_p
w(1)=7.593444936347896e-1_p
x(2)=-14.46150688908276_p
w(2)=1.706924145769038_p
x(3)=-12.33646663312468_p
w(3)=2.512800221729519_p
x(4)=-9.509377587210162_p
w(4)=3.097908982706738_p
x(5)=-6.241529489674787_p
w(5)=3.371089981080723_p
x(6)=-2.901894743663453_p
w(6)=3.047505426015012_p
x(7)=1.152178417889564e-1_p
w(7)=1.377578321022433_p
x(8)=3.372849627607945_p
w(8)=1.246790061463423e-1_p
x(9)=7.749181679231470_p
w(9)=2.160579799449960e-3_p
x(10)=13.5145142540976_p
w(10)=8.949797170914564e-6_p
x(11)=21.40141442901491_p
w(11)=4.833858920380546e-9_p
else if(N==12)then
x(1)=-15.7387503995739_p
w(1)=6.681459402130240e-1_p
x(2)=-14.64363365447887_p
w(2)=1.509736820121068_p
x(3)=-12.75494886427424_p
w(3)=2.244711462569725_p
x(4)=-10.20981756351544_p
w(4)=2.812709758971211_p
x(5)=-7.205547093671009_p
w(5)=3.149019698817894_p
x(6)=-4.014657256777022_p
w(6)=3.108074373886282_p
x(7)=-1.009236458615967_p
w(7)=2.072803759208546_p
x(8)=1.873997016499125_p
w(8)=4.178264522950315e-1_p
x(9)=5.506817987505213_p
w(9)=1.677518107074418e-2_p
x(10)=10.19793753121647_p
w(10)=1.960114397337082e-4_p
x(11)=16.14629174983807_p
w(11)=6.535680344927877e-7_p
x(12)=23.89036597380544_p
w(12)=3.737807146420799e-10_p
else if(N==13)then
x(1)=-15.76847912845736_p
w(1)=5.923963569416779e-1_p
x(2)=-14.79552802234508_p
w(2)=1.344128012934602_p
x(3)=-13.10752998280137_p
w(3)=2.014272368172389_p
x(4)=-10.80974678957006_p
w(4)=2.556053628080668_p
x(5)=-8.053745861402613_p
w(5)=2.921284416406358_p
x(6)=-5.045028206377062_p
w(6)=3.027470044971567_p
x(7)=-2.076117074107485_p
w(7)=2.518264529370730_p
x(8)=6.520059734364430e-1_p
w(8)=9.426131945630728e-1_p
x(9)=3.736403768587629_p
w(9)=8.147470672101938e-2_p
x(10)=7.682623948060028_p
w(10)=2.023818685025914e-3_p
x(11)=12.55490118818805_p
w(11)=1.897598693523871e-5_p
x(12)=18.52199188024449_p
w(12)=5.965094191724285e-8_p
x(13)=25.74449955369421_p
w(13)=5.008711372258312e-11_p
else if(N==14)then
x(1)=-15.79344882050737_p
w(1)=5.287100429753575e-1_p
x(2)=-14.92365201737545_p
w(2)=1.203657204245866_p
x(3)=-13.40735177791538_p
w(3)=1.815237368864750_p
x(4)=-11.32653356009826_p
w(4)=2.326714177585501_p
x(5)=-8.799359903219912_p
w(5)=2.701127014014902_p
x(6)=-5.984045045390797_p
w(6)=2.886062414046535_p
x(7)=-3.101011237414031_p
w(7)=2.698554581277183_p
x(8)=-4.142199285694728e-1_p
w(8)=1.555578634062544_p
x(9)=2.303949490778565_p
w(9)=2.712810982967077e-1_p
x(10)=5.676673323554085_p
w(10)=1.282848333206324e-2_p
x(11)=9.815921573917356_p
w(11)=2.469878315964604e-4_p
x(12)=14.75493143644585_p
w(12)=2.098750843477249e-6_p
x(13)=20.57906441936591_p
w(13)=7.239905167575787e-9_p
x(14)=27.01295991711576_p
w(14)=1.131983007092291e-11_p
else if(N==15)then
x(1)=-15.81461316864259_p
w(1)=4.746861211372619e-1_p
x(2)=-15.03262640007073_p
w(2)=1.083645164966325_p
x(3)=-13.66403237171792_p
w(3)=1.642724148256619_p
x(4)=-11.77353702311673_p
w(4)=2.122710375808168_p
x(5)=-9.454493601244970_p
w(5)=2.494660690279223_p
x(6)=-6.830890541270627_p
w(6)=2.722169802321985_p
x(7)=-4.070167725636350_p
w(7)=2.709623999884628_p
x(8)=-1.405885790943568_p
w(8)=2.045246679237214_p
x(9)=1.116958680646765_p
w(9)=6.461072627665574e-1_p
x(10)=4.035669017663794_p
w(10)=5.647544341474798e-2_p
x(11)=7.619462041755879_p
w(11)=1.917691304935253e-3_p
x(12)=11.85399554644585_p
w(12)=3.245557287172623e-5_p
x(13)=16.75868157853597_p
w(13)=2.763895838556834e-7_p
x(14)=22.30154906659349_p
w(14)=1.191129209852631e-9_p
x(15)=27.85093244745626_p
w(15)=3.825702841147600e-12_p
else if(N==16)then
x(1)=-15.83269760939443_p
w(1)=4.284935103613651e-1_p
x(2)=-15.12600732116244_p
w(2)=9.804292813346491e-1_p
x(3)=-13.88516065554352_p
w(3)=1.492619987251784_p
x(4)=-12.16184702617128_p
w(4)=1.941565083714847_p
x(5)=-10.03071723270587_p
w(5)=2.304234391678762_p
x(6)=-7.590400572279409_p
w(6)=2.553757207637523_p
x(7)=-4.970728888260616_p
w(7)=2.635803798004752_p
x(8)=-2.355423005330227_p
w(8)=2.318024770014550_p
x(9)=9.096134526264743e-2_p
w(9)=1.151541682491467_p
x(10)=2.673327616514427_p
w(10)=1.829614614804606e-1_p
x(11)=5.807038264527584_p
w(11)=1.026957120903424e-2_p
x(12)=9.510836385567659_p
w(12)=2.945521433552645e-4_p
x(13)=13.76243167382115_p
w(13)=4.770607107461993e-6_p
x(14)=18.54542223732396_p
w(14)=4.434109314579853e-8_p
x(15)=23.70676898328529_p
w(15)=2.626130568263922e-10_p
x(16)=28.40591945813239_p
w(16)=1.711691866584476e-12_p
else if(N==17)then
x(1)=-15.84826679097742_p
w(1)=3.887037745875933e-1_p
x(2)=-15.2065902745423_p
w(2)=8.910896840470193e-1_p
x(3)=-14.07682692199801_p
w(3)=1.361453531295125_p
x(4)=-12.50072650533801_p
w(4)=1.780685873518155_p
x(5)=-10.53864639668252_p
w(5)=2.130218517991202_p
x(6)=-8.270054195063777_p
w(6)=2.389400986895145_p
x(7)=-5.797655118629399_p
w(7)=2.524169006567166_p
x(8)=-3.262702180210177_p
w(8)=2.411994798097138_p
x(9)=-8.449306225148778e-1_p
w(9)=1.631807185898211_p
x(10)=1.525640295418110_p
w(10)=4.475136505106116e-1_p
x(11)=4.285505943333408_p
w(11)=4.108624500661710e-2_p
x(12)=7.562839494861511_p
w(12)=1.827552752009146e-3_p
x(13)=11.31607661671129_p
w(13)=4.849314157275394e-5_p
x(14)=15.51952564697402_p
w(14)=8.034183716101420e-7_p
x(15)=20.10999845479597_p
w(15)=8.732990280178573e-9_p
x(16)=24.83283134863652_p
w(16)=7.522179440476663e-11_p
x(17)=28.7816536051003_p
w(17)=9.260488464320164e-13_p
else
call GD(-16)
end if
end subroutine GF_m16

! [-15kT;30kT]
subroutine GF_m15(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-11.60756997360961_p
w(1)=8.010480027395472_p
x(2)=-2.557094432125229_p
w(2)=6.989520278506709_p
else if(N==3)then
x(1)=-13.08170712899073_p
w(1)=4.723446652873447_p
x(2)=-6.541749673724104_p
w(2)=7.396058999319299_p
x(3)=-2.364727630272400e-1_p
w(3)=2.880494653709433_p
else if(N==4)then
x(1)=-13.74325971805242_p
w(1)=3.145856453734280_p
x(2)=-9.049689815522935_p
w(2)=5.837742636209535_p
x(3)=-3.109009557432346_p
w(3)=5.206260948650809_p
x(4)=1.722327153073603_p
w(4)=8.101402673075561e-1_p
else if(N==5)then
x(1)=-14.09703420382426_p
w(1)=2.278835857774667_p
x(2)=-10.57187271277046_p
w(2)=4.569443276131304_p
x(3)=-5.495873761293192_p
w(3)=5.228388007950590_p
x(4)=-7.674558530378146e-1_p
w(4)=2.806612556706955_p
x(5)=3.991074062035576_p
w(5)=1.167206073386637e-1_p
else if(N==6)then
x(1)=-14.30985859801154_p
w(1)=1.749856176867583_p
x(2)=-11.54722780846006_p
w(2)=3.661725051162676_p
x(3)=-7.294931834420429_p
w(3)=4.647658093431417_p
x(4)=-2.712694905366536_p
w(4)=3.986918425323752_p
x(5)=1.190135339046017_p
w(5)=9.442478970214229e-1_p
x(6)=6.644992603738861_p
w(6)=9.594662095329144e-3_p
else if(N==7)then
x(1)=-14.44896124236366_p
w(1)=1.401235562254186_p
x(2)=-12.20850078144725_p
w(2)=3.010069386525431_p
x(3)=-8.620658183667185_p
w(3)=4.044524357797790_p
x(4)=-4.410882728380970_p
w(4)=4.145668744199956_p
x(5)=-5.647344610626824e-1_p
w(5)=2.233229800823954_p
x(6)=3.327184491268798_p
w(6)=1.646989517430923e-1_p
x(7)=9.556462955569984_p
w(7)=5.735025577704973e-4_p
else if(N==8)then
x(1)=-14.54562940594606_p
w(1)=1.157669989744116_p
x(2)=-12.67890966943965_p
w(2)=2.530327701204312_p
x(3)=-9.611729081764446_p
w(3)=3.523682941613829_p
x(4)=-5.825220716811942_p
w(4)=3.920756744887407_p
x(5)=-2.028098778935641_p
w(5)=3.115357194505122_p
x(6)=1.353062833849261_p
w(6)=7.355123926573137e-1_p
x(7)=5.785947226651979_p
w(7)=1.666497181969180e-2_p
x(8)=12.63288614482857_p
w(8)=2.836947038965246e-5_p
else if(N==9)then
x(1)=-14.61613195011921_p
w(1)=9.793809834426125e-1_p
x(2)=-13.02750469804914_p
w(2)=2.166721352618161_p
x(3)=-10.37047663479342_p
w(3)=3.091417525273317_p
x(4)=-6.979738122863997_p
w(4)=3.606085239758105_p
x(5)=-3.348684052159942_p
w(5)=3.413623389332265_p
x(6)=-6.490989924109589e-2_p
w(6)=1.613746527800090_p
x(7)=3.451002570550278_p
w(7)=1.277727042403424e-1_p
x(8)=8.469286695301843_p
w(8)=1.251329199115217e-3_p
x(9)=15.80629214702742_p
w(9)=1.254238173473871e-6_p
else if(N==10)then
x(1)=-14.66976096421435_p
w(1)=8.434030455409606e-1_p
x(2)=-13.29573696572318_p
w(2)=1.882476705044556_p
x(3)=-10.96784241350311_p
w(3)=2.732990860665787_p
x(4)=-7.927399991719542_p
w(4)=3.288743575881537_p
x(5)=-4.527390808884816_p
w(5)=3.388151162530464_p
x(6)=-1.264935586640126_p
w(6)=2.376630930967452_p
x(7)=1.806892750754828_p
w(7)=4.733565212918780e-1_p
x(8)=5.796235411133126_p
w(8)=1.416574378023289e-2_p
x(9)=11.26257934584521_p
w(9)=8.170504265133538e-5_p
x(10)=18.96498100775219_p
w(10)=5.515666098011364e-8_p
else if(N==11)then
x(1)=-14.71215754614299_p
w(1)=7.356892381525740e-1_p
x(2)=-13.50964321328184_p
w(2)=1.653121162640853_p
x(3)=-11.45241498593256_p
w(3)=2.431485449971808_p
x(4)=-8.719122512228218_p
w(4)=2.991702212387033_p
x(5)=-5.569758971792454_p
w(5)=3.233153204665212_p
x(6)=-2.377959242589115_p
w(6)=2.797801555373530_p
x(7)=5.339849504547938e-1_p
w(7)=1.075324149301664_p
x(8)=3.841101251218832_p
w(8)=8.041596732994692e-2_p
x(9)=8.260408064556543_p
w(9)=1.302047430479165e-3_p
x(10)=14.03453179914207_p
w(10)=5.315694480441861e-6_p
x(11)=21.88287257612967_p
w(11)=2.954598495317527e-9_p
else if(N==12)then
x(1)=-14.74671238056253_p
w(1)=6.477602965001126e-1_p
x(2)=-13.68517525070102_p
w(2)=1.463199234289779_p
x(3)=-11.85532557685086_p
w(3)=2.173958699773688_p
x(4)=-9.392067488995771_p
w(4)=2.719903343261453_p
x(5)=-6.491225950162869_p
w(5)=3.032055314993833_p
x(6)=-3.429096714911540_p
w(6)=2.925521590903893_p
x(7)=-5.589568997048139e-1_p
w(7)=1.741225883295155_p
x(8)=2.321271372546282_p
w(8)=2.859807103223524e-1_p
x(9)=6.006005091143257_p
w(9)=1.027756400210953e-2_p
x(10)=10.71140955113401_p
w(10)=1.172722782560108e-4_p
x(11)=16.64098691424844_p
w(11)=3.960350880219245e-7_p
x(12)=24.28102088552252_p
w(12)=2.464603546491754e-10_p
else if(N==13)then
x(1)=-14.77542060744972_p
w(1)=5.746175808662073e-1_p
x(2)=-13.83179635187858_p
w(2)=1.303427660447498_p
x(3)=-12.19537414282638_p
w(3)=1.952112897656281_p
x(4)=-9.969702739209886_p
w(4)=2.474199291263906_p
x(5)=-7.304917364495007_p
w(5)=2.819493304756937_p
x(6)=-4.408373915031733_p
w(6)=2.886665594545883_p
x(7)=-1.574248634583164_p
w(7)=2.240134953902742_p
x(8)=1.089565480707594_p
w(8)=6.968262275925378e-1_p
x(9)=4.220756327623320_p
w(9)=5.129192389744561e-2_p
x(10)=8.190785448963275_p
w(10)=1.219366869046808e-3_p
x(11)=13.05404660661894_p
w(11)=1.146652673523072e-5_p
x(12)=18.97262070304644_p
w(12)=3.754084280364643e-8_p
x(13)=26.03079400565164_p
w(13)=3.611799350144813e-11_p
else if(N==14)then
x(1)=-14.79955151201288_p
w(1)=5.130754165411229e-1_p
x(2)=-13.95557358070852_p
w(2)=1.167785655361025_p
x(3)=-12.4848150560063_p
w(3)=1.760253005260315_p
x(4)=-10.4679202154834_p
w(4)=2.254049578471832_p
x(5)=-8.021769358875309_p
w(5)=2.611243814456581_p
x(6)=-5.305182111648317_p
w(6)=2.770453062712110_p
x(7)=-2.543771395733453_p
w(7)=2.492515966029523_p
x(8)=3.741238157260259e-2_p
w(8)=1.243861283458616_p
x(9)=2.771726596813807_p
w(9)=1.788083737557801e-1_p
x(10)=6.179243497283629_p
w(10)=7.803900940431909e-3_p
x(11)=10.3185477951859_p
w(11)=1.489480428240938e-4_p
x(12)=15.22805634380728_p
w(12)=1.296082992465276e-6_p
x(13)=20.9753215960593_p
w(13)=4.780206095188916e-9_p
x(14)=27.21216560848045_p
w(14)=8.820430887592498e-12_p
else if(N==15)then
x(1)=-14.82001659554552_p
w(1)=4.608399539999994e-1_p
x(2)=-14.06091603196051_p
w(2)=1.051819582871605_p
x(3)=-12.73278871793682_p
w(3)=1.593795882767877_p
x(4)=-10.89927848100179_p
w(4)=2.057843445601990_p
x(5)=-8.652630030784335_p
w(5)=2.414548120473955_p
x(6)=-6.116786915343141_p
w(6)=2.623077105662779_p
x(7)=-3.463131895026415_p
w(7)=2.556915690276669_p
x(8)=-9.175344606060168e-1_p
w(8)=1.749841081008453_p
x(9)=1.573016120404432_p
w(9)=4.551657803283063e-1_p
x(10)=4.530168337873175_p
w(10)=3.497747165723670e-2_p
x(11)=8.124346001545218_p
w(11)=1.156205933074550e-3_p
x(12)=12.34088679190857_p
w(12)=1.980860539726330e-5_p
x(13)=17.19759733049449_p
w(13)=1.758836046071725e-7_p
x(14)=22.64027086586952_p
w(14)=8.280763909316390e-10_p
x(15)=27.98841408050369_p
w(15)=3.157679602495598e-12_p
else if(N==16)then
x(1)=-14.83751293177205_p
w(1)=4.161521516325389e-1_p
x(2)=-14.15123679550331_p
w(2)=9.520203889736619e-1_p
x(3)=-12.94655801908316_p
w(3)=1.448836525108304_p
x(4)=-11.27431552179048_p
w(4)=1.883357134917330_p
x(5)=-9.208216151378776_p
w(5)=2.232333607151418_p
x(6)=-6.846542668257601_p
w(6)=2.466604546639450_p
x(7)=-4.321444838788628_p
w(7)=2.516082210740664_p
x(8)=-1.819731203848070_p
w(8)=2.084889884285988_p
x(9)=5.505861458704069e-1_p
w(9)=8.761144923224214e-1_p
x(10)=3.156724055134454_p
w(10)=1.172136770079427e-1_p
x(11)=6.311966754046875_p
w(11)=6.214325901587125e-3_p
x(12)=10.00732130745646_p
w(12)=1.783617922901684e-4_p
x(13)=14.22606782476346_p
w(13)=2.970005729741520e-6_p
x(14)=18.9450526336406_p
w(14)=2.922943033935943e-8_p
x(15)=23.99037848999849_p
w(15)=1.919524146969642e-10_p
x(16)=28.50239890162582_p
w(16)=1.470952069072596e-12_p
else if(N==17)then
x(1)=-14.85258353531191_p
w(1)=3.776386043464140e-1_p
x(2)=-14.22922154740112_p
w(2)=8.655870543956817e-1_p
x(3)=-13.13196023457027_p
w(3)=1.322067913115055_p
x(4)=-11.60186103373206_p
w(4)=1.728197697924574_p
x(5)=-9.698481874448856_p
w(5)=2.065321519843038_p
x(6)=-7.500823823420951_p
w(6)=2.311550151046607_p
x(7)=-5.112784739970333_p
w(7)=2.424791360479257_p
x(8)=-2.680168627373036_p
w(8)=2.239580207680443_p
x(9)=-3.619078261565128e-1_p
w(9)=1.336256677114260_p
x(10)=1.998497954584917_p
w(10)=3.027341334832155e-1_p
x(11)=4.787268601299442_p
w(11)=2.514303763877541e-2_p
x(12)=8.065862505017961_p
w(12)=1.101689527434691e-3_p
x(13)=11.79661584793022_p
w(13)=2.974024275987559e-5_p
x(14)=15.95460600960395_p
w(14)=5.130284788563388e-7_p
x(15)=20.46823377318677_p
w(15)=5.977836672929840e-9_p
x(16)=25.0673363149905_p
w(16)=5.753114191847663e-11_p
x(17)=28.8511921232702_p
w(17)=8.184017872914049e-13_p
else
call GD(-15)
end if
end subroutine GF_m15

! [-14kT;30kT]
subroutine GF_m14(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.80652726713428_p
w(1)=7.538498986167001_p
x(2)=-2.304430752347808_p
w(2)=6.461501845361279_p
else if(N==3)then
x(1)=-12.18399784001079_p
w(1)=4.470876818967738_p
x(2)=-6.001285055704397_p
w(2)=6.968250847659204_p
x(3)=-2.478265040080565e-2_p
w(3)=2.560873164901338_p
else if(N==4)then
x(1)=-12.80448621543236_p
w(1)=2.992233756326454_p
x(2)=-8.343342107631695_p
w(2)=5.541917092606293_p
x(3)=-2.724817291359444_p
w(3)=4.809655173357426_p
x(4)=1.984897288736443_p
w(4)=6.561948092381070e-1_p
else if(N==5)then
x(1)=-13.13751696094859_p
w(1)=2.176445502639877_p
x(2)=-9.772564581910425_p
w(2)=4.358553304889778_p
x(3)=-4.942237425085844_p
w(3)=4.940451973040727_p
x(4)=-4.573485625889147e-1_p
w(4)=2.440389395226744_p
x(5)=4.339915986369394_p
w(5)=8.416065573115321e-2_p
else if(N==6)then
x(1)=-13.33854626771138_p
w(1)=1.676968373032351_p
x(2)=-10.69215990094283_p
w(2)=3.505727495204447_p
x(3)=-6.627078900411189_p
w(3)=4.430118455265039_p
x(4)=-2.279202989061195_p
w(4)=3.645532945038032_p
x(5)=1.522859160753436_p
w(5)=7.352917128858175e-1_p
x(6)=7.065425890230589_p
w(6)=6.361850102593749e-3_p
else if(N==7)then
x(1)=-13.47034791186032_p
w(1)=1.346744870315978_p
x(2)=-11.31782347516166_p
w(2)=2.890650476528815_p
x(3)=-7.876021734602507_p
w(3)=3.873426345874547_p
x(4)=-3.858894299976795_p
w(4)=3.899403926423833_p
x(5)=-1.968339905059322e-1_p
w(5)=1.876355171751898_p
x(6)=3.734453960138201_p
w(6)=1.130607777106546e-1_p
x(7)=10.02955380669376_p
w(7)=3.592629225545212e-4_p
else if(N==8)then
x(1)=-13.56220712759897_p
w(1)=1.115353906076123_p
x(2)=-11.76430767830168_p
w(2)=2.436140145926284_p
x(3)=-8.813778638538128_p
w(3)=3.385771337386887_p
x(4)=-5.184366924187098_p
w(4)=3.734176816798931_p
x(5)=-1.577438854171735_p
w(5)=2.776507637187661_p
x(6)=1.746137310101184_p
w(6)=5.415077105778776e-1_p
x(7)=6.257367798664645_p
w(7)=1.052623087246425e-2_p
x(8)=13.14564585242605_p
w(8)=1.704670205114850e-5_p
else if(N==9)then
x(1)=-13.62940641294131_p
w(1)=9.454541586456272e-1_p
x(2)=-12.09624717802454_p
w(2)=2.090408221904782_p
x(3)=-9.534556574262282_p
w(3)=2.977896916692950_p
x(4)=-6.274020523725151_p
w(4)=3.455712224591666_p
x(5)=-2.809212905772648_p
w(5)=3.161116983670044_p
x(6)=3.417988524308755e-1_p
w(6)=1.285490713295243_p
x(7)=3.910487614573786_p
w(7)=8.316804499714565e-2_p
x(8)=8.983314076884447_p
w(8)=7.528343018838871e-4_p
x(9)=16.34438410659295_p
w(9)=7.334289376763193e-7_p
else if(N==10)then
x(1)=-13.68071140147687_p
w(1)=8.153917921572958e-1_p
x(2)=-12.35264944275053_p
w(2)=1.819015532066665_p
x(3)=-10.10450675489547_p
w(3)=2.637543090715618_p
x(4)=-7.174077231254479_p
w(4)=3.162933472017178_p
x(5)=-3.915179600895831_p
w(5)=3.201652321374816_p
x(6)=-8.106172482664659e-1_p
w(6)=2.027631956016169_p
x(7)=2.248677528873792_p
w(7)=3.271618164558447e-1_p
x(8)=6.303362826147819_p
w(8)=8.622862381398417e-3_p
x(9)=11.79772278777574_p
w(9)=4.795610383262127e-5_p
x(10)=19.49911899389769_p
w(10)=3.223946147478696e-8_p
else if(N==11)then
x(1)=-13.72142796611032_p
w(1)=7.119613347230798e-1_p
x(2)=-12.55794415991315_p
w(2)=1.599098698689356_p
x(3)=-10.56887963796544_p
w(3)=2.349619422109024_p
x(4)=-7.930270725421093_p
w(4)=2.883800842422553_p
x(5)=-4.901918009933155_p
w(5)=3.086354754024267_p
x(6)=-1.860453900314167_p
w(6)=2.514174126261103_p
x(7)=9.693528743733126e-1_p
w(7)=8.038767042464332e-1_p
x(8)=4.332599751976999_p
w(8)=5.034043588485543e-2_p
x(9)=8.787438909486688_p
w(9)=7.713885307819218e-4_p
x(10)=14.56447117036769_p
w(10)=3.122831951650214e-6_p
x(11)=22.3623108557902_p
w(11)=1.804875666597279e-9_p
else if(N==12)then
x(1)=-13.75470469413294_p
w(1)=6.272949792695568e-1_p
x(2)=-12.7268913653589_p
w(2)=1.416440356556339_p
x(3)=-10.95620967503936_p
w(3)=2.102716789717959_p
x(4)=-8.575559047541761_p
w(4)=2.625858473603132_p
x(5)=-5.779996285731610_p
w(5)=2.910029103042981_p
x(6)=-2.850534971635695_p
w(6)=2.716705071254728_p
x(7)=-1.041123428206585e-1_p
w(7)=1.406562549734116_p
x(8)=2.792908429536630_p
w(8)=1.881519414913899e-1_p
x(9)=6.522752800517630_p
w(9)=6.172031928043209e-3_p
x(10)=11.23621474880708_p
w(10)=6.929619323193758e-5_p
x(11)=17.14019134263235_p
w(11)=2.385731856340808e-7_p
x(12)=24.66128117348711_p
w(12)=1.636174091985117e-10_p
else if(N==13)then
x(1)=-13.7823896228269_p
w(1)=5.567667196796644e-1_p
x(2)=-12.86822087848049_p
w(2)=1.262532566334778_p
x(3)=-11.28366035977903_p
w(3)=1.889545160845460_p
x(4)=-9.130692143329430_p
w(4)=2.391417235289454_p
x(5)=-6.558483107093621_p
w(5)=2.714618022657450_p
x(6)=-3.777445968256389_p
w(6)=2.729841140412549_p
x(7)=-1.076493167768983_p
w(7)=1.931327978309385_p
x(8)=1.547367709717319_p
w(8)=4.917644336676439e-1_p
x(9)=4.725522731345223_p
w(9)=3.145664900714423e-2_p
x(10)=8.712148197326727_p
w(10)=7.240331022970567e-4_p
x(11)=13.56078068052281_p
w(11)=6.868613414022821e-6_p
x(12)=19.42344035263849_p
w(12)=2.358276459594783e-8_p
x(13)=26.30494549440365_p
w(13)=2.627523078210933e-11_p
else if(N==14)then
x(1)=-13.80567816038493_p
w(1)=4.973781804850479e-1_p
x(2)=-12.98763000689266_p
w(2)=1.131747527245040_p
x(3)=-11.56265418854249_p
w(3)=1.704930494883482_p
x(4)=-9.610161014903122_p
w(4)=2.180670137688930_p
x(5)=-7.246058048731546_p
w(5)=2.519344211870596_p
x(6)=-4.630694022098882_p
w(6)=2.645612574150442_p
x(7)=-1.993711230822405_p
w(7)=2.252441982119014_p
x(8)=4.995975420840603e-1_p
w(8)=9.494294660878934e-1_p
x(9)=3.262385634044980_p
w(9)=1.136930313870726e-1_p
x(10)=6.697280894384497_p
w(10)=4.663580009652685e-3_p
x(11)=10.83096221409576_p
w(11)=8.884650815867558e-5_p
x(12)=15.70555732012421_p
w(12)=7.959264602098144e-7_p
x(13)=21.36871198457522_p
w(13)=3.159565632435562e-9_p
x(14)=27.40143938023668_p
w(14)=6.924338003603451e-12_p
else if(N==15)then
x(1)=-13.82544097230872_p
w(1)=4.469391121088500e-1_p
x(2)=-13.08932284946076_p
w(2)=1.019850386148405_p
x(3)=-11.80186751045569_p
w(3)=1.544583722091086_p
x(4)=-10.02573611458104_p
w(4)=1.992409076148435_p
x(5)=-7.852277773423559_p
w(5)=2.333029918184173_p
x(6)=-5.406028013057639_p
w(6)=2.518545083212368_p
x(7)=-2.862997256625105_p
w(7)=2.379392460554676_p
x(8)=-4.287759166926551e-1_p
w(8)=1.437159083158960_p
x(9)=2.050915447828648_p
w(9)=3.062265735948043e-1_p
x(10)=5.042913960953564_p
w(10)=2.116533137447626e-2_p
x(11)=8.640972629390109_p
w(11)=6.879793648057830e-4_p
x(12)=12.8346631788841_p
w(12)=1.199341400275466e-5_p
x(13)=17.63818062799331_p
w(13)=1.115932904929344e-7_p
x(14)=22.97433397585512_p
w(14)=5.773263448999118e-10_p
x(15)=28.11883701044168_p
w(15)=2.620250663490206e-12_p
else if(N==16)then
x(1)=-13.84234676134517_p
w(1)=4.037625546681252e-1_p
x(2)=-13.1765691947812_p
w(2)=9.234862511933555e-1_p
x(3)=-12.00823538709497_p
w(3)=1.404811175956694_p
x(4)=-10.38739382156061_p
w(4)=1.824687316863013_p
x(5)=-8.386958238645255_p
w(5)=2.159399820227875_p
x(6)=-6.105295940079935_p
w(6)=2.376073290093795_p
x(7)=-3.677808412323777_p
w(7)=2.380877010655113_p
x(8)=-1.289618094400873_p
w(8)=1.816878025474539_p
x(9)=1.025465110449452_p
w(9)=6.334988405233437e-1_p
x(10)=3.661137979162820_p
w(10)=7.271730915454452e-2_p
x(11)=6.830748217992729_p
w(11)=3.700446199749984e-3_p
x(12)=10.51261138525548_p
w(12)=1.069322833238605e-4_p
x(13)=14.69408967548051_p
w(13)=1.838842168454888e-6_p
x(14)=19.34422772896024_p
w(14)=1.925055555553750e-8_p
x(15)=24.26864901358354_p
w(15)=1.408150858118077e-10_p
x(16)=28.59408725743456_p
w(16)=1.268561651622442e-12_p
else if(N==17)then
x(1)=-13.8569167449915_p
w(1)=3.665305665143751e-1_p
x(2)=-13.25194392163007_p
w(2)=8.399742618730689e-1_p
x(3)=-12.18733892969717_p
w(3)=1.282473798187047_p
x(4)=-10.70352106731137_p
w(4)=1.675326148242564_p
x(5)=-8.859358528665881_p
w(5)=1.999633251583004_p
x(6)=-6.733681017902645_p
w(6)=2.231471742573463_p
x(7)=-4.432342081713736_p
w(7)=2.316110093009704_p
x(8)=-2.104869658204613_p
w(8)=2.034568171595800_p
x(9)=1.267130915650492e-1_p
w(9)=1.042048141950113_p
x(10)=2.493151019704733_p
w(10)=1.961198994209668e-1_p
x(11)=5.305402202029925_p
w(11)=1.507012525434412e-2_p
x(12)=8.579468502111308_p
w(12)=6.561969216261735e-4_p
x(13)=12.28351553928266_p
w(13)=1.810379417386883e-5_p
x(14)=16.39198347029212_p
w(14)=3.264688441991089e-7_p
x(15)=20.82451941374102_p
w(15)=4.094297851600878e-9_p
x(16)=25.29660075815615_p
w(16)=4.416397205975498e-11_p
x(17)=28.91748676299044_p
w(17)=7.249082659972882e-13_p
else
call GD(-14)
end if
end subroutine GF_m14

! [-13kT;30kT]
subroutine GF_m13(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.00429020226805_p
w(1)=7.068991849038227_p
x(2)=-2.046000738658235_p
w(2)=5.931010411288532_p
else if(N==3)then
x(1)=-11.28554791070526_p
w(1)=4.220016810921786_p
x(2)=-5.458790526601783_p
w(2)=6.536163415936136_p
x(3)=2.003952427750062e-1_p
w(3)=2.243822033468836_p
else if(N==4)then
x(1)=-11.86528124872804_p
w(1)=2.839636142856032_p
x(2)=-7.635514086105605_p
w(2)=5.245844525997030_p
x(3)=-2.338699954299779_p
w(3)=4.396806513320269_p
x(4)=2.270582632127310_p
w(4)=5.177150781534274e-1_p
else if(N==5)then
x(1)=-12.17775142131569_p
w(1)=2.074650494282364_p
x(2)=-8.972331173544141_p
w(2)=4.147940889257332_p
x(3)=-4.388784233082940_p
w(3)=4.641274768374927_p
x(4)=-1.359856164077179e-1_p
w(4)=2.077126067046954_p
x(5)=4.714325925690138_p
w(5)=5.901004136518094e-2_p
else if(N==6)then
x(1)=-12.36709336766716_p
w(1)=1.604417256587785_p
x(2)=-9.836562750923616_p
w(2)=3.349940433575558_p
x(3)=-5.959323465924265_p
w(3)=4.208079938014012_p
x(4)=-1.846224864485961_p
w(4)=3.279965702281416_p
x(5)=1.880335366846795_p
w(5)=5.534826857252652e-1_p
x(6)=7.509371950421902_p
w(6)=4.116244142723445e-3_p
else if(N==7)then
x(1)=-12.49165903044596_p
w(1)=1.292432936812127_p
x(2)=-10.42687665201231_p
w(2)=2.771311014121086_p
x(3)=-7.131525982583645_p
w(3)=3.700234967223175_p
x(4)=-3.310021367491959_p
w(4)=3.632018324138173_p
x(5)=1.834359006037758e-1_p
w(5)=1.528633266167417_p
x(6)=4.169025737092856_p
w(6)=7.515158560084817e-2_p
x(7)=10.52410671896727_p
w(7)=2.201662639325771e-4_p
else if(N==8)then
x(1)=-12.57875156628831_p
w(1)=1.073113126304228_p
x(2)=-10.84961360880328_p
w(2)=2.341914100735996_p
x(3)=-8.016096870608525_p
w(3)=3.246616812564318_p
x(4)=-4.546192986498311_p
w(4)=3.536144257713554_p
x(5)=-1.127157009205411_p
w(5)=2.412906311890837_p
x(6)=2.166044548944924_p
w(6)=3.828157418854903e-1_p
x(7)=6.752527856266411_p
w(7)=6.481866823385068e-3_p
x(8)=13.67781859444458_p
w(8)=1.004240895039661e-5_p
else if(N==9)then
x(1)=-12.64267989794451_p
w(1)=9.115229044715217e-1_p
x(2)=-11.16503980402867_p
w(2)=2.013944312726434_p
x(3)=-8.699077918086104_p
w(3)=2.863443835649830_p
x(4)=-5.570529196211506_p
w(4)=3.299178739179469_p
x(5)=-2.275285154700033_p
w(5)=2.876352808639424_p
x(6)=7.653852382360985e-1_p
w(6)=9.827125025655351e-1_p
x(7)=4.396605475898948_p
w(7)=5.240314740687662e-2_p
x(8)=9.517340613429722_p
w(8)=4.435877405937875e-4_p
x(9)=16.89822227716313_p
w(9)=4.219470744458762e-7_p
else if(N==10)then
x(1)=-12.69168627061645_p
w(1)=7.873130421397783e-1_p
x(2)=-11.40972736364123_p
w(2)=1.755304318620196_p
x(3)=-9.241785086642816_p
w(3)=2.541271979071672_p
x(4)=-6.422783257973320_p
w(4)=3.033434867109086_p
x(5)=-3.308910648564775_p
w(5)=2.992589568308437_p
x(6)=-3.528782115712421e-1_p
w(6)=1.668117715674416_p
x(7)=2.717680549282419_p
w(7)=2.168135166080390e-1_p
x(8)=6.831422990410331_p
w(8)=5.129534729283336e-3_p
x(9)=12.34808262543837_p
w(9)=2.769939103265268e-5_p
x(10)=20.04083621119458_p
w(10)=1.867481846865397e-8_p
else if(N==11)then
x(1)=-12.73073559611188_p
w(1)=6.881345138111727e-1_p
x(2)=-11.60646618894322_p
w(2)=1.544782777978751_p
x(3)=-9.686026787813001_p
w(3)=2.267013820393654_p
x(4)=-7.143259872685894_p
w(4)=2.773456300660603_p
x(5)=-4.239090379851072_p
w(5)=2.926267573093485_p
x(6)=-1.348156899007400_p
w(6)=2.196072215736142_p
x(7)=1.426025060609114_p
w(7)=5.731963818535960e-1_p
x(8)=4.847141372529745_p
w(8)=3.062746383781503e-2_p
x(9)=9.330017201928678_p
w(9)=4.493963255918505e-4_p
x(10)=15.10370494917752_p
w(10)=1.815532257047506e-6_p
x(11)=22.83771876347905_p
w(11)=1.103689896221107e-9_p
else if(N==12)then
x(1)=-12.7627347833334_p
w(1)=6.067301250715549e-1_p
x(2)=-11.76882464359632_p
w(2)=1.369404234725170_p
x(3)=-10.05772619774516_p
w(3)=2.030848468257676_p
x(4)=-7.760613457141336_p
w(4)=2.530099881555760_p
x(5)=-5.072691609709119_p
w(5)=2.780305653555408_p
x(6)=-2.279542739502392_p
w(6)=2.474382956558937_p
x(7)=3.607267010074881e-1_p
w(7)=1.085399254154202_p
x(8)=3.289737948360358_p
w(8)=1.191556849182858e-1_p
x(9)=7.056733172039638_p
w(9)=3.635405688762490e-3_p
x(10)=11.77201995211868_p
w(10)=4.045276816499947e-5_p
x(11)=17.64315851673755_p
w(11)=1.429633593350133e-7_p
x(12)=25.0298413747958_p
w(12)=1.094795724448097e-10_p
else if(N==13)then
x(1)=-12.78939218193835_p
w(1)=5.388277241845998e-1_p
x(2)=-11.90483591842561_p
w(2)=1.221397939921682_p
x(3)=-10.37248811555181_p
w(3)=1.826463873459980_p
x(4)=-8.292962545157565_p
w(4)=2.307386102859692_p
x(5)=-5.815071403893652_p
w(5)=2.605097798334865_p
x(6)=-3.153356750604979_p
w(6)=2.549985155270612_p
x(7)=-5.793981366078031e-1_p
w(7)=1.600723640636113_p
x(8)=2.028787523273785_p
w(8)=3.308695608483168e-1_p
x(9)=5.250258720414394_p
w(9)=1.882255196738185e-2_p
x(10)=9.246435030181530_p
w(10)=4.238180086685942e-4_p
x(11)=14.0746997322523_p
w(11)=4.080019295366895e-6_p
x(12)=19.87372501882734_p
w(12)=1.479626230301367e-8_p
x(13)=26.56664182234354_p
w(13)=1.928948978257541e-11_p
else if(N==14)then
x(1)=-12.81183392271789_p
w(1)=4.816045713870926e-1_p
x(2)=-12.01985054070241_p
w(2)=1.095505060115402_p
x(3)=-10.64095250019478_p
w(3)=1.649185210970909_p
x(4)=-8.753455901920589_p
w(4)=2.106345554461929_p
x(5)=-6.472709528049032_p
w(5)=2.424469288964781_p
x(6)=-3.961652147899401_p
w(6)=2.506698733111736_p
x(7)=-1.449984863410956_p
w(7)=1.975280751833442_p
x(8)=9.778438635491781e-1_p
w(8)=6.882168153564859e-1_p
x(9)=3.775943491527922_p
w(9)=6.990375012947742e-2_p
x(10)=7.230395044590134_p
w(10)=2.739601763406704e-3_p
x(11)=11.35285950027667_p
w(11)=5.243389732410336e-5_p
x(12)=16.18697324384457_p
w(12)=4.862376013707458e-7_p
x(13)=21.75861781424276_p
w(13)=2.091696311576067e-9_p
x(14)=27.58093155337088_p
w(14)=5.475949514142271e-12_p
else if(N==15)then
x(1)=-12.83089081518565_p
w(1)=4.329715584161136e-1_p
x(2)=-12.11787227505424_p
w(2)=9.877050986795662e-1_p
x(3)=-10.87134001092891_p
w(3)=1.495017878673530_p
x(4)=-9.153075512488096_p
w(4)=1.926234730111206_p
x(5)=-7.053817603612522_p
w(5)=2.249487386088069_p
x(6)=-4.699496295864051_p
w(6)=2.405542000086072_p
x(7)=-2.270424068792610_p
w(7)=2.169112898463501_p
x(8)=6.550816837629490e-2_p
w(8)=1.123988090956731_p
x(9)=2.552561059192742_p
w(9)=1.969986198044025e-1_p
x(10)=5.573329039997970_p
w(10)=1.253255807119595e-2_p
x(11)=9.169019336375468_p
w(11)=4.041640875023384e-4_p
x(12)=13.33497597928907_p
w(12)=7.205862221381477e-6_p
x(13)=18.07995873618228_p
w(13)=7.062065709678727e-8_p
x(14)=23.30329165424861_p
w(14)=4.038055638636552e-10_p
x(15)=28.24243355134212_p
w(15)=2.185488399904102e-12_p
else if(N==16)then
x(1)=-12.84720307230536_p
w(1)=3.913141382387428e-1_p
x(2)=-12.20202675007942_p
w(2)=8.947987208359028e-1_p
x(3)=-11.07025423179494_p
w(3)=1.360485507084236_p
x(4)=-9.501221055876544_p
w(4)=1.765421950340432_p
x(5)=-7.567249479347366_p
w(5)=2.085013704373086_p
x(6)=-5.367358006831093_p
w(6)=2.280288739029896_p
x(7)=-3.040935621524522_p
w(7)=2.222947568189362_p
x(8)=-7.623321960103306e-1_p
w(8)=1.519423706046426_p
x(9)=1.520151891815291_p
w(9)=4.342661989937501e-1_p
x(10)=4.186116776836441_p
w(10)=4.380751009320528e-2_p
x(11)=7.362939470729516_p
w(11)=2.169880780531149e-3_p
x(12)=11.02639118481671_p
w(12)=6.349095630503100e-5_p
x(13)=15.16612482051331_p
w(13)=1.132588463613882e-6_p
x(14)=19.74251431498867_p
w(14)=1.267162237297202e-8_p
x(15)=24.54130987975731_p
w(15)=1.036997022906154e-10_p
x(16)=28.6811743687315_p
w(16)=1.097702675403849e-12_p
else if(N==17)then
x(1)=-12.86126992862127_p
w(1)=3.553703265691963e-1_p
x(2)=-12.27477692003572_p
w(2)=8.142267698592439e-1_p
x(3)=-11.24301638114389_p
w(3)=1.242621677080944_p
x(4)=-9.805824830131296_p
w(4)=1.621964857020878_p
x(5)=-8.021526742378901_p
w(5)=1.932856439838320_p
x(6)=-5.969176173163931_p
w(6)=2.147980723974532_p
x(7)=-3.757414549241767_p
w(7)=2.192993906815840_p
x(8)=-1.536332806283964_p
w(8)=1.791940544045417_p
x(9)=6.266786265361406e-1_p
w(9)=7.687543032633735e-1_p
x(10)=3.010342647634261_p
w(10)=1.220350330205452e-1_p
x(11)=5.839266179125192_p
w(11)=8.860188751270733e-3_p
x(12)=9.103306347857188_p
w(12)=3.863385992398519e-4_p
x(13)=12.7764535398037_p
w(13)=1.094154799028621e-5_p
x(14)=16.83128982348126_p
w(14)=2.070985802792257e-7_p
x(15)=21.17849563532475_p
w(15)=2.806713675640050e-9_p
x(16)=25.52049038647323_p
w(16)=3.403149548893270e-11_p
x(17)=28.98067047820836_p
w(17)=6.434572652617825e-13_p
else
call GD(-13)
end if
end subroutine GF_m13

! [-12kT;30kT]
subroutine GF_m12(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-9.200741236103321_p
w(1)=6.602046581447386_p
x(2)=-1.780566058592697_p
w(2)=5.397959562745998_p
else if(N==3)then
x(1)=-10.38632282752091_p
w(1)=3.970896360907764_p
x(2)=-4.914383631816433_p
w(2)=6.097468871607230_p
x(3)=4.416798817603066e-1_p
w(3)=1.931640911678390_p
else if(N==4)then
x(1)=-10.92564495919517_p
w(1)=2.688039020804280_p
x(2)=-6.926375234631146_p
w(2)=4.948533288856562_p
x(3)=-1.949879044657114_p
w(3)=3.966938464852134_p
x(4)=2.582281792242629_p
w(4)=3.964953696804078e-1_p
else if(N==5)then
x(1)=-11.21775017744934_p
w(1)=1.973405759796467_p
x(2)=-8.171320720590078_p
w(2)=3.937130829329820_p
x(3)=-3.836134755322004_p
w(3)=4.326414064777375_p
x(4)=2.001102280652502e-1_p
w(4)=1.722881078179963_p
x(5)=5.115867373362192_p
w(5)=4.017441210975926e-2_p
else if(N==6)then
x(1)=-11.39551624513811_p
w(1)=1.532153017998961_p
x(2)=-8.980567508813580_p
w(2)=3.194068635278898_p
x(3)=-5.292299815807398_p
w(3)=3.978902551092034_p
x(4)=-1.412415181758850_p
w(4)=2.891008682209279_p
x(5)=2.265803664049550_p
w(5)=4.012769852592327e-1_p
x(6)=7.977874101519951_p
w(6)=2.596272354980206e-3_p
else if(N==7)then
x(1)=-11.51291153254397_p
w(1)=1.238250944916761_p
x(2)=-9.535777083458942_p
w(2)=2.651836420436813_p
x(3)=-6.387662435255684_p
w(3)=3.523550671132937_p
x(4)=-2.764945091149111_p
w(4)=3.337273024191917_p
x(5)=5.807822145068469e-1_p
w(5)=1.200620302751959_p
x(6)=4.631965229661217_p
w(6)=4.834289495300168e-2_p
x(7)=11.04094035214087_p
w(7)=1.318858099952101e-4_p
else if(N==8)then
x(1)=-11.59527955569056_p
w(1)=1.030900558884207_p
x(2)=-9.934934161206950_p
w(2)=2.247477380380653_p
x(3)=-7.219075566337885_p
w(3)=3.105395578119903_p
x(4)=-3.911791986319449_p
w(4)=3.321200044630448_p
x(5)=-6.741123460903204e-1_p
w(5)=2.031835753962794_p
x(6)=2.615565649466656_p
w(6)=2.593011335768740e-1_p
x(7)=7.271957092960126_p
w(7)=3.889897573694172e-3_p
x(8)=14.22992946183731_p
w(8)=5.797064810517304e-6_p
else if(N==9)then
x(1)=-11.65596915208748_p
w(1)=8.775413093491552e-1_p
x(2)=-10.23398293287939_p
w(2)=1.937181877840092_p
x(3)=-7.864370981568943_p
w(3)=2.747513567679557_p
x(4)=-4.870235247308156_p
w(4)=3.133093828966114_p
x(5)=-1.746541109276897_p
w(5)=2.555396433942038_p
x(6)=1.211092760229191_p
w(6)=7.170396787159755e-1_p
x(7)=4.909640973130745_p
w(7)=3.198327370518827e-2_p
x(8)=10.07156332508088_p
w(8)=2.559351373257676e-4_p
x(9)=17.46755826192441_p
w(9)=2.388579389554828e-7_p
else if(N==10)then
x(1)=-11.70270082576748_p
w(1)=7.591253552971325e-1_p
x(2)=-10.46705955501317_p
w(2)=1.691218675357364_p
x(3)=-8.379951610280465_p
w(3)=2.443793101754917_p
x(4)=-5.674287344867516_p
w(4)=2.898231636088297_p
x(5)=-2.709626625435134_p
w(5)=2.753001871195556_p
x(6)=1.135869686876407e-1_p
w(6)=1.313798975347014_p
x(7)=3.215240739649198_p
w(7)=1.378375377527620e-1_p
x(8)=7.380255968621366_p
w(8)=2.983232128363137e-3_p
x(9)=12.91332338264651_p
w(9)=1.574853808585964e-5_p
x(10)=20.58853908765025_p
w(10)=1.073389214323734e-8_p
else if(N==11)then
x(1)=-11.74009248428946_p
w(1)=6.641759902424005e-1_p
x(2)=-10.65527905558627_p
w(2)=1.490076886491441_p
x(3)=-8.804067298150413_p
w(3)=2.183395273150205_p
x(4)=-6.358662442460703_p
w(4)=2.659444852173218_p
x(5)=-3.582520803942668_p
w(5)=2.746447884701463_p
x(6)=-8.382261941094653e-1_p
w(6)=1.849257530985260_p
x(7)=1.908093144202071_p
w(7)=3.888145650449756e-1_p
x(8)=5.384375189677705_p
w(8)=1.813458993452029e-2_p
x(9)=9.887854324984758_p
w(9)=2.575256436230252e-4_p
x(10)=15.65152900591852_p
w(10)=1.045149509956240e-6_p
x(11)=23.30698259724998_p
w(11)=6.767672671735143e-10_p
else if(N==12)then
x(1)=-11.77081192516678_p
w(1)=5.860403735261186e-1_p
x(2)=-10.81102878095983_p
w(2)=1.322016707765953_p
x(3)=-9.160035978090356_p
w(3)=1.958154842605259_p
x(4)=-6.947656007294190_p
w(4)=2.431851951568837_p
x(5)=-4.370366505191548_p
w(5)=2.638688976011859_p
x(6)=-1.715815494218054_p
w(6)=2.193179297952655_p
x(7)=8.416078384987753e-1_p
w(7)=7.951611431999466e-1_p
x(8)=3.811959937339701_p
w(8)=7.278806006257099e-2_p
x(9)=7.607615801637484_p
w(9)=2.101369103203224e-3_p
x(10)=12.31846125353991_p
w(10)=2.333704658156187e-5_p
x(11)=18.14909366811636_p
w(11)=8.527649202807587e-8_p
x(12)=25.38552029005331_p
w(12)=7.390674252672274e-11_p
else if(N==13)then
x(1)=-11.79643592889585_p
w(1)=5.207796718396583e-1_p
x(2)=-10.94168546085865_p
w(2)=1.179963608411706_p
x(3)=-9.461986974416677_p
w(3)=1.762716884475267_p
x(4)=-7.456844270850947_p
w(4)=2.221586349047037_p
x(5)=-5.075513208132380_p
w(5)=2.488333798249326_p
x(6)=-2.537037994469716_p
w(6)=2.338558083435968_p
x(7)=-7.778328937319012e-2_p
w(7)=1.264462908454265_p
x(8)=2.536143614321593_p
w(8)=2.123539965075686e-1_p
x(9)=5.794459108173494_p
w(9)=1.100378887193534e-2_p
x(10)=9.793353941140953_p
w(10)=2.446414162187027e-4_p
x(11)=14.59536530443683_p
w(11)=2.404192287135653e-6_p
x(12)=20.32272060977242_p
w(12)=9.277853587564526e-9_p
x(13)=26.8156910830921_p
w(13)=1.429317835164674e-11_p
else if(N==14)then
x(1)=-11.81802539361419_p
w(1)=4.657365565329259e-1_p
x(2)=-11.05227280752718_p
w(2)=1.059007483492706_p
x(3)=-9.719818619280794_p
w(3)=1.592895984037594_p
x(4)=-7.898071278475395_p
w(4)=2.030709317522344_p
x(5)=-5.702374052042645_p
w(5)=2.324991762197535_p
x(6)=-3.299265816892505_p
w(6)=2.346647143309695_p
x(7)=-9.100980924414291e-1_p
w(7)=1.664586996182029_p
x(8)=1.477272272988199_p
w(8)=4.721478266973754e-1_p
x(9)=4.312003971537066_p
w(9)=4.166919528427700e-2_p
x(10)=7.778199036945703_p
w(10)=1.582956902720001e-3_p
x(11)=11.88391031943582_p
w(11)=3.062501982911657e-5_p
x(12)=16.67181199700339_p
w(12)=2.956223290663926e-7_p
x(13)=22.14441757790478_p
w(13)=1.387662378499987e-9_p
x(14)=27.75084366614042_p
w(14)=4.361804161999491e-12_p
else if(N==15)then
x(1)=-11.83637189210395_p
w(1)=4.189215378200130e-1_p
x(2)=-11.14659695616471_p
w(2)=9.553402092983942e-1_p
x(3)=-9.941298816866880_p
w(3)=1.444999489537945_p
x(4)=-8.281516196359700_p
w(4)=1.859050674708419_p
x(5)=-6.257763459412825_p
w(5)=2.162867125327675_p
x(6)=-3.998298149379171_p
w(6)=2.279218332723314_p
x(7)=-1.685213367250918_p
w(7)=1.919662822851267_p
x(8)=5.715140759677949e-1_p
w(8)=8.309263379748018e-1_p
x(9)=3.078815040704026_p
w(9)=1.215095225031801e-1_p
x(10)=6.120820963403546_p
w(10)=7.271253392752173e-3_p
x(11)=9.708154227193205_p
w(11)=2.344956282157778e-4_p
x(12)=13.84145263957703_p
w(12)=4.297547297238032e-6_p
x(13)=18.52243882917546_p
w(13)=4.459482981989065e-8_p
x(14)=23.62671223125649_p
w(14)=2.834500595775258e-10_p
x(15)=28.3594490482641_p
w(15)=1.831850224686110e-12_p
else if(N==16)then
x(1)=-11.85208693187898_p
w(1)=3.787930707930730e-1_p
x(2)=-11.22763794996683_p
w(2)=8.659202132235633e-1_p
x(3)=-10.13269417031832_p
w(3)=1.315777499779412_p
x(4)=-8.615980751571808_p
w(4)=1.705355600877087_p
x(5)=-6.749502205541212_p
w(5)=2.008465683368065_p
x(6)=-4.633645070917048_p
w(6)=2.176099069930718_p
x(7)=-2.411734746218491_p
w(7)=2.033391824186169_p
x(8)=-2.331909823478287e-1_p
w(8)=1.206986394239861_p
x(9)=2.038113248615235_p
w(9)=2.822293957352038e-1_p
x(10)=4.730971009630414_p
w(10)=2.569561128300968e-2_p
x(11)=7.908108447666397_p
w(11)=1.253732329555345e-3_p
x(12)=11.54833012279495_p
w(12)=3.734583271497808e-5_p
x(13)=15.64178183876212_p
w(13)=6.941977095765392e-7_p
x(14)=20.13947133490293_p
w(14)=8.339611547406383e-9_p
x(15)=24.80811178375507_p
w(15)=7.667667059536437e-11_p
x(16)=28.76385047366729_p
w(16)=9.528727576527484e-13_p
else if(N==17)then
x(1)=-11.86564755490056_p
w(1)=3.441456909396761e-1_p
x(2)=-11.29774552268405_p
w(2)=7.883118959147706e-1_p
x(3)=-10.29906154245817_p
w(3)=1.202442574955918_p
x(4)=-8.908927610912498_p
w(4)=1.567952876175602_p
x(5)=-7.185322699142288_p
w(5)=1.864493830774445_p
x(6)=-5.208047345769610_p
w(6)=2.059032692785969_p
x(7)=-3.089199270097995_p
w(7)=2.047949492506215_p
x(8)=-9.724714180718057e-1_p
w(8)=1.513017837459797_p
x(9)=1.143790550165094_p
w(9)=5.340990047829057e-1_p
x(10)=3.550000314472636_p
w(10)=7.321248593428248e-2_p
x(11)=6.388232553038253_p
w(11)=5.116142997585648e-3_p
x(12)=9.637022587355531_p
w(12)=2.249185244388424e-4_p
x(13)=13.27509289261756_p
w(13)=6.567484264201423e-6_p
x(14)=17.2721443864219_p
w(14)=1.310043029732462e-7_p
x(15)=21.52980439466704_p
w(15)=1.926313044043463e-9_p
x(16)=25.73888989932475_p
w(16)=2.632538230668430e-11_p
x(17)=29.04087395198984_p
w(17)=5.722836655301385e-13_p
else
call GD(-12)
end if
end subroutine GF_m12

! [-11kT;30kT]
subroutine GF_m11(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-8.395770707567936_p
w(1)=6.137601896942973_p
x(2)=-1.506528839114157_p
w(2)=4.862414804618251_p
else if(N==3)then
x(1)=-9.486303270253453_p
w(1)=3.723465704703212_p
x(2)=-4.368235929102347_p
w(2)=5.649032165102499_p
x(3)=7.022737833792854e-1_p
w(3)=1.627518831755515_p
else if(N==4)then
x(1)=-9.985591074232902_p
w(1)=2.537364192572847_p
x(2)=-6.216211455701315_p
w(2)=4.648374659393034_p
x(3)=-1.556988904816957_p
w(3)=3.520555663547332_p
x(4)=2.923036928430720_p
w(4)=2.937221860480124e-1_p
else if(N==5)then
x(1)=-10.25753678959441_p
w(1)=1.872627157964132_p
x(2)=-7.369768522091887_p
w(2)=3.725328020914680_p
x(3)=-3.284907682730306_p
w(3)=3.990371791974723_p
x(4)=5.551724900869175e-1_p
w(4)=1.385171100392857_p
x(5)=5.546095809428338_p
w(5)=2.651863031483342e-2_p
else if(N==6)then
x(1)=-10.42384004757603_p
w(1)=1.460095973380560_p
x(2)=-8.124369480058689_p
w(2)=3.037630751847590_p
x(3)=-4.626839621879512_p
w(3)=3.738586906821553_p
x(4)=-9.753283446591076e-1_p
w(4)=2.482784668237023_p
x(5)=2.682325278925096_p
w(5)=2.793236929090046e-1_p
x(6)=8.472012441393034_p
w(6)=1.594708365495076e-3_p
else if(N==7)then
x(1)=-10.5341295784853_p
w(1)=1.184126237020579_p
x(2)=-8.644690986188175_p
w(2)=2.531890017976500_p
x(3)=-5.645108169306309_p
w(3)=3.341102378243888_p
x(4)=-2.223892337123724_p
w(4)=3.009245465960113_p
x(5)=1.000510555662115_p
w(5)=9.034916137270309e-1_p
x(6)=5.124197197712114_p
w(6)=3.008382937281236e-2_p
x(7)=11.58090484685481_p
w(7)=7.715926030240075e-5_p
else if(N==8)then
x(1)=-10.61181408970027_p
w(1)=9.886492363190518e-1_p
x(2)=-9.020416106420855_p
w(2)=2.152570044699491_p
x(3)=-6.423255169699005_p
w(3)=2.960751914028402_p
x(4)=-3.282351496880958_p
w(4)=3.081940529554391_p
x(5)=-2.136227892163517e-1_p
w(5)=1.645725926886392_p
x(6)=3.096881697973724_p
w(6)=1.681015700163107e-1_p
x(7)=7.816175665136639_p
w(7)=2.274202692092289e-3_p
x(8)=14.80247400928458_p
w(8)=3.277365093107438e-6_p
else if(N==9)then
x(1)=-10.66929612999477_p
w(1)=8.434468527084553e-1_p
x(2)=-9.303209635869626_p
w(2)=1.859907055765289_p
x(3)=-7.030882090337205_p
w(3)=2.629223259724953_p
x(4)=-4.174354386853849_p
w(4)=2.952210569229761_p
x(5)=-1.221231621053250_p
w(5)=2.199072546889536_p
x(6)=1.683942179376334_p
w(6)=4.970894971766283e-1_p
x(7)=5.449701342984337_p
w(7)=1.892221336555272e-2_p
x(8)=10.64611520854687_p
w(8)=1.445736132047707e-4_p
x(9)=18.05193236705847_p
w(9)=1.330878441167467e-7_p
else if(N==10)then
x(1)=-10.71377430905778_p
w(1)=7.307743906708636e-1_p
x(2)=-9.524759674994693_p
w(2)=1.626585094494275_p
x(3)=-7.519366782804121_p
w(3)=2.344499417627418_p
x(4)=-4.929589964225407_p
w(4)=2.754018301506761_p
x(5)=-2.117813766562496_p
w(5)=2.474998533770876_p
x(6)=5.951858148041506e-1_p
w(6)=9.832529443247180e-1_p
x(7)=3.741985058999453_p
w(7)=8.418237435984059e-2_p
x(8)=7.949662552198607_p
w(8)=1.696822022591635e-3_p
x(9)=13.49300604725174_p
w(9)=8.816652577577547e-6_p
x(10)=21.14031926440305_p
w(10)=6.131303806520965e-9_p
else if(N==11)then
x(1)=-10.74951373613409_p
w(1)=6.400428978893611e-1_p
x(2)=-9.704471467759559_p
w(2)=1.434847306652165_p
x(3)=-7.923276752244402_p
w(3)=2.098337872466809_p
x(4)=-5.577237128091847_p
w(4)=2.539706352306379_p
x(5)=-2.933455288470557_p
w(5)=2.538254643554205_p
x(6)=-3.258499802836910e-1_p
w(6)=1.487493297460972_p
x(7)=2.418632026892170_p
w(7)=2.507259356987518e-1_p
x(8)=5.943875657308315_p
w(8)=1.046259616968927e-2_p
x(9)=10.46063317032009_p
w(9)=1.452028040707125e-4_p
x(10)=16.20716593425974_p
w(10)=5.961419690650100e-7_p
x(11)=23.76793388347_p
w(11)=4.168534281928093e-10_p
else if(N==12)then
x(1)=-10.7789480174517_p
w(1)=5.651917408946818e-1_p
x(2)=-9.853573409702101_p
w(2)=1.274173466154177_p
x(3)=-8.263352160311449_p
w(3)=1.884326679737683_p
x(4)=-6.137260959590216_p
w(4)=2.329793836076320_p
x(5)=-3.674285393046495_p
w(5)=2.478730925503210_p
x(6)=-1.157483027072448_p
w(6)=1.873240473666321_p
x(7)=1.344477097284772_p
w(7)=5.503621952189772e-1_p
x(8)=4.359317106333988_p
w(8)=4.299145193956494e-2_p
x(9)=8.175073118756391_p
w(9)=1.192572665200062e-3_p
x(10)=12.87514446251635_p
w(10)=1.330898638772909e-5_p
x(11)=18.65715612063734_p
w(11)=5.066832182196415e-8_p
x(12)=25.72728900913856_p
w(12)=5.037973740979822e-11_p
else if(N==13)then
x(1)=-10.80353081876573_p
w(1)=5.025940783777977e-1_p
x(2)=-9.978827281414445_p
w(2)=1.138144265108626_p
x(3)=-8.552330043223893_p
w(3)=1.698069042016700_p
x(4)=-6.622787304321372_p
w(4)=2.133133309404035_p
x(5)=-4.340885050398078_p
w(5)=2.360033351232933_p
x(6)=-1.928737607258982_p
w(6)=2.087331074637329_p
x(7)=4.349616357236079e-1_p
w(7)=9.439839871786889e-1_p
x(8)=3.070636397005934_p
w(8)=1.302944964938784e-1_p
x(9)=6.357604313696799_p
w(9)=6.292388568511100e-3_p
x(10)=10.35259798808155_p
w(10)=1.392967995766995e-4_p
x(11)=15.12230451239805_p
w(11)=1.405914646486719e-6_p
x(12)=20.76964922765087_p
w(12)=5.817811028111784e-9_p
x(13)=27.05201906012694_p
w(13)=1.069079220867813e-11_p
else if(N==14)then
x(1)=-10.82426118111066_p
w(1)=4.497495177710974e-1_p
x(2)=-10.08494628059429_p
w(2)=1.022182954257045_p
x(3)=-8.799397526347583_p
w(3)=1.535877566626340_p
x(4)=-7.044369872837067_p
w(4)=1.953142427061795_p
x(5)=-4.935923628602882_p
w(5)=2.218118131129701_p
x(6)=-2.644659398848943_p
w(6)=2.156165814017460_p
x(7)=-3.694360970001483e-1_p
w(7)=1.333436164801297_p
x(8)=2.001940574230306_p
w(8)=3.062849404096771e-1_p
x(9)=4.869928455108324_p
w(9)=2.414120330718079e-2_p
x(10)=8.340311934587753_p
w(10)=9.000944795291515e-4_p
x(11)=12.4237623560513_p
w(11)=1.770782602340626e-5_p
x(12)=17.15955250455426_p
w(12)=1.789475756304805e-7_p
x(13)=22.52549235429946_p
w(13)=9.230039511962187e-10_p
x(14)=27.91142220317321_p
w(14)=3.498737931835070e-12_p
else if(N==15)then
x(1)=-10.84189172039348_p
w(1)=4.047675600365354e-1_p
x(2)=-10.17553972554999_p
w(2)=9.226944009538182e-1_p
x(3)=-9.011867069885209_p
w(3)=1.394379092234831_p
x(4)=-7.411355944601792_p
w(4)=1.790406781774911_p
x(5)=-5.464814695224963_p
w(5)=2.071326463332220_p
x(6)=-3.303712747181350_p
w(6)=2.132206991835046_p
x(7)=-1.105547866901361_p
w(7)=1.630418059190929_p
x(8)=1.095677411293620_p
w(8)=5.774245012205669e-1_p
x(9)=3.629678093516098_p
w(9)=7.211758043125915e-2_p
x(10)=6.684810805369952_p
w(10)=4.138280047973882e-3_p
x(11)=10.25803675719031_p
w(11)=1.344171733221301e-4_p
x(12)=14.3536987057795_p
w(12)=2.545017345898172e-6_p
x(13)=18.96511134299438_p
w(13)=2.811117759797039e-8_p
x(14)=23.94418419985383_p
w(14)=1.997459828110112e-10_p
x(15)=28.47013885138485_p
w(15)=1.542640350788453e-12_p
else if(N==16)then
x(1)=-10.85700493442004_p
w(1)=3.661804982256462e-1_p
x(2)=-10.2534400946718_p
w(2)=8.367979439858065e-1_p
x(3)=-9.195660739285289_p
w(3)=1.270564350841039_p
x(4)=-7.731920838167752_p
w(4)=1.644149910302040_p
x(5)=-5.934280436880009_p
w(5)=1.928506303541340_p
x(6)=-3.905316917805058_p
w(6)=2.058318245644895_p
x(7)=-1.790346769452018_p
w(7)=1.803790597476549_p
x(8)=3.042336334831122e-1_p
w(8)=9.019297359618847e-1_p
x(9)=2.581413907724733_p
w(9)=1.743338418402118e-1_p
x(10)=5.294908048660751_p
w(10)=1.470891583911763e-2_p
x(11)=8.465835370044649_p
w(11)=7.141600637952796e-4_p
x(12)=12.07808416621337_p
w(12)=2.176872173014543e-5_p
x(13)=16.12065279570863_p
w(13)=4.235697828304410e-7_p
x(14)=20.53465360187063_p
w(14)=5.489621285332497e-9_p
x(15)=25.06882959532687_p
w(15)=5.693507674689437e-11_p
x(16)=28.84230524328781_p
w(16)=8.296140181051822e-13_p
else if(N==17)then
x(1)=-10.87005543366875_p
w(1)=3.328400393804439e-1_p
x(2)=-10.32088238782707_p
w(2)=7.621838547366834e-1_p
x(3)=-9.355565579725289_p
w(3)=1.161834050229055_p
x(4)=-8.013038395019459_p
w(4)=1.513028545943735_p
x(5)=-6.351206522930127_p
w(5)=1.793670830033579_p
x(6)=-4.451271099346327_p
w(6)=1.961103925571326_p
x(7)=-2.428724302613277_p
w(7)=1.871302663069977_p
x(8)=-4.089961534655994e-1_p
w(8)=1.209535001505586_p
x(9)=1.682963809865278_p
w(9)=3.489666381085025e-1_p
x(10)=4.111500196729639_p
w(10)=4.251312433136817e-2_p
x(11)=6.951703689658927_p
w(11)=2.904500867807022e-3_p
x(12)=10.18026216747064_p
w(12)=1.295276180451428e-4_p
x(13)=13.77908405904097_p
w(13)=3.916157963089591e-6_p
x(14)=17.71415680189149_p
w(14)=8.266219690475927e-8_p
x(15)=21.87809267589534_p
w(15)=1.324002035000858e-9_p
x(16)=25.95170416632925_p
w(16)=2.044429908291538e-11_p
x(17)=29.09822541458794_p
w(17)=5.099069971146078e-13_p
else
call GD(-11)
end if
end subroutine GF_m11

! [-10kT;30kT]
subroutine GF_m10(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-7.589291604896390_p
w(1)=5.675311882661388_p
x(2)=-1.221802100747070_p
w(2)=4.324733516237735_p
else if(N==3)then
x(1)=-8.585496555657913_p
w(1)=3.477526163814243_p
x(2)=-3.820530666483537_p
w(2)=5.186811694099812_p
x(3)=9.860666936779807e-1_p
w(3)=1.335707540985068_p
else if(N==4)then
x(1)=-9.045154619284544_p
w(1)=2.387438897373280_p
x(2)=-5.505463675035747_p
w(2)=4.342786792228469_p
x(3)=-1.157816393886908_p
w(3)=3.060088912820780_p
x(4)=3.295961794555325_p
w(4)=2.097307964765937e-1_p
else if(N==5)then
x(1)=-9.297151253222260_p
w(1)=1.772164118066356_p
x(2)=-6.568034975192197_p
w(2)=3.511186735852089_p
x(3)=-2.735522121712663_p
w(3)=3.627022372509059_p
x(4)=9.341745866604096e-1_p
w(4)=1.072724419356759_p
x(5)=6.006569681803540_p
w(5)=1.694775311486074e-2_p
else if(N==6)then
x(1)=-9.452102828114645_p
w(1)=1.388116669175856_p
x(2)=-7.268257539104391_p
w(2)=2.879816577115177_p
x(3)=-3.963965870560947_p
w(3)=3.481259320819366_p
x(4)=-5.311006914410022e-1_p
w(4)=2.063682315960888_p
x(5)=3.132635592467245_p
w(5)=1.862176706513180e-1_p
x(6)=8.992916339509934_p
w(6)=9.528451765180658e-4_p
else if(N==7)then
x(1)=-9.555347794349021_p
w(1)=1.129946946315155_p
x(2)=-7.753856721014895_p
w(2)=2.410918583551855_p
x(3)=-4.904777315686662_p
w(3)=3.149199594285201_p
x(4)=-1.686124460044562_p
w(4)=2.644424026374996_p
x(5)=1.448192628055100_p
w(5)=6.474065633149971e-1_p
x(6)=5.646550347043649_p
w(6)=1.810563596851754e-2_p
x(7)=12.14489031726124_p
w(7)=4.404908840157436e-5_p
else if(N==8)then
x(1)=-9.628386963214865_p
w(1)=9.462599603393870e-1_p
x(2)=-8.106264212843479_p
w(2)=2.056777690286312_p
x(3)=-5.629381024369136_p
w(3)=2.810400070452641_p
x(4)=-2.658895068392484_p
w(4)=2.809383662141378_p
x(5)=2.605285869497109e-1_p
w(5)=1.271633045491403_p
x(6)=3.611526390919247_p
w(6)=1.042943541361692e-1_p
x(7)=8.385700098751304_p
w(7)=1.294802308894815e-3_p
x(8)=15.3959031974559_p
w(8)=1.813742938048827e-6_p
else if(N==9)then
x(1)=-9.682690082750476_p
w(1)=8.091504852300785e-1_p
x(2)=-8.372899605186964_p
w(2)=1.781790996251905_p
x(3)=-6.199221166400164_p
w(3)=2.507079171569197_p
x(4)=-3.484296702112390_p
w(4)=2.748784729996897_p
x(5)=-6.956164581912899e-1_p
w(5)=1.815843604314100_p
x(6)=2.188208525817768_p
w(6)=3.264567101896355e-1_p
x(7)=6.016778292227530_p
w(7)=1.085967812919056e-2_p
x(8)=11.24105554497949_p
w(8)=7.995019136035994e-5_p
x(9)=18.65062189394112_p
w(9)=7.302675978357453e-8_p
else if(N==10)then
x(1)=-9.724931581048544_p
w(1)=7.021849106459581e-1_p
x(2)=-8.582976940839986_p
w(2)=1.561144170905948_p
x(3)=-6.660514974227046_p
w(3)=2.242373519954479_p
x(4)=-4.189956548716254_p
w(4)=2.595443698582389_p
x(5)=-1.532699570004841_p
w(5)=2.153964815600726_p
x(6)=1.098790858417563_p
w(6)=6.944965902188176e-1_p
x(7)=4.297975712067506_p
w(7)=4.948860776438199e-2_p
x(8)=8.539413091389171_p
w(8)=9.442193778373293e-4_p
x(9)=14.08658720270769_p
w(9)=4.862361884231658e-6_p
x(10)=21.69394850760639_p
w(10)=3.486702221235815e-9_p
else if(N==11)then
x(1)=-9.759018917008047_p
w(1)=6.156754541969234e-1_p
x(2)=-8.754160059097622_p
w(2)=1.378894086958981_p
x(3)=-7.044026301704623_p
w(3)=2.011130113472078_p
x(4)=-4.799987035771091_p
w(4)=2.410735696664718_p
x(5)=-2.292738164419906_p
w(5)=2.291785830759900_p
x(6)=1.957153526029294e-1_p
w(6)=1.131964411877592_p
x(7)=2.959511959186700_p
w(7)=1.538908967825431e-1_p
x(8)=6.525196877807474_p
w(8)=5.887991245748396e-3_p
x(9)=11.04801320884815_p
w(9)=8.057953630953033e-5_p
x(10)=16.76977043773111_p
w(10)=3.371459622785413e-7_p
x(11)=24.21840732521542_p
w(11)=2.583661695519088e-10_p
else if(N==12)then
x(1)=-9.787158801296027_p
w(1)=5.441356996586620e-1_p
x(2)=-8.896551726619485_p
w(2)=1.225716583134012_p
x(3)=-7.367965647403888_p
w(3)=1.808847337936439_p
x(4)=-5.330210608345867_p
w(4)=2.221615630483269_p
x(5)=-2.985781740437949_p
w(5)=2.291247049330074_p
x(6)=-6.004204101230911e-1_p
w(6)=1.524212115630124_p
x(7)=1.874382840517493_p
w(7)=3.589889948339319e-1_p
x(8)=4.931276941572364_p
w(8)=2.460966472931240e-2_p
x(9)=8.758784707501617_p
w(9)=6.647873414654671e-4_p
x(10)=13.44164702383822_p
w(10)=7.505777537230955e-6_p
x(11)=19.16646316470014_p
w(11)=3.000959314489253e-8_p
x(12)=26.05429417138662_p
w(12)=3.470247636056491e-11_p
else if(N==13)then
x(1)=-9.810690159896136_p
w(1)=4.842298018306720e-1_p
x(2)=-9.016339339510337_p
w(2)=1.095810298400964_p
x(3)=-7.643754804950557_p
w(3)=1.632129577062387_p
x(4)=-5.791413347270534_p
w(4)=2.040460577818120_p
x(5)=-3.612502097144762_p
w(5)=2.213355973627370_p
x(6)=-1.327213458142357_p
w(6)=1.792461685086667_p
x(7)=9.660825170252427e-1_p
w(7)=6.613149019809286e-1_p
x(8)=3.632505386706481_p
w(8)=7.668038474948843e-2_p
x(9)=6.939190205599424_p
w(9)=3.523118015156279e-3_p
x(10)=10.92384716310744_p
w(10)=7.826044328995463e-5_p
x(11)=15.65501213249728_p
w(11)=8.162253547572301e-7_p
x(12)=21.21371566003004_p
w(12)=3.650652736965571e-9_p
x(13)=27.27566406897799_p
w(13)=8.071610511767349e-12_p
else if(N==14)then
x(1)=-9.830552799060470_p
w(1)=4.336078346214658e-1_p
x(2)=-9.117937683526202_p
w(2)=9.849226579404415e-1_p
x(3)=-7.879887756081644_p
w(3)=1.477824920907407_p
x(4)=-6.192854679867777_p
w(4)=1.872546040074383_p
x(5)=-4.174497486905981_p
w(5)=2.099102723190275_p
x(6)=-1.998350728101022_p
w(6)=1.925312612911368_p
x(7)=1.787318777030241e-1_p
w(7)=1.004377671816946_p
x(8)=2.554426133614806_p
w(8)=1.882132986874659e-1_p
x(9)=5.448973971605505_p
w(9)=1.362349202034904e-2_p
x(10)=8.916361342879847_p
w(10)=5.038987400500565e-4_p
x(11)=12.97204320302123_p
w(11)=1.013947358272780e-5_p
x(12)=17.64964849128992_p
w(12)=1.078967174054660e-7_p
x(13)=22.90123346846829_p
w(13)=6.158461459552680e-10_p
x(14)=28.06295236665125_p
w(14)=2.825463016320461e-12_p
else if(N==15)then
x(1)=-9.847460338911498_p
w(1)=3.904785338675130e-1_p
x(2)=-9.204758218435378_p
w(2)=8.896751650159869e-1_p
x(3)=-8.083212842420233_p
w(3)=1.342912870510755_p
x(4)=-6.543007474430116_p
w(4)=1.719506394000547_p
x(5)=-4.675916057874988_p
w(5)=1.971615792529142_p
x(6)=-2.616956496786332_p
w(6)=1.954428081304703_p
x(7)=-5.272376432702273e-1_p
w(7)=1.311441579731054_p
x(8)=1.643632077586173_p
w(8)=3.762532827927791e-1_p
x(9)=4.204566462009381_p
w(9)=4.134356387497946e-2_p
x(10)=7.264750354928162_p
w(10)=2.312471807130676e-3_p
x(11)=10.81832031915387_p
w(11)=7.614854649987268e-5_p
x(12)=14.87130138270145_p
w(12)=1.497078353772520e-6_p
x(13)=19.40745477816571_p
w(13)=1.769702120477058e-8_p
x(14)=24.25532184836192_p
w(14)=1.413541458640744e-10_p
x(15)=28.57476568640656_p
w(15)=1.304857509923853e-12_p
else if(N==16)then
x(1)=-9.861965874852725_p
w(1)=3.534491337567250e-1_p
x(2)=-9.279483279189598_p
w(2)=8.073525152518402e-1_p
x(3)=-8.259297561351545_p
w(3)=1.224647398782860_p
x(4)=-6.849384283190775_p
w(4)=1.581209623028137_p
x(5)=-5.122359157296906_p
w(5)=1.842884643958731_p
x(6)=-3.183712903843033_p
w(6)=1.918884375116525_p
x(7)=-1.175263299391316_p
w(7)=1.531011274671338_p
x(8)=8.572642354681500e-1_p
w(8)=6.291603023742235e-1_p
x(9)=3.150761987622690_p
w(9)=1.027989769157900e-1_p
x(10)=5.877123748335399_p
w(10)=8.233064074858092e-3_p
x(11)=9.035714527590857_p
w(11)=4.012517604460345e-4_p
x(12)=12.61529924093834_p
w(12)=1.257818511804136e-5_p
x(13)=16.60231717499365_p
w(13)=2.573637706088715e-7_p
x(14)=20.92761662129858_p
w(14)=3.615576554080268e-9_p
x(15)=25.32326537004209_p
w(15)=4.246079641767654e-11_p
x(16)=28.91672706980311_p
w(16)=7.243007509531368e-13_p
else if(N==17)then
x(1)=-9.874501306922266_p
w(1)=3.214292970627233e-1_p
x(2)=-9.344231313944571_p
w(2)=7.357739206173093e-1_p
x(3)=-8.412652258736641_p
w(3)=1.120631573471992_p
x(4)=-7.118445580944725_p
w(4)=1.456734985902538_p
x(5)=-5.519815669123185_p
w(5)=1.718794304606951_p
x(6)=-3.700080435414784_p
w(6)=1.848286980038708_p
x(7)=-1.776228828220846_p
w(7)=1.653400638400963_p
x(8)=1.606455988927659e-1_p
w(8)=9.044282265133377e-1_p
x(9)=2.247516976533383_p
w(9)=2.148859827924628e-1_p
x(10)=4.693924761709791_p
w(10)=2.398071624184428e-2_p
x(11)=7.529121371794950_p
w(11)=1.622587355855816e-3_p
x(12)=10.73267097111282_p
w(12)=7.381236044965820e-5_p
x(13)=14.2880686131036_p
w(13)=2.320560758504529e-6_p
x(14)=18.15693106131216_p
w(14)=5.204524328211454e-8_p
x(15)=22.22301661003858_p
w(15)=9.115920124522304e-10_p
x(16)=26.1588595648891_p
w(16)=1.593991255143583e-11_p
x(17)=29.15285059584158_p
w(17)=4.550816557691866e-13_p
else
call GD(-10)
end if
end subroutine GF_m10

! [-9kT;30kT]
subroutine GF_m9(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-6.781260852938670_p
w(1)=5.214314237520104_p
x(2)=-9.236268372096855e-1_p
w(2)=3.785809164669525_p
else if(N==3)then
x(1)=-7.683954152460664_p
w(1)=3.232601258371010_p
x(2)=-3.271349658232936_p
w(2)=4.705941078222352_p
x(3)=1.297723448735163_p
w(3)=1.061581065596267_p
else if(N==4)then
x(1)=-8.104403858819643_p
w(1)=2.237917774130678_p
x(2)=-4.794759949268698_p
w(2)=4.027699871831481_p
x(3)=-7.489887569015593e-1_p
w(3)=2.590639804868726_p
x(4)=3.704167668960602_p
w(4)=1.438659513587452e-1_p
else if(N==5)then
x(1)=-8.336658534725983_p
w(1)=1.671746739127369_p
x(2)=-5.766655230799187_p
w(2)=3.292409786962957_p
x(3)=-2.187825218557237_p
w(3)=3.230797187867031_p
x(4)=1.342698781359630_p
w(4)=7.946981460027387e-1_p
x(5)=6.498872056555674_p
w(5)=1.047154222953371e-2_p
else if(N==6)then
x(1)=-8.480361991256521_p
w(1)=1.315997033823599_p
x(2)=-6.412656638637498_p
w(2)=2.719219928773549_p
x(3)=-3.304788991099708_p
w(3)=3.198806319573186_p
x(4)=-7.421849132013467e-2_p
w(4)=1.646846533964862_p
x(5)=3.619052590789086_p
w(5)=1.187004003018377e-1_p
x(6)=9.541784215403302_p
w(6)=5.531857525959586e-4_p
else if(N==7)then
x(1)=-8.576616369337044_p
w(1)=1.075531806204510_p
x(2)=-6.863618982575591_p
w(2)=2.287968777156960_p
x(3)=-4.167849712936079_p
w(3)=2.941954536277743_p
x(4)=-1.149251788100251_p
w(4)=2.244737414177315_p
x(5)=1.929196836654164_p
w(5)=4.393709939841643e-1_p
x(6)=6.199809304510317_p
w(6)=1.053535908308302e-2_p
x(7)=12.7338401315248_p
w(7)=2.451530585435740e-5_p
else if(N==8)then
x(1)=-8.645042910332890_p
w(1)=9.035769753668620e-1_p
x(2)=-7.192768695965297_p
w(2)=1.959399094971666_p
x(3)=-4.838466143306803_p
w(3)=2.650454514990393_p
x(4)=-2.041736214313256_p
w(4)=2.494804616808388_p
x(5)=7.557575309658160e-1_p
w(5)=9.291994852151864e-1_p
x(6)=4.160449571450836_p
w(6)=6.197014076682867e-2_p
x(7)=8.981050302754639_p
w(7)=7.175919408021824e-4_p
x(8)=16.01060374934438_p
w(8)=9.821295032616263e-7_p
else if(N==9)then
x(1)=-8.696190839800273_p
w(1)=7.745168939180239e-1_p
x(2)=-7.443300706388601_p
w(2)=1.702291332618033_p
x(3)=-5.370224056245767_p
w(3)=2.378478533080292_p
x(4)=-2.801433316379490_p
w(4)=2.512429011771500_p
x(5)=-1.635824344272732e-1_p
w(5)=1.423378694735713_p
x(6)=2.727020285546795_p
w(6)=2.029358847344043e-1_p
x(7)=6.610801076516084_p
w(7)=6.049729575889129e-3_p
x(8)=11.85636305346325_p
w(8)=4.328226375314958e-5_p
x(9)=19.26258455458714_p
w(9)=3.949202213547785e-8_p
else if(N==10)then
x(1)=-8.736205751533623_p
w(1)=6.732445048258505e-1_p
x(2)=-7.641913205383367_p
w(2)=1.494475119505835_p
x(3)=-5.804058238316429_p
w(3)=2.135627112947502_p
x(4)=-3.456872151025381_p
w(4)=2.414226939809441_p
x(5)=-9.513478269029562e-1_p
w(5)=1.793330785426160_p
x(6)=1.630853288700213_p
w(6)=4.606378713103733e-1_p
x(7)=4.882901937200936_p
w(7)=2.806422326335652e-2_p
x(8)=9.149259300515793_p
w(8)=5.142001589128122e-4_p
x(9)=14.6934237383137_p
w(9)=2.642964240358701e-6_p
x(10)=22.24689238088517_p
w(10)=1.977957953196991e-9_p
else if(N==11)then
x(1)=-8.768634314357991_p
w(1)=5.909830199380228e-1_p
x(2)=-7.804503732198373_p
w(2)=1.321891116818053_p
x(3)=-6.166828650427776_p
w(3)=1.920511288863507_p
x(4)=-4.028196213683359_p
w(4)=2.266658670020367_p
x(5)=-1.660040288896329_p
w(5)=1.999101550919057_p
x(6)=7.345388523044335e-1_p
w(6)=8.075471303846117e-1_p
x(7)=3.531475993029515_p
w(7)=9.015141917792792e-2_p
x(8)=7.127912098164990_p
w(8)=3.234991563215837e-3_p
x(9)=11.64963877825607_p
w(9)=4.402515200963889e-5_p
x(10)=17.33843746401258_p
w(10)=1.891914489650411e-7_p
x(11)=24.65630598816381_p
w(11)=1.614086193332603e-10_p
else if(N==12)then
x(1)=-8.795465806646888_p
w(1)=5.227971536612908e-1_p
x(2)=-7.940092588739271_p
w(2)=1.176386019726237_p
x(3)=-6.474283736701698_p
w(3)=1.730796490712568_p
x(4)=-4.527558119113960_p
w(4)=2.103257652623073_p
x(5)=-2.305836609648364_p
w(5)=2.064987803469508_p
x(6)=-3.792653261970614e-2_p
w(6)=1.167078054765855_p
x(7)=2.434867134470104_p
w(7)=2.207699179288128e-1_p
x(8)=5.527187172563816_p
w(8)=1.368197594641849e-2_p
x(9)=9.358443395615149_p
w(9)=3.641281173831969e-4_p
x(10)=14.01752263878609_p
w(10)=4.187483730951347e-6_p
x(11)=19.67609655049368_p
w(11)=1.773058477216774e-8_p
x(12)=26.36587557280623_p
w(12)=2.416799206244753e-11_p
else if(N==13)then
x(1)=-8.817932270853984_p
w(1)=4.656226470307532e-1_p
x(2)=-8.054329931802844_p
w(2)=1.052747989835035_p
x(3)=-6.736595239995328_p
w(3)=1.564202929165738_p
x(4)=-4.963581478194426_p
w(4)=1.940737570879816_p
x(5)=-2.891756725358480_p
w(5)=2.038250465468750_p
x(6)=-7.287725548461488e-1_p
w(6)=1.460265965796887_p
x(7)=1.522318348294631_p
w(7)=4.328741603683033e-1_p
x(8)=4.221317270777503_p
w(8)=4.344481503056177e-2_p
x(9)=7.538747890622359_p
w(9)=1.932988667489620e-3_p
x(10)=11.50677355741686_p
w(10)=4.339698543626877e-5_p
x(11)=16.19295551092143_p
w(11)=4.706608750924817e-7_p
x(12)=21.65411663158474_p
w(12)=2.293833708605323e-9_p
x(13)=27.48676986731839_p
w(13)=6.150833794517481e-12_p
else if(N==14)then
x(1)=-8.836916088789264_p
w(1)=4.172558195497958e-1_p
x(2)=-8.151339591635693_p
w(2)=9.470476278382832e-1_p
x(3)=-6.961568240376200_p
w(3)=1.418197361364408_p
x(4)=-5.344229329174731_p
w(4)=1.786903556072008_p
x(5)=-3.419479111070681_p
w(5)=1.960223390810359_p
x(6)=-1.359325224856497_p
w(6)=1.648001125549319_p
x(7)=7.425031940503162e-1_p
w(7)=7.047127616322639e-1_p
x(8)=3.135802376582112_p
w(8)=1.099956371907280e-1_p
x(9)=6.048390658053910_p
w(9)=7.502455380205730e-3_p
x(10)=9.505988406628216_p
w(10)=2.778502678658693e-4_p
x(11)=13.52836617889066_p
w(11)=5.751288783030557e-6_p
x(12)=18.14153481464007_p
w(12)=6.483093781141001e-8_p
x(13)=23.27105186273755_p
w(13)=4.123761712483240e-10_p
x(14)=28.20575220850098_p
w(14)=2.296559524429672e-12_p
else if(N==15)then
x(1)=-8.853091539363712_p
w(1)=3.760057934560749e-1_p
x(2)=-8.234332236239256_p
w(2)=8.561307441360775e-1_p
x(3)=-7.155571767846175_p
w(3)=1.290170812717943_p
x(4)=-5.677051411746169_p
w(4)=1.644875957809673_p
x(5)=-3.892296198774307_p
w(5)=1.858107514209433_p
x(6)=-1.938586856540695_p
w(6)=1.734758994715386_p
x(7)=5.655563016485352e-2_p
w(7)=9.856007175911872e-1_p
x(8)=2.219352659912618_p
w(8)=2.301851590969999e-1_p
x(9)=4.802587704631216_p
w(9)=2.297443856539860e-2_p
x(10)=7.860133220545859_p
w(10)=1.269736167232109e-3_p
x(11)=11.38865789315817_p
w(11)=4.264744383958501e-5_p
x(12)=15.39383563598543_p
w(12)=8.750478645381614e-7_p
x(13)=19.84894261400823_p
w(13)=1.113093027526418e-8_p
x(14)=24.55977168801782_p
w(14)=1.004811029595187e-10_p
x(15)=28.67359752739918_p
w(15)=1.108328476161590e-12_p
else if(N==16)then
x(1)=-8.866981822917847_p
w(1)=3.405561924786397e-1_p
x(2)=-8.305836751246048_p
w(2)=7.774539017442692e-1_p
x(3)=-7.323805584855136_p
w(3)=1.177677964053585_p
x(4)=-5.968854741415130_p
w(4)=1.515430287758130_p
x(5)=-4.314785096387439_p
w(5)=1.747545660332825_p
x(6)=-2.470055205275596_p
w(6)=1.746672319092924_p
x(7)=-5.623462405246860e-1_p
w(7)=1.223746299946565_p
x(8)=1.432770727269492_p
w(8)=4.081313782134409e-1_p
x(9)=3.745832130020173_p
w(9)=5.816633403392956e-2_p
x(10)=6.476858992747133_p
w(10)=4.513238408490506e-3_p
x(11)=9.617358589339219_p
w(11)=2.224613622070398e-4_p
x(12)=13.15961728135728_p
w(12)=7.206573023143345e-6_p
x(13)=17.08634800785255_p
w(13)=1.557757367181302e-7_p
x(14)=21.31792302500274_p
w(14)=2.383423070008965e-9_p
x(15)=25.57125179806621_p
w(15)=3.180779825229105e-11_p
x(16)=28.98730265788447_p
w(16)=6.339724903237652e-13_p
else if(N==17)then
x(1)=-8.878995791683913_p
w(1)=3.098756342455611e-1_p
x(2)=-8.367852768855556_p
w(2)=7.089696574501405e-1_p
x(3)=-7.470494431715381_p
w(3)=1.078547651962179_p
x(4)=-6.225556109704536_p
w(4)=1.398224392808231_p
x(5)=-4.692030022687828_p
w(5)=1.636920636671360_p
x(6)=-2.955856614010637_p
w(6)=1.711353413632727_p
x(7)=-1.130131447067328_p
w(7)=1.390244577970426_p
x(8)=7.444345372798337e-1_p
w(8)=6.265274261660111e-1_p
x(9)=2.838967808402975_p
w(9)=1.253439762242134e-1_p
x(10)=5.296261726410130_p
w(10)=1.318037931297537e-2_p
x(11)=8.119972828643462_p
w(11)=8.926198122399068e-4_p
x(12)=11.29390116706972_p
w(12)=4.163571855396549e-5_p
x(13)=14.80168522303902_p
w(13)=1.366865953024611e-6_p
x(14)=18.60007138771531_p
w(14)=3.270728996597295e-8_p
x(15)=22.56424678382658_p
w(15)=6.288844201619295e-10_p
x(16)=26.36030568137873_p
w(16)=1.247716412723422e-11_p
x(17)=29.20487285082706_p
w(17)=4.067562899599063e-13_p
else
call GD(-9)
end if
end subroutine GF_m9

! [-8kT;30kT]
subroutine GF_m8(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.971704484781063_p
w(1)=4.752846008464972_p
x(2)=-6.083138549073606e-1_p
w(2)=3.247489397907831_p
else if(N==3)then
x(1)=-6.781796997286458_p
w(1)=2.987695810736320_p
x(2)=-2.720431279439573_p
w(2)=4.201208061417463_p
x(3)=1.642726003269583_p
w(3)=8.114315342190200e-1_p
else if(N==4)then
x(1)=-7.163458381791874_p
w(1)=2.088130145783928_p
x(2)=-4.084906699473080_p
w(2)=3.696910718222500_p
x(3)=-3.256327222461730e-1_p
w(3)=2.120785067881653_p
x(4)=4.150707151479298_p
w(4)=9.450947448472211e-2_p
else if(N==5)then
x(1)=-7.376161809183711_p
w(1)=1.570879570659989_p
x(2)=-4.966392184822051_p
w(2)=3.065081055298883_p
x(3)=-1.640488859613366_p
w(3)=2.798925990691715_p
x(4)=1.786655759674327_p
w(4)=5.592027989800031e-1_p
x(5)=7.024647165641093_p
w(5)=6.245990742212197e-3_p
else if(N==6)then
x(1)=-7.508704429131158_p
w(1)=1.243351066290925_p
x(2)=-5.558184177400142_p
w(2)=2.553345045112136_p
x(3)=-2.650189155961214_p
w(3)=2.881248391517834_p
x(4)=4.025145741064950e-1_p
w(4)=1.249804626200331_p
x(5)=4.143470768312838_p
w(5)=7.227461755138910e-2_p
x(6)=10.11991558628597_p
w(6)=3.116597001863647e-4_p
else if(N==7)then
x(1)=-7.598009129954612_p
w(1)=1.020567836237293_p
x(2)=-5.974477914378691_p
w(2)=2.161329130268220_p
x(3)=-3.435704620701103_p
w(3)=2.710432754208659_p
x(4)=-6.085091214734079e-1_p
w(4)=1.820714537941002_p
x(5)=2.448182848935705_p
w(5)=2.813529485311471e-1_p
x(6)=6.784772694388999_p
w(6)=5.924911523963789e-3_p
x(7)=13.34877207680123_p
w(7)=1.328766251653557e-5_p
else if(N==8)then
x(1)=-7.661846163480459_p
w(1)=8.603373918968918e-1_p
x(2)=-6.280346118839132_p
w(2)=1.859179774046521_p
x(3)=-4.051827059192229_p
w(3)=2.474415855929810_p
x(4)=-1.429559944564403_p
w(4)=2.133856692878161_p
x(5)=1.279955496267587_p
w(5)=6.368529799761905e-1_p
x(6)=4.744164791650449_p
w(6)=3.530524598737414e-2_p
x(7)=9.602761153525499_p
w(7)=3.869454959915633e-4_p
x(8)=16.64687385795413_p
w(8)=5.201618619077545e-7_p
else if(N==9)then
x(1)=-7.709854051998176_p
w(1)=7.393229419512363e-1_p
x(2)=-6.514761916305872_p
w(2)=1.620449158569074_p
x(3)=-4.545016799804702_p
w(3)=2.238849351690644_p
x(4)=-2.126501894905718_p
w(4)=2.231658579253744_p
x(5)=3.832197768257338e-1_p
w(5)=1.047204879361532_p
x(6)=3.302223441024461_p
w(6)=1.195544692909255e-1_p
x(7)=7.231683106504392_p
w(7)=3.273066225470072e-3_p
x(8)=12.49193562399008_p
w(8)=2.293895908385538e-5_p
x(9)=19.88640156757389_p
w(9)=2.107109219476785e-8_p
else if(N==10)then
x(1)=-7.747642470333334_p
w(1)=6.437687554126427e-1_p
x(2)=-6.701849817328332_p
w(2)=1.425837173775177_p
x(3)=-4.950903490066298_p
w(3)=2.021030422330903_p
x(4)=-2.731776591166827_p
w(4)=2.198766874385128_p
x(5)=-3.678628626188576e-1_p
w(5)=1.408968398539651_p
x(6)=2.196516534236888_p
w(6)=2.863052085213881e-1_p
x(7)=5.496269102436107_p
w(7)=1.538304076628333e-2_p
x(8)=9.778952921621896_p
w(8)=2.741148026339934e-4_p
x(9)=15.31278567076961_p
w(9)=1.416717185499160e-6_p
x(10)=22.79634838119912_p
w(10)=1.121809974612898e-9_p
else if(N==11)then
x(1)=-7.778396615888939_p
w(1)=5.658142000140960e-1_p
x(2)=-6.855726376459176_p
w(2)=1.263258962591298_p
x(3)=-5.292400930134226_p
w(3)=1.824157693079393_p
x(4)=-3.263360038326167_p
w(4)=2.098144803037232_p
x(5)=-1.032722457688460_p
w(5)=1.660330733075726_p
x(6)=1.298850872659773_p
w(6)=5.362866093200227e-1_p
x(7)=4.134421449408367_p
w(7)=5.058217165899950e-2_p
x(8)=7.751645649915981_p
w(8)=1.736440111090007e-3_p
x(9)=12.26515287088903_p
w(9)=2.368796139186994e-5_p
x(10)=17.91221474776819_p
w(10)=1.054217551057340e-7_p
x(11)=25.07967075072501_p
w(11)=1.017972785125317e-10_p
else if(N==12)then
x(1)=-7.803899494024538_p
w(1)=5.010486058326095e-1_p
x(2)=-6.984379686332548_p
w(2)=1.125715956021732_p
x(3)=-5.582885552996911_p
w(3)=1.648455041580506_p
x(4)=-3.730649421044006_p
w(4)=1.967763946069890_p
x(5)=-1.634190059113215_p
w(5)=1.790163912993702_p
x(6)=5.388192730982685e-1_p
w(6)=8.311833028738119e-1_p
x(7)=3.027772161850240_p
w(7)=1.284055472379817e-1_p
x(8)=6.146392794067892_p
w(8)=7.400737216927747e-3_p
x(9)=9.973766495124481_p
w(9)=1.960341524597702e-4_p
x(10)=14.60231074815941_p
w(10)=2.311918076477357e-6_p
x(11)=20.18511335607401_p
w(11)=1.045808081476994e-8_p
x(12)=26.6615778763723_p
w(12)=1.702408702019677e-11_p
else if(N==13)then
x(1)=-7.825283159780046_p
w(1)=4.466629041055216e-1_p
x(2)=-7.092953876973148_p
w(2)=1.008573730508829_p
x(3)=-5.831329481008220_p
w(3)=1.492981147513734_p
x(4)=-4.140446102298617_p
w(4)=1.828876871339468_p
x(5)=-2.179605324476715_p
w(5)=1.822230844673047_p
x(6)=-1.266283087615385e-1_p
w(6)=1.111518217939407_p
x(7)=2.108804548477551_p
w(7)=2.646476191147734e-1_p
x(8)=4.836276095296669_p
w(8)=2.378011353170985e-2_p
x(9)=8.155860887873370_p
w(9)=1.039928457211984e-3_p
x(10)=12.10105201023963_p
w(10)=2.375806534211444e-5_p
x(11)=16.73558410676053_p
w(11)=2.696748900271827e-7_p
x(12)=22.09005396163127_p
w(12)=1.444138181408156e-9_p
x(13)=27.68557745335405_p
w(13)=4.729817808376583e-12_p
else if(N==14)then
x(1)=-7.843373523573483_p
w(1)=4.005980163042756e-1_p
x(2)=-7.185284216169656_p
w(2)=9.082367069382327e-1_p
x(3)=-6.044839082303021_p
w(3)=1.355975217192780_p
x(4)=-4.499466388430479_p
w(4)=1.692476682512563_p
x(5)=-2.672261365266866_p
w(5)=1.790094547552701_p
x(6)=-7.238372416104979e-1_p
w(6)=1.329401225704595_p
x(7)=1.329908098510700_p
w(7)=4.579126950419077e-1_p
x(8)=3.745957412211153_p
w(8)=6.144829895553738e-2_p
x(9)=6.667486221375603_p
w(9)=4.037791021467440e-3_p
x(10)=10.10885800731055_p
w(10)=1.509534520143480e-4_p
x(11)=14.09234090681059_p
w(11)=3.232580708433437e-6_p
x(12)=18.63463781342973_p
w(12)=3.883690232160066e-8_p
x(13)=23.63438984995645_p
w(13)=2.772394667559283e-10_p
x(14)=28.34016749361587_p
w(14)=1.878172245009871e-12_p
else if(N==15)then
x(1)=-7.858804865029779_p
w(1)=3.612656792724714e-1_p
x(2)=-7.264375591203804_p
w(2)=8.217888404893210e-1_p
x(3)=-6.229281984776408_p
w(3)=1.235341030093860_p
x(4)=-4.814303818888974_p
w(4)=1.563727659260380_p
x(5)=-3.115394902313534_p
w(5)=1.721615853264256_p
x(6)=-1.267397760159577_p
w(6)=1.466485867942513_p
x(7)=6.546138337590233e-1_p
w(7)=6.841547606522882e-1_p
x(8)=2.824831007138291_p
w(8)=1.328337925593299e-1_p
x(9)=5.422758855950208_p
w(9)=1.241229464352436e-2_p
x(10)=8.470506211795893_p
w(10)=6.854929433920687e-4_p
x(11)=11.968712641901_p
w(11)=2.361978904016287e-5_p
x(12)=15.92087440294452_p
w(12)=5.083921014764876e-7_p
x(13)=20.28905346049838_p
w(13)=6.997616965059188e-9_p
x(14)=24.85722017779209_p
w(14)=7.176330834238384e-11_p
x(15)=28.76690612410497_p
w(15)=9.450538451803622e-13_p
else if(N==16)then
x(1)=-7.872069868445037_p
w(1)=3.274278846630845e-1_p
x(2)=-7.332599165528848_p
w(2)=7.468687064470106e-1_p
x(3)=-6.389473146688614_p
w(3)=1.128997516920044_p
x(4)=-5.091018938942719_p
w(4)=1.444694006668973_p
x(5)=-3.512887104228367_p
w(5)=1.635422137529525_p
x(6)=-1.764692775433922_p
w(6)=1.529815919466849_p
x(7)=5.563257596363638e-2_p
w(7)=9.063326075864291e-1_p
x(8)=2.035866659514680_p
w(8)=2.464832654256937e-1_p
x(9)=4.365690897749770_p
w(9)=3.174135218323066e-2_p
x(10)=7.093434204262706_p
w(10)=2.426068356493905e-3_p
x(11)=10.21040778236859_p
w(11)=1.217502342235986e-4_p
x(12)=13.7106865435449_p
w(12)=4.095337316908083e-6_p
x(13)=17.57232151984997_p
w(13)=9.395635006277603e-8_p
x(14)=21.70515149824051_p
w(14)=1.573086326011298e-9_p
x(15)=25.81265652031301_p
w(15)=2.393560106925168e-11_p
x(16)=29.05421701183548_p
w(16)=5.562022349964363e-13_p
else if(N==17)then
x(1)=-7.883553912915190_p
w(1)=2.981135779670181e-1_p
x(2)=-7.391832825998035_p
w(2)=6.815690750745814e-1_p
x(3)=-6.529340027538371_p
w(3)=1.035039384858891_p
x(4)=-5.334951390376903_p
w(4)=1.335856481849836_p
x(5)=-3.869020580536843_p
w(5)=1.542688115233419_p
x(6)=-2.219698455323800_p
w(6)=1.537912222145994_p
x(7)=-4.858599549141452e-1_p
w(7)=1.091629911840299_p
x(8)=1.350140757146347_p
w(8)=4.002243033012886e-1_p
x(9)=3.457334474936507_p
w(9)=6.971853717734140e-2_p
x(10)=5.917535451866795_p
w(10)=7.075878090438826e-3_p
x(11)=8.723798716270068_p
w(11)=4.838431407166949e-4_p
x(12)=11.8636210407917_p
w(12)=2.325418931631622e-5_p
x(13)=15.31957933504511_p
w(13)=8.005363546672422e-7_p
x(14)=19.04319107882251_p
w(14)=2.052233226622937e-8_p
x(15)=22.90147544079312_p
w(15)=4.348060932213327e-10_p
x(16)=26.55601773429183_p
w(16)=9.805009887503184e-12_p
x(17)=29.25441352939149_p
w(17)=3.640405230312343e-13_p
else
call GD(-8)
end if
end subroutine GF_m8

! [-7kT;30kT]
subroutine GF_m7(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.160732875495108_p
w(1)=4.287642623767839_p
x(2)=-2.708834502807088e-1_p
w(2)=2.713268842685841_p
else if(N==3)then
x(1)=-5.879247477879814_p
w(1)=2.740849982811423_p
x(2)=-2.166717819507948_p
w(2)=3.668240033962870_p
x(3)=2.027331933748082_p
w(3)=5.918214496793878e-1_p
else if(N==4)then
x(1)=-6.222514627057777_p
w(1)=1.936778132431642_p
x(2)=-3.376756654310450_p
w(2)=3.341543937878793_p
x(3)=1.189397737810174e-1_p
w(3)=1.663299313143786_p
x(4)=4.638561052324389_p
w(4)=5.929008299945972e-2_p
else if(N==5)then
x(1)=-6.415822088485939_p
w(1)=1.468623946063427_p
x(2)=-4.168257285081333_p
w(2)=2.822660036048771_p
x(3)=-1.090177048484157_p
w(3)=2.334695697540397_p
x(4)=2.271870437512672_p
w(4)=3.713410236039525e-1_p
x(5)=7.585660289754259_p
w(5)=3.590763197132934e-3_p
else if(N==6)then
x(1)=-6.537261971765012_p
w(1)=1.169458538539330_p
x(2)=-4.705707991554724_p
w(2)=2.377735879083060_p
x(3)=-2.000116124552820_p
w(3)=2.518939341923673_p
x(4)=9.076735238252773e-1_p
w(4)=8.925901299153390e-1_p
x(5)=4.707450061174476_p
w(5)=4.201742456783029e-2_p
x(6)=10.72876399909375_p
w(6)=1.701524244487825e-4_p
else if(N==7)then
x(1)=-6.619636044717327_p
w(1)=9.644776415813561e-1_p
x(2)=-5.087150537434329_p
w(2)=2.027847519618563_p
x(3)=-2.709600067022123_p
w(3)=2.442442061810052_p
x(4)=-5.627363562644506e-2_p
w(4)=1.393206989790224_p
x(5)=3.008731926435168_p
w(5)=1.697114887742237e-1_p
x(6)=7.402321745826376_p
w(6)=3.218758707271050e-3_p
x(7)=13.99081301083832_p
w(7)=7.006171991839499e-6_p
else if(N==8)then
x(1)=-6.678890688192545_p
w(1)=8.160622513352410e-1_p
x(2)=-5.369594950798295_p
w(2)=1.753780217817730_p
x(3)=-3.270992886403572_p
w(3)=2.271996153143771_p
x(4)=-8.182294163372242e-1_p
w(4)=1.732663843609668_p
x(5)=1.840472154839026_p
w(5)=4.068962934902290e-1_p
x(6)=5.362939990390321_p
w(6)=1.930953354283410e-2_p
x(7)=10.25140483751071_p
w(7)=2.029041421203607e-4_p
x(8)=17.30489588430846_p
w(8)=2.693720873702471e-7_p
else if(N==9)then
x(1)=-6.723759477460525_p
w(1)=7.031669193523751e-1_p
x(2)=-5.587780358498913_p
w(2)=1.534470700439743_p
x(3)=-3.725026958656722_p
w(3)=2.080351589186901_p
x(4)=-1.458473206615460_p
w(4)=1.898819026977370_p
x(5)=9.545015665008104e-1_p
w(5)=7.154434752867042e-1_p
x(6)=3.914547909304956_p
w(6)=6.692742821999438e-2_p
x(7)=7.879370684668730_p
w(7)=1.720413299819306e-3_p
x(8)=13.14760297426008_p
w(8)=1.190258313212991e-5_p
x(9)=20.52022878613368_p
w(9)=1.110764195162815e-8_p
else if(N==10)then
x(1)=-6.759306822880985_p
w(1)=6.134242385928732e-1_p
x(2)=-5.763187539023138_p
w(2)=1.353834942530876_p
x(3)=-4.102255248281217_p
w(3)=1.892762703016930_p
x(4)=-2.015336644708435_p
w(4)=1.935904868716313_p
x(5)=2.267599410846761e-1_p
w(5)=1.029708469922276_p
x(6)=2.799074556928979_p
w(6)=1.669682793047916e-1_p
x(7)=6.137562028141309_p
w(7)=8.164139423275580e-3_p
x(8)=10.4282769088748_p
w(8)=1.430749582935265e-4_p
x(9)=15.94388114070884_p
w(9)=7.493504621910391e-7_p
x(10)=23.3393138407945_p
w(10)=6.375884576521124e-10_p
else if(N==11)then
x(1)=-6.788358813138937_p
w(1)=5.398904775141637e-1_p
x(2)=-5.908151238095954_p
w(2)=1.201892377835146_p
x(3)=-4.421731532550901_p
w(3)=1.717732617884765_p
x(4)=-2.506814673363797_p
w(4)=1.892066368039396_p
x(5)=-4.046944595108340e-1_p
w(5)=1.290664197149370_p
x(6)=1.895644438285756_p
w(6)=3.304630469177626e-1_p
x(7)=4.767764517953346_p
w(7)=2.727870828887012e-2_p
x(8)=8.396107017290447_p
w(8)=9.110595174063779e-4_p
x(9)=12.89422059809985_p
w(9)=1.255486573316889e-5_p
x(10)=18.49012293938177_p
w(10)=5.837616389215350e-8_p
x(11)=25.48675085401349_p
w(11)=6.490319035996921e-11_p
else if(N==12)then
x(1)=-6.812504292495823_p
w(1)=4.786525387141287e-1_p
x(2)=-6.029680905224172_p
w(2)=1.072809808845993_p
x(3)=-4.694589467080940_p
w(3)=1.558536624891449_p
x(4)=-2.940974595404708_p
w(4)=1.804068832304944_p
x(5)=-9.679500413926487e-1_p
w(5)=1.466118629312361_p
x(6)=1.139366956040523_p
w(6)=5.457449706114764e-1_p
x(7)=3.653496270857784_p
w(7)=7.097492371611014e-2_p
x(8)=6.788322320173249_p
w(8)=3.900111915448800e-3_p
x(9)=10.6045171118657_p
w(9)=1.037563956961711e-4_p
x(10)=15.195554628234_p
w(10)=1.263571282984628e-6_p
x(11)=20.69256405948883_p
w(11)=6.162659436072407e-9_p
x(12)=26.9411569819198_p
w(12)=1.213157895074719e-11_p
else if(N==13)then
x(1)=-6.832780836573246_p
w(1)=4.271449287896023e-1_p
x(2)=-6.132437611066035_p
w(2)=9.625457211318649e-1_p
x(3)=-4.928642544121980_p
w(3)=1.415923341976848_p
x(4)=-3.323427792884787_p
w(4)=1.696130728213283_p
x(5)=-1.475458549626183_p
w(5)=1.554965194977415_p
x(6)=4.887498595708693e-1_p
w(6)=7.793520954028456e-1_p
x(7)=2.728492933719312_p
w(7)=1.516747968267647e-1_p
x(8)=5.476484878693449_p
w(8)=1.261280010250719e-2_p
x(9)=8.790187842371857_p
w(9)=5.488605856840073e-4_p
x(10)=12.70638000607024_p
w(10)=1.284393272719461e-5_p
x(11)=17.28234675065407_p
w(11)=1.535989408679334e-7_p
x(12)=22.52075347131798_p
w(12)=9.115280826000051e-10_p
x(13)=27.87241679671093_p
w(13)=3.669134769553846e-12_p
else if(N==14)then
x(1)=-6.849957930242598_p
w(1)=3.834547168199489e-1_p
x(2)=-6.219964991998693_p
w(2)=8.678668900128543e-1_p
x(3)=-5.130278065680126_p
w(3)=1.289155349110723_p
x(4)=-3.659837111677286_p
w(4)=1.582493628675957_p
x(5)=-1.933533939216163_p
w(5)=1.575160867421406_p
x(6)=-8.455387586596723e-2_p
w(6)=9.921933719406218e-1_p
x(7)=1.947321686753734_p
w(7)=2.753953647633022e-1_p
x(8)=4.384070312249892_p
w(8)=3.298245149683961e-2_p
x(9)=7.305672578522959_p
w(9)=2.126173908061041e-3_p
x(10)=10.72467824448376_p
w(10)=8.082800649470321e-5_p
x(11)=14.66359185567248_p
w(11)=1.800903695626842e-6_p
x(12)=19.12839212445719_p
w(12)=2.320502548828922e-8_p
x(13)=23.99073645356871_p
w(13)=1.872062337908385e-10_p
x(14)=28.46656776175426_p
w(14)=1.544915665271924e-12_p
else if(N==15)then
x(1)=-6.864628846623699_p
w(1)=3.461000055357660e-1_p
x(2)=-6.295054797790220_p
w(2)=7.861196623813939e-1_p
x(3)=-5.304834313418489_p
w(3)=1.176815432282295_p
x(4)=-3.955872145962730_p
w(4)=1.470824798396562_p
x(5)=-2.346467501056162_p
w(5)=1.549032410027709_p
x(6)=-5.989881181170631e-1_p
w(6)=1.156605708108003_p
x(7)=1.275917888532301_p
w(7)=4.357155340351208e-1_p
x(8)=3.460353773141956_p
w(8)=7.278546409021014e-2_p
x(9)=6.064157445684243_p
w(9)=6.535167946542294e-3_p
x(10)=9.095487457322971_p
w(10)=3.640459775282997e-4_p
x(11)=12.55817671535017_p
w(11)=1.293953787799137e-5_p
x(12)=16.4520056301284_p
w(12)=2.936837072875632e-7_p
x(13)=20.72728638036043_p
w(13)=4.398652503266291e-9_p
x(14)=25.14740367601927_p
w(14)=5.150324614509209e-11_p
x(15)=28.85496641973918_p
w(15)=8.087118882113892e-13_p
else if(N==16)then
x(1)=-6.877254952513056_p
w(1)=3.139240568315003e-1_p
x(2)=-6.359914862821694_p
w(2)=7.151414686585111e-1_p
x(3)=-5.456720257791504_p
w(3)=1.077293536340662_p
x(4)=-4.216831968322994_p
w(4)=1.364917560752532_p
x(5)=-2.718087597470714_p
w(5)=1.495245522121964_p
x(6)=-1.065728473171651_p
w(6)=1.263025864012807_p
x(7)=6.881861131392334e-1_p
w(7)=6.138492641047051e-1_p
x(8)=2.669266489074067_p
w(8)=1.393882054175261e-1_p
x(9)=5.009177549283458_p
w(9)=1.677779837831164e-2_p
x(10)=7.726276133733548_p
w(10)=1.280028221780642e-3_p
x(11)=10.81454744933913_p
w(11)=6.579514311434595e-5_p
x(12)=14.26817902440725_p
w(12)=2.308923713995648e-6_p
x(13)=18.05983257807291_p
w(13)=5.648815833179425e-8_p
x(14)=22.08890972874906_p
w(14)=1.039810854480299e-9_p
x(15)=26.04738807460839_p
w(15)=1.809367532346848e-11_p
x(16)=29.11765397976433_p
w(16)=4.889919357597074e-13_p
else if(N==17)then
x(1)=-6.888197594494938_p
w(1)=2.860182040866727e-1_p
x(2)=-6.416297421213724_p
w(2)=6.531768181648265e-1_p
x(3)=-5.589551079446935_p
w(3)=9.890193652369227e-1_p
x(4)=-4.447453576020579_p
w(4)=1.266407864174954_p
x(5)=-3.052183494977993_p
w(5)=1.426890442966526_p
x(6)=-1.491386877023509_p
w(6)=1.316318975208137_p
x(7)=1.646254629239046e-1_p
w(7)=7.856695966459744e-1_p
x(8)=1.983604653997882_p
w(8)=2.361948641802751e-1_p
x(9)=4.101702812342236_p
w(9)=3.722614012876348e-2_p
x(10)=6.556887948994471_p
w(10)=3.717314527298876e-3_p
x(11)=9.340208223982568_p
w(11)=2.585386692995481e-4_p
x(12)=12.44153220247578_p
w(12)=1.286299408859840e-5_p
x(13)=15.84141902774363_p
w(13)=4.663005001825339e-7_p
x(14)=19.48592621596867_p
w(14)=1.286004350664629e-8_p
x(15)=23.23442680411884_p
w(15)=3.013373864124572e-10_p
x(16)=26.74600033427293_p
w(16)=7.734839459623058e-12_p
x(17)=29.30159271320337_p
w(17)=3.261775215049443e-13_p
else
call GD(-7)
end if
end subroutine GF_m7

! [-6kT;30kT]
subroutine GF_m6(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-4.348502560283281_p
w(1)=3.813108199782167_p
x(2)=9.542185539560426e-2_p
w(2)=2.189367485355470_p
else if(N==3)then
x(1)=-4.976655280349003_p
w(1)=2.488346384593441_p
x(2)=-1.607600763207661_p
w(2)=3.105729843718220_p
x(3)=2.458422906120189_p
w(3)=4.083994568259754e-1_p
else if(N==4)then
x(1)=-5.281875128941513_p
w(1)=1.781349020745459_p
x(2)=-2.670786361937648_p
w(2)=2.950357827892909_p
x(3)=5.934077370568107e-1_p
w(3)=1.235342363259137_p
x(4)=5.170697035066502_p
w(4)=3.542647324013119e-2_p
else if(N==5)then
x(1)=-5.455883521655720_p
w(1)=1.363153426368828_p
x(2)=-3.373394396186944_p
w(2)=2.554812483281129_p
x(3)=-5.306149147449191e-1_p
w(3)=1.850998563980723_p
x(4)=2.803640897668142_p
w(4)=2.315252406262155e-1_p
x(5)=8.183896825391324_p
w(5)=1.985970880741443e-3_p
else if(N==6)then
x(1)=-5.566232540300096_p
w(1)=1.092914975042465_p
x(2)=-3.856351232993425_p
w(2)=2.184610859486647_p
x(3)=-1.352364376883791_p
w(3)=2.107777650554804_p
x(4)=1.450471757924032_p
w(4)=5.937650505155765e-1_p
x(5)=5.312392985562700_p
w(5)=2.331727729621487e-2_p
x(6)=11.37002565504762_p
w(6)=8.987224192916267e-5_p
else if(N==7)then
x(1)=-5.641660957236388_p
w(1)=9.061343364019462e-1_p
x(2)=-4.202616415939521_p
w(2)=1.881718851330669_p
x(3)=-1.989824320109664_p
w(3)=2.124735025053496_p
x(4)=5.177969009527450e-1_p
w(4)=9.917369176317441e-1_p
x(5)=3.613274030673797_p
w(5)=9.645908226491648e-2_p
x(6)=8.053511553294264_p
w(6)=1.687883502564227e-3_p
x(7)=14.66125696894312_p
w(7)=3.588952301482494e-6_p
else if(N==8)then
x(1)=-5.696314992165067_p
w(1)=7.698189368432895e-1_p
x(2)=-4.461351331687855_p
w(2)=1.638763077942332_p
x(3)=-2.497254292161964_p
w(3)=2.028846286846358_p
x(4)=-1.997697646905167e-1_p
w(4)=1.313098677160241_p
x(5)=2.443128294820116_p
w(5)=2.416960122308282e-1_p
x(6)=6.017001830818675_p
w(6)=1.014915687973140e-2_p
x(7)=10.92763485413927_p
w(7)=1.034008662246849e-4_p
x(8)=17.98471105662978_p
w(8)=1.363686315104649e-7_p
else if(N==9)then
x(1)=-5.738023212956526_p
w(1)=6.652677373525743e-1_p
x(2)=-4.663055316035655_p
w(2)=1.440893057506490_p
x(3)=-2.911781241369753_p
w(3)=1.890542123955374_p
x(4)=-7.929475423869035e-1_p
w(4)=1.518815774828987_p
x(5)=1.559793565010229_p
w(5)=4.503547527679728e-1_p
x(6)=4.563992183871073_p
w(6)=3.571748205329680e-2_p
x(7)=8.553908353560308_p
w(7)=8.787038487121949e-4_p
x(8)=13.82316265433575_p
w(8)=6.047029104526446e-6_p
x(9)=21.16176923756331_p
w(9)=5.795124744995251e-9_p
else if(N==10)then
x(1)=-5.771293695153418_p
w(1)=5.815562504918431e-1_p
x(2)=-4.826496496679252_p
w(2)=1.275728900683876_p
x(3)=-3.259551265724047_p
w(3)=1.740809840659452_p
x(4)=-1.306007086566149_p
w(4)=1.617425705512999_p
x(5)=8.436433675914973e-1_p
w(5)=6.909555553372005e-1_p
x(6)=3.440002509303409_p
w(6)=9.172537051662395e-2_p
x(7)=6.806385994975549_p
w(7)=4.200545333103668e-3_p
x(8)=11.09709808928738_p
w(8)=7.312490018909841e-5_p
x(9)=16.58590028215554_p
w(9)=3.913383350977983e-7_p
x(10)=23.87268775706856_p
w(10)=3.640139994500244e-10_p
else if(N==11)then
x(1)=-5.798599119602791_p
w(1)=5.126567440152424e-1_p
x(2)=-4.962246137956219_p
w(2)=1.135585534978223_p
x(3)=-3.556087003396009_p
w(3)=1.593349398454562_p
x(4)=-1.758734901639307_p
w(4)=1.634381352273134_p
x(5)=2.339269557071204e-1_p
w(5)=9.226053537517437e-1_p
x(6)=2.529634084195411_p
w(6)=1.892399890694939e-1_p
x(7)=5.430787659027744_p
w(7)=1.418335590165090e-2_p
x(8)=9.061139513374041_p
w(8)=4.673687233047341e-4_p
x(9)=13.53656966986247_p
w(9)=6.555781901737449e-6_p
x(10)=19.07118886841742_p
w(10)=3.214650059595096e-8_p
x(11)=25.87607279777457_p
w(11)=4.188062333254731e-11_p
else if(N==12)then
x(1)=-5.821346253123572_p
w(1)=4.551307471568371e-1_p
x(2)=-5.076388339855199_p
w(2)=1.015856620703773_p
x(3)=-3.810493259548773_p
w(3)=1.454826555600031_p
x(4)=-2.159561129418912_p
w(4)=1.597302169386694_p
x(5)=-3.001829546537828e-1_p
w(5)=1.110662209939046_p
x(6)=1.772072766945700_p
w(6)=3.291603599416965e-1_p
x(7)=4.311529239567273_p
w(7)=3.747799598496163e-2_p
x(8)=7.452562417442102_p
w(8)=2.004343859744428e-3_p
x(9)=11.25054331434918_p
w(9)=5.399508287287639e-5_p
x(10)=15.79683441949812_p
w(10)=6.838426805414253e-7_p
x(11)=21.19752224437638_p
w(11)=3.630553247322254e-9_p
x(12)=27.20458248818202_p
w(12)=8.745848695621612e-12_p
else if(N==13)then
x(1)=-5.840481910795072_p
w(1)=4.066520154548989e-1_p
x(2)=-5.173114350533836_p
w(2)=9.131528235159937e-1_p
x(3)=-4.029480297830059_p
w(3)=1.328087411000709_p
x(4)=-2.513882328137784_p
w(4)=1.529067199012425_p
x(5)=-7.754737028075669e-1_p
w(5)=1.238345117644956_p
x(6)=1.127936712161747_p
w(6)=4.983735771849583e-1_p
x(7)=3.382309210930340_p
w(7)=8.200897992422293e-2_p
x(8)=6.141142720620889_p
w(8)=6.497340161421880e-3_p
x(9)=9.441500728690977_p
w(9)=2.842758055058728e-4_p
x(10)=13.32251322350968_p
w(10)=6.857854223031356e-6_p
x(11)=17.83272173732806_p
w(11)=8.699832033805747e-8_p
x(12)=22.94549256617196_p
w(12)=5.771324850755113e-10_p
x(13)=28.04769979271581_p
w(13)=2.870262320538903e-12_p
else if(N==14)then
x(1)=-5.856718218163327_p
w(1)=3.654597690341564e-1_p
x(2)=-5.255667480648855_p
w(2)=8.246601796968768e-1_p
x(3)=-4.218698671820745_p
w(3)=1.213758740759806_p
x(4)=-2.826752487102482_p
w(4)=1.445607122908391_p
x(5)=-1.201810499316616_p
w(5)=1.306632680409326_p
x(6)=5.689858975479022e-1_p
w(6)=6.740905793852132e-1_p
x(7)=2.598499436468792_p
w(7)=1.540413775792052e-1_p
x(8)=5.049068534375306_p
w(8)=1.708530700998755e-2_p
x(9)=7.962512690666909_p
w(9)=1.096257409017038e-3_p
x(10)=11.35323577330293_p
w(10)=4.266230277076856e-5_p
x(11)=15.24179028490747_p
w(11)=9.946802552723554e-7_p
x(12)=19.62226803298084_p
w(12)=1.383434924600923e-8_p
x(13)=24.33964836537929_p
w(13)=1.270042283999273e-10_p
x(14)=28.58534420170558_p
w(14)=1.277637818270476e-12_p
else if(N==15)then
x(1)=-5.870606008270731_p
w(1)=3.301847475149297e-1_p
x(2)=-5.326616279503378_p
w(2)=7.480297001918602e-1_p
x(3)=-4.382929471820103_p
w(3)=1.111347317007005_p
x(4)=-3.103097517374083_p
w(4)=1.356841700240540_p
x(5)=-1.585512774440755_p
w(5)=1.326697284420690_p
x(6)=7.511879607453587e-2_p
w(6)=8.330122531464915e-1_p
x(7)=1.927586138343272_p
w(7)=2.546753276379559e-1_p
x(8)=4.125140464414460_p
w(8)=3.813087006499208e-2_p
x(9)=6.726026050993424_p
w(9)=3.359054186643025e-3_p
x(10)=9.734799272470950_p
w(10)=1.902463307019098e-4_p
x(11)=13.15680384477658_p
w(11)=7.012865749333311e-6_p
x(12)=16.98686072907794_p
w(12)=1.687267113037379e-7_p
x(13)=21.16318459423126_p
w(13)=2.765525306243991e-9_p
x(14)=25.43012219594257_p
w(14)=3.714666286206385e-11_p
x(15)=28.9380572199531_p
w(15)=6.942804381905408e-13_p
else if(N==16)then
x(1)=-5.882574265901826_p
w(1)=2.997561170557742e-1_p
x(2)=-5.387997884273608_p
w(2)=6.813268040848597e-1_p
x(3)=-4.526152737423549_p
w(3)=1.019881589523537_p
x(4)=-3.347516888480000_p
w(4)=1.268501041529622_p
x(5)=-1.931196400463520_p
w(5)=1.312363737211311_p
x(6)=-3.674007674283825e-1_p
w(6)=9.590573481628505e-1_p
x(7)=1.344931645738907_p
w(7)=3.778346466808172e-1_p
x(8)=3.333530422063828_p
w(8)=7.443535367479544e-2_p
x(9)=5.675182415368411_p
w(9)=8.619271718396963e-3_p
x(10)=8.374951204863214_p
w(10)=6.633324160145678e-4_p
x(11)=11.42953970424821_p
w(11)=3.511679641791871e-5_p
x(12)=14.83181983747316_p
w(12)=1.291719590745894e-6_p
x(13)=18.54851978057559_p
w(13)=3.386098273168519e-8_p
x(14)=22.4688539314744_p
w(14)=6.884971695866883e-10_p
x(15)=26.27540473434435_p
w(15)=1.373915603713872e-11_p
x(16)=29.17779761566938_p
w(16)=4.306891187784522e-13_p
else if(N==17)then
x(1)=-5.892959543541179_p
w(1)=2.733309719292762e-1_p
x(2)=-5.441433615308824_p
w(2)=6.229680006647053e-1_p
x(3)=-4.651653843002852_p
w(3)=9.382400714258046e-1_p
x(4)=-3.564156322654702_p
w(4)=1.183677299946987_p
x(5)=-2.242707111034230_p
w(5)=1.275832880047625_p
x(6)=-7.676685768684598e-1_p
w(6)=1.046051414185617_p
x(7)=8.316419972928448e-1_p
w(7)=5.113597015063257e-1_p
x(8)=2.647865424676612_p
w(8)=1.297670755269083e-1_p
x(9)=4.770792387417837_p
w(9)=1.919107161790603e-2_p
x(10)=7.213636083337630_p
w(10)=1.913642460315655e-3_p
x(11)=9.968907954569433_p
w(11)=1.362294319787740e-4_p
x(12)=13.02739913491171_p
w(12)=7.047943800037954e-6_p
x(13)=16.36692122930109_p
w(13)=2.701848739673398e-7_p
x(14)=19.92795744210047_p
w(14)=8.049735677538011e-9_p
x(15)=23.56287257937821_p
w(15)=2.093606533126781e-10_p
x(16)=26.93029358342722_p
w(16)=6.124533426995498e-12_p
x(17)=29.34653052193701_p
w(17)=2.925211867406988e-13_p
else
call GD(-6)
end if
end subroutine GF_m6

! [-5kT;30kT]
subroutine GF_m5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-3.535012775838008_p
w(1)=3.320511014575395_p
x(2)=4.997493692838678e-1_p
w(2)=1.686204333913630_p
else if(N==3)then
x(1)=-4.074467845789563_p
w(1)=2.223447082312202_p
x(2)=-1.037808927767268_p
w(2)=2.518893665304897_p
x(3)=2.943265610998302_p
w(3)=2.643746008719250e-1_p
else if(N==4)then
x(1)=-4.341958146641130_p
w(1)=1.617041750733071_p
x(2)=-1.966113699390737_p
w(2)=2.512463398593522_p
x(3)=1.108297617580277_p
w(3)=8.571028438787484e-1_p
x(4)=5.750232302841264_p
w(4)=2.010735528368338e-2_p
else if(N==5)then
x(1)=-4.496691989845595_p
w(1)=1.250884376219996_p
x(2)=-2.582578777621975_p
w(2)=2.247117032332564_p
x(3)=4.811935300019917e-2_p
w(3)=1.372568578055962_p
x(4)=3.386463233633969_p
w(4)=1.350909821048192e-1_p
x(5)=8.821727261097339_p
w(5)=1.054379775683001e-3_p
else if(N==6)then
x(1)=-4.595899863926249_p
w(1)=1.010918194001542_p
x(2)=-3.011276891034413_p
w(2)=1.961333422506361_p
x(3)=-7.009292626204709e-1_p
w(3)=1.657180074233217_p
x(4)=2.039669695178076_p
w(4)=3.648910831202932e-1_p
x(5)=5.959802152102413_p
w(5)=1.234674395126371e-2_p
x(6)=12.04578752836502_p
w(6)=4.583067634788915e-5_p
else if(N==7)then
x(1)=-4.664320158679953_p
w(1)=8.432641136359729e-1_p
x(2)=-3.322039735814951_p
w(2)=1.712702330496317_p
x(3)=-1.274040312394391_p
w(3)=1.750240431956794_p
x(4)=1.125696850551889_p
w(4)=6.479132054908878e-1_p
x(5)=4.263363803705871_p
w(5)=5.174007294032856e-2_p
x(6)=8.739706391445022_p
w(6)=8.534106812624719e-4_p
x(7)=15.36166270611304_p
w(7)=1.783287462036624e-6_p
else if(N==8)then
x(1)=-4.714318648753188_p
w(1)=7.197131394053995e-1_p
x(2)=-3.556674474452703_p
w(2)=1.505899547033762_p
x(3)=-1.730450853116951_p
w(3)=1.730069079078406_p
x(4)=4.376868353766615e-1_p
w(4)=9.122344846135184e-1_p
x(5)=3.091718061904484_p
w(5)=1.336184460344312e-1_p
x(6)=6.706750718178096_p
w(6)=5.129418150719540e-3_p
x(7)=11.63226927951365_p
w(7)=5.116669549080177e-5_p
x(8)=18.68620586243561_p
w(8)=6.747729725785282e-8_p
else if(N==9)then
x(1)=-4.752811969604664_p
w(1)=6.240283307243990e-1_p
x(2)=-3.741502213560667_p
w(2)=1.333076394470984_p
x(3)=-2.106129459725337_p
w(3)=1.652983277649515_p
x(4)=-1.207652034065889e-1_p
w(4)=1.117488749034516_p
x(5)=2.206774721643353_p
w(5)=2.604732361026968e-1_p
x(6)=5.250296374788581_p
w(6)=1.822630331718233e-2_p
x(7)=9.255541422548333_p
w(7)=4.360462527496028e-4_p
x(8)=14.51845491070473_p
w(8)=3.007938614999845e-6_p
x(9)=21.80828526368763_p
w(9)=2.998366556032356e-9_p
else if(N==10)then
x(1)=-4.783740324092668_p
w(1)=5.468095244149329e-1_p
x(2)=-3.892544294632604_p
w(2)=1.186121477352349_p
x(3)=-2.424003611005651_p
w(3)=1.549986129778926_p
x(4)=-5.980323639579850e-1_p
w(4)=1.251865096573765_p
x(5)=1.493920586978704_p
w(5)=4.220864867887074e-1_p
x(6)=4.119501103557875_p
w(6)=4.771308279523925e-2_p
x(7)=7.502608378987369_p
w(7)=2.096756478797422e-3_p
x(8)=11.78545493076703_p
w(8)=3.659221394598897e-5_p
x(9)=17.23808799475491_p
w(9)=2.018831179489798e-7_p
x(10)=24.39340806786138_p
w(10)=2.092441998699970e-10_p
else if(N==11)then
x(1)=-4.809232020997360_p
w(1)=4.829490735692794e-1_p
x(2)=-4.018657519212394_p
w(2)=1.059893906038665_p
x(3)=-2.696756846078816_p
w(3)=1.437906426089100_p
x(4)=-1.016235945617125_p
w(4)=1.319762107986113_p
x(5)=8.955383673583589e-1_p
w(5)=5.975782584826929e-1_p
x(6)=3.203079589260811_p
w(6)=1.012616630665309e-1_p
x(7)=6.122933392235484_p
w(7)=7.126098627248479e-3_p
x(8)=9.746799850359837_p
w(8)=2.344243696450308e-4_p
x(9)=14.19205937405384_p
w(9)=3.372616716241695e-6_p
x(10)=19.65450019519735_p
w(10)=1.761565897278702e-8_p
x(11)=26.24650538079357_p
w(11)=2.737407033269183e-11_p
else if(N==12)then
x(1)=-4.830522718743578_p
w(1)=4.294713097015858e-1_p
x(2)=-4.125053540455689_p
w(2)=9.511445670152578e-1_p
x(3)=-2.931842546996994_p
w(3)=1.326320109159135_p
x(4)=-1.385483798775980_p
w(4)=1.334472167466891_p
x(5)=3.803407333222149e-1_p
w(5)=7.623997090449435e-1_p
x(6)=2.442577837368508_p
w(6)=1.828809128915049e-1_p
x(7)=5.001042535260221_p
w(7)=1.899352447849129e-2_p
x(8)=8.138945749735404_p
w(8)=1.005053853825329e-3_p
x(9)=11.91184697455714_p
w(9)=2.762620062228341e-5_p
x(10)=16.40582463575541_p
w(10)=3.665308343155997e-7_p
x(11)=21.69913203031948_p
w(11)=2.139555877842174e-9_p
x(12)=27.45203826385299_p
w(12)=6.377125505485362e-12_p
else if(N==13)then
x(1)=-4.848470073340847_p
w(1)=3.842961403564908e-1_p
x(2)=-4.215458383281041_p
w(2)=8.572558544127078e-1_p
x(3)=-3.134991573324413_p
w(3)=1.220305218609040_p
x(4)=-1.712043759969828_p
w(4)=1.311919092920834_p
x(5)=-7.105087845965065e-2_p
w(5)=8.974898037628219e-1_p
x(6)=1.800068261046479_p
w(6)=2.899138987632207e-1_p
x(7)=4.069860037704927_p
w(7)=4.213124418807676e-2_p
x(8)=6.829701091143249_p
w(8)=3.255928663237247e-3_p
x(9)=10.10975160281943_p
w(9)=1.445009332816874e-4_p
x(10)=13.94932661889193_p
w(10)=3.616496099067398e-6_p
x(11)=18.38626735411932_p
w(11)=4.901425673811407e-8_p
x(12)=23.36364051043659_p
w(12)=3.666951477973145e-10_p
x(13)=28.21191582265794_p
w(13)=2.263087731973237e-12_p
else if(N==14)then
x(1)=-4.863726851383663_p
w(1)=3.458279332257924e-1_p
x(2)=-4.292801733715160_p
w(2)=7.759318302717906e-1_p
x(3)=-3.311135564466019_p
w(3)=1.122139821556718_p
x(4)=-2.001055969207739_p
w(4)=1.266080974435033_p
x(5)=-4.714039785809034e-1_p
w(5)=9.938202111973509e-1_p
x(6)=1.248122408267504_p
w(6)=4.129563699124797e-1_p
x(7)=3.284683757019339_p
w(7)=8.081138078886127e-2_p
x(8)=5.739987821247515_p
w(8)=8.570374480558819e-3_p
x(9)=8.637787050649534_p
w(9)=5.537025179485743e-4_p
x(10)=11.99445704740644_p
w(10)=2.219706647275183e-5_p
x(11)=15.8267079138053_p
w(11)=5.447165857946327e-7_p
x(12)=20.11581533594595_p
w(12)=8.231789480141231e-9_p
x(13)=24.68077937848848_p
w(13)=8.658187479554772e-11_p
x(14)=28.69691003495022_p
w(14)=1.061796817020153e-12_p
else if(N==15)then
x(1)=-4.876799476714107_p
w(1)=3.128208703128452e-1_p
x(2)=-4.359416398471066_p
w(2)=7.051995277732325e-1_p
x(3)=-3.464488637043202_p
w(3)=1.032525349356896_p
x(4)=-2.257099340281062_p
w(4)=1.207351606837096_p
x(5)=-8.293072062232819e-1_p
w(5)=1.051463740786468_p
x(6)=7.665072379620188e-1_p
w(6)=5.387570790928909e-1_p
x(7)=2.613657142695636_p
w(7)=1.375956752576153e-1_p
x(8)=4.818026220023084_p
w(8)=1.921234007824406e-2_p
x(9)=7.407863085558534_p
w(9)=1.687455972951731e-3_p
x(10)=10.38832661300499_p
w(10)=9.784454269417479e-5_p
x(11)=13.76446437225076_p
w(11)=3.760290076204161e-6_p
x(12)=17.52516140024428_p
w(12)=9.642101843191462e-8_p
x(13)=21.59637226615559_p
w(13)=1.739473332779737e-9_p
x(14)=25.70525918627103_p
w(14)=2.692478797031803e-11_p
x(15)=29.01646356701263_p
w(15)=5.977471980021137e-13_p
else if(N==16)then
x(1)=-4.888083117224417_p
w(1)=2.842979765260054e-1_p
x(2)=-4.417159566997644_p
w(2)=6.434024807188721e-1_p
x(3)=-3.598586827948305_p
w(3)=9.513439569857471e-1_p
x(4)=-2.484281281517525_p
w(4)=1.142743701783138_p
x(5)=-1.150776576661981_p
w(5)=1.076048217290598_p
x(6)=3.404483440743690e-1_p
w(6)=6.543703294627725e-1_p
x(7)=2.033117184580050_p
w(7)=2.119734648917995e-1_p
x(8)=4.027890824280034_p
w(8)=3.786425875062136e-2_p
x(9)=6.362839391186355_p
w(9)=4.313955988321521e-3_p
x(10)=9.039220360844471_p
w(10)=3.377562255879370e-4_p
x(11)=12.05527798054635_p
w(11)=1.851203542519816e-5_p
x(12)=15.40143600461151_p
w(12)=7.171224098700855e-7_p
x(13)=19.03810595912999_p
w(13)=2.024014815167621e-8_p
x(14)=22.84471867405955_p
w(14)=4.567192851048030e-10_p
x(15)=26.49672800131463_p
w(15)=1.047820225211980e-11_p
x(16)=29.23483470392775_p
w(16)=3.799199053292545e-13_p
else if(N==17)then
x(1)=-4.897888479932249_p
w(1)=2.594880246450970e-1_p
x(2)=-4.467514818508939_p
w(2)=5.891648875344441e-1_p
x(3)=-3.716370824559494_p
w(3)=8.780844887204009e-1_p
x(4)=-2.686255698348648_p
w(4)=1.076692720750999_p
x(5)=-1.440324836020199_p
w(5)=1.075244160968112_p
x(6)=-4.068091414450715e-2_p
w(6)=7.504320305777229e-1_p
x(7)=1.524999485194955_p
w(7)=2.998921371647544e-1_p
x(8)=3.343492208789065_p
w(8)=6.708189576618741e-2_p
x(9)=5.463387213027635_p
w(9)=9.594052095164389e-3_p
x(10)=7.887332160968417_p
w(10)=9.661690826689137e-4_p
x(11)=10.60975384657368_p
w(11)=7.079483589186119e-5_p
x(12)=13.62109878796053_p
w(12)=3.825423007923944e-6_p
x(13)=16.89589469817276_p
w(13)=1.557398650943726e-7_p
x(14)=20.36904459686642_p
w(14)=5.033753935091012e-9_p
x(15)=23.88665563529313_p
w(15)=1.458259931661099e-10_p
x(16)=27.10898290916745_p
w(16)=4.866666060395357e-12_p
x(17)=29.38934926046903_p
w(17)=2.625169743156755e-13_p
else
call GD(-5)
end if
end subroutine GF_m5

! [-4kT;30kT]
subroutine GF_m4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.719496190305115_p
w(1)=2.798302111345682_p
x(2)=9.542779201775164e-1_p
w(2)=1.219847816572034_p
else if(N==3)then
x(1)=-3.173001314683805_p
w(1)=1.934954903923198_p
x(2)=-4.480233016492620e-1_p
w(2)=1.923940249147675_p
x(3)=3.489292068886087_p
w(3)=1.592547748468434e-1_p
else if(N==4)then
x(1)=-3.403203826977881_p
w(1)=1.435139794124162_p
x(2)=-1.258691244621591_p
w(2)=2.024550389893521_p
x(3)=1.675327611309050_p
w(3)=5.476517547015248e-1_p
x(4)=6.380732675612212_p
w(4)=1.080798919850859e-2_p
else if(N==5)then
x(1)=-3.538654218796107_p
w(1)=1.124991597299904_p
x(2)=-1.794888000062430_p
w(2)=1.884609416410270_p
x(3)=6.595647531553280e-1_p
w(3)=9.343688305720128e-1_p
x(4)=4.024112855866699_p
w(4)=7.364426996348414e-2_p
x(5)=9.502172250210759_p
w(5)=5.358136720455223e-4_p
else if(N==6)then
x(1)=-3.626616072483077_p
w(1)=9.179654294350601e-1_p
x(2)=-2.170857664246327_p
w(2)=1.690740364973876_p
x(3)=-3.460035119388913e-2_p
w(3)=1.196952004656360_p
x(4)=2.682545676206110_p
w(4)=2.062376622446219e-1_p
x(5)=6.651620408484129_p
w(5)=6.231961979727193e-3_p
x(6)=12.75876407756932_p
w(6)=2.250462807128811e-5_p
else if(N==7)then
x(1)=-3.687916244219368_p
w(1)=7.713068114938942e-1_p
x(2)=-2.446263499691166_p
w(2)=1.504866174727809_p
x(3)=-5.549836696121507e-1_p
w(3)=1.330684896078485_p
x(4)=1.779158403901016_p
w(4)=3.846371515537849e-1_p
x(5)=4.960227716536796_p
w(5)=2.623869623786630e-2_p
x(6)=9.462785085449804_p
w(6)=4.153400767047078e-4_p
x(7)=16.09400741832998_p
w(7)=8.577491721713124e-7_p
else if(N==8)then
x(1)=-3.733161412034629_p
w(1)=6.618900058809687e-1_p
x(2)=-2.656533956071830_p
w(2)=1.341293467947247_p
x(3)=-9.666740088995850e-1_p
w(3)=1.371557107749051_p
x(4)=1.108318470543784_p
w(4)=5.718835645474802e-1_p
x(5)=3.788275606777673_p
w(5)=6.900862567564114e-2_p
x(6)=7.433005784912257_p
w(6)=2.492566939664525e-3_p
x(7)=12.36643349040489_p
w(7)=2.455654701960224e-5_p
x(8)=19.40911913175597_p
w(8)=3.263064398305114e-8_p
else if(N==9)then
x(1)=-3.768344715116065_p
w(1)=5.761570545594904e-1_p
x(2)=-2.824056711477717_p
w(2)=1.199166193468971_p
x(3)=-1.306371318882281_p
w(3)=1.354553574561360_p
x(4)=5.718585990182553e-1_p
w(4)=7.403388676745489e-1_p
x(5)=2.900338751592089_p
w(5)=1.388102969411518e-1_p
x(6)=5.973414151429119_p
w(6)=8.912356961321522e-3_p
x(7)=9.984877585399525_p
w(7)=2.101176153182038e-4_p
x(8)=15.23349203646334_p
w(8)=1.464593685268833e-6_p
x(9)=22.45666599352397_p
w(9)=1.541868771189743e-9_p
else if(N==10)then
x(1)=-3.796829533983595_p
w(1)=5.063511940732179e-1_p
x(2)=-2.962174585031153_p
w(2)=1.074958556238768_p
x(3)=-1.595209475698161_p
w(3)=1.303523653101375_p
x(4)=1.199620719110596e-1_p
w(4)=8.742417491992931e-1_p
x(5)=2.186408220326427_p
w(5)=2.344263787535364e-1_p
x(6)=4.837285680520598_p
w(6)=2.361487446908803e-2_p
x(7)=8.226530607286143_p
w(7)=1.015499165371288e-3_p
x(8)=12.49369497238874_p
w(8)=1.791988785365256e-5_p
x(9)=17.89985456673542_p
w(9)=1.029078622924365e-7_p
x(10)=24.89861790589101_p
w(10)=1.213506681111383e-10_p
else if(N==11)then
x(1)=-3.820412299788244_p
w(1)=4.483040950490571e-1_p
x(2)=-3.078136068164277_p
w(2)=9.662595959837806e-1_p
x(3)=-1.844066282649002_p
w(3)=1.234095753272480_p
x(4)=-2.710869163069514e-1_p
w(4)=9.668073640236484e-1_p
x(5)=1.592226275022609_p
w(5)=3.481043437368165e-1_p
x(6)=3.916485633758910_p
w(6)=5.099779831714658e-2_p
x(7)=6.844061694193637_p
w(7)=3.464335791294640e-3_p
x(8)=10.45348538995728_p
w(8)=1.149231936966966e-4_p
x(9)=14.86078998071719_p
w(9)=1.708921691387162e-6_p
x(10)=20.23928836155427_p
w(10)=9.609972142640374e-9_p
x(11)=26.59731683552579_p
w(11)=1.813178714903453e-11_p
else if(N==12)then
x(1)=-3.840166622405321_p
w(1)=3.995116559820704e-1_p
x(2)=-3.176342892270234_p
w(2)=8.713394000794854e-1_p
x(3)=-2.059341481077432_p
w(3)=1.156678339799049_p
x(4)=-6.134120952915491e-1_p
w(4)=1.019162769739693_p
x(5)=1.087147594338803_p
w(5)=4.673474648219328e-1_p
x(6)=3.153532144756262_p
w(6)=9.433463298144948e-2_p
x(7)=5.721401170075460_p
w(7)=9.269837690839004e-3_p
x(8)=8.847676042081853_p
w(8)=4.917392220905300e-4_p
x(9)=12.58869489666429_p
w(9)=1.389178268552422e-5_p
x(10)=17.02238546783903_p
w(10)=1.945518930075472e-7_p
x(11)=22.1966775624782_p
w(11)=1.261827151911591e-9_p
x(12)=27.68392189193465_p
w(12)=4.700991176109838e-12_p
else if(N==13)then
x(1)=-3.856860425913831_p
w(1)=3.581639774011720e-1_p
x(2)=-3.260059638786010_p
w(2)=7.885220044801161e-1_p
x(3)=-2.246050050664472_p
w(3)=1.077796190524123_p
x(4)=-9.148254678017603e-1_p
w(4)=1.037787619305088_p
x(5)=6.507774640794330e-1_p
w(5)=5.792303053387381e-1_p
x(6)=2.511001871749586_p
w(6)=1.542933627523710e-1_p
x(7)=4.790301882168006_p
w(7)=2.069399434116692e-2_p
x(8)=7.542017122753374_p
w(8)=1.588494944373353e-3_p
x(9)=10.79518137264224_p
w(9)=7.206792286579820e-5_p
x(10)=14.58691132827336_p
w(10)=1.883202371136786e-6_p
x(11)=18.94269983727256_p
w(11)=2.746967047474116e-8_p
x(12)=23.77471383458575_p
w(12)=2.338624276673244e-10_p
x(13)=28.36563031886253_p
w(13)=1.797345203525848e-12_p
else if(N==14)then
x(1)=-3.871084075083512_p
w(1)=3.228549484474891e-1_p
x(2)=-3.331889349362319_p
w(2)=7.161720519296197e-1_p
x(3)=-2.408513440992933_p
w(3)=1.001196947770691_p
x(4)=-1.181226783236016_p
w(4)=1.031048086968870_p
x(5)=2.687032677051343e-1_p
w(5)=6.739956798123727e-1_p
x(6)=1.962040705541889_p
w(6)=2.282982912130399e-1_p
x(7)=4.005541455811893_p
w(7)=4.012596479970558e-2_p
x(8)=6.456245512657122_p
w(8)=4.172307481007664e-3_p
x(9)=9.331597614734150_p
w(9)=2.739671639395014e-4_p
x(10)=12.64850621294135_p
w(10)=1.138164735907233e-5_p
x(11)=16.41830067930409_p
w(11)=2.957342932852936e-7_p
x(12)=20.60872893033674_p
w(12)=4.889128321026364e-9_p
x(13)=25.01391995275008_p
w(13)=5.931331885009627e-11_p
x(14)=28.80170352912378_p
w(14)=8.862772045068888e-13_p
else if(N==15)then
x(1)=-3.883297027585079_p
w(1)=2.924810831830524e-1_p
x(2)=-3.393916650392757_p
w(2)=6.527996917487213e-1_p
x(3)=-2.550424058911089_p
w(3)=9.288359778025119e-1_p
x(4)=-1.417378825791291_p
w(4)=1.006826378252257_p
x(5)=-6.934326444737439e-2_p
w(5)=7.465056394335741e-1_p
x(6)=1.486773997138355_p
w(6)=3.109951741982856e-1_p
x(7)=3.335337306056286_p
w(7)=6.947453161524864e-2_p
x(8)=5.538011398697939_p
w(8)=9.350915805540160e-3_p
x(9)=8.109530987887430_p
w(9)=8.289700510270457e-4_p
x(10)=11.05621241224558_p
w(10)=4.951550868299852e-5_p
x(11)=14.38123179163612_p
w(11)=1.994398837865500e-6_p
x(12)=18.06679158050765_p
w(12)=5.480523408244973e-8_p
x(13)=22.02660829242275_p
w(13)=1.094617500933982e-9_p
x(14)=25.97280866862148_p
w(14)=1.960941558797337e-11_p
x(15)=29.09048093126707_p
w(15)=5.158869634200005e-13_p
else if(N==16)then
x(1)=-3.893858759039397_p
w(1)=2.661733634735693e-1_p
x(2)=-3.447809028962741_p
w(2)=5.971053738982651e-1_p
x(3)=-2.674890427239526_p
w(3)=8.615853540686478e-1_p
x(4)=-1.627260203000860_p
w(4)=9.715115863355712e-1_p
x(5)=-3.707584914616764e-1_p
w(5)=7.958629744221083e-1_p
x(6)=1.070333843163986_p
w(6)=3.955897671509783e-1_p
x(7)=2.756446777345701_p
w(7)=1.095548739022114e-1_p
x(8)=4.751172629480884_p
w(8)=1.848099965635326e-2_p
x(9)=7.071679428443148_p
w(9)=2.106607418247056e-3_p
x(10)=9.719129157114747_p
w(10)=1.689835278605643e-4_p
x(11)=12.69187389586816_p
w(11)=9.636663182788984e-6_p
x(12)=15.97703230847383_p
w(12)=3.950249859067328e-7_p
x(13)=19.52845954096674_p
w(13)=1.206385742047469e-8_p
x(14)=23.2163600295702_p
w(14)=3.035178856076591e-10_p
x(15)=26.71146185451753_p
w(15)=8.024164623277116e-12_p
x(16)=29.28895857539881_p
w(16)=3.355349888151057e-13_p
else if(N==17)then
x(1)=-3.903052725862650_p
w(1)=2.432429318796303e-1_p
x(2)=-3.494904681535000_p
w(2)=5.479793374437221e-1_p
x(3)=-2.784511296391767_p
w(3)=7.996894270204440e-1_p
x(4)=-1.814260558068730_p
w(4)=9.298447977348450e-1_p
x(5)=-6.410122276872713e-1_p
w(5)=8.240965968302743e-1_p
x(6)=7.015568057271981e-1_p
w(6)=4.754613206012092e-1_p
x(7)=2.251339009030557_p
w(7)=1.596840148803260e-1_p
x(8)=4.069664424593863_p
w(8)=3.296966102286990e-2_p
x(9)=6.178631975733647_p
w(9)=4.664814371335459e-3_p
x(10)=8.577850456515650_p
w(10)=4.785976378171169e-4_p
x(11)=11.26283590079366_p
w(11)=3.627949983684579e-5_p
x(12)=14.22269836572244_p
w(12)=2.056448029762565e-6_p
x(13)=17.42830618381631_p
w(13)=8.929693028390569e-8_p
x(14)=20.80907862025936_p
w(14)=3.144511740063539e-9_p
x(15)=24.20572426740996_p
w(15)=1.018188401570844e-10_p
x(16)=27.28221354011992_p
w(16)=3.879764686909308e-12_p
x(17)=29.43017653733708_p
w(17)=2.356856651713023e-13_p
else
call GD(-4)
end if
end subroutine GF_m4

! [-3kT;30kT]
subroutine GF_m3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.899025451537589_p
w(1)=2.236589553683670_p
x(2)=1.474550524625797_p
w(2)=8.119977978899787e-1_p
else if(N==3)then
x(1)=-2.271684154241718_p
w(1)=1.607697452908116_p
x(2)=1.763422218894688e-1_p
w(2)=1.352267407896297_p
x(3)=4.104040384300776_p
w(3)=8.862249076923576e-2_p
else if(N==4)then
x(1)=-2.465647671391490_p
w(1)=1.221926489317827_p
x(2)=-5.388490773618366e-1_p
w(2)=1.502930107795915_p
x(3)=2.306221422229316_p
w(3)=3.182503060659476e-1_p
x(4)=7.066634049664944_p
w(4)=5.480448393959080e-3_p
else if(N==5)then
x(1)=-2.581975096130622_p
w(1)=9.738540224943066e-1_p
x(2)=-1.005155282061314_p
w(2)=1.463842269411105_p
x(3)=1.319542839766923_p
w(3)=5.731563632846204e-1_p
x(4)=4.720118857903068_p
w(4)=3.747507586503024e-2_p
x(5)=10.22926392304468_p
w(5)=2.596205185858045e-4_p
else if(N==6)then
x(1)=-2.658627593685827_p
w(1)=8.042121199486892e-1_p
x(2)=-1.332623643718737_p
w(2)=1.358875296226007_p
x(3)=6.629395552959811e-1_p
w(3)=7.753308410041915e-1_p
x(4)=3.384506363259987_p
w(4)=1.071659976357819e-1_p
x(5)=7.390631710226988_p
w(5)=2.992494364350276e-3_p
x(6)=13.51261396202398_p
w(6)=1.060239462846141e-5_p
else if(N==7)then
x(1)=-2.712695817732596_p
w(1)=6.818237845194719e-1_p
x(2)=-1.574269759185692_p
w(2)=1.240505412540748_p
x(3)=1.811834086917572e-1_p
w(3)=9.067147230019764e-1_p
x(4)=2.487667302840799_p
w(4)=2.067557420992372e-1_p
x(5)=5.705418005578686_p
w(5)=1.259320711587275e-2_p
x(6)=10.22540598629301_p
w(6)=1.940839870456782e-4_p
x(7)=16.86087112669011_p
w(7)=3.983092960511915e-7_p
else if(N==8)then
x(1)=-2.753073002837978_p
w(1)=5.890422837890688e-1_p
x(2)=-1.760667767300597_p
w(2)=1.126795998821483_p
x(3)=-1.955441138358057e-1_p
w(3)=9.774700539018497e-1_p
x(4)=1.825611029181629_p
w(4)=3.206606733725709e-1_p
x(5)=4.533944867723010_p
w(5)=3.344350750541911e-2_p
x(6)=8.197276310181255_p
w(6)=1.163408048105828e-3_p
x(7)=13.1317470628148_p
w(7)=1.141071642565432e-5_p
x(8)=20.15303905072707_p
w(8)=1.541872586561324e-8_p
else if(N==9)then
x(1)=-2.784824131667931_p
w(1)=5.152914531470814e-1_p
x(2)=-1.910825869386701_p
w(2)=1.021998347962027_p
x(3)=-5.052775378433365e-1_p
w(3)=1.003462390148508_p
x(4)=1.300694122428323_p
w(4)=4.349507989758292e-1_p
x(5)=3.642914094377871_p
w(5)=6.860561712570706e-2_p
x(6)=6.733933244553238_p
w(6)=4.179845112551141e-3_p
x(7)=10.74309571018405_p
w(7)=9.820071258132225e-5_p
x(8)=15.96862289455317_p
w(8)=6.975995252165775e-7_p
x(9)=23.10352931571814_p
w(9)=7.898376596726333e-10_p
else if(N==10)then
x(1)=-2.810736954127914_p
w(1)=4.546085281305913e-1_p
x(2)=-2.035672734304626_p
w(2)=9.265594582043756e-1_p
x(3)=-7.684033984840208e-1_p
w(3)=9.978984545650910e-1_p
x(4)=8.638437704748370e-1_p
w(4)=5.387927533513764e-1_p
x(5)=2.926432433941859_p
w(5)=1.190831751003688e-1_p
x(6)=5.593340815208967_p
w(6)=1.115948248426755e-2_p
x(7)=8.979089117301925_p
w(7)=4.768680065314619e-4_p
x(8)=13.22264613084261_p
w(8)=8.579832165161788e-6_p
x(9)=18.57090259774748_p
w(9)=5.182775919515965e-8_p
x(10)=25.38582574558304_p
w(10)=7.112205740345463e-11_p
else if(N==11)then
x(1)=-2.832293675209424_p
w(1)=4.038037392419727e-1_p
x(2)=-2.141056883411937_p
w(2)=8.405629477322861e-1_p
x(3)=-9.950418940314635e-1_p
w(3)=9.711088498223768e-1_p
x(4)=4.909437249292509e-1_p
w(4)=6.242485488947922e-1_p
x(5)=2.332914312571686_p
w(5)=1.828435528235128e-1_p
x(6)=4.669706533578785_p
w(6)=2.433379538418808e-2_p
x(7)=7.594684652864760_p
w(7)=1.630047385516267e-3_p
x(8)=11.1820973792267_p
w(8)=5.501276270091856e-5_p
x(9)=15.5432372234292_p
w(9)=8.522942185368569e-7_p
x(10)=20.8250212566923_p
w(10)=5.219913305783206e-9_p
x(11)=26.92820623408189_p
w(11)=1.217084553620651e-11_p
else if(N==12)then
x(1)=-2.850413563765848_p
w(1)=3.608811964491995e-1_p
x(2)=-2.230669578344563_p
w(2)=7.638002295356333e-1_p
x(3)=-1.191250441830084_p
w(3)=9.312463897908665e-1_p
x(4)=1.683765871959060e-1_p
w(4)=6.874066587312440e-1_p
x(5)=1.832345262036364_p
w(5)=2.550354199631452e-1_p
x(6)=3.905549986531503_p
w(6)=4.561058430922986e-2_p
x(7)=6.472556278261543_p
w(7)=4.365304397686681e-3_p
x(8)=9.579485221095698_p
w(8)=2.346055946192792e-4_p
x(9)=13.2817594039361_p
w(9)=6.859829340239288e-6_p
x(10)=17.64667302931715_p
w(10)=1.022243441156740e-7_p
x(11)=22.68965820668211_p
w(11)=7.448388840380061e-10_p
x(12)=27.90083495723956_p
w(12)=3.500938645688617e-12_p
else if(N==13)then
x(1)=-2.865772938274224_p
w(1)=3.243478602045122e-1_p
x(2)=-2.307337577663161_p
w(2)=6.956497348312523e-1_p
x(3)=-1.361734486843261_p
w(3)=8.843345565495537e-1_p
x(4)=-1.131533777858017e-1_p
w(4)=7.282832959874019e-1_p
x(5)=1.404048361789827_p
w(5)=3.294555248538673e-1_p
x(6)=3.263227755140470_p
w(6)=7.596459291148214e-2_p
x(7)=5.543073159142849_p
w(7)=9.761052588183565e-3_p
x(8)=8.278515390197942_p
w(8)=7.545105376956688e-4_p
x(9)=11.49845963807089_p
w(9)=3.523992260698522e-5_p
x(10)=15.23569476691488_p
w(10)=9.677248794213193e-7_p
x(11)=19.50198491681621_p
w(11)=1.531107309181388e-8_p
x(12)=24.1784333538078_p
w(12)=1.497036211576684e-10_p
x(13)=28.50948109346063_p
w(13)=1.436733012872357e-12_p
else if(N==14)then
x(1)=-2.878896270523881_p
w(1)=2.930277698599987e-1_p
x(2)=-2.373338136492667_p
w(2)=6.352648935184710e-1_p
x(3)=-1.510441651716081_p
w(3)=8.344949604189980e-1_p
x(4)=-3.605573163868699e-1_p
w(4)=7.494571817174344e-1_p
x(5)=1.032949109438391_p
w(5)=4.001462338684948e-1_p
x(6)=2.715990395531004_p
w(6)=1.150825101713103e-1_p
x(7)=4.760306289103216_p
w(7)=1.900183700613637e-2_p
x(8)=7.197855417037144_p
w(8)=1.973330104672479e-3_p
x(9)=10.04450184136175_p
w(9)=1.327252197566813e-4_p
x(10)=13.31590851213184_p
w(10)=5.747643205399595e-6_p
x(11)=17.01681060108031_p
w(11)=1.591056075239386e-7_p
x(12)=21.10092378623866_p
w(12)=2.897997592040366e-9_p
x(13)=25.33903654142994_p
w(13)=4.082274083337456e-11_p
x(14)=28.90019015083666_p
w(14)=7.425279012704015e-13_p
else if(N==15)then
x(1)=-2.890193247304679_p
w(1)=2.659910704706082e-1_p
x(2)=-2.430503981231926_p
w(2)=5.817518620237578e-1_p
x(3)=-1.640683051797114_p
w(3)=7.843833989649236e-1_p
x(4)=-5.791538993387445e-1_p
w(4)=7.546353080026149e-1_p
x(5)=7.079314170396643e-1_p
w(5)=4.624991976630392e-1_p
x(6)=2.244194611122846_p
w(6)=1.613490641892713e-1_p
x(7)=4.092256868503008_p
w(7)=3.314538518683027e-2_p
x(8)=6.284642875681560_p
w(8)=4.408163303908643e-3_p
x(9)=8.831384995841580_p
w(9)=3.981826010542699e-4_p
x(10)=11.73897984332073_p
w(10)=2.464172662127018e-5_p
x(11)=15.00749012269895_p
w(11)=1.045763808410559e-6_p
x(12)=18.61188344977428_p
w(12)=3.097340119355300e-8_p
x(13)=22.45384648027937_p
w(13)=6.890180433616485e-10_p
x(14)=26.23290201243809_p
w(14)=1.434527811758879e-11_p
x(15)=29.16041891835161_p
w(15)=4.460919026095139e-13_p
else if(N==16)then
x(1)=-2.899985545084639_p
w(1)=2.425006104065136e-1_p
x(2)=-2.480308219487669_p
w(2)=5.342610174512942e-1_p
x(3)=-1.755221770421946_p
w(3)=7.356202926413141e-1_p
x(4)=-7.731520198045111e-1_p
w(4)=7.476565372840793e-1_p
x(5)=4.207256603750594e-1_p
w(5)=5.137186357217762e-1_p
x(6)=1.833116127560301_p
w(6)=2.121551340862764e-1_p
x(7)=3.515748123086857_p
w(7)=5.288391071468014e-2_p
x(8)=5.502501276651107_p
w(8)=8.698787322691404e-3_p
x(9)=7.801770874940766_p
w(9)=1.004216941831589e-3_p
x(10)=10.41512514612368_p
w(10)=8.303484096559832e-5_p
x(11)=13.33976667466256_p
w(11)=4.950976716051186e-6_p
x(12)=16.55888416978944_p
w(12)=2.158091100138274e-7_p
x(13)=20.01966679542451_p
w(13)=7.167911012824185e-9_p
x(14)=23.58380317712427_p
w(14)=2.020244835050456e-10_p
x(15)=26.91981199883658_p
w(15)=6.167754781544643e-12_p
x(16)=29.34037266192871_p
w(16)=2.965670972304282e-13_p
else if(N==17)then
x(1)=-2.908527746778089_p
w(1)=2.219684236315647e-1_p
x(2)=-2.523938903292936_p
w(2)=4.920235559866907e-1_p
x(3)=-1.856361185412172_p
w(3)=6.891299661414700e-1_p
x(4)=-9.459678857722739e-1_p
w(4)=7.319530218818138e-1_p
x(5)=1.650927469161830e-1_p
w(5)=5.527488276441410e-1_p
x(6)=1.471547840043489_p
w(6)=2.644075846737665e-1_p
x(7)=3.013460674540000_p
w(7)=7.836258447853151e-2_p
x(8)=4.825295468463786_p
w(8)=1.553187797638442e-2_p
x(9)=6.916236367276687_p
w(9)=2.209477041812890e-3_p
x(10)=9.285497644034384_p
w(10)=2.325604289515478e-4_p
x(11)=11.92858669671961_p
w(11)=1.832437250276864e-5_p
x(12)=14.83255205978826_p
w(12)=1.094369146906332e-6_p
x(13)=17.96436049725014_p
w(13)=5.091055314911389e-8_p
x(14)=21.24814191727975_p
w(14)=1.961760712724106e-9_p
x(15)=24.52016974598024_p
w(15)=7.124437946430382e-11_p
x(16)=27.4502052840452_p
w(16)=3.101845943570148e-12_p
x(17)=29.46914827130071_p
w(17)=2.116102683038367e-13_p
else
call GD(-3)
end if
end subroutine GF_m3

! [-2kT;30kT]
subroutine GF_m2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.066219023118341_p
w(1)=1.641101497006655_p
x(2)=2.078600417732956_p
w(2)=4.858265140362236e-1_p
else if(N==3)then
x(1)=-1.367356239612951_p
w(1)=1.231471514394506_p
x(2)=8.549450144438935e-1_p
w(2)=8.501892891976498e-1_p
x(3)=4.795098643119389_p
w(3)=4.526720745072309e-2_p
else if(N==4)then
x(1)=-1.527758762241507_p
w(1)=9.633823166192717e-1_p
x(2)=2.103248194374745e-1_p
w(2)=9.940878179508772e-1_p
x(3)=3.011208151494253_p
w(3)=1.668493147046110e-1_p
x(4)=7.813492696399264_p
w(4)=2.608561768119180e-3_p
else if(N==5)then
x(1)=-1.625837554379148_p
w(1)=7.833844843041082e-1_p
x(2)=-2.010068435126267e-1_p
w(2)=1.013088537106372_p
x(3)=2.043282436080548_p
w(3)=3.125549785397507e-1_p
x(4)=5.478275404443171_p
w(4)=1.778067687206656e-2_p
x(5)=11.00824590215207_p
w(5)=1.193342205808257e-4_p
else if(N==6)then
x(1)=-1.691470390922537_p
w(1)=6.565066998042409e-1_p
x(2)=-4.880270242928417e-1_p
w(2)=9.761274379927435e-1_p
x(3)=1.410214973604378_p
w(3)=4.416138892366522e-1_p
x(4)=4.149421700798003_p
w(4)=5.131253466327768e-2_p
x(5)=8.180678166503697_p
w(5)=1.362679468405709e-3_p
x(6)=14.31209006416396_p
w(6)=4.769877558975956e-6_p
else if(N==7)then
x(1)=-1.738386211423255_p
w(1)=5.628055829285903e-1_p
x(2)=-7.002064729682331e-1_p
w(2)=9.179997085678459e-1_p
x(3)=9.534133815934746e-1_p
w(3)=5.393615378713025e-1_p
x(4)=3.257427686939455_p
w(4)=1.009556762583168e-1_p
x(5)=6.501233424901033_p
w(5)=5.718546123046742e-3_p
x(6)=11.0310991293045_p
w(6)=8.678131944789821e-5_p
x(7)=17.66539566875883_p
w(7)=1.779743288923001e-7_p
else if(N==8)then
x(1)=-1.773887602891218_p
w(1)=4.903020859324808e-1_p
x(2)=-8.650272701182955e-1_p
w(2)=8.538167435749849e-1_p
x(3)=6.002385052572147e-1_p
w(3)=6.060109448879080e-1_p
x(4)=2.599386891429781_p
w(4)=1.610106584504815e-1_p
x(5)=5.329845659151271_p
w(5)=1.526188855006043e-2_p
x(6)=9.001855531476158_p
w(6)=5.205607418164605e-4_p
x(7)=13.9303359556123_p
w(7)=5.121786233166220e-6_p
x(8)=20.9171607528007_p
w(8)=7.118913626170005e-9_p
else if(N==9)then
x(1)=-1.802143233750803_p
w(1)=4.316447015431913e-1_p
x(2)=-9.989575968549917e-1_p
w(2)=7.893049696591395e-1_p
x(3)=3.118624128985927e-1_p
w(3)=6.464975368122069e-1_p
x(4)=2.079155893459556_p
w(4)=2.258817565884818e-1_p
x(5)=4.435555107252972_p
w(5)=3.167484834870880e-2_p
x(6)=7.533257232842559_p
w(6)=1.879443722182483e-3_p
x(7)=11.53200283567845_p
w(7)=4.442927351236386e-5_p
x(8)=16.72453323673976_p
w(8)=3.246914625977959e-7_p
x(9)=23.7451852528793_p
w(9)=4.039930492065757e-10_p
else if(N==10)then
x(1)=-1.825392714188625_p
w(1)=3.827673436812485e-1_p
x(2)=-1.111010384708041_p
w(2)=7.269375429074862e-1_p
x(3)=6.835135647615698e-2_p
w(3)=6.657934584820948e-1_p
x(4)=1.649529792807362_p
w(4)=2.902857465338317e-1_p
x(5)=3.716297564912211_p
w(5)=5.587924214060738e-2_p
x(6)=6.388340904878318_p
w(6)=5.043846730410684e-3_p
x(7)=9.761908824804202_p
w(7)=2.167947011731334e-4_p
x(8)=13.97364121270495_p
w(8)=4.010045680172775e-6_p
x(9)=19.25119990769414_p
w(9)=2.577816963834977e-8_p
x(10)=25.8529291691679_p
w(10)=4.217672169554688e-11_p
else if(N==11)then
x(1)=-1.844832814428251_p
w(1)=3.414871165212109e-1_p
x(2)=-1.205974547097721_p
w(2)=6.682522839550297e-1_p
x(3)=-1.402884425963227e-1_p
w(3)=6.684968154055240e-1_p
x(4)=1.286749016488824_p
w(4)=3.493311623311918e-1_p
x(5)=3.122269008974285_p
w(5)=8.754025581678176e-2_p
x(6)=5.462806747312499_p
w(6)=1.105251564380923e-2_p
x(7)=8.376033192899452_p
w(7)=7.417661669520313e-4_p
x(8)=11.93407304822554_p
w(8)=2.567446520980169e-5_p
x(9)=16.24025326328774_p
w(9)=4.179062385069976e-7_p
x(10)=21.41136827108786_p
w(10)=2.822655406737428e-9_p
x(11)=27.23923822679967_p
w(11)=8.275781561490210e-12_p
else if(N==12)then
x(1)=-1.861238810963487_p
w(1)=3.063665728358489e-1_p
x(2)=-1.287000052620260_p
w(2)=6.140878177808257e-1_p
x(3)=-3.203000826996006e-1_p
w(3)=6.589703168427068e-1_p
x(4)=9.763717423721705e-1_p
w(4)=3.994960256786808e-1_p
x(5)=2.623597438947023_p
w(5)=1.250673051045983e-1_p
x(6)=4.698496987218933_p
w(6)=2.084305924773644e-2_p
x(7)=7.255192776003851_p
w(7)=1.984532823931108e-3_p
x(8)=10.33566787522567_p
w(8)=1.090049269809366e-4_p
x(9)=13.99213778489543_p
w(9)=3.322229146451441e-6_p
x(10)=18.27913171657395_p
w(10)=5.312978639080254e-8_p
x(11)=23.17776131164332_p
w(11)=4.400056330106243e-10_p
x(12)=28.1035231410149_p
w(12)=2.631488171689398e-12_p
else if(N==13)then
x(1)=-1.875195532729816_p
w(1)=2.762905176546809e-1_p
x(2)=-1.356549702365023_p
w(2)=5.646912462430306e-1_p
x(3)=-4.764661927873558e-1_p
w(3)=6.410180426074337e-1_p
x(4)=7.081041933943724e-1_p
w(4)=4.390422913430929e-1_p
x(5)=2.199384166452034_p
w(5)=1.660727549069030e-1_p
x(6)=4.057121078098970_p
w(6)=3.501491874403789e-2_p
x(7)=6.328262708512022_p
w(7)=4.432235128975569e-3_p
x(8)=9.040222824208188_p
w(8)=3.486318753482901e-4_p
x(9)=12.2207118684599_p
w(9)=1.687370920430560e-5_p
x(10)=15.89645048341846_p
w(10)=4.902498337103646e-7_p
x(11)=20.06432727326333_p
w(11)=8.483020941766001e-9_p
x(12)=24.57470003223575_p
w(12)=9.616238350617606e-11_p
x(13)=28.6441461493331_p
w(13)=1.154894852827735e-12_p
else if(N==14)then
x(1)=-1.887159899283292_p
w(1)=2.503658770456280e-1_p
x(2)=-1.416612807457801_p
w(2)=5.199478606205696e-1_p
x(3)=-6.126509038460921e-1_p
w(3)=6.176722451605707e-1_p
x(4)=4.742321332167241e-1_p
w(4)=4.677388422486243e-1_p
x(5)=1.834277556213729_p
w(5)=2.079193091516111e-1_p
x(6)=3.511690708453423_p
w(6)=5.368529940511916e-2_p
x(7)=5.548547473885582_p
w(7)=8.626062119531114e-3_p
x(8)=7.965481435179539_p
w(8)=9.066840808311436e-4_p
x(9)=10.77754029366818_p
w(9)=6.288920931304238e-5_p
x(10)=13.99756966483667_p
w(10)=2.855500116258012e-6_p
x(11)=17.62276908423864_p
w(11)=8.475853676340228e-8_p
x(12)=21.59252320634207_p
w(12)=1.713587955214564e-9_p
x(13)=25.65624843832662_p
w(13)=2.821577438137865e-11_p
x(14)=28.99284645725419_p
w(14)=6.239507961964214e-13_p
else if(N==15)then
x(1)=-1.897490339774979_p
w(1)=2.278784427211032e-1_p
x(2)=-1.468792056369413_p
w(2)=4.795617691037588e-1_p
x(3)=-7.319970853859628e-1_p
w(3)=5.912046202898700e-1_p
x(4)=2.688702634431494e-1_p
w(4)=4.863658087816665e-1_p
x(5)=1.516819809591111_p
w(5)=2.481755145322107e-1_p
x(6)=3.042550284336162_p
w(6)=7.645772385281377e-2_p
x(7)=4.883713501050028_p
w(7)=1.506959174465972e-2_p
x(8)=7.058146260368509_p
w(8)=2.015068229913312e-3_p
x(9)=9.574297034552703_p
w(9)=1.868655107960767e-4_p
x(10)=12.4375559186388_p
w(10)=1.204681936323578e-5_p
x(11)=15.64394658913253_p
w(11)=5.416182215034431e-7_p
x(12)=19.16081664962181_p
w(12)=1.739393099121076e-8_p
x(13)=22.87822327819664_p
w(13)=4.336493009230190e-10_p
x(14)=26.48578758306684_p
w(14)=1.053562574326412e-11_p
x(15)=29.22659259901148_p
w(15)=3.862516328245665e-13_p
else if(N==16)then
x(1)=-1.906469505866398_p
w(1)=2.082562854207231e-1_p
x(2)=-1.514378878666013_p
w(2)=4.431617648086759e-1_p
x(3)=-8.370729548584603e-1_p
w(3)=5.632440169378886e-1_p
x(4)=8.744753363803437e-2_p
w(4)=4.962522105897521e-1_p
x(5)=1.238345514527391_p
w(5)=2.849118451941650e-1_p
x(6)=2.635029139773594_p
w(6)=1.024937056745410e-1_p
x(7)=4.310478706595590_p
w(7)=2.413842911008701e-2_p
x(8)=6.281630659849573_p
w(8)=3.959908969805534e-3_p
x(9)=8.553742914783532_p
w(9)=4.671793140960487e-4_p
x(10)=11.12808127664162_p
w(10)=4.003573899067798e-5_p
x(11)=13.99974155364971_p
w(11)=2.508059738209496e-6_p
x(12)=17.14754533288263_p
w(12)=1.168415646197467e-7_p
x(13)=20.51202858670117_p
w(13)=4.243211402897602e-9_p
x(14)=23.94723023985398_p
w(14)=1.346216186853070e-10_p
x(15)=27.12206965868069_p
w(15)=4.755910863515445e-12_p
x(16)=29.38928537731217_p
w(16)=2.622029919709507e-13_p
else if(N==17)then
x(1)=-1.914322074870460_p
w(1)=1.910390291829239e-1_p
x(2)=-1.554418294361086_p
w(2)=4.103586497100479e-1_p
x(3)=-9.299901994201064e-1_p
w(3)=5.349171353560191e-1_p
x(4)=-7.365544410595663e-2_p
w(4)=4.989278455358920e-1_p
x(5)=9.922079164443294e-1_p
w(5)=3.168269531588954e-1_p
x(6)=2.277952117325952_p
w(6)=1.306553471786688e-1_p
x(7)=3.811543642544335_p
w(7)=3.601183589148255e-2_p
x(8)=5.609709240875539_p
w(8)=7.050800839390855e-3_p
x(9)=7.676519449077099_p
w(9)=1.019920762397535e-3_p
x(10)=10.01103220999436_p
w(10)=1.107732723691454e-4_p
x(11)=12.60780242449166_p
w(11)=9.113992275346299e-6_p
x(12)=15.45131468865411_p
w(12)=5.760461445080416e-7_p
x(13)=18.50450466480568_p
w(13)=2.884210270196648e-8_p
x(14)=21.68650367925616_p
w(14)=1.221659160098892e-9_p
x(15)=24.83021496921875_p
w(15)=4.993433574991730e-11_p
x(16)=27.6132403851809_p
w(16)=2.485707005944094e-12_p
x(17)=29.50640544645762_p
w(17)=1.899288663552480e-13_p
else
call GD(-2)
end if
end subroutine GF_m2

! [-1kT;30kT]
subroutine GF_m1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.078062665545136e-1_p
w(1)=1.057155732718490_p
x(2)=2.782863715387483_p
w(2)=2.561059547996387e-1_p
else if(N==3)then
x(1)=-4.522745353022805e-1_p
w(1)=8.263519347869620e-1_p
x(2)=1.608264293393303_p
w(2)=4.657801714989437e-1_p
x(3)=5.568719064519834_p
w(3)=2.112958123222357e-2_p
else if(N==4)then
x(1)=-5.846768224138797e-1_p
w(1)=6.659146826697676e-1_p
x(2)=1.010155084805336_p
w(2)=5.673790583315413e-1_p
x(3)=3.796859762951641_p
w(3)=7.880823682048102e-2_p
x(4)=8.626813640361146_p
w(4)=1.159709696339347e-3_p
else if(N==5)then
x(1)=-6.669557681973231e-1_p
w(1)=5.533306029149249e-1_p
x(2)=6.366359318822591e-1_p
w(2)=6.008955204990546e-1_p
x(3)=2.841235784603139_p
w(3)=1.511251774516737e-1_p
x(4)=6.301913000693788_p
w(4)=7.858621877353630e-3_p
x(5)=11.84448484502321_p
w(5)=5.176477512257208e-5_p
else if(N==6)then
x(1)=-7.227893333348973e-1_p
w(1)=4.713187434521317e-1_p
x(2)=3.788210107648846e-1_p
w(2)=5.988571687630622e-1_p
x(3)=2.222038141857655_p
w(3)=2.197704469977241e-1_p
x(4)=4.979419243345648_p
w(4)=2.272682133684763e-2_p
x(5)=9.025659078386377_p
w(5)=5.864674909279838e-4_p
x(6)=15.16197041319771_p
w(6)=2.039477435715944e-6_p
else if(N==7)then
x(1)=-7.632227810690183e-1_p
w(1)=4.091216146565310e-1_p
x(2)=1.888125476766101e-1_p
w(2)=5.796361077895926e-1_p
x(3)=1.779451219287759_p
w(3)=2.768702394308623e-1_p
x(4)=4.090908780117044_p
w(4)=4.514160358669803e-2_p
x(5)=7.349908352298005_p
w(5)=2.455039359881186e-3_p
x(6)=11.8832153549113_p
w(6)=3.700638675267071e-5_p
x(7)=18.51002268349497_p
w(7)=7.630781142027498e-8_p
else if(N==8)then
x(1)=-7.942348176459271e-1_p
w(1)=3.598377697360340e-1_p
x(2)=4.077923931607996e-2_p
w(2)=5.523824826081705e-1_p
x(3)=1.439550467329046_p
w(3)=3.210761475882162e-1_p
x(4)=3.433980130528981_p
w(4)=7.316469657292314e-2_p
x(5)=6.176736539190704_p
w(5)=6.575515025185078e-3_p
x(6)=9.848860754400100_p
w(6)=2.228562193763000e-4_p
x(7)=14.76379734834394_p
w(7)=2.216552426837787e-6_p
x(8)=21.69899291706912_p
w(8)=3.215797279076040e-9_p
else if(N==9)then
x(1)=-8.192089450442220e-1_p
w(1)=3.191642251008440e-1_p
x(2)=-8.005770969806962e-2_p
w(2)=5.213465800393586e-1_p
x(3)=1.163624517638475_p
w(3)=3.533709456721005e-1_p
x(4)=2.914452212242553_p
w(4)=1.048009858556528e-1_p
x(5)=5.278239994670038_p
w(5)=1.374976123816172e-2_p
x(6)=8.372763489945562_p
w(6)=8.096154871485864e-4_p
x(7)=12.35314318518117_p
w(7)=1.942632971904367e-5_p
x(8)=17.50133321616988_p
w(8)=1.475881621651682e-7_p
x(9)=24.37690304829557_p
w(9)=2.069818660901169e-10_p
else if(N==10)then
x(1)=-8.399125172770163e-1_p
w(1)=2.847883639870817e-1_p
x(2)=-1.813957531832187e-1_p
w(2)=4.888575587789053e-1_p
x(3)=9.323737970337386e-1_p
w(3)=3.749703238622836e-1_p
x(4)=2.487278814572772_p
w(4)=1.378872486960687e-1_p
x(5)=4.555957810881784_p
w(5)=2.447879891175080e-2_p
x(6)=7.222993261932618_p
w(6)=2.182274965609892e-3_p
x(7)=10.5764749267019_p
w(7)=9.527842107900706e-5_p
x(8)=14.74769775250087_p
w(8)=1.827207641097220e-6_p
x(9)=19.94019063713465_p
w(9)=1.266236835433932e-8_p
x(10)=26.29775584595241_p
w(10)=2.534084194094815e-11_p
else if(N==11)then
x(1)=-8.573072141733997e-1_p
w(1)=2.554522178288790e-1_p
x(2)=-2.673738868720177e-1_p
w(2)=4.565045590124753e-1_p
x(3)=7.357605012727364e-1_p
w(3)=3.872474762855978e-1_p
x(4)=2.129164358954891_p
w(4)=1.701702484907645e-1_p
x(5)=3.961028337599113_p
w(5)=3.875520009261866e-2_p
x(6)=6.295767471075730_p
w(6)=4.793958327662381e-3_p
x(7)=9.189281874989533_p
w(7)=3.261585384014850e-4_p
x(8)=12.71062705841653_p
w(8)=1.166612376886654e-5_p
x(9)=16.9523360521029_p
w(9)=2.012924226255026e-7_p
x(10)=21.99756336467757_p
w(10)=1.519840416788625e-9_p
x(11)=27.53048691413657_p
w(11)=5.698212510096262e-12_p
else if(N==12)then
x(1)=-8.720457666325987e-1_p
w(1)=2.302753373226090e-1_p
x(2)=-3.408260755934145e-1_p
w(2)=4.253104673924351e-1_p
x(3)=5.671769960560900e-1_p
w(3)=3.918332089983201e-1_p
x(4)=1.825170152547565_p
w(4)=1.997904403796794e-1_p
x(5)=3.463223669393261_p
w(5)=5.607067075739056e-2_p
x(6)=5.531745554715682_p
w(6)=9.059705621225246e-3_p
x(7)=8.070026126356872_p
w(7)=8.709879629568404e-4_p
x(8)=11.11736671750126_p
w(8)=4.926521203803417e-5_p
x(9)=14.72066937533879_p
w(9)=1.576308169984388e-6_p
x(10)=18.9198659456523_p
w(10)=2.730114846633897e-8_p
x(11)=23.6603714701183_p
w(11)=2.601620424676590e-10_p
x(12)=28.29264828578932_p
w(12)=1.994616408966696e-12_p
else if(N==13)then
x(1)=-8.846303748085728e-1_p
w(1)=2.085481962040819e-1_p
x(2)=-4.039812151124012e-1_p
w(2)=3.958416901312103e-1_p
x(3)=4.215837070161062e-1_p
w(3)=3.904019088610058e-1_p
x(4)=1.564403795553205_p
w(4)=2.255243803540146e-1_p
x(5)=3.041260510477883_p
w(5)=7.557613406968951e-2_p
x(6)=4.891761091255381_p
w(6)=1.526452754980184e-2_p
x(7)=7.146048213578762_p
w(7)=1.940122189862369e-3_p
x(8)=9.828085446437942_p
w(8)=1.565757202575506e-4_p
x(9)=12.96287143651389_p
w(9)=7.903050854291317e-6_p
x(10)=16.56969243951371_p
w(10)=2.446539302663555e-7_p
x(11)=20.62964265091459_p
w(11)=4.670510669797242e-9_p
x(12)=24.96321932285768_p
w(12)=6.197738170848701e-11_p
x(13)=28.77020667333369_p
w(13)=9.327565514230182e-13_p
else if(N==14)then
x(1)=-8.954555061047553e-1_p
w(1)=1.896914053857612e-1_p
x(2)=-4.586268017525584e-1_p
w(2)=3.683591654430601e-1_p
x(3)=2.950132574447678e-1_p
w(3)=3.844738439810889e-1_p
x(4)=1.338658398991842_p
w(4)=2.467596756619423e-1_p
x(5)=2.679538820216133_p
w(5)=9.626619555910851e-2_p
x(6)=4.348401931048382_p
w(6)=2.350978361458079e-2_p
x(7)=6.369883960284213_p
w(7)=3.766471769954066e-3_p
x(8)=8.759784302490582_p
w(8)=4.045895037580603e-4_p
x(9)=11.53161459466394_p
w(9)=2.911648574049532e-5_p
x(10)=14.69419209100059_p
w(10)=1.394399325005695e-6_p
x(11)=18.23646736538458_p
w(11)=4.468317145795779e-8_p
x(12)=22.08342169656148_p
w(12)=1.010534316111847e-9_p
x(13)=25.96554034602406_p
w(13)=1.957866238448504e-11_p
x(14)=29.08007428885669_p
w(14)=5.255133311863219e-13_p
else if(N==15)then
x(1)=-9.048317810979117e-1_p
w(1)=1.732346631829081e-1_p
x(2)=-5.061952107312496e-1_p
w(2)=3.429370478550861e-1_p
x(3)=1.843174726922250e-1_p
w(3)=3.753292439551085e-1_p
x(4)=1.141667735765708_p
w(4)=2.633671801863153e-1_p
x(5)=2.366407556550821_p
w(5)=1.171380082559116e-1_p
x(6)=3.881834994581255_p
w(6)=3.370171547416040e-2_p
x(7)=5.708827203438091_p
w(7)=6.568483805983025e-3_p
x(8)=7.858823484965142_p
w(8)=8.936635249099359e-4_p
x(9)=10.33905258934396_p
w(9)=8.561419388937164e-5_p
x(10)=13.15270704894305_p
w(10)=5.780235356368012e-6_p
x(11)=16.29111033278718_p
w(11)=2.768658481188958e-7_p
x(12)=19.71376085503309_p
w(12)=9.701740038902448e-9_p
x(13)=23.29969881912903_p
w(13)=2.728129500773861e-10_p
x(14)=26.73161151838649_p
w(14)=7.764744468965296e-12_p
x(15)=29.28926548343783_p
w(15)=3.346951717891649e-13_p
else if(N==16)then
x(1)=-9.130051886498416e-1_p
w(1)=1.587963030310755e-1_p
x(2)=-5.478377832304935e-1_p
w(2)=3.195400412884026e-1_p
x(3)=8.697552047666517e-2_p
w(3)=3.639956299406364e-1_p
x(4)=9.685775501948040e-1_p
w(4)=2.755543900269449e-1_p
x(5)=2.093016804002169_p
w(5)=1.373060258061377e-1_p
x(6)=3.477323038540976_p
w(6)=4.557514510094040e-2_p
x(7)=5.139421520281456_p
w(7)=1.051549337463304e-2_p
x(8)=7.088449406659178_p
w(8)=1.746401837096768e-3_p
x(9)=9.328197425007337_p
w(9)=2.120149967248148e-4_p
x(10)=11.85874741360074_p
w(10)=1.892511955592265e-5_p
x(11)=14.67241953201699_p
w(11)=1.251747731121735e-6_p
x(12)=17.74338638608466_p
w(12)=6.265296683939922e-8_p
x(13)=21.00566864746308_p
w(13)=2.501596330455201e-9_p
x(14)=24.30668678134484_p
w(14)=8.977799577176933e-11_p
x(15)=27.31844434671855_p
w(15)=3.677138219962461e-12_p
x(16)=29.43587030736705_p
w(16)=2.317816567665878e-13_p
else if(N==17)then
x(1)=-9.201721094836257e-1_p
w(1)=1.460653960800349e-1_p
x(2)=-5.844855377555161e-1_p
w(2)=2.980718372998667e-1_p
x(3)=9.484943436798918e-4_p
w(3)=3.512701839015125e-1_p
x(4)=8.155688383408723e-1_p
w(4)=2.837339234462328e-1_p
x(5)=1.852534990579970_p
w(5)=1.560678534710231e-1_p
x(6)=3.123666008233588_p
w(6)=5.873951673602620e-2_p
x(7)=4.644299939456907_p
w(7)=1.570291626825174e-2_p
x(8)=6.422358482896009_p
w(8)=3.094716509886363e-3_p
x(9)=8.459840445486813_p
w(9)=4.588820628685694e-4_p
x(10)=10.7551280870438_p
w(10)=5.168486527182032e-5_p
x(11)=13.30114382401104_p
w(11)=4.460147836258319e-6_p
x(12)=16.07948292549945_p
w(12)=2.997049956912573e-7_p
x(13)=19.04902225548453_p
w(13)=1.622801776440848e-8_p
x(14)=22.12428626178344_p
w(14)=7.590953692827815e-10_p
x(15)=25.13597485895138_p
w(15)=3.504345470518041e-11_p
x(16)=27.77153515675816_p
w(16)=1.995663708185668e-12_p
x(17)=29.54206525187571_p
w(17)=1.703418987183081e-13_p
else
call GD(-1)
end if
end subroutine GF_m1

! [0kT;30kT]
subroutine GF_0(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=6.905392549622149e-1_p
w(1)=5.746633477136057e-1_p
x(2)=3.592384068038296_p
w(2)=1.184838328462460e-1_p
else if(N==3)then
x(1)=4.840534525048435e-1_p
w(1)=4.633605373499075e-1_p
x(2)=2.446744755679928_p
w(2)=2.207494256156386e-1_p
x(3)=6.424351910554018_p
w(3)=9.037217594305660e-3_p
else if(N==4)then
x(1)=3.712750550276717e-1_p
w(1)=3.825383403139221e-1_p
x(2)=1.875429818770171_p
w(2)=2.763015036466671e-1_p
x(3)=4.661462828646605_p
w(3)=3.382573843919810e-2_p
x(4)=9.507072814636205_p
w(4)=4.815981600644379e-4_p
else if(N==5)then
x(1)=3.004679987621822e-1_p
w(1)=3.238003784898136e-1_p
x(2)=1.524107747701783_p
w(2)=3.004829420619879e-1_p
x(3)=3.713586924342065_p
w(3)=6.559653542203568e-2_p
x(4)=7.189694083733896_p
w(4)=3.246150304883040e-3_p
x(5)=12.73893456041382_p
w(5)=2.117428113149175e-5_p
else if(N==6)then
x(1)=2.519384656867165e-1_p
w(1)=2.798023927605287e-1_p
x(2)=1.283920302806619_p
w(2)=3.068347086413593e-1_p
x(3)=3.102002744098719_p
w(3)=9.688727152311261e-2_p
x(4)=5.871682251953978_p
w(4)=9.383271440111777e-3_p
x(5)=9.925353692588642_p
w(5)=2.387078505462162e-4_p
x(6)=16.06277245143514_p
w(6)=8.283441930944024e-7_p
else if(N==7)then
x(1)=2.164182591253747e-1_p
w(1)=2.456170232531913e-1_p
x(2)=1.107561326128935_p
w(2)=3.034988455977747e-1_p
x(3)=2.666325760610290_p
w(3)=1.242951009867823e-1_p
x(4)=4.984542893563705_p
w(4)=1.872201030534841e-2_p
x(5)=8.249798931949019_p
w(5)=9.991070046452071e-4_p
x(6)=12.78093778778532_p
w(6)=1.506195569692723e-5_p
x(7)=19.3922401039275_p
w(7)=3.145641291275750e-8_p
else if(N==8)then
x(1)=1.888494180753585e-1_p
w(1)=2.179093843199849e-1_p
x(2)=9.699989190046777e-1_p
w(2)=2.948271449856841e-1_p
x(3)=2.332189386348564_p
w(3)=1.470084533997281e-1_p
x(4)=4.326161067893349_p
w(4)=3.062136890184181e-2_p
x(5)=7.071760460193816_p
w(5)=2.688458712703997e-3_p
x(6)=10.73662203648899_p
w(6)=9.144193406097705e-5_p
x(7)=15.62958933767052_p
w(7)=9.268757934566665e-7_p
x(8)=22.49080961658646_p
w(8)=1.430054452164891e-9_p
else if(N==9)then
x(1)=1.664364857740422e-1_p
w(1)=1.946185291539263e-1_p
x(2)=8.575621422422584e-1_p
w(2)=2.830473460345792e-1_p
x(3)=2.061717505160829_p
w(3)=1.651003661308522e-1_p
x(4)=3.804750463779527_p
w(4)=4.438071032614915e-2_p
x(5)=6.167372313225545_p
w(5)=5.657031684646818e-3_p
x(6)=9.250499790481324_p
w(6)=3.349081589737526e-4_p
x(7)=13.2045627111828_p
w(7)=8.223253277131763e-6_p
x(8)=18.29550720651786_p
w(8)=6.571055414066162e-8_p
x(9)=24.99083685916795_p
w(9)=1.068930718885516e-10_p
else if(N==10)then
x(1)=1.477582890372907e-1_p
w(1)=1.746813069670231e-1_p
x(2)=7.633797955344981e-1_p
w(2)=2.695086466211856e-1_p
x(3)=1.836416895827319_p
w(3)=1.787301082752128e-1_p
x(4)=3.377285744726137_p
w(4)=5.915112243150452e-2_p
x(5)=5.441376897184881_p
w(5)=1.012783516881433e-2_p
x(6)=8.095007769975087_p
w(6)=9.067959560522135e-4_p
x(7)=11.42112255856991_p
w(7)=4.054575589189480e-5_p
x(8)=15.54266869699639_p
w(8)=8.132077228030592e-7_p
x(9)=20.63431263428523_p
w(9)=6.160972486560996e-9_p
x(10)=26.71679870895879_p
w(10)=1.547196053300820e-11_p
else if(N==11)then
x(1)=1.320140299015136e-1_p
w(1)=1.575021619068897e-1_p
x(2)=6.836202851721309e-1_p
w(2)=2.551762499330135e-1_p
x(3)=1.646186157359436_p
w(3)=1.882001714518115e-1_p
x(4)=3.020671427501270_p
w(4)=7.401132983490701e-2_p
x(5)=4.845075339343623_p
w(5)=1.611794745974901e-2_p
x(6)=7.165802856532985_p
w(6)=1.995220020872571e-3_p
x(7)=10.0327161993686_p
w(7)=1.388347281998414e-4_p
x(8)=13.51006269711867_p
w(8)=5.168972571649144e-6_p
x(9)=17.67718513675638_p
w(9)=9.543086101653047e-8_p
x(10)=22.58048065759554_p
w(10)=8.170000555439503e-10_p
x(11)=27.80121734417488_p
w(11)=3.975882813023504e-12_p
else if(N==12)then
x(1)=1.186356537895724e-1_p
w(1)=1.426354047685729e-1_p
x(2)=6.155633147278429e-1_p
w(2)=2.407176790179885e-1_p
x(3)=1.484068790802373_p
w(3)=1.940092943973096e-1_p
x(4)=2.719499587464482_p
w(4)=8.817002111898481e-2_p
x(5)=4.347510820783546_p
w(5)=2.345063703900480e-2_p
x(6)=6.401982619173558_p
w(6)=3.771781390970329e-3_p
x(7)=8.915124969865888_p
w(7)=3.699242659078739e-4_p
x(8)=11.92301565011746_p
w(8)=2.169062655659716e-5_p
x(9)=15.46556869085135_p
w(9)=7.338816115647508e-7_p
x(10)=19.56659358706858_p
w(10)=1.389715014777152e-8_p
x(11)=24.13512002747909_p
w(11)=1.542700032188102e-10_p
x(12)=28.46828260674132_p
w(12)=1.524586780561644e-12_p
else if(N==13)then
x(1)=1.071809285075112e-1_p
w(1)=1.297096184100764e-1_p
x(2)=5.570771040659482e-1_p
w(2)=2.265610392646302e-1_p
x(3)=1.344762975720825_p
w(3)=1.967523026022221e-1_p
x(4)=2.462443364570984_p
w(4)=1.010578606550796e-1_p
x(5)=3.926867861777174_p
w(5)=3.181711167022424e-2_p
x(6)=5.763389144161920_p
w(6)=6.355721999232742e-3_p
x(7)=7.994184719275926_p
w(7)=8.213158558696085e-4_p
x(8)=10.64052148769267_p
w(8)=6.846132500892991e-5_p
x(9)=13.72339252733826_p
w(9)=3.625720201218132e-6_p
x(10)=17.25361974536527_p
w(10)=1.204566338327838e-7_p
x(11)=21.19587412338356_p
w(11)=2.559784523538944e-9_p
x(12)=25.342414417493_p
w(12)=4.013143920519941e-11_p
x(13)=28.88782881750962_p
w(13)=7.567943284393951e-13_p
else if(N==14)then
x(1)=9.730193166516954e-2_p
w(1)=1.184161241168541e-1_p
x(2)=5.064726653491256e-1_p
w(2)=2.129644318244809e-1_p
x(3)=1.224152594262693_p
w(3)=1.970235659656116e-1_p
x(4)=2.240977173671334_p
w(4)=1.123268788828490e-1_p
x(5)=3.567240391388452_p
w(5)=4.084347919361620e-2_p
x(6)=5.222100338383900_p
w(6)=9.794283604566230e-3_p
x(7)=7.221695899504068_p
w(7)=1.588859454579019e-3_p
x(8)=9.579070561960114_p
w(8)=1.756736601586020e-4_p
x(9)=12.30527624357947_p
w(9)=1.318972664370697e-5_p
x(10)=15.40424688596321_p
w(10)=6.701757207172119e-7_p
x(11)=18.85619287743111_p
w(11)=2.334549187513204e-8_p
x(12)=22.57191499414086_p
w(12)=5.951868877333639e-10_p
x(13)=26.26594627333697_p
w(13)=1.364935197916000e-11_p
x(14)=29.16199017558822_p
w(14)=4.435424278413592e-13_p
else if(N==15)then
x(1)=8.872422248152018e-2_p
w(1)=1.085007163930649e-1_p
x(2)=4.624088949899418e-1_p
w(2)=2.000716537051369e-1_p
x(3)=1.119015580676255_p
w(3)=1.953643834302794e-1_p
x(4)=2.048597677866329_p
w(4)=1.218148006645206e-1_p
x(5)=3.256785554992348_p
w(5)=5.014743550163153e-2_p
x(6)=4.758021604202263_p
w(6)=1.405984285917136e-2_p
x(7)=6.564581185403656_p
w(7)=2.761699514469479e-3_p
x(8)=8.684794431171275_p
w(8)=3.854283731565328e-4_p
x(9)=11.12420929741147_p
w(9)=3.834927771343547e-5_p
x(10)=13.88305173895072_p
w(10)=2.725414219597841e-6_p
x(11)=16.94750894369671_p
w(11)=1.398671096935488e-7_p
x(12)=20.26917602954722_p
w(12)=5.381597715847818e-9_p
x(13)=23.71694812288441_p
w(13)=1.717453109328435e-10_p
x(14)=26.96980111575526_p
w(14)=5.745040349035606e-12_p
x(15)=29.34850331427857_p
w(15)=2.901967382187227e-13_p
else if(N==16)then
x(1)=8.122990982035233e-2_p
w(1)=9.975436123742641e-2_p
x(2)=4.238144349495395e-1_p
w(2)=1.879512387142216e-1_p
x(3)=1.026803040685212_p
w(3)=1.922414830949790e-1_p
x(4)=1.880271556268101_p
w(4)=1.295001443897242e-1_p
x(5)=2.986514325176596_p
w(5)=5.937922261827606e-2_p
x(6)=4.356276978348997_p
w(6)=1.905995938888739e-2_p
x(7)=5.999190042460761_p
w(7)=4.408860414156728e-3_p
x(8)=7.920830822017976_p
w(8)=7.484679704027999e-4_p
x(9)=10.1236307887874_p
w(9)=9.401020281949262e-5_p
x(10)=12.6058082380703_p
w(10)=8.781467395566201e-6_p
x(11)=15.35648132364199_p
w(11)=6.162152862166431e-7_p
x(12)=18.34503710815332_p
w(12)=3.331283645558784e-8_p
x(13)=21.49926573803177_p
w(13)=1.470416613405390e-9_p
x(14)=24.66118518553083_p
w(14)=5.996716846689422e-11_p
x(15)=27.50859337651265_p
w(15)=2.851329193448655e-12_p
x(16)=29.48016073520667_p
w(16)=2.048260567875703e-13_p
else if(N==17)then
x(1)=7.464454954588876e-2_p
w(1)=9.200472434289786e-2_p
x(2)=3.898266223250045e-1_p
w(2)=1.766230627802647e-1_p
x(3)=9.454758650715339e-1_p
w(3)=1.880429941104884e-1_p
x(4)=1.732046034969650_p
w(4)=1.354589807194106e-1_p
x(5)=2.749482797526667_p
w(5)=6.824611320202771e-2_p
x(6)=4.005589722669287_p
w(6)=2.465477848708524e-2_p
x(7)=5.508055870353312_p
w(7)=6.570253376615573e-3_p
x(8)=7.260826796528747_p
w(8)=1.318696195037458e-3_p
x(9)=9.264579439473307_p
w(9)=2.016110677984350e-4_p
x(10)=11.51647782915971_p
w(10)=2.365244123891347e-5_p
x(11)=14.00738091710189_p
w(11)=2.149970851000592e-6_p
x(12)=16.71581619695584_p
w(12)=1.542909773060200e-7_p
x(13)=19.59667984708848_p
w(13)=9.077703645516541e-9_p
x(14)=22.56039661589628_p
w(14)=4.710585212395784e-10_p
x(15)=25.43672969035928_p
w(15)=2.463840999046192e-11_p
x(16)=27.92487641590829_p
w(16)=1.605353739121297e-12_p
x(17)=29.57614262342637_p
w(17)=1.526408487533269e-13_p
else
call GD(0)
end if
end subroutine GF_0

! [1kT;30kT]
subroutine GF_1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=1.631825456248780_p
w(1)=2.640326500761633e-1_p
x(2)=4.490327167258881_p
w(2)=4.922903744196601e-2_p
else if(N==3)then
x(1)=1.446129726766344_p
w(1)=2.168209614697316e-1_p
x(2)=3.359537071064013_p
w(2)=9.283915476198841e-2_p
x(3)=7.347310931215376_p
w(3)=3.601571286409238e-3_p
else if(N==4)then
x(1)=1.344409540393048_p
w(1)=1.816941046250355e-1_p
x(2)=2.801536278920493_p
w(2)=1.178922229086259e-1_p
x(3)=5.589733580525595_p
w(3)=1.348632134237426e-2_p
x(4)=10.44290965865248_p
w(4)=1.890386420936406e-4_p
else if(N==5)then
x(1)=1.280229328948570_p
w(1)=1.556262139406970e-1_p
x(2)=2.461253987671356_p
w(2)=1.300848576758794e-1_p
x(3)=4.646052824793444_p
w(3)=2.627233301513359e-2_p
x(4)=8.129751905904147_p
w(4)=1.270034548547387e-3_p
x(5)=13.68190531357041_p
w(5)=8.248337871864875e-6_p
else if(N==6)then
x(1)=1.235987981749751_p
w(1)=1.357474496753815e-1_p
x(2)=2.229841539406415_p
w(2)=1.346667243845227e-1_p
x(3)=4.037972229460173_p
w(3)=3.908444111744645e-2_p
x(4)=6.813648735207184_p
w(4)=3.669906051740199e-3_p
x(5)=10.86974184079334_p
w(5)=9.284364137520580e-5_p
x(6)=17.00486861751281_p
w(6)=3.226476632686170e-7_p
else if(N==7)then
x(1)=1.203353261498056_p
w(1)=1.200312014807022e-1_p
x(2)=2.060098811588997_p
w(2)=1.348845574459062e-1_p
x(3)=3.604512737553172_p
w(3)=5.060400951719489e-2_p
x(4)=5.925202836896561_p
w(4)=7.346176918194557e-3_p
x(5)=9.190239617258756_p
w(5)=3.898187352832129e-4_p
x(6)=13.7139949081057_p
w(6)=5.910801573031527e-6_p
x(7)=20.29911950302117_p
w(7)=1.261927521095105e-8_p
else if(N==8)then
x(1)=1.177790265031082_p
w(1)=1.070727347485751e-1_p
x(2)=1.927415561402892_p
w(2)=1.325220960701029e-1_p
x(3)=3.271347361872636_p
w(3)=6.048388040197451e-2_p
x(4)=5.262855152647492_p
w(4)=1.209013092502193e-2_p
x(5)=8.003929063252277_p
w(5)=1.056140224249873e-3_p
x(6)=11.65502914829827_p
w(6)=3.632597519722033e-5_p
x(7)=16.5165560635452_p
w(7)=3.785376217790057e-7_p
x(8)=23.27607183952723_p
w(8)=6.353859215706290e-10_p
else if(N==9)then
x(1)=1.156883040330617_p
w(1)=9.603967482644987e-2_p
x(2)=1.818947097860465_p
w(2)=1.285353536234717e-1_p
x(3)=3.001889993307245_p
w(3)=6.866659081379756e-2_p
x(4)=4.737677121279925_p
w(4)=1.764566250878041e-2_p
x(5)=7.091936087069888_p
w(5)=2.236633352911662e-3_p
x(6)=10.15694960762528_p
w(6)=1.343418622221103e-4_p
x(7)=14.07677154829229_p
w(7)=3.401524568909624e-6_p
x(8)=19.09638759556574_p
w(8)=2.894964163297097e-8_p
x(9)=25.57456299659133_p
w(9)=5.628537689121473e-11_p
else if(N==10)then
x(1)=1.139422573072240_p
w(1)=8.651969194057500e-2_p
x(2)=1.728336744417941_p
w(2)=1.235358329075278e-1_p
x(3)=2.778423541830650_p
w(3)=7.512687980271887e-2_p
x(4)=4.308285512531827_p
w(4)=2.367548679490351e-2_p
x(5)=6.361478647311515_p
w(5)=4.021125967998921e-3_p
x(6)=8.995176383428960_p
w(6)=3.654595305150425e-4_p
x(7)=12.28726310551512_p
w(7)=1.685103722937857e-5_p
x(8)=16.34980872329569_p
w(8)=3.565312964490566e-7_p
x(9)=21.3243284201084_p
w(9)=2.995707533856362e-9_p
x(10)=27.10445497652039_p
w(10)=9.656749782136749e-12_p
else if(N==11)then
x(1)=1.124691591543936_p
w(1)=7.826797774618897e-2_p
x(2)=1.651844522947080_p
w(2)=1.179715277757986e-1_p
x(3)=2.590715307330147_p
w(3)=7.992471018685632e-2_p
x(4)=3.951418024274713_p
w(4)=2.981573635823940e-2_p
x(5)=5.763305150000617_p
w(5)=6.416607252541496e-3_p
x(6)=8.063752852713311_p
w(6)=8.051451334790863e-4_p
x(7)=10.89817712636369_p
w(7)=5.768697896742407e-5_p
x(8)=14.32447346677148_p
w(8)=2.250764664068225e-6_p
x(9)=18.40686598691194_p
w(9)=4.487694238093443e-8_p
x(10)=23.15270557760707_p
w(10)=4.416323429062623e-10_p
x(11)=28.04939479652756_p
w(11)=2.819198023858600e-12_p
else if(N==12)then
x(1)=1.112163015728284_p
w(1)=7.108950528704198e-2_p
x(2)=1.586737892540994_p
w(2)=1.121617542013798e-1_p
x(3)=2.431488241876839_p
w(3)=8.321591065377069e-2_p
x(4)=3.651125581716782_p
w(4)=3.575455201237811e-2_p
x(5)=5.265485699252793_p
w(5)=9.355570548981333e-3_p
x(6)=7.299973607865340_p
w(6)=1.521372354524471e-3_p
x(7)=9.782543359729098_p
w(7)=1.533048218082744e-4_p
x(8)=12.74517747290811_p
w(8)=9.372825781020278e-6_p
x(9)=16.21959125292914_p
w(9)=3.376635273684719e-7_p
x(10)=20.21235975505785_p
w(10)=7.055511626081524e-9_p
x(11)=24.59650843365049_p
w(11)=9.224764147273003e-11_p
x(12)=28.6295933873993_p
w(12)=1.176971984860537e-12_p
else if(N==13)then
x(1)=1.101425167653680_p
w(1)=6.481840896500135e-2_p
x(2)=1.530889609298845_p
w(2)=1.063229304012621e-1_p
x(3)=2.295211559350945_p
w(3)=8.520656072427818e-2_p
x(4)=3.395685276483288_p
w(4)=4.126239655583083e-2_p
x(5)=4.845589130652406_p
w(5)=1.272055367312611e-2_p
x(6)=6.662652610750705_p
w(6)=2.560658890737176e-3_p
x(7)=8.864810847894521_p
w(7)=3.391234227790758e-4_p
x(8)=11.4703863073068_p
w(8)=2.935417893379385e-5_p
x(9)=14.49546804796489_p
w(9)=1.640384663532240e-6_p
x(10)=17.94171632104243_p
w(10)=5.889002003957939e-8_p
x(11)=21.75717483672714_p
w(11)=1.404667827102980e-9_p
x(12)=25.70842914656373_p
w(12)=2.621172317174067e-11_p
x(13)=28.99655141222062_p
w(13)=6.174978126152072e-13_p
else if(N==14)then
x(1)=1.092154927175116_p
w(1)=5.931552908610550e-2_p
x(2)=1.482632903182353_p
w(2)=1.005964215998728e-1_p
x(3)=2.177629652591419_p
w(3)=8.611358553096013e-2_p
x(4)=3.176312786922230_p
w(4)=4.619117500382153e-2_p
x(5)=4.487359792736407_p
w(5)=1.636971355606057e-2_p
x(6)=6.123330621454931_p
w(6)=3.940906310690762e-3_p
x(7)=8.096115354353154_p
w(7)=6.533849380576762e-4_p
x(8)=10.41637436381805_p
w(8)=7.475567090508344e-5_p
x(9)=13.09201504157897_p
w(9)=5.884333755159218e-6_p
x(10)=16.12155030639175_p
w(10)=3.189693509099980e-7_p
x(11)=19.476218062494_p
w(11)=1.215680582228943e-8_p
x(12)=23.05326248667827_p
w(12)=3.517798785825443e-10_p
x(13)=26.55481196877149_p
w(13)=9.587998284626338e-12_p
x(14)=29.23827407563225_p
w(14)=3.754547682399498e-13_p
else if(N==15)then
x(1)=1.084097681367454_p
w(1)=5.446526641687548e-2_p
x(2)=1.440655331395018_p
w(2)=9.507091789501843e-2_p
x(3)=2.075436977155330_p
w(3)=8.614244847121488e-2_p
x(4)=2.986327447538145_p
w(4)=5.046188893577319e-2_p
x(5)=4.178742911218119_p
w(5)=2.015802228397770e-2_p
x(6)=5.661619113390911_p
w(6)=5.650994608315735e-3_p
x(7)=7.443038466392231_p
w(7)=1.131070408562205e-3_p
x(8)=9.529187456340178_p
w(8)=1.628332245079644e-4_p
x(9)=11.92346142824981_p
w(9)=1.690167364697228e-5_p
x(10)=14.62265462191553_p
w(10)=1.270290036098886e-6_p
x(11)=17.60759424491843_p
w(11)=7.021368795990467e-8_p
x(12)=20.82213803420656_p
w(12)=2.983378746015175e-9_p
x(13)=24.12622122922745_p
w(13)=1.086056521154191e-10_p
x(14)=27.19850821374605_p
w(14)=4.276313578982595e-12_p
x(15)=29.4040618724232_p
w(15)=2.519318800042686e-13_p
else if(N==16)then
x(1)=1.077051268522123_p
w(1)=5.017176516327485e-2_p
x(2)=1.403914877117539_p
w(2)=8.979870084967018e-2_p
x(3)=1.986036057445629_p
w(3)=8.547657149331142e-2_p
x(4)=2.820569277996643_p
w(4)=5.404907372133820e-2_p
x(5)=3.910609939012855_p
w(5)=2.395220243335733e-2_p
x(6)=5.262472595793743_p
w(6)=7.655265266624776e-3_p
x(7)=6.881744298038888_p
w(7)=1.798715780957318e-3_p
x(8)=8.771930728073459_p
w(8)=3.140634947308414e-4_p
x(9)=10.93387391182204_p
w(9)=4.098705817279832e-5_p
x(10)=13.36351446849369_p
w(10)=4.022876130113112e-6_p
x(11)=16.04654543809596_p
w(11)=3.008233015846019e-7_p
x(12)=18.94758697471921_p
w(12)=1.764930590488856e-8_p
x(13)=21.98866284343098_p
w(13)=8.653115847192834e-10_p
x(14)=25.00779492525973_p
w(14)=4.024040701657331e-11_p
x(15)=27.69119382371253_p
w(15)=2.220901390616259e-12_p
x(16)=29.52196410972166_p
w(16)=1.810465216023048e-13_p
else if(N==17)then
x(1)=1.070853749415388_p
w(1)=4.635538568888201e-2_p
x(2)=1.371576532353379_p
w(2)=8.480719606034938e-2_p
x(3)=1.907361673959013_p
w(3)=8.427362000750815e-2_p
x(4)=2.674993608933803_p
w(4)=5.696567186115992e-2_p
x(5)=3.675918894122549_p
w(5)=2.763945097909312e-2_p
x(6)=4.914512802477195_p
w(6)=9.900525559151920e-3_p
x(7)=6.394663946893998_p
w(7)=2.671161244813780e-3_p
x(8)=8.118244709012099_p
w(8)=5.498422942398686e-4_p
x(9)=10.08464997030133_p
w(9)=8.704667348881002e-5_p
x(10)=12.28947023869223_p
w(10)=1.067658956534499e-5_p
x(11)=14.72127332024642_p
w(11)=1.026202767511541e-6_p
x(12)=17.35547400807764_p
w(12)=7.897519454307272e-8_p
x(13)=20.1431856743782_p
w(13)=5.070127251884899e-9_p
x(14)=22.99136995713906_p
w(14)=2.929588589539984e-10_p
x(15)=25.73019278032432_p
w(15)=1.739660438082272e-11_p
x(16)=28.07228644383394_p
w(16)=1.295471134100883e-12_p
x(17)=29.60848366863395_p
w(17)=1.367210587960696e-13_p
else
call GD(1)
end if
end subroutine GF_1

! [2kT;30kT]
subroutine GF_2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=2.604167181753275_p
w(1)=1.077990759039410e-1_p
x(2)=5.444196989988682_p
w(2)=1.912893513893789e-2_p
else if(N==3)then
x(1)=2.427959708569824_p
w(1)=8.929228741583291e-2_p
x(2)=4.320004303400430_p
w(2)=3.626217304676625e-2_p
x(3)=8.312534840022057_p
w(3)=1.373550580279761e-3_p
else if(N==4)then
x(1)=2.331360990664846_p
w(1)=7.536969676535622e-2_p
x(2)=3.767786254385082_p
w(2)=4.634410657358905e-2_p
x(3)=6.557480453665055_p
w(3)=5.142593963321233e-3_p
x(4)=11.41385379603198_p
w(4)=7.161374061240277e-5_p
else if(N==5)then
x(1)=2.270285450545287_p
w(1)=6.493401555322667e-2_p
x(2)=3.432246552082125_p
w(2)=5.147467037588539e-2_p
x(3)=5.615621332493097_p
w(3)=1.003574378849614e-2_p
x(4)=9.102411714068054_p
w(4)=4.804653312221949e-4_p
x(5)=14.65534219699154_p
w(5)=3.115994048530821e-6_p
else if(N==6)then
x(1)=2.228041759762313_p
w(1)=5.689933424772052e-2_p
x(2)=3.204423576237275_p
w(2)=5.362538118620931e-2_p
x(3)=5.008475940223007_p
w(3)=1.497868002971565e-2_p
x(4)=7.785906680872967_p
w(4)=1.389366837173505e-3_p
x(5)=11.84119614873383_p
w(5)=3.512607001026732e-5_p
x(6)=17.97037948573158_p
w(6)=1.226720496658858e-7_p
else if(N==7)then
x(1)=2.196687223539375_p
w(1)=5.047470651362180e-2_p
x(2)=3.036971602181366_p
w(2)=5.402577251604765e-2_p
x(3)=4.574336660209156_p
w(3)=1.948528194369490e-2_p
x(4)=6.893605948054168_p
w(4)=2.791536689683735e-3_p
x(5)=10.15379156944504_p
w(5)=1.484326468741434e-4_p
x(6)=14.66478415747603_p
w(6)=2.275706394019582e-6_p
x(7)=21.20945254287268_p
w(7)=5.026562673294611e-9_p
else if(N==8)then
x(1)=2.171956677263949_p
w(1)=4.511676234116877e-2_p
x(2)=2.905629312598200_p
w(2)=5.335393368327287e-2_p
x(3)=4.239391160293923_p
w(3)=2.341763406580343e-2_p
x(4)=6.225281986992616_p
w(4)=4.619610090313087e-3_p
x(5)=8.956458295917562_p
w(5)=4.057171773480523e-4_p
x(6)=12.58779379434978_p
w(6)=1.419983958760010e-5_p
x(7)=17.4073963563331_p
w(7)=1.535576187750522e-7_p
x(8)=24.03320335323032_p
w(8)=2.877663416660418e-10_p
else if(N==9)then
x(1)=2.151673120502521_p
w(1)=4.052404376471902e-2_p
x(2)=2.798277122291890_p
w(2)=5.198382666277172e-2_p
x(3)=3.968606133514843_p
w(3)=2.672540667217945e-2_p
x(4)=5.695204524516007_p
w(4)=6.775333620270197e-3_p
x(5)=8.035874979189774_p
w(5)=8.649419277676885e-4_p
x(6)=11.07718344220084_p
w(6)=5.305029654073451e-5_p
x(7)=14.95497450573409_p
w(7)=1.395257652376958e-6_p
x(8)=19.88871679338055_p
w(8)=1.281035862728382e-8_p
x(9)=26.11488291359216_p
w(9)=3.061910957960986e-11_p
else if(N==10)then
x(1)=2.134741427982998_p
w(1)=3.654963677424952e-2_p
x(2)=2.708873285065424_p
w(2)=5.016491859790954e-2_p
x(3)=3.744845339755287_p
w(3)=2.937773245761250e-2_p
x(4)=5.263079718593026_p
w(4)=9.123206458681333e-3_p
x(5)=7.300682912543309_p
w(5)=1.560483782850421e-3_p
x(6)=9.909407719629332_p
w(6)=1.449427515807256e-4_p
x(7)=13.16141912002847_p
w(7)=6.932721604550815e-6_p
x(8)=17.15590807411378_p
w(8)=1.560183548161857e-7_p
x(9)=21.99774126573973_p
w(9)=1.473833102519264e-9_p
x(10)=27.45538644179088_p
w(10)=6.202414109394640e-12_p
else if(N==11)then
x(1)=2.120471597500229_p
w(1)=3.309840956989392e-2_p
x(2)=2.633645554183967_p
w(2)=4.808184094171195e-2_p
x(3)=3.557632999988652_p
w(3)=3.138874947378626e-2_p
x(4)=4.905139917060740_p
w(4)=1.152099183083418e-2_p
x(5)=6.700480829802829_p
w(5)=2.493750545639086e-3_p
x(6)=8.976045008689681_p
w(6)=3.195726987473854e-4_p
x(7)=11.77296989272064_p
w(7)=2.369957002688549e-5_p
x(8)=15.14167145210915_p
w(8)=9.749919284089375e-7_p
x(9)=19.12982323820546_p
w(9)=2.117586629370361e-8_p
x(10)=23.70466575815109_p
w(10)=2.424059464206258e-10_p
x(11)=28.27302995035019_p
w(11)=2.038601578580341e-12_p
else if(N==12)then
x(1)=2.108344872930218_p
w(1)=3.009102816346377e-2_p
x(2)=2.569786397089160_p
w(2)=4.586710851522434e-2_p
x(3)=3.399376019232204_p
w(3)=3.281343265569321e-2_p
x(4)=4.604831259138745_p
w(4)=1.384870383190109e-2_p
x(5)=6.202236529091956_p
w(5)=3.637562309836056e-3_p
x(6)=8.212502218691224_p
w(6)=6.032285365536796e-4_p
x(7)=10.66013313837769_p
w(7)=6.276685182426537e-5_p
x(8)=13.5723425883386_p
w(8)=4.021289407634487e-6_p
x(9)=16.97184587475821_p
w(9)=1.552239777984590e-7_p
x(10)=20.84738186696724_p
w(10)=3.608046239272271e-9_p
x(11)=25.03765102630353_p
w(11)=5.603107659969517e-11_p
x(12)=28.77564065933071_p
w(12)=9.197629152952406e-13_p
else if(N==13)then
x(1)=2.097957234416043_p
w(1)=2.745964054721418e-2_p
x(2)=2.515126509452047_p
w(2)=4.361210835498551e-2_p
x(3)=3.264334803335123_p
w(3)=3.372728046966460e-2_p
x(4)=4.350042222073005_p
w(4)=1.601815725785093e-2_p
x(5)=5.782875974692856_p
w(5)=4.945952330308985e-3_p
x(6)=7.576594949434116_p
w(6)=1.013373411022902e-3_p
x(7)=9.746182417053042_p
w(7)=1.382488706148144e-4_p
x(8)=12.30667569678183_p
w(8)=1.248055786475436e-5_p
x(9)=15.26871522889433_p
w(9)=7.395826862989815e-7_p
x(10)=18.62442755499055_p
w(10)=2.886470395700752e-8_p
x(11)=22.30553951220067_p
w(11)=7.780932491195542e-10_p
x(12)=26.05647751473946_p
w(12)=1.736120604851840e-11_p
x(13)=29.09577832362459_p
w(13)=5.075405581521029e-13_p
else if(N==14)then
x(1)=2.088993061880553_p
w(1)=2.514726453136182e-2_p
x(2)=2.467980960002095_p
w(2)=4.137806329012379e-2_p
x(3)=3.148124952254462_p
w(3)=3.421101946696604e-2_p
x(4)=4.131748269100940_p
w(4)=1.797203573313491e-2_p
x(5)=5.425779085107965_p
w(5)=6.364151448829353e-3_p
x(6)=7.039341059059432_p
w(6)=1.556061741618219e-3_p
x(7)=8.981699555498308_p
w(7)=2.651295537189326e-4_p
x(8)=11.26108351771933_p
w(8)=3.151539631550191e-5_p
x(9)=13.88185417606287_p
w(9)=2.611550359546043e-6_p
x(10)=16.83682939591517_p
w(10)=1.517509077328256e-7_p
x(11)=20.08832213850179_p
w(11)=6.362374679085332e-9_p
x(12)=23.5210834970557_p
w(12)=2.100362660847287e-10_p
x(13)=26.8288128772266_p
w(13)=6.812942453486049e-12_p
x(14)=29.30848504242169_p
w(14)=3.191834041801850e-13_p
else if(N==15)then
x(1)=2.081204363438529_p
w(1)=2.310646447053356e-2_p
x(2)=2.427031429816389_p
w(2)=3.920471718019562e-2_p
x(3)=3.047359627052937_p
w(3)=3.434202420223218e-2_p
x(4)=3.943111946158738_p
w(4)=1.967908084262255e-2_p
x(5)=5.118670739103294_p
w(5)=7.836701654919082e-3_p
x(6)=6.580059218536033_p
w(6)=2.226066057585685e-3_p
x(7)=8.332981460558921_p
w(7)=4.568232211555347e-4_p
x(8)=10.38169882717672_p
w(8)=6.810443088728542e-5_p
x(9)=12.72716427098005_p
w(9)=7.401307161323472e-6_p
x(10)=15.36251165316094_p
w(10)=5.906204806916786e-7_p
x(11)=18.26318026920773_p
w(11)=3.531760445642396e-8_p
x(12)=21.36569335830043_p
w(12)=1.664712993024781e-9_p
x(13)=24.52250901033199_p
w(13)=6.935696637564046e-11_p
x(14)=27.41537205034059_p
w(14)=3.211754381130211e-12_p
x(15)=29.4555971909257_p
w(15)=2.192370130152120e-13_p
else if(N==16)then
x(1)=2.074394579706376_p
w(1)=2.129780178236844e-2_p
x(2)=2.391236294315842_p
w(2)=3.711672124304394e-2_p
x(3)=2.959389410696288_p
w(3)=3.419011433704192e-2_p
x(4)=3.778866569523871_p
w(4)=2.112819515453547e-2_p
x(5)=4.852281205880986_p
w(5)=9.313010241572892e-3_p
x(6)=6.183530895646181_p
w(6)=3.008864085434828e-3_p
x(7)=7.776036916359221_p
w(7)=7.231855260109617e-4_p
x(8)=9.631688446891172_p
w(8)=1.303873868801575e-4_p
x(9)=11.74955726321777_p
w(9)=1.773883908505702e-5_p
x(10)=14.12310546676866_p
w(10)=1.835692631346635e-6_p
x(11)=16.73454136196117_p
w(11)=1.468267879021626e-7_p
x(12)=19.54389004727152_p
w(12)=9.385439020568164e-9_p
x(13)=22.46805284753558_p
w(13)=5.129005661640103e-10_p
x(14)=25.34260077594755_p
w(14)=2.724456294373937e-11_p
x(15)=27.86451661920294_p
w(15)=1.741629164976397e-12_p
x(16)=29.56100715172411_p
w(16)=1.602190379341777e-13_p
else if(N==17)then
x(1)=2.068406451939440_p
w(1)=1.968842323655235e-2_p
x(2)=2.359764159051768_p
w(2)=3.512823652715392e-2_p
x(3)=2.882116186238599_p
w(3)=3.381593660832560e-2_p
x(4)=3.634893266086544_p
w(4)=2.232277891510930e-2_p
x(5)=4.619474282659309_p
w(5)=1.075046856638761e-2_p
x(6)=5.838272156711479_p
w(6)=3.883498922021088e-3_p
x(7)=7.293210773593263_p
w(7)=1.069352005744428e-3_p
x(8)=8.984741997757988_p
w(8)=2.267080932527928e-4_p
x(9)=10.91091134379598_p
w(9)=3.728059021781429e-5_p
x(10)=13.06556131297761_p
w(10)=4.795123281891549e-6_p
x(11)=15.43489138874849_p
w(11)=4.889251846429815e-7_p
x(12)=17.99127565324367_p
w(12)=4.048711652160607e-8_p
x(13)=20.68236019879503_p
w(13)=2.845455054958844e-9_p
x(14)=23.41239376886534_p
w(14)=1.835243014429110e-10_p
x(15)=26.01329182005098_p
w(15)=1.237845108726035e-11_p
x(16)=28.21245916816143_p
w(16)=1.050651536290756e-12_p
x(17)=29.6388691271564_p
w(17)=1.225120436656930e-13_p
else
call GD(2)
end if
end subroutine GF_2

! [3kT;30kT]
subroutine GF_3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=3.592777477796867_p
w(1)=4.139326964714949e-2_p
x(2)=6.425554867011932_p
w(2)=7.194081926498992e-3_p
else if(N==3)then
x(1)=3.420419384247819_p
w(1)=3.440929339614446e-2_p
x(2)=5.304011971458463_p
w(2)=1.366535719866185e-2_p
x(3)=9.298485759699750_p
w(3)=5.127009788421677e-4_p
else if(N==4)then
x(1)=3.325910268431095_p
w(1)=2.913172864911403e-2_p
x(2)=4.754082666232826_p
w(2)=1.750960327272769e-2_p
x(3)=7.544451036992169_p
w(3)=1.919358619125053e-3_p
x(4)=12.4020353582791_p
w(4)=2.666103268170390e-5_p
else if(N==5)then
x(1)=3.266096121235321_p
w(1)=2.515874112562724e-2_p
x(2)=4.420342994649730_p
w(2)=1.950003763301302e-2_p
x(3)=6.603117205805006_p
w(3)=3.748572012036451e-3_p
x(4)=10.09079933327909_p
w(4)=1.788407305116383e-4_p
x(5)=15.64318748725285_p
w(5)=1.160072460134692e-6_p
else if(N==6)then
x(1)=3.224611944148747_p
w(1)=2.208310493666029e-2_p
x(2)=4.193574999275429_p
w(2)=2.036765144634394e-2_p
x(3)=5.995356948321470_p
w(3)=5.605274793150539e-3_p
x(4)=8.772022501659301_p
w(4)=5.181426043703515e-4_p
x(5)=12.82402004925821_p
w(5)=1.313151187358982e-5_p
x(6)=18.94245832861748_p
w(6)=4.628124977838558e-8_p
else if(N==7)then
x(1)=3.193640208874334_p
w(1)=1.960326800209498e-2_p
x(2)=4.026201999956188_p
w(2)=2.056731744114012e-2_p
x(3)=5.558752370496867_p
w(3)=7.313852614829802e-3_p
x(4)=7.873705405580154_p
w(4)=1.046029368925646e-3_p
x(5)=11.12521472004627_p
w(5)=5.600896916902473e-5_p
x(6)=15.61731099760976_p
w(6)=8.731512518436047e-7_p
x(7)=22.10279875038286_p
w(7)=2.026237065280869e-9_p
else if(N==8)then
x(1)=3.169082880609178_p
w(1)=1.751949557198631e-2_p
x(2)=3.894426048064042_p
w(2)=2.034841560606920e-2_p
x(3)=5.220591280271424_p
w(3)=8.818600317658904e-3_p
x(4)=7.198103396357168_p
w(4)=1.740595311408960e-3_p
x(5)=9.915142741380595_p
w(5)=1.546428873760250e-4_p
x(6)=13.5207752468065_p
w(6)=5.538952542094602e-6_p
x(7)=18.28698231213627_p
w(7)=6.279153854763207e-8_p
x(8)=24.74444792018852_p
w(8)=1.350684350804892e-10_p
else if(N==9)then
x(1)=3.148930944525302_p
w(1)=1.572876925299611e-2_p
x(2)=3.786807648714209_p
w(2)=1.985262694116572e-2_p
x(3)=4.947470484942989_p
w(3)=1.008995179179819e-2_p
x(4)=6.662717107047012_p
w(4)=2.562728830554739e-3_p
x(5)=8.985883171459742_p
w(5)=3.318065108934402e-4_p
x(6)=11.99850080432424_p
w(6)=2.088778597587099e-5_p
x(7)=15.8265348850802_p
w(7)=5.746779145682899e-7_p
x(8)=20.65980907424769_p
w(8)=5.764990986328995e-9_p
x(9)=26.60377164133679_p
w(9)=1.735886152774811e-11_p
else if(N==10)then
x(1)=3.132143156457168_p
w(1)=1.417963713402549e-2_p
x(2)=3.697467060019217_p
w(2)=1.917800272854927e-2_p
x(3)=4.722550760696618_p
w(3)=1.111124801764986e-2_p
x(4)=6.227687560617721_p
w(4)=3.457973447818995e-3_p
x(5)=8.246266404808026_p
w(5)=6.003090423480962e-4_p
x(6)=10.82584320443264_p
w(6)=5.725559899546118e-5_p
x(7)=14.03213447366429_p
w(7)=2.855956700508771e-6_p
x(8)=17.94985725534781_p
w(8)=6.890248734012540e-8_p
x(9)=22.64467659325921_p
w(9)=7.409596132483210e-10_p
x(10)=27.76769007035169_p
w(10)=4.113858059881013e-12_p
else if(N==11)then
x(1)=3.118024722673753_p
w(1)=1.283542184770219e-2_p
x(2)=3.622526341620557_p
w(2)=1.839717072504754e-2_p
x(3)=4.535004286397268_p
w(3)=1.188738718450324e-2_p
x(4)=5.868481135856408_p
w(4)=4.371045261972771e-3_p
x(5)=7.644309863241090_p
w(5)=9.599344570580224e-4_p
x(6)=9.891385712559606_p
w(6)=1.262258839198004e-4_p
x(7)=12.64636238901484_p
w(7)=9.731445530923932e-6_p
x(8)=15.95137347142901_p
w(8)=4.245079698155242e-7_p
x(9)=19.83655331013899_p
w(9)=1.012233146763659e-8_p
x(10)=24.22925463602322_p
w(10)=1.361069140275603e-10_p
x(11)=28.47195683328647_p
w(11)=1.505796399058835e-12_p
else if(N==12)then
x(1)=3.106047596047011_p
w(1)=1.166477296367017e-2_p
x(2)=3.559074904518548_p
w(2)=1.756203548051011e-2_p
x(3)=4.376919428316064_p
w(3)=1.243958927968719e-2_p
x(4)=5.567908480377965_p
w(4)=5.256163513098918e-3_p
x(5)=7.145839990521465_p
w(5)=1.399494271171704e-3_p
x(6)=9.128702986664035_p
w(6)=2.378401133818135e-4_p
x(7)=11.53769629484062_p
w(7)=2.565232126703131e-5_p
x(8)=14.39481064630645_p
w(8)=1.729775980795381e-6_p
x(9)=17.71326293935655_p
w(9)=7.194610340169940e-8_p
x(10)=21.46384286474121_p
w(10)=1.873296324833096e-9_p
x(11)=25.45376794903705_p
w(11)=3.475262058688817e-11_p
x(12)=28.90646641960049_p
w(12)=7.284034375228906e-13_p
else if(N==13)then
x(1)=3.095803014784364_p
w(1)=1.064097810494395e-2_p
x(2)=3.504881600678579_p
w(2)=1.670843190610070e-2_p
x(3)=4.242357912672706_p
w(3)=1.279677571152291e-2_p
x(4)=5.313477126120110_p
w(4)=6.080034937567681e-3_p
x(5)=6.727150364900137_p
w(5)=1.900760186296024e-3_p
x(6)=8.494691060072803_p
w(6)=3.985052778009482e-4_p
x(7)=10.62852022676802_p
w(7)=5.620434321891531e-5_p
x(8)=13.14014390599285_p
w(8)=5.311151252643620e-6_p
x(9)=16.03445028360353_p
w(9)=3.352079234250921e-7_p
x(10)=19.29392944581097_p
w(10)=1.429700432323668e-8_p
x(11)=22.83477024366645_p
w(11)=4.378920225646915e-10_p
x(12)=26.38343204553059_p
w(12)=1.170429614281349e-11_p
x(13)=29.18548508334294_p
w(13)=4.206308910853197e-13_p
else if(N==14)then
x(1)=3.086973401075401_p
w(1)=9.741688762945910e-3_p
x(2)=3.458225700324485_p
w(2)=1.586045934668963e-2_p
x(3)=4.126812494644506_p
w(3)=1.298974177103832e-2_p
x(4)=5.095932013650108_p
w(4)=6.821258307862166e-3_p
x(5)=6.371262873071031_p
w(5)=2.442399691084524e-3_p
x(6)=7.959887329982366_p
w(6)=6.100789864466152e-4_p
x(7)=9.869005478419709_p
w(7)=1.072041012503862e-4_p
x(8)=12.10432099591168_p
w(8)=1.328159445650129e-5_p
x(9)=14.66644285258616_p
w(9)=1.162781521862910e-6_p
x(10)=17.54240998730015_p
w(10)=7.272857650794296e-8_p
x(11)=20.68589854800307_p
w(11)=3.369262156416409e-9_p
x(12)=23.97058780662942_p
w(12)=1.273310639661364e-10_p
x(13)=27.08587195078036_p
w(13)=4.910098508550676e-12_p
x(14)=29.37253968141272_p
w(14)=2.727449834921622e-13_p
else if(N==15)then
x(1)=3.079310125750283_p
w(1)=8.948333729944970e-3_p
x(2)=3.417767647779965_p
w(2)=1.503385039375913e-2_p
x(3)=4.026817448773705_p
w(3)=1.304794486346538e-2_p
x(4)=4.908288451839292_p
w(4)=7.468364275580702e-3_p
x(5)=6.065686342518097_p
w(5)=3.003106269265569e-3_p
x(6)=7.503340162176131_p
w(6)=8.700362464870683e-4_p
x(7)=9.225241389713911_p
w(7)=1.837271763168937e-4_p
x(8)=11.2337569920117_p
w(8)=2.844704852826280e-5_p
x(9)=13.52725508896197_p
w(9)=3.246642730507782e-6_p
x(10)=16.09513572044842_p
w(10)=2.760179956626453e-7_p
x(11)=18.90757497791035_p
w(11)=1.792172922335568e-8_p
x(12)=21.89435996357263_p
w(12)=9.403054110660806e-10_p
x(13)=24.90215197481306_p
w(13)=4.490949215760219e-11_p
x(14)=27.61895504366123_p
w(14)=2.438823212782105e-12_p
x(15)=29.50300157544556_p
w(15)=1.913905240007434e-13_p
else if(N==16)then
x(1)=3.072616643516050_p
w(1)=8.245486922380977e-3_p
x(2)=3.382453172650323_p
w(2)=1.423844696308061e-2_p
x(3)=3.939671572703012_p
w(3)=1.299793817295757e-2_p
x(4)=4.745182220466954_p
w(4)=8.017491985634798e-3_p
x(5)=5.801014495781549_p
w(5)=3.563676860458163e-3_p
x(6)=7.109671190799254_p
w(6)=1.172340900852986e-3_p
x(7)=8.673126668373081_p
w(7)=2.893515584571877e-4_p
x(8)=10.49178871445166_p
w(8)=5.401855985982186e-5_p
x(9)=12.56286888916748_p
w(9)=7.681596477539165e-6_p
x(10)=14.87728426551653_p
w(10)=8.405511399433320e-7_p
x(11)=17.41381347420598_p
w(11)=7.213532331421077e-8_p
x(12)=20.12817992711093_p
w(12)=5.039173794610332e-9_p
x(13)=22.93294009604287_p
w(13)=3.076626233253605e-10_p
x(14)=25.66280440451824_p
w(14)=1.866986812514706e-11_p
x(15)=28.0275171035037_p
w(15)=1.377231704717575e-12_p
x(16)=29.59717948075901_p
w(16)=1.420554411135719e-13_p
else if(N==17)then
x(1)=3.066736042815420_p
w(1)=7.620306039827619e-3_p
x(2)=3.351443541086812_p
w(2)=1.347998764507600e-2_p
x(3)=3.863242527269500_p
w(3)=1.286277562269108e-2_p
x(4)=4.602428532890719_p
w(4)=8.470198302172242e-3_p
x(5)=5.570022299924317_p
w(5)=4.108124247726207e-3_p
x(6)=6.767299446674991_p
w(6)=1.508615351396063e-3_p
x(7)=8.194948105762634_p
w(7)=4.257509805817349e-4_p
x(8)=9.852220169003079_p
w(8)=9.321722513474595e-5_p
x(9)=11.73577095162499_p
w(9)=1.596114738468547e-5_p
x(10)=13.83763604127293_p
w(10)=2.158285154229227e-6_p
x(11)=16.14166626432722_p
w(11)=2.340744376122399e-7_p
x(12)=18.617353329524_p
w(12)=2.091311728391384e-8_p
x(13)=21.20928076057837_p
w(13)=1.612820979937085e-9_p
x(14)=23.81980233312931_p
w(14)=1.162621216160311e-10_p
x(15)=26.28386555853788_p
w(15)=8.898517473948443e-12_p
x(16)=28.34460141530883_p
w(16)=8.574640089252402e-13_p
x(17)=29.66719595475221_p
w(17)=1.098931067496444e-13_p
else
call GD(3)
end if
end subroutine GF_3

! [4kT;30kT]
subroutine GF_4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=4.588391360436827_p
w(1)=1.548099365962760e-2_p
x(2)=7.418430416374662_p
w(2)=2.668934258088566e-3_p
else if(N==3)then
x(1)=4.417506413188821_p
w(1)=1.288666339608897e-2_p
x(2)=6.297897006859372_p
w(2)=5.073601579896283e-3_p
x(3)=10.29311377146317_p
w(3)=1.896629417309168e-4_p
else if(N==4)then
x(1)=4.323796064134211_p
w(1)=1.092279651646086e-2_p
x(2)=5.748819175378977_p
w(2)=6.507260411722738e-3_p
x(3)=8.539422252743874_p
w(3)=7.100169853256470e-4_p
x(4)=13.39737328344335_p
w(4)=9.854004206914020e-6_p
else if(N==5)then
x(1)=4.264442274912880_p
w(1)=9.441292985191328e-3_p
x(2)=5.415622180744307_p
w(2)=7.254612998874008e-3_p
x(3)=7.597903734086188_p
w(3)=1.387449995825839e-3_p
x(4)=11.08533556158353_p
w(4)=6.614228214858480e-5_p
x(5)=16.635964187797_p
w(5)=4.296556764037973e-7_p
else if(N==6)then
x(1)=4.223151537219453_p
w(1)=8.289507868482942e-3_p
x(2)=5.188701601919376_p
w(2)=7.585278788261616e-3_p
x(3)=6.988425982110916_p
w(3)=2.077989349277654e-3_p
x(4)=9.762517312715250_p
w(4)=1.922375323790209e-4_p
x(5)=13.80859153906937_p
w(5)=4.896858857336517e-6_p
x(6)=19.90931193714992_p
w(6)=1.752045759473973e-8_p
else if(N==7)then
x(1)=4.192136877931429_p
w(1)=7.353995862939160e-3_p
x(2)=5.020308002742460_p
w(2)=7.665606453426112e-3_p
x(3)=6.548134853380689_p
w(3)=2.718468548033622e-3_p
x(4)=8.856314191916450_p
w(4)=3.903846993570434e-4_p
x(5)=12.09530710659391_p
w(5)=2.113430486284641e-5_p
x(6)=16.56115346114876_p
w(6)=3.372110047941473e-7_p
x(7)=22.96370233722791_p
w(7)=8.380925865620561e-10_p
else if(N==8)then
x(1)=4.167452249772261_p
w(1)=6.563882705740009e-3_p
x(2)=4.887309572344661_p
w(2)=7.586172185510391e-3_p
x(3)=6.206058183809564_p
w(3)=3.285476403434742e-3_p
x(4)=8.172734844162351_p
w(4)=6.532253791647215e-4_p
x(5)=10.87176058157243_p
w(5)=5.897106503721368e-5_p
x(6)=14.44547047389712_p
w(6)=2.173994019437624e-6_p
x(7)=19.14579836687786_p
w(7)=2.611846691861695e-8_p
x(8)=25.39930777640235_p
w(8)=6.634273101621860e-11_p
else if(N==9)then
x(1)=4.147218427988832_p
w(1)=5.884872222555190e-3_p
x(2)=4.778877926448365_p
w(2)=7.400393423712226e-3_p
x(3)=5.930293511947798_p
w(3)=3.764060589268362e-3_p
x(4)=7.632128596968045_p
w(4)=9.648416641455733e-4_p
x(5)=9.934428351424188_p
w(5)=1.272574464844474e-4_p
x(6)=12.91352273467657_p
w(6)=8.260476305387527e-6_p
x(7)=16.68394761439747_p
w(7)=2.394272596157814e-7_p
x(8)=21.40217542860599_p
w(8)=2.657700290722584e-9_p
x(9)=27.039368629965_p
w(9)=1.028507130701341e-11_p
else if(N==10)then
x(1)=4.130410256243933_p
w(1)=5.298622922985886e-3_p
x(2)=4.689162185376730_p
w(2)=7.146351864269638e-3_p
x(3)=5.703988169298269_p
w(3)=4.146911508912051e-3_p
x(4)=7.194403036289960_p
w(4)=1.303453527567445e-3_p
x(5)=9.191104751339847_p
w(5)=2.306896609129317e-4_p
x(6)=11.73768599859973_p
w(6)=2.268126381301886e-5_p
x(7)=14.89272553094574_p
w(7)=1.185877000122863e-6_p
x(8)=18.72514667895945_p
w(8)=3.090674457329543e-8_p
x(9)=23.25980470706982_p
w(9)=3.826932813659525e-10_p
x(10)=28.04288409203424_p
w(10)=2.817215222316435e-12_p
else if(N==11)then
x(1)=4.116311635284843_p
w(1)=4.790916472658581e-3_p
x(2)=4.614133987098065_p
w(2)=6.852094960389152e-3_p
x(3)=5.515879093802599_p
w(3)=4.436272328977706e-3_p
x(4)=6.834084108210057_p
w(4)=1.647660191984320e-3_p
x(5)=8.587966961035997_p
w(5)=3.688340897206798e-4_p
x(6)=10.80336644395736_p
w(6)=4.993948772896730e-5_p
x(7)=13.51216288508169_p
w(7)=4.018503234858066e-6_p
x(8)=16.74760237157264_p
w(8)=1.868754469595950e-7_p
x(9)=20.52165386698117_p
w(9)=4.927987217834371e-9_p
x(10)=24.72315050138197_p
w(10)=7.845223761931167e-11_p
x(11)=28.64776140677304_p
w(11)=1.135484456663348e-12_p
else if(N==12)then
x(1)=4.104377411876207_p
w(1)=4.349507318777361e-3_p
x(2)=4.550768345552830_p
w(2)=6.537489913915399e-3_p
x(3)=5.357736173622714_p
w(3)=4.640673462748004e-3_p
x(4)=6.533343362267767_p
w(4)=1.980059404491423e-3_p
x(5)=8.089721755501820_p
w(5)=5.370434652260944e-4_p
x(6)=10.04246557293792_p
w(6)=9.384295688379464e-5_p
x(7)=12.40940365412629_p
w(7)=1.052641848889750e-5_p
x(8)=15.20698839943873_p
w(8)=7.501663595435570e-7_p
x(9)=18.43864692575721_p
w(9)=3.379647132233548e-8_p
x(10)=22.05751732324633_p
w(10)=9.917119193764859e-10_p
x(11)=25.84304634333527_p
w(11)=2.205799601574972e-11_p
x(12)=29.02308802906791_p
w(12)=5.844095875355733e-13_p
else if(N==13)then
x(1)=4.094188662924796_p
w(1)=3.964043318499481e-3_p
x(2)=4.496764920657966_p
w(2)=6.216176004816967e-3_p
x(3)=5.223429062349186_p
w(3)=4.771429213087460e-3_p
x(4)=6.279319318813533_p
w(4)=2.288183164364544e-3_p
x(5)=7.672061964521601_p
w(5)=7.280455911419179e-4_p
x(6)=9.411069856104032_p
w(6)=1.567007602390268e-4_p
x(7)=11.50627951608995_p
w(7)=2.291474081187280e-5_p
x(8)=13.96549809915272_p
w(8)=2.274188928326448e-6_p
x(9)=16.78770370469922_p
w(9)=1.534887591633706e-7_p
x(10)=19.94585050867692_p
w(10)=7.187490444727964e-9_p
x(11)=23.34173470745731_p
w(11)=2.511837847928177e-10_p
x(12)=26.68839120177093_p
w(12)=8.041699899032964e-12_p
x(13)=29.26624663311938_p
w(13)=3.514764937196298e-13_p
else if(N==14)then
x(1)=4.085421699167966_p
w(1)=3.625911060584250e-3_p
x(2)=4.450360391228663_p
w(2)=5.897279787415402e-3_p
x(3)=5.108331610318458_p
w(3)=4.840437429754747e-3_p
x(4)=6.062535505273949_p
w(4)=2.564177045943072e-3_p
x(5)=7.317670139971408_p
w(5)=9.335014878966394e-4_p
x(6)=8.879296187325039_p
w(6)=2.390085566950489e-4_p
x(7)=10.75271777756504_p
w(7)=4.342981857068565e-5_p
x(8)=12.94103763286826_p
w(8)=5.623704477491443e-6_p
x(9)=15.44101776027303_p
w(9)=5.218665423813719e-7_p
x(10)=18.23396144026349_p
w(10)=3.526553073661258e-8_p
x(11)=21.26537842400807_p
w(11)=1.811913020670530e-9_p
x(12)=24.3995382460669_p
w(12)=7.856636938344619e-11_p
x(13)=27.32555337384143_p
w(13)=3.592037267156297e-12_p
x(14)=29.43075033426127_p
w(14)=2.342829187923404e-13_p
else if(N==15)then
x(1)=4.077824073728467_p
w(1)=3.327977658775680e-3_p
x(2)=4.410188018332325_p
w(2)=5.586724846109149e-3_p
x(3)=5.008901436477738_p
w(3)=4.858988763089944e-3_p
x(4)=5.875867466932331_p
w(4)=2.803987645851575e-3_p
x(5)=7.013851450039644_p
w(5)=1.145213916342023e-3_p
x(6)=8.425957914598863_p
w(6)=3.395632247994201e-4_p
x(7)=10.11469180797798_p
w(7)=7.397401245851474e-5_p
x(8)=12.08051514363336_p
w(8)=1.192470118421134e-5_p
x(9)=14.31915286534456_p
w(9)=1.433164385178301e-6_p
x(10)=16.81629112353007_p
w(10)=1.302050625522527e-7_p
x(11)=19.53707537856105_p
w(11)=9.208856355822875e-9_p
x(12)=22.40529298460862_p
w(12)=5.392237023549151e-10_p
x(13)=25.26357858110587_p
w(13)=2.953686036991457e-11_p
x(14)=27.80903264979419_p
w(14)=1.873361215309950e-12_p
x(15)=29.54644185027945_p
w(15)=1.676364356237265e-13_p
else if(N==16)then
x(1)=4.071196819491157_p
w(1)=3.064333465614644e-3_p
x(2)=4.375175864465569_p
w(2)=5.288189341227702e-3_p
x(3)=4.922386784336135_p
w(3)=4.837198348706028e-3_p
x(4)=5.713859975461035_p
w(4)=3.006433079914243e-3_p
x(5)=6.751072610094104_p
w(5)=1.355902446849393e-3_p
x(6)=8.035539651450836_p
w(6)=4.558419487698778e-4_p
x(7)=9.568045569924143_p
w(7)=1.158208776299859e-4_p
x(8)=11.34755553032088_p
w(8)=2.243875431359420e-5_p
x(9)=13.36938831584842_p
w(9)=3.343095054547874e-6_p
x(10)=15.62192452334331_p
w(10)=3.878115305269066e-7_p
x(11)=18.08064237506768_p
w(11)=3.580630988636024e-8_p
x(12)=20.69734162314928_p
w(12)=2.740400975824216e-9_p
x(13)=23.38109154418413_p
w(13)=1.872035901305618e-10_p
x(14)=25.96729776148601_p
w(14)=1.296629239755614e-11_p
x(15)=28.18005863653043_p
w(15)=1.098664634488634e-12_p
x(16)=29.63056825059483_p
w(16)=1.262119467189763e-13_p
else if(N==17)then
x(1)=4.065381493720296_p
w(1)=2.830069315525727e-3_p
x(2)=4.344473661282962_p
w(2)=5.003794353048639e-3_p
x(3)=4.846621637956479_p
w(3)=4.783802921210172e-3_p
x(4)=5.572267983692302_p
w(4)=3.172344902674609e-3_p
x(5)=6.522027676862151_p
w(5)=1.559595546333984e-3_p
x(6)=7.696379191921369_p
w(6)=5.844798366124323e-4_p
x(7)=9.095043486012344_p
w(7)=1.694771246663861e-4_p
x(8)=10.71614909839131_p
w(8)=3.840086794857025e-5_p
x(9)=12.55494997327983_p
w(9)=6.860624884733589e-6_p
x(10)=14.60167800945299_p
w(10)=9.774734552125345e-7_p
x(11)=16.83791251282189_p
w(11)=1.130240873565388e-7_p
x(12)=19.23047856096071_p
w(12)=1.091966951542147e-8_p
x(13)=21.72135899761136_p
w(13)=9.257073000134052e-10_p
x(14)=24.21185406012728_p
w(14)=7.461918887649021e-11_p
x(15)=26.541116813602_p
w(15)=6.469194038855070e-12_p
x(16)=28.46861103496884_p
w(16)=7.044499829301150e-13_p
x(17)=29.6935074501305_p
w(17)=9.869447190943786e-14_p
else
call GD(4)
end if
end subroutine GF_4

! [5kT;30kT]
subroutine GF_5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=5.586749299917828_p
w(1)=5.730412617577080e-3_p
x(2)=8.415770895359664_p
w(2)=9.849358714474116e-4_p
else if(N==3)then
x(1)=5.416414165914285_p
w(1)=4.772547584142153e-3_p
x(2)=7.295611663835515_p
w(2)=1.872882541923603e-3_p
x(3)=11.2911004592383_p
w(3)=6.991836295873624e-5_p
else if(N==4)then
x(1)=5.322996574676402_p
w(1)=4.046938544238569e-3_p
x(2)=6.746817271360138_p
w(2)=2.403016189527361e-3_p
x(3)=9.537439499825233_p
w(3)=2.617614707444599e-4_p
x(4)=14.39534530658846_p
w(4)=3.632284514102913e-6_p
else if(N==5)then
x(1)=5.263773129867798_p
w(1)=3.498739079417895e-3_p
x(2)=6.413586810375021_p
w(2)=2.680197222059018e-3_p
x(3)=8.595198889866705_p
w(3)=5.118374788560971e-4_p
x(4)=12.08151410526323_p
w(4)=2.441563840289126e-5_p
x(5)=17.62870468949738_p
w(5)=1.590702885909001e-7_p
else if(N==6)then
x(1)=5.222412774034071_p
w(1)=3.070600360898961e-3_p
x(2)=6.185823174892298_p
w(2)=2.803606084328610e-3_p
x(3)=7.982970841739201_p
w(3)=7.680123426419834e-4_p
x(4)=10.75267749126835_p
w(4)=7.129201551295563e-5_p
x(5)=14.78945200960706_p
w(5)=1.830978614696501e-6_p
x(6)=20.86222581606111_p
w(6)=6.707027286175175e-9_p
else if(N==7)then
x(1)=5.191152681404293_p
w(1)=2.720378849572790e-3_p
x(2)=6.015797606900788_p
w(2)=2.833635938949671e-3_p
x(3)=7.538047003700672_p
w(3)=1.007403492196604e-3_p
x(4)=9.836955329975854_p
w(4)=1.457855454034751e-4_p
x(5)=13.05912635923823_p
w(5)=8.012440403181651e-6_p
x(6)=17.48987875562109_p
w(6)=1.318633117320802e-7_p
x(7)=23.78061636949661_p
w(7)=3.591870394314342e-10_p
else if(N==8)then
x(1)=5.166216946234400_p
w(1)=2.423646393447724e-3_p
x(2)=5.881251075334375_p
w(2)=2.803110336917694e-3_p
x(3)=7.191760599080683_p
w(3)=1.219856280841310e-3_p
x(4)=9.145175599779712_p
w(4)=2.452740924118061e-4_p
x(5)=11.82224807303306_p
w(5)=2.258797965333846e-5_p
x(6)=15.3573460366803_p
w(6)=8.622640017256787e-7_p
x(7)=19.97832822128026_p
w(7)=1.110749973384921e-8_p
x(8)=25.99301200550404_p
w(8)=3.425115977011242e-11_p
else if(N==9)then
x(1)=5.145824383796376_p
w(1)=2.169033879806972e-3_p
x(2)=5.771842031894834_p
w(2)=2.732271873346783e-3_p
x(3)=6.913380424936088_p
w(3)=1.398460650477593e-3_p
x(4)=8.599744923005158_p
w(4)=3.632141888919922e-4_p
x(5)=10.87792327775898_p
w(5)=4.897247129867612e-5_p
x(6)=13.81854895240408_p
w(6)=3.292877076099549e-6_p
x(7)=17.52324729611104_p
w(7)=1.012820528604440e-7_p
x(8)=22.11190399757304_p
w(8)=1.259710937112810e-9_p
x(9)=27.42368381498833_p
w(9)=6.362579048439153e-12_p
else if(N==10)then
x(1)=5.128939433044999_p
w(1)=1.949805458091714e-3_p
x(2)=5.681632168378886_p
w(2)=2.635851052393227e-3_p
x(3)=6.685749227531143_p
w(3)=1.540329929158854e-3_p
x(4)=8.159735477422561_p
w(4)=4.909452095280619e-4_p
x(5)=10.13186216842536_p
w(5)=8.886493572566654e-5_p
x(6)=12.64161749901207_p
w(6)=9.039625858819388e-6_p
x(7)=15.73979202162971_p
w(7)=4.979467864368045e-7_p
x(8)=19.47840888858322_p
w(8)=1.412598588935533e-8_p
x(9)=23.84085470342688_p
w(9)=2.035083206063889e-10_p
x(10)=28.28421565150909_p
w(10)=1.987503084679222e-12_p
else if(N==11)then
x(1)=5.114816389937765_p
w(1)=1.760419666348455e-3_p
x(2)=5.606416247837567_p
w(2)=2.524591832176661e-3_p
x(3)=6.497115417037731_p
w(3)=1.646576408171013e-3_p
x(4)=7.798634993738794_p
w(4)=6.202054234962993e-4_p
x(5)=9.528296850921986_p
w(5)=1.419448655638897e-4_p
x(6)=11.70891720056199_p
w(6)=1.985063682154655e-5_p
x(7)=14.3673008633887_p
w(7)=1.673741677669453e-6_p
x(8)=17.52732926690476_p
w(8)=8.341779771067670e-8_p
x(9)=21.18250035811809_p
w(9)=2.449631751469985e-9_p
x(10)=25.18549715852158_p
w(10)=4.646688298371091e-11_p
x(11)=28.80280134291859_p
w(11)=8.726137176774367e-13_p
else if(N==12)then
x(1)=5.102889933776915_p
w(1)=1.596119591702446e-3_p
x(2)=5.543051285831358_p
w(2)=2.406024498424840e-3_p
x(3)=6.338934436727270_p
w(3)=1.720678836633983e-3_p
x(4)=7.497989821353298_p
w(4)=7.443956743903330e-4_p
x(5)=9.030874547643764_p
w(5)=2.062739903595467e-4_p
x(6)=10.95090797582277_p
w(6)=3.716136202297524e-5_p
x(7)=13.27242185959643_p
w(7)=4.348981611794731e-6_p
x(8)=16.00609737513726_p
w(8)=3.288734255821897e-7_p
x(9)=19.14543752296266_p
w(9)=1.612937689954532e-8_p
x(10)=22.62658058258624_p
w(10)=5.362720078902016e-10_p
x(11)=26.20552932479611_p
w(11)=1.432958572251328e-11_p
x(12)=29.12693932254936_p
w(12)=4.744978438620828e-13_p
else if(N==13)then
x(1)=5.092728890569257_p
w(1)=1.452919940236710e-3_p
x(2)=5.489165625869665_p
w(2)=2.285274523934180e-3_p
x(3)=6.204889548882973_p
w(3)=1.767100259048101e-3_p
x(4)=7.244584596500866_p
w(4)=8.588722081338737e-4_p
x(5)=8.614730845831374_p
w(5)=2.789423447056728e-4_p
x(6)=10.32299754050656_p
w(6)=6.178851475767926e-5_p
x(7)=12.37680828708929_p
w(7)=9.393430914196766e-6_p
x(8)=14.78015340366398_p
w(8)=9.822707129652084e-7_p
x(9)=17.52603917197219_p
w(9)=7.116894218872742e-8_p
x(10)=20.57814808274113_p
w(10)=3.674685574252892e-9_p
x(11)=23.82531501305955_p
w(11)=1.470277311720197e-10_p
x(12)=26.9717960043697_p
w(12)=5.629701953447424e-12_p
x(13)=29.33890310063393_p
w(13)=2.959175650120399e-13_p
else if(N==14)then
x(1)=5.084001850755158_p
w(1)=1.327524167325488e-3_p
x(2)=5.442951187136716_p
w(2)=2.165740529110132e-3_p
x(3)=6.090239237120503_p
w(3)=1.790461035771999e-3_p
x(4)=7.028731579031491_p
w(4)=9.607859022351751e-4_p
x(5)=8.262234933234264_p
w(5)=3.566860194952228e-4_p
x(6)=9.794954126070204_p
w(6)=9.382657128501061e-5_p
x(7)=11.63032772256194_p
w(7)=1.767119339210187e-5_p
x(8)=13.76880263181719_p
w(8)=2.398072860661808e-6_p
x(9)=16.20326548798451_p
w(9)=2.366190460518637e-7_p
x(10)=18.9094198323492_p
w(10)=1.733524952231848e-8_p
x(11)=21.8252217363761_p
w(11)=9.910124636925916e-10_p
x(12)=24.80734498535483_p
w(12)=4.937200509026176e-11_p
x(13)=27.54838606110892_p
w(13)=2.666439844376222e-12_p
x(14)=29.48361413334946_p
w(14)=2.022190831968319e-13_p
else if(N==15)then
x(1)=5.076451336119713_p
w(1)=1.217213430442264e-3_p
x(2)=5.403012166964515_p
w(2)=2.049604095504686e-3_p
x(3)=5.991366955287794_p
w(3)=1.795099900918780e-3_p
x(4)=6.843174284176286_p
w(4)=1.048742970016197e-3_p
x(5)=7.960505727489919_p
w(5)=4.363524834208279e-4_p
x(6)=9.345399680211932_p
w(6)=1.327136707351161e-4_p
x(7)=10.99894006057289_p
w(7)=2.988886220956761e-5_p
x(8)=12.91966815063608_p
w(8)=5.027829188441960e-6_p
x(9)=15.10065473991347_p
w(9)=6.379924813658778e-7_p
x(10)=17.52395306763548_p
w(10)=6.211919571806528e-8_p
x(11)=20.14999118661721_p
w(11)=4.799293818730619e-9_p
x(12)=22.89739011820831_p
w(12)=3.142771766899761e-10_p
x(13)=25.60654215848863_p
w(13)=1.973807375059847e-11_p
x(14)=27.98608328465768_p
w(14)=1.455174772719665e-12_p
x(15)=29.58621973206423_p
w(15)=1.472838558490382e-13_p
else if(N==16)then
x(1)=5.069875047976725_p
w(1)=1.119742493480165e-3_p
x(2)=5.368257427783290_p
w(2)=1.938199682580577e-3_p
x(3)=5.905472285395487_p
w(3)=1.784871388522015e-3_p
x(4)=6.682372799778004_p
w(4)=1.122431003729544e-3_p
x(5)=7.699895734375545_p
w(5)=5.151876517684426e-4_p
x(6)=8.958710563226493_p
w(6)=1.773954236263280e-4_p
x(7)=10.45849706266272_p
w(7)=4.648970978810797e-5_p
x(8)=12.19678823440612_p
w(8)=9.365668573379580e-6_p
x(9)=14.16700992749461_p
w(9)=1.465211931714099e-6_p
x(10)=16.35505939656134_p
w(10)=1.806306362191992e-7_p
x(11)=18.7332953947683_p
w(11)=1.798721529040982e-8_p
x(12)=21.2500325770669_p
w(12)=1.511416183449847e-9_p
x(13)=23.81175338226561_p
w(13)=1.156327402691310e-10_p
x(14)=26.25603085957991_p
w(14)=9.127534759840504e-12_p
x(15)=28.32252818908692_p
w(15)=8.838998999107051e-13_p
x(16)=29.66136192130683_p
w(16)=1.123512537098101e-13_p
else if(N==17)then
x(1)=5.064112326356510_p
w(1)=1.033251509844834e-3_p
x(2)=5.337823930103768_p
w(2)=1.832278738654052e-3_p
x(3)=5.830356982091284_p
w(3)=1.763080631677171e-3_p
x(4)=6.542027058337609_p
w(4)=1.182281624169861e-3_p
x(5)=7.473027991467707_p
w(5)=5.909712953832019e-4_p
x(6)=8.623163415301935_p
w(6)=2.265193699495558e-4_p
x(7)=9.991281531076755_p
w(7)=6.760903609049806e-5_p
x(8)=11.57441626835778_p
w(8)=1.588211788523466e-5_p
x(9)=13.36642799988385_p
w(9)=2.966411651506372e-6_p
x(10)=15.35578251821928_p
w(10)=4.462562038189340e-7_p
x(11)=17.52190151595446_p
w(11)=5.513336188109543e-8_p
x(12)=19.82919923254881_p
w(12)=5.771595438574473e-9_p
x(13)=22.21755553733285_p
w(13)=5.385842005666364e-10_p
x(14)=24.58805310335935_p
w(14)=4.854577252758891e-11_p
x(15)=26.78509390490946_p
w(15)=4.756275711061331e-12_p
x(16)=28.58478491324863_p
w(16)=5.824530619123924e-13_p
x(17)=29.71792462418113_p
w(17)=8.873692983809215e-14_p
else
call GD(5)
end if
end subroutine GF_5

end module m_gauss_fermi_30
