! Module to contain all the Gauss-Fermi quadrature points
! It has been created by an automatic script created by:
! Nick Papior Andersen, 2013, nickpapior@gmail.com
! If you ever need to use this please contact the author for approval

! We have employed the Stieltjes and moment algorithm together with the Golub-Welsch
! for an efficient and fairly accurate stability of the orthogonal polynomials.

module m_gauss_fermi_26

  implicit none

  integer, parameter :: p = selected_real_kind(14,300)

  integer, parameter :: G_NF_MIN_N  =  2
  integer, parameter :: G_NF_MAX_N  = 17
  integer, parameter :: G_NF_MIN_kT = -20
  integer, parameter :: G_NF_MAX_kT = 5
  
  private
  public :: G_NF_MIN_N
  public :: G_NF_MAX_N
  public :: G_NF_MIN_kT
  public :: G_NF_MAX_kT
  public :: GaussFermi_26
  
contains

  ! Die routine for the Gauss-Fermi routines
  subroutine GD(NkT)
    integer, intent(in) :: NkT
    write(*,*) 'Error in Gauss-Fermi ',NkT
    call die('Error in number of points for Gauss-Fermi, see output.')
  end subroutine GD
  
  subroutine GaussFermi_26(NkT,N,x,w)
    integer, intent(in) :: NkT, N
    real(p), intent(out) :: x(N), w(N)
    
    if ( NkT == -20 ) then
       call GF_m20(N,x,w)
    else if ( NkT == -19 ) then
       call GF_m19(N,x,w)
    else if ( NkT == -18 ) then
       call GF_m18(N,x,w)
    else if ( NkT == -17 ) then
       call GF_m17(N,x,w)
    else if ( NkT == -16 ) then
       call GF_m16(N,x,w)
    else if ( NkT == -15 ) then
       call GF_m15(N,x,w)
    else if ( NkT == -14 ) then
       call GF_m14(N,x,w)
    else if ( NkT == -13 ) then
       call GF_m13(N,x,w)
    else if ( NkT == -12 ) then
       call GF_m12(N,x,w)
    else if ( NkT == -11 ) then
       call GF_m11(N,x,w)
    else if ( NkT == -10 ) then
       call GF_m10(N,x,w)
    else if ( NkT == -9 ) then
       call GF_m9(N,x,w)
    else if ( NkT == -8 ) then
       call GF_m8(N,x,w)
    else if ( NkT == -7 ) then
       call GF_m7(N,x,w)
    else if ( NkT == -6 ) then
       call GF_m6(N,x,w)
    else if ( NkT == -5 ) then
       call GF_m5(N,x,w)
    else if ( NkT == -4 ) then
       call GF_m4(N,x,w)
    else if ( NkT == -3 ) then
       call GF_m3(N,x,w)
    else if ( NkT == -2 ) then
       call GF_m2(N,x,w)
    else if ( NkT == -1 ) then
       call GF_m1(N,x,w)
    else if ( NkT == 0 ) then
       call GF_0(N,x,w)
    else if ( NkT == 1 ) then
       call GF_1(N,x,w)
    else if ( NkT == 2 ) then
       call GF_2(N,x,w)
    else if ( NkT == 3 ) then
       call GF_3(N,x,w)
    else if ( NkT == 4 ) then
       call GF_4(N,x,w)
    else if ( NkT == 5 ) then
       call GF_5(N,x,w)
    else
       call die('Could not figure out the Gauss-Fermi &
             &quadratue method you asked for.')
    end if
  end subroutine GaussFermi_26
  
  
! [-20kT;26kT]
subroutine GF_m20(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-15.5986730019566_p
w(1)=10.40132057902985_p
x(2)=-3.761795335006763_p
w(2)=9.598679423026191_p
else if(N==3)then
x(1)=-17.56069617926886_p
w(1)=6.008953671638631_p
x(2)=-9.213296002380076_p
w(2)=9.514824292241080_p
x(3)=-1.155162441557274_p
w(3)=4.476222038176333_p
else if(N==4)then
x(1)=-18.43109874210283_p
w(1)=3.928604503192994_p
x(2)=-12.55785513959813_p
w(2)=7.327553949570297_p
x(3)=-5.008577129200695_p
w(3)=7.006527673216961_p
x(4)=6.703030707131251e-1_p
w(4)=1.737313876075793_p
else if(N==5)then
x(1)=-18.89086287994227_p
w(1)=2.800000939891763_p
x(2)=-14.55265723749133_p
w(2)=5.634867726072582_p
x(3)=-8.251797804176826_p
w(3)=6.590037508744570_p
x(4)=-2.226671892809321_p
w(4)=4.558761992806111_p
x(5)=2.575327153253721_p
w(5)=4.163318345410182e-1_p
else if(N==6)then
x(1)=-19.16408715058618_p
w(1)=2.120037798658674_p
x(2)=-15.81252785412028_p
w(2)=4.449462909663263_p
x(3)=-10.62336302242768_p
w(3)=5.711086806791309_p
x(4)=-4.894491002750503_p
w(4)=5.411411623432195_p
x(5)=-2.096588225186945e-1_p
w(5)=2.254409596430693_p
x(6)=4.860682238898356_p
w(6)=5.359126707990983e-2_p
else if(N==7)then
x(1)=-19.34061458504375_p
w(1)=1.677165407024903_p
x(2)=-16.65580640127493_p
w(2)=3.611913707131025_p
x(3)=-12.33676257850114_p
w(3)=4.890318684101320_p
x(4)=-7.191668897058681_p
w(4)=5.214250998227190_p
x(5)=-2.329004453738769_p
w(5)=3.909236933665424_p
x(6)=1.650421325752078_p
w(6)=6.927191284006489e-1_p
x(7)=7.485141597472006_p
w(7)=4.395143505533805e-3_p
else if(N==8)then
x(1)=-19.4620196279181_p
w(1)=1.371005532224323_p
x(2)=-17.24897713676284_p
w(2)=3.003270397363240_p
x(3)=-13.59901320688861_p
w(3)=4.206991357894619_p
x(4)=-9.045879111117747_p
w(4)=4.777905655430492_p
x(5)=-4.323831496810628_p
w(5)=4.437284404682745_p
x(6)=-3.288255252028777e-1_p
w(6)=2.088399806897366_p
x(7)=3.761189859248346_p
w(7)=1.148665192608681e-1_p
x(8)=10.33360316381359_p
w(8)=2.763283023907442e-4_p
else if(N==9)then
x(1)=-19.54980486301389_p
w(1)=1.148842958325081_p
x(2)=-17.68452855166447_p
w(2)=2.546673981792961_p
x(3)=-14.55465614853336_p
w(3)=3.651207673751273_p
x(4)=-10.52882212205484_p
w(4)=4.315958849188494_p
x(5)=-6.115810090678742_p
w(5)=4.387425980451136_p
x(6)=-2.005060578717577_p
w(6)=3.261076676065399_p
x(7)=1.511079852733836_p
w(7)=6.768465522144995e-1_p
x(8)=6.166582166783800_p
w(8)=1.195229544677357e-2_p
x(9)=13.3036230348224_p
w(9)=1.503482042613770e-5_p
else if(N==10)then
x(1)=-19.61613397455595_p
w(1)=9.805494466940621e-1_p
x(2)=-18.01729769917684_p
w(2)=2.192514713187471_p
x(3)=-15.30077829425107_p
w(3)=3.196351594247488_p
x(4)=-11.73002942537074_p
w(4)=3.884187208228057_p
x(5)=-7.671094433176700_p
w(5)=4.152533024897195_p
x(6)=-3.611899159294412_p
w(6)=3.746228409709920_p
x(7)=-1.207729305502430e-1_p
w(7)=1.722935833116922_p
x(8)=3.523302622577530_p
w(8)=1.236992306974144e-1_p
x(9)=8.726469865225777_p
w(9)=9.997181913218619e-4_p
x(10)=16.2383280851727_p
w(10)=8.230861925617065e-7_p
else if(N==11)then
x(1)=-19.66821300089568_p
w(1)=8.481550291235144e-1_p
x(2)=-18.28077689061573_p
w(2)=1.908933770228722_p
x(3)=-15.90116371460332_p
w(3)=2.817914591843666_p
x(4)=-12.72260704782123_p
w(4)=3.494135881945947_p
x(5)=-9.015376944802453_p
w(5)=3.861918830172803_p
x(6)=-5.132708921339113_p
w(6)=3.799124989289963_p
x(7)=-1.560233604582585_p
w(7)=2.693898783290821_p
x(8)=1.633053080302004_p
w(8)=5.600602448606793e-1_p
x(9)=5.711024878407921_p
w(9)=1.577627169511851e-2_p
x(10)=11.27439905293103_p
w(10)=8.155246602146267e-5_p
x(11)=18.87967902861964_p
w(11)=5.713878877490082e-8_p
else if(N==12)then
x(1)=-19.71027824452511_p
w(1)=7.410560344443868e-1_p
x(2)=-18.49498384332663_p
w(2)=1.676394484918653_p
x(3)=-16.39536774802885_p
w(3)=2.498607531132839_p
x(4)=-13.55609791898398_p
w(4)=3.145986336557532_p
x(5)=-10.18066089838655_p
w(5)=3.561253991553799_p
x(6)=-6.532343569436387_p
w(6)=3.672325481665652_p
x(7)=-2.967745744294250_p
w(7)=3.202841298620556_p
x(8)=1.484875675483736e-1_p
w(8)=1.385206621085685_p
x(9)=3.484353676393241_p
w(9)=1.145062711875961e-1_p
x(10)=7.932032309023678_p
w(10)=1.814403473980645e-3_p
x(11)=13.66163388567657_p
w(11)=7.541159849943006e-6_p
x(12)=20.98287733818845_p
w(12)=6.255515539579693e-9_p
else if(N==13)then
x(1)=-19.74486766049407_p
w(1)=6.528861271115415e-1_p
x(2)=-18.67202487083187_p
w(2)=1.482913080121199_p
x(3)=-16.80779658343663_p
w(3)=2.227087290990451_p
x(4)=-14.26240420452061_p
w(4)=2.837708248568458_p
x(5)=-11.19160208461111_p
w(5)=3.270562607023362_p
x(6)=-7.796073273508553_p
w(6)=3.476538747033058_p
x(7)=-4.337272914075037_p
w(7)=3.333309362492757_p
x(8)=-1.172487183280871_p
w(8)=2.238330354275572_p
x(9)=1.767084081000840_p
w(9)=4.621234433340816e-1_p
x(10)=5.419755358955737_p
w(10)=1.832247809969240e-2_p
x(11)=10.07578082424844_p
w(11)=2.173900253376157e-4_p
x(12)=15.78981010495477_p
w(12)=8.718267825754839e-7_p
x(13)=22.48681483365304_p
w(13)=1.153749753072993e-9_p
else if(N==14)then
x(1)=-19.77365619562132_p
w(1)=5.794335649502410e-1_p
x(2)=-18.81997557246729_p
w(2)=1.320368103647351_p
x(3)=-17.15510564023661_p
w(3)=1.995089698498841_p
x(4)=-14.86434968162689_p
w(4)=2.566229157702621_p
x(5)=-12.0687135818164_p
w(5)=2.999143753988627_p
x(6)=-8.923893526526985_p
w(6)=3.257667607061108_p
x(7)=-5.627261062602284_p
w(7)=3.278818490532753_p
x(8)=-2.452669509378417_p
w(8)=2.761877653616339_p
x(9)=3.759654990445842e-1_p
w(9)=1.131772822280039_p
x(10)=3.449838726077507_p
w(10)=1.067957637847283e-1_p
x(11)=7.349273486513328_p
w(11)=2.773986324236923e-3_p
x(12)=12.07600125102241_p
w(12)=2.926722693470398e-5_p
x(13)=17.61397508669918_p
w(13)=1.321098567028229e-7_p
x(14)=23.49873771089946_p
w(14)=3.323669279182070e-10_p
else if(N==15)then
x(1)=-19.79785715170857_p
w(1)=5.176388641688622e-1_p
x(2)=-18.94475870120393_p
w(2)=1.182694801210297_p
x(3)=-17.44983556677622_p
w(3)=1.795940281376919_p
x(4)=-15.3800506666635_p
w(4)=2.327726066949691_p
x(5)=-12.83070185492057_p
w(5)=2.750557490995396_p
x(6)=-9.924397265580248_p
w(6)=3.036643290090728_p
x(7)=-6.814103274017649_p
w(7)=3.147547919678638_p
x(8)=-3.702648762156902_p
w(8)=2.949693107856390_p
x(9)=-8.553031621245940e-1_p
w(9)=1.879237958695429_p
x(10)=1.872573709845079_p
w(10)=3.912766541659730e-1_p
x(11)=5.179748313870855_p
w(11)=2.060093270323494e-2_p
x(12)=9.206684465511971_p
w(12)=4.379871934628448e-4_p
x(13)=13.89420478266166_p
w(13)=4.620350020619113e-6_p
x(14)=19.12967873104975_p
w(14)=2.648824036626541e-8_p
x(15)=24.16914693889264_p
w(15)=1.327625497825521e-10_p
else if(N==16)then
x(1)=-19.81838671711863_p
w(1)=4.651859420292082e-1_p
x(2)=-19.0508963573009_p
w(2)=1.065189242174655_p
x(3)=-17.7017841926899_p
w(3)=1.624119700040367_p
x(4)=-15.82429741553011_p
w(4)=2.118172487079580_p
x(5)=-13.49442671678013_p
w(5)=2.525272963241669_p
x(6)=-10.80998985321186_p
w(6)=2.823500443240575_p
x(7)=-7.891928555135132_p
w(7)=2.986361496626683_p
x(8)=-4.894103440338637_p
w(8)=2.950155738873079_p
x(9)=-2.032948563927666_p
w(9)=2.397137157198793_p
x(10)=5.673167420070122e-1_p
w(10)=9.403910534234148e-1_p
x(11)=3.414570474329350_p
w(11)=1.006043174166439e-1_p
x(12)=6.893194613698881_p
w(12)=3.832745514066854e-3_p
x(13)=10.95129950241026_p
w(13)=7.583384785713364e-5_p
x(14)=15.51150084053454_p
w(14)=8.743719102202180e-7_p
x(15)=20.36034828729046_p
w(15)=6.911124328046918e-9_p
x(16)=24.61901002312888_p
w(16)=6.641771686943505e-11_p
else if(N==17)then
x(1)=-19.83594731159466_p
w(1)=4.202955055954480e-1_p
x(2)=-19.14188654625893_p
w(2)=9.641672843380181e-1_p
x(3)=-17.91866958045996_p
w(3)=1.475093165448909_p
x(4)=-16.20913470602907_p
w(4)=1.933749269891863_p
x(5)=-14.07456858959632_p
w(5)=2.322225287254158_p
x(6)=-11.59392202085855_p
w(6)=2.622914898742136_p
x(7)=-8.864309474073146_p
w(7)=2.816140958236954_p
x(8)=-6.005903126340344_p
w(8)=2.866805484374645_p
x(9)=-3.181841596853359_p
w(9)=2.626253597104149_p
x(10)=-5.873750554578071e-1_p
w(10)=1.591552238060704_p
x(11)=1.959814742141565_p
w(11)=3.375161233815238e-1_p
x(12)=4.982127636204175_p
w(12)=2.253062369084197e-2_p
x(13)=8.543205064516741_p
w(13)=7.405567281806576e-4_p
x(14)=12.55926523939673_p
w(14)=1.480727517759386e-5_p
x(15)=16.92471096249811_p
w(15)=1.996217853148050e-7_p
x(16)=21.34509007159092_p
w(16)=2.272814389523078e-9_p
x(17)=24.92867747951401_p
w(17)=3.873707079791973e-11_p
else
call GD(-20)
end if
end subroutine GF_m20

! [-19kT;26kT]
subroutine GF_m19(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.80201381327371_p
w(1)=9.919648067875450_p
x(2)=-3.526768405176206_p
w(2)=9.080351937722238_p
else if(N==3)then
x(1)=-16.66602162874436_p
w(1)=5.749160057274414_p
x(2)=-8.682923508908418_p
w(2)=9.091369947181439_p
x(3)=-9.856472916035961e-1_p
w(3)=4.159470001141834_p
else if(N==4)then
x(1)=-17.49427661684364_p
w(1)=3.770229210524950_p
x(2)=-11.85930473759726_p
w(2)=7.027560195217923_p
x(3)=-4.631462559976475_p
w(3)=6.664636557269022_p
x(4)=8.528755324304992e-1_p
w(4)=1.537574042585792_p
else if(N==5)then
x(1)=-17.93258431806909_p
w(1)=2.694563509736483_p
x(2)=-13.75863927644597_p
w(2)=5.420030589868551_p
x(3)=-7.703174791777708_p
w(3)=6.322857088370760_p
x(4)=-1.942137173054236_p
w(4)=4.225541195052860_p
x(5)=2.819879876278530_p
w(5)=3.370076225690325e-1_p
else if(N==6)then
x(1)=-18.19356041388111_p
w(1)=2.045209161218717_p
x(2)=-14.9609064382138_p
w(2)=4.290652292888099_p
x(3)=-9.959825798074119_p
w(3)=5.499441582835228_p
x(4)=-4.456992907847147_p
w(4)=5.154157330799446_p
x(5)=4.417437858098878e-2_p
w(5)=1.970937024164007_p
x(6)=5.178340133587962_p
w(6)=3.960261369218917e-2_p
else if(N==7)then
x(1)=-18.36249983474077_p
w(1)=1.621441878403053_p
x(2)=-15.76733176599173_p
w(2)=3.490652412423217_p
x(3)=-11.59515229742899_p
w(3)=4.721285527228388_p
x(4)=-6.634953588076684_p
w(4)=5.012522989476343_p
x(5)=-1.979622497737345_p
w(5)=3.602349159917305_p
x(6)=1.943135349051493_p
w(6)=5.487091359202674e-1_p
x(7)=7.862145285986505_p
w(7)=3.038902229114091e-3_p
else if(N==8)then
x(1)=-18.47891891483055_p
w(1)=1.327895376869144_p
x(2)=-16.33578903904488_p
w(2)=2.907906704789760_p
x(3)=-12.80302567301349_p
w(3)=4.070075940827755_p
x(4)=-8.402272431498110_p
w(4)=4.611239443774925_p
x(5)=-3.860217317458650_p
w(5)=4.213117769333651_p
x(6)=-2.038448925061662e-2_p
w(6)=1.787539996568624_p
x(7)=4.121780622266457_p
w(7)=8.204266994479663e-2_p
x(8)=10.75551719999423_p
w(8)=1.821034890314086e-4_p
else if(N==9)then
x(1)=-18.56330172456785_p
w(1)=1.114367637886337_p
x(2)=-16.75424448189214_p
w(2)=2.469556146330099_p
x(3)=-13.72009153086308_p
w(3)=3.538259530794145_p
x(4)=-9.821552568029402_p
w(4)=4.175506728123468_p
x(5)=-5.560987814220419_p
w(5)=4.215189810198136_p
x(6)=-1.624239670524543_p
w(6)=2.960615701431828_p
x(7)=1.848980223002976_p
w(7)=5.185080252650109e-1_p
x(8)=6.579954598320968_p
w(8)=7.986808982226895e-3_p
x(9)=13.75259152298815_p
w(9)=9.616586438469538e-6_p
else if(N==10)then
x(1)=-18.62725284856379_p
w(1)=9.521225155799533e-1_p
x(2)=-17.07495104404412_p
w(2)=2.128432881878608_p
x(3)=-14.43851459026691_p
w(3)=3.101204442441264_p
x(4)=-10.97594833904034_p
w(4)=3.763925190266713_p
x(5)=-7.048004944004083_p
w(5)=4.009060642642647_p
x(6)=-3.144443828974526_p
w(6)=3.527138773221695_p
x(7)=2.218886979421693e-1_p
w(7)=1.431702746157000_p
x(8)=3.915758542502470_p
w(8)=8.576593621308286e-2_p
x(9)=9.166730365406556_p
w(9)=6.463503259282372e-4_p
x(10)=16.68070694544746_p
w(10)=5.268707948359035e-7_p
else if(N==11)then
x(1)=-18.6776095470805_p
w(1)=8.241159110423701e-1_p
x(2)=-17.32963306234876_p
w(2)=1.854444546288560_p
x(3)=-15.01844361989496_p
w(3)=2.736227763289328_p
x(4)=-11.93334842083483_p
w(4)=3.389649486660213_p
x(5)=-8.340361971071145_p
w(5)=3.737747699774146_p
x(6)=-4.592417071970928_p
w(6)=3.637038365248768_p
x(7)=-1.170000006916502_p
w(7)=2.394269702574088_p
x(8)=1.999408077826415_p
w(8)=4.160517114972308e-1_p
x(9)=6.136360346135281_p
w(9)=1.040231418357854e-2_p
x(10)=11.71428832559893_p
w(10)=5.246687539045074e-5_p
x(11)=19.26800302771985_p
w(11)=3.816401468870639e-8_p
else if(N==12)then
x(1)=-18.71835658277703_p
w(1)=7.203793061004421e-1_p
x(2)=-17.53707183585909_p
w(2)=1.629334783986765_p
x(3)=-15.49676162001865_p
w(3)=2.427553303325357_p
x(4)=-12.73917063599055_p
w(4)=3.054271784313658_p
x(5)=-9.464387613533084_p
w(5)=3.451909683852298_p
x(6)=-5.934080755811937_p
w(6)=3.540442488136103_p
x(7)=-2.509426140139023_p
w(7)=2.978220741030772_p
x(8)=5.096600976702080e-1_p
w(8)=1.118470762571124_p
x(9)=3.889118060791387_p
w(9)=7.823474275491271e-2_p
x(10)=8.365680571733471_p
w(10)=1.177467536669062e-3_p
x(11)=14.07809644798109_p
w(11)=4.937502751650283e-6_p
x(12)=21.28525560881887_p
w(12)=4.486833978533296e-9_p
else if(N==13)then
x(1)=-18.75189045520855_p
w(1)=6.349043406064386e-1_p
x(2)=-17.70867162537662_p
w(2)=1.441856612761659_p
x(3)=-15.89632816817465_p
w(3)=2.164751399271829_p
x(4)=-13.42285933150077_p
w(4)=2.756661290430812_p
x(5)=-10.44131361435758_p
w(5)=3.173434557895398_p
x(6)=-7.150398698685953_p
w(6)=3.362852043358010_p
x(7)=-3.814378675316854_p
w(7)=3.172392661214576_p
x(8)=-7.787131985091281e-1_p
w(8)=1.945165044993288_p
x(9)=2.149777420676765_p
w(9)=3.357842383618797e-1_p
x(10)=5.844953542526897_p
w(10)=1.205567469189905e-2_p
x(11)=10.50084391533732_p
w(11)=1.415514664402652e-4_p
x(12)=16.16757958756407_p
w(12)=5.896550868756389e-7_p
x(13)=22.70411789766138_p
w(13)=8.903712211220478e-10_p
else if(N==14)then
x(1)=-18.77981398801676_p
w(1)=5.636618683938298e-1_p
x(2)=-17.85214940408753_p
w(2)=1.284265954444805_p
x(3)=-16.2330054820998_p
w(3)=1.940030583532069_p
x(4)=-14.00596932140889_p
w(4)=2.494216664725502_p
x(5)=-11.2898877383353_p
w(5)=2.912375031431175_p
x(6)=-8.238549006032619_p
w(6)=3.157050527676092_p
x(7)=-5.050025359859032_p
w(7)=3.153009378827083_p
x(8)=-2.002072759375304_p
w(8)=2.530621915970763_p
x(9)=7.517235664852723e-1_p
w(9)=8.906723511703510e-1_p
x(10)=3.861825020117612_p
w(10)=7.226999299477505e-2_p
x(11)=7.777454199280588_p
w(11)=1.806285419607226e-3_p
x(12)=12.48085099015511_p
w(12)=1.935768951585731e-5_p
x(13)=17.94512443283682_p
w(13)=9.304998076333228e-8_p
x(14)=23.65021536179832_p
w(14)=2.721404219244247e-10_p
else if(N==15)then
x(1)=-18.80329745308426_p
w(1)=5.037014399201022e-1_p
x(2)=-17.97321316346237_p
w(2)=1.150725186662472_p
x(3)=-16.51885585102895_p
w(3)=1.747005635835427_p
x(4)=-14.50584414598344_p
w(4)=2.263408276678339_p
x(5)=-12.02774339006128_p
w(5)=2.672669862448192_p
x(6)=-9.205461600456387_p
w(6)=2.946455046551985_p
x(7)=-6.191590102323298_p
w(7)=3.041266765389206_p
x(8)=-3.193219334974050_p
w(8)=2.785308283857537_p
x(9)=-4.561915186539955e-1_p
w(9)=1.596444938048839_p
x(10)=2.268338403456909_p
w(10)=2.792069101384366e-1_p
x(11)=5.606064402749868_p
w(11)=1.351808046115434e-2_p
x(12)=9.625855573814393_p
w(12)=2.864300108717778e-4_p
x(13)=14.27086828029339_p
w(13)=3.130003924631163e-6_p
x(14)=19.41237787754787_p
w(14)=1.947771547320897e-8_p
x(15)=24.27518823304712_p
w(15)=1.134855721899570e-10_p
else if(N==16)then
x(1)=-18.823226253299_p
w(1)=4.527851105428325e-1_p
x(2)=-18.0762302526145_p
w(2)=1.036695611376160_p
x(3)=-16.76332782404764_p
w(3)=1.580374095090982_p
x(4)=-14.93669933812371_p
w(4)=2.060438404541816_p
x(5)=-12.67093473178558_p
w(5)=2.455044397623501_p
x(6)=-10.06238497952347_p
w(6)=2.742058208067790_p
x(7)=-7.231188203426411_p
w(7)=2.892756343647045_p
x(8)=-4.333421870129709_p
w(8)=2.826332327450279_p
x(9)=-1.586731386784070_p
w(9)=2.160457814681355_p
x(10)=9.562668556542775e-1_p
w(10)=7.229973902383993e-1_p
x(11)=3.833053073664810_p
w(11)=6.751342962860152e-2_p
x(12)=7.319888450675665_p
w(12)=2.495989515912768e-3_p
x(13)=11.35316996069673_p
w(13)=5.026804301981462e-5_p
x(14)=15.85518852020808_p
w(14)=6.097948947098833e-7_p
x(15)=20.59734051724256_p
w(15)=5.296583311336270e-9_p
x(16)=24.69484686242571_p
w(16)=5.851527925477839e-11_p
else if(N==17)then
x(1)=-18.84027934489751_p
w(1)=4.091932358937155e-1_p
x(2)=-18.16457992798965_p
w(2)=9.386210183117976e-1_p
x(3)=-16.97386807761196_p
w(3)=1.435773833893087_p
x(4)=-15.3101252488268_p
w(4)=1.881677154808079_p
x(5)=-13.2334962478453_p
w(5)=2.258634823072077_p
x(6)=-10.82168275549167_p
w(6)=2.548982769102583_p
x(7)=-8.170874758725539_p
w(7)=2.731995132879185_p
x(8)=-5.402025658566568_p
w(8)=2.765149863422880_p
x(9)=-2.682714548277555_p
w(9)=2.455637871991963_p
x(10)=-1.818232776563750e-1_p
w(10)=1.321918117054157_p
x(11)=2.366502029699130_p
w(11)=2.371855328314928e-1_p
x(12)=5.410551941617984_p
w(12)=1.473591089541188e-2_p
x(13)=8.960769746434597_p
w(13)=4.845864657797643e-4_p
x(14)=12.93822071643242_p
w(14)=1.000947326132935e-5_p
x(15)=17.23348360899094_p
w(15)=1.436596857421640e-7_p
x(16)=21.54178412922511_p
w(16)=1.807670689816616e-9_p
x(17)=24.98440438960939_p
w(17)=3.486103891405080e-11_p
else
call GD(-19)
end if
end subroutine GF_m19

! [-18kT;26kT]
subroutine GF_m18(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.00466036091657_p
w(1)=9.439548871161085_p
x(2)=-3.289241401874075_p
w(2)=8.560451144063787_p
else if(N==3)then
x(1)=-15.77082961593816_p
w(1)=5.490612552600121_p
x(2)=-8.150660653422781_p
w(2)=8.668234968377499_p
x(3)=-8.100978760291002e-1_p
w(3)=3.841152494247251_p
else if(N==4)then
x(1)=-16.5571007745595_p
w(1)=3.612723117203091_p
x(2)=-11.15925571888782_p
w(2)=6.728671086461256_p
x(3)=-4.252903313606392_p
w(3)=6.315427517226858_p
x(4)=1.047529149593622_p
w(4)=1.343178294333666_p
else if(N==5)then
x(1)=-16.97406876089292_p
w(1)=2.589714008509615_p
x(2)=-12.96356024066438_p
w(2)=5.206111307394709_p
x(3)=-7.153081844274702_p
w(3)=6.054181760487299_p
x(4)=-1.654999942381089_p
w(4)=3.882545316327274_p
x(5)=3.082191876735619_p
w(5)=2.674476225059739e-1_p
else if(N==6)then
x(1)=-17.22287546843523_p
w(1)=1.970774915542012_p
x(2)=-14.10855797597822_p
w(2)=4.132507624575445_p
x(3)=-9.295087245547148_p
w(3)=5.287688698254675_p
x(4)=-4.019725528823591_p
w(4)=4.886040322399557_p
x(5)=3.086357946863569e-1_p
w(5)=1.694298249642071_p
x(6)=5.514629199785924_p
w(6)=2.869020481111073e-2_p
else if(N==7)then
x(1)=-17.3842805921343_p
w(1)=1.565979403879698_p
x(2)=-14.87837140349355_p
w(2)=3.369846374906548_p
x(3)=-10.85268758380945_p
w(3)=4.552370089776742_p
x(4)=-6.078110421794485_p
w(4)=4.806844310136577_p
x(5)=-1.629950369903711_p
w(5)=3.279064306537163_p
x(6)=2.255236201622391_p
w(6)=4.238322282840061e-1_p
x(7)=8.256774459366152_p
w(7)=2.063301704136277e-3_p
else if(N==8)then
x(1)=-17.49575372422477_p
w(1)=1.284946215913723_p
x(2)=-15.42230195787688_p
w(2)=2.812822252570189_p
x(3)=-12.00651185653533_p
w(3)=3.933248931066111_p
x(4)=-7.758504727095608_p
w(4)=4.443021328625933_p
x(5)=-3.398998258060432_p
w(5)=3.972714855649238_p
x(6)=2.982902393088838e-1_p
w(6)=1.495884574578524_p
x(7)=4.502741594973679_p
w(7)=5.724380592002865e-2_p
x(8)=11.19347252322512_p
w(8)=1.180509011215673e-4_p
else if(N==9)then
x(1)=-17.57676812180292_p
w(1)=1.079967738348068_p
x(2)=-15.82382503672147_p
w(2)=2.392554934105127_p
x(3)=-12.88532207436483_p
w(3)=3.425283681186772_p
x(4)=-9.114375705374824_p
w(4)=4.034207460260215_p
x(5)=-5.008153291634756_p
w(5)=4.035266882275497_p
x(6)=-1.244186748671208_p
w(6)=2.641808588667471_p
x(7)=2.206924002756104_p
w(7)=3.856652648228346e-1_p
x(8)=7.010540821558867_p
w(8)=5.239394425396701e-3_p
x(9)=14.21396916776026_p
w(9)=6.071133488635373e-6_p
else if(N==10)then
x(1)=-17.63836753748414_p
w(1)=9.237046762618775e-1_p
x(2)=-16.1325973828934_p
w(2)=2.064336867646641_p
x(3)=-13.57631045963901_p
w(3)=3.005908920511791_p
x(4)=-10.22225507221988_p
w(4)=3.643027985900571_p
x(5)=-6.426578357911973_p
w(5)=3.862042055156804_p
x(6)=-2.681657381909792_p
w(6)=3.285862962466240_p
x(7)=5.756187795289359e-1_p
w(7)=1.156623456605361_p
x(8)=4.327359494474064_p
w(8)=5.808058830708462e-2_p
x(9)=9.619827646709647_p
w(9)=4.121672679691803e-4_p
x(10)=17.12794122196236_p
w(10)=3.351005310550147e-7_p
else if(N==11)then
x(1)=-17.68701472969006_p
w(1)=8.000535988040076e-1_p
x(2)=-16.3785441470982_p
w(2)=1.799879199816496_p
x(3)=-14.13590656275892_p
w(3)=2.654342687418787_p
x(4)=-11.14459994623459_p
w(4)=3.284641440252746_p
x(5)=-7.666763100908634_p
w(5)=3.611682930768652_p
x(6)=-4.056289387267731_p
w(6)=3.462465520139149_p
x(7)=-7.798996640248826e-1_p
w(7)=2.080420189308975_p
x(8)=2.385001971294302_p
w(8)=2.997325892641778e-1_p
x(9)=6.576087737814219_p
w(9)=6.748383752166034e-3_p
x(10)=12.16211806259473_p
w(10)=3.345017501007544e-5_p
x(11)=19.65223948426952_p
w(11)=2.552470473287843e-8_p
else if(N==12)then
x(1)=-17.72644597917204_p
w(1)=6.996734810306988e-1_p
x(2)=-16.57922462774998_p
w(2)=1.582192005549492_p
x(3)=-14.59834784718677_p
w(3)=2.356314920279171_p
x(4)=-11.92271448197169_p
w(4)=2.962145856725789_p
x(5)=-8.749240866735301_p
w(5)=3.341414018911421_p
x(6)=-5.338802196171901_p
w(6)=3.402602215526738_p
x(7)=-2.056296330821259_p
w(7)=2.728042736392016_p
x(8)=8.833290488887555e-1_p
w(8)=8.745771228832776e-1_p
x(9)=4.311070968101423_p
w(9)=5.227909057674850e-2_p
x(10)=8.809636048705027_p
w(10)=7.553472174920294e-4_p
x(11)=14.49812625380953_p
w(11)=3.216895206787505e-6_p
x(12)=21.57875799773343_p
w(12)=3.236820292441540e-9_p
else if(N==13)then
x(1)=-17.75892319570952_p
w(1)=6.168964911818996e-1_p
x(2)=-16.74537566278566_p
w(2)=1.400728054024291_p
x(3)=-14.98502491333325_p
w(3)=2.102263216757011_p
x(4)=-12.58370250571415_p
w(4)=2.675296871469276_p
x(5)=-9.691894659558237_p
w(5)=3.075541471872826_p
x(6)=-6.506818612139067_p
w(6)=3.246181574897860_p
x(7)=-3.296562122877533_p
w(7)=2.994087776502925_p
x(8)=-3.829024290985829e-1_p
w(8)=1.644490218269073_p
x(9)=2.551005198582383_p
w(9)=2.366091326049437e-1_p
x(10)=6.283106378999349_p
w(10)=7.813385052455978e-3_p
x(11)=10.93287663906922_p
w(11)=9.142376316782518e-5_p
x(12)=16.54549384008174_p
w(12)=3.981377180546101e-7_p
x(13)=22.91257060746427_p
w(13)=6.914219657795321e-10_p
else if(N==14)then
x(1)=-17.78598034569526_p
w(1)=5.478677747670661e-1_p
x(2)=-16.88437211171996_p
w(2)=1.248102926562795_p
x(3)=-15.31104392329452_p
w(3)=1.884846556459217_p
x(4)=-13.14790637637313_p
w(4)=2.421955388505375_p
x(5)=-10.51174360956606_p
w(5)=2.825062887304338_p
x(6)=-7.554726071541616_p
w(6)=3.054763496287990_p
x(7)=-4.476542328032302_p
w(7)=3.018213420711506_p
x(8)=-1.555877209578847_p
w(8)=2.273237674064183_p
x(9)=1.141282210688253_p
w(9)=6.769018462033841e-1_p
x(10)=4.289839207880007_p
w(10)=4.787179035529751e-2_p
x(11)=8.215141736979382_p
w(11)=1.163452722839822e-3_p
x(12)=12.88983053160701_p
w(12)=1.273547837377990e-5_p
x(13)=18.27404002803399_p
w(13)=6.557857146701773e-8_p
x(14)=23.79484134228861_p
w(14)=2.239342685407232e-10_p
else if(N==15)then
x(1)=-17.80874525180758_p
w(1)=4.897444503191303e-1_p
x(2)=-17.00171004112428_p
w(2)=1.118703248555386_p
x(3)=-15.58799458994153_p
w(3)=1.697966475579403_p
x(4)=-13.6319027835051_p
w(4)=2.198890375760493_p
x(5)=-11.22533472516131_p
w(5)=2.594375927054771_p
x(6)=-8.487680015512350_p
w(6)=2.855223782750546_p
x(7)=-5.571745697992611_p
w(7)=2.930461917549226_p
x(8)=-2.689260778436097_p
w(8)=2.599034041848842_p
x(9)=-5.280637451457854e-2_p
w(9)=1.313400850823786_p
x(10)=2.681930281929034_p
w(10)=1.932680798815686e-1_p
x(11)=6.044484473843138_p
w(11)=8.742891636078403e-3_p
x(12)=10.05174729531222_p
w(12)=1.858450044922341e-4_p
x(13)=14.64930657250821_p
w(13)=2.114012902400906e-6_p
x(14)=19.69150740968288_p
w(14)=1.435090260718509e-8_p
x(15)=24.3764109353634_p
w(15)=9.734303045837951e-11_p
else if(N==16)then
x(1)=-17.82807245279406_p
w(1)=4.403669226565290e-1_p
x(2)=-17.10160154437922_p
w(2)=1.008156264428679_p
x(3)=-15.82497442671573_p
w(3)=1.536539426197578_p
x(4)=-14.04932703836114_p
w(4)=2.002539685721679_p
x(5)=-11.8478969740904_p
w(5)=2.384500250322700_p
x(6)=-9.315687733377658_p
w(6)=2.659905176718779_p
x(7)=-6.572396104511173_p
w(7)=2.796709287856276_p
x(8)=-3.777175436239898_p
w(8)=2.689888066074875_p
x(9)=-1.143655564199882_p
w(9)=1.899563472844913_p
x(10)=1.359792489552483_p
w(10)=5.358094272185694e-1_p
x(11)=4.266577800192002_p
w(11)=4.437987211759196e-2_p
x(12)=7.755548367707213_p
w(12)=1.608596621051784e-3_p
x(13)=11.75944641253101_p
w(13)=3.313756684529596e-5_p
x(14)=16.19883787330583_p
w(14)=4.247575490313643e-7_p
x(15)=20.83029195040703_p
w(15)=4.069587008614147e-9_p
x(16)=24.76738256307211_p
w(16)=5.166943507180269e-11_p
else if(N==17)then
x(1)=-17.84461734817285_p
w(1)=3.980754411633725e-1_p
x(2)=-17.18730658112089_p
w(2)=9.130344032409035e-1_p
x(3)=-16.02915705790441_p
w(3)=1.396377617317974_p
x(4)=-14.41131063605947_p
w(4)=1.829467219488014_p
x(5)=-12.39280599042167_p
w(5)=2.194792203368363_p
x(6)=-10.05017734280176_p
w(6)=2.474534359891055_p
x(7)=-7.478916479465974_p
w(7)=2.646398784345195_p
x(8)=-4.801416824551490_p
w(8)=2.656882101669694_p
x(9)=-2.189069339989228_p
w(9)=2.259704678623006_p
x(10)=2.299751274635229e-1_p
w(10)=1.059135014152031_p
x(11)=2.790224243872024_p
w(11)=1.617725908336766e-1_p
x(12)=5.850373916242657_p
w(12)=9.504093594371515e-3_p
x(13)=9.384842258048824_p
w(13)=3.146609076560392e-4_p
x(14)=13.31968669080415_p
w(14)=6.741765489773267e-6_p
x(15)=17.54095524070537_p
w(15)=1.033911965428887e-7_p
x(16)=21.73453607450747_p
w(16)=1.441456397768738e-9_p
x(17)=25.03785784230633_p
w(17)=3.141697800094306e-11_p
else
call GD(-18)
end if
end subroutine GF_m18

! [-17kT;26kT]
subroutine GF_m17(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-13.20653105322503_p
w(1)=8.961195868001401_p
x(2)=-3.048806096658773_p
w(2)=8.038804173392867_p
else if(N==3)then
x(1)=-14.87507691222563_p
w(1)=5.233410355528187_p
x(2)=-7.616418703867758_p
w(2)=8.245051531930315_p
x(3)=-6.275440810264172e-1_p
w(3)=3.521538153935765_p
else if(N==4)then
x(1)=-15.61955160049169_p
w(1)=3.456131733394193_p
x(2)=-10.45765630386558_p
w(2)=6.430831751359322_p
x(3)=-3.872960192908870_p
w(3)=5.957222686733343_p
x(4)=1.255977140332118_p
w(4)=1.155813869907409_p
else if(N==5)then
x(1)=-16.01530884097655_p
w(1)=2.485469010239142_p
x(2)=-12.16740471654176_p
w(2)=4.993084234793066_p
x(3)=-6.601669869855269_p
w(3)=5.783132073796040_p
x(4)=-1.364387276683811_p
w(4)=3.530580837919682_p
x(5)=3.363785086929900_p
w(5)=2.077338846463373e-1_p
else if(N==6)then
x(1)=-16.25203108811512_p
w(1)=1.896736925737021_p
x(2)=-13.25548844805406_p
w(2)=3.975000861540895_p
x(3)=-8.629253846803149_p
w(3)=5.075500729752641_p
x(4)=-3.583065713091891_p
w(4)=4.604235436986090_p
x(5)=5.859884738964278e-1_p
w(5)=1.428168143072422_p
x(6)=5.870487670819466_p
w(6)=2.035794430519794e-2_p
else if(N==7)then
x(1)=-16.40595892176653_p
w(1)=1.510771916328194_p
x(2)=-13.98894349266189_p
w(2)=3.249462947196355_p
x(3)=-10.10946202216249_p
w(3)=4.383400629071692_p
x(4)=-5.521578217169347_p
w(4)=4.595524621460122_p
x(5)=-1.278932423603946_p
w(5)=2.940851677900196_p
x(6)=2.588564791937217_p
w(6)=3.186135168391541e-1_p
x(7)=8.669712637839366_p
w(7)=1.374732598552658e-3_p
else if(N==8)then
x(1)=-16.51252846845729_p
w(1)=1.242146255773281_p
x(2)=-14.50854354355398_p
w(2)=2.717978537742760_p
x(3)=-11.20956770779551_p
w(3)=3.796388725382338_p
x(4)=-7.114909205748341_p
w(4)=4.272496102168605_p
x(5)=-2.940681575566415_p
w(5)=3.712269836500599_p
x(6)=6.301388047355858e-1_p
w(6)=1.219641893724434_p
x(7)=4.904704169967594_p
w(7)=3.900344012441991e-2_p
x(8)=11.6478382429127_p
w(8)=7.524997782934866e-5_p
else if(N==9)then
x(1)=-16.59021011141178_p
w(1)=1.045627434018778_p
x(2)=-14.89330474143038_p
w(2)=2.315626955203407_p
x(3)=-12.05044894296242_p
w(3)=3.312178358832241_p
x(4)=-8.407564582872395_p
w(4)=3.891670477894022_p
x(5)=-4.458060261970686_p
w(5)=3.844664456795417_p
x(6)=-8.631400258111579e-1_p
w(6)=2.308717916030949_p
x(7)=2.586604099518851_p
w(7)=2.781366734740804e-1_p
x(8)=7.458474772497305_p
w(8)=3.373985180552405e-3_p
x(9)=14.68740055685685_p
w(9)=3.783964819909655e-6_p
else if(N==10)then
x(1)=-16.64948377191023_p
w(1)=8.952810357124404e-1_p
x(2)=-15.19026860476767_p
w(2)=2.000187776102465_p
x(3)=-12.71425455789274_p
w(3)=2.910383698491672_p
x(4)=-9.469163841639007_p
w(4)=3.521263718367665_p
x(5)=-5.807390506593792_p
w(5)=3.709987757622236_p
x(6)=-2.223727274629283_p
w(6)=3.018965618036079_p
x(7)=9.437104837360069e-1_p
w(7)=9.052369087070308e-1_p
x(8)=4.758173608110927_p
w(8)=3.843402595547549e-2_p
x(9)=10.08549541680263_p
w(9)=2.592904138581028e-4_p
x(10)=17.57873130222218_p
w(10)=2.119853466385101e-7_p
else if(N==11)then
x(1)=-16.69643257352206_p
w(1)=7.759576173645819e-1_p
x(2)=-15.42753264988519_p
w(2)=1.745210158418614_p
x(3)=-13.25361530219214_p
w(3)=2.572202197373804_p
x(4)=-10.35651045385495_p
w(4)=3.178967366015885_p
x(5)=-6.994962739181576_p
w(5)=3.483006446799457_p
x(6)=-3.525115199008003_p
w(6)=3.271095410842340_p
x(7)=-3.872044377801543e-1_p
w(7)=1.759882809096951_p
x(8)=2.791025836181579_p
w(8)=2.093480025249906e-1_p
x(9)=7.029988915383797_p
w(9)=4.308873388582858e-3_p
x(10)=12.61738390414003_p
w(10)=2.114245536468133e-5_p
x(11)=20.03098207258677_p
w(11)=1.711369499472827e-8_p
else if(N==12)then
x(1)=-16.73454919268549_p
w(1)=6.789313602299865e-1_p
x(2)=-15.62145779034665_p
w(2)=1.534946885159526_p
x(3)=-13.70017035928341_p
w(3)=2.284852060014768_p
x(4)=-11.10683347287276_p
w(4)=2.869513166540167_p
x(5)=-8.035477085654259_p
w(5)=3.229392173420301_p
x(6)=-4.747184065704428_p
w(6)=3.256286664863749_p
x(7)=-1.607747671860200_p
w(7)=2.451064329183224_p
x(8)=1.272694327209052_p
w(8)=6.603356330601831e-1_p
x(9)=4.750065232189435_p
w(9)=3.419656657969403e-2_p
x(10)=9.263626409270659_p
w(10)=4.791134222212138e-4_p
x(11)=14.92114635441335_p
w(11)=2.086570530330560e-6_p
x(12)=21.86269228617731_p
w(12)=2.349917363795272e-9_p
else if(N==13)then
x(1)=-16.76596806703969_p
w(1)=5.988568777556831e-1_p
x(2)=-15.7821492988503_p
w(2)=1.359512202991680_p
x(3)=-14.07392135083274_p
w(3)=2.039591506993589_p
x(4)=-11.74501376449669_p
w(4)=2.593546269964946_p
x(5)=-8.943531269223486_p
w(5)=2.976664837169060_p
x(6)=-5.865818956747751_p
w(6)=3.125256853904259_p
x(7)=-2.784426919484902_p
w(7)=2.793362093678899_p
x(8)=1.832576805541651e-2_p
w(8)=1.346390164801381_p
x(9)=2.971562487980051_p
w(9)=1.617700364411750e-1_p
x(10)=6.733936102159436_p
w(10)=4.990342225250756e-3_p
x(11)=11.37154224203974_p
w(11)=5.858643253400361e-5_p
x(12)=16.92299355573572_p
w(12)=2.684954613413447e-7_p
x(13)=23.11207217305051_p
w(13)=5.403490286525356e-10_p
else if(N==14)then
x(1)=-16.79215715336251_p
w(1)=5.320463741003640e-1_p
x(2)=-15.91665424409362_p
w(2)=1.211866112416324_p
x(3)=-14.38925010423861_p
w(3)=1.829511905569797_p
x(4)=-12.29022645071963_p
w(4)=2.349392595008903_p
x(5)=-9.734424956895770_p
w(5)=2.737066421239108_p
x(6)=-6.872772832971982_p
w(6)=2.950151459932237_p
x(7)=-3.907582654960744_p
w(7)=2.870694573014789_p
x(8)=-1.112646114746356_p
w(8)=1.991663846024657_p
x(9)=1.547491383359663_p
w(9)=4.957826907143249e-1_p
x(10)=4.733595649274303_p
w(10)=3.107416319813363e-2_p
x(11)=8.662051794890131_p
w(11)=7.415168038914386e-4_p
x(12)=13.30255623859754_p
w(12)=8.336922921769961e-6_p
x(13)=18.60025580338839_p
w(13)=4.626365048735159e-8_p
x(14)=23.93273292874805_p
w(14)=1.851659649481064e-10_p
else if(N==15)then
x(1)=-16.81420220295672_p
w(1)=4.757635900997241e-1_p
x(2)=-16.03025853516495_p
w(2)=1.086617821452670_p
x(3)=-14.65727685284721_p
w(3)=1.648801174327928_p
x(4)=-12.75828161761879_p
w(4)=2.134130452595180_p
x(5)=-10.42359086409684_p
w(5)=2.515577575814693_p
x(6)=-7.771309909471191_p
w(6)=2.762585350983875_p
x(7)=-4.955191637257858_p
w(7)=2.813055942657769_p
x(8)=-2.191019484131982_p
w(8)=2.386122066971997_p
x(9)=3.585600573277508e-1_p
w(9)=1.041720096625079_p
x(10)=3.113809358244427_p
w(10)=1.299282901414806e-1_p
x(11)=6.494656748499455_p
w(11)=5.576577241991134e-3_p
x(12)=10.48405308150839_p
w(12)=1.196678216146194e-4_p
x(13)=15.02913191576717_p
w(13)=1.423979208950948e-6_p
x(14)=19.96673671650326_p
w(14)=1.059728402481443e-8_p
x(15)=24.47295655823494_p
w(15)=8.377450032347939e-11_p
else if(N==16)then
x(1)=-16.83292677118108_p
w(1)=4.279275966650521e-1_p
x(2)=-16.12701828004707_p
w(2)=9.795615015876755e-1_p
x(3)=-14.88674568415906_p
w(3)=1.492597327545662_p
x(4)=-13.16222718203443_p
w(4)=1.944442273405070_p
x(5)=-11.02540744702927_p
w(5)=2.313568282009863_p
x(6)=-8.570095098945718_p
w(6)=2.576820798735100_p
x(7)=-5.916011777715428_p
w(7)=2.697120952885063_p
x(8)=-3.226134627688192_p
w(8)=2.535973175978562_p
x(9)=-7.014929676670905e-1_p
w(9)=1.619955589651576_p
x(10)=1.780310583120553_p
w(10)=3.823700014195340e-1_p
x(11)=4.714749064158001_p
w(11)=2.861420387746629e-2_p
x(12)=8.199861360817062_p
w(12)=1.026308448619737e-3_p
x(13)=12.16980899975173_p
w(13)=2.173041039028268e-5_p
x(14)=16.54209746249529_p
w(14)=2.955935951392535e-7_p
x(15)=21.05900151174854_p
w(15)=3.135315994858275e-9_p
x(16)=24.836728537946_p
w(16)=4.572211965102715e-11_p
else if(N==17)then
x(1)=-16.84896260381855_p
w(1)=3.869387929483217e-1_p
x(2)=-16.21007356358444_p
w(2)=8.873989794181010e-1_p
x(3)=-15.08455536599529_p
w(3)=1.356888792955300_p
x(4)=-13.51273077833873_p
w(4)=1.777091312046305_p
x(5)=-11.55257594225744_p
w(5)=2.130642000157805_p
x(6)=-9.279561140242993_p
w(6)=2.399425195931162_p
x(7)=-6.788774729426996_p
w(7)=2.558750335894831_p
x(8)=-4.204807074749954_p
w(8)=2.538922968271069_p
x(9)=-1.700615213618822_p
w(9)=2.035161204627696_p
x(10)=6.518023176306935e-1_p
w(10)=8.152484626684925e-1_p
x(11)=3.231177252610044_p
w(11)=1.072755609965683e-1_p
x(12)=6.301186730928852_p
w(12)=6.049021628230662e-3_p
x(13)=9.815125390572074_p
w(13)=2.028126276253329e-4_p
x(14)=13.70334998395164_p
w(14)=4.525610263125507e-6_p
x(15)=17.84683484984381_p
w(15)=7.443164339922561e-8_p
x(16)=21.92324117856699_p
w(16)=1.152503523076681e-9_p
x(17)=25.08911586809187_p
w(17)=2.835029266988427e-11_p
else
call GD(-17)
end if
end subroutine GF_m17

! [-16kT;26kT]
subroutine GF_m16(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-12.40753460214918_p
w(1)=8.484775125343726_p
x(2)=-2.804962848507195_p
w(2)=7.515224987186333_p
else if(N==3)then
x(1)=-13.97871821771774_p
w(1)=4.977655039317124_p
x(2)=-7.080128279719611_p
w(2)=7.821265255075057_p
x(3)=-4.368117730781311e-1_p
w(3)=3.201079818137877_p
else if(N==4)then
x(1)=-14.68161028658716_p
w(1)=3.300497400477631_p
x(2)=-9.754471059899483_p
w(2)=6.133926172789627_p
x(3)=-3.491671230301113_p
w(3)=5.588154930949264_p
x(4)=1.480173822545733_p
w(4)=9.774216083135375e-1_p
else if(N==5)then
x(1)=-15.05629879406313_p
w(1)=2.381840442826340_p
x(2)=-11.37017102400377_p
w(2)=4.780893856146504_p
x(3)=-6.049164051864227_p
w(3)=5.508456740415925_p
x(4)=-1.069087464777616_p
w(4)=3.171150571739108_p
x(5)=3.666216207722309_p
w(5)=1.576585014021826e-1_p
else if(N==6)then
x(1)=-15.28102775179346_p
w(1)=1.823092373675437_p
x(2)=-12.4017156182295_p
w(2)=3.818084103430961_p
x(3)=-7.962486710904426_p
w(3)=4.862390004417928_p
x(4)=-3.147354338138384_p
w(4)=4.305599143624470_p
x(5)=8.788197762677177e-1_p
w(5)=1.176698322319881_p
x(6)=6.246867287398713_p
w(6)=1.413616506138183e-2_p
else if(N==7)then
x(1)=-15.42753855332426_p
w(1)=1.455808880599070_p
x(2)=-13.09907664809345_p
w(2)=3.129454111717827_p
x(3)=-9.365608834225982_p
w(3)=4.214128331473211_p
x(4)=-4.965914043810723_p
w(4)=4.376192653468221_p
x(5)=-9.249429298562574e-1_p
w(5)=2.590810531280401_p
x(6)=2.944855869186555_p
w(6)=2.327073773480633e-1_p
x(7)=9.101650542039092_p
w(7)=8.982266432670562e-4_p
else if(N==8)then
x(1)=-15.52924920916583_p
w(1)=1.199479342323751_p
x(2)=-13.59455116219578_p
w(2)=2.623323944463870_p
x(3)=-10.41232102376524_p
w(3)=3.659328020811652_p
x(4)=-6.471923855658492_p
w(4)=4.098542025101620_p
x(5)=-2.485578530976099_p
w(5)=3.428092309538032_p
x(6)=9.783977961300565e-1_p
w(6)=9.652430035887339e-1_p
x(7)=5.328217603751945_p
w(7)=2.594431724720810e-2_p
x(8)=12.118929701934_p
w(8)=4.714945519287203e-5_p
else if(N==9)then
x(1)=-15.6036351565633_p
w(1)=1.011327200212851_p
x(2)=-13.96272620568661_p
w(2)=2.238718313461233_p
x(3)=-11.21559802696718_p
w(3)=3.198811844907539_p
x(4)=-7.701466835347046_p
w(4)=3.747325432023056_p
x(5)=-3.911568876397301_p
w(5)=3.639384233925301_p
x(6)=-4.785398327715737e-1_p
w(6)=1.967966541226927_p
x(7)=2.989384408386856_p
w(7)=1.943314336155299e-1_p
x(8)=7.923824172566452_p
w(8)=2.132783887927420e-3_p
x(9)=15.17235070478707_p
w(9)=2.329269695302745e-6_p
else if(N==10)then
x(1)=-15.66060815413053_p
w(1)=8.668343931976855e-1_p
x(2)=-14.24800169976033_p
w(2)=1.935939962631074_p
x(3)=-11.85245140571847_p
w(3)=2.814528683627573_p
x(4)=-8.716936107497439_p
w(4)=3.398308317711652_p
x(5)=-5.191148902713103_p
w(5)=3.550698229877964_p
x(6)=-1.770295163867925_p
w(6)=2.724550574152266_p
x(7)=1.329482959496759_p
w(7)=6.841128865166520e-1_p
x(8)=5.208142495800312_p
w(8)=2.486596808582175e-2_p
x(9)=10.56339025472628_p
w(9)=1.609631897803859e-4_p
x(10)=18.03158831844139_p
w(10)=1.335395904467316e-7_p
else if(N==11)then
x(1)=-15.70586767058187_p
w(1)=7.518159792680652e-1_p
x(2)=-14.47662445705034_p
w(2)=1.690405292791140_p
x(3)=-12.37164329653923_p
w(3)=2.489736635533001_p
x(4)=-9.569260080630629_p
w(4)=3.072431193358171_p
x(5)=-6.325440993052872_p
w(5)=3.350626072802843_p
x(6)=-2.999635044387297_p
w(6)=3.057759451445050_p
x(7)=1.160533271431456e-2_p
w(7)=1.442697446010477_p
x(8)=3.218250976649540_p
w(8)=1.418060187928196e-1_p
x(9)=7.497812855835352_p
w(9)=2.708756743972324e-3_p
x(10)=13.07952385994538_p
w(10)=1.325426860495769e-5_p
x(11)=20.40281992942185_p
w(11)=1.151591504122141e-8_p
else if(N==12)then
x(1)=-15.74266949537462_p
w(1)=6.581443837978737e-1_p
x(2)=-14.66378988901598_p
w(2)=1.487576233871071_p
x(3)=-12.80228213848011_p
w(3)=2.213114667463886_p
x(4)=-10.29165592931124_p
w(4)=2.776245658431279_p
x(5)=-7.323423375338996_p
w(5)=3.115275577468243_p
x(6)=-4.160028143784086_p
w(6)=3.097897455571315_p
x(7)=-1.162316251253675_p
w(7)=2.149187817436884_p
x(8)=1.680678295927189_p
w(8)=4.803417260576408e-1_p
x(9)=5.205854852649970_p
w(9)=2.191467373916745e-2_p
x(10)=9.727346541173498_p
w(10)=3.005688914397682e-4_p
x(11)=15.34653819516396_p
w(11)=1.348083488632520e-6_p
x(12)=22.13645590335959_p
w(12)=1.717771562102969e-9_p
else if(N==13)then
x(1)=-15.77302773121598_p
w(1)=5.807785405514919e-1_p
x(2)=-14.81900757831056_p
w(2)=1.318190371919296_p
x(3)=-13.16305993855139_p
w(3)=1.976697093283283_p
x(4)=-10.90689292994184_p
w(4)=2.511318332732773_p
x(5)=-8.196461659639176_p
w(5)=2.876480005145164_p
x(6)=-5.228017433600137_p
w(6)=2.998130180296508_p
x(7)=-2.278285738086575_p
w(7)=2.565193476820428_p
x(8)=4.289397800805781e-1_p
w(8)=1.062602719808512_p
x(9)=3.411819622007710_p
w(9)=1.074295863934626e-1_p
x(10)=7.197142051166592_p
w(10)=3.142362440000102e-3_p
x(11)=11.8164688378662_p
w(11)=3.726178104708445e-5_p
x(12)=17.29949575492833_p
w(12)=1.809330938213914e-7_p
x(13)=23.30258315561296_p
w(13)=4.249996916891955e-10_p
else if(N==14)then
x(1)=-15.79834671576172_p
w(1)=5.161916506758040e-1_p
x(2)=-14.9490087273772_p
w(2)=1.175539609917669_p
x(3)=-13.46765991122195_p
w(3)=1.773994452834202_p
x(4)=-11.43301123117306_p
w(4)=2.276459358884634_p
x(5)=-8.958114765188443_p
w(5)=2.648182204528444_p
x(6)=-6.193140118611644_p
w(6)=2.842187849398103_p
x(7)=-3.343975115566272_p
w(7)=2.705461322107398_p
x(8)=-6.699090108924338e-1_p
w(8)=1.692121451752749_p
x(9)=1.972699759176760_p
w(9)=3.496019131465306e-1_p
x(10)=5.192721376093433_p
w(10)=1.978706009120315e-2_p
x(11)=9.117875703330757_p
w(11)=4.677741727097439e-4_p
x(12)=13.71861504296415_p
w(12)=5.432184027161605e-6_p
x(13)=18.92330190788913_p
w(13)=3.268274666913621e-8_p
x(14)=24.06403081106648_p
w(14)=1.538385636213058e-10_p
else if(N==15)then
x(1)=-15.81967032512696_p
w(1)=4.617535983597691e-1_p
x(2)=-15.05886988941976_p
w(2)=1.054455191251519_p
x(3)=-13.72673341408469_p
w(3)=1.599482803998724_p
x(4)=-11.88504885522794_p
w(4)=2.069074441383584_p
x(5)=-9.622657036578573_p
w(5)=2.436137135013450_p
x(6)=-7.056684557289561_p
w(6)=2.667971896134824_p
x(7)=-4.342690758014523_p
w(7)=2.685938323364649_p
x(8)=-1.698147360492608_p
w(8)=2.143332289915989_p
x(9)=7.819146551758117e-1_p
w(9)=7.932971789620580e-1_p
x(10)=3.564031930846851_p
w(10)=8.496991110656490e-2_p
x(11)=6.956214444329718_p
w(11)=3.509884722453055e-3_p
x(12)=10.92244187016058_p
w(12)=7.649346932849568e-5_p
x(13)=15.40993720982475_p
w(13)=9.569297333708961e-7_p
x(14)=20.23774416152667_p
w(14)=7.845086764034757e-9_p
x(15)=24.56497229846097_p
w(15)=7.232709814284454e-11_p
else if(N==16)then
x(1)=-15.83779097959395_p
w(1)=4.154625221868548e-1_p
x(2)=-15.15249027003578_p
w(2)=9.508994405680152e-1_p
x(3)=-13.94866814030073_p
w(3)=1.448525026897341_p
x(4)=-12.27545737141334_p
w(4)=1.886102678554668_p
x(5)=-10.20358406439693_p
w(5)=2.242149577707304_p
x(6)=-7.825860530075897_p
w(6)=2.492467875115665_p
x(7)=-5.262624578857406_p
w(7)=2.592261332239698_p
x(8)=-2.680974841265231_p
w(8)=2.358748309181837_p
x(9)=-2.569566088815990e-1_p
w(9)=1.331791365790828_p
x(10)=2.219594875318642_p
w(10)=2.628108558856240e-1_p
x(11)=5.177097831002481_p
w(11)=1.811827496441325e-2_p
x(12)=8.652499401681393_p
w(12)=6.484659410009561e-4_p
x(13)=12.58391757749863_p
w(13)=1.417945656869944e-5_p
x(14)=16.8846065528102_p
w(14)=2.055772662014755e-7_p
x(15)=21.28328079918926_p
w(15)=2.422433983768650e-9_p
x(16)=24.90299624256216_p
w(16)=4.054100160143615e-11_p
else if(N==17)then
x(1)=-15.85331667004612_p
w(1)=3.757792391354445e-1_p
x(2)=-15.23288946636934_p
w(2)=8.617044018293197e-1_p
x(3)=-14.14008602701363_p
w(3)=1.317287926057850_p
x(4)=-12.61443479676987_p
w(4)=1.724513760547024_p
x(5)=-10.71290358509655_p
w(5)=2.066109815320593_p
x(6)=-8.510032552971404_p
w(6)=2.323440096222041_p
x(7)=-6.100891236356742_p
w(7)=2.468087670831688_p
x(8)=-3.613035530754528_p
w(8)=2.406868119728052_p
x(9)=-1.216177429080773_p
w(9)=1.781984297732918_p
x(10)=1.087421728467187_p
w(10)=6.009848602574361e-1_p
x(11)=3.689187301063807_p
w(11)=6.930532598133866e-2_p
x(12)=6.762576907650405_p
w(12)=3.801722068050065e-3_p
x(13)=10.2513055751582_p
w(13)=1.297936620687929e-4_p
x(14)=14.08888296566686_p
w(14)=3.028594814478833e-6_p
x(15)=18.15082967389442_p
w(15)=5.361181498947673e-8_p
x(16)=22.10780581385157_p
w(16)=9.239913056512927e-10_p
x(17)=25.13825533786869_p
w(17)=2.561398249847336e-11_p
else
call GD(-16)
end if
end subroutine GF_m16

! [-15kT;26kT]
subroutine GF_m15(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-11.60756997386616_p
w(1)=8.010480026888077_p
x(2)=-2.557094432509374_p
w(2)=6.989520279009088_p
else if(N==3)then
x(1)=-13.08170713400058_p
w(1)=4.723446641362276_p
x(2)=-6.541749689590541_p
w(2)=7.396058994486616_p
x(3)=-2.364727760314134e-1_p
w(3)=2.880494670048273_p
else if(N==4)then
x(1)=-13.7432598000445_p
w(1)=3.145856255639208_p
x(2)=-9.049690145281501_p
w(2)=5.837742397702302_p
x(3)=-3.109009985991661_p
w(3)=5.206261121850701_p
x(4)=1.722326681516655_p
w(4)=8.101405307049545e-1_p
else if(N==5)then
x(1)=-14.09703524123455_p
w(1)=2.278833293357533_p
x(2)=-10.57187734467103_p
w(2)=4.569439159391039_p
x(3)=-5.495881722000618_p
w(3)=5.228386430330067_p
x(4)=-7.674635467268350e-1_p
w(4)=2.806619484892665_p
x(5)=3.991060422109427_p
w(5)=1.167219379258602e-1_p
else if(N==6)then
x(1)=-14.30986826608245_p
w(1)=1.749831983377912_p
x(2)=-11.54727341149428_p
w(2)=3.661680712075215_p
x(3)=-7.295021129574884_p
w(3)=4.647621077179346_p
x(4)=-2.712801633280624_p
w(4)=3.986950635179946_p
x(5)=1.190015549646301_p
w(5)=9.443190568580695e-1_p
x(6)=6.644734692263892_p
w(6)=9.596841226674226e-3_p
else if(N==7)then
x(1)=-14.44902540422222_p
w(1)=1.401073832367940_p
x(2)=-12.20881333310815_p
w(2)=3.009750508222796_p
x(3)=-8.621315020975516_p
w(3)=4.044184290193426_p
x(4)=-4.411800414532002_p
w(4)=4.145583606389931_p
x(5)=-5.656687474181827e-1_p
w(5)=2.233932273715423_p
x(6)=3.325688472952307_p
w(6)=1.649006656178290e-1_p
x(7)=9.553282468636842_p
w(7)=5.751293898209741e-4_p
else if(N==8)then
x(1)=-14.54592409567603_p
w(1)=1.156923749831588_p
x(2)=-12.68037462583839_p
w(2)=2.528789388836235_p
x(3)=-9.614941641630981_p
w(3)=3.521830609872753_p
x(4)=-5.830120689348393_p
w(4)=3.919477014028569_p
x(5)=-2.033599777173007_p
w(5)=3.117413882015546_p
x(6)=1.346463525489441_p
w(6)=7.386923565538054e-1_p
x(7)=5.773755006420881_p
w(7)=1.684427428679496e-2_p
x(8)=12.60698830514148_p
w(8)=2.903047187340071e-5_p
else if(N==9)then
x(1)=-14.61705241460756_p
w(1)=9.770430090642511e-1_p
x(2)=-13.03214193197622_p
w(2)=2.161761725901364_p
x(3)=-10.38092660427519_p
w(3)=3.085009172056262_p
x(4)=-6.996527868784677_p
w(4)=3.600314131920624_p
x(5)=-3.369584599656431_p
w(5)=3.414363807869216_p
x(6)=-8.698610828141320e-2_p
w(6)=1.628675055540249_p
x(7)=3.416262126932677_p
w(7)=1.315085532221434e-1_p
x(8)=8.406581457165233_p
w(8)=1.323433451001752e-3_p
x(9)=15.66807211890269_p
w(9)=1.416872054422933e-6_p
else if(N==10)then
x(1)=-14.67174834245924_p
w(1)=8.383447149046639e-1_p
x(2)=-13.3058399447528_p
w(2)=1.871539105628783_p
x(3)=-10.99102579085905_p
w(3)=2.718216880563242_p
x(4)=-7.965896395977878_p
w(4)=3.273688109386152_p
x(5)=-4.578708453605083_p
w(5)=3.380959397874567_p
x(6)=-1.320169296994319_p
w(6)=2.403572766213758_p
x(7)=1.736042345373981_p
w(7)=4.978425700616447e-1_p
x(8)=5.677108339419957_p
w(8)=1.573803979969000e-2_p
x(9)=11.05308781638612_p
w(9)=9.863758337964729e-5_p
x(10)=18.48484020183938_p
w(10)=8.388128420048688e-8_p
else if(N==11)then
x(1)=-14.71532536280081_p
w(1)=7.276146743038175e-1_p
x(2)=-13.52584995153452_p
w(2)=1.635426239445529_p
x(3)=-11.49007844481487_p
w(3)=2.406858087864781_p
x(4)=-8.783072220992180_p
w(4)=2.964752886956071_p
x(5)=-5.658805565898270_p
w(5)=3.212856536420244_p
x(6)=-2.480354782872999_p
w(6)=2.816989729170664_p
x(7)=4.207062436480037e-1_p
w(7)=1.140583278850069_p
x(8)=3.667056423293345_p
w(8)=9.323349107643918e-2_p
x(9)=7.979276308173405_p
w(9)=1.677128470411958e-3_p
x(10)=13.54791732732271_p
w(10)=8.245553178132266e-6_p
x(11)=20.7663675044756_p
w(11)=7.785960608137940e-9_p
else if(N==12)then
x(1)=-14.75081084293961_p
w(1)=6.373021598044520e-1_p
x(2)=-13.70624349185913_p
w(2)=1.440051493752687_p
x(3)=-11.90474838854397_p
w(3)=2.141038673516149_p
x(4)=-9.477343644046805_p
w(4)=2.682163235128404_p
x(5)=-6.613503481548515_p
w(5)=2.998174955566610_p
x(6)=-3.578228623886500_p
w(6)=2.922502079062090_p
x(7)=-7.174474221814523e-1_p
w(7)=1.828601002135364_p
x(8)=2.109696007774937_p
w(8)=3.362090183254731e-1_p
x(9)=5.678125783699094_p
w(9)=1.377026991877295e-2_p
x(10)=10.2004555889404_p
w(10)=1.865494145117987e-4_p
x(11)=15.77364156141605_p
w(11)=8.680077778366352e-7_p
x(12)=22.39954473292135_p
w(12)=1.264872331353887e-9_p
else if(N==13)then
x(1)=-14.78010547040554_p
w(1)=5.626528660185927e-1_p
x(2)=-13.85596911156856_p
w(2)=1.276739210311338_p
x(3)=-12.25249361189027_p
w(3)=1.913529654338235_p
x(4)=-10.06946656808326_p
w(4)=2.428487154947652_p
x(5)=-7.450995816423839_p
w(5)=2.774484438801224_p
x(6)=-4.594186367000125_p
w(6)=2.861840566300715_p
x(7)=-1.777852178623946_p
w(7)=2.305970562394874_p
x(8)=8.532025258499957e-1_p
w(8)=8.049253023064812e-1_p
x(9)=3.871789034748600_p
w(9)=6.939525921186054e-2_p
x(10)=7.672401155361653_p
w(10)=1.951639852359014e-3_p
x(11)=12.2672477440075_p
w(11)=2.352918052159926e-5_p
x(12)=17.67439636189714_p
w(12)=1.218968893170235e-7_p
x(13)=23.48412248838804_p
w(13)=3.364244914829789e-10_p
else if(N==14)then
x(1)=-14.80455187796392_p
w(1)=5.002961510726055e-1_p
x(2)=-13.98145156183534_p
w(2)=1.139103556566852_p
x(3)=-12.54631805340276_p
w(3)=1.718253086387157_p
x(4)=-10.57636389175543_p
w(4)=2.203062275371829_p
x(5)=-8.183049803962451_p
w(5)=2.558102466893321_p
x(6)=-5.516412884423231_p
w(6)=2.729243412517721_p
x(7)=-2.786476558153082_p
w(7)=2.516393737585072_p
x(8)=-2.240738068373553e-1_p
w(8)=1.385497003661110_p
x(9)=2.418589577506916_p
w(9)=2.373804421923311e-1_p
x(10)=5.666788726241277_p
w(10)=1.237245801444207e-2_p
x(11)=9.582278693563818_p
w(11)=2.921680114408048e-4_p
x(12)=14.13756453432201_p
w(12)=3.524365419589956e-6_p
x(13)=19.24270826056427_p
w(13)=2.312946288367973e-8_p
x(14)=24.18889606793231_p
w(14)=1.284024486742726e-10_p
else if(N==15)then
x(1)=-14.8251521036146_p
w(1)=4.477079739469083e-1_p
x(2)=-14.08755798288234_p
w(2)=1.022198284600054_p
x(3)=-12.79640248272722_p
w(3)=1.549977176295752_p
x(4)=-11.0122901909884_p
w(4)=2.003650259003136_p
x(5)=-8.822719707132585_p
w(5)=2.355851801977196_p
x(6)=-6.344240237961484_p
w(6)=2.570472297398354_p
x(7)=-3.735134737455228_p
w(7)=2.544601120950375_p
x(8)=-1.209333936756776_p
w(8)=1.870959381382443_p
x(9)=1.221164510097963_p
w(9)=5.781957841843414e-1_p
x(10)=4.032342539242723_p
w(10)=5.415603683165685e-2_p
x(11)=7.428777644555535_p
w(11)=2.180987543457957e-3_p
x(12)=11.36655746789502_p
w(12)=4.855411166062480e-5_p
x(13)=15.79129724450911_p
w(13)=6.417855235761234e-7_p
x(14)=20.5042196800459_p
w(14)=5.823673576553484e-9_p
x(15)=24.6526096597529_p
w(15)=6.263368730023999e-11_p
else if(N==16)then
x(1)=-14.84266725431673_p
w(1)=4.029660131604096e-1_p
x(2)=-14.17802959788234_p
w(2)=9.221553264100876e-1_p
x(3)=-13.01077466271704_p
w(3)=1.404293755128498_p
x(4)=-11.38908967325911_p
w(4)=1.827463657080337_p
x(5)=-9.382577172771688_p
w(5)=2.170102104984154_p
x(6)=-7.083315174362606_p
w(6)=2.406309631175723_p
x(7)=-4.612980012660287_p
w(7)=2.479422792189221_p
x(8)=-2.142022533115956_p
w(8)=2.152256708057998_p
x(9)=1.941843292243604e-1_p
w(9)=1.049122302615127_p
x(10)=2.678696160846082_p
w(10)=1.742135106663180e-1_p
x(11)=5.653115364599701_p
w(11)=1.127924334185226e-2_p
x(12)=9.113118312207950_p
w(12)=4.059069223274942e-4_p
x(13)=13.00141197955846_p
w(13)=9.209325360266199e-6_p
x(14)=17.22599677687336_p
w(14)=1.429265001699229e-7_p
x(15)=21.50295536251013_p
w(15)=1.877236233507802e-9_p
x(16)=24.96629669683812_p
w(16)=3.601500537842206e-11_p
else if(N==17)then
x(1)=-14.85768145922112_p
w(1)=3.645917880317348e-1_p
x(2)=-14.25576485648045_p
w(2)=8.359378467433769e-1_p
x(3)=-13.19577749769233_p
w(3)=1.277550555416888_p
x(4)=-11.71648395285935_p
w(4)=1.671688076047753_p
x(5)=-9.873912506046675_p
w(5)=2.001091190137503_p
x(6)=-7.741849337195329_p
w(6)=2.246242778655008_p
x(7)=-5.415841186047152_p
w(7)=2.372851813127105_p
x(8)=-3.026966675812690_p
w(8)=2.254814821825168_p
x(9)=-7.333703665295974e-1_p
w(9)=1.505474922482944_p
x(10)=1.540148945650532_p
w(10)=4.235965729930976e-1_p
x(11)=4.163817432295385_p
w(11)=4.371462879962477e-2_p
x(12)=7.234126917303628_p
w(12)=2.360752286843534e-3_p
x(13)=10.69305250794464_p
w(13)=8.249883175370864e-5_p
x(14)=14.47594434399905_p
w(14)=2.021107228525449e-6_p
x(15)=18.45264673938259_p
w(15)=3.864512262732141e-8_p
x(16)=22.28814788399158_p
w(16)=7.428462481175331e-10_p
x(17)=25.18535182998619_p
w(17)=2.316750131371466e-11_p
else
call GD(-15)
end if
end subroutine GF_m15

! [-14kT;26kT]
subroutine GF_m14(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.80652726743162_p
w(1)=7.538498985580396_p
x(2)=-2.304430752795460_p
w(2)=6.461501845942869_p
else if(N==3)then
x(1)=-12.18399784616892_p
w(1)=4.470876804830689_p
x(2)=-6.001285075120887_p
w(2)=6.968250842051368_p
x(3)=-2.478266708050312e-2_p
w(3)=2.560873184641208_p
else if(N==4)then
x(1)=-12.80448631955729_p
w(1)=2.992233504880373_p
x(2)=-8.343342525369343_p
w(2)=5.541916792740853_p
x(3)=-2.724817830296562_p
w(3)=4.809655422622050_p
x(4)=1.984896643746563_p
w(4)=6.561951112799884e-1_p
else if(N==5)then
x(1)=-13.13751829421442_p
w(1)=2.176442207987691_p
x(2)=-9.772570524770620_p
w(2)=4.358548041538520_p
x(3)=-4.942247566734081_p
w(3)=4.940450244830999_p
x(4)=-4.573585993332386e-1_p
w(4)=2.440398340541524_p
x(5)=4.339897122697867_p
w(5)=8.416199662452960e-2_p
else if(N==6)then
x(1)=-13.33855862898347_p
w(1)=1.676937448025881_p
x(2)=-10.69221813321446_p
w(2)=3.505671005030289_p
x(3)=-6.627192423735459_p
w(3)=4.430072679919284_p
x(4)=-2.279337265801443_p
w(4)=3.645584141848317_p
x(5)=1.522696733913804_p
w(5)=7.353717286608499e-1_p
x(6)=7.065073389061740_p
w(6)=6.363828038644039e-3_p
else if(N==7)then
x(1)=-13.47042829433577_p
w(1)=1.346542297109063_p
x(2)=-11.3182146377724_p
w(2)=2.890252065044816_p
x(3)=-7.876841252701429_p
w(3)=3.873007087728633_p
x(4)=-3.860026971761282_p
w(4)=3.899352975008541_p
x(5)=-1.980185852883720e-1_p
w(5)=1.877236338126527_p
x(6)=3.732453206252701_p
w(6)=1.132494436016382e-1_p
x(7)=10.02530138890135_p
w(7)=3.606249040462930e-4_p
else if(N==8)then
x(1)=-13.56256394722161_p
w(1)=1.114450505494366_p
x(2)=-11.76607991036146_p
w(2)=2.434281706514802_p
x(3)=-8.817655789266670_p
w(3)=3.383551780549493_p
x(4)=-5.190236956336649_p
w(4)=3.732777222803791_p
x(5)=-1.583980449923732_p
w(5)=2.779532405164342_p
x(6)=1.737700053275692_p
w(6)=5.447173420528494e-1_p
x(7)=6.241717797107295_p
w(7)=1.067230797694224e-2_p
x(8)=13.11215583552952_p
w(8)=1.756096667852952e-5_p
else if(N==9)then
x(1)=-13.63047311907184_p
w(1)=9.427452083847453e-1_p
x(2)=-12.10161678038144_p
w(2)=2.084672141495096_p
x(3)=-9.546632785426954_p
w(3)=2.970529323060299_p
x(4)=-6.293321264647128_p
w(4)=3.449313142827545_p
x(5)=-2.832916696279120_p
w(5)=3.163746836518064_p
x(6)=3.157027537042390e-1_p
w(6)=1.301969662126929_p
x(7)=3.867870990817838_p
w(7)=8.621745932702957e-2_p
x(8)=8.906653988258769_p
w(8)=8.062054495641510e-4_p
x(9)=16.1735705994558_p
w(9)=8.523339918599878e-7_p
else if(N==10)then
x(1)=-13.68291332323974_p
w(1)=8.097883233673266e-1_p
x(2)=-12.36383466198707_p
w(2)=1.806919104716199_p
x(3)=-10.13012935908662_p
w(3)=2.621280232611732_p
x(4)=-7.216455043350998_p
w(4)=3.146680054061471_p
x(5)=-3.971062894664068_p
w(5)=3.196203676715083_p
x(6)=-8.710385123552064e-1_p
w(6)=2.061105251431955_p
x(7)=2.166042215344949_p
w(7)=3.482144612052502e-1_p
x(8)=6.164836853488358_p
w(8)=9.749983305427061e-3_p
x(9)=11.55408004168485_p
w(9)=5.969149423583711e-5_p
x(10)=18.93664706082552_p
w(10)=5.261458436028140e-8_p
else if(N==11)then
x(1)=-13.72481200596446_p
w(1)=7.033369014693742e-1_p
x(2)=-12.57524563397986_p
w(2)=1.580225771426591_p
x(3)=-10.60902859827299_p
w(3)=2.323450567490580_p
x(4)=-7.998231039827377_p
w(4)=2.855511100556026_p
x(5)=-4.995823381331953_p
w(5)=3.067091871623289_p
x(6)=-1.967241045995004_p
w(6)=2.544277420598965_p
x(7)=8.446602042314603e-1_p
w(7)=8.655119605523552e-1_p
x(8)=4.137492603169889_p
w(8)=5.956707720349423e-2_p
x(9)=8.474063107159525_p
w(9)=1.023062130613027e-3_p
x(10)=14.02188427823014_p
w(10)=5.093177122549733e-6_p
x(11)=21.12029578437946_p
w(11)=5.294854925011716e-9_p
else if(N==12)then
x(1)=-13.75897811039687_p
w(1)=6.163917848249439e-1_p
x(2)=-12.74884657855991_p
w(2)=1.392336556216914_p
x(3)=-11.00765105642392_p
w(3)=2.068538911532719_p
x(4)=-8.664105203782961_p
w(4)=2.586999192112214_p
x(5)=-5.906271576929366_p
w(5)=2.876669264670416_p
x(6)=-3.002663894821401_p
w(6)=2.723816072201785_p
x(7)=-2.693756089810669e-1_p
w(7)=1.500234263594640_p
x(8)=2.561495192389474_p
w(8)=2.264090757927239e-1_p
x(9)=6.166518506287002_p
w(9)=8.490566801189092e-3_p
x(10)=10.68257407905432_p
w(10)=1.145855190070105e-4_p
x(11)=16.20175517952473_p
w(11)=5.573181786499517e-7_p
x(12)=22.65155920991516_p
w(12)=9.385333000234395e-10_p
else if(N==13)then
x(1)=-13.78720538397585_p
w(1)=5.444690184629314e-1_p
x(2)=-12.89305723791124_p
w(2)=1.235128940227161_p
x(3)=-11.34228940269266_p
w(3)=1.850022492366909_p
x(4)=-9.232898092555175_p
w(4)=2.344870147326751_p
x(5)=-6.707542871771710_p
w(5)=2.669872014591511_p
x(6)=-3.965254291791399_p
w(6)=2.712000928659526_p
x(7)=-1.281842920645020_p
w(7)=2.015571736263566_p
x(8)=1.295268181605571_p
w(8)=5.831820223602686e-1_p
x(9)=4.351212675747423_p
w(9)=4.367267492120903e-2_p
x(10)=8.159367113728655_p
w(10)=1.196017282339437e-3_p
x(11)=12.72343225932561_p
w(11)=1.475664782940010e-5_p
x(12)=18.04707360696385_p
w(12)=8.214525170729016e-8_p
x(13)=23.6567636172948_p
w(13)=2.680103929798602e-10_p
else if(N==14)then
x(1)=-13.81077619178714_p
w(1)=4.843505036901318e-1_p
x(2)=-13.01400279387358_p
w(2)=1.102532678778182_p
x(3)=-11.6252810106433_p
w(3)=1.662233766306324_p
x(4)=-9.720416942021938_p
w(4)=2.129068800670333_p
x(5)=-7.409541611428146_p
w(5)=2.466339781240228_p
x(6)=-4.843343108361669_p
w(6)=2.608732004354977_p
x(7)=-2.235512477318126_p
w(7)=2.297063219886470_p
x(8)=2.294498665940765e-1_p
w(8)=1.086491610562613_p
x(9)=2.886122518581449_p
w(9)=1.554019163709437e-1_p
x(10)=6.155338095215518_p
w(10)=7.603515233918705e-3_p
x(11)=10.05489846372656_p
w(11)=1.807402279309578e-4_p
x(12)=14.5589335578301_p
w(12)=2.277689702150531e-6_p
x(13)=19.5580085017412_p
w(13)=1.640386034270619e-8_p
x(14)=24.30750717427471_p
w(14)=1.076507239574798e-10_p
else if(N==15)then
x(1)=-13.83065063345801_p
w(1)=4.336185623305899e-1_p
x(2)=-13.11634015689417_p
w(2)=9.898254529410618e-1_p
x(3)=-11.86633215450204_p
w(3)=1.500239700410824_p
x(4)=-10.14011506383505_p
w(4)=1.937757535397173_p
x(5)=-8.024022646640487_p
w(5)=2.274406974307113_p
x(6)=-5.634551101161173_p
w(6)=2.468597381301897_p
x(7)=-3.133466781537099_p
w(7)=2.382897704939270_p
x(8)=-7.219532070301781e-1_p
w(8)=1.574938932814320_p
x(9)=1.679687129304493_p
w(9)=4.026464283709052e-1_p
x(10)=4.518271856066368_p
w(10)=3.370248813598103e-2_p
x(11)=7.911953558744503_p
w(11)=1.338622147418528e-3_p
x(12)=11.816018329672_p
w(12)=3.061431046241908e-5_p
x(13)=16.17277038006325_p
w(13)=4.297258047775773e-7_p
x(14)=20.76586741946939_p
w(14)=4.336047604401004e-9_p
x(15)=24.73602319902255_p
w(15)=5.439569154094714e-11_p
else if(N==16)then
x(1)=-13.84755830098178_p
w(1)=3.904309489860412e-1_p
x(2)=-13.20365133214584_p
w(2)=8.933104984697613e-1_p
x(3)=-12.07310651182342_p
w(3)=1.359866215773502_p
x(4)=-10.50321570999853_p
w(4)=1.768446722427014_p
x(5)=-8.562582040996645_p
w(5)=2.097210568413233_p
x(6)=-6.342897299441294_p
w(6)=2.317463036511503_p
x(7)=-3.967987968687613_p
w(7)=2.354463837617252_p
x(8)=-1.608853468178381_p
w(8)=1.912360448826846_p
x(9)=6.567366232309914e-1_p
w(9)=7.876505096065728e-1_p
x(10)=3.157983136985395_p
w(10)=1.116297701575536e-1_p
x(11)=6.142275582858139_p
w(11)=6.910422891798203e-3_p
x(12)=9.581356878084705_p
w(12)=2.517955834842256e-4_p
x(13)=13.4219126460403_p
w(13)=5.955400798185823e-6_p
x(14)=17.56589410027617_p
w(14)=9.936659576890929e-8_p
x(15)=21.71786592063839_p
w(15)=1.459256787351043e-9_p
x(16)=25.02674007855758_p
w(16)=3.205065434717731e-11_p
else if(N==17)then
x(1)=-13.86205934641725_p
w(1)=3.533701944753708e-1_p
x(2)=-13.27871289443315_p
w(2)=8.100831252404836e-1_p
x(3)=-12.25166543152262_p
w(3)=1.237645117417341_p
x(4)=-10.81895586025289_p
w(4)=1.618551307704462_p
x(5)=-9.035762282913900_p
w(5)=1.935431305468072_p
x(6)=-6.975351999573065_p
w(6)=2.167284100801497_p
x(7)=-4.734366589066408_p
w(7)=2.270517203256166_p
x(8)=-2.447286893930964_p
w(8)=2.075721142417778_p
x(9)=-2.484287020437311e-1_p
w(9)=1.217409769615558_p
x(10)=2.012490613954595_p
w(10)=2.855097714460442e-1_p
x(11)=4.654467346518318_p
w(11)=2.697512307752152e-2_p
x(12)=7.715415814376347_p
w(12)=1.449199846570197e-3_p
x(13)=11.14001913523216_p
w(13)=5.209685986857539e-5_p
x(14)=14.86418026305088_p
w(14)=1.345392302463483e-6_p
x(15)=18.75199458110837_p
w(15)=2.788435840695844e-8_p
x(16)=22.46419721002235_p
w(16)=5.988938102663650e-10_p
x(17)=25.23047953160737_p
w(17)=2.097579813908043e-11_p
else
call GD(-14)
end if
end subroutine GF_m14

! [-13kT;26kT]
subroutine GF_m13(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.00429020261604_p
w(1)=7.068991848353496_p
x(2)=-2.046000739186755_p
w(2)=5.931010411968247_p
else if(N==3)then
x(1)=-11.28554791835755_p
w(1)=4.220016793371549_p
x(2)=-5.458790550604832_p
w(2)=6.536163409510841_p
x(3)=2.003952209834572e-1_p
w(3)=2.243822057439354_p
else if(N==4)then
x(1)=-11.86528138228374_p
w(1)=2.839635820517541_p
x(2)=-7.635514620331914_p
w(2)=5.245844146403225_p
x(3)=-2.338700639182559_p
w(3)=4.396806873508912_p
x(4)=2.270581736415933_p
w(4)=5.177154198920646e-1_p
else if(N==5)then
x(1)=-12.17775314854112_p
w(1)=2.074646227784142_p
x(2)=-8.972338856897567_p
w(2)=4.147934115151702_p
x(3)=-4.388797232199637_p
w(3)=4.641273043667309_p
x(4)=-1.359989303686970e-1_p
w(4)=2.077137507364223_p
x(5)=4.714299569959376_p
w(5)=5.901136635436690e-2_p
else if(N==6)then
x(1)=-12.3671092566648_p
w(1)=1.604377518261300_p
x(2)=-9.836637487057663_p
w(2)=3.349868139119150_p
x(3)=-5.959468360712150_p
w(3)=4.208023816119276_p
x(4)=-1.846394870708148_p
w(4)=3.280044754568204_p
x(5)=1.880112530238435_p
w(5)=5.535700235400346e-1_p
x(6)=7.508886383667542_p
w(6)=4.118008713779598e-3_p
else if(N==7)then
x(1)=-12.49175994758068_p
w(1)=1.292178679122219_p
x(2)=-10.42736713028786_p
w(2)=2.770812483442385_p
x(3)=-7.132549648452570_p
w(3)=3.699719854782178_p
x(4)=-3.311418686038213_p
w(4)=3.632043998434342_p
x(5)=1.819143441167289e-1_p
w(5)=1.529703599275067_p
x(6)=4.166340712819828_p
w(6)=7.532235804397361e-2_p
x(7)=10.51839234186712_p
w(7)=2.212872215792557e-4_p
else if(N==8)then
x(1)=-12.57918304764531_p
w(1)=1.072020944103327_p
x(2)=-10.85175436531214_p
w(2)=2.339672960511292_p
x(3)=-8.020766531921916_p
w(3)=3.243968892582891_p
x(4)=-4.553198413158108_p
w(4)=3.534701668288375_p
x(5)=-1.134959725895585_p
w(5)=2.417127209371925_p
x(6)=2.155213302926346_p
w(6)=3.859023233353333e-1_p
x(7)=6.732437305138669_p
w(7)=6.597826543835878e-3_p
x(8)=13.63444213572567_p
w(8)=1.043558476364051e-5_p
else if(N==9)then
x(1)=-12.64391111087668_p
w(1)=9.083968390869414e-1_p
x(2)=-11.17123147760151_p
w(2)=2.007339565467225_p
x(3)=-8.712969280423600_p
w(3)=2.855024526934060_p
x(4)=-5.592585894465482_p
w(4)=3.292249834185108_p
x(5)=-2.302014072979111_p
w(5)=2.881773797621434_p
x(6)=7.342978929232842e-1_p
w(6)=9.999409465425529e-1_p
x(7)=4.344519400715724_p
w(7)=5.479402267246379e-2_p
x(8)=9.423854278559185_p
w(8)=4.822202540054924e-4_p
x(9)=16.68757192900007_p
w(9)=5.075579530043265e-7_p
else if(N==10)then
x(1)=-12.69411382129529_p
w(1)=7.811365866380309e-1_p
x(2)=-11.422047886343_p
w(2)=1.741996814721283_p
x(3)=-9.269950647037113_p
w(3)=2.523483996220409_p
x(4)=-6.469140036639438_p
w(4)=3.016139024168623_p
x(5)=-3.369277192463749_p
w(5)=2.990278774281343_p
x(6)=-4.192697830214518e-1_p
w(6)=1.707094468736428_p
x(7)=2.621498068480719_p
w(7)=2.339211209176700e-1_p
x(8)=6.671035097048421_p
w(8)=5.915751733534003e-3_p
x(9)=12.06577347471463_p
w(9)=3.568989659300264e-5_p
x(10)=19.38502710392729_p
w(10)=3.300782920383286e-8_p
else if(N==11)then
x(1)=-12.73433535483566_p
w(1)=6.789618698219182e-1_p
x(2)=-11.6248565094435_p
w(2)=1.524743471471292_p
x(3)=-9.728629788555851_p
w(3)=2.239352509217182_p
x(4)=-7.215106932347287_p
w(4)=2.744040122802479_p
x(5)=-4.337441315831497_p
w(5)=2.909358696125920_p
x(6)=-1.459297987685302_p
w(6)=2.238121397390766_p
x(7)=1.288018085294188_p
w(7)=6.277742773915946e-1_p
x(8)=4.629362241395382_p
w(8)=3.703170916339157e-2_p
x(9)=8.981822653172932_p
w(9)=6.150777742185859e-4_p
x(10)=14.50068473497655_p
w(10)=3.125537516139173e-6_p
x(11)=21.46336340747316_p
w(11)=3.625465952729590e-9_p
else if(N==12)then
x(1)=-12.76717742558509_p
w(1)=5.953968120748401e-1_p
x(2)=-11.79163455786843_p
w(2)=1.344384261489695_p
x(3)=-10.11109544142796_p
w(3)=1.995496696096328_p
x(4)=-7.852215520265999_p
w(4)=2.490337006747284_p
x(5)=-5.202451950026250_p
w(5)=2.748466544735131_p
x(6)=-2.433957388422498_p
w(6)=2.494806649052286_p
x(7)=1.867899246251332e-1_p
w(7)=1.179069200108022_p
x(8)=3.037104339274308_p
w(8)=1.468343645913987e-1_p
x(9)=6.670642881850060_p
w(9)=5.140688002330270e-3_p
x(10)=11.17328136584593_p
w(10)=6.967968118291854e-5_p
x(11)=16.63013823391003_p
w(11)=3.570413221780828e-7_p
x(12)=22.89220756900103_p
w(12)=7.019228670346278e-10_p
else if(N==13)then
x(1)=-12.79433266735_p
w(1)=5.262130750258741e-1_p
x(2)=-11.93030168933649_p
w(2)=1.193320533968333_p
x(3)=-10.43253371607165_p
w(3)=1.786083434628413_p
x(4)=-8.397402687714175_p
w(4)=2.260187599548635_p
x(5)=-5.966647920009224_p
w(5)=2.561314973598080_p
x(6)=-3.342249587757634_p
w(6)=2.542438804234715_p
x(7)=-7.875743634032756e-1_p
w(7)=1.699618059742907_p
x(8)=1.758743111514790_p
w(8)=4.032728525639366e-1_p
x(9)=4.849649695532294_p
w(9)=2.682016692209144e-2_p
x(10)=8.657669013520893_p
w(10)=7.235088643570436e-4_p
x(11)=13.18453705805354_p
w(11)=9.195609151223335e-6_p
x(12)=18.41689235247287_p
w(12)=5.540039727877157e-8_p
x(13)=23.82062996192179_p
w(13)=2.148525534163538e-10_p
else if(N==14)then
x(1)=-12.81702415225507_p
w(1)=4.683426834252741e-1_p
x(2)=-12.0466879098766_p
w(2)=1.065793972031216_p
x(3)=-10.70462133260878_p
w(3)=1.605862626682302_p
x(4)=-8.865343861069015_p
w(4)=2.054280182125993_p
x(5)=-6.638006366299495_p
w(5)=2.372090773603983_p
x(6)=-4.174869864582995_p
w(6)=2.476617007450589_p
x(7)=-1.690750200554394_p
w(7)=2.042678671329516_p
x(8)=6.958670505212663e-1_p
w(8)=8.113356496498757e-1_p
x(9)=3.375599192567359_p
w(9)=9.829214788322641e-2_p
x(10)=6.657892244862772_p
w(10)=4.596289271739777e-3_p
x(11)=10.53534425070005_p
w(11)=1.107782367053121e-4_p
x(12)=14.9822234485208_p
w(12)=1.466877399315808e-6_p
x(13)=19.86874433294514_p
w(13)=1.166328416243042e-8_p
x(14)=24.42005711306683_p
w(14)=9.063986515598387e-11_p
else if(N==15)then
x(1)=-12.83616982289409_p
w(1)=4.194749216991449e-1_p
x(2)=-12.1452384012712_p
w(2)=9.573085312886758e-1_p
x(3)=-10.93658398158502_p
w(3)=1.450209997045292_p
x(4)=-9.268665928497541_p
w(4)=1.871248706782414_p
x(5)=-7.226890430497141_p
w(5)=2.191289712405944_p
x(6)=-4.928368564516529_p
w(6)=2.359900478056662_p
x(7)=-2.538477329300088_p
w(7)=2.193319745525302_p
x(8)=-2.318799230474626e-1_p
w(8)=1.267975055586124_p
x(9)=2.159983105606588_p
w(9)=2.679285306226226e-1_p
x(10)=5.021222607054908_p
w(10)=2.051520175717644e-2_p
x(11)=8.405336053814775_p
w(11)=8.119079644190199e-4_p
x(12)=12.27041786074374_p
w(12)=1.918092827378457e-5_p
x(13)=16.55390074427823_p
w(13)=2.873735355984394e-7_p
x(14)=21.0224084112275_p
w(14)=3.238787880102116e-9_p
x(15)=24.81536941096793_p
w(15)=4.736950835065234e-11_p
else if(N==16)then
x(1)=-12.85246753117565_p
w(1)=3.778482231204268e-1_p
x(2)=-12.22937454613492_p
w(2)=8.643407446427956e-1_p
x(3)=-11.13571634615781_p
w(3)=1.315192279135837_p
x(4)=-9.617954187717441_p
w(4)=1.708938438003985_p
x(5)=-7.743857349270264_p
w(5)=2.023129751593733_p
x(6)=-5.605190965184690_p
w(6)=2.224443499508407_p
x(7)=-3.328676032744069_p
w(7)=2.211354110068508_p
x(8)=-1.079779631027630_p
w(8)=1.639728046742931_p
x(9)=1.135497376329141_p
w(9)=5.613658090603756e-1_p
x(10)=3.657273392706756_p
w(10)=6.933225010731678e-2_p
x(11)=6.644048328435924_p
w(11)=4.170354047420974e-3_p
x(12)=10.05683641817872_p
w(12)=1.548482475410220e-4_p
x(13)=13.84502171457369_p
w(13)=3.835773994045766e-6_p
x(14)=17.90392113754642_p
w(14)=6.910193036997361e-8_p
x(15)=21.9278695282946_p
w(15)=1.137972682332808e-9_p
x(16)=25.08443539208098_p
w(16)=2.856907722725954e-11_p
else if(N==17)then
x(1)=-12.86645332370777_p
w(1)=3.421064768896667e-1_p
x(2)=-12.30175021777022_p
w(2)=7.841192732206170e-1_p
x(3)=-11.30779523655205_p
w(3)=1.197529436293072_p
x(4)=-9.921950695005656_p
w(4)=1.565013779161030_p
x(5)=-8.198663193676506_p
w(5)=1.868886579858233_p
x(6)=-6.210996622905714_p
w(6)=2.085635281576605_p
x(7)=-4.057395822334723_p
w(7)=2.157066335520094_p
x(8)=-1.874117365907161_p
w(8)=1.862910946824597_p
x(9)=2.436404220886322e-1_p
w(9)=9.351301716942304e-1_p
x(10)=2.505956232523213_p
w(10)=1.843760534688146e-1_p
x(11)=5.160452946376857_p
w(11)=1.631442229265192e-2_p
x(12)=8.206018948507376_p
w(12)=8.798941881765422e-4_p
x(13)=11.59184210866154_p
w(13)=3.269507228362568e-5_p
x(14)=15.2532257877831_p
w(14)=8.936139814874737e-7_p
x(15)=19.04858517030138_p
w(15)=2.014447728254958e-8_p
x(16)=22.6358958932201_p
w(16)=4.842040416217612e-10_p
x(17)=25.27371117698249_p
w(17)=1.900850922700325e-11_p
else
call GD(-13)
end if
end subroutine GF_m13

! [-12kT;26kT]
subroutine GF_m12(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-9.200741236514975_p
w(1)=6.602046580639726_p
x(2)=-1.780566059226120_p
w(2)=5.397959563548643_p
else if(N==3)then
x(1)=-10.38632283714098_p
w(1)=3.970896338868636_p
x(2)=-4.914383661808235_p
w(2)=6.097468864434546_p
x(3)=4.416798527095964e-1_p
w(3)=1.931640940885186_p
else if(N==4)then
x(1)=-10.92564513229029_p
w(1)=2.688038603310654_p
x(2)=-6.926375924494228_p
w(2)=4.948532805670029_p
x(3)=-1.949879925613136_p
w(3)=3.966938985435191_p
x(4)=2.582280528952809_p
w(4)=3.964957497724948e-1_p
else if(N==5)then
x(1)=-11.21775243324578_p
w(1)=1.973400190299185_p
x(2)=-8.171330730284067_p
w(2)=3.937122057728874_p
x(3)=-3.836151516302913_p
w(3)=4.326412692778263_p
x(4)=2.000922386642696e-1_p
w(4)=1.722895508774863_p
x(5)=5.115830158230694_p
w(5)=4.017569460718436e-2_p
else if(N==6)then
x(1)=-11.3955367735678_p
w(1)=1.532101695813631_p
x(2)=-8.980663885236012_p
w(2)=3.193975751978279_p
x(3)=-5.292485365857031_p
w(3)=3.978834921354123_p
x(4)=-1.412632228521604_p
w(4)=2.891126914202041_p
x(5)=2.265494671290704_p
w(5)=4.013690423402888e-1_p
x(6)=7.977199838602909_p
w(6)=2.597818500005476e-3_p
else if(N==7)then
x(1)=-11.5130384347972_p
w(1)=1.237931319438683_p
x(2)=-9.536392914078327_p
w(2)=2.651212137149231_p
x(3)=-6.388941514666012_p
w(3)=3.522922260585410_p
x(4)=-2.766667620707291_p
w(4)=3.337444331455445_p
x(5)=5.788009905495283e-1_p
w(5)=1.201870878792163_p
x(6)=4.628351014338545_p
w(6)=4.849242477371346e-2_p
x(7)=11.0332235329248_p
w(7)=1.327919937235632e-4_p
else if(N==8)then
x(1)=-11.59580026653005_p
w(1)=1.029582883193924_p
x(2)=-9.937514241126639_p
w(2)=2.244781986351167_p
x(3)=-7.224682919960799_p
w(3)=3.102257688641671_p
x(4)=-3.920110648350779_p
w(4)=3.319874167320929_p
x(5)=-6.834735595227649e-1_p
w(5)=2.037405245382864_p
x(6)=2.601634325252852_p
w(6)=2.621185262179195e-1_p
x(7)=7.246172963223564_p
w(7)=3.979554831686813e-3_p
x(8)=14.17368510807487_p
w(8)=6.092248207470397e-6_p
else if(N==9)then
x(1)=-11.65738361288774_p
w(1)=8.739508932655164e-1_p
x(2)=-10.24108782480661_p
w(2)=1.929616432686993_p
x(3)=-7.880263807416368_p
w(3)=2.737965499891286_p
x(4)=-4.895263759826507_p
w(4)=3.125871490131471_p
x(5)=-1.776547859152094_p
w(5)=2.564555123926940_p
x(6)=1.173818748914098_p
w(6)=7.339772243826875e-1_p
x(7)=4.846250310176528_p
w(7)=3.378590840399896e-2_p
x(8)=9.957891132459535_p
w(8)=2.832719326403296e-4_p
x(9)=17.20849258732885_p
w(9)=2.995668346394616e-7_p
else if(N==10)then
x(1)=-11.70536293132863_p
w(1)=7.523536838061642e-1_p
x(2)=-10.48055648815156_p
w(2)=1.676662606767505_p
x(3)=-8.410730494520688_p
w(3)=2.424478864042454_p
x(4)=-5.724638906001592_p
w(4)=2.880204321948470_p
x(5)=-2.774302423468040_p
w(5)=2.755657226502121_p
x(6)=4.011208077845992e-2_p
w(6)=1.356127594503199_p
x(7)=3.103703199041318_p
w(7)=1.509834860143486e-1_p
x(8)=7.195364444363436_p
w(8)=3.517244858742338e-3_p
x(9)=12.58748880160964_p
w(9)=2.109500021228204e-5_p
x(10)=19.82789368721157_p
w(10)=2.074515178114196e-8_p
else if(N==11)then
x(1)=-11.74390513489503_p
w(1)=6.544628223482740e-1_p
x(2)=-10.67473966595155_p
w(2)=1.468898179819289_p
x(3)=-8.849058677865626_p
w(3)=2.154324206761812_p
x(4)=-6.434192623901461_p
w(4)=2.629244680543006_p
x(5)=-3.684765184523958_p
w(5)=2.733818530455867_p
x(6)=-9.540897353131079e-1_p
w(6)=1.902510477356309_p
x(7)=1.754858678169489_p
w(7)=4.339492157741592e-1_p
x(8)=5.142300626685885_p
w(8)=2.243152819447746e-2_p
x(9)=9.502168108448599_p
w(9)=3.645936127109843e-4_p
x(10)=14.98351878365719_p
w(10)=1.906820726144542e-6_p
x(11)=21.79444610123511_p
w(11)=2.501737005339433e-9_p
else if(N==12)then
x(1)=-11.77541665479932_p
w(1)=5.742955759526346e-1_p
x(2)=-10.83465324007932_p
w(2)=1.296130377001181_p
x(3)=-9.215220087768950_p
w(3)=1.921736844774702_p
x(4)=-7.042044383928893_p
w(4)=2.391493128565964_p
x(5)=-4.502974483636463_p
w(5)=2.609895372651708_p
x(6)=-1.872050933531393_p
w(6)=2.229433929012403_p
x(7)=6.567104402457271e-1_p
w(7)=8.820459300255927e-1_p
x(8)=3.536892298456063_p
w(8)=9.187454445512129e-2_p
x(9)=7.190086940579356_p
w(9)=3.058247461666521e-3_p
x(10)=11.67211370869716_p
w(10)=4.196538546021930e-5_p
x(11)=17.05801312004962_p
w(11)=2.283727089128066e-7_p
x(12)=23.12130627484484_p
w(12)=5.292264164308821e-10_p
else if(N==13)then
x(1)=-11.80149401887219_p
w(1)=5.078666142400116e-1_p
x(2)=-10.96774104365997_p
w(2)=1.151260863369093_p
x(3)=-9.523340232927287_p
w(3)=1.721578044097264_p
x(4)=-7.563269535078760_p
w(4)=2.173986299529456_p
x(5)=-5.229037223339867_p
w(5)=2.446596515063849_p
x(6)=-2.726120316757718_p
w(6)=2.345256579513477_p
x(7)=-2.907129315812544e-1_p
w(7)=1.370854470598634_p
x(8)=2.246324539442628_p
w(8)=2.660720349312453e-1_p
x(9)=5.366550752759653_p
w(9)=1.609678106306292e-2_p
x(10)=9.166910080612743_p
w(10)=4.322081703254035e-4_p
x(11)=13.65003844066609_p
w(11)=5.696026687379064e-6_p
x(12)=18.78320944894554_p
w(12)=3.741196513976334e-8_p
x(13)=23.97588991589643_p
w(13)=1.732984276627772e-10_p
else if(N==14)then
x(1)=-11.82330154356935_p
w(1)=4.522568056259511e-1_p
x(2)=-11.07953989428606_p
w(2)=1.028842714193679_p
x(3)=-9.784434080008431_p
w(3)=1.549033288901287_p
x(4)=-8.011376594254275_p
w(4)=1.978379806654354_p
x(5)=-5.869005750040635_p
w(5)=2.273991740038559_p
x(6)=-3.512091042441516_p
w(6)=2.326855107441176_p
x(7)=-1.150529305197838_p
w(7)=1.753237402835326_p
x(8)=1.180383767771035_p
w(8)=5.743864135646874e-1_p
x(9)=3.886798437863008_p
w(9)=6.021966846692176e-2_p
x(10)=7.173964463756654_p
w(10)=2.734950030898879e-3_p
x(11)=11.02319665911717_p
w(11)=6.729622841300353e-5_p
x(12)=15.40691007812672_p
w(12)=9.418139183035337e-7_p
x(13)=20.174470247071_p
w(13)=8.316567860300986e-9_p
x(14)=24.5267506601655_p
w(14)=7.662938845511434e-11_p
else if(N==15)then
x(1)=-11.84171469116349_p
w(1)=4.052632801996589e-1_p
x(2)=-11.17428110478935_p
w(2)=9.246095061396039e-1_p
x(3)=-10.0072383139227_p
w(3)=1.399802035294013_p
x(4)=-8.398132252746832_p
w(4)=1.803892776742590_p
x(5)=-6.431762248379812_p
w(5)=2.105627679949508_p
x(6)=-4.226651478218353_p
w(6)=2.240412509749016_p
x(7)=-1.950396160479763_p
w(7)=1.968468302808574_p
x(8)=2.663508243617128e-1_p
w(8)=9.685259992182068e-1_p
x(9)=2.663512441164682_p
w(9)=1.706709061038566e-1_p
x(10)=5.540534991496776_p
w(10)=1.223416094936606e-2_p
x(11)=8.908505215403586_p
w(11)=4.868466694298020e-4_p
x(12)=12.72932542350207_p
w(12)=1.194588716992655e-5_p
x(13)=16.93422106464972_p
w(13)=1.920085906962049e-7_p
x(14)=21.27358328260971_p
w(14)=2.427430267001986e-9_p
x(15)=24.89080576655787_p
w(15)=4.135574088002047e-11_p
else if(N==16)then
x(1)=-11.85739932083846_p
w(1)=3.652058339537460e-1_p
x(2)=-11.25522382113341_p
w(2)=8.352134797322316e-1_p
x(3)=-10.19867271033629_p
w(3)=1.270201132224892_p
x(4)=-8.733462270447877_p
w(4)=1.648764117940008_p
x(5)=-6.926752499383768_p
w(5)=1.947276573332080_p
x(6)=-4.870970717553146_p
w(6)=2.124737521552764_p
x(7)=-2.696017889405150_p
w(7)=2.042093688246784_p
x(8)=-5.513803091528496e-1_p
w(8)=1.342919144461090_p
x(9)=1.634590921159818_p
w(9)=3.791571409795457e-1_p
x(10)=4.176002987183892_p
w(10)=4.185958788876831e-2_p
x(11)=7.157906397819666_p
w(11)=2.480973046006014e-3_p
x(12)=10.53916105033685_p
w(12)=9.444031751139138e-5_p
x(13)=14.27032472384797_p
w(13)=2.461513995089155e-6_p
x(14)=18.2396998966439_p
w(14)=4.808311249689580e-8_p
x(15)=22.13284072104176_p
w(15)=8.903320449757977e-10_p
x(16)=25.13949021850682_p
w(16)=2.550355178733437e-11_p
else if(N==17)then
x(1)=-11.8708672258155_p
w(1)=3.307901191915900e-1_p
x(2)=-11.32489824209915_p
w(2)=7.580181357957431e-1_p
x(3)=-10.3642258877958_p
w(3)=1.157144351887483_p
x(4)=-9.025600572872028_p
w(4)=1.510939420073601_p
x(5)=-7.362898251639105_p
w(5)=1.801050418054883_p
x(6)=-5.449398214280929_p
w(6)=1.999690059190739_p
x(7)=-3.386010486576704_p
w(7)=2.026389887709080_p
x(8)=-1.306422688724062_p
w(8)=1.613253899332250_p
x(9)=7.484970319381014e-1_p
w(9)=6.780418325589993e-1_p
x(10)=3.021083214961913_p
w(10)=1.144524217434773e-1_p
x(11)=5.681061899860268_p
w(11)=9.685951797704616e-3_p
x(12)=8.705507598916034_p
w(12)=5.286408233054727e-4_p
x(13)=12.04814286964038_p
w(13)=2.039863343738848e-5_p
x(14)=15.64270689351461_p
w(14)=5.924124014344676e-7_p
x(15)=19.34213610854854_p
w(15)=1.457384790569972e-8_p
x(16)=22.80319868830187_p
w(16)=3.925866251881361e-10_p
x(17)=25.31511802765374_p
w(17)=1.723927586951533e-11_p
else
call GD(-12)
end if
end subroutine GF_m12

! [-11kT;26kT]
subroutine GF_m11(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-8.395770708060661_p
w(1)=6.137601895979538_p
x(2)=-1.506528839886567_p
w(2)=4.862414805576671_p
else if(N==3)then
x(1)=-9.486303282498051_p
w(1)=3.723465676688670_p
x(2)=-4.368235967001851_p
w(2)=5.649032157497190_p
x(3)=7.022737437884892e-1_p
w(3)=1.627518867370348_p
else if(N==4)then
x(1)=-9.985591301009977_p
w(1)=2.537363646050121_p
x(2)=-6.216212355350489_p
w(2)=4.648374042427514_p
x(3)=-1.556990054350486_p
w(3)=3.520556413015432_p
x(4)=2.923035118477328_p
w(4)=2.937226000631421e-1_p
else if(N==5)then
x(1)=-10.25753975984815_p
w(1)=1.872619828906422_p
x(2)=-7.369781660665438_p
w(2)=3.725316605937917_p
x(3)=-3.284929422973644_p
w(3)=3.990371470178815_p
x(4)=5.551476983021429e-1_p
w(4)=1.385188951280333_p
x(5)=5.546042677572048_p
w(5)=2.651984525272308e-2_p
else if(N==6)then
x(1)=-10.42386669861411_p
w(1)=1.460029376273979_p
x(2)=-8.124494304803507_p
w(2)=3.037511056436530_p
x(3)=-4.627077833620961_p
w(3)=3.738508020732934_p
x(4)=-9.756085515887399e-1_p
w(4)=2.482955242951051_p
x(5)=2.681892741865447_p
w(5)=2.794169672358119e-1_p
x(6)=8.471068400775843_p
w(6)=1.596037925903339e-3_p
else if(N==7)then
x(1)=-10.53428931470341_p
w(1)=1.183724075092434_p
x(2)=-8.645464678402696_p
w(2)=2.531108464618722_p
x(3)=-5.646705205012337_p
w(3)=3.340345774422437_p
x(4)=-2.226015191822717_p
w(4)=3.009664170900886_p
x(5)=9.978963110463018e-1_p
w(5)=9.048858691741580e-1_p
x(6)=5.119319195240966_p
w(6)=3.021046922750810e-2_p
x(7)=11.57043436874118_p
w(7)=7.787812006389787e-5_p
else if(N==8)then
x(1)=-10.61244070014408_p
w(1)=9.870641385763178e-1_p
x(2)=-9.023515883869459_p
w(2)=2.149340571043949_p
x(3)=-6.429960671901603_p
w(3)=2.957071352415264_p
x(4)=-3.292169283905491_p
w(4)=3.081019373548535_p
x(5)=-2.249519507675737e-1_p
w(5)=1.652638544322800_p
x(6)=3.078964877674438_p
w(6)=1.705375390439514e-1_p
x(7)=7.783107403400364_p
w(7)=2.341687768763700e-3_p
x(8)=14.72950233740623_p
w(8)=3.494836628732105e-6_p
else if(N==9)then
x(1)=-10.6709124098488_p
w(1)=8.393454580800722e-1_p
x(2)=-9.311316700628600_p
w(2)=1.851293957017906_p
x(3)=-7.048949333812129_p
w(3)=2.618502012943423_p
x(4)=-4.202518782660019_p
w(4)=2.945158816259382_p
x(5)=-1.254859407858413_p
w(5)=2.212679599823542_p
x(6)=1.639067127654183_p
w(6)=5.126423017519368e-1_p
x(7)=5.372908387324973_p
w(7)=2.023090213585925e-2_p
x(8)=10.50836280348674_p
w(8)=1.634780417927280e-4_p
x(9)=17.73441868647836_p
w(9)=1.755022958959579e-7_p
else if(N==10)then
x(1)=-10.71667710721647_p
w(1)=7.233925640364239e-1_p
x(2)=-9.539458649531136_p
w(2)=1.610762537499156_p
x(3)=-7.552785697125969_p
w(3)=2.323709514419261_p
x(4)=-4.983846441107284_p
w(4)=2.735822201152663_p
x(5)=-2.186595503723125_p
w(5)=2.484655121201556_p
x(6)=5.131738983068096e-1_p
w(6)=1.025855861029430_p
x(7)=3.613261871401061_p
w(7)=9.375632079918640e-2_p
x(8)=7.737449930723610_p
w(8)=2.050234936707287e-3_p
x(9)=13.11846178051352_p
w(9)=1.233339775667342e-5_p
x(10)=20.26310319988178_p
w(10)=1.308406813784987e-8_p
else if(N==11)then
x(1)=-10.75353391067732_p
w(1)=6.298035513326995e-1_p
x(2)=-9.724969755073738_p
w(2)=1.412573967394329_p
x(3)=-7.970551569481263_p
w(3)=2.067985170933352_p
x(4)=-5.656151376706684_p
w(4)=2.509272368349908_p
x(5)=-3.038933903607661_p
w(5)=2.532495180582469_p
x(6)=-4.473602947247358e-1_p
w(6)=1.548880643821352_p
x(7)=2.248374346871214_p
w(7)=2.855355076965759e-1_p
x(8)=5.675843587166209_p
w(8)=1.325599284809166e-2_p
x(9)=10.03467496449441_p
w(9)=2.131595567919918e-4_p
x(10)=15.46952756196845_p
w(10)=1.157299481424329e-6_p
x(11)=22.112562945867_p
w(11)=1.741159063793954e-9_p
else if(N==12)then
x(1)=-10.78370613251777_p
w(1)=5.530582518523003e-1_p
x(2)=-9.877963346980630_p
w(2)=1.247482476077329_p
x(3)=-8.320211876488477_p
w(3)=1.846983271472306_p
x(4)=-6.234097182121355_p
w(4)=2.289299528679747_p
x(5)=-3.808976217511165_p
w(5)=2.455246091837192_p
x(6)=-1.315583298932595_p
w(6)=1.925826574823662_p
x(7)=1.146199912054694_p
w(7)=6.247181681398510e-1_p
x(8)=4.060707113906227_p
w(8)=5.558842506979451e-2_p
x(9)=7.724421790079267_p
w(9)=1.788725406017799e-3_p
x(10)=12.17856342429396_p
w(10)=2.504185890554352e-5_p
x(11)=17.48456983286128_p
w(11)=1.459368118846899e-7_p
x(12)=23.33877783836007_p
w(12)=4.022926647384442e-10_p
else if(N==13)then
x(1)=-10.80869825278038_p
w(1)=4.894042236870525e-1_p
x(2)=-10.00542645264392_p
w(2)=1.108873728511490_p
x(3)=-8.614862014001407_p
w(3)=1.656297051648420_p
x(4)=-6.730894671947111_p
w(4)=2.085493544587702_p
x(5)=-4.495661791518150_p
w(5)=2.322029510865626_p
x(6)=-2.117337371584943_p
w(6)=2.112025130328108_p
x(7)=2.146276852747948e-1_p
w(7)=1.048436498317203_p
x(8)=2.759624481902774_p
w(8)=1.677441274975709e-1_p
x(9)=5.901313547520498_p
w(9)=9.454281251885469e-3_p
x(10)=9.686667264563994_p
w(10)=2.550705926129102e-4_p
x(11)=14.11937578919973_p
w(11)=3.508817438292741e-6_p
x(12)=19.14538025570232_p
w(12)=2.531048320487351e-8_p
x(13)=24.12275161974469_p
w(13)=1.406163710996413e-10_p
else if(N==14)then
x(1)=-10.82961596127371_p
w(1)=4.360709854818402e-1_p
x(2)=-10.11260236029693_p
w(2)=9.916150849331257e-1_p
x(3)=-8.864846710010935_p
w(3)=1.491582213234915_p
x(4)=-7.158831940972403_p
w(4)=1.900832582383949_p
x(5)=-5.103297581820850_p
w(5)=2.169693348640073_p
x(6)=-2.856113504157167_p
w(6)=2.151113350644522_p
x(7)=-6.113027681907230e-1_p
w(7)=1.436986214441436_p
x(8)=1.687501581281729_p
w(8)=3.846476216051085e-1_p
x(9)=4.419146249337897_p
w(9)=3.583119004242395e-2_p
x(10)=7.703063076608036_p
w(10)=1.602966039990299e-3_p
x(11)=11.51800859920697_p
w(11)=4.053497821365926e-5_p
x(12)=15.83244697113904_p
w(12)=6.031163412364066e-7_p
x(13)=20.47475868249022_p
w(13)=5.949234922191468e-9_p
x(14)=24.62780191101129_p
w(14)=6.503585707733908e-11_p
else if(N==15)then
x(1)=-10.84729181800242_p
w(1)=3.909646783953214e-1_p
x(2)=-10.20350571652483_p
w(2)=8.916743448866331e-1_p
x(3)=-9.078402496810288_p
w(3)=1.348884969075118_p
x(4)=-7.528771857199222_p
w(4)=1.735303859866209_p
x(5)=-5.639238201205703_p
w(5)=2.015892891880740_p
x(6)=-3.530548678589439_p
w(6)=2.103940342743811_p
x(7)=-1.368241770093958_p
w(7)=1.704382844765445_p
x(8)=7.789435496687518e-1_p
w(8)=6.971150292535082e-1_p
x(9)=3.190747205416474_p
w(9)=1.044041149091902e-1_p
x(10)=6.075531103051879_p
w(10)=7.157360680033292e-3_p
x(11)=9.421027649983621_p
w(11)=2.887366791489476e-4_p
x(12)=13.1922883288871_p
w(12)=7.398332308518852e-6_p
x(13)=17.31325631504848_p
w(13)=1.282267226804123e-7_p
x(14)=21.51915505218333_p
w(14)=1.825829646951368e-9_p
x(15)=24.96248992554073_p
w(15)=3.619064081727034e-11_p
else if(N==16)then
x(1)=-10.86235940012779_p
w(1)=3.524872599567206e-1_p
x(2)=-10.28123152976529_p
w(2)=8.058825182169121e-1_p
x(3)=-9.262066917873279_p
w(3)=1.224786035924476_p
x(4)=-7.849953022499032_p
w(4)=1.587635570454137_p
x(5)=-6.111746971187539_p
w(5)=1.868624379671278_p
x(6)=-4.141236294583089_p
w(6)=2.014144232226025_p
x(7)=-2.070532530652365_p
w(7)=1.837822052871860_p
x(8)=-1.835348100864237e-2_p
w(8)=1.039566366676318_p
x(9)=2.156941541686472_p
w(9)=2.429197026746603e-1_p
x(10)=4.713387867061717_p
w(10)=2.463386461122958e-2_p
x(11)=7.683329074207629_p
w(11)=1.455967087237592e-3_p
x(12)=11.02791897270971_p
w(12)=5.714259334371653e-5_p
x(13)=14.69739315873635_p
w(13)=1.574383426885573e-6_p
x(14)=18.57285507911278_p
w(14)=3.348688640156306e-8_p
x(15)=22.33267269688941_p
w(15)=6.989003718957803e-10_p
x(16)=25.19201055856584_p
w(16)=2.279748427986277e-11_p
else if(N==17)then
x(1)=-10.87530607043939_p
w(1)=3.194066396026182e-1_p
x(2)=-10.34818513566775_p
w(2)=7.317398891909469e-1_p
x(3)=-9.421035768390466_p
w(3)=1.116401356750935_p
x(4)=-8.130083972684778_p
w(4)=1.456106499940319_p
x(5)=-6.528855893385475_p
w(5)=1.731208295379878_p
x(6)=-4.691379892145316_p
w(6)=1.906655501715757_p
x(7)=-2.721278752711946_p
w(7)=1.869995822116072_p
x(8)=-7.413336404182490e-1_p
w(8)=1.331588829614441_p
x(9)=1.271587149191648_p
w(9)=4.623677423396281e-1_p
x(10)=3.557630119266645_p
w(10)=6.856586021980686e-2_p
x(11)=6.215588278985093_p
w(11)=5.652783445481185e-3_p
x(12)=9.213449265452478_p
w(12)=3.144218057071965e-4_p
x(13)=12.50852961032396_p
w(13)=1.265643280260228e-5_p
x(14)=16.03224314374171_p
w(14)=3.921060102947791e-7_p
x(15)=19.63237318571624_p
w(15)=1.056095907926425e-8_p
x(16)=22.96607344254823_p
w(16)=3.192010122079218e-10_p
x(17)=25.35476990384619_p
w(17)=1.564516695282007e-11_p
else
call GD(-11)
end if
end subroutine GF_m11

! [-10kT;26kT]
subroutine GF_m10(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-7.589291605493806_p
w(1)=5.675311881498350_p
x(2)=-1.221802101708121_p
w(2)=4.324733517395758_p
else if(N==3)then
x(1)=-8.585496571449392_p
w(1)=3.477526127748062_p
x(2)=-3.820530714952788_p
w(2)=5.186811686862900_p
x(3)=9.860666384199275e-1_p
w(3)=1.335707584283147_p
else if(N==4)then
x(1)=-9.045154919724661_p
w(1)=2.387438174119421_p
x(2)=-5.505464859853777_p
w(2)=4.342786005408994_p
x(3)=-1.157817920023470_p
w(3)=3.060089982823330_p
x(4)=3.295959159521174_p
w(4)=2.097312365423635e-1_p
else if(N==5)then
x(1)=-9.297155196096561_p
w(1)=1.772154396940439_p
x(2)=-6.568052345209625_p
w(2)=3.511171836072347_p
x(3)=-2.735550500407642_p
w(3)=3.627024370559143_p
x(4)=9.341397122813052e-1_p
w(4)=1.072745916600897_p
x(5)=6.006492943642262_p
w(5)=1.694887872128226e-2_p
else if(N==6)then
x(1)=-9.452137580800008_p
w(1)=1.388029883026876_p
x(2)=-7.268419815135316_p
w(2)=2.879662094493063_p
x(3)=-3.964272177768116_p
w(3)=3.481172805155571_p
x(4)=-5.314677146448871e-1_p
w(4)=2.063918442448650_p
x(5)=3.132025063553249_p
w(5)=1.863082074915567e-1_p
x(6)=8.991583382724663_p
w(6)=9.539662783903993e-4_p
else if(N==7)then
x(1)=-9.555548902354284_p
w(1)=1.129440896379241_p
x(2)=-7.754828441032759_p
w(2)=2.409941821236063_p
x(3)=-4.906767198993509_p
w(3)=3.148309936575500_p
x(4)=-1.688744232135601_p
w(4)=2.645221963781893_p
x(5)=1.444702485274090_p
w(5)=6.488767959747649e-1_p
x(6)=5.639950928828767_p
w(6)=1.820937682976692e-2_p
x(7)=12.13061951733297_p
w(7)=4.460811687854954e-5_p
else if(N==8)then
x(1)=-9.629138162886241_p
w(1)=9.443605901346048e-1_p
x(2)=-8.109972745120912_p
w(2)=2.052928409582003_p
x(3)=-5.637355407183171_p
w(3)=2.806152100682297_p
x(4)=-2.670404144590501_p
w(4)=2.809323776633352_p
x(5)=2.466679563479516e-1_p
w(5)=1.279645463204668_p
x(6)=3.588525399936020_p
w(6)=1.062888621994392e-1_p
x(7)=8.343339734599184_p
w(7)=1.344225591621819e-3_p
x(8)=15.30123446083574_p
w(8)=1.970866122522064e-6_p
else if(N==9)then
x(1)=-9.684525711951439_p
w(1)=8.044944356439419e-1_p
x(2)=-8.382090650037659_p
w(2)=1.772055611224713_p
x(3)=-6.219607596427295_p
w(3)=2.495202795894676_p
x(4)=-3.515687165169659_p
w(4)=2.742708612436461_p
x(5)=-7.333861763705433e-1_p
w(5)=1.833984525867381_p
x(6)=2.134126625524253_p
w(6)=3.397308973472779e-1_p
x(7)=5.924203642507075_p
w(7)=1.177569459460516e-2_p
x(8)=11.07475352706238_p
w(8)=9.272364632332038e-5_p
x(9)=18.26309831539515_p
w(9)=1.022387290214603e-7_p
else if(N==10)then
x(1)=-9.728077739594090_p
w(1)=6.941871722138876e-1_p
x(2)=-8.598884158402578_p
w(2)=1.544063065058436_p
x(3)=-6.696544656412455_p
w(3)=2.220238126069105_p
x(4)=-4.247898971911062_p
w(4)=2.578036518173335_p
x(5)=-1.605484052514614_p
w(5)=2.172267561797619_p
x(6)=1.006511272103880_p
w(6)=7.339542440071312e-1_p
x(7)=4.150216573559107_p
w(7)=5.611930810041352e-2_p
x(8)=8.296887787666988_p
w(8)=1.172257623805616e-3_p
x(9)=13.65784595222746_p
w(9)=7.137555081744180e-6_p
x(10)=20.68851250332308_p
w(10)=8.295292760574353e-9_p
else if(N==11)then
x(1)=-9.763238438219711_p
w(1)=6.049317888509567e-1_p
x(2)=-8.775647555001440_p
w(2)=1.355592554228428_p
x(3)=-7.093433362816906_p
w(3)=1.979690973960812_p
x(4)=-4.881872622059672_p
w(4)=2.380958000800998_p
x(5)=-2.400783237604258_p
w(5)=2.295897142820682_p
x(6)=6.703254925487324e-2_p
w(6)=1.196229789143405_p
x(7)=2.770629100687347_p
w(7)=1.789703168817742e-1_p
x(8)=6.229479047570070_p
w(8)=7.651164133119503e-3_p
x(9)=10.57888086999222_p
w(9)=1.229675703983857e-4_p
x(10)=15.95779593290223_p
w(10)=6.992804751122914e-7_p
x(11)=22.41689821282673_p
w(11)=1.223058981883584e-9_p
else if(N==12)then
x(1)=-9.792059792707688_p
w(1)=5.316412698067140e-1_p
x(2)=-8.921647537124134_p
w(2)=1.198298042522614_p
x(3)=-7.426329242756390_p
w(3)=1.770770492631745_p
x(4)=-5.429069052350997_p
w(4)=2.181707469088443_p
x(5)=-3.121699660865820_p
w(5)=2.276199422803651_p
x(6)=-7.611966652907776e-1_p
w(6)=1.590278971639661_p
x(7)=1.660460141656448_p
w(7)=4.175043136536237e-1_p
x(8)=4.608045377151033_p
w(8)=3.260138754443795e-2_p
x(9)=8.273205032987331_p
w(9)=1.029123222336514e-3_p
x(10)=12.69207978932817_p
w(10)=1.481243917682119e-5_p
x(11)=17.90897251370849_p
w(11)=9.323339499366840e-8_p
x(12)=23.54464639217169_p
w(12)=3.083101121254098e-10_p
else if(N==13)then
x(1)=-9.815957251966577_p
w(1)=4.707887329081945e-1_p
x(2)=-9.043427464088104_p
w(2)=1.066042127802525_p
x(3)=-7.707310289113832_p
w(3)=1.589890802193507_p
x(4)=-5.900827813636083_p
w(4)=1.993339088439319_p
x(5)=-3.767705897591087_p
w(5)=2.181653866721690_p
x(6)=-1.515205379521983_p
w(6)=1.836991582221781_p
x(7)=7.353087966630343e-1_p
w(7)=7.544050291393211e-1_p
x(8)=3.299219519326419_p
w(8)=1.013427151882006e-1_p
x(9)=6.453320756740381_p
w(9)=5.440513588685814e-3_p
x(10)=10.2164924949316_p
w(10)=1.487728350700460e-4_p
x(11)=14.59195475790706_p
w(11)=2.150577694116521e-6_p
x(12)=19.50276652782601_p
w(12)=1.716336544537012e-8_p
x(13)=24.26145775492011_p
w(13)=1.147542290343373e-10_p
else if(N==14)then
x(1)=-9.835977624824913_p
w(1)=4.197532219164080e-1_p
x(2)=-9.145934444404309_p
w(2)=9.540135370507147e-1_p
x(3)=-7.946034502386840_p
w(3)=1.433238744451561_p
x(4)=-6.308150623207339_p
w(4)=1.820687605418594_p
x(5)=-4.341883345741304_p
w(5)=2.055168711969566_p
x(6)=-2.207660873408102_p
w(6)=1.939597838935071_p
x(7)=-6.738899495542434e-2_p
w(7)=1.112103710819383_p
x(8)=2.220444447786912_p
w(8)=2.437746245926246e-1_p
x(9)=4.971871921914755_p
w(9)=2.075684032617482e-2_p
x(10)=8.244694727054673_p
w(10)=9.259553687927990e-4_p
x(11)=12.01930787806022_p
w(11)=2.421833089793097e-5_p
x(12)=16.25826988764946_p
w(12)=3.853881625605157e-7_p
x(13)=20.76920570200985_p
w(13)=4.270760688990897e-9_p
x(14)=24.72343212561517_p
w(14)=5.539771816889315e-11_p
else if(N==15)then
x(1)=-9.852910043140577_p
w(1)=3.765513817687052e-1_p
x(2)=-9.232962906540706_p
w(2)=8.584207369990268e-1_p
x(3)=-8.150223698248414_p
w(3)=1.297244113652162_p
x(4)=-6.660943233627306_p
w(4)=1.664798179311541_p
x(5)=-4.850135153706185_p
w(5)=1.919376112650638_p
x(6)=-2.841247781655044_p
w(6)=1.941580603453663_p
x(7)=-7.890366092168414e-1_p
w(7)=1.405431863952041_p
x(8)=1.311886584190428_p
w(8)=4.707877238620767e-1_p
x(9)=3.741387447870848_p
w(9)=6.156795994455127e-2_p
x(10)=6.625542671895221_p
w(10)=4.112636744000906e-3_p
x(11)=9.942458313249800_p
w(11)=1.694414320078670e-4_p
x(12)=13.65883526160352_p
w(12)=4.558091766817324e-6_p
x(13)=17.69052846587693_p
w(13)=8.562176028168666e-8_p
x(14)=21.7589121141685_p
w(14)=1.378426906313608e-9_p
x(15)=25.0305791534798_p
w(15)=3.173928881262706e-11_p
else if(N==16)then
x(1)=-9.867355459996540_p
w(1)=3.396683084541109e-1_p
x(2)=-9.307441404676458_p
w(2)=7.762776662247579e-1_p
x(3)=-8.326023836960999_p
w(3)=1.178773176732004_p
x(4)=-6.967722197652988_p
w(4)=1.525045002741783_p
x(5)=-5.299503184900313_p
w(5)=1.785317970824903_p
x(6)=-3.417189927142120_p
w(6)=1.885934902125783_p
x(7)=-1.451564172362936_p
w(7)=1.592240914348045_p
x(8)=5.260351120606518e-1_p
w(8)=7.536177408174570e-1_p
x(9)=2.704063510914242_p
w(9)=1.481272095149037e-1_p
x(10)=5.268550732731232_p
w(10)=1.416377245128092e-2_p
x(11)=8.219804607994753_p
w(11)=8.433926113585362e-4_p
x(12)=11.522685245635_p
w(12)=3.431413603035419e-5_p
x(13)=15.12578820622491_p
w(13)=1.003992343925336e-6_p
x(14)=18.90301815167128_p
w(14)=2.334847285744977e-8_p
x(15)=22.52727864113427_p
w(15)=5.504702954795657e-10_p
x(16)=25.24210078880911_p
w(16)=2.040274263330568e-11_p
else if(N==17)then
x(1)=-9.879776587659066_p
w(1)=3.079348035032163e-1_p
x(2)=-9.371648904409177_p
w(2)=7.052241037056296e-1_p
x(3)=-8.478331829990463_p
w(3)=1.075157263932431_p
x(4)=-7.235648088223114_p
w(4)=1.400127066502479_p
x(5)=-5.697076507791235_p
w(5)=1.658056673707409_p
x(6)=-3.938005533758213_p
w(6)=1.801760745054343_p
x(7)=-2.063823083311959_p
w(7)=1.678010177647762_p
x(8)=-1.737197931189046e-1_p
w(8)=1.034055286052653_p
x(9)=1.817229587149403_p
w(9)=2.964770864437466e-1_p
x(10)=4.114842603120910_p
w(10)=3.980232315069909e-2_p
x(11)=6.763352342592787_p
w(11)=3.246577333571039e-3_p
x(12)=9.729409370217590_p
w(12)=1.852128180204801e-4_p
x(13)=12.97260051450096_p
w(13)=7.811910648802534e-6_p
x(14)=16.42145135562502_p
w(14)=2.591900598452030e-7_p
x(15)=19.91903347377289_p
w(15)=7.666977125741549e-9_p
x(16)=23.12450169315303_p
w(16)=2.602552107246896e-10_p
x(17)=25.39273528367908_p
w(17)=1.420618864725384e-11_p
else
call GD(-10)
end if
end subroutine GF_m10

! [-9kT;26kT]
subroutine GF_m9(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-6.781260853673272_p
w(1)=5.214314236098785_p
x(2)=-9.236268384339396e-1_p
w(2)=3.785809166085829_p
else if(N==3)then
x(1)=-7.683954173110864_p
w(1)=3.232601211327671_p
x(2)=-3.271349721029268_p
w(2)=4.705941073054968_p
x(3)=1.297723369610631_p
w(3)=1.061581117801976_p
else if(N==4)then
x(1)=-8.104404261416512_p
w(1)=2.237916806495939_p
x(2)=-4.794761524788465_p
w(2)=4.027698877227341_p
x(3)=-7.489908258662455e-1_p
w(3)=2.590641312087679_p
x(4)=3.704163769200790_p
w(4)=1.438664063736545e-1_p
else if(N==5)then
x(1)=-8.336663810431721_p
w(1)=1.671733747129785_p
x(2)=-5.766678348243076_p
w(2)=3.292390349713147_p
x(3)=-2.187862546985802_p
w(3)=3.230803616390858_p
x(4)=1.342648709973491_p
w(4)=7.947231274957991e-1_p
x(5)=6.498759866657518_p
w(5)=1.047256145502578e-2_p
else if(N==6)then
x(1)=-8.480407481482318_p
w(1)=1.315883538799916_p
x(2)=-6.412868207694703_p
w(2)=2.719020745689694_p
x(3)=-3.305183149254501_p
w(3)=3.198722608331638_p
x(4)=-7.470788177321654e-2_p
w(4)=1.647157981827040_p
x(5)=3.618184473182666_p
w(5)=1.187844156899804e-1_p
x(6)=9.539885845393918_p
w(6)=5.541118463447591e-4_p
else if(N==7)then
x(1)=-8.576869371344756_p
w(1)=1.074895668386019_p
x(2)=-6.864837596505809_p
w(2)=2.286752841208355_p
x(3)=-4.170319948138896_p
w(3)=2.940951979784726_p
x(4)=-1.152499377410611_p
w(4)=2.246055255270309_p
x(5)=1.924494749311073_p
w(5)=4.408251591918571e-1_p
x(6)=6.190862169104871_p
w(6)=1.061755732931826e-2_p
x(7)=12.71430811688226_p
w(7)=2.494101402966869e-5_p
else if(N==8)then
x(1)=-8.645939086106059_p
w(1)=9.013125681227450e-1_p
x(2)=-7.197181361527368_p
w(2)=1.954843879981849_p
x(3)=-4.847881121023046_p
w(3)=2.645678985678043_p
x(4)=-2.055144066945095_p
w(4)=2.496222047666638_p
x(5)=7.386058084682700e-1_p
w(5)=9.377936013696472e-1_p
x(6)=4.131012501069899_p
w(6)=6.351843873687336e-2_p
x(7)=8.926879484274970_p
w(7)=7.527872333738759e-4_p
x(8)=15.8878819710096_p
w(8)=1.093395444473122e-6_p
else if(N==9)then
x(1)=-8.698261171210255_p
w(1)=7.692686574744867e-1_p
x(2)=-7.453643810691369_p
w(2)=1.691382501485686_p
x(3)=-5.393026596126815_p
w(3)=2.365580209070514_p
x(4)=-2.836057512614122_p
w(4)=2.508561239115675_p
x(5)=-2.062872541172784e-1_p
w(5)=1.445162185529975_p
x(6)=2.661973606246343_p
w(6)=2.134482141879211e-1_p
x(7)=6.499766852778242_p
w(7)=6.668621687818224e-3_p
x(8)=11.65643521730979_p
w(8)=5.171429059434223e-5_p
x(9)=18.79195322160707_p
w(9)=5.934194430484587e-8_p
else if(N==10)then
x(1)=-8.739593707567025_p
w(1)=6.646366007501076e-1_p
x(2)=-7.659010814864575_p
w(2)=1.476178661302313_p
x(3)=-5.842598425688924_p
w(3)=2.112405651878641_p
x(4)=-3.518139921664038_p
w(4)=2.399133465738333_p
x(5)=-1.028322466819998_p
w(5)=1.820599826499263_p
x(6)=1.526432974467235_p
w(6)=4.940590609882882e-1_p
x(7)=4.714222359069479_p
w(7)=3.244829094026353e-2_p
x(8)=8.873253540778563_p
w(8)=6.577471464966705e-4_p
x(9)=14.20471798452205_p
w(9)=4.091645550509978e-6_p
x(10)=21.10204366893693_p
w(10)=5.295357653969274e-9_p
else if(N==11)then
x(1)=-8.773041819633702_p
w(1)=5.797657943749965e-1_p
x(2)=-7.826913516249294_p
w(2)=1.297656562134531_p
x(3)=-6.218160485794520_p
w(3)=1.888289465379636_p
x(4)=-4.112511084675216_p
w(4)=2.238964444302340_p
x(5)=-1.770173819172309_p
w(5)=2.015631817323913_p
x(6)=5.966711456963197e-1_p
w(6)=8.683208635855464e-1_p
x(7)=3.322560030687479_p
w(7)=1.071065142591164e-1_p
x(8)=6.802684172638440_p
w(8)=4.317495093409771e-3_p
x(9)=11.13428807673134_p
w(9)=7.002388490540865e-5_p
x(10)=16.44735797370135_p
w(10)=4.209786656074534e-7_p
x(11)=22.70681794899157_p
w(11)=8.675543538926854e-10_p
else if(N==12)then
x(1)=-8.800496969870288_p
w(1)=5.099759193793392e-1_p
x(2)=-7.965821544556198_p
w(2)=1.148339137443151_p
x(3)=-6.533937460397657_p
w(3)=1.692264504683637_p
x(4)=-4.627904618024330_p
w(4)=2.065099907805656_p
x(5)=-2.442156117914294_p
w(5)=2.062101503264996_p
x(6)=-2.030782214384150e-1_p
w(6)=1.240041248484880_p
x(7)=2.203399236317118_p
w(7)=2.631345986451306e-1_p
x(8)=5.178210832517632_p
w(8)=1.857511446023821e-2_p
x(9)=8.835985283316244_p
w(9)=5.827190649945513e-4_p
x(10)=13.2120727773991_p
w(10)=8.689126604250088e-6_p
x(11)=18.33036889234545_p
w(11)=5.958779031523364e-8_p
x(12)=23.7390315676653_p
w(12)=2.381968453944354e-10_p
else if(N==13)then
x(1)=-8.823287488548781_p
w(1)=4.519614245450120e-1_p
x(2)=-8.081841289858470_p
w(2)=1.022571317401249_p
x(3)=-6.800983512847071_p
w(3)=1.521734365763187_p
x(4)=-5.073832676051465_p
w(4)=1.895039086104007_p
x(5)=-3.046476073327872_p
w(5)=2.016468452485040_p
x(6)=-9.169428107851578e-1_p
w(6)=1.522421113079491_p
x(7)=1.278152542343816_p
w(7)=5.078847374187950e-1_p
x(8)=3.864876525864482_p
w(8)=5.888528829088315e-2_p
x(9)=7.021965419496330_p
w(9)=3.070498432842240e-3_p
x(10)=10.75591679215107_p
w(10)=8.579478860760107e-5_p
x(11)=15.06715305235648_p
w(11)=1.312109839256053e-6_p
x(12)=19.8547460151951_p
w(12)=1.167149888212654e-8_p
x(13)=24.39228063444834_p
w(13)=9.416303388976437e-11_p
else if(N==14)then
x(1)=-8.842400675829669_p
w(1)=4.032528989015877e-1_p
x(2)=-8.179618615425078_p
w(2)=9.158761613006178e-1_p
x(3)=-7.028244683657256_p
w(3)=1.373521059600974_p
x(4)=-5.459951699212056_p
w(4)=1.736195583290681_p
x(5)=-3.586008007768942_p
w(5)=1.923746049547395_p
x(6)=-1.566308498413986_p
w(6)=1.684344284501743_p
x(7)=4.886311155032491e-1_p
w(7)=8.042546008293024e-1_p
x(8)=2.780921612243524_p
w(8)=1.466585586797368e-1_p
x(9)=5.544129668682149_p
w(9)=1.173214736979842e-2_p
x(10)=8.798368846055313_p
w(10)=5.274507044951330e-4_p
x(11)=12.52660234390195_p
w(11)=1.435849264814371e-5_p
x(12)=16.6838035211731_p
w(12)=2.458408096440617e-7_p
x(13)=21.05743742666377_p
w(13)=3.077476824188066e-9_p
x(14)=24.81386798941148_p
w(14)=4.734833668644678e-11_p
else if(N==15)then
x(1)=-8.858581584249619_p
w(1)=3.619794372014958e-1_p
x(2)=-8.262723212090131_p
w(2)=8.247123084877991e-1_p
x(3)=-7.222909117791343_p
w(3)=1.244498897589337_p
x(4)=-5.795152647843886_p
w(4)=1.591108294427679_p
x(5)=-4.065531539813792_p
w(5)=1.811328458219561_p
x(6)=-2.159536779738507_p
w(6)=1.742479702894795_p
x(7)=-2.072513774600654e-1_p
w(7)=1.088340909448665_p
x(8)=1.869947608085803_p
w(8)=2.981148333555518e-1_p
x(9)=4.314641355066438_p
w(9)=3.513597314275133e-2_p
x(10)=7.189928424183583_p
w(10)=2.323305360308658e-3_p
x(11)=10.47234492793572_p
w(11)=9.842910169377930e-5_p
x(12)=14.12848188915303_p
w(12)=2.794695593596629e-6_p
x(13)=18.06556282437785_p
w(13)=5.718686093318781e-8_p
x(14)=21.99267162483031_p
w(14)=1.044631576549306e-9_p
x(15)=25.09522999422965_p
w(15)=2.789014258264024e-11_p
else if(N==16)then
x(1)=-8.872398121805075_p
w(1)=3.267105467523728e-1_p
x(2)=-8.333914243637894_p
w(2)=7.462827402158816e-1_p
x(3)=-7.390718969906714_p
w(3)=1.131855687038756_p
x(4)=-6.087188422528964_p
w(4)=1.460048276505780_p
x(5)=-4.490925138488643_p
w(5)=1.693987833706444_p
x(6)=-2.700045573019415_p
w(6)=1.730285693919993_p
x(7)=-8.363140620901760e-1_p
w(7)=1.307644786168376_p
x(8)=1.088851106521302_p
w(8)=5.084399182561721e-1_p
x(9)=3.276203882401790_p
w(9)=8.639173086464540e-2_p
x(10)=5.840608021345568_p
w(10)=7.972575034884967e-3_p
x(11)=8.766833913265025_p
w(11)=4.825007959736106e-4_p
x(12)=12.02302687453699_p
w(12)=2.045759279032807e-5_p
x(13)=15.55506634009719_p
w(13)=6.385766367693082e-7_p
x(14)=19.22983256532496_p
w(14)=1.630261087067183e-8_p
x(15)=22.71659338411464_p
w(15)=4.350186511597218e-10_p
x(16)=25.2898637682671_p
w(16)=1.827827682488196e-11_p
else if(N==17)then
x(1)=-8.884288066319867_p
w(1)=2.963407872051171e-1_p
x(2)=-8.395342326801181_p
w(2)=6.783707967651359e-1_p
x(3)=-7.536264151257098_p
w(3)=1.033160217840311_p
x(4)=-6.342643005668682_p
w(4)=1.342279606438429_p
x(5)=-4.868311600073067_p
w(5)=1.579173747265208_p
x(6)=-3.190529435974224_p
w(6)=1.677280394543946_p
x(7)=-1.412991750165891_p
w(7)=1.443031683696663_p
x(8)=4.035273385726075e-1_p
w(8)=7.466923530211559e-1_p
x(9)=2.388038502829913_p
w(9)=1.793731503234424e-1_p
x(10)=4.691704422740400_p
w(10)=2.247085895486385e-2_p
x(11)=7.323712077770003_p
w(11)=1.836734561807387e-3_p
x(12)=10.25295534243345_p
w(12)=1.080963764235799e-4_p
x(13)=13.43994896058388_p
w(13)=4.798232379910404e-6_p
x(14)=16.80995075909502_p
w(14)=1.711569591558026e-7_p
x(15)=20.20186926041325_p
w(15)=5.577093897090727e-9_p
x(16)=23.27847957868363_p
w(16)=2.127728711645113e-10_p
x(17)=25.42908149978659_p
w(17)=1.290486630077751e-11_p
else
call GD(-9)
end if
end subroutine GF_m9

! [-8kT;26kT]
subroutine GF_m8(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.971704485698226_p
w(1)=4.752846006707157_p
x(2)=-6.083138565106944e-1_p
w(2)=3.247489399660629_p
else if(N==3)then
x(1)=-6.781797024683915_p
w(1)=2.987695748573782_p
x(2)=-2.720431361993253_p
w(2)=4.201208061571785_p
x(3)=1.642725886854654_p
w(3)=8.114315962222201e-1_p
else if(N==4)then
x(1)=-7.163458927516236_p
w(1)=2.088128837469669_p
x(2)=-4.084908814255637_p
w(2)=3.696909488556062_p
x(3)=-3.256355984455839e-1_p
w(3)=2.120787149336320_p
x(4)=4.150701280683395_p
w(4)=9.450993100573568e-2_p
else if(N==5)then
x(1)=-7.376168921790527_p
w(1)=1.570862087675655_p
x(2)=-4.966423130270287_p
w(2)=3.065055876801688_p
x(3)=-1.640538470397635_p
w(3)=2.798940005703092_p
x(4)=1.786582449292725_p
w(4)=5.592305440123351e-1_p
x(5)=7.024481021983958_p
w(5)=6.246892175016307e-3_p
else if(N==6)then
x(1)=-7.508764151253581_p
w(1)=1.243202283823142_p
x(2)=-5.558460463836211_p
w(2)=2.553089606343028_p
x(3)=-2.650696569935519_p
w(3)=2.881189629386958_p
x(4)=4.018485960084156e-1_p
w(4)=1.250192376553902_p
x(5)=4.142228098724108_p
w(5)=7.234910190663434e-2_p
x(6)=10.11718816038817_p
w(6)=3.124083541235825e-4_p
else if(N==7)then
x(1)=-7.598326781153954_p
w(1)=1.019770134774058_p
x(2)=-5.976001529426795_p
w(2)=2.159826798044878_p
x(3)=-3.438754648674313_p
w(3)=2.709388522382779_p
x(4)=-6.125714175734367e-1_p
w(4)=1.822654889981325_p
x(5)=2.441810219276237_p
w(5)=2.826935589284253e-1_p
x(6)=6.772620724114992_p
w(6)=5.987897516186954e-3_p
x(7)=13.32193775897315_p
w(7)=1.360474013503429e-5_p
else if(N==8)then
x(1)=-7.662908710256776_p
w(1)=8.576554929021664e-1_p
x(2)=-6.285560001723253_p
w(2)=1.853843661015834_p
x(3)=-4.062841026623496_p
w(3)=2.469281978487476_p
x(4)=-1.445121566846326_p
w(4)=2.137398274315657_p
x(5)=1.258525403458359_p
w(5)=6.452969745608361e-1_p
x(6)=4.706639609716708_p
w(6)=3.644712832986152e-2_p
x(7)=9.533645409036570_p
w(7)=4.112994014899539e-4_p
x(8)=16.48803978690191_p
w(8)=5.973544660396815e-7_p
else if(N==9)then
x(1)=-7.712170801497777_p
w(1)=7.334556142267191e-1_p
x(2)=-6.526302793709477_p
w(2)=1.608357579529191_p
x(3)=-4.570260144882548_p
w(3)=2.225268403350948_p
x(4)=-2.164314546868531_p
w(4)=2.231580142831913_p
x(5)=3.344509131410697e-1_p
w(5)=1.070675352441528_p
x(6)=3.224335191530920_p
w(6)=1.272928163781790e-1_p
x(7)=7.099198354535352_p
w(7)=3.677086344544248e-3_p
x(8)=12.25267692842006_p
w(8)=2.837687067807245e-5_p
x(9)=19.31811602219026_p
w(9)=3.439408612251269e-8_p
else if(N==10)then
x(1)=-7.751265525093063_p
w(1)=6.345712216698247e-1_p
x(2)=-6.720090154384950_p
w(2)=1.406419949475348_p
x(3)=-4.991764807197481_p
w(3)=1.997200971494081_p
x(4)=-2.795890311347020_p
w(4)=2.188169467192990_p
x(5)=-4.497000285425786e-1_p
w(5)=1.443328672955901_p
x(6)=2.078101584459287_p
w(6)=3.121196809908309e-1_p
x(7)=5.304723332481590_p
w(7)=1.816079190906185e-2_p
x(8)=9.466113934580912_p
w(8)=3.623220472929640e-4_p
x(9)=14.75808738338156_p
w(9)=2.325223696762994e-6_p
x(10)=21.50175303543203_p
w(10)=3.408758934698467e-9_p
else if(N==11)then
x(1)=-7.782976978196437_p
w(1)=5.541656351992936e-1_p
x(2)=-6.878969071920101_p
w(2)=1.238229251594482_p
x(3)=-5.345379622886426_p
w(3)=1.791644802860838_p
x(4)=-3.349436656822773_p
w(4)=2.074718681440604_p
x(5)=-1.144947891942846_p
w(5)=1.689847332652536_p
x(6)=1.149569250202176_p
w(6)=5.879018474254374e-1_p
x(7)=3.904193808004275_p
w(7)=6.140434567362460e-2_p
x(8)=7.394954133357383_p
w(8)=2.383878136721085e-3_p
x(9)=11.70037073842444_p
w(9)=3.937805751102622e-5_p
x(10)=16.93720707010167_p
w(10)=2.527050934489746e-7_p
x(11)=22.98188106794813_p
w(11)=6.216462456573651e-10_p
else if(N==12)then
x(1)=-7.809045309798742_p
w(1)=4.879437864593323e-1_p
x(2)=-7.010651842587563_p
w(2)=1.097175333540789_p
x(3)=-5.643559474778801_p
w(3)=1.609901306190517_p
x(4)=-3.831826579940524_p
w(4)=1.933225276090414_p
x(5)=-1.770371622214251_p
w(5)=1.802619165702251_p
x(6)=3.668470181679148e-1_p
w(6)=9.020782293776238e-1_p
x(7)=2.777285523051886_p
w(7)=1.567602257998330e-1_p
x(8)=5.770441689820586_p
w(8)=1.030211220519906e-2_p
x(9)=9.412310915537168_p
w(9)=3.248753063591138e-4_p
x(10)=13.73792143748959_p
w(10)=5.057384888528976e-6_p
x(11)=18.74790374092593_p
w(11)=3.812509705327244e-8_p
x(12)=23.92214139607747_p
w(12)=1.854836264903987e-10_p
else if(N==13)then
x(1)=-7.830712488232672_p
w(1)=4.328207952336097e-1_p
x(2)=-7.120807604596231_p
w(2)=9.781090159265184e-1_p
x(3)=-5.896310657974420_p
w(3)=1.450648678852952_p
x(4)=-4.250944311803527_p
w(4)=1.786099817367413_p
x(5)=-2.333000351750217_p
w(5)=1.814666261141224_p
x(6)=-3.168858562385427e-1_p
w(6)=1.183907913762463_p
x(7)=1.848790589902896_p
w(7)=3.193025023284229e-1_p
x(8)=4.455852615368717_p
w(8)=3.302968849001676e-2_p
x(9)=7.606670646237252_p
w(9)=1.700989807189539e-3_p
x(10)=11.30445912770103_p
w(10)=4.893811581517097e-5_p
x(11)=15.54433022080859_p
w(11)=7.973016631267009e-7_p
x(12)=20.20072439956711_p
w(12)=7.962830313059099e-9_p
x(13)=24.51551791804102_p
w(13)=7.766787550281746e-11_p
else if(N==14)then
x(1)=-7.848905285404195_p
w(1)=3.864822418859325e-1_p
x(2)=-7.213773202259498_p
w(2)=8.769100259550989e-1_p
x(3)=-6.111833189221276_p
w(3)=1.311517110735917_p
x(4)=-4.615096486135761_p
w(4)=1.644096974408203_p
x(5)=-2.836996766765469_p
w(5)=1.765240779816611_p
x(6)=-9.293616969753227e-1_p
w(6)=1.385765736010194_p
x(7)=1.064751055091287_p
w(7)=5.393783928061475e-1_p
x(8)=3.369278580671953_p
w(8)=8.415736475943715e-2_p
x(9)=6.135083965298291_p
w(9)=6.481746839657005e-3_p
x(10)=9.363606071938502_p
w(10)=2.964234590840000e-4_p
x(11)=13.03938912506458_p
w(11)=8.450799631576986e-6_p
x(12)=17.10847140683103_p
w(12)=1.566247466973869e-7_p
x(13)=21.33911768898827_p
w(13)=2.226531062079682e-9_p
x(14)=24.89934043163947_p
w(14)=4.059524534487100e-11_p
else if(N==15)then
x(1)=-7.864323853518394_p
w(1)=3.471723485399117e-1_p
x(2)=-7.292887736264134_p
w(2)=7.903021585797652e-1_p
x(3)=-6.296757268950161_p
w(3)=1.189927660955850_p
x(4)=-4.932115602594112_p
w(4)=1.511826203476089_p
x(5)=-3.286732612504800_p
w(5)=1.683811705118865_p
x(6)=-1.484900243728696_p
w(6)=1.497698392305495_p
x(7)=3.849781638271943e-1_p
w(7)=7.812097039142414e-1_p
x(8)=2.456031317079439_p
w(8)=1.775648343169675e-1_p
x(9)=4.909484020189675_p
w(9)=1.947260314620239e-2_p
x(10)=7.768087797258882_p
w(10)=1.291429308788817e-3_p
x(11)=11.01023666496713_p
w(11)=5.662177014490850e-5_p
x(12)=14.60073994094377_p
w(12)=1.705898510331888e-6_p
x(13)=18.43789680682267_p
w(13)=3.821766235045805e-8_p
x(14)=22.22028369028473_p
w(14)=7.947430793554989e-10_p
x(15)=25.15659828596629_p
w(15)=2.455066255292933e-11_p
else if(N==16)then
x(1)=-7.877502514199012_p
w(1)=3.135468265215104e-1_p
x(2)=-7.360737117739514_p
w(2)=7.156871620582144e-1_p
x(3)=-6.456405194541129_p
w(3)=1.083451137381621_p
x(4)=-5.208948991518978_p
w(4)=1.390828340609152_p
x(5)=-3.687185101456699_p
w(5)=1.588661705087999_p
x(6)=-1.990470409948991_p
w(6)=1.535390743856958_p
x(7)=-2.190576958379541e-1_p
w(7)=1.000869471812849_p
x(8)=1.676085480188811_p
w(8)=3.187608569348147e-1_p
x(9)=3.872714873763856_p
w(9)=4.845346243954415e-2_p
x(10)=6.428725247695127_p
w(10)=4.400415296457033e-3_p
x(11)=9.323937963370545_p
w(11)=2.727542461421717e-4_p
x(12)=12.52851157223792_p
w(12)=1.211312785119126e-5_p
x(13)=15.98478779640205_p
w(13)=4.052315937786461e-7_p
x(14)=19.55296078546068_p
w(14)=1.140176813931461e-8_p
x(15)=22.90057572439049_p
w(15)=3.449236887360533e-10_p
x(16)=25.33540116186911_p
w(16)=1.638897186670033e-11_p
else if(N==17)then
x(1)=-7.888853731540686_p
w(1)=2.845652581420646e-1_p
x(2)=-7.419340936015991_p
w(2)=6.509984962314879e-1_p
x(3)=-6.595048927736906_p
w(3)=9.899319815001572e-1_p
x(4)=-5.451571116010967_p
w(4)=1.281163560810821_p
x(5)=-4.043576307579510_p
w(5)=1.490094210659972_p
x(6)=-2.450109056091154_p
w(6)=1.522091634996984_p
x(7)=-7.657050832901016e-1_p
w(7)=1.167514691367989_p
x(8)=9.982660719563611e-1_p
w(8)=4.974919526480014e-1_p
x(9)=2.984890776216802_p
w(9)=1.030176616308627e-1_p
x(10)=5.287128246487184_p
w(10)=1.237597703229968e-2_p
x(11)=7.896072716244002_p
w(11)=1.024399334906629e-3_p
x(12)=10.78366458931391_p
w(12)=6.253109374087661e-5_p
x(13)=13.91017186836809_p
w(13)=2.933726372534052e-6_p
x(14)=17.19737052501677_p
w(14)=1.129404915258570e-7_p
x(15)=20.48065336138234_p
w(15)=4.065495225089344e-9_p
x(16)=23.42801933104893_p
w(16)=1.744129968152769e-10_p
x(17)=25.46387508550522_p
w(17)=1.172588557956974e-11_p
else
call GD(-8)
end if
end subroutine GF_m8

! [-7kT;26kT]
subroutine GF_m7(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.160732876659112_p
w(1)=4.287642621571244_p
x(2)=-2.708834524502663e-1_p
w(2)=2.713268844877422_p
else if(N==3)then
x(1)=-5.879247514773414_p
w(1)=2.740849899685666_p
x(2)=-2.166717929933403_p
w(2)=3.668240045142143_p
x(3)=2.027331757526113_p
w(3)=5.918215216208559e-1_p
else if(N==4)then
x(1)=-6.222515375204783_p
w(1)=1.936776346780954_p
x(2)=-3.376759519174640_p
w(2)=3.341542485939874_p
x(3)=1.189356560476209e-1_p
w(3)=1.663302107033012_p
x(4)=4.638552053650644_p
w(4)=5.929052669482545e-2_p
else if(N==5)then
x(1)=-6.415831743531452_p
w(1)=1.468600291479837_p
x(2)=-4.168298901456848_p
w(2)=2.822628024181953_p
x(3)=-1.090243973247889_p
w(3)=2.334721402128675_p
x(4)=2.271761150207811_p
w(4)=3.713702072645775e-1_p
x(5)=7.585410861430729_p
w(5)=3.591541393623001e-3_p
else if(N==6)then
x(1)=-6.537340516534962_p
w(1)=1.169263378292909_p
x(2)=-4.706068774613440_p
w(2)=2.377412616527532_p
x(3)=-2.000770307542488_p
w(3)=2.518943854059263_p
x(4)=9.067479009581860e-1_p
w(4)=8.930403387889799e-1_p
x(5)=4.705659868468247_p
w(5)=4.208053479443471e-2_p
x(6)=10.72481037695355_p
w(6)=1.707439855455704e-4_p
else if(N==7)then
x(1)=-6.620033434219623_p
w(1)=9.634819111958163e-1_p
x(2)=-5.089045924494927_p
w(2)=2.026016589321146_p
x(3)=-2.713340869370570_p
w(3)=2.441513672343335_p
x(4)=-6.142586025010109e-2_p
w(4)=1.395766511911153_p
x(5)=3.000070174721672_p
w(5)=1.708601279077773e-1_p
x(6)=7.385792859623880_p
w(6)=3.265416903512420e-3_p
x(7)=13.95382435468509_p
w(7)=7.236865925881767e-6_p
else if(N==8)then
x(1)=-6.680140771583361_p
w(1)=8.129131263768306e-1_p
x(2)=-5.375700943903536_p
w(2)=1.747622972139643_p
x(3)=-3.283733778261591_p
w(3)=2.266899578866107_p
x(4)=-8.363122956263256e-1_p
w(4)=1.738714365701402_p
x(5)=1.813536686189628_p
w(5)=4.144303560612162e-1_p
x(6)=5.315320605747078_p
w(6)=2.011147835270844e-2_p
x(7)=10.16347607222301_p
w(7)=2.192671274033103e-4_p
x(8)=17.09983799748122_p
w(8)=3.218233545503559e-7_p
else if(N==9)then
x(1)=-6.726328845793399_p
w(1)=6.966710417482124e-1_p
x(2)=-5.600531096307622_p
w(2)=1.521261681801066_p
x(3)=-3.752638077889793_p
w(3)=2.066775949012767_p
x(4)=-1.499474797560072_p
w(4)=1.904000449373492_p
x(5)=8.982144740182473e-1_p
w(5)=7.379652197209031e-1_p
x(6)=3.821834718851817_p
w(6)=7.224631650706853e-2_p
x(7)=7.722117200485789_p
w(7)=1.975459211931621e-3_p
x(8)=12.86266622591924_p
w(8)=1.532912023125398e-5_p
x(9)=19.8384987312994_p
w(9)=1.995299248998209e-8_p
else if(N==10)then
x(1)=-6.763151962503710_p
w(1)=6.036779713463285e-1_p
x(2)=-5.782485495056765_p
w(2)=1.333473696319132_p
x(3)=-4.145140216730508_p
w(3)=1.869173164588703_p
x(4)=-2.081798913865663_p
w(4)=1.932366115843061_p
x(5)=1.388092464847764e-1_p
w(5)=1.066977185447938_p
x(6)=2.664947929468540_p
w(6)=1.851895783387063e-1_p
x(7)=5.921106743895252_p
w(7)=9.856425287291195e-3_p
x(8)=10.07504764314216_p
w(8)=1.960160853868706e-4_p
x(9)=15.31691383434574_p
w(9)=1.310976362485539e-6_p
x(10)=21.88590135354212_p
w(10)=2.215755627826417e-9_p
else if(N==11)then
x(1)=-6.793092205203409_p
w(1)=5.278694609312711e-1_p
x(2)=-5.932108739871268_p
w(2)=1.176276855668236_p
x(3)=-4.475991031688994_p
w(3)=1.685752177415279_p
x(4)=-2.593922550062700_p
w(4)=1.875885668625384_p
x(5)=-5.197810246379253e-1_p
w(5)=1.330248482718067_p
x(6)=1.732832588457484_p
w(6)=3.697246100054881e-1_p
x(7)=4.514976884522222_p
w(7)=3.384342038756514e-2_p
x(8)=8.005831234018972_p
w(8)=1.288761636996141e-3_p
x(9)=12.27659085957215_p
w(9)=2.187723496504898e-5_p
x(10)=17.42631345778637_p
w(10)=1.513753568430884e-7_p
x(11)=23.24184544826979_p
w(11)=4.500569087578673e-10_p
else if(N==12)then
x(1)=-6.817745436856931_p
w(1)=4.653218513949116e-1_p
x(2)=-6.056382701284958_p
w(2)=1.043972777999079_p
x(3)=-4.755938480959814_p
w(3)=1.520679783083211_p
x(4)=-3.042222905775402_p
w(4)=1.775966486190110_p
x(5)=-1.104121166434526_p
w(5)=1.494387157316838_p
x(6)=9.578044295490211e-1_p
w(6)=6.061675598776602e-1_p
x(7)=3.382849630214922_p
w(7)=8.866365100918894e-2_p
x(8)=6.384006892431552_p
w(8)=5.570845188329292e-3_p
x(9)=10.00174745619184_p
w(9)=1.784077787615330e-4_p
x(10)=14.26898997694532_p
w(10)=2.922030310948223e-6_p
x(11)=19.16073811849311_p
w(11)=2.443472720101131e-8_p
x(12)=24.09426516487546_p
w(12)=1.455378658637100e-10_p
else if(N==13)then
x(1)=-6.838266797714656_p
w(1)=4.131747717499729e-1_p
x(2)=-6.160531507097982_p
w(2)=9.319699678032883e-1_p
x(3)=-4.993908757162444_p
w(3)=1.374335167951620_p
x(4)=-3.433458219875854_p
w(4)=1.658691455013154_p
x(5)=-1.627094954705215_p
w(5)=1.565002651299203_p
x(6)=2.935396834270363e-1_p
w(6)=8.509390931845346e-1_p
x(7)=2.450849499971940_p
w(7)=1.878997534887553e-1_p
x(8)=5.071179430714638_p
w(8)=1.794490883294911e-2_p
x(9)=8.206911620808075_p
w(9)=9.255873904902451e-4_p
x(10)=11.86164324480265_p
w(10)=2.762146732871108e-5_p
x(11)=16.02284386912072_p
w(11)=4.827504917244515e-7_p
x(12)=20.54015069596428_p
w(12)=5.452503541256755e-9_p
x(13)=24.63148937438932_p
w(13)=6.437300879984693e-11_p
else if(N==14)then
x(1)=-6.855521056653296_p
w(1)=3.692743582374528e-1_p
x(2)=-6.248572018021887_p
w(2)=8.365431957336100e-1_p
x(3)=-5.197315982898266_p
w(3)=1.245428515330607_p
x(4)=-3.774725077821224_p
w(4)=1.538425523910793_p
x(5)=-2.095696929298907_p
w(5)=1.566623514317574_p
x(6)=-2.908066436378306e-1_p
w(6)=1.060089439482327_p
x(7)=1.667940225641042_p
w(7)=3.345428519154482e-1_p
x(8)=3.984910050102061_p
w(8)=4.630926525717596e-2_p
x(9)=6.743969634355577_p
w(9)=3.505336494406047e-3_p
x(10)=9.939954430334051_p
w(10)=1.644249990032601e-4_p
x(11)=13.557170633621_p
w(11)=4.939417111745667e-6_p
x(12)=17.53171091042776_p
w(12)=9.970061563976508e-8_p
x(13)=21.61395777146816_p
w(13)=1.617637344413180e-9_p
x(14)=24.98008422148623_p
w(14)=3.490411664867555e-11_p
else if(N==15)then
x(1)=-6.870162397448754_p
w(1)=3.319839453207554e-1_p
x(2)=-6.323605031566403_p
w(2)=7.547064783708181e-1_p
x(3)=-5.372203147938845_p
w(3)=1.132095285228027_p
x(4)=-4.072812706104918_p
w(4)=1.422390787870929_p
x(5)=-2.514983783155286_p
w(5)=1.524955651937918_p
x(6)=-8.141681567301784e-1_p
w(6)=1.208425346113366_p
x(7)=9.965293406645837e-1_p
w(7)=5.150206596495233e-1_p
x(8)=3.071147847114326_p
w(8)=1.000825580563775e-1_p
x(9)=5.524855066424662_p
w(9)=1.051060543885562e-2_p
x(10)=8.359478014560450_p
w(10)=7.068186118799050e-4_p
x(11)=11.5556999164925_p
w(11)=3.226662333542500e-5_p
x(12)=15.07513197930426_p
w(12)=1.037034713570879e-6_p
x(13)=18.80709260056024_p
w(13)=2.556353250467284e-8_p
x(14)=22.44163706601048_p
w(14)=6.069895699256859e-10_p
x(15)=25.2148396716584_p
w(15)=2.164378614020132e-11_p
else if(N==16)then
x(1)=-6.882690830107065_p
w(1)=3.000481988586979e-1_p
x(2)=-6.388037989763702_p
w(2)=6.840768344656394e-1_p
x(3)=-5.523452329694005_p
w(3)=1.032393658589424_p
x(4)=-4.333841296824850_p
w(4)=1.313857910272480_p
x(5)=-2.889602773288456_p
w(5)=1.459497479652853_p
x(6)=-1.287443621126708_p
w(6)=1.292769260407736_p
x(7)=4.086842282829004e-1_p
w(7)=7.030566846869205e-1_p
x(8)=2.291590531189227_p
w(8)=1.864018975508403e-1_p
x(9)=4.492478002896624_p
w(9)=2.626511902851129e-2_p
x(10)=7.032154802391933_p
w(10)=2.384614603845864e-3_p
x(11)=9.890672239643512_p
w(11)=1.524178748654493e-4_p
x(12)=13.03872260197206_p
w(12)=7.125533593637353e-6_p
x(13)=16.41452977594857_p
w(13)=2.566452674098286e-7_p
x(14)=19.87209429355392_p
w(14)=7.988908434285047e-9_p
x(15)=23.07921198852967_p
w(15)=2.743771050247889e-10_p
x(16)=25.37881409546295_p
w(16)=1.470468801661632e-11_p
else if(N==17)then
x(1)=-6.893492982356499_p
w(1)=2.724937134083610e-1_p
x(2)=-6.443755754062528_p
w(2)=6.227490964405160e-1_p
x(3)=-5.655003114643523_p
w(3)=9.445102099837573e-1_p
x(4)=-4.563147616488436_p
w(4)=1.214010621728743_p
x(5)=-3.224121478016885_p
w(5)=1.382962715407267_p
x(6)=-1.717018475925746_p
w(6)=1.323867756569911_p
x(7)=-1.155534281370308e-1_p
w(7)=8.711280836437435e-1_p
x(8)=1.617313346216303_p
w(8)=3.053597949816382e-1_p
x(9)=3.607347449447781_p
w(9)=5.656238023496393e-2_p
x(10)=5.900082904902113_p
w(10)=6.665758380063822e-3_p
x(11)=8.479900288858316_p
w(11)=5.636070350976775e-4_p
x(12)=11.32113888315381_p
w(12)=3.586496400809551e-5_p
x(13)=14.38288324697033_p
w(13)=1.786058341164048e-6_p
x(14)=17.58336118162318_p
w(14)=7.448809083243637e-8_p
x(15)=20.7551867550498_p
w(15)=2.970177112340836e-9_p
x(16)=23.57315180058762_p
w(16)=1.433302134337938e-10_p
x(17)=25.49718236052922_p
w(17)=1.065578119456360e-11_p
else
call GD(-7)
end if
end subroutine GF_m7

! [-6kT;26kT]
subroutine GF_m6(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-4.348502561786690_p
w(1)=3.813108197019172_p
x(2)=9.542185234429022e-2_p
w(2)=2.189367488113450_p
else if(N==3)then
x(1)=-4.976655330777918_p
w(1)=2.488346272426511_p
x(2)=-1.607600914199985_p
w(2)=3.105729875062222_p
x(3)=2.458422631337354_p
w(3)=4.083995376438883e-1_p
else if(N==4)then
x(1)=-5.281876165646562_p
w(1)=1.781346567194945_p
x(2)=-2.670790281092243_p
w(2)=2.950356262425298_p
x(3)=5.934016433005155e-1_p
w(3)=1.235345964925515_p
x(4)=5.170682971972423_p
w(4)=3.542689058686271e-2_p
else if(N==5)then
x(1)=-5.455896702782328_p
w(1)=1.363121338163307_p
x(2)=-3.373450551572876_p
w(2)=2.554773359758309_p
x(3)=-5.307071387015860e-1_p
w(3)=1.851040247058160_p
x(4)=2.803475289251114_p
w(4)=2.315541140257983e-1_p
x(5)=8.183516862506300_p
w(5)=1.986626127047464e-3_p
else if(N==6)then
x(1)=-5.566335844595232_p
w(1)=1.092659626076430_p
x(2)=-3.856821326414019_p
w(2)=2.184212909102578_p
x(3)=-1.353212096641480_p
w(3)=2.107898345773664_p
x(4)=1.449159843682951_p
w(4)=5.942460468524163e-1_p
x(5)=5.309797572676257_p
w(5)=2.336842884610413e-2_p
x(6)=11.36424240098516_p
w(6)=9.032848142842418e-5_p
else if(N==7)then
x(1)=-5.642155279343206_p
w(1)=9.049012357720796e-1_p
x(2)=-4.204956466200470_p
w(2)=1.879542148339807_p
x(3)=-1.994383056209289_p
w(3)=2.124188609488010_p
x(4)=5.111496215179144e-1_p
w(4)=9.947443424471664e-1_p
x(5)=3.601494897729852_p
w(5)=9.737432317837150e-2_p
x(6)=8.031005361260746_p
w(6)=1.721273232111988e-3_p
x(7)=14.61013207901763_p
w(7)=3.752675074922879e-6_p
else if(N==8)then
x(1)=-5.697771510389606_p
w(1)=7.661642393208921e-1_p
x(2)=-4.468421951613164_p
w(2)=1.631826025419132_p
x(3)=-2.511809804634022_p
w(3)=2.024502431425165_p
x(4)=-2.209444539689288e-1_p
w(4)=1.321407176164842_p
x(5)=2.409225976848107_p
w(5)=2.477749675132303e-1_p
x(6)=5.956867136370079_p
w(6)=1.068660671981413e-2_p
x(7)=10.81616323668074_p
w(7)=1.140672978981741e-4_p
x(8)=17.72090268225259_p
w(8)=1.712716478903350e-7_p
else if(N==9)then
x(1)=-5.740843431484048_p
w(1)=6.581629909274377e-1_p
x(2)=-4.676980104264320_p
w(2)=1.426767610191909_p
x(3)=-2.941576295207341_p
w(3)=1.878173566885431_p
x(4)=-8.373598051831977e-1_p
w(4)=1.529712247429564_p
x(5)=1.494309917430310_p
w(5)=4.694652479850173e-1_p
x(6)=4.454350237502680_p
w(6)=3.915136328105421e-2_p
x(7)=8.368222725024809_p
w(7)=1.034489753712590e-3_p
x(8)=13.48554927014083_p
w(8)=8.157064417496136e-6_p
x(9)=20.34989707728956_p
w(9)=1.161407762865187e-8_p
else if(N==10)then
x(1)=-5.775339922832796_p
w(1)=5.713334654258589e-1_p
x(2)=-4.846719322275400_p
w(2)=1.254743585743980_p
x(3)=-3.304045380694399_p
w(3)=1.718886220020874_p
x(4)=-1.374522072942292_p
w(4)=1.622859176634704_p
x(5)=7.478503351320157e-1_p
w(5)=7.257934305643748e-1_p
x(6)=3.288604874082468_p
w(6)=1.035602555226069e-1_p
x(7)=6.562834752517082_p
w(7)=5.194638604592961e-3_p
x(8)=10.69968269665165_p
w(8)=1.041772773567951e-4_p
x(9)=15.8801378038805_p
w(9)=7.338822925096412e-7_p
x(10)=22.25302210655996_p
w(10)=1.455981037866244e-9_p
else if(N==11)then
x(1)=-5.803459494777949_p
w(1)=5.003499977479089e-1_p
x(2)=-4.986762229684229_p
w(2)=1.109724538183107_p
x(3)=-3.611159499145249_p
w(3)=1.563283067037129_p
x(4)=-1.846263905995392_p
w(4)=1.628572006200742_p
x(5)=1.143587120983321e-1_p
w(5)=9.657821206164470e-1_p
x(6)=2.351519087592057_p
w(6)=2.160786664803152e-1_p
x(7)=5.154116380588031_p
w(7)=1.799067890306499e-2_p
x(8)=8.634945818045528_p
w(8)=6.825070070899744e-4_p
x(9)=12.86242923343952_p
w(9)=1.201207297376071e-5_p
x(10)=17.91365359795362_p
w(10)=9.055463825602776e-8_p
x(11)=23.48667034377388_p
w(11)=3.292048874383713e-10_p
else if(N==12)then
x(1)=-5.826658028798978_p
w(1)=4.416578678448182e-1_p
x(2)=-5.103373054229960_p
w(2)=9.870399883679262e-1_p
x(3)=-3.872078080548311_p
w(3)=1.418893105602596_p
x(4)=-2.260137639013694_p
w(4)=1.579238231567092_p
x(5)=-4.374821519008947e-1_p
w(5)=1.150432458153876_p
x(6)=1.578355945727861_p
w(6)=3.743129069606895e-1_p
x(7)=4.019733008936868_p
w(7)=4.786220324892773e-2_p
x(8)=7.018285916543696_p
w(8)=2.940695317108677e-3_p
x(9)=10.60391041626582_p
w(9)=9.653560220829771e-5_p
x(10)=14.8046566152375_p
w(10)=1.676656169618747e-6_p
x(11)=19.56807719713732_p
w(11)=1.569618626698841e-8_p
x(12)=24.25576738964109_p
w(12)=1.150231905261022e-10_p
else if(N==13)then
x(1)=-5.846002042130277_p
w(1)=3.926314932912490e-1_p
x(2)=-5.201315693855123_p
w(2)=8.827521909190962e-1_p
x(3)=-4.094634384021704_p
w(3)=1.288299938472302_p
x(4)=-2.622667676622229_p
w(4)=1.500468981424999_p
x(5)=-9.257964097602228e-1_p
w(5)=1.265543622451579_p
x(6)=9.245405169945485e-1_p
w(6)=5.587095644862762e-1_p
x(7)=3.085827822310899_p
w(7)=1.040901563356072e-1_p
x(8)=5.709891205302712_p
w(8)=9.469037557266396e-3_p
x(9)=8.822249469731144_p
w(9)=4.949738617424076e-4_p
x(10)=12.42702783807424_p
w(10)=1.543114992467035e-5_p
x(11)=16.50207627137594_p
w(11)=2.913805636777315e-7_p
x(12)=20.8725380138082_p
w(12)=3.748423333550950e-9_p
x(13)=24.74053525018528_p
w(13)=5.359186038569652e-11_p
else if(N==14)then
x(1)=-5.862292249840332_p
w(1)=3.512867461602811e-1_p
x(2)=-5.284272443596109_p
w(2)=7.935968359849970e-1_p
x(3)=-4.285423089670056_p
w(3)=1.171665287619723_p
x(4)=-2.940140653725008_p
w(4)=1.408976081487026_p
x(5)=-1.361223850281643_p
w(5)=1.317258603304555_p
x(6)=3.587517678656478e-1_p
w(6)=7.407051460191413e-1_p
x(7)=2.302851855643263_p
w(7)=1.924780149036207e-1_p
x(8)=4.626741314440032_p
w(8)=2.455833843120765e-2_p
x(9)=7.370143791205304_p
w(9)=1.857646296902476e-3_p
x(10)=10.52701912573096_p
w(10)=9.005224527157896e-5_p
x(11)=14.07948182959584_p
w(11)=2.868035434655248e-6_p
x(12)=17.95299638863286_p
w(12)=6.343407178902223e-8_p
x(13)=21.88172969767492_p
w(13)=1.180301770328502e-9_p
x(14)=25.05633867647664_p
w(14)=3.008632731802485e-11_p
else if(N==15)then
x(1)=-5.876135433670053_p
w(1)=3.161125268393443e-1_p
x(2)=-5.355095662550463_p
w(2)=7.169214732454531e-1_p
x(3)=-4.449870660491551_p
w(3)=1.068090365726511_p
x(4)=-3.218456992793466_p
w(4)=1.314545550656836_p
x(5)=-1.750611009425950_p
w(5)=1.320988403001907_p
x(6)=-1.403340672426104e-1_p
w(6)=8.950694464266632e-1_p
x(7)=1.635242938104385_p
w(7)=3.110455721746941e-1_p
x(8)=3.714901351633057_p
w(8)=5.376457862652168e-2_p
x(9)=6.159798248394437_p
w(9)=5.537797951557151e-3_p
x(10)=8.963642617219946_p
w(10)=3.811043770693339e-4_p
x(11)=12.10834592634499_p
w(11)=1.822046447655356e-5_p
x(12)=15.5512155869313_p
w(12)=6.280382979570107e-7_p
x(13)=19.1727561403346_p
w(13)=1.711880712842879e-8_p
x(14)=22.65666754085215_p
w(14)=4.653778462216675e-10_p
x(15)=25.27011084562822_p
w(15)=1.910506898282727e-11_p
else if(N==16)then
x(1)=-5.887996289595194_p
w(1)=2.859470339410484e-1_p
x(2)=-5.416007263806127_p
w(2)=6.505874527142851e-1_p
x(3)=-4.592396137148909_p
w(3)=9.762875214093424e-1_p
x(4)=-3.462955210515601_p
w(4)=1.222484144068387_p
x(5)=-2.099108494943522_p
w(5)=1.292789818122446_p
x(6)=-5.866542460872597e-1_p
w(6)=1.007877025848227_p
x(7)=1.056505896812015_p
w(7)=4.488714199501428e-1_p
x(8)=2.936861845109355_p
w(8)=1.024546855591028e-1_p
x(9)=5.134259598159685_p
w(9)=1.381806581256114e-2_p
x(10)=7.650271927362930_p
w(10)=1.269960025610643e-3_p
x(11)=10.46665337382376_p
w(11)=8.422422848848593e-5_p
x(12)=13.55328377123863_p
w(12)=4.165352179721875e-6_p
x(13)=16.84390744856178_p
w(13)=1.622599762520889e-7_p
x(14)=20.18696849771037_p
w(14)=5.608683018574585e-9_p
x(15)=23.25252175578699_p
w(15)=2.189419829314738e-10_p
x(16)=25.42020432813528_p
w(16)=1.319944981854126e-11_p
else if(N==17)then
x(1)=-5.898234872554425_p
w(1)=2.598872416668025e-1_p
x(2)=-5.468752267375871_p
w(2)=5.928710520121520e-1_p
x(3)=-4.716589358606461_p
w(3)=8.948965811693864e-1_p
x(4)=-3.678336176536977_p
w(4)=1.135436307388003_p
x(5)=-2.411122273180250_p
w(5)=1.245509872904919_p
x(6)=-9.891584287089711e-1_p
w(6)=1.077120460831000_p
x(7)=5.468145926011992e-1_p
w(7)=5.894389304385262e-1_p
x(8)=2.265025421283875_p
w(8)=1.735812419891226e-1_p
x(9)=4.254252040867690_p
w(9)=2.988894375616511e-2_p
x(10)=6.529677897434955_p
w(10)=3.517473388924470e-3_p
x(11)=9.074746124496485_p
w(11)=3.060443332276264e-4_p
x(12)=11.86502943485517_p
w(12)=2.040088878461246e-5_p
x(13)=14.85773642058866_p
w(13)=1.082951221656214e-6_p
x(14)=17.96761246497882_p
w(14)=4.911177065299646e-8_p
x(15)=21.02531011290211_p
w(15)=2.174865863623250e-9_p
x(16)=23.71393074806602_p
w(16)=1.180663102430107e-10_p
x(17)=25.52907040174937_p
w(17)=9.682662297159508e-12_p
else
call GD(-6)
end if
end subroutine GF_m6

! [-5kT;26kT]
subroutine GF_m5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-3.535012777817061_p
w(1)=3.320511011102611_p
x(2)=4.997493647927588e-1_p
w(2)=1.686204337381398_p
else if(N==3)then
x(1)=-4.074467915739697_p
w(1)=2.223446930553281_p
x(2)=-1.037809140386511_p
w(2)=2.518893729904173_p
x(3)=2.943265168997896_p
w(3)=2.643746880265551e-1_p
else if(N==4)then
x(1)=-4.341959597062782_p
w(1)=1.617038376351541_p
x(2)=-1.966119127967257_p
w(2)=2.512462003146809_p
x(3)=1.108288273709099_p
w(3)=8.571072338885802e-1_p
x(4)=5.750209851843470_p
w(4)=2.010773509707826e-2_p
else if(N==5)then
x(1)=-4.496710055047569_p
w(1)=1.250840981062602_p
x(2)=-2.582654763820902_p
w(2)=2.247072739390989_p
x(3)=4.798860792612505e-2_p
w(3)=1.372628950165725_p
x(4)=3.386208430192641_p
w(4)=1.351177604936728e-1_p
x(5)=8.821139288072924_p
w(5)=1.054917371020680e-3_p
else if(N==6)then
x(1)=-4.596035408692712_p
w(1)=1.010586871262563_p
x(2)=-3.011886724388743_p
w(2)=1.960869044597696_p
x(3)=-7.020409936334304e-1_p
w(3)=1.657468322205669_p
x(4)=2.037780093545324_p
w(4)=3.653584969832162e-1_p
x(5)=5.956014392436499_p
w(5)=1.238643990515824e-2_p
x(6)=12.03724933010423_p
w(6)=4.617352970617407e-5_p
else if(N==7)then
x(1)=-4.664929860855241_p
w(1)=8.417579747607539e-1_p
x(2)=-3.324898464671163_p
w(2)=1.710228807490859_p
x(3)=-1.279580170790060_p
w(3)=1.750403183963415_p
x(4)=1.116974466045336_p
w(4)=6.510265355045816e-1_p
x(5)=4.247361360295276_p
w(5)=5.242048144086688e-2_p
x(6)=8.709042022326946_p
w(6)=8.764688753067583e-4_p
x(7)=15.29085185011727_p
w(7)=1.896448226109559e-6_p
else if(N==8)then
x(1)=-4.715995086857459_p
w(1)=7.155434319629416e-1_p
x(2)=-3.564747757571898_p
w(2)=1.498391994780551_p
x(3)=-1.746890549350064_p
w(3)=1.727464070274688_p
x(4)=4.125654888481548e-1_p
w(4)=9.217212369490162e-1_p
x(5)=3.049157738077881_p
w(5)=1.380629417580610e-1_p
x(6)=6.631195419822052_p
w(6)=5.473675985557203e-3_p
x(7)=11.49152424263695_p
w(7)=5.790654746200539e-5_p
x(8)=18.34835608238769_p
w(8)=9.022573190599868e-8_p
else if(N==9)then
x(1)=-4.755870081739526_p
w(1)=6.163860146834145e-1_p
x(2)=-3.756501473114711_p
w(2)=1.318481578533350_p
x(3)=-2.137846718187169_p
w(3)=1.643552827776845_p
x(4)=-1.692216322742680e-1_p
w(4)=1.132655579491487_p
x(5)=2.130340033694067_p
w(5)=2.747859188353525e-1_p
x(6)=5.121463334310160_p
w(6)=2.032098910300251e-2_p
x(7)=9.037385570248620_p
w(7)=5.281552091498863e-4_p
x(8)=14.12049971339321_p
w(8)=4.278052627697824e-6_p
x(9)=20.84913200715516_p
w(9)=6.798780050647110e-9_p
else if(N==10)then
x(1)=-4.787956256391527_p
w(1)=5.362370692220767e-1_p
x(2)=-3.913499813542235_p
w(2)=1.165091301473022_p
x(3)=-2.469608456165208_p
w(3)=1.531859397598230_p
x(4)=-6.688133028109543e-1_p
w(4)=1.265854891800545_p
x(5)=1.388364258327845_p
w(5)=4.501019995851018e-1_p
x(6)=3.949354419827367_p
w(6)=5.485487099743806e-2_p
x(7)=7.229572963743484_p
w(7)=2.661009285323463e-3_p
x(8)=11.33976250592151_p
w(8)=5.439936307339584e-5_p
x(9)=16.4467326518911_p
w(9)=4.081912588249482e-7_p
x(10)=22.60198552772501_p
w(10)=9.679396122234193e-10_p
else if(N==11)then
x(1)=-4.814184770149544_p
w(1)=4.704956458889127e-1_p
x(2)=-4.043526023951552_p
w(2)=1.034375716582812_p
x(3)=-2.752090037540927_p
w(3)=1.411921930461157_p
x(4)=-1.104034322965880_p
w(4)=1.325783641790111_p
x(5)=7.692768156007116e-1_p
w(5)=6.366155608548731e-1_p
x(6)=3.008252477567990_p
w(6)=1.179144330569290e-1_p
x(7)=5.820879919160594_p
w(7)=9.247688726455539e-3_p
x(8)=9.282083578916771_p
w(8)=3.541568434464032e-4_p
x(9)=13.45744085959924_p
w(9)=6.519902235123152e-6_p
x(10)=18.39825730116891_p
w(10)=5.413383139763531e-8_p
x(11)=23.7165169207938_p
w(11)=2.432461527452537e-10_p
else if(N==12)then
x(1)=-4.835872687198701_p
w(1)=4.159908161776439e-1_p
x(2)=-4.152128959926066_p
w(2)=9.228981545677020e-1_p
x(3)=-2.993131615696267_p
w(3)=1.294330131984491_p
x(4)=-1.484956141251273_p
w(4)=1.329497742641766_p
x(5)=2.397561050819894e-1_p
w(5)=8.049717878065386e-1_p
x(6)=2.234701675889938_p
w(6)=2.126755583569027e-1_p
x(7)=4.687067466824003_p
w(7)=2.478212490166306e-2_p
x(8)=7.672854396574582_p
w(8)=1.516589220491289e-3_p
x(9)=11.21852360846809_p
w(9)=5.147685204408876e-5_p
x(10)=15.34436265916733_p
w(10)=9.557728110095147e-7_p
x(11)=19.96921042532566_p
w(11)=1.011043311856143e-8_p
x(12)=24.40708413448792_p
w(12)=9.152199809819641e-11_p
else if(N==13)then
x(1)=-4.853994655348664_p
w(1)=3.703523321299468e-1_p
x(2)=-4.243591839411953_p
w(2)=8.275328307915985e-1_p
x(3)=-3.199538789150056_p
w(3)=1.184127985515446_p
x(4)=-1.818964883875417_p
w(4)=1.296054275318583_p
x(5)=-2.217241302648761e-1_p
w(5)=9.353549260693810e-1_p
x(6)=1.585610790049829_p
w(6)=3.334874419823252e-1_p
x(7)=3.753631685599221_p
w(7)=5.467395719211823e-2_p
x(8)=6.371203632338624_p
w(8)=4.862672750708699e-3_p
x(9)=9.452389024826109_p
w(9)=2.602139667486174e-4_p
x(10)=13.00025826838185_p
w(10)=8.534752643158228e-6_p
x(11)=16.98147714522369_p
w(11)=1.753820286916044e-7_p
x(12)=21.19749230534019_p
w(12)=2.587685574396431e-9_p
x(13)=24.84301687583987_p
w(13)=4.479519232714535e-11_p
else if(N==14)then
x(1)=-4.869284548544724_p
w(1)=3.317815524506731e-1_p
x(2)=-4.321244829963236_p
w(2)=7.455850366204312e-1_p
x(3)=-3.377091276295468_p
w(3)=1.083270974159407_p
x(4)=-2.112227894104918_p
w(4)=1.240973996369385_p
x(5)=-6.290314029285986e-1_p
w(5)=1.020981592564032_p
x(6)=1.030388496434524_p
w(6)=4.669943278861722e-1_p
x(7)=2.971501091987713_p
w(7)=1.035099594005505e-1_p
x(8)=5.293646250243587_p
w(8)=1.260210499012435e-2_p
x(9)=8.013149222963998_p
w(9)=9.654026244313650e-4_p
x(10)=11.12451461418309_p
w(10)=4.870546903081893e-5_p
x(11)=14.60593549428097_p
w(11)=1.654708434923389e-6_p
x(12)=18.37187498151942_p
w(12)=4.035045748371232e-8_p
x(13)=22.14228511616802_p
w(13)=8.648895355959984e-10_p
x(14)=25.12834989758373_p
w(14)=2.598926225465920e-11_p
else if(N==15)then
x(1)=-4.882299798468607_p
w(1)=2.989041171091399e-1_p
x(2)=-4.387679293399491_p
w(2)=6.748094573439870e-1_p
x(3)=-3.530586292723892_p
w(3)=9.921196467081231e-1_p
x(4)=-2.370131515548595_p
w(4)=1.175086242176980_p
x(5)=-9.912871465021449e-1_p
w(5)=1.065150960331289_p
x(6)=5.471830704084247e-1_p
w(6)=5.969125467052668e-1_p
x(7)=2.306243788991559_p
w(7)=1.729532480416616e-1_p
x(8)=4.386187906290374_p
w(8)=2.771341025191617e-2_p
x(9)=6.813570165103371_p
w(9)=2.852634724049040e-3_p
x(10)=9.580261608350595_p
w(10)=2.024971604525659e-4_p
x(11)=12.66787753697836_p
w(11)=1.019709375459324e-5_p
x(12)=16.0286225132098_p
w(12)=3.789838139784639e-7_p
x(13)=19.53456589423607_p
w(13)=1.147856299778791e-8_p
x(14)=22.86537062184111_p
w(14)=3.581316198236372e-10_p
x(15)=25.32257185019257_p
w(15)=1.688034988239635e-11_p
else if(N==16)then
x(1)=-4.893468390011796_p
w(1)=2.706598605013865e-1_p
x(2)=-4.444922512802732_p
w(2)=6.133625430464352e-1_p
x(3)=-3.663963284288739_p
w(3)=9.102639081394509e-1_p
x(4)=-2.597415418694533_p
w(4)=1.105289930494816_p
x(5)=-1.314879759981984_p
w(5)=1.076182174570645_p
x(6)=1.205489329079135e-1_p
w(6)=7.094213666135363e-1_p
x(7)=1.732581621319756_p
w(7)=2.603256780209012e-1_p
x(8)=3.611628123892093_p
w(8)=5.341853569408752e-2_p
x(9)=5.796968700205570_p
w(9)=7.077687840687860e-3_p
x(10)=8.282625001684480_p
w(10)=6.651048328519392e-4_p
x(11)=11.05160562019504_p
w(11)=4.603210044167381e-5_p
x(12)=14.07190074720994_p
w(12)=2.420071159110465e-6_p
x(13)=17.27260731043743_p
w(13)=1.024249479711603e-7_p
x(14)=20.49738534350807_p
w(14)=3.945591197078021e-9_p
x(15)=23.42056702490465_p
w(15)=1.752200705719196e-10_p
x(16)=25.45967618886733_p
w(16)=1.185075200892849e-11_p
else if(N==17)then
x(1)=-4.903122764527166_p
w(1)=2.462221719374868e-1_p
x(2)=-4.494572893077851_p
w(2)=5.597378000493867e-1_p
x(3)=-3.780446558952339_p
w(3)=8.369596385621250e-1_p
x(4)=-2.798224885565179_p
w(4)=1.035704686522561_p
x(5)=-1.604681291253705_p
w(5)=1.063353954089750_p
x(6)=-2.603066011285718e-1_p
w(6)=7.963782356346394e-1_p
x(7)=1.231463270759807_p
w(7)=3.587769480151551e-1_p
x(8)=2.943021047720253_p
w(8)=9.230089242041579e-2_p
x(9)=4.924270056760093_p
w(9)=1.528386183826980e-2_p
x(10)=7.175234048488877_p
w(10)=1.820890320531875e-3_p
x(11)=9.680291031405314_p
w(11)=1.640703777756277e-4_p
x(12)=12.41507918679447_p
w(12)=1.151058092916831e-5_p
x(13)=15.3344601714045_p
w(13)=6.540593522164613e-7_p
x(14)=18.34988136049446_p
w(14)=3.237331502553152e-8_p
x(15)=21.29092149135565_p
w(15)=1.596053131034875e-9_p
x(16)=23.85043991857184_p
w(16)=9.746592064508374e-11_p
x(17)=25.55960859634027_p
w(17)=8.795964637307070e-12_p
else
call GD(-5)
end if
end subroutine GF_m5

! [-4kT;26kT]
subroutine GF_m4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.719496192968128_p
w(1)=2.798302107037955_p
x(2)=9.542779132061875e-1_p
w(2)=1.219847820874746_p
else if(N==3)then
x(1)=-3.173001413138016_p
w(1)=1.934954700608524_p
x(2)=-4.480236132593083e-1_p
w(2)=1.923940362820843_p
x(3)=3.489291333782299_p
w(3)=1.592548644833340e-1_p
else if(N==4)then
x(1)=-3.403205872768615_p
w(1)=1.435135203371352_p
x(2)=-1.258698909888466_p
w(2)=2.024549674571903_p
x(3)=1.675312756258495_p
w(3)=5.476567263136262e-1_p
x(4)=6.380695966391221_p
w(4)=1.080832365582002e-2_p
else if(N==5)then
x(1)=-3.538679013833086_p
w(1)=1.124933753814715_p
x(2)=-1.794991326548515_p
w(2)=1.884565966317657_p
x(3)=6.593729866878676e-1_p
w(3)=9.344464081212931e-1_p
x(4)=4.023714842436286_p
w(4)=7.366755678273493e-2_p
x(5)=9.501246662953776_p
w(5)=5.362428763008243e-4_p
else if(N==6)then
x(1)=-3.626792920418930_p
w(1)=9.175439028881913e-1_p
x(2)=-2.171644587997929_p
w(2)=1.690249383058438_p
x(3)=-3.608912122272905e-2_p
w(3)=1.197424040963574_p
x(4)=2.679790903012264_p
w(4)=2.066483745820570e-1_p
x(5)=6.646053259446313_p
w(5)=6.261471300308670e-3_p
x(6)=12.74603778215829_p
w(6)=2.275512013131707e-5_p
else if(N==7)then
x(1)=-3.688659209305593_p
w(1)=7.695123688854068e-1_p
x(2)=-2.449710848031330_p
w(2)=1.502275305485635_p
x(3)=-5.617507075641108e-1_p
w(3)=1.331769498773169_p
x(4)=1.767563749614403_p
w(4)=3.874484894866990e-1_p
x(5)=4.938524341061611_p
w(5)=2.671264991797422e-2_p
x(6)=9.420996733214901_p
w(6)=4.306815811978282e-4_p
x(7)=15.99579507275196_p
w(7)=9.337826184013047e-7_p
else if(N==8)then
x(1)=-3.735061465961551_p
w(1)=6.572606192698541e-1_p
x(2)=-2.665599680238481_p
w(2)=1.333720225546764_p
x(3)=-9.851359867205258e-1_p
w(3)=1.371530654346967_p
x(4)=1.078088510931578_p
w(4)=5.809317492100834e-1_p
x(5)=3.735116947145499_p
w(5)=7.197445155416012e-2_p
x(6)=7.338558529897506_p
w(6)=2.703500526907174e-3_p
x(7)=12.18952927152211_p
w(7)=2.868030050481446e-5_p
x(8)=18.97887310168998_p
w(8)=4.715746035404390e-8_p
else if(N==9)then
x(1)=-3.771612712655716_p
w(1)=5.681453486471046e-1_p
x(2)=-2.839958232810869_p
w(2)=1.184958558225987_p
x(3)=-1.339802114132574_p
w(3)=1.349791203903602_p
x(4)=5.182384351107125e-1_p
w(4)=7.565309102584921e-1_p
x(5)=2.811222447677021_p
w(5)=1.483331400363698e-1_p
x(6)=5.822907874048844_p
w(6)=1.012571315220614e-2_p
x(7)=9.729785409453910_p
w(7)=2.628376023396018e-4_p
x(8)=14.76682504471627_p
w(8)=2.212075532943443e-6_p
x(9)=21.33322101780073_p
w(9)=4.011065868929283e-9_p
else if(N==10)then
x(1)=-3.801170381662689_p
w(1)=4.956599243075875e-1_p
x(2)=-2.983606023490677_p
w(2)=1.054904959503669_p
x(3)=-1.641479006866428_p
w(3)=1.291626156605723_p
x(4)=4.597355419290251e-2_p
w(4)=8.930583668069235e-1_p
x(5)=2.069283880184219_p
w(5)=2.538882257381224e-1_p
x(6)=4.646857362199137_p
w(6)=2.765876337387822e-2_p
x(7)=7.921341692017655_p
w(7)=1.325399592506633e-3_p
x(8)=11.99525237283451_p
w(8)=2.790563048726507e-5_p
x(9)=17.01578480688405_p
w(9)=2.257024963943904e-7_p
x(10)=22.93205387243776_p
w(10)=6.513057256790081e-10_p
else if(N==11)then
x(1)=-3.825411236194240_p
w(1)=4.359476630829261e-1_p
x(2)=-3.103093875674278_p
w(2)=9.421156429677127e-1_p
x(3)=-1.899133416247393_p
w(3)=1.214979373494545_p
x(4)=-3.598310538917218e-1_p
w(4)=9.822135730754419e-1_p
x(5)=1.456981077028132_p
w(5)=3.775988393166482e-1_p
x(6)=3.703731991348775_p
w(6)=6.050693407696494e-2_p
x(7)=6.514856303706966_p
w(7)=4.604317578155609e-3_p
x(8)=9.947293553586805_p
w(8)=1.800532844986986e-4_p
x(9)=14.06134378504541_p
w(9)=3.498499193355900e-6_p
x(10)=18.87927644832482_p
w(10)=3.235514213724292e-8_p
x(11)=23.93174745304218_p
w(11)=1.814722537182446e-10_p
else if(N==12)then
x(1)=-3.845511591807553_p
w(1)=3.862622734343137e-1_p
x(2)=-3.203262442887139_p
w(2)=8.446444621641386e-1_p
x(3)=-2.119790124284084_p
w(3)=1.131493564599462_p
x(4)=-7.121044594732535e-1_p
w(4)=1.027029814639013_p
x(5)=9.405916863118754e-1_p
w(5)=5.036116492268313e-1_p
x(6)=2.930046026053903_p
w(6)=1.119597954567593e-1_p
x(7)=5.384015379493778_p
w(7)=1.235636919449704e-2_p
x(8)=8.347597749747473_p
w(8)=7.644019818354771e-4_p
x(9)=11.84551300293469_p
w(9)=2.704924696045947e-5_p
x(10)=15.88768835593479_p
w(10)=5.413634767624664e-7_p
x(11)=20.36356600322311_p
w(11)=6.532141689422105e-9_p
x(12)=24.54872194552357_p
w(12)=7.327106208821884e-11_p
else if(N==13)then
x(1)=-3.862349594402052_p
w(1)=3.445260581358023e-1_p
x(2)=-3.287897400935986_p
w(2)=7.603902570590076e-1_p
x(3)=-2.309450939118754_p
w(3)=1.047992130482921_p
x(4)=-1.019858635494739_p
w(4)=1.036470725251875_p
x(5)=4.970699036109515e-1_p
w(5)=6.171379531514517e-1_p
x(6)=2.283377114412537_p
w(6)=1.816443138391133e-1_p
x(7)=4.453420483784168_p
w(7)=2.741594641238084e-2_p
x(8)=7.054674225269904_p
w(8)=2.433280180968496e-3_p
x(9)=10.0972721403386_p
w(9)=1.344829663039529e-4_p
x(10)=13.58114776106318_p
w(10)=4.673315193543847e-6_p
x(11)=17.46062735371066_p
w(11)=1.052862126908621e-7_p
x(12)=21.51475041102255_p
w(12)=1.793898073350755e-9_p
x(13)=24.93931957095203_p
w(13)=3.757259047871357e-11_p
else if(N==14)then
x(1)=-3.876588693483423_p
w(1)=3.091532493917526e-1_p
x(2)=-3.359960774021582_p
w(2)=6.873842080317987e-1_p
x(3)=-2.473179795252595_p
w(3)=9.681251630092824e-1_p
x(4)=-1.289884418645675_p
w(4)=1.020705806497166_p
x(5)=1.105696433490099e-1_p
w(5)=7.083657198786049e-1_p
x(6)=1.733886320343950_p
w(6)=2.650982992579566e-1_p
x(7)=3.673945742005875_p
w(7)=5.252283332947559e-2_p
x(8)=5.984769927248199_p
w(8)=6.275502663608311e-3_p
x(9)=8.672806761278212_p
w(9)=4.921571516110575e-4_p
x(10)=11.73234770458913_p
w(10)=2.601373089675539e-5_p
x(11)=15.13629182688367_p
w(11)=9.486479472642528e-7_p
x(12)=18.78801853725605_p
w(12)=2.566372942814093e-8_p
x(13)=22.39558085936057_p
w(13)=6.363826628023913e-10_p
x(14)=25.19637460721017_p
w(14)=2.248873306620266e-11_p
else if(N==15)then
x(1)=-3.888734422814731_p
w(1)=2.789260458277012e-1_p
x(2)=-3.421770318367096_p
w(2)=6.239005869007744e-1_p
x(3)=-2.615184989752403_p
w(3)=8.936267673888665e-1_p
x(4)=-1.527601404777731_p
w(4)=9.885905702043176e-1_p
x(5)=-2.298883130229139e-1_p
w(5)=7.734143902861997e-1_p
x(6)=1.260017080516083_p
w(6)=3.548994653452433e-1_p
x(7)=3.011611460567682_p
w(7)=8.946194687258914e-2_p
x(8)=5.083834204040022_p
w(8)=1.378019316026822e-2_p
x(9)=7.485749747083060_p
w(9)=1.438033790439656e-3_p
x(10)=10.20923307859908_p
w(10)=1.060364501523308e-4_p
x(11)=13.23416225662719_p
w(11)=5.655803958373379e-6_p
x(12)=16.50711779005808_p
w(12)=2.278840801969374e-7_p
x(13)=19.89231411827707_p
w(13)=7.706629221891868e-9_p
x(14)=23.06781943403442_p
w(14)=2.765569364984052e-10_p
x(15)=25.37238952227948_p
w(15)=1.492383717981673e-11_p
else if(N==16)then
x(1)=-3.899176185922089_p
w(1)=2.529005752800732e-1_p
x(2)=-3.475148817894708_p
w(2)=5.684722726255016e-1_p
x(3)=-2.738938750801385_p
w(3)=8.251327919246854e-1_p
x(4)=-1.737500993537280_p
w(4)=9.468734252152634e-1_p
x(5)=-5.320925413015348e-1_p
w(5)=8.131435913721630e-1_p
x(6)=8.459955820233162e-1_p
w(6)=4.427532440670011e-1_p
x(7)=2.441828055849034_p
w(7)=1.383256302691422e-1_p
x(8)=4.314788113053477_p
w(8)=2.664249808228465e-2_p
x(9)=6.479847065177010_p
w(9)=3.536907714469644e-3_p
x(10)=8.929014078901051_p
w(10)=3.426436185940895e-4_p
x(11)=11.64543491593663_p
w(11)=2.488279786196438e-5_p
x(12)=14.5944246693833_p
w(12)=1.397460118514787e-6_p
x(13)=17.70043689881436_p
w(13)=6.455328600945585e-8_p
x(14)=20.8032457235212_p
w(14)=2.781015720081154e-9_p
x(15)=23.58346558504604_p
w(15)=1.406012384139594e-10_p
x(16)=25.49733938301604_p
w(16)=1.063896202751752e-11_p
else if(N==17)then
x(1)=-3.908217398010113_p
w(1)=2.303377021009695e-1_p
x(2)=-3.521540305342855_p
w(2)=5.198694364127197e-1_p
x(3)=-2.847299601943836_p
w(3)=7.626770106471435e-1_p
x(4)=-1.923379892946847_p
w(4)=9.002971018351630e-1_p
x(5)=-8.017874861483368e-1_p
w(5)=8.311793270939808e-1_p
x(6)=4.802224661439583e-1_p
w(6)=5.215375739930858e-1_p
x(7)=1.946206614960815_p
w(7)=1.972067539569060e-1_p
x(8)=3.650981672839380_p
w(8)=4.643299683348943e-2_p
x(9)=5.616284461673621_p
w(9)=7.592913492056432e-3_p
x(10)=7.836366231842546_p
w(10)=9.254093370348419e-4_p
x(11)=10.29641770611097_p
w(11)=8.684446840620085e-5_p
x(12)=12.97118890319705_p
w(12)=6.441677581066887e-6_p
x(13)=15.81291376366392_p
w(13)=3.934678372196030e-7_p
x(14)=18.73003357828091_p
w(14)=2.133402062677550e-8_p
x(15)=21.5520018893168_p
w(15)=1.173709417961232e-9_p
x(16)=23.98280353375124_p
w(16)=8.061094641415514e-11_p
x(17)=25.58887087750958_p
w(17)=7.986224552658518e-12_p
else
call GD(-4)
end if
end subroutine GF_m4

! [-3kT;26kT]
subroutine GF_m3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.899025455227514_p
w(1)=2.236589548505266_p
x(2)=1.474550513117715_p
w(2)=8.119978030633666e-1_p
else if(N==3)then
x(1)=-2.271684295137613_p
w(1)=1.607697189063535_p
x(2)=1.763417402804845e-1_p
w(2)=1.352267584099873_p
x(3)=4.104039115344065_p
w(3)=8.862257840522533e-2_p
else if(N==4)then
x(1)=-2.465650578867492_p
w(1)=1.221920447114345_p
x(2)=-5.388602511301364e-1_p
w(2)=1.502930710593218_p
x(3)=2.306196944106988_p
w(3)=3.182554604536311e-1_p
x(4)=7.066572359294550_p
w(4)=5.480733407438926e-3_p
else if(N==5)then
x(1)=-2.582009101900379_p
w(1)=9.737796902415640e-1_p
x(2)=-1.005297604662584_p
w(2)=1.463810029054032_p
x(3)=1.319251252610928_p
w(3)=5.732435605318550e-1_p
x(4)=4.719486895270760_p
w(4)=3.749411840418738e-2_p
x(5)=10.22777887143619_p
w(5)=2.599533369949375e-4_p
else if(N==6)then
x(1)=-2.658856239560879_p
w(1)=8.036977383784917e-1_p
x(2)=-1.333637304900134_p
w(2)=1.358438818083329_p
x(3)=6.608887555751413e-1_p
w(3)=7.759336489847340e-1_p
x(4)=3.380453441605819_p
w(4)=1.074928679691874e-1_p
x(5)=7.382385409639058_p
w(5)=3.013498336349831e-3_p
x(6)=13.49345487601995_p
w(6)=1.077981654078914e-5_p
else if(N==7)then
x(1)=-2.713586727997865_p
w(1)=6.797828048142459e-1_p
x(2)=-1.578376647536798_p
w(2)=1.238149594857012_p
x(3)=1.727875752135386e-1_p
w(3)=9.085811422638663e-1_p
x(4)=2.472142366895821_p
w(4)=2.089657661367527e-1_p
x(5)=5.676034163996277_p
w(5)=1.290369982146381e-2_p
x(6)=10.16846718942988_p
w(6)=2.038958091477742e-4_p
x(7)=16.72456578055501_p
w(7)=4.478661444432542e-7_p
else if(N==8)then
x(1)=-2.755186155117902_p
w(1)=5.841410628515613e-1_p
x(2)=-1.770677663522342_p
w(2)=1.120032587105037_p
x(3)=-2.163850974574236e-1_p
w(3)=9.799674367300993e-1_p
x(4)=1.788853943033837_p
w(4)=3.278783118990460e-1_p
x(5)=4.467939435714911_p
w(5)=3.526704460279014e-2_p
x(6)=8.079795797004367_p
w(6)=1.287033343883957e-3_p
x(7)=12.91046192428156_p
w(7)=1.385052352701129e-5_p
x(8)=19.6087730115456_p
w(8)=2.451268777088599e-8_p
else if(N==9)then
x(1)=-2.788256333590808_p
w(1)=5.072589153511984e-1_p
x(2)=-1.927410487535451_p
w(2)=1.009542347785873_p
x(3)=-5.405087088009621e-1_p
w(3)=1.003814812912826_p
x(4)=1.240434999692906_p
w(4)=4.486825283290825e-1_p
x(5)=3.539388411407922_p
w(5)=7.431059806735366e-2_p
x(6)=6.558962401790344_p
w(6)=4.849617624016590e-3_p
x(7)=10.44607957082294_p
w(7)=1.274014069863303e-4_p
x(8)=15.42408668507027_p
w(8)=1.127702343180704e-6_p
x(9)=21.79954226343646_p
w(9)=2.388953032817006e-9_p
else if(N==10)then
x(1)=-2.815142985174643_p
w(1)=4.442257704565411e-1_p
x(2)=-2.057288380402484_p
w(2)=9.090848897935744e-1_p
x(3)=-8.152271582711875e-1_p
w(3)=9.934884283097777e-1_p
x(4)=7.850738520597160e-1_p
w(4)=5.568769772683515e-1_p
x(5)=2.796168812199731_p
w(5)=1.309296382958459e-1_p
x(6)=5.380884731284202_p
w(6)=1.332580724818509e-2_p
x(7)=8.638686308496684_p
w(7)=6.416608450645559e-4_p
x(8)=12.66646944283086_p
w(8)=1.405481340913455e-5_p
x(9)=17.58658188733752_p
w(9)=1.240943160523664e-7_p
x(10)=23.24290987376902_p
w(10)=4.435674735044615e-10_p
else if(N==11)then
x(1)=-2.837279503929148_p
w(1)=3.919910451163232e-1_p
x(2)=-2.165808813085788_p
w(2)=8.194524960673251e-1_p
x(3)=-1.049617195047984_p
w(3)=9.609401803571690e-1_p
x(4)=3.996722551658904e-1_p
w(4)=6.427472241973408e-1_p
x(5)=2.186730733356107_p
w(5)=2.017423245505124e-1_p
x(6)=4.437754644203026_p
w(6)=2.940056661644615e-2_p
x(7)=7.236182000729259_p
w(7)=2.222003949680524e-3_p
x(8)=10.63102351864662_p
w(8)=8.963592579126042e-5_p
x(9)=14.67412499752175_p
w(9)=1.855312450066858e-6_p
x(10)=19.35605785915794_p
w(10)=1.933899512227309e-8_p
x(11)=24.1329151574623_p
w(11)=1.365995791626532e-10_p
else if(N==12)then
x(1)=-2.855698013951432_p
w(1)=3.483067943485619e-1_p
x(2)=-2.257151523856218_p
w(2)=7.402898166027266e-1_p
x(3)=-1.250545845316673_p
w(3)=9.155647599338600e-1_p
x(4)=6.908686245016762e-2_p
w(4)=7.027493855067591e-1_p
x(5)=1.677305389930156_p
w(5)=2.802005240982799e-1_p
x(6)=3.665268951666003_p
w(6)=5.513765842434284e-2_p
x(7)=6.110190415956419_p
w(7)=5.947655060466226e-3_p
x(8)=9.042847088685605_p
w(8)=3.764487759117500e-4_p
x(9)=12.48512214423815_p
w(9)=1.399987942813570e-5_p
x(10)=16.43444050276129_p
w(10)=3.046461744563114e-7_p
x(11)=20.75076550231184_p
w(11)=4.233145888132545e-9_p
x(12)=24.68125425065412_p
w(12)=5.897617955881202e-11_p
else if(N==13)then
x(1)=-2.871175124160255_p
w(1)=3.114482252295900e-1_p
x(2)=-2.334613642675505_p
w(2)=6.706773233142270e-1_p
x(3)=-1.423611376358338_p
w(3)=8.639611468145733e-1_p
x(4)=-2.173309243330651e-1_p
w(4)=7.381179157467885e-1_p
x(5)=1.244375169669798_p
w(5)=3.587013051963784e-1_p
x(6)=3.020987139301505_p
w(6)=9.123026377249004e-2_p
x(7)=5.184396584445757_p
w(7)=1.319328874366434e-2_p
x(8)=7.760355238778499_p
w(8)=1.186986520204546e-3_p
x(9)=10.75719480061403_p
w(9)=6.829932674219084e-5_p
x(10)=14.16977493182278_p
w(10)=2.532588485248666e-6_p
x(11)=17.93931032939566_p
w(11)=6.303528511507526e-8_p
x(12)=21.82421674158445_p
w(12)=1.248600345360707e-9_p
x(13)=25.02985446694589_p
w(13)=3.160396070067969e-11_p
else if(N==14)then
x(1)=-2.884300029481774_p
w(1)=2.800872585569610e-1_p
x(2)=-2.400788256229001_p
w(2)=6.095199346349475e-1_p
x(3)=-1.573400664891039_p
w(3)=8.104169677672239e-1_p
x(4)=-4.673564503776196e-1_p
w(4)=7.526984301393069e-1_p
x(5)=8.712569641382988e-1_p
w(5)=4.305474650930807e-1_p
x(6)=2.475412143634378_p
w(6)=1.366562680108191e-1_p
x(7)=4.409410350995159_p
w(7)=2.536307247886352e-2_p
x(8)=6.699766844447527_p
w(8)=3.037606412042436e-3_p
x(9)=9.349329684902871_p
w(9)=2.460760329898116e-4_p
x(10)=12.35071989917766_p
w(10)=1.371533584986607e-5_p
x(11)=15.67054036645579_p
w(11)=5.402985519507484e-7_p
x(12)=19.20128046829639_p
w(12)=1.631848924078735e-8_p
x(13)=22.64170336130064_p
w(13)=4.700239952753788e-10_p
x(14)=25.26068336952491_p
w(14)=1.948313310623219e-11_p
else if(N==15)then
x(1)=-2.895523549814405_p
w(1)=2.531959990652269e-1_p
x(2)=-2.457715444809212_p
w(2)=5.557355869660614e-1_p
x(3)=-1.703670620138934_p
w(3)=7.575515763600263e-1_p
x(4)=-6.868849135522251e-1_p
w(4)=7.511808289924177e-1_p
x(5)=5.459549804568889e-1_p
w(5)=4.911220746514013e-1_p
x(6)=2.007315795077615_p
w(6)=1.888425970645456e-1_p
x(7)=3.751344418995157_p
w(7)=4.355746870851990e-2_p
x(8)=5.807060527393011_p
w(8)=6.633645066622604e-3_p
x(9)=8.176354779341318_p
w(9)=7.096217535223954e-4_p
x(10)=10.85077587954502_p
w(10)=5.470306314480781e-5_p
x(11)=13.80732065686026_p
w(11)=3.107956263378348e-6_p
x(12)=16.9866681305938_p
w(12)=1.365136285622126e-7_p
x(13)=20.24595133171915_p
w(13)=5.179836186270343e-9_p
x(14)=23.26418206797756_p
w(14)=2.142192687867460e-10_p
x(15)=25.41974059216642_p
w(15)=1.319659061997587e-11_p
else if(N==16)then
x(1)=-2.905194374405753_p
w(1)=2.299721088488185e-1_p
x(2)=-2.507008357378909_p
w(2)=5.083334023546431e-1_p
x(3)=-1.817502944141500_p
w(3)=7.068639324260783e-1_p
x(4)=-8.805471648728624e-1_p
w(4)=7.380272931661673e-1_p
x(5)=2.597008119439370e-1_p
w(5)=5.381689042477137e-1_p
x(6)=1.601038877313635_p
w(6)=2.442415752281518e-1_p
x(7)=3.185898449592497_p
w(7)=6.827414529755590e-2_p
x(8)=5.045245892706109_p
w(8)=1.279191017503265e-2_p
x(9)=7.182618363801250_p
w(9)=1.726324314737082e-3_p
x(10)=9.589590245925809_p
w(10)=1.736123647623858e-4_p
x(11)=12.2483203466397_p
w(11)=1.329864948818650e-5_p
x(12)=15.12092802077868_p
w(12)=8.017973447657909e-7_p
x(13)=18.12738153376705_p
w(13)=4.061207141630205e-8_p
x(14)=21.10458417179388_p
w(14)=1.963445572449076e-9_p
x(15)=23.74140427400873_p
w(15)=1.130754702353402e-10_p
x(16)=25.53331162323797_p
w(16)=9.546836285635790e-12_p
else if(N==17)then
x(1)=-2.913585244058061_p
w(1)=2.097833165177040e-1_p
x(2)=-2.549951494366501_p
w(2)=4.664390780088963e-1_p
x(3)=-1.917431765711837_p
w(3)=6.591334794450798e-1_p
x(4)=-1.052084955776581_p
w(4)=7.169862053481321e-1_p
x(5)=5.950682772057832e-3_p
w(5)=5.714329380822413e-1_p
x(6)=1.244831481629909_p
w(6)=2.990823696932759e-1_p
x(7)=2.695047703235398_p
w(7)=9.923096702022785e-2_p
x(8)=4.387829550598390_p
w(8)=2.231433787843332e-2_p
x(9)=6.329656735723804_p
w(9)=3.673655973531129e-3_p
x(10)=8.513079638656254_p
w(10)=4.618051602490233e-4_p
x(11)=10.92330204145605_p
w(11)=4.537321768518332e-5_p
x(12)=13.53349760540054_p
w(12)=3.574525830292440e-6_p
x(13)=16.29315181497504_p
w(13)=2.357067114479932e-7_p
x(14)=19.10809044019764_p
w(14)=1.405197531031349e-8_p
x(15)=21.808642604608_p
w(15)=8.646452410636410e-10_p
x(16)=24.11119692514253_p
w(16)=6.676992193919894e-11_p
x(17)=25.61693789001299_p
w(17)=7.244892690743284e-12_p
else
call GD(-3)
end if
end subroutine GF_m3

! [-2kT;26kT]
subroutine GF_m2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.066219028475456_p
w(1)=1.641101491102072_p
x(2)=2.078600397351406_p
w(2)=4.858265199357910e-1_p
else if(N==3)then
x(1)=-1.367356446559053_p
w(1)=1.231471193360931_p
x(2)=8.549442189886410e-1_p
w(2)=8.501895287320748e-1_p
x(3)=4.795096356090631_p
w(3)=4.526728894485736e-2_p
else if(N==4)then
x(1)=-1.527762945309900_p
w(1)=9.633749003180543e-1_p
x(2)=2.103077119020685e-1_p
w(2)=9.940901381223669e-1_p
x(3)=3.011166336317831_p
w(3)=1.668541758174596e-1_p
x(4)=7.813385674706855_p
w(4)=2.608796779982593e-3_p
else if(N==5)then
x(1)=-1.625884228457906_p
w(1)=7.832958809888985e-1_p
x(2)=-2.012085483042762e-1_p
w(2)=1.013077392979350_p
x(3)=2.042823588089222_p
w(3)=3.126397764486522e-1_p
x(4)=5.477253028929806_p
w(4)=1.779537640627389e-2_p
x(5)=11.00581179573297_p
w(5)=1.195842146884860e-4_p
else if(N==6)then
x(1)=-1.691763125251400_p
w(1)=6.559280073629777e-1_p
x(2)=-4.893459678894342e-1_p
w(2)=9.758378393117596e-1_p
x(3)=1.407304197198371_p
w(3)=4.422303616448786e-1_p
x(4)=4.143411032716916_p
w(4)=5.154994110677130e-2_p
x(5)=8.168358310145331_p
w(5)=1.376970354274069e-3_p
x(6)=14.28294183569733_p
w(6)=4.891257202124876e-6_p
else if(N==7)then
x(1)=-1.739435719366315_p
w(1)=5.606751758289551e-1_p
x(2)=-7.050816794297794e-1_p
w(2)=9.162905502525027e-1_p
x(3)=9.427589206135778e-1_p
w(3)=5.414769803324976e-1_p
x(4)=3.236587310790539_p
w(4)=1.024820262365839e-1_p
x(5)=6.461510093653457_p
w(5)=5.910274015037123e-3_p
x(6)=10.95355550623479_p
w(6)=9.279514148902321e-5_p
x(7)=17.47626194011879_p
w(7)=2.092307980574844e-7_p
else if(N==8)then
x(1)=-1.776190473863726_p
w(1)=4.855393165169873e-1_p
x(2)=-8.759692301226082e-1_p
w(2)=8.488462794001238e-1_p
x(3)=5.763156177371053e-1_p
w(3)=6.097606381969388e-1_p
x(4)=2.554490191180165_p
w(4)=1.658813250550880e-1_p
x(5)=5.248338152497659_p
w(5)=1.630412036148252e-2_p
x(6)=8.856397016805435_p
w(6)=5.898034885626451e-4_p
x(7)=13.65490107769883_p
w(7)=6.515314321527478e-6_p
x(8)=20.23396755792415_p
w(8)=1.270435883091550e-8_p
else if(N==9)then
x(1)=-1.805682570535592_p
w(1)=4.242214029439386e-1_p
x(2)=-1.016069781138751_p
w(2)=7.801074494974286e-1_p
x(3)=2.742274560899302e-1_p
w(3)=6.501676661908515e-1_p
x(4)=2.010662424508545_p
w(4)=2.353368635821843e-1_p
x(5)=4.315760540007033_p
w(5)=3.480152037687420e-2_p
x(6)=7.330599845063476_p
w(6)=2.232472595995313e-3_p
x(7)=11.18741280042368_p
w(7)=6.006779507871126e-5_p
x(8)=16.09205502675837_p
w(8)=5.666173007676900e-7_p
x(9)=22.24585885431621_p
w(9)=1.438211446759691e-9_p
else if(N==10)then
x(1)=-1.829797524820634_p
w(1)=3.734272074875220e-1_p
x(2)=-1.132603786162460_p
w(2)=7.138726611856266e-1_p
x(3)=2.043991479417643e-2_p
w(3)=6.672307803200930e-1_p
x(4)=1.564162188122773_p
w(4)=3.036057175273387e-1_p
x(5)=3.571417670013994_p
w(5)=6.233475104115795e-2_p
x(6)=6.151733866151782_p
w(6)=6.148255290478310e-3_p
x(7)=9.382698384768188_p
w(7)=3.016266698980511e-4_p
x(8)=13.35406995921086_p
w(8)=6.943367055185349e-6_p
x(9)=18.15856690856603_p
w(9)=6.784306599006127e-8_p
x(10)=23.53458874017205_p
w(10)=3.056275528836327e-10_p
else if(N==11)then
x(1)=-1.849741500784610_p
w(1)=3.309872454062023e-1_p
x(2)=-1.230307970703683_p
w(2)=6.521890351424190e-1_p
x(3)=-1.948175971395651e-1_p
w(3)=6.663812039508039e-1_p
x(4)=1.190870601949141_p
w(4)=3.646109452745855e-1_p
x(5)=2.963552102002754_p
w(5)=9.807569813688877e-2_p
x(6)=5.210086502498317_p
w(6)=1.360013479842151e-2_p
x(7)=7.985593327793850_p
w(7)=1.039114425816881e-3_p
x(8)=11.33412611709535_p
w(8)=4.365042904743761e-5_p
x(9)=15.296021584438_p
w(9)=9.718107235336981e-7_p
x(10)=19.82811043244866_p
w(10)=1.155930797574281e-8_p
x(11)=24.32070507031582_p
w(11)=1.036466679747279e-10_p
else if(N==12)then
x(1)=-1.866402900021688_p
w(1)=2.952419495331712e-1_p
x(2)=-1.312832051985455_p
w(2)=5.958701662540105e-1_p
x(3)=-3.787611706461085e-1_p
w(3)=6.528725737925867e-1_p
x(4)=8.743143582863030e-1_p
w(4)=4.146198350672704e-1_p
x(5)=2.458091309733837_p
w(5)=1.397343741385363e-1_p
x(6)=4.440139070101273_p
w(6)=2.563387916813655e-2_p
x(7)=6.865820163552841_p
w(7)=2.766934285555855e-3_p
x(8)=9.759392071625992_p
w(8)=1.809945703091812e-4_p
x(9)=13.13791098717996_p
w(9)=7.131173770439508e-6_p
x(10)=16.98463341045491_p
w(10)=1.702557767034785e-7_p
x(11)=21.13059591563432_p
w(11)=2.751056099933546e-9_p
x(12)=24.80529012791035_p
w(12)=4.768354847944331e-11_p
else if(N==13)then
x(1)=-1.880454930419853_p
w(1)=2.648946047528840e-1_p
x(2)=-1.383053091076923_p
w(2)=5.450156188995321e-1_p
x(3)=-5.370018226651583e-1_p
w(3)=6.310818503113818e-1_p
x(4)=6.027178563753719e-1_p
w(4)=4.522107340958349e-1_p
x(5)=2.031292830163458_p
w(5)=1.842285064177318e-1_p
x(6)=3.799042721362694_p
w(6)=4.278379723255205e-2_p
x(7)=5.946240376259820_p
w(7)=6.113161783731385e-3_p
x(8)=8.488814049081114_p
w(8)=5.642837494859768e-4_p
x(9)=11.43281449453656_p
w(9)=3.405778904885616e-5_p
x(10)=14.76647799666191_p
w(10)=1.357481911918530e-6_p
x(11)=18.41749406222643_p
w(11)=3.762493777571222e-8_p
x(12)=22.12593730263973_p
w(12)=8.721917998142229e-10_p
x(13)=25.11504274069679_p
w(13)=2.663919608046565e-11_p
else if(N==14)then
x(1)=-1.892410828001325_p
w(1)=2.389333442699343e-1_p
x(2)=-1.443234132394823_p
w(2)=4.993644070230398e-1_p
x(3)=-6.739636558432160e-1_p
w(3)=6.043412285785127e-1_p
x(4)=3.674699152603350e-1_p
w(4)=4.776827866308177e-1_p
x(5)=1.666172169318794_p
w(5)=2.283934364219223e-1_p
x(6)=3.257288742388499_p
w(6)=6.492512810266694e-2_p
x(7)=5.177159665844528_p
w(7)=1.172964485241034e-2_p
x(8)=7.438859256024915_p
w(8)=1.429996113416652e-3_p
x(9)=10.04333304579225_p
w(9)=1.205897495972709e-4_p
x(10)=12.9801305213423_p
w(10)=7.133009000233079e-6_p
x(11)=16.20889183065387_p
w(11)=3.055514989687290e-7_p
x(12)=19.61167875625994_p
w(12)=1.036986559558758e-8_p
x(13)=22.88084640402786_p
w(13)=3.482912733113829e-10_p
x(14)=25.3215519516562_p
w(14)=1.688935925742119e-11_p
else if(N==15)then
x(1)=-1.902665249795695_p
w(1)=2.165657702222530e-1_p
x(2)=-1.495159640183072_p
w(2)=4.584953273551927e-1_p
x(3)=-7.931742992738160e-1_p
w(3)=5.750426390256625e-1_p
x(4)=1.621185121816095e-1_p
w(4)=4.923696454088208e-1_p
x(5)=1.350322770806791_p
w(5)=2.695289640355700e-1_p
x(6)=2.793769521548996_p
w(6)=9.129380867126048e-2_p
x(7)=4.524640231652281_p
w(7)=2.016194859229034e-2_p
x(8)=6.555661547914919_p
w(8)=3.097683175652961e-3_p
x(9)=8.885850898841756_p
w(9)=3.426654296590527e-4_p
x(10)=11.50543719102446_p
w(10)=2.778301162923308e-5_p
x(11)=14.38772614033447_p
w(11)=1.691013471730390e-6_p
x(12)=17.46743272856363_p
w(12)=8.143448423141007e-8_p
x(13)=20.59557051882701_p
w(13)=3.483898517542109e-9_p
x(14)=23.45470414451061_p
w(14)=1.663522009237181e-10_p
x(15)=25.46480649909514_p
w(15)=1.166557005067360e-11_p
else if(N==16)then
x(1)=-1.911524928724931_p
w(1)=1.971669068754176e-1_p
x(2)=-1.540245330147349_p
w(2)=4.219343735660436e-1_p
x(3)=-8.974759597858233e-1_p
w(3)=5.448288124664723e-1_p
x(4)=-1.829344406473854e-2_p
w(4)=4.980693538538438e-1_p
x(5)=1.074507558014066_p
w(5)=3.056968924791930e-1_p
x(6)=2.392937515216183_p
w(6)=1.206409245140890e-1_p
x(7)=3.964468378848350_p
w(7)=3.173696492151947e-2_p
x(8)=5.802357378986963_p
w(8)=5.936637412343417e-3_p
x(9)=7.905507087976368_p
w(9)=8.231721544968920e-4_p
x(10)=10.26486334286506_p
w(10)=8.646636074113595e-5_p
x(11)=12.86071921359348_p
w(11)=7.022611315451857e-6_p
x(12)=15.65170213429975_p
w(12)=4.568415630852620e-7_p
x(13)=18.55359481529088_p
w(13)=2.549324960527325e-8_p
x(14)=21.40155470883395_p
w(14)=1.387921196286578e-9_p
x(15)=23.89462600334531_p
w(15)=9.109454319908861e-11_p
x(16)=25.56771530027099_p
w(16)=8.559288082799931e-12_p
else if(N==17)then
x(1)=-1.919230874956865_p
w(1)=1.802397295085252e-1_p
x(2)=-1.579622656691457_p
w(2)=3.892102902236177e-1_p
x(3)=-9.891789963950419e-1_p
w(3)=5.147842527138836e-1_p
x(4)=-1.776634453307627e-1_p
w(4)=4.966549002841249e-1_p
x(5)=8.317239232894986e-1_p
w(5)=3.357847156751664e-1_p
x(6)=2.043078326126096_p
w(6)=1.514598278182629e-1_p
x(7)=3.478775607815571_p
w(7)=4.649420850877367e-2_p
x(8)=5.152581766735775_p
w(8)=1.031532057449842e-2_p
x(9)=7.064293908629955_p
w(9)=1.733058171919929e-3_p
x(10)=9.205774699451981_p
w(10)=2.262069713668851e-4_p
x(11)=11.56142063694674_p
w(11)=2.338450665561925e-5_p
x(12)=14.10238520997075_p
w(12)=1.965598608795238e-6_p
x(13)=16.7754204081064_p
w(13)=1.405359783164541e-7_p
x(14)=19.48421957386335_p
w(14)=9.246766094391851e-9_p
x(15)=22.06103307300926_p
w(15)=6.377902342238602e-10_p
x(16)=24.23583707083976_p
w(16)=5.536042131045937e-11_p
x(17)=25.64389475050649_p
w(17)=6.564286880691046e-12_p
else
call GD(-2)
end if
end subroutine GF_m2

! [-1kT;26kT]
subroutine GF_m1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.078062749716404e-1_p
w(1)=1.057155726440605_p
x(2)=2.782863676349124_p
w(2)=2.561059610725085e-1_p
else if(N==3)then
x(1)=-4.522748549203163e-1_p
w(1)=8.263515810954380e-1_p
x(2)=1.608262876680297_p
w(2)=4.657804528177026e-1_p
x(3)=5.568714732352236_p
w(3)=2.112965359997306e-2_p
else if(N==4)then
x(1)=-5.846830243635545e-1_p
w(1)=6.659065726224812e-1_p
x(2)=1.010127158965967_p
w(2)=5.673827896458726e-1_p
x(3)=3.796785611823982_p
w(3)=7.881242810975832e-2_p
x(4)=8.626621171765091_p
w(4)=1.159897135001596e-3_p
else if(N==5)then
x(1)=-6.670207128882626e-1_p
w(1)=5.532376358345554e-1_p
x(2)=6.363364036518769e-1_p
w(2)=6.009059484749973e-1_p
x(3)=2.840491247425049_p
w(3)=1.511967846707159e-1_p
x(4)=6.300223957838000_p
w(4)=7.869372443202840e-3_p
x(5)=11.84040150912881_p
w(5)=5.194608964224285e-5_p
else if(N==6)then
x(1)=-7.231639570966520e-1_p
w(1)=4.707515451174793e-1_p
x(2)=3.770555703338821e-1_p
w(2)=5.987427507937712e-1_p
x(3)=2.217800904820309_p
w(3)=2.202837797810377e-1_p
x(4)=4.970435566015730_p
w(4)=2.288575361257952e-2_p
x(5)=9.007092763721616_p
w(5)=5.957388527634081e-4_p
x(6)=15.11716420858695_p
w(6)=2.119355482688964e-6_p
else if(N==7)then
x(1)=-7.644466433630976e-1_p
w(1)=4.071966745871590e-1_p
x(2)=1.829440916126228e-1_p
w(2)=5.787283728663282e-1_p
x(3)=1.765638363683252_p
w(3)=2.786454277045685e-1_p
x(4)=4.062936980562905_p
w(4)=4.608384899157691e-2_p
x(5)=7.296290045470172_p
w(5)=2.566740439872518e-3_p
x(6)=11.77774548394164_p
w(6)=4.052757550977577e-5_p
x(7)=18.24804127682054_p
w(7)=9.534809878067149e-8_p
else if(N==8)then
x(1)=-7.967120924416659e-1_p
w(1)=3.558313908371182e-1_p
x(2)=2.873542491847759e-2_p
w(2)=5.495692229450990e-1_p
x(3)=1.411504111649458_p
w(3)=3.244506221062551e-1_p
x(4)=3.379131786792493_p
w(4)=7.601435802971450e-2_p
x(5)=6.076555516648046_p
w(5)=7.133221199171778e-3_p
x(6)=9.669548342692803_p
w(6)=2.598818356938276e-4_p
x(7)=14.42273512218854_p
w(7)=2.983972324609301e-6_p
x(8)=20.84919632727847_p
w(8)=6.587736694203927e-9_p
else if(N==9)then
x(1)=-8.228183842039382e-1_p
w(1)=3.132000170504302e-1_p
x(2)=-9.780666802194464e-2_p
w(2)=5.159745389971736e-1_p
x(3)=1.122490599493145_p
w(3)=3.574679406632134e-1_p
x(4)=2.836127022027346_p
w(4)=1.102632476184307e-1_p
x(5)=5.140017189589426_p
w(5)=1.534060955063143e-2_p
x(6)=8.138647513175879_p
w(6)=9.875325430671847e-4_p
x(7)=11.95453769764988_p
w(7)=2.751956097923524e-5_p
x(8)=16.76986943553875_p
w(8)=2.806527982372622e-7_p
x(9)=22.66986030964472_p
w(9)=8.763897851101654e-10_p
else if(N==10)then
x(1)=-8.442782018648574e-1_p
w(1)=2.774498816519645e-1_p
x(2)=-2.030703767019657e-1_p
w(2)=4.809923101588598e-1_p
x(3)=8.821808206260835e-1_p
w(3)=3.784731580210183e-1_p
x(4)=2.393582370562541_p
w(4)=1.457847842128006e-1_p
x(5)=4.394823236452725_p
w(5)=2.770026522595781e-2_p
x(6)=6.959601463529663_p
w(6)=2.720342027499515e-3_p
x(7)=10.15420518123964_p
w(7)=1.375466349269154e-4_p
x(8)=14.0582744131603_p
w(8)=3.362471679522225e-6_p
x(9)=18.7306761569093_p
w(9)=3.689544139350242e-8_p
x(10)=23.80712694512409_p
w(10)=2.129653613349112e-10_p
else if(N==11)then
x(1)=-8.621054771900208e-1_p
w(1)=2.472736995264402e-1_p
x(2)=-2.913897379668590e-1_p
w(2)=4.465381637052538e-1_p
x(3)=6.800505643752145e-1_p
w(3)=3.891622871235502e-1_p
x(4)=2.026650058023743_p
w(4)=1.797576457871491e-1_p
x(5)=3.788258917114312_p
w(5)=4.402494552030939e-2_p
x(6)=6.020240711289819_p
w(6)=6.012929400539002e-3_p
x(7)=8.763674423837827_p
w(7)=4.707300345500906e-4_p
x(8)=12.05713583087747_p
w(8)=2.077678535133545e-5_p
x(9)=15.92686334066669_p
w(9)=5.026396510722455e-7_p
x(10)=20.29460617384351_p
w(10)=6.911115558361100e-9_p
x(11)=24.4957141042728_p
w(11)=7.920402915783601e-11_p
else if(N==12)then
x(1)=-8.770597947431589e-1_p
w(1)=2.216308688338791e-1_p
x(2)=-3.660932186637278e-1_p
w(2)=4.136900153554658e-1_p
x(3)=5.083837173445839e-1_p
w(3)=3.916187803987792e-1_p
x(4)=1.718059547979721_p
w(4)=2.101172992967181e-1_p
x(5)=3.285626468579161_p
w(5)=6.353796607863142e-2_p
x(6)=5.253663017014081_p
w(6)=1.133330370678276e-2_p
x(7)=7.651079804508167_p
w(7)=1.244884823264971e-3_p
x(8)=10.49779425811598_p
w(8)=8.489980962883334e-5_p
x(9)=13.80412170063043_p
w(9)=3.572895185866108e-6_p
x(10)=17.53794460774376_p
w(10)=9.448323321170667e-8_p
x(11)=21.50263373982099_p
w(11)=1.792850287135712e-9_p
x(12)=24.92134355262456_p
w(12)=3.869423177956527e-11_p
else if(N==13)then
x(1)=-8.897196737055484e-1_p
w(1)=1.996902405611412e-1_p
x(2)=-4.297747893647494e-1_p
w(2)=3.829816543265504e-1_p
x(3)=3.613414684502771e-1_p
w(3)=3.878692049771595e-1_p
x(4)=1.455382182994019_p
w(4)=2.356560264862548e-1_p
x(5)=2.862877826760962_p
w(5)=8.510312591452569e-2_p
x(6)=4.616439512024384_p
w(6)=1.894934429094692e-2_p
x(7)=6.738622716260484_p
w(7)=2.733348180812233e-3_p
x(8)=9.240474921465882_p
w(8)=2.613359328945734e-4_p
x(9)=12.12453867621162_p
w(9)=1.666443753506769e-5_p
x(10)=15.3713065550385_p
w(10)=7.193846580616288e-7_p
x(11)=18.8948866881109_p
w(11)=2.238687858854975e-8_p
x(12)=22.41981560556568_p
w(12)=6.112709009858944e-10_p
x(13)=25.1952340176762_p
w(13)=2.248573282390918e-11_p
else if(N==14)then
x(1)=-9.005280970284187e-1_p
w(1)=1.807918175694641e-1_p
x(2)=-4.844598849087171e-1_p
w(2)=3.546178783622669e-1_p
x(3)=2.344408349067355e-1_p
w(3)=3.796686128609237e-1_p
x(4)=1.229490732843599_p
w(4)=2.559041516096755e-1_p
x(5)=2.502829573258370_p
w(5)=1.074685473310664e-1_p
x(6)=4.078858196751525_p
w(6)=2.887574441922329e-2_p
x(7)=5.976348661542532_p
w(7)=5.218315986979989e-3_p
x(8)=8.202214056725749_p
w(8)=6.548960577022649e-4_p
x(9)=10.75524085816661_p
w(9)=5.788754763386051e-5_p
x(10)=13.6208363331591_p
w(10)=3.657387721255812e-6_p
x(11)=16.75130984738388_p
w(11)=1.715226763363622e-7_p
x(12)=20.01903545499665_p
w(12)=6.584320248949409e-9_p
x(13)=23.11309667739729_p
w(13)=2.588187521379356e-10_p
x(14)=25.37920717652353_p
w(14)=1.464117577282550e-11_p
else if(N==15)then
x(1)=-9.098273249548683e-1_p
w(1)=1.644107511093392e-1_p
x(2)=-5.317397966529898e-1_p
w(2)=3.286123261614773e-1_p
x(3)=1.241880971503126e-1_p
w(3)=3.684372233538263e-1_p
x(4)=1.033542370945913_p
w(4)=2.709342920654384e-1_p
x(5)=2.192887336506795_p
w(5)=1.294645229566316e-1_p
x(6)=3.619768615282769_p
w(6)=4.088190211247670e-2_p
x(7)=5.330239774383387_p
w(7)=8.939069268511665e-3_p
x(8)=7.329455344568752_p
w(8)=1.404889409596239e-3_p
x(9)=9.614573503252544_p
w(9)=1.618655781491892e-4_p
x(10)=12.17356276326064_p
w(10)=1.388407357076537e-5_p
x(11)=14.9755311167452_p
w(11)=9.105804288777579e-7_p
x(12)=17.94936643774139_p
w(12)=4.835976756111045e-8_p
x(13)=20.94111538005037_p
w(13)=2.344151963237130e-9_p
x(14)=23.63954657633058_p
w(14)=1.294441654114044e-10_p
x(15)=25.50773563327509_p
w(15)=1.030381040452203e-11_p
else if(N==16)then
x(1)=-9.178846246614263e-1_p
w(1)=1.501274499611032e-1_p
x(2)=-5.728751580522379e-1_p
w(2)=3.048726803810424e-1_p
x(3)=2.782148323220536e-2_p
w(3)=3.552736774897005e-1_p
x(4)=8.623018595194439e-1_p
w(4)=2.811640104739531e-1_p
x(5)=1.923615350897257_p
w(5)=1.501298878865127e-1_p
x(6)=3.223637695775780_p
w(6)=5.454392100031585e-2_p
x(7)=4.776094622460186_p
w(7)=1.405008466382777e-2_p
x(8)=6.585535387372373_p
w(8)=2.670237738908035e-3_p
x(9)=8.648675584144874_p
w(9)=3.834914336738306e-4_p
x(10)=10.95518207934979_p
w(10)=4.230877840444638e-5_p
x(11)=13.48289519177452_p
w(11)=3.662292169729661e-6_p
x(12)=16.18684439491685_p
w(12)=2.583881543064929e-7_p
x(13)=18.97906382905563_p
w(13)=1.596226833001063e-8_p
x(14)=21.69419470901566_p
w(14)=9.819393006024923e-10_p
x(15)=24.04330598746258_p
w(15)=7.347659100060116e-11_p
x(16)=25.60065013607219_p
w(16)=7.663808406969051e-12_p
else if(N==17)then
x(1)=-9.249109356126689e-1_p
w(1)=1.376042369890449e-1_p
x(2)=-6.088733377635791e-1_p
w(2)=2.832525151042240e-1_p
x(3)=-5.686963992270149e-2_p
w(3)=3.410001341191439e-1_p
x(4)=7.116885062689149e-1_p
w(4)=2.871928918644976e-1_p
x(5)=1.687808319109326_p
w(5)=1.687679744436159e-1_p
x(6)=2.878771275086780_p
w(6)=6.931855170346297e-2_p
x(7)=4.296105491951744_p
w(7)=2.059731732032301e-2_p
x(8)=5.944240785199050_p
w(8)=4.608574498431206e-3_p
x(9)=7.820113941202061_p
w(9)=7.977221905728475e-4_p
x(10)=9.914734922711780_p
w(10)=1.087261736225439e-4_p
x(11)=12.21108372759549_p
w(11)=1.188253304978022e-5_p
x(12)=14.67805395088461_p
w(12)=1.070606125750074e-6_p
x(13)=17.25979906492758_p
w(13)=8.336733532439463e-8_p
x(14)=19.85845297479945_p
w(14)=6.076925152586276e-9_p
x(15)=22.30926934284202_p
w(15)=4.708760343216539e-10_p
x(16)=24.35688698846114_p
w(16)=4.592482669385898e-11_p
x(17)=25.66981063916529_p
w(17)=5.937972172204149e-12_p
else
call GD(-1)
end if
end subroutine GF_m1

! [0kT;26kT]
subroutine GF_0(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=6.905392401050940e-1_p
w(1)=5.746633415044964e-1_p
x(2)=3.592383987039436_p
w(2)=1.184838390503399e-1_p
else if(N==3)then
x(1)=4.840529149754196e-1_p
w(1)=4.633601903151416e-1_p
x(2)=2.446742038498063_p
w(2)=2.207497108617890e-1_p
x(3)=6.424343267584341_p
w(3)=9.037279377905608e-3_p
else if(N==4)then
x(1)=3.712652828908716e-1_p
w(1)=3.825306691031065e-1_p
x(2)=1.875381108238723_p
w(2)=2.763056778109154e-1_p
x(3)=4.661326476730985_p
w(3)=3.382909081697028e-2_p
x(4)=9.506713968373552_p
w(4)=4.817428238440503e-4_p
else if(N==5)then
x(1)=3.003739130688435e-1_p
w(1)=3.237178567254538e-1_p
x(2)=1.523638361670508_p
w(2)=3.005042074594810e-1_p
x(3)=3.712348282801855_p
w(3)=6.565018653077363e-2_p
x(4)=7.186847893447545_p
w(4)=3.253628866929599e-3_p
x(5)=12.73193536003653_p
w(5)=2.130097219822612e-5_p
else if(N==6)then
x(1)=2.514478891587711e-1_p
w(1)=2.793402942770417e-1_p
x(2)=1.281462025255314_p
w(2)=3.068320529236597e-1_p
x(3)=3.095731885142101_p
w(3)=9.724712687612559e-2_p
x(4)=5.858180680800336_p
w(4)=9.482392143243765e-3_p
x(5)=9.897207347253245_p
w(5)=2.444355446402317e-4_p
x(6)=15.99339986355285_p
w(6)=8.787901252404063e-7_p
else if(N==7)then
x(1)=2.149738673211855e-1_p
w(1)=2.441865796987944e-1_p
x(2)=1.100289985162921_p
w(2)=3.031555824317053e-1_p
x(3)=2.648181353208393_p
w(3)=1.254745495154472e-1_p
x(4)=4.947098378966986_p
w(4)=1.925275538788999e-2_p
x(5)=8.177672242396053_p
w(5)=1.060640797193178e-3_p
x(6)=12.63803525830903_p
w(6)=1.703005176076773e-5_p
x(7)=19.03129949547928_p
w(7)=4.267204536723613e-8_p
else if(N==8)then
x(1)=1.861605328517636e-1_p
w(1)=2.151440962687325e-1_p
x(2)=9.564048649314045e-1_p
w(2)=2.935871193732724e-1_p
x(3)=2.298773016123708_p
w(3)=1.492202053250996e-1_p
x(4)=4.259315351460167_p
w(4)=3.211404230021156e-2_p
x(5)=6.949207927022382_p
w(5)=2.970005204821712e-3_p
x(6)=10.51669916645829_p
w(6)=1.103735451441174e-4_p
x(7)=15.2099327111551_p
w(7)=1.335096632100016e-6_p
x(8)=21.4459268318336_p
w(8)=3.440922219679913e-9_p
else if(N==9)then
x(1)=1.627178859977094e-1_p
w(1)=1.906786326226473e-1_p
x(2)=8.386856437589533e-1_p
w(2)=2.805451410224994e-1_p
x(3)=2.015771233783469_p
w(3)=1.679243162376717e-1_p
x(4)=3.714958516325452_p
w(4)=4.714673025328932e-2_p
x(5)=6.008201093047375_p
w(5)=6.419004340682035e-3_p
x(6)=8.980628588067958_p
w(6)=4.209385384294099e-4_p
x(7)=12.74481774453429_p
w(7)=1.227949726300071e-5_p
x(8)=17.45345624277791_p
w(8)=1.375001542752225e-7_p
x(9)=23.06792441933164_p
w(9)=5.421998443274934e-10_p
else if(N==10)then
x(1)=1.433817048205835e-1_p
w(1)=1.699309851114087e-1_p
x(2)=7.410768770879913e-1_p
w(2)=2.656997889717392e-1_p
x(3)=1.782458989739190_p
w(3)=1.815210319128506e-1_p
x(4)=3.273657925396922_p
w(4)=6.314253284256721e-2_p
x(5)=5.262044398141651_p
w(5)=1.163158619624006e-2_p
x(6)=7.801701801249838_p
w(6)=1.158657536456746e-3_p
x(7)=10.95095503837026_p
w(7)=6.097784372251986e-5_p
x(8)=14.77632847699553_p
w(8)=1.599971554099283e-6_p
x(9)=19.29938244823657_p
w(9)=2.001811059375109e-8_p
x(10)=24.05977382023235_p
w(10)=1.501864849204304e-10_p
else if(N==11)then
x(1)=1.272690681115515e-1_p
w(1)=1.522487873463132e-1_p
x(2)=6.593533702020812e-1_p
w(2)=2.501869785431763e-1_p
x(3)=1.587679630222902_p
w(3)=1.904320934915277e-1_p
x(4)=2.909763973283455_p
w(4)=7.895256708973475e-2_p
x(5)=4.656564747230175_p
w(5)=1.855497188607242e-2_p
x(6)=6.864965754341719_p
w(6)=2.554779165088474e-3_p
x(7)=9.568193249134975_p
w(7)=2.070562542287622e-4_p
x(8)=12.7978168285755_p
w(8)=9.685285729335953e-6_p
x(9)=16.5639769966153_p
w(9)=2.572899286361789e-7_p
x(10)=20.75293536594161_p
w(10)=4.142080040942973e-9_p
x(11)=24.65797112525142_p
w(11)=6.095654692078343e-11_p
else if(N==12)then
x(1)=1.137128554019770e-1_p
w(1)=1.370944528721764e-1_p
x(2)=5.903056834358746e-1_p
w(2)=2.347315262679810e-1_p
x(3)=1.423279191049824_p
w(3)=1.953424341646083e-1_p
x(4)=2.605384211371408_p
w(4)=9.368448721948586e-2_p
x(5)=4.156232654478252_p
w(5)=2.690753863799745e-2_p
x(6)=6.102110408171574_p
w(6)=4.802758096045604e-3_p
x(7)=8.463570209091495_p
w(7)=5.432385333804165e-4_p
x(8)=11.25602318560113_p
w(8)=3.892730364475135e-5_p
x(9)=14.48157282973943_p
w(9)=1.764085825935225e-6_p
x(10)=18.09201591910016_p
w(10)=5.216891767198128e-8_p
x(11)=21.86517952824594_p
w(11)=1.173263864112733e-9_p
x(12)=25.02953378455678_p
w(12)=3.150895056275005e-11_p
else if(N==13)then
x(1)=1.022043730787481e-1_p
w(1)=1.240299424320320e-1_p
x(2)=5.314706984728024e-1_p
w(2)=2.197711464794065e-1_p
x(3)=1.283171276628604_p
w(3)=1.970057733356487e-1_p
x(4)=2.347660014112185_p
w(4)=1.067484965324369e-1_p
x(5)=3.736587780845233_p
w(5)=3.626683288763698e-2_p
x(6)=5.469080436499115_p
w(6)=8.014573262986161e-3_p
x(7)=7.558855862315274_p
w(7)=1.183861650455355e-3_p
x(8)=10.01333786978138_p
w(8)=1.181480904547857e-4_p
x(9)=12.83044897541566_p
w(9)=8.014568908653071e-6_p
x(10)=15.98223503548988_p
w(10)=3.775665452999032e-7_p
x(11)=19.36957300097786_p
w(11)=1.329915905420015e-8_p
x(12)=22.70482225932955_p
w(12)=4.301631298279390e-10_p
x(13)=25.27050880578425_p
w(13)=1.900277124551896e-11_p
else if(N==14)then
x(1)=9.235333809708979e-2_p
w(1)=1.127015238249110e-1_p
x(2)=4.809461658988540e-1_p
w(2)=2.055529290606263e-1_p
x(3)=1.162745836420992_p
w(3)=1.961354973076625e-1_p
x(4)=2.127149892100757_p
w(4)=1.178289001577295e-1_p
x(5)=3.380218079567023_p
w(5)=4.615882357937598e-2_p
x(6)=4.935885036489368_p
w(6)=1.220281619467411e-2_p
x(7)=6.803930420755734_p
w(7)=2.245018506251834e-3_p
x(8)=8.987741332398953_p
w(8)=2.924542609957950e-4_p
x(9)=11.48325414684827_p
w(9)=2.726583343891764e-5_p
x(10)=14.27104339288458_p
w(10)=1.851723016065966e-6_p
x(11)=17.29600849291975_p
w(11)=9.571828778988236e-8_p
x(12)=20.42188615352837_p
w(12)=4.182218974158436e-9_p
x(13)=23.33784218096485_p
w(13)=1.929572975123437e-10_p
x(14)=25.43369005231528_p
w(14)=1.269021708527986e-11_p
else if(N==15)then
x(1)=8.385737155449952e-2_p
w(1)=1.028236427792989e-1_p
x(2)=4.372487836988901e-1_p
w(2)=1.922004569500470e-1_p
x(3)=1.058455695812098_p
w(3)=1.933553038245888e-1_p
x(4)=1.936775540496875_p
w(4)=1.268261295246971e-1_p
x(5)=3.074376813037621_p
w(5)=5.612853953483524e-2_p
x(6)=4.481252565779942_p
w(6)=1.728637949693287e-2_p
x(7)=6.164724556635299_p
w(7)=3.823830680552570e-3_p
x(8)=8.126170833592148_p
w(8)=6.206172261610737e-4_p
x(9)=10.36074314427349_p
w(9)=7.492729824535438e-5_p
x(10)=12.85349671914424_p
w(10)=6.836975477786940e-6_p
x(11)=15.56910235454702_p
w(11)=4.859499784076314e-7_p
x(12)=18.43096260249071_p
w(12)=2.862476793421743e-8_p
x(13)=21.28150716267524_p
w(13)=1.579211212623616e-9_p
x(14)=23.81833736687161_p
w(14)=1.009498596660390e-10_p
x(15)=25.5485447452416_p
w(15)=9.092083168016428e-12_p
else if(N==16)then
x(1)=7.647964060142477e-2_p
w(1)=9.416495306384913e-2_p
x(2)=3.992096839666745e-1_p
w(2)=1.797589918951191e-1_p
x(3)=9.675301772098099e-1_p
w(3)=1.891843266711439e-1_p
x(4)=1.771127339181687_p
w(4)=1.337934634016001e-1_p
x(5)=2.809509325323258_p
w(5)=6.578544257462447e-2_p
x(6)=4.089601773608849_p
w(6)=2.311147645654469e-2_p
x(7)=5.617041385574031_p
w(7)=5.982809459185032e-3_p
x(8)=7.392259732369816_p
w(8)=1.168412758256872e-3_p
x(9)=9.410287012638525_p
w(9)=1.748907843405029e-4_p
x(10)=11.65895547650026_p
w(10)=2.036889576472934e-5_p
x(11)=14.11333071914722_p
w(11)=1.888605712936468e-6_p
x(12)=16.72491051916893_p
w(12)=1.452476868040226e-7_p
x(13)=19.40255920628787_p
w(13)=9.979108545421709e-9_p
x(14)=21.98172296396882_p
w(14)=6.957046734459132e-10_p
x(15)=24.18720721495303_p
w(15)=5.934281130617686e-11_p
x(16)=25.63211992755027_p
w(16)=6.851867842882091e-12_p
else if(N==17)then
x(1)=7.003266899783114e-2_p
w(1)=8.653706706986471e-2_p
x(2)=3.658983460143428e-1_p
w(2)=1.682254460885441e-1_p
x(3)=8.877757412517711e-1_p
w(3)=1.840403746423707e-1_p
x(4)=1.625999468854342_p
w(4)=1.388809066624599e-1_p
x(5)=2.578308942840275_p
w(5)=7.482536339364276e-2_p
x(6)=3.749221878345899_p
w(6)=2.947903336683871e-2_p
x(7)=5.143106608021420_p
w(7)=8.742009476634940e-3_p
x(8)=6.759995578457525_p
w(8)=1.999926970471199e-3_p
x(9)=8.595159132552023_p
w(9)=3.591022086744496e-4_p
x(10)=10.63837575934902_p
w(10)=5.135804970000820e-5_p
x(11)=12.87084578821541_p
w(11)=5.960722822001433e-6_p
x(12)=15.25913340471688_p
w(12)=5.782658990912627e-7_p
x(13)=17.7450428898138_p
w(13)=4.925373031374820e-8_p
x(14)=20.22980966469953_p
w(14)=3.991619463315859e-9_p
x(15)=22.55278640533525_p
w(15)=3.480847172905290e-10_p
x(16)=24.47418680149861_p
w(16)=3.811735153997399e-11_p
x(17)=25.69468296122353_p
w(17)=5.361838694729426e-12_p
else
call GD(0)
end if
end subroutine GF_0

! [1kT;26kT]
subroutine GF_1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=1.631825426536777_p
w(1)=2.640326442779364e-1_p
x(2)=4.490326987652996_p
w(2)=4.922904323517730e-2_p
else if(N==3)then
x(1)=1.446128728026491_p
w(1)=2.168206532777367e-1_p
x(2)=3.359531550875918_p
w(2)=9.283941179091679e-2_p
x(3)=7.347292943956069_p
w(3)=3.601622444460266e-3_p
else if(N==4)then
x(1)=1.344392900370686_p
w(1)=1.816877487124497e-1_p
x(2)=2.801446947352973_p
w(2)=1.178959349166650e-1_p
x(3)=5.589476037664729_p
w(3)=1.348885688528993e-2_p
x(4)=10.44222234783222_p
w(4)=1.891469987091769e-4_p
else if(N==5)then
x(1)=1.280084933236775_p
w(1)=1.555637511609894e-1_p
x(2)=2.460488055465709_p
w(2)=1.301054453310583e-1_p
x(3)=4.643963278051605_p
w(3)=2.630914424178017e-2_p
x(4)=8.124901740323034_p
w(4)=1.275013039443237e-3_p
x(5)=13.66975450294498_p
w(5)=8.333739842582532e-6_p
else if(N==6)then
x(1)=1.235318600854552_p
w(1)=1.354331570345370e-1_p
x(2)=2.226312131160851_p
w(2)=1.346965492254252e-1_p
x(3)=4.028652271782063_p
w(3)=3.930719288735487e-2_p
x(4)=6.793394768249437_p
w(4)=3.728210994819209e-3_p
x(5)=10.827157683526_p
w(5)=9.622406143849473e-5_p
x(6)=16.89760249086242_p
w(6)=3.533095389267159e-7_p
else if(N==7)then
x(1)=1.201593052698973_p
w(1)=1.191546155439797e-1_p
x(2)=2.050852556843477_p
w(2)=1.347821616307004e-1_p
x(3)=3.580637887290647_p
w(3)=5.127073980377746e-2_p
x(4)=5.875455314303588_p
w(4)=7.625080655483679e-3_p
x(5)=9.094030912960992_p
w(5)=4.221040672094041e-4_p
x(6)=13.52218036704318_p
w(6)=6.966753481962994e-6_p
x(7)=19.80792300312535_p
w(7)=1.905848118758464e-8_p
else if(N==8)then
x(1)=1.174780134012068_p
w(1)=1.055043525728314e-1_p
x(2)=1.911642119766373_p
w(2)=1.320374279755909e-1_p
x(3)=3.231273846461499_p
w(3)=6.166768526899807e-2_p
x(4)=5.181816589617490_p
w(4)=1.281414094772296e-2_p
x(5)=7.855016579129556_p
w(5)=1.191832698724101e-3_p
x(6)=11.38731831497471_p
w(6)=4.565617053793663e-5_p
x(7)=16.00486577000795_p
w(7)=5.900463879612484e-7_p
x(8)=22.01102008726066_p
w(8)=1.832320414916467e-9_p
else if(N==9)then
x(1)=1.152925528761003_p
w(1)=9.390166042759213e-2_p
x(2)=1.798237620593061_p
w(2)=1.274995863369308e-1_p
x(3)=2.949880189803795_p
w(3)=7.016388555963654e-2_p
x(4)=4.634759840870005_p
w(4)=1.893066010568301e-2_p
x(5)=6.909110377175975_p
w(5)=2.585819137963098e-3_p
x(6)=9.846833126132720_p
w(6)=1.746216558335946e-4_p
x(7)=13.54866473272956_p
w(7)=5.386675994635760e-6_p
x(8)=18.13282163327176_p
w(8)=6.727084407257685e-8_p
x(9)=23.43444687841033_p
w(9)=3.426358926226532e-10_p
else if(N==10)then
x(1)=1.134887542658577_p
w(1)=8.399605418526668e-2_p
x(2)=1.704619317119012_p
w(2)=1.219110305113432e-1_p
x(3)=2.719340370929573_p
w(3)=7.665689927379252e-2_p
x(4)=4.193222264277715_p
w(4)=2.549879930291434e-2_p
x(5)=6.161823651409434_p
w(5)=4.691760745097000e-3_p
x(6)=8.668620705080192_p
w(6)=4.798684635874934e-4_p
x(7)=11.76421468461466_p
w(7)=2.650966246234558e-5_p
x(8)=15.49961148070372_p
w(8)=7.543424531701969e-7_p
x(9)=19.85680038086369_p
w(9)=1.091870061700065e-8_p
x(10)=24.29055296911444_p
w(10)=1.074963996240358e-10_p
else if(N==11)then
x(1)=1.119844942819562_p
w(1)=7.550396016018021e-2_p
x(2)=1.626500631387793_p
w(2)=1.157945353651901e-1_p
x(3)=2.527938506016834_p
w(3)=8.125755957318101e-2_p
x(4)=3.830613093620851_p
w(4)=3.206970666090234e-2_p
x(5)=5.557240381939685_p
w(5)=7.487739415217864e-3_p
x(6)=7.734904659321226_p
w(6)=1.054416746279825e-3_p
x(7)=10.39085584540266_p
w(7)=8.917955245000296e-5_p
x(8)=13.54827691903889_p
w(8)=4.456197832396923e-6_p
x(9)=17.19989946320533_p
w(9)=1.312918314134741e-7_p
x(10)=21.19738818328411_p
w(10)=2.502726003490764e-9_p
x(11)=24.80665432529093_p
w(11)=4.732256136775916e-11_p
else if(N==12)then
x(1)=1.107177145953822_p
w(1)=6.818708240313320e-2_p
x(2)=1.560662357810578_p
w(2)=1.095010318292322e-1_p
x(3)=2.367157128715049_p
w(3)=8.419433825198715e-2_p
x(4)=3.528448501431636_p
w(4)=3.829089422635310e-2_p
x(5)=5.058911710396625_p
w(5)=1.086369129960849e-2_p
x(6)=6.976063784044515_p
w(6)=1.974309595342637e-3_p
x(7)=9.295221710559096_p
w(7)=2.318695673719183e-4_p
x(8)=12.02663091139783_p
w(8)=1.757643013755360e-5_p
x(9)=15.163248877419_p
w(9)=8.642757292605364e-7_p
x(10)=18.64066919576554_p
w(10)=2.883430785631482e-8_p
x(11)=22.21431814266429_p
w(11)=7.741352364158989e-10_p
x(12)=25.1293941397263_p
w(12)=2.577519255559660e-11_p
else if(N==13)then
x(1)=1.096412319196289_p
w(1)=6.184914584896055e-2_p
x(2)=1.504665478332374_p
w(2)=1.032574868462323e-1_p
x(3)=2.230695608356247_p
w(3)=8.573690206968905e-2_p
x(4)=3.273510392040057_p
w(4)=4.392184781810807e-2_p
x(5)=4.641911381029930_p
w(5)=1.465679230831029e-2_p
x(6)=6.347450642363774_p
w(6)=3.281927137028061e-3_p
x(7)=8.398952141111304_p
w(7)=5.010456371007727e-4_p
x(8)=10.80023200337027_p
w(8)=5.252037278883649e-5_p
x(9)=13.54386748046009_p
w(9)=3.813786792659039e-6_p
x(10)=16.59317106561657_p
w(10)=1.974403770435336e-7_p
x(11)=19.83662513994177_p
w(11)=7.926803405385747e-9_p
x(12)=22.97830660916167_p
w(12)=3.048308519345129e-10_p
x(13)=25.34054160166804_p
w(13)=1.609183620008637e-11_p
else if(N==14)then
x(1)=1.087188870775227_p
w(1)=5.633005042934934e-2_p
x(2)=1.456644178067370_p
w(2)=9.720502754971948e-2_p
x(3)=2.113818521513113_p
w(3)=8.615204664955031e-2_p
x(4)=3.056121614407852_p
w(4)=4.882383047052166e-2_p
x(5)=4.288570337224794_p
w(5)=1.868578512054286e-2_p
x(6)=5.818791196103329_p
w(6)=4.980198221348642e-3_p
x(7)=7.651900867841141_p
w(7)=9.428072579952402e-4_p
x(8)=9.788431694768885_p
w(8)=1.282720273033929e-4_p
x(9)=12.22093774689078_p
w(9)=1.268241346755604e-5_p
x(10)=14.92482737068925_p
w(10)=9.311762170111930e-7_p
x(11)=17.83781558422641_p
w(11)=5.337370650693588e-8_p
x(12)=20.81639202784875_p
w(12)=2.667763168495082e-9_p
x(13)=23.55325601572059_p
w(13)=1.446239713532449e-10_p
x(14)=25.48475393526104_p
w(14)=1.100459322643570e-11_p
else if(N==15)then
x(1)=1.079226666036736_p
w(1)=5.149933577257908e-2_p
x(2)=1.415153960706123_p
w(2)=9.142652622642022e-2_p
x(3)=2.012907683972506_p
w(3)=8.568174987076121e-2_p
x(4)=2.869041295343263_p
w(4)=5.293940860644743e-2_p
x(5)=3.985986206460993_p
w(5)=2.277709689081374e-2_p
x(6)=5.368674049593410_p
w(6)=7.036082520996443e-3_p
x(7)=7.020013140323761_p
w(7)=1.594648934647594e-3_p
x(8)=8.938872624508791_p
w(8)=2.690218360409805e-4_p
x(9)=11.11809274779986_p
w(9)=3.420375370564364e-5_p
x(10)=13.53947339644174_p
w(10)=3.336641023025846e-6_p
x(11)=16.16325297052014_p
w(11)=2.583433085584260e-7_p
x(12)=18.90790894099452_p
w(12)=1.696087608136614e-8_p
x(13)=21.61378454924655_p
w(13)=1.068448801033816e-9_p
x(14)=23.98977630249395_p
w(14)=7.902572123622329e-11_p
x(15)=25.58704117982031_p
w(15)=8.019213992502582e-12_p
else if(N==16)then
x(1)=1.072306203701585_p
w(1)=4.725040898166008e-2_p
x(2)=1.379062975379092_p
w(2)=8.596593859591706e-2_p
x(3)=1.925155678445140_p
w(3)=8.453442259493234e-2_p
x(4)=2.706745532645153_p
w(4)=5.627013686317140e-2_p
x(5)=3.724502170375704_p
w(5)=2.678101426050799e-2_p
x(6)=4.981449840697726_p
w(6)=9.389541393021854e-3_p
x(7)=6.479125725299745_p
w(7)=2.479665625933082e-3_p
x(8)=8.215600563837052_p
w(8)=5.012284296326602e-4_p
x(9)=10.18418159919275_p
w(9)=7.857145308443362e-5_p
x(10)=12.37054789596403_p
w(10)=9.703002861431154e-6_p
x(11)=14.74689308101785_p
w(11)=9.680022910876978e-7_p
x(12)=17.26141499538596_p
w(12)=8.150987430330507e-8_p
x(13)=19.82052825568314_p
w(13)=6.251261379368805e-9_p
x(14)=22.26185224139038_p
w(14)=4.947984064231995e-10_p
x(15)=24.3253718901934_p
w(15)=4.804668987459844e-11_p
x(16)=25.66197195582173_p
w(16)=6.119561585179232e-12_p
else if(N==17)then
x(1)=1.066253617914024_p
w(1)=4.349581112928563e-2_p
x(2)=1.347474293400895_p
w(2)=8.084165216290470e-2_p
x(3)=1.848353896986602_p
w(3)=8.288353496676185e-2_p
x(4)=2.564948325911093_p
w(4)=5.885664825716529e-2_p
x(5)=3.496739959917655_p
w(5)=3.057921546758968e-2_p
x(6)=4.645376327923064_p
w(6)=1.196434060616125e-2_p
x(7)=6.011506825736451_p
w(7)=3.604059773335797e-3_p
x(8)=7.592870063199012_p
w(8)=8.500336087349195e-4_p
x(9)=9.383325462057565_p
w(9)=1.591068385759230e-4_p
x(10)=11.37115987836346_p
w(10)=2.397475241275040e-5_p
x(11)=13.53564396564879_p
w(11)=2.966802965791863e-6_p
x(12)=15.84108921531392_p
w(12)=3.111318155400917e-7_p
x(13)=18.22731059358047_p
w(13)=2.909249798537436e-8_p
x(14)=20.59537973386138_p
w(14)=2.628257586270337e-9_p
x(15)=22.78980261067953_p
w(15)=2.581310940626098e-10_p
x(16)=24.58700872522512_p
w(16)=3.168322900182467e-11_p
x(17)=25.71838933271701_p
w(17)=4.834739650424731e-12_p
else
call GD(1)
end if
end subroutine GF_1

! [2kT;26kT]
subroutine GF_2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=2.604167116741462_p
w(1)=1.077990706812620e-1_p
x(2)=5.444196575324298_p
w(2)=1.912894035660145e-2_p
else if(N==3)then
x(1)=2.427957711287620_p
w(1)=8.929203104776180e-2_p
x(2)=4.319992730871742_p
w(2)=3.626238797278050e-2_p
x(3)=8.312496529560660_p
w(3)=1.373592017321103e-3_p
else if(N==4)then
x(1)=2.331330976235606_p
w(1)=7.536488716281874e-2_p
x(2)=3.767618495479486_p
w(2)=4.634699197745654e-2_p
x(3)=6.556988953393932_p
w(3)=5.144439003989325e-3_p
x(4)=11.41252296427015_p
w(4)=7.169289359881108e-5_p
else if(N==5)then
x(1)=2.270054290270104_p
w(1)=6.489178149472229e-2_p
x(2)=3.430977687386374_p
w(2)=5.148984594487770e-2_p
x(3)=5.612100971755867_p
w(3)=1.005955056150351e-2_p
x(4)=9.094168164961044_p
w(4)=4.836612324484969e-4_p
x(5)=14.63427256676315_p
w(5)=3.171804311416695e-6_p
else if(N==6)then
x(1)=2.227100253485439_p
w(1)=5.671157937091609e-2_p
x(2)=3.199313134578345_p
w(2)=5.365115453274320e-2_p
x(3)=4.994752773273212_p
w(3)=1.510594857442408e-2_p
x(4)=7.755899953636371_p
w(4)=1.422140995849175e-3_p
x(5)=11.77759411692026_p
w(5)=3.704680700860560e-5_p
x(6)=17.80667611370165_p
w(6)=1.407569222523425e-7_p
else if(N==7)then
x(1)=2.194484331774771_p
w(1)=5.000648214910583e-2_p
x(2)=3.025110614308109_p
w(2)=5.399550773862801e-2_p
x(3)=4.543207849079411_p
w(3)=1.982723520444692e-2_p
x(4)=6.828426308658347_p
w(4)=2.931191857482994e-3_p
x(5)=10.0273440804118_p
w(5)=1.647596349589773e-4_p
x(6)=14.41140106205294_p
w(6)=2.825773706141459e-6_p
x(7)=20.55452634623661_p
w(7)=8.679534530797160e-9_p
else if(N==8)then
x(1)=2.168486785238308_p
w(1)=4.434180102165598e-2_p
x(2)=2.887057375904029_p
w(2)=5.316032694173071e-2_p
x(3)=4.191459148955846_p
w(3)=2.398327122136625e-2_p
x(4)=6.127887355238902_p
w(4)=4.954548468361231e-3_p
x(5)=8.777264705276730_p
w(5)=4.691101735323141e-4_p
x(6)=12.26533625354388_p
w(6)=1.869046027942517e-5_p
x(7)=16.79111278293493_p
w(7)=2.617425170404735e-7_p
x(8)=22.53089229274551_p
w(8)=1.008420455278982e-9_p
else if(N==9)then
x(1)=2.147321899890387_p
w(1)=3.951270969666051e-2_p
x(2)=2.775087098005846_p
w(2)=5.155893496434522e-2_p
x(3)=3.909477413612064_p
w(3)=2.741763717755413e-2_p
x(4)=5.577585735887077_p
w(4)=7.344046551033546e-3_p
x(5)=7.826768374279931_p
w(5)=1.020736524102449e-3_p
x(6)=10.7225502438965_p
w(6)=7.155652386374865e-5_p
x(7)=14.35186576101238_p
w(7)=2.356077376777353e-6_p
x(8)=18.7946865385487_p
w(8)=3.330028571048539e-8_p
x(9)=23.76428517698789_p
w(9)=2.226413149056220e-10_p
else if(N==10)then
x(1)=2.129880702295342_p
w(1)=3.538230757336400e-2_p
x(2)=2.683046241169176_p
w(2)=4.949282988291982e-2_p
x(3)=3.679571731966297_p
w(3)=3.008086344831235e-2_p
x(4)=5.135220356712527_p
w(4)=9.912188309142058e-3_p
x(5)=7.078638167178058_p
w(5)=1.851955835221798e-3_p
x(6)=9.546418113504794_p
w(6)=1.960518145354478e-4_p
x(7)=12.58087102414531_p
w(7)=1.145130697659776e-5_p
x(8)=16.21582295178093_p
w(8)=3.567409589853780e-7_p
x(9)=20.39297953504805_p
w(9)=6.048068458096164e-9_p
x(10)=24.49760870141706_p
w(10)=7.836388522808831e-11_p
else if(N==11)then
x(1)=2.115352627102222_p
w(1)=3.183520235286388e-2_p
x(2)=2.606505768248384_p
w(2)=4.717617432890747e-2_p
x(3)=3.489487407360111_p
w(3)=3.201040329299015e-2_p
x(4)=4.773173555657733_p
w(4)=1.248547222341186e-2_p
x(5)=6.475125208987560_p
w(5)=2.951741674621700e-3_p
x(6)=8.616620556141735_p
w(6)=4.288160230104904e-4_p
x(7)=11.21926379443012_p
w(7)=3.808480313651856e-5_p
x(8)=14.29693158147039_p
w(8)=2.047283317241548e-6_p
x(9)=17.8243652261094_p
w(9)=6.748258637351790e-8_p
x(10)=21.62099026394044_p
w(10)=1.535874767313510e-9_p
x(11)=24.94087485962376_p
w(11)=3.714297376536489e-11_p
else if(N==12)then
x(1)=2.103128432981948_p
w(1)=2.877407421152800e-2_p
x(2)=2.542174190264251_p
w(2)=4.475489019257213e-2_p
x(3)=3.330382337506178_p
w(3)=3.328992275325104e-2_p
x(4)=4.472379694052202_p
w(4)=1.492870282894639e-2_p
x(5)=5.978866153483885_p
w(5)=4.275236115500875e-3_p
x(6)=7.862432493937620_p
w(6)=7.988515526873126e-4_p
x(7)=10.13414402897187_p
w(7)=9.798975776463067e-5_p
x(8)=12.79857581543944_p
w(8)=7.902562605619169e-6_p
x(9)=15.83910427082509_p
w(9)=4.244353566317230e-7_p
x(10)=19.17564233358978_p
w(10)=1.608867797088143e-8_p
x(11)=22.54530961433383_p
w(11)=5.177554241090863e-10_p
x(12)=25.22035020248012_p
w(12)=2.121738076625802e-11_p
else if(N==13)then
x(1)=2.092747330657120_p
w(1)=2.611866376884489e-2_p
x(2)=2.487581813770659_p
w(2)=4.232534473786624e-2_p
x(3)=3.195764832762367_p
w(3)=3.401990141414091e-2_p
x(4)=4.219286128141921_p
w(4)=1.714984066255969e-2_p
x(5)=5.564467844357081_p
w(5)=5.758182613104756e-3_p
x(6)=7.238710816605918_p
w(6)=1.321225975104546e-3_p
x(7)=9.247390699015037_p
w(7)=2.097248854140772e-4_p
x(8)=11.59053777146552_p
w(8)=2.320481175217283e-5_p
x(9)=14.25503953461096_p
w(9)=1.813399214614166e-6_p
x(10)=17.19557812552537_p
w(10)=1.037652122817349e-7_p
x(11)=20.28956726959195_p
w(11)=4.772603590973528e-9_p
x(12)=23.23702741475807_p
w(12)=2.183724241204201e-10_p
x(13)=25.40490545414638_p
w(13)=1.367321534753541e-11_p
else if(N==14)then
x(1)=2.083857313062153_p
w(1)=2.380334100586941e-2_p
x(2)=2.440852723262573_p
w(2)=3.994915734126674e-2_p
x(3)=3.080783837430978_p
w(3)=3.430083978337248e-2_p
x(4)=4.004009511286555_p
w(4)=1.909554961829821e-2_p
x(5)=5.214003285475020_p
w(5)=7.330379092989961e-3_p
x(6)=6.714941391032484_p
w(6)=1.995324240611177e-3_p
x(7)=8.509008550343543_p
w(7)=3.911952874070470e-4_p
x(8)=10.59399731088153_p
w(8)=5.584211160964620e-5_p
x(9)=12.95881480523101_p
w(9)=5.881639030290354e-6_p
x(10)=15.57366742184806_p
w(10)=4.691235908966606e-7_p
x(11)=18.36960235549211_p
w(11)=2.995680415596142e-8_p
x(12)=21.19754549429283_p
w(12)=1.718160653298672e-9_p
x(13)=23.75705853582811_p
w(13)=1.092942710779080e-10_p
x(14)=25.53206661611136_p
w(14)=9.558465718107997e-12_p
else if(N==15)then
x(1)=2.076186241864055_p
w(1)=2.177447575164021e-2_p
x(2)=2.400542642898364_p
w(2)=3.766402334239751e-2_p
x(3)=2.981750749325197_p
w(3)=3.422475718313701e-2_p
x(4)=3.819175897205722_p
w(4)=2.074315349255285e-2_p
x(5)=4.914418579137570_p
w(5)=8.925517752663419e-3_p
x(6)=6.269592721961286_p
w(6)=2.806728068966948e-3_p
x(7)=7.885051495042171_p
w(7)=6.564142114705261e-4_p
x(8)=9.757533310236822_p
w(8)=1.156221329118348e-4_p
x(9)=11.87739222699941_p
w(9)=1.554271163655966e-5_p
x(10)=14.2230818329077_p
w(10)=1.627624565536688e-6_p
x(11)=16.75062273018233_p
w(11)=1.378457228468265e-7_p
x(12)=19.37432528364631_p
w(12)=1.012180202876861e-8_p
x(13)=21.93408203013943_p
w(13)=7.290822887717837e-10_p
x(14)=24.15220294230303_p
w(14)=6.223722547633577e-11_p
x(15)=25.62296211927457_p
w(15)=7.076606002867339e-12_p
else if(N==16)then
x(1)=2.069521211766351_p
w(1)=1.998813205126704e-2_p
x(2)=2.365525087134473_p
w(2)=3.549139524706091e-2_p
x(3)=2.895816082664419_p
w(3)=3.387165108295489e-2_p
x(4)=3.659173546492532_p
w(4)=2.209213070408067e-2_p
x(5)=4.655964095428176_p
w(5)=1.048700007040821e-2_p
x(6)=5.886956749949970_p
w(6)=3.731061549458423e-3_p
x(7)=7.351442555824243_p
w(7)=1.013390767082745e-3_p
x(8)=9.045732987924326_p
w(8)=2.129950567218831e-4_p
x(9)=10.96134192969503_p
w(9)=3.509532552063946e-5_p
x(10)=13.0816871163665_p
w(10)=4.612022364489391e-6_p
x(11)=15.37616822621027_p
w(11)=4.968574059374061e-7_p
x(12)=17.79005846839565_p
w(12)=4.596059931003865e-8_p
x(13)=20.22815267864993_p
w(13)=3.943939591592166e-9_p
x(14)=22.53157848393839_p
w(14)=3.544666876347156e-10_p
x(15)=24.45654994076289_p
w(15)=3.906760442920768e-11_p
x(16)=25.68999618959029_p
w(16)=5.464388847816601e-12_p
else if(N==17)then
x(1)=2.063693788053468_p
w(1)=1.840817289608237e-2_p
x(2)=2.334910862575555_p
w(2)=3.344184994252682e-2_p
x(3)=2.820747290961954_p
w(3)=3.330875513378884e-2_p
x(4)=3.519658130090933_p
w(4)=2.315665342472228e-2_p
x(5)=4.431203107846401_p
w(5)=1.197043168996315e-2_p
x(6)=5.555265317740242_p
w(6)=4.738326091290384e-3_p
x(7)=6.890522519521344_p
w(7)=1.463393933904733e-3_p
x(8)=8.433194900927873_p
w(8)=3.575930360276169e-4_p
x(9)=10.17577492306024_p
w(9)=7.001936534477761e-5_p
x(10)=12.10495717379301_p
w(10)=1.115224202290926e-5_p
x(11)=14.19809069358238_p
w(11)=1.476175827624104e-6_p
x(12)=16.4174280330841_p
w(12)=1.678653256655198e-7_p
x(13)=18.70124510752296_p
w(13)=1.727559168616588e-8_p
x(14)=20.95122066907169_p
w(14)=1.742113052006443e-9_p
x(15)=23.01795611224233_p
w(15)=1.925626860752763e-10_p
x(16)=24.69438491842412_p
w(16)=2.641235781648528e-11_p
x(17)=25.74076034489138_p
w(17)=4.356442754457641e-12_p
else
call GD(2)
end if
end subroutine GF_2

! [3kT;26kT]
subroutine GF_3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=3.592777329054475_p
w(1)=4.139326503713226e-2_p
x(2)=6.425553893290478_p
w(2)=7.194086531500709e-3_p
else if(N==3)then
x(1)=3.420415251173270_p
w(1)=3.440908799062820e-2_p
x(2)=5.303987485993062_p
w(2)=1.366552957898285e-2_p
x(3)=9.298403680463593_p
w(3)=5.127339990219178e-4_p
else if(N==4)then
x(1)=3.325854870800829_p
w(1)=2.912828016144875e-2_p
x(2)=4.753767122814556_p
w(2)=1.751168940960241e-2_p
x(3)=7.543517177264115_p
w(3)=1.920664354018186e-3_p
x(4)=12.39946710524099_p
w(4)=2.671764356361765e-5_p
else if(N==5)then
x(1)=3.265721653795546_p
w(1)=2.513208811284415e-2_p
x(2)=4.418254351547196_p
w(2)=1.950988671975913e-2_p
x(3)=6.597269963368226_p
w(3)=3.763350320799840e-3_p
x(4)=10.07699230147107_p
w(4)=1.808308130611001e-4_p
x(5)=15.60713545101764_p
w(5)=1.195602168745767e-6_p
else if(N==6)then
x(1)=3.223280874800699_p
w(1)=2.197942953477082e-2_p
x(2)=4.186252509180870_p
w(2)=2.038339768510113e-2_p
x(3)=5.975537735658433_p
w(3)=5.674348559440601e-3_p
x(4)=8.728487407359655_p
w(4)=5.359285402354872e-4_p
x(5)=12.73104648348875_p
w(5)=1.419052045150866e-5_p
x(6)=18.69825340185391_p
w(6)=5.672863342579733e-8_p
else if(N==7)then
x(1)=3.190864714489239_p
w(1)=1.937228227030646e-2_p
x(2)=4.011088387642147_p
w(2)=2.055636879505530e-2_p
x(3)=5.518807032437626_p
w(3)=7.479764301821442e-3_p
x(4)=7.789845238537988_p
w(4)=1.113719721095353e-3_p
x(5)=10.96214233297145_p
w(5)=6.405777583191957e-5_p
x(6)=15.28932265998257_p
w(6)=1.154602243573882e-6_p
x(7)=21.25208134824722_p
w(7)=4.102278919654160e-9_p
else if(N==8)then
x(1)=3.165031573803917_p
w(1)=1.716443307898045e-2_p
x(2)=3.872532157122257_p
w(2)=2.026628976520777e-2_p
x(3)=5.163714052732539_p
w(3)=9.073699805603182e-3_p
x(4)=7.082302357768230_p
w(4)=1.891408342353111e-3_p
x(5)=9.701960814734626_p
w(5)=1.837264485882537e-4_p
x(6)=13.13709780460828_p
w(6)=7.675447776319340e-6_p
x(7)=17.55507216899568_p
w(7)=1.181014962400752e-7_p
x(8)=22.99767093339883_p
w(8)=5.786276416172497e-10_p
else if(N==9)then
x(1)=3.144062399709988_p
w(1)=1.528390937957464e-2_p
x(2)=3.760643656465234_p
w(2)=1.967432470342826e-2_p
x(3)=4.880342176464301_p
w(3)=1.038994674285369e-2_p
x(4)=6.528926553475010_p
w(4)=2.808388345276005e-3_p
x(5)=8.748017227224953_p
w(5)=4.003980528241896e-4_p
x(6)=11.59538635183244_p
w(6)=2.932761964024869e-5_p
x(7)=15.14251939599423_p
w(7)=1.039722452813849e-6_p
x(8)=19.42865348208167_p
w(8)=1.685332477044034e-8_p
x(9)=24.05586697323608_p
w(9)=1.492583517666533e-10_p
else if(N==10)then
x(1)=3.126830660875963_p
w(1)=1.367732418958752e-2_p
x(2)=3.669034889122709_p
w(2)=1.889882107581916e-2_p
x(3)=4.650267380612588_p
w(3)=1.140975768391288e-2_p
x(4)=6.085805762268346_p
w(4)=3.790832455702671e-3_p
x(5)=7.999890820544942_p
w(5)=7.255180229059064e-4_p
x(6)=10.42346720400463_p
w(6)=7.995437235467402e-5_p
x(7)=13.38993365130834_p
w(7)=4.969346528541058e-6_p
x(8)=16.91491289349_p
w(8)=1.709354404252585e-7_p
x(9)=20.90065675358277_p
w(9)=3.428104375384641e-9_p
x(10)=24.68090908011098_p
w(10)=5.827682169838144e-11_p
else if(N==11)then
x(1)=3.112509271841297_p
w(1)=1.229890582217017e-2_p
x(2)=3.593099734957182_p
w(2)=1.802347328722782e-2_p
x(3)=4.460703925827861_p
w(3)=1.214854942907873e-2_p
x(4)=5.724277224979829_p
w(4)=4.771900363513520e-3_p
x(5)=7.398064402445485_p
w(5)=1.153411751372489e-3_p
x(6)=9.499035847717343_p
w(6)=1.738306253671011e-4_p
x(7)=12.04306452170674_p
w(7)=1.629581307021062e-5_p
x(8)=15.03420020857738_p
w(8)=9.482587404562617e-7_p
x(9)=18.42925218776784_p
w(9)=3.522623800631937e-8_p
x(10)=22.01901410541713_p
w(10)=9.623462595368181e-10_p
x(11)=25.06071014240296_p
w(11)=2.950821419580101e-11_p
else if(N==12)then
x(1)=3.100481441834878_p
w(1)=1.111027650436202e-2_p
x(2)=3.529448650860301_p
w(2)=1.710523428476270e-2_p
x(3)=4.302505538820157_p
w(3)=1.263903893867850e-2_p
x(4)=5.424714518418212_p
w(4)=5.700314376643129e-3_p
x(5)=6.904327395327625_p
w(5)=1.665472921925213e-3_p
x(6)=8.750555527918213_p
w(6)=3.218088947612791e-4_p
x(7)=10.9704694223259_p
w(7)=4.141466425859876e-5_p
x(8)=13.56269722085176_p
w(8)=3.570833907479910e-6_p
x(9)=16.50098088793865_p
w(9)=2.106574811084763e-7_p
x(10)=19.69062268520819_p
w(10)=9.121972956346844e-9_p
x(11)=22.8551422252997_p
w(11)=3.522874037589118e-10_p
x(12)=25.30238638196634_p
w(12)=1.759258383777791e-11_p
else if(N==13)then
x(1)=3.090283457244286_p
w(1)=1.007991525531009e-2_p
x(2)=3.475557972627779_p
w(2)=1.618174523281116e-2_p
x(3)=4.169002467927905_p
w(3)=1.292000497775322e-2_p
x(4)=5.173250010384465_p
w(4)=6.541752757508753e-3_p
x(5)=6.492855253039729_p
w(5)=2.236075489268487e-3_p
x(6)=8.132528743008100_p
w(6)=5.289791125498200e-4_p
x(7)=10.09468442002923_p
w(7)=8.767081374181775e-5_p
x(8)=12.37545248268797_p
w(8)=1.028108922046726e-5_p
x(9)=14.95595871718028_p
w(9)=8.685637408281603e-7_p
x(10)=17.78266475992763_p
w(10)=5.518899754896101e-8_p
x(11)=20.72361462190298_p
w(11)=2.917509992844449e-9_p
x(12)=23.47901793034588_p
w(12)=1.585529128271733e-10_p
x(13)=25.46352168715117_p
w(13)=1.166786008089066e-11_p
else if(N==14)then
x(1)=3.081562513734018_p
w(1)=9.182100330416559e-3_p
x(2)=3.429521552376421_p
w(2)=1.527712415144237e-2_p
x(3)=4.055235262837736_p
w(3)=1.302998115111070e-2_p
x(4)=4.959812200569703_p
w(4)=7.276807396107212e-3_p
x(5)=6.145484697285053_p
w(5)=2.837869286108976e-3_p
x(6)=7.614275873615659_p
w(6)=7.942101190604844e-4_p
x(7)=9.366071078342154_p
w(7)=1.619226860735993e-4_p
x(8)=11.3959389004337_p
w(8)=2.433860255678685e-5_p
x(9)=13.68907528466534_p
w(9)=2.741166825042943e-6_p
x(10)=16.21066085895378_p
w(10)=2.384440476864200e-7_p
x(11)=18.88581472216806_p
w(11)=1.702142539699763e-8_p
x(12)=21.56175248700766_p
w(12)=1.121696168362392e-9_p
x(13)=23.94789962354719_p
w(13)=8.343958161654925e-11_p
x(14)=25.57552546957368_p
w(14)=8.322410374102872e-12_p
else if(N==15)then
x(1)=3.074046700848507_p
w(1)=8.395840697054003e-3_p
x(2)=3.389878424552969_p
w(2)=1.440618196570218e-2_p
x(3)=3.957448209565261_p
w(3)=1.300410368726661e-2_p
x(4)=4.776910562557086_p
w(4)=7.897691140929209e-3_p
x(5)=5.849026615662581_p
w(5)=3.445499703209701e-3_p
x(6)=7.174188587408329_p
w(6)=1.111097407044089e-3_p
x(7)=8.750905467321553_p
w(7)=2.692843080646894e-4_p
x(8)=10.57391090933593_p
w(8)=4.968748830987839e-5_p
x(9)=12.63103086904628_p
w(9)=7.085091239688506e-6_p
x(10)=14.8974482031486_p
w(10)=7.991417758867926e-7_p
x(11)=17.32533232918356_p
w(11)=7.426651658338796e-8_p
x(12)=19.82571945150628_p
w(12)=6.112553314502191e-9_p
x(13)=22.23968768606128_p
w(13)=5.033284697679170e-10_p
x(14)=24.30463899563619_p
w(14)=4.938632752156486e-11_p
x(15)=25.65620276825594_p
w(15)=6.252341765244968e-12_p
else if(N==16)then
x(1)=3.067523837126734_p
w(1)=7.703957376530615e-3_p
x(2)=3.355493420777957_p
w(2)=1.357740994585216e-2_p
x(3)=3.872750324391069_p
w(3)=1.287283302216775e-2_p
x(4)=4.618859905415895_p
w(4)=8.404884230508202e-3_p
x(5)=5.593652502437527_p
w(5)=4.037690762094059e-3_p
x(6)=6.796527272262760_p
w(6)=1.469602963429090e-3_p
x(7)=8.225264387954445_p
w(7)=4.123736658312186e-4_p
x(8)=9.874633447701925_p
w(8)=9.040776348398693e-5_p
x(9)=11.73434546545332_p
w(9)=1.570342980340387e-5_p
x(10)=13.78558557162341_p
w(10)=2.202469083035433e-6_p
x(11)=15.99515533670947_p
w(11)=2.569573848976892e-7_p
x(12)=18.30587861295175_p
w(12)=2.617351560406984e-8_p
x(13)=20.62181445281487_p
w(13)=2.515718482078537e-9_p
x(14)=22.78882756032638_p
w(14)=2.564073510806256e-10_p
x(15)=24.57999892954069_p
w(15)=3.194177857367536e-11_p
x(16)=25.71609521477426_p
w(16)=4.881337976847157e-12_p
else if(N==17)then
x(1)=3.061826431502527_p
w(1)=7.092333362040704e-3_p
x(2)=3.325473460119733_p
w(2)=1.279506493764903e-2_p
x(3)=3.798883851735476_p
w(3)=1.266172131052666e-2_p
x(4)=4.481269548507758_p
w(4)=8.804261163376070e-3_p
x(5)=5.371879714728967_p
w(5)=4.598039103762949e-3_p
x(6)=6.469516253021847_p
w(6)=1.857797667144251e-3_p
x(7)=7.771603584279029_p
w(7)=5.911272524792826e-4_p
x(8)=9.273132364056497_p
w(8)=1.501272348532024e-4_p
x(9)=10.96525709578856_p
w(9)=3.083334043393625e-5_p
x(10)=12.83308909106434_p
w(10)=5.204436163711479e-6_p
x(11)=14.85216367967307_p
w(11)=7.387606509836325e-7_p
x(12)=16.982946977694_p
w(12)=9.130438617617580e-8_p
x(13)=19.16268090898982_p
w(13)=1.035818696819585e-8_p
x(14)=21.29441388332627_p
w(14)=1.166158763153063e-9_p
x(15)=23.23563185282866_p
w(15)=1.447900207626292e-10_p
x(16)=24.79573160612165_p
w(16)=2.210536718828250e-11_p
x(17)=25.76170920732777_p
w(17)=3.924887077795561e-12_p
else
call GD(3)
end if
end subroutine GF_3

! [4kT;26kT]
subroutine GF_4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=4.588391014856999_p
w(1)=1.548098964008977e-2_p
x(2)=7.418428122065847_p
w(2)=2.668938272610878e-3_p
else if(N==3)then
x(1)=4.417497795789434_p
w(1)=1.288650258351934e-2_p
x(2)=6.297845385904406_p
w(2)=5.073736436533930e-3_p
x(3)=10.29293867329531_p
w(3)=1.896888926473781e-4_p
else if(N==4)then
x(1)=4.323693972269376_p
w(1)=1.092040769815769e-2_p
x(2)=5.748232350275798_p
w(2)=6.508706708082334e-3_p
x(3)=8.537671709534695_p
w(3)=7.109197977979722e-4_p
x(4)=13.3924765001864_p
w(4)=9.893708662649978e-6_p
else if(N==5)then
x(1)=4.263841804328588_p
w(1)=9.425210291367205e-3_p
x(2)=5.412248199401875_p
w(2)=7.260589195916502e-3_p
x(3)=7.588403119428012_p
w(3)=1.396328876672975e-3_p
x(4)=11.06271642151705_p
w(4)=6.734779262214690e-5_p
x(5)=16.57556126631603_p
w(5)=4.517561218225767e-7_p
else if(N==6)then
x(1)=4.221293975458605_p
w(1)=8.234992425433267e-3_p
x(2)=5.178423115045739_p
w(2)=7.593707827632424e-3_p
x(3)=6.960492073744794_p
w(3)=2.114123809554802e-3_p
x(4)=9.700928283243309_p
w(4)=2.016136647588887e-4_p
x(5)=13.67616689613664_p
w(5)=5.466706734960988e-6_p
x(6)=19.55529083409276_p
w(6)=2.347858630820743e-8_p
else if(N==7)then
x(1)=4.188666526759288_p
w(1)=7.245020088340027e-3_p
x(2)=5.001322371363761_p
w(2)=7.660657290702230e-3_p
x(3)=6.497803207793667_p
w(3)=2.796286274115855e-3_p
x(4)=8.750486400344238_p
w(4)=4.224489366018668e-4_p
x(5)=11.88917085380199_p
w(5)=2.503337811847823e-5_p
x(6)=16.14563454620613_p
w(6)=4.799122076053669e-7_p
x(7)=21.889618312383_p
w(7)=2.032614588631429e-9_p
else if(N==8)then
x(1)=4.162721541955413_p
w(1)=6.407251099576289e-3_p
x(2)=4.861645104586934_p
w(2)=7.550032479848470e-3_p
x(3)=6.139215386419893_p
w(3)=3.397144277078116e-3_p
x(4)=8.036541371642679_p
w(4)=7.200744829660125e-4_p
x(5)=10.62101903555891_p
w(5)=7.218355699941481e-5_p
x(6)=13.9944776808166_p
w(6)=3.187045151969330e-6_p
x(7)=18.28870798563992_p
w(7)=5.462405035112090e-8_p
x(8)=23.41002135663628_p
w(8)=3.470300283296734e-10_p
else if(N==9)then
x(1)=4.141742525918052_p
w(1)=5.695670340590624e-3_p
x(2)=4.749353454206018_p
w(2)=7.324429315348979e-3_p
x(3)=5.854369631324624_p
w(3)=3.890243070650539e-3_p
x(4)=7.480729816199942_p
w(4)=1.069711065588116e-3_p
x(5)=9.665372207788183_p
w(5)=1.572909078401385e-4_p
x(6)=12.45811059937436_p
w(6)=1.210825179188360e-5_p
x(7)=15.91363177775256_p
w(7)=4.660888942592912e-7_p
x(8)=20.02916480323102_p
w(8)=8.768799573809795e-9_p
x(9)=24.31104046651614_p
w(9)=1.031965382228829e-10_p
else if(N==10)then
x(1)=4.124560269980813_p
w(1)=5.089322424507696e-3_p
x(2)=4.657765613110456_p
w(2)=7.029689456217576e-3_p
x(3)=5.624000513589659_p
w(3)=4.269300233651714e-3_p
x(4)=7.037326454164694_p
w(4)=1.442322885500625e-3_p
x(5)=8.918502899371664_p
w(5)=2.842600267912816e-4_p
x(6)=11.29307797779569_p
w(6)=3.276732455047768e-5_p
x(7)=14.18500555379681_p
w(7)=2.180067846435291e-6_p
x(8)=17.59117496357344_p
w(8)=8.345414901063189e-8_p
x(9)=21.37654138681591_p
w(9)=1.995301920567552e-9_p
x(10)=24.84211910789099_p
w(10)=4.418391392609864e-11_p
else if(N==11)then
x(1)=4.110319313914881_p
w(1)=4.570240662503890e-3_p
x(2)=4.582085945111270_p
w(2)=6.697898193287244e-3_p
x(3)=5.434802681371965_p
w(3)=4.541159793738755e-3_p
x(4)=6.676654141503038_p
w(4)=1.812209245378038e-3_p
x(5)=8.319296503977894_p
w(5)=4.502375781584159e-4_p
x(6)=10.37585125274225_p
w(6)=7.069027870597616e-5_p
x(7)=12.85629114014083_p
w(7)=7.027555250209680e-6_p
x(8)=15.75459423376956_p
w(8)=4.452081786329936e-7_p
x(9)=19.0102060599193_p
w(9)=1.875686310577314e-8_p
x(10)=22.38977933895358_p
w(10)=6.169156372872153e-10_p
x(11)=25.16717254796874_p
w(11)=2.372074735737572e-11_p
else if(N==12)then
x(1)=4.098387143851324_p
w(1)=4.123504734509871e-3_p
x(2)=4.518818012295045_p
w(2)=6.350709148762354e-3_p
x(3)=5.277340595645570_p
w(3)=4.718993595821104e-3_p
x(4)=6.378558716442003_p
w(4)=2.160044387705241e-3_p
x(5)=7.828800411570046_p
w(5)=6.474550642130812e-4_p
x(6)=9.634432446291623_p
w(6)=1.298755203323156e-4_p
x(7)=11.79856128646068_p
w(7)=1.760378332953148e-5_p
x(8)=14.31375410014185_p
w(8)=1.629998970258258e-6_p
x(9)=17.14433462136004_p
w(9)=1.061476589816503e-7_p
x(10)=20.18247399148573_p
w(10)=5.272566253469495e-9_p
x(11)=23.14304228242863_p
w(11)=2.441395265883409e-10_p
x(12)=25.37605971225299_p
w(12)=1.469213343822437e-11_p
else if(N==13)then
x(1)=4.088291080433458_p
w(1)=3.736935194829187e-3_p
x(2)=4.465375831599257_p
w(2)=6.002320370113869e-3_p
x(3)=5.144776080252392_p
w(3)=4.818019259604629e-3_p
x(4)=6.128880265509312_p
w(4)=2.473214992405553e-3_p
x(5)=7.420816553849196_p
w(5)=8.656530087677218e-4_p
x(6)=9.023141381764530_p
w(6)=2.119420116430481e-4_p
x(7)=10.93545842452903_p
w(7)=3.679974367948550e-5_p
x(8)=13.14996072825965_p
w(8)=4.590631033683296e-6_p
x(9)=15.6421142151374_p
w(9)=4.209442464178836e-7_p
x(10)=18.35078927563531_p
w(10)=2.981459181150593e-8_p
x(11)=21.13659140667395_p
w(11)=1.815025862506825e-9_p
x(12)=23.70393421270277_p
w(12)=1.167594530757085e-10_p
x(13)=25.51668884983059_p
w(13)=9.999930369816656e-12_p
else if(N==14)then
x(1)=4.079673063593428_p
w(1)=3.400634364823878e-3_p
x(2)=4.419815789899945_p
w(2)=5.661747759204602e-3_p
x(3)=5.032047693405745_p
w(3)=4.853146761498394e-3_p
x(4)=5.917376543771233_p
w(4)=2.744878826553471e-3_p
x(5)=7.076981383206784_p
w(5)=1.094162399593217e-3_p
x(6)=8.511227717822083_p
w(6)=3.160497418756113e-4_p
x(7)=10.21792576206562_p
w(7)=6.721387772113238e-5_p
x(8)=12.18943820797322_p
w(8)=1.067133118535581e-5_p
x(9)=14.40730719045926_p
w(9)=1.289478013610764e-6_p
x(10)=16.8320032331358_p
w(10)=1.227375024246045e-7_p
x(11)=19.38360550525015_p
w(11)=9.819536305342719e-9_p
x(12)=21.90752399800882_p
w(12)=7.435452898288664e-10_p
x(13)=24.12561438012474_p
w(13)=6.438270858478424e-11_p
x(14)=25.61528904624837_p
w(14)=7.264651464874679e-12_p
else if(N==15)then
x(1)=4.072258103475039_p
w(1)=3.106551275360744e-3_p
x(2)=4.380654189669299_p
w(2)=5.334465291173045e-3_p
x(3)=4.935336867513972_p
w(3)=4.837835119099395e-3_p
x(4)=5.736454512441584_p
w(4)=2.972598629465814e-3_p
x(5)=6.783995554943393_p
w(5)=1.323303911676933e-3_p
x(6)=8.077063763665429_p
w(6)=4.393587230042586e-4_p
x(7)=9.612587774952610_p
w(7)=1.106699961908594e-4_p
x(8)=11.38335781278509_p
w(8)=2.145012305610492e-5_p
x(9)=13.37471283518295_p
w(9)=3.253737984056949e-6_p
x(10)=15.55874140173252_p
w(10)=3.964351091675625e-7_p
x(11)=17.88422745096495_p
w(11)=4.052961047079154e-8_p
x(12)=20.25989786790387_p
w(12)=3.743969208441384e-9_p
x(13)=22.52957346908375_p
w(13)=3.519693445695555e-10_p
x(14)=24.44698608463992_p
w(14)=3.949961817627047e-11_p
x(15)=25.68684596283597_p
w(15)=5.531632457231886e-12_p
else if(N==16)then
x(1)=4.065832263141059_p
w(1)=2.848115513373931e-3_p
x(2)=4.346742181177016_p
w(2)=5.023558532545594e-3_p
x(3)=4.851713817806268_p
w(3)=4.783657907980321e-3_p
x(4)=5.580366949494719_p
w(4)=3.157004576970634e-3_p
x(5)=6.531970297470259_p
w(5)=1.545123064394087e-3_p
x(6)=7.704915743791908_p
w(6)=5.777235640184840e-4_p
x(7)=9.095751851528451_p
w(7)=1.679590763070631e-4_p
x(8)=10.6978018881248_p
w(8)=3.850551334839969e-5_p
x(9)=12.49901277444867_p
w(9)=7.068175643289458e-6_p
x(10)=14.47844395604316_p
w(10)=1.060717032363377e-6_p
x(11)=16.60056736155067_p
w(11)=1.343346892780093e-7_p
x(12)=18.8062919238807_p
w(12)=1.509300631699551e-8_p
x(13)=20.99983104060991_p
w(13)=1.625310696416160e-9_p
x(14)=23.03287078428326_p
w(14)=1.874497898080831e-10_p
x(15)=24.6956422103211_p
w(15)=2.626743791852720e-11_p
x(16)=25.74031044942344_p
w(16)=4.362966093868662e-12_p
else if(N==17)then
x(1)=4.060227114739090_p
w(1)=2.619941236270768e-3_p
x(2)=4.317178668738314_p
w(2)=4.730524240695794e-3_p
x(3)=4.778897138414640_p
w(3)=4.700256379248524e-3_p
x(4)=5.444686011459812_p
w(4)=3.300678010859927e-3_p
x(5)=6.313391567368791_p
w(5)=1.753625440916937e-3_p
x(6)=7.383026205198240_p
w(6)=7.263911235067896e-4_p
x(7)=8.650038265739918_p
w(7)=2.388111830184397e-4_p
x(8)=10.10831030520063_p
w(8)=6.318259260057364e-5_p
x(9)=11.74770271341518_p
w(9)=1.364150151224287e-5_p
x(10)=13.55181372941864_p
w(10)=2.445693778193731e-6_p
x(11)=15.49453065672763_p
w(11)=3.730989782201748e-7_p
x(12)=17.53485265036812_p
w(12)=5.020551384569082e-8_p
x(13)=19.60951631599042_p
w(13)=6.284436007372455e-9_p
x(14)=21.623663054805_p
w(14)=7.894401845504017e-10_p
x(15)=23.44229407395911_p
w(15)=1.098095994573211e-10_p
x(16)=24.89097829080721_p
w(16)=1.857850154615536e-11_p
x(17)=25.78125441424502_p
w(17)=3.536103270128074e-12_p
else
call GD(4)
end if
end subroutine GF_4

! [5kT;26kT]
subroutine GF_5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=5.586748495896086_p
w(1)=5.730409145214063e-3_p
x(2)=8.415765505330709_p
w(2)=9.849393387949170e-4_p
else if(N==3)then
x(1)=5.416396302000853_p
w(1)=4.772423888672573e-3_p
x(2)=7.295503916068081_p
w(2)=1.872986110745211e-3_p
x(3)=11.29073044567058_p
w(3)=6.993848459119473e-5_p
else if(N==4)then
x(1)=5.322811098047415_p
w(1)=4.045328009196380e-3_p
x(2)=6.745745542413562_p
w(2)=2.403989043132729e-3_p
x(3)=9.534218734618134_p
w(3)=2.623718432414516e-4_p
x(4)=14.38616622281697_p
w(4)=3.659588438419429e-6_p
else if(N==5)then
x(1)=5.262830695685143_p
w(1)=3.489367348534817e-3_p
x(2)=6.408270946464694_p
w(2)=2.683666750647894e-3_p
x(3)=8.580162102499843_p
w(3)=5.170151695554377e-4_p
x(4)=12.04542133399614_p
w(4)=2.512668779566607e-5_p
x(5)=17.53008406375119_p
w(5)=1.725274751644944e-7_p
else if(N==6)then
x(1)=5.219874774203247_p
w(1)=3.042921232763082e-3_p
x(2)=6.171742240749805_p
w(2)=2.807817000325106e-3_p
x(3)=7.944608279219202_p
w(3)=7.863570709091429e-4_p
x(4)=10.66783119859507_p
w(4)=7.611157120654088e-5_p
x(5)=14.60595744905529_p
w(5)=2.131523728108305e-6_p
x(6)=20.36498531984661_p
w(6)=1.008507699964576e-8_p
else if(N==7)then
x(1)=5.186871523588236_p
w(1)=2.670370839923743e-3_p
x(2)=5.992331856346200_p
w(2)=2.831121980162305e-3_p
x(3)=7.475752680404366_p
w(3)=1.043057083117419e-3_p
x(4)=9.705853327107809_p
w(4)=1.607147020862621e-4_p
x(5)=12.80350309315913_p
w(5)=9.878790929759635e-6_p
x(6)=16.97432506065873_p
w(6)=2.040274627661646e-7_p
x(7)=22.46253760683946_p
w(7)=1.060326724273856e-9_p
else if(N==8)then
x(1)=5.160722128144975_p
w(1)=2.355917019762440e-3_p
x(2)=5.851398046112478_p
w(2)=2.786977903110366e-3_p
x(3)=7.113937950680836_p
w(3)=1.267904066646796e-3_p
x(4)=8.986587102968643_p
w(4)=2.746186698211032e-4_p
x(5)=11.53038293585112_p
w(5)=2.856113387396195e-5_p
x(6)=14.83313879078763_p
w(6)=1.343475670475240e-6_p
x(7)=18.9878059183296_p
w(7)=2.599789039795750e-8_p
x(8)=23.77059959797691_p
w(8)=2.172334395519601e-10_p
else if(N==9)then
x(1)=5.139668623130461_p
w(1)=2.089811164739941e-3_p
x(2)=5.738613621761232_p
w(2)=2.699706535463633e-3_p
x(3)=6.827873228965944_p
w(3)=1.450740422531566e-3_p
x(4)=8.429259117446430_p
w(4)=4.077149174020099e-4_p
x(5)=10.57518518748396_p
w(5)=6.210427292141644e-5_p
x(6)=13.30701485492784_p
w(6)=5.053424952184494e-6_p
x(7)=16.66154658333939_p
w(7)=2.129717579525260e-7_p
x(8)=20.59391140849121_p
w(8)=4.700835065979938e-9_p
x(9)=24.53330647157608_p
w(9)=7.340521015218439e-11_p
else if(N==10)then
x(1)=5.122487212860901_p
w(1)=1.863792981200618e-3_p
x(2)=5.646970961014476_p
w(2)=2.586955279619251e-3_p
x(3)=6.597396066852025_p
w(3)=1.589680251866579e-3_p
x(4)=7.986272587013721_p
w(4)=5.485935788041968e-4_p
x(5)=9.831097573263561_p
w(5)=1.117757796506919e-4_p
x(6)=12.15191751774901_p
w(6)=1.353791912919290e-5_p
x(7)=14.96281457628071_p
w(7)=9.698433221316376e-7_p
x(8)=18.24183231786049_p
w(8)=4.162277143276618e-8_p
x(9)=21.81990924339918_p
w(9)=1.193553885326124e-9_p
x(10)=24.98361869471611_p
w(10)=3.409100086496960e-11_p
else if(N==11)then
x(1)=5.108289596127388_p
w(1)=1.670846457914298e-3_p
x(2)=5.571482810263043_p
w(2)=2.460916571148747e-3_p
x(3)=6.408699035466791_p
w(3)=1.687805058555334e-3_p
x(4)=7.626998076872931_p
w(4)=6.873909985297794e-4_p
x(5)=9.235650870530050_p
w(5)=1.761787971916960e-4_p
x(6)=11.24399946445922_p
w(6)=2.892444942156193e-5_p
x(7)=13.65595768445483_p
w(7)=3.063101852148937e-6_p
x(8)=16.45539203614453_p
w(8)=2.124199014078764e-7_p
x(9)=19.56537669534591_p
w(9)=1.020561441745733e-8_p
x(10)=22.73348624567504_p
w(10)=4.046067224408359e-10_p
x(11)=25.26166133230106_p
w(11)=1.927286684486610e-11_p
else if(N==12)then
x(1)=5.096424485684269_p
w(1)=1.505205822953696e-3_p
x(2)=5.508544323062139_p
w(2)=2.329724079418301e-3_p
x(3)=6.252071544468472_p
w(3)=1.750473937164110e-3_p
x(4)=7.330795705134020_p
w(4)=8.168638865381595e-4_p
x(5)=8.749280739335239_p
w(5)=2.520629500003555e-4_p
x(6)=10.51119483129953_p
w(6)=5.266127608416323e-5_p
x(7)=12.61565225520994_p
w(7)=7.545338852942361e-6_p
x(8)=15.04915938156783_p
w(8)=7.534884432741757e-7_p
x(9)=17.76704400471323_p
w(9)=5.440985079613497e-8_p
x(10)=20.65013090136518_p
w(10)=3.110093802921207e-9_p
x(11)=23.40956466167296_p
w(11)=1.722595046258266e-10_p
x(12)=25.44217561537503_p
w(12)=1.234987414753603e-11_p
else if(N==13)then
x(1)=5.086408010618044_p
w(1)=1.362196103629241e-3_p
x(2)=5.455505405656308_p
w(2)=2.198646273766256e-3_p
x(3)=6.120516508937556_p
w(3)=1.783696271571726e-3_p
x(4)=7.083240345588051_p
w(4)=9.324322400994660e-4_p
x(5)=8.345488447222120_p
w(5)=3.353173635323462e-4_p
x(6)=9.907835221654357_p
w(6)=8.521631390041131e-5_p
x(7)=11.76711653783483_p
w(7)=1.554892281631526e-5_p
x(8)=13.91161160345264_p
w(8)=2.070522949440266e-6_p
x(9)=16.31134853450033_p
w(9)=2.068424046293058e-7_p
x(10)=18.89839900569827_p
w(10)=1.638384421922664e-8_p
x(11)=21.52798890228671_p
w(11)=1.149724299105204e-9_p
x(12)=23.91237106945972_p
w(12)=8.716654581822920e-11_p
x(13)=25.564879300791_p
w(13)=8.604083196587072e-12_p
else if(N==14)then
x(1)=5.077875261680974_p
w(1)=1.238036974699812e-3_p
x(2)=5.410383437571667_p
w(2)=2.070980505755778e-3_p
x(3)=6.008877451918048_p
w(3)=1.793259151044145e-3_p
x(4)=6.873938444619939_p
w(4)=1.031748458338566e-3_p
x(5)=8.005755810228409_p
w(5)=4.217849604478559e-4_p
x(6)=9.403208627943535_p
w(6)=1.260904391563126e-4_p
x(7)=11.06211364309249_p
w(7)=2.804690583128535e-5_p
x(8)=12.9721666859886_p
w(8)=4.717215838940317e-6_p
x(9)=15.11139120167772_p
w(9)=6.134726238408555e-7_p
x(10)=17.43596142311213_p
w(10)=6.408587289489380e-8_p
x(11)=19.86190198411439_p
w(11)=5.757310058584215e-9_p
x(12)=22.23469214043098_p
w(12)=5.005454987657944e-10_p
x(13)=24.29071460718644_p
w(13)=5.018826599275294e-11_p
x(14)=25.65164291522381_p
w(14)=6.355726192688804e-12_p
else if(N==15)then
x(1)=5.070547027476383_p
w(1)=1.129666082679337e-3_p
x(2)=5.371670755619138_p
w(2)=1.948690348711513e-3_p
x(3)=5.913278191743972_p
w(3)=1.784320246000821e-3_p
x(4)=6.695209185384400_p
w(4)=1.114128958368200e-3_p
x(5)=7.716704246527692_p
w(5)=5.077834994623435e-4_p
x(6)=8.975734979196540_p
w(6)=1.740336479982591e-4_p
x(7)=10.46775172668515_p
w(7)=4.567145853156925e-5_p
x(8)=12.18365209293263_p
w(8)=9.321910424370751e-6_p
x(9)=14.10638053626182_p
w(9)=1.508254614512964e-6_p
x(10)=16.20517349452331_p
w(10)=1.990314312461782e-7_p
x(11)=18.42596162400934_p
w(11)=2.243233603820499e-8_p
x(12)=20.67615649814301_p
w(12)=2.327410718024473e-9_p
x(13)=22.8037533183382_p
w(13)=2.493091945013495e-10_p
x(14)=24.5796465028256_p
w(14)=3.183111817910209e-11_p
x(15)=25.71506991732512_p
w(15)=4.899738155345615e-12_p
else if(N==16)then
x(1)=5.064206787666735_p
w(1)=1.034593214055115e-3_p
x(2)=5.338203846734682_p
w(2)=1.832849211048765e-3_p
x(3)=5.830754091528638_p
w(3)=1.761268094936466e-3_p
x(4)=6.541254726547936_p
w(4)=1.180019611090956e-3_p
x(5)=7.468406942640119_p
w(5)=5.903585420627215e-4_p
x(6)=8.609730261999216_p
w(6)=2.273370451851144e-4_p
x(7)=9.960651930644060_p
w(7)=6.862989716867954e-5_p
x(8)=11.51310855324158_p
w(8)=1.648943773714625e-5_p
x(9)=13.253353358514_p
w(9)=3.206253484062922e-6_p
x(10)=15.15847441658674_p
w(10)=5.160384591088852e-7_p
x(11)=17.19092969232169_p
w(11)=7.108939190389465e-8_p
x(12)=19.29028071868611_p
w(12)=8.821315014144335e-9_p
x(13)=21.36176118584707_p
w(13)=1.063968468667530e-9_p
x(14)=23.26380390424756_p
w(14)=1.384839137473975e-10_p
x(15)=24.80378304284221_p
w(15)=2.172026395842543e-11_p
x(16)=25.76275643771767_p
w(16)=3.901279536194835e-12_p
else if(N==17)then
x(1)=5.058684569304205_p
w(1)=9.507836671474118e-4_p
x(2)=5.309072812350410_p
w(2)=1.723944890074374e-3_p
x(3)=5.759003057500423_p
w(3)=1.727724623615786e-3_p
x(4)=6.407618985363731_p
w(4)=1.230561874512511e-3_p
x(5)=7.253335012920932_p
w(5)=6.673438442347853e-4_p
x(6)=8.293485550380854_p
w(6)=2.841102945256756e-4_p
x(7)=9.523653327262757_p
w(7)=9.671299932897561e-5_p
x(8)=10.93667866860049_p
w(8)=2.670947662104154e-5_p
x(9)=12.5211867079991_p
w(9)=6.074751147099292e-6_p
x(10)=14.25936802433538_p
w(10)=1.159200048254266e-6_p
x(11)=16.12366309937052_p
w(11)=1.904192955280466e-7_p
x(12)=18.07195175618823_p
w(12)=2.793923543885166e-8_p
x(13)=20.04099794271371_p
w(13)=3.860791943829182e-9_p
x(14)=21.93870331270304_p
w(14)=5.405799546372602e-10_p
x(15)=23.63806446759347_p
w(15)=8.398846869518124e-11_p
x(16)=24.98034922145236_p
w(16)=1.567625985776714e-11_p
x(17)=25.79947152967646_p
w(17)=3.185470890173234e-12_p
else
call GD(5)
end if
end subroutine GF_5

end module m_gauss_fermi_26
