!!
!! This file contains modules that are true dummies, used only
!! to avoid more complex dependencies within siesta. Most of these
!! are only used in read_options.
module spin_subs_m
  implicit none
  private
  public :: print_spin_options
contains
  subroutine print_spin_options( )
  end subroutine print_spin_options
end module spin_subs_m

module m_mixing_scf
  implicit none
  private
  public :: mixers_scf_init
  public :: mixers_scf_print
  public :: mixers_scf_print_block
contains
  subroutine mixers_scf_init( dummy_nspin )
    integer, intent(in) :: dummy_nspin
    integer :: dumm
    dumm = dummy_nspin ! Prevents "unused variable" warnings.
  end subroutine mixers_scf_init

  subroutine mixers_scf_print( dummy_nspin )
    integer, intent(in) :: dummy_nspin
    integer :: dumm
    dumm = dummy_nspin  ! Prevents "unused variable" warnings.
  end subroutine mixers_scf_print

  subroutine mixers_scf_print_block( )
  end subroutine mixers_scf_print_block
end module m_mixing_scf

module siesta_master
  implicit none
  private
  character(len=132), public :: input_file = ' '
end module siesta_master

module m_hartree_add
  implicit none
  private
  public :: read_hartree_add
contains
  subroutine read_hartree_add( )
  end subroutine read_hartree_add
end module m_hartree_add

module velocity_shift_m
  implicit none
  private
  public :: read_velocity_shift
contains
  subroutine read_velocity_shift()
  end subroutine read_velocity_shift
end module velocity_shift_m

module option_charges_m
  implicit none
  integer, parameter, public :: OPT_CHARGE_NONE = 0
  integer, parameter, public :: OPT_CHARGE_INIT = int(b'1')
  integer, parameter, public :: OPT_CHARGE_GEOMETRY = int(b'10')
  integer, parameter, public :: OPT_CHARGE_SCF = int(b'100')
  integer, parameter, public :: OPT_CHARGE_SCF_AFTER_MIX = int(b'1000')
  integer, parameter, public :: OPT_CHARGE_END = int(b'10000')

  type :: option_charge_t
    integer :: STEPS_ALLOWED
    integer :: step = 0
    integer :: format = 0
  contains
    procedure, public :: run_string => charge_t_char
    procedure, public :: run => charge_t_run
    procedure, public :: can_run => charge_t_can_run
    procedure, private :: charge_t_enable_run, charge_t_enable_run_string
    generic, public :: enable_run => charge_t_enable_run, charge_t_enable_run_string
    procedure, public :: disable_run => charge_t_disable_run
  end type
  public :: option_charge_t

  type :: option_charges_t
    type(option_charge_t) :: hirshfeld
    type(option_charge_t) :: voronoi
    type(option_charge_t) :: mulliken
    type(option_charge_t) :: spin
  end type
  public :: option_charges_t

  contains

  subroutine charge_t_enable_run_string(this, step)
    class(option_charge_t), intent(inout) :: this
    character(len=*)      , intent(in)    :: step
  end subroutine charge_t_enable_run_string

  subroutine charge_t_disable_run(this, step)
    class(option_charge_t), intent(inout) :: this
    integer, intent(in), optional :: step
  end subroutine charge_t_disable_run

  subroutine charge_t_enable_run(this, step)
    class(option_charge_t), intent(inout) :: this
    integer, intent(in) :: step
  end subroutine charge_t_enable_run

  elemental function charge_t_run(this, step) result(run)
    class(option_charge_t), intent(in) :: this
    integer, intent(in), optional :: step
    logical :: run
    run = .false.
  end function charge_t_run

  elemental function charge_t_can_run(this, step) result(run)
    class(option_charge_t), intent(in) :: this
    integer, intent(in) :: step
    logical :: run
    run = .false.
  end function charge_t_can_run

  elemental function charge_t_char(this) result(chr)
    class(option_charge_t), intent(in) :: this
    character(len=56) :: chr

    chr = ' '
  end function charge_t_char

end module option_charges_m