! Module to contain all the Gauss-Fermi quadrature points
! It has been created by an automatic script created by:
! Nick Papior Andersen, 2013, nickpapior@gmail.com
! If you ever need to use this please contact the author for approval

! We have employed the Stieltjes and moment algorithm together with the Golub-Welsch
! for an efficient and fairly accurate stability of the orthogonal polynomials.

module m_gauss_fermi_inf

  implicit none

  integer, parameter :: p = selected_real_kind(14,300)

  integer, parameter :: G_NF_MIN_N  =  2
  integer, parameter :: G_NF_MAX_N  = 17
  integer, parameter :: G_NF_MIN_kT = -20
  integer, parameter :: G_NF_MAX_kT = 5
  
  private
  public :: G_NF_MIN_N
  public :: G_NF_MAX_N
  public :: G_NF_MIN_kT
  public :: G_NF_MAX_kT
  public :: GaussFermi_inf
  
contains

  ! Die routine for the Gauss-Fermi routines
  subroutine GD(NkT)
    integer, intent(in) :: NkT
    write(*,*) 'Error in Gauss-Fermi ',NkT
    call die('Error in number of points for Gauss-Fermi, see output.')
  end subroutine GD
  
  subroutine GaussFermi_inf(NkT,N,x,w)
    integer, intent(in) :: NkT, N
    real(p), intent(out) :: x(N), w(N)
    
    if ( NkT == -20 ) then
       call GF_m20(N,x,w)
    else if ( NkT == -19 ) then
       call GF_m19(N,x,w)
    else if ( NkT == -18 ) then
       call GF_m18(N,x,w)
    else if ( NkT == -17 ) then
       call GF_m17(N,x,w)
    else if ( NkT == -16 ) then
       call GF_m16(N,x,w)
    else if ( NkT == -15 ) then
       call GF_m15(N,x,w)
    else if ( NkT == -14 ) then
       call GF_m14(N,x,w)
    else if ( NkT == -13 ) then
       call GF_m13(N,x,w)
    else if ( NkT == -12 ) then
       call GF_m12(N,x,w)
    else if ( NkT == -11 ) then
       call GF_m11(N,x,w)
    else if ( NkT == -10 ) then
       call GF_m10(N,x,w)
    else if ( NkT == -9 ) then
       call GF_m9(N,x,w)
    else if ( NkT == -8 ) then
       call GF_m8(N,x,w)
    else if ( NkT == -7 ) then
       call GF_m7(N,x,w)
    else if ( NkT == -6 ) then
       call GF_m6(N,x,w)
    else if ( NkT == -5 ) then
       call GF_m5(N,x,w)
    else if ( NkT == -4 ) then
       call GF_m4(N,x,w)
    else if ( NkT == -3 ) then
       call GF_m3(N,x,w)
    else if ( NkT == -2 ) then
       call GF_m2(N,x,w)
    else if ( NkT == -1 ) then
       call GF_m1(N,x,w)
    else if ( NkT == 0 ) then
       call GF_0(N,x,w)
    else if ( NkT == 1 ) then
       call GF_1(N,x,w)
    else if ( NkT == 2 ) then
       call GF_2(N,x,w)
    else if ( NkT == 3 ) then
       call GF_3(N,x,w)
    else if ( NkT == 4 ) then
       call GF_4(N,x,w)
    else if ( NkT == 5 ) then
       call GF_5(N,x,w)
    else
       call die('Could not figure out the Gauss-Fermi &
             &quadratue method you asked for.')
    end if
  end subroutine GaussFermi_inf
  
  
! [-20kT;infkT]
subroutine GF_m20(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-15.59867300181491_p
w(1)=10.40132057931341_p
x(2)=-3.761795334794254_p
w(2)=9.598679422747743_p
else if(N==3)then
x(1)=-17.56069617714904_p
w(1)=6.008953676528421_p
x(2)=-9.213295995556745_p
w(2)=9.514824294586044_p
x(3)=-1.155162436732046_p
w(3)=4.476222030946689_p
else if(N==4)then
x(1)=-18.43109871253158_p
w(1)=3.928604574772254_p
x(2)=-12.5578550196613_p
w(2)=7.327554038101301_p
x(3)=-5.008576968354657_p
w(3)=7.006527638623358_p
x(4)=6.703031973789981e-1_p
w(4)=1.737313750564241_p
else if(N==5)then
x(1)=-18.89086253068257_p
w(1)=2.800001804216934_p
x(2)=-14.55265566976953_p
w(2)=5.634869133395066_p
x(3)=-8.251795056131250_p
w(3)=6.590038222063018_p
x(4)=-2.226669302749292_p
w(4)=4.558760058277294_p
x(5)=2.575330427214392_p
w(5)=4.163307841088411e-1_p
else if(N==6)then
x(1)=-19.16408385966145_p
w(1)=2.120046040357872_p
x(2)=-15.81251227261988_p
w(2)=4.449478155908313_p
x(3)=-10.62333214695017_p
w(3)=5.711100387810925_p
x(4)=-4.894452357100633_p
w(4)=5.411409623036391_p
x(5)=-2.096250897805324e-1_p
w(5)=2.254377505973845_p
x(6)=4.860746544733448_p
w(6)=5.358828897380866e-2_p
else if(N==7)then
x(1)=-19.34059078579826_p
w(1)=1.677225432325356_p
x(2)=-16.6556901347836_p
w(2)=3.612032868524941_p
x(3)=-12.33651621603334_p
w(3)=4.890449861886520_p
x(4)=-7.191313942059608_p
w(4)=5.214321072135164_p
x(5)=-2.328646904925933_p
w(5)=3.909057362825768_p
x(6)=1.650831568110828_p
w(6)=6.925216813154152e-1_p
x(7)=7.486015269040595_p
w(7)=4.391723047987576e-3_p
else if(N==8)then
x(1)=-19.46189127678765_p
w(1)=1.371330712337890_p
x(2)=-17.24833759053588_p
w(2)=3.003944351026206_p
x(3)=-13.59760191538772_p
w(3)=4.207819512999689_p
x(4)=-9.043684426372778_p
w(4)=4.778581484964734_p
x(5)=-4.321229543874761_p
w(5)=4.437164267929162_p
x(6)=-3.263829344271529e-1_p
w(6)=2.086403938309132_p
x(7)=3.765173395422165_p
w(7)=1.144814528794247e-1_p
x(8)=10.34189376058689_p
w(8)=2.742816149172535e-4_p
else if(N==9)then
x(1)=-19.54929920180994_p
w(1)=1.150127891291028_p
x(2)=-17.68197584410784_p
w(2)=2.549412353787224_p
x(3)=-14.54887398529679_p
w(3)=3.654799255713877_p
x(4)=-10.51940502007361_p
w(4)=4.319442139624553_p
x(5)=-6.103558182574935_p
w(5)=4.389145912439426_p
x(6)=-1.992655191658415_p
w(6)=3.255216040119644_p
x(7)=1.525571125830642_p
w(7)=6.701671980957189e-1_p
x(8)=6.193010340434850_p
w(8)=1.167490044861822e-2_p
x(9)=13.35883244318492_p
w(9)=1.431054106403458e-5_p
else if(N==10)then
x(1)=-19.61468272042795_p
w(1)=9.842447158645075e-1_p
x(2)=-18.00990626156388_p
w(2)=2.200538111421372_p
x(3)=-15.28374171400702_p
w(3)=3.207319412970532_p
x(4)=-11.70144577838286_p
w(4)=3.895860254046847_p
x(5)=-7.631842452014737_p
w(5)=4.161376340940960_p
x(6)=-3.567593262309521_p
w(6)=3.741730275384222_p
x(7)=-7.719173304833568e-2_p
w(7)=1.691165719729973_p
x(8)=3.590736256334204_p
w(8)=1.168666525461115e-1_p
x(9)=8.845658646267566_p
w(9)=8.978640682982272e-4_p
x(10)=16.49542210035773_p
w(10)=6.550883323320337e-7_p
else if(N==11)then
x(1)=-19.66508766656747_p
w(1)=8.561241928297296e-1_p
x(2)=-18.26476096557275_p
w(2)=1.926460549973733_p
x(3)=-15.8638041532783_p
w(3)=2.842542302774394_p
x(4)=-12.65866268349835_p
w(4)=3.521870654905992_p
x(5)=-8.924531096337752_p
w(5)=3.886694048377255_p
x(6)=-5.022613018482625_p
w(6)=3.807609025308505_p
x(7)=-1.450026897676731_p
w(7)=2.636620134890845_p
x(8)=1.766952664750808_p
w(8)=5.090785251109540e-1_p
x(9)=5.932823022577261_p
w(9)=1.294280664377331e-2_p
x(10)=11.65525933005966_p
w(10)=5.773411935401895e-5_p
x(11)=19.72466959569032_p
w(11)=2.712661769042421e-8_p
else if(N==12)then
x(1)=-19.70491970697922_p
w(1)=7.547335428424637e-1_p
x(2)=-18.46740139143786_p
w(2)=1.706754687533315_p
x(3)=-16.33047299257485_p
w(3)=2.542100546335812_p
x(4)=-13.44345076400403_p
w(4)=3.196832536854960_p
x(5)=-10.01690685706252_p
w(5)=3.610860092607346_p
x(6)=-6.325019901498297_p
w(6)=3.705337409619433_p
x(7)=-2.744101107661920_p
w(7)=3.159915874111090_p
x(8)=3.777065522545868e-1_p
w(8)=1.236955753226900_p
x(9)=3.827502585005944_p
w(9)=8.540068508555666e-2_p
x(10)=8.477132285494802_p
w(10)=1.105611535628827e-3_p
x(11)=14.58255336535496_p
w(11)=3.261271157201902e-6_p
x(12)=23.02779440155184_p
w(12)=1.037490534773947e-9_p
else if(N==13)then
x(1)=-19.73705416475562_p
w(1)=6.728453456155434e-1_p
x(2)=-18.63166998994055_p
w(2)=1.527526513681529_p
x(3)=-16.71223607613085_p
w(3)=2.291920131170444_p
x(4)=-14.09478544246224_p
w(4)=2.915538471232808_p
x(5)=-10.94388567487473_p
w(5)=3.350800943458909_p
x(6)=-7.473295468142035_p
w(6)=3.542303532888327_p
x(7)=-3.967251858088885_p
w(7)=3.334876567124824_p
x(8)=-8.043099246565832e-1_p
w(8)=2.028339919598563_p
x(9)=2.230334475422021_p
w(9)=3.261059791542212e-1_p
x(10)=6.130852195596870_p
w(10)=9.662321756026292e-3_p
x(11)=11.16493739301624_p
w(11)=8.010976114173917e-5_p
x(12)=17.60269479469747_p
w(12)=1.665816161482871e-7_p
x(13)=26.39116923593885_p
w(13)=3.720027960830202e-11_p
else if(N==14)then
x(1)=-19.76343621065332_p
w(1)=6.055560405248214e-1_p
x(2)=-18.76705151154246_p
w(2)=1.379077459425347_p
x(3)=-17.02914658428721_p
w(3)=2.081354266270839_p
x(4)=-14.64162212042819_p
w(4)=2.671855749184328_p
x(5)=-11.73544594677954_p
w(5)=3.112237201933321_p
x(6)=-8.480747841760989_p
w(6)=3.360410270559719_p
x(7)=-5.098244724187010_p
w(7)=3.331581110265602_p
x(8)=-1.901946794292929_p
w(8)=2.598254041699046_p
x(9)=9.668363726543742e-1_p
w(9)=8.080974208562934e-1_p
x(10)=4.306957805447959_p
w(10)=5.069649140895955e-2_p
x(11)=8.609769248654967_p
w(11)=8.747974362993119e-4_p
x(12)=13.96231252096782_p
w(12)=5.144650902766344e-6_p
x(13)=20.69848500859545_p
w(13)=7.844411673191676e-9_p
x(14)=29.80459509531974_p
w(14)=1.264426006937047e-12_p
else if(N==15)then
x(1)=-19.78542255480206_p
w(1)=5.494376582429612e-1_p
x(2)=-18.88022829314334_p
w(2)=1.254475989984406_p
x(3)=-17.29562965074692_p
w(3)=1.902340570691907_p
x(4)=-15.10562548018762_p
w(4)=2.460012877281205_p
x(5)=-12.41610060989606_p
w(5)=2.896145780503053_p
x(6)=-9.364752385966169_p
w(6)=3.177360552523300_p
x(7)=-6.127526331449111_p
w(7)=3.250185520386895_p
x(8)=-2.949577628310765_p
w(8)=2.888362666399352_p
x(9)=-9.838579906568046e-2_p
w(9)=1.435318475221152_p
x(10)=2.849892651548303_p
w(10)=1.805714965739970e-1_p
x(11)=6.592459615534564_p
w(11)=5.719646693601742e-3_p
x(12)=11.21642970615475_p
w(12)=6.846688852483986e-5_p
x(13)=16.84780078900069_p
w(13)=3.003254332632861e-7_p
x(14)=23.85734532541331_p
w(14)=3.453250879111445e-10_p
x(15)=33.26024692626537_p
w(15)=4.108625627685484e-14_p
else if(N==16)then
x(1)=-19.80398464275003_p
w(1)=5.020311187678407e-1_p
x(2)=-18.97602403135512_p
w(2)=1.148661564774744_p
x(3)=-17.52227091962527_p
w(3)=1.748731275985970_p
x(4)=-15.50317608297341_p
w(4)=2.274987147215812_p
x(5)=-13.00553862251178_p
w(5)=2.701485892982864_p
x(6)=-10.14239856209119_p
w(6)=3.001051810851880_p
x(7)=-7.056912506594921_p
w(7)=3.135999542788255_p
x(8)=-3.941637651758770_p
w(8)=2.985860613178784_p
x(9)=-1.062932274950569_p
w(9)=2.010453816413300_p
x(10)=1.660585651493235_p
w(10)=4.642662574535880e-1_p
x(11)=4.950292519717981_p
w(11)=2.592974788679539e-2_p
x(12)=9.028051208472112_p
w(12)=5.363954088062528e-4_p
x(13)=13.92301657307198_p
w(13)=4.802129147911623e-6_p
x(14)=19.80644382621807_p
w(14)=1.620900481033295e-8_p
x(15)=27.06973183210022_p
w(15)=1.436025964908819e-11_p
x(16)=36.75199528941828_p
w(16)=1.284751489870714e-15_p
else if(N==17)then
x(1)=-19.81983410474521_p
w(1)=4.615322885123728e-1_p
x(2)=-19.05799583764061_p
w(2)=1.057868185564688_p
x(3)=-17.71698087967642_p
w(3)=1.615794099045188_p
x(4)=-15.84680465083466_p
w(4)=2.112550476229670_p
x(5)=-13.51949748468829_p
w(5)=2.526432485057623_p
x(6)=-10.82900554482041_p
w(6)=2.834913476982563_p
x(7)=-7.893683565025416_p
w(7)=3.009409666749765_p
x(8)=-4.868133938188313_p
w(8)=2.980443818299084_p
x(9)=-1.976618025606301_p
w(9)=2.405844322768957_p
x(10)=6.582606085273948e-1_p
w(10)=9.041796060052063e-1_p
x(11)=3.588918697810794_p
w(11)=8.808727005571149e-2_p
x(12)=7.226559008556424_p
w(12)=2.899691158817529e-3_p
x(13)=11.57635755670031_p
w(13)=4.430652888729884e-5_p
x(14)=16.71159884048039_p
w(14)=3.082832294300767e-7_p
x(15)=22.82716910661676_p
w(15)=8.188216619803338e-10_p
x(16)=30.32820232033592_p
w(16)=5.686809410402574e-13_p
x(17)=40.27495314099827_p
w(17)=3.886306729241489e-17_p
else
call GD(-20)
end if
end subroutine GF_m20

! [-19kT;infkT]
subroutine GF_m19(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.80201381311547_p
w(1)=9.919648068191373_p
x(2)=-3.526768404939610_p
w(2)=9.080351937411423_p
else if(N==3)then
x(1)=-16.66602162625121_p
w(1)=5.749160063020812_p
x(2)=-8.682923500907314_p
w(2)=9.091369949889410_p
x(3)=-9.856472858292772e-1_p
w(3)=4.159469992692573_p
else if(N==4)then
x(1)=-17.49427658086179_p
w(1)=3.770229297589282_p
x(2)=-11.85930459188424_p
w(2)=7.027560302434473_p
x(3)=-4.631462365584170_p
w(3)=6.664636510494388_p
x(4)=8.528756941940310e-1_p
w(4)=1.537573895084653_p
else if(N==5)then
x(1)=-17.93258388516578_p
w(1)=2.694564580828685_p
x(2)=-13.75863733511359_p
w(2)=5.420032329739570_p
x(3)=-7.703171398341638_p
w(3)=6.322857946361100_p
x(4)=-1.942133983166052_p
w(4)=4.225538670594744_p
x(5)=2.819884196069364_p
w(5)=3.370064780786974e-1_p
else if(N==6)then
x(1)=-18.19355631457084_p
w(1)=2.045219425933743_p
x(2)=-14.9608870421208_p
w(2)=4.290671251634665_p
x(3)=-9.959787432010831_p
w(3)=5.499458337860428_p
x(4)=-4.456945239697077_p
w(4)=5.154153355471656_p
x(5)=4.421738263772694e-2_p
w(5)=1.970897942515073_p
x(6)=5.178425022782308_p
w(6)=3.959969218723200e-2_p
else if(N==7)then
x(1)=-18.36247040117996_p
w(1)=1.621516106143955_p
x(2)=-15.76718804759129_p
w(2)=3.490799595063441_p
x(3)=-11.59484816147048_p
w(3)=4.721446837906120_p
x(4)=-6.634517239902546_p
w(4)=5.012604364354215_p
x(5)=-1.979186255707338_p
w(5)=3.602101106913148_p
x(6)=1.943670613002912_p
w(6)=5.484961827618048e-1_p
x(7)=7.863285963536075_p
w(7)=3.035812460112327e-3_p
else if(N==8)then
x(1)=-18.47876304855901_p
w(1)=1.328290230539274_p
x(2)=-16.3350127246853_p
w(2)=2.908724269928566_p
x(3)=-12.80131436180361_p
w(3)=4.071077459900543_p
x(4)=-8.399618530045927_p
w(4)=4.612042759892961_p
x(5)=-3.857101961127709_p
w(5)=4.212839056276384_p
x(6)=-1.737429879710975e-2_p
w(6)=1.785160007094370_p
x(7)=4.126886910364783_p
w(7)=8.168584342888947e-2_p
x(8)=10.76613960308552_p
w(8)=1.803785418083903e-4_p
else if(N==9)then
x(1)=-18.56270436210288_p
w(1)=1.115885460627803_p
x(2)=-16.7512300440497_p
w(2)=2.472788007131112_p
x(3)=-13.71326975732636_p
w(3)=3.542487837704410_p
x(4)=-9.810465628293210_p
w(4)=4.179570118221152_p
x(5)=-5.546655227880795_p
w(5)=4.216942178003018_p
x(6)=-1.609825621355609_p
w(6)=2.952736917885460_p
x(7)=1.866937401036721_p
w(7)=5.118232766614783e-1_p
x(8)=6.612704431954331_p
w(8)=7.757165837078883e-3_p
x(9)=13.82140951203918_p
w(9)=9.043531285259288e-6_p
else if(N==10)then
x(1)=-18.6255933726759_p
w(1)=9.563476047396374e-1_p
x(2)=-17.0665024202783_p
w(2)=2.137598899791375_p
x(3)=-14.41905799682345_p
w(3)=3.113706973546405_p
x(4)=-10.94336197485319_p
w(4)=3.777148553196124_p
x(5)=-7.003450056156724_p
w(5)=4.018703242204241_p
x(6)=-3.094760943682705_p
w(6)=3.519091781860367_p
x(7)=2.724966432760223e-1_p
w(7)=1.396804665613420_p
x(8)=3.996648477140828_p
w(8)=8.002938328903186e-2_p
x(9)=9.309041718602215_p
w(9)=5.685008234276501e-4_p
x(10)=16.99007163187573_p
w(10)=4.005387685141270e-7_p
else if(N==11)then
x(1)=-18.6741455204556_p
w(1)=8.329479402598071e-1_p
x(2)=-17.31188825348771_p
w(2)=1.873853326513616_p
x(3)=-14.97708434266134_p
w(3)=2.763447143356643_p
x(4)=-11.86266631109308_p
w(4)=3.420156949306753_p
x(5)=-8.240267448484136_p
w(5)=3.764505832301117_p
x(6)=-4.472186251121821_p
w(6)=3.642743004098151_p
x(7)=-1.049746264665105_p
w(7)=2.323795884776085_p
x(8)=2.154478082512909_p
w(8)=3.702433923989825e-1_p
x(9)=6.392262724365528_p
w(9)=8.271275773679029e-3_p
x(10)=12.153229095278_p
w(10)=3.524068896823020e-5_p
x(11)=20.24662705561505_p
w(11)=1.612899325275921e-8_p
else if(N==12)then
x(1)=-18.7125646123214_p
w(1)=7.351619643893312e-1_p
x(2)=-17.50726885509446_p
w(2)=1.662123748213714_p
x(3)=-15.42669323937674_p
w(3)=2.474446092859394_p
x(4)=-12.61770272739028_p
w(4)=3.108885787314475_p
x(5)=-9.288255101055414_p
w(5)=3.504605049759478_p
x(6)=-5.712423285863728_p
w(6)=3.572534074581270_p
x(7)=-2.273215843849831_p
w(7)=2.914703897319273_p
x(8)=7.626260597197106e-1_p
w(8)=9.709301927357825e-1_p
x(9)=4.275877759708590_p
w(9)=5.593142162947065e-2_p
x(10)=8.976011405201126_p
w(10)=6.758438369507614e-4_p
x(11)=15.10906980893074_p
w(11)=1.932361423151654e-6_p
x(12)=23.57332644084623_p
w(12)=6.022345755282065e-10_p
else if(N==13)then
x(1)=-18.74359728555937_p
w(1)=6.560873460949936e-1_p
x(2)=-17.66585290057036_p
w(2)=1.489174161957236_p
x(3)=-15.79499799224657_p
w(3)=2.233413374947048_p
x(4)=-13.24531972143346_p
w(4)=2.838837388855251_p
x(5)=-10.17946446146363_p
w(5)=3.257513837211535_p
x(6)=-6.810653986403598_p
w(6)=3.429336862751374_p
x(7)=-3.429076546216255_p
w(7)=3.156511905195813_p
x(8)=-3.914157546240498e-1_p
w(8)=1.709038295068293_p
x(9)=2.662449642307967_p
w(9)=2.240898519128848e-1_p
x(10)=6.626777465000019_p
w(10)=5.949504401094711e-3_p
x(11)=11.69462151242283_p
w(11)=4.738091447173444e-5_p
x(12)=18.15338453636227_p
w(12)=9.627165580187031e-8_p
x(13)=26.95729047630613_p
w(13)=2.114690504270728e-11_p
else if(N==14)then
x(1)=-18.76910367308258_p
w(1)=5.910358886768120e-1_p
x(2)=-17.79670176466_p
w(2)=1.345752159359328_p
x(3)=-16.10111416649267_p
w(3)=2.030261450438067_p
x(4)=-13.77297612079927_p
w(4)=2.604423530400724_p
x(5)=-10.94183484224786_p
w(5)=3.029716199049524_p
x(6)=-7.777208961010864_p
w(6)=3.261636679431878_p
x(7)=-4.503486443272602_p
w(7)=3.194763127092679_p
x(8)=-1.437875217265061_p
w(8)=2.315608957014369_p
x(9)=1.388248091489507_p
w(9)=5.945085373850482e-1_p
x(10)=4.794802292034820_p
w(10)=3.177262751454420e-2_p
x(11)=9.140448022354796_p
w(11)=5.178816288665899e-4_p
x(12)=14.51727886499724_p
w(12)=2.963172596487001e-6_p
x(13)=21.27001345871336_p
w(13)=4.437655310994864e-9_p
x(14)=30.38887869310355_p
w(14)=7.056713293973093e-13_p
else if(N==15)then
x(1)=-18.79038253544306_p
w(1)=5.367266724616648e-1_p
x(2)=-17.9062068180608_p
w(2)=1.225236354722265_p
x(3)=-16.35881205399733_p
w(3)=1.857331770959399_p
x(4)=-14.2212660437112_p
w(4)=2.400289379302373_p
x(5)=-11.59839508518266_p
w(5)=2.822666112769924_p
x(6)=-8.627341425307675_p
w(6)=3.089712360202088_p
x(7)=-5.486165887893653_p
w(7)=3.137841263995727_p
x(8)=-2.428255004029888_p
w(8)=2.673811115547103_p
x(9)=3.311726746592434e-1_p
w(9)=1.135810218474002_p
x(10)=3.324683336027647_p
w(10)=1.171321782022793e-1_p
x(11)=7.121327882647225_p
w(11)=3.403043649158469e-3_p
x(12)=11.77426623052702_p
w(12)=3.936593949432487e-5_p
x(13)=17.42414611033031_p
w(13)=1.691855395304558e-7_p
x(14)=24.44708700655815_p
w(14)=1.917556450855681e-10_p
x(15)=33.86069210370499_p
w(15)=2.255836604401734e-14_p
else if(N==16)then
x(1)=-18.80836476264819_p
w(1)=4.908036905097590e-1_p
x(2)=-17.9989867481037_p
w(2)=1.122786703096660_p
x(3)=-16.57821001369954_p
w(3)=1.708772148620909_p
x(4)=-14.60579159883605_p
w(4)=2.221731299045083_p
x(5)=-12.16773590550839_p
w(5)=2.635664605415907_p
x(6)=-9.376619924810511_p
w(6)=2.922550158050808_p
x(7)=-6.376833759887580_p
w(7)=3.039414461996731_p
x(8)=-3.367885083308305_p
w(8)=2.826443592624575_p
x(9)=-6.033130433928988e-1_p
w(9)=1.698053071411018_p
x(10)=2.121731374459842_p
w(10)=3.178609230329605e-1_p
x(11)=5.473788003770952_p
w(11)=1.560814284259962e-2_p
x(12)=9.587085531946229_p
w(12)=3.085030737628147e-4_p
x(13)=14.50317651846941_p
w(13)=2.696914745295066e-6_p
x(14)=20.40123357066261_p
w(14)=8.959431999103726e-9_p
x(15)=27.67557129851711_p
w(15)=7.844596451978893e-12_p
x(16)=37.36693205656168_p
w(16)=6.951445379367009e-16_p
else if(N==17)then
x(1)=-18.82373293442323_p
w(1)=4.515367360356218e-1_p
x(2)=-18.07845100991899_p
w(2)=1.034797162709826_p
x(3)=-16.76687852519049_p
w(3)=1.580069686055906_p
x(4)=-14.93850849765526_p
w(4)=2.064766564514975_p
x(5)=-12.66477063799024_p
w(5)=2.467146435473467_p
x(6)=-10.03924067115027_p
w(6)=2.764123805599797_p
x(7)=-7.181023529898700_p
w(7)=2.924127948468993_p
x(8)=-4.249600945695697_p
w(8)=2.856368069154074_p
x(9)=-1.473323224677703_p
w(9)=2.139108876959195_p
x(10)=1.113891611508485_p
w(10)=6.620331088867097e-1_p
x(11)=4.103033190658738_p
w(11)=5.422375443802178e-2_p
x(12)=7.784804215146700_p
w(12)=1.672848278802336e-3_p
x(13)=12.15919065396723_p
w(13)=2.483882235081853e-5_p
x(14)=17.31067900222774_p
w(14)=1.697595756830556e-7_p
x(15)=23.43811120544429_p
w(15)=4.451734182512990e-10_p
x(16)=30.9484038779931_p
w(16)=3.061599544697266e-13_p
x(17)=40.90297227542177_p
w(17)=2.075214066545992e-17_p
else
call GD(-19)
end if
end subroutine GF_m19

! [-18kT;infkT]
subroutine GF_m18(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.00466036073876_p
w(1)=9.439548871515244_p
x(2)=-3.289241401608763_p
w(2)=8.560451143714735_p
else if(N==3)then
x(1)=-15.77082961298327_p
w(1)=5.490612559405316_p
x(2)=-8.150660643969207_p
w(2)=8.668234971519464_p
x(3)=-8.100978690398901e-1_p
w(3)=3.841152484305199_p
else if(N==4)then
x(1)=-16.55710073043468_p
w(1)=3.612723223930193_p
x(2)=-11.15925554048769_p
w(2)=6.728671217268861_p
x(3)=-4.252903077003987_p
w(3)=6.315427452950114_p
x(4)=1.047529358812038_p
w(4)=1.343178121080811_p
else if(N==5)then
x(1)=-16.97406822056003_p
w(1)=2.589715345102509_p
x(2)=-12.96355782004749_p
w(2)=5.206113472896976_p
x(3)=-7.153077626938813_p
w(3)=6.054182790223568_p
x(4)=-1.654995978801906_p
w(4)=3.882542016326300_p
x(5)=3.082197629610171_p
w(5)=2.674463906806258e-1_p
else if(N==6)then
x(1)=-17.22287033384974_p
w(1)=1.970787770570362_p
x(2)=-14.10853369923916_p
w(2)=4.132531325785859_p
x(3)=-9.295039324426474_p
w(3)=5.287709441311396_p
x(4)=-4.019666495316222_p
w(4)=4.886033052826970_p
x(5)=3.086912876879329e-1_p
w(5)=1.694251046225133_p
x(6)=5.514742030693133_p
w(6)=2.868737851026002e-2_p
else if(N==7)then
x(1)=-17.38424405806274_p
w(1)=1.566071526894235_p
x(2)=-14.8781931173696_p
w(2)=3.370028797419097_p
x(3)=-10.85231086349047_p
w(3)=4.552568972187516_p
x(4)=-6.077572684146050_p
w(4)=4.806936841612527_p
x(5)=-1.629415336104333_p
w(5)=3.278725538310399_p
x(6)=2.255939485842282_p
w(6)=4.236077912500349e-1_p
x(7)=8.258271597019895_p
w(7)=2.060547556171015e-3_p
else if(N==8)then
x(1)=-17.49556417733067_p
w(1)=1.285426341553343_p
x(2)=-15.42135835617337_p
w(2)=2.813815275947039_p
x(3)=-12.00443429128588_p
w(3)=3.934460960162416_p
x(4)=-7.755293466891800_p
w(4)=4.443971885364344_p
x(5)=-3.395270534350739_p
w(5)=3.972178628059518_p
x(6)=3.020348580084773e-1_p
w(6)=1.493109321917914_p
x(7)=4.509299977332863_p
w(7)=5.692098531354819e-2_p
x(8)=11.20712693795855_p
w(8)=1.166169118578818e-4_p
else if(N==9)then
x(1)=-17.57606295673883_p
w(1)=1.081759295551178_p
x(2)=-15.82026822827559_p
w(2)=2.396365807664711_p
x(3)=-12.87728143237631_p
w(3)=3.430255077335824_p
x(4)=-9.101340175086325_p
w(4)=4.038930974486370_p
x(5)=-4.991430550972884_p
w(5)=4.036904388850897_p
x(6)=-1.227401321288712_p
w(6)=2.631517697566705_p
x(7)=2.229235414658248_p
w(7)=3.792081317595585e-1_p
x(8)=7.051122065463515_p
w(8)=5.053018071152041e-3_p
x(9)=14.29982757029218_p
w(9)=5.623943584095880e-6_p
else if(N==10)then
x(1)=-17.63647410542629_p
w(1)=9.285249510842198e-1_p
x(2)=-16.12296196212716_p
w(2)=2.074784011780542_p
x(3)=-13.55414253388296_p
w(3)=3.020123262269669_p
x(4)=-10.1852036104876_p
w(4)=3.657949582794688_p
x(5)=-6.376180878252589_p
w(5)=3.872359982577665_p
x(6)=-2.626170610464742_p
w(6)=3.272820233421733_p
x(7)=6.347769231026557e-1_p
w(7)=1.119675756012619_p
x(8)=4.424166493052695_p
w(8)=5.340831289361422e-2_p
x(9)=9.789504844819310_p
w(9)=3.536811853381303e-4_p
x(10)=17.49973147181752_p
w(10)=2.412098907952433e-7_p
else if(N==11)then
x(1)=-17.68318511428275_p
w(1)=8.098168175212295e-1_p
x(2)=-16.35893495064834_p
w(2)=1.821314816632631_p
x(3)=-14.09024305447193_p
w(3)=2.684338602757518_p
x(4)=-11.06669785231243_p
w(4)=3.318074349741819_p
x(5)=-7.556861297430753_p
w(5)=3.640318527375998_p
x(6)=-3.925642975145728_p
w(6)=3.463467529723903_p
x(7)=-6.482571320020386e-1_p
w(7)=1.997187257400571_p
x(8)=2.564569570001311_p
w(8)=2.602813939606162e-1_p
x(9)=6.870626421719130_p
w(9)=5.179544888819780e-3_p
x(10)=12.66704732057075_p
w(10)=2.116577386043103e-5_p
x(11)=20.78283666511255_p
w(11)=9.453015306112074e-9_p
else if(N==12)then
x(1)=-17.72019951638099_p
w(1)=7.156147242218146e-1_p
x(2)=-16.54709558133075_p
w(2)=1.617521682305367_p
x(3)=-14.52287157895458_p
w(3)=2.406745520798481_p
x(4)=-11.79206503408608_p
w(4)=3.020626728631731_p
x(5)=-8.560343969865704_p
w(5)=3.397073064542594_p
x(6)=-5.102779713821126_p
w(6)=3.432128287023573_p
x(7)=-1.807435250902053_p
w(7)=2.639857513738948_p
x(8)=1.164254922159430_p
w(8)=7.343312397921837e-1_p
x(9)=4.745836933228706_p
w(9)=3.569417935346201e-2_p
x(10)=9.491823199787207_p
w(10)=4.059466504628724e-4_p
x(11)=15.6504343170835_p
w(11)=1.127826530110683e-6_p
x(12)=24.13242389242166_p
w(12)=3.448329247706099e-10_p
else if(N==13)then
x(1)=-17.75013630776125_p
w(1)=6.393388197412255e-1_p
x(2)=-16.70002360768251_p
w(2)=1.450822071957548_p
x(3)=-14.87777535118601_p
w(3)=2.174836080722304_p
x(4)=-12.39602691399786_p
w(4)=2.761854386468938_p
x(5)=-9.415731394778874_p
w(5)=3.163303885287581_p
x(6)=-6.150300495935233_p
w(6)=3.312148218765542_p
x(7)=-2.897025260979644_p
w(7)=2.953888774208147_p
x(8)=2.732248679695939e-2_p
w(8)=1.391442367500201_p
x(9)=3.118105058178589_p
w(9)=1.487467271931289e-1_p
x(10)=7.141231012736632_p
w(10)=3.591047573535875e-3_p
x(11)=12.23985140236894_p
w(11)=2.758094514638735e-5_p
x(12)=18.71807490504211_p
w(12)=5.485481687636605e-8_p
x(13)=27.53635701193173_p
w(13)=1.186552581431423e-11_p
else if(N==14)then
x(1)=-17.77477128275375_p
w(1)=5.765145185758825e-1_p
x(2)=-16.82636033101532_p
w(2)=1.312406556322444_p
x(3)=-15.1731384467621_p
w(3)=1.979080399902698_p
x(4)=-12.90454889213718_p
w(4)=2.536727896308690_p
x(5)=-10.14888588121864_p
w(5)=2.946468464285473_p
x(6)=-7.075542881211831_p
w(6)=3.160257018290840_p
x(7)=-3.913970301714333_p
w(7)=3.042958673256199_p
x(8)=-9.770693550479351e-1_p
w(8)=2.006399599879354_p
x(9)=1.830755621117856_p
w(9)=4.194533051728845e-1_p
x(10)=5.303473962650494_p
w(10)=1.943051075545416e-2_p
x(11)=9.687594523823842_p
w(11)=3.013882639149480e-4_p
x(12)=15.08672305670697_p
w(12)=1.681738753588219e-6_p
x(13)=21.85481015255117_p
w(13)=2.477001300124525e-9_p
x(14)=30.98554766439064_p
w(14)=3.889564058562031e-13_p
else if(N==15)then
x(1)=-17.79534572814586_p
w(1)=5.240067551834983e-1_p
x(2)=-16.93220842951383_p
w(2)=1.195961663570754_p
x(3)=-15.42208070351338_p
w(3)=1.812222261923807_p
x(4)=-13.33715800219586_p
w(4)=2.340315335588433_p
x(5)=-10.78133586584909_p
w(5)=2.748580159550706_p
x(6)=-7.891539848856336_p
w(6)=3.000278674189949_p
x(7)=-4.849019382552180_p
w(7)=3.016732452699959_p
x(8)=-1.914173350839229_p
w(8)=2.425502565077501_p
x(9)=7.736182553888971e-1_p
w(9)=8.608227465657522e-1_p
x(10)=3.822748106540838_p
w(10)=7.356842521513036e-2_p
x(11)=7.667967690854132_p
w(11)=1.986594528849945e-3_p
x(12)=12.34716569344802_p
w(12)=2.228702725555191e-5_p
x(13)=18.01409639469198_p
w(13)=9.400323872776962e-8_p
x(14)=25.04945601447258_p
w(14)=1.051326753013675e-10_p
x(15)=34.47301621799561_p
w(15)=1.223864208553232e-14_p
else if(N==16)then
x(1)=-17.81275030727938_p
w(1)=4.795617678666628e-1_p
x(2)=-17.02198316655575_p
w(2)=1.096866263126989_p
x(3)=-15.63425633985093_p
w(3)=1.668703816768661_p
x(4)=-13.70868094150189_p
w(4)=2.168235016588304_p
x(5)=-11.33056689477798_p
w(5)=2.569317521458913_p
x(6)=-8.612273800828289_p
w(6)=2.842717527781701_p
x(7)=-5.700184979818200_p
w(7)=2.937504867257536_p
x(8)=-2.801722039958980_p
w(8)=2.640388579523079_p
x(9)=-1.410853355000634e-1_p
w(9)=1.378590660544907_p
x(10)=2.606640729889556_p
w(10)=2.087508338543626e-1_p
x(11)=6.016906969110737_p
w(11)=9.187118998485658e-3_p
x(12)=10.16194162538579_p
w(12)=1.745434134392519e-4_p
x(13)=15.0973361531929_p
w(13)=1.493154472894365e-6_p
x(14)=21.00889187529517_p
w(14)=4.888232143040211e-9_p
x(15)=28.29347185291397_p
w(15)=4.233533518457128e-12_p
x(16)=37.99328846372791_p
w(16)=3.718340743778614e-16_p
else if(N==17)then
x(1)=-17.82763878003004_p
w(1)=4.415226952169720e-1_p
x(2)=-17.09894746020112_p
w(2)=1.011673141345161_p
x(3)=-15.81689809065359_p
w(3)=1.544230575163575_p
x(4)=-14.03050086296262_p
w(4)=2.016750935763837_p
x(5)=-11.81066530583981_p
w(5)=2.407392172268684_p
x(6)=-9.250781599881201_p
w(6)=2.692277766033267_p
x(7)=-6.471240951683964_p
w(7)=2.835376108701214_p
x(8)=-3.637706945973269_p
w(8)=2.714665810568893_p
x(9)=-9.750652173681323e-1_p
w(9)=1.840786189530217_p
x(10)=1.589343396093912_p
w(10)=4.619141848467788e-1_p
x(11)=4.639093150313913_p
w(11)=3.244863884839515e-2_p
x(12)=8.359898271173018_p
w(12)=9.479848435329689e-4_p
x(13)=12.75650746606672_p
w(13)=1.371961905682396e-5_p
x(14)=17.92290221842357_p
w(14)=9.224117214788515e-8_p
x(15)=24.06128812725705_p
w(15)=2.390588527723052e-10_p
x(16)=31.58016226754206_p
w(16)=1.629212443915578e-13_p
x(17)=41.54199317170228_p
w(17)=1.095952099696873e-17_p
else
call GD(-18)
end if
end subroutine GF_m18

! [-17kT;infkT]
subroutine GF_m17(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-13.20653105302386_p
w(1)=8.961195868401102_p
x(2)=-3.048806096358868_p
w(2)=8.038804172998274_p
else if(N==3)then
x(1)=-14.8750769086945_p
w(1)=5.233410363653921_p
x(2)=-7.616418692607541_p
w(2)=8.245051535589660_p
x(3)=-6.275440724601082e-1_p
w(3)=3.521538142155794_p
else if(N==4)then
x(1)=-15.6195515459349_p
w(1)=3.456131865301683_p
x(2)=-10.45765608367017_p
w(2)=6.430831912166185_p
x(3)=-3.872959902779743_p
w(3)=5.957222597071654_p
x(4)=1.255977414549942_p
w(4)=1.155813666859854_p
else if(N==5)then
x(1)=-16.01530816166952_p
w(1)=2.485470690196998_p
x(2)=-12.16740167675782_p
w(2)=4.993086948643365_p
x(3)=-6.601664594514566_p
w(3)=5.783133301863342_p
x(4)=-1.364382301899727_p
w(4)=3.530576523560669_p
x(5)=3.363792820741406_p
w(5)=2.077325771350040e-1_p
else if(N==6)then
x(1)=-16.2520246207372_p
w(1)=1.896753114740103_p
x(2)=-13.25545789493357_p
w(2)=3.975030649925132_p
x(3)=-8.629193683237538_p
w(3)=5.075526480791626_p
x(4)=-3.582992313036415_p
w(4)=4.604222778895665_p
x(5)=5.860609982267795e-1_p
w(5)=1.428111767373783_p
x(6)=5.870638701252592_p
w(6)=2.035524967306769e-2_p
else if(N==7)then
x(1)=-16.40591341521856_p
w(1)=1.510886648062215_p
x(2)=-13.98872156673365_p
w(2)=3.249689791131861_p
x(3)=-10.10899391799916_p
w(3)=4.383646361614995_p
x(4)=-5.520914159459844_p
w(4)=4.595626075422028_p
x(5)=-1.278271911245498_p
w(5)=2.940395831532197_p
x(6)=2.589494666339033_p
w(6)=3.183830220720140e-1_p
x(7)=8.671688104963510_p
w(7)=1.372311564067138e-3_p
else if(N==8)then
x(1)=-16.51229770572805_p
w(1)=1.242730711074507_p
x(2)=-14.50739541187791_p
w(2)=2.719185791175351_p
x(3)=-11.20704339629164_p
w(3)=3.797855836231221_p
x(4)=-7.111022975322052_p
w(4)=4.273612487504830_p
x(5)=-2.936224661932860_p
w(5)=3.711331934829461_p
x(6)=6.348417916622613e-1_p
w(6)=1.216490791707564_p
x(7)=4.913141933079933_p
w(7)=3.871841402827233e-2_p
x(8)=11.66544488731892_p
w(8)=7.407484817028511e-5_p
else if(N==9)then
x(1)=-16.58937861487619_p
w(1)=1.047739709247107_p
x(2)=-14.88911294016845_p
w(2)=2.320114798886117_p
x(3)=-12.04098451056026_p
w(3)=3.318012907553513_p
x(4)=-8.392266027775193_p
w(4)=3.897134587623965_p
x(5)=-4.438613909149009_p
w(5)=3.845928587400503_p
x(6)=-8.435148301329284e-1_p
w(6)=2.295708317591756_p
x(7)=2.614362218564612_p
w(7)=2.721319456412546e-1_p
x(8)=7.508745681412485_p
w(8)=3.225747532557502e-3_p
x(9)=14.79458320719674_p
w(9)=3.439922603102300e-6_p
else if(N==10)then
x(1)=-16.64732872725292_p
w(1)=9.007667029227658e-1_p
x(2)=-15.17930746885458_p
w(2)=2.012063926852444_p
x(3)=-12.68906504261358_p
w(3)=2.926495480063648_p
x(4)=-9.427162711281078_p
w(4)=3.538023217878097_p
x(5)=-5.750617316330634_p
w(5)=3.720713903630950_p
x(6)=-2.161975230284154_p
w(6)=2.999267126118565_p
x(7)=1.013289502337840_p
w(7)=8.677132318130822e-1_p
x(8)=4.873728116465605_p
w(8)=3.474019712962719e-2_p
x(9)=10.28747249601894_p
w(9)=2.161119806073847e-4_p
x(10)=18.02483043438926_p
w(10)=1.430095895939777e-7_p
else if(N==11)then
x(1)=-16.69221022919786_p
w(1)=7.867209061422892e-1_p
x(2)=-15.40592290055188_p
w(2)=1.768817290572990_p
x(3)=-13.20334451969499_p
w(3)=2.605154245748385_p
x(4)=-10.27091967396488_p
w(4)=3.215454214836434_p
x(5)=-6.874755478768686_p
w(5)=3.513270466304906_p
x(6)=-3.383905456944808_p
w(6)=3.264716979002117_p
x(7)=-2.423092001624823e-1_p
w(7)=1.665873721932710_p
x(8)=2.998683713513314_p
w(8)=1.768017612428917e-1_p
x(9)=7.368184817286602_p
w(9)=3.177946362688653e-3_p
x(10)=13.19708981581959_p
w(10)=1.250379487159613e-5_p
x(11)=21.33367722166336_p
w(11)=5.459093698288151e-9_p
else if(N==12)then
x(1)=-16.72782807074501_p
w(1)=6.960822802685701e-1_p
x(2)=-15.58690232242892_p
w(2)=1.572922645583197_p
x(3)=-13.61906712428914_p
w(3)=2.338944112074135_p
x(4)=-10.96667875707882_p
w(4)=2.931926231586765_p
x(5)=-7.833522110719811_p
w(5)=3.287761499640254_p
x(6)=-4.496995656601631_p
w(6)=3.280759451214548_p
x(7)=-1.345719134994456_p
w(7)=2.335638053765647_p
x(8)=1.586244852272438_p
w(8)=5.335148486105576e-1_p
x(9)=5.237507343682971_p
w(9)=2.221073700347426e-2_p
x(10)=10.02485266409726_p
w(10)=2.395332640338792e-4_p
x(11)=16.20698262965185_p
w(11)=6.481934958534662e-7_p
x(12)=24.70542792317458_p
w(12)=1.946997258015871e-10_p
else if(N==13)then
x(1)=-16.75667470674582_p
w(1)=6.225907084347373e-1_p
x(2)=-15.73420164245498_p
w(2)=1.412446243754221_p
x(3)=-13.96062257052315_p
w(3)=2.116139610115114_p
x(4)=-11.54703175936995_p
w(4)=2.684484954844889_p
x(5)=-8.652972163438273_p
w(5)=3.067844385939379_p
x(6)=-5.492968411804681_p
w(6)=3.188801611432971_p
x(7)=-2.371720012848556_p
w(7)=2.721048724555895_p
x(8)=4.565193355782611e-1_p
w(8)=1.089031079869192_p
x(9)=3.597989706114166_p
w(9)=9.547198090366207e-2_p
x(10)=7.674330740813271_p
w(10)=2.124913208587125e-3_p
x(11)=12.800903610489_p
w(11)=1.579752748048652e-5_p
x(12)=19.29707073233113_p
w(12)=3.080667981167197e-8_p
x(13)=28.1286810625966_p
w(13)=6.569486660298942e-12_p
else if(N==14)then
x(1)=-16.78044232178904_p
w(1)=5.619833917986424e-1_p
x(2)=-15.8560455067851_p
w(2)=1.279018388182970_p
x(3)=-14.24526958357586_p
w(3)=1.927767438120449_p
x(4)=-12.0364520819157_p
w(4)=2.468681121764234_p
x(5)=-9.356840671783393_p
w(5)=2.862261647975972_p
x(6)=-6.376330585260235_p
w(6)=3.055141469512693_p
x(7)=-3.330824443359534_p
w(7)=2.870216301962174_p
x(8)=-5.163547126571134e-1_p
w(8)=1.679550061351175_p
x(9)=2.297031645834148_p
w(9)=2.836021174524697e-1_p
x(10)=5.832874100103585_p
w(10)=1.160476120846650e-2_p
x(11)=10.25139252906875_p
w(11)=1.724004396815735e-4_p
x(12)=15.67090575804485_p
w(12)=9.402664172532157e-7_p
x(13)=22.45315614207732_p
w(13)=1.363820760409445e-9_p
x(14)=31.59489146887975_p
w(14)=2.116719951049766e-13_p
else if(N==15)then
x(1)=-16.80031522036793_p
w(1)=5.112698857494048e-1_p
x(2)=-15.95825023314459_p
w(2)=1.166631259148254_p
x(3)=-14.48548192009084_p
w(3)=1.766972512180454_p
x(4)=-12.45340219725809_p
w(4)=2.280015240125559_p
x(5)=-9.965132094111107_p
w(5)=2.673711064113284_p
x(6)=-7.157817200787120_p
w(6)=2.908358783190628_p
x(7)=-4.217173714513158_p
w(7)=2.882741606225907_p
x(8)=-1.406502395487769_p
w(8)=2.141899654849193_p
x(9)=1.233827947879315_p
w(9)=6.224270135039514e-1_p
x(10)=4.344079498596900_p
w(10)=4.482249524268498e-2_p
x(11)=8.232406870862759_p
w(11)=1.138053381997196e-3_p
x(12)=12.93533038008362_p
w(12)=1.242212888829169e-5_p
x(13)=18.61789739735637_p
w(13)=5.150226918660527e-8_p
x(14)=25.66471479878496_p
w(14)=5.689624887542685e-11_p
x(15)=35.09749046133253_p
w(15)=6.559275971809290e-15_p
else if(N==16)then
x(1)=-16.8171441760954_p
w(1)=4.682978269218593e-1_p
x(2)=-16.04502927349038_p
w(2)=1.070881053161576_p
x(3)=-14.69045277229381_p
w(3)=1.628490269329518_p
x(4)=-12.81193584961219_p
w(4)=2.114432126663530_p
x(5)=-10.49421577256535_p
w(5)=2.502303206307030_p
x(6)=-7.849749958795041_p
w(6)=2.761087385262557_p
x(7)=-5.027880530907227_p
w(7)=2.827683410840416_p
x(8)=-2.243854857857004_p
w(8)=2.420597421487888_p
x(9)=3.290208730997134e-1_p
w(9)=1.069098128090951_p
x(10)=3.116450673745389_p
w(10)=1.317392215157913e-1_p
x(11)=6.579447494613353_p
w(11)=5.292036476872804e-3_p
x(12)=10.75273677266887_p
w(12)=9.713788540720070e-5_p
x(13)=15.70569905350442_p
w(13)=8.148218155148861e-7_p
x(14)=21.62965196889103_p
w(14)=2.631908145305392e-9_p
x(15)=28.92368108711278_p
w(15)=2.256589901399534e-12_p
x(16)=38.63132076075298_p
w(16)=1.965759425536122e-16_p
else if(N==17)then
x(1)=-16.83155436354847_p
w(1)=4.314831089667757e-1_p
x(2)=-16.11950013847052_p
w(2)=9.884782607498327e-1_p
x(3)=-14.86707935814956_p
w(3)=1.508243782066074_p
x(4)=-13.12286570167486_p
w(4)=1.968444802776566_p
x(5)=-10.95734581926038_p
w(5)=2.347052462471437_p
x(6)=-8.463959777827021_p
w(6)=2.619043529276746_p
x(7)=-5.765084545720438_p
w(7)=2.741534130071136_p
x(8)=-3.033703352161500_p
w(8)=2.548148672124063_p
x(9)=-4.782771808701210e-1_p
w(9)=1.521171544240365_p
x(10)=2.088074138692539_p
w(10)=3.069520561351937e-1_p
x(11)=5.196719571819144_p
w(11)=1.891239488947035e-2_p
x(12)=8.951826199801056_p
w(12)=5.277827933428291e-4_p
x(13)=13.36845784912971_p
w(13)=7.465264796584842e-6_p
x(14)=18.54846882742037_p
w(14)=4.944671974034682e-8_p
x(15)=24.69692273633405_p
w(15)=1.267712027007651e-10_p
x(16)=32.22371296598303_p
w(16)=8.567517553537345e-14_p
x(17)=42.1922596441432_p
w(17)=5.722917586784377e-18_p
else
call GD(-17)
end if
end subroutine GF_m17

! [-16kT;infkT]
subroutine GF_m16(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-12.40753460191992_p
w(1)=8.484775125798155_p
x(2)=-2.804962848165129_p
w(2)=7.515224986737014_p
else if(N==3)then
x(1)=-13.97871821346054_p
w(1)=4.977655049105642_p
x(2)=-7.080128266191962_p
w(2)=7.821265259346206_p
x(3)=-4.368117624330574e-1_p
w(3)=3.201079804083320_p
else if(N==4)then
x(1)=-14.68161021854647_p
w(1)=3.300497564918344_p
x(2)=-9.754470785803079_p
w(2)=6.133926372011440_p
x(3)=-3.491670871713184_p
w(3)=5.588154804223506_p
x(4)=1.480174186985312_p
w(4)=9.774213713818787e-1_p
else if(N==5)then
x(1)=-15.05629793364784_p
w(1)=2.381842570109182_p
x(2)=-11.37016717863363_p
w(2)=4.780897281041286_p
x(3)=-6.049157410087459_p
w(3)=5.508458185915934_p
x(4)=-1.069081148509315_p
w(4)=3.171144940524705_p
x(5)=3.666226704393334_p
w(5)=1.576571349440607e-1_p
else if(N==6)then
x(1)=-15.28101955971044_p
w(1)=1.823112875902200_p
x(2)=-12.4016769536063_p
w(2)=3.818121740851303_p
x(3)=-7.962410797079914_p
w(3)=4.862422022793744_p
x(4)=-3.147262702885787_p
w(4)=4.305577849777160_p
x(5)=8.789158006589822e-1_p
w(5)=1.176631988485668_p
x(6)=6.247070923654787_p
w(6)=1.413363472509215e-2_p
else if(N==7)then
x(1)=-15.42748168159343_p
w(1)=1.455952243543489_p
x(2)=-13.09879950685951_p
w(2)=3.129737058146092_p
x(3)=-9.365025491763594_p
w(3)=4.214432405976064_p
x(4)=-4.965092710769486_p
w(4)=4.376296704088186_p
x(5)=-9.241207944132026e-1_p
w(5)=2.590208297875138_p
x(6)=2.946092194859093_p
w(6)=2.324772736743992e-1_p
x(7)=9.104271162924396_p
w(7)=8.961292318005675e-4_p
else if(N==8)then
x(1)=-15.52896805132876_p
w(1)=1.200191333970508_p
x(2)=-13.59315321706639_p
w(2)=2.624792433294898_p
x(3)=-10.4092526043489_p
w(3)=3.661103207942296_p
x(4)=-6.467222964821481_p
w(4)=4.099837250105542_p
x(5)=-2.480253129406763_p
w(5)=3.426554312711164_p
x(6)=9.843590116571680e-1_p
w(6)=9.617765876305042e-1_p
x(7)=5.339089189806386_p
w(7)=2.569878608301585e-2_p
x(8)=12.14169941571011_p
w(8)=4.620079723883103e-5_p
else if(N==9)then
x(1)=-15.60265617356153_p
w(1)=1.013813808945119_p
x(2)=-13.95779391173553_p
w(2)=2.243994310580270_p
x(3)=-11.20447779458813_p
w(3)=3.205643178480010_p
x(4)=-7.683555582012971_p
w(4)=3.753602921510685_p
x(5)=-3.889047267006056_p
w(5)=3.639848905358729_p
x(6)=-4.554582890246930e-1_p
w(6)=1.952113090823260_p
x(7)=3.023920600158810_p
w(7)=1.889645479587534e-1_p
x(8)=7.986065038568107_p
w(8)=2.017280459592690e-3_p
x(9)=15.30618886343207_p
w(9)=2.068418749635495e-6_p
else if(N==10)then
x(1)=-15.65816210918383_p
w(1)=8.730599993362463e-1_p
x(2)=-14.23556773642665_p
w(2)=1.949400944125087_p
x(3)=-11.82391445813685_p
w(3)=2.832728625544330_p
x(4)=-8.669487613386783_p
w(4)=3.417024608375905_p
x(5)=-5.127497631846201_p
w(5)=3.561333532249836_p
x(6)=-1.701723685943044_p
w(6)=2.696555692147776_p
x(7)=1.411725496773323_p
w(7)=6.477376806784856e-1_p
x(8)=5.345689545352485_p
w(8)=2.202930286837174e-2_p
x(9)=10.80337988956024_p
w(9)=1.296437715629357e-4_p
x(10)=18.56581328349386_p
w(10)=8.343756847769632e-8_p
else if(N==11)then
x(1)=-15.70122558589431_p
w(1)=7.636478106597161e-1_p
x(2)=-14.45287937357837_p
w(2)=1.716326006459914_p
x(3)=-12.31646920760952_p
w(3)=2.525814247495605_p
x(4)=-9.475538256406082_p
w(4)=3.112062666491461_p
x(5)=-6.194522316476164_p
w(5)=3.382039498049603_p
x(6)=-2.847829111178024_p
w(6)=3.040531386303033_p
x(7)=1.722457800745592e-1_p
w(7)=1.341588242641627_p
x(8)=3.457842866164381_p
w(8)=1.160727829141114e-1_p
x(9)=7.885218085240266_p
w(9)=1.910205640524495e-3_p
x(10)=13.74374380115244_p
w(10)=7.262774396522901e-6_p
x(11)=21.89954384473538_p
w(11)=3.105178050726221e-9_p
else if(N==12)then
x(1)=-15.73545476343516_p
w(1)=6.765528900450791e-1_p
x(2)=-14.62671461601505_p
w(2)=1.528294696517936_p
x(3)=-12.71535296303973_p
w(3)=2.270972973063707_p
x(4)=-10.14172082455151_p
w(4)=2.842610538757723_p
x(5)=-7.108238455226934_p
w(5)=3.175904579066075_p
x(6)=-3.896137073580592_p
w(6)=3.113666130966418_p
x(7)=-8.858620510363331e-1_p
w(7)=2.006786874931494_p
x(8)=2.031792723689428_p
w(8)=3.715886884330956e-1_p
x(9)=5.750961860338193_p
w(9)=1.348356266505748e-2_p
x(10)=10.57539619983547_p
w(10)=1.388112674565731e-4_p
x(11)=16.779063181319_p
w(11)=3.667127629426163e-7_p
x(12)=25.29269638584612_p
w(12)=1.083628676901934e-10_p
else if(N==13)then
x(1)=-15.76321670767544_p
w(1)=6.058319849795384e-1_p
x(2)=-14.76841079319266_p
w(2)=1.374017312162057_p
x(3)=-13.04360626982331_p
w(3)=2.057263437468790_p
x(4)=-10.69848897901504_p
w(4)=2.606591789061315_p
x(5)=-7.891550910284865_p
w(5)=2.970649759083979_p
x(6)=-4.839581337239943_p
w(6)=3.056330736928011_p
x(7)=-1.853166905753667_p
w(7)=2.453378723294299_p
x(8)=9.012114760354611e-1_p
w(8)=8.153594999171503e-1_p
x(9)=4.102401633033881_p
w(9)=5.933526451318671e-2_p
x(10)=8.226212936056257_p
w(10)=1.232687362374256e-3_p
x(11)=13.37806563517077_p
w(11)=8.900713727978392e-6_p
x(12)=19.8906907053596_p
w(12)=1.704715049265697e-8_p
x(13)=28.73459180866289_p
w(13)=3.587877444245231e-12_p
else if(N==14)then
x(1)=-15.78612074884037_p
w(1)=5.474321956895636e-1_p
x(2)=-14.88577940559512_p
w(2)=1.245560623950767_p
x(3)=-13.31756851605555_p
w(3)=1.876268708449234_p
x(4)=-11.1688229592417_p
w(4)=2.400170066756790_p
x(5)=-8.566003846392379_p
w(5)=2.776760709230845_p
x(6)=-5.680318474127672_p
w(6)=2.944507951725797_p
x(7)=-2.755104912798330_p
w(7)=2.669301672926041_p
x(8)=-5.118262499709283e-2_p
w(8)=1.349266194679193_p
x(9)=2.788918734772041_p
w(9)=1.838611051372657e-1_p
x(10)=6.382900385735467_p
w(10)=6.773448430576363e-3_p
x(11)=10.8320398794573_p
w(11)=9.691706952301193e-5_p
x(12)=16.27009959340379_p
w(12)=5.177489690660812e-7_p
x(13)=23.06534720320326_p
w(13)=7.404903387090691e-10_p
x(14)=32.21721670080584_p
w(14)=1.136991320646629e-13_p
else if(N==15)then
x(1)=-15.80529471373083_p
w(1)=4.985064347025207e-1_p
x(2)=-14.98435278216276_p
w(2)=1.137220208578534_p
x(3)=-13.54907164359482_p
w(3)=1.721534129551581_p
x(4)=-11.57012173888823_p
w(4)=2.219293100634049_p
x(5)=-9.150044906200179_p
w(5)=2.597811170543161_p
x(6)=-6.426777428567210_p
w(6)=2.812846087560578_p
x(7)=-3.591882716327505_p
w(7)=2.729981086411165_p
x(8)=-9.029707017715808e-1_p
w(8)=1.827291693944102_p
x(9)=1.716162428652773_p
w(9)=4.283312658733944e-1_p
x(10)=4.888461783962717_p
w(10)=2.653825837172046e-2_p
x(11)=8.814698993045836_p
w(11)=6.398334941242222e-4_p
x(12)=13.53897454144832_p
w(12)=6.815023263480658e-6_p
x(13)=19.23580794625201_p
w(13)=2.781658595978396e-8_p
x(14)=26.29314113878077_p
w(14)=3.038548560920177e-11_p
x(15)=35.73440324458748_p
w(15)=3.471768657448944e-15_p
else if(N==16)then
x(1)=-15.82154982920245_p
w(1)=4.570028765830712e-1_p
x(2)=-15.06814418897101_p
w(2)=1.044808019560710_p
x(3)=-13.74685083988662_p
w(3)=1.588087682275675_p
x(4)=-11.91566767804569_p
w(4)=2.060239446261630_p
x(5)=-9.658910606316805_p
w(5)=2.434428619910753_p
x(6)=-7.089546749734696_p
w(6)=2.676933862671511_p
x(7)=-4.361056674038092_p
w(7)=2.705946183730003_p
x(8)=-1.694177936729833_p
w(8)=2.161885738336748_p
x(9)=8.129128790521988e-1_p
w(9)=7.875338753343661e-1_p
x(10)=3.651566010603871_p
w(10)=8.009518694596279e-2_p
x(11)=7.161241469572426_p
w(11)=2.985010178689519e-3_p
x(12)=11.35960452397603_p
w(12)=5.317116756686683e-5_p
x(13)=16.32848108779372_p
w(13)=4.381792166824513e-7_p
x(14)=22.26376101997879_p
w(14)=1.398078551407051e-9_p
x(15)=29.56646232373367_p
w(15)=1.187697724083510e-12_p
x(16)=39.28130242710876_p
w(16)=1.026834016774095e-16_p
else if(N==17)then
x(1)=-15.83548292135565_p
w(1)=4.214095752248760e-1_p
x(2)=-15.14012685848181_p
w(2)=9.651911489607091e-1_p
x(3)=-13.91746995284031_p
w(3)=1.472069360101374_p
x(4)=-12.21570443917221_p
w(4)=1.919774930446915_p
x(5)=-10.1050142523326_p
w(5)=2.285970688655857_p
x(6)=-7.679195544141268_p
w(6)=2.543916669514237_p
x(7)=-5.063511809974234_p
w(7)=2.639998941011064_p
x(8)=-2.438631808137660_p
w(8)=2.348453311563877_p
x(9)=2.228608481624795e-2_p
w(9)=1.197625114617232_p
x(10)=2.612381952450192_p
w(10)=1.945447182641609e-1_p
x(11)=5.775496261385435_p
w(11)=1.075291759833027e-2_p
x(12)=9.560601538921842_p
w(12)=2.887092747485012e-4_p
x(13)=13.99520483965004_p
w(13)=4.001090732531941e-6_p
x(14)=19.18759221291978_p
w(14)=2.614463929195502e-8_p
x(15)=25.34525245400707_p
w(15)=6.637045319094256e-11_p
x(16)=32.87930742908934_p
w(16)=4.451144407345474e-14_p
x(17)=42.85403269065512_p
w(17)=2.954116646325193e-18_p
else
call GD(-16)
end if
end subroutine GF_m16

! [-15kT;infkT]
subroutine GF_m15(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-11.60756997360276_p
w(1)=8.010480027408899_p
x(2)=-2.557094432115252_p
w(2)=6.989520278493374_p
else if(N==3)then
x(1)=-13.08170712881915_p
w(1)=4.723446653265805_p
x(2)=-6.541749673190368_p
w(2)=7.396058999469052_p
x(3)=-2.364727626005448e-1_p
w(3)=2.880494653167417_p
else if(N==4)then
x(1)=-13.74325971441257_p
w(1)=3.145856462502512_p
x(2)=-9.049689801056603_p
w(2)=5.837742646433079_p
x(3)=-3.109009539003485_p
w(3)=5.206260940820605_p
x(4)=1.722327172897047_p
w(4)=8.101402561460784e-1_p
else if(N==5)then
x(1)=-14.09703414302525_p
w(1)=2.278836007758541_p
x(2)=-10.57187244361477_p
w(2)=4.569443512113921_p
x(3)=-5.495873305736682_p
w(3)=5.228388089987513_p
x(4)=-7.674554210291473e-1_p
w(4)=2.806612162050532_p
x(5)=3.991074808050628_p
w(5)=1.167205339917669e-1_p
else if(N==6)then
x(1)=-14.30985783080412_p
w(1)=1.749858093768984_p
x(2)=-11.54722421315621_p
w(2)=3.661728513650919_p
x(3)=-7.294924878159671_p
w(3)=4.647660875554209_p
x(4)=-2.712686726739773_p
w(4)=3.986915823076528_p
x(5)=1.190144352620105_p
w(5)=9.442424973672287e-1_p
x(6)=6.645011321704619_p
w(6)=9.594502484405238e-3_p
else if(N==7)then
x(1)=-14.4489541074967_p
w(1)=1.401253524772893_p
x(2)=-12.2084662056166_p
w(2)=3.010104407697762_p
x(3)=-8.620586215942257_p
w(3)=4.044560765177224_p
x(4)=-4.410783566068743_p
w(4)=4.145676415878581_p
x(5)=-5.646351137422854e-1_p
w(5)=2.233154051492525_p
x(6)=3.327340270301292_p
w(6)=1.646778010023079e-1_p
x(7)=9.556777669544864_p
w(7)=5.733398809796484e-4_p
else if(N==8)then
x(1)=-14.545581408912_p
w(1)=1.157791412172983_p
x(2)=-12.67867206979538_p
w(2)=2.530575782360836_p
x(3)=-9.611212085397179_p
w(3)=3.523976041420601_p
x(4)=-5.824441196943567_p
w(4)=3.920949977040414_p
x(5)=-2.027236160962190_p
w(5)=3.115022631919953_p
x(6)=1.354082002001071_p
w(6)=7.350182225397471e-1_p
x(7)=5.787779733173984_p
w(7)=1.663796189239656e-2_p
x(8)=12.63651552831337_p
w(8)=2.827655534332271e-5_p
else if(N==9)then
x(1)=-14.61590201460518_p
w(1)=9.799645622321282e-1_p
x(2)=-13.02635016127108_p
w(2)=2.167950697601048_p
x(3)=-10.3678909615529_p
w(3)=3.092983245544977_p
x(4)=-6.975622186831935_p
w(4)=3.607455021423299_p
x(5)=-3.343623562032965_p
w(5)=3.413370201213299_p
x(6)=-5.963084548340638e-2_p
w(6)=1.610138462399667_p
x(7)=3.459186295254904_p
w(7)=1.269015915253227e-1_p
x(8)=8.483580650969941_p
w(8)=1.235301938337859e-3_p
x(9)=15.83517567960736_p
w(9)=1.222024194051363e-6_p
else if(N==10)then
x(1)=-14.6689804722284_p
w(1)=8.453883773913097e-1_p
x(2)=-13.29177952899876_p
w(2)=1.886746562700814_p
x(3)=-10.95880491593066_p
w(3)=2.738695736173736_p
x(4)=-7.912502838899342_p
w(4)=3.294438883054887_p
x(5)=-4.507737332461336_p
w(5)=3.390642282513019_p
x(6)=-1.244035059310698_p
w(6)=2.366055926560819_p
x(7)=1.833566338343814_p
w(7)=4.643357451601932e-1_p
x(8)=5.840356928922867_p
w(8)=1.362042350647540e-2_p
x(9)=11.33767537251747_p
w(9)=7.632095779266954e-5_p
x(10)=19.12314392485991_p
w(10)=4.788322822154977e-8_p
else if(N==11)then
x(1)=-14.71023709388797_p
w(1)=7.405819736196427e-1_p
x(2)=-13.49983856345871_p
w(2)=1.663797041288792_p
x(3)=-11.4297187140958_p
w(3)=2.446214290239552_p
x(4)=-8.680819452824180_p
w(4)=3.007561332043948_p
x(5)=-5.516901468083743_p
w(5)=3.244571607095254_p
x(6)=-2.317956156001205_p
w(6)=2.784890283824492_p
x(7)=6.002647152366314e-1_p
w(7)=1.037550141087743_p
x(8)=3.942681946177680_p
w(8)=7.370483938551649e-2_p
x(9)=8.422020458506866_p
w(9)=1.124649425794950e-3_p
x(10)=14.30741083127894_p
w(10)=4.146152583026763e-6_p
x(11)=22.48085132828602_p
w(11)=1.738955888901964e-9_p
else if(N==12)then
x(1)=-14.74308513783343_p
w(1)=6.570120108486569e-1_p
x(2)=-13.66656408251262_p
w(2)=1.483597958910550_p
x(3)=-11.81182025559393_p
w(3)=2.202743581718097_p
x(4)=-9.317416049101658_p
w(4)=2.752435961257063_p
x(5)=-6.385076898788329_p
w(5)=3.060299606305763_p
x(6)=-3.301361424511771_p
w(6)=2.924473445643289_p
x(7)=-4.242621521652738e-1_p
w(7)=1.663456012796778_p
x(8)=2.503405845201311_p
w(8)=2.479128056082251e-1_p
x(9)=6.286254680751641_p
w(9)=7.989737115172644e-3_p
x(10)=11.14376401134207_p
w(10)=7.898148884254662e-5_p
x(11)=17.36704029199991_p
w(11)=2.041504079996899e-7_p
x(12)=25.89460723065854_p
w(12)=5.942792228287435e-11_p
else if(N==13)then
x(1)=-14.76976747983801_p
w(1)=5.890491219140785e-1_p
x(2)=-13.80268024501641_p
w(2)=1.335498962357161_p
x(3)=-12.12680877550016_p
w(3)=1.998130794901613_p
x(4)=-9.850593031309131_p
w(4)=2.527987401349987_p
x(5)=-7.131938588030247_p
w(5)=2.870966777739607_p
x(6)=-4.191272018257644_p
w(6)=2.910273807704374_p
x(7)=-1.340279373896337_p
w(7)=2.150012039088386_p
x(8)=1.366371268529227_p
w(8)=5.816134785629176e-1_p
x(9)=4.631365114812875_p
w(9)=3.576193888696781e-2_p
x(10)=8.797035648792836_p
w(10)=7.010424619926496e-4_p
x(11)=13.97163887285373_p
w(11)=4.931641643145895e-6_p
x(12)=20.49927065186424_p
w(12)=9.291614226808221e-9_p
x(13)=29.35443880538779_p
w(13)=1.932209368361346e-12_p
else if(N==14)then
x(1)=-14.79181137319044_p
w(1)=5.328483684451193e-1_p
x(2)=-13.91558897050163_p
w(2)=1.212000077933726_p
x(3)=-12.39011000942785_p
w(3)=1.824516589997471_p
x(4)=-10.30183252295745_p
w(4)=2.331043563085888_p
x(5)=-7.776765836857666_p
w(5)=2.689458026964124_p
x(6)=-4.988462056717643_p
w(6)=2.825529476986317_p
x(7)=-2.187464818686373_p
w(7)=2.432824972269451_p
x(8)=4.241324286164949e-1_p
w(8)=1.033370428930855_p
x(9)=3.307438596877440_p
w(9)=1.144891855473382e-1_p
x(10)=6.953471237320731_p
w(10)=3.865799868571413e-3_p
x(11)=11.42975065800381_p
w(11)=5.353477720427889e-5_p
x(12)=16.88459232014524_p
w(12)=2.806998002401992e-7_p
x(13)=23.69169713834353_p
w(13)=3.963487343363512e-10_p
x(14)=32.85285047446905_p
w(14)=6.026159014030457e-14_p
else if(N==15)then
x(1)=-14.81028868119611_p
w(1)=4.857047357367382e-1_p
x(2)=-14.01054098412922_p
w(2)=1.107698077077951_p
x(3)=-12.61291811351708_p
w(3)=1.675846841773270_p
x(4)=-10.68746888463398_p
w(4)=2.158022872072197_p
x(5)=-8.336405896412650_p
w(5)=2.520515274360599_p
x(6)=-5.699203760077928_p
w(6)=2.711950616830889_p
x(7)=-2.974441422168856_p
w(7)=2.550656471707482_p
x(8)=-3.995274976801190e-1_p
w(8)=1.493557657872968_p
x(9)=2.224013164314651_p
w(9)=2.803971288215070e-1_p
x(10)=5.455581862963642_p
w(10)=1.529388536933960e-2_p
x(11)=9.414924780412685_p
w(11)=3.530500799405002e-4_p
x(12)=14.15832727418191_p
w(12)=3.679376684875440e-6_p
x(13)=19.86810315940147_p
w(13)=1.480669652928390e-8_p
x(14)=26.93503142563418_p
w(14)=1.600875801004135e-11_p
x(15)=36.38406353684241_p
w(15)=1.814195652733931e-15_p
else if(N==16)then
x(1)=-14.82597143020973_p
w(1)=4.456660700751484e-1_p
x(2)=-14.09135098518619_p
w(2)=1.018619150809559_p
x(3)=-12.803513110735_p
w(3)=1.547441827772200_p
x(4)=-11.02001333361581_p
w(4)=2.005549260132407_p
x(5)=-8.824938571416828_p
w(5)=2.365416503240261_p
x(6)=-6.332310569671891_p
w(6)=2.589083707381194_p
x(7)=-3.701063397019318_p
w(7)=2.566310767518070_p
x(8)=-1.151151702915914_p
w(8)=1.864381800000709_p
x(9)=1.316400792165602_p
w(9)=5.488055966676114e-1_p
x(10)=4.211866892544109_p
w(10)=4.704729229409577e-2_p
x(11)=7.762164291335199_p
w(11)=1.649474014847118e-3_p
x(12)=11.98269667749553_p
w(12)=2.862310900131762e-5_p
x(13)=16.96591351371735_p
w(13)=2.321540302899794e-7_p
x(14)=22.91148334024117_p
w(14)=7.325232012461135e-10_p
x(15)=30.22209785866088_p
w(15)=6.170794662411134e-13_p
x(16)=39.94352745647655_p
w(16)=5.298239135854449e-17_p
else if(N==17)then
x(1)=-14.83942833481071_p
w(1)=4.112919922004749e-1_p
x(2)=-14.16084904215092_p
w(2)=9.417859353142589e-1_p
x(3)=-12.96812748333751_p
w(3)=1.435658143592196_p
x(4)=-11.30914116453578_p
w(4)=1.870647544896230_p
x(5)=-9.253923196397094_p
w(5)=2.223927182453241_p
x(6)=-6.897031323074262_p
w(6)=2.466092353379087_p
x(7)=-4.367728324510117_p
w(7)=2.526625115582546_p
x(8)=-1.852829283019684_p
w(8)=2.108077824816518_p
x(9)=5.331363404824029e-1_p
w(9)=8.918172205431991e-1_p
x(10)=3.163405058835928_p
w(10)=1.179481347543273e-1_p
x(11)=6.375029769657146_p
w(11)=5.971551996405211e-3_p
x(12)=10.1862665852792_p
w(12)=1.551808137106665e-4_p
x(13)=14.63692743795456_p
w(13)=2.111893630274847e-6_p
x(14)=19.84050192810014_p
w(14)=1.363212912282071e-8_p
x(15)=26.00653242426832_p
w(15)=3.429714343975098e-11_p
x(16)=33.54721628424876_p
w(16)=2.284078064385698e-14_p
x(17)=43.52759371822279_p
w(17)=1.506954617144741e-18_p
else
call GD(-15)
end if
end subroutine GF_m15

! [-14kT;infkT]
subroutine GF_m14(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.8065272671263_p
w(1)=7.538498986182593_p
x(2)=-2.304430752336122_p
w(2)=6.461501845345780_p
else if(N==3)then
x(1)=-12.18399783979824_p
w(1)=4.470876819453365_p
x(2)=-6.001285055045941_p
w(2)=6.968250847834018_p
x(3)=-2.478264984865137e-2_p
w(3)=2.560873164240990_p
else if(N==4)then
x(1)=-12.8044862107529_p
w(1)=2.992233767593727_p
x(2)=-8.343342089077355_p
w(2)=5.541917105622264_p
x(3)=-2.724817267883710_p
w(3)=4.809655162038792_p
x(4)=1.984897316204543_p
w(4)=6.561947962735910e-1_p
else if(N==5)then
x(1)=-13.1375168813965_p
w(1)=2.176445698819973_p
x(2)=-9.772564230315849_p
w(2)=4.358553612081031_p
x(3)=-4.942236834085437_p
w(3)=4.940452063314008_p
x(4)=-4.573479884026656e-1_p
w(4)=2.440388876833778_p
x(5)=4.339917036602905_p
w(5)=8.416058047958373e-2_p
else if(N==6)then
x(1)=-13.33854526183002_p
w(1)=1.676970885611543_p
x(2)=-10.69215519318654_p
w(2)=3.505732018740962_p
x(3)=-6.627069831207871_p
w(3)=4.430121981283202_p
x(4)=-2.279192433454109_p
w(4)=3.645528757852585_p
x(5)=1.522871698629405_p
w(5)=7.352854863463952e-1_p
x(6)=7.065452089514292_p
w(6)=6.361701693685928e-3_p
else if(N==7)then
x(1)=-13.47033866082933_p
w(1)=1.346768155321762_p
x(2)=-11.31777869134358_p
w(2)=2.890695760024231_p
x(3)=-7.875928804482664_p
w(3)=3.873472791911879_p
x(4)=-3.858767609958913_p
w(4)=3.899407725432404_p
x(5)=-1.967035562514321e-1_p
w(5)=1.876256964555194_p
x(6)=3.734669526935965_p
w(6)=1.130403119351902e-1_p
x(7)=10.02998810854861_p
w(7)=3.591223477134381e-4_p
else if(N==8)then
x(1)=-13.56214630233156_p
w(1)=1.115507751959147_p
x(2)=-11.76400684491309_p
w(2)=2.436453820150534_p
x(3)=-8.813125598392975_p
w(3)=3.386138898750926_p
x(4)=-5.183389455223305_p
w(4)=3.734397037957669_p
x(5)=-1.576364755148577_p
w(5)=2.775997042380556_p
x(6)=1.747501879502417_p
w(6)=5.409860592300084e-1_p
x(7)=6.259828331240842_p
w(7)=1.050324955454497e-2_p
x(8)=13.15054055033624_p
w(8)=1.697154498749415e-5_p
else if(N==9)then
x(1)=-13.62912452591475_p
w(1)=9.461694675072490e-1_p
x(2)=-12.09483291678658_p
w(2)=2.091912358225493_p
x(3)=-9.531395425235830_p
w(3)=2.979801316769619_p
x(4)=-6.269014605147221_p
w(4)=3.457317401322654_p
x(5)=-2.803139852602402_p
w(5)=3.160352843512511_p
x(6)=3.484091386444399e-1_p
w(6)=1.281287558929258_p
x(7)=3.921117673889765_p
w(7)=8.241879661458512e-2_p
x(8)=9.001807621956942_p
w(8)=7.403796691413055e-4_p
x(9)=16.38209743243008_p
w(9)=7.089778619098854e-7_p
else if(N==10)then
x(1)=-13.67979178065523_p
w(1)=8.177306451308408e-1_p
x(2)=-12.34799001496179_p
w(2)=1.824037525135990_p
x(3)=-10.09388430312569_p
w(3)=2.644221398647852_p
x(4)=-7.156637146198165_p
w(4)=3.169467638199942_p
x(5)=-3.892422082434075_p
w(5)=3.203538550661902_p
x(6)=-7.862768490144955e-1_p
w(6)=2.013766116022440_p
x(7)=2.281824835899550_p
w(7)=3.189826937585969e-1_p
x(8)=6.358013880459715_p
w(8)=8.212165131267046e-3_p
x(9)=11.890823869704_p
w(9)=4.407182363911618e-5_p
x(10)=19.69730965453927_p
w(10)=2.701590327960970e-8_p
else if(N==11)then
x(1)=-13.71925219215242_p
w(1)=7.175037036273976e-1_p
x(2)=-12.54684365993883_p
w(2)=1.611174044313425_p
x(3)=-10.54322271612192_p
w(3)=2.366213740813327_p
x(4)=-7.887110487244108_p
w(4)=2.901437514365826_p
x(5)=-4.842838739250375_p
w(5)=3.097677635108190_p
x(6)=-1.794119921336926_p
w(6)=2.493441262677978_p
x(7)=1.046958031525651_p
w(7)=7.665889392213274e-1_p
x(8)=4.453533430938575_p
w(8)=4.531323214187428e-2_p
x(9)=8.978904558476719_p
w(9)=6.484329350929043e-4_p
x(10)=14.88851077123985_p
w(10)=2.325365556182912e-6_p
x(11)=23.07803851207399_p
w(11)=9.583779305549739e-10_p
else if(N==12)then
x(1)=-13.7507260915897_p
w(1)=6.374414497249720e-1_p
x(2)=-12.70649021801083_p
w(2)=1.438781891476774_p
x(3)=-10.9085840384905_p
w(3)=2.134138848313647_p
x(4)=-8.494054578008194_p
w(4)=2.661043569545507_p
x(5)=-5.664800734318863_p
w(5)=2.939018456582255_p
x(6)=-2.713729170940181_p
w(6)=2.705462438790960_p
x(7)=4.410329259726568e-2_p
w(7)=1.320931918511770_p
x(8)=3.002790906832830_p
w(8)=1.585152210749452e-1_p
x(9)=6.843447537161641_p
w(9)=4.622815554220290e-3_p
x(10)=11.73028353251511_p
w(10)=4.411012870772182e-5_p
x(11)=17.97129835477873_p
w(11)=1.117925144517605e-7_p
x(12)=26.51156289896589_p
w(12)=3.210120926484646e-11_p
else if(N==13)then
x(1)=-13.77633340179216_p
w(1)=5.722253394773145e-1_p
x(2)=-12.83704615160837_p
w(2)=1.296845589240875_p
x(3)=-11.21033306340231_p
w(3)=1.938641632144706_p
x(4)=-9.003592259942288_p
w(4)=2.448403071280066_p
x(5)=-6.374752217820919_p
w(5)=2.767583590317765_p
x(6)=-3.549350653842620_p
w(6)=2.744203986486602_p
x(7)=-8.303725323441656e-1_p
w(7)=1.816494278143222_p
x(8)=1.856371941144419_p
w(8)=3.942765859188734e-1_p
x(9)=5.184745228502115_p
w(9)=2.093324326959456e-2_p
x(10)=9.386981871015738_p
w(10)=3.908239492337458e-4_p
x(11)=14.58194256945146_p
w(11)=2.686312438510198e-6_p
x(12)=21.12316778001836_p
w(12)=4.986658282378690e-9_p
x(13)=29.98859634519343_p
w(13)=1.025697395086442e-12_p
else if(N==14)then
x(1)=-13.79752009210323_p
w(1)=5.182164273207943e-1_p
x(2)=-12.94550736720791_p
w(2)=1.178295372365341_p
x(3)=-11.46298693380293_p
w(3)=1.772423975363784_p
x(4)=-9.435697228011470_p
w(4)=2.261090068953610_p
x(5)=-6.989635499650466_p
w(5)=2.599546877017188_p
x(6)=-4.301959668514487_p
w(6)=2.693776763895495_p
x(7)=-1.627613115350427_p
w(7)=2.155765796044333_p
x(8)=9.158582546774499e-1_p
w(8)=7.500588298495499e-1_p
x(9)=3.852933510233244_p
w(9)=6.863929523165876e-2_p
x(10)=7.544540751318894_p
w(10)=2.158224619193472e-3_p
x(11)=12.04475840876125_p
w(11)=2.905086589500877e-5_p
x(12)=17.51469093661034_p
w(12)=1.497924307697858e-7_p
x(13)=24.33254199830874_p
w(13)=2.090677032425019e-10_p
x(14)=33.50214472674089_p
w(14)=3.150369106595967e-14_p
else if(N==15)then
x(1)=-13.81530258119615_p
w(1)=4.728504806342205e-1_p
x(2)=-13.03684534744769_p
w(2)=1.078027132316246_p
x(3)=-11.67710562275233_p
w(3)=1.629833728517033_p
x(4)=-9.805634949756874_p
w(4)=2.096031689499064_p
x(5)=-7.524643974979757_p
w(5)=2.441254625041148_p
x(6)=-4.976110463894508_p
w(6)=2.602750339423641_p
x(7)=-2.365874170611474_p
w(7)=2.335811109719558_p
x(8)=1.096521341694500e-1_p
w(8)=1.159790624269572_p
x(9)=2.759567762571573_p
w(9)=1.748675711598984e-1_p
x(10)=6.045109853769763_p
w(10)=8.590380037656860e-3_p
x(11)=10.03319394541965_p
w(11)=1.911887228789014e-4_p
x(12)=14.79363635762463_p
w(12)=1.954413739433240e-6_p
x(13)=20.51507855751645_p
w(13)=7.765396548057540e-9_p
x(14)=27.59070483342229_p
w(14)=8.318030352102429e-12_p
x(15)=37.04680509380105_p
w(15)=9.356458572457116e-16_p
else if(N==16)then
x(1)=-13.83041404071695_p
w(1)=4.342741561135632e-1_p
x(2)=-13.11467781053273_p
w(2)=9.922798784465791e-1_p
x(3)=-11.86051652191766_p
w(3)=1.506484021646326_p
x(4)=-10.12514379044901_p
w(4)=1.950216291574237_p
x(5)=-7.992668227370880_p
w(5)=2.294844979289741_p
x(6)=-5.578887578359158_p
w(6)=2.495590421231635_p
x(7)=-3.049353219977113_p
w(7)=2.400453571192352_p
x(8)=-6.112082061579893e-1_p
w(8)=1.537004558829866_p
x(9)=1.844415744274418_p
w(9)=3.611723098465419e-1_p
x(10)=4.796927544683733_p
w(10)=2.677214323375620e-2_p
x(11)=8.382139393966719_p
w(11)=8.932272882251424e-4_p
x(12)=12.62218631905097_p
w(12)=1.515130446841888e-5_p
x(13)=17.61824695785631_p
w(13)=1.211523082867134e-7_p
x(14)=23.5731044515047_p
w(14)=3.784583378692078e-10_p
x(15)=30.89089306536597_p
w(15)=3.163926967680841e-13_p
x(16)=40.6183145046389_p
w(16)=2.699518834475611e-17_p
else if(N==17)then
x(1)=-13.84339530794305_p
w(1)=4.011180574826237e-1_p
x(2)=-13.18169274019975_p
w(2)=9.182308139046724e-1_p
x(3)=-12.01912252281885_p
w(3)=1.398948247332872_p
x(4)=-10.40333005053255_p
w(4)=1.820937909933088_p
x(5)=-8.404394474173438_p
w(5)=2.160595371226140_p
x(6)=-6.118177789058212_p
w(6)=2.384234525835186_p
x(7)=-3.679185674383948_p
w(7)=2.395035144101932_p
x(8)=-1.275191675353021_p
w(8)=1.824298593780733_p
x(9)=1.061194468645194_p
w(9)=6.246118231454655e-1_p
x(10)=3.741344005128688_p
w(10)=6.866497204505016e-2_p
x(11)=6.994982964533681_p
w(11)=3.242310944582331e-3_p
x(12)=10.82889363424039_p
w(12)=8.195716189495681e-5_p
x(13)=15.29382430111296_p
w(13)=1.097608937489514e-6_p
x(14)=20.50744766244437_p
w(14)=7.007696349110154e-9_p
x(15)=26.6810395167013_p
w(15)=1.748845149986046e-11_p
x(16)=34.22773336106641_p
w(16)=1.157299978269276e-14_p
x(17)=44.21324860832978_p
w(17)=7.594560750722442e-19_p
else
call GD(-14)
end if
end subroutine GF_m14

! [-13kT;infkT]
subroutine GF_m13(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.00429020225867_p
w(1)=7.068991849056509_p
x(2)=-2.046000738644365_p
w(2)=5.931010411270344_p
else if(N==3)then
x(1)=-11.285547910439_p
w(1)=4.220016811529613_p
x(2)=-5.458790525780842_p
w(2)=6.536163416137358_p
x(3)=2.003952435030740e-1_p
w(3)=2.243822032659881_p
else if(N==4)then
x(1)=-11.86528124264769_p
w(1)=2.839636157488557_p
x(2)=-7.635514062064738_p
w(2)=5.245844542693213_p
x(3)=-2.338699924057776_p
w(3)=4.396806496859456_p
x(4)=2.270582670794636_p
w(4)=5.177150632856260e-1_p
else if(N==5)then
x(1)=-12.17775131627927_p
w(1)=2.074650753207546_p
x(2)=-8.972330710234960_p
w(2)=4.147941292245002_p
x(3)=-4.388783460819332_p
w(3)=4.641274857597357_p
x(4)=-1.359848395456273e-1_p
w(4)=2.077125391688920_p
x(5)=4.714327420770425_p
w(5)=5.900996558802752e-2_p
else if(N==6)then
x(1)=-12.36709203969579_p
w(1)=1.604420572680486_p
x(2)=-9.836556545239278_p
w(2)=3.349946379456734_p
x(3)=-5.959311575945755_p
w(3)=4.208084374075914_p
x(4)=-1.846211131961595_p
w(4)=3.279959121007053_p
x(5)=1.880353039700397_p
w(5)=5.534757047846318e-1_p
x(6)=7.509408960265083_p
w(6)=4.116108322033385e-3_p
else if(N==7)then
x(1)=-12.49164698264062_p
w(1)=1.292463253430516_p
x(2)=-10.42681840236585_p
w(2)=2.771369790317991_p
x(3)=-7.131405568603862_p
w(3)=3.700294148921612_p
x(4)=-3.309859209670885_p
w(4)=3.632012997599541_p
x(5)=1.836097860406854e-1_p
w(5)=1.528509643322526_p
x(6)=4.169325721825977_p
w(6)=7.513238011482051e-2_p
x(7)=10.52471028640064_p
w(7)=2.200466198459427e-4_p
else if(N==8)then
x(1)=-12.57867436213281_p
w(1)=1.073308355070457_p
x(2)=-10.84923217639824_p
w(2)=2.342311150210766_p
x(3)=-8.015271269933745_p
w(3)=3.247077066726115_p
x(4)=-4.544968362568661_p
w(4)=3.536380560200838_p
x(5)=-1.125811456750792_p
w(5)=2.412162691196766_p
x(6)=2.167884392051911_p
w(6)=3.822896856145231e-1_p
x(7)=6.755841590180836_p
w(7)=6.462768739584749e-3_p
x(8)=13.68444893284715_p
w(8)=9.982567803227613e-6_p
else if(N==9)then
x(1)=-12.64233475041525_p
w(1)=9.123985612724987e-1_p
x(2)=-11.16330980370578_p
w(2)=2.015781650647170_p
x(3)=-8.695220212074478_p
w(3)=2.865752614308636_p
x(4)=-5.564459753906071_p
w(4)=3.301019139597955_p
x(5)=-2.268017985796723_p
w(5)=2.874768813117618_p
x(6)=7.737514737530465e-1_p
w(6)=9.780639646784295e-1_p
x(7)=4.410401777573731_p
w(7)=5.178300104443942e-2_p
x(8)=9.541280465505549_p
w(8)=4.341119726388689e-4_p
x(9)=16.94753596880336_p
w(9)=4.036874669860577e-7_p
else if(N==10)then
x(1)=-12.69060629446719_p
w(1)=7.900591957346673e-1_p
x(2)=-11.40426024515397_p
w(2)=1.761189465110906_p
x(3)=-9.229346767038537_p
w(3)=2.549052492694627_p
x(4)=-6.402462276397434_p
w(4)=3.040831922626004_p
x(5)=-3.282729940076004_p
w(5)=2.993160583850285_p
x(6)=-3.243443725550368e-1_p
w(6)=1.651050453397319_p
x(7)=2.758851399328902_p
w(7)=2.098045118673326e-1_p
x(8)=6.898944186339607_p
w(8)=4.828668410590270e-3_p
x(9)=12.46331181081994_p
w(9)=2.495165737442212e-5_p
x(10)=20.28882685032186_p
w(10)=1.497774714457042e-8_p
else if(N==11)then
x(1)=-12.72828032711144_p
w(1)=6.943877236029325e-1_p
x(2)=-11.5939497998844_p
w(2)=1.558383070364153_p
x(3)=-9.657149121711074_p
w(3)=2.285614840226977_p
x(4)=-7.094871633654301_p
w(4)=2.792878278313081_p
x(5)=-4.173507905917718_p
w(5)=2.936497644670565_p
x(6)=-1.274916368986843_p
w(6)=2.166098058756642_p
x(7)=1.517398269244001_p
w(7)=5.387734161626271e-1_p
x(8)=4.990526986719275_p
w(8)=2.700191958263618e-2_p
x(9)=9.556206299119205_p
w(9)=3.660274154204964e-4_p
x(10)=15.48748719245705_p
w(10)=1.280712267205776e-6_p
x(11)=23.69157403994141_p
w(11)=5.195514612246715e-10_p
else if(N==12)then
x(1)=-12.75838629563838_p
w(1)=6.178180952954484e-1_p
x(2)=-11.74654294078529_p
w(2)=1.393780974441324_p
x(3)=-10.00579166671047_p
w(3)=2.064997539286411_p
x(4)=-7.672017466432873_p
w(4)=2.567875948002550_p
x(5)=-4.948402555117321_p
w(5)=2.808950161647809_p
x(6)=-2.133819899357264_p
w(6)=2.448894732916821_p
x(7)=5.253995445254813e-1_p
w(7)=9.977644379513086e-1_p
x(8)=3.530889411762294_p
w(8)=9.728376317849423e-2_p
x(9)=7.422628208882093_p
w(9)=2.612374773616740e-3_p
x(10)=12.33530427359478_p
w(10)=2.417262411428552e-5_p
x(11)=18.59224737289128_p
w(11)=6.019188264118538e-8_p
x(12)=27.14399605197881_p
w(12)=1.707206036244079e-11_p
else if(N==13)then
x(1)=-12.78292243270832_p
w(1)=5.553394846802412e-1_p
x(2)=-11.87155386289593_p
w(2)=1.257998622387605_p
x(3)=-10.29430992380791_p
w(3)=1.878660479595982_p
x(4)=-8.157809766553545_p
w(4)=2.367431371557274_p
x(5)=-5.620806373198053_p
w(5)=2.658500560302472_p
x(6)=-2.915153697913671_p
w(6)=2.549599005618399_p
x(7)=-3.188180202709399e-1_p
w(7)=1.466467478380259_p
x(8)=2.374550164450040_p
w(8)=2.538746851467701e-1_p
x(9)=5.762342321121332_p
w(9)=1.191557765214124e-2_p
x(10)=9.996263438309681_p
w(10)=2.135543104821989e-4_p
x(11)=15.20931910980511_p
w(11)=1.438060530869789e-6_p
x(12)=21.76276621124846_p
w(12)=2.634160254360504e-9_p
x(13)=30.63746910806909_p
w(13)=5.364852556103819e-13_p
else if(N==14)then
x(1)=-12.80325422295021_p
w(1)=5.035169680448246e-1_p
x(2)=-11.97557595499155_p
w(2)=1.144393754925390_p
x(3)=-10.53631644604189_p
w(3)=1.719874507015353_p
x(4)=-8.570696309527031_p
w(4)=2.189996282979235_p
x(5)=-6.205285801561624_p
w(5)=2.505692867263766_p
x(6)=-3.622237947738089_p
w(6)=2.542571078907866_p
x(7)=-1.073611595963112_p
w(7)=1.839290757168741_p
x(8)=1.430053297671360_p
w(8)=5.137475624231900e-1_p
x(9)=4.425276345646928_p
w(9)=3.972396379515544e-2_p
x(10)=8.156107841844275_p
w(10)=1.178955467692957e-3_p
x(11)=12.67732074486877_p
w(11)=1.548357270683168e-5_p
x(12)=18.16072705106239_p
w(12)=7.865427455126384e-8_p
x(13)=24.98824555040593_p
w(13)=1.086403933345531e-10_p
x(14)=34.16548176542965_p
w(14)=1.623881473981693e-14_p
else if(N==15)then
x(1)=-12.82034315702725_p
w(1)=4.599258185989952e-1_p
x(2)=-12.06330374177135_p
w(2)=1.048159551699591_p
x(3)=-10.74173992405371_p
w(3)=1.583393163753766_p
x(4)=-8.924864931323603_p
w(4)=2.033068925629243_p
x(5)=-6.715324220479029_p
w(5)=2.359097149942501_p
x(6)=-4.258785147362770_p
w(6)=2.480527383019203_p
x(7)=-1.766347804101136_p
w(7)=2.077799251952069_p
x(8)=6.316647719802650e-1_p
w(8)=8.490165159690760e-1_p
x(9)=3.323850231373326_p
w(9)=1.042041254073750e-1_p
x(10)=6.656750890642738_p
w(10)=4.707744132915404e-3_p
x(11)=10.66964819253975_p
w(11)=1.016050712118752e-4_p
x(12)=15.44517335298352_p
w(12)=1.021135361587301e-6_p
x(13)=21.17705538620924_p
w(13)=4.011283812981369e-9_p
x(14)=28.26050869580794_p
w(14)=4.260937178574362e-12_p
x(15)=37.72299189387292_p
w(15)=4.760750423609375e-16_p
else if(N==16)then
x(1)=-12.83488389203941_p
w(1)=4.228106623241242e-1_p
x(2)=-12.13815947476872_p
w(2)=9.657465992307915e-1_p
x(3)=-10.91795716157166_p
w(3)=1.465124334466091_p
x(4)=-9.231276626089574_p
w(4)=1.894033803834225_p
x(5)=-7.162582286446358_p
w(5)=2.222033453012231_p
x(6)=-4.830383045404600_p
w(6)=2.393195359572747_p
x(7)=-2.407157870860573_p
w(7)=2.198255711576621_p
x(8)=-6.849929243311717e-2_p
w(8)=1.198824595859381_p
x(9)=2.400437501048214_p
w(9)=2.247018429915176e-1_p
x(10)=5.406197059905056_p
w(10)=1.479383118506277e-2_p
x(11)=9.021140721408406_p
w(11)=4.741188005725059e-4_p
x(12)=13.27827221353476_p
w(12)=7.885021426828387e-6_p
x(13)=18.28575657907396_p
w(13)=6.225915440428461e-8_p
x(14)=24.24893632221555_p
w(14)=1.927472470065870e-10_p
x(15)=31.57318166900636_p
w(15)=1.600361352317207e-13_p
x(16)=41.30601221035642_p
w(16)=1.357731094888422e-17_p
else if(N==17)then
x(1)=-12.8473896155346_p
w(1)=3.908725230461013e-1_p
x(2)=-12.20269006950806_p
w(2)=8.944858246110862e-1_p
x(3)=-11.07054287944413_p
w(3)=1.361859248468883_p
x(4)=-9.498466245486751_p
w(4)=1.770471349417923_p
x(5)=-7.556846898177541_p
w(5)=2.095458170620639_p
x(6)=-5.343573905461301_p
w(6)=2.296068967811881_p
x(7)=-2.999459714549741_p
w(7)=2.236118762083855_p
x(8)=-7.023684134564852e-1_p
w(8)=1.504052369905869_p
x(9)=1.612701319751201_p
w(9)=4.103143664440872e-1_p
x(10)=4.345786723535570_p
w(10)=3.853513853300255e-2_p
x(11)=7.635091248592230_p
w(11)=1.722444982124382e-3_p
x(12)=11.48858768647559_p
w(12)=4.252925672377712e-5_p
x(13)=15.96611862728962_p
w(13)=5.615852802863074e-7_p
x(14)=21.18870434660588_p
w(14)=3.550595380325303e-9_p
x(15)=27.36907746472814_p
w(15)=8.796798970134237e-12_p
x(16)=34.92118085948123_p
w(16)=5.788120963966502e-15_p
x(17)=44.9113329236695_p
w(17)=3.779982773128743e-19_p
else
call GD(-13)
end if
end subroutine GF_m13

! [-12kT;infkT]
subroutine GF_m12(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-9.200741236092172_p
w(1)=6.602046581469052_p
x(2)=-1.780566058575981_p
w(2)=5.397959562724426_p
else if(N==3)then
x(1)=-10.3863228271833_p
w(1)=3.970896361677668_p
x(2)=-4.914383630781427_p
w(2)=6.097468871832251_p
x(3)=4.416798827403419e-1_p
w(3)=1.931640910683559_p
else if(N==4)then
x(1)=-10.9256449512059_p
w(1)=2.688039040018496_p
x(2)=-6.926375203152926_p
w(2)=4.948533310408404_p
x(3)=-1.949879005191662_p
w(3)=3.966938440859460_p
x(4)=2.582281847561768_p
w(4)=3.964953529071178e-1_p
else if(N==5)then
x(1)=-11.21775003746852_p
w(1)=1.973406104700789_p
x(2)=-8.171320104646755_p
w(2)=3.937131361853921_p
x(3)=-3.836133738921368_p
w(3)=4.326414131181671_p
x(4)=2.001112999622220e-1_p
w(4)=1.722880209173696_p
x(5)=5.115869526585487_p
w(5)=4.017433728340080e-2_p
else if(N==6)then
x(1)=-11.39551447976794_p
w(1)=1.532157424654811_p
x(2)=-8.980559274623396_p
w(2)=3.194076495577728_p
x(3)=-5.292284147379992_p
w(3)=3.978908042818781_p
x(4)=-1.412397133027116_p
w(4)=2.890998617259364_p
x(5)=2.265828884958524_p
w(5)=4.012694138016608e-1_p
x(6)=7.977926885664790_p
w(6)=2.596150081132937e-3_p
else if(N==7)then
x(1)=-11.51289577714424_p
w(1)=1.238290578536780_p
x(2)=-9.535701024526400_p
w(2)=2.651912962686577_p
x(3)=-6.387505958437551_p
w(3)=3.523625731090312_p
x(4)=-2.764737148028609_p
w(4)=3.337249472611530_p
x(5)=5.810178127628224e-1_p
w(5)=1.200470194107630_p
x(6)=4.632384969666560_p
w(6)=4.832541957368250e-2_p
x(7)=11.04178517373514_p
w(7)=1.317855869669863e-4_p
else if(N==8)then
x(1)=-11.59518145421869_p
w(1)=1.031148562580225_p
x(2)=-9.934450112874696_p
w(2)=2.247980194110109_p
x(3)=-7.218031646817474_p
w(3)=3.105969843408296_p
x(4)=-3.910260527414525_p
w(4)=3.321424544657500_p
x(5)=-6.724113596965462e-1_p
w(5)=2.030806658311541_p
x(6)=2.618058873454973_p
w(6)=2.587961899276461e-1_p
x(7)=7.276432794340154_p
w(7)=3.874400996812613e-3_p
x(8)=14.23894923830769_p
w(8)=5.750201348513484e-6_p
else if(N==9)then
x(1)=-11.65554732645699_p
w(1)=8.786112345564417e-1_p
x(2)=-10.23187101671797_p
w(2)=1.939420905088743_p
x(3)=-7.859675429019597_p
w(3)=2.750299105654036_p
x(4)=-4.862907552077506_p
w(4)=3.135127184709575_p
x(5)=-1.737857903234759_p
w(5)=2.552614700616517_p
x(6)=1.221781764763104_p
w(6)=7.121950835949182e-1_p
x(7)=4.927523215619398_p
w(7)=3.148882328581681e-2_p
x(8)=10.10255969822781_p
w(8)=2.488812371727524e-4_p
x(9)=17.53210874488066_p
w(9)=2.254502579006168e-7_p
else if(N==10)then
x(1)=-11.70143736900069_p
w(1)=7.623373178880624e-1_p
x(2)=-10.46067026639964_p
w(2)=1.698085999808146_p
x(3)=-8.365451353644632_p
w(3)=2.452804144293197_p
x(4)=-5.650743481225176_p
w(4)=2.906436579556981_p
x(5)=-2.679711983555213_p
w(5)=2.751208152799206_p
x(6)=1.473432436229018e-1_p
w(6)=1.294192463712633_p
x(7)=3.266258367462298_p
w(7)=1.321588491105410e-1_p
x(8)=7.463450502956224_p
w(8)=2.768785474483273e-3_p
x(9)=13.05565412927494_p
w(9)=1.384339520043969e-5_p
x(10)=20.8982486804134_p
w(10)=8.155026968543893e-9_p
else if(N==11)then
x(1)=-11.73733364362342_p
w(1)=6.712008568872320e-1_p
x(2)=-10.64122839551962_p
w(2)=1.505323769477211_p
x(3)=-8.771719225348960_p
w(3)=2.204124221326008_p
x(4)=-6.304720854872241_p
w(4)=2.680543395154973_p
x(5)=-3.510272216590031_p
w(5)=2.753954780178657_p
x(6)=-7.571517779223771e-1_p
w(6)=1.809829733532034_p
x(7)=2.015988290792615_p
w(7)=3.592147101353201e-1_p
x(8)=5.553683911686790_p
w(8)=1.561176025113280e-2_p
x(9)=10.15429128521133_p
w(9)=2.022246263524031e-4_p
x(10)=16.10481473544045_p
w(10)=6.923476430184369e-7_p
x(11)=24.3219640534429_p
w(11)=2.769141492090515e-10_p
else if(N==12)then
x(1)=-11.76607679926471_p
w(1)=5.981118978505864e-1_p
x(2)=-10.78678631785065_p
w(2)=1.348507398583983_p
x(3)=-9.103635411935835_p
w(3)=1.995085565053181_p
x(4)=-6.851814015864749_p
w(4)=2.472022216959022_p
x(5)=-4.237141616713717_p
w(5)=2.665141565170906_p
x(6)=-1.561103439108015_p
w(6)=2.149940454463252_p
x(7)=1.026323334770621_p
w(7)=7.123126940909607e-1_p
x(8)=4.088030202290414_p
w(8)=5.742928446136877e-2_p
x(9)=8.023924088813748_p
w(9)=1.442042128129406e-3_p
x(10)=12.95920462845275_p
w(10)=1.299357118629088e-5_p
x(11)=19.23033036908567_p
w(11)=3.185196671618757e-8_p
x(12)=27.792377161203_p
w(12)=8.934717609581320e-12_p
else if(N==13)then
x(1)=-11.78954464804447_p
w(1)=5.383642467651750e-1_p
x(2)=-10.90626117839069_p
w(2)=1.218880329426004_p
x(3)=-9.378908634820904_p
w(3)=1.817994192497600_p
x(4)=-7.313674422955290_p
w(4)=2.284417217615867_p
x(5)=-4.871172224356003_p
w(5)=2.540388346863140_p
x(6)=-2.289666635874558_p
w(6)=2.316787549182310_p
x(7)=2.009069956230952e-1_p
w(7)=1.120958102443037_p
x(8)=2.923004109928703_p
w(8)=1.554985670586375e-1_p
x(9)=6.363960809869110_p
w(9)=6.602481136807880e-3_p
x(10)=10.6251265527808_p
w(10)=1.143535294422504e-4_p
x(11)=15.85414114284319_p
w(11)=7.563061635539837e-7_p
x(12)=22.41848431052456_p
w(12)=1.369018519873886e-9_p
x(13)=31.30149960793157_p
w(13)=2.763620903949905e-13_p
else if(N==14)then
x(1)=-11.80902298186325_p
w(1)=4.887250723292151e-1_p
x(2)=-11.00584715975431_p
w(2)=1.110225756537054_p
x(3)=-9.610249178076808_p
w(3)=1.666704782676970_p
x(4)=-7.707197741224679_p
w(4)=2.117267933543927_p
x(5)=-5.424613823964295_p
w(5)=2.405629803176663_p
x(6)=-2.950807115922518_p
w(6)=2.362608729390233_p
x(7)=-5.212267645879681e-1_p
w(7)=1.494475086479870_p
x(8)=1.971747518673670_p
w(8)=3.314831821739024e-1_p
x(9)=5.024082428906025_p
w(9)=2.224741161287792e-2_p
x(10)=8.788222854558690_p
w(10)=6.302423350769953e-4_p
x(11)=13.32772582918232_p
w(11)=8.103257811419376e-6_p
x(12)=18.82306399491563_p
w(12)=4.062427656882455e-8_p
x(13)=25.659206480779_p
w(13)=5.559287221299104e-11_p
x(14)=34.84328155467823_p
w(14)=8.249689539477449e-15_p
else if(N==15)then
x(1)=-11.82541886795029_p
w(1)=4.469079230018331e-1_p
x(2)=-11.08996395987817_p
w(2)=1.018032752257445_p
x(3)=-9.806956246799688_p
w(3)=1.536384223298183_p
x(4)=-8.045479500906607_p
w(4)=1.968746719338538_p
x(5)=-5.909202304553865_p
w(5)=2.272452409653286_p
x(6)=-3.548774832642109_p
w(6)=2.337963315678896_p
x(7)=-1.174310703663005_p
w(7)=1.774913648008437_p
x(8)=1.173897295117421_p
w(8)=5.824751078687962e-1_p
x(9)=3.916977298725953_p
w(9)=5.955734379315849e-2_p
x(10)=7.290275316757612_p
w(10)=2.519190592929806e-3_p
x(11)=11.32446608690913_p
w(11)=5.298403286424218e-5_p
x(12)=16.1132404234971_p
w(12)=5.246267888094595e-7_p
x(13)=21.85438761768668_p
w(13)=2.040170790710684e-9_p
x(14)=28.94482556174828_p
w(14)=2.151031218748780e-12_p
x(15)=38.41302525813617_p
w(15)=2.388923411960667e-16_p
else if(N==16)then
x(1)=-11.83938877615162_p
w(1)=4.112545958222708e-1_p
x(2)=-11.16183975234905_p
w(2)=9.389625450514593e-1_p
x(3)=-9.975957343236928_p
w(3)=1.423239372986036_p
x(4)=-8.338694892570295_p
w(4)=1.836687635801957_p
x(5)=-6.335325154601850_p
w(5)=2.145825936436003_p
x(6)=-4.088206012979241_p
w(6)=2.276520989039625_p
x(7)=-1.774824165725617_p
w(7)=1.950435883273843_p
x(8)=4.846962686665800e-1_p
w(8)=8.762583551907714e-1_p
x(9)=2.986325617138983_p
w(9)=1.326165539353202e-1_p
x(10)=6.039124743589070_p
w(10)=7.953510494945696e-3_p
x(11)=9.679195470058017_p
w(11)=2.467010172498241e-4_p
x(12)=13.95118497934918_p
w(12)=4.033550683840588e-6_p
x(13)=18.96874886727672_p
w(13)=3.149649867272988e-8_p
x(14)=24.93932423055301_p
w(14)=9.673505333651781e-11_p
x(15)=32.26933265036522_p
w(15)=7.982827558392253e-14_p
x(16)=42.00700615183795_p
w(16)=6.738246219254128e-18_p
else if(N==17)then
x(1)=-11.85141845977975_p
w(1)=3.805360096459587e-1_p
x(2)=-11.22388129881089_p
w(2)=8.704991647466460e-1_p
x(3)=-10.12249989964047_p
w(3)=1.324281776859505_p
x(4)=-8.594802260812640_p
w(4)=1.718986806242744_p
x(5)=-6.711837363500137_p
w(5)=2.027646271024594_p
x(6)=-4.574452508297811_p
w(6)=2.197705701415914_p
x(7)=-2.329870292100030_p
w(7)=2.038618576803599_p
x(8)=-1.282991917764291e-1_p
w(8)=1.166880952696268_p
x(9)=2.192282845853221_p
w(9)=2.530116371677250e-1_p
x(10)=4.976019219311343_p
w(10)=2.092153398446356e-2_p
x(11)=8.295169484716373_p
w(11)=8.957469459270258e-4_p
x(12)=12.165491114698_p
w(12)=2.168208726641210e-5_p
x(13)=16.65406466034246_p
w(13)=2.827958978740240e-7_p
x(14)=21.88457883724675_p
w(14)=1.772602661455316e-9_p
x(15)=28.07098358456367_p
w(15)=4.363480556113155e-12_p
x(16)=35.62791610329532_p
w(16)=2.856482875863410e-15_p
x(17)=45.62221870629762_p
w(17)=1.857379187357766e-19_p
else
call GD(-12)
end if
end subroutine GF_m12

! [-11kT;infkT]
subroutine GF_m11(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-8.395770707554528_p
w(1)=6.137601896968946_p
x(2)=-1.506528839093654_p
w(2)=4.862414804592372_p
else if(N==3)then
x(1)=-9.486303269819835_p
w(1)=3.723465705690820_p
x(2)=-4.368235927781971_p
w(2)=5.649032165339982_p
x(3)=7.022737847285230e-1_p
w(3)=1.627518830530517_p
else if(N==4)then
x(1)=-9.985591063612290_p
w(1)=2.537364218095198_p
x(2)=-6.216211414040785_p
w(2)=4.648374687321719_p
x(3)=-1.556988852523270_p
w(3)=3.520555628643202_p
x(4)=2.923037008887659_p
w(4)=2.937221675012002e-1_p
else if(N==5)then
x(1)=-10.25753660126174_p
w(1)=1.872627621728586_p
x(2)=-7.369767695940959_p
w(2)=3.725328729097815_p
x(3)=-3.284906335157609_p
w(3)=3.990371790677180_p
x(4)=5.551740005925602e-1_p
w(4)=1.385170002144088_p
x(5)=5.546098948543216_p
w(5)=2.651855791364932e-2_p
else if(N==6)then
x(1)=-10.42383768461882_p
w(1)=1.460101868882122_p
x(2)=-8.124358484447614_p
w(2)=3.037641195397097_p
x(3)=-4.626818879773144_p
w(3)=3.738593492353996_p
x(4)=-9.753043077969421e-1_p
w(4)=2.482769761334350_p
x(5)=2.682361683088820_p
w(5)=2.793157834470798e-1_p
x(6)=8.472088476943870_p
w(6)=1.594600146674604e-3_p
else if(N==7)then
x(1)=-10.53410889585327_p
w(1)=1.184178244401532_p
x(2)=-8.644591330639694_p
w(2)=2.531989953507029_p
x(3)=-5.644904399945920_p
w(3)=3.341196578337963_p
x(4)=-2.223624979662771_p
w(4)=3.009189268156826_p
x(5)=1.000834949740488_p
w(5)=9.033171709389537e-1_p
x(6)=5.124787668059335_p
w(6)=3.006840952507743e-2_p
x(7)=11.58209594883825_p
w(7)=7.707669393760130e-5_p
else if(N==8)then
x(1)=-10.6116893698532_p
w(1)=9.889644217991359e-1_p
x(2)=-9.019801702605196_p
w(2)=2.153206535308428_p
x(3)=-6.421936202095099_p
w(3)=2.961463463157013_p
x(4)=-3.280441505369984_p
w(4)=3.082095613024149_p
x(5)=-2.114460342715943e-1_p
w(5)=1.644380367169310_p
x(6)=3.100271370043383_p
w(6)=1.676411296457012e-1_p
x(7)=7.822237353212466_p
w(7)=2.261930159262599e-3_p
x(8)=14.81479430089747_p
w(8)=3.241298318559425e-6_p
else if(N==9)then
x(1)=-10.66878189433679_p
w(1)=8.447507585606602e-1_p
x(2)=-9.300638663453563_p
w(2)=1.862626679148181_p
x(3)=-7.025186871656059_p
w(3)=2.632559983061125_p
x(4)=-4.165556511369510_p
w(4)=2.954312447181282_p
x(5)=-1.210842907251425_p
w(5)=2.194720086736019_p
x(6)=1.697694457452269_p
w(6)=4.923651568869238e-1_p
x(7)=5.472841086162811_p
w(7)=1.854202722495977e-2_p
x(8)=10.68624128749721_p
w(8)=1.394393486718562e-4_p
x(9)=18.13647940165831_p
w(9)=1.234134946800428e-7_p
else if(N==10)then
x(1)=-10.71230264955454_p
w(1)=7.345145710087082e-1_p
x(2)=-9.517326856960116_p
w(2)=1.634558711866050_p
x(3)=-7.502550025019208_p
w(3)=2.354856969619964_p
x(4)=-4.902496675936167_p
w(4)=2.762824107627549_p
x(5)=-2.083839477536642_p
w(5)=2.469500875533183_p
x(6)=6.355301840957475e-1_p
w(6)=9.623824349789676e-1_p
x(7)=3.804976417793849_p
w(7)=7.982342200074349e-2_p
x(8)=8.051870941011479_p
w(8)=1.548082144966139e-3_p
x(9)=13.66840422519696_p
w(9)=7.522423089314714e-6_p
x(10)=21.52617571387203_p
w(10)=4.358097377473827e-9_p
else if(N==11)then
x(1)=-10.74642801625353_p
w(1)=6.478980479072942e-1_p
x(2)=-9.688773673518634_p
w(2)=1.451853270706891_p
x(3)=-7.887230696102693_p
w(3)=2.121278974673531_p
x(4)=-5.517492902840921_p
w(4)=2.562163506133144_p
x(5)=-2.854499171104240_p
w(5)=2.540621922424357_p
x(6)=-2.354813374756865e-1_p
w(6)=1.440279623190645_p
x(7)=2.546041289904284_p
w(7)=2.270462694171058e-1_p
x(8)=6.142995453967855_p
w(8)=8.765405574544850e-3_p
x(9)=10.77356381814093_p
w(9)=1.093141998981528e-4_p
x(10)=16.74100927957875_p
w(10)=3.671888817168803e-7_p
x(11)=24.96976266692072_p
w(11)=1.450264490465414e-10_p
else if(N==12)then
x(1)=-10.7738119322368_p
w(1)=5.782823944785650e-1_p
x(2)=-9.827304186751329_p
w(2)=1.302837734791813_p
x(3)=-8.202371648876978_p
w(3)=1.924040556473184_p
x(4)=-6.034134710947886_p
w(4)=2.371930216739249_p
x(5)=-3.532519154844243_p
w(5)=2.500032507423756_p
x(6)=-9.931293307695769e-1_p
w(6)=1.811026954340551_p
x(7)=1.553247093489355_p
w(7)=4.783966911827539e-1_p
x(8)=4.674137392351274_p
w(8)=3.268520140355065e-2_p
x(9)=8.647513858582936_p
w(9)=7.775798753353983e-4_p
x(10)=13.60240145139177_p
w(10)=6.848290274946937e-6_p
x(11)=19.88603347485617_p
w(11)=1.655768579381007e-8_p
x(12)=28.45722477396785_p
w(12)=4.599196977957570e-12_p
else if(N==13)then
x(1)=-10.79621303745627_p
w(1)=5.212630858308258e-1_p
x(2)=-9.941243247727559_p
w(2)=1.179382550773611_p
x(3)=-8.464353240239506_p
w(3)=1.756348933132279_p
x(4)=-6.471766431651170_p
w(4)=2.198249403389463_p
x(5)=-4.127221660567272_p
w(5)=2.407779305984453_p
x(6)=-1.672813491248375_p
w(6)=2.037999572277041_p
x(7)=7.366115279868961e-1_p
w(7)=8.045026876378819e-1_p
x(8)=3.502674463063621_p
w(8)=9.086665889624776e-2_p
x(9)=6.989455384228512_p
w(9)=3.564118629838643e-3_p
x(10)=11.27385993921902_p
w(10)=5.999369847965241e-5_p
x(11)=16.51682131214645_p
w(11)=3.906113559571343e-7_p
x(12)=23.09078459343871_p
w(12)=6.997008889216947e-10_p
x(13)=31.98117821965935_p
w(13)=1.401423184139801e-13_p
else if(N==14)then
x(1)=-10.81483819606758_p
w(1)=4.738075654700418e-1_p
x(2)=-10.03638879540547_p
w(2)=1.075695504850944_p
x(3)=-8.684983250157350_p
w(3)=1.612669982853399_p
x(4)=-6.845697138576836_p
w(4)=2.042075301653227_p
x(5)=-4.648807499448858_p
w(5)=2.295482338542401_p
x(6)=-2.288846527819193_p
w(6)=2.142780532907360_p
x(7)=3.628873460098322e-2_p
w(7)=1.143366133426465_p
x(8)=2.544378116189421_p
w(8)=2.017225058399903e-1_p
x(9)=5.648881097333830_p
w(9)=1.208293064041726e-2_p
x(10)=9.440994464911249_p
w(10)=3.297218380869522e-4_p
x(11)=13.99630146169319_p
w(11)=4.162880556735363e-6_p
x(12)=19.50210642802058_p
w(12)=2.063042410894373e-8_p
x(13)=26.34586808531682_p
w(13)=2.800138846651182e-11_p
x(14)=35.53601149655011_p
w(14)=4.128660023161775e-15_p
else if(N==15)then
x(1)=-10.83054053021924_p
w(1)=4.337665215529432e-1_p
x(2)=-10.11688756567325_p
w(2)=9.875609420451147e-1_p
x(3)=-8.872931514541385_p
w(3)=1.488598547755311_p
x(4)=-7.167908344559863_p
w(4)=1.902422568612996_p
x(5)=-5.107294299902393_p
w(5)=2.178542581508068_p
x(6)=-2.847710565778171_p
w(6)=2.164647348492025_p
x(7)=-5.855907698670407e-1_p
w(7)=1.436858882996260_p
x(8)=1.742828258252498_p
w(8)=3.735017593115197e-1_p
x(9)=4.538502753411830_p
w(9)=3.277314142403338e-2_p
x(10)=7.945535821281977_p
w(10)=1.317035129285695e-3_p
x(11)=11.9978706110408_p
w(11)=2.710675383388254e-5_p
x(12)=16.79817958994163_p
w(12)=2.649575814348327e-7_p
x(13)=22.5474713586678_p
w(13)=1.021277988238018e-9_p
x(14)=29.64408266205186_p
w(14)=1.069697888049399e-12_p
x(15)=39.11735339025716_p
w(15)=1.181674883435511e-16_p
else if(N==16)then
x(1)=-10.84393862655224_p
w(1)=3.995782023494962e-1_p
x(2)=-10.18577483760463_p
w(2)=9.118503258455836e-1_p
x(3)=-9.034676375024970_p
w(3)=1.380648776551495_p
x(4)=-7.447775912885660_p
w(4)=1.777664762810675_p
x(5)=-5.511768478537978_p
w(5)=2.064185304760844_p
x(6)=-3.354034517270591_p
w(6)=2.137115460686855_p
x(7)=-1.150779524327043_p
w(7)=1.654136495087671_p
x(8)=1.056819424614515_p
w(8)=5.959294135671345e-1_p
x(9)=3.602557384114439_p
w(9)=7.461375506642509e-2_p
x(10)=6.695235535662052_p
w(10)=4.166319709045423e-3_p
x(11)=10.35638891076118_p
w(11)=1.258417253561759e-4_p
x(12)=14.64119571898533_p
w(12)=2.027672269875739e-6_p
x(13)=19.66757077791914_p
w(13)=1.568060553421413e-8_p
x(14)=25.6446559612548_p
w(14)=4.782323786832186e-11_p
x(15)=32.97975949095325_p
w(15)=3.925221140474113e-14_p
x(16)=42.72172815385868_p
w(16)=3.298365531597999e-18_p
else if(N==17)then
x(1)=-10.85549099982975_p
w(1)=3.700829605797171e-1_p
x(2)=-10.24531797362763_p
w(2)=8.462005405554566e-1_p
x(3)=-9.175138050864573_p
w(3)=1.286057544525065_p
x(4)=-7.692673068422883_p
w(4)=1.666064018022895_p
x(5)=-5.870119930691639_p
w(5)=1.955626213664033_p
x(6)=-3.812376102388810_p
w(6)=2.082644027376542_p
x(7)=-1.670675393725759_p
w(7)=1.792378666886351_p
x(8)=4.554150112559257e-1_p
w(8)=8.424230427172471e-1_p
x(9)=2.802535452965667_p
w(9)=1.470518922214807e-1_p
x(10)=5.631257822947817_p
w(10)=1.102062752750342e-2_p
x(11)=8.975115793878858_p
w(11)=4.561681098994223e-4_p
x(12)=12.85979095386209_p
w(12)=1.085838162489236e-5_p
x(13)=17.35795648554185_p
w(13)=1.401196858025951e-7_p
x(14)=22.59541886600556_p
w(14)=8.716822864693781e-10_p
x(15)=28.78713776373321_p
w(15)=2.133601243235924e-12_p
x(16)=36.34834057160742_p
w(16)=1.390447631845921e-15_p
x(17)=46.34632356299704_p
w(17)=9.006459533113421e-20_p
else
call GD(-11)
end if
end subroutine GF_m11

! [-10kT;infkT]
subroutine GF_m10(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-7.589291604880055_p
w(1)=5.675311882692907_p
x(2)=-1.221802100721404_p
w(2)=4.324733516206310_p
else if(N==3)then
x(1)=-8.585496555093298_p
w(1)=3.477526165098068_p
x(2)=-3.820530664777785_p
w(2)=5.186811694320807_p
x(3)=9.860666955813724e-1_p
w(3)=1.335707539480342_p
else if(N==4)then
x(1)=-9.045154604993709_p
w(1)=2.387438931678964_p
x(2)=-5.505463619299148_p
w(2)=4.342786828407171_p
x(3)=-1.157816323315435_p
w(3)=3.060088862366499_p
x(4)=3.295961913561928_p
w(4)=2.097307764465837e-1_p
else if(N==5)then
x(1)=-9.297150997381326_p
w(1)=1.772164747565641_p
x(2)=-6.568033857374443_p
w(2)=3.511187681918511_p
x(3)=-2.735520320810697_p
w(3)=3.627022219007637_p
x(4)=9.341767625781312e-1_p
w(4)=1.072723065897711_p
x(5)=6.006574317458223_p
w(5)=1.694768450971705e-2_p
else if(N==6)then
x(1)=-9.452099644090413_p
w(1)=1.388124608118155_p
x(2)=-7.268242767389183_p
w(2)=2.879830505762380_p
x(3)=-3.963938304413228_p
w(3)=3.481266741848998_p
x(4)=-5.310681376130680e-1_p
w(4)=2.063661054138478_p
x(5)=3.132688689823216_p
w(5)=1.862097379559514e-1_p
x(6)=8.993027010392536_p
w(6)=9.527510752550011e-4_p
else if(N==7)then
x(1)=-9.555320552439506_p
w(1)=1.130015410502581_p
x(2)=-7.753725776689699_p
w(2)=2.411049249581520_p
x(3)=-4.904511670069176_p
w(3)=3.149315366919483_p
x(4)=-1.685779131852667_p
w(4)=2.644314743151385_p
x(5)=1.448645955438238_p
w(5)=6.472142083152083e-1_p
x(6)=5.647385498519457_p
w(6)=1.809243818044958e-2_p
x(7)=12.14658196402564_p
w(7)=4.398224859028073e-5_p
else if(N==8)then
x(1)=-9.628228432679833_p
w(1)=9.466604043129438e-1_p
x(2)=-8.105484817588136_p
w(2)=2.057582109189131_p
x(3)=-5.627717747742147_p
w(3)=2.811270590156890_p
x(4)=-2.656520346047210_p
w(4)=2.809366434036807_p
x(5)=2.633552229731640e-1_p
w(5)=1.269983201718754_p
x(6)=3.616143170833610_p
w(6)=1.038955516751187e-1_p
x(7)=8.393930661409803_p
w(7)=1.285321320373140e-3_p
x(8)=15.41279614012964_p
w(8)=1.786489199307664e-6_p
else if(N==9)then
x(1)=-9.682065265471909_p
w(1)=8.107341271459941e-1_p
x(2)=-8.369781210751535_p
w(2)=1.785079818178739_p
x(3)=-6.192345665022462_p
w(3)=2.511032584486491_p
x(4)=-3.473805652680996_p
w(4)=2.750687100015107_p
x(5)=-6.831205857299746e-1_p
w(5)=1.809690141636326_p
x(6)=2.205969577947786_p
w(6)=3.221677848190707e-1_p
x(7)=6.046663086454349_p
w(7)=1.057747756893992e-2_p
x(8)=11.29297056115455_p
w(8)=7.629887743216598e-5_p
x(9)=18.76137286350605_p
w(9)=6.617111634194061e-8_p
else if(N==10)then
x(1)=-9.723225912935650_p
w(1)=7.065181875747334e-1_p
x(2)=-8.574375512923954_p
w(2)=1.570348197971932_p
x(3)=-6.641129380929998_p
w(3)=2.254158866230011_p
x(4)=-4.159028746082773_p
w(4)=2.604370153471480_p
x(5)=-1.494255554382590_p
w(5)=2.143421464281334_p
x(6)=1.147456409070011_p
w(6)=6.740721035813015e-1_p
x(7)=4.375411858186191_p
w(7)=4.630860182317514e-2_p
x(8)=8.664596261603462_p
w(8)=8.438204905595268e-4_p
x(9)=14.30216830431625_p
w(9)=4.001190274391857e-6_p
x(10)=22.17327084772196_p
w(10)=2.284415371247907e-9_p
else if(N==11)then
x(1)=-9.755584638087310_p
w(1)=6.244149508235040e-1_p
x(2)=-8.736712816004236_p
w(2)=1.397754776597229_p
x(3)=-7.004092507102143_p
w(3)=2.036301124410628_p
x(4)=-4.734305854678002_p
w(4)=2.433863384245550_p
x(5)=-2.207092188727888_p
w(5)=2.285934600432631_p
x(6)=2.974975611905444e-1_p
w(6)=1.080706625075275_p
x(7)=3.109612898457574_p
w(7)=1.362296513384349e-1_p
x(8)=6.758483175591900_p
w(8)=4.782303192475306e-3_p
x(9)=11.41448003146258_p
w(9)=5.779176576773219e-5_p
x(10)=17.39664226434477_p
w(10)=1.909431331368885e-7_p
x(11)=25.63558657924636_p
w(11)=7.458792298595650e-11_p
else if(N==12)then
x(1)=-9.781610693787981_p
w(1)=5.582722257073239e-1_p
x(2)=-8.868208874694258_p
w(2)=1.256586940224353_p
x(3)=-7.302350343691741_p
w(3)=1.851261376345065_p
x(4)=-5.219920298420468_p
w(4)=2.264885128363835_p
x(5)=-2.836082968818161_p
w(5)=2.303070054888020_p
x(6)=-4.248042791416450e-1_p
w(6)=1.445885480028356_p
x(7)=2.111354759992304_p
w(7)=3.016980176149446e-1_p
x(8)=5.288934251927386_p
w(8)=1.797308559436643e-2_p
x(9)=9.293640430066443_p
w(9)=4.095442204460728e-4_p
x(10)=14.26536368563016_p
w(10)=3.537459425466003e-6_p
x(11)=20.55989999334495_p
w(11)=8.450754014891253e-9_p
x(12)=29.13911975763506_p
w(12)=2.327225813128926e-12_p
else if(N==13)then
x(1)=-9.802944732523734_p
w(1)=5.039844922558308e-1_p
x(2)=-8.976600168688634_p
w(2)=1.139344727564864_p
x(3)=-7.550947734773477_p
w(3)=1.693243714786153_p
x(4)=-5.632881188773164_p
w(4)=2.106965465095334_p
x(5)=-3.390590997206719_p
w(5)=2.252110967401716_p
x(6)=-1.062427565763326_p
w(6)=1.712940860843568_p
x(7)=1.296258290404108_p
w(7)=5.387043188637678e-1_p
x(8)=4.113636022933184_p
w(8)=5.084447146040432e-2_p
x(9)=7.638761996184767_p
w(9)=1.875353894531170e-3_p
x(10)=11.94280699436571_p
w(10)=3.082835528110794e-5_p
x(11)=17.19782582794715_p
w(11)=1.980261942598798e-7_p
x(12)=23.78018745948154_p
w(12)=3.515021562956727e-10_p
x(13)=32.67705704476367_p
w(13)=6.991842078754533e-14_p
else if(N==14)then
x(1)=-9.820715399240081_p
w(1)=4.587178817484152e-1_p
x(2)=-9.067290760279867_p
w(2)=1.040661830292795_p
x(3)=-7.760786036078033_p
w(3)=1.557374432697868_p
x(4)=-5.986874546981522_p
w(4)=1.962951442444875_p
x(5)=-3.879384879735112_p
w(5)=2.168757815058630_p
x(6)=-1.636362636593299_p
w(6)=1.873680436703043_p
x(7)=6.076261950491434e-1_p
w(7)=8.151481659627882e-1_p
x(8)=3.149679035408263_p
w(8)=1.162078426306880e-1_p
x(9)=6.299235055376679_p
w(9)=6.374633917770719e-3_p
x(10)=10.11459940747394_p
w(10)=1.688085776503636e-4_p
x(11)=14.68342795068508_p
w(11)=2.098554196419095e-6_p
x(12)=20.19831363617556_p
w(12)=1.029661982637806e-8_p
x(13)=27.04873165877067_p
w(13)=1.387576472596986e-11_p
x(14)=36.24419992586615_p
w(14)=2.034418814482857e-15_p
else if(N==15)then
x(1)=-9.835722302194297_p
w(1)=4.204592640834092e-1_p
x(2)=-9.144155853134679_p
w(2)=9.566186407401555e-1_p
x(3)=-7.939903362394818_p
w(3)=1.439703317064570_p
x(4)=-6.292740056243495_p
w(4)=1.832965113597395_p
x(5)=-4.310946473016213_p
w(5)=2.072518869957828_p
x(6)=-2.156786402685434_p
w(6)=1.948145348572929_p
x(7)=7.026720934025918e-3_p
w(7)=1.087394009358152_p
x(8)=2.343063434227752_p
w(8)=2.241321691315286e-1_p
x(9)=5.187734112726094_p
w(9)=1.742199581152172e-2_p
x(10)=8.622479265534754_p
w(10)=6.729362875407564e-4_p
x(11)=12.69014058353754_p
w(11)=1.360229958020217e-5_p
x(12)=17.50038557291997_p
w(12)=1.314911347008956e-7_p
x(13)=23.25675783059448_p
w(13)=5.029477482249950e-10_p
x(14)=30.35876496038322_p
w(14)=5.237684587624757e-13_p
x(15)=39.83648451639409_p
w(15)=5.758943641997787e-17_p
else if(N==16)then
x(1)=-9.848546410402642_p
w(1)=3.877427563080178e-1_p
x(2)=-9.210038691584955_p
w(2)=8.842973839595019e-1_p
x(3)=-8.094327341284350_p
w(3)=1.337067488842792_p
x(4)=-6.559035068833240_p
w(4)=1.716068141607882_p
x(5)=-4.693089822199627_p
w(5)=1.973466485874236_p
x(6)=-2.629555448067344_p
w(6)=1.963033828943381_p
x(7)=-5.304147728205207e-1_p
w(7)=1.320008615282153_p
x(8)=1.655450064520418_p
w(8)=3.759392240556383e-1_p
x(9)=4.248695706614122_p
w(9)=4.022880985918401e-2_p
x(10)=7.374171113759405_p
w(10)=2.128730318583768e-3_p
x(11)=11.05287298112113_p
w(11)=6.292475329715783e-5_p
x(12)=15.34862820048992_p
w(12)=1.001391700914861e-6_p
x(13)=20.38262232770834_p
w(13)=7.679551516240357e-9_p
x(14)=26.36537447050511_p
w(14)=2.327895432405632e-11_p
x(15)=33.70493289992374_p
w(15)=1.901678239195193e-14_p
x(16)=43.45066909176157_p
w(16)=1.591684500096668e-18_p
else if(N==17)then
x(1)=-9.859619164663929_p
w(1)=3.594777908646137e-1_p
x(2)=-9.267067748562157_p
w(2)=8.214881979554354e-1_p
x(3)=-8.228649861241962_p
w(3)=1.246938746489436_p
x(4)=-6.792534667847691_p
w(4)=1.610974456153249_p
x(5)=-5.032723688559221_p
w(5)=1.876614919095088_p
x(6)=-3.059143980397058_p
w(6)=1.940718363363861_p
x(7)=-1.019815143174315_p
w(7)=1.495398974015314_p
x(8)=1.058112767942232_p
w(8)=5.614981559494947e-1_p
x(9)=3.444228762828166_p
w(9)=8.105790262535478e-2_p
x(10)=6.310793925911792_p
w(10)=5.644947738379057e-3_p
x(11)=9.674916736007203_p
w(11)=2.275353130079171e-4_p
x(12)=13.57172985398879_p
w(12)=5.340623935663579e-6_p
x(13)=18.07814020038539_p
w(13)=6.828896197907607e-8_p
x(14)=23.32162535089521_p
w(14)=4.220568446252464e-10_p
x(15)=29.51797482411764_p
w(15)=1.027964937260599e-12_p
x(16)=37.0829123184892_p
w(16)=6.672809861986115e-16_p
x(17)=47.08412315306948_p
w(17)=4.307689766877253e-20_p
else
call GD(-10)
end if
end subroutine GF_m10

! [-9kT;infkT]
subroutine GF_m9(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-6.781260852918477_p
w(1)=5.214314237558836_p
x(2)=-9.236268371767800e-1_p
w(2)=3.785809164630887_p
else if(N==3)then
x(1)=-7.683954151714736_p
w(1)=3.232601260062967_p
x(2)=-3.271349655999011_p
w(2)=4.705941078364771_p
x(3)=1.297723451491527_p
w(3)=1.061581063761986_p
else if(N==4)then
x(1)=-8.104403839348128_p
w(1)=2.237917820800087_p
x(2)=-4.794759873890775_p
w(2)=4.027699918324601_p
x(3)=-7.489886595383116e-1_p
w(3)=2.590639732769998_p
x(4)=3.704167848071610_p
w(4)=1.438659302950360e-1_p
else if(N==5)then
x(1)=-8.336658183800775_p
w(1)=1.671747601583987_p
x(2)=-5.766653705586105_p
w(2)=3.292411052253654_p
x(3)=-2.187822788996405_p
w(3)=3.230796736230749_p
x(4)=1.342701985908042_p
w(4)=7.946965335244519e-1_p
x(5)=6.498878996243528_p
w(5)=1.047147859688094e-2_p
else if(N==6)then
x(1)=-8.480357673407347_p
w(1)=1.316007789854031_p
x(2)=-6.412636685663035_p
w(2)=2.719238535012091_p
x(3)=-3.304752232639726_p
w(3)=3.198813660559332_p
x(4)=-7.417349258797230e-2_p
w(4)=1.646817535822792_p
x(5)=3.619130794649189_p
w(5)=1.186927755246831e-1_p
x(6)=9.541947047575144_p
w(6)=5.531054167935924e-4_p
else if(N==7)then
x(1)=-8.576580389680734_p
w(1)=1.075622160235427_p
x(2)=-6.863446578096177_p
w(2)=2.288139551653221_p
x(3)=-4.167503453092448_p
w(3)=2.942091252124726_p
x(4)=-1.148802123107691_p
w(4)=2.244550218314371_p
x(5)=1.929838343876886_p
w(5)=4.391713585010832e-1_p
x(6)=6.200997042306462_p
w(6)=1.052439917569892e-2_p
x(7)=12.73626044555126_p
w(7)=2.446218519667578e-5_p
else if(N==8)then
x(1)=-8.644841616996203_p
w(1)=9.040850980206296e-1_p
x(2)=-7.191781617272031_p
w(2)=1.960412344713226_p
x(3)=-4.836375792778110_p
w(3)=2.651495433552247_p
x(4)=-2.038790547526094_p
w(4)=2.494457332260455_p
x(5)=7.594847970428568e-1_p
w(5)=9.273201502151485e-1_p
x(6)=4.166742587470021_p
w(6)=6.164162966399555e-2_p
x(7)=8.992251431355157_p
w(7)=7.104518352858954e-4_p
x(8)=16.03384823426031_p
w(8)=9.619287355999905e-7_p
else if(N==9)then
x(1)=-8.695434853613001_p
w(1)=7.764318563897410e-1_p
x(2)=-7.439536012185579_p
w(2)=1.706244755850808_p
x(3)=-5.361973955255759_p
w(3)=2.383081503426771_p
x(4)=-2.789019396533470_p
w(4)=2.513649000224065_p
x(5)=-1.484044883245808e-1_p
w(5)=1.415510087816152_p
x(6)=2.749973494721224_p
w(6)=1.993180622614897e-1_p
x(7)=6.649312671876570_p
w(7)=5.847354460903985e-3_p
x(8)=11.92346311940306_p
w(8)=4.074703657604473e-5_p
x(9)=19.4075974240917_p
w(9)=3.472321702332459e-8_p
else if(N==10)then
x(1)=-8.734239982638096_p
w(1)=6.782359036478686e-1_p
x(2)=-7.632019272933647_p
w(2)=1.505024798189425_p
x(3)=-5.781870068031213_p
w(3)=2.148844128719436_p
x(4)=-3.421893522424452_p
w(4)=2.422348541677218_p
x(5)=-9.078113964842383e-1_p
w(5)=1.776984751988813_p
x(6)=1.689927974115049_p
w(6)=4.423834139619237e-1_p
x(7)=4.977649713444378_p
w(7)=2.585153210361654e-2_p
x(8)=9.302091283829512_p
w(8)=4.482488768073187e-4_p
x(9)=14.95762642568723_p
w(9)=2.081850966478539e-6_p
x(10)=22.84028090058109_p
w(10)=1.173647689686265e-9_p
else if(N==11)then
x(1)=-8.764832536833886_p
w(1)=6.006530743470894e-1_p
x(2)=-7.785221956785437_p
w(2)=1.342673234020999_p
x(3)=-6.122876699590067_p
w(3)=1.947809127661576_p
x(4)=-3.956601717083454_p
w(4)=2.289142725229494_p
x(5)=-1.567602921726896_p
w(5)=1.982049369003556_p
x(6)=8.505108107636895e-1_p
w(6)=7.574181649538489e-1_p
x(7)=3.707625609570740_p
w(7)=7.781128696304400e-2_p
x(8)=7.400246158712635_p
w(8)=2.536455523247765e-3_p
x(9)=12.07756748455563_p
w(9)=2.986715398130378e-5_p
x(10)=18.07236139544845_p
w(10)=9.729524258320348e-8_p
x(11)=26.32013607452222_p
w(11)=3.764495208532974e-11_p
else if(N==12)then
x(1)=-8.789498952641047_p
w(1)=5.379940965621900e-1_p
x(2)=-7.909654989867835_p
w(2)=1.209454858844759_p
x(3)=-6.404059817746219_p
w(3)=1.775684381132815_p
x(4)=-4.410433139448481_p
w(4)=2.146123472557842_p
x(5)=-2.148874933278524_p
w(5)=2.061956354783386_p
x(6)=1.517845497100739e-1_p
w(6)=1.080238078654534_p
x(7)=2.704086597542274_p
w(7)=1.788940019575335e-1_p
x(8)=5.932109148059223_p
w(8)=9.565714248073053e-3_p
x(9)=9.962628646986015_p
w(9)=2.106493023130368e-4_p
x(10)=14.9486321705431_p
w(10)=1.789913003020195e-6_p
x(11)=21.25255058704104_p
w(11)=4.232118326942672e-9_p
x(12)=29.83872568952323_p
w(12)=1.156814412978154e-12_p
else if(N==13)then
x(1)=-8.809762951425064_p
w(1)=4.864504055302774e-1_p
x(2)=-8.012469026329438_p
w(2)=1.098508511718315_p
x(3)=-6.639114887467832_p
w(3)=1.627832681406808_p
x(4)=-4.798107869167244_p
w(4)=2.007030872560923_p
x(5)=-2.662915525880427_p
w(5)=2.061302478052335_p
x(6)=-4.532255675760256e-1_p
w(6)=1.355011683031785_p
x(7)=1.886631292110175_p
w(7)=3.356675005986293e-1_p
x(8)=4.755464846124475_p
w(8)=2.734152896324917e-2_p
x(9)=8.311922329750464_p
w(9)=9.621312385886590e-4_p
x(10)=12.63238402701029_p
w(10)=1.551042280550551e-5_p
x(11)=17.89769393924876_p
w(11)=9.849251397313379e-8_p
x(12)=24.48729082926344_p
w(12)=1.734598918584223e-10_p
x(13)=33.38976970695389_p
w(13)=3.429821150085738e-14_p
else if(N==14)then
x(1)=-8.826675566422185_p
w(1)=4.433856754394452e-1_p
x(2)=-8.098675659507492_p
w(2)=1.004899117674761_p
x(3)=-6.838028059548679_p
w(3)=1.500127292507859_p
x(4)=-5.131670770944996_p
w(4)=1.877215508416541_p
x(5)=-3.118107400374313_p
w(5)=2.015239559761733_p
x(6)=-9.909161240749585e-1_p
w(6)=1.554679585000322_p
x(7)=1.202002768013199_p
w(7)=5.375246841280691e-1_p
x(8)=3.788000984443570_p
w(8)=6.369554901760474e-2_p
x(9)=6.974816463866687_p
w(9)=3.270824921752079e-3_p
x(10)=10.80929780290089_p
w(10)=8.456261115484613e-5_p
x(11)=15.38955673392627_p
w(11)=1.037655731423165e-6_p
x(12)=20.91221851835054_p
w(12)=5.047986911980888e-9_p
x(13)=27.76837559367717_p
w(13)=6.760862614541254e-12_p
x(14)=36.96845534141407_p
w(14)=9.864341644219247e-16_p
else if(N==15)then
x(1)=-8.840983244470365_p
w(1)=4.069223240861285e-1_p
x(2)=-8.171879305433423_p
w(2)=9.250064479448887e-1_p
x(3)=-7.008199962257097_p
w(3)=1.389121762935146_p
x(4)=-5.420792802044534_p
w(4)=1.758291795629356_p
x(5)=-3.521845515936899_p
w(5)=1.946209764164095_p
x(6)=-1.475691065213292_p
w(6)=1.678686179234516_p
x(7)=6.131653977072158e-1_p
w(7)=7.601069317112646e-1_p
x(8)=2.977001718567611_p
w(8)=1.264642328502698e-1_p
x(9)=5.863965508298815_p
w(9)=8.971110623940714e-3_p
x(10)=9.321159745420164_p
w(10)=3.360957574747674e-4_p
x(11)=13.40162783255745_p
w(11)=6.692915124069260e-6_p
x(12)=18.22032414347779_p
w(12)=6.409372151508129e-8_p
x(13)=23.98277186216882_p
w(13)=2.435446203171561e-10_p
x(14)=31.08943374016003_p
w(14)=2.523708784371553e-13_p
x(15)=40.57100558641628_p
w(15)=2.763647641116974e-17_p
else if(N==16)then
x(1)=-8.853229541210652_p
w(1)=3.756899965282597e-1_p
x(2)=-8.234731533061728_p
w(2)=8.561257129625162e-1_p
x(3)=-7.155203550747760_p
w(3)=1.292005122691869_p
x(4)=-5.673189950925535_p
w(4)=1.650242451428187_p
x(5)=-3.880830895719098_p
w(5)=1.867243662395137_p
x(6)=-1.915733605562518_p
w(6)=1.740783298602063_p
x(7)=9.439839320421535e-2_p
w(7)=9.756246239357651e-1_p
x(8)=2.285967105673965_p
w(8)=2.204328550979857e-1_p
x(9)=4.923871959086783_p
w(9)=2.088272686750026e-2_p
x(10)=8.075713406715050_p
w(10)=1.061623814051293e-3_p
x(11)=11.76888073519236_p
w(11)=3.083848220089594e-5_p
x(12)=16.0738764304774_p
w(12)=4.856749025604627e-7_p
x(13)=21.11437452580694_p
w(13)=3.698125165898673e-9_p
x(14)=27.10199590569329_p
w(14)=1.115156112378649e-11_p
x(15)=34.44539891917539_p
w(15)=9.072765584090337e-15_p
x(16)=44.19439709725511_p
w(16)=7.567902049282212e-19_p
else if(N==17)then
x(1)=-8.863818940047986_p
w(1)=3.486670338847219e-1_p
x(2)=-8.289222062907617_p
w(2)=7.962018700371281e-1_p
x(3)=-7.283299546622056_p
w(3)=1.206502037810051_p
x(4)=-5.895021906323899_p
w(4)=1.552374599379671_p
x(5)=-4.201032125392087_p
w(5)=1.785556021239550_p
x(6)=-2.316358185329777_p
w(6)=1.758160775487709_p
x(7)=-3.716388440108341e-1_p
w(7)=1.162393985757352_p
x(8)=1.688080020691938_p
w(8)=3.446782039107160e-1_p
x(9)=4.116901980213625_p
w(9)=4.265899081060199e-2_p
x(10)=7.014072832392166_p
w(10)=2.816103748420969e-3_p
x(11)=10.3946575436228_p
w(11)=1.111681405018292e-4_p
x(12)=14.3016224442002_p
w(12)=2.579058655823524e-6_p
x(13)=18.81503127128776_p
w(13)=3.272303860004126e-8_p
x(14)=24.06366989782795_p
w(14)=2.011167619304753e-10_p
x(15)=30.26400209704936_p
w(15)=4.877640576952688e-13_p
x(16)=37.83216362658488_p
w(16)=3.155469019965567e-16_p
x(17)=47.83616893166293_p
w(17)=2.031106405326982e-20_p
else
call GD(-9)
end if
end subroutine GF_m9

! [-8kT;infkT]
subroutine GF_m8(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.971704484755712_p
w(1)=4.752846008513156_p
x(2)=-6.083138548639736e-1_p
w(2)=3.247489397859739_p
else if(N==3)then
x(1)=-6.781796996285888_p
w(1)=2.987695812996957_p
x(2)=-2.720431276468587_p
w(2)=4.201208061361022_p
x(3)=1.642726007373623_p
w(3)=8.114315320149164e-1_p
else if(N==4)then
x(1)=-7.163458354920818_p
w(1)=2.088130210028070_p
x(2)=-4.084906596437593_p
w(2)=3.696910776704428_p
x(3)=-3.256325843255794e-1_p
w(3)=2.120784966674070_p
x(4)=4.150707425983287_p
w(4)=9.450945296632805e-2_p
else if(N==5)then
x(1)=-7.376161323223533_p
w(1)=1.570880762786066_p
x(2)=-4.966390087432366_p
w(2)=3.065082738871327_p
x(3)=-1.640485541089629_p
w(3)=2.798925012474315_p
x(4)=1.786660581332027_p
w(4)=5.592009592467970e-1_p
x(5)=7.024657706723565_p
w(5)=6.245932994392010e-3_p
else if(N==6)then
x(1)=-7.508698539121582_p
w(1)=1.243365717087255_p
x(2)=-5.558157102196564_p
w(2)=2.553369838592851_p
x(3)=-2.650139972896226_p
w(3)=2.881253501791746_p
x(4)=4.025782404775194e-1_p
w(4)=1.249767160024774_p
x(5)=4.143587040919606_p
w(5)=7.226759645952095e-2_p
x(6)=10.1201578781191_p
w(6)=3.115924167494456e-4_p
else if(N==7)then
x(1)=-7.597961519522404_p
w(1)=1.020687250979850_p
x(2)=-5.974250721386938_p
w(2)=2.161551519859335_p
x(3)=-3.435253935893861_p
w(3)=2.710582240414992_p
x(4)=-6.079159231743126e-1_p
w(4)=1.820425967762249_p
x(5)=2.449099572936666_p
w(5)=2.811591016223564e-1_p
x(6)=6.786471392417435_p
w(6)=5.916079475319015e-3_p
x(7)=13.35226069409756_p
w(7)=1.324625879291145e-5_p
else if(N==8)then
x(1)=-7.661591120563749_p
w(1)=8.609805077627389e-1_p
x(2)=-6.279099710626079_p
w(2)=1.860448254246041_p
x(3)=-4.049213500567708_p
w(3)=2.475609857837928_p
x(4)=-1.425904496184196_p
w(4)=2.132982610181226_p
x(5)=1.284938515574827_p
w(5)=6.348846238529070e-1_p
x(6)=4.752743837249968_p
w(6)=3.504733912434832e-2_p
x(7)=9.618035471386074_p
w(7)=3.817078773650964e-4_p
x(8)=16.67895960931263_p
w(8)=5.054903416745884e-7_p
else if(N==9)then
x(1)=-7.708944172923838_p
w(1)=7.416255383547740e-1_p
x(2)=-6.510243892247484_p
w(2)=1.625161996585911_p
x(3)=-4.535194024222826_p
w(3)=2.244054161795198_p
x(4)=-2.111920316461438_p
w(4)=2.231472390181074_p
x(5)=4.018954640317268e-1_p
w(5)=1.038152902524167_p
x(6)=3.331829897569342_p
w(6)=1.167144006636555e-1_p
x(7)=7.281192125443246_p
w(7)=3.132776778976132e-3_p
x(8)=12.57853699897118_p
w(8)=2.122167278651418e-5_p
x(9)=20.07607804308665_p
w(9)=1.781635356877070e-8_p
else if(N==10)then
x(1)=-7.745391413262365_p
w(1)=6.494796558712893e-1_p
x(2)=-6.690548061062068_p
w(2)=1.437822720124065_p
x(3)=-4.925721256206491_p
w(3)=2.035524014740347_p
x(4)=-2.692610414818553_p
w(4)=2.204552514493824_p
x(5)=-3.182303357840279e-1_p
w(5)=1.387364902674204_p
x(6)=2.268397201907328_p
w(6)=2.714489433857648e-1_p
x(7)=5.611654376094484_p
w(7)=1.390963910973527e-2_p
x(8)=9.964925525249795_p
w(8)=2.319566017436088e-4_p
x(9)=15.63556425340802_p
w(9)=1.058781431749568e-6_p
x(10)=23.52806890323502_p
w(10)=5.904903281031823e-10_p
else if(N==11)then
x(1)=-7.774212626358096_p
w(1)=5.764482022045164e-1_p
x(2)=-6.834551371714124_p
w(2)=1.285979188400628_p
x(3)=-5.244389052811934_p
w(3)=1.853254967722821_p
x(4)=-3.186062338206511_p
w(4)=2.117720807901230_p
x(5)=-9.329594721988036e-1_p
w(5)=1.630762009929484_p
x(6)=1.432283659680858_p
w(6)=4.923931354593727e-1_p
x(7)=4.340202524114698_p
w(7)=4.245394058239790e-2_p
x(8)=8.068503894602269_p
w(8)=1.308025431479046e-3_p
x(9)=12.76345507165985_p
w(9)=1.508017897111975e-5_p
x(10)=18.76892156894252_p
w(10)=4.854336597749911e-8_p
x(11)=27.02422627585608_p
w(11)=1.862987835303757e-11_p
else if(N==12)then
x(1)=-7.797512995123328_p
w(1)=5.173029254492326e-1_p
x(2)=-6.951861296093401_p
w(2)=1.160911998045820_p
x(3)=-5.508190976723723_p
w(3)=1.695332741234358_p
x(4)=-3.607273242055292_p
w(4)=2.007537295100961_p
x(5)=-1.470321544671981_p
w(5)=1.767501123622087_p
x(6)=7.465797386209292e-1_p
w(6)=7.465820347584596e-1_p
x(7)=3.333102220030201_p
w(7)=1.001265309087667e-1_p
x(8)=6.603438295084541_p
w(8)=4.934094235261560e-3_p
x(9)=10.65491227669144_p
w(9)=1.057743245019653e-4_p
x(10)=15.65284928132677_p
w(10)=8.866147445220168e-7_p
x(11)=21.96471328238662_p
w(11)=2.078138185062090e-9_p
x(12)=30.55681911035632_p
w(12)=5.644454296415192e-13_p
else if(N==13)then
x(1)=-7.816700139028605_p
w(1)=4.685313704717695e-1_p
x(2)=-7.049043088332863_p
w(2)=1.056420173420873_p
x(3)=-5.729453756095666_p
w(3)=1.558538780648529_p
x(4)=-3.968891356709220_p
w(4)=1.892142325863793_p
x(5)=-1.945080296790062_p
w(5)=1.821690446735003_p
x(6)=1.635346426039999e-1_p
w(6)=9.933795103242946e-1_p
x(7)=2.512345256751103_p
w(7)=1.949696369705463e-1_p
x(8)=5.427569065324672_p
w(8)=1.417414655607245e-2_p
x(9)=9.009110683925208_p
w(9)=4.813303156408335e-4_p
x(10)=13.34310810581653_p
w(10)=7.636952085578775e-6_p
x(11)=18.61706684375507_p
w(11)=4.803024502352647e-8_p
x(12)=25.21279925153272_p
w(12)=8.402772899337569e-11_p
x(13)=34.12006066496256_p
w(13)=1.653053725450887e-14_p
else if(N==14)then
x(1)=-7.832747918085063_p
w(1)=4.276944470467446e-1_p
x(2)=-7.130715807593774_p
w(2)=9.680126440683062e-1_p
x(3)=-5.917234318166122_p
w(3)=1.439639905363374_p
x(4)=-4.281367662099484_p
w(4)=1.779938487567924_p
x(5)=-2.366548939315894_p
w(5)=1.820926111920528_p
x(6)=-3.463658992791592e-1_p
w(6)=1.202045088072821_p
x(7)=1.827345433376777_p
w(7)=3.270109105670478e-1_p
x(8)=4.458850692520672_p
w(8)=3.339234512858705e-2_p
x(9)=7.675457744180641_p
w(9)=1.633525401022309e-3_p
x(10)=11.52545786332539_p
w(10)=4.143580728279047e-5_p
x(11)=16.11523813957688_p
w(11)=5.029965710274545e-7_p
x(12)=21.64445569369362_p
w(12)=2.429449201034003e-9_p
x(13)=28.5054836408139_p
w(13)=3.236834171218763e-12_p
x(14)=37.709494843451_p
w(14)=4.703076810152302e-16_p
else if(N==15)then
x(1)=-7.846349843383503_p
w(1)=3.930500850569563e-1_p
x(2)=-7.200212780721510_p
w(2)=8.923766496784828e-1_p
x(3)=-6.078285891998825_p
w(3)=1.335779191392118_p
x(4)=-4.553199522556747_p
w(4)=1.674495361909566_p
x(5)=-2.741807921693480_p
w(5)=1.787052520749459_p
x(6)=-8.010431824809821e-1_p
w(6)=1.358405317396674_p
x(7)=1.243038221721552_p
w(7)=4.869820243718193e-1_p
x(8)=3.645184313953717_p
w(8)=6.754335450586325e-2_p
x(9)=6.566626499754731_p
w(9)=4.483561614944169e-3_p
x(10)=10.04175900081047_p
w(10)=1.640811031174348e-4_p
x(11)=14.13278336917193_p
w(11)=3.227809179528759e-6_p
x(12)=18.95855928690206_p
w(12)=3.066870702528196e-8_p
x(13)=24.72613922432276_p
w(13)=1.158891144257284e-10_p
x(14)=31.83675407517413_p
w(14)=1.195842007188665e-13_p
x(15)=41.32160989979974_p
w(15)=1.305020715857999e-17_p
else if(N==16)then
x(1)=-7.858012165280253_p
w(1)=3.633235536417537e-1_p
x(2)=-7.259993501749259_p
w(2)=8.270257697278727e-1_p
x(3)=-6.217719682458290_p
w(3)=1.244549764056912_p
x(4)=-4.791244134048377_p
w(4)=1.577040109658284_p
x(5)=-3.076824081165363_p
w(5)=1.734860551193228_p
x(6)=-1.211393922145977_p
w(6)=1.462308985101094_p
x(7)=7.343655161714918e-1_p
w(7)=6.593171000844729e-1_p
x(8)=2.951068376773286_p
w(8)=1.209016799370815e-1_p
x(9)=5.627156030311122_p
w(9)=1.047586577365416e-2_p
x(10)=8.799804955992537_p
w(10)=5.169854010609160e-4_p
x(11)=12.50474986944939_p
w(11)=1.480882496228599e-5_p
x(12)=16.8174307994364_p
w(12)=2.312171805223908e-7_p
x(13)=21.86339585976377_p
w(13)=1.750080769336847e-9_p
x(14)=27.85513621783102_p
w(14)=5.254007512235276e-12_p
x(15)=35.20180565932991_p
w(15)=4.259828202197813e-15_p
x(16)=44.95358443207187_p
w(16)=3.542935060048560e-19_p
else if(N==17)then
x(1)=-7.868112452578593_p
w(1)=3.375622570701008e-1_p
x(2)=-7.311908514487195_p
w(2)=7.700635147732918e-1_p
x(3)=-6.339460089003557_p
w(3)=1.163962125243489_p
x(4)=-5.001028018680998_p
w(4)=1.487687324400281_p
x(5)=-3.376790193486193_p
w(5)=1.673612514854653_p
x(6)=-1.584334124677638_p
w(6)=1.521535717216005_p
x(7)=2.833804482699752e-1_p
w(7)=8.273153496367401e-1_p
x(8)=2.350928446112280_p
w(8)=1.956102512622671e-1_p
x(9)=4.819521234353796_p
w(9)=2.156218367665623e-2_p
x(10)=7.740736397264266_p
w(10)=1.369734324888927e-3_p
x(11)=11.13454134759788_p
w(11)=5.319602233718197e-5_p
x(12)=15.04988015276141_p
w(12)=1.222388011951527e-6_p
x(13)=19.56914019142362_p
w(13)=1.540968090782899e-8_p
x(14)=24.82212062964095_p
w(14)=9.426426041804118e-11_p
x(15)=31.02582536286678_p
w(15)=2.277963183893434e-13_p
x(16)=38.59672705975511_p
w(16)=1.469422334960487e-16_p
x(17)=48.60311432537922_p
w(17)=9.434867322116007e-21_p
else
call GD(-8)
end if
end subroutine GF_m8

! [-7kT;infkT]
subroutine GF_m7(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.160732875462740_p
w(1)=4.287642623828432_p
x(2)=-2.708834502215777e-1_p
w(2)=2.713268842625342_p
else if(N==3)then
x(1)=-5.879247476516393_p
w(1)=2.740849985870782_p
x(2)=-2.166717815483878_p
w(2)=3.668240033493143_p
x(3)=2.027331940039729_p
w(3)=5.918214470898486e-1_p
else if(N==4)then
x(1)=-6.222514589498077_p
w(1)=1.936778221836928_p
x(2)=-3.376756511950506_p
w(2)=3.341544008164287_p
x(3)=1.189399752807954e-1_p
w(3)=1.663299174775770_p
x(4)=4.638561481204779_p
w(4)=5.929006167678859e-2_p
else if(N==5)then
x(1)=-6.415821409347330_p
w(1)=1.468625606657609_p
x(2)=-4.168254380749758_p
w(2)=2.822662239413804_p
x(3)=-1.090172436827608_p
w(3)=2.334693877325914_p
x(4)=2.271877840062589_p
w(4)=3.713390311157983e-1_p
x(5)=7.585676552772365_p
w(5)=3.590711940648021e-3_p
else if(N==6)then
x(1)=-6.537253895977168_p
w(1)=1.169478573668147_p
x(2)=-4.705671129420211_p
w(2)=2.377768589844318_p
x(3)=-2.000049993285920_p
w(3)=2.518938166683133_p
x(4)=9.077658292611508e-1_p
w(4)=8.925448127968291e-1_p
x(5)=4.707624586683007_p
w(5)=4.201122627130725e-2_p
x(6)=10.72912879874509_p
w(6)=1.700971900398587e-4_p
else if(N==7)then
x(1)=-6.619572996078730_p
w(1)=9.646354285120770e-1_p
x(2)=-5.086851344158783_p
w(2)=2.028134425854754_p
x(3)=-2.709014797704946_p
w(3)=2.442581326999243_p
x(4)=-5.547663555474947e-2_p
w(4)=1.392805617237254_p
x(5)=3.010051377975343_p
w(5)=1.695358406801828e-1_p
x(6)=7.404765234775069_p
w(6)=3.211852610148665e-3_p
x(7)=13.99587907197572_p
w(7)=6.974560113888754e-6_p
else if(N==8)then
x(1)=-6.678568682791337_p
w(1)=8.168726510573617e-1_p
x(2)=-5.368028435683444_p
w(2)=1.755350957615773_p
x(3)=-3.267747922781133_p
w(3)=2.273263583296715_p
x(4)=-8.136676356571579e-1_p
w(4)=1.731091373615664_p
x(5)=1.847202253147159_p
w(5)=4.050173600240265e-1_p
x(6)=5.374633061798622_p
w(6)=1.911611640681823e-2_p
x(7)=10.27226814344805_p
w(7)=1.991654944809848e-4_p
x(8)=17.34930852585619_p
w(8)=2.589429355544204e-7_p
else if(N==9)then
x(1)=-6.722671542479262_p
w(1)=7.059153455293034e-1_p
x(2)=-5.582398822866604_p
w(2)=1.540020269268474_p
x(3)=-3.713444890651290_p
w(3)=2.085942262226576_p
x(4)=-1.441423394577962_p
w(4)=1.896398008448712_p
x(5)=9.777865083098330e-1_p
w(5)=7.061548186406501e-1_p
x(6)=3.952599958695761_p
w(6)=6.484360111074960e-2_p
x(7)=7.942850899905654_p
w(7)=1.626383606402848e-3_p
x(8)=13.2591634432553_p
w(8)=1.076869408364379e-5_p
x(9)=20.76790823873101_p
w(9)=8.928822129903011e-9_p
else if(N==10)then
x(1)=-6.756747953974071_p
w(1)=6.199058313235667e-1_p
x(2)=-5.750382170776092_p
w(2)=1.367290406075574_p
x(3)=-4.073960723103365_p
w(3)=1.908070445582586_p
x(4)=-1.971881004220637_p
w(4)=1.937290063798746_p
x(5)=2.840174913968520e-1_p
w(5)=1.005082061000970_p
x(6)=2.886423853547879_p
w(6)=1.559327435123258e-1_p
x(7)=6.277445657921155_p
w(7)=7.222534903170660e-3_p
x(8)=10.65382077273259_p
w(8)=1.168541188161124e-4_p
x(9)=16.33692249956611_p
w(9)=5.258473779300965e-7_p
x(10)=24.23766413571828_p
w(10)=2.906405772597700e-10_p
else if(N==11)then
x(1)=-6.783784193523358_p
w(1)=5.515005422614565e-1_p
x(2)=-5.885063611909764_p
w(2)=1.226477027639625_p
x(3)=-4.369744240344058_p
w(3)=1.747884807841899_p
x(4)=-2.424175070992249_p
w(4)=1.905354425100778_p
x(5)=-2.962734049360579e-1_p
w(5)=1.250706009823171_p
x(6)=2.050042061448758_p
w(6)=2.961264038842545e-1_p
x(7)=5.007072543821070_p
w(7)=2.219900556561920e-2_p
x(8)=8.763646652455986_p
w(8)=6.557872768284072e-4_p
x(9)=13.47291991504403_p
w(9)=7.433357586578905e-6_p
x(10)=19.48723272054261_p
w(10)=2.369352555477278e-8_p
x(11)=27.74883541046728_p
w(11)=9.031416791542008e-12_p
else if(N==12)then
x(1)=-6.805705228215542_p
w(1)=4.959338727401570e-1_p
x(2)=-5.995144337265913_p
w(2)=1.109951575723864_p
x(3)=-4.615715099476364_p
w(3)=1.606442270915588_p
x(4)=-2.812175828440878_p
w(4)=1.836458671128030_p
x(5)=-7.966214469957079e-1_p
w(5)=1.422853441040588_p
x(6)=1.369782397414446_p
w(6)=4.735794495494906e-1_p
x(7)=3.998709922260554_p
w(7)=5.317129806701618e-2_p
x(8)=7.302879893152477_p
w(8)=2.468630862487171e-3_p
x(9)=11.37107716579373_p
w(9)=5.182582280037053e-5_p
x(10)=16.37880480210119_p
w(10)=4.296037895643607e-7_p
x(11)=22.69726975081418_p
w(11)=9.996930921017189e-10_p
x(12)=31.29433614244931_p
w(12)=2.700901203019447e-13_p
else if(N==13)then
x(1)=-6.823803030182701_p
w(1)=4.499909666032574e-1_p
x(2)=-6.086601650584498_p
w(2)=1.012216542755284_p
x(3)=-4.822814838521177_p
w(3)=1.482317831164958_p
x(4)=-3.146967002674428_p
w(4)=1.751664245307058_p
x(5)=-1.235748468860900_p
w(5)=1.525059785275471_p
x(6)=7.990288793192459e-1_p
w(6)=6.661853843033101e-1_p
x(7)=3.175633001302077_p
w(7)=1.061376054628756e-1_p
x(8)=6.129438229366868_p
w(8)=7.100632950770860e-3_p
x(9)=9.730673136364844_p
w(9)=2.347719932065643e-4_p
x(10)=14.07564064232909_p
w(10)=3.677650847957657e-6_p
x(11)=19.35673222952262_p
w(11)=2.294680388513678e-8_p
x(12)=25.95756871708445_p
w(12)=3.992363750137890e-11_p
x(13)=34.86883031440527_p
w(13)=7.820753777804737e-15_p
else if(N==14)then
x(1)=-6.838974453543950_p
w(1)=4.114312622545860e-1_p
x(2)=-6.163659899045252_p
w(2)=9.292512868511958e-1_p
x(3)=-4.999154754020225_p
w(3)=1.373401637089483_p
x(4)=-3.437599718023760_p
w(4)=1.662357586594054_p
x(5)=-1.624981300829633_p
w(5)=1.571828475490998_p
x(6)=3.073860589611547e-1_p
w(6)=8.508812848661587e-1_p
x(7)=2.488923108730682_p
w(7)=1.841260244404869e-1_p
x(8)=5.161421903857861_p
w(8)=1.681941703618571e-2_p
x(9)=8.401197078704243_p
w(9)=7.944002786416838e-4_p
x(10)=12.26359604264705_p
w(10)=1.985153139057175e-5_p
x(11)=16.86116423428894_p
w(11)=2.388721603466720e-7_p
x(12)=22.39580473009955_p
w(12)=1.146911214280249e-9_p
x(13)=29.26088836711309_p
w(13)=1.521433021131212e-12_p
x(14)=38.46818784265015_p
w(14)=2.202956713651811e-16_p
else if(N==15)then
x(1)=-6.851860099941162_p
w(1)=3.786492951240081e-1_p
x(2)=-6.229379499885659_p
w(2)=8.580674520734982e-1_p
x(3)=-5.150827338589209_p
w(3)=1.277568472186279_p
x(4)=-3.691460830224796_p
w(4)=1.574368557973873_p
x(5)=-1.972022113097914_p
w(5)=1.579313112629698_p
x(6)=-1.250628861134395e-1_p
w(6)=1.010656330307271_p
x(7)=1.905138206016190_p
w(7)=2.856494414987216e-1_p
x(8)=4.347026153644869_p
w(8)=3.438128129795415e-2_p
x(9)=7.295376051646293_p
w(9)=2.177700808989979e-3_p
x(10)=10.78462139822742_p
w(10)=7.828317469947773e-5_p
x(11)=14.88419826621857_p
w(11)=1.524928711490845e-6_p
x(12)=19.71579496733577_p
w(12)=1.439586576050429e-8_p
x(13)=25.48762863223686_p
w(13)=5.414831381678957e-11_p
x(14)=32.60153703674864_p
w(14)=5.567917005000606e-14_p
x(15)=42.08913953391856_p
w(15)=6.058741071979626e-18_p
else if(N==16)then
x(1)=-6.862928873602605_p
w(1)=3.504668715265291e-1_p
x(2)=-6.286026363124892_p
w(2)=7.964083007238340e-1_p
x(3)=-5.282471782021204_p
w(3)=1.192905569640211_p
x(4)=-3.914561020621210_p
w(4)=1.490497775677145_p
x(5)=-2.282715845390953_p
w(5)=1.561031388206735_p
x(6)=-5.113792235690318e-1_p
w(6)=1.136934289714598_p
x(7)=1.400352479744204_p
w(7)=4.047635015002862e-1_p
x(8)=3.651240299653571_p
w(8)=6.255851699470522e-2_p
x(9)=6.357793768022679_p
w(9)=5.092314739249698e-3_p
x(10)=9.546578765752253_p
w(10)=2.458639364032831e-4_p
x(11)=13.26096083102272_p
w(11)=6.964992911177251e-6_p
x(12)=17.57991838399455_p
w(12)=1.079854089359304e-7_p
x(13)=22.63039296885453_p
w(13)=8.133237843911377e-10_p
x(14)=28.62555202806078_p
w(14)=2.432779208575223e-12_p
x(15)=35.97494435178854_p
w(15)=1.966763659638753e-15_p
x(16)=45.72904873613477_p
w(16)=1.631795987367392e-19_p
else if(N==17)then
x(1)=-6.872531358576040_p
w(1)=3.260012174431878e-1_p
x(2)=-6.335310607631081_p
w(2)=7.425437261614006e-1_p
x(3)=-5.397668357646336_p
w(3)=1.117767799741111_p
x(4)=-4.111787883534224_p
w(4)=1.411932507090397_p
x(5)=-2.561828134464525_p
w(5)=1.526897021199453_p
x(6)=-8.602324609203910e-1_p
w(6)=1.228410871493749_p
x(7)=9.570247246431930e-1_p
w(7)=5.326418660389357e-1_p
x(8)=3.049163875831097_p
w(8)=1.035250508639119e-1_p
x(9)=5.550987417668241_p
w(9)=1.051594287424849e-2_p
x(10)=8.490656358964847_p
w(10)=6.499632985341456e-4_p
x(11)=11.89492305570144_p
w(11)=2.492473316387887e-5_p
x(12)=15.81704986059548_p
w(12)=5.683453039756231e-7_p
x(13)=20.34111189512522_p
w(13)=7.126845650141571e-9_p
x(14)=25.59768182960326_p
w(14)=4.342753845022763e-11_p
x(15)=31.80418866565116_p
w(15)=1.046328507768977e-13_p
x(16)=39.37737544580634_p
w(16)=6.733216258430752e-17_p
x(17)=49.38575488983272_p
w(17)=4.314287129111325e-21_p
else
call GD(-7)
end if
end subroutine GF_m7

! [-6kT;infkT]
subroutine GF_m6(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-4.348502560241204_p
w(1)=3.813108199858906_p
x(2)=9.542185547940388e-2_p
w(2)=2.189367485278825_p
else if(N==3)then
x(1)=-4.976655278461227_p
w(1)=2.488346388775657_p
x(2)=-1.607600757629958_p
w(2)=3.105729842484512_p
x(3)=2.458422916064378_p
w(3)=4.083994538775620e-1_p
else if(N==4)then
x(1)=-5.281875075783540_p
w(1)=1.781349146222501_p
x(2)=-2.670786162954550_p
w(2)=2.950357904971129_p
x(3)=5.934080418735456e-1_p
w(3)=1.235342181183617_p
x(4)=5.170697719252064_p
w(4)=3.542645276048271e-2_p
else if(N==5)then
x(1)=-5.455882564574141_p
w(1)=1.363155751768411_p
x(2)=-3.373390349960227_p
w(2)=2.554815261683073_p
x(3)=-5.306083503952688e-1_p
w(3)=1.850995539698647_p
x(4)=2.803652478695313_p
w(4)=2.315232055827914e-1_p
x(5)=8.183922342183012_p
w(5)=1.985926404808333e-3_p
else if(N==6)then
x(1)=-5.566221424189560_p
w(1)=1.092942410233749_p
x(2)=-3.856300960121768_p
w(2)=2.184652998319181_p
x(3)=-1.352274648795763_p
w(3)=2.107764020807349_p
x(4)=1.450608746202754_p
w(4)=5.937144038311041e-1_p
x(5)=5.312657582073431_p
w(5)=2.331202410221634e-2_p
x(6)=11.3705817548425_p
w(6)=8.982784413158834e-5_p
else if(N==7)then
x(1)=-5.641577534522524_p
w(1)=9.063421853428689e-1_p
x(2)=-4.202223472943160_p
w(2)=1.882081648772496_p
x(3)=-1.989065395154232_p
w(3)=2.124818713667728_p
x(4)=5.188915778594440e-1_p
w(4)=9.912365181674928e-1_p
x(5)=3.615183216508282_p
w(5)=9.631040820457371e-2_p
x(6)=8.057047198230974_p
w(6)=1.682645640187241e-3_p
x(7)=14.66866913555335_p
w(7)=3.565342383689880e-6_p
else if(N==8)then
x(1)=-5.695910609412882_p
w(1)=7.708326499523819e-1_p
x(2)=-4.459396062703736_p
w(2)=1.640670224406497_p
x(3)=-2.493257991510210_p
w(3)=2.029999869495779_p
x(4)=-1.940064073850039e-1_p
w(4)=1.310793413189056_p
x(5)=2.452270278595861_p
w(5)=2.400682739658139e-1_p
x(6)=6.032933417584495_p
w(6)=1.001031789829324e-2_p
x(7)=10.95616931174244_p
w(7)=1.008071079469607e-4_p
x(8)=18.04632928089712_p
w(8)=1.291219624887180e-7_p
else if(N==9)then
x(1)=-5.736732988266551_p
w(1)=6.685155508133097e-1_p
x(2)=-4.656705848807945_p
w(2)=1.447302194855121_p
x(3)=-2.898280608873420_p
w(3)=1.896005260635911_p
x(4)=-7.729818714325473e-1_p
w(4)=1.513630457551130_p
x(5)=1.589120205927763_p
w(5)=4.419186843366105e-1_p
x(6)=4.612686480194077_p
w(6)=3.428044315416959e-2_p
x(7)=8.635075343013344_p
w(7)=8.177715454883339e-4_p
x(8)=13.9665490066177_p
w(8)=5.317881169846807e-6_p
x(9)=21.48443340874128_p
w(9)=4.364820477976463e-9_p
else if(N==10)then
x(1)=-5.768409760045492_p
w(1)=5.888371955573343e-1_p
x(2)=-4.812127097743256_p
w(2)=1.290569640066507_p
x(3)=-3.228130472857214_p
w(3)=1.755930606348675_p
x(4)=-1.258041637671119_p
w(4)=1.612498276307700_p
x(5)=9.106139586401357e-1_p
w(5)=6.667708271265470e-1_p
x(6)=3.545750387994133_p
w(6)=8.418986091150533e-2_p
x(7)=6.975256570670164_p
w(7)=3.621763118635388e-3_p
x(8)=11.36972811653598_p
w(8)=5.726081401000751e-5_p
x(9)=17.0628762024961_p
w(9)=2.547470458050963e-7_p
x(10)=24.97034215926358_p
w(10)=1.397711939505373e-10_p
else if(N==11)then
x(1)=-5.793634745134553_p
w(1)=5.252174523369195e-1_p
x(2)=-4.937284085238042_p
w(2)=1.161788962518515_p
x(3)=-3.500373400448377_p
w(3)=1.623074176448075_p
x(4)=-1.671078257357869_p
w(4)=1.637496303582879_p
x(5)=3.533465960428439e-1_p
w(5)=8.782897193082345e-1_p
x(6)=2.708517584653859_p
w(6)=1.651315867758936e-1_p
x(7)=5.707944833305461_p
w(7)=1.115438393364926e-2_p
x(8)=9.486308958960398_p
w(8)=3.195152705642022e-4_p
x(9)=14.206962796206_p
w(9)=3.573658109754221e-6_p
x(10)=20.22843625637127_p
w(10)=1.130060708789487e-8_p
x(11)=28.49518182571371_p
w(11)=4.283689136796933e-12_p
else if(N==12)then
x(1)=-5.814152909845197_p
w(1)=4.733618106353753e-1_p
x(2)=-5.039964642992890_p
w(2)=1.054556293594009_p
x(3)=-3.727928021564856_p
w(3)=1.501932551277255_p
x(4)=-2.026242622391789_p
w(4)=1.616611737484296_p
x(5)=-1.193576289138952e-1_p
w(5)=1.052650776816281_p
x(6)=2.029758029315665_p
w(6)=2.752118432382543e-1_p
x(7)=4.700514515255163_p
w(7)=2.692728190464693e-2_p
x(8)=8.030664747474352_p
w(8)=1.198426830745170e-3_p
x(9)=12.1119318565597_p
w(9)=2.475946158020573e-5_p
x(10)=17.12750916502244_p
w(10)=2.034245550255282e-7_p
x(11)=23.45132908845637_p
w(11)=4.706061245778672e-10_p
x(12)=32.05244676285847_p
w(12)=1.265954048937915e-13_p
else if(N==13)then
x(1)=-5.831140454504716_p
w(1)=4.303590108746587e-1_p
x(2)=-5.125552132058016_p
w(2)=9.641578884114441e-1_p
x(3)=-3.920361981609359_p
w(3)=1.393292609442032_p
x(4)=-2.333884163423006_p
w(4)=1.569964175207095_p
x(5)=-5.293975572034304e-1_p
w(5)=1.180894173753558_p
x(6)=1.464482315403647_p
w(6)=4.057128144477561e-1_p
x(7)=3.876903075076063_p
w(7)=5.453895592484628e-2_p
x(8)=6.860824429775076_p
w(8)=3.442716992941684e-3_p
x(9)=10.47719185593653_p
w(9)=1.115986737335389e-4_p
x(10)=14.83085736385807_p
w(10)=1.730661164713803e-6_p
x(11)=20.11769521288808_p
w(11)=1.072991113679017e-8_p
x(12)=26.72267801222931_p
w(12)=1.858473900164034e-11_p
x(13)=35.6372067678117_p
w(13)=3.628007783505876e-15_p
else if(N==14)then
x(1)=-5.845416979653525_p
w(1)=3.941713970805997e-1_p
x(2)=-5.197871383156821_p
w(2)=8.870938895369851e-1_p
x(3)=-4.084833754020618_p
w(3)=1.296470581123930_p
x(4)=-2.602078211736133_p
w(4)=1.510391760352184_p
x(5)=-8.903975315615557e-1_p
w(5)=1.264842035645411_p
x(6)=9.827587717527917e-1_p
w(6)=5.442677769312317e-1_p
x(7)=3.189101544328227_p
w(7)=9.668544183113613e-2_p
x(8)=5.895003927202153_p
w(8)=8.167209470803903e-3_p
x(9)=9.152339148647144_p
w(9)=3.761888522031041e-4_p
x(10)=13.02444292249742_p
w(10)=9.292743403478369e-6_p
x(11)=17.62823710650921_p
w(11)=1.110385516274894e-7_p
x(12)=23.16725891995263_p
w(12)=5.305885861683995e-10_p
x(13)=30.03564029154991_p
w(13)=7.013676352100825e-13_p
x(14)=39.2456255685735_p
w(14)=1.012668469185796e-16_p
else if(N==15)then
x(1)=-5.857569900797222_p
w(1)=3.633333764645710e-1_p
x(2)=-5.259706108946122_p
w(2)=8.207332055116433e-1_p
x(3)=-4.226763735655675_p
w(3)=1.210280231742132_p
x(4)=-2.837301141817394_p
w(4)=1.445576525750115_p
x(5)=-1.211352068568793_p
w(5)=1.311746905161294_p
x(6)=5.641376136059315e-1_p
w(6)=6.786462372002746e-1_p
x(7)=2.604689210653065_p
w(7)=1.543172109696473e-1_p
x(8)=5.081561027129704_p
w(8)=1.677613234458038e-2_p
x(9)=8.050179192747239_p
w(9)=1.028664912652554e-3_p
x(10)=11.55031406787403_p
w(10)=3.648323665357100e-5_p
x(11)=15.65666919385195_p
w(11)=7.051963286970581e-7_p
x(12)=20.49294155073038_p
w(12)=6.622993866432613e-9_p
x(13)=26.26821852896522_p
w(13)=2.481900152890861e-11_p
x(14)=33.384806797626_p
w(14)=2.544798577276066e-14_p
x(15)=42.87465277547525_p
w(15)=2.762607610054699e-18_p
else if(N==16)then
x(1)=-5.868030510088636_p
w(1)=3.367657757817372e-1_p
x(2)=-5.313125640492607_p
w(2)=7.630709861212595e-1_p
x(3)=-4.350308121101810_p
w(3)=1.133443434367536_p
x(4)=-3.044805196146363_p
w(4)=1.379924463931903_p
x(5)=-1.498633545021019_p
w(5)=1.330287907537945_p
x(6)=1.944579699083359e-1_p
w(6)=7.994260894864145e-1_p
x(7)=2.100673306022401_p
w(7)=2.262434447565171e-1_p
x(8)=4.385727701916625_p
w(8)=3.079338997502847e-2_p
x(9)=7.115355170608958_p
w(9)=2.402770489595289e-3_p
x(10)=10.31641108213076_p
w(10)=1.141664787430222e-4_p
x(11)=14.0381990789152_p
w(11)=3.206404484045102e-6_p
x(12)=18.36216712284909_p
w(12)=4.943460228324245e-8_p
x(13)=23.41627528756345_p
w(13)=3.708582949890098e-10_p
x(14)=29.41420557687702_p
w(14)=1.106004070237965e-12_p
x(15)=36.76581458408585_p
w(15)=8.920466366975612e-16_p
x(16)=46.52181855238116_p
w(16)=7.386484823470691e-20_p
else if(N==17)then
x(1)=-5.877122166677395_p
w(1)=3.136575612894595e-1_p
x(2)=-5.359697296929018_p
w(2)=7.125589762974057e-1_p
x(3)=-4.458693674349978_p
w(3)=1.064755433648541_p
x(4)=-3.228873811990802_p
w(4)=1.315861557872872_p
x(5)=-1.757068113067542_p
w(5)=1.328409569710653_p
x(6)=-1.361882160387193e-1_p
w(6)=9.010153917398427e-1_p
x(7)=1.660177807039901_p
w(7)=3.093091992137851e-1_p
x(8)=3.782938210997594_p
w(8)=5.163090369533667e-2_p
x(9)=6.310459096003555_p
w(9)=4.964454636604126e-3_p
x(10)=9.263981425650011_p
w(10)=3.009453574678251e-4_p
x(11)=12.67636721897787_p
w(11)=1.142938491996260e-5_p
x(12)=16.60387577494992_p
w(12)=2.590366564741577e-7_p
x(13)=21.13178840718116_p
w(13)=3.234491360705495e-9_p
x(14)=26.39125692593752_p
w(14)=1.964781486346964e-11_p
x(15)=32.60003756802946_p
w(15)=4.722429965355586e-14_p
x(16)=40.17508538724624_p
w(16)=3.032976001349117e-17_p
x(17)=50.18509207747311_p
w(17)=1.940074184487975e-21_p
else
call GD(-6)
end if
end subroutine GF_m6

! [-5kT;infkT]
subroutine GF_m5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-3.535012775782224_p
w(1)=3.320511014672565_p
x(2)=4.997493694082198e-1_p
w(2)=1.686204333816553_p
else if(N==3)then
x(1)=-4.074467843133754_p
w(1)=2.223447088051925_p
x(2)=-1.037808919795278_p
w(2)=2.518893662791505_p
x(3)=2.943265627228397_p
w(3)=2.643745976456878e-1_p
else if(N==4)then
x(1)=-4.341958070523551_p
w(1)=1.617041927364643_p
x(2)=-1.966113417180336_p
w(2)=2.512463468101026_p
x(3)=1.108298096284762_p
w(3)=8.571026168052063e-1_p
x(4)=5.750233419733130_p
w(4)=2.010733621824280e-2_p
else if(N==5)then
x(1)=-4.496690631525474_p
w(1)=1.250887632864157_p
x(2)=-2.582573106598828_p
w(2)=2.247120285415605_p
x(3)=4.812899615534253e-2_p
w(3)=1.372564060357862_p
x(4)=3.386481683092881_p
w(4)=1.350890277822859e-1_p
x(5)=8.821768038702933_p
w(5)=1.054342069208626e-3_p
else if(N==6)then
x(1)=-4.595884530478747_p
w(1)=1.010955618478988_p
x(2)=-3.011208318839239_p
w(2)=1.961385097702911_p
x(3)=-7.008054885271557e-1_p
w(3)=1.657147011903349_p
x(4)=2.039877200225108_p
w(4)=3.648393612525572e-1_p
x(5)=5.960207686686298_p
w(5)=1.234246337332063e-2_p
x(6)=12.04664647971878_p
w(6)=4.579577799244883e-5_p
else if(N==7)then
x(1)=-4.664210116772231_p
w(1)=8.435356232250003e-1_p
x(2)=-3.321526296749007_p
w(2)=1.713143129484348_p
x(3)=-1.273053551246420_p
w(3)=1.750202946936065_p
x(4)=1.127234378144698_p
w(4)=6.473602348769782e-1_p
x(5)=4.266138410488425_p
w(5)=5.162208740935208e-2_p
x(6)=8.744853651491418_p
w(6)=8.495604903079898e-4_p
x(7)=15.37259025543052_p
w(7)=1.766067066075928e-6_p
else if(N==8)then
x(1)=-4.713814736647345_p
w(1)=7.209652862298241e-1_p
x(2)=-3.554257333094895_p
w(2)=1.508133065180222_p
x(3)=-1.725563100862022_p
w(3)=1.730794270382585_p
x(4)=4.450990322727980e-1_p
w(4)=9.094032070863199e-1_p
x(5)=3.104159135070200_p
w(5)=1.323361392011064e-1_p
x(6)=6.728448557998139_p
w(6)=5.033897540708062e-3_p
x(7)=11.67133284613836_p
w(7)=4.942030602301849e-5_p
x(8)=18.77185412051121_p
w(8)=6.256232990923725e-8_p
else if(N==9)then
x(1)=-4.751297544569715_p
w(1)=6.278097549906080e-1_p
x(2)=-3.734099724984756_p
w(2)=1.340237425087397_p
x(3)=-2.090576711955368_p
w(3)=1.657412783954600_p
x(4)=-9.715698879820041e-2_p
w(4)=1.109858813729422_p
x(5)=2.243895418909657_p
w(5)=2.537063524749994e-1_p
x(6)=5.312331505453814_p
w(6)=1.728977696774972e-2_p
x(7)=9.359023779821149_p
w(7)=3.978874518350784e-4_p
x(8)=14.70226967093871_p
w(8)=2.551754780018669e-6_p
x(9)=22.22738646013163_p
w(9)=2.077726116245712e-9_p
else if(N==10)then
x(1)=-4.780523172001149_p
w(1)=5.548705927236507e-1_p
x(2)=-3.876606791897109_p
w(2)=1.202020557472167_p
x(3)=-2.389549253131537_p
w(3)=1.563158961613514_p
x(4)=-5.449457897190041e-1_p
w(4)=1.240271374364788_p
x(5)=1.573136922883120_p
w(5)=4.016751439497273e-1_p
x(6)=4.246911543292023_p
w(6)=4.293727246582172e-2_p
x(7)=7.705700691739606_p
w(7)=1.754066269673085e-3_p
x(8)=12.11395429224607_p
w(8)=2.725936628304467e-5_p
x(9)=17.81496359652102_p
w(9)=1.201979268124036e-7_p
x(10)=25.72775476899081_p
w(10)=6.556676160218234e-11_p
else if(N==11)then
x(1)=-4.803892442842028_p
w(1)=4.963633039236983e-1_p
x(2)=-3.991940704217801_p
w(2)=1.087135208588879_p
x(3)=-2.637736040760180_p
w(3)=1.464610102690596_p
x(4)=-9.234390578208435e-1_p
w(4)=1.310412788847701_p
x(5)=1.029157175280041_p
w(5)=5.567457425289710e-1_p
x(6)=3.409949766825174_p
w(6)=8.590016708649816e-2_p
x(7)=6.442826231214915_p
w(7)=5.395191967610373e-3_p
x(8)=10.23748765467458_p
w(8)=1.511641026707637e-4_p
x(9)=14.96693090468261_p
w(9)=1.673491508770218e-6_p
x(10)=20.99402902358407_p
w(10)=5.258999271024585e-9_p
x(11)=29.26484884964963_p
w(11)=1.984776738950862e-12_p
else if(N==12)then
x(1)=-4.822969412158161_p
w(1)=4.484856877513126e-1_p
x(2)=-4.086968567792361_p
w(2)=9.906121337028658e-1_p
x(3)=-2.846288422195755_p
w(3)=1.369409582600441_p
x(4)=-1.248146249394707_p
w(4)=1.335727445706762_p
x(5)=5.742770025535534e-1_p
w(5)=7.016403191947588e-1_p
x(6)=2.731727224649865_p
w(6)=1.472064409410078e-1_p
x(7)=5.438048674281468_p
w(7)=1.305772773856279e-2_p
x(8)=8.787414153781175_p
w(8)=5.643954112969694e-4_p
x(9)=12.87862370312144_p
w(9)=1.152121737093803e-5_p
x(10)=17.90031216464668_p
w(10)=9.400820069806018e-8_p
x(11)=24.22834734287337_p
w(11)=2.164809970627889e-10_p
x(12)=32.83267509014083_p
w(12)=5.803502836028110e-14_p
else if(N==13)then
x(1)=-4.838813581880773_p
w(1)=4.086446019662087e-1_p
x(2)=-4.166471929490602_p
w(2)=9.086550185044729e-1_p
x(3)=-3.023490478903042_p
w(3)=1.280712042842002_p
x(4)=-1.529609436366940_p
w(4)=1.330644462642721_p
x(5)=1.848659411447271e-1_p
w(5)=8.251520422333597e-1_p
x(6)=2.168553708474380_p
w(6)=2.246039430515867e-1_p
x(7)=4.615672633515015_p
w(7)=2.663408421679521e-2_p
x(8)=7.621899191638792_p
w(8)=1.616695437964978e-3_p
x(9)=11.2495929607278_p
w(9)=5.165773276780698e-5_p
x(10)=15.60996201571671_p
w(10)=7.949486286889605e-7_p
x(11)=20.90129317541786_p
w(11)=4.904145303503997e-9_p
x(12)=27.509544223108_p
w(12)=8.464280968846664e-12_p
x(13)=36.4266620157954_p
w(13)=1.647814901465260e-15_p
else if(N==14)then
x(1)=-4.852166471173950_p
w(1)=3.750155522916409e-1_p
x(2)=-4.233869219135433_p
w(2)=8.383722117176265e-1_p
x(3)=-3.175578839826579_p
w(3)=1.199500189675244_p
x(4)=-1.775551632198979_p
w(4)=1.306332233843269_p
x(5)=-1.544143302851829e-1_p
w(5)=9.224378319843725e-1_p
x(6)=1.691318188349490_p
w(6)=3.132627752733252e-1_p
x(7)=3.928166550877194_p
w(7)=4.778534348902386e-2_p
x(8)=6.659273523667566_p
w(8)=3.831517461695694e-3_p
x(9)=9.929554019092146_p
w(9)=1.733959100070816e-4_p
x(10)=13.80905148504845_p
w(10)=4.246139762329820e-6_p
x(11)=18.41767941593532_p
w(11)=5.046260446078077e-8_p
x(12)=23.96013655026737_p
w(12)=2.402287891810972e-10_p
x(13)=30.83111973479408_p
w(13)=3.166668204685077e-13_p
x(14)=40.04323349076413_p
w(14)=4.561929351547118e-17_p
else if(N==15)then
x(1)=-4.863561606296808_p
w(1)=3.462802548574155e-1_p
x(2)=-4.291661788948626_p
w(2)=7.775486987589767e-1_p
x(3)=-3.307308652590444_p
w(3)=1.125743946474784_p
x(4)=-1.991913987761078_p
w(4)=1.270652865383152_p
x(5)=-4.538829092533093e-1_p
w(5)=9.934472886237905e-1_p
x(6)=1.279833372181653_p
w(6)=4.070891228729844e-1_p
x(7)=3.343667990996705_p
w(7)=7.758429797869423e-2_p
x(8)=5.848011554664972_p
w(8)=7.879361869865766e-3_p
x(9)=8.831403534436742_p
w(9)=4.725944526064225e-4_p
x(10)=12.33972848522235_p
w(10)=1.659534596290056e-5_p
x(11)=16.45130481795013_p
w(11)=3.188769510212568e-7_p
x(12)=21.29122323476453_p
w(12)=2.982778393845225e-9_p
x(13)=27.06920508933438_p
w(13)=1.114504681017497e-11_p
x(14)=34.18790914523273_p
w(14)=1.140180562733431e-14_p
x(15)=43.67953313369314_p
w(15)=1.235458892183165e-18_p
else if(N==16)then
x(1)=-4.873392082831924_p
w(1)=3.214640722652746e-1_p
x(2)=-4.341717844737500_p
w(2)=7.244721625656340e-1_p
x(3)=-3.422350580784834_p
w(3)=1.058971783924326_p
x(4)=-2.183403467456416_p
w(4)=1.228849174724195_p
x(5)=-7.207674158154861e-1_p
w(5)=1.040944419597307_p
x(6)=9.197309787606596e-1_p
w(6)=5.000657209385858e-1_p
x(7)=2.839758736276077_p
w(7)=1.162779630682220e-1_p
x(8)=5.153483593036241_p
w(8)=1.451545246566081e-2_p
x(9)=7.899854594147108_p
w(9)=1.101400584725639e-3_p
x(10)=11.11001440656802_p
w(10)=5.173257423934329e-5_p
x(11)=14.83745710248147_p
w(11)=1.443456451471200e-6_p
x(12)=19.16530966682718_p
w(12)=2.215828518926732e-8_p
x(13)=24.2222595570374_p
w(13)=1.657176145076859e-10_p
x(14)=30.22236972777358_p
w(14)=4.930637991976751e-13_p
x(15)=37.57572975298933_p
w(15)=3.969444251950597e-16_p
x(16)=47.33323921959551_p
w(16)=3.281677235623607e-20_p
else if(N==17)then
x(1)=-4.881953553252527_p
w(1)=2.998318814240050e-1_p
x(2)=-4.385458272535963_p
w(2)=6.778049942853402e-1_p
x(3)=-3.523572145047269_p
w(3)=9.985493629387643e-1_p
x(4)=-2.353816186821800_p
w(4)=1.184298164189399_p
x(5)=-9.603513439424077e-1_p
w(5)=1.068887955792316_p
x(6)=6.005984859393217e-1_p
w(6)=5.872160818244664e-1_p
x(7)=2.400076624508204_p
w(7)=1.632182697803277e-1_p
x(8)=4.551295694189363_p
w(8)=2.449449549502730e-2_p
x(9)=7.097556471062322_p
w(9)=2.272970008148895e-3_p
x(10)=10.06122056285275_p
w(10)=1.359305263610022e-4_p
x(11)=13.47974494245141_p
w(11)=5.125161648644752e-6_p
x(12)=17.41139980807499_p
w(12)=1.156156716307758e-7_p
x(13)=21.94231013033913_p
w(13)=1.438902506669514e-9_p
x(14)=27.20405029650005_p
w(14)=8.719171682882796e-12_p
x(15)=33.41462138737806_p
w(15)=2.091698144776814e-14_p
x(16)=40.9911398952324_p
w(16)=1.341313194123526e-17_p
x(17)=51.00243626036887_p
w(17)=8.568316791786754e-22_p
else
call GD(-5)
end if
end subroutine GF_m5

! [-4kT;infkT]
subroutine GF_m4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.719496190229457_p
w(1)=2.798302111467206_p
x(2)=9.542779203722508e-1_p
w(2)=1.219847816450604_p
else if(N==3)then
x(1)=-3.173001310886673_p
w(1)=1.934954911735428_p
x(2)=-4.480232897721722e-1_p
w(2)=1.923940244706907_p
x(3)=3.489292096308511_p
w(3)=1.592547714754745e-1_p
else if(N==4)then
x(1)=-3.403203716818599_p
w(1)=1.435140040703270_p
x(2)=-1.258690835561112_p
w(2)=2.024550424353285_p
x(3)=1.675328392593702_p
w(3)=5.476514908739840e-1_p
x(4)=6.380734546885206_p
w(4)=1.080797198727147e-2_p
else if(N==5)then
x(1)=-3.538652280896523_p
w(1)=1.124996109689236_p
x(2)=-1.794879981956074_p
w(2)=1.884612722489621_p
x(3)=6.595794635421018e-1_p
w(3)=9.343628094167140e-1_p
x(4)=4.024142799184552_p
w(4)=7.364250385850382e-2_p
x(5)=9.502238752860208_p
w(5)=5.357824637350607e-4_p
else if(N==6)then
x(1)=-3.626594928827350_p
w(1)=9.180157518247676e-1_p
x(2)=-2.170764128671303_p
w(2)=1.690798048143879_p
x(3)=-3.442507328367793e-2_p
w(3)=1.196895395681665_p
x(4)=2.682865451992741_p
w(4)=2.061896498403964e-1_p
x(5)=6.652249530046832_p
w(5)=6.228604579439121e-3_p
x(6)=12.76010979182192_p
w(6)=2.247784766239062e-5_p
else if(N==7)then
x(1)=-3.687771966085986_p
w(1)=7.716548615709768e-1_p
x(2)=-2.445597229507797_p
w(2)=1.505362578535941_p
x(3)=-5.536860324320598e-1_p
w(3)=1.330467714148563_p
x(4)=1.781359346285596_p
w(4)=3.841008316201496e-1_p
x(5)=4.964277652952540_p
w(5)=2.615049574063351e-2_p
x(6)=9.470326698165286_p
w(6)=4.126007923598767e-4_p
x(7)=16.11024418351231_p
w(7)=8.455091858659624e-7_p
else if(N==8)then
x(1)=-3.732540276057644_p
w(1)=6.634018442822618e-1_p
x(2)=-2.653581974660928_p
w(2)=1.343740791550228_p
x(3)=-9.607020301271685e-1_p
w(3)=1.371507617209881_p
x(4)=1.118033017140109_p
w(4)=5.689632895687637e-1_p
x(5)=3.805197099172307_p
w(5)=6.808338894796565e-2_p
x(6)=7.462547802641441_p
w(6)=2.429549470920933e-3_p
x(7)=12.41994824579345_p
w(7)=2.341750553036774e-5_p
x(8)=19.52833803510411_p
w(8)=2.938225775273478e-8_p
else if(N==9)then
x(1)=-3.766590224822862_p
w(1)=5.804541477849965e-1_p
x(2)=-2.815550344375922_p
w(2)=1.206707811827298_p
x(3)=-1.288600559391299_p
w(3)=1.356834071368443_p
x(4)=6.002298748286895e-1_p
w(4)=7.316476672048814e-1_p
x(5)=2.947335471214548_p
w(5)=1.339849590605708e-1_p
x(6)=6.052120577815452_p
w(6)=8.333039841110099e-3_p
x(7)=10.116435423086_p
w(7)=1.870426121933438e-4_p
x(8)=15.46848300837569_p
w(8)=1.187257473769629e-6_p
x(9)=22.99910211473202_p
w(9)=9.608425333109669e-10_p
else if(N==10)then
x(1)=-3.793285361611701_p
w(1)=5.150712489010336e-1_p
x(2)=-2.944741127563285_p
w(2)=1.091133156089099_p
x(3)=-1.557828766737705_p
w(3)=1.312425356709811_p
x(4)=1.794456935717927e-1_p
w(4)=8.583551200701367e-1_p
x(5)=2.280668119189426_p
w(5)=2.195538166170430e-1_p
x(6)=4.990086506057731_p
w(6)=2.077867603917830e-2_p
x(7)=8.469986244812661_p
w(7)=8.199136123996438e-4_p
x(8)=12.88836204250315_p
w(8)=1.258472776121331e-5_p
x(9)=18.59528947192073_p
w(9)=5.512141099163872e-8_p
x(10)=26.51213502978445_p
w(10)=2.993568732125546e-11_p
else if(N==11)then
x(1)=-3.814731621081473_p
w(1)=4.623295447642554e-1_p
x(2)=-3.049887019675561_p
w(2)=9.933345398765657e-1_p
x(3)=-1.782212958402775_p
w(3)=1.254146131056476_p
x(4)=-1.720588449732285e-1_p
w(4)=9.471442589528163e-1_p
x(5)=1.743641697789831_p
w(5)=3.166235767363454e-1_p
x(6)=4.154984122319658_p
w(6)=4.198819145798703e-2_p
x(7)=7.212313131730185_p
w(7)=2.513573622347536e-3_p
x(8)=11.0187295635431_p
w(8)=6.934713642966460e-5_p
x(9)=15.75471153052168_p
w(9)=7.619305368080670e-7_p
x(10)=21.78605872306332_p
w(10)=2.383153867655311e-9_p
x(11)=30.0599816085353_p
w(11)=8.964146137041740e-13_p
else if(N==12)then
x(1)=-3.832310151859461_p
w(1)=4.189623052349011e-1_p
x(2)=-3.136941137491463_p
w(2)=9.100279886943470e-1_p
x(3)=-1.971598991985317_p
w(3)=1.190986850455831_p
x(4)=-4.713961676759626e-1_p
w(4)=1.002517034840670_p
x(5)=1.298753218498669_p
w(5)=4.161970051118782e-1_p
x(6)=3.477948843993753_p
w(6)=7.311694561168249e-2_p
x(7)=6.211293653329241_p
w(7)=6.078916272982507e-3_p
x(8)=9.574316579480229_p
w(8)=2.576258675999527e-4_p
x(9)=13.672823031183_p
w(9)=5.213410146579507e-6_p
x(10)=18.69908995022282_p
w(10)=4.232062814549456e-8_p
x(11)=25.03031580024707_p
w(11)=9.711673107304868e-11_p
x(12)=33.63708886997951_p
w(12)=2.596750431115907e-14_p
else if(N==13)then
x(1)=-3.846961996608427_p
w(1)=3.827240471772317e-1_p
x(2)=-3.210081037714196_p
w(2)=8.385141929946818e-1_p
x(3)=-2.133221023377039_p
w(3)=1.127787345666233_p
x(4)=-7.298775689269931e-1_p
w(4)=1.031279438384283_p
x(5)=9.218702850817959e-1_p
w(5)=5.106651271543704e-1_p
x(6)=2.916102580156255_p
w(6)=1.139955456895590e-1_p
x(7)=5.391472071316332_p
w(7)=1.242540698342369e-2_p
x(8)=8.413435952905141_p
w(8)=7.352119297281033e-4_p
x(9)=12.04931999968408_p
w(9)=2.325393156277268e-5_p
x(10)=16.41466560646656_p
w(10)=3.558160744795055e-7_p
x(11)=21.70937654778343_p
w(11)=2.186896508530504e-9_p
x(12)=28.32010460615908_p
w(12)=3.764382513480109e-12_p
x(13)=37.23919482761491_p
w(13)=7.313131796676132e-16_p
else if(N==14)then
x(1)=-3.859349130181753_p
w(1)=3.520242626733072e-1_p
x(2)=-3.272313900046066_p
w(2)=7.766368489937069e-1_p
x(3)=-2.272510150963738_p
w(3)=1.067011259363854_p
x(4)=-9.554439023445880e-1_p
w(4)=1.040204022149905_p
x(5)=5.968449242400848e-1_p
w(5)=5.948113303766220e-1_p
x(6)=2.440987959433897_p
w(6)=1.632337863283484e-1_p
x(7)=4.705585902922793_p
w(7)=2.241059878580326e-2_p
x(8)=7.454535162238527_p
w(8)=1.738191683268944e-3_p
x(9)=10.73403822964859_p
w(9)=7.771404622081156e-5_p
x(10)=14.61896867486415_p
w(10)=1.891027365760797e-6_p
x(11)=19.23120839188639_p
w(11)=2.238301281746990e-8_p
x(12)=24.77625602338563_p
w(12)=1.062545044673711e-10_p
x(13)=31.64921287633956_p
w(13)=1.397678948761916e-13_p
x(14)=40.86294826681807_p
w(14)=2.010066705214156e-17_p
else if(N==15)then
x(1)=-3.869950001929692_p
w(1)=3.257070350693366e-1_p
x(2)=-3.325853495258499_p
w(2)=7.226875796854740e-1_p
x(3)=-2.393613162420416_p
w(3)=1.009798835216924_p
x(4)=-1.153948535923723_p
w(4)=1.035034677325866_p
x(5)=3.125203572668829e-1_p
w(5)=6.658591117701642e-1_p
x(6)=2.032841809111928_p
w(6)=2.185714947005432e-1_p
x(7)=4.122071328267885_p
w(7)=3.670184521579924e-2_p
x(8)=6.646189360220503_p
w(8)=3.570799296418388e-3_p
x(9)=9.639968591565653_p
w(9)=2.110491386045293e-4_p
x(10)=13.15424364554522_p
w(10)=7.358409656558229e-6_p
x(11)=17.26969344933164_p
w(11)=1.407713064232906e-7_p
x(12)=22.11234706950023_p
w(12)=1.312816857482748e-9_p
x(13)=27.8923721662219_p
w(13)=4.894489189259917e-12_p
x(14)=35.0126822416731_p
w(14)=4.998706761432617e-15_p
x(15)=44.50566087568308_p
w(15)=5.408720788113946e-19_p
else if(N==16)then
x(1)=-3.879118554001132_p
w(1)=3.029133952686350e-1_p
x(2)=-3.372362112936842_p
w(2)=6.753119360297316e-1_p
x(3)=-2.499742004059966_p
w(3)=9.565679049166960e-1_p
x(4)=-1.329869258346857_p
w(4)=1.020252025877571_p
x(5)=6.095898790083282e-2_p
w(5)=7.230045243347641e-1_p
x(6)=1.677477832901121_p
w(6)=2.773279575676338e-1_p
x(7)=3.618823217942657_p
w(7)=5.567682409448289e-2_p
x(8)=5.953866227079200_p
w(8)=6.581411315677459e-3_p
x(9)=8.711897541023292_p
w(9)=4.904533699562327e-4_p
x(10)=11.92859079381349_p
w(10)=2.285081527029739e-5_p
x(11)=15.66019582826463_p
w(11)=6.345452621848705e-7_p
x(12)=19.99094678316752_p
w(12)=9.709467085167308e-9_p
x(13)=25.05003422899292_p
w(13)=7.244658812314480e-11_p
x(14)=31.05179316447884_p
w(14)=2.151720317278307e-13_p
x(15)=38.40648297241354_p
w(15)=1.729824071889025e-16_p
x(16)=48.16513945928085_p
w(16)=1.428390826412944e-20_p
else if(N==17)then
x(1)=-3.887121961559238_p
w(1)=2.829925221845728e-1_p
x(2)=-3.413110067439127_p
w(2)=6.334308096425728e-1_p
x(3)=-2.593416527513122_p
w(3)=9.073515870469383e-1_p
x(4)=-1.486726296768327_p
w(4)=9.991827935564415e-1_p
x(5)=-1.636489755537441e-1_p
w(5)=7.667928007314285e-1_p
x(6)=1.364458148498536_p
w(6)=3.368221937136067e-1_p
x(7)=3.179783480410599_p
w(7)=7.937468606312904e-2_p
x(8)=5.353274307858534_p
w(8)=1.113037579104377e-2_p
x(9)=7.912533038446577_p
w(9)=1.010019962221872e-3_p
x(10)=10.88338460445297_p
w(10)=5.984356698074633e-5_p
x(11)=14.30638873795387_p
w(11)=2.244569305236143e-6_p
x(12)=18.24111968739302_p
w(12)=5.045931994662644e-8_p
x(13)=22.7742751589325_p
w(13)=6.264504455737253e-10_p
x(14)=28.03772739796758_p
w(14)=3.789039829154228e-12_p
x(15)=34.24965401469627_p
w(15)=9.076676731119903e-15_p
x(16)=41.82728983210698_p
w(16)=5.813631933040804e-18_p
x(17)=51.83956877083747_p
w(17)=3.709949510143784e-22_p
else
call GD(-4)
end if
end subroutine GF_m4

! [-3kT;infkT]
subroutine GF_m3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.899025451431811_p
w(1)=2.236589553831101_p
x(2)=1.474550524950370_p
w(2)=8.119977977426408e-1_p
else if(N==3)then
x(1)=-2.271684148710932_p
w(1)=1.607697463227898_p
x(2)=1.763422405853526e-1_p
w(2)=1.352267400931320_p
x(3)=4.104040432467021_p
w(3)=8.862248741452430e-2_p
else if(N==4)then
x(1)=-2.465647510253731_p
w(1)=1.221926823371651_p
x(2)=-5.388484633369968e-1_p
w(2)=1.502930070329095_p
x(3)=2.306222747594586_p
w(3)=3.182500245553618e-1_p
x(4)=7.066637280270300_p
w(4)=5.480433317633632e-3_p
else if(N==5)then
x(1)=-2.581972320670878_p
w(1)=9.738600781466518e-1_p
x(2)=-1.005143745126413_p
w(2)=1.463844805515510_p
x(3)=1.319566207332200_p
w(3)=5.731493040551519e-1_p
x(4)=4.720168467374710_p
w(4)=3.747356852418503e-2_p
x(5)=10.22937489265078_p
w(5)=2.595953322437444e-4_p
else if(N==6)then
x(1)=-2.658598519676396_p
w(1)=8.042774313652157e-1_p
x(2)=-1.332495468922910_p
w(2)=1.358929688914632_p
x(3)=6.631964875195999e-1_p
w(3)=7.752543076771192e-1_p
x(4)=3.385006713842561_p
w(4)=1.071253825835620e-1_p
x(5)=7.391621269998611_p
w(5)=2.989958656780908e-3_p
x(6)=13.51475552406082_p
w(6)=1.058237643230077e-5_p
else if(N==7)then
x(1)=-2.712508406670877_p
w(1)=6.822525943187800e-1_p
x(2)=-1.573409789180229_p
w(2)=1.240993416254945_p
x(3)=1.829286559696374e-1_p
w(3)=9.063179914909502e-1_p
x(4)=2.490862202745343_p
w(4)=2.062999226149193e-1_p
x(5)=5.711359546810002_p
w(5)=1.253083547884352e-2_p
x(6)=10.23653211983373_p
w(6)=1.922015612098988e-4_p
x(7)=16.88519623493936_p
w(7)=3.898540945311145e-7_p
else if(N==8)then
x(1)=-2.752318299871486_p
w(1)=5.907907151392341e-1_p
x(2)=-1.757106707048736_p
w(2)=1.129177169165370_p
x(3)=-1.881736325908012e-1_p
w(3)=9.765288900508544e-1_p
x(4)=1.838534870554975_p
w(4)=3.181299941462148e-1_p
x(5)=4.556930987302778_p
w(5)=3.282631301288555e-2_p
x(6)=8.237496055984282_p
w(6)=1.123563920189885e-3_p
x(7)=13.20510085480177_p
w(7)=1.069280812870013e-5_p
x(8)=20.31916336922565_p
w(8)=1.333086416449382e-8_p
else if(N==9)then
x(1)=-2.782824115046858_p
w(1)=5.199663077105474e-1_p
x(2)=-1.901198075217537_p
w(2)=1.029144731359285_p
x(3)=-4.849404183990648e-1_p
w(3)=1.002989421528803_p
x(4)=1.335371570629916_p
w(4)=4.270574173056941e-1_p
x(5)=3.702267068162861_p
w(5)=6.550544022784177e-2_p
x(6)=6.833449974786993_p
w(6)=3.838752972328793e-3_p
x(7)=10.90991121265801_p
w(7)=8.474601389644325e-5_p
x(8)=16.26821510155897_p
w(8)=5.340250524088635e-7_p
x(9)=23.8028070543703_p
w(9)=4.302928044829102e-10_p
else if(N==10)then
x(1)=-2.806891369984961_p
w(1)=4.636573179417861e-1_p
x(2)=-2.016882864550538_p
w(2)=9.415440997593838e-1_p
x(3)=-7.279578532942766e-1_p
w(3)=1.000899317517163_p
x(4)=9.317241097024582e-1_p
w(4)=5.229567301725837e-1_p
x(5)=3.038724810606576_p
w(5)=1.095858584214377e-1_p
x(6)=5.775911841134979_p
w(6)=9.569102986358640e-3_p
x(7)=9.270184457898784_p
w(7)=3.692806457752157e-4_p
x(8)=13.69564111214232_p
w(8)=5.619619042536274e-6_p
x(9)=19.40680003524885_p
w(9)=2.449694976330886e-8_p
x(10)=27.32657475621258_p
w(10)=1.326162501596241e-11_p
else if(N==11)then
x(1)=-2.826330533744472_p
w(1)=4.179080473040981e-1_p
x(2)=-2.111584115994856_p
w(2)=8.653203426402654e-1_p
x(3)=-9.305318074982529e-1_p
w(3)=9.814268346031485e-1_p
x(4)=5.984921759525513e-1_p
w(4)=6.011581907193652e-1_p
x(5)=2.505705070017243_p
w(5)=1.622112599911882e-1_p
x(6)=4.943905229544062_p
w(6)=1.940428604052839e-2_p
x(7)=8.017883725959853_p
w(7)=1.127272901943668e-3_p
x(8)=11.83238612252286_p
w(8)=3.077993663431112e-5_p
x(9)=16.57299358980877_p
w(9)=3.363875670833392e-7_p
x(10)=22.60738801330341_p
w(10)=1.048609924854115e-9_p
x(11)=30.88355332947027_p
w(11)=3.934798809333967e-13_p
else if(N==12)then
x(1)=-2.842338238791084_p
w(1)=3.800603192305196e-1_p
x(2)=-2.190393901599009_p
w(2)=7.989778980240686e-1_p
x(3)=-1.101808639621531_p
w(3)=9.520845646220329e-1_p
x(4)=3.174386007052089e-1_p
w(4)=6.609016245418036e-1_p
x(5)=2.066187953775957_p
w(5)=2.196857677985659e-1_p
x(6)=4.269054396696240_p
w(6)=3.404178924120808e-2_p
x(7)=7.021091630573705_p
w(7)=2.719300468099945e-3_p
x(8)=10.39336511551197_p
w(8)=1.137804421903145e-4_p
x(9)=14.49697212402608_p
w(9)=2.288652211303285e-6_p
x(10)=19.52649746519858_p
w(10)=1.851065861640133e-8_p
x(11)=25.86001547691611_p
w(11)=4.237198359713331e-11_p
x(12)=34.46855583121872_p
w(12)=1.130825743803179e-14_p
else if(N==13)then
x(1)=-2.855735322600329_p
w(1)=3.482674961233848e-1_p
x(2)=-2.256908814252493_p
w(2)=7.410416802811640e-1_p
x(3)=-1.248349875209718_p
w(3)=9.176877698345527e-1_p
x(4)=7.648848658877554e-2_p
w(4)=7.036747969836897e-1_p
x(5)=1.696130840361994_p
w(5)=2.783503185429805e-1_p
x(6)=3.708945369602473_p
w(6)=5.367739899159829e-2_p
x(7)=6.204533742171480_p
w(7)=5.554168988083602e-3_p
x(8)=9.237035266678848_p
w(8)=3.234075226006294e-4_p
x(9)=12.87856993960566_p
w(9)=1.015853738071168e-5_p
x(10)=17.24742828934972_p
w(10)=1.548176744985082e-7_p
x(11)=22.54455292737748_p
w(11)=9.490017831646067e-10_p
x(12)=29.1570624311646_p
w(12)=1.630414863778915e-12_p
x(13)=38.07757818671985_p
w(13)=3.162651590708204e-16_p
else if(N==14)then
x(1)=-2.867102627734727_p
w(1)=3.212097691635427e-1_p
x(2)=-2.313734065897671_p
w(2)=6.902062310865545e-1_p
x(3)=-1.375009739628357_p
w(3)=8.812279084742504e-1_p
x(4)=-1.327362034414343e-1_p
w(4)=7.319660588014637e-1_p
x(5)=1.379212235550803_p
w(5)=3.351318886479309e-1_p
x(6)=3.235525160617631_p
w(6)=7.801912560689638e-2_p
x(7)=5.521121434103240_p
w(7)=1.002948563495827e-2_p
x(8)=8.281956259293532_p
w(8)=7.622481909314645e-4_p
x(9)=11.56773624374615_p
w(9)=3.380724065273759e-5_p
x(10)=15.4564672443754_p
w(10)=8.190141989454282e-7_p
x(11)=20.0712706213056_p
w(11)=9.666506649655013e-9_p
x(12)=25.61817239190268_p
w(12)=4.579536024821547e-11_p
x(13)=32.4925497635722_p
w(13)=6.014806963641891e-14_p
x(14)=41.70745712138547_p
w(14)=8.639488313502051e-18_p
else if(N==15)then
x(1)=-2.876862170936098_p
w(1)=2.979204974666648e-1_p
x(2)=-2.362798740401403_p
w(2)=6.453654181625224e-1_p
x(3)=-1.485464120833851_p
w(3)=8.445147751177222e-1_p
x(4)=-3.162851380175881e-1_p
w(4)=7.484905520603550e-1_p
x(5)=1.103965898549687_p
w(5)=3.877778285165842e-1_p
x(6)=2.829348092423341_p
w(6)=1.063822939436416e-1_p
x(7)=4.939464148932697_p
w(7)=1.647874022850235e-2_p
x(8)=7.476794166075763_p
w(8)=1.562528995058080e-3_p
x(9)=10.47755124341232_p
w(9)=9.148194434503215e-5_p
x(10)=13.99594771881186_p
w(10)=3.174038545095139e-6_p
x(11)=18.11412923506294_p
w(11)=6.053437356935083e-8_p
x(12)=22.95873110043706_p
w(12)=5.633287991229625e-10_p
x(13)=28.74022089100704_p
w(13)=2.096907612281704e-12_p
x(14)=35.8616874937595_p
w(14)=2.138926915994174e-15_p
x(15)=45.35564508341947_p
w(15)=2.311993250874741e-19_p
else if(N==16)then
x(1)=-2.885327613509993_p
w(1)=2.776764915941406e-1_p
x(2)=-2.405559169768672_p
w(2)=6.055991114215119e-1_p
x(3)=-1.582548888429578_p
w(3)=8.086094233017816e-1_p
x(4)=-4.786756178045187e-1_p
w(4)=7.557823951771155e-1_p
x(5)=8.621059870763124e-1_p
w(5)=4.348650131391440e-1_p
x(6)=2.476445813473343_p
w(6)=1.378226737727832e-1_p
x(7)=4.437629055103358_p
w(7)=2.513369403795938e-2_p
x(8)=6.787095199247492_p
w(8)=2.876500347942871e-3_p
x(9)=9.552871634346740_p
w(9)=2.119514439897626e-4_p
x(10)=12.7740424127033_p
w(10)=9.821336041297548e-6_p
x(11)=16.50856263323497_p
w(11)=2.718205478765205e-7_p
x(12)=20.84136781783912_p
w(12)=4.149780163362767e-9_p
x(13)=25.90198145030125_p
w(13)=3.091201841368238e-11_p
x(14)=31.9049236199006_p
w(14)=9.169497182998229e-14_p
x(15)=39.26057140298346_p
w(15)=7.364140287882228e-17_p
x(16)=49.0200567408209_p
w(16)=6.075622299499072e-21_p
else if(N==17)then
x(1)=-2.892736725485689_p
w(1)=2.599265292922975e-1_p
x(2)=-2.443133774468004_p
w(2)=5.701471028892356e-1_p
x(3)=-1.668486030329298_p
w(3)=7.741045703882460e-1_p
x(4)=-6.233755247958535e-1_p
w(4)=7.560224548892671e-1_p
x(5)=6.474968074928356e-1_p
w(5)=4.756828016007665e-1_p
x(6)=2.166500881407613_p
w(6)=1.712734659378802e-1_p
x(7)=3.999724724731790_p
w(7)=3.610452282284166e-2_p
x(8)=6.188640295200850_p
w(8)=4.863882953246339e-3_p
x(9)=8.756461446156228_p
w(9)=4.354013321968351e-4_p
x(10)=11.73218418267267_p
w(10)=2.563951507635899e-5_p
x(11)=15.15830241921805_p
w(11)=9.581961937045604e-7_p
x(12)=19.09520226940076_p
w(12)=2.148856800031164e-8_p
x(13)=23.62995428824362_p
w(13)=2.663137029741628e-10_p
x(14)=28.89463104003911_p
w(14)=1.608656414725144e-12_p
x(15)=35.1075312635004_p
w(15)=3.849564238874113e-15_p
x(16)=42.68597222044092_p
w(16)=2.463567653093367e-18_p
x(17)=52.69896112006001_p
w(17)=1.570954518028828e-22_p
else
call GD(-3)
end if
end subroutine GF_m3

! [-2kT;infkT]
subroutine GF_m2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.066219022963170_p
w(1)=1.641101497176529_p
x(2)=2.078600418313979_p
w(2)=4.858265138664436e-1_p
else if(N==3)then
x(1)=-1.367356231323794_p
w(1)=1.231471527208014_p
x(2)=8.549450459676792e-1_p
w(2)=8.501892795661649e-1_p
x(3)=4.795098731628099_p
w(3)=4.526720426879353e-2_p
else if(N==4)then
x(1)=-1.527758522688313_p
w(1)=9.633827403146467e-1_p
x(2)=2.103257912251834e-1_p
w(2)=9.940876813710295e-1_p
x(3)=3.011210490610731_p
w(3)=1.668490404108140e-1_p
x(4)=7.813498472750431_p
w(4)=2.608548946482357e-3_p
else if(N==5)then
x(1)=-1.625833553382936_p
w(1)=7.833920657864845e-1_p
x(2)=-2.009896653424005e-1_p
w(2)=1.013089401889349_p
x(3)=2.043321062584543_p
w(3)=3.125477730084710e-1_p
x(4)=5.478359593775568_p
w(4)=1.777945592332448e-2_p
x(5)=11.00843598371968_p
w(5)=1.193144353436136e-4_p
else if(N==6)then
x(1)=-1.691430500526304_p
w(1)=6.565854403506320e-1_p
x(2)=-4.878482492359962e-1_p
w(2)=9.761658231958015e-1_p
x(3)=1.410605943191935_p
w(3)=4.415302028717195e-1_p
x(4)=4.150216704576321_p
w(4)=5.128095283291732e-2_p
x(5)=8.182259616158492_p
w(5)=1.360836446374211e-3_p
x(6)=14.3155582240346_p
w(6)=4.755345527951026e-6_p
else if(N==7)then
x(1)=-1.738145243212661_p
w(1)=5.632940627040226e-1_p
x(2)=-6.990919598400156e-1_p
w(2)=9.183843645299515e-1_p
x(3)=9.558326585567990e-1_p
w(3)=5.388742848377983e-1_p
x(4)=3.262112279567420_p
w(4)=1.006128804629916e-1_p
x(5)=6.510004468797175_p
w(5)=5.676710634021832e-3_p
x(6)=11.04763743931781_p
w(6)=8.553555652338806e-5_p
x(7)=17.70216025090167_p
w(7)=1.723176632328094e-7_p
else if(N==8)then
x(1)=-1.772984992481520_p
w(1)=4.921660572298100e-1_p
x(2)=-8.607546046559785e-1_p
w(2)=8.557261661082416e-1_p
x(3)=6.095334706150166e-1_p
w(3)=6.045093619146975e-1_p
x(4)=2.616735949158334_p
w(4)=1.591472685143311e-1_p
x(5)=5.361044598798482_p
w(5)=1.487800930866558e-2_p
x(6)=9.056630868890718_p
w(6)=4.964562611850428e-4_p
x(7)=14.03094275028928_p
w(7)=4.685889082742266e-6_p
x(8)=21.14881661753862_p
w(8)=5.816958868061738e-9_p
else if(N==9)then
x(1)=-1.799902693232007_p
w(1)=4.363351445733010e-1_p
x(2)=-9.881655153441032e-1_p
w(2)=7.949925604242531e-1_p
x(3)=3.354926571570169e-1_p
w(3)=6.439758094902146e-1_p
x(4)=2.122062123454675_p
w(4)=2.200471199433607e-1_p
x(5)=4.510294409407023_p
w(5)=2.985219479903238e-2_p
x(6)=7.658773055255134_p
w(6)=1.688070153640836e-3_p
x(7)=11.74307065428292_p
w(7)=3.688018854598124e-5_p
x(8)=17.10552542658949_p
w(8)=2.312848134587328e-7_p
x(9)=24.64278936493966_p
w(9)=1.858104255598128e-10_p
else if(N==10)then
x(1)=-1.821287332144799_p
w(1)=3.914521941829920e-1_p
x(2)=-1.090968012604787_p
w(2)=7.387845837685421e-1_p
x(3)=1.126057743609709e-1_p
w(3)=6.637762831284887e-1_p
x(4)=1.728317475968686_p
w(4)=2.781075811482584e-1_p
x(5)=3.849935629756687_p
w(5)=5.044763542450551e-2_p
x(6)=6.605961534323868_p
w(6)=4.197492786338716e-3_p
x(7)=10.10937255748285_p
w(7)=1.598115992975290e-4_p
x(8)=14.53946239974696_p
w(8)=2.418489623591975e-6_p
x(9)=20.25344202454972_p
w(9)=1.050924887647386e-8_p
x(10)=28.17518737442196_p
w(10)=5.677093285927114e-12_p
else if(N==11)then
x(1)=-1.838663163802687_p
w(1)=3.546475239251867e-1_p
x(2)=-1.175530583316538_p
w(2)=6.878283192179104e-1_p
x(3)=-7.245540578890269e-2_p
w(3)=6.695879517062723e-1_p
x(4)=1.405955699506372_p
w(4)=3.301170710369017e-1_p
x(5)=3.319985087216567_p
w(5)=7.573771540446372e-2_p
x(6)=5.777551969373607_p
w(6)=8.510379576436241e-3_p
x(7)=8.862040272162803_p
w(7)=4.857301445464996e-4_p
x(8)=12.68175597971531_p
w(8)=1.317608995942566e-5_p
x(9)=17.42541782746396_p
w(9)=1.434948207059103e-7_p
x(10)=23.46184832834664_p
w(10)=4.463076354383755e-10_p
x(11)=31.73952229076624_p
w(11)=1.672007087998206e-13_p
else if(N==12)then
x(1)=-1.853046235248405_p
w(1)=3.239595810711310e-1_p
x(2)=-1.246222549133243_p
w(2)=6.420415343733986e-1_p
x(3)=-2.286260598603770e-1_p
w(3)=6.658251942308738e-1_p
x(4)=1.136237242398086_p
w(4)=3.745397747279435e-1_p
x(5)=2.883822951860602_p
w(5)=1.043811681905549e-1_p
x(6)=5.105468341984945_p
w(6)=1.496329627904583e-2_p
x(7)=7.869333948308167_p
w(7)=1.167995059035959e-3_p
x(8)=11.2474863597046_p
w(8)=4.848775340225872e-5_p
x(9)=15.3544269779034_p
w(9)=9.715011539138681e-7_p
x(10)=20.3861144841645_p
w(10)=7.838514987874651e-9_p
x(11)=26.72116609238129_p
w(11)=1.791288361056194e-11_p
x(12)=35.33089529997958_p
w(12)=4.774540398207929e-15_p
else if(N==13)then
x(1)=-1.865138705882564_p
w(1)=2.980061943060472e-1_p
x(2)=-1.306136684465914_p
w(2)=6.010212806255508e-1_p
x(3)=-3.621731090043983e-1_p
w(3)=6.557272372354608e-1_p
x(4)=9.066547483971303e-1_p
w(4)=4.110167985652274e-1_p
x(5)=2.517617610208000_p
w(5)=1.349311899551000e-1_p
x(6)=4.547565547079387_p
w(6)=2.370287849862072e-2_p
x(7)=7.056123203257781_p
w(7)=2.380770033382608e-3_p
x(8)=10.0952391270531_p
w(8)=1.373023642619847e-4_p
x(9)=13.74042594555213_p
w(9)=4.293793125561243e-6_p
x(10)=18.11159836136361_p
w(10)=6.526614852126675e-8_p
x(11)=23.41032914272238_p
w(11)=3.993615146650344e-10_p
x(12)=30.0240315079637_p
w(12)=6.852341677768506e-13_p
x(13)=38.94550606197298_p
w(13)=1.327855822454459e-16_p
else if(N==14)then
x(1)=-1.875440708410614_p
w(1)=2.757875538059690e-1_p
x(2)=-1.357520374550541_p
w(2)=5.642651249495931e-1_p
x(3)=-4.776480472133245e-1_p
w(3)=6.415951873110346e-1_p
x(4)=7.085084886291031e-1_p
w(4)=4.399114726007684e-1_p
x(5)=2.205113720995127_p
w(5)=1.660457518889829e-1_p
x(6)=4.076023893376093_p
w(6)=3.469038886468504e-2_p
x(7)=6.375443474799791_p
w(7)=4.295338238566693e-3_p
x(8)=9.143673097446859_p
w(8)=3.226088685692609e-4_p
x(9)=12.43346270985806_p
w(9)=1.423653857407678e-5_p
x(10)=16.32467801168846_p
w(10)=3.439057144764571e-7_p
x(11)=20.94117792390452_p
w(11)=4.051322324952133e-9_p
x(12)=26.48931569822851_p
w(12)=1.916746974271973e-11_p
x(13)=33.36464474219746_p
w(13)=2.514914349966035e-14_p
x(14)=42.58034019950018_p
w(14)=3.609347831244095e-18_p
else if(N==15)then
x(1)=-1.884317747404781_p
w(1)=2.565637650592077e-1_p
x(2)=-1.402043804169261_p
w(2)=5.312688679101522e-1_p
x(3)=-5.784488820674794e-1_p
w(3)=6.250316105842272e-1_p
x(4)=5.355354415257988e-1_p
w(4)=4.619686287313959e-1_p
x(5)=1.934813349599864_p
w(5)=1.966025567857466e-1_p
x(6)=3.671590513670808_p
w(6)=4.773346688014062e-2_p
x(7)=5.796015964295285_p
w(7)=7.059682827862439e-3_p
x(8)=8.341532774149588_p
w(8)=6.596794284646360e-4_p
x(9)=11.34669530288836_p
w(9)=3.839921508638950e-5_p
x(10)=14.86776336475236_p
w(10)=1.328106878580237e-6_p
x(11)=18.98774231852413_p
w(11)=2.527803382362830e-8_p
x(12)=23.83363715890204_p
w(12)=2.349020247422821e-10_p
x(13)=29.61610452613794_p
w(13)=8.734673791487696e-13_p
x(14)=36.73834619621103_p
w(14)=8.902375114216720e-16_p
x(15)=46.23296195744641_p
w(15)=9.616046425445025e-20_p
else if(N==16)then
x(1)=-1.892042908946991_p
w(1)=2.397762583747070e-1_p
x(2)=-1.440972647871681_p
w(2)=5.015666792302307e-1_p
x(3)=-6.671697172203744e-1_p
w(3)=6.071372489141857e-1_p
x(4)=3.830937510146878e-1_p
w(4)=4.780874540693750e-1_p
x(5)=1.698342046157031_p
w(5)=2.257413546350734e-1_p
x(6)=3.320447076496158_p
w(6)=6.252945223652945e-2_p
x(7)=5.296010724772942_p
w(7)=1.078447019234758e-2_p
x(8)=7.654428826176578_p
w(8)=1.212166088689610e-3_p
x(9)=10.42504185740955_p
w(9)=8.871576456957151e-5_p
x(10)=13.64908914585825_p
w(10)=4.096664601599155e-6_p
x(11)=17.3855160322403_p
w(11)=1.131351954037188e-7_p
x(12)=21.71967841002202_p
w(12)=1.724596972559302e-9_p
x(13)=26.78130689276319_p
w(13)=1.283250474648261e-11_p
x(14)=32.78503946125716_p
w(14)=3.803317753984380e-14_p
x(15)=40.1413293823798_p
w(15)=3.052422225826414e-17_p
x(16)=49.90137185665707_p
w(16)=2.516867647518318e-21_p
else if(N==17)then
x(1)=-1.898824187090161_p
w(1)=2.249958871327784e-1_p
x(2)=-1.475282594522571_p
w(2)=4.747445182261920e-1_p
x(3)=-7.458279178962095e-1_p
w(3)=5.886592457447304e-1_p
x(4)=2.476568041400507e-1_p
w(4)=4.891837565983304e-1_p
x(5)=1.489449796961681_p
w(5)=2.528590824695349e-1_p
x(6)=3.012384331132667_p
w(6)=7.870962611964445e-2_p
x(7)=4.859631210166215_p
w(7)=1.553589618793056e-2_p
x(8)=7.058197440378294_p
w(8)=2.047123894513348e-3_p
x(9)=9.631315495442829_p
w(9)=1.818031887614066e-4_p
x(10)=12.61013825956577_p
w(10)=1.066483299575196e-5_p
x(11)=16.03828030436574_p
w(11)=3.976335354540412e-7_p
x(12)=19.9766065166588_p
w(12)=8.903147167824586e-9_p
x(13)=24.51241625311388_p
w(13)=1.102115731245025e-10_p
x(14)=29.77790839454906_p
w(14)=6.651444276332604e-13_p
x(15)=35.99145938895295_p
w(15)=1.590611035580853e-15_p
x(16)=43.57044010521439_p
w(16)=1.017350181079685e-18_p
x(17)=53.58390612640017_p
w(17)=6.484159300282983e-23_p
else
call GD(-2)
end if
end subroutine GF_m2

! [-1kT;infkT]
subroutine GF_m1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.078062663077150e-1_p
w(1)=1.057155732901310_p
x(2)=2.782863716513927_p
w(2)=2.561059546169127e-1_p
else if(N==3)then
x(1)=-4.522745221968787e-1_p
w(1)=8.263519492383066e-1_p
x(2)=1.608264350878083_p
w(2)=4.657801599377602e-1_p
x(3)=5.568719235907259_p
w(3)=2.112957834215611e-2_p
else if(N==4)then
x(1)=-5.846764535985927e-1_p
w(1)=6.659151638031704e-1_p
x(2)=1.010156732431460_p
w(2)=5.673788332892165e-1_p
x(3)=3.796864067639880_p
w(3)=7.880799132168421e-2_p
x(4)=8.626824391181561_p
w(4)=1.159699104151790e-3_p
else if(N==5)then
x(1)=-6.669498791547245e-1_p
w(1)=5.533390176074376e-1_p
x(2)=6.366629216886428e-1_p
w(2)=6.008944974944520e-1_p
x(3)=2.841302070601595_p
w(3)=1.511187440821858e-1_p
x(4)=6.302059873121433_p
w(4)=7.857678655872806e-3_p
x(5)=11.84482010191209_p
w(5)=5.174967827451130e-5_p
else if(N==6)then
x(1)=-7.227341290012128e-1_p
w(1)=4.714021948849164e-1_p
x(2)=3.790798502406825e-1_p
w(2)=5.988731027197903e-1_p
x(3)=2.222653753505264_p
w(3)=2.196951881998307e-1_p
x(4)=4.980703591582445_p
w(4)=2.270399232077194e-2_p
x(5)=9.028231218329397_p
w(5)=5.851801248751673e-4_p
x(6)=15.16769432034242_p
w(6)=2.029268038260190e-6_p
else if(N==7)then
x(1)=-7.629135240163035e-1_p
w(1)=4.096072201050895e-1_p
x(2)=1.902895517251881e-1_p
w(2)=5.798584578856252e-1_p
x(3)=1.782905808817384_p
w(3)=2.764219192995133e-1_p
x(4)=4.097833823028209_p
w(4)=4.490941122558972e-2_p
x(5)=7.362947134432840_p
w(5)=2.428391141876180e-3_p
x(6)=11.90798818372219_p
w(6)=3.621520391593606e-5_p
x(7)=18.56608169043936_p
w(7)=7.265661311048939e-8_p
else if(N==8)then
x(1)=-7.931645848954029e-1_p
w(1)=3.615648240811711e-1_p
x(2)=4.596506193945705e-2_p
w(2)=5.535604358900100e-1_p
x(3)=1.451576914626440_p
w(3)=3.196038634986650e-1_p
x(4)=3.457374440659069_p
w(4)=7.197022505787321e-2_p
x(5)=6.219077885995737_p
w(5)=6.351440963181871e-3_p
x(6)=9.923493382428624_p
w(6)=2.089331921240929e-4_p
x(7)=14.90182853693781_p
w(7)=1.962405470950789e-6_p
x(8)=22.0220295728796_p
w(8)=2.429726502300689e-9_p
else if(N==9)then
x(1)=-8.167253529380544e-1_p
w(1)=3.232557455219645e-1_p
x(2)=-6.788527017641360e-2_p
w(2)=5.249092609696150e-1_p
x(3)=1.191747011614960_p
w(3)=3.504435762756363e-1_p
x(4)=2.967884863271346_p
w(4)=1.011748822344772e-1_p
x(5)=5.372155139080400_p
w(5)=1.275549242113048e-2_p
x(6)=8.530806020073229_p
w(6)=7.072747297093296e-4_p
x(7)=12.61972969804914_p
w(7)=1.535924546656190e-5_p
x(8)=17.98469192752994_p
w(8)=9.604320249886829e-8_p
x(9)=25.52358790388824_p
w(9)=7.702095609538006e-11_p
else if(N==10)then
x(1)=-8.355724217858526e-1_p
w(1)=2.920554040863521e-1_p
x(2)=-1.599262318414068e-1_p
w(2)=4.963473172527608e-1_p
x(3)=9.819411472449060e-1_p
w(3)=3.710889026923449e-1_p
x(4)=2.579767875404461_p
w(4)=1.303145249074940e-1_p
x(5)=4.714848906825367_p
w(5)=2.163485417928015e-2_p
x(6)=7.482112360183733_p
w(6)=1.753427974792968e-3_p
x(7)=10.99084358433154_p
w(7)=6.625276095506136e-5_p
x(8)=15.42370023868374_p
w(8)=9.993277747788312e-7_p
x(9)=21.13938938566968_p
w(9)=4.334129815819639e-9_p
x(10)=29.06233818443954_p
w(10)=2.338236949752624e-12_p
else if(N==11)then
x(1)=-8.509781984361839e-1_p
w(1)=2.661891058594442e-1_p
x(2)=-2.358238902499765e-1_p
w(2)=4.690318363793670e-1_p
x(3)=8.086968502233496e-1_p
w(3)=3.837422949153444e-1_p
x(4)=2.263437341157070_p
w(4)=1.578613848775742e-1_p
x(5)=4.187541781539194_p
w(5)=3.268160779496063e-2_p
x(6)=6.656998432043386_p
w(6)=3.549353202016796e-3_p
x(7)=9.747546443109584_p
w(7)=2.006239289577751e-4_p
x(8)=13.57033775168111_p
w(8)=5.421458791987395e-6_p
x(9)=18.31583599348842_p
w(9)=5.891869390063424e-8_p
x(10)=24.35350238037818_p
w(10)=1.830035420602442e-10_p
x(11)=32.63209734133484_p
w(11)=6.849096577610393e-14_p
else if(N==12)then
x(1)=-8.637975933129440e-1_p
w(1)=2.444190442567030e-1_p
x(2)=-2.994429930645706e-1_p
w(2)=4.434567516144923e-1_p
x(3)=6.630852756565013e-1_p
w(3)=3.903240729817136e-1_p
x(4)=2.000023168928342_p
w(4)=1.829018334147764e-1_p
x(5)=3.753870050496275_p
w(5)=4.541963232512305e-2_p
x(6)=5.987579140323186_p
w(6)=6.239064611250130e-3_p
x(7)=8.758237888928917_p
w(7)=4.810087199217154e-4_p
x(8)=12.13981664383068_p
w(8)=1.987901359811700e-5_p
x(9)=16.24874458492109_p
w(9)=3.973718291541035e-7_p
x(10)=21.28173664256028_p
w(10)=3.201504592278314e-9_p
x(11)=27.61771984614172_p
w(11)=7.308793152546015e-12_p
x(12)=36.22817452581152_p
w(12)=1.946595714428201e-15_p
else if(N==13)then
x(1)=-8.746255992156230e-1_p
w(1)=2.258580982844257e-1_p
x(2)=-3.535105772162788e-1_p
w(2)=4.197755737476777e-1_p
x(3)=5.389189953669623e-1_p
w(3)=3.923903197429601e-1_p
x(4)=1.776867254091248_p
w(4)=2.049918179235032e-1_p
x(5)=3.390166916488427_p
w(5)=5.931586124121783e-2_p
x(6)=5.431870221077532_p
w(6)=9.893840707556152e-3_p
x(7)=7.947896159080197_p
w(7)=9.782808406107971e-4_p
x(8)=10.99082410682873_p
w(8)=5.611788918595108e-5_p
x(9)=14.63816849655416_p
w(9)=1.750413777677665e-6_p
x(10)=19.01072854324293_p
w(10)=2.656465453811726e-8_p
x(11)=24.31043031258292_p
w(11)=1.623747451146479e-10_p
x(12)=30.9248575658776_p
w(12)=2.783890998876818e-13_p
x(13)=39.84691695454377_p
w(13)=5.391319277174862e-17_p
else if(N==14)then
x(1)=-8.838887115942743e-1_p
w(1)=2.098551876955256e-1_p
x(2)=-4.000056011476302e-1_p
w(2)=3.979705678762466e-1_p
x(3)=4.317576739673050e-1_p
w(3)=3.911543203416706e-1_p
x(4)=1.585133219286028_p
w(4)=2.240116501771912e-1_p
x(5)=3.080270944982133_p
w(5)=7.385547213171581e-2_p
x(6)=4.962186821762510_p
w(6)=1.451476151386979e-2_p
x(7)=7.269645012122608_p
w(7)=1.762289674717601e-3_p
x(8)=10.04209702768937_p
w(8)=1.315102732471519e-4_p
x(9)=13.33423297957614_p
w(9)=5.786637026490315e-6_p
x(10)=17.22692843254824_p
w(10)=1.395471926943950e-7_p
x(11)=21.84444907773623_p
w(11)=1.642046611717434e-9_p
x(12)=27.39333496913789_p
w(12)=7.762477099903662e-12_p
x(13)=34.26924242807092_p
w(13)=1.017865416798627e-14_p
x(14)=43.48541839441337_p
w(14)=1.460077767924167e-18_p
else if(N==15)then
x(1)=-8.919004067432992e-1_p
w(1)=1.959224028093058e-1_p
x(2)=-4.403985379361532e-1_p
w(2)=3.779420667068715e-1_p
x(3)=3.383226888340083e-1_p
w(3)=3.875416904655967e-1_p
x(4)=1.418448635198189_p
w(4)=2.400475745993209e-1_p
x(5)=2.812726558299743_p
w(5)=8.858463327722467e-2_p
x(6)=4.559387054261535_p
w(6)=2.004490100332959e-2_p
x(7)=6.692280230345889_p
w(7)=2.893980760465883e-3_p
x(8)=9.242441051147171_p
w(8)=2.683226919727132e-4_p
x(9)=12.25015678907598_p
w(9)=1.556745920355194e-5_p
x(10)=15.7728057864785_p
w(10)=5.374330557345694e-7_p
x(11)=19.89386093069952_p
w(11)=1.021666330742667e-8_p
x(12)=24.74053531489034_p
w(12)=9.485960457792133e-11_p
x(13)=30.52359483059938_p
w(13)=3.525042479655123e-13_p
x(14)=37.6463075936263_p
w(14)=3.590925401368079e-16_p
x(15)=47.14132447998269_p
w(15)=3.877164994571304e-20_p
else if(N==16)then
x(1)=-8.988961148321751e-1_p
w(1)=1.836873326710328e-1_p
x(2)=-4.758044237154717e-1_p
w(2)=3.595557000076985e-1_p
x(3)=2.561353408742535e-1_p
w(3)=3.822495453464758e-1_p
x(4)=1.272091508426079_p
w(4)=2.533047605144738e-1_p
x(5)=2.579166654761371_p
w(5)=1.031293588997698e-1_p
x(6)=4.209741526465959_p
w(6)=2.638510615974319e-2_p
x(7)=6.194036480851649_p
w(7)=4.420150037954850e-3_p
x(8)=8.557516033537555_p
w(8)=4.921497713335690e-4_p
x(9)=11.33090602852305_p
w(9)=3.588410632176021e-5_p
x(10)=14.55664330240902_p
w(10)=1.653693471487087e-6_p
x(11)=18.29420606160937_p
w(11)=4.561012693462718e-8_p
x(12)=22.62918351362939_p
w(12)=6.946397035059951e-10_p
x(13)=27.69142469935632_p
w(13)=5.165291021375550e-12_p
x(14)=33.69563627128149_p
w(14)=1.530113651878590e-14_p
x(15)=41.05231647184506_p
w(15)=1.227514793339574e-17_p
x(16)=50.81269836015395_p
w(16)=1.011785483136970e-21_p
else if(N==17)then
x(1)=-9.050559981758302e-1_p
w(1)=1.728610598430222e-1_p
x(2)=-5.070838072881326e-1_p
w(2)=3.426671524035674e-1_p
x(3)=1.832840250231241e-1_p
w(3)=3.757987361520771e-1_p
x(4)=1.142481301318092_p
w(4)=2.640476206057937e-1_p
x(5)=2.373326638934221_p
w(5)=1.171988419092913e-1_p
x(6)=3.903109952299493_p
w(6)=3.340957559589156e-2_p
x(7)=5.759173926492903_p
w(7)=6.370900637343354e-3_p
x(8)=7.963198913258323_p
w(8)=8.299529121447372e-4_p
x(9)=10.53933216714149_p
w(9)=7.338834606823674e-5_p
x(10)=13.5199625477223_p
w(10)=4.295554040284807e-6_p
x(11)=16.94930395640382_p
w(11)=1.599368280732924e-7_p
x(12)=20.88848341414215_p
w(12)=3.577630746592141e-9_p
x(13)=25.42492966109191_p
w(13)=4.425650875427032e-11_p
x(14)=30.69091455115232_p
w(14)=2.669536113644145e-13_p
x(15)=36.90486005377125_p
w(15)=6.381193320584724e-16_p
x(16)=44.484168793686_p
w(16)=4.079985783984987e-19_p
x(17)=54.49792537276351_p
w(17)=2.599623172706327e-23_p
else
call GD(-1)
end if
end subroutine GF_m1

! [0kT;infkT]
subroutine GF_0(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=6.905392554041752e-1_p
w(1)=5.746633478970105e-1_p
x(2)=3.592384070408228_p
w(2)=1.184838326629348e-1_p
else if(N==3)then
x(1)=4.840534751554061e-1_p
w(1)=4.633605519204452e-1_p
x(2)=2.446744868967085_p
w(2)=2.207494135774719e-1_p
x(3)=6.424352261225516_p
w(3)=9.037215062028254e-3_p
else if(N==4)then
x(1)=3.712756620850277e-1_p
w(1)=3.825388156952151e-1_p
x(2)=1.875432820833205_p
w(2)=2.763012417698876e-1_p
x(3)=4.661471088260850_p
w(3)=3.382553344606828e-2_p
x(4)=9.507093662076505_p
w(4)=4.815896487743821e-4_p
else if(N==5)then
x(1)=3.004771004745241e-1_p
w(1)=3.238083464690713e-1_p
x(2)=1.524152872017077_p
w(2)=3.004808234726896e-1_p
x(3)=3.713704503646147_p
w(3)=6.559139578626215e-2_p
x(4)=7.189957524003015_p
w(4)=3.245451726705576e-3_p
x(5)=12.7395431732222_p
w(5)=2.116310521660557e-5_p
else if(N==6)then
x(1)=2.520174458196917e-1_p
w(1)=2.798766579655337e-1_p
x(2)=1.284314149366321_p
w(2)=3.068344174354263e-1_p
x(3)=3.102998171059898_p
w(3)=9.682968827815576e-2_p
x(4)=5.873789871207389_p
w(4)=9.367751308199846e-3_p
x(5)=9.929605296596467_p
w(5)=2.378441532483348e-4_p
x(6)=16.07238534570181_p
w(6)=8.214193813231147e-7_p
else if(N==7)then
x(1)=2.168233305172354e-1_p
w(1)=2.460173041548890e-1_p
x(2)=1.109593250256884_p
w(2)=3.035895698770797e-1_p
x(3)=2.671365693969538_p
w(3)=1.239653022750305e-1_p
x(4)=4.994839418054564_p
w(4)=1.857743335953853e-2_p
x(5)=8.269285176702109_p
w(5)=9.829610093600074e-4_p
x(6)=12.81824859636541_p
w(6)=1.458069672848966e-5_p
x(7)=19.47826877980403_p
w(7)=2.918731897329437e-8_p
else if(N==8)then
x(1)=1.901344747358959e-1_p
w(1)=2.192266547494495e-1_p
x(2)=9.764779476202812e-1_p
w(2)=2.953900683193310e-1_p
x(3)=2.348059740004623_p
w(3)=1.459472287884359e-1_p
x(4)=4.357744312104359_p
w(4)=2.993373149684017e-2_p
x(5)=7.129170219982503_p
w(5)=2.564945897484104e-3_p
x(6)=10.83820831903568_p
w(6)=8.376561104959234e-5_p
x(7)=15.81868805472317_p
w(7)=7.847271242337231e-7_p
x(8)=22.94014552113654_p
w(8)=9.702308405829972e-10_p
else if(N==9)then
x(1)=1.692176334349495e-1_p
w(1)=1.975514669429050e-1_p
x(2)=8.716448419223213e-1_p
w(2)=2.848149272192623e-1_p
x(3)=2.095919914044832_p
w(3)=1.629413743693064e-1_p
x(4)=3.871444549139930_p
w(4)=4.240317444163187e-2_p
x(5)=6.285160012270786_p
w(5)=5.147437279298788e-3_p
x(6)=9.449114143009451_p
w(6)=2.826433928762481e-4_p
x(7)=13.54047365083015_p
w(7)=6.118682320566103e-6_p
x(8)=18.90677834262067_p
w(8)=3.820173826214879e-8_p
x(9)=26.4465551425336_p
w(9)=3.060584517389215e-11_p
else if(N==10)then
x(1)=1.523935763598589e-1_p
w(1)=1.796818593186601e-1_p
x(2)=7.869403592271879e-1_p
w(2)=2.732916540455503e-1_p
x(3)=1.893320817998023_p
w(3)=1.755859710522999e-1_p
x(4)=3.486516058083401_p
w(4)=5.512470186086788e-2_p
x(5)=5.630201307150046_p
w(5)=8.737253435005771e-3_p
x(6)=8.403344459605853_p
w(6)=6.990323083359971e-4_p
x(7)=11.91484585682358_p
w(7)=2.631065415787850e-5_p
x(8)=16.3491709388166_p
w(8)=3.961677102784019e-7_p
x(9)=22.06577699881644_p
w(9)=1.716431779996861e-9_p
x(10)=29.98937490042952_p
w(10)=9.253522677688020e-13_p
else if(N==11)then
x(1)=1.385747378442940e-1_p
w(1)=1.647124596185756e-1_p
x(2)=7.170808382243067e-1_p
w(2)=2.616057689250482e-1_p
x(3)=1.726728853585884_p
w(3)=1.846308915722753e-1_p
x(4)=3.173429233501669_p
w(4)=6.747762704395904e-2_p
x(5)=5.104880356389756_p
w(5)=1.322609564367359e-2_p
x(6)=7.580631246985890_p
w(6)=1.412704959677264e-3_p
x(7)=10.67430672069099_p
w(7)=7.946631344137202e-5_p
x(8)=14.49871552104411_p
w(8)=2.143146050988891e-6_p
x(9)=19.24519259686949_p
w(9)=2.326500775314294e-8_p
x(10)=25.28352229712721_p
w(10)=7.220915732941059e-11_p
x(11)=33.56261367055433_p
w(11)=2.701061050019496e-14_p
else if(N==12)then
x(1)=1.270262753424029e-1_p
w(1)=1.520000238830440e-1_p
x(2)=6.584865938216736e-1_p
w(2)=2.501817487526245e-1_p
x(3)=1.587198672413710_p
w(3)=1.907829656912683e-1_p
x(4)=2.913311386299704_p
w(4)=7.906173787099657e-2_p
x(5)=4.672978572605234_p
w(5)=1.844157083709677e-2_p
x(6)=6.913204428829729_p
w(6)=2.481017134374080e-3_p
x(7)=9.687349591107623_p
w(7)=1.901195017269480e-4_p
x(8)=13.07071383562855_p
w(8)=7.839117874309118e-6_p
x(9)=17.18069423641608_p
w(9)=1.565081064762062e-7_p
x(10)=22.21438311037711_p
w(10)=1.259957690791670e-9_p
x(11)=28.55086639495061_p
w(11)=2.874824683596239e-12_p
x(12)=37.16171182861083_p
w(12)=7.653508235767676e-16_p
else if(N==13)then
x(1)=1.172341018310048e-1_p
w(1)=1.410762111497642e-1_p
x(2)=6.086441447662309e-1_p
w(2)=2.392391492940452e-1_p
x(3)=1.468559459638358_p
w(3)=1.946513897775082e-1_p
x(4)=2.693476208000259_p
w(4)=8.964971846235624e-2_p
x(5)=4.310928544363007_p
w(5)=2.418837612171095e-2_p
x(6)=6.359172528297489_p
w(6)=3.933551521492815e-3_p
x(7)=8.879024286051289_p
w(7)=3.860030342739448e-4_p
x(8)=11.92392146565029_p
w(8)=2.208283451679074e-5_p
x(9)=15.57240077218079_p
w(9)=6.878699011090878e-7_p
x(10)=19.94569845557895_p
w(10)=1.043054701830937e-8_p
x(11)=25.24591942776766_p
w(11)=6.371967305921315e-11_p
x(12)=31.86073577457862_p
w(12)=1.092006885081078e-13_p
x(13)=40.78310995749683_p
w(13)=2.114089657724995e-17_p
else if(N==14)then
x(1)=1.088279551691404e-1_p
w(1)=1.315925605666356e-1_p
x(2)=5.657359307176808e-1_p
w(2)=2.288805738177078e-1_p
x(3)=1.366405413254442_p
w(3)=1.967382499463331e-1_p
x(4)=2.505051688598354_p
w(4)=9.913844744896573e-2_p
x(5)=4.002633644072031_p
w(5)=3.027557543888319e-2_p
x(6)=5.890926112153244_p
w(6)=5.773367924256626e-3_p
x(7)=8.202511156759972_p
w(7)=6.944248563287938e-4_p
x(8)=10.97712765633433_p
w(8)=5.165572559321110e-5_p
x(9)=14.27048917140992_p
w(9)=2.269508204831061e-6_p
x(10)=18.16396757817548_p
w(10)=5.468095369785378e-8_p
x(11)=22.78203194614557_p
w(11)=6.430401985480557e-10_p
x(12)=28.33131809133604_p
w(12)=3.038534401047352e-12_p
x(13)=35.20753596275942_p
w(13)=3.982999083812457e-15_p
x(14)=44.42397040611259_p
w(14)=5.711860189500878e-19_p
else if(N==15)then
x(1)=1.015344947424082e-1_p
w(1)=1.232847930051944e-1_p
x(2)=5.284147334178626e-1_p
w(2)=2.191419693960622e-1_p
x(3)=1.277500608985740_p
w(3)=1.974473810321536e-1_p
x(4)=2.341631360175820_p
w(4)=1.075084928066252e-1_p
x(5)=3.736677838673561_p
w(5)=3.653196034048861e-2_p
x(6)=5.489384374387769_p
w(6)=7.981783672638808e-3_p
x(7)=7.626652177618869_p
w(7)=1.139263265855043e-3_p
x(8)=10.17917884716605_p
w(8)=1.052279928403015e-4_p
x(9)=13.18821869929745_p
w(9)=6.094811325272587e-6_p
x(10)=16.71169970119415_p
w(10)=2.102060824464642e-7_p
x(11)=20.83332592708516_p
w(11)=3.993479898278182e-9_p
x(12)=25.6804160618949_p
w(12)=3.706174790622195e-11_p
x(13)=31.46379247226527_p
w(13)=1.376768232920523e-13_p
x(14)=38.5867579870667_p
w(14)=1.402123870626300e-16_p
x(15)=48.08199052039756_p
w(15)=1.513547476275949e-20_p
else if(N==16)then
x(1)=9.514760195581037e-2_p
w(1)=1.159490407982464e-1_p
x(2)=4.956606748446008e-1_p
w(2)=2.100217560670347e-1_p
x(3)=1.199411336587502_p
w(3)=1.970991379895803e-1_p
x(4)=2.198464642407805_p
w(4)=1.147935229246652e-1_p
x(5)=3.504715741318919_p
w(5)=4.281293865813461e-2_p
x(6)=5.140866880105158_p
w(6)=1.052434095775765e-2_p
x(7)=7.129720645858495_p
w(7)=1.739006003613811e-3_p
x(8)=9.495767399383292_p
w(8)=1.927463155380731e-4_p
x(9)=12.27058743918371_p
w(9)=1.402702794217669e-5_p
x(10)=15.49720938515852_p
w(10)=6.457464349313414e-7_p
x(11)=19.23537257091838_p
w(11)=1.779804416729033e-8_p
x(12)=23.57078337207755_p
w(12)=2.709334507714500e-10_p
x(13)=28.63335157066905_p
w(13)=2.013927684770142e-12_p
x(14)=34.63781951229616_p
w(14)=5.964222600825111e-15_p
x(15)=41.99470904507229_p
w(15)=4.783666887739649e-18_p
x(16)=51.75527330299429_p
w(16)=3.942211078905222e-22_p
else if(N==17)then
x(1)=8.950895482544206e-2_p
w(1)=1.094256411339050e-1_p
x(2)=4.666874727997759e-1_p
w(2)=2.014978600488022e-1_p
x(3)=1.130269941213794_p
w(3)=1.959456614777226e-1_p
x(4)=2.071948969684054_p
w(4)=1.210584994219921e-1_p
x(5)=3.300492343911909_p
w(5)=4.900206004059156e-2_p
x(6)=4.835272010755396_p
w(6)=1.335656028278536e-2_p
x(7)=6.696009543592456_p
w(7)=2.505836088754779e-3_p
x(8)=8.902796769665928_p
w(8)=3.246760433668300e-4_p
x(9)=11.48047241627778_p
w(9)=2.864742435443103e-5_p
x(10)=14.46204383146127_p
w(10)=1.674871630331007e-6_p
x(11)=17.89201672044946_p
w(11)=6.231547361836524e-8_p
x(12)=21.83164841807303_p
w(12)=1.393233922578766e-9_p
x(13)=26.36843349333713_p
w(13)=1.722840332271432e-11_p
x(14)=31.63468149418602_p
w(14)=1.038917042059309e-13_p
x(15)=37.84883814183487_p
w(15)=2.482845129747591e-16_p
x(16)=45.4283227676358_p
w(16)=1.587179743967912e-19_p
x(17)=55.44223538443698_p
w(17)=1.011130648651416e-23_p
else
call GD(0)
end if
end subroutine GF_0

! [1kT;infkT]
subroutine GF_1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=1.631825457147633_p
w(1)=2.640326502502725e-1_p
x(2)=4.490327172598123_p
w(2)=4.922903726795031e-2_p
else if(N==3)then
x(1)=1.446129770198734_p
w(1)=2.168209748212968e-1_p
x(2)=3.359537308471753_p
w(2)=9.283914357047311e-2_p
x(3)=7.347311682333117_p
w(3)=3.601569126452891e-3_p
else if(N==4)then
x(1)=1.344410627263788_p
w(1)=1.816945187097640e-1_p
x(2)=2.801542066030032_p
w(2)=1.178919783683790e-1_p
x(3)=5.589749957979830_p
w(3)=1.348615847299144e-2_p
x(4)=10.44295141644978_p
w(4)=1.890319670883401e-4_p
else if(N==5)then
x(1)=1.280244368915715_p
w(1)=1.556327068119685e-1_p
x(2)=2.461333257637843_p
w(2)=1.300826665044902e-1_p
x(3)=4.646266205134497_p
w(3)=2.626853870868262e-2_p
x(4)=8.130233969265630_p
w(4)=1.269535195894290e-3_p
x(5)=13.68303339164334_p
w(5)=8.240297187269972e-6_p
else if(N==6)then
x(1)=1.236106939096659_p
w(1)=1.358031882872357e-1_p
x(2)=2.230465782213953_p
w(2)=1.346609004494306e-1_p
x(3)=4.039605211255465_p
w(3)=3.904513391903808e-2_p
x(4)=6.817136815938837_p
w(4)=3.659861191043489e-3_p
x(5)=10.87683006080952_p
w(5)=9.228556483241816e-5_p
x(6)=17.02117190735555_p
w(6)=3.181066425819039e-7_p
else if(N==7)then
x(1)=1.203904985640319_p
w(1)=1.203051554269644e-1_p
x(2)=2.062987690895406_p
w(2)=1.349126990140938e-1_p
x(3)=3.611929318751232_p
w(3)=5.039601491048983e-2_p
x(4)=5.940505504576837_p
w(4)=7.261712187509977e-3_p
x(5)=9.219332615218041_p
w(5)=3.804650611132524e-4_p
x(6)=13.77012293571594_p
w(6)=5.629660540283936e-6_p
x(7)=20.43105126595995_p
w(7)=1.125751128597015e-8_p
else if(N==8)then
x(1)=1.179384458364056_p
w(1)=1.078995778025939e-1_p
x(2)=1.935751277265470_p
w(2)=1.327585957802792e-1_p
x(3)=3.292458449811021_p
w(3)=5.985641324145288e-2_p
x(4)=5.305339658128823_p
w(4)=1.172328923880719e-2_p
x(5)=8.081389357471338_p
w(5)=9.912435521841735e-4_p
x(6)=11.79256282332997_p
w(6)=3.226562701851471e-5_p
x(7)=16.77404531282744_p
w(7)=3.019028642939500e-7_p
x(8)=23.89609487559465_p
w(8)=3.730227669891089e-10_p
else if(N==9)then
x(1)=1.160096147612447_p
w(1)=9.776423787597080e-2_p
x(2)=1.835732869997467_p
w(2)=1.293098520758114e-1_p
x(3)=3.043974353313172_p
w(3)=6.743157061765180e-2_p
x(4)=4.820780150912666_p
w(4)=1.665727207745995e-2_p
x(5)=7.239091801372807_p
w(5)=1.987722351450495e-3_p
x(6)=10.40548472343024_p
w(6)=1.086687802250866e-4_p
x(7)=14.49797405132223_p
w(7)=2.349072190819031e-6_p
x(8)=19.8649078150593_p
w(8)=1.465572624072739e-8_p
x(9)=27.40509941979979_p
w(9)=1.173627886776425e-11_p
else if(N==10)then
x(1)=1.144530812733780_p
w(1)=8.933843382835734e-2_p
x(2)=1.755011534897136_p
w(2)=1.252121061736947e-1_p
x(3)=2.844809960886372_p
w(3)=7.331979499485602e-2_p
x(4)=4.437506058977834_p
w(4)=2.173904909683783e-2_p
x(5)=6.585526747756972_p
w(5)=3.373692854851474e-3_p
x(6)=9.361372839917882_p
w(6)=2.683746983951595e-4_p
x(7)=12.87414959116489_p
w(7)=1.008350626911651e-5_p
x(8)=17.30915882514746_p
w(8)=1.517076368531481e-7_p
x(9)=23.02619484044726_p
w(9)=6.569702625157694e-10_p
x(10)=30.95009818115675_p
w(10)=3.540644236824984e-13_p
else if(N==11)then
x(1)=1.131708020045589_p
w(1)=8.222909694548738e-2_p
x(2)=1.688480843772763_p
w(2)=1.208422552811536e-1_p
x(3)=2.681411069530446_p
w(3)=7.777604400328791e-2_p
x(4)=4.126035124891367_p
w(4)=2.673148338719774e-2_p
x(5)=6.061382008798081_p
w(5)=5.109768012095561e-3_p
x(6)=8.540037609223283_p
w(6)=5.418007458411510e-4_p
x(7)=11.6351439793436_p
w(7)=3.041082082501006e-5_p
x(8)=15.46030194185222_p
w(8)=8.194043001950059e-7_p
x(9)=20.20723608349648_p
w(9)=8.890439583069598e-9_p
x(10)=26.24587683780739_p
w(10)=2.758440293881416e-11_p
x(11)=34.52520161824585_p
w(11)=1.031565505874829e-14_p
else if(N==12)then
x(1)=1.120963361531172_p
w(1)=7.615355128545444e-2_p
x(2)=1.632695779808703_p
w(2)=1.164201470400979e-1_p
x(3)=2.544828192604971_p
w(3)=8.105105605378533e-2_p
x(4)=3.867511931019000_p
w(4)=3.147771327378453e-2_p
x(5)=5.630511510350205_p
w(5)=7.132645671571423e-3_p
x(6)=7.873769228424456_p
w(6)=9.508531512809259e-4_p
x(7)=10.64950229572174_p
w(7)=7.266771299970772e-5_p
x(8)=14.03368862492925_p
w(8)=2.993123762985969e-6_p
x(9)=18.14415838031072_p
w(9)=5.972376167591018e-8_p
x(10)=23.17817294556086_p
w(10)=4.806273127509273e-10_p
x(11)=29.51489068943418_p
w(11)=1.096359995651083e-12_p
x(12)=38.12591971469993_p
w(12)=2.918215713591543e-16_p
else if(N==13)then
x(1)=1.111830718702915_p
w(1)=7.090379901940640e-2_p
x(2)=1.585245657785080_p
w(2)=1.120725724253825e-1_p
x(3)=2.428897188478961_p
w(3)=8.336770990717048e-2_p
x(4)=3.649252346974097_p
w(4)=3.588412902000854e-2_p
x(5)=5.269398546209541_p
w(5)=9.370424072639416e-3_p
x(6)=7.320723718302037_p
w(6)=1.506975509206342e-3_p
x(7)=9.842313490077471_p
w(7)=1.473896823571272e-4_p
x(8)=12.88811220569236_p
w(8)=8.421715250086878e-6_p
x(9)=16.53711689632826_p
w(9)=2.621686293425533e-7_p
x(10)=20.91075823347651_p
w(10)=3.973861378351321e-9_p
x(11)=26.21122197282972_p
w(11)=2.426964004057320e-11_p
x(12)=32.82622068507959_p
w(12)=4.158435210687702e-14_p
x(13)=41.74874266854479_p
w(13)=8.049334778262508e-18_p
else if(N==14)then
x(1)=1.103973486089625_p
w(1)=6.632364114556119e-2_p
x(2)=1.544392005882057_p
w(2)=1.078705222263859e-1_p
x(3)=2.329225223256199_p
w(3)=8.491468767514575e-2_p
x(4)=3.462379817362143_p
w(4)=3.990303435373736e-2_p
x(5)=4.961981080845175_p
w(5)=1.175261632870806e-2_p
x(6)=6.853329549996070_p
w(6)=2.211681683071360e-3_p
x(7)=9.166788449313252_p
w(7)=2.649393268414414e-4_p
x(8)=11.94239075428618_p
w(8)=1.967968765124483e-5_p
x(9)=15.23631706407013_p
w(9)=8.640361307923302e-7_p
x(10)=19.13015904770709_p
w(10)=2.080918819762618e-8_p
x(11)=23.74847698286029_p
w(11)=2.446441993037409e-10_p
x(12)=29.29795029535154_p
w(12)=1.155773405465745e-12_p
x(13)=36.17431360147533_p
w(13)=1.514786078108285e-15_p
x(14)=45.39086932578818_p
w(14)=2.172016811566946e-19_p
else if(N==15)then
x(1)=1.097142548658342_p
w(1)=6.229363529359060e-2_p
x(2)=1.508849023324746_p
w(2)=1.038512514072469e-1_p
x(3)=2.242592503122460_p
w(3)=8.584761837550219e-2_p
x(4)=3.300481076537485_p
w(4)=4.351823493146953e-2_p
x(5)=4.696865992236480_p
w(5)=1.421572753569841e-2_p
x(6)=6.452536258143514_p
w(6)=3.058388884863591e-3_p
x(7)=8.591793672208789_p
w(7)=4.343778345585383e-4_p
x(8)=11.14539310732393_p
w(8)=4.005367538200040e-5_p
x(9)=14.15504039067419_p
w(9)=2.318132949087763e-6_p
x(10)=17.67890646094952_p
w(10)=7.991505876450381e-8_p
x(11)=21.80079832644351_p
w(11)=1.517768116346525e-9_p
x(12)=26.64808244878951_p
w(12)=1.408275285315510e-11_p
x(13)=32.43160703760337_p
w(13)=5.230621131029297e-14_p
x(14)=39.55469092619757_p
w(14)=5.326283364834755e-17_p
x(15)=49.05002458388863_p
w(15)=5.748941280364384e-21_p
else if(N==16)then
x(1)=1.091149614938640_p
w(1)=5.872096275593369e-2_p
x(2)=1.477644994779333_p
w(2)=1.000315569394808e-1_p
x(3)=2.166582595843798_p
w(3)=8.629302846622064e-2_p
x(4)=3.158798738914707_p
w(4)=4.673411261706234e-2_p
x(5)=4.465722500680142_p
w(5)=1.670573408762656e-2_p
x(6)=6.104687621589759_p
w(6)=4.034664320809328e-3_p
x(7)=8.095622609997658_p
w(7)=6.627362886213111e-4_p
x(8)=10.46282939206236_p
w(8)=7.330942292623787e-5_p
x(9)=13.23830250159561_p
w(9)=5.330482966275387e-6_p
x(10)=16.46533249074774_p
w(10)=2.452748326235921e-7_p
x(11)=20.20377424639546_p
w(11)=6.758122754164373e-9_p
x(12)=24.53938681479589_p
w(12)=1.028536366549980e-10_p
x(13)=29.60210763483169_p
w(13)=7.644147745905128e-13_p
x(14)=35.6066954366253_p
w(14)=2.263515425319883e-15_p
x(15)=42.96368297005754_p
w(15)=1.815288378228604e-18_p
x(16)=52.72433270022925_p
w(16)=1.495842215399052e-22_p
else if(N==17)then
x(1)=1.085849737726306_p
w(1)=5.553244849785476e-2_p
x(2)=1.450031775500649_p
w(2)=9.641587972054798e-2_p
x(3)=2.099345049160424_p
w(3)=8.635296561049692e-2_p
x(4)=3.033724436993589_p
w(4)=4.956776780414940e-2_p
x(5)=4.262304419855115_p
w(5)=1.917863380006429e-2_p
x(6)=5.799701219280963_p
w(6)=5.124365622778747e-3_p
x(7)=7.662585079210328_p
w(7)=9.546834350326389e-4_p
x(8)=9.870617458786562_p
w(8)=1.234052139351636e-4_p
x(9)=12.44899443308057_p
w(9)=1.087798709578606e-5_p
x(10)=15.43099836206934_p
w(10)=6.356491185657155e-7_p
x(11)=18.8612634653133_p
w(11)=2.364211451957453e-8_p
x(12)=22.80110528309696_p
w(12)=5.284608648244445e-10_p
x(13)=27.33804820611652_p
w(13)=6.533697397276202e-12_p
x(14)=32.60441901605714_p
w(14)=3.939467770554742e-14_p
x(15)=38.81867436101819_p
w(15)=9.413710111115469e-17_p
x(16)=46.39824129788396_p
w(16)=6.017273390493764e-20_p
x(17)=56.4122270082702_p
w(17)=3.833079647132000e-24_p
else
call GD(1)
end if
end subroutine GF_1

! [2kT;infkT]
subroutine GF_2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=2.604167183757946_p
w(1)=1.077990760637123e-1_p
x(2)=5.444197002537470_p
w(2)=1.912893497926020e-2_p
else if(N==3)then
x(1)=2.427959798575556_p
w(1)=8.929229892218352e-2_p
x(2)=4.320004818778931_p
w(2)=3.626216334939591e-2_p
x(3)=8.312536492313045_p
w(3)=1.373548771393071e-3_p
else if(N==4)then
x(1)=2.331363065401635_p
w(1)=7.537002832017947e-2_p
x(2)=3.767797750350079_p
w(2)=4.634390542961134e-2_p
x(3)=6.557513466350604_p
w(3)=5.142468686773940e-3_p
x(4)=11.41393881959208_p
w(4)=7.160860640774651e-5_p
else if(N==5)then
x(1)=2.270311610079028_p
w(1)=6.493878441001875e-2_p
x(2)=3.432389196057478_p
w(2)=5.147291798541093e-2_p
x(3)=5.616011515544880_p
w(3)=1.003308004038921e-2_p
x(4)=9.103299324639670_p
w(4)=4.801182599692678e-4_p
x(5)=14.65744805016286_p
w(5)=3.110347184336294e-6_p
else if(N==6)then
x(1)=2.228228116104285_p
w(1)=5.693640428691236e-2_p
x(2)=3.205430371603062_p
w(2)=5.361990880403181e-2_p
x(3)=5.011153949204796_p
w(3)=1.495369560255635e-2_p
x(4)=7.791660599132540_p
w(4)=1.383105794048266e-3_p
x(5)=11.85297509986655_p
w(5)=3.477677685874437e-5_p
x(6)=17.9979725593116_p
w(6)=1.197785649633325e-7_p
else if(N==7)then
x(1)=2.197462222157174_p
w(1)=5.063880081841453e-2_p
x(2)=3.041132278656752_p
w(2)=5.403374976991079e-2_p
x(3)=4.585196649846221_p
w(3)=1.936573931420941e-2_p
x(4)=6.916133137458679_p
w(4)=2.744392750696529e-3_p
x(5)=10.19679278929976_p
w(5)=1.432073261981279e-4_p
x(6)=14.74834545343288_p
w(6)=2.116832422112686e-6_p
x(7)=21.40965509031545_p
w(7)=4.231121004054822e-9_p
else if(N==8)then
x(1)=2.173991143106510_p
w(1)=4.556843101009667e-2_p
x(2)=2.916499542657732_p
w(2)=5.345488957306401e-2_p
x(3)=4.267367215475987_p
w(3)=2.308625427645942e-2_p
x(4)=6.281876027396669_p
w(4)=4.433387361655760e-3_p
x(5)=9.059869105002445_p
w(5)=3.728163385490518e-4_p
x(6)=12.77192946675603_p
w(6)=1.211900537379581e-5_p
x(7)=17.75383114277978_p
w(7)=1.133377757943168e-7_p
x(8)=24.87612921562634_p
w(8)=1.399980000475311e-10_p
else if(N==9)then
x(1)=2.155496708457618_p
w(1)=4.140535901473420e-2_p
x(2)=2.818632361412937_p
w(2)=5.231904760694379e-2_p
x(3)=4.020436760190826_p
w(3)=2.610832539734941e-2_p
x(4)=5.798120151721728_p
w(4)=6.306337423498786e-3_p
x(5)=8.218381675092825_p
w(5)=7.472744878751244e-4_p
x(6)=11.38578458149232_p
w(6)=4.078059502397447e-5_p
x(7)=15.47874416864005_p
w(7)=8.810181885384596e-7_p
x(8)=20.84594113617331_p
w(8)=5.494959166876677e-9_p
x(9)=28.38630673852454_p
w(9)=4.399511300145134e-12_p
else if(N==10)then
x(1)=2.140548799167912_p
w(1)=3.792964489882648e-2_p
x(2)=2.739705961209696_p
w(2)=5.088440474484408e-2_p
x(3)=3.822728818760103_p
w(3)=2.849873841084468e-2_p
x(4)=5.415592864654275_p
w(4)=8.242596969895630e-3_p
x(5)=7.565479209433001_p
w(5)=1.268144551094684e-3_p
x(6)=10.34244362722613_p
w(6)=1.006456224383602e-4_p
x(7)=13.85574906643519_p
w(7)=3.778765982020367e-6_p
x(8)=18.29104365425896_p
w(8)=5.683284876807739e-8_p
x(9)=24.00825958949367_p
w(9)=2.460651929143673e-10_p
x(10)=31.93229097531508_p
w(10)=1.325947783205479e-13_p
else if(N==11)then
x(1)=2.128217242207024_p
w(1)=3.498603450482291e-2_p
x(2)=2.674687520106045_p
w(2)=4.930522584139656e-2_p
x(3)=3.660684980718251_p
w(3)=3.034735467993536e-2_p
x(4)=5.104836271364089_p
w(4)=1.015365637763333e-2_p
x(5)=7.041894061282068_p
w(5)=1.920959770559078e-3_p
x(6)=9.521752701664351_p
w(6)=2.030811352829479e-4_p
x(7)=12.61745018381991_p
w(7)=1.138865091867864e-5_p
x(8)=16.44291962344799_p
w(8)=3.067446777729808e-7_p
x(9)=21.19004458509064_p
w(9)=3.327419482130404e-9_p
x(10)=27.22881548469999_p
w(10)=1.032251920019247e-11_p
x(11)=35.50823805722698_p
w(11)=3.859875549614891e-15_p
else if(N==12)then
x(1)=2.117870908201984_p
w(1)=3.246220273959290e-2_p
x(2)=2.620188328384834_p
w(2)=4.767409600222394e-2_p
x(3)=3.525356201748456_p
w(3)=3.174423670780796e-2_p
x(4)=4.847006138575543_p
w(4)=1.198045555261701e-2_p
x(5)=6.611511940256212_p
w(5)=2.682404730646144e-3_p
x(6)=8.856029082485087_p
w(6)=3.562749393739243e-4_p
x(7)=11.6324163744062_p
w(7)=2.719807266492540e-5_p
x(8)=15.01694341669643_p
w(8)=1.119779490590805e-6_p
x(9)=19.12761699722076_p
w(9)=2.233840386193687e-8_p
x(10)=24.16176758075082_p
w(10)=1.797411604460484e-10_p
x(11)=30.49858339741751_p
w(11)=4.099642544382726e-13_p
x(12)=39.10968930240404_p
w(12)=1.091125289562045e-16_p
else if(N==13)then
x(1)=2.109066486772597_p
w(1)=3.027506029300914e-2_p
x(2)=2.573841008824670_p
w(2)=4.604641639158882e-2_p
x(3)=3.410581989010161_p
w(3)=3.277049047501436e-2_p
x(4)=4.629422571269727_p
w(4)=1.368714918255022e-2_p
x(5)=6.250838529541559_p
w(5)=3.525986431873108e-3_p
x(6)=8.303449900341318_p
w(6)=5.645210331152620e-4_p
x(7)=10.82575449370919_p
w(7)=5.513874025208245e-5_p
x(8)=13.87192571060391_p
w(8)=3.148998085608541e-6_p
x(9)=17.52114871616296_p
w(9)=9.800314125573227e-8_p
x(10)=21.89493331517639_p
w(10)=1.485257172982489e-9_p
x(11)=27.19549844724479_p
w(11)=9.069929581410528e-12_p
x(12)=33.81057341904142_p
w(12)=1.553942279484815e-14_p
x(13)=42.73315726425659_p
w(13)=3.007713645100045e-18_p
else if(N==14)then
x(1)=2.101483467109804_p
w(1)=2.836191630154691e-2_p
x(2)=2.533940671994059_p
w(2)=4.445485456021889e-2_p
x(3)=3.311975057475479_p
w(3)=3.349554180432016e-2_p
x(4)=4.443209811422312_p
w(4)=1.525478813150826e-2_p
x(5)=5.943827324570010_p
w(5)=4.425720563501691e-3_p
x(6)=7.836460324487856_p
w(6)=8.284285975559549e-4_p
x(7)=10.15068932061175_p
w(7)=9.907537232258721e-5_p
x(8)=12.92669780122612_p
w(8)=7.355016899458846e-6_p
x(9)=16.22085823762439_p
w(9)=3.228297003920107e-7_p
x(10)=20.11485151747254_p
w(10)=7.773586144689158e-9_p
x(11)=24.73327520054348_p
w(11)=9.137980600663726e-11_p
x(12)=30.28282667863103_p
w(12)=4.316692907051264e-13_p
x(13)=37.15925078218692_p
w(13)=5.657200513132989e-16_p
x(14)=46.37585724560678_p
w(14)=8.111295785660345e-20_p
else if(N==15)then
x(1)=2.094884378812865_p
w(1)=2.667463050771931e-2_p
x(2)=2.499227800169955_p
w(2)=4.291802441637896e-2_p
x(3)=3.226322106555470_p
w(3)=3.397724844834713e-2_p
x(4)=4.281953875925048_p
w(4)=1.667607934515250e-2_p
x(5)=5.679095788789033_p
w(5)=5.358172418648751e-3_p
x(6)=7.436023175443120_p
w(6)=1.145609946480484e-3_p
x(7)=9.576098432126917_p
w(7)=1.623865195652016e-4_p
x(8)=12.13013878762318_p
w(8)=1.496329212665650e-5_p
x(9)=15.14003726121159_p
w(9)=8.657368579404555e-7_p
x(10)=18.66406328162769_p
w(10)=2.983976426106656e-8_p
x(11)=22.7860657709008_p
w(11)=5.666544678894614e-10_p
x(12)=27.63343080658401_p
w(12)=5.257290509591858e-12_p
x(13)=33.41701726975307_p
w(13)=1.952534775894327e-14_p
x(14)=40.54015062802455_p
w(14)=1.988140121909904e-17_p
x(15)=50.03552657450839_p
w(15)=2.145810343048945e-21_p
else if(N==16)then
x(1)=2.089089539728724_p
w(1)=2.517565137505315e-2_p
x(2)=2.468751445736048_p
w(2)=4.144579015020391e-2_p
x(3)=3.151213507345833_p
w(3)=3.426312384429561e-2_p
x(4)=4.140896162460901_p
w(4)=1.795141429192757e-2_p
x(5)=5.448320208485168_p
w(5)=6.303358104291060e-3_p
x(6)=7.088492805318612_p
w(6)=1.511516994065375e-3_p
x(7)=9.080284312907589_p
w(7)=2.476951831740271e-4_p
x(8)=11.44796692102575_p
w(8)=2.737705106004491e-5_p
x(9)=14.2237094460309_p
w(9)=1.989942050620465e-6_p
x(10)=17.45090861709747_p
w(10)=9.154612113816486e-8_p
x(11)=21.18946621658074_p
w(11)=2.522063543021801e-9_p
x(12)=25.52516284233871_p
w(12)=3.838038236696373e-11_p
x(13)=30.5879473235679_p
w(13)=2.852257723930819e-13_p
x(14)=36.59258516629779_p
w(14)=8.445394612479866e-16_p
x(15)=43.9496136429925_p
w(15)=6.772723591954544e-19_p
x(16)=53.71029910271984_p
w(16)=5.580682272642912e-23_p
else if(N==17)then
x(1)=2.083960489474742_p
w(1)=2.383527301637595e-2_p
x(2)=2.441780029132626_p
w(2)=4.004255703493441e-2_p
x(3)=3.084805527505249_p
w(3)=3.439187440885615e-2_p
x(4)=4.016427094000594_p
w(4)=1.908600789229957e-2_p
x(5)=5.245258991938815_p
w(5)=7.244941197712563e-3_p
x(6)=6.783795181382604_p
w(6)=1.920234093837691e-3_p
x(7)=8.647564267111969_p
w(7)=3.567472575271681e-4_p
x(8)=10.85610661371349_p
w(8)=4.607051959658207e-5_p
x(9)=13.43477224240858_p
w(9)=4.059442573105106e-6_p
x(10)=16.41695516328348_p
w(10)=2.371600624810172e-7_p
x(11)=19.84734161166365_p
w(11)=8.819623508918393e-9_p
x(12)=23.78727086409174_p
w(12)=1.971216334487823e-10_p
x(13)=28.32427956038993_p
w(13)=2.436965113300854e-12_p
x(14)=33.59070159405694_p
w(14)=1.469277909219673e-14_p
x(15)=39.80499813673207_p
w(15)=3.510817306523202e-17_p
x(16)=47.38459945207035_p
w(16)=2.244044518238012e-20_p
x(17)=57.39861570652735_p
w(17)=1.429439413608321e-24_p
else
call GD(2)
end if
end subroutine GF_2

! [3kT;infkT]
subroutine GF_3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=3.592777482481761_p
w(1)=4.139326979111708e-2_p
x(2)=6.425554897065060_p
w(2)=7.194081782624971e-3_p
else if(N==3)then
x(1)=3.420419578026696_p
w(1)=3.440930298480709e-2_p
x(2)=5.304013104946703_p
w(2)=1.366534910583379e-2_p
x(3)=9.298489428375097_p
w(3)=5.126994831011750e-4_p
else if(N==4)then
x(1)=3.325914347303423_p
w(1)=2.913198180995831e-2_p
x(2)=4.754105684656246_p
w(2)=1.750944830184729e-2_p
x(3)=7.544517698839821_p
w(3)=1.919264317268226e-3_p
x(4)=12.40220885070952_p
w(4)=2.665714466823139e-5_p
else if(N==5)then
x(1)=3.266142562895556_p
w(1)=2.516203837161066e-2_p
x(2)=4.420600245752952_p
w(2)=1.949879018741334e-2_p
x(3)=6.603826710378993_p
w(3)=3.746761912953112e-3_p
x(4)=10.09242385850943_p
w(4)=1.786049153380387e-4_p
x(5)=15.6470994130527_p
w(5)=1.156186426907988e-6_p
else if(N==6)then
x(1)=3.224907467409672_p
w(1)=2.210605152435183e-2_p
x(2)=4.195193239226616_p
w(2)=2.036389570729541e-2_p
x(3)=5.999695646727879_p
w(3)=5.590087193796250e-3_p
x(4)=8.781387366143313_p
w(4)=5.143540177987547e-4_p
x(5)=12.84333355998581_p
w(5)=1.291864989284971e-5_p
x(6)=18.98858696389288_p
w(6)=4.448060695499855e-8_p
else if(N==7)then
x(1)=3.194737504400996_p
w(1)=1.969414075538954e-2_p
x(2)=4.032161338348158_p
w(2)=2.056989706761946e-2_p
x(3)=5.574422499362289_p
w(3)=7.248779787786367e-3_p
x(4)=7.906316278711023_p
w(4)=1.020574552807710e-3_p
x(5)=11.18768986565015_p
w(5)=5.317218409962793e-5_p
x(6)=15.73953933268312_p
w(6)=7.856559414237960e-7_p
x(7)=22.40099782781274_p
w(7)=1.570097930459758e-9_p
else if(N==8)then
x(1)=3.171703655418446_p
w(1)=1.774747590596954e-2_p
x(2)=3.908568951983391_p
w(2)=2.039409191163830e-2_p
x(3)=5.257241696211993_p
w(3)=8.653832237223562e-3_p
x(4)=7.272433528557709_p
w(4)=1.649033571018669e-3_p
x(5)=10.05118505024312_p
w(5)=1.383799464193231e-4_p
x(6)=13.76358995756068_p
w(6)=4.495911744121850e-6_p
x(7)=18.74565495255004_p
w(7)=4.203780790098878e-8_p
x(8)=25.86805001710151_p
w(8)=5.192063619202114e-11_p
else if(N==9)then
x(1)=3.153541110052763_p
w(1)=1.614577982068474e-2_p
x(2)=3.811564502539182_p
w(2)=2.000071973428951e-2_p
x(3)=5.010922692779316_p
w(3)=9.801432073054292e-3_p
x(4)=6.789006244741636_p
w(4)=2.346651806808376e-3_p
x(5)=9.210031478519275_p
w(5)=2.773160580994178e-4_p
x(6)=12.3778261945391_p
w(6)=1.512339443591519e-5_p
x(7)=16.47096863877549_p
w(7)=3.266476595601581e-7_p
x(8)=21.83826818490173_p
w(8)=2.037079397709989e-9_p
x(9)=29.3787016754275_p
w(9)=1.630855572386299e-12_p
else if(N==10)then
x(1)=3.138852096867737_p
w(1)=1.480609307442752e-2_p
x(2)=3.733360580643016_p
w(2)=1.948783738896570e-2_p
x(3)=4.813786895569073_p
w(3)=1.071524236247133e-2_p
x(4)=6.406781542641570_p
w(4)=3.068866008984038e-3_p
x(5)=8.557402675008353_p
w(5)=4.705772956252572e-4_p
x(6)=11.33480067902188_p
w(6)=3.731372978373501e-5_p
x(7)=14.84831131708381_p
w(7)=1.400560508183006e-6_p
x(8)=19.28371695719835_p
w(8)=2.106174476472109e-8_p
x(9)=25.00100301312996_p
w(9)=9.118239714820968e-11_p
x(10)=32.92508434190673_p
w(10)=4.913191678598642e-14_p
else if(N==11)then
x(1)=3.126727065760888_p
w(1)=1.366968656487091e-2_p
x(2)=3.668952984478016_p
w(2)=1.891455605270004e-2_p
x(3)=4.652275155473134_p
w(3)=1.142772116879230e-2_p
x(4)=6.096311831091350_p
w(4)=3.782936704756689e-3_p
x(5)=8.034048783727487_p
w(5)=7.128413983096925e-4_p
x(6)=10.51437396778257_p
w(6)=7.527488735592071e-5_p
x(7)=13.61030051253688_p
w(7)=4.219917018359063e-6_p
x(8)=17.43589099650412_p
w(8)=1.136434673648487e-7_p
x(9)=22.18309024729134_p
w(9)=1.232645581352173e-9_p
x(10)=28.22191186296971_p
w(10)=3.823773228654498e-12_p
x(11)=36.50137256700256_p
w(11)=1.429756052953779e-15_p
else if(N==12)then
x(1)=3.116548587180367_p
w(1)=1.269396308466115e-2_p
x(2)=3.614974940995369_p
w(2)=1.831673246959881e-2_p
x(3)=4.517439098842976_p
w(3)=1.197164533685451e-2_p
x(4)=5.838757925963275_p
w(4)=4.466950674183615e-3_p
x(5)=7.603868203230765_p
w(5)=9.955235551959397e-4_p
x(6)=9.848874266050666_p
w(6)=1.320378200681063e-4_p
x(7)=12.62551476013824_p
w(7)=1.007554030403995e-5_p
x(8)=16.01017401880815_p
w(8)=4.147530419259056e-7_p
x(9)=20.12092686720093_p
w(9)=8.273118172949891e-9_p
x(10)=25.15513041009295_p
w(10)=6.656393382820364e-11_p
x(11)=31.49198443854532_p
w(11)=1.518166481265812e-13_p
x(12)=40.1031203124655_p
w(12)=4.040491148440750e-17_p
else if(N==13)then
x(1)=3.107882768164613_p
w(1)=1.184734223193252e-2_p
x(2)=3.569075989269102_p
w(2)=1.771611148733355e-2_p
x(3)=4.403119905459755_p
w(3)=1.237668166877001e-2_p
x(4)=5.621442160024117_p
w(4)=5.107528229129483e-3_p
x(5)=7.243375579241824_p
w(5)=1.308868748909872e-3_p
x(6)=9.296487184255287_p
w(6)=2.091941022014954e-4_p
x(7)=11.81906819390493_p
w(7)=2.042217151796716e-5_p
x(8)=14.86538376352692_p
w(8)=1.166093165520775e-6_p
x(9)=18.51469158093371_p
w(9)=3.628750813194222e-8_p
x(10)=22.88853191337769_p
w(10)=5.499097944800237e-10_p
x(11)=28.18913652261747_p
w(11)=3.357955087075914e-12_p
x(12)=34.80424120210733_p
w(12)=5.752968145401771e-15_p
x(13)=43.7268491558621_p
w(13)=1.113480167531876e-18_p
else if(N==14)then
x(1)=3.100415761358047_p
w(1)=1.110594917602239e-2_p
x(2)=3.529564395547654_p
w(2)=1.712574640286623e-2_p
x(3)=4.304932556158708_p
w(3)=1.266833257462505e-2_p
x(4)=5.435489557290837_p
w(4)=5.697505225095722e-3_p
x(5)=6.936530663304787_p
w(5)=1.643308543201237e-3_p
x(6)=8.829664574279505_p
w(6)=3.069747886224050e-4_p
x(7)=11.14419122632296_p
w(7)=3.668936320145681e-5_p
x(8)=13.92035690855301_p
w(8)=2.723079191887023e-6_p
x(9)=17.21460820054421_p
w(9)=1.195093956125042e-7_p
x(10)=21.10866029117819_p
w(10)=2.877535704874063e-9_p
x(11)=25.7271251190674_p
w(11)=3.382436943741719e-11_p
x(12)=31.27670702881623_p
w(12)=1.597777440298316e-13_p
x(13)=38.15315481257046_p
w(13)=2.093898974514955e-16_p
x(14)=47.36978104522365_p
w(14)=3.002170460822529e-20_p
else if(N==15)then
x(1)=3.093914929328384_p
w(1)=1.045141768257969e-2_p
x(2)=3.495190969648343_p
w(2)=1.655327246607173e-2_p
x(3)=4.219666300175089_p
w(3)=1.286793506266515e-2_p
x(4)=5.274486231429704_p
w(4)=6.234013018622815e-3_p
x(5)=6.671955228211445_p
w(5)=1.990210419140642e-3_p
x(6)=8.429374559893459_p
w(6)=4.245055940313680e-4_p
x(7)=10.5697659139508_p
w(7)=6.012666309836359e-5_p
x(8)=13.12397672635341_p
w(8)=5.538980491384396e-6_p
x(9)=16.1339725708816_p
w(9)=3.204317054801222e-7_p
x(10)=19.6580607148358_p
w(10)=1.104367435838852e-8_p
x(11)=23.78010621755156_p
w(11)=2.097082802773619e-10_p
x(12)=28.62750273642902_p
w(12)=1.945558389426805e-12_p
x(13)=34.41111328646148_p
w(13)=7.225531843467786e-15_p
x(14)=41.53426590961458_p
w(14)=7.357142298554932e-18_p
x(15)=51.02965832932762_p
w(15)=7.940466138588236e-22_p
else if(N==16)then
x(1)=3.088204171184394_p
w(1)=9.869398128907849e-3_p
x(2)=3.465012949317233_p
w(2)=1.600291885212500e-2_p
x(3)=4.144914134078348_p
w(3)=1.299307872413702e-2_p
x(4)=5.133673400539460_p
w(4)=6.717023824178929e-3_p
x(5)=6.441328483979043_p
w(5)=2.342207630721952e-3_p
x(6)=8.081975708201528_p
w(6)=5.601161818791521e-4_p
x(7)=10.07409838253435_p
w(7)=9.170431384583882e-5_p
x(8)=12.44196476911248_p
w(8)=1.013268574717955e-5_p
x(9)=15.21781161727535_p
w(9)=7.364092358799221e-7_p
x(10)=18.44507644274188_p
w(10)=3.387544737653386e-8_p
x(11)=22.18367905599239_p
w(11)=9.332091076119410e-10_p
x(12)=26.51940837006189_p
w(12)=1.420092292832554e-11_p
x(13)=31.5822176213027_p
w(13)=1.055320524899626e-13_p
x(14)=37.58687494224691_p
w(14)=3.124687105619295e-16_p
x(15)=44.94391936082729_p
w(15)=2.505778243429054e-19_p
x(16)=54.70461873592418_p
w(16)=2.064715727033206e-23_p
else if(N==17)then
x(1)=3.083147730489466_p
w(1)=9.348522295793821e-3_p
x(2)=3.438305303695380_p
w(2)=1.547676489978579e-2_p
x(3)=4.078834896678162_p
w(3)=1.305814771023560e-2_p
x(4)=5.009441242529086_p
w(4)=7.148302462800354e-3_p
x(5)=6.238410786897129_p
w(5)=2.693270504091635e-3_p
x(6)=7.777397330755830_p
w(6)=7.116327273200940e-4_p
x(7)=9.641508944701229_p
w(7)=1.320686326012109e-4_p
x(8)=11.85024811210654_p
w(8)=1.704921952565860e-5_p
x(9)=14.42902539729253_p
w(9)=1.502040242895834e-6_p
x(10)=17.41127772086032_p
w(10)=8.774460085239374e-8_p
x(11)=20.84171129003582_p
w(11)=3.262912705565907e-9_p
x(12)=24.78167452571406_p
w(12)=7.292446824466369e-11_p
x(13)=29.31870880151145_p
w(13)=9.015216810369502e-13_p
x(14)=34.58515076496442_p
w(14)=5.435274910179990e-15_p
x(15)=40.79946334189039_p
w(15)=1.298728608231089e-17_p
x(16)=48.37907804095411_p
w(16)=8.301097956683270e-21_p
x(17)=58.39310618903319_p
w(17)=5.287671220113230e-25_p
else
call GD(3)
end if
end subroutine GF_3

! [4kT;infkT]
subroutine GF_4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=4.588391371578517_p
w(1)=1.548099378803193e-2_p
x(2)=7.418430488729950_p
w(2)=2.668934129777814e-3_p
else if(N==3)then
x(1)=4.417506835278497_p
w(1)=1.288667123597650e-2_p
x(2)=6.297899500714727_p
w(2)=5.073594964446512e-3_p
x(3)=10.29312191090159_p
w(3)=1.896617173867308e-4_p
else if(N==4)then
x(1)=4.323804125001076_p
w(1)=1.092298452478774e-2_p
x(2)=5.748865050012787_p
w(2)=6.507145111845759e-3_p
x(3)=8.539555921389839_p
w(3)=7.099471807270610e-4_p
x(4)=13.39772509672886_p
w(4)=9.851100449183233e-6_p
else if(N==5)then
x(1)=4.264524573694274_p
w(1)=9.443490859905536e-3_p
x(2)=5.416081304008356_p
w(2)=7.253774816467304e-3_p
x(3)=7.599176519875028_p
w(3)=1.386249915399743e-3_p
x(4)=11.08826894909748_p
w(4)=6.598529559652344e-5_p
x(5)=16.64314302132507_p
w(5)=4.270304406337071e-7_p
else if(N==6)then
x(1)=4.223616534547756_p
w(1)=8.303101502456002e-3_p
x(2)=5.191263021496387_p
w(2)=7.582988140726062e-3_p
x(3)=6.995322896324596_p
w(3)=2.069048354351840e-3_p
x(4)=9.777464592308254_p
w(4)=1.900033023177890e-4_p
x(5)=13.83964861050429_p
w(5)=4.770195488994089e-6_p
x(6)=19.98499845141024_p
w(6)=1.642246905256638e-8_p
else if(N==7)then
x(1)=4.193676736889514_p
w(1)=7.402051835574058e-3_p
x(2)=5.028711992398342_p
w(2)=7.666683674178906e-3_p
x(3)=6.570309769558416_p
w(3)=2.684274316508100e-3_p
x(4)=8.902569511077516_p
w(4)=3.769973766856853e-4_p
x(5)=12.18421185897266_p
w(5)=1.963013006823147e-5_p
x(6)=16.736173034703_p
w(6)=2.900052698362968e-7_p
x(7)=23.39768761687636_p
w(7)=5.795249230411888e-10_p
else if(N==8)then
x(1)=4.170812034587225_p
w(1)=6.674116260789474e-3_p
x(2)=4.905515232098844_p
w(2)=7.607553442365852e-3_p
x(3)=6.253374728727389_p
w(3)=3.206306898423448e-3_p
x(4)=8.268830952766885_p
w(4)=6.091957823417335e-4_p
x(5)=11.04786817113195_p
w(5)=5.108073402428521e-5_p
x(6)=14.76040264130745_p
w(6)=1.659267322992058e-6_p
x(7)=19.74252912191173_p
w(7)=1.551338225822102e-8_p
x(8)=26.86496072694327_p
w(8)=1.915969786497367e-11_p
else if(N==9)then
x(1)=4.152778066160002_p
w(1)=6.074686421593540e-3_p
x(2)=4.808839330480810_p
w(2)=7.466568541876027e-3_p
x(3)=6.007286989123551_p
w(3)=3.633568224089538e-3_p
x(4)=7.785529880497535_p
w(4)=8.670437308981192e-4_p
x(5)=10.20684318052355_p
w(5)=1.023590267259164e-4_p
x(6)=13.37478514599264_p
w(6)=5.580694478850987e-6_p
x(7)=17.46799637666217_p
w(7)=1.205259410349969e-7_p
x(8)=22.83533454536802_p
w(8)=7.516050083667545e-10_p
x(9)=30.37579360833984_p
w(9)=6.017069089245159e-13_p
else if(N==10)then
x(1)=4.138189476406565_p
w(1)=5.572955049142991e-3_p
x(2)=4.730910938084459_p
w(2)=7.280234037363104e-3_p
x(3)=5.810367396528386_p
w(3)=3.974637116751234e-3_p
x(4)=7.403420997824604_p
w(4)=1.134122077764423e-3_p
x(5)=9.554319866790241_p
w(5)=1.736874457281205e-4_p
x(6)=12.33188077793166_p
w(6)=1.376767599415097e-5_p
x(7)=15.84546854941127_p
w(7)=5.167114441150728e-7_p
x(8)=20.28091597834547_p
w(8)=7.769966037384805e-9_p
x(9)=25.99822843564899_p
w(9)=3.363744049283962e-11_p
x(10)=33.92232857455281_p
w(10)=1.812453115757491e-14_p
else if(N==11)then
x(1)=4.126144642695412_p
w(1)=5.147088674343997e-3_p
x(2)=4.666736622617665_p
w(2)=7.070628997894826e-3_p
x(3)=5.649056668477319_p
w(3)=4.241369381458555e-3_p
x(4)=7.093060717304805_p
w(4)=1.398362067210474e-3_p
x(5)=9.031055143298680_p
w(5)=2.631077980763891e-4_p
x(6)=11.51155562779995_p
w(6)=2.777192629911696e-5_p
x(7)=14.60756822060826_p
w(7)=1.556696526543469e-6_p
x(8)=18.43320422686212_p
w(8)=4.191991471382830e-8_p
x(9)=23.18043143628027_p
w(9)=4.546741883088784e-10_p
x(10)=29.2192721461624_p
w(10)=1.410409029634719e-12_p
x(11)=37.49874720987829_p
w(11)=5.273612280545280e-16_p
else if(N==12)then
x(1)=4.116031408743314_p
w(1)=4.781235658870366e-3_p
x(2)=4.612957870394703_p
w(2)=6.851199563849155e-3_p
x(3)=5.514406766956005_p
w(3)=4.445771534172049e-3_p
x(4)=6.835611860900147_p
w(4)=1.651676902140948e-3_p
x(5)=8.600952235607005_p
w(5)=3.674606491540958e-4_p
x(6)=10.84614207534423_p
w(6)=4.871109810931389e-5_p
x(7)=13.62287763677273_p
w(7)=3.716459629923566e-6_p
x(8)=17.00758659056667_p
w(8)=1.529759578373988e-7_p
x(9)=21.11836925843785_p
w(9)=3.051320247955183e-9_p
x(10)=26.15259273314047_p
w(10)=2.454979613921063e-11_p
x(11)=32.48946114700063_p
w(11)=5.599142499068957e-14_p
x(12)=41.10060830536519_p
w(12)=1.490153678853352e-17_p
else if(N==13)then
x(1)=4.107419510915247_p
w(1)=4.463633859226564e-3_p
x(2)=4.567230595259875_p
w(2)=6.630140076198747e-3_p
x(3)=5.400259546124237_p
w(3)=4.598731459198710e-3_p
x(4)=6.618397687648168_p
w(4)=1.889118253054746e-3_p
x(5)=8.240529202260312_p
w(5)=4.831559396665935e-4_p
x(6)=10.29382896471243_p
w(6)=7.717233764275216e-5_p
x(7)=12.81651372026188_p
w(7)=7.532345389313752e-6_p
x(8)=15.86288351639161_p
w(8)=4.300608898450047e-7_p
x(9)=19.51222322497793_p
w(9)=1.338250505718830e-8_p
x(10)=23.88608452618695_p
w(10)=2.027969572866543e-10_p
x(11)=29.18670399286824_p
w(11)=1.238333942028582e-12_p
x(12)=35.80181985542121_p
w(12)=2.121532248229395e-15_p
x(13)=44.72443688596331_p
w(13)=4.106161064160844e-19_p
else if(N==14)then
x(1)=4.099997672703980_p
w(1)=4.185384196771444e-3_p
x(2)=4.527868026247746_p
w(2)=6.412401390481058e-3_p
x(3)=5.302230861140174_p
w(3)=4.709623513196937e-3_p
x(4)=6.432543587496152_p
w(4)=2.108024297385946e-3_p
x(5)=7.933748182621161_p
w(5)=6.066722363640418e-4_p
x(6)=9.827070692459060_p
w(6)=1.132415759833525e-4_p
x(7)=12.14170903977425_p
w(7)=1.353135323114830e-5_p
x(8)=14.91793374477857_p
w(8)=1.004210224823790e-6_p
x(9)=18.21221918553704_p
w(9)=4.407054004958675e-8_p
x(10)=22.10629339535975_p
w(10)=1.061099327819282e-9_p
x(11)=26.72477370400309_p
w(11)=1.247261645386763e-11_p
x(12)=32.27436706647736_p
w(12)=5.891674489561023e-14_p
x(13)=39.15082376365038_p
w(13)=7.721008866990378e-17_p
x(14)=48.36745743860776_p
w(14)=1.107006752880331e-20_p
else if(N==15)then
x(1)=4.093535123198168_p
w(1)=3.939636094129949e-3_p
x(2)=4.493624873458277_p
w(2)=6.200906199892112e-3_p
x(3)=5.217110928662637_p
w(3)=4.786302433324217e-3_p
x(4)=6.271635767867186_p
w(4)=2.307314369369613e-3_p
x(5)=7.669232600729252_p
w(5)=7.348321979315897e-4_p
x(6)=9.426837399705960_p
w(6)=1.565977031491044e-4_p
x(7)=11.56734736445615_p
w(7)=2.217409738191733e-5_p
x(8)=14.12162214722951_p
w(8)=2.042517651054822e-6_p
x(9)=17.13165457325953_p
w(9)=1.181548421256871e-7_p
x(10)=20.65576607455909_p
w(10)=4.072094452847787e-9_p
x(11)=24.77782775672669_p
w(11)=7.732357987056774e-11_p
x(12)=29.62523612125607_p
w(12)=7.173564561451397e-13_p
x(13)=35.40885573580128_p
w(13)=2.664135608389006e-15_p
x(14)=42.53201560987999_p
w(14)=2.712641012296908e-18_p
x(15)=52.02741423051398_p
w(15)=2.927698441017195e-22_p
else if(N==16)then
x(1)=4.087857145902794_p
w(1)=3.721033789866416e-3_p
x(2)=4.463561469468163_p
w(2)=5.997297625535924e-3_p
x(3)=5.142493733356781_p
w(3)=4.835252701497998e-3_p
x(4)=6.130915424423178_p
w(4)=2.486954684405407e-3_p
x(5)=7.438662793588585_p
w(5)=8.649236831913581e-4_p
x(6)=9.079489256094961_p
w(6)=2.066265745429902e-4_p
x(7)=11.0717362103761_p
w(7)=3.381824784633303e-5_p
x(8)=13.43967154026332_p
w(8)=3.736247668776421e-6_p
x(9)=16.21555756479704_p
w(9)=2.715239430431410e-7_p
x(10)=19.44284706683832_p
w(10)=1.248996666667651e-8_p
x(11)=23.18146660746458_p
w(11)=3.440700581215264e-10_p
x(12)=27.51720821781268_p
w(12)=5.235746222236941e-12_p
x(13)=32.5800267887309_p
w(13)=3.890827869516049e-14_p
x(14)=38.58469143948113_p
w(14)=1.152021992207601e-16_p
x(15)=45.94174185785482_p
w(15)=9.238343778540371e-20_p
x(16)=55.7024464705862_p
w(16)=7.612185699902155e-24_p
else if(N==17)then
x(1)=4.082829030535089_p
w(1)=3.525331848132285e-3_p
x(2)=4.436955262290367_p
w(2)=5.802407723703149e-3_p
x(3)=5.076539077553138_p
w(3)=4.861784673205654e-3_p
x(4)=6.006772677852315_p
w(4)=2.647573297760093e-3_p
x(5)=7.235799874919820_p
w(5)=9.947258237244486e-4_p
x(6)=8.774956844685043_p
w(6)=2.625287693038792e-4_p
x(7)=10.63919703750996_p
w(7)=4.870212924607829e-5_p
x(8)=12.84801001865237_p
w(8)=6.286281570022739e-6_p
x(9)=15.42682921649167_p
w(9)=5.537912204234495e-7_p
x(10)=18.40910761655969_p
w(10)=3.234977460505029e-8_p
x(11)=21.83955890078095_p
w(11)=1.202949791030180e-9_p
x(12)=25.77953491702259_p
w(12)=2.688494420542487e-11_p
x(13)=30.31657881516849_p
w(13)=3.323590323922009e-13_p
x(14)=35.5830282769929_p
w(14)=2.003776723210810e-15_p
x(15)=41.79734688743438_p
w(15)=4.787882005363908e-18_p
x(16)=49.37696662318096_p
w(16)=3.060259624862077e-21_p
x(17)=59.39099924757192_p
w(17)=1.949329039614873e-25_p
else
call GD(4)
end if
end subroutine GF_4

! [5kT;infkT]
subroutine GF_5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=5.586749326513009_p
w(1)=5.730412731293692e-3_p
x(2)=8.415771069400188_p
w(2)=9.849357578243765e-4_p
else if(N==3)then
x(1)=5.416415084176649_p
w(1)=4.772553910177009e-3_p
x(2)=7.295617120048452_p
w(2)=1.872877208781131e-3_p
x(3)=11.29111841657932_p
w(3)=6.991737015992867e-5_p
else if(N==4)then
x(1)=5.323012394079078_p
w(1)=4.047075421657101e-3_p
x(2)=6.746907707739948_p
w(2)=2.402932330935080e-3_p
x(3)=9.537704451888931_p
w(3)=2.617105911692491e-4_p
x(4)=14.39605124868471_p
w(4)=3.630145356638063e-6_p
else if(N==5)then
x(1)=5.263917036178604_p
w(1)=3.500165209599780e-3_p
x(2)=6.414392560334878_p
w(2)=2.679653449020504e-3_p
x(3)=8.597441603646109_p
w(3)=5.110592851564178e-4_p
x(4)=12.08671817862579_p
w(4)=2.431321643899597e-5_p
x(5)=17.64166595365878_p
w(5)=1.573289023710174e-7_p
else if(N==6)then
x(1)=5.223131483765298_p
w(1)=3.078400031672386e-3_p
x(2)=6.189793418626479_p
w(2)=2.802289050780555e-3_p
x(3)=7.993691522709384_p
w(3)=7.628899941272090e-4_p
x(4)=10.77600075652079_p
w(4)=7.000607070416403e-5_p
x(5)=14.83827304086527_p
w(5)=1.757292225966444e-6_p
x(6)=20.98365868443629_p
w(6)=6.049607788452786e-9_p
else if(N==7)then
x(1)=5.193277948494432_p
w(1)=2.745013085549860e-3_p
x(2)=6.027421453476767_p
w(2)=2.834184226063070e-3_p
x(3)=7.568775260810138_p
w(3)=9.899104481376668e-4_p
x(4)=9.901171603162958_p
w(4)=1.389026521182730e-4_p
x(5)=13.18291369448373_p
w(5)=7.231042105885893e-6_p
x(6)=17.73491632505787_p
w(6)=1.068216839490809e-7_p
x(7)=24.39645172957954_p
w(7)=2.134593641336582e-10_p
else if(N==8)then
x(1)=5.170476679574437_p
w(1)=2.475581542171796e-3_p
x(2)=5.904372086456097_p
w(2)=2.813210121142962e-3_p
x(3)=7.251931664364463_p
w(3)=1.182663295699749e-3_p
x(4)=9.267487030726400_p
w(4)=2.244612307406013e-4_p
x(5)=12.04663030211315_p
w(5)=1.881543692392755e-5_p
x(6)=15.75921283642388_p
w(6)=6.111416475734843e-7_p
x(7)=20.74136213650267_p
w(7)=5.713734856368439e-9_p
x(8)=27.86380730658074_p
w(8)=7.056602344959186e-12_p
else if(N==9)then
x(1)=5.152490956451965_p
w(1)=2.253645460275257e-3_p
x(2)=5.807818652824186_p
w(2)=2.761872137061402e-3_p
x(3)=7.005929914353006_p
w(3)=1.340544154282578e-3_p
x(4)=8.784233163876067_p
w(4)=3.194841275591470e-4_p
x(5)=11.20565344958029_p
w(5)=3.770256762933444e-5_p
x(6)=14.37365002800143_p
w(6)=2.055376868224053e-6_p
x(7)=18.46688677996249_p
w(7)=4.438841699067335e-8_p
x(8)=23.83423928343023_p
w(8)=2.768035396109876e-10_p
x(9)=31.37470783921664_p
w(9)=2.215962663501323e-13_p
else if(N==10)then
x(1)=5.137940066183756_p
w(1)=2.067831902461363e-3_p
x(2)=5.729993020817409_p
w(2)=2.693658997342185e-3_p
x(3)=6.809090682965439_p
w(3)=1.466691711893533e-3_p
x(4)=8.402167543720296_p
w(4)=4.179276134509741e-4_p
x(5)=10.55316964211079_p
w(5)=6.397465271912791e-5_p
x(6)=13.33079096713848_p
w(6)=5.070447113700494e-6_p
x(7)=16.84440734868023_p
w(7)=1.902903349332635e-7_p
x(8)=21.27987028408118_p
w(8)=2.861408214983202e-9_p
x(9)=26.99719254019253_p
w(9)=1.238736335950252e-11_p
x(10)=34.92129966126934_p
w(10)=6.674510576754226e-15_p
else if(N==11)then
x(1)=5.125925351768470_p
w(1)=1.910077384702387e-3_p
x(2)=5.665905754590173_p
w(2)=2.616738963273021e-3_p
x(3)=6.647854659191474_p
w(3)=1.565455806768385e-3_p
x(4)=8.091848086499215_p
w(4)=5.153484930156934e-4_p
x(5)=10.02993831586132_p
w(5)=9.691126892561398e-5_p
x(6)=12.51050381142136_p
w(6)=1.022770258982069e-5_p
x(7)=15.60654831297804_p
w(7)=5.732648945300637e-7_p
x(8)=19.43220120730472_p
w(8)=1.543699738157720e-8_p
x(9)=24.17943879176537_p
w(9)=1.674316686708784e-10_p
x(10)=30.21828658825447_p
w(10)=5.193725570402279e-13_p
x(11)=38.49776698190055_p
w(11)=1.941957090276394e-16_p
else if(N==12)then
x(1)=5.115836630638133_p
w(1)=1.774525476018467e-3_p
x(2)=5.612201405984658_p
w(2)=2.536093758742425e-3_p
x(3)=6.513273941778335_p
w(3)=1.641246259731861e-3_p
x(4)=7.834438373638309_p
w(4)=6.087683567604017e-4_p
x(5)=9.599864495143855_p
w(5)=1.353499418352760e-4_p
x(6)=11.84512249868714_p
w(6)=1.793866453753241e-5_p
x(7)=14.6218933064864_p
w(7)=1.368567534691406e-6_p
x(8)=18.00662069234117_p
w(8)=5.633130433829040e-8_p
x(9)=22.11741442395714_p
w(9)=1.123592516462725e-9_p
x(10)=27.15164529514155_p
w(10)=9.039935983922251e-12_p
x(11)=33.48851904783694_p
w(11)=2.061752197961332e-14_p
x(12)=42.09967039448876_p
w(12)=5.487115056460468e-18_p
else if(N==13)then
x(1)=5.107244998202253_p
w(1)=1.656829208518062e-3_p
x(2)=5.566538255626211_p
w(2)=2.454764825241554e-3_p
x(3)=6.399190641868948_p
w(3)=1.698064842119621e-3_p
x(4)=7.617262020354774_p
w(4)=6.963632627622351e-4_p
x(5)=9.239467510734681_p
w(5)=1.779697635074885e-4_p
x(6)=11.29283707923115_p
w(6)=2.841955522002080e-5_p
x(7)=13.81556029337265_p
w(7)=2.773669908990413e-6_p
x(8)=16.86195019798814_p
w(8)=1.583590114056433e-7_p
x(9)=20.51130173700303_p
w(9)=4.927698807331538e-9_p
x(10)=24.8851708184868_p
w(10)=7.467312995494061e-11_p
x(11)=30.18579579856955_p
w(11)=4.559718881151009e-13_p
x(12)=36.8009158113511_p
w(12)=7.811743768099938e-16_p
x(13)=45.72353621065093_p
w(13)=1.511933826066798e-19_p
else if(N==14)then
x(1)=5.099840141049997_p
w(1)=1.553698769088561e-3_p
x(2)=5.527231375793264_p
w(2)=2.374594079014842e-3_p
x(3)=6.301220942439071_p
w(3)=1.739359055221525e-3_p
x(4)=7.431444562539055_p
w(4)=7.771504179483116e-4_p
x(5)=8.932710392897235_p
w(5)=2.234750736076951e-4_p
x(6)=10.82610289822498_p
w(6)=4.170211230545300e-5_p
x(7)=13.14078264768519_p
w(7)=4.982594813338228e-6_p
x(8)=15.91702923543107_p
w(8)=3.697646452903889e-7_p
x(9)=19.21132734197334_p
w(9)=1.622715653833369e-8_p
x(10)=23.10540975787649_p
w(10)=3.907023382470551e-10_p
x(11)=27.72389581060959_p
w(11)=4.592453531134212e-12_p
x(12)=33.27349342297983_p
w(12)=2.169321617396953e-14_p
x(13)=40.14995342797809_p
w(13)=2.842874691620570e-17_p
x(14)=49.36658986496259_p
w(14)=4.075985897736323e-21_p
else if(N==15)then
x(1)=5.093391987783847_p
w(1)=1.462600971979877e-3_p
x(2)=5.493036925797285_p
w(2)=2.296672510991207e-3_p
x(3)=6.216155420505513_p
w(3)=1.768019115363084e-3_p
x(4)=7.270572250544711_p
w(4)=8.507288262706172e-4_p
x(5)=8.668217182649849_p
w(5)=2.706967706678957e-4_p
x(6)=10.42589084853882_p
w(6)=5.766827482481037e-5_p
x(7)=12.56644477795651_p
w(7)=8.164920462524221e-6_p
x(8)=15.12074327365144_p
w(8)=7.520659884686106e-7_p
x(9)=18.13078926548672_p
w(9)=4.350450801952868e-8_p
x(10)=21.6549094311086_p
w(10)=1.499326463450515e-9_p
x(11)=25.7769771159933_p
w(11)=2.846999517733926e-11_p
x(12)=30.62438987582572_p
w(12)=2.641243022816038e-13_p
x(13)=36.40801285398565_p
w(13)=9.809076186259004e-16_p
x(14)=43.53117541885015_p
w(14)=9.987639639155565e-19_p
x(15)=53.02657634071934_p
w(15)=1.077943093225689e-22_p
else if(N==16)then
x(1)=5.087726340924122_p
w(1)=1.381554910284839e-3_p
x(2)=5.463016388637585_p
w(2)=2.221616728292646e-3_p
x(3)=6.141588427605594_p
w(3)=1.786432304031147e-3_p
x(4)=7.129886278132099_p
w(4)=9.170828550858310e-4_p
x(5)=8.437668639008521_p
w(5)=3.186368323845855e-4_p
x(6)=10.07856169686632_p
w(6)=7.609215500068342e-5_p
x(7)=12.07085471908511_p
w(7)=1.245232725095341e-5_p
x(8)=14.43881560152746_p
w(8)=1.375676986718365e-6_p
x(9)=17.21471615173325_p
w(9)=9.997254002440857e-8_p
x(10)=20.44201480628177_p
w(10)=4.598637504639135e-9_p
x(11)=24.18064062647218_p
w(11)=1.266810601596575e-10_p
x(12)=28.516386798928_p
w(12)=1.927707821568529e-12_p
x(13)=33.57920882787194_p
w(13)=1.432527648001968e-14_p
x(14)=39.58387619847815_p
w(14)=4.241510080129641e-17_p
x(15)=46.94092884328651_p
w(15)=3.401361820149255e-20_p
x(16)=56.70163539970126_p
w(16)=2.802639287859272e-24_p
else if(N==17)then
x(1)=5.082708882525211_p
w(1)=1.308990008170298e-3_p
x(2)=5.436448134178012_p
w(2)=2.149742179098811e-3_p
x(3)=6.075680123192580_p
w(3)=1.796554676277098e-3_p
x(4)=7.005776749754425_p
w(4)=9.764406664728713e-4_p
x(5)=8.234826160220173_p
w(5)=3.664778851695054e-4_p
x(6)=9.774046499987303_p
w(6)=9.667969849074531e-5_p
x(7)=11.63833435900766_p
w(7)=1.793256599026321e-5_p
x(8)=13.84717469464989_p
w(8)=2.314549648572407e-6_p
x(9)=16.42600943022058_p
w(9)=2.038963903795611e-7_p
x(10)=19.408297500767_p
w(10)=1.191049118294330e-8_p
x(11)=22.83875535609097_p
w(11)=4.428969055998891e-10_p
x(12)=26.77873611371465_p
w(12)=9.898331461960386e-12_p
x(13)=31.31578358192048_p
w(13)=1.223654038889071e-13_p
x(14)=36.58223582595527_p
w(14)=7.377329676111630e-16_p
x(15)=42.79655667519663_p
w(15)=1.762756283292196e-18_p
x(16)=50.37617827993273_p
w(16)=1.126694702265492e-21_p
x(17)=60.3902125654294_p
w(17)=7.176825405752797e-26_p
else
call GD(5)
end if
end subroutine GF_5

end module m_gauss_fermi_inf
