! Module to contain all the Gauss-Fermi quadrature points
! It has been created by an automatic script created by:
! Nick Papior Andersen, 2013, nickpapior@gmail.com
! If you ever need to use this please contact the author for approval

! We have employed the Stieltjes and moment algorithm together with the Golub-Welsch
! for an efficient and fairly accurate stability of the orthogonal polynomials.

module m_gauss_fermi_18

  implicit none

  integer, parameter :: p = selected_real_kind(14,300)

  integer, parameter :: G_NF_MIN_N  =  2
  integer, parameter :: G_NF_MAX_N  = 17
  integer, parameter :: G_NF_MIN_kT = -20
  integer, parameter :: G_NF_MAX_kT = 5
  
  private
  public :: G_NF_MIN_N
  public :: G_NF_MAX_N
  public :: G_NF_MIN_kT
  public :: G_NF_MAX_kT
  public :: GaussFermi_18
  
contains

  ! Die routine for the Gauss-Fermi routines
  subroutine GD(NkT)
    integer, intent(in) :: NkT
    write(*,*) 'Error in Gauss-Fermi ',NkT
    call die('Error in number of points for Gauss-Fermi, see output.')
  end subroutine GD
  
  subroutine GaussFermi_18(NkT,N,x,w)
    integer, intent(in) :: NkT, N
    real(p), intent(out) :: x(N), w(N)
    
    if ( NkT == -20 ) then
       call GF_m20(N,x,w)
    else if ( NkT == -19 ) then
       call GF_m19(N,x,w)
    else if ( NkT == -18 ) then
       call GF_m18(N,x,w)
    else if ( NkT == -17 ) then
       call GF_m17(N,x,w)
    else if ( NkT == -16 ) then
       call GF_m16(N,x,w)
    else if ( NkT == -15 ) then
       call GF_m15(N,x,w)
    else if ( NkT == -14 ) then
       call GF_m14(N,x,w)
    else if ( NkT == -13 ) then
       call GF_m13(N,x,w)
    else if ( NkT == -12 ) then
       call GF_m12(N,x,w)
    else if ( NkT == -11 ) then
       call GF_m11(N,x,w)
    else if ( NkT == -10 ) then
       call GF_m10(N,x,w)
    else if ( NkT == -9 ) then
       call GF_m9(N,x,w)
    else if ( NkT == -8 ) then
       call GF_m8(N,x,w)
    else if ( NkT == -7 ) then
       call GF_m7(N,x,w)
    else if ( NkT == -6 ) then
       call GF_m6(N,x,w)
    else if ( NkT == -5 ) then
       call GF_m5(N,x,w)
    else if ( NkT == -4 ) then
       call GF_m4(N,x,w)
    else if ( NkT == -3 ) then
       call GF_m3(N,x,w)
    else if ( NkT == -2 ) then
       call GF_m2(N,x,w)
    else if ( NkT == -1 ) then
       call GF_m1(N,x,w)
    else if ( NkT == 0 ) then
       call GF_0(N,x,w)
    else if ( NkT == 1 ) then
       call GF_1(N,x,w)
    else if ( NkT == 2 ) then
       call GF_2(N,x,w)
    else if ( NkT == 3 ) then
       call GF_3(N,x,w)
    else if ( NkT == 4 ) then
       call GF_4(N,x,w)
    else if ( NkT == 5 ) then
       call GF_5(N,x,w)
    else
       call die('Could not figure out the Gauss-Fermi &
             &quadratue method you asked for.')
    end if
  end subroutine GaussFermi_18
  
  
! [-20kT;18kT]
subroutine GF_m20(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-15.59867319000385_p
w(1)=10.40132019215651_p
x(2)=-3.761795644417777_p
w(2)=9.598679794674659_p
else if(N==3)then
x(1)=-17.5606978015907_p
w(1)=6.008949882212709_p
x(2)=-9.213301497788221_p
w(2)=9.514821999923614_p
x(3)=-1.155166666072345_p
w(3)=4.476228104694852_p
else if(N==4)then
x(1)=-18.43111153858134_p
w(1)=3.928573297318514_p
x(2)=-12.55790870111283_p
w(2)=7.327511957535149_p
x(3)=-5.008653414153457_p
w(3)=7.006538652318143_p
x(4)=6.702384645257067e-1_p
w(4)=1.737376079659367_p
else if(N==5)then
x(1)=-18.89094536782962_p
w(1)=2.799795779862334_p
x(2)=-14.55303553805697_p
w(2)=5.634516352910392_p
x(3)=-8.252489296148312_p
w(3)=6.589821541256094_p
x(4)=-2.227363893601614_p
w(4)=4.559239772461328_p
x(5)=2.574385586765723_p
w(5)=4.166265403410266e-1_p
else if(N==6)then
x(1)=-19.16449130352246_p
w(1)=2.119021995632532_p
x(2)=-15.81447133825638_p
w(2)=4.447517709183806_p
x(3)=-10.62733209807856_p
w(3)=5.709188682926914_p
x(4)=-4.899695384012876_p
w(4)=5.411404083971542_p
x(5)=-2.144587020525696e-1_p
w(5)=2.258822497386431_p
x(6)=4.850652049523586_p
w(6)=5.404501772994812e-2_p
else if(N==7)then
x(1)=-19.34205224162109_p
w(1)=1.673529815808823_p
x(2)=-16.6629104288841_p
w(2)=3.604516306232575_p
x(3)=-12.35215061880677_p
w(3)=4.881694636126421_p
x(4)=-7.214618697764503_p
w(4)=5.208775624534207_p
x(5)=-2.353209956910885_p
w(5)=3.920259799286807_p
x(6)=1.621243952040081_p
w(6)=7.065546362629048e-1_p
x(7)=7.414940220488590_p
w(7)=4.669168579436839e-3_p
else if(N==8)then
x(1)=-19.4656813593212_p
w(1)=1.361710827958588_p
x(2)=-17.26737302713748_p
w(2)=2.983668770018506_p
x(3)=-13.64025020614659_p
w(3)=4.181971340367484_p
x(4)=-9.111612003252041_p
w(4)=4.755702678523974_p
x(5)=-4.404561455172829_p
w(5)=4.437597841169477_p
x(6)=-4.075224031542937e-1_p
w(6)=2.150664736650855_p
x(7)=3.626906293874713_p
w(7)=1.283188211165273e-1_p
x(8)=10.01073957047471_p
w(8)=3.649710257612860e-4_p
else if(N==9)then
x(1)=-19.5566783913632_p
w(1)=1.131353465029918_p
x(2)=-17.71942758081914_p
w(2)=2.508950405700218_p
x(3)=-14.63457669255013_p
w(3)=3.600455477004404_p
x(4)=-10.6612542812444_p
w(4)=4.264193432928420_p
x(5)=-6.292558052726041_p
w(5)=4.357046547893416_p
x(6)=-2.190299860801534_p
w(6)=3.338561334841769_p
x(7)=1.291797554342592_p
w(7)=7.821863344782898e-1_p
x(8)=5.747829280097477_p
w(8)=1.721760980201386e-2_p
x(9)=12.30685107629943_p
w(9)=3.537915272563640e-5_p
else if(N==10)then
x(1)=-19.62625052671157_p
w(1)=9.547655453313540e-1_p
x(2)=-18.06903542185252_p
w(2)=2.136048887892109_p
x(3)=-15.42097011675945_p
w(3)=3.117775354546349_p
x(4)=-11.93421587103582_p
w(4)=3.797691447865056_p
x(5)=-7.956801505051516_p
w(5)=4.081514228772178_p
x(6)=-3.943976741439927_p
w(6)=3.762994433444989_p
x(7)=-4.528698565458424e-1_p
w(7)=1.958539831949148_p
x(8)=3.011529076421532_p
w(8)=1.883626870908366e-1_p
x(9)=7.785806830771805_p
w(9)=2.302250509919053e-3_p
x(10)=14.06370191633535_p
w(10)=5.319429234727017e-6_p
else if(N==11)then
x(1)=-19.68075023819176_p
w(1)=8.161629535488359e-1_p
x(2)=-18.34523278518574_p
w(2)=1.838099424538236_p
x(3)=-16.05244873979064_p
w(3)=2.716998740346638_p
x(4)=-12.98410665682544_p
w(4)=3.377561457679319_p
x(5)=-9.392485172521887_p
w(5)=3.752099747096662_p
x(6)=-5.600820730515564_p
w(6)=3.745583701426740_p
x(7)=-2.044355323260477_p
w(7)=2.899610942332324_p
x(8)=1.062387071892048_p
w(8)=8.171222671612620e-1_p
x(9)=4.759094701860816_p
w(9)=3.639784910003573e-2_p
x(10)=9.608499478421804_p
w(10)=3.616215152271229e-4_p
x(11)=15.27118298984444_p
w(11)=1.282085893980604e-6_p
else if(N==12)then
x(1)=-19.72421164087739_p
w(1)=7.054684612922745e-1_p
x(2)=-18.56690563380258_p
w(2)=1.596941763680647_p
x(3)=-16.56548931964417_p
w(3)=2.383435342410347_p
x(4)=-13.85392709719499_p
w(4)=3.008447530398874_p
x(5)=-10.61923890069018_p
w(5)=3.421432013044845_p
x(6)=-7.099051791539429_p
w(6)=3.565956021201325_p
x(7)=-3.601439558679343_p
w(7)=3.264634011701729_p
x(8)=-4.972159278242959e-1_p
w(8)=1.801217964423262_p
x(9)=2.554648384542070_p
w(9)=2.454727391556295e-1_p
x(10)=6.440227516065753_p
w(10)=6.922172380371505e-3_p
x(11)=11.15923797624338_p
w(11)=7.151519187348625e-5_p
x(12)=16.06207379264606_p
w(12)=4.519499952956166e-7_p
else if(N==13)then
x(1)=-19.75940010938335_p
w(1)=6.157415883470070e-1_p
x(2)=-18.74727512722102_p
w(2)=1.399445242893907_p
x(3)=-16.98686511909206_p
w(3)=2.104485565766430_p
x(4)=-14.57895164540219_p
w(4)=2.687720593066542_p
x(5)=-11.66491727854045_p
w(5)=3.110496997000854_p
x(6)=-8.424018062295861_p
w(6)=3.333819687165699_p
x(7)=-5.080330947086380_p
w(7)=3.282102858273098_p
x(8)=-1.936607102982987_p
w(8)=2.564781697253268_p
x(9)=8.700908255928949e-1_p
w(9)=8.388708171207029e-1_p
x(10)=4.052397677082212_p
w(10)=6.106963368685219e-2_p
x(11)=7.984848879174020_p
w(11)=1.447003779745948e-3_p
x(12)=12.43200713946959_p
w(12)=1.809403556112552e-5_p
x(13)=16.57893683029156_p
w(13)=2.084415054489311e-7_p
else if(N==14)then
x(1)=-19.78827680954747_p
w(1)=5.420420559631660e-1_p
x(2)=-18.89587222680517_p
w(2)=1.235912335138344_p
x(3)=-17.33657295898398_p
w(3)=1.869752601740170_p
x(4)=-15.18756708821514_p
w(4)=2.410091244340870_p
x(5)=-12.55760126708183_p
w(5)=2.826844210315136_p
x(6)=-9.584621225429981_p
w(6)=3.090967713252208_p
x(7)=-6.437666583023042_p
w(7)=3.162020314972096_p
x(8)=-3.336599218379578_p
w(8)=2.881391873294839_p
x(9)=-5.388058431835787e-1_p
w(9)=1.669060280167889_p
x(10)=2.198017511333872_p
w(10)=2.968755043965930e-1_p
x(11)=5.502436724404850_p
w(11)=1.468699792387807e-2_p
x(12)=9.359026334192485_p
w(12)=3.489718134323560e-4_p
x(13)=13.45182943253342_p
w(13)=5.768162275380609e-6_p
x(14)=16.92415870638116_p
w(14)=1.153502772896006e-7_p
else if(N==15)then
x(1)=-19.81226008134484_p
w(1)=4.807868532230307e-1_p
x(2)=-19.01967656094905_p
w(2)=1.099112943261053_p
x(3)=-17.62964626206092_p
w(3)=1.670883486376703_p
x(4)=-15.7022352491956_p
w(4)=2.169748926771979_p
x(5)=-13.32238489510525_p
w(5)=2.571951537578632_p
x(6)=-10.59801055450803_p
w(6)=2.854987415675137_p
x(7)=-7.660098456354234_p
w(7)=2.992778410071652_p
x(8)=-4.671353379854347_p
w(8)=2.919045384293205_p
x(9)=-1.851096527083279_p
w(9)=2.299684108618847_p
x(10)=7.100787211552181e-1_p
w(10)=8.483407485034222e-1_p
x(11)=3.518659926927747_p
w(11)=8.884206033421994e-2_p
x(12)=6.857466302259456_p
w(12)=3.737096204302633e-3_p
x(13)=10.5539163016947_p
w(13)=9.869705153593360e-5_p
x(14)=14.25828670892569_p
w(14)=2.246604424946039e-6_p
x(15)=17.16187543753988_p
w(15)=7.226302898788273e-8_p
else if(N==16)then
x(1)=-19.83239346748968_p
w(1)=4.293339234542706e-1_p
x(2)=-19.12387369829854_p
w(2)=9.836015056379128e-1_p
x(3)=-17.87747979283319_p
w(3)=1.501242422760013_p
x(4)=-16.14062196330372_p
w(4)=1.961237440353972_p
x(5)=-13.98056702880525_p
w(5)=2.344586090795321_p
x(6)=-11.48293921292833_p
w(6)=2.633427818951758_p
x(7)=-8.751232277699328_p
w(7)=2.808950929383702_p
x(8)=-5.910297809073392_p
w(8)=2.838216140249477_p
x(9)=-3.123446953030534_p
w(9)=2.577274336896737_p
x(10)=-5.750307695436244e-1_p
w(10)=1.554792277838044_p
x(11)=1.912014443721992_p
w(11)=3.408429459192590e-1_p
x(12)=4.801841541721339_p
w(12)=2.541206361428338e-2_p
x(13)=8.092485315547604_p
w(13)=1.048325612676356e-3_p
x(14)=11.57653940935482_p
w(14)=3.268367899491873e-5_p
x(15)=14.89329983911189_p
w(15)=1.032328160596638e-6_p
x(16)=17.33078594881425_p
w(16)=4.935659449538365e-8_p
else if(N==17)then
x(1)=-19.84945745877133_p
w(1)=3.857036920211908e-1_p
x(2)=-19.21237234374959_p
w(2)=8.852291458425663e-1_p
x(3)=-18.08879813231538_p
w(3)=1.355568317361904_p
x(4)=-16.51663473403602_p
w(4)=1.779750897102768_p
x(5)=-14.54981535575656_p
w(5)=2.142408956249821_p
x(6)=-12.25712811131748_p
w(6)=2.429128272412339_p
x(7)=-9.721590329087501_p
w(7)=2.625464684314304_p
x(8)=-7.041737516163439_p
w(8)=2.711715197726645_p
x(9)=-4.340167583747827_p
w(9)=2.626874252992265_p
x(10)=-1.780627318854245_p
w(10)=2.084195908056226_p
x(11)=5.755661775465587e-1_p
w(11)=8.484282971458492e-1_p
x(12)=3.098554631605705_p
w(12)=1.176851795524305e-1_p
x(13)=6.014504463633593_p
w(13)=7.504709576016013e-3_p
x(14)=9.198882715810271_p
w(14)=3.293709510542346e-4_p
x(15)=12.44284466517066_p
w(15)=1.252794965874781e-5_p
x(16)=15.39438066981978_p
w(16)=5.417068285565227e-7_p
x(17)=17.45435657613425_p
w(17)=3.586930629394897e-8_p
else
call GD(-20)
end if
end subroutine GF_m20

! [-19kT;18kT]
subroutine GF_m19(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.80201402124505_p
w(1)=9.919647641066515_p
x(2)=-3.526768745724599_p
w(2)=9.080352349306301_p
else if(N==3)then
x(1)=-16.66602350371399_p
w(1)=5.749155681128021_p
x(2)=-8.682929839356085_p
w(2)=9.091367345231163_p
x(3)=-9.856522489249885e-1_p
w(3)=4.159476964013634_p
else if(N==4)then
x(1)=-17.49429177292363_p
w(1)=3.770192262889777_p
x(2)=-11.85936807986235_p
w(2)=7.027510690570842_p
x(3)=-4.631552247320798_p
w(3)=6.664651902847512_p
x(4)=8.527953467786094e-1_p
w(4)=1.537645134064687_p
else if(N==5)then
x(1)=-17.93268268287164_p
w(1)=2.694318905373902_p
x(2)=-13.75909000760358_p
w(2)=5.419612564645624_p
x(3)=-7.703996310838678_p
w(3)=6.322606352856890_p
x(4)=-1.942956293027869_p
w(4)=4.226145621458752_p
x(5)=2.818684657429706_p
w(5)=3.373165460376487e-1_p
else if(N==6)then
x(1)=-18.19403793906376_p
w(1)=2.044009087899713_p
x(2)=-14.96320141960319_p
w(2)=4.288357449640087_p
x(3)=-9.964504568728577_p
w(3)=5.497219119815838_p
x(4)=-4.463080470476171_p
w(4)=5.154347135506375_p
x(5)=3.837781461281804e-2_p
w(5)=1.976041347239538_p
x(6)=5.165755631149215_p
w(6)=4.002585027126396e-2_p
else if(N==7)then
x(1)=-18.36416059447012_p
w(1)=1.617242533004132_p
x(2)=-15.7755341691482_p
w(2)=3.482117727555849_p
x(3)=-11.61289596859037_p
w(3)=4.711379484404769_p
x(4)=-6.661299534474836_p
w(4)=5.006535005101993_p
x(5)=-2.007175678463229_p
w(5)=3.616784812505264_p
x(6)=1.907641823647186_p
w(6)=5.626684096367556e-1_p
x(7)=7.776329801825583_p
w(7)=3.272018164054181e-3_p
else if(N==8)then
x(1)=-18.48302247711626_p
w(1)=1.317480228280888_p
x(2)=-16.35639475106942_p
w(2)=2.885965610617855_p
x(3)=-12.84916291686955_p
w(3)=4.042162575155959_p
x(4)=-8.475597476793377_p
w(4)=4.586875957517358_p
x(5)=-3.949351162621605_p
w(5)=4.217280265906313_p
x(6)=-1.095742608604156e-1_p
w(6)=1.856333994554521_p
x(7)=3.963410197447720_p
w(7)=9.364860623103043e-2_p
x(8)=10.3744551996495_p
w(8)=2.527521088931789e-4_p
else if(N==9)then
x(1)=-18.57077185543888_p
w(1)=1.095361975053522_p
x(2)=-16.79215563623657_p
w(2)=2.428602321967463_p
x(3)=-13.80682219865984_p
w(3)=3.483307592445168_p
x(4)=-9.964949294011452_p
w(4)=4.119957371680152_p
x(5)=-5.751151722994579_p
w(5)=4.185775695188361_p
x(6)=-1.821942166584887_p
w(6)=3.058041300590655_p
x(7)=1.600310770105540_p
w(7)=6.168298992549228e-1_p
x(8)=6.104899386083696_p
w(8)=1.209847712404214e-2_p
x(9)=12.62149718712358_p
w(9)=2.535706853129923e-5_p
else if(N==10)then
x(1)=-18.63796910677067_p
w(1)=9.248125263552877e-1_p
x(2)=-17.12973428744947_p
w(2)=2.068675181683345_p
x(3)=-14.56567371115033_p
w(3)=3.018222086918067_p
x(4)=-11.19160322353764_p
w(4)=3.673102871793395_p
x(5)=-7.348542218696851_p
w(5)=3.936752612224229_p
x(6)=-3.489826505565119_p
w(6)=3.562974583308038_p
x(7)=-1.332203190109948e-1_p
w(7)=1.676079965506200_p
x(8)=3.349311723436583_p
w(8)=1.377587206997667e-1_p
x(9)=8.132974552017568_p
w(9)=1.617393720421123e-3_p
x(10)=14.30255883218212_p
w(10)=4.048164067398578e-6_p
else if(N==11)then
x(1)=-18.69064626685372_p
w(1)=7.908517003683315e-1_p
x(2)=-17.3966349998654_p
w(2)=1.780844478065498_p
x(3)=-15.17559659858743_p
w(3)=2.631543846654930_p
x(4)=-12.20463661153486_p
w(4)=3.269200580829990_p
x(5)=-8.730520045064383_p
w(5)=3.625878394509578_p
x(6)=-5.073150030807843_p
w(6)=3.593335593652069_p
x(7)=-1.665033554067005_p
w(7)=2.639878490390930_p
x(8)=1.382971675990787_p
w(8)=6.424613834070907e-1_p
x(9)=5.109377632703291_p
w(9)=2.574508437287714e-2_p
x(10)=9.926568100542669_p
w(10)=2.594030955135404e-4_p
x(11)=15.43988128914979_p
w(11)=1.035026008301553e-6_p
else if(N==12)then
x(1)=-18.73267340952081_p
w(1)=6.838146018665421e-1_p
x(2)=-17.61095307289677_p
w(2)=1.547746406343360_p
x(3)=-15.67142169359835_p
w(3)=2.309437337356888_p
x(4)=-13.04463706510988_p
w(4)=2.913619438584100_p
x(5)=-9.913340010213354_p
w(5)=3.310072616877870_p
x(6)=-6.511529418447636_p
w(6)=3.438152944071649_p
x(7)=-3.148276460467736_p
w(7)=3.079495497057426_p
x(8)=-1.611151269007984e-1_p
w(8)=1.532749745416711_p
x(9)=2.894908307070603_p
w(9)=1.799785831783010e-1_p
x(10)=6.783801331668857_p
w(10)=4.879486990539361e-3_p
x(11)=11.43844743567902_p
w(11)=5.295051280442426e-5_p
x(12)=16.17909716774174_p
w(12)=3.821166254695722e-7_p
else if(N==13)then
x(1)=-18.76671457199939_p
w(1)=5.970161901490362e-1_p
x(2)=-17.78541525390966_p
w(2)=1.356756989751310_p
x(3)=-16.07886871395795_p
w(3)=2.039880599545395_p
x(4)=-13.74528811522267_p
w(4)=2.604223489408928_p
x(5)=-10.92272870340989_p
w(5)=3.011597736809331_p
x(6)=-7.787157746693889_p
w(6)=3.221652339316595_p
x(7)=-4.561965632434135_p
w(7)=3.143310808000145_p
x(8)=-1.547512394407244_p
w(8)=2.322779863173974_p
x(9)=1.202058712388164_p
w(9)=6.584512442804190e-1_p
x(10)=4.402444264157716_p
w(10)=4.328353298624903e-2_p
x(11)=8.309007878009334_p
w(11)=1.033135032453559e-3_p
x(12)=12.66984366199501_p
w(12)=1.387975703802545e-5_p
x(13)=16.66121197690754_p
w(13)=1.821619439447826e-7_p
else if(N==14)then
x(1)=-18.79466052623373_p
w(1)=5.256941516095029e-1_p
x(2)=-17.92920466444824_p
w(2)=1.198541523197813_p
x(3)=-16.41717504571379_p
w(3)=1.812916232241006_p
x(4)=-14.33379003659193_p
w(4)=2.336126001776874_p
x(5)=-11.78518875784819_p
w(5)=2.738551777876203_p
x(6)=-8.906522481178236_p
w(6)=2.990766616661959_p
x(7)=-5.865184637113819_p
w(7)=3.046766951589852_p
x(8)=-2.883022780306146_p
w(8)=2.707778960264003_p
x(9)=-1.885932160588323e-1_p
w(9)=1.414236009043230_p
x(10)=2.542937465705439_p
w(10)=2.180216223612020e-1_p
x(11)=5.847869398587720_p
w(11)=1.034091639680703e-2_p
x(12)=9.656606948291738_p
w(12)=2.545446970032477e-4_p
x(13)=13.65070358609645_p
w(13)=4.579485778328260e-6_p
x(14)=16.98354549132786_p
w(14)=1.031715830163144e-7_p
else if(N==15)then
x(1)=-18.81787898511011_p
w(1)=4.663937686279382e-1_p
x(2)=-18.0490482253175_p
w(2)=1.066137149222997_p
x(3)=-16.70081174238783_p
w(3)=1.620530039169146_p
x(4)=-14.83170150178552_p
w(4)=2.103848264819884_p
x(5)=-12.52459522010743_p
w(5)=2.492754978717450_p
x(6)=-9.885087572471740_p
w(6)=2.764720275970447_p
x(7)=-7.042290572283826_p
w(7)=2.891582841099614_p
x(8)=-4.159567738999852_p
w(8)=2.790088321682945_p
x(9)=-1.453455764269725_p
w(9)=2.072905205320740_p
x(10)=1.052601829892242_p
w(10)=6.653009347778727e-1_p
x(11)=3.871026963371778_p
w(11)=6.300940666406810e-2_p
x(12)=7.188237181744741_p
w(12)=2.653057114373707e-3_p
x(13)=10.8218381526543_p
w(13)=7.384208885566632e-5_p
x(14)=14.42313385612576_p
w(14)=1.839394134199853e-6_p
x(15)=17.20600872615699_p
w(15)=6.570235171911340e-8_p
else if(N==16)then
x(1)=-18.83737656345887_p
w(1)=4.165667316069297e-1_p
x(2)=-18.14994574712016_p
w(2)=9.542967890771283e-1_p
x(3)=-16.94075416084913_p
w(3)=1.456346417531894_p
x(4)=-15.25600043131989_p
w(4)=1.902202553107395_p
x(5)=-13.16130127894301_p
w(5)=2.273231386978124_p
x(6)=-10.74036616340667_p
w(6)=2.551680560660137_p
x(7)=-8.094902368442929_p
w(7)=2.717928728372630_p
x(8)=-5.349289468174761_p
w(8)=2.732390049121540_p
x(9)=-2.668913400999368_p
w(9)=2.412957121842285_p
x(10)=-2.128211592372536e-1_p
w(10)=1.313060982437330_p
x(11)=2.262349065621619_p
w(11)=2.507020056348949e-1_p
x(12)=5.150700520595137_p
w(12)=1.785439996027928e-2_p
x(13)=8.402733799838717_p
w(13)=7.562439383164503e-4_p
x(14)=11.81458891211218_p
w(14)=2.510698349649143e-5_p
x(15)=15.02974641314723_p
w(15)=8.677093963625144e-7_p
x(16)=17.36450363989591_p
w(16)=4.541104119285098e-8_p
else if(N==17)then
x(1)=-18.85390644180512_p
w(1)=3.743028954347019e-1_p
x(2)=-18.23566771971479_p
w(2)=8.590204393347779e-1_p
x(3)=-17.14541127536813_p
w(3)=1.315304490430208_p
x(4)=-15.62006804405243_p
w(4)=1.726598066761845_p
x(5)=-13.71223847200419_p
w(5)=2.077847570206824_p
x(6)=-11.4891299546352_p
w(6)=2.354792975998907_p
x(7)=-9.032164638741987_p
w(7)=2.542685202787899_p
x(8)=-6.438913430517816_p
w(8)=2.619141976780104_p
x(9)=-3.833259245928754_p
w(9)=2.505344262079244_p
x(10)=-1.375607077570756_p
w(10)=1.870690709235260_p
x(11)=9.276698665396323e-1_p
w(11)=6.652105645570605e-1_p
x(12)=3.454246229769314_p
w(12)=8.350906507385966e-2_p
x(13)=6.351573929644427_p
w(13)=5.299024105224834e-3_p
x(14)=9.485697091461871_p
w(14)=2.423764767295449e-4_p
x(15)=12.65262206377869_p
w(15)=9.872442683852694e-6_p
x(16)=15.50770607404325_p
w(16)=4.653739119477620e-7_p
x(17)=17.48076242135971_p
w(17)=3.329357642120529e-8_p
else
call GD(-19)
end if
end subroutine GF_m19

! [-18kT;18kT]
subroutine GF_m18(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.00466059226402_p
w(1)=9.439548397568959_p
x(2)=-3.289241779217783_p
w(2)=8.560451602431041_p
else if(N==3)then
x(1)=-15.77083179797411_p
w(1)=5.490607463808082_p
x(2)=-8.150667995325669_p
w(2)=8.668232002668127_p
x(3)=-8.101037548704175e-1_p
w(3)=3.841160533523791_p
else if(N==4)then
x(1)=-16.55711884179791_p
w(1)=3.612679088115519_p
x(2)=-11.15933110642336_p
w(2)=6.728612373762116_p
x(3)=-4.253009355523327_p
w(3)=6.315449146378229_p
x(4)=1.047428490305235_p
w(4)=1.343259391744137_p
else if(N==5)then
x(1)=-16.97418663467549_p
w(1)=2.589420947914460_p
x(2)=-12.96409986195327_p
w(2)=5.205611681953886_p
x(3)=-7.154062035398081_p
w(3)=6.053891535539704_p
x(4)=-1.655976019692596_p
w(4)=3.883308931302226_p
x(5)=3.080663364779207_p
w(5)=2.677669032897232e-1_p
else if(N==6)then
x(1)=-17.22344115583708_p
w(1)=1.969353473818091_p
x(2)=-14.1112748639481_p
w(2)=4.129793854445660_p
x(3)=-9.300614778388233_p
w(3)=5.285085001302508_p
x(4)=-4.026853052890730_p
w(4)=4.886554174157312_p
x(5)=3.015714772001229e-1_p
w(5)=1.700134934440518_p
x(6)=5.498773658118638_p
w(6)=2.907856183591068e-2_p
else if(N==7)then
x(1)=-17.38619934035858_p
w(1)=1.561128300077567_p
x(2)=-14.8878425446567_p
w(2)=3.360000244468179_p
x(3)=-10.87314382618028_p
w(3)=4.541002475060198_p
x(4)=-6.108321704982631_p
w(4)=4.800425561414650_p
x(5)=-1.661359899741875_p
w(5)=3.297630385610817_p
x(6)=2.211912366328329_p
w(6)=4.375544372541224e-1_p
x(7)=8.151697019954495_p
w(7)=2.258596114466733e-3_p
else if(N==8)then
x(1)=-17.50034477823721_p
w(1)=1.273295152700321_p
x(2)=-15.44534288997856_p
w(2)=2.788307706735546_p
x(3)=-12.05803259530546_p
w(3)=3.902182773119879_p
x(4)=-7.840096502338813_p
w(4)=4.416476060305214_p
x(5)=-3.497041153221221_p
w(5)=3.982544684863734_p
x(6)=1.966181445734453e-1_p
w(6)=1.570013164160234_p
x(7)=4.316214356393089_p
w(7)=6.700680996853364e-2_p
x(8)=10.74407874114618_p
w(8)=1.736481465366082e-4_p
else if(N==9)then
x(1)=-17.58486714516564_p
w(1)=1.059364312912517_p
x(2)=-15.86490706848435_p
w(2)=2.348207144557385_p
x(3)=-12.9791990714037_p
w(3)=3.365958286140598_p
x(4)=-9.269188195843823_p
w(4)=3.974884737607106_p
x(5)=-5.211910765735746_p
w(5)=4.008390585961926_p
x(6)=-1.455189706275121_p
w(6)=2.760425761315686_p
x(7)=1.924613940056573_p
w(7)=4.743579299039558e-1_p
x(8)=6.472722229518320_p
w(8)=8.393077830655913e-3_p
x(9)=12.93352746110139_p
w(9)=1.816377017127770e-5_p
else if(N==10)then
x(1)=-17.64969291235663_p
w(1)=8.948451544536898e-1_p
x(2)=-16.19046935652305_p
w(2)=2.001247514987747_p
x(3)=-13.71051194932693_p
w(3)=2.918507163039193_p
x(4)=-10.44941377871343_p
w(4)=3.548010382043917_p
x(5)=-6.741648520149256_p
w(5)=3.789479723883933_p
x(6)=-3.039420471432863_p
w(6)=3.346261589290827_p
x(7)=1.936830224555381e-1_p
w(7)=1.401757313627989_p
x(8)=3.701826340955494_p
w(8)=9.876043329148620e-2_p
x(9)=8.485905672788610_p
w(9)=1.127634780279716e-3_p
x(10)=14.53491786380547_p
w(10)=3.090600937028776e-6_p
else if(N==11)then
x(1)=-17.70054675948548_p
w(1)=7.655283336141347e-1_p
x(2)=-16.4480667352833_p
w(2)=1.723547188711304_p
x(3)=-14.29884785938754_p
w(3)=2.545971679010370_p
x(4)=-11.42546868592513_p
w(4)=3.160515879651604_p
x(5)=-8.069426638502845_p
w(5)=3.498458810234301_p
x(6)=-4.548161952646163_p
w(6)=3.433177263679311_p
x(7)=-1.287171024835465_p
w(7)=2.362682748161085_p
x(8)=1.718058214601232_p
w(8)=4.919591112901425e-1_p
x(9)=5.470077455378044_p
w(9)=1.797278173552767e-2_p
x(10)=10.24655041619772_p
w(10)=1.853652917247222e-4_p
x(11)=15.60227313931356_p
w(11)=8.386204959251575e-7_p
else if(N==12)then
x(1)=-17.74113884207765_p
w(1)=6.621508653252544e-1_p
x(2)=-16.65502411313429_p
w(2)=1.498517976646412_p
x(3)=-14.77743371830222_p
w(3)=2.235352401867865_p
x(4)=-12.23556872722368_p
w(4)=2.818569813872382_p
x(5)=-9.208031850623323_p
w(5)=3.198045720493568_p
x(6)=-5.925698803031409_p
w(6)=3.306953630770199_p
x(7)=-2.698893182277564_p
w(7)=2.876115578748903_p
x(8)=1.817170148384445e-1_p
w(8)=1.271632599075013_p
x(9)=3.249313284410175_p
w(9)=1.292113621042160e-1_p
x(10)=7.133934780091796_p
w(10)=3.410570185855989e-3_p
x(11)=11.71692924573315_p
w(11)=3.915693851395616e-5_p
x(12)=16.29133827212713_p
w(12)=3.239718171560407e-7_p
else if(N==13)then
x(1)=-17.77403221523786_p
w(1)=5.782822812770305e-1_p
x(2)=-16.82357527223114_p
w(2)=1.314041601511795_p
x(3)=-15.17093673320742_p
w(3)=1.975208246212675_p
x(4)=-12.91179538809571_p
w(4)=2.520566191319207_p
x(5)=-10.18096571452778_p
w(5)=2.912280138588515_p
x(6)=-7.151403717280050_p
w(6)=3.107878063921738_p
x(7)=-4.046576894057359_p
w(7)=2.994932249597035_p
x(8)=-1.159651341437119_p
w(8)=2.063194682140240_p
x(9)=1.547442071950694_p
w(9)=5.026210933994918e-1_p
x(10)=4.762972413890518_p
w(10)=3.025088446536817e-2_p
x(11)=8.636735782783164_p
w(11)=7.337576065291298e-4_p
x(12)=12.90546724351068_p
w(12)=1.065048012939235e-5_p
x(13)=16.74014615572899_p
w(13)=1.594802449008118e-7_p
else if(N==14)then
x(1)=-17.80104708861298_p
w(1)=5.093386845669726e-1_p
x(2)=-16.96255441941127_p
w(2)=1.161147691956616_p
x(3)=-15.4978310679326_p
w(3)=1.756025770122913_p
x(4)=-13.48014961987549_p
w(4)=2.262039863739588_p
x(5)=-11.01309781454282_p
w(5)=2.649974695028977_p
x(6)=-8.229191702876564_p
w(6)=2.889694959966902_p
x(7)=-5.294693311311771_p
w(7)=2.927134971707757_p
x(8)=-2.433175482618166_p
w(8)=2.514843477947974_p
x(9)=1.678219815202270e-1_p
w(9)=1.165820572536087_p
x(10)=2.901459107982440_p
w(10)=1.565765151206414e-1_p
x(11)=6.200356853790026_p
w(11)=7.213955490942186e-3_p
x(12)=9.955559057874249_p
w(12)=1.851098577447582e-4_p
x(13)=13.84677467409_p
w(13)=3.639585193704368e-6_p
x(14)=17.04063629812049_p
w(14)=9.237169066779795e-8_p
else if(N==15)then
x(1)=-17.82350045846521_p
w(1)=4.519938928114206e-1_p
x(2)=-17.07843517994794_p
w(2)=1.033141475840151_p
x(3)=-15.77202328355039_p
w(3)=1.570132109708309_p
x(4)=-13.96127991697899_p
w(4)=2.037853382976034_p
x(5)=-11.72705719203352_p
w(5)=2.413353291532910_p
x(6)=-9.172726010418600_p
w(6)=2.673922506119450_p
x(7)=-6.425824112968000_p
w(7)=2.788286702096521_p
x(8)=-3.650970941448386_p
w(8)=2.650026292210669_p
x(9)=-1.056857984036026_p
w(9)=1.828674541636005_p
x(10)=1.407515693540084_p
w(10)=5.066670623877275e-1_p
x(11)=4.233912078881603_p
w(11)=4.402009636933234e-2_p
x(12)=7.523436688495029_p
w(12)=1.871912772199574e-3_p
x(13)=11.08963130473437_p
w(13)=5.516590898506069e-5_p
x(14)=14.58514267174807_p
w(14)=1.507865696167945e-6_p
x(15)=17.24854742463939_p
w(15)=5.976458899150045e-8_p
else if(N==16)then
x(1)=-17.84236198426186_p
w(1)=4.037934221062841e-1_p
x(2)=-17.17603138526269_p
w(2)=9.249747240384165e-1_p
x(3)=-16.00406835863894_p
w(3)=1.411413183451341_p
x(4)=-14.37147270427475_p
w(4)=1.843092376938022_p
x(5)=-12.34223774986899_p
w(5)=2.201722578072627_p
x(6)=-9.998220438471572_p
w(6)=2.469579906295038_p
x(7)=-7.439517215393055_p
w(7)=2.625786666737069_p
x(8)=-4.790527330733442_p
w(8)=2.621155525416546_p
x(9)=-2.217993133887977_p
w(9)=2.228627411093377_p
x(10)=1.551014160229070e-1_p
w(10)=1.076788588175725_p
x(11)=2.625725512061430_p
w(11)=1.800829234735126e-1_p
x(12)=5.506965445128781_p
w(12)=1.241930058985232e-2_p
x(13)=8.715462844856095_p
w(13)=5.433438263937825e-4_p
x(14)=12.05157958193119_p
w(14)=1.927782046157396e-5_p
x(15)=15.16359460348714_p
w(15)=7.301811170196026e-7_p
x(16)=17.39709073242897_p
w(16)=4.178421647445245e-8_p
else if(N==17)then
x(1)=-17.85835752899198_p
w(1)=3.628965808982357e-1_p
x(2)=-17.25897522166807_p
w(2)=8.327964820287245e-1_p
x(3)=-16.20205917058325_p
w(3)=1.275009074665450_p
x(4)=-14.72358093980127_p
w(4)=1.673383852286287_p
x(5)=-12.8748275029796_p
w(5)=2.013166697217662_p
x(6)=-10.72146737381036_p
w(6)=2.280206812261061_p
x(7)=-8.343434704683499_p
w(7)=2.459240866236979_p
x(8)=-5.837645921305127_p
w(8)=2.523902613649089_p
x(9)=-3.329666964473571_p
w(9)=2.371385550395701_p
x(10)=-9.714533436503848e-1_p
w(10)=1.640045032084278_p
x(11)=1.291220515700701_p
w(11)=5.057608883836346e-1_p
x(12)=3.820441933073910_p
w(12)=5.830341831646220e-2_p
x(13)=6.693634697490732_p
w(13)=3.716012780006438e-3_p
x(14)=9.773582616944617_p
w(14)=1.779069802170436e-4_p
x(15)=12.86083601976862_p
w(15)=7.780747022469773e-6_p
x(16)=15.6187719312256_p
w(16)=4.001718941903508e-7_p
x(17)=17.50634768691415_p
w(17)=3.089729615602500e-8_p
else
call GD(-18)
end if
end subroutine GF_m18

! [-17kT;18kT]
subroutine GF_m17(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-13.2065313122156_p
w(1)=8.961195339173969_p
x(2)=-3.048806517923872_p
w(2)=8.038804686995427_p
else if(N==3)then
x(1)=-14.87507947050384_p
w(1)=5.233404394132346_p
x(2)=-7.616427280189940_p
w(2)=8.245048140216872_p
x(3)=-6.275511340436717e-1_p
w(3)=3.521547491820179_p
else if(N==4)then
x(1)=-15.61957328395805_p
w(1)=3.456078911134476_p
x(2)=-10.45774662256934_p
w(2)=6.430761692418488_p
x(3)=-3.873086310844324_p
w(3)=5.957253382273205_p
x(4)=1.255849267832229_p
w(4)=1.155906040343227_p
else if(N==5)then
x(1)=-16.01545079211201_p
w(1)=2.485116163034525_p
x(2)=-12.16805388272269_p
w(2)=4.992484345960061_p
x(3)=-6.602844237102672_p
w(3)=5.782798341906641_p
x(4)=-1.365559346010824_p
w(4)=3.531542541916619_p
x(5)=3.361815865124073_p
w(5)=2.080586333515502e-1_p
else if(N==6)then
x(1)=-16.25270282126299_p
w(1)=1.895049277658432_p
x(2)=-13.25871218434461_p
w(2)=3.971784925634037_p
x(3)=-8.635796430757102_p
w(3)=5.072451644341376_p
x(4)=-3.591416266927948_p
w(4)=4.605260712067277_p
x(5)=5.772976401330200e-1_p
w(5)=1.434745246271194_p
x(6)=5.850428233719945_p
w(6)=2.070822019708071e-2_p
else if(N==7)then
x(1)=-16.40817527384526_p
w(1)=1.505169176788015_p
x(2)=-13.99987627132664_p
w(2)=3.238109101929305_p
x(3)=-10.13303137742625_p
w(3)=4.370377132630428_p
x(4)=-5.556161673696574_p
w(4)=4.588858741087724_p
x(5)=-1.314828899893432_p
w(5)=2.964231554189189_p
x(6)=2.535552193598606_p
w(6)=3.317185544907518e-1_p
x(7)=8.540867723749646_p
w(7)=1.535765053985296e-3_p
else if(N==8)then
x(1)=-16.51765475978225_p
w(1)=1.229138649865307_p
x(2)=-14.5342543207412_p
w(2)=2.690648685284599_p
x(3)=-11.26696870699567_p
w(3)=3.761913998369740_p
x(4)=-7.205429500406185_p
w(4)=4.243852995747418_p
x(5)=-3.048096564213938_p
w(5)=3.730071092444320_p
x(6)=5.135369340822622e-1_p
w(6)=1.297246058667505_p
x(7)=4.685380041951156_p
w(7)=4.701009232027619e-2_p
x(8)=11.11846242420604_p
w(8)=1.184534702304585e-4_p
else if(N==9)then
x(1)=-16.5989681204864_p
w(1)=1.023350368654665_p
x(2)=-14.93770408226886_p
w(2)=2.267736610849868_p
x(3)=-12.15177375821727_p
w(3)=3.248338075564584_p
x(4)=-8.574157542726240_p
w(4)=3.828688518422901_p
x(5)=-4.675374865450205_p
w(5)=3.822611001218148_p
x(6)=-1.088722361172501_p
w(6)=2.448220907817971_p
x(7)=2.266095550112272_p
w(7)=3.552910592261255e-1_p
x(8)=6.850908661179549_p
w(8)=5.750468965051704e-3_p
x(9)=13.24176280067619_p
w(9)=1.301545008229924e-5_p
else if(N==10)then
x(1)=-16.66142426761066_p
w(1)=8.648573100111422e-1_p
x(2)=-15.25125425160886_p
w(2)=1.933748235299392_p
x(3)=-12.85552637279878_p
w(3)=2.818587264650155_p
x(4)=-9.707761645635525_p
w(4)=3.422267150289068_p
x(5)=-6.136469896425279_p
w(5)=3.638692504800865_p
x(6)=-2.592990034891003_p
w(6)=3.109490366759592_p
x(7)=5.304866667230214e-1_p
w(7)=1.142141864786023_p
x(8)=4.069075301424430_p
w(8)=6.943243040680029e-2_p
x(9)=8.844078601759138_p
w(9)=7.805310134203538e-4_p
x(10)=14.76022965473552_p
w(10)=2.368152939834086e-6_p
else if(N==11)then
x(1)=-16.71045348828611_p
w(1)=7.401881917727067e-1_p
x(2)=-15.49953831214758_p
w(2)=1.666194303235408_p
x(3)=-13.42223337256248_p
w(3)=2.460251358784003_p
x(4)=-10.64668292235333_p
w(4)=3.051419788458970_p
x(5)=-7.409429235081054_p
w(5)=3.369394237304216_p
x(6)=-4.026402076128362_p
w(6)=3.262193864805168_p
x(7)=-9.091966697354181e-1_p
w(7)=2.071340646236328_p
x(8)=2.069061075699199_p
w(8)=3.664958315379084e-1_p
x(9)=5.840849487331991_p
w(9)=1.238911534200272e-2_p
x(10)=10.56790824242889_p
w(10)=1.320066751160431e-4_p
x(11)=15.75825450081788_p
w(11)=6.820175691354098e-7_p
else if(N==12)then
x(1)=-16.74960943867977_p
w(1)=6.404733188912954e-1_p
x(2)=-15.69912736098349_p
w(2)=1.449245617905568_p
x(3)=-13.88355033836323_p
w(3)=2.161156766871159_p
x(4)=-11.42678306444659_p
w(4)=2.723240264346399_p
x(5)=-8.503468215503021_p
w(5)=3.085127200218341_p
x(6)=-5.341981034693942_p
w(6)=3.170910324741878_p
x(7)=-2.253347053527367_p
w(7)=2.651271803522009_p
x(8)=5.339671093888482e-1_p
w(8)=1.025289600811784_p
x(9)=3.617864233201691_p
w(9)=9.089128918891126e-2_p
x(10)=7.490222029933538_p
w(10)=2.364633030995650e-3_p
x(11)=11.99422793926808_p
w(11)=2.893121952060783e-5_p
x(12)=16.39884694298347_p
w(12)=2.754215356175840e-7_p
else if(N==13)then
x(1)=-16.78135432504543_p
w(1)=5.595364997789386e-1_p
x(2)=-15.86176246923032_p
w(2)=1.271290020811788_p
x(3)=-14.26308977820418_p
w(3)=1.910449634899563_p
x(4)=-12.07852158144265_p
w(4)=2.436706938590937_p
x(5)=-9.439739880331450_p
w(5)=2.812416619532945_p
x(6)=-6.517043342509966_p
w(6)=2.991822018638853_p
x(7)=-3.534707415150541_p
w(7)=2.833524790188412_p
x(8)=-7.712949455945390e-1_p
w(8)=1.790078030504272_p
x(9)=1.907692221409280_p
w(9)=3.727864537603204e-1_p
x(10)=5.133609147177022_p
w(10)=2.086213999852709e-2_p
x(11)=8.967626951406967_p
w(11)=5.185624311048151e-4_p
x(12)=13.13855212610012_p
w(12)=8.177174729266032e-6_p
x(13)=16.81581129518188_p
w(13)=1.398590074326639e-7_p
else if(N==14)then
x(1)=-16.8074375988277_p
w(1)=4.929727793888953e-1_p
x(2)=-15.99592767897506_p
w(2)=1.123723237504179_p
x(3)=-14.57855819156728_p
w(3)=1.699065959740388_p
x(4)=-12.62668459480089_p
w(4)=2.187801543034027_p
x(5)=-10.24141285121489_p
w(5)=2.561032344639792_p
x(6)=-7.552828080115302_p
w(6)=2.787416744617495_p
x(7)=-4.726670986620780_p
w(7)=2.801201390042353_p
x(8)=-1.986939846126246_p
w(8)=2.299670630814688_p
x(9)=5.331338186180369e-1_p
w(9)=9.319276995550794e-1_p
x(10)=3.273613427541060_p
w(10)=1.100619702717438e-1_p
x(11)=6.559506794326834_p
w(11)=4.988498464501112e-3_p
x(12)=10.25551673973428_p
w(12)=1.342492844751384e-4_p
x(13)=14.03983818755136_p
w(13)=2.896033934363298e-6_p
x(14)=17.09548949877316_p
w(14)=8.277784594575885e-8_p
else if(N==15)then
x(1)=-16.82912544884196_p
w(1)=4.375847579673919e-1_p
x(2)=-16.10784270443323_p
w(2)=1.000119492700783_p
x(3)=-14.84329531823863_p
w(3)=1.519677174752553_p
x(4)=-13.09100224078975_p
w(4)=1.971740030429984_p
x(5)=-10.92983677757126_p
w(5)=2.333691348823556_p
x(6)=-8.461069827469876_p
w(6)=2.582409542112828_p
x(7)=-5.811043382621204_p
w(7)=2.681936971266007_p
x(8)=-3.146064734189808_p
w(8)=2.495032061524481_p
x(9)=-6.594557427844120e-1_p
w(9)=1.571702197649333_p
x(10)=1.776321027601326_p
w(10)=3.744299854195415e-1_p
x(11)=4.606920709354219_p
w(11)=3.032091646800539e-2_p
x(12)=7.862702671399197_p
w(12)=1.313092209984600e-3_p
x(13)=11.35699283223413_p
w(13)=4.116275699996438e-5_p
x(14)=14.74419690106328_p
w(14)=1.237704302227452e-6_p
x(15)=17.28953291674581_p
w(15)=5.438364566031889e-8_p
else if(N==16)then
x(1)=-16.84735054855643_p
w(1)=3.910118653792137e-1_p
x(2)=-16.20213514718067_p
w(2)=8.956298282455379e-1_p
x(3)=-15.06743463386372_p
w(3)=1.366432298882009_p
x(4)=-13.48706516783283_p
w(4)=1.783887615649850_p
x(5)=-11.5234293165987_p
w(5)=2.130019704749565_p
x(6)=-9.256610390195101_p
w(6)=2.387014261557314_p
x(7)=-6.785320310905107_p
w(7)=2.532041291261002_p
x(8)=-4.234523743981213_p
w(8)=2.502121513802885_p
x(9)=-1.770397345074032_p
w(9)=2.021795982599884_p
x(10)=5.314170231348940e-1_p
w(10)=8.546168518799805e-1_p
x(11)=3.002232741148432_p
w(11)=1.264670386347979e-1_p
x(12)=5.870230914168084_p
w(12)=8.557410858267642e-3_p
x(13)=9.030350021120306_p
w(13)=3.889113574911595e-4_p
x(14)=12.28727686622668_p
w(14)=1.479769983341962e-5_p
x(15)=15.29478361233751_p
w(15)=6.151645798140604e-7_p
x(16)=17.42857543518504_p
w(16)=3.844718438861112e-8_p
else if(N==17)then
x(1)=-16.86281143180127_p
w(1)=3.514828996972357e-1_p
x(2)=-16.28229877041503_p
w(2)=8.065525627964731e-1_p
x(3)=-15.2587523029249_p
w(3)=1.234673292481214_p
x(4)=-13.82719562992252_p
w(4)=1.620092576073802_p
x(5)=-12.03762569646524_p
w(5)=1.948336092484891_p
x(6)=-9.954224713710856_p
w(6)=2.205296575367198_p
x(7)=-7.655577461387429_p
w(7)=2.374868888624587_p
x(8)=-5.238327520880428_p
w(8)=2.424729163099546_p
x(9)=-2.829824332720119_p
w(9)=2.220933257066391_p
x(10)=-5.662339199907250e-1_p
w(10)=1.397541250323633_p
x(11)=1.667768615272970_p
w(11)=3.726720175936345e-1_p
x(12)=4.196741214736122_p
w(12)=4.009560897631926e-2_p
x(13)=7.040332434254577_p
w(13)=2.589052185237853e-3_p
x(14)=10.06226245133051_p
w(14)=1.302826630036612e-4_p
x(15)=13.06731359353521_p
w(15)=6.133648907281000e-6_p
x(16)=15.72754918998008_p
w(16)=3.444209340222088e-7_p
x(17)=17.53113149328169_p
w(17)=2.866638881211370e-8_p
else
call GD(-17)
end if
end subroutine GF_m17

! [-16kT;18kT]
subroutine GF_m16(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-12.40753489410807_p
w(1)=8.484774530751716_p
x(2)=-2.804963322790233_p
w(2)=7.515225566553473_p
else if(N==3)then
x(1)=-13.97872124096368_p
w(1)=4.977648000330841_p
x(2)=-7.080138374408954_p
w(2)=7.821261368442014_p
x(3)=-4.368203437353564e-1_p
w(3)=3.201090728532334_p
else if(N==4)then
x(1)=-14.68163649371591_p
w(1)=3.300433583347440_p
x(2)=-9.754580009694708_p
w(2)=6.133842065052947_p
x(3)=-3.491822154180909_p
w(3)=5.588198707373663_p
x(4)=1.480009358358626_p
w(4)=9.775257415311391e-1_p
else if(N==5)then
x(1)=-15.05647058692376_p
w(1)=2.381413519633215_p
x(2)=-11.3709557220079_p
w(2)=4.780170378280062_p
x(3)=-6.050576581633816_p
w(3)=5.508077647321679_p
x(4)=-1.070507426753381_p
w(4)=3.172355571155207_p
x(5)=3.663660551878487_p
w(5)=1.579829809150253e-1_p
else if(N==6)then
x(1)=-15.28182711399301_p
w(1)=1.821084435051762_p
x(2)=-12.40554842221411_p
w(2)=3.814266367672968_p
x(3)=-7.970242162794187_p
w(3)=4.858825836923363_p
x(4)=-3.157141931492090_p
w(4)=4.307403267194991_p
x(5)=8.680264393978796e-1_p
w(5)=1.183973732934832_p
x(6)=6.221386394076477_p
w(6)=1.444645752727270e-2_p
else if(N==7)then
x(1)=-15.43009713831165_p
w(1)=1.449342072032205_p
x(2)=-13.11168757314414_p
w(2)=3.116373617331462_p
x(3)=-9.392735556818320_p
w(3)=4.199244896019810_p
x(4)=-5.005404727495655_p
w(4)=4.369626842127442_p
x(5)=-9.661280612691957e-1_p
w(5)=2.619547200605255_p
x(6)=2.879889049614241_p
w(6)=2.448366178444448e-1_p
x(7)=8.943485787439805_p
w(7)=1.028851344570820e-3_p
else if(N==8)then
x(1)=-15.53495989445058_p
w(1)=1.184991155316388_p
x(2)=-13.62317190021629_p
w(2)=2.592933625955690_p
x(3)=-10.47610194927763_p
w(3)=3.621203688556417_p
x(4)=-6.571993091916887_p
w(4)=4.068056205983717_p
x(5)=-2.602809850031547_p
w(5)=3.456568023273142_p
x(6)=8.439026053289664e-1_p
w(6)=1.043820990065437_p
x(7)=5.070829623915271_p
w(7)=3.234610126042778e-2_p
x(8)=11.4962756957854_p
w(8)=8.030689397098388e-5_p
else if(N==9)then
x(1)=-15.61307919284669_p
w(1)=9.873085352488925e-1_p
x(2)=-14.01057237891596_p
w(2)=2.187157327668413_p
x(3)=-11.32462533625622_p
w(3)=3.130358437645496_p
x(4)=-7.880089663481789_p
w(4)=3.680949567809837_p
x(5)=-4.142157352251047_p
w(5)=3.625361468091723_p
x(6)=-7.205896707362597e-1_p
w(6)=2.125995781217751_p
x(7)=2.625878431893697_p
w(7)=2.589668978398127e-1_p
x(8)=7.238995984983753_p
w(8)=3.892743781917768e-3_p
x(9)=13.54501495468557_p
w(9)=9.338001345288440e-6_p
else if(N==10)then
x(1)=-15.67316600231705_p
w(1)=8.348415172247651e-1_p
x(2)=-14.31210565418852_p
w(2)=1.866155459047180_p
x(3)=-12.00076855152734_p
w(3)=2.718406288200853_p
x(4)=-8.966792335037431_p
w(4)=3.295661945107022_p
x(5)=-5.533448151518193_p
w(5)=3.482900735658947_p
x(6)=-2.150463372661167_p
w(6)=2.849803914827996_p
x(7)=8.799997382863899e-1_p
w(7)=9.037966014044483e-1_p
x(8)=4.450915063194564_p
w(8)=4.789517956515509e-2_p
x(9)=9.206914653367891_p
w(9)=5.366343545337973e-4_p
x(10)=14.97800642949542_p
w(10)=1.821914287500874e-6_p
else if(N==11)then
x(1)=-15.72036868284379_p
w(1)=7.148253966324088e-1_p
x(2)=-14.55106272998306_p
w(2)=1.608769015695275_p
x(3)=-12.5457921954897_p
w(3)=2.374342743374101_p
x(4)=-9.868382181862037_p
w(4)=2.941789256495370_p
x(5)=-6.750819789830532_p
w(5)=3.238002890634414_p
x(6)=-3.508450250400478_p
w(6)=3.076607700093108_p
x(7)=-5.288715137966887e-1_p
w(7)=1.771643233782474_p
x(8)=2.437067551811891_p
w(8)=2.654887515821276e-1_p
x(9)=6.221292763074717_p
w(9)=8.436823983861492e-3_p
x(10)=10.89006866709953_p
w(10)=9.372828061487200e-5_p
x(11)=15.90776150907851_p
w(11)=5.567514333816715e-7_p
else if(N==12)then
x(1)=-15.75808708575459_p
w(1)=6.187770058228215e-1_p
x(2)=-14.74327364870978_p
w(2)=1.399915586154169_p
x(3)=-12.98980306937548_p
w(3)=2.086819772193486_p
x(4)=-10.61835800718256_p
w(4)=2.627550774541748_p
x(5)=-7.799849443074297_p
w(5)=2.970977700855545_p
x(6)=-4.760897849413723_p
w(6)=3.027894488681111_p
x(7)=-1.811278708283321_p
w(7)=2.402777224693215_p
x(8)=8.984286063010890e-1_p
w(8)=8.009428317029057e-1_p
x(9)=4.000381079854807_p
w(9)=6.269623048547224e-2_p
x(10)=7.852218391015987_p
w(10)=1.626882573556264e-3_p
x(11)=12.26987714898387_p
w(11)=2.136483631625504e-5_p
x(12)=16.50168874420429_p
w(12)=2.347648421305616e-7_p
else if(N==13)then
x(1)=-15.78868250970783_p
w(1)=5.407746310031399e-1_p
x(2)=-14.89998596905727_p
w(2)=1.228490842306027_p
x(3)=-13.35535373893767_p
w(3)=1.845580624646019_p
x(4)=-11.24552775463609_p
w(4)=2.352589690959927_p
x(5)=-8.699195507714641_p
w(5)=2.711818506355927_p
x(6)=-5.884448009553746_p
w(6)=2.872443437945156_p
x(7)=-3.026870140667338_p
w(7)=2.654842463137460_p
x(8)=-3.800256080645095e-1_p
w(8)=1.510292614744103_p
x(9)=2.283884002401223_p
w(9)=2.685900887756245e-1_p
x(10)=5.513927676322218_p
w(10)=1.420599140533692e-2_p
x(11)=9.301248776902865_p
w(11)=3.647998908021060e-4_p
x(12)=13.36877605794065_p
w(12)=6.283289322169089e-6_p
x(13)=16.88828399774838_p
w(13)=1.228463433123321e-7_p
else if(N==14)then
x(1)=-15.81383343029482_p
w(1)=4.765928441259046e-1_p
x(2)=-15.02933216287743_p
w(2)=1.086258620354153_p
x(3)=-13.65937790749414_p
w(3)=1.642017402590231_p
x(4)=-11.77344388366322_p
w(4)=2.113369708276779_p
x(5)=-9.470242229921986_p
w(5)=2.471608740139967_p
x(6)=-6.877691397356860_p
w(6)=2.683408473074270_p
x(7)=-4.161688303491228_p
w(7)=2.666194631903232_p
x(8)=-1.543682223233547_p
w(8)=2.060925748136111_p
x(9)=9.100979515795895e-1_p
w(9)=7.202963719530756e-1_p
x(10)=3.659212697456407_p
w(10)=7.580714326806348e-2_p
x(11)=6.924899902684233_p
w(11)=3.420904739355255e-3_p
x(12)=10.55609888028914_p
w(12)=9.712707800615426e-5_p
x(13)=14.2296977911014_p
w(13)=2.307425379519508e-6_p
x(14)=17.14816441102183_p
w(14)=7.424066299505017e-8_p
else if(N==15)then
x(1)=-15.83475513434205_p
w(1)=4.231632878030593e-1_p
x(2)=-15.13727737173823_p
w(2)=9.670631518069789e-1_p
x(3)=-13.91464587037839_p
w(3)=1.469149378541926_p
x(4)=-12.22090839550471_p
w(4)=1.905476541555662_p
x(5)=-10.13301811869391_p
w(5)=2.253691829894543_p
x(6)=-7.750306335783047_p
w(6)=2.489896888763552_p
x(7)=-5.198387293285511_p
w(7)=2.571066103576940_p
x(8)=-2.645244743873070_p
w(8)=2.320653008757689_p
x(9)=-2.587114169160140e-1_p
w(9)=1.309752536644900_p
x(10)=2.160102940723764_p
w(10)=2.685305222749346e-1_p
x(11)=4.989598532532530_p
w(11)=2.060904140946885e-2_p
x(12)=8.205653567869581_p
w(12)=9.160559171963627e-4_p
x(13)=11.62361363068173_p
w(13)=3.068353341813118e-5_p
x(14)=14.90018798423267_p
w(14)=1.017323839728479e-6_p
x(15)=17.32900649822946_p
w(15)=4.950108185847218e-8_p
else if(N==16)then
x(1)=-15.85234327288254_p
w(1)=3.782194103881242e-1_p
x(2)=-15.22826266983112_p
w(2)=8.662552518888458e-1_p
x(3)=-14.13086825432187_p
w(3)=1.321390611376390_p
x(4)=-12.60281090993414_p
w(4)=1.724563292582320_p
x(5)=-10.70494307620531_p
w(5)=2.058067906489544_p
x(6)=-8.515676184232360_p
w(6)=2.303815232226591_p
x(7)=-6.132628675286734_p
w(7)=2.435928664409321_p
x(8)=-3.681860704681645_p
w(8)=2.371931085369192_p
x(9)=-1.325240794460812_p
w(9)=1.792079296725737_p
x(10)=9.188297584803058e-1_p
w(10)=6.546657530459409e-1_p
x(11)=3.391701930795828_p
w(11)=8.695019456382033e-2_p
x(12)=6.240071451919094_p
w(12)=5.844085806409356e-3_p
x(13)=9.347059661164572_p
w(13)=2.774008976938856e-4_p
x(14)=12.52144549522623_p
w(14)=1.135729347445647e-5_p
x(15)=15.42325834007629_p
w(15)=5.188678823667889e-7_p
x(16)=17.45898567053358_p
w(16)=3.537390357670962e-8_p
else if(N==17)then
x(1)=-15.8672690327513_p
w(1)=3.400595527286182e-1_p
x(2)=-15.3056432346035_p
w(2)=7.802828029640466e-1_p
x(3)=-14.31550372455173_p
w(3)=1.194286094299781_p
x(4)=-12.9309399025697_p
w(4)=1.566704081283002_p
x(5)=-11.20068770698723_p
w(5)=1.883314941980361_p
x(6)=-9.187510403996846_p
w(6)=2.129954510196886_p
x(7)=-6.968824120841508_p
w(7)=2.289152876609768_p
x(8)=-4.641448716163448_p
w(8)=2.319687726453517_p
x(9)=-2.333977934705862_p
w(9)=2.049573052604553_p
x(10)=-1.573389486125743e-1_p
w(10)=1.151673116458299_p
x(11)=2.058419169490508_p
w(11)=2.662273341416762e-1_p
x(12)=4.582670749546740_p
w(12)=2.719078175543684e-2_p
x(13)=7.391299788247145_p
w(13)=1.792859299278620e-3_p
x(14)=10.3514519020846_p
w(14)=9.520637943802650e-5_p
x(15)=13.27188373950107_p
w(15)=4.836861637823722e-6_p
x(16)=15.8340125947108_p
w(16)=2.967008850409006e-7_p
x(17)=17.55513269815566_p
w(17)=2.658800474839223e-8_p
else
call GD(-16)
end if
end subroutine GF_m16

! [-15kT;18kT]
subroutine GF_m15(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-11.60757030550733_p
w(1)=8.010479353287920_p
x(2)=-2.557094971596408_p
w(2)=6.989520937384373_p
else if(N==3)then
x(1)=-13.08171073708008_p
w(1)=4.723438259688482_p
x(2)=-6.541761667049538_p
w(2)=7.396054542035773_p
x(3)=-2.364833389159757e-1_p
w(3)=2.880507488948039_p
else if(N==4)then
x(1)=-13.74329170666469_p
w(1)=3.145778592841436_p
x(2)=-9.049822497003975_p
w(2)=5.837640825380126_p
x(3)=-3.109191789753860_p
w(3)=5.206323710986256_p
x(4)=1.722112439554973_p
w(4)=8.102571614644756e-1_p
else if(N==5)then
x(1)=-14.09724416894468_p
w(1)=2.278314226741911_p
x(2)=-10.5728303327388_p
w(2)=4.568562952095767_p
x(3)=-5.497586816827110_p
w(3)=5.227965005036282_p
x(4)=-7.692015569397865e-1_p
w(4)=2.808118230036902_p
x(5)=3.987719450831309_p
w(5)=1.170398767614320e-1_p
else if(N==6)then
x(1)=-14.31082122798301_p
w(1)=1.747438721946245_p
x(2)=-11.55183782778164_p
w(2)=3.657142583497565_p
x(3)=-7.304223013582709_p
w(3)=4.643471136900439_p
x(4)=-2.724278282391131_p
w(4)=3.989898354888246_p
x(5)=1.176488239043691_p
w(5)=9.521829008683446e-1_p
x(6)=6.612239308664076_p
w(6)=9.866592571455080e-3_p
else if(N==7)then
x(1)=-14.45197601052678_p
w(1)=1.393617645534143_p
x(2)=-12.22334278279268_p
w(2)=2.994702306118461_p
x(3)=-8.652484452702982_p
w(3)=4.027236867859389_p
x(4)=-4.456747253452711_p
w(4)=4.139716254705552_p
x(5)=-6.131812416724303e-1_p
w(5)=2.268288790962802_p
x(6)=3.246024238115544_p
w(6)=1.757591055073930e-1_p
x(7)=9.358976483166606_p
w(7)=6.793199845545827e-4_p
else if(N==8)then
x(1)=-14.55226883092772_p
w(1)=1.140829896110220_p
x(2)=-12.71214589583727_p
w(2)=2.495096301902256_p
x(3)=-9.685590731035463_p
w(3)=3.479846316795708_p
x(4)=-5.940280321294023_p
w(4)=3.887677163694674_p
x(5)=-2.161135853525343_p
w(5)=3.159394017234664_p
x(6)=1.190560515177119_p
w(6)=8.152669163909885e-1_p
x(7)=5.472351186601076_p
w(7)=2.183550705217439e-2_p
x(8)=11.87600885476609_p
w(8)=5.417149160859162e-5_p
else if(N==9)then
x(1)=-14.62720553113277_p
w(1)=9.512251211546278e-1_p
x(2)=-13.0835424776821_p
w(2)=2.106428573685061_p
x(3)=-10.49785049116813_p
w(3)=3.011901409017499_p
x(4)=-7.187279977623636_p
w(4)=3.531035425099990_p
x(5)=-3.612910510465501_p
w(5)=3.412657927315437_p
x(6)=-3.481500818086383e-1_p
w(6)=1.800511102898887_p
x(7)=3.004773169179286_p
w(7)=1.836291864962022e-1_p
x(8)=7.636444348026411_p
w(8)=2.604830993811334e-3_p
x(9)=13.84210994860051_p
w(9)=6.714010778949157e-6_p
else if(N==10)then
x(1)=-14.6849216361972_p
w(1)=8.047884267879463e-1_p
x(2)=-13.37304442964414_p
w(2)=1.798441340850833_p
x(3)=-11.14630390427194_p
w(3)=2.617888869692200_p
x(4)=-8.226695115597492_p
w(4)=3.167878386544131_p
x(5)=-4.933135221393291_p
w(5)=3.319900585841116_p
x(6)=-1.711261874206167_p
w(6)=2.565762553254748_p
x(7)=1.245029897122914_p
w(7)=6.925346394421914e-1_p
x(8)=4.847073667064336_p
w(8)=3.243743196153811e-2_p
x(9)=9.573775964180507_p
w(9)=3.666484903614646e-4_p
x(10)=15.1878286579672_p
w(10)=1.407807229791248e-6_p
else if(N==11)then
x(1)=-14.7302951768471_p
w(1)=6.894324420226020e-1_p
x(2)=-13.60265654608272_p
w(2)=1.551249656677111_p
x(3)=-11.66957443528712_p
w(3)=2.288192166302133_p
x(4)=-9.090700707293665_p
w(4)=2.831444013072332_p
x(5)=-6.093979896446235_p
w(5)=3.103227870295451_p
x(6)=-2.994838283107067_p
w(6)=2.871844759855451_p
x(7)=-1.432713101558815e-1_p
w(7)=1.471841350850842_p
x(8)=2.822792794259923_p
w(8)=1.870224947554945e-1_p
x(9)=6.610951045691410_p
w(9)=5.678697752965411e-3_p
x(10)=11.21242601721399_p
w(10)=6.638287620903087e-5_p
x(11)=16.05076917461437_p
w(11)=4.562117030968908e-7_p
else if(N==12)then
x(1)=-14.76657417451437_p
w(1)=5.970556133854933e-1_p
x(2)=-13.78747673387371_p
w(2)=1.350510231138814_p
x(3)=-12.09623217702049_p
w(3)=2.012300893187184_p
x(4)=-9.810394568631663_p
w(4)=2.531387146779891_p
x(5)=-7.097439449930645_p
w(5)=2.855067492142865_p
x(6)=-4.183074003264899_p
w(6)=2.874837373039818_p
x(7)=-1.371685778130543_p
w(7)=2.130627209827925_p
x(8)=1.277797355765229_p
w(8)=6.046388137509838e-1_p
x(9)=4.396532664330690_p
w(9)=4.244835862577350e-2_p
x(10)=8.219439378130588_p
w(10)=1.111183382587259e-3_p
x(11)=12.54340289096665_p
w(11)=1.577479316639816e-5_p
x(12)=16.59994342707871_p
w(12)=2.006177936770120e-7_p
else if(N==13)then
x(1)=-14.79601879813168_p
w(1)=5.219913324367836e-1_p
x(2)=-13.9382573053454_p
w(2)=1.185629495994436_p
x(3)=-12.44776152070967_p
w(3)=1.780569622195431_p
x(4)=-10.41289248368469_p
w(4)=2.268136298860719_p
x(5)=-7.959521981383499_p
w(5)=2.610195284687511_p
x(6)=-5.254094977105729_p
w(6)=2.748131110035921_p
x(7)=-2.523414594744284_p
w(7)=2.454166294800665_p
x(8)=1.723089805509298e-2_p
w(8)=1.233285802956176_p
x(9)=2.676670675312785_p
w(9)=1.880767514237938e-1_p
x(10)=5.903454977212495_p
w(10)=9.557807822678652e-3_p
x(11)=9.637142195707673_p
w(11)=2.555483692524787e-4_p
x(12)=13.59582271766788_p
w(12)=4.833027293023733e-6_p
x(13)=16.95764481001084_p
w(13)=1.080616337728500e-7_p
else if(N==14)then
x(1)=-14.82023631044371_p
w(1)=4.601943388274337e-1_p
x(2)=-14.06277759960295_p
w(2)=1.048741697451613_p
x(3)=-12.74031743085842_p
w(3)=1.584854894546146_p
x(4)=-10.92049010015616_p
w(4)=2.038687777082497_p
x(5)=-8.699727256691455_p
w(5)=2.381529262335184_p
x(6)=-6.204122782661289_p
w(6)=2.576837911027937_p
x(7)=-3.600385080218875_p
w(7)=2.518260125648315_p
x(8)=-1.102022486882031_p
w(8)=1.800165155163251_p
x(9)=1.301294494670238_p
w(9)=5.371051981554461e-1_p
x(10)=4.057892242329610_p
w(10)=5.122445471678342e-2_p
x(11)=7.296090173843476_p
w(11)=2.327447240034925e-3_p
x(12)=10.85691049068921_p
w(12)=7.012076188474351e-5_p
x(13)=14.41616656066141_p
w(13)=1.841084992111954e-6_p
x(14)=17.19872102352836_p
w(14)=6.663077610381431e-8_p
else if(N==15)then
x(1)=-14.84039099406237_p
w(1)=4.087256007992717e-1_p
x(2)=-14.16674744912918_p
w(2)=9.339622329885671e-1_p
x(3)=-12.98609770795092_p
w(3)=1.418528228962086_p
x(4)=-11.3510492684712_p
w(4)=1.839020184617843_p
x(5)=-9.336710253490324_p
w(5)=2.173241121495585_p
x(6)=-7.040682381171749_p
w(6)=2.395931343037131_p
x(7)=-4.588405317672846_p
w(7)=2.453431863072268_p
x(8)=-2.148619404744176_p
w(8)=2.122454629959265_p
x(9)=1.485199615646642e-1_p
w(9)=1.053160536425740_p
x(10)=2.559484438948988_p
w(10)=1.870506450838951e-1_p
x(11)=5.381446485514835_p
w(11)=1.383437494779961e-2_p
x(12)=8.551888535311138_p
w(12)=6.357922725764761e-4_p
x(13)=11.88917978973038_p
w(13)=2.285459743436941e-5_p
x(14)=15.05301554213153_p
w(14)=8.373476681579639e-7_p
x(15)=17.36700928518682_p
w(15)=4.506516451671620e-8_p
else if(N==16)then
x(1)=-14.85734143192689_p
w(1)=3.654127159909150e-1_p
x(2)=-14.25442103345863_p
w(2)=8.368423114473175e-1_p
x(3)=-13.19438847062126_p
w(3)=1.276271191565960_p
x(4)=-11.71875197370787_p
w(4)=1.665086077441961_p
x(5)=-9.886865506331299_p
w(5)=1.985788371287911_p
x(6)=-7.775601952733505_p
w(6)=2.219717780359392_p
x(7)=-5.481854994683184_p
w(7)=2.336229991852115_p
x(8)=-3.133133711020359_p
w(8)=2.226120627923349_p
x(9)=-8.808232211800393e-1_p
w(9)=1.542589304120145_p
x(10)=1.319805160313366_p
w(10)=4.831623510102769e-1_p
x(11)=3.793758839963280_p
w(11)=5.861543172042837e-2_p
x(12)=6.616043630428684_p
w(12)=3.957721053243651e-3_p
x(13)=9.665243458380738_p
w(13)=1.972271703883624e-4_p
x(14)=12.75385056257558_p
w(14)=8.717038192732669e-6_p
x(15)=15.54896952869858_p
w(15)=4.381497820267474e-7_p
x(16)=17.48834904870521_p
w(16)=3.254091480310846e-8_p
else if(N==17)then
x(1)=-14.87173143743818_p
w(1)=3.286236448188835e-1_p
x(2)=-14.32901472290829_p
w(2)=7.539797602026926e-1_p
x(3)=-13.37232986809245_p
w(3)=1.153833303259493_p
x(4)=-12.03484897763008_p
w(4)=1.513191705030255_p
x(5)=-10.36408365490311_p
w(5)=1.818045746721149_p
x(6)=-8.421466136103929_p
w(6)=2.054014257015701_p
x(7)=-6.283479510772705_p
w(7)=2.201417581390944_p
x(8)=-4.047601557771253_p
w(8)=2.205886288019953_p
x(9)=-1.841967390298216_p
w(9)=1.853509064728230_p
x(10)=2.583876916101978e-1_p
w(10)=9.133835499266250e-1_p
x(11)=2.463782437607462_p
w(11)=1.846054041062845e-1_p
x(12)=4.977707995770411_p
w(12)=1.820206254628333e-2_p
x(13)=7.746156517291256_p
w(13)=1.234383883483807e-3_p
x(14)=10.64085921084596_p
w(14)=6.944264848726920e-5_p
x(15)=13.47437803900298_p
w(15)=3.815912867240647e-6_p
x(16)=15.93814070709503_p
w(16)=2.558105560649715e-7_p
x(17)=17.57836989306496_p
w(17)=2.465040496448176e-8_p
else
call GD(-15)
end if
end subroutine GF_m15

! [-14kT;18kT]
subroutine GF_m14(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.80652764731221_p
w(1)=7.538498216149494_p
x(2)=-2.304431372212210_p
w(2)=6.461502600148901_p
else if(N==3)then
x(1)=-12.18400217923463_p
w(1)=4.470866734413216_p
x(2)=-6.001299406638789_p
w(2)=6.968245761972262_p
x(3)=-2.479588944108819e-2_p
w(3)=2.560888319912915_p
else if(N==4)then
x(1)=-12.80452545952231_p
w(1)=2.992138281106031_p
x(2)=-8.343504463220196_p
w(2)=5.541793454867380_p
x(3)=-2.725038417230167_p
w(3)=4.809744885196171_p
x(4)=1.984613895419508_p
w(4)=6.563241951288110e-1_p
else if(N==5)then
x(1)=-13.13777360293805_p
w(1)=2.175808111157167_p
x(2)=-9.773733136302376_p
w(2)=4.357482797898637_p
x(3)=-4.944312309516599_p
w(3)=4.939999222131499_p
x(4)=-4.595110224748968e-1_p
w(4)=2.442243673636333_p
x(5)=4.335497719883077_p
w(5)=8.446701147475746e-2_p
else if(N==6)then
x(1)=-13.33969630435612_p
w(1)=1.674081024590681_p
x(2)=-10.69766026848998_p
w(2)=3.500272485371192_p
x(3)=-6.638113593109437_p
w(3)=4.425275110789869_p
x(4)=-2.292804744866085_p
w(4)=3.650144310796291_p
x(5)=1.505599961551189_p
w(5)=7.436341066771435e-1_p
x(6)=7.023475101708670_p
w(6)=6.593778073217513e-3_p
else if(N==7)then
x(1)=-13.47382580296446_p
w(1)=1.337958784687592_p
x(2)=-11.33492588305527_p
w(2)=2.872975204958881_p
x(3)=-7.912573088480692_p
w(3)=3.853809504071729_p
x(4)=-3.910974865010425_p
w(4)=3.895145478323294_p
x(5)=-2.532174167160462e-1_p
w(5)=1.917030246611884_p
x(6)=3.634790405280051_p
w(6)=1.226392851975555e-1_p
x(7)=9.786507403115369_p
w(7)=4.423124474576163e-4_p
else if(N==8)then
x(1)=-13.56959170313482_p
w(1)=1.096627926216025_p
x(2)=-11.80123618555946_p
w(2)=2.397054530123856_p
x(3)=-8.895630945732416_p
w(3)=3.337551328140686_p
x(4)=-5.310902381179512_p
w(4)=3.700620241758297_p
x(5)=-1.722470546077135_p
w(5)=2.837464702245255_p
x(6)=1.556322996802608_p
w(6)=6.161777207908993e-1_p
x(7)=5.889603036762368_p
w(7)=1.446796350756314e-2_p
x(8)=12.25598509677373_p
w(8)=3.640351581233705e-5_p
else if(N==9)then
x(1)=-13.64135336502988_p
w(1)=9.150834446322997e-1_p
x(2)=-12.15665167260909_p
w(2)=2.025498741287224_p
x(3)=-9.671570929097017_p
w(3)=2.892801489421935_p
x(4)=-6.496110368490406_p
w(4)=3.377966985467542_p
x(5)=-3.088239527329758_p
w(5)=3.179672465393006_p
x(6)=3.192445826797698e-2_p
w(6)=1.480560744891921_p
x(7)=3.403260556928823_p
w(7)=1.266882579526921e-1_p
x(8)=8.042632472203065_p
w(8)=1.723845267964685e-3_p
x(9)=14.13191282417103_p
w(9)=4.841983808913006e-6_p
else if(N==10)then
x(1)=-13.69669563659895_p
w(1)=7.746860563574315e-1_p
x(2)=-12.43409722027354_p
w(2)=1.730569381470275_p
x(3)=-10.29221722439375_p
w(3)=2.516929320797903_p
x(4)=-7.487720527896749_p
w(4)=3.038424549109835_p
x(5)=-4.336200589174741_p
w(5)=3.146487956687345_p
x(6)=-1.274058721776719_p
w(6)=2.258490119574073_p
x(7)=1.628185300594798_p
w(7)=5.125794980741203e-1_p
x(8)=5.257167203319019_p
w(8)=2.158376055936864e-2_p
x(9)=9.943964183173794_p
w(9)=2.490807817804947e-4_p
x(10)=15.38935004160572_p
w(10)=1.092886261737187e-6_p
else if(N==11)then
x(1)=-13.74023661292213_p
w(1)=6.639995897524705e-1_p
x(2)=-12.65434111668205_p
w(2)=1.493607667275748_p
x(3)=-10.79364534586235_p
w(3)=2.201725236685098_p
x(4)=-8.313816523032116_p
w(4)=2.720108132407313_p
x(5)=-5.439406551110467_p
w(5)=2.963419083843278_p
x(6)=-2.485891484255429_p
w(6)=2.642970687852006_p
x(7)=2.511326572160817e-1_p
w(7)=1.182146119251201_p
x(8)=3.226573570747201_p
w(8)=1.281971475719412e-1_p
x(9)=7.009312731504616_p
w(9)=3.779855734146386e-3_p
x(10)=11.53434477060236_p
w(10)=4.692069471378727e-5_p
x(11)=16.1872895247952_p
w(11)=3.752304778192314e-7_p
else if(N==12)then
x(1)=-13.77507376732336_p
w(1)=5.753009818651218e-1_p
x(2)=-12.83175429055278_p
w(2)=1.301006422407229_p
x(3)=-11.20288981894176_p
w(3)=1.937544762644754_p
x(4)=-9.003025805933635_p
w(4)=2.434578612041243_p
x(5)=-6.396588749564401_p
w(5)=2.736549446386660_p
x(6)=-3.609210090273336_p
w(6)=2.707477470754744_p
x(7)=-9.326895495362125e-1_p
w(7)=1.838255684166407_p
x(8)=1.674447332633183_p
w(8)=4.402857306169049e-1_p
x(9)=4.805866351436884_p
w(9)=2.823610521988665e-2_p
x(10)=8.591360106540712_p
w(10)=7.537786406751392e-4_p
x(11)=12.81432730021216_p
w(11)=1.164970243996512e-5_p
x(12)=16.69370336488331_p
w(12)=1.718523282024706e-7_p
else if(N==13)then
x(1)=-13.80336577803887_p
w(1)=5.031797257305417e-1_p
x(2)=-12.97659123237525_p
w(2)=1.142686989212290_p
x(3)=-11.54035552850555_p
w(3)=1.715373966029692_p
x(4)=-9.580718552961065_p
w(4)=2.183232561837622_p
x(5)=-7.220971318612143_p
w(5)=2.507082757615880_p
x(6)=-4.626586261883407_p
w(6)=2.616408946556633_p
x(7)=-2.024302442284508_p
w(7)=2.227185085629975_p
x(8)=4.240476697608609e-1_p
w(8)=9.701790870264715e-1_p
x(9)=3.086288032217885_p
w(9)=1.281319145734558e-1_p
x(10)=6.301676949320706_p
w(10)=6.357635534590357e-3_p
x(11)=9.974822666100689_p
w(11)=1.783292248385138e-4_p
x(12)=13.81938421995708_p
w(12)=3.722142669567191e-6_p
x(13)=17.02397753918516_p
w(13)=9.518373299792384e-8_p
else if(N==14)then
x(1)=-13.826648437012_p
w(1)=4.437714319561998e-1_p
x(2)=-13.09627640049686_p
w(2)=1.011156696331584_p
x(3)=-11.82141170845166_p
w(3)=1.527544697450849_p
x(4)=-10.06790469558875_p
w(4)=1.963674702371755_p
x(5)=-7.930055254294647_p
w(5)=2.290518727935372_p
x(6)=-5.532570301918919_p
w(6)=2.466366853261909_p
x(7)=-3.043394738247896_p
w(7)=2.352360068790786_p
x(8)=-6.596358930660607e-1_p
w(8)=1.523051960986907_p
x(9)=1.708887994155887_p
w(9)=3.859312007376751e-1_p
x(10)=4.469152909023510_p
w(10)=3.400067447462201e-2_p
x(11)=7.672605074169219_p
w(11)=1.571739084645588e-3_p
x(12)=11.15754435728272_p
w(12)=5.053183376061692e-5_p
x(13)=14.59906818838122_p
w(13)=1.471246338665401e-6_p
x(14)=17.24721975293084_p
w(14)=5.983599086889539e-8_p
else if(N==15)then
x(1)=-13.8460349068902_p
w(1)=3.942667179369604e-1_p
x(2)=-13.19626346489029_p
w(2)=9.008034942797446e-1_p
x(3)=-12.05767999223198_p
w(3)=1.367786476225872_p
x(4)=-10.48149076946058_p
w(4)=1.772310756726479_p
x(5)=-8.541056962924790_p
w(5)=2.092163638966253_p
x(6)=-6.332526416854202_p
w(6)=2.299772092823432_p
x(7)=-3.981758701889738_p
w(7)=2.325684376339198_p
x(8)=-1.655736688793537_p
w(8)=1.897340419886574_p
x(9)=5.657630176514604e-1_p
w(9)=8.134977838008631e-1_p
x(10)=2.974639416935494_p
w(10)=1.267392635120005e-1_p
x(11)=5.781931634998586_p
w(11)=9.178886086141742e-3_p
x(12)=8.900987850368615_p
w(12)=4.391644420244971e-4_p
x(13)=12.15337415587603_p
w(13)=1.701405580091634e-5_p
x(14)=15.20258783131911_p
w(14)=6.901870084896709e-7_p
x(15)=17.40358213962062_p
w(15)=4.103004184839602e-8_p
else if(N==16)then
x(1)=-13.86234664314812_p
w(1)=3.525875001279928e-1_p
x(2)=-13.28061924278216_p
w(2)=8.073797767374958e-1_p
x(3)=-12.25801989018583_p
w(3)=1.231051643329329_p
x(4)=-10.83494262421152_p
w(4)=1.605409641668937_p
x(5)=-9.069310038248810_p
w(5)=1.913061804709811_p
x(6)=-7.036633102682711_p
w(6)=2.134288897839154_p
x(7)=-4.833530597170999_p
w(7)=2.231002737412701_p
x(8)=-2.588820624390941_p
w(8)=2.059286845728608_p
x(9)=-4.344853688624773e-1_p
w(9)=1.280965947241911_p
x(10)=1.736322330887572_p
w(10)=3.433562835716542e-1_p
x(11)=4.207878507265677_p
w(11)=3.880366948823142e-2_p
x(12)=6.997687310034943_p
w(12)=2.659162832857563e-3_p
x(13)=9.984541319376834_p
w(13)=1.398134832253938e-4_p
x(14)=12.98425870045424_p
w(14)=6.691792406929284e-6_p
x(15)=15.67187389595507_p
w(15)=3.704070165298604e-7_p
x(16)=17.51669285167844_p
w(16)=2.992706375215383e-8_p
else if(N==17)then
x(1)=-13.87620004757135_p
w(1)=3.171714677791100e-1_p
x(2)=-13.35242099622919_p
w(2)=7.276338234476614e-1_p
x(3)=-12.42925170512549_p
w(3)=1.113296241873162_p
x(4)=-11.1389681839015_p
w(4)=1.459518790123240_p
x(5)=-9.527905079851145_p
w(5)=1.752443173849688_p
x(6)=-7.656280199421328_p
w(6)=1.977206889313985_p
x(7)=-5.599946669035949_p
w(7)=2.110552368913473_p
x(8)=-3.457452602908422_p
w(8)=2.079166668483573_p
x(9)=-1.352924964192922_p
w(9)=1.631252449725149_p
x(10)=6.843617620212128e-1_p
w(10)=6.943355057600398e-1_p
x(11)=2.883994114623265_p
w(11)=1.244847463383483e-1_p
x(12)=5.381298666221161_p
w(12)=1.203957485591505e-2_p
x(13)=8.104509688166599_p
w(13)=8.452938121147406e-4_p
x(14)=10.93018651982882_p
w(14)=5.056639640145614e-5_p
x(15)=13.67463148000665_p
w(15)=3.012050285079269e-6_p
x(16)=16.03991593222705_p
w(16)=2.207333915844789e-7_p
x(17)=17.60086140599116_p
w(17)=2.284285612619348e-8_p
else
call GD(-14)
end if
end subroutine GF_m14

! [-13kT;18kT]
subroutine GF_m13(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.00429064176777_p
w(1)=7.068990961511478_p
x(2)=-2.046001459766678_p
w(2)=5.931011283585395_p
else if(N==3)then
x(1)=-11.28555317965211_p
w(1)=4.220004578180474_p
x(2)=-5.458807850513011_p
w(2)=6.536157672166158_p
x(3)=2.003783836619076e-1_p
w(3)=2.243839994750241_p
else if(N==4)then
x(1)=-11.8653297695197_p
w(1)=2.839518163778213_p
x(2)=-7.635714196979746_p
w(2)=5.245693682433703_p
x(3)=-2.338970467662945_p
w(3)=4.396934311830415_p
x(4)=2.270203613805108_p
w(4)=5.178560870545410e-1_p
else if(N==5)then
x(1)=-12.17806657409193_p
w(1)=2.073868083507494_p
x(2)=-8.973763225826827_p
w(2)=4.146634884348184_p
x(3)=-4.391304012741943_p
w(3)=4.640822962379998_p
x(4)=-1.387000951394489e-1_p
w(4)=2.079378870131486_p
x(5)=4.708464274465805_p
w(5)=5.929744472970996e-2_p
else if(N==6)then
x(1)=-12.36846869463231_p
w(1)=1.600965360373931_p
x(2)=-9.843130202430556_p
w(2)=3.343445973757478_p
x(3)=-5.972422870904460_p
w(3)=4.202544992906814_p
x(4)=-1.862224799322906_p
w(4)=3.286773809052745_p
x(5)=1.858346530987581_p
w(5)=5.619620465606687e-1_p
x(6)=7.455443540433068_p
w(6)=4.310062445235019e-3_p
else if(N==7)then
x(1)=-12.49566395725873_p
w(1)=1.282318306296219_p
x(2)=-10.44654356130102_p
w(2)=2.751030922845995_p
x(3)=-7.173385247947801_p
w(3)=3.678135608595326_p
x(4)=-3.368892295138327_p
w(4)=3.630936453214479_p
x(5)=1.172520497805143e-1_p
w(5)=1.574136775909635_p
x(6)=4.046728851587978_p
w(6)=8.315995762898212e-2_p
x(7)=10.22494896297631_p
w(7)=2.842206062369572e-4_p
else if(N==8)then
x(1)=-12.58694061556228_p
w(1)=1.052352498184927_p
x(2)=-10.89051569663085_p
w(2)=2.298701985106715_p
x(3)=-8.106470712676430_p
w(3)=3.193886123627177_p
x(4)=-4.684604698906876_p
w(4)=3.503792751491793_p
x(5)=-1.285389062212027_p
w(5)=2.492349614847234_p
x(6)=1.943780985664449_p
w(6)=4.494807023366176e-1_p
x(7)=6.322116968635509_p
w(7)=9.414165519515821e-3_p
x(8)=12.63438223897139_p
w(8)=2.440398289343491e-5_p
else if(N==9)then
x(1)=-12.65553043501753_p
w(1)=8.788623880207426e-1_p
x(2)=-11.22994695936299_p
w(2)=1.944299307585449_p
x(3)=-8.845944466503161_p
w(3)=2.772813212312560_p
x(4)=-5.807078740027360_p
w(4)=3.220203713980545_p
x(5)=-2.568533046784500_p
w(5)=2.921182425692860_p
x(6)=4.235508129431337e-1_p
w(6)=1.176421909119041_p
x(7)=3.821502762667619_p
w(7)=8.508686920744885e-2_p
x(8)=8.456853066221733_p
w(8)=1.128913783572003e-3_p
x(9)=14.41335261844113_p
w(9)=3.505394654489426e-6_p
else if(N==10)then
x(1)=-12.70849378778031_p
w(1)=7.445186139010680e-1_p
x(2)=-11.49529875826971_p
w(2)=1.662489981103179_p
x(3)=-9.438620831348187_p
w(3)=2.415371872273691_p
x(4)=-6.750204788457541_p
w(4)=2.906511082967076_p
x(5)=-3.743408897470208_p
w(5)=2.958164069511119_p
x(6)=-8.365418554504518e-1_p
w(6)=1.932808582295007_p
x(7)=2.031672734127552_p
w(7)=3.658483672126027e-1_p
x(8)=5.680713386890813_p
w(8)=1.412047672077148e-2_p
x(9)=10.31672026195318_p
w(9)=1.683465729371654e-4_p
x(10)=15.58230069239427_p
w(10)=8.525394216195338e-7_p
else if(N==11)then
x(1)=-12.75019773676728_p
w(1)=6.385139294493341e-1_p
x(2)=-11.70614439955122_p
w(2)=1.435804262962295_p
x(3)=-9.918091377758490_p
w(3)=2.114834018152526_p
x(4)=-7.537969424114954_p
w(4)=2.607341001304869_p
x(5)=-4.787736669744091_p
w(5)=2.816011082180183_p
x(6)=-1.981467098433390_p
w(6)=2.385737996811077_p
x(7)=6.582706978160331e-1_p
w(7)=9.136418855299262e-1_p
x(8)=3.648397504261147_p
w(8)=8.559525247454425e-2_p
x(9)=7.415810099486186_p
w(9)=2.489392207295916e-3_p
x(10)=11.85516352197709_p
w(10)=3.311426336105948e-5_p
x(11)=16.31736928545278_p
w(11)=3.097614615275330e-7_p
else if(N==12)then
x(1)=-12.78358983756648_p
w(1)=5.535023357490085e-1_p
x(2)=-11.87612935204811_p
w(2)=1.251372960791901_p
x(3)=-10.30984468800897_p
w(3)=1.862472350938643_p
x(4)=-8.196430056339048_p
w(4)=2.336856861197820_p
x(5)=-5.697763769710518_p
w(5)=2.614047954581029_p
x(6)=-3.039993370828774_p
w(6)=2.520273558224295_p
x(7)=-4.913626870609082e-1_p
w(7)=1.533478646109580_p
x(8)=2.090230506743223_p
w(8)=3.090093374915362e-1_p
x(9)=5.227833891907236_p
w(9)=1.847140429270249e-2_p
x(10)=8.967415229522764_p
w(10)=5.080800967430501e-4_p
x(11)=13.08217280820093_p
w(11)=8.608076444031599e-6_p
x(12)=16.7830720020922_p
w(12)=1.475471708141500e-7_p
else if(N==13)then
x(1)=-12.81072679533108_p
w(1)=4.843307560971818e-1_p
x(2)=-12.01500690496366_p
w(2)=1.099637842988198_p
x(3)=-10.63319133208462_p
w(3)=1.649933562733337_p
x(4)=-8.749142904570011_p
w(4)=2.097702514869149_p
x(5)=-6.483882622351717_p
w(5)=2.401716437367497_p
x(6)=-4.002650629509294_p
w(6)=2.473557739302207_p
x(7)=-1.528784277029052_p
w(7)=1.971604418578960_p
x(8)=8.442035538091901e-1_p
w(8)=7.321522711894564e-1_p
x(9)=3.512600713145374_p
w(9)=8.505608817482985e-2_p
x(10)=6.708041705131128_p
w(10)=4.183643902707430e-3_p
x(11)=10.31378171218977_p
w(11)=1.240152079308291e-4_p
x(12)=14.03916368746682_p
w(12)=2.870744230226238e-6_p
x(13)=17.08736862768956_p
w(13)=8.394118918109874e-8_p
else if(N==14)then
x(1)=-12.83307264573174_p
w(1)=4.273164598840967e-1_p
x(2)=-12.1298446389153_p
w(2)=9.734825364183034e-1_p
x(3)=-10.9027063726662_p
w(3)=1.470039770484807_p
x(4)=-9.215795620774870_p
w(4)=1.888207952755537_p
x(5)=-7.161478492516221_p
w(5)=2.198124980797782_p
x(6)=-4.863615933547150_p
w(6)=2.349843356513899_p
x(7)=-2.491175102836658_p
w(7)=2.162588476816298_p
x(8)=-2.131751713652427e-1_p
w(8)=1.239887722991839_p
x(9)=2.134438959334523_p
w(9)=2.672232112875464e-1_p
x(10)=4.892398657560520_p
w(10)=2.219619026611205e-2_p
x(11)=8.053945795620958_p
w(11)=1.053994947968702e-3_p
x(12)=11.45758307359718_p
w(12)=3.636057339214105e-5_p
x(13)=14.77823815910859_p
w(13)=1.177600433513769e-6_p
x(14)=17.29372123720455_p
w(14)=5.375885762394222e-8_p
else if(N==15)then
x(1)=-12.85168929387834_p
w(1)=3.797801020150230e-1_p
x(2)=-12.22583903041129_p
w(2)=8.675692839653137e-1_p
x(3)=-11.12943069891028_p
w(3)=1.316886428597579_p
x(4)=-9.612319865988864_p
w(4)=1.705258777862458_p
x(5)=-7.746251292574787_p
w(5)=2.010174109302576_p
x(6)=-5.626276932967317_p
w(6)=2.200188397927230_p
x(7)=-3.379181730010470_p
w(7)=2.183036486931839_p
x(8)=-1.165239899881307_p
w(8)=1.645558666308477_p
x(9)=9.965615824382459e-1_p
w(9)=6.015200084233567e-1_p
x(10)=3.405354025581104_p
w(10)=8.369090046297289e-2_p
x(11)=6.190494536440674_p
w(11)=6.023810384014134e-3_p
x(12)=9.252513679140433_p
w(12)=3.020037956983321e-4_p
x(13)=12.41587811037907_p
w(13)=1.266206628634847e-5_p
x(14)=15.34882218110988_p
w(14)=5.696990258678044e-7_p
x(15)=17.43876561511154_p
w(15)=3.735502394600614e-8_p
else if(N==16)then
x(1)=-12.86736098867921_p
w(1)=3.397381436460791e-1_p
x(2)=-12.30686892425884_p
w(2)=7.778527074358987e-1_p
x(3)=-11.32179449003633_p
w(3)=1.185701185007410_p
x(4)=-9.951454198674828_p
w(4)=1.545466132895888_p
x(5)=-8.252428319634166_p
w(5)=1.839697373519949_p
x(6)=-6.299100384527793_p
w(6)=2.046800171385047_p
x(7)=-4.188319388627124_p
w(7)=2.117197851877687_p
x(8)=-2.049034253807016_p
w(8)=1.865938132832623_p
x(9)=1.736162585154671e-2_p
w(9)=1.019337163775018_p
x(10)=2.169702375587331_p
w(10)=2.351317450009971e-1_p
x(11)=4.633434117514336_p
w(11)=2.526383158049893e-2_p
x(12)=7.384526424947437_p
w(12)=1.773476252461423e-3_p
x(13)=10.30458252524623_p
w(13)=9.885014618520247e-5_p
x(14)=13.21243936815844_p
w(14)=5.138746753341736e-6_p
x(15)=15.79193427348853_p
w(15)=3.134811227724318e-7_p
x(16)=17.54404402900678_p
w(16)=2.751325472474384e-8_p
else if(N==17)then
x(1)=-12.88067666614486_p
w(1)=3.056981569496894e-1_p
x(2)=-12.3758720644434_p
w(2)=7.012322259426198e-1_p
x(3)=-11.48629644005952_p
w(3)=1.072649370976595_p
x(4)=-10.24335692519719_p
w(4)=1.405632314860618_p
x(5)=-8.692273823966715_p
w(5)=1.686373000086326_p
x(6)=-6.892206726956588_p
w(6)=1.899079950565435_p
x(7)=-4.918754310734871_p
w(7)=2.014725349654901_p
x(8)=-2.871648809448804_p
w(8)=1.933960633639214_p
x(9)=-8.649501536119434e-1_p
w(9)=1.385793015219004_p
x(10)=1.123854082504152_p
w(10)=5.045472485729855e-1_p
x(11)=3.318789614782772_p
w(11)=8.182024103110169e-2_p
x(12)=5.792868716676359_p
w(12)=7.875446631031043e-3_p
x(13)=8.465954090308937_p
w(13)=5.759325058741065e-4_p
x(14)=11.21913105645067_p
w(14)=3.676772606611116e-5_p
x(15)=13.87248330099864_p
w(15)=2.378971311788511e-6_p
x(16)=16.139324560576_p
w(16)=1.906085647419336e-7_p
x(17)=17.62262531189385_p
w(17)=2.115553569144534e-8_p
else
call GD(-13)
end if
end subroutine GF_m13

! [-12kT;18kT]
subroutine GF_m12(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-9.200741749330934_p
w(1)=6.602045548441724_p
x(2)=-1.780566909509512_p
w(2)=5.397960580521775_p
else if(N==3)then
x(1)=-10.38632929106257_p
w(1)=3.970881372332189_p
x(2)=-4.914404737454593_p
w(2)=6.097462517118777_p
x(3)=4.416580056656910e-1_p
w(3)=1.931662239512532_p
else if(N==4)then
x(1)=-10.92570542722799_p
w(1)=2.687892088998946_p
x(2)=-6.926623661640489_p
w(2)=4.948348677687689_p
x(3)=-1.950213130054301_p
w(3)=3.967119273395801_p
x(4)=2.581768101656396_p
w(4)=3.966460888810611e-1_p
else if(N==5)then
x(1)=-11.21813887099439_p
w(1)=1.972441226281856_p
x(2)=-8.173082467000834_p
w(2)=3.935533876668462_p
x(3)=-3.839201140848177_p
w(3)=4.326024549947708_p
x(4)=1.966527300572662e-1_p
w(4)=1.725568805628615_p
x(5)=5.108033887253724_p
w(5)=4.043767043685694e-2_p
else if(N==6)then
x(1)=-11.39716172581411_p
w(1)=1.528024677721243_p
x(2)=-8.988409515929007_p
w(2)=3.186343095959254_p
x(3)=-5.307827409327287_p
w(3)=3.972705332887024_p
x(4)=-1.431299613237314_p
w(4)=2.900613751433776_p
x(5)=2.237621855860763_p
w(5)=4.095644268352203e-1_p
x(6)=7.908310777473318_p
w(6)=2.754844126980778e-3_p
else if(N==7)then
x(1)=-11.51751245765172_p
w(1)=1.226635160995563_p
x(2)=-9.558332731448163_p
w(2)=2.628643474588333_p
x(3)=-6.435422894153708_p
w(3)=3.498920353307645_p
x(4)=-2.831168894429182_p
w(4)=3.341417841553527_p
x(5)=5.023759336201407e-1_p
w(5)=1.249403325982212_p
x(6)=4.482086237767536_p
w(6)=5.480554486720692e-2_p
x(7)=10.67283760960948_p
w(7)=1.804276690110850e-4_p
else if(N==8)then
x(1)=-11.60433041410583_p
w(1)=1.007962191280201_p
x(2)=-9.980075838677202_p
w(2)=2.199893180083918_p
x(3)=-7.318432322607054_p
w(3)=3.048173790049335_p
x(4)=-4.062260021822873_p
w(4)=3.292743116876207_p
x(5)=-8.473835451493283e-1_p
w(5)=2.129327688685462_p
x(6)=2.355115241052773_p
w(6)=3.158705151057771e-1_p
x(7)=6.769299699462262_p
w(7)=6.019303164651856e-3_p
x(8)=13.00926487763826_p
w(8)=1.634371794589720e-5_p
else if(N==9)then
x(1)=-11.66974666983293_p
w(1)=8.425339682185512e-1_p
x(2)=-10.3034894778412_p
w(2)=1.862734076843159_p
x(3)=-8.021181642147202_p
w(3)=2.651551675702634_p
x(4)=-5.120831497167862_p
w(4)=3.055311234049790_p
x(5)=-2.053677739721363_p
w(5)=2.632658337104124_p
x(6)=8.310206903572510e-1_p
w(6)=8.988039505250032e-1_p
x(7)=4.259376446094812_p
w(7)=5.567828437534346e-2_p
x(8)=8.878308398193077_p
w(8)=7.320526603368382e-4_p
x(9)=14.68544641951508_p
w(9)=2.549484555971135e-6_p
else if(N==10)then
x(1)=-11.72032373548733_p
w(1)=7.142645487017452e-1_p
x(2)=-10.5566953163227_p
w(2)=1.594132604878041_p
x(3)=-8.585666787463619_p
w(3)=2.312974084095937_p
x(4)=-6.014602339371193_p
w(4)=2.770842309354201_p
x(5)=-3.155531555554714_p
w(5)=2.748995837322353_p
x(6)=-3.952517988670243e-1_p
w(6)=1.597960998752769_p
x(7)=2.457133860241830_p
w(7)=2.516323687241274e-1_p
x(8)=6.117141508154223_p
w(8)=9.089438694968241e-3_p
x(9)=10.69122572589092_p
w(9)=1.132700600900078e-4_p
x(10)=15.76648847668192_p
w(10)=6.683792664088232e-7_p
else if(N==11)then
x(1)=-11.7601848324108_p
w(1)=6.129578103815642e-1_p
x(2)=-10.75810364835315_p
w(2)=1.377784556548020_p
x(3)=-9.043029299862917_p
w(3)=2.027353151627138_p
x(4)=-6.763486723231306_p
w(4)=2.492412634579165_p
x(5)=-4.139755948496075_p
w(5)=2.657093723461411_p
x(6)=-1.480584345341711_p
w(6)=2.098389730087173_p
x(7)=1.082148233674514_p
w(7)=6.766261601318097e-1_p
x(8)=4.087956619799201_p
w(8)=5.574164690765938e-2_p
x(9)=7.829818442866729_p
w(9)=1.623111559420187e-3_p
x(10)=12.17420011660227_p
w(10)=2.334704926616552e-5_p
x(11)=16.44108721772902_p
w(11)=2.566308704941758e-7_p
else if(N==12)then
x(1)=-11.79212762555165_p
w(1)=5.316449938965983e-1_p
x(2)=-10.92063247009089_p
w(2)=1.201566019745317_p
x(3)=-9.417189031818243_p
w(3)=1.786964520023111_p
x(4)=-7.390850502599360_p
w(4)=2.237779819312562_p
x(5)=-5.001579436193899_p
w(5)=2.485321111613269_p
x(6)=-2.475897636744831_p
w(6)=2.306811651560259_p
x(7)=-4.370854603815320e-2_p
w(7)=1.228574882610136_p
x(8)=2.526347888107900_p
w(8)=2.091011933537019e-1_p
x(9)=5.661811913121202_p
w(9)=1.189498654129237e-2_p
x(10)=9.346999658594681_p
w(10)=3.404570817351146e-4_p
x(11)=13.3464667584231_p
w(11)=6.366277140017698e-6_p
x(12)=16.86816236062179_p
w(12)=1.269483763209887e-7_p
else if(N==13)then
x(1)=-11.81810624991097_p
w(1)=4.654321138320869e-1_p
x(2)=-11.05352964283386_p
w(2)=1.056446462052673_p
x(3)=-9.726343205038949_p
w(3)=1.584159037923775_p
x(4)=-7.918351569533080_p
w(4)=2.011259762859254_p
x(5)=-5.748714406757115_p
w(5)=2.292811322253696_p
x(6)=-3.383098382974097_p
w(6)=2.314244187063403_p
x(7)=-1.035016282678696_p
w(7)=1.689357648954466_p
x(8)=1.281286029853505_p
w(8)=5.283715753503350e-1_p
x(9)=3.955174439343453_p
w(9)=5.511052020829769e-2_p
x(10)=7.121961676197698_p
w(10)=2.725224795377943e-3_p
x(11)=10.65348915517035_p
w(11)=8.598187422256489e-5_p
x(12)=14.25487788876962_p
w(12)=2.217691782674399e-6_p
x(13)=17.14790659936132_p
w(13)=7.410412946531685e-8_p
else if(N==14)then
x(1)=-11.83951265901031_p
w(1)=4.108190141347318e-1_p
x(2)=-11.16350351255419_p
w(2)=9.356898788277814e-1_p
x(3)=-9.984262199938799_p
w(3)=1.412270912965688_p
x(4)=-8.364308904831065_p
w(4)=1.812090994540578_p
x(5)=-6.394341011669161_p
w(5)=2.103579563487555_p
x(6)=-4.197992204227490_p
w(6)=2.223859486549776_p
x(7)=-1.943699055566547_p
w(7)=1.943340211074137_p
x(8)=2.415932972285575e-1_p
w(8)=9.648400897869341e-1_p
x(9)=2.578813097216854_p
w(9)=1.785187668952522e-1_p
x(10)=5.326966503226823_p
w(10)=1.426790052915344e-2_p
x(11)=8.439587883826377_p
w(11)=7.021853806353628e-4_p
x(12)=11.75660152093174_p
w(12)=2.613233215904736e-5_p
x(13)=14.95352491673189_p
w(13)=9.441445141745543e-7_p
x(14)=17.33828617202487_p
w(14)=4.831460184429385e-8_p
else if(N==15)then
x(1)=-11.8573573292855_p
w(1)=3.652568772041010e-1_p
x(2)=-11.25549206655305_p
w(2)=8.342351021125080e-1_p
x(3)=-10.20140026672479_p
w(3)=1.265773127686472_p
x(4)=-8.743653730442880_p
w(4)=1.637722826018926_p
x(5)=-6.952556845745395_p
w(5)=1.926787969923365_p
x(6)=-4.922514495989062_p
w(6)=2.095127494015764_p
x(7)=-2.781356823090839_p
w(7)=2.019179347709954_p
x(8)=-6.745397483764067e-1_p
w(8)=1.372897722630305_p
x(9)=1.444051951644687_p
w(9)=4.249230801704557e-1_p
x(10)=3.851114855455598_p
w(10)=5.397284549337199e-2_p
x(11)=6.606554017867678_p
w(11)=3.912972197698204e-3_p
x(12)=9.606011344941400_p
w(12)=2.068365978778982e-4_p
x(13)=12.67637360590341_p
w(13)=9.422288898481646e-6_p
x(14)=15.49164543638136_p
w(14)=4.709098470941204e-7_p
x(15)=17.47259992738383_p
w(15)=3.400395484551357e-8_p
else if(N==16)then
x(1)=-11.87238719595078_p
w(1)=3.268570169004473e-1_p
x(2)=-11.33318536523719_p
w(2)=7.482404085328923e-1_p
x(3)=-10.38575464544885_p
w(3)=1.140175256426774_p
x(4)=-9.068382463117590_p
w(4)=1.485149777349106_p
x(5)=-7.436427031677251_p
w(5)=1.765373273423151_p
x(6)=-5.563451458388918_p
w(6)=1.956003519528749_p
x(7)=-3.546998426713573_p
w(7)=1.990200637581028_p
x(8)=-1.513133494845851_p
w(8)=1.642444736333475_p
x(9)=4.789543758324653e-1_p
w(9)=7.726431166204528e-1_p
x(10)=2.620554400903134_p
w(10)=1.554707386512989e-1_p
x(11)=5.069735850286339_p
w(11)=1.619908610213997e-2_p
x(12)=7.776069717605775_p
w(12)=1.174600087768769e-3_p
x(13)=10.6249872815065_p
w(13)=6.972262896341518e-5_p
x(14)=13.43816628908345_p
w(14)=3.947933606009487e-6_p
x(15)=15.90911977024447_p
w(15)=2.655814138502908e-7_p
x(16)=17.57042920941591_p
w(16)=2.528223130931324e-8_p
else if(N==17)then
x(1)=-11.88516365321955_p
w(1)=2.941971054273781e-1_p
x(2)=-11.39938107502454_p
w(2)=6.747573097466147e-1_p
x(3)=-10.54350005526305_p
w(3)=1.031855936972743_p
x(4)=-9.348094693724192_p
w(4)=1.351450640020165_p
x(5)=-7.857355426201161_p
w(5)=1.619611317247401_p
x(6)=-6.129592703050248_p
w(6)=1.818848768393990_p
x(7)=-4.240577559489550_p
w(7)=1.910951922800468_p
x(8)=-2.290600382346787_p
w(8)=1.763722122886785_p
x(9)=-3.748884924152899e-1_p
w(9)=1.126367474397032_p
x(10)=1.579565497482049_p
w(10)=3.501800715114092e-1_p
x(11)=3.767605674689922_p
w(11)=5.254541535250801e-2_p
x(12)=6.211832063820950_p
w(12)=5.098713564922941e-3_p
x(13)=8.830073016471992_p
w(13)=3.905648703528470e-4_p
x(14)=11.50738659523166_p
w(14)=2.670126838884907e-5_p
x(15)=14.06777793009786_p
w(15)=1.880217263126504e-6_p
x(16)=16.23635684308397_p
w(16)=1.647066302680661e-7_p
x(17)=17.64367945426898_p
w(17)=1.957944588116120e-8_p
else
call GD(-12)
end if
end subroutine GF_m12

! [-11kT;18kT]
subroutine GF_m11(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-8.395771313553448_p
w(1)=6.137600681943390_p
x(2)=-1.506529859890634_p
w(2)=4.862416004387949_p
else if(N==3)then
x(1)=-9.486311285263415_p
w(1)=3.723447144925419_p
x(2)=-4.368261888967542_p
w(2)=5.649025406373128_p
x(3)=7.022448101580946e-1_p
w(3)=1.627544135032791_p
else if(N==4)then
x(1)=-9.985667037261896_p
w(1)=2.537179763339293_p
x(2)=-6.216522026668802_p
w(2)=4.648148617244765_p
x(3)=-1.557406226545763_p
w(3)=3.520808757428958_p
x(4)=2.922331402785654_p
w(4)=2.938795483183227e-1_p
else if(N==5)then
x(1)=-10.2580180839872_p
w(1)=1.871433558026681_p
x(2)=-7.371942936064552_p
w(2)=3.723373833801963_p
x(3)=-3.288645124267503_p
w(3)=3.990154434353966_p
x(4)=5.506997243962932e-1_p
w(4)=1.388301063290843_p
x(5)=5.535550179329252_p
w(5)=2.675379685788628e-2_p
else if(N==6)then
x(1)=-10.42580825395278_p
w(1)=1.455160417717738_p
x(2)=-8.133726172931251_p
w(2)=3.028460433959817_p
x(3)=-4.645196167431559_p
w(3)=3.731884400794399_p
x(4)=-9.977449049898255e-1_p
w(4)=2.495714376394387_p
x(5)=2.646048608503764_p
w(5)=2.870754405820679e-1_p
x(6)=8.382002526890966_p
w(6)=1.721616882930026e-3_p
else if(N==7)then
x(1)=-10.53939938896567_p
w(1)=1.170827610773433_p
x(2)=-8.670472067309809_p
w(2)=2.505478921316236_p
x(3)=-5.699343016113311_p
w(3)=3.314097230728122_p
x(4)=-2.298055614955630_p
w(4)=3.021141561312854_p
x(5)=9.067927214766723e-1_p
w(5)=9.532394578208450e-1_p
x(6)=4.940826762593835_p
w(6)=3.511860150398578e-2_p
x(7)=11.12834611284963_p
w(7)=1.133028758631778e-4_p
else if(N==8)then
x(1)=-10.62177992332299_p
w(1)=9.634015949564498e-1_p
x(2)=-9.070035139802398_p
w(2)=2.100414874340136_p
x(3)=-6.531943839333562_p
w(3)=2.899309940321727_p
x(4)=-3.444802575979997_p
w(4)=3.061376631843351_p
x(5)=-4.046677696683257e-1_p
w(5)=1.758067514283680_p
x(6)=2.791947391113616_p
w(6)=2.136508312976832e-1_p
x(7)=7.230432475102330_p
w(7)=3.784348010979058e-3_p
x(8)=13.37862699187506_p
w(8)=1.095127733307492e-5_p
else if(N==9)then
x(1)=-10.68401522723252_p
w(1)=8.060589873291985e-1_p
x(2)=-9.377361365808918_p
w(2)=1.780658978467661_p
x(3)=-7.197570376962200_p
w(3)=2.528381939814410_p
x(4)=-4.438186883603310_p
w(4)=2.879486046551976_p
x(5)=-1.542645104317581_p
w(5)=2.312150304365403_p
x(6)=1.258665845342910_p
w(6)=6.572731721505335e-1_p
x(7)=4.716517663002463_p
w(7)=3.553501689304420e-2_p
x(8)=9.306106694921580_p
w(8)=4.703766928503604e-4_p
x(9)=14.9473213513411_p
w(9)=1.864066261706637e-6_p
else if(N==10)then
x(1)=-10.7321958148074_p
w(1)=6.838930729621755e-1_p
x(2)=-9.618349991267568_p
w(2)=1.525391101504537_p
x(3)=-7.733565336368454_p
w(3)=2.209337272204234_p
x(4)=-5.281525071376556_p
w(4)=2.629268194889961_p
x(5)=-2.573134892692347_p
w(5)=2.511984552263390_p
x(6)=5.441672668784674e-2_p
w(6)=1.267458539913859_p
x(7)=2.905558166897284_p
w(7)=1.668462217776358e-1_p
x(8)=6.565799043087750_p
w(8)=5.761283103895599e-3_p
x(9)=11.06660587945016_p
w(9)=7.592105148741066e-5_p
x(10)=15.94179860606534_p
w(10)=5.266601639532981e-7_p
else if(N==11)then
x(1)=-10.77020638629664_p
w(1)=5.873060201996485e-1_p
x(2)=-9.810269551059269_p
w(2)=1.319466510183342_p
x(3)=-8.168620142721009_p
w(3)=1.939013815848964_p
x(4)=-5.990818602913160_p
w(4)=2.374080071832927_p
x(5)=-3.496358739800704_p
w(5)=2.480960521933331_p
x(6)=-9.809949274984366e-1_p
w(6)=1.784007842579129_p
x(7)=1.526435034537780_p
w(7)=4.786598924066041e-1_p
x(8)=4.544711028095406_p
w(8)=3.545701816185223e-2_p
x(9)=8.250655708486294_p
w(9)=1.048327013667982e-3_p
x(10)=12.49075808126748_p
w(10)=1.645282768129420e-5_p
x(11)=16.55855124254945_p
w(11)=2.133441919524823e-7_p
else if(N==12)then
x(1)=-10.80069418241652_p
w(1)=5.097080351193244e-1_p
x(2)=-9.965305035147159_p
w(2)=1.151520558928178_p
x(3)=-8.525049451439294_p
w(3)=1.710830055260851_p
x(4)=-6.586623610198846_p
w(4)=2.136589009745649_p
x(5)=-4.308822895283074_p
w(5)=2.346759766825976_p
x(6)=-1.916817318781342_p
w(6)=2.061204061978854_p
x(7)=4.151220448863039e-1_p
w(7)=9.390139363366514e-1_p
x(8)=2.983320931326684_p
w(8)=1.366120926741587e-1_p
x(9)=6.107117039624723_p
w(9)=7.547435371285171e-3_p
x(10)=9.729470367229711_p
w(10)=2.269106114228051e-4_p
x(11)=13.6067464779566_p
w(11)=4.714041395149670e-6_p
x(12)=16.94909565005951_p
w(12)=1.094375928473029e-7_p
else if(N==13)then
x(1)=-10.82551004771142_p
w(1)=4.464662735379766e-1_p
x(2)=-10.09219364251024_p
w(2)=1.013060289333164_p
x(3)=-8.819912667965841_p
w(3)=1.517908599212374_p
x(4)=-7.088602003461600_p
w(4)=1.923413964046125_p
x(5)=-5.016082372447194_p
w(5)=2.178191355787506_p
x(6)=-2.768672527856756_p
w(6)=2.131449240742158_p
x(7)=-5.397308463889895e-1_p
w(7)=1.388716770709525_p
x(8)=1.738272879708120_p
w(8)=3.640739421129245e-1_p
x(9)=4.413355733681505_p
w(9)=3.491667644714920e-2_p
x(10)=7.542815305705009_p
w(10)=1.758336411572956e-3_p
x(11)=10.99339620248329_p
w(11)=5.945626520720566e-5_p
x(12)=14.46625996934446_p
w(12)=1.716248140263031e-6_p
x(13)=17.20568159552451_p
w(13)=6.547751708565959e-8_p
else if(N==14)then
x(1)=-10.84597346576505_p
w(1)=3.942642747124064e-1_p
x(2)=-10.19728158936881_p
w(2)=8.977355555686453e-1_p
x(3)=-9.066161993211908_p
w(3)=1.354129424203603_p
x(4)=-7.513646249115703_p
w(4)=1.734989713904134_p
x(5)=-5.629114537770821_p
w(5)=2.005546976111245_p
x(6)=-3.536558740724318_p
w(6)=2.083220402010331_p
x(7)=-1.399985867352423_p
w(7)=1.691737500245943_p
x(8)=7.093854593737516e-1_p
w(8)=7.135521597342454e-1_p
x(9)=3.042203618166108_p
w(9)=1.153153546014929e-1_p
x(10)=5.772148512706086_p
w(10)=9.040794610080654e-3_p
x(11)=8.828982556034187_p
w(11)=4.649643195850214e-4_p
x(12)=12.05416990386622_p
w(12)=1.876461003602829e-5_p
x(13)=15.12479106195477_p
w(13)=7.582702349173734e-7_p
x(14)=17.38097520092225_p
w(14)=4.342935614839960e-8_p
else if(N==15)then
x(1)=-10.86304326280304_p
w(1)=3.506843977261538e-1_p
x(2)=-10.28524668580411_p
w(2)=8.007649887089178e-1_p
x(3)=-9.273657230290288_p
w(3)=1.214360966076757_p
x(4)=-7.875653761576484_p
w(4)=1.569464710753883_p
x(5)=-6.160338145953735_p
w(5)=1.841153284009211_p
x(6)=-4.221985611371975_p
w(6)=1.981208302895962_p
x(7)=-2.188634555860622_p
w(7)=1.826969184722383_p
x(8)=-1.796646339087214e-1_p
w(8)=1.091924039808461_p
x(9)=1.910583422469489_p
w(9)=2.867547638974503e-1_p
x(10)=4.311201491197683_p
w(10)=3.406590450571208e-2_p
x(11)=7.029510440688034_p
w(11)=2.517577139985381e-3_p
x(12)=9.961011268937096_p
w(12)=1.411332099990042e-4_p
x(13)=12.93454553857846_p
w(13)=7.012141409543523e-6_p
x(14)=15.63099444730149_p
w(14)=3.897903908958313e-7_p
x(15)=17.50512495784881_p
w(15)=3.094466322034025e-8_p
else if(N==16)then
x(1)=-10.87742891339621_p
w(1)=3.139332393139661e-1_p
x(2)=-10.35958910776218_p
w(2)=7.185125562575656e-1_p
x(3)=-9.449957804127122_p
w(3)=1.094404932526244_p
x(4)=-8.185858944802458_p
w(4)=1.424284196439567_p
x(5)=-6.621592702730013_p
w(5)=1.689522107890136_p
x(6)=-4.830286851088291_p
w(6)=1.859750703864200_p
x(7)=-2.910354549646899_p
w(7)=1.843505783238058_p
x(8)=-9.792356496293880e-1_p
w(8)=1.390111310855088_p
x(9)=9.546425377896195e-1_p
w(9)=5.553883545807037e-1_p
x(10)=3.088839350121139_p
w(10)=9.953610821650087e-2_p
x(11)=5.516059048454613_p
w(11)=1.024211065313684e-2_p
x(12)=8.171811825935780_p
w(12)=7.729244093414414e-4_p
x(13)=10.94536878083328_p
w(13)=4.907484461192199e-5_p
x(14)=13.66121909928562_p
w(14)=3.034802506930352e-6_p
x(15)=16.02340599578281_p
w(15)=2.252213321453203e-7_p
x(16)=17.59587473460386_p
w(16)=2.321838042229361e-8_p
else if(N==17)then
x(1)=-10.88966416365349_p
w(1)=2.826588802899327e-1_p
x(2)=-10.4229656751752_p
w(2)=6.481832303488663e-1_p
x(3)=-9.600911236892946_p
w(3)=9.908594200767075e-1_p
x(4)=-8.453290358067147_p
w(4)=1.296838957490553_p
x(5)=-7.023379284434117_p
w(5)=1.551764320738201_p
x(6)=-5.368913301584390_p
w(6)=1.735128191522642_p
x(7)=-3.566225592884645_p
w(7)=1.794534749949524_p
x(8)=-1.714080549558670_p
w(8)=1.562599769378496_p
x(9)=1.216058042925933e-1_p
w(9)=8.684200622771687e-1_p
x(10)=2.053309925747614_p
w(10)=2.324252435138628e-1_p
x(11)=4.229683132436014_p
w(11)=3.304961062171903e-2_p
x(12)=6.637595455294715_p
w(12)=3.269525017691127e-3_p
x(13)=9.196439600413910_p
w(13)=2.637067972661225e-4_p
x(14)=11.79464529397856_p
w(14)=1.937069173739377e-5_p
x(15)=14.26036607410118_p
w(15)=1.487101618777116e-6_p
x(16)=16.33100712722884_p
w(16)=1.424090163259511e-7_p
x(17)=17.66404148293661_p
w(17)=1.810633525556829e-8_p
else
call GD(-11)
end if
end subroutine GF_m11

! [-10kT;18kT]
subroutine GF_m10(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-7.589292329096467_p
w(1)=5.675310437732342_p
x(2)=-1.221803349028170_p
w(2)=4.324734945936895_p
else if(N==3)then
x(1)=-8.585506607718138_p
w(1)=3.477502930651481_p
x(2)=-3.820562918418062_p
w(2)=5.186805038367709_p
x(3)=9.860274622435002e-1_p
w(3)=1.335737414650048_p
else if(N==4)then
x(1)=-9.045250811133837_p
w(1)=2.387205617054772_p
x(2)=-5.505854493626612_p
w(2)=4.342511152034493_p
x(3)=-1.158345004151023_p
w(3)=3.060437956394330_p
x(4)=3.294979854818199_p
w(4)=2.098906581856415e-1_p
else if(N==5)then
x(1)=-9.297749228519610_p
w(1)=1.770682365319770_p
x(2)=-6.570725190608528_p
w(2)=3.508799559867631_p
x(3)=-2.740084013142813_p
w(3)=3.627156168288236_p
x(4)=9.282963992003270e-1_p
w(4)=1.076254898900406_p
x(5)=5.992267950664147_p
w(5)=1.715239129319539e-2_p
else if(N==6)then
x(1)=-9.454454488740080_p
w(1)=1.382223516531413_p
x(2)=-7.279401333254429_p
w(2)=2.868975115903507_p
x(3)=-3.985579285078923_p
w(3)=3.474436038954691_p
x(4)=-5.579395608912356e-1_p
w(4)=2.080226964586468_p
x(5)=3.085809774162394_p
w(5)=1.931316271329109e-1_p
x(6)=8.876134710641553_p
w(6)=1.052120560246895e-3_p
else if(N==7)then
x(1)=-9.561361424028583_p
w(1)=1.114780065614180_p
x(2)=-7.783199897427606_p
w(2)=2.381011720298273_p
x(3)=-4.965995638636860_p
w(3)=3.120349227072198_p
x(4)=-1.768939390590614_p
w(4)=2.666667925137524_p
x(5)=1.335324680947154_p
w(5)=6.952719755302331e-1_p
x(6)=5.422654026107335_p
w(6)=2.189397453736520e-2_p
x(7)=11.58926661509273_p
w(7)=7.049547946456944e-5_p
else if(N==8)then
x(1)=-9.639313951199268_p
w(1)=9.185909573409080e-1_p
x(2)=-8.160552964630545_p
w(2)=1.999929957526028_p
x(3)=-5.747581436673296_p
w(3)=2.745439977728643_p
x(4)=-2.833039518968238_p
w(4)=2.802080340509836_p
x(5)=4.786423795963441e-2_p
w(5)=1.392555824889556_p
x(6)=3.255265933236099_p
w(6)=1.390997782153340e-1_p
x(7)=7.704669457577169_p
w(7)=2.341194559793867e-3_p
x(8)=13.74044410618997_p
w(8)=7.352899137778191e-6_p
else if(N==9)then
x(1)=-9.698354128168834_p
w(1)=7.693787118356690e-1_p
x(2)=-8.451676466594494_p
w(2)=1.697842416877457_p
x(3)=-6.375511480142995_p
w(3)=2.402212877834421_p
x(4)=-3.760117412288610_p
w(4)=2.686982508842310_p
x(5)=-1.032994798682051_p
w(5)=1.962776282430886_p
x(6)=1.710438407546463_p
w(6)=4.584068801492008e-1_p
x(7)=5.192368773350856_p
w(7)=2.214462446129464e-2_p
x(8)=9.739260298682114_p
w(8)=2.997103263589463e-4_p
x(9)=15.19823348147899_p
w(9)=1.370911640409709e-6_p
else if(N==10)then
x(1)=-9.744124345305730_p
w(1)=6.533574803890932e-1_p
x(2)=-8.680350963479563_p
w(2)=1.456094713877848_p
x(3)=-6.882612469350875_p
w(3)=2.103772309353384_p
x(4)=-4.551778118216887_p
w(4)=2.478238983924215_p
x(5)=-1.996175164905593_p
w(5)=2.240507499401720_p
x(6)=5.179652020738411e-1_p
w(6)=9.576415743838962e-1_p
x(7)=3.377289682295312_p
w(7)=1.067831156488258e-1_p
x(8)=7.025956029659383_p
w(8)=3.598561526394931e-3_p
x(9)=11.44193550773199_p
w(9)=5.072806923776094e-5_p
x(10)=16.10819167487464_p
w(10)=4.170946224748485e-7_p
else if(N==11)then
x(1)=-9.780274129722386_p
w(1)=5.615203204234768e-1_p
x(2)=-8.862712729040330_p
w(2)=1.260718973423223_p
x(3)=-7.295090529141556_p
w(3)=1.849352906535910_p
x(4)=-5.220581961104522_p
w(4)=2.250196739514251_p
x(5)=-2.858393454644960_p
w(5)=2.279943639329030_p
x(6)=-4.788256128698065e-1_p
w(6)=1.452601100142539_p
x(7)=1.994059819330667_p
w(7)=3.229658907068759e-1_p
x(8)=5.017950664402065_p
w(8)=2.206291192329858e-2_p
x(9)=8.677583407443574_p
w(9)=6.711289230147631e-4_p
x(10)=12.80413453059459_p
w(10)=1.159481131403169e-5_p
x(11)=16.66989550598699_p
w(11)=1.779363047457730e-7_p
else if(N==12)then
x(1)=-9.809299224920112_p
w(1)=4.876597475600442e-1_p
x(2)=-9.010204501438706_p
w(2)=1.101133171233278_p
x(3)=-7.633603635632036_p
w(3)=1.633741651640544_p
x(4)=-5.784218431416999_p
w(4)=2.031944901318022_p
x(5)=-3.620435201307120_p
w(5)=2.192758241729405_p
x(6)=-1.361515587238788_p
w(6)=1.780902078112877_p
x(7)=8.903396125698021e-1_p
w(7)=6.806714187369794e-1_p
x(8)=3.461059982669358_p
w(8)=8.635737159373102e-2_p
x(9)=6.563016833525464_p
w(9)=4.722711218331168e-3_p
x(10)=10.11414969346123_p
w(10)=1.505001188973537e-4_p
x(11)=13.86256487502577_p
w(11)=3.495900617019637e-6_p
x(12)=17.02600003903503_p
w(12)=9.450650961154079e-8_p
else if(N==13)then
x(1)=-9.832946311114043_p
w(1)=4.274066508277373e-1_p
x(2)=-9.131046247589234_p
w(2)=9.693960757871334e-1_p
x(3)=-7.914041824580314_p
w(3)=1.450941221736217_p
x(4)=-6.260255643973017_p
w(4)=1.833290617338389_p
x(5)=-4.286789855918490_p
w(5)=2.054208547253532_p
x(6)=-2.159711570119551_p
w(6)=1.917329932012137_p
x(7)=-3.814755251399848e-2_p
w(7)=1.085021378056304_p
x(8)=2.217209764303874_p
w(8)=2.396137451479048e-1_p
x(9)=4.886344918027452_p
w(9)=2.167042074592430e-2_p
x(10)=7.969949188255635_p
w(10)=1.124383234541236e-3_p
x(11)=11.3329396560843_p
w(11)=4.102291724700500e-5_p
x(12)=14.67306235241287_p
w(12)=1.330716629821082e-6_p
x(13)=17.26078502817785_p
w(13)=5.789553979857350e-8_p
else if(N==14)then
x(1)=-9.852461918302279_p
w(1)=3.776297259758287e-1_p
x(2)=-9.231218344834506_p
w(2)=8.595513545136682e-1_p
x(3)=-8.148521372898372_p
w(3)=1.295431750339130_p
x(4)=-6.664091451853589_p
w(4)=1.656306718258838_p
x(5)=-4.866440301675383_p
w(5)=1.901689123191645_p
x(6)=-2.880175596744476_p
w(6)=1.920587492458294_p
x(7)=-8.575457201586979e-1_p
w(7)=1.411129984530643_p
x(8)=1.194768976014224_p
w(8)=4.995216550468180e-1_p
x(9)=3.524244255747639_p
w(9)=7.222463014049406e-2_p
x(10)=6.227207267712363_p
w(10)=5.652678485722136e-3_p
x(11)=9.221559118843235_p
w(11)=3.061555343052141e-4_p
x(12)=12.34985751976487_p
w(12)=1.346611246364232e-5_p
x(13)=15.29191466246352_p
w(13)=6.100427412483816e-7_p
x(14)=17.42184887742935_p
w(14)=3.903864663226058e-8_p
else if(N==15)then
x(1)=-9.868752925857965_p
w(1)=3.360434128228146e-1_p
x(2)=-9.315136156808567_p
w(2)=7.671022056529030e-1_p
x(3)=-8.346297075769778_p
w(3)=1.162506243452724_p
x(4)=-7.008547028351576_p
w(4)=1.500059221716044_p
x(5)=-5.370100887372193_p
w(5)=1.751740742544259_p
x(6)=-3.525585116644655_p
w(6)=1.853065125496511_p
x(7)=-1.600531921087377_p
w(7)=1.600666205441639_p
x(8)=3.245237516443592e-1_p
w(8)=8.208562581779193e-1_p
x(9)=2.397502560281079_p
w(9)=1.852140224643779e-1_p
x(10)=4.784767572846392_p
w(10)=2.108504264883075e-2_p
x(11)=7.458748539301380_p
w(11)=1.605353580063762e-3_p
x(12)=10.31703185246618_p
w(12)=9.597848583633433e-5_p
x(13)=13.19008459264376_p
w(13)=5.219961755089956e-6_p
x(14)=15.76681667700527_p
w(14)=3.230750788423847e-7_p
x(15)=17.53638030401609_p
w(15)=2.814848025980697e-8_p
else if(N==16)then
x(1)=-9.882491143626153_p
w(1)=3.009502099339335e-1_p
x(2)=-9.386108458881743_p
w(2)=6.886213429485980e-1_p
x(3)=-8.514483847117969_p
w(3)=1.048275111090472_p
x(4)=-7.304068463033543_p
w(4)=1.362555718769773_p
x(5)=-5.808326821634830_p
w(5)=1.611111038807953_p
x(6)=-4.100385687158168_p
w(6)=1.754396237359564_p
x(7)=-2.278910443590053_p
w(7)=1.669110257274196_p
x(8)=-4.438026120260495e-1_p
w(8)=1.118327122535809_p
x(9)=1.448224187600917_p
w(9)=3.778610634739448e-1_p
x(10)=3.574013577141023_p
w(10)=6.190205953515099e-2_p
x(11)=5.971663399387058_p
w(11)=6.392652370017626e-3_p
x(12)=8.571235184070030_p
w(12)=5.055440447145396e-4_p
x(13)=11.26533598321159_p
w(13)=3.447862121462654e-5_p
x(14)=13.88138532112342_p
w(14)=2.334430476958910e-6_p
x(15)=16.13477540116578_p
w(15)=1.911658635291014e-7_p
x(16)=17.62040672623228_p
w(16)=2.130755627666310e-8_p
else if(N==17)then
x(1)=-9.894182520591354_p
w(1)=2.710690543495107e-1_p
x(2)=-9.446650157090918_p
w(2)=6.214692514432661e-1_p
x(3)=-8.658597563698278_p
w(3)=9.495658444038017e-1_p
x(4)=-7.559096638554096_p
w(4)=1.241558686542590_p
x(5)=-6.190668289009929_p
w(5)=1.482110168113616_p
x(6)=-4.610810554340707_p
w(6)=1.645468954117855_p
x(7)=-2.896536840722256_p
w(7)=1.658591239483589_p
x(8)=-1.140637681049598_p
w(8)=1.328890298101594_p
x(9)=6.295888335758876e-1_p
w(9)=6.306647651984945e-1_p
x(10)=2.545901943784322_p
w(10)=1.479833817633486e-1_p
x(11)=4.704153762283711_p
w(11)=2.040308335954331e-2_p
x(12)=7.069561936006993_p
w(12)=2.077961271910792e-3_p
x(13)=9.564618985775988_p
w(13)=1.773378277554400e-4_p
x(14)=12.08060006921904_p
w(14)=1.404070667737320e-5_p
x(15)=14.45010605379696_p
w(15)=1.177066313066631e-6_p
x(16)=16.42327410017596_p
w(16)=1.231907454348828e-7_p
x(17)=17.68372891687729_p
w(17)=1.672862658240116e-8_p
else
call GD(-10)
end if
end subroutine GF_m10

! [-9kT;18kT]
subroutine GF_m9(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-6.781261729837057_p
w(1)=5.214312499700422_p
x(2)=-9.236283984400475e-1_p
w(2)=3.785810887259322_p
else if(N==3)then
x(1)=-7.683966908312341_p
w(1)=3.232571855180556_p
x(2)=-3.271390158556952_p
w(2)=4.705935560534248_p
x(3)=1.297669056017437_p
w(3)=1.061615971244941_p
else if(N==4)then
x(1)=-8.104526612852281_p
w(1)=2.237620561952609_p
x(2)=-4.795254661559943_p
w(2)=4.027367713319081_p
x(3)=-7.496698981017215e-1_p
w(3)=2.591111702275152_p
x(4)=3.702782725965981_p
w(4)=1.440234094129020e-1_p
else if(N==5)then
x(1)=-8.337403401825480_p
w(1)=1.669903194728126_p
x(2)=-5.769987707724940_p
w(2)=3.289510818248094_p
x(3)=-2.193404939523308_p
w(3)=3.231544854352714_p
x(4)=1.334855514164356_p
w(4)=7.985196983724542e-1_p
x(5)=6.479332583667426_p
w(5)=1.064482125835478e-2_p
else if(N==6)then
x(1)=-8.483165878169986_p
w(1)=1.308977427983545_p
x(2)=-6.425887695325700_p
w(2)=2.706491391623594_p
x(3)=-3.330101681160706_p
w(3)=3.192608232123602_p
x(4)=-1.067236389308976e-1_p
w(4)=1.666849585007806_p
x(5)=3.558529083877327_p
w(5)=1.245677159117475e-1_p
x(6)=9.389932075172293_p
w(6)=6.290343094498037e-4_p
else if(N==7)then
x(1)=-8.583447877949336_p
w(1)=1.058316281547558_p
x(2)=-6.896841584107265_p
w(2)=2.254360853218270_p
x(3)=-4.236440183100621_p
w(3)=2.912427445387614_p
x(4)=-1.241748126682195_p
w(4)=2.279195351039923_p
x(5)=1.792551213375907_p
w(5)=4.824898438810968e-1_p
x(6)=5.927037351281867_p
w(6)=1.329007308800518e-2_p
x(7)=12.05301322807895_p
w(7)=4.353879727632148e-5_p
else if(N==8)then
x(1)=-8.656966555236176_p
w(1)=8.734050594835062e-1_p
x(2)=-7.251851009594768_p
w(2)=1.897864987176259_p
x(3)=-4.966117187588177_p
w(3)=2.583413235831504_p
x(4)=-2.227248169220122_p
w(4)=2.506875549263918_p
x(5)=5.164324878947028e-1_p
w(5)=1.049882536316320_p
x(6)=3.745440967209331_p
w(6)=8.725067852268731e-2_p
x(7)=8.191036225134928_p
w(7)=1.426386176114962e-3_p
x(8)=14.09273318798964_p
w(8)=4.954189433763326e-6_p
else if(N==9)then
x(1)=-8.712788868657194_p
w(1)=7.323979703148198e-1_p
x(2)=-7.526597084512920_p
w(2)=1.613884875279770_p
x(3)=-5.555565970323846_p
w(3)=2.271118633329904_p
x(4)=-3.087621916268651_p
w(4)=2.469703643908397_p
x(5)=-5.204288706830742e-1_p
w(5)=1.595024071360247_p
x(6)=2.189496669457442_p
w(6)=3.043131813938424e-1_p
x(7)=5.686220921871815_p
w(7)=1.349047172683317e-2_p
x(8)=10.17668691169255_p
w(8)=1.895250595789920e-4_p
x(9)=15.43758292609294_p
w(9)=1.014586352177000e-6_p
else if(N==10)then
x(1)=-8.756129702668913_p
w(1)=6.225814694700487e-1_p
x(2)=-7.742824525753109_p
w(2)=1.385948566557987_p
x(3)=-6.033229491137805_p
w(3)=1.995040860739762_p
x(4)=-3.826359961216666_p
w(4)=2.312056374448733_p
x(5)=-1.423361701854790_p
w(5)=1.931363474824474_p
x(6)=1.001254252874769_p
w(6)=6.847894727219797e-1_p
x(7)=3.872115042582414_p
w(7)=6.609234257009916e-2_p
x(8)=7.496809019467975_p
w(8)=2.216680555609587e-3_p
x(9)=11.81624781908941_p
w(9)=3.381310060865313e-5_p
x(10)=16.26570047172969_p
w(10)=3.319704424930982e-7_p
else if(N==11)then
x(1)=-8.790404711742164_p
w(1)=5.355381668183460e-1_p
x(2)=-7.915534064878220_p
w(2)=1.201316130945131_p
x(3)=-6.422764575894424_p
w(3)=1.757532224074180_p
x(4)=-4.453601156642423_p
w(4)=2.117069914162930_p
x(5)=-2.226288843256937_p
w(5)=2.045254969244731_p
x(6)=3.150025894461103e-2_p
w(6)=1.121600866311593_p
x(7)=2.486927796429732_p
w(7)=2.079277689466092e-1_p
x(8)=5.506848159740497_p
w(8)=1.344888155227692e-2_p
x(9)=9.109809818147619_p
w(9)=4.261405005795581e-4_p
x(10)=13.11362983821525_p
w(10)=8.175548157081965e-6_p
x(11)=16.77527757036458_p
w(11)=1.488552095307794e-7_p
else if(N==12)then
x(1)=-8.817956509032385_p
w(1)=4.654481714146617e-1_p
x(2)=-8.055412725319165_p
w(2)=1.050226218684380_p
x(3)=-6.743105999423881_p
w(3)=1.555105616360332_p
x(4)=-4.984284401526640_p
w(4)=1.921450578244353_p
x(5)=-2.937376509908940_p
w(5)=2.015237230919622_p
x(6)=-8.069780515062779e-1_p
w(6)=1.470617957927398_p
x(7)=1.386815557158514_p
w(7)=4.660653279609279e-1_p
x(8)=3.958997495400430_p
w(8)=5.295341252359499e-2_p
x(9)=7.028738566007652_p
w(9)=2.916804724625998e-3_p
x(10)=10.50033076997258_p
w(10)=9.938931155800473e-5_p
x(11)=14.11349673655115_p
w(11)=2.597152034007323e-6_p
x(12)=17.09900966551647_p
w(12)=8.173625578761278e-8_p
else if(N==13)then
x(1)=-8.840426521176475_p
w(1)=4.082095662246592e-1_p
x(2)=-8.170154781224145_p
w(2)=9.253109800412688e-1_p
x(3)=-7.008934104706402_p
w(3)=1.382819807175891_p
x(4)=-5.433822054411500_p
w(4)=1.739288604461922_p
x(5)=-3.561812153330084_p
w(5)=1.914964872117218_p
x(6)=-1.555543123192115_p
w(6)=1.665936225846723_p
x(7)=4.756842750837308e-1_p
w(7)=7.986966585288606e-1_p
x(8)=2.719082323738947_p
w(8)=1.509581067289343e-1_p
x(9)=5.373255345555902_p
w(9)=1.319621531089835e-2_p
x(10)=8.402681703028938_p
w(10)=7.130121097520851e-4_p
x(11)=11.67154766787831_p
w(11)=2.825334809691166e-5_p
x(12)=14.87505997462496_p
w(12)=1.033848590282722e-6_p
x(13)=17.31330939446492_p
w(13)=5.121692992039624e-8_p
else if(N==14)then
x(1)=-8.858987692380577_p
w(1)=3.608782500375101e-1_p
x(2)=-8.265369831978704_p
w(2)=8.210202731340575e-1_p
x(3)=-7.231505729852088_p
w(3)=1.235845445465609_p
x(4)=-5.816048369054360_p
w(4)=1.574933648999581_p
x(5)=-4.107159566378090_p
w(5)=1.787965762942179_p
x(6)=-2.229364144157874_p
w(6)=1.727028390077678_p
x(7)=-3.119662500598713e-1_p
w(7)=1.114193315014584_p
x(8)=1.701472819688666_p
w(8)=3.305659430113058e-1_p
x(9)=4.024167621135196_p
w(9)=4.399100385252264e-2_p
x(10)=6.691387215961735_p
w(10)=3.490619323570913e-3_p
x(11)=9.616729090633763_p
w(11)=2.005477449006672e-4_p
x(12)=12.64323757516851_p
w(12)=9.660638632245088e-6_p
x(13)=15.45479082437334_p
w(13)=4.916315204262910e-7_p
x(14)=17.46096773064888_p
w(14)=3.508609272851341e-8_p
else if(N==15)then
x(1)=-8.874494546277043_p
w(1)=3.213020717324814e-1_p
x(2)=-8.345207662830411_p
w(2)=7.331494008884776e-1_p
x(3)=-7.419456249742561_p
w(3)=1.109949128045648_p
x(4)=-6.142658166794654_p
w(4)=1.428711633920315_p
x(5)=-4.582535932273382_p
w(5)=1.655796689244358_p
x(6)=-2.834220701488701_p
w(6)=1.702826673630703_p
x(7)=-1.015027063901980_p
w(7)=1.340183635562252_p
x(8)=8.436561711662642e-1_p
w(8)=5.794074313027098e-1_p
x(9)=2.905157272752810_p
w(9)=1.148915329528306e-1_p
x(10)=5.270903622302964_p
w(10)=1.282078960497143e-2_p
x(11)=7.893641044529798_p
w(11)=1.015143890502459e-3_p
x(12)=10.67358374355688_p
w(12)=6.507492475959959e-5_p
x(13)=13.44269080443128_p
w(13)=3.887554614054059e-6_p
x(14)=15.8990710500676_p
w(14)=2.681153064893824e-7_p
x(15)=17.56640540091326_p
w(15)=2.558981421163291e-8_p
else if(N==16)then
x(1)=-8.887580940644687_p
w(1)=2.878803580151439e-1_p
x(2)=-8.412783524220856_p
w(2)=6.584846720857572e-1_p
x(3)=-7.579446790288157_p
w(3)=1.001578013955053_p
x(4)=-6.423275799891790_p
w(4)=1.299375907229656_p
x(5)=-4.997190394340270_p
w(5)=1.528230701857233_p
x(6)=-3.374677970114976_p
w(6)=1.634013412885919_p
x(7)=-1.652375950363620_p
w(7)=1.459703971377481_p
x(8)=9.839588547715619e-2_p
w(8)=8.454579459832239e-1_p
x(9)=1.962376677039666_p
w(9)=2.435842592361712e-1_p
x(10)=4.075199338770527_p
w(10)=3.751645338027224e-2_p
x(11)=6.435806059306596_p
w(11)=3.942718732976126e-3_p
x(12)=8.973813355436512_p
w(12)=3.288076351050607e-4_p
x(13)=11.58449746412415_p
w(13)=2.418564007842408e-5_p
x(14)=14.09846286545887_p
w(14)=1.797020665145942e-6_p
x(15)=16.24321783553984_p
w(15)=1.623880879488961e-7_p
x(16)=17.64405120512829_p
w(16)=1.953692077845301e-8_p
else if(N==17)then
x(1)=-8.898724816780588_p
w(1)=2.594035738620646e-1_p
x(2)=-8.470468907765090_p
w(2)=5.945453332397787e-1_p
x(3)=-7.716655380316378_p
w(3)=9.078058124443471e-1_p
x(4)=-6.665732469429173_p
w(4)=1.185161591309233_p
x(5)=-5.359679462453840_p
w(5)=1.409291384367671_p
x(6)=-3.856113521481718_p
w(6)=1.545628860995992_p
x(7)=-2.232072791289437_p
w(7)=1.494373904499702_p
x(8)=-5.669804862968431e-1_p
w(8)=1.069615465652717_p
x(9)=1.153974854019741_p
w(9)=4.297048324998105e-1_p
x(10)=3.057258223337360_p
w(10)=9.076635882187949e-2_p
x(11)=5.190104986727063_p
w(11)=1.238649054285030e-2_p
x(12)=7.507134367426986_p
w(12)=1.309738370032235e-3_p
x(13)=9.934171765812156_p
w(13)=1.188155222005194e-4_p
x(14)=12.36494779820553_p
w(14)=1.017040618632382e-5_p
x(15)=14.63686555577815_p
w(15)=9.323800624606471e-7_p
x(16)=16.51316121745207_p
w(16)=1.066058681913246e-7_p
x(17)=17.70275924733115_p
w(17)=1.543934946419078e-8_p
else
call GD(-9)
end if
end subroutine GF_m9

! [-8kT;18kT]
subroutine GF_m8(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.971705561665337_p
w(1)=4.752843895781908_p
x(2)=-6.083158599974350e-1_p
w(2)=3.247491495361009_p
else if(N==3)then
x(1)=-6.781813379461619_p
w(1)=2.987658207560920_p
x(2)=-2.720482748405081_p
w(2)=4.201205571706131_p
x(3)=1.642648686798244_p
w(3)=8.114716118758649e-1_p
else if(N==4)then
x(1)=-7.163616171341348_p
w(1)=2.087749095141954_p
x(2)=-4.085536070240996_p
w(2)=3.696520390197295_p
x(3)=-3.265288297086500e-1_p
w(3)=2.121406504997710_p
x(4)=4.148727334646120_p
w(4)=9.465940080595732e-2_p
else if(N==5)then
x(1)=-7.377091028015808_p
w(1)=1.568584114392325_p
x(2)=-4.970518802195731_p
w(2)=3.061605892084983_p
x(3)=-1.647340931137658_p
w(3)=2.800624335955956_p
x(4)=1.776047074697913_p
w(4)=5.631324388466973e-1_p
x(5)=6.997754148214250_p
w(5)=6.388609862955162e-3_p
else if(N==6)then
x(1)=-7.512036234887924_p
w(1)=1.235022538574273_p
x(2)=-5.573818965542448_p
w(2)=2.538574248735268_p
x(3)=-2.679653907252530_p
w(3)=2.876904700843959_p
x(4)=3.626071864403884e-1_p
w(4)=1.272457539557060_p
x(5)=4.065227142818852_p
w(5)=7.700814423972077e-2_p
x(6)=9.922138026357114_p
w(6)=3.682191926349444e-4_p
else if(N==7)then
x(1)=-7.605727305489948_p
w(1)=1.001142738698466_p
x(2)=-6.011849072090150_p
w(2)=2.123969289802703_p
x(3)=-3.511879337529289_p
w(3)=2.682389552939568_p
x(4)=-7.123144932236715e-1_p
w(4)=1.867431813744640_p
x(5)=2.282341532353392_p
w(5)=3.175132703835861e-1_p
x(6)=6.453239962504821_p
w(6)=7.861976693937912e-3_p
x(7)=12.51665161277902_p
w(7)=2.674888001442888e-5_p
else if(N==8)then
x(1)=-7.674786333554584_p
w(1)=8.276284327020408e-1_p
x(2)=-6.344245638897590_p
w(2)=1.793182990598509_p
x(3)=-4.188547416950986_p
w(3)=2.407939221871919_p
x(4)=-1.626474265450846_p
w(4)=2.170364133378517_p
x(5)=1.007850401636160_p
w(5)=7.475549809309466e-1_p
x(6)=4.262314729193583_p
w(6)=5.280569247763047e-2_p
x(7)=8.688430718539452_p
w(7)=8.565848402182513e-4_p
x(8)=14.43361766595514_p
w(8)=3.354343135931948e-6_p
else if(N==9)then
x(1)=-7.727356616429906_p
w(1)=6.949491852195845e-1_p
x(2)=-6.602359630395066_p
w(2)=1.528052949943280_p
x(3)=-4.738506328030073_p
w(3)=2.131673253040615_p
x(4)=-2.421361627002534_p
w(4)=2.217687526428213_p
x(5)=1.377901828810611e-3_p
w(5)=1.227532423586595_p
x(6)=2.697919889119027_p
w(6)=1.922770350233486e-1_p
x(7)=6.197250368471533_p
w(7)=8.043214898076426e-3_p
x(8)=10.61721588351753_p
w(8)=1.190471597678297e-4_p
x(9)=15.66492484921166_p
w(9)=7.558434368976466e-7_p
else if(N==10)then
x(1)=-7.768241660669929_p
w(1)=5.914297683810211e-1_p
x(2)=-6.805955374980018_p
w(2)=1.314408593089777_p
x(3)=-5.186013823845235_p
w(3)=1.880867041687044_p
x(4)=-3.106346396375931_p
w(4)=2.122152484005257_p
x(5)=-8.513717998306150e-1_p
w(5)=1.589204145792687_p
x(6)=1.509742306285349_p
w(6)=4.612546125350854e-1_p
x(7)=4.389399837220535_p
w(7)=3.964831807961626e-2_p
x(8)=7.977487188870520_p
w(8)=1.347661923305440e-3_p
x(9)=12.18854769566176_p
w(9)=2.250015557649568e-5_p
x(10)=16.41442604007829_p
w(10)=2.654935470001416e-7_p
else if(N==11)then
x(1)=-7.800622408367270_p
w(1)=5.092482793255972e-1_p
x(2)=-6.968880990481336_p
w(2)=1.140840424928013_p
x(3)=-5.552108354346030_p
w(3)=1.661981504641786_p
x(4)=-3.690905095149545_p
w(4)=1.968537791121324_p
x(5)=-1.599349321505301_p
w(5)=1.769955609611340_p
x(6)=5.568539645730597e-1_p
w(6)=8.134508569780096e-1_p
x(7)=3.005848949796206_p
w(7)=1.280046497011521e-1_p
x(8)=6.010501716763043_p
w(8)=8.041832766990213e-3_p
x(9)=9.546496986619417_p
w(9)=2.685468530201902e-4_p
x(10)=13.41855958791529_p
w(10)=5.770343909569137e-6_p
x(11)=16.87487596865437_p
w(11)=1.248717738402728e-7_p
else if(N==12)then
x(1)=-7.826686059325159_p
w(1)=4.429804705906584e-1_p
x(2)=-7.101049225608706_p
w(2)=9.984705549311248e-1_p
x(3)=-5.853925124393702_p
w(3)=1.473796523900988_p
x(4)=-4.187689650721464_p
w(4)=1.800853945184951_p
x(5)=-2.260238897149755_p
w(5)=1.804170981615434_p
x(6)=-2.479491400496796e-1_p
w(6)=1.145575877100843_p
x(7)=1.908367021267912_p
w(7)=3.010600222740009e-1_p
x(8)=4.476243772018033_p
w(8)=3.158013078345388e-2_p
x(9)=7.503478526548283_p
w(9)=1.779493350025036e-3_p
x(10)=10.88728609730145_p
w(10)=6.538731080659107e-5_p
x(11)=14.35914609237604_p
w(11)=1.933319870487681e-6_p
x(12)=17.16826400211676_p
w(12)=7.078076025103360e-8_p
else if(N==13)then
x(1)=-7.847967374381822_p
w(1)=3.887966049222321e-1_p
x(2)=-7.209617476131567_p
w(2)=8.805397248712380e-1_p
x(3)=-6.104885460550525_p
w(3)=1.312709454290309_p
x(4)=-4.610008028454788_p
w(4)=1.638456266567884_p
x(5)=-2.842141121045171_p
w(5)=1.751661645158493_p
x(6)=-9.536378081812540e-1_p
w(6)=1.378238834150373_p
x(7)=1.008048602394777_p
w(7)=5.502108792115165e-1_p
x(8)=3.243905807653396_p
w(8)=9.135684937026251e-2_p
x(9)=5.873158686273776_p
w(9)=7.896208119964150e-3_p
x(10)=8.840309581456561_p
w(10)=4.486432682455512e-4_p
x(11)=12.00864777234937_p
w(11)=1.943104141855015e-5_p
x(12)=15.07205417492678_p
w(12)=8.048499301260861e-7_p
x(13)=17.36334832661561_p
w(13)=4.532104937619970e-8_p
else if(N==14)then
x(1)=-7.865564849842810_p
w(1)=3.439428765762331e-1_p
x(2)=-7.299817792420950_p
w(2)=7.819244767728732e-1_p
x(3)=-6.315356233231017_p
w(3)=1.174732250526206_p
x(4)=-4.970089241713067_p
w(4)=1.488775151819654_p
x(5)=-3.352279236810581_p
w(5)=1.657699288863558_p
x(6)=-1.583626167495980_p
w(6)=1.494809604702730_p
x(7)=2.430010061088731e-1_p
w(7)=8.229098319114865e-1_p
x(8)=2.231882831926038_p
w(8)=2.071419829708498e-1_p
x(9)=4.540964801544062_p
w(9)=2.613115442079239e-2_p
x(10)=7.163924963043044_p
w(10)=2.130664663523704e-3_p
x(11)=10.0138930054386_p
w(11)=1.307494551211225e-4_p
x(12)=12.93389360328917_p
w(12)=6.930075968867618e-6_p
x(13)=15.61333379068837_p
w(13)=3.968616338862035e-7_p
x(14)=17.49839248876406_p
w(14)=3.152228461004694e-8_p
else if(N==15)then
x(1)=-7.880280075722291_p
w(1)=3.064026137757596e-1_p
x(2)=-7.375529974690995_p
w(2)=6.987248372150542e-1_p
x(3)=-6.493333954637935_p
w(3)=1.056188951948332_p
x(4)=-5.278453084502585_p
w(4)=1.353893755776172_p
x(5)=-3.798538973915069_p
w(5)=1.548470777942957_p
x(6)=-2.148418749493171_p
w(6)=1.520657734098024_p
x(7)=-4.278890250891376e-1_p
w(7)=1.056117661944833_p
x(8)=1.382857617942054_p
w(8)=3.827859588678484e-1_p
x(9)=3.433085447362661_p
w(9)=6.873861564811937e-2_p
x(10)=5.768682617275243_p
w(10)=7.670401528227969e-3_p
x(11)=8.333554586778288_p
w(11)=6.369353761970420e-4_p
x(12)=11.03017624540344_p
w(12)=4.400410427755304e-5_p
x(13)=13.6920782881205_p
w(13)=2.896910294522430e-6_p
x(14)=16.02772925445644_p
w(14)=2.227610474439560e-7_p
x(15)=17.59523975550641_p
w(15)=2.324577141761626e-8_p
else if(N==16)then
x(1)=-7.892708546995685_p
w(1)=2.746734288807631e-1_p
x(2)=-7.439672730095084_p
w(2)=6.279488476230035e-1_p
x(3)=-6.645013178375757_p
w(3)=9.539121565582476e-1_p
x(4)=-5.543863949868357_p
w(4)=1.233599853792220_p
x(5)=-4.188944401922979_p
w(5)=1.437373292110067_p
x(6)=-2.654061352602495_p
w(6)=1.489824708165418_p
x(7)=-1.028804503877100_p
w(7)=1.213661409326393_p
x(8)=6.536627371478095e-1_p
w(8)=5.951326214848737e-1_p
x(9)=2.498397030510428_p
w(9)=1.493492967658155e-1_p
x(10)=4.591340357472767_p
w(10)=2.222355598258904e-2_p
x(11)=6.907752229053557_p
w(11)=2.404991012408576e-3_p
x(12)=9.379016751126755_p
w(12)=2.127463749161182e-4_p
x(13)=11.90246694351687_p
w(13)=1.694272589877101e-5_p
x(14)=14.31226342530454_p
w(14)=1.384412239897156e-6_p
x(15)=16.34873148719133_p
w(15)=1.380332661990298e-7_p
x(16)=17.66683429573355_p
w(16)=1.789479646430680e-8_p
else if(N==17)then
x(1)=-7.903299896123137_p
w(1)=2.476183720607978e-1_p
x(2)=-7.494471999710265_p
w(2)=5.672799579501914e-1_p
x(3)=-6.775225438594450_p
w(3)=8.652512432247882e-1_p
x(4)=-5.773516065439733_p
w(4)=1.126768256122525_p
x(5)=-4.531049998422981_p
w(5)=1.330740588261417_p
x(6)=-3.105776139774183_p
w(6)=1.428665518964882_p
x(7)=-1.572471312743319_p
w(7)=1.293826649237808_p
x(8)=1.226424769239465e-2_p
w(8)=8.032462179883253e-1_p
x(9)=1.698607772866908_p
w(9)=2.747438905555636e-1_p
x(10)=3.586637721256128_p
w(10)=5.388125172137665e-2_p
x(11)=5.686624677836440_p
w(11)=7.406742583860862e-3_p
x(12)=7.949720629085604_p
w(12)=8.191582804486649e-4_p
x(13)=10.30465944111213_p
w(13)=7.933553323533718e-5_p
x(14)=12.64739385353513_p
w(14)=7.363041160820071e-6_p
x(15)=14.82052410145931_p
w(15)=7.391092884086884e-7_p
x(16)=16.60067745228378_p
w(16)=9.227517160406310e-8_p
x(17)=17.7211501075647_p
w(17)=1.423207573858503e-8_p
else
call GD(-8)
end if
end subroutine GF_m8

! [-7kT;18kT]
subroutine GF_m7(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.160734217992717_p
w(1)=4.287640032265134_p
x(2)=-2.708861073697502e-1_p
w(2)=2.713271418958660_p
else if(N==3)then
x(1)=-5.879268769643418_p
w(1)=2.740801460449969_p
x(2)=-2.166784164708382_p
w(2)=3.668243711270100_p
x(3)=2.027219146913393_p
w(3)=5.918662795037254e-1_p
else if(N==4)then
x(1)=-6.222718740960213_p
w(1)=1.936287432534029_p
x(2)=-3.377560623258512_p
w(2)=3.341106856571216_p
x(3)=1.177317065737410e-1_p
w(3)=1.664089392044483_p
x(4)=4.635691444316431_p
w(4)=5.942777007406654e-2_p
else if(N==5)then
x(1)=-6.416981225488462_p
w(1)=1.465770048182826_p
x(2)=-4.173355180908060_p
w(2)=2.818597650662225_p
x(3)=-1.098656852076827_p
w(3)=2.337696378511598_p
x(4)=2.257358094007582_p
w(4)=3.751426444734778e-1_p
x(5)=7.548374777045145_p
w(5)=3.704729393668115e-3_p
else if(N==6)then
x(1)=-6.541201467334172_p
w(1)=1.159637377932467_p
x(2)=-4.724057651450841_p
w(2)=2.360930397166834_p
x(3)=-2.034226624318614_p
w(3)=2.518138161849540_p
x(4)=8.579848759137272e-1_p
w(4)=9.163452049139446e-1_p
x(5)=4.606360041994592_p
w(5)=4.564901783195918e-2_p
x(6)=10.47092350658055_p
w(6)=2.112915290503177e-4_p
else if(N==7)then
x(1)=-6.628297856234731_p
w(1)=9.427265840478649e-1_p
x(2)=-5.128849612358831_p
w(2)=1.986992814555121_p
x(3)=-2.793377112680192_p
w(3)=2.419328059453024_p
x(4)=-1.739293201431593e-1_p
w(4)=1.449438005960115_p
x(5)=2.807487160943176_p
w(5)=1.978728052015591e-1_p
x(6)=7.000350438083484_p
w(6)=4.536796898231744e-3_p
x(7)=12.97696280584849_p
w(7)=1.638510787930994e-5_p
else if(N==8)then
x(1)=-6.692844732615558_p
w(1)=7.808580893077959e-1_p
x(2)=-5.438191652048296_p
w(2)=1.683929527332115_p
x(3)=-3.416026946535904_p
w(3)=2.210536988799140_p
x(4)=-1.027553132953833_p
w(4)=1.794690330692542_p
x(5)=1.528711869500857_p
w(5)=4.994952487297267e-1_p
x(6)=4.805338408714569_p
w(6)=3.089147492152909e-2_p
x(7)=9.195630510502292_p
w(7)=5.075063767754734e-4_p
x(8)=14.76139451311712_p
w(8)=2.285064171102840e-6_p
else if(N==9)then
x(1)=-6.742112811721118_p
w(1)=6.567135483778995e-1_p
x(2)=-5.679311071054838_p
w(2)=1.438936959152026_p
x(3)=-3.925335382209968_p
w(3)=1.977895654014151_p
x(4)=-1.760893847170449_p
w(4)=1.921857209344225_p
x(5)=5.404193848800287e-1_p
w(5)=8.849072835044040e-1_p
x(6)=3.236647569066013_p
w(6)=1.158275027825820e-1_p
x(7)=6.724551798651000_p
w(7)=4.698382310622556e-3_p
x(8)=11.0596024693879_p
w(8)=7.434484346664163e-5_p
x(9)=15.87997660723345_p
w(9)=5.668944171556628e-7_p
else if(N==10)then
x(1)=-6.780504686976162_p
w(1)=5.596431062078407e-1_p
x(2)=-5.870016463574087_p
w(2)=1.240417220435819_p
x(3)=-4.341784800665939_p
w(3)=1.757069005135029_p
x(4)=-2.392495203343629_p
w(4)=1.897277146990815_p
x(5)=-2.742235311301624e-1_p
w(5)=1.230477256582213_p
x(6)=2.047708338943127_p
w(6)=2.920985255942816e-1_p
x(7)=4.928238285485185_p
w(7)=2.310473886695978e-2_p
x(8)=8.467064321329261_p
w(8)=8.092807533293061e-4_p
x(9)=12.55783086876695_p
w(9)=1.495735808162194e-5_p
x(10)=16.55453364017341_p
w(10)=2.132994244020730e-7_p
else if(N==11)then
x(1)=-6.810963440721952_p
w(1)=4.824360943826335e-1_p
x(2)=-6.022972017333044_p
w(2)=1.078473622325121_p
x(3)=-4.683780547365884_p
w(3)=1.559719012715721_p
x(4)=-2.933573476219130_p
w(4)=1.795062870654647_p
x(5)=-9.747267046497273e-1_p
w(5)=1.454746632676909_p
x(6)=1.104438160786323_p
w(6)=5.499746023461407e-1_p
x(7)=3.550682626618492_p
w(7)=7.560357311449389e-2_p
x(8)=6.527971855786021_p
w(8)=4.722789927582286e-3_p
x(9)=9.986773888157790_p
w(9)=1.680696015856502e-4_p
x(10)=13.71826972600711_p
w(10)=4.078469370041239e-6_p
x(11)=16.96888844496367_p
w(11)=1.050095898946793e-7_p
else if(N==12)then
x(1)=-6.835517737115843_p
w(1)=4.200765344552684e-1_p
x(2)=-6.147291482771626_p
w(2)=9.452168073665337e-1_p
x(3)=-4.966591443499903_p
w(3)=1.387628947463042_p
x(4)=-3.395488119168041_p
w(4)=1.662922275912072_p
x(5)=-1.588434221218954_p
w(5)=1.550767636509634_p
x(6)=3.229264356809721e-1_p
w(6)=8.310171382362254e-1_p
x(7)=2.457291428889361_p
w(7)=1.838020863370656e-1_p
x(8)=5.011733101997181_p
w(8)=1.836243196965356e-2_p
x(9)=7.986415481513528_p
w(9)=1.073212807201967e-3_p
x(10)=11.27428094577014_p
w(10)=4.287653914523367e-5_p
x(11)=14.59915534141283_p
w(11)=1.442274677419187e-6_p
x(12)=17.23390775689017_p
w(12)=6.135327538719925e-8_p
else if(N==13)then
x(1)=-6.855593764181227_p
w(1)=3.690146801294840e-1_p
x(2)=-6.249580408757996_p
w(2)=8.345557829101945e-1_p
x(3)=-5.202326758754936_p
w(3)=1.238962766764182_p
x(4)=-3.789738067911092_p
w(4)=1.525463766448852_p
x(5)=-2.128310253813514_p
w(5)=1.553213684284469_p
x(6)=-3.488328079164575e-1_p
w(6)=1.067783532418111_p
x(7)=1.564432539812195_p
w(7)=3.536479878493433e-1_p
x(8)=3.790970230977433_p
w(8)=5.332622575323263e-2_p
x(9)=6.385121146192419_p
w(9)=4.648743451163506e-3_p
x(10)=9.282119608455240_p
w(10)=2.802639588964397e-4_p
x(11)=12.34367844806269_p
w(11)=1.334929931835849e-5_p
x(12)=15.26387780858818_p
w(12)=6.278519484901756e-7_p
x(13)=17.41099700121036_p
w(13)=4.010459926126664e-8_p
else if(N==14)then
x(1)=-6.872214354828670_p
w(1)=3.266920534587578e-1_p
x(2)=-6.334683902881589_p
w(2)=7.418292165999225e-1_p
x(3)=-5.400426687539299_p
w(3)=1.110817678973836_p
x(4)=-4.126995880618082_p
w(4)=1.393892226699975_p
x(5)=-2.602741282890916_p
w(5)=1.500910651997794_p
x(6)=-9.404106225342255e-1_p
w(6)=1.223543644142728_p
x(7)=8.145789286320538e-1_p
w(7)=5.632407875886577e-1_p
x(8)=2.786911264817570_p
w(8)=1.234319401279094e-1_p
x(9)=5.073520385950622_p
w(9)=1.517652407035171e-2_p
x(10)=7.644062249465297_p
w(10)=1.286529403944705e-3_p
x(11)=10.4124515363362_p
w(11)=8.487702473264899e-5_p
x(12)=13.22142845193856_p
w(12)=4.971971169229700e-6_p
x(13)=15.76748002573803_p
w(13)=3.208602109773495e-7_p
x(14)=17.53418455313048_p
w(14)=2.830380538639380e-8_p
else if(N==15)then
x(1)=-6.886127332247035_p
w(1)=2.912308949745983e-1_p
x(2)=-6.406205535780871_p
w(2)=6.634639403428693e-1_p
x(3)=-5.568223948829139_p
w(3)=1.000216681502113_p
x(4)=-4.416585955606048_p
w(4)=1.272650074917294_p
x(5)=-3.019121352383062_p
w(5)=1.421742394728042_p
x(6)=-1.467498316900798_p
w(6)=1.298207846172530_p
x(7)=1.674449118358995e-1_p
w(7)=7.716411694037683e-1_p
x(8)=1.945808994562579_p
w(8)=2.369691659626499e-1_p
x(9)=3.980293335793201_p
w(9)=3.983921138487972e-2_p
x(10)=6.277194264801115_p
w(10)=4.521288343553313e-3_p
x(11)=8.777860012384066_p
w(11)=3.967315534622574e-4_p
x(12)=11.38632717292724_p
w(12)=2.968543814774133e-5_p
x(13)=13.93798190016509_p
w(13)=2.160138883566248e-6_p
x(14)=16.15277785939308_p
w(14)=1.852651900324692e-7_p
x(15)=17.62292336571567_p
w(15)=2.109581333172823e-8_p
else if(N==16)then
x(1)=-6.897889232937826_p
w(1)=2.612295325317321e-1_p
x(2)=-6.466863155920181_p
w(2)=5.967040429336199e-1_p
x(3)=-5.711429496949762_p
w(3)=9.044623343735690e-1_p
x(4)=-4.666380435822163_p
w(4)=1.162966854093074_p
x(5)=-3.384534561069036_p
w(5)=1.332341725094904_p
x(6)=-1.938874847743443_p
w(6)=1.311184053115479_p
x(7)=-4.037302309983364e-1_p
w(7)=9.417078379352116e-1_p
x(8)=1.228130425629920_p
w(8)=3.882308178994763e-1_p
x(9)=3.056316364404998_p
w(9)=8.758236752496837e-2_p
x(10)=5.121323639283667_p
w(10)=1.289984536086590e-2_p
x(11)=7.386787165648869_p
w(11)=1.451996171643922e-3_p
x(12)=9.786322306452195_p
w(12)=1.369877295650216e-4_p
x(13)=12.2188715616048_p
w(13)=1.185531892891608e-5_p
x(14)=14.52261739519643_p
w(14)=1.067381096691668e-6_p
x(15)=16.4513244964432_p
w(15)=1.173891318992330e-7_p
x(16)=17.68878257221225_p
w(16)=1.637052725836323e-8_p
else if(N==17)then
x(1)=-6.907920944029973_p
w(1)=2.356253646640853e-1_p
x(2)=-6.518734090138663_p
w(2)=5.394067684053409e-1_p
x(3)=-5.834516582507163_p
w(3)=8.212318052197422e-1_p
x(4)=-4.882907955874857_p
w(4)=1.064614769895118_p
x(5)=-3.705618082368306_p
w(5)=1.241709520974814_p
x(6)=-2.360585095244982_p
w(6)=1.284549930115690_p
x(7)=-9.154330061809530e-1_p
w(7)=1.055807382424177_p
x(8)=6.039479898079392e-1_p
w(8)=5.563819332381382e-1_p
x(9)=2.265667520371226_p
w(9)=1.655547993981352e-1_p
x(10)=4.132918136083156_p
w(10)=3.109335838677062e-2_p
x(11)=6.192833018984915_p
w(11)=4.368370994662048e-3_p
x(12)=8.396742636264912_p
w(12)=5.086315645835057e-4_p
x(13)=10.67565318437609_p
w(13)=5.280828970822358e-5_p
x(14)=12.92765885363216_p
w(14)=5.328370435090672e-6_p
x(15)=15.00097675595395_p
w(15)=5.863057497817571e-7_p
x(16)=16.6858385963661_p
w(16)=7.987578866922115e-8_p
x(17)=17.73891955447046_p
w(17)=1.310085487233990e-8_p
else
call GD(-7)
end if
end subroutine GF_m7

! [-6kT;18kT]
subroutine GF_m6(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-4.348504260656911_p
w(1)=3.813105005392418_p
x(2)=9.541820145204172e-2_p
w(2)=2.189370664515332_p
else if(N==3)then
x(1)=-4.976683270371589_p
w(1)=2.488283429009783_p
x(2)=-1.607687863340372_p
w(2)=3.105744391979504_p
x(3)=2.458253924500242_p
w(3)=4.084478489184640e-1_p
else if(N==4)then
x(1)=-5.282140448743548_p
w(1)=1.780716604671062_p
x(2)=-2.671817223012162_p
w(2)=2.949910703168421_p
x(3)=5.917339458816083e-1_p
w(3)=1.236300131677530_p
x(4)=5.166477204748234_p
w(4)=3.554823039073779e-2_p
else if(N==5)then
x(1)=-5.457326305637697_p
w(1)=1.359623957103441_p
x(2)=-3.379663055732405_p
w(2)=2.550278724012589_p
x(3)=-5.412478099697401e-1_p
w(3)=1.855539504832677_p
x(4)=2.783614515733153_p
w(4)=2.349592094212099e-1_p
x(5)=8.131830249875311_p
w(5)=2.074274537833387e-3_p
else if(N==6)then
x(1)=-5.570857938306417_p
w(1)=1.081444247117705_p
x(2)=-3.877688076781819_p
w(2)=2.166130061763025_p
x(3)=-1.391761723803108_p
w(3)=2.112277262146312_p
x(4)=1.387839680834946_p
w(4)=6.165355770001559e-1_p
x(5)=5.181930050012645_p
w(5)=2.596947625986857e-2_p
x(6)=11.03380933563378_p
w(6)=1.190456206847997e-4_p
else if(N==7)then
x(1)=-5.651301849117354_p
w(1)=8.820323377588443e-1_p
x(2)=-4.248677849690695_p
w(2)=1.838213786670270_p
x(3)=-2.081129878301245_p
w(3)=2.111060537395352_p
x(4)=3.825924447808144e-1_p
w(4)=1.051753762822792_p
x(5)=3.369574216098031_p
w(5)=1.168490134064535e-1_p
x(6)=7.567323710717467_p
w(6)=2.556200757129977e-3_p
x(7)=13.43054708771964_p
w(7)=1.003109690889858e-5_p
else if(N==8)then
x(1)=-5.711247924642153_p
w(1)=7.322910240664234e-1_p
x(2)=-4.534324911458173_p
w(2)=1.566365370712301_p
x(3)=-2.649531026828245_p
w(3)=1.978996267623347_p
x(4)=-4.241335947158708e-1_p
w(4)=1.394987792671337_p
x(5)=2.084480331635446_p
w(5)=3.120370564287200e-1_p
x(6)=5.373727294236081_p
w(6)=1.749965215329011e-2_p
x(7)=9.711312532753375_p
w(7)=2.969384673645844e-4_p
x(8)=15.07460033325111_p
w(8)=1.567784967731067e-6_p
else if(N==9)then
x(1)=-5.757140739809655_p
w(1)=6.170466720487174e-1_p
x(2)=-4.757950295725052_p
w(2)=1.343764976625895_p
x(3)=-3.117162223770612_p
w(3)=1.799971813454635_p
x(4)=-1.103423800553852_p
w(4)=1.580368975087801_p
x(5)=1.105337650408238_p
w(5)=5.918678945723985e-1_p
x(6)=3.805653326608748_p
w(6)=6.671707142156405e-2_p
x(7)=7.267176298818356_p
w(7)=2.691637505267821e-3_p
x(8)=11.50255434897763_p
w(8)=4.620114761324470e-5_p
x(9)=16.08262190039175_p
w(9)=4.280438582174308e-7_p
else if(N==10)then
x(1)=-5.792985732706845_p
w(1)=5.266927628230238e-1_p
x(2)=-4.935405937905561_p
w(2)=1.161855727017258_p
x(3)=-3.501559934762184_p
w(3)=1.616225540560498_p
x(4)=-1.684329778647806_p
w(4)=1.626588711956080_p
x(5)=3.166828564130157e-1_p
w(5)=8.833709967457750e-1_p
x(6)=2.617757824550953_p
w(6)=1.741450933952673e-1_p
x(7)=5.487595288572652_p
w(7)=1.310634972770144e-2_p
x(8)=8.964582090527792_p
w(8)=4.803758565212005e-4_p
x(9)=12.92311144282951_p
w(9)=9.939735491256117e-6_p
x(10)=16.68624945514605_p
w(10)=1.720901343928466e-7_p
else if(N==11)then
x(1)=-5.821482396031095_p
w(1)=4.546606197163793e-1_p
x(2)=-5.078128797306805_p
w(2)=1.012553043879880_p
x(3)=-3.818652175207125_p
w(3)=1.445175420065031_p
x(4)=-2.182207756715117_p
w(4)=1.584115971607194_p
x(5)=-3.464187179672576e-1_p
w(5)=1.114780028890821_p
x(6)=1.680501620886837_p
w(6)=3.453517273206180e-1_p
x(7)=4.120625047036182_p
w(7)=4.300437498538898e-2_p
x(8)=7.058319869681914_p
w(8)=2.726980440226877e-3_p
x(9)=10.42975945918887_p
w(9)=1.045268383030751e-4_p
x(10)=14.01215644352566_p
w(10)=2.887673540494506e-6_p
x(11)=17.05753131586862_p
w(11)=8.849036791339764e-8_p
else if(N==12)then
x(1)=-5.844496591258487_p
w(1)=3.963633993775249e-1_p
x(2)=-5.194402476866257_p
w(2)=8.891301099027983e-1_p
x(3)=-4.081833831964849_p
w(3)=1.292373285507867_p
x(4)=-2.608653923306114_p
w(4)=1.496547112481695_p
x(5)=-9.189207589517161e-1_p
w(5)=1.254787364636349_p
x(6)=9.140470981148305e-1_p
w(6)=5.556556502655826e-1_p
x(7)=3.034329232356245_p
w(7)=1.065170296020471e-1_p
x(8)=5.564348052631923_p
w(8)=1.043226607481527e-2_p
x(9)=8.476733304038632_p
w(9)=6.402842634632569e-4_p
x(10)=11.66059429979145_p
w(10)=2.803621519316507e-5_p
x(11)=14.833217313249_p
w(11)=1.078364992179971e-6_p
x(12)=17.29609157854073_p
w(12)=5.321542288279138e-8_p
else if(N==13)then
x(1)=-5.863343283099439_p
w(1)=3.485445292836991e-1_p
x(2)=-5.290261098955926_p
w(2)=7.862662405834473e-1_p
x(3)=-4.301865163738513_p
w(3)=1.158307876903215_p
x(4)=-2.974039641575386_p
w(4)=1.391307090830191_p
x(5)=-1.419371352974300_p
w(5)=1.310475836977073_p
x(6)=2.667345589759667e-1_p
w(6)=7.621281565050876e-1_p
x(7)=2.148564327301353_p
w(7)=2.124223187613926e-1_p
x(8)=4.359142565821134_p
w(8)=3.014428868161917e-2_p
x(9)=6.908238901743299_p
w(9)=2.695735573106295e-3_p
x(10)=9.727408905227865_p
w(10)=1.739055825772314e-4_p
x(11)=12.6761062566941_p
w(11)=9.164006806050129e-6_p
x(12)=15.45040252401637_p
w(12)=4.907407027208720e-7_p
x(13)=17.45635310083075_p
w(13)=3.547883430880594e-8_p
else if(N==14)then
x(1)=-5.878967895278438_p
w(1)=3.088495877149595e-1_p
x(2)=-5.370150036215567_p
w(2)=6.998244663419144e-1_p
x(3)=-4.487224391873740_p
w(3)=1.041520392571996_p
x(4)=-3.287725368406676_p
w(4)=1.283194762523886_p
x(5)=-1.858749907140536_p
w(5)=1.305677600909762_p
x(6)=-2.941144896147904e-1_p
w(6)=9.278602303231300e-1_p
x(7)=1.409467569586565_p
w(7)=3.557439760024099e-1_p
x(8)=3.366245288581270_p
w(8)=7.034054085801668e-2_p
x(9)=5.620718638486635_p
w(9)=8.636420945372097e-3_p
x(10)=8.131066471677075_p
w(10)=7.689565871486470e-4_p
x(11)=10.8118236211313_p
w(11)=5.488182429465896e-5_p
x(12)=13.505477442886_p
w(12)=3.568134318505170e-6_p
x(13)=15.91719302495907_p
w(13)=2.597781748845293e-7_p
x(14)=17.56840686957157_p
w(14)=2.539236743493376e-8_p
else if(N==15)then
x(1)=-5.892063270348359_p
w(1)=2.755457572674753e-1_p
x(2)=-5.437387922493956_p
w(2)=6.265978843523659e-1_p
x(3)=-4.644552694439840_p
w(3)=9.399569732297969e-1_p
x(4)=-3.557905970538398_p
w(4)=1.179417571868938_p
x(5)=-2.245013574010836_p
w(5)=1.264121900466786_p
x(6)=-7.883158198901088e-1_p
w(6)=1.036511024329108_p
x(7)=7.789325467609356e-1_p
w(7)=5.167940489852447e-1_p
x(8)=2.534297534961100_p
w(8)=1.381782443139551e-1_p
x(9)=4.545532630220917_p
w(9)=2.245645656022935e-2_p
x(10)=6.795576725757145_p
w(10)=2.628610205227472e-3_p
x(11)=9.225950366050734_p
w(11)=2.454295771390601e-4_p
x(12)=11.74157831921487_p
w(12)=1.998355441113739e-5_p
x(13)=14.18016712656688_p
w(13)=1.611869418959976e-6_p
x(14)=16.27422183114681_p
w(14)=1.542062166689230e-7_p
x(15)=17.64949743820051_p
w(15)=1.912143814779791e-8_p
else if(N==16)then
x(1)=-5.903146115362053_p
w(1)=2.473363702004000e-1_p
x(2)=-5.494485651628157_p
w(2)=5.640925061286302e-1_p
x(3)=-4.779056867813678_p
w(3)=8.515309126455289e-1_p
x(4)=-3.791563932488849_p
w(4)=1.083079520149263_p
x(5)=-2.584876424971917_p
w(5)=1.203216981381751_p
x(6)=-1.227825284195702_p
w(6)=1.090662253247811_p
x(7)=2.300099078906686e-1_p
w(7)=6.698032887170103e-1_p
x(8)=1.826408141450871_p
w(8)=2.350116349803594e-1_p
x(9)=3.635273868350411_p
w(9)=4.942437708885476e-2_p
x(10)=5.664069567726944_p
w(10)=7.352566332942732e-3_p
x(11)=7.872234442574394_p
w(11)=8.682244674546725e-4_p
x(12)=10.19522969417168_p
w(12)=8.780894193868198e-5_p
x(13)=12.53336467193174_p
w(13)=8.287253256554925e-6_p
x(14)=14.72938136193535_p
w(14)=8.235569256199872e-7_p
x(15)=16.55101770331967_p
w(15)=9.986128304119267e-8_p
x(16)=17.70992363670911_p
w(16)=1.495434110614317e-8_p
else if(N==17)then
x(1)=-5.912607933945366_p
w(1)=2.232362924908800e-1_p
x(2)=-5.543367575573875_p
w(2)=5.103568430346540e-1_p
x(3)=-4.894836908419061_p
w(3)=7.743371022134812e-1_p
x(4)=-3.994546270607614_p
w(4)=9.951831823863841e-1_p
x(5)=-2.884318378724334_p
w(5)=1.134009215693391_p
x(6)=-1.620388176374620_p
w(6)=1.102417970523090_p
x(7)=-2.557416236335662e-1_p
w(7)=7.942380169299843e-1_p
x(8)=1.214883509614538_p
w(8)=3.536007777924525e-1_p
x(9)=2.855651707561776_p
w(9)=9.469017810945694e-2_p
x(10)=4.694836688211316_p
w(10)=1.750906067514024e-2_p
x(11)=6.707910597934004_p
w(11)=2.543909083188186e-3_p
x(12)=8.847652285072982_p
w(12)=3.136712465516328e-4_p
x(13)=11.0467480601631_p
w(13)=3.504861989210478e-5_p
x(14)=13.20548909711723_p
w(14)=3.854570594304548e-6_p
x(15)=15.17813993644148_p
w(15)=4.653660739693336e-7_p
x(16)=16.76866948551022_p
w(16)=6.913239070657290e-8_p
x(17)=17.75608653482515_p
w(17)=1.204014545176946e-8_p
else
call GD(-6)
end if
end subroutine GF_m6

! [-5kT;18kT]
subroutine GF_m5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-3.535014966182505_p
w(1)=3.320507088247206_p
x(2)=4.997441205243907e-1_p
w(2)=1.686208245011933_p
else if(N==3)then
x(1)=-4.074505024501613_p
w(1)=2.223365537031029_p
x(2)=-1.037926163675282_p
w(2)=2.518925244933468_p
x(3)=2.943005361418334_p
w(3)=2.644245512946418e-1_p
else if(N==4)then
x(1)=-4.342303913416639_p
w(1)=1.616231669100341_p
x(2)=-1.967442425581866_p
w(2)=2.512080837178337_p
x(3)=1.105910987733363_p
w(3)=8.581919206466723e-1_p
x(4)=5.743930771301599_p
w(4)=2.021090633378766e-2_p
else if(N==5)then
x(1)=-4.498478646181853_p
w(1)=1.246571916857255_p
x(2)=-2.590238191464392_p
w(2)=2.242460760990430_p
x(3)=3.452941103963458e-2_p
w(3)=1.378587064736378_p
x(4)=3.358648981270986_p
w(4)=1.379749687862624e-1_p
x(5)=8.748509534161883_p
w(5)=1.120621888813385e-3_p
else if(N==6)then
x(1)=-4.601277995051198_p
w(1)=9.977290278800952e-1_p
x(2)=-3.035796803438381_p
w(2)=1.942180569074490_p
x(3)=-7.466200248890308e-1_p
w(3)=1.667927597493108_p
x(4)=1.960034529104504_p
w(4)=3.846194169377579e-1_p
x(5)=5.791653674088571_p
w(5)=1.419272838646577e-2_p
x(6)=11.60762340754326_p
w(6)=6.599348722163525e-5_p
else if(N==7)then
x(1)=-4.674940008736531_p
w(1)=8.169707916120278e-1_p
x(2)=-3.372295563046067_p
w(2)=1.668430915496766_p
x(3)=-1.373038059283828_p
w(3)=1.750130780202182_p
x(4)=9.680405027490880e-1_p
w(4)=7.042502856685929e-1_p
x(5)=3.969152303345432_p
w(5)=6.551888428581240e-2_p
x(6)=8.153042442211433_p
w(6)=1.407523861778808e-3_p
x(7)=13.8739697678293_p
w(7)=6.152131978321706e-6_p
else if(N==8)then
x(1)=-4.730149312856936_p
w(1)=6.802708085567875e-1_p
x(2)=-3.633445166085993_p
w(2)=1.433496732652628_p
x(3)=-1.888918621693443_p
w(3)=1.699543760550721_p
x(4)=1.936854428833826e-1_p
w(4)=1.001393264943425_p
x(5)=2.678837408100521_p
w(5)=1.822228506147761e-1_p
x(6)=5.966621596934741_p
w(6)=9.615100389287205e-3_p
x(7)=10.23409364608591_p
w(7)=1.717314064722576e-4_p
x(8)=15.37207337827896_p
w(8)=1.084145041391899e-6_p
else if(N==9)then
x(1)=-4.772562132539883_p
w(1)=5.746004389047812e-1_p
x(2)=-3.838937550673450_p
w(2)=1.237143739735848_p
x(3)=-2.314671411809090_p
w(3)=1.583986464848233_p
x(4)=-4.423828727877350e-1_p
w(4)=1.207398572795325_p
x(5)=1.703934182665826_p
w(5)=3.651744070693789e-1_p
x(6)=4.404280461244642_p
w(6)=3.686920519469767e-2_p
x(7)=7.824185417820108_p
w(7)=1.513584427370112e-3_p
x(8)=11.94477580965615_p
w(8)=2.859497807104732e-5_p
x(9)=16.27291311737555_p
w(9)=3.253054339236237e-7_p
else if(N==10)then
x(1)=-4.805783198835898_p
w(1)=4.914608077080762e-1_p
x(2)=-4.002667302658982_p
w(2)=1.074484146126908_p
x(3)=-2.666275656272731_p
w(3)=1.446384057696539_p
x(4)=-9.785670844313207e-1_p
w(4)=1.307996910918222_p
x(5)=9.314202416606625e-1_p
w(5)=5.807153804453492e-1_p
x(6)=3.220823303573157_p
w(6)=9.813539163818312e-2_p
x(7)=6.066439123199781_p
w(7)=7.249849518527149e-3_p
x(8)=9.469091941024555_p
w(8)=2.820431840404156e-4_p
x(9)=13.28346079204295_p
w(9)=6.606658672172907e-6_p
x(10)=16.80985891476386_p
w(10)=1.393646215273639e-7_p
else if(N==11)then
x(1)=-4.832259838142098_p
w(1)=4.249806945255860e-1_p
x(2)=-4.134799801446614_p
w(2)=9.396794119730604e-1_p
x(3)=-2.957669136302564_p
w(3)=1.308622090403844_p
x(4)=-1.435706616274921_p
w(4)=1.324828524166934_p
x(5)=2.949086233086987e-1_p
w(5)=7.816799478897830e-1_p
x(6)=2.289275159782767_p
w(6)=2.016647192666053e-1_p
x(7)=4.714543625101773_p
w(7)=2.364369370717627e-2_p
x(8)=7.600658733130115_p
w(8)=1.549492861358955e-3_p
x(9)=10.87460060717278_p
w(9)=6.463521768404304e-5_p
x(10)=14.29969278956948_p
w(10)=2.048555770570407e-6_p
x(11)=17.14104042289921_p
w(11)=7.469133652020726e-8_p
else if(N==12)then
x(1)=-4.853689346599586_p
w(1)=3.710383656441117e-1_p
x(2)=-4.242754569796290_p
w(2)=8.274347113019274e-1_p
x(3)=-3.200519572529701_p
w(3)=1.180217674131763_p
x(4)=-1.827262110599455_p
w(4)=1.288258214536570_p
x(5)=-2.449440768456340e-1_p
w(5)=9.338061770385865e-1_p
x(6)=1.533083590414053_p
w(6)=3.408380676514228e-1_p
x(7)=3.639024801056168_p
w(7)=5.892362147875830e-2_p
x(8)=6.133027990892637_p
w(8)=5.801260037096060e-3_p
x(9)=8.973659428367707_p
w(9)=3.780997011985439e-4_p
x(10)=12.04555108751746_p
w(10)=1.828750526319786e-5_p
x(11)=15.06109182262771_p
w(11)=8.080641892742562e-7_p
x(12)=17.35497388152408_p
w(12)=4.616825077936112e-8_p
else if(N==13)then
x(1)=-4.871271783187742_p
w(1)=3.266937692337678e-1_p
x(2)=-4.331971142626040_p
w(2)=7.333667640327011e-1_p
x(3)=-3.404265856124406_p
w(3)=1.064453313387241_p
x(4)=-2.163533528462143_p
w(4)=1.223010337232205_p
x(5)=-7.113269643315864e-1_p
w(5)=1.026012875703496_p
x(6)=9.023901904891439e-1_p
w(6)=4.950531048989154e-1_p
x(7)=2.762077270269941_p
w(7)=1.199101205667141e-1_p
x(8)=4.947150983724636_p
w(8)=1.656003038207971e-2_p
x(9)=7.441683189552451_p
w(9)=1.541084314309748e-3_p
x(10)=10.1755186525006_p
w(10)=1.072305738216524e-4_p
x(11)=13.00545139355697_p
w(11)=6.287304176903434e-6_p
x(12)=15.63154944059795_p
w(12)=3.842625272973695e-7_p
x(13)=17.49951856609355_p
w(13)=3.136718352428936e-8_p
else if(N==14)then
x(1)=-4.885872674585299_p
w(1)=2.898123295274759e-1_p
x(2)=-4.406479081763280_p
w(2)=6.539691118779843e-1_p
x(3)=-3.576414076747820_p
w(3)=9.617238768241051e-1_p
x(4)=-2.453105855401639_p
w(4)=1.145300344824702_p
x(5)=-1.118397797675093_p
w(5)=1.064824657734488_p
x(6)=3.639650203010331e-1_p
w(6)=6.394034579789033e-1_p
x(7)=2.032396370828712_p
w(7)=2.078029701086147e-1_p
x(8)=3.968813878537068_p
w(8)=3.856154612786330e-2_p
x(9)=6.181532054508798_p
w(9)=4.823698302599064e-3_p
x(10)=8.624264975603111_p
w(10)=4.551879664769190e-4_p
x(11)=11.21147541560787_p
w(11)=3.535712696166413e-5_p
x(12)=13.78572792325259_p
w(12)=2.561533598299706e-6_p
x(13)=16.0624708273679_p
w(13)=2.105713292341139e-7_p
x(14)=17.60112538312113_p
w(14)=2.275403589539963e-8_p
else if(N==15)then
x(1)=-4.898128133309990_p
w(1)=2.588172060516687e-1_p
x(2)=-4.469300713249192_p
w(2)=5.864704031824555e-1_p
x(3)=-3.722894771383672_p
w(3)=8.711980544029442e-1_p
x(4)=-2.703282166040712_p
w(4)=1.064581332186885_p
x(5)=-1.475633942514251_p
w(5)=1.064037012917990_p
x(6)=-1.041824743198807e-1_p
w(6)=7.551863653475261e-1_p
x(7)=1.414029089876275_p
w(7)=3.159309460585693e-1_p
x(8)=3.148414257592365_p
w(8)=7.646835791183187e-2_p
x(9)=5.127530140684486_p
w(9)=1.235139185684771e-2_p
x(10)=7.323056017749625_p
w(10)=1.508640424347914e-3_p
x(11)=9.677271126993910_p
w(11)=1.508474882461631e-4_p
x(12)=12.09551961519872_p
w(12)=1.342616798428292e-5_p
x(13)=14.4184449757838_p
w(13)=1.203530277518796e-6_p
x(14)=16.39209022181683_p
w(14)=1.284256887332096e-7_p
x(15)=17.6750055531078_p
w(15)=1.730587597282725e-8_p
else if(N==16)then
x(1)=-4.908513775890976_p
w(1)=2.325246407831051e-1_p
x(2)=-4.522731812459070_p
w(2)=5.286849940864150e-1_p
x(3)=-3.848391992254435_p
w(3)=7.916070582085085e-1_p
x(4)=-2.920248443852947_p
w(4)=9.859213157332289e-1_p
x(5)=-1.790138618052256_p
w(5)=1.037411558737280_p
x(6)=-5.165037377193789e-1_p
w(6)=8.345143118705960e-1_p
x(7)=8.810429035937388e-1_p
w(7)=4.314454205553693e-1_p
x(8)=2.450840953643251_p
w(8)=1.329165234833216e-1_p
x(9)=4.233965541140231_p
w(9)=2.699077902673027e-2_p
x(10)=6.218604620438633_p
w(10)=4.121727998712361e-3_p
x(11)=8.363486379903627_p
w(11)=5.144361268895400e-4_p
x(12)=10.60528780571655_p
w(12)=5.604457979683489e-5_p
x(13)=12.84564567507066_p
w(13)=5.787659848841466e-6_p
x(14)=14.93244961939785_p
w(14)=6.358193590093185e-7_p
x(15)=16.64784915246139_p
w(15)=8.495276869204865e-8_p
x(16)=17.73028704924341_p
w(16)=1.363720806768635e-8_p
else if(N==17)then
x(1)=-4.917390796574264_p
w(1)=2.100327472068994e-1_p
x(2)=-4.568537813628409_p
w(2)=4.788845347043036e-1_p
x(3)=-3.956616932158179_p
w(3)=7.216049632720025e-1_p
x(4)=-3.109199338769011_p
w(4)=9.117979216885876e-1_p
x(5)=-2.067704166850146_p
w(5)=9.957009339854815e-1_p
x(6)=-8.826730829366337e-1_p
w(6)=8.787219511508469e-1_p
x(7)=4.146937253547416e-1_p
w(7)=5.400493335071103e-1_p
x(8)=1.850121674795952_p
w(8)=2.067693002000765e-1_p
x(9)=3.467834700588102_p
w(9)=5.182088463124983e-2_p
x(10)=5.271173250553851_p
w(10)=9.650155947525564e-3_p
x(11)=7.231132770127728_p
w(11)=1.463996760072210e-3_p
x(12)=9.301958661814169_p
w(12)=1.921853760147063e-4_p
x(13)=11.41758581657556_p
w(13)=2.319707548633995e-5_p
x(14)=13.48067277246029_p
w(14)=2.787371591762920e-6_p
x(15)=15.35196051639648_p
w(15)=3.695274531742082e-7_p
x(16)=16.84920765723269_p
w(16)=5.980969819320730e-8_p
x(17)=17.77267163373847_p
w(17)=1.104473822044500e-8_p
else
call GD(-5)
end if
end subroutine GF_m5

! [-4kT;18kT]
subroutine GF_m4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.719499066544051_p
w(1)=2.798297361108466_p
x(2)=9.542699867925882e-1_p
w(2)=1.219852551579364_p
else if(N==3)then
x(1)=-3.173051154100659_p
w(1)=1.934850877881331_p
x(2)=-4.481866509974521e-1_p
w(2)=1.923995322585637_p
x(3)=3.488879451253971_p
w(3)=1.593037122208619e-1_p
else if(N==4)then
x(1)=-3.403654244830745_p
w(1)=1.434122060837725_p
x(2)=-1.260422018835485_p
w(2)=2.024343278083387_p
x(3)=1.671827629777726_p
w(3)=5.487919803365044e-1_p
x(4)=6.371164306154157_p
w(4)=1.089259343021443e-2_p
else if(N==5)then
x(1)=-3.540847062014338_p
w(1)=1.119851596189017_p
x(2)=-1.804194184520950_p
w(2)=1.880483567241600_p
x(3)=6.417827197364885e-1_p
w(3)=9.413363737177287e-1_p
x(4)=3.985290040331970_p
w(4)=7.589453808787625e-2_p
x(5)=9.398510349203585_p
w(5)=5.838374516078345e-4_p
else if(N==6)then
x(1)=-3.632787676425836_p
w(1)=9.032059071023956e-1_p
x(2)=-2.198674262287963_p
w(2)=1.672831208749279_p
x(3)=-8.826939819726248e-2_p
w(3)=1.213020219848656_p
x(4)=2.580831693920825_p
w(4)=2.215988464096199e-1_p
x(5)=6.435175252833147_p
w(5)=7.457647461199755e-3_p
x(6)=12.18851290603992_p
w(6)=3.608311667972738e-5_p
else if(N==7)then
x(1)=-3.699461215500158_p
w(1)=7.433532383838584e-1_p
x(2)=-2.500332767272758_p
w(2)=1.463250167454492_p
x(3)=-6.626603127406041e-1_p
w(3)=1.345055251428923_p
x(4)=1.593125429861085_p
w(4)=4.307550965772324e-1_p
x(5)=4.606141566066150_p
w(5)=3.497441332819303e-2_p
x(6)=8.756407569018835_p
w(6)=7.579575157108436e-4_p
x(7)=14.30394021281834_p
w(7)=3.787999419843694e-6_p
else if(N==8)then
x(1)=-3.749745382452882_p
w(1)=6.213998597804937e-1_p
x(2)=-2.736251901125230_p
w(2)=1.273349977857244_p
x(3)=-1.131062668190237_p
w(3)=1.365485371048571_p
x(4)=8.383931681988456e-1_p
w(4)=6.529127921754985e-1_p
x(5)=3.313611484278586_p
w(5)=9.977258138686630e-2_p
x(6)=6.583254262389554_p
w(6)=5.130321541070589e-3_p
x(7)=10.76259763891633_p
w(7)=9.825301150937849e-5_p
x(8)=15.65300605370874_p
w(8)=7.558865773278043e-7_p
else if(N==9)then
x(1)=-3.788536074919274_p
w(1)=5.265642616719397e-1_p
x(2)=-2.922939865589927_p
w(2)=1.109264732392045_p
x(3)=-1.516740411649222_p
w(3)=1.316307428763286_p
x(4)=2.331959395060018e-1_p
w(4)=8.377875654158842e-1_p
x(5)=2.341833862285060_p
w(5)=2.077633865018236e-1_p
x(6)=5.031638607274311_p
w(6)=1.960867453572992e-2_p
x(7)=8.394731222843420_p
w(7)=8.359760618382656e-4_p
x(8)=12.38503208326677_p
w(8)=1.763862546371568e-5_p
x(9)=16.45107172312609_p
w(9)=2.487198194723355e-7_p
else if(N==10)then
x(1)=-3.819027464009089_p
w(1)=4.515859912372671e-1_p
x(2)=-3.072397888638831_p
w(2)=9.702521248629143e-1_p
x(3)=-1.835848948320460_p
w(3)=1.232360083647010_p
x(4)=-2.673798287188740e-1_p
w(4)=9.601026592489492e-1_p
x(5)=1.579435753014287_p
w(5)=3.472150080077924e-1_p
x(6)=3.856626778060186_p
w(6)=5.254991334530751e-2_p
x(7)=6.663874684486305_p
w(7)=3.915746760160327e-3_p
x(8)=9.979720967129543_p
w(8)=1.638785942295177e-4_p
x(9)=13.63805853409407_p
w(9)=4.393765751924095e-6_p
x(10)=16.92570658456319_p
w(10)=1.132184481538043e-7_p
else if(N==11)then
x(1)=-3.843403676792505_p
w(1)=3.913862352659633e-1_p
x(2)=-3.193505871702419_p
w(2)=8.531870296049570e-1_p
x(3)=-2.101233888675248_p
w(3)=1.135746038664066_p
x(4)=-6.892839181781126e-1_p
w(4)=1.019871968418953_p
x(5)=9.604745533741709e-1_p
w(5)=4.943282054815956e-1_p
x(6)=2.932669348978103_p
w(6)=1.101195164517833e-1_p
x(7)=5.331291923703753_p
w(7)=1.260269183001571e-2_p
x(8)=8.154225766335243_p
w(8)=8.669536874518721e-4_p
x(9)=11.32052859029826_p
w(9)=3.975399029731840e-5_p
x(10)=14.58046240333919_p
w(10)=1.456180737328809e-6_p
x(11)=17.21967359941013_p
w(11)=6.311200950392180e-8_p
else if(N==12)then
x(1)=-3.863186176307751_p
w(1)=3.423704590790565e-1_p
x(2)=-3.292797343777940_p
w(2)=7.545495628779434e-1_p
x(3)=-2.323248905567947_p
w(3)=1.038515745976971_p
x(4)=-1.048763166822869_p
w(4)=1.030541829139905_p
x(5)=4.440136160501377e-1_p
w(5)=6.252393125138574e-1_p
x(6)=2.185351545184639_p
w(6)=1.922498567374793e-1_p
x(7)=4.270290310761531_p
w(7)=3.128779988116235e-2_p
x(8)=6.716876007072645_p
w(8)=3.161713453363693e-3_p
x(9)=9.476524396633309_p
w(9)=2.210841971765783e-4_p
x(10)=12.42856796043551_p
w(10)=1.190203239351922e-5_p
x(11)=15.28262714672492_p
w(11)=6.067535864473948e-7_p
x(12)=17.41072377337132_p
w(12)=4.004493459858582e-8_p
else if(N==13)then
x(1)=-3.879455305828972_p
w(1)=3.019566390538502e-1_p
x(2)=-3.375097706812939_p
w(2)=6.711305230136914e-1_p
x(3)=-2.510184792036210_p
w(3)=9.465063170661278e-1_p
x(4)=-1.357099741514276_p
w(4)=1.008249074411157_p
x(5)=4.155204166342935e-3_p
w(5)=7.249162026194391e-1_p
x(6)=1.566609920186254_p
w(6)=2.914802280016013e-1_p
x(7)=3.404899215085485_p
w(7)=6.410595498569845e-2_p
x(8)=5.553822932346579_p
w(8)=8.865554622234813e-3_p
x(9)=7.984763948250656_p
w(9)=8.690590004236377e-4_p
x(10)=10.62588494295427_p
w(10)=6.571944969177602e-5_p
x(11)=13.3313232796192_p
w(11)=4.311418524342601e-6_p
x(12)=15.80730365850993_p
w(12)=3.013421727295114e-7_p
x(13)=17.5406021618365_p
w(13)=2.770321765622099e-8_p
else if(N==14)then
x(1)=-3.892993362206794_p
w(1)=2.682587237577310e-1_p
x(2)=-3.444004939672813_p
w(2)=6.002156888791603e-1_p
x(3)=-2.668640318402566_p
w(3)=8.621194960722964e-1_p
x(4)=-1.622859317320986_p
w(4)=9.664670437225845e-1_p
x(5)=-3.758454952969905e-1_p
w(5)=7.890239748193530e-1_p
x(6)=1.043903845909285_p
w(6)=3.955452185688095e-1_p
x(7)=2.685534856857541_p
w(7)=1.131396608275069e-1_p
x(8)=4.593282502136486_p
w(8)=2.044087847839877e-2_p
x(9)=6.755108300576610_p
w(9)=2.647545700309248e-3_p
x(10)=9.123098209139572_p
w(10)=2.669529144543059e-4_p
x(11)=11.61096286620829_p
w(11)=2.269837958078331e-5_p
x(12)=14.06194647478579_p
w(12)=1.839380654487759e-6_p
x(13)=16.20335662230834_p
w(13)=1.708284615083227e-7_p
x(14)=17.63241111858622_p
w(14)=2.035852929746268e-8_p
else if(N==15)then
x(1)=-3.904377350024232_p
w(1)=2.398761900271951e-1_p
x(2)=-3.502232827990995_p
w(2)=5.395805032929336e-1_p
x(3)=-2.803853971773829_p
w(3)=7.859811519457565e-1_p
x(4)=-1.852903523983269_p
w(4)=9.147274624726175e-1_p
x(5)=-7.072684096608806e-1_p
w(5)=8.208947090801074e-1_p
x(6)=5.947420195055253e-1_p
w(6)=4.919086910894780e-1_p
x(7)=2.077841009780276_p
w(7)=1.770972138273889e-1_p
x(8)=3.787189483822069_p
w(8)=4.048137288872919e-2_p
x(9)=5.725167567065403_p
w(9)=6.645202366428333e-3_p
x(10)=7.859001628326037_p
w(10)=8.552579024838194e-4_p
x(11)=10.13136641157037_p
w(11)=9.213297772911046e-5_p
x(12)=12.44782417290829_p
w(12)=9.003144932170196e-6_p
x(13)=14.65269290855739_p
w(13)=8.990604549657606e-7_p
x(14)=16.50644437638485_p
w(14)=1.069777997634843e-7_p
x(15)=17.69949532398892_p
w(15)=1.563379586863462e-8_p
else if(N==16)then
x(1)=-3.914040065112988_p
w(1)=2.157529289108555e-1_p
x(2)=-3.551852695021215_p
w(2)=4.874252010305581e-1_p
x(3)=-2.919987141588649_p
w(3)=7.178554769052409e-1_p
x(4)=-2.052865404522596_p
w(4)=8.591553016777734e-1_p
x(5)=-9.981740905371919e-1_p
w(5)=8.273617084921056e-1_p
x(6)=2.034438462891366e-1_p
w(6)=5.714889193743596e-1_p
x(7)=1.557060206846028_p
w(7)=2.512295916360162e-1_p
x(8)=3.101714571262746_p
w(8)=7.093443987823990e-2_p
x(9)=4.851036293878701_p
w(9)=1.432885613138041e-2_p
x(10)=6.784133183417042_p
w(10)=2.275120196730707e-3_p
x(11)=8.860051537724114_p
w(11)=3.021337547719661e-4_p
x(12)=11.0161344638916_p
w(12)=3.562099545063222e-5_p
x(13)=13.15548866098629_p
w(13)=4.037980261090990e-6_p
x(14)=15.13177056846144_p
w(14)=4.910661977806206e-7_p
x(15)=16.74188065829111_p
w(15)=7.224719495937805e-8_p
x(16)=17.74990565722939_p
w(16)=1.241069334010451e-8_p
else if(N==17)then
x(1)=-3.922311113505994_p
w(1)=1.950811824590502e-1_p
x(2)=-3.594463965453116_p
w(2)=4.422994687696604e-1_p
x(3)=-3.020355711426125_p
w(3)=6.571278519217930e-1_p
x(4)=-2.227411129153170_p
w(4)=8.034288905120981e-1_p
x(5)=-1.254691336985986_p
w(5)=8.157101031588625e-1_p
x(6)=-1.410379189161644e-1_p
w(6)=6.300601672001496e-1_p
x(7)=1.104962695830462_p
w(7)=3.285981958126308e-1_p
x(8)=2.512079390378063_p
w(8)=1.123242041103426e-1_p
x(9)=4.100903506463067_p
w(9)=2.733481514474331e-2_p
x(10)=5.860888119446496_p
w(10)=5.217277077439706e-3_p
x(11)=7.761918478059625_p
w(11)=8.330691166579742e-4_p
x(12)=9.759270149873862_p
w(12)=1.170068774846711e-4_p
x(13)=11.78788868335858_p
w(13)=1.531061252500876e-5_p
x(14)=13.7530634031403_p
w(14)=2.014627188764448e-6_p
x(15)=15.52242895469337_p
w(15)=2.934714033806176e-7_p
x(16)=16.92750870641406_p
w(16)=5.170613005984335e-8_p
x(17)=17.78869815044002_p
w(17)=1.010967006401800e-8_p
else
call GD(-4)
end if
end subroutine GF_m4

! [-3kT;18kT]
subroutine GF_m3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.899029326698773_p
w(1)=2.236584003082936_p
x(2)=1.474537808964631_p
w(2)=8.120033332608265e-1_p
else if(N==3)then
x(1)=-2.271751618126928_p
w(1)=1.607569787063798_p
x(2)=1.761038006073218e-1_p
w(2)=1.352349754199464_p
x(3)=4.103365101584894_p
w(3)=8.866779508050013e-2_p
else if(N==4)then
x(1)=-2.466232675217047_p
w(1)=1.220702446213262_p
x(2)=-5.411519267663918e-1_p
w(2)=1.503006503340324_p
x(3)=2.300953698763319_p
w(3)=3.193316270544989e-1_p
x(4)=7.051835787544541_p
w(4)=5.546759735677916e-3_p
else if(N==5)then
x(1)=-2.584632388860438_p
w(1)=9.680175342232712e-1_p
x(2)=-1.016469944817181_p
w(2)=1.461057015030366_p
x(3)=1.295708845926216_p
w(3)=5.801104831740703e-1_p
x(4)=4.665687870270570_p
w(4)=3.910911201964807e-2_p
x(5)=10.0815322846531_p
w(5)=2.931918964064087e-4_p
else if(N==6)then
x(1)=-2.665592411414818_p
w(1)=7.884862962689776e-1_p
x(2)=-1.363879828849900_p
w(2)=1.344797861542094_p
x(3)=5.986222069072072e-1_p
w(3)=7.935804865308440e-1_p
x(4)=3.254407806774192_p
w(4)=1.179340359600163e-1_p
x(5)=7.112281519380725_p
w(5)=3.769144505577515e-3_p
x(6)=12.77199104590354_p
w(6)=1.951153625328291e-5_p
else if(N==7)then
x(1)=-2.725044340677087_p
w(1)=6.534471969335398e-1_p
x(2)=-1.631719768947361_p
w(2)=1.206341405865014_p
x(3)=6.239305767864981e-2_p
w(3)=9.309485695021384e-1_p
x(4)=2.266546956734405_p
w(4)=2.396329620924017e-1_p
x(5)=5.280323553857067_p
w(5)=1.781551044031402e-2_p
x(6)=9.376429528048606_p
w(6)=3.993458860151337e-4_p
x(7)=14.71748337267076_p
w(7)=2.345624338891086e-6_p
else if(N==8)then
x(1)=-2.770192422052330_p
w(1)=5.492220273144842e-1_p
x(2)=-1.842393044052588_p
w(2)=1.069789245902736_p
x(3)=-3.673908923325631e-1_p
w(3)=9.930720524632295e-1_p
x(4)=1.522590811881300_p
w(4)=3.823314518548319e-1_p
x(5)=3.989290231353722_p
w(5)=5.145627631686178e-2_p
x(6)=7.223105033086230_p
w(6)=2.660107556251767e-3_p
x(7)=11.29552460042792_p
w(7)=5.564361120013151e-5_p
x(8)=15.91696926700415_p
w(8)=5.313241675054180e-7_p
else if(N==9)then
x(1)=-2.805198373273540_p
w(1)=4.674792825991176e-1_p
x(2)=-2.009963448592186_p
w(2)=9.454037980022226e-1_p
x(3)=-7.179809993062801e-1_p
w(3)=9.976567668219491e-1_p
x(4)=9.372320561053135e-1_p
w(4)=5.180021034592944e-1_p
x(5)=3.022011546015082_p
w(5)=1.095200261637222e-1_p
x(6)=5.686963316577526_p
w(6)=1.006067791761216e-2_p
x(7)=8.978143513014491_p
w(7)=4.536415054318855e-4_p
x(8)=12.82221368159832_p
w(8)=1.084870123091267e-5_p
x(9)=16.6174786925542_p
w(9)=1.911731813962440e-7_p
else if(N==10)then
x(1)=-2.832835581358107_p
w(1)=4.024009048228672e-1_p
x(2)=-2.144771808453686_p
w(2)=8.361444487525997e-1_p
x(3)=-1.007098281706942_p
w(3)=9.655949013495834e-1_p
x(4)=4.619229331952867e-1_p
w(4)=6.263351948927157e-1_p
x(5)=2.267503705501160_p
w(5)=1.890707939079649e-1_p
x(6)=4.524349297238221_p
w(6)=2.687712083737229e-2_p
x(7)=7.279266528398969_p
w(7)=2.066699102457388e-3_p
x(8)=10.49574368583025_p
w(8)=9.425638248749387e-5_p
x(9)=13.98623989673804_p
w(9)=2.924099843613589e-6_p
x(10)=17.03419272583893_p
w(10)=9.219587071737634e-8_p
else if(N==11)then
x(1)=-2.855014545312765_p
w(1)=3.498456506726506e-1_p
x(2)=-2.254492068009761_p
w(2)=7.417008488071872e-1_p
x(3)=-1.247568864255441_p
w(3)=9.136145226192729e-1_p
x(4)=6.720123148452344e-2_p
w(4)=6.992586703189605e-1_p
x(5)=1.660522288120814_p
w(5)=2.804726914012115e-1_p
x(6)=3.610808609450546_p
w(6)=5.666503683366462e-2_p
x(7)=5.969962422450253_p
w(7)=6.526720315513325e-3_p
x(8)=8.718462643376640_p
w(8)=4.777814478751688e-4_p
x(9)=11.76691828801525_p
w(9)=2.432359959676708e-5_p
x(10)=14.85418906914686_p
w(10)=1.036979210398254e-6_p
x(11)=17.29371151855467_p
w(11)=5.334861944862946e-8_p
else if(N==12)then
x(1)=-2.873073714938249_p
w(1)=3.068449223432696e-1_p
x(2)=-2.344798070909025_p
w(2)=6.605517337259760e-1_p
x(3)=-1.449102079608072_p
w(3)=8.529145722598275e-1_p
x(4)=-2.657305947268215e-1_p
w(4)=7.383125780096665e-1_p
x(5)=1.159989515203011_p
w(5)=3.715718931818582e-1_p
x(6)=2.873270350327549_p
w(6)=1.005450487181188e-1_p
x(7)=4.926950010439032_p
w(7)=1.602024622051619e-2_p
x(8)=7.315258505354664_p
w(8)=1.690099883301211e-3_p
x(9)=9.984828131384386_p
w(9)=1.280220091532298e-4_p
x(10)=12.80919992670073_p
w(10)=7.728929650132106e-6_p
x(11)=15.49777841130552_p
w(11)=4.563574111531939e-7_p
x(12)=17.46352303877823_p
w(12)=3.470501385771612e-8_p
else if(N==13)then
x(1)=-2.887968680578944_p
w(1)=2.712433156963894e-1_p
x(2)=-2.419906157936043_p
w(2)=5.908790249559915e-1_p
x(3)=-1.619215639979027_p
w(3)=7.902347756935514e-1_p
x(4)=-5.496015608581729e-1_p
w(4)=7.499277035002289e-1_p
x(5)=7.389932572847330e-1_p
w(5)=4.519877260433411e-1_p
x(6)=2.264955459829405_p
w(6)=1.564447932677620e-1_p
x(7)=4.076044593600560_p
w(7)=3.270912803260734e-2_p
x(8)=6.178265502009719_p
w(8)=4.634039992327326e-3_p
x(9)=8.537000535951091_p
w(9)=4.835776055443926e-4_p
x(10)=11.07809415294564_p
w(10)=4.003602888961340e-5_p
x(11)=13.65345603618218_p
w(11)=2.954532124036973e-6_p
x(12)=15.97772681514542_p
w(12)=2.365659804358788e-7_p
x(13)=17.57972147483652_p
w(13)=2.442902501023783e-8_p
else if(N==14)then
x(1)=-2.900394863365595_p
w(1)=2.414520868573150e-1_p
x(2)=-2.482979643612951_p
w(2)=5.309389455378770e-1_p
x(3)=-1.763799630263227_p
w(3)=7.293061608641518e-1_p
x(4)=-7.935714765245836e-1_p
w(4)=7.416848796314343e-1_p
x(5)=3.793857415144470e-1_p
w(5)=5.154517496396774e-1_p
x(6)=1.754197666720729_p
w(6)=2.196221934702986e-1_p
x(7)=3.368973118478856_p
w(7)=5.801330058585644e-2_p
x(8)=5.238447847690235_p
w(8)=1.051788953652313e-2_p
x(9)=7.340852363421744_p
w(9)=1.429012675437141e-3_p
x(10)=9.627179840379815_p
w(10)=1.551204362904239e-4_p
x(11)=12.00997718407259_p
w(11)=1.451947373209520e-5_p
x(12)=14.3340057428918_p
w(12)=1.320818977750943e-6_p
x(13)=16.33994818230268_p
w(13)=1.386375318311218e-7_p
x(14)=17.66234191798377_p
w(14)=1.817865952748855e-8_p
else if(N==15)then
x(1)=-2.910867475964174_p
w(1)=2.162824197615039e-1_p
x(2)=-2.536418130965450_p
w(2)=4.791916830666994e-1_p
x(3)=-1.887502255158411_p
w(3)=6.720040056771164e-1_p
x(4)=-1.004574792384437_p
w(4)=7.203181059004292e-1_p
x(5)=6.857333760825673e-2_p
w(5)=5.599565027006317e-1_p
x(6)=1.318792566311739_p
w(6)=2.841005241776564e-1_p
x(7)=2.772499349381324_p
w(7)=9.205019391098727e-2_p
x(8)=4.449301789967450_p
w(8)=2.063920821324841e-2_p
x(9)=6.337614574454486_p
w(9)=3.502934632312793e-3_p
x(10)=8.402988899054302_p
w(10)=4.790415182484961e-4_p
x(11)=10.58793046234794_p
w(11)=5.591728048849690e-5_p
x(12)=12.79828522656379_p
w(12)=6.024614660282219e-6_p
x(13)=14.88287544754605_p
w(13)=6.717094513851887e-7_p
x(14)=16.61738544763771_p
w(14)=8.908925721311139e-8_p
x(15)=17.72301985176727_p
w(15)=1.409107112644700e-8_p
else if(N==16)then
x(1)=-2.919774493956010_p
w(1)=1.948319804955058e-1_p
x(2)=-2.582062567985278_p
w(2)=4.343278743524722e-1_p
x(3)=-1.994012788606216_p
w(3)=6.191203503161924e-1_p
x(4)=-1.188054306055629_p
w(4)=6.910418569285482e-1_p
x(5)=-2.024767247702231e-1_p
w(5)=5.866073127901870e-1_p
x(6)=9.428161651955185e-1_p
w(6)=3.442674232954765e-1_p
x(7)=2.262787719419626_p
w(7)=1.334522136655534e-1_p
x(8)=3.778088991023018_p
w(8)=3.608021166499416e-2_p
x(9)=5.485360232706547_p
w(9)=7.419028970351100e-3_p
x(10)=7.360106612467686_p
w(10)=1.237377353530145e-3_p
x(11)=9.361609141322949_p
w(11)=1.758979153010873e-4_p
x(12)=11.42754006928529_p
w(12)=2.254286288097353e-5_p
x(13)=13.46277237619538_p
w(13)=2.813798552491608e-6_p
x(14)=15.32736294670029_p
w(14)=3.792722987610545e-7_p
x(15)=16.83320397320714_p
w(15)=6.139507951505025e-8_p
x(16)=17.76881680321744_p
w(16)=1.126683854123979e-8_p
else if(N==17)then
x(1)=-2.927412429454345_p
w(1)=1.764067348577101e-1_p
x(2)=-2.621341005399781_p
w(2)=3.952540350323942e-1_p
x(3)=-2.086275748370414_p
w(3)=5.708423064753786e-1_p
x(4)=-1.348382477419851_p
w(4)=6.575760542116588e-1_p
x(5)=-4.404823611877758e-1_p
w(5)=5.981811571221425e-1_p
x(6)=6.146561819057071e-1_p
w(6)=3.959963620530480e-1_p
x(7)=1.822247851415544_p
w(7)=1.796236748191414e-1_p
x(8)=3.200917986812917_p
w(8)=5.740762292093830e-2_p
x(9)=4.753506938315537_p
w(9)=1.397707482964521e-2_p
x(10)=6.463223728031927_p
w(10)=2.770867715045638e-3_p
x(11)=8.299885567045374_p
w(11)=4.688463633552470e-4_p
x(12)=10.21934215199935_p
w(12)=7.078242592050277e-5_p
x(13)=12.15749616100179_p
w(13)=1.007566269657814e-5_p
x(14)=14.02260430613177_p
w(14)=1.454961409030476e-6_p
x(15)=15.68959239687818_p
w(15)=2.330145011901431e-7_p
x(16)=17.00365142768655_p
w(16)=4.464862411949344e-8_p
x(17)=17.80419310445075_p
w(17)=9.230153167193866e-9_p
else
call GD(-3)
end if
end subroutine GF_m3

! [-2kT;18kT]
subroutine GF_m2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.066224466984254_p
w(1)=1.641095372841770_p
x(2)=2.078578634100086_p
w(2)=4.858326229712230e-1_p
else if(N==3)then
x(1)=-1.367449129921660_p
w(1)=1.231325903995310_p
x(2)=8.545762539526716e-1_p
w(2)=8.502952995731118e-1_p
x(3)=4.793953050381775_p
w(3)=4.530679224457172e-2_p
else if(N==4)then
x(1)=-1.528517873395159_p
w(1)=9.620272358869958e-1_p
x(2)=2.071484772832355e-1_p
w(2)=9.944721880634619e-1_p
x(3)=3.003089304108798_p
w(3)=1.677702576186206e-1_p
x(4)=7.790136102958829_p
w(4)=2.658314243914525e-3_p
else if(N==5)then
x(1)=-1.629015896934030_p
w(1)=7.773200718454343e-1_p
x(2)=-2.149636820565169e-1_p
w(2)=1.012106407665508_p
x(3)=2.010670091610691_p
w(3)=3.184717931490538e-1_p
x(4)=5.401597139264786_p
w(4)=1.888782031954628e-2_p
x(5)=10.79639494463946_p
w(5)=1.419028334503813e-4_p
else if(N==6)then
x(1)=-1.699195461863295_p
w(1)=6.411676181492179e-1_p
x(2)=-5.232218303331169e-1_p
w(2)=9.677740362251721e-1_p
x(3)=1.331417538249195_p
w(3)=4.579821200632795e-1_p
x(4)=3.982987407112557_p
w(4)=5.816157929362588e-2_p
x(5)=7.822865466446590_p
w(5)=1.832176472541051e-3_p
x(6)=13.35282973416906_p
w(6)=1.046560915639895e-5_p
else if(N==7)then
x(1)=-1.751372824978027_p
w(1)=5.363288446621706e-1_p
x(2)=-7.610469776721484e-1_p
w(2)=8.953402178175850e-1_p
x(3)=8.193836856983246e-1_p
w(3)=5.648158875829865e-1_p
x(4)=2.993684931543036_p
w(4)=1.215616674351326e-1_p
x(5)=5.991589490191344_p
w(5)=8.674014362532220e-3_p
x(6)=10.01212040655145_p
w(6)=2.059012984060869e-4_p
x(7)=15.11196822002536_p
w(7)=1.462654179897757e-6_p
else if(N==8)then
x(1)=-1.791287079044138_p
w(1)=4.541574976447472e-1_p
x(2)=-9.483146900070083e-1_p
w(2)=8.138958478202653e-1_p
x(3)=4.170069723577444e-1_p
w(3)=6.316252476132753e-1_p
x(4)=2.255899550903247_p
w(4)=2.007621862359016e-1_p
x(5)=4.705650513032245_p
w(5)=2.511503469665166e-2_p
x(6)=7.885861917987005_p
w(6)=1.340599087148711e-3_p
x(7)=11.83157076138177_p
w(7)=3.120637138717090e-5_p
x(8)=16.16384291417256_p
w(8)=3.763436158819726e-7_p
else if(N==9)then
x(1)=-1.822416190003872_p
w(1)=3.889387413960821e-1_p
x(2)=-1.097647612172115_p
w(2)=7.336555044257637e-1_p
x(3)=9.341872265318804e-2_p
w(3)=6.621787913927630e-1_p
x(4)=1.682814876049390_p
w(4)=2.830195830517959e-1_p
x(5)=3.745222425794752_p
w(5)=5.389942987483112e-2_p
x(6)=6.369737610523079_p
w(6)=4.987277544891660e-3_p
x(7)=9.573871927871414_p
w(7)=2.418657591488319e-4_p
x(8)=13.25528815222077_p
w(8)=6.654791998507089e-6_p
x(9)=16.77261914966883_p
w(9)=1.475757181024926e-7_p
else if(N==10)then
x(1)=-1.847119068969539_p
w(1)=3.365042856799080e-1_p
x(2)=-1.218193374442972_p
w(2)=6.592789674647604e-1_p
x(3)=-1.711049254846972e-1_p
w(3)=6.651843133059293e-1_p
x(4)=1.223987921458939_p
w(4)=3.570913176442997e-1_p
x(5)=2.998850880294451_p
w(5)=9.456321298800867e-2_p
x(6)=5.223104965675495_p
w(6)=1.318399683068779e-2_p
x(7)=7.912210799154125_p
w(7)=1.066214658076357e-3_p
x(8)=11.01653580607843_p
w(8)=5.366492058275558e-5_p
x(9)=14.32745819521842_p
w(9)=1.947137212659277e-6_p
x(10)=17.13574436380523_p
w(10)=7.518352712764048e-8_p
else if(N==11)then
x(1)=-1.867032587872107_p
w(1)=2.938129246116029e-1_p
x(2)=-1.316659830969029_p
w(2)=5.924070879787955e-1_p
x(3)=-3.900932922925387e-1_p
w(3)=6.496429778873823e-1_p
x(4)=8.480580820973725e-1_p
w(4)=4.161481637812152e-1_p
x(5)=2.401633157597197_p
w(5)=1.436665476812368e-1_p
x(6)=4.322853125344509_p
w(6)=2.768697225014354e-2_p
x(7)=6.629941582412868_p
w(7)=3.288384365368843e-3_p
x(8)=9.292978096803573_p
w(8)=2.593486573211369e-4_p
x(9)=12.21325187975598_p
w(9)=1.480402777649031e-5_p
x(10)=15.12070396120892_p
w(10)=7.394962098220354e-7_p
x(11)=17.36344254101951_p
w(11)=4.507594029595434e-8_p
else if(N==12)then
x(1)=-1.883311042347962_p
w(1)=2.586424679978375e-1_p
x(2)=-1.397987216500029_p
w(2)=5.332000539312437e-1_p
x(3)=-5.732611209704905e-1_p
w(3)=6.228654801457256e-1_p
x(4)=5.345942587481458e-1_p
w(4)=4.578655667541370e-1_p
x(5)=1.912705251652571_p
w(5)=1.961647516077030e-1_p
x(6)=3.596949119042829_p
w(6)=4.928845786822932e-2_p
x(7)=5.608023743604437_p
w(7)=7.936047159144465e-3_p
x(8)=7.927780916923027_p
w(8)=8.863829482311247e-4_p
x(9)=10.49820793994909_p
w(9)=7.340698933929687e-5_p
x(10)=13.1871103103467_p
w(10)=5.006758012197590e-6_p
x(11)=15.7065808234759_p
w(11)=3.436227074258705e-7_p
x(12)=17.51355745005165_p
w(12)=3.003068218113253e-8_p
else if(N==13)then
x(1)=-1.896783773803309_p
w(1)=2.293536306038428e-1_p
x(2)=-1.465848922351656_p
w(2)=4.811580929285862e-1_p
x(3)=-7.278273879062443e-1_p
w(3)=5.901066136021021e-1_p
x(4)=2.696840829579301e-1_p
w(4)=4.831184100995677e-1_p
x(5)=1.504980951633883_p
w(5)=2.469923284284662e-1_p
x(6)=2.999503380630726_p
w(6)=7.751070922300587e-2_p
x(7)=4.774279323781829_p
w(7)=1.602867054603169e-2_p
x(8)=6.819885615350712_p
w(8)=2.367573295534640e-3_p
x(9)=9.098093737681797_p
w(9)=2.654986705615705e-4_p
x(10)=11.53185583201985_p
w(10)=2.423847561474801e-5_p
x(11)=13.97168294364594_p
w(11)=2.022647810574447e-6_p
x(12)=16.14293664807349_p
w(12)=1.857974407279006e-7_p
x(13)=17.61699749799215_p
w(13)=2.149442802234284e-8_p
else if(N==14)then
x(1)=-1.908057827862055_p
w(1)=2.047219769381900e-1_p
x(2)=-1.523008145339150_p
w(2)=4.355352577777149e-1_p
x(3)=-8.592890263629370e-1_p
w(3)=5.548651429683610e-1_p
x(4)=4.344795281130375e-2_p
w(4)=4.944600534028566e-1_p
x(5)=1.159828767431774_p
w(5)=2.921921340464282e-1_p
x(6)=2.499541405803189_p
w(6)=1.107337773447680e-1_p
x(7)=4.081659486748829_p
w(7)=2.829413970193885e-2_p
x(8)=5.903395524792153_p
w(8)=5.267181016042236e-3_p
x(9)=7.938404269079796_p
w(9)=7.587102815266864e-4_p
x(10)=10.13627248410594_p
w(10)=8.929384682479201e-5_p
x(11)=12.40832147949089_p
w(11)=9.251777137857488e-6_p
x(12)=14.6018628701469_p
w(12)=9.480357969859622e-7_p
x(13)=16.4723827470887_p
w(13)=1.124851876981955e-7_p
x(14)=17.69099885468658_p
w(14)=1.619021908691731e-8_p
else if(N==15)then
x(1)=-1.917585281028679_p
w(1)=1.838210153114342e-1_p
x(2)=-1.571568209774902_p
w(2)=3.955387020191696e-1_p
x(3)=-9.719048752736590e-1_p
w(3)=5.193393821239748e-1_p
x(4)=-1.513985670043150e-1_p
w(4)=4.949658738497250e-1_p
x(5)=8.640447179232448e-1_p
w(5)=3.293750793068547e-1_p
x(6)=2.075290999564992_p
w(6)=1.466281399104364e-1_p
x(7)=3.497820413307060_p
w(7)=4.496044662097410e-2_p
x(8)=5.133519840766501_p
w(8)=1.018505807956003e-2_p
x(9)=6.964330678863070_p
w(9)=1.810882876598869e-3_p
x(10)=8.954776167104551_p
w(10)=2.650904748647889e-4_p
x(11)=11.04678658910461_p
w(11)=3.371510828194817e-5_p
x(12)=13.14679584207743_p
w(12)=4.021663491359765e-6_p
x(13)=15.10902632200266_p
w(13)=5.016733319230478e-7_p
x(14)=16.72504327914371_p
w(14)=7.412947331581761e-8_p
x(15)=17.74563524484008_p
w(15)=1.266482183501034e-8_p
else if(N==16)then
x(1)=-1.925708146690518_p
w(1)=1.659408140963491e-1_p
x(2)=-1.613148761584407_p
w(2)=3.604183255444923e-1_p
x(3)=-1.069017556962969_p
w(3)=4.848350378212761e-1_p
x(4)=-3.203983136290776e-1_p
w(4)=4.875557177212602e-1_p
x(5)=6.080177382143546e-1_p
w(5)=3.576384389193296e-1_p
x(6)=1.710992617740854_p
w(6)=1.826882829805999e-1_p
x(7)=2.999624648262864_p
w(7)=6.568073280007072e-2_p
x(8)=4.478604651837331_p
w(8)=1.763504203328643e-2_p
x(9)=6.136124475960001_p
w(9)=3.754348975416777e-3_p
x(10)=7.946202349242824_p
w(10)=6.632487811364919e-4_p
x(11)=9.867989460481891_p
w(11)=1.014927904510822e-4_p
x(12)=11.8393890686687_p
w(12)=1.420071213767800e-5_p
x(13)=13.76746266577934_p
w(13)=1.957553666872884e-6_p
x(14)=15.51930129718281_p
w(14)=2.927811714512078e-7_p
x(15)=16.9219325477604_p
w(15)=5.210411739162924e-8_p
x(16)=17.78706055224498_p
w(16)=1.019823089816542e-8_p
else if(N==17)then
x(1)=-1.932688898443582_p
w(1)=1.505308501382562e-1_p
x(2)=-1.649010841155069_p
w(2)=3.295017487424988e-1_p
x(3)=-1.153278019139696_p
w(3)=4.520731422048566e-1_p
x(4)=-4.678758512702439e-1_p
w(4)=4.746923860325635e-1_p
x(5)=3.845725865926981e-1_p
w(5)=3.771980958816777e-1_p
x(6)=1.394980369656143_p
w(6)=2.166879498950481e-1_p
x(7)=2.570014541955403_p
w(7)=8.959603803644091e-2_p
x(8)=3.915536316358474_p
w(8)=2.793421298326487e-2_p
x(9)=5.424529565920268_p
w(9)=6.955453778870276e-3_p
x(10)=7.077696805048574_p
w(10)=1.446737744747686e-3_p
x(11)=8.844831114171155_p
w(11)=2.609551633469542e-4_p
x(12)=10.68206002638489_p
w(12)=4.253516859361437e-5_p
x(13)=12.52634863518543_p
w(13)=6.608801567082669e-6_p
x(14)=14.28931353251654_p
w(14)=1.049477693849358e-6_p
x(15)=15.85354296746529_p
w(15)=1.848726775371320e-7_p
x(16)=17.07773162601182_p
w(16)=3.848925031856327e-8_p
x(17)=17.8191859345272_p
w(17)=8.401638845818883e-9_p
else
call GD(-2)
end if
end subroutine GF_m2

! [-1kT;18kT]
subroutine GF_m1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.078144895667094e-1_p
w(1)=1.057149469760819_p
x(2)=2.782823559274514_p
w(2)=2.561122025274238e-1_p
else if(N==3)then
x(1)=-4.524074704063213e-1_p
w(1)=8.262032603683741e-1_p
x(2)=1.607655857211994_p
w(2)=4.658961310749252e-1_p
x(3)=5.566695646362012_p
w(3)=2.116228084494390e-2_p
else if(N==4)then
x(1)=-5.856754487348710e-1_p
w(1)=6.645995459614621e-1_p
x(2)=1.005558226757504_p
w(2)=5.679525300543590e-1_p
x(3)=3.784068566034573_p
w(3)=7.951424887003510e-2_p
x(4)=8.589153363747823_p
w(4)=1.195347402387099e-3_p
else if(N==5)then
x(1)=-6.707499443251103e-1_p
w(1)=5.478675181934388e-1_p
x(2)=6.188793213384146e-1_p
w(2)=6.013388084848160e-1_p
x(3)=2.795925898434465_p
w(3)=1.554285731416039e-1_p
x(4)=6.193363661578069_p
w(4)=8.560452123909164e-3_p
x(5)=11.53916019316113_p
w(5)=6.632034447532766e-5_p
else if(N==6)then
x(1)=-7.312939844979927e-1_p
w(1)=4.583650406879957e-1_p
x(2)=3.383614301060496e-1_p
w(2)=5.957051946191501e-1_p
x(3)=2.123719646464078_p
w(3)=2.316053532987922e-1_p
x(4)=4.766437412362078_p
w(4)=2.672332511485224e-2_p
x(5)=8.565745613601853_p
w(5)=8.571668794411093e-4_p
x(6)=13.92421544259151_p
w(6)=5.591688011925932e-6_p
else if(N==7)then
x(1)=-7.767696616362365e-1_p
w(1)=3.876729614828966e-1_p
x(2)=1.234063104898105e-1_p
w(2)=5.683452087054709e-1_p
x(3)=1.624683498875768_p
w(3)=2.963891131237589e-1_p
x(4)=3.775755272742221_p
w(4)=5.670581633716781e-2_p
x(5)=6.739084048106063_p
w(5)=4.043662686010667e-3_p
x(6)=10.66150596977244_p
w(6)=1.039901781840100e-4_p
x(7)=15.48466624523147_p
w(7)=9.197747543407810e-7_p
else if(N==8)then
x(1)=-8.117810201688690e-1_p
w(1)=3.312595385879302e-1_p
x(2)=-4.503352624954297e-2_p
w(2)=5.304259415267190e-1_p
x(3)=1.239121541142705_p
w(3)=3.438444023153601e-1_p
x(4)=3.042414330693015_p
w(4)=9.540204980864021e-2_p
x(5)=5.461431579178139_p
w(5)=1.165505664092977e-2_p
x(6)=8.570529158903886_p
w(6)=6.570664656728878e-4_p
x(7)=12.36870489946833_p
w(7)=1.734845643951472e-5_p
x(8)=16.39348654295712_p
w(8)=2.684865515193399e-7_p
else if(N==9)then
x(1)=-8.392385227282707e-1_p
w(1)=2.858291316148340e-1_p
x(2)=-1.790974394635297e-1_p
w(2)=4.888909494049387e-1_p
x(3)=9.334591283886730e-1_p
w(3)=3.734320101994228e-1_p
x(4)=2.477604218022456_p
w(4)=1.376076093641672e-1_p
x(5)=4.510168640473106_p
w(5)=2.497875874149929e-2_p
x(6)=7.078943823834321_p
w(6)=2.392262297000741e-3_p
x(7)=10.18074986829538_p
w(7)=1.267627119014839e-4_p
x(8)=13.68278839543022_p
w(8)=4.073649928147428e-6_p
x(9)=16.91688470000846_p
w(9)=1.143045507614855e-7_p
else if(N==10)then
x(1)=-8.611379550485261e-1_p
w(1)=2.488585059281309e-1_p
x(2)=-2.873236848735967e-1_p
w(2)=4.476333128732680e-1_p
x(3)=6.863030894795910e-1_p
w(3)=3.876834210080388e-1_p
x(4)=2.029612432934678_p
w(4)=1.783087364051713e-1_p
x(5)=3.773111248497016_p
w(5)=4.398366972909695e-2_p
x(6)=5.951494376515085_p
w(6)=6.224436574643984e-3_p
x(7)=8.561826468886762_p
w(7)=5.379736477038693e-4_p
x(8)=11.54099124892588_p
w(8)=3.025737924864793e-5_p
x(9)=14.66091468036914_p
w(9)=1.297402142113902e-6_p
x(10)=17.23069981763592_p
w(10)=6.134079873561954e-8_p
else if(N==11)then
x(1)=-8.788713300858347e-1_p
w(1)=2.184494466256873e-1_p
x(2)=-3.758258746169676e-1_p
w(2)=4.086254869223414e-1_p
x(3)=4.832959248325089e-1_p
w(3)=3.901407257256574e-1_p
x(4)=1.666096669828476_p
w(4)=2.139170427255694e-1_p
x(5)=3.185417669540466_p
w(5)=6.743493436346630e-2_p
x(6)=5.067049594478911_p
w(6)=1.293194514752145e-2_p
x(7)=7.310262561551052_p
w(7)=1.613856514276666e-3_p
x(8)=9.876951229758292_p
w(8)=1.387039311034500e-4_p
x(9)=12.65866129758904_p
w(9)=8.964361421195376e-6_p
x(10)=15.37967387564023_p
w(10)=5.279330188584442e-7_p
x(11)=17.42909096867226_p
w(11)=3.803817975389813e-8_p
else if(N==12)then
x(1)=-8.934258156757460e-1_p
w(1)=1.931805634473340e-1_p
x(2)=-4.490446397940456e-1_p
w(2)=3.727276666765312e-1_p
x(3)=3.144071407297641e-1_p
w(3)=3.842175825170841e-1_p
x(4)=1.365786093771398_p
w(4)=2.425306530587320e-1_p
x(5)=2.706392578225199_p
w(5)=9.339815769290800e-2_p
x(6)=4.354674279478439_p
w(6)=2.289188277163953e-2_p
x(7)=6.312235881823305_p
w(7)=3.813657395182729e-3_p
x(8)=8.553696923430406_p
w(8)=4.563034632678504e-4_p
x(9)=11.01594544770393_p
w(9)=4.168512966213211e-5_p
x(10)=13.56171109976019_p
w(10)=3.235313434511793e-6_p
x(11)=15.90894916069207_p
w(11)=2.588956934855797e-7_p
x(12)=17.56096923809472_p
w(12)=2.592677370068725e-8_p
else if(N==13)then
x(1)=-9.055147630297127e-1_p
w(1)=1.719817711631246e-1_p
x(2)=-5.102569654163077e-1_p
w(2)=3.401890735820820e-1_p
x(3)=1.723868689795338e-1_p
w(3)=3.727396360531928e-1_p
x(4)=1.114095060864541_p
w(4)=2.636461964798966e-1_p
x(5)=2.309009487667934_p
w(5)=1.197998980301888e-1_p
x(6)=3.769233292641797_p
w(6)=3.597991513489722e-2_p
x(7)=5.497953349013936_p
w(7)=7.581675833417256e-3_p
x(8)=7.477825927359199_p
w(8)=1.183522073381922e-3_p
x(9)=9.667420245719827_p
w(9)=1.438527100809762e-4_p
x(10)=11.9865968006117_p
w(10)=1.458348570908640e-5_p
x(11)=14.28565248080198_p
w(11)=1.382978953071071e-6_p
x(12)=16.30295788731543_p
w(12)=1.459050919132411e-7_p
x(13)=17.65252153538987_p
w(13)=1.885822687808190e-8_p
else if(N==14)then
x(1)=-9.156631566554225e-1_p
w(1)=1.540400664114112e-1_p
x(2)=-5.619183742977080e-1_p
w(2)=3.109409982497996e-1_p
x(3)=5.184967750140979e-2_p
w(3)=3.578563441662000e-1_p
x(4)=9.006594575506862e-1_p
w(4)=2.776905255270541e-1_p
x(5)=1.974559981378916_p
w(5)=1.448441529129015e-1_p
x(6)=3.280304980889315_p
w(6)=5.162806177818243e-2_p
x(7)=4.821694900026927_p
w(7)=1.323511286735661e-2_p
x(8)=6.587016334416164_p
w(8)=2.572434814119497e-3_p
x(9)=8.547131746122462_p
w(9)=3.963962495423345e-4_p
x(10)=10.64985889030359_p
w(10)=5.092212326064462e-5_p
x(11)=12.80557649062176_p
w(11)=5.871704031082942e-6_p
x(12)=14.86533415052841_p
w(12)=6.799219050505100e-7_p
x(13)=16.60072465703272_p
w(13)=9.118931983317867e-8_p
x(14)=17.71844229121269_p
w(14)=1.437315930000700e-8_p
else if(N==15)then
x(1)=-9.242639143717059e-1_p
w(1)=1.387313574416523e-1_p
x(2)=-6.058950179447108e-1_p
w(2)=2.847624517297784e-1_p
x(3)=-5.129261780564732e-2_p
w(3)=3.411155848150642e-1_p
x(4)=7.178865961801721e-1_p
w(4)=2.855873481020837e-1_p
x(5)=1.689669043187722_p
w(5)=1.672258201573549e-1_p
x(6)=2.866507472610279_p
w(6)=6.897767167474850e-2_p
x(7)=4.251976128803280_p
w(7)=2.089105966631152e-2_p
x(8)=5.838408071015348_p
w(8)=4.883267706372609e-3_p
x(9)=7.604568426349414_p
w(9)=9.188453427705957e-4_p
x(10)=9.513864763922188_p
w(10)=1.449471939735435e-4_p
x(11)=11.50752372119276_p
w(11)=2.019369238057896e-5_p
x(12)=13.49307300774992_p
w(12)=2.677445409510975e-6_p
x(13)=15.33106855211737_p
w(13)=3.743825760053596e-7_p
x(14)=16.82949034201446_p
w(14)=6.159341837807748e-8_p
x(15)=17.76738276354041_p
w(15)=1.134434836335234e-8_p
else if(N==16)then
x(1)=-9.316156487956362e-1_p
w(1)=1.255715097279134e-1_p
x(2)=-6.436236350237401e-1_p
w(2)=2.613712278310543e-1_p
x(3)=-1.401979223165929e-1_p
w(3)=3.235875481347865e-1_p
x(4)=5.600674039350307e-1_p
w(4)=2.884408294939185e-1_p
x(5)=1.444517307430442_p
w(5)=1.861714843084291e-1_p
x(6)=2.512328624752451_p
w(6)=8.705833524108110e-2_p
x(7)=3.766270857483261_p
w(7)=3.044666841323715e-2_p
x(8)=5.201520483493551_p
w(8)=8.335148900593600e-3_p
x(9)=6.802373711136521_p
w(9)=1.859862480525567e-3_p
x(10)=8.541879003738201_p
w(10)=3.504788950306367e-4_p
x(11)=10.37879358932668_p
w(11)=5.803759609709612e-5_p
x(12)=12.25137162929585_p
w(12)=8.902934384251247e-6_p
x(13)=14.06938396485124_p
w(13)=1.359206479402896e-6_p
x(14)=15.7075712677041_p
w(14)=2.257904367629490e-7_p
x(15)=17.00813449999087_p
w(15)=4.413555707130255e-8_p
x(16)=17.80466603822628_p
w(16)=9.198718803109185e-9_p
else if(N==17)then
x(1)=-9.379484782620796e-1_p
w(1)=1.141810876249249e-1_p
x(2)=-6.762236114405963e-1_p
w(2)=2.404723321592651e-1_p
x(3)=-2.173407055024994e-1_p
w(3)=3.059862947427532e-1_p
x(4)=4.228136146571239e-1_p
w(4)=2.873404828889921e-1_p
x(5)=1.231729465260727_p
w(5)=2.013715989652899e-1_p
x(6)=2.206230695528674_p
w(6)=1.049423940825790e-1_p
x(7)=3.347974274664703_p
w(7)=4.160587452074979e-2_p
x(8)=4.654025491773893_p
w(8)=1.306578866293815e-2_p
x(9)=6.112744491232339_p
w(9)=3.378390534518755e-3_p
x(10)=7.703656056182187_p
w(10)=7.431244412622290e-4_p
x(11)=9.396341193587595_p
w(11)=1.436535054331981e-4_p
x(12)=11.14711025169861_p
w(12)=2.538770119042264e-5_p
x(13)=12.89422533435801_p
w(13)=4.319464485927946e-6_p
x(14)=14.55309381642301_p
w(14)=7.557752611846375e-7_p
x(15)=16.01430041148603_p
w(15)=1.464929093556812e-7_p
x(16)=17.14980906758991_p
w(16)=3.310532282633833e-8_p
x(17)=17.83369783573001_p
w(17)=7.620367194192043e-9_p
else
call GD(-1)
end if
end subroutine GF_m1

! [0kT;18kT]
subroutine GF_0(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=6.905254141075479e-1_p
w(1)=5.746574345930763e-1_p
x(2)=3.592304399841270_p
w(2)=1.184897307368894e-1_p
else if(N==3)then
x(1)=4.838492419290347e-1_p
w(1)=4.632272277575239e-1_p
x(2)=2.445677951723041_p
w(2)=2.208570713576653e-1_p
x(3)=6.420632257231743_p
w(3)=9.062866214776470e-3_p
else if(N==4)then
x(1)=3.699054957581601e-1_p
w(1)=3.814549556717088e-1_p
x(2)=1.868452951874336_p
w(2)=2.768674010659611e-1_p
x(3)=4.640946675582215_p
w(3)=3.431887193863573e-2_p
x(4)=9.445238054933224_p
w(4)=5.059366536600963e-4_p
else if(N==5)then
x(1)=2.958281726128292e-1_p
w(1)=3.197015496376404e-1_p
x(2)=1.500650177128464_p
w(2)=3.014206549910982e-1_p
x(3)=3.650074766031411_p
w(3)=6.833051566880893e-2_p
x(4)=7.035616951032380_p
w(4)=3.664258370897397e-3_p
x(5)=12.29848623706514_p
w(5)=3.018666152081386e-5_p
else if(N==6)then
x(1)=2.424078539033713e-1_p
w(1)=2.707497482400024e-1_p
x(2)=1.235799866344718_p
w(2)=3.064138562410463e-1_p
x(3)=2.977907266100970_p
w(3)=1.040411606602301e-1_p
x(4)=5.599192077365467_p
w(4)=1.155143915673401e-2_p
x(5)=9.334947541420044_p
w(5)=3.879613580300765e-4_p
x(6)=14.47564418206298_p
w(6)=2.999673922729036e-6_p
else if(N==7)then
x(1)=2.020645242239394e-1_p
w(1)=2.312621395097166e-1_p
x(2)=1.034956978254077_p
w(2)=2.992585048051755e-1_p
x(3)=2.484497991007704_p
w(3)=1.360904447289867e-1_p
x(4)=4.607555482388665_p
w(4)=2.466930713504037e-2_p
x(5)=7.517925441381376_p
w(5)=1.814496357073760e-3_p
x(6)=11.31879774413579_p
w(6)=5.168765153991212e-5_p
x(7)=15.83161954480073_p
w(7)=5.851424327974235e-7_p
else if(N==8)then
x(1)=1.708990721261177e-1_p
w(1)=1.992514091290514e-1_p
x(2)=8.789083052092963e-1_p
w(2)=2.851864176734537e-1_p
x(3)=2.108046885938993_p
w(3)=1.614189636233032e-1_p
x(4)=3.878246923881104_p
w(4)=4.178606531507744e-2_p
x(5)=6.251641392504556_p
w(5)=5.180076515468610e-3_p
x(6)=9.272658893801404_p
w(6)=3.144436103709564e-4_p
x(7)=12.90216677681324_p
w(7)=9.596414988393647e-6_p
x(8)=16.60504105666311_p
w(8)=1.930482520265684e-7_p
else if(N==9)then
x(1)=1.463750278706073e-1_p
w(1)=1.731305053752991e-1_p
x(2)=7.553836039188556e-1_p
w(2)=2.677437155875699e-1_p
x(3)=1.812915285342449_p
w(3)=1.792451892268379e-1_p
x(4)=3.319987792380508_p
w(4)=6.082700348293835e-2_p
x(5)=5.311599372191225_p
w(5)=1.101751482171732e-2_p
x(6)=7.810449093187708_p
w(6)=1.115129757061187e-3_p
x(7)=10.79480117481334_p
w(7)=6.552346656355803e-5_p
x(8)=14.10141638585089_p
w(8)=2.494787116319698e-6_p
x(9)=17.05016071568006_p
w(9)=8.882486201284231e-8_p
else if(N==10)then
x(1)=1.267504245320207e-1_p
w(1)=1.516335720343486e-1_p
x(2)=6.559915746481410e-1_p
w(2)=2.491375981145992e-1_p
x(3)=1.576507116638848_p
w(3)=1.901745145338777e-1_p
x(4)=2.879935942048422_p
w(4)=7.975967990975812e-2_p
x(5)=4.585137817645493_p
w(5)=1.931342757001202e-2_p
x(6)=6.705253732558964_p
w(6)=2.844194482756769e-3_p
x(7)=9.224546585527678_p
w(7)=2.663236989612958e-4_p
x(8)=12.06581797429729_p
w(8)=1.693862596827819e-5_p
x(9)=14.98456868320925_p
w(9)=8.663020802605701e-7_p
x(10)=17.3190545873053_p
w(10)=5.005760339537861e-8_p
else if(N==11)then
x(1)=1.108098566575466e-1_p
w(1)=1.337817800169118e-1_p
x(2)=5.748635632912635e-1_p
w(2)=2.306543753347388e-1_p
x(3)=1.383818425951626_p
w(3)=1.954013202297396e-1_p
x(4)=2.525121946462916_p
w(4)=9.705448676033641e-2_p
x(5)=4.007453764701560_p
w(5)=2.958228072650413e-2_p
x(6)=5.838835508653264_p
w(6)=5.819593333555141e-3_p
x(7)=8.007447658224342_p
w(7)=7.742331564066332e-4_p
x(8)=10.46731679577362_p
w(8)=7.327492199151702e-5_p
x(9)=13.10061001090521_p
w(9)=5.411206480460510e-6_p
x(10)=15.62988730912157_p
w(10)=3.775949855991452e-7_p
x(11)=17.49065053481281_p
w(11)=3.204831548051707e-8_p
else if(N==12)then
x(1)=9.768953826875879e-2_p
w(1)=1.188252923224202e-1_p
x(2)=5.078062793800946e-1_p
w(2)=2.129944524244154e-1_p
x(3)=1.224498039814343_p
w(3)=1.962304902799476e-1_p
x(4)=2.233837486710042_p
w(4)=1.117942750453404e-1_p
x(5)=3.537988285444743_p
w(5)=4.107369761009907e-2_p
x(6)=5.141649537796148_p
w(6)=1.018634247453886e-2_p
x(7)=7.035976833740819_p
w(7)=1.785638303207883e-3_p
x(8)=9.190064934697665_p
w(8)=2.311800450175378e-4_p
x(9)=11.53548664985_p
w(9)=2.349100108982108e-5_p
x(10)=13.93113959929994_p
w(10)=2.088257233116013e-6_p
x(11)=16.10415442872349_p
w(11)=1.952415891915112e-7_p
x(12)=17.6057421799486_p
w(12)=2.232506662205830e-8_p
else if(N==13)then
x(1)=8.676346214622553e-2_p
w(1)=1.061886530743368e-1_p
x(2)=4.517608123174669e-1_p
w(2)=1.965010354127597e-1_p
x(3)=1.091167817308838_p
w(3)=1.938449556618130e-1_p
x(4)=1.991169857803668_p
w(4)=1.235920997157250e-1_p
x(5)=3.149823693515293_p
w(5)=5.298156880242989e-2_p
x(6)=4.569378680776916_p
w(6)=1.588914092971081e-2_p
x(7)=6.243198006056359_p
w(7)=3.482253343528840e-3_p
x(8)=8.149134368313726_p
w(8)=5.805687413608690e-4_p
x(9)=10.24247802799712_p
w(9)=7.707956410182505e-5_p
x(10)=12.44025571326006_p
w(10)=8.733755190747891e-6_p
x(11)=14.59402807240435_p
w(11)=9.452660093473423e-7_p
x(12)=16.45733172629747_p
w(12)=1.145707868438886e-7_p
x(13)=17.6862726523512_p
w(13)=1.649221194338904e-8_p
else if(N==14)then
x(1)=7.756950640447736e-2_p
w(1)=9.542748765699287e-2_p
x(2)=4.044537901255983e-1_p
w(2)=1.813065523304384e-1_p
x(3)=9.784244094036099e-1_p
w(3)=1.892211141044604e-1_p
x(4)=1.786517135485927_p
w(4)=1.324414922040230e-1_p
x(5)=2.824306183984577_p
w(5)=6.459140047938705e-2_p
x(6)=4.092141867547744_p
w(6)=2.270484925910128e-2_p
x(7)=5.584928239570239_p
w(7)=5.987260186455829e-3_p
x(8)=7.286229576177483_p
w(8)=1.229654366049535e-3_p
x(9)=9.164546130697797_p
w(9)=2.042477535452676e-4_p
x(10)=11.16583440706983_p
w(10)=2.881693661274177e-5_p
x(11)=13.2001165618511_p
w(11)=3.715980070775595e-6_p
x(12)=15.12346358908643_p
w(12)=4.875008466493267e-7_p
x(13)=16.72466840041428_p
w(13)=7.385726463431401e-8_p
x(14)=17.74465065856002_p
w(14)=1.271471733647249e-8_p
else if(N==15)then
x(1)=6.976075218199615e-2_p
w(1)=8.619590432769760e-2_p
x(2)=3.641675125099036e-1_p
w(2)=1.674233326272717e-1_p
x(3)=8.822210246369850e-1_p
w(3)=1.831206341808004e-1_p
x(4)=1.612125468000513_p
w(4)=1.385695885923847e-1_p
x(5)=2.548068751420705_p
w(5)=7.535528666705911e-2_p
x(6)=3.688932278325637_p
w(6)=3.030467063484278e-2_p
x(7)=5.030620876578604_p
w(7)=9.340978376723083e-3_p
x(8)=6.560670766751182_p
w(8)=2.285429864007089e-3_p
x(9)=8.255786741457150_p
w(9)=4.587416214052195e-4_p
x(10)=10.07813651741418_p
w(10)=7.844807503208305e-5_p
x(11)=11.96839637382174_p
w(11)=1.203065574501301e-5_p
x(12)=13.83585088548615_p
w(12)=1.779240483743275e-6_p
x(13)=15.5483112358062_p
w(13)=2.792472912539746e-7_p
x(14)=16.93051174011453_p
w(14)=5.109571872745538e-8_p
x(15)=17.78824221611726_p
w(15)=1.012350324389695e-8_p
else if(N==16)then
x(1)=6.307277734075892e-2_p
w(1)=7.822234467844909e-2_p
x(2)=3.295849105203381e-1_p
w(2)=1.547985814763731e-1_p
x(3)=7.994695314966543e-1_p
w(3)=1.761154166120567e-1_p
x(4)=1.462187583243587_p
w(4)=1.423217667224807e-1_p
x(5)=2.311270798574646_p
w(5)=8.490983632506453e-2_p
x(6)=3.344499166298762_p
w(6)=3.831966393143052e-2_p
x(7)=4.558375682727016_p
w(7)=1.349843519878514e-2_p
x(8)=5.943285033630625_p
w(8)=3.833878391775712e-3_p
x(9)=7.481446351586298_p
w(9)=9.046530720839376e-4_p
x(10)=9.144986723409692_p
w(10)=1.829285365124864e-4_p
x(11)=10.89222211708924_p
w(11)=3.293785656468282e-5_p
x(12)=12.66205635748556_p
w(12)=5.560538099628876e-6_p
x(13)=14.36755418920353_p
w(13)=9.424423357190731e-7_p
x(14)=15.89166438291372_p
w(14)=1.739758395214387e-7_p
x(15)=17.09165139773605_p
w(15)=3.730689167829338e-8_p
x(16)=17.82161519997439_p
w(16)=8.265222567670286e-9_p
else if(N==17)then
x(1)=5.730124901731269e-2_p
w(1)=7.129174610269511e-2_p
x(2)=2.996827052235191e-1_p
w(2)=1.433471298477648e-1_p
x(3)=7.277756040355371e-1_p
w(3)=1.686226973733887e-1_p
x(4)=1.332265549945635_p
w(4)=1.440826518268571e-1_p
x(5)=2.106503210876464_p
w(5)=9.305894032438379e-2_p
x(6)=3.047483252491519_p
w(6)=4.639395506018353e-2_p
x(7)=4.152030756913723_p
w(7)=1.834344702931333e-2_p
x(8)=5.412595333587673_p
w(8)=5.925620731572912e-3_p
x(9)=6.815311495673909_p
w(9)=1.607746344443100e-3_p
x(10)=8.338883446257169_p
w(10)=3.763215554010913e-4_p
x(11)=9.952576949253624_p
w(11)=7.833157519028838e-5_p
x(12)=11.61297242439812_p
w(12)=1.506745083652200e-5_p
x(13)=13.25996021998379_p
w(13)=2.815298039440300e-6_p
x(14)=14.81318075841664_p
w(14)=5.435864818001802e-7_p
x(15)=16.17148232630615_p
w(15)=1.159349988945846e-7_p
x(16)=17.21976245055376_p
w(16)=2.840364465525295e-8_p
x(17)=17.84771300789953_p
w(17)=6.884770599720357e-9_p
else
call GD(0)
end if
end subroutine GF_0

! [1kT;18kT]
subroutine GF_1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=1.631799300945701_p
w(1)=2.640274239168896e-1_p
x(2)=4.490159514705097_p
w(2)=4.923424837135362e-2_p
else if(N==3)then
x(1)=1.445788657538021_p
w(1)=2.167144537638940e-1_p
x(2)=3.357585329977737_p
w(2)=9.292640591846379e-2_p
x(3)=7.340274405001088_p
w(3)=3.620812605885397e-3_p
else if(N==4)then
x(1)=1.342419951231957_p
w(1)=1.809275361903577e-1_p
x(2)=2.790619110001332_p
w(2)=1.183231366315809e-1_p
x(3)=5.556591861204457_p
w(3)=1.380605962650471e-2_p
x(4)=10.34067094824073_p
w(4)=2.049398397999253e-4_p
else if(N==5)then
x(1)=1.274300628666653_p
w(1)=1.530382094283579e-1_p
x(2)=2.429421367407548_p
w(2)=1.308605349558136e-1_p
x(3)=4.557023808672736_p
w(3)=2.784287843423010e-2_p
x(4)=7.911933871175019_p
w(4)=1.506402709439314e-3_p
x(5)=13.05143074184073_p
w(5)=1.364676040227198e-5_p
else if(N==6)then
x(1)=1.224871528785583_p
w(1)=1.304690417654484e-1_p
x(2)=2.170882983341454_p
w(2)=1.349408390177269e-1_p
x(3)=3.880800201327625_p
w(3)=4.289516398224185e-2_p
x(4)=6.466207328725309_p
w(4)=4.782716398044454e-3_p
x(5)=10.11565751603482_p
w(5)=1.722733392191395e-4_p
x(6)=14.9920622014815_p
w(6)=1.637785562484014e-6_p
else if(N==7)then
x(1)=1.187550039136508_p
w(1)=1.120563077605341e-1_p
x(2)=1.976844453413449_p
w(2)=1.334879706672586e-1_p
x(3)=3.389011965560955_p
w(3)=5.667479773798091e-2_p
x(4)=5.474707872442239_p
w(4)=1.022275380408202e-2_p
x(5)=8.315411066696143_p
w(5)=7.938865599936059e-4_p
x(6)=11.97166654867235_p
w(6)=2.557681749329604e-5_p
x(7)=16.14723683874489_p
w(7)=3.789409006562978e-7_p
else if(N==8)then
x(1)=1.158736895118653_p
w(1)=9.700212152502928e-2_p
x(2)=1.827396046015235_p
w(2)=1.286896071222348e-1_p
x(3)=3.017263251313776_p
w(3)=6.787447971946976e-2_p
x(4)=4.749821105555219_p
w(4)=1.730644570650516e-2_p
x(5)=7.064199226396996_p
w(5)=2.235071837122665e-3_p
x(6)=9.981389148343165_p
w(6)=1.484778923044876e-4_p
x(7)=13.42274419747853_p
w(7)=5.328193107025014e-6_p
x(8)=16.79662798699473_p
w(8)=1.402924700372284e-7_p
else if(N==9)then
x(1)=1.136062256362402_p
w(1)=8.462611831222440e-2_p
x(2)=1.709847160341259_p
w(2)=1.220820271704897e-1_p
x(3)=2.728142403299848_p
w(3)=7.611016522063410e-2_p
x(4)=4.197696187504437_p
w(4)=2.520013697715694e-2_p
x(5)=6.137618408383363_p
w(5)=4.697559955623978e-3_p
x(6)=8.554076913820136_p
w(6)=5.103650354570214e-4_p
x(7)=11.40703119619085_p
w(7)=3.369234443294672e-5_p
x(8)=14.50492688670404_p
w(8)=1.537913388199740e-6_p
x(9)=17.17162510526142_p
w(9)=6.935883594152252e-8_p
else if(N==10)then
x(1)=1.117909313782172_p
w(1)=7.437481245278323e-2_p
x(2)=1.615701085148070_p
w(2)=1.146619543450497e-1_p
x(3)=2.498142099647696_p
w(3)=8.155259254113434e-2_p
x(4)=3.764461234535973_p
w(4)=3.310333198099102e-2_p
x(5)=5.423182223572997_p
w(5)=8.156986461911663e-3_p
x(6)=7.474482254372790_p
w(6)=1.271441371409072e-3_p
x(7)=9.891758461386983_p
w(7)=1.304504277335311e-4_p
x(8)=12.58390560221427_p
w(8)=9.479756962986660e-6_p
x(9)=15.29437068854461_p
w(9)=5.820502939527960e-7_p
x(10)=17.40032140731478_p
w(10)=4.089997374724617e-8_p
else if(N==11)then
x(1)=1.103154996094018_p
w(1)=6.581402550477025e-2_p
x(2)=1.539117188503432_p
w(2)=1.070423869219670e-1_p
x(3)=2.311785349203982_p
w(3)=8.462082584072675e-2_p
x(4)=3.416672675148146_p
w(4)=4.041594173387057e-2_p
x(5)=4.856332729574429_p
w(5)=1.240661983730355e-2_p
x(6)=6.628363573842109_p
w(6)=2.553637593326976e-3_p
x(7)=8.713127833128697_p
w(7)=3.661598362838943e-4_p
x(8)=11.05689318983297_p
w(8)=3.850343366228530e-5_p
x(9)=13.53367512909389_p
w(9)=3.273290420969299e-6_p
x(10)=15.86870317738267_p
w(10)=2.713178547230420e-7_p
x(11)=17.54778226579263_p
w(11)=2.697805622747310e-8_p
else if(N==12)then
x(1)=1.091002725260418_p
w(1)=5.860686076835753e-2_p
x(2)=1.475975932227652_p
w(2)=9.958263136927746e-2_p
x(3)=2.158477143621713_p
w(3)=8.579819325019566e-2_p
x(4)=3.132361204006445_p
w(4)=4.677162046077581e-2_p
x(5)=4.396726222304385_p
w(5)=1.714589331355318e-2_p
x(6)=5.948000434394049_p
w(6)=4.403828801218489e-3_p
x(7)=7.770975976557023_p
w(7)=8.218382586202479e-4_p
x(8)=9.829774063618549_p
w(8)=1.160758116977909e-4_p
x(9)=12.05095815886348_p
w(9)=1.321170547264609e-5_p
x(10)=14.29133359535832_p
w(10)=1.351708620621322e-6_p
x(11)=16.29041485932094_p
w(11)=1.476571397129618e-7_p
x(12)=17.64762470988852_p
w(12)=1.918331403578136e-8_p
else if(N==13)then
x(1)=1.080875677324234_p
w(1)=5.249187598200603e-2_p
x(2)=1.423302410770969_p
w(2)=9.248051789444599e-2_p
x(3)=2.030724395903472_p
w(3)=8.553927533359765e-2_p
x(4)=2.896455423876961_p
w(4)=5.200334474964365e-2_p
x(5)=4.017611544974927_p
w(5)=2.206133200960247e-2_p
x(6)=5.390077014197717_p
w(6)=6.788758498450622e-3_p
x(7)=7.001730877481850_p
w(7)=1.568041403432064e-3_p
x(8)=8.826758783931998_p
w(8)=2.814615117335267e-4_p
x(9)=10.81725811712689_p
w(9)=4.108258916131273e-5_p
x(10)=12.88810031858492_p
w(10)=5.230062408010223e-6_p
x(11)=14.89377254806522_p
w(11)=6.477888117460795e-7_p
x(12)=16.6048045926179_p
w(12)=9.008272888212524e-8_p
x(13)=17.71805852903706_p
w(13)=1.438222126308932e-8_p
else if(N==14)then
x(1)=1.072348141232626_p
w(1)=4.726523839179746e-2_p
x(2)=1.378903359563402_p
w(2)=8.583373217124816e-2_p
x(3)=1.923082762672140_p
w(3)=8.423205538083293e-2_p
x(4)=2.698255254739962_p
w(4)=5.608759994157132e-2_p
x(5)=3.700456449547364_p
w(5)=2.687928881448138e-2_p
x(6)=4.925333135411298_p
w(6)=9.612533565844307e-3_p
x(7)=6.363002965391599_p
w(7)=2.648203066626586e-3_p
x(8)=7.993991344658011_p
w(8)=5.795754998140528e-4_p
x(9)=9.784600738492289_p
w(9)=1.044092447587843e-4_p
x(10)=11.67916214801017_p
w(10)=1.626131586747827e-5_p
x(11)=13.58815840202251_p
w(11)=2.353628538941042e-6_p
x(12)=15.3739596846908_p
w(12)=3.502320378496313e-7_p
x(13)=16.84329659557773_p
w(13)=5.982400183177136e-8_p
x(14)=17.76947414799449_p
w(14)=1.121082211818428e-8_p
else if(N==15)then
x(1)=1.065100503930215_p
w(1)=4.276696934112735e-2_p
x(2)=1.341132205684400_p
w(2)=7.967931975676459e-2_p
x(3)=1.831506160579859_p
w(3)=8.218952723157050e-2_p
x(4)=2.529949419601233_p
w(4)=5.909119175377656e-2_p
x(5)=3.431980211406750_p
w(5)=3.139042789971936e-2_p
x(6)=4.533177751974020_p
w(6)=1.274303906031436e-2_p
x(7)=5.825315761157873_p
w(7)=4.071183272918153e-3_p
x(8)=7.293218953820053_p
w(8)=1.052443270638523e-3_p
x(9)=8.911918081595006_p
w(9)=2.267320055027819e-4_p
x(10)=10.64241164823855_p
w(10)=4.223711438710739e-5_p
x(11)=12.42520920500591_p
w(11)=7.158068979895318e-6_p
x(12)=14.1721080098308_p
w(12)=1.183618605802962e-6_p
x(13)=15.75899934256467_p
w(13)=2.085409372733510e-7_p
x(14)=17.02741346429562_p
w(14)=4.235098391112915e-8_p
x(15)=17.80809513360309_p
w(15)=9.002017029747472e-9_p
else if(N==16)then
x(1)=1.058889085348364_p
w(1)=3.887056124932108e-2_p
x(2)=1.308732896745746_p
w(2)=7.401865668742390e-2_p
x(3)=1.752929559187473_p
w(3)=7.965508291144012e-2_p
x(4)=2.385702038918305_p
w(4)=6.112964929839541e-2_p
x(5)=3.202403480196858_p
w(5)=3.545390972505901e-2_p
x(6)=4.198651644756144_p
w(6)=1.603712941300699e-2_p
x(7)=5.367463259222877_p
w(7)=5.812690552968847e-3_p
x(8)=6.696724185516109_p
w(8)=1.731463536837726e-3_p
x(9)=8.167239170466926_p
w(9)=4.348063810109214e-4_p
x(10)=9.750269634273453_p
w(10)=9.479273978909936e-5_p
x(11)=11.40385047798702_p
w(11)=1.863128384360128e-5_p
x(12)=13.06795981529234_p
w(12)=3.471430751772027e-6_p
x(13)=14.65955049764764_p
w(13)=6.540801265806994e-7_p
x(14)=16.07021315977372_p
w(14)=1.341135112624380e-7_p
x(15)=17.17194387513476_p
w(15)=3.148587230330757e-8_p
x(16)=17.83781308311539_p
w(16)=7.398884581292417e-9_p
else if(N==17)then
x(1)=1.053525503196699_p
w(1)=3.547519025639589e-2_p
x(2)=1.280733585166278_p
w(2)=6.883302488791976e-2_p
x(3)=1.684992604445452_p
w(3)=7.681307122631520e-2_p
x(4)=2.261066980756214_p
w(4)=6.233834477088909e-2_p
x(5)=3.004361988607530_p
w(5)=3.898999119809067e-2_p
x(6)=3.910605653884557_p
w(6)=1.935959756333588e-2_p
x(7)=4.973762128718668_p
w(7)=7.822525056128574e-3_p
x(8)=6.183969167239159_p
w(8)=2.632546596400393e-3_p
x(9)=7.526066424465087_p
w(9)=7.547312334100185e-4_p
x(10)=8.978068292543353_p
w(10)=1.888813949199800e-4_p
x(11)=10.50897970446447_p
w(11)=4.249571125049067e-5_p
x(12)=12.0758757595839_p
w(12)=8.924082658786721e-6_p
x(13)=13.62066076554571_p
w(13)=1.834853390231406e-6_p
x(14)=15.0676172001804_p
w(14)=3.912100078662971e-7_p
x(15)=16.32400472227534_p
w(15)=9.173138212563322e-8_p
x(16)=17.28716335301339_p
w(16)=2.431930208618993e-8_p
x(17)=17.86115439834383_p
w(17)=6.196446170787208e-9_p
else
call GD(1)
end if
end subroutine GF_1

! [2kT;18kT]
subroutine GF_2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=2.604113603870162_p
w(1)=1.077946595429316e-1_p
x(2)=5.443832514114974_p
w(2)=1.913333627006131e-2_p
else if(N==3)then
x(1)=2.427356483096855_p
w(1)=8.921383988549539e-2_p
x(2)=4.316376572030184_p
w(2)=3.632668343338540e-2_p
x(3)=8.299104695895910_p
w(3)=1.387472494112082e-3_p
else if(N==4)then
x(1)=2.328354407767482_p
w(1)=7.488300320837334e-2_p
x(2)=3.750605773949697_p
w(2)=4.662454541255989e-2_p
x(3)=6.504380156084124_p
w(3)=5.338812824592139e-3_p
x(4)=11.2463591830624_p
w(4)=8.163436746750763e-5_p
else if(N==5)then
x(1)=2.262448084180216_p
w(1)=6.348556659298825e-2_p
x(2)=3.388746174943561_p
w(2)=5.194668793876674e-2_p
x(3)=5.492067007072854_p
w(3)=1.088037029439375e-2_p
x(4)=8.798433031252889_p
w(4)=6.090830478800239e-4_p
x(5)=13.76917628277698_p
w(5)=6.287938964107936e-6_p
else if(N==6)then
x(1)=2.214612805170453_p
w(1)=5.418267086086134e-2_p
x(2)=3.131201666406023_p
w(2)=5.386702177040035e-2_p
x(3)=4.810292690121463_p
w(3)=1.686058844646660e-2_p
x(4)=7.346539579956907_p
w(4)=1.940266306387129e-3_p
x(5)=10.88778397260826_p
w(5)=7.652482062550079e-5_p
x(6)=15.45904975568071_p
w(6)=9.236082519485929e-7_p
else if(N==7)then
x(1)=2.178651885270821_p
w(1)=4.657729099286147e-2_p
x(2)=2.939711513034586_p
w(2)=5.352267959811573e-2_p
x(3)=4.318725467579256_p
w(3)=2.233744920689997e-2_p
x(4)=6.357621719711167_p
w(4)=4.132826994588173e-3_p
x(5)=9.113989360528700_p
w(5)=3.447042058347544e-4_p
x(6)=12.60455492144024_p
w(6)=1.279334888976117e-5_p
x(7)=16.42691309149782_p
w(7)=2.514658030006450e-7_p
else if(N==8)then
x(1)=2.150990597777672_p
w(1)=4.035116897000289e-2_p
x(2)=2.793361647497104_p
w(2)=5.179265354715322e-2_p
x(3)=3.949906968333437_p
w(3)=2.679802646948171e-2_p
x(4)=5.638530806302968_p
w(4)=6.960277556932657e-3_p
x(5)=7.882710559293288_p
w(5)=9.525804235440817e-4_p
x(6)=10.68216970400174_p
w(6)=7.018302066968495e-5_p
x(7)=13.91953280542578_p
w(7)=3.002425106948460e-6_p
x(8)=16.96668054189169_p
w(8)=1.034001016681875e-7_p
else if(N==9)then
x(1)=2.129279086817563_p
w(1)=3.522609056924456e-2_p
x(2)=2.678927305277747_p
w(2)=4.929586821727444e-2_p
x(3)=3.664816742627220_p
w(3)=3.009878089876659e-2_p
x(4)=5.093165372467124_p
w(4)=1.008503037710794e-2_p
x(5)=6.972499838326996_p
w(5)=1.971220150406463e-3_p
x(6)=9.296047928680391_p
w(6)=2.325544462090853e-4_p
x(7)=12.00583811747599_p
w(7)=1.743503875924493e-5_p
x(8)=14.88620183851894_p
w(8)=9.615721165286058e-7_p
x(9)=17.2804918006998_p
w(9)=5.454310801922805e-8_p
else if(N==10)then
x(1)=2.111931240368205_p
w(1)=3.097588009641697e-2_p
x(2)=2.587698934761566_p
w(2)=4.643622166074581e-2_p
x(3)=3.439200625208412_p
w(3)=3.230900336534844e-2_p
x(4)=4.666829406748993_p
w(4)=1.319457877989625e-2_p
x(5)=6.271993653377311_p
w(5)=3.378782993371695e-3_p
x(6)=8.245924563315755_p
w(6)=5.637952243595888e-4_p
x(7)=10.55199010841682_p
w(7)=6.395272451969050e-5_p
x(8)=13.08635523950292_p
w(8)=5.351898551387560e-6_p
x(9)=15.58574695906831_p
w(9)=3.955554433969710e-7_p
x(10)=17.47397360910641_p
w(10)=3.351433963955868e-8_p
else if(N==11)then
x(1)=2.097853083025689_p
w(1)=2.742293460293173e-2_p
x(2)=2.513763495882142_p
w(2)=4.346487767265316e-2_p
x(3)=3.257216680231126_p
w(3)=3.359123615764235e-2_p
x(4)=4.325744488759134_p
w(4)=1.606132060049769e-2_p
x(5)=5.717247834532200_p
w(5)=5.084183016523652e-3_p
x(6)=7.422728489316018_p
w(6)=1.108246504539480e-3_p
x(7)=9.416077467618894_p
w(7)=1.726650443966000e-4_p
x(8)=11.63629698129671_p
w(8)=2.031494802666282e-5_p
x(9)=13.95119218759788_p
w(9)=1.997973851264343e-6_p
x(10)=16.09310475559373_p
w(10)=1.965722898896701e-7_p
x(11)=17.60009343780473_p
w(11)=2.271964039732403e-8_p
else if(N==12)then
x(1)=2.086272296401991_p
w(1)=2.442916063515941e-2_p
x(2)=2.452989755972371_p
w(2)=4.053153623368449e-2_p
x(3)=3.108089036808254_p
w(3)=3.413140045633953e-2_p
x(4)=4.047794300881300_p
w(4)=1.855017211219535e-2_p
x(5)=5.268307524589593_p
w(5)=6.964926713726852e-3_p
x(6)=6.761069326073287_p
w(6)=1.877926278643127e-3_p
x(7)=8.506229472883337_p
w(7)=3.760769780529327e-4_p
x(8)=10.46335756576633_p
w(8)=5.831290111404642e-5_p
x(9)=12.554804595995_p
w(9)=7.472689468061456e-6_p
x(10)=14.63733525849905_p
w(10)=8.820614475972108e-7_p
x(11)=16.46565199140609_p
w(11)=1.122868938627173e-7_p
x(12)=17.68631396622632_p
w(12)=1.646626760627328e-8_p
else if(N==13)then
x(1)=2.076631551570986_p
w(1)=2.188716863241212e-2_p
x(2)=2.402417232810560_p
w(2)=3.772078719406714e-2_p
x(3)=2.984240466945907_p
w(3)=3.410406967660051e-2_p
x(4)=3.817844682838963_p
w(4)=2.060206265501906e-2_p
x(5)=4.898689561057011_p
w(5)=8.898626438531582e-3_p
x(6)=6.218878854186382_p
w(6)=2.853121136434037e-3_p
x(7)=7.762719004026240_p
w(7)=7.003711571757276e-4_p
x(8)=9.501276357358185_p
w(8)=1.361522075608109e-4_p
x(9)=11.38383854359722_p
w(9)=2.195516705138537e-5_p
x(10)=13.32410330851912_p
w(10)=3.151070464755922e-6_p
x(11)=15.18117305991179_p
w(11)=4.468964309350992e-7_p
x(12)=16.7438798608489_p
w(12)=7.106390071116955e-8_p
x(13)=17.74764201020689_p
w(13)=1.251734410777543e-8_p
else if(N==14)then
x(1)=2.068520640395733_p
w(1)=1.971307424439760e-2_p
x(2)=2.359877237500965_p
w(2)=3.507639474467024e-2_p
x(3)=2.880195219854255_p
w(3)=3.365852065411434e-2_p
x(4)=3.625175236768797_p
w(4)=2.221123551679484e-2_p
x(5)=4.590056025733818_p
w(5)=1.078181428867882e-2_p
x(6)=5.767649451569490_p
w(6)=3.991232594909428e-3_p
x(7)=7.145212799318333_p
w(7)=1.159352751798115e-3_p
x(8)=8.700954154214916_p
w(8)=2.719663671893490e-4_p
x(9)=10.39923566356855_p
w(9)=5.338269047231869e-5_p
x(10)=12.18325642321478_p
w(10)=9.211266775061796e-6_p
x(11)=13.9649046850034_p
w(11)=1.499388626603004e-6_p
x(12)=15.61400128949883_p
w(12)=2.529082403853859e-7_p
x(13)=16.95549019622284_p
w(13)=4.853695349981620e-8_p
x(14)=17.79272485968696_p
w(14)=9.859372277065331e-9_p
else if(N==15)then
x(1)=2.061632267602607_p
w(1)=1.784093128219105e-2_p
x(2)=2.323750410842847_p
w(2)=3.261704667860239e-2_p
x(3)=2.791904605255955_p
w(3)=3.291570116413171e-2_p
x(4)=3.461977379278320_p
w(4)=2.340480371254347e-2_p
x(5)=4.329272116225605_p
w(5)=1.253749913805384e-2_p
x(6)=5.387283489372445_p
w(6)=5.237979836722725e-3_p
x(7)=6.625455670825572_p
w(7)=1.752537492304267e-3_p
x(8)=8.026776692796650_p
w(8)=4.815975020231361e-4_p
x(9)=9.564864990620006_p
w(9)=1.118514938687799e-4_p
x(10)=11.1998166581159_p
w(10)=2.277969439642552e-5_p
x(11)=12.87250673988489_p
w(11)=4.277011953782451e-6_p
x(12)=14.49801307825588_p
w(12)=7.913945095041355e-7_p
x(13)=15.96095072748559_p
w(13)=1.563139301864832e-7_p
x(14)=17.11933311426506_p
w(14)=3.511672660987132e-8_p
x(15)=17.82679095392842_p
w(15)=7.981034987557286e-9_p
else if(N==16)then
x(1)=2.055732572990875_p
w(1)=1.621851531787847e-2_p
x(2)=2.292807101500543_p
w(2)=3.034639757964464e-2_p
x(3)=2.716316259368069_p
w(3)=3.197025438305134e-2_p
x(4)=3.322430784727708_p
w(4)=2.422727188986486e-2_p
x(5)=4.106671263360841_p
w(5)=1.411530988249333e-2_p
x(6)=5.063164833131610_p
w(6)=6.537157336872803e-3_p
x(7)=6.183026488066734_p
w(7)=2.466720496355382e-3_p
x(8)=7.452619564539047_p
w(8)=7.756937152659706e-4_p
x(9)=8.851658315070120_p
w(9)=2.082258063572364e-4_p
x(10)=10.35070929892912_p
w(10)=4.911456725661655e-5_p
x(11)=11.90783141272295_p
w(11)=1.056592653146990e-5_p
x(12)=13.46456381592867_p
w(12)=2.176256599821567e-6_p
x(13)=14.94229093534028_p
w(13)=4.558565460394211e-7_p
x(14)=16.24149868907176_p
w(14)=1.036375577666354e-7_p
x(15)=17.24833119591351_p
w(15)=2.655875875336626e-8_p
x(16)=17.85313769857762_p
w(16)=6.601958374105356e-9_p
else if(N==17)then
x(1)=2.050641044574827_p
w(1)=1.480415183415972e-2_p
x(2)=2.266099596869428_p
w(2)=2.825940070041054e-2_p
x(3)=2.651090002901032_p
w(3)=3.089443478146436e-2_p
x(4)=3.202111924516505_p
w(4)=2.473001693023429e-2_p
x(5)=3.914978719051288_p
w(5)=1.548778785619318e-2_p
x(6)=4.784393203059715_p
w(6)=7.837421381784011e-3_p
x(7)=5.802777459667519_p
w(7)=3.279505940673759e-3_p
x(8)=6.958973988263029_p
w(8)=1.158206600224522e-3_p
x(9)=8.236932004679511_p
w(9)=3.524709288533583e-4_p
x(10)=9.614122428335190_p
w(10)=9.463821645844244e-5_p
x(11)=11.05947013974911_p
w(11)=2.307757071219525e-5_p
x(12)=12.53085072760189_p
w(12)=5.301151413066804e-6_p
x(13)=13.97257543304169_p
w(13)=1.200413083631369e-6_p
x(14)=15.31390064635692_p
w(14)=2.824712697364627e-7_p
x(15)=16.47049021313049_p
w(15)=7.268173636759644e-8_p
x(16)=17.35146399112994_p
w(16)=2.079641855449351e-8_p
x(17)=17.87392210274374_p
w(17)=5.557903118502756e-9_p
else
call GD(2)
end if
end subroutine GF_2

! [3kT;18kT]
subroutine GF_3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=3.592663792871365_p
w(1)=4.138964493036260e-2_p
x(2)=6.424755424111575_p
w(2)=7.197691413399826e-3_p
else if(N==3)then
x(1)=3.419333110154976_p
w(1)=3.435451326403214e-2_p
x(2)=5.297313262706935_p
w(2)=1.371034798137655e-2_p
x(3)=9.273078890585678_p
w(3)=5.224750983537408e-4_p
else if(N==4)then
x(1)=3.321330503178616_p
w(1)=2.884314741927183e-2_p
x(2)=4.727410369642006_p
w(2)=1.767640520163631e-2_p
x(3)=7.461099984131787_p
w(3)=2.034976602485836e-3_p
x(4)=12.133805403723_p
w(4)=3.280712036844617e-5_p
else if(N==5)then
x(1)=3.255632753988060_p
w(1)=2.440319061537209e-2_p
x(2)=4.361395622810672_p
w(2)=1.974960795427620e-2_p
x(3)=6.434517565722876_p
w(3)=4.184431391991433e-3_p
x(4)=9.674593926934799_p
w(4)=2.470922868825382e-4_p
x(5)=14.42904133682061_p
w(5)=3.014095240174475e-6_p
else if(N==6)then
x(1)=3.208145683927569_p
w(1)=2.077771179303547e-2_p
x(2)=4.102683805346969_p
w(2)=2.049240322014624e-2_p
x(3)=5.747844717242435_p
w(3)=6.496854304943874e-3_p
x(4)=8.222868276845380_p
w(4)=7.852759246091971e-4_p
x(5)=11.63486807723352_p
w(5)=3.454843528004115e-5_p
x(6)=15.86940885932073_p
w(6)=5.426657476073881e-7_p
else if(N==7)then
x(1)=3.172684031725171_p
w(1)=1.782438624745806e-2_p
x(2)=3.912016796814373_p
w(2)=2.035253022200737e-2_p
x(3)=5.256884232198367_p
w(3)=8.593314880339044e-3_p
x(4)=7.240401227821403_p
w(4)=1.659716282236678e-3_p
x(5)=9.899227903129692_p
w(5)=1.506726702753974e-4_p
x(6)=13.2056122817964_p
w(6)=6.544538327948283e-6_p
x(7)=16.66989866947278_p
w(7)=1.715031179327379e-7_p
else if(N==8)then
x(1)=3.145551057023120_p
w(1)=1.541435993416712e-2_p
x(2)=3.767308587359972_p
w(2)=1.967886660980235e-2_p
x(3)=4.890932287241863_p
w(3)=1.028145517453466e-2_p
x(4)=6.529440753627764_p
w(4)=2.770706126670135e-3_p
x(5)=8.693833049944695_p
w(5)=4.065479754545332e-4_p
x(6)=11.36336440327285_p
w(6)=3.359249281248458e-5_p
x(7)=14.38496753166993_p
w(7)=1.730627969479955e-6_p
x(8)=17.11543873744398_p
w(8)=7.740235166690157e-8_p
else if(N==9)then
x(1)=3.124341718541153_p
w(1)=1.343568924297068e-2_p
x(2)=3.654772052590905_p
w(2)=1.871343857150087e-2_p
x(3)=4.609533286836881_p
w(3)=1.151521388999427e-2_p
x(4)=5.992299338433113_p
w(4)=3.981206186437828e-3_p
x(5)=7.803620578589098_p
w(5)=8.252931729768433e-4_p
x(6)=10.02524577655117_p
w(6)=1.066782545314902e-4_p
x(7)=12.58231496144675_p
w(7)=9.160901379814254e-6_p
x(8)=15.24074279240838_p
w(8)=6.128817472142862e-7_p
x(9)=17.37690187750919_p
w(9)=4.324222342181970e-8_p
else if(N==10)then
x(1)=3.107451852140450_p
w(1)=1.179843388963341e-2_p
x(2)=3.565452268663832_p
w(2)=1.761235182200590e-2_p
x(3)=4.387812415716277_p
w(3)=1.232854880193263e-2_p
x(4)=5.573771321785455_p
w(4)=5.170038506012406e-3_p
x(5)=7.119481917118105_p
w(5)=1.392231372936005e-3_p
x(6)=9.008922798062756_p
w(6)=2.506987876606083e-4_p
x(7)=11.19616850158036_p
w(7)=3.166442821727138e-5_p
x(8)=13.56662994782152_p
w(8)=3.068375427576223e-6_p
x(9)=15.85601788172658_p
w(9)=2.727938094858369e-7_p
x(10)=17.5400141750094_p
w(10)=2.756612713718613e-8_p
else if(N==11)then
x(1)=3.093783892585057_p
w(1)=1.043244497596968e-2_p
x(2)=3.493329493984006_p
w(2)=1.647175955987979e-2_p
x(3)=4.209643215558003_p
w(3)=1.278844225750877e-2_p
x(4)=5.239916100667253_p
w(4)=6.252656490694281e-3_p
x(5)=6.578557200547713_p
w(5)=2.066989818668706e-3_p
x(6)=8.211640791536698_p
w(6)=4.808877813792215e-4_p
x(7)=10.10733954118189_p
w(7)=8.191520169234177e-5_p
x(8)=12.19828900584439_p
w(8)=1.084052679830360e-5_p
x(9)=14.34846154971434_p
w(9)=1.236652828045883e-6_p
x(10)=16.30140790427793_p
w(10)=1.439225211759883e-7_p
x(11)=17.64751920680671_p
w(11)=1.915582211469823e-8_p
else if(N==12)then
x(1)=3.082567576533938_p
w(1)=9.283427744027514e-3_p
x(2)=3.434229969120954_p
w(2)=1.534844712676057e-2_p
x(3)=4.064119768013894_p
w(3)=1.296851195695843e-2_p
x(4)=4.968582859896997_p
w(4)=7.181582507836609e-3_p
x(5)=6.141515153223141_p
w(5)=2.799504185101037e-3_p
x(6)=7.570865381363014_p
w(6)=7.987407743542783e-4_p
x(7)=9.232959916994332_p
w(7)=1.726358067616197e-4_p
x(8)=11.08336495805603_p
w(8)=2.952861266835116e-5_p
x(9)=13.04134365299736_p
w(9)=4.275117056762482e-6_p
x(10)=14.96576420461025_p
w(10)=5.823850654903589e-7_p
x(11)=16.62872833130374_p
w(11)=8.599926723232431e-8_p
x(12)=17.72172229476744_p
w(12)=1.412790453658397e-8_p
else if(N==13)then
x(1)=3.073249710088834_p
w(1)=8.309311167220737e-3_p
x(2)=3.385181536354450_p
w(2)=1.427416535028400e-2_p
x(3)=3.943611568892121_p
w(3)=1.293645445064186e-2_p
x(4)=4.744654702366276_p
w(4)=7.938418212717981e-3_p
x(5)=5.782275886745278_p
w(5)=3.542155340885945e-3_p
x(6)=7.046049250988903_p
w(6)=1.193409734861659e-3_p
x(7)=8.517565285974657_p
w(7)=3.130797619063162e-4_p
x(8)=10.16521565835352_p
w(8)=6.620839579143855e-5_p
x(9)=11.93608488945076_p
w(9)=1.183678175008983e-5_p
x(10)=13.7438364572095_p
w(10)=1.918743084341808e-6_p
x(11)=15.45376022398227_p
w(11)=3.112115619610749e-7_p
x(12)=16.87373678924533_p
w(12)=5.631474377532690e-8_p
x(13)=17.77493368603592_p
w(13)=1.087831233099355e-8_p
else if(N==14)then
x(1)=3.065424759203270_p
w(1)=7.477331980064523e-3_p
x(2)=3.344018584388083_p
w(2)=1.326509029164449e-2_p
x(3)=3.842628978319693_p
w(3)=1.274936277150119e-2_p
x(4)=4.557449694428161_p
w(4)=8.524363321827655e-3_p
x(5)=5.482783404058044_p
w(5)=4.256310353171369e-3_p
x(6)=6.609593364409911_p
w(6)=1.645963292614594e-3_p
x(7)=7.923125232177011_p
w(7)=5.069715255157536e-4_p
x(8)=9.399700346193782_p
w(8)=1.280115661826814e-4_p
x(9)=11.00212164523893_p
w(9)=2.747097004971805e-5_p
x(10)=12.67310030821157_p
w(10)=5.264032126051607e-6_p
x(11)=14.32690017388996_p
w(11)=9.641567429420133e-7_p
x(12)=15.84174203820989_p
w(12)=1.839487374530844e-7_p
x(13)=17.06062603492606_p
w(13)=3.948139725588710e-8_p
x(14)=17.8143200584229_p
w(14)=8.652186752951195e-9_p
else if(N==15)then
x(1)=3.058789974079603_p
w(1)=6.761800581778486e-3_p
x(2)=3.309131502116480_p
w(2)=1.232790193510624e-2_p
x(3)=3.757129537756198_p
w(3)=1.245302674151037e-2_p
x(4)=4.399205361463917_p
w(4)=8.952187460883382e-3_p
x(5)=5.230110757565916_p
w(5)=4.914410738812839e-3_p
x(6)=6.241990022503309_p
w(6)=2.134061102811114e-3_p
x(7)=7.422757160068722_p
w(7)=7.522364366164034e-4_p
x(8)=8.754006622123120_p
w(8)=2.206479217450358e-4_p
x(9)=10.20823058190515_p
w(9)=5.542704226900237e-5_p
x(10)=11.74501369141123_p
w(10)=1.237209247479057e-5_p
x(11)=13.30619543623267_p
w(11)=2.576953978549123e-6_p
x(12)=14.81084972137251_p
w(12)=5.333375342036180e-7_p
x(13)=16.15274931950545_p
w(13)=1.177895608974790e-7_p
x(14)=17.20577992698412_p
w(14)=2.915138585293586e-8_p
x(15)=17.84425624932472_p
w(15)=7.057295263397076e-9_p
else if(N==16)then
x(1)=3.053115643241681_p
w(1)=6.142419652512290e-3_p
x(2)=3.279302944525916_p
w(2)=1.146363142153254e-2_p
x(3)=3.684076929035027_p
w(3)=1.208299119051153e-2_p
x(4)=4.264148783709951_p
w(4)=9.240402673753097e-3_p
x(5)=5.014750589870800_p
w(5)=5.499376920276138e-3_p
x(6)=5.929030411051123_p
w(6)=2.635679775991022e-3_p
x(7)=6.996921749830199_p
w(7)=1.042038143579812e-3_p
x(8)=8.203720406767196_p
w(8)=3.473791353881099e-4_p
x(9)=9.528302658417353_p
w(9)=9.999704437099837e-5_p
x(10)=10.94079948570179_p
w(10)=2.558310622055060e-5_p
x(11)=12.39967462505113_p
w(11)=6.034239898318656e-6_p
x(12)=13.84852245882218_p
w(12)=1.374618023346833e-6_p
x(13)=15.21361566821458_p
w(13)=3.197594771633217e-7_p
x(14)=16.40440834171818_p
w(14)=8.038486003305863e-8_p
x(15)=17.32041673494018_p
w(15)=2.240390850993262e-8_p
x(16)=17.8675250859449_p
w(16)=5.873458966517170e-9_p
else if(N==17)then
x(1)=3.048224924209860_p
w(1)=5.603025427310020e-3_p
x(2)=3.253597987492167_p
w(2)=1.067007073337435e-2_p
x(3)=3.621151225190885_p
w(3)=1.166621155728288e-2_p
x(4)=4.147902115163273_p
w(4)=9.409441973109202e-3_p
x(5)=4.829553666340396_p
w(5)=6.002772627779913e-3_p
x(6)=5.660108805626585_p
w(6)=3.131483888417312e-3_p
x(7)=6.631071577423967_p
w(7)=1.366419985687826e-3_p
x(8)=7.730444610810093_p
w(8)=5.086346228995416e-4_p
x(9)=8.941533702343129_p
w(9)=1.648269315846804e-4_p
x(10)=10.24145860435412_p
w(10)=4.759877551216443e-5_p
x(11)=11.59931637083685_p
w(11)=1.260366538951843e-5_p
x(12)=12.9741208333155_p
w(12)=3.170173655910618e-6_p
x(13)=14.31295617327367_p
w(13)=7.905179746140824e-7_p
x(14)=15.5502911208722_p
w(14)=2.049974848037218e-7_p
x(15)=16.61004566758173_p
w(15)=5.772679651105385e-8_p
x(16)=17.41233773208583_p
w(16)=1.777027656961912e-8_p
x(17)=17.8859608324214_p
w(17)=4.969226610021526e-9_p
else
call GD(3)
end if
end subroutine GF_3

! [4kT;18kT]
subroutine GF_4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=4.588148876102814_p
w(1)=1.547808317566689e-2_p
x(2)=7.416686302301951_p
w(2)=2.671829512163221e-3_p
else if(N==3)then
x(1)=4.415567743641724_p
w(1)=1.284987810878976e-2_p
x(2)=6.285772801986455_p
w(2)=5.103695352834961e-3_p
x(3)=10.24601443692103_p
w(3)=1.963392262053919e-4_p
else if(N==4)then
x(1)=4.316911772398061_p
w(1)=1.075929075791132e-2_p
x(2)=5.708370618729869_p
w(2)=6.601091925544368e-3_p
x(3)=8.412061323165103_p
w(3)=7.759796551312953e-4_p
x(4)=12.9808235320394_p
w(4)=1.355034924312739e-5_p
else if(N==5)then
x(1)=4.250566487181799_p
w(1)=9.062909252755607e-3_p
x(2)=5.336970523319472_p
w(2)=7.377401243998880e-3_p
x(3)=7.372248349794928_p
w(3)=1.606292832929639e-3_p
x(4)=10.52746689564777_p
w(4)=1.017899488636944e-4_p
x(5)=15.01895769265696_p
w(5)=1.519409282291055e-6_p
else if(N==6)then
x(1)=4.202960470618922_p
w(1)=7.684174708620184e-3_p
x(2)=5.076717819627309_p
w(2)=7.638567194541405e-3_p
x(3)=6.682841548331828_p
w(3)=2.490522766118603e-3_p
x(4)=9.084893037708611_p
w(4)=3.203191796870322e-4_p
x(5)=12.34714107976509_p
w(5)=1.599615967180271e-5_p
x(6)=16.22339201017036_p
w(6)=3.326791910846157e-7_p
else if(N==7)then
x(1)=4.167687412353975_p
w(1)=6.568307726378799e-3_p
x(2)=4.886570410283064_p
w(2)=7.563547416209127e-3_p
x(3)=6.193944335421603_p
w(3)=3.279012017366856e-3_p
x(4)=8.113855530546255_p
w(4)=6.686420350094815e-4_p
x(5)=10.66259397634706_p
w(5)=6.683931699162814e-5_p
x(6)=13.76869921302357_p
w(6)=3.444085826864822e-6_p
x(7)=16.87878486757093_p
w(7)=1.200900473553811e-7_p
else if(N==8)then
x(1)=4.140862823968388_p
w(1)=5.662672038704924e-3_p
x(2)=4.743212091458683_p
w(2)=7.290035891736788e-3_p
x(3)=5.831747198968665_p
w(3)=3.901919904248005e-3_p
x(4)=7.414080014817305_p
w(4)=1.102751006517540e-3_p
x(5)=9.489808369861958_p
w(5)=1.750688750966844e-4_p
x(6)=12.01839849935753_p
w(6)=1.638251834046360e-5_p
x(7)=14.81595221636938_p
w(7)=1.023658168999875e-6_p
x(8)=17.24469049352806_p
w(8)=5.879501670632437e-8_p
else if(N==9)then
x(1)=4.119996444161696_p
w(1)=4.922536137112266e-3_p
x(2)=4.632310512306463_p
w(2)=6.911317029294645e-3_p
x(3)=5.554578558278034_p
w(3)=4.346762983277053e-3_p
x(4)=6.887199657551690_p
w(4)=1.567099471401132e-3_p
x(5)=8.623762383549208_p
w(5)=3.472923042855851e-4_p
x(6)=10.7353141096597_p
w(6)=4.956241481771780e-5_p
x(7)=13.13180929831819_p
w(7)=4.908993808028900e-6_p
x(8)=15.56726996652177_p
w(8)=3.988094204493169e-7_p
x(9)=17.46183405547535_p
w(9)=3.454441323503942e-8_p
else if(N==10)then
x(1)=4.103446876745258_p
w(1)=4.312530784401653e-3_p
x(2)=4.544670186702631_p
w(2)=6.486346731580887e-3_p
x(3)=5.337071569199293_p
w(3)=4.630614777518798e-3_p
x(4)=6.477897313152848_p
w(4)=2.015117052268076e-3_p
x(5)=7.958832892582032_p
w(5)=5.749466800604248e-4_p
x(6)=9.757405096683492_p
w(6)=1.124428342429984e-4_p
x(7)=11.81929174521281_p
w(7)=1.590827860194216e-5_p
x(8)=14.02164895838187_p
w(8)=1.791759271816480e-6_p
x(9)=16.10474130773615_p
w(9)=1.910372378461863e-7_p
x(10)=17.59895615753231_p
w(10)=2.275264566881343e-8_p
else if(N==11)then
x(1)=4.090100400438912_p
w(1)=3.805352525283490e-3_p
x(2)=4.474163313766775_p
w(2)=6.050721466275622e-3_p
x(3)=5.162893997602152_p
w(3)=4.781664693718245e-3_p
x(4)=6.152278330547861_p
w(4)=2.416034891720077e-3_p
x(5)=7.433774958366613_p
w(5)=8.402434331121497e-4_p
x(6)=8.989286014866119_p
w(6)=2.098413027199935e-4_p
x(7)=10.78190049565637_p
w(7)=3.928266001354901e-5_p
x(8)=12.73907529587416_p
w(8)=5.871393409402410e-6_p
x(9)=14.72351444831371_p
w(9)=7.776413234020731e-7_p
x(10)=16.49348764942391_p
w(10)=1.065132217231366e-7_p
x(11)=17.69032926645528_p
w(11)=1.616703245771740e-8_p
else if(N==12)then
x(1)=4.079180479824787_p
w(1)=3.380032748770636e-3_p
x(2)=4.416570243976130_p
w(2)=5.624994349791119e-3_p
x(3)=5.021060556410416_p
w(3)=4.829360725035581e-3_p
x(4)=5.888282609822929_p
w(4)=2.753909683239208e-3_p
x(5)=7.010152543637726_p
w(5)=1.122831768693941e-3_p
x(6)=8.371794796705897_p
w(6)=3.408361113252101e-4_p
x(7)=9.946243342787813_p
w(7)=7.987002594505292e-5_p
x(8)=11.68574200432827_p
w(8)=1.512902859111895e-5_p
x(9)=13.50776845073299_p
w(9)=2.480269400779839e-6_p
x(10)=15.27536657845969_p
w(10)=3.895215248329040e-7_p
x(11)=16.77961514349043_p
w(11)=6.634086274430506e-8_p
x(12)=17.7539927549788_p
w(12)=1.211464988795426e-8_p
else if(N==13)then
x(1)=4.070132423248034_p
w(1)=3.020427468535675e-3_p
x(2)=4.368903291341582_p
w(2)=5.220318151587978e-3_p
x(3)=4.903920625702059_p
w(3)=4.800008561873316e-3_p
x(4)=5.670892529049694_p
w(4)=3.023836860091401e-3_p
x(5)=6.662445983809295_p
w(5)=1.404368223126667e-3_p
x(6)=7.866185987447544_p
w(6)=4.998265517682796e-4_p
x(7)=9.261461740220543_p
w(7)=1.407236868530804e-4_p
x(8)=10.8144515954715_p
w(8)=3.248999068725925e-5_p
x(9)=12.47077430344406_p
w(9)=6.456978739764400e-6_p
x(10)=14.14524522910562_p
w(10)=1.183021040391010e-6_p
x(11)=15.71071589636003_p
w(11)=2.189262930292354e-7_p
x(12)=16.99436329562099_p
w(12)=4.482844561636566e-8_p
x(13)=17.80000937356893_p
w(13)=9.438787654514759e-9_p
else if(N==14)then
x(1)=4.062551476634469_p
w(1)=2.714032886590631e-3_p
x(2)=4.328996197558791_p
w(2)=4.842097074319940e-3_p
x(3)=4.805992462584871_p
w(3)=4.715334497695347e-3_p
x(4)=5.489521075137757_p
w(4)=3.227990223006690e-3_p
x(5)=6.372980383427449_p
w(5)=1.670678723494386e-3_p
x(6)=7.445935442409300_p
w(6)=6.785043552126607e-4_p
x(7)=8.692049668497688_p
w(7)=2.224871184663278e-4_p
x(8)=10.08611562556137_p
w(8)=6.067172010378238e-5_p
x(9)=11.58984022086881_p
w(9)=1.427298577770184e-5_p
x(10)=13.14615844520049_p
w(10)=3.041880750789921e-6_p
x(11)=14.67263732387687_p
w(11)=6.266317814520377e-7_p
x(12)=16.05662418817215_p
w(12)=1.348188286937805e-7_p
x(13)=17.15868547146751_p
w(13)=3.219640769481313e-8_p
x(14)=17.83429898007472_p
w(14)=7.575394015543028e-9_p
else if(N==15)then
x(1)=4.056136688275046_p
w(1)=2.451091221564249e-3_p
x(2)=4.295245751095894_p
w(2)=4.492294233233652e-3_p
x(3)=4.723254144187825_p
w(3)=4.592470504661833e-3_p
x(4)=5.336491896286120_p
w(4)=3.372472487475468e-3_p
x(5)=6.129103676233568_p
w(5)=1.912195151357787e-3_p
x(6)=7.092230819152298_p
w(6)=8.677584736019135e-4_p
x(7)=8.212641250690377_p
w(7)=3.235096726059500e-4_p
x(8)=9.470840068341500_p
w(8)=1.016079526727791e-4_p
x(9)=10.83851514830998_p
w(9)=2.767850956143392e-5_p
x(10)=12.27519297799995_p
w(10)=6.783793489773272e-6_p
x(11)=13.72428730241346_p
w(11)=1.568372866707298e-6_p
x(12)=15.10949759719625_p
w(12)=3.626123817718914e-7_p
x(13)=16.33399408362404_p
w(13)=8.925466929681515e-8_p
x(14)=17.28672525262281_p
w(14)=2.422457698971223e-8_p
x(15)=17.86050993945484_p
w(15)=6.223110507286806e-9_p
else if(N==16)then
x(1)=4.050660520966650_p
w(1)=2.223924973465523e-3_p
x(2)=4.266444014662255_p
w(2)=4.170869729419699e-3_p
x(3)=4.652694755172526_p
w(3)=4.444519604451980e-3_p
x(4)=5.206108331881693_p
w(4)=3.465135138379389e-3_p
x(5)=5.921515292270639_p
w(5)=2.123450957866314e-3_p
x(6)=6.791341390695852_p
w(6)=1.059058005771388e-3_p
x(7)=7.804675537329885_p
w(7)=4.404241820776780e-4_p
x(8)=8.946017381858605_p
w(8)=1.561189125158155e-4_p
x(9)=10.19365124511048_p
w(9)=4.831272663201760e-5_p
x(10)=11.51757979349567_p
w(10)=1.343244092140372e-5_p
x(11)=12.8770806864442_p
w(11)=3.477447820703861e-6_p
x(12)=14.2182722348323_p
w(12)=8.759823516836322e-7_p
x(13)=15.47267571401176_p
w(13)=2.258899844753309e-7_p
x(14)=16.55863801015554_p
w(14)=6.258951421475393e-8_p
x(15)=17.38816412623298_p
w(15)=1.889769039377644e-8_p
x(16)=17.88098272826729_p
w(16)=5.208967433242041e-9_p
else if(N==17)then
x(1)=4.045948358872924_p
w(1)=2.026442777641529e-3_p
x(2)=4.241666396166009_p
w(2)=3.876667927326619e-3_p
x(3)=4.592020700083257_p
w(3)=4.281282384285268e-3_p
x(4)=5.094059241244950_p
w(4)=3.514211666060060e-3_p
x(5)=5.743226472530748_p
w(5)=2.302208071421552e-3_p
x(6)=6.533005813109564_p
w(6)=1.245241158662604e-3_p
x(7)=7.454272353529102_p
w(7)=5.688790060053359e-4_p
x(8)=8.494435422930364_p
w(8)=2.238604058518750e-4_p
x(9)=9.636360790402806_p
w(9)=7.743346648096940e-5_p
x(10)=10.85703924138802_p
w(10)=2.409688555326208e-5_p
x(11)=12.1260237016896_p
w(11)=6.937661304630496e-6_p
x(12)=13.40380516549449_p
w(12)=1.911586919791489e-6_p
x(13)=14.64056361537138_p
w(13)=5.245332283424038e-7_p
x(14)=15.7761303449836_p
w(14)=1.495972451064982e-7_p
x(15)=16.74242952169521_p
w(15)=4.596145293862354e-8_p
x(16)=17.46974368286945_p
w(16)=1.517057577424217e-8_p
x(17)=17.89727160990862_p
w(17)=4.427814454610630e-9_p
else
call GD(4)
end if
end subroutine GF_4

! [5kT;18kT]
subroutine GF_5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=5.586237309441668_p
w(1)=5.728122286085833e-3_p
x(2)=8.412015012600781_p
w(2)=9.872109730526067e-4_p
else if(N==3)then
x(1)=5.413032186839287_p
w(1)=4.748671890137079e-3_p
x(2)=7.274257429877785_p
w(2)=1.892302795255274e-3_p
x(3)=11.20613881500719_p
w(3)=7.435857374608636e-5_p
else if(N==4)then
x(1)=5.312878377727259_p
w(1)=3.957431731974652e-3_p
x(2)=6.687104057172123_p
w(2)=2.453692226684009e-3_p
x(3)=9.348404727819085_p
w(3)=2.983831735207728e-4_p
x(4)=13.77047904564789_p
w(4)=5.826126959006491e-6_p
else if(N==5)then
x(1)=5.245619151937140_p
w(1)=3.314146424699692e-3_p
x(2)=6.310438009725775_p
w(2)=2.737977917740304e-3_p
x(3)=8.298910401233888_p
w(3)=6.195430496668090e-4_p
x(4)=11.34933961600969_p
w(4)=4.285766166980064e-5_p
x(5)=15.53523168125585_p
w(5)=8.082053618347975e-7_p
else if(N==6)then
x(1)=5.197815508746318_p
w(1)=2.795442664570793e-3_p
x(2)=6.049183550703407_p
w(2)=2.823705581963334e-3_p
x(3)=7.610009287881404_p
w(3)=9.559988788728138e-4_p
x(4)=9.926982175660438_p
w(4)=1.323457294407269e-4_p
x(5)=13.01940590415458_p
w(5)=7.628223321050112e-6_p
x(6)=16.52541691955489_p
w(6)=2.121809697226850e-7_p
else if(N==7)then
x(1)=5.162693422433482_p
w(1)=2.378981583105755e-3_p
x(2)=5.859946490292501_p
w(2)=2.783124533248298e-3_p
x(3)=7.125294696675053_p
w(3)=1.249616700319040e-3_p
x(4)=8.973215436590085_p
w(4)=2.714492638007120e-4_p
x(5)=11.39949977187974_p
w(5)=3.020709726705498e-5_p
x(6)=14.29148088098433_p
w(6)=1.868019871408205e-6_p
x(7)=17.05757717041186_p
w(7)=8.606152617156768e-8_p
else if(N==8)then
x(1)=5.136157475870825_p
w(1)=2.043222553068160e-3_p
x(2)=5.718207248898868_p
w(2)=2.670317737766365e-3_p
x(3)=6.768275419979982_p
w(3)=1.475864754012229e-3_p
x(4)=8.288220518267815_p
w(4)=4.407690289532155e-4_p
x(5)=10.26657751633213_p
w(5)=7.633114187119650e-5_p
x(6)=12.64406472876737_p
w(6)=8.161430446764580e-6_p
x(7)=15.21220303422176_p
w(7)=6.213933788733174e-7_p
x(8)=17.35680112096686_p
w(8)=4.521964163580401e-8_p
else if(N==9)then
x(1)=5.115624437009214_p
w(1)=1.770362396901054e-3_p
x(2)=5.609132993905968_p
w(2)=2.520889391114025e-3_p
x(3)=6.496335423145633_p
w(3)=1.632450678773595e-3_p
x(4)=7.774035205220661_p
w(4)=6.178991526889138e-4_p
x(5)=9.429259069316284_p
w(5)=1.473707472151358e-4_p
x(6)=11.42304886203685_p
w(6)=2.338191125374239e-5_p
x(7)=13.65244750600539_p
w(7)=2.686478529255775e-6_p
x(8)=15.86641201903121_p
w(8)=2.647365860885613e-7_p
x(9)=17.53658680350188_p
w(9)=2.776607663002376e-8_p
else if(N==10)then
x(1)=5.099411164557163_p
w(1)=1.546565659546509e-3_p
x(2)=5.523313314359195_p
w(2)=2.356771645295800e-3_p
x(3)=6.283762845276991_p
w(3)=1.727762280590523e-3_p
x(4)=7.375697182633446_p
w(4)=7.851676359013648e-4_p
x(5)=8.786675694011898_p
w(5)=2.387242725337419e-4_p
x(6)=10.48832241328973_p
w(6)=5.099691351405293e-5_p
x(7)=12.41903390722268_p
w(7)=8.124151518497848e-6_p
x(8)=14.4505322304008_p
w(8)=1.066164664734397e-6_p
x(9)=16.33274474552202_p
w(9)=1.357100370958059e-7_p
x(10)=17.65152280189335_p
w(10)=1.882553611985287e-8_p
else if(N==11)then
x(1)=5.086385218140069_p
w(1)=1.361278663178000e-3_p
x(2)=5.454528174536827_p
w(2)=2.190858799083642e-3_p
x(3)=6.114107960098178_p
w(3)=1.773687988589316e-3_p
x(4)=7.059598583361320_p
w(4)=9.316619579008512e-4_p
x(5)=8.279763205281437_p
w(5)=3.426420341153841e-4_p
x(6)=9.752783419264198_p
w(6)=9.230546821911514e-5_p
x(7)=11.43734034332037_p
w(7)=1.907732961803163e-5_p
x(8)=13.25709881257084_p
w(8)=3.231023578608491e-6_p
x(9)=15.07607757101102_p
w(9)=4.967493514813225e-7_p
x(10)=16.67008203801379_p
w(10)=7.959848470548759e-8_p
x(11)=17.72894187553197_p
w(11)=1.364701930508735e-8_p
else if(N==12)then
x(1)=5.075762363392212_p
w(1)=1.206471922251568e-3_p
x(2)=5.398522395304351_p
w(2)=2.030362675840202e-3_p
x(3)=5.976362839476342_p
w(3)=1.782002507062714e-3_p
x(4)=6.803910988696680_p
w(4)=1.052341659104111e-3_p
x(5)=7.871276123827188_p
w(5)=4.509411982006951e-4_p
x(6)=9.161129470929723_p
w(6)=1.462636136115046e-4_p
x(7)=10.64368563187318_p
w(7)=3.731122897489965e-5_p
x(8)=12.26865444784781_p
w(8)=7.852824977928522e-6_p
x(9)=13.95311275625555_p
w(9)=1.459954436188839e-6_p
x(10)=15.56618145006721_p
w(10)=2.638020438594106e-7_p
x(11)=16.91889161014478_p
w(11)=5.149743925543134e-8_p
x(12)=17.78337727662042_p
w(12)=1.037519551340842e-8_p
else if(N==13)then
x(1)=5.066985613546478_p
w(1)=1.076011390373333e-3_p
x(2)=5.352299735870815_p
w(2)=1.879023106674199e-3_p
x(3)=5.862894589558334_p
w(3)=1.762887354738459e-3_p
x(4)=6.593805465635811_p
w(4)=1.146291232700031e-3_p
x(5)=7.536426777420310_p
w(5)=5.566665160220281e-4_p
x(6)=8.676694825380292_p
w(6)=2.101194944675231e-4_p
x(7)=9.992079640351635_p
w(7)=6.371794755413067e-5_p
x(8)=11.44705091310125_p
w(8)=1.611136658269896e-5_p
x(9)=12.98657139892475_p
w(9)=3.566755283645000e-6_p
x(10)=14.527773739156_p
w(10)=7.386235237254378e-7_p
x(11)=15.95221088431186_p
w(11)=1.554831344291317e-7_p
x(12)=17.10619094453919_p
w(12)=3.581647757909606e-8_p
x(13)=17.82302664899763_p
w(13)=8.171606657249230e-9_p
else if(N==14)then
x(1)=5.059650546551911_p
w(1)=9.651776267447904e-4_p
x(2)=5.313698079126218_p
w(2)=1.738504921784376e-3_p
x(3)=5.768255250943489_p
w(3)=1.724548147864637e-3_p
x(4)=6.418849762689685_p
w(4)=1.215084853484777e-3_p
x(5)=7.258029440784345_p
w(5)=6.547435167865062e-4_p
x(6)=8.274199776691157_p
w(6)=2.802920056729068e-4_p
x(7)=9.449733066810953_p
w(7)=9.816948742949001e-5_p
x(8)=10.75824847023497_p
w(8)=2.899601618511350e-5_p
x(9)=12.16087064515231_p
w(9)=7.494526702715526e-6_p
x(10)=13.60148984196896_p
w(10)=1.778175457723959e-6_p
x(11)=15.00182371573808_p
w(11)=4.115597139033977e-7_p
x(12)=16.25885450883841_p
w(12)=9.950565862083574e-8_p
x(13)=17.24998362101067_p
w(13)=2.630210542222175e-8_p
x(14)=17.85276350603779_p
w(14)=6.613547457174269e-9_p
else if(N==15)then
x(1)=5.053457757602598_p
w(1)=8.703088383771921e-4_p
x(2)=5.281123961257113_p
w(2)=1.609262347034798e-3_p
x(3)=5.688461495730613_p
w(3)=1.673323431418951e-3_p
x(4)=6.271495222170747_p
w(4)=1.261566426207382e-3_p
x(5)=7.023779018924639_p
w(5)=7.419841230896009e-4_p
x(6)=7.935636957003599_p
w(6)=3.531230099260746e-4_p
x(7)=8.992930289705221_p
w(7)=1.396617200977802e-4_p
x(8)=10.1753439773189_p
w(8)=4.709605879841057e-5_p
x(9)=11.45411209906932_p
w(9)=1.394317178310914e-5_p
x(10)=12.78918347374245_p
w(10)=3.757587693052860e-6_p
x(11)=14.12613555683595_p
w(11)=9.643350219064160e-7_p
x(12)=15.39382277217061_p
w(12)=2.486377995733578e-7_p
x(13)=16.50488325146107_p
w(13)=6.796529102534759e-8_p
x(14)=17.36239789665354_p
w(14)=2.013741505535745e-8_p
x(15)=17.87561980186398_p
w(15)=5.469184527898116e-9_p
else if(N==16)then
x(1)=5.048181744966859_p
w(1)=7.885384533571740e-4_p
x(2)=5.253381234990938_p
w(2)=1.491067089296096e-3_p
x(3)=5.620540621730443_p
w(3)=1.613971548267511e-3_p
x(4)=6.146151111013836_p
w(4)=1.289048521607761e-3_p
x(5)=6.824631985306995_p
w(5)=8.167803827047631e-4_p
x(6)=7.647828070838345_p
w(6)=4.253687251489182e-4_p
x(7)=8.604182009313629_p
w(7)=1.866062611062422e-4_p
x(8)=9.677612075869565_p
w(8)=7.051286909060285e-5_p
x(9)=10.84606544003547_p
w(9)=2.350887674484303e-5_p
x(10)=12.07974763933161_p
w(10)=7.114427093424994e-6_p
x(11)=13.33916174151999_p
w(11)=2.022898876103239e-6_p
x(12)=14.57337641497712_p
w(12)=5.631430975857068e-7_p
x(13)=15.7194267292611_p
w(13)=1.606416432880851e-7_p
x(14)=16.7043602204593_p
w(14)=4.888981358367948e-8_p
x(15)=17.45173974929999_p
w(15)=1.592866330675144e-8_p
x(16)=17.89355682495556_p
w(16)=4.602627235793280e-9_p
else if(N==17)then
x(1)=5.043650045494352_p
w(1)=7.176023003127612e-4_p
x(2)=5.229557363728850_p
w(2)=1.383327664971191e-3_p
x(3)=5.562234587471994_p
w(3)=1.549988305664540e-3_p
x(4)=6.038594602309614_p
w(4)=1.300836885829126e-3_p
x(5)=6.653796279469146_p
w(5)=8.787059026514953e-4_p
x(6)=7.400908596810495_p
w(6)=4.944408893989804e-4_p
x(7)=8.270341799682665_p
w(7)=2.371435480828065e-4_p
x(8)=9.249089087546890_p
w(8)=9.888621314510758e-5_p
x(9)=10.31977170600583_p
w(9)=3.658548602818852e-5_p
x(10)=11.45949054156389_p
w(10)=1.228899292919521e-5_p
x(11)=12.63854828583738_p
w(11)=3.850809665976597e-6_p
x(12)=13.81923709361249_p
w(12)=1.162413862404570e-6_p
x(13)=14.9551061642346_p
w(13)=3.506055892596688e-7_p
x(14)=15.99142101570718_p
w(14)=1.097193700772914e-7_p
x(15)=16.86778465188001_p
w(15)=3.666052559774317e-8_p
x(16)=17.52380339916217_p
w(16)=1.293127538761680e-8_p
x(17)=17.90788658203764_p
w(17)=3.929836344620264e-9_p
else
call GD(5)
end if
end subroutine GF_5

end module m_gauss_fermi_18
