! Module to contain all the Gauss-Fermi quadrature points
! It has been created by an automatic script created by:
! Nick Papior Andersen, 2013, nickpapior@gmail.com
! If you ever need to use this please contact the author for approval

! We have employed the Stieltjes and moment algorithm together with the Golub-Welsch
! for an efficient and fairly accurate stability of the orthogonal polynomials.

module m_gauss_fermi_28

  implicit none

  integer, parameter :: p = selected_real_kind(14,300)

  integer, parameter :: G_NF_MIN_N  =  2
  integer, parameter :: G_NF_MAX_N  = 17
  integer, parameter :: G_NF_MIN_kT = -20
  integer, parameter :: G_NF_MAX_kT = 5
  
  private
  public :: G_NF_MIN_N
  public :: G_NF_MAX_N
  public :: G_NF_MIN_kT
  public :: G_NF_MAX_kT
  public :: GaussFermi_28
  
contains

  ! Die routine for the Gauss-Fermi routines
  subroutine GD(NkT)
    integer, intent(in) :: NkT
    write(*,*) 'Error in Gauss-Fermi ',NkT
    call die('Error in number of points for Gauss-Fermi, see output.')
  end subroutine GD
  
  subroutine GaussFermi_28(NkT,N,x,w)
    integer, intent(in) :: NkT, N
    real(p), intent(out) :: x(N), w(N)
    
    if ( NkT == -20 ) then
       call GF_m20(N,x,w)
    else if ( NkT == -19 ) then
       call GF_m19(N,x,w)
    else if ( NkT == -18 ) then
       call GF_m18(N,x,w)
    else if ( NkT == -17 ) then
       call GF_m17(N,x,w)
    else if ( NkT == -16 ) then
       call GF_m16(N,x,w)
    else if ( NkT == -15 ) then
       call GF_m15(N,x,w)
    else if ( NkT == -14 ) then
       call GF_m14(N,x,w)
    else if ( NkT == -13 ) then
       call GF_m13(N,x,w)
    else if ( NkT == -12 ) then
       call GF_m12(N,x,w)
    else if ( NkT == -11 ) then
       call GF_m11(N,x,w)
    else if ( NkT == -10 ) then
       call GF_m10(N,x,w)
    else if ( NkT == -9 ) then
       call GF_m9(N,x,w)
    else if ( NkT == -8 ) then
       call GF_m8(N,x,w)
    else if ( NkT == -7 ) then
       call GF_m7(N,x,w)
    else if ( NkT == -6 ) then
       call GF_m6(N,x,w)
    else if ( NkT == -5 ) then
       call GF_m5(N,x,w)
    else if ( NkT == -4 ) then
       call GF_m4(N,x,w)
    else if ( NkT == -3 ) then
       call GF_m3(N,x,w)
    else if ( NkT == -2 ) then
       call GF_m2(N,x,w)
    else if ( NkT == -1 ) then
       call GF_m1(N,x,w)
    else if ( NkT == 0 ) then
       call GF_0(N,x,w)
    else if ( NkT == 1 ) then
       call GF_1(N,x,w)
    else if ( NkT == 2 ) then
       call GF_2(N,x,w)
    else if ( NkT == 3 ) then
       call GF_3(N,x,w)
    else if ( NkT == 4 ) then
       call GF_4(N,x,w)
    else if ( NkT == 5 ) then
       call GF_5(N,x,w)
    else
       call die('Could not figure out the Gauss-Fermi &
             &quadratue method you asked for.')
    end if
  end subroutine GaussFermi_28
  
  
! [-20kT;28kT]
subroutine GF_m20(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-15.59867300183768_p
w(1)=10.4013205792681_p
x(2)=-3.761795334827820_p
w(2)=9.598679422792362_p
else if(N==3)then
x(1)=-17.56069617753153_p
w(1)=6.008953675648327_p
x(2)=-9.213295996775964_p
w(2)=9.514824294183629_p
x(3)=-1.155162437581640_p
w(3)=4.476222032228507_p
else if(N==4)then
x(1)=-18.43109871854324_p
w(1)=3.928604560242156_p
x(2)=-12.55785504389464_p
w(2)=7.327554020425854_p
x(3)=-5.008577000495323_p
w(3)=7.006527645942386_p
x(4)=6.703031723797448e-1_p
w(4)=1.737313775450066_p
else if(N==5)then
x(1)=-18.89086261114641_p
w(1)=2.800001605290142_p
x(2)=-14.55265602941928_p
w(2)=5.634868812724625_p
x(3)=-8.251795681559237_p
w(3)=6.590038065829275_p
x(4)=-2.226669885941989_p
w(4)=4.558760499533268_p
x(5)=2.575329698944912_p
w(5)=4.163310186831529e-1_p
else if(N==6)then
x(1)=-19.16408472573598_p
w(1)=2.120043872976564_p
x(2)=-15.8125163604138_p
w(2)=4.449474174324683_p
x(3)=-10.62334019941564_p
w(3)=5.711096905152075_p
x(4)=-4.894462349026169_p
w(4)=5.411410236308278_p
x(5)=-2.096337272871457e-1_p
w(5)=2.254385769941508_p
x(6)=4.860730322370252_p
w(6)=5.358904335735344e-2_p
else if(N==7)then
x(1)=-19.34059801437626_p
w(1)=1.677207210987228_p
x(2)=-16.65572536388645_p
w(2)=3.611996882841555_p
x(3)=-12.33659052734315_p
w(3)=4.890410715762954_p
x(4)=-7.191420279182941_p
w(4)=5.214300923329527_p
x(5)=-2.328753103902456_p
w(5)=3.909111550983110_p
x(6)=1.650710848979399_p
w(6)=6.925800040825091e-1_p
x(7)=7.485763323957646_p
w(7)=4.392714073578576e-3_p
else if(N==8)then
x(1)=-19.46193683044605_p
w(1)=1.371215351591337_p
x(2)=-17.24856415049749_p
w(2)=3.003706205215230_p
x(3)=-13.59810011193444_p
w(3)=4.207529363334783_p
x(4)=-9.044455031130711_p
w(4)=4.778349044199617_p
x(5)=-4.322136643806782_p
w(5)=4.437213185812215_p
x(6)=-3.272278456287229e-1_p
w(6)=2.087098289829747_p
x(7)=3.763809840335326_p
w(7)=1.146135960566271e-1_p
x(8)=10.33913204687977_p
w(8)=2.749660209057448e-4_p
else if(N==9)then
x(1)=-19.54951135205908_p
w(1)=1.149588975591781_p
x(2)=-17.68304531447397_p
w(2)=2.548267254412876_p
x(3)=-14.55129001908567_p
w(3)=3.653306586827476_p
x(4)=-10.52332395095838_p
w(4)=4.318011415697580_p
x(5)=-6.108628464159929_p
w(5)=4.388466303293159_p
x(6)=-1.997754512713900_p
w(6)=3.257660129556359_p
x(7)=1.519652595709692_p
w(7)=6.728983173958329e-1_p
x(8)=6.182350462779283_p
w(8)=1.178642836046487e-2_p
x(9)=13.33730661784359_p
w(9)=1.459092493286362e-5_p
else if(N==10)then
x(1)=-19.61540417608303_p
w(1)=9.824081341491973e-1_p
x(2)=-18.01357702802905_p
w(2)=2.196558757864302_p
x(3)=-15.29218652339087_p
w(3)=3.201902786346789_p
x(4)=-11.71557343300493_p
w(4)=3.890139380947193_p
x(5)=-7.651164639137004_p
w(5)=4.157114052091030_p
x(6)=-3.589286553373913_p
w(6)=3.744081139802308_p
x(7)=-9.843034652736182e-2_p
w(7)=1.706707463445996_p
x(8)=3.558037565431179_p
w(8)=1.201421242441651e-1_p
x(9)=8.788606219623576_p
w(9)=9.454344981426104e-4_p
x(10)=16.37660290969238_p
w(10)=7.286713397438483e-7_p
else if(N==11)then
x(1)=-19.66689967738346_p
w(1)=8.515045601382427e-1_p
x(2)=-18.27404029833289_p
w(2)=1.916314944707665_p
x(3)=-15.88542163613549_p
w(3)=2.828326934163215_p
x(4)=-12.69558951345186_p
w(4)=3.505942182008915_p
x(5)=-8.976844475191575_p
w(5)=3.872602535157074_p
x(6)=-5.085758030640276_p
w(6)=3.803080267997031_p
x(7)=-1.512934914149265_p
w(7)=2.669893730131979_p
x(8)=1.690508739616698_p
w(8)=5.377773300337557e-1_p
x(9)=5.806829128298682_p
w(9)=1.448732342018752e-2_p
x(10)=11.44111060377788_p
w(10)=7.015334747076871e-5_p
x(11)=19.26112425994502_p
w(11)=4.095492639102696e-8_p
else if(N==12)then
x(1)=-19.7084314703519_p
w(1)=7.457708961748868e-1_p
x(2)=-18.48546887322451_p
w(2)=1.686880345010105_p
x(3)=-16.37294197150818_p
w(3)=2.513686956844368_p
x(4)=-13.5170644848017_p
w(4)=3.163732341739509_p
x(5)=-10.12369586216239_p
w(5)=3.578775655477441_p
x(6)=-6.459812089846507_p
w(6)=3.684409377890767_p
x(7)=-2.888827084574221_p
w(7)=3.189236860396888_p
x(8)=2.293575099367306e-1_p
w(8)=1.332629883345266_p
x(9)=3.605139680271547_p
w(9)=1.033490807470986e-1_p
x(10)=8.125354916259568_p
w(10)=1.523008737629757e-3_p
x(11)=13.99162562808244_p
w(11)=5.592409420508353e-6_p
x(12)=21.72218794239194_p
w(12)=3.287081069132952e-9_p
else if(N==13)then
x(1)=-19.74265032496751_p
w(1)=6.585514876780932e-1_p
x(2)=-18.6605616954902_p
w(2)=1.495601795278982_p
x(3)=-16.78060203646463_p
w(3)=2.245599926610833_p
x(4)=-14.21456783989234_p
w(4)=2.860083591462955_p
x(5)=-11.1206146350868_p
w(5)=3.293905933154381_p
x(6)=-7.703017083963545_p
w(6)=3.496206051221075_p
x(7)=-4.229551874275320_p
w(7)=3.335811467685698_p
x(8)=-1.064435340101992_p
w(8)=2.179983225363896_p
x(9)=1.901010061216469_p
w(9)=4.188602932812311e-1_p
x(10)=5.626030828781960_p
w(10)=1.523301925881677e-2_p
x(11)=10.39336310511465_p
w(11)=1.626718436797656e-4_p
x(12)=16.31963941153161_p
w(12)=5.387802362551065e-7_p
x(13)=23.58790821017286_p
w(13)=4.405852928088880e-10_p
else if(N==14)then
x(1)=-19.77122387070331_p
w(1)=5.856521230644097e-1_p
x(2)=-18.80736677498023_p
w(2)=1.334373738208555_p
x(3)=-17.12503837603545_p
w(3)=2.015755092328761_p
x(4)=-14.81102260828926_p
w(4)=2.591712818145219_p
x(5)=-11.98856962599212_p
w(5)=3.026759519090544_p
x(6)=-8.816645725040775_p
w(6)=3.283374600762029_p
x(7)=-5.497932166620252_p
w(7)=3.293831805213203_p
x(8)=-2.315932186815321_p
w(8)=2.728520025866345_p
x(9)=5.205319145445412e-1_p
w(9)=1.048502502347652_p
x(10)=3.657325115665722_p
w(10)=8.940064389595738e-2_p
x(11)=7.655827885217991_p
w(11)=2.097857544638969e-3_p
x(12)=12.53491663000768_p
w(12)=1.920830622097605e-5_p
x(13)=18.35630243778974_p
w(13)=6.718907791264655e-8_p
x(14)=24.88446466499366_p
w(14)=9.784933693681006e-11_p
else if(N==15)then
x(1)=-19.79531975990593_p
w(1)=5.241293366528869e-1_p
x(2)=-18.93157630077645_p
w(2)=1.197378851059229_p
x(3)=-17.41826945426265_p
w(3)=1.817801794452849_p
x(4)=-15.32369707256288_p
w(4)=2.355106494993156_p
x(5)=-12.74517079473893_p
w(5)=2.781059342456171_p
x(6)=-9.808179073819518_p
w(6)=3.066795995097139_p
x(7)=-6.670076640321094_p
w(7)=3.171146491272849_p
x(8)=-3.541866137784593_p
w(8)=2.944272439771535_p
x(9)=-6.931709850037785e-1_p
w(9)=1.790418762465716_p
x(10)=2.075061271375843_p
w(10)=3.357665678538454e-1_p
x(11)=5.473118565531780_p
w(11)=1.582293805768592e-2_p
x(12)=9.624440436764974_p
w(12)=2.983422130373121e-4_p
x(13)=14.50408898752083_p
w(13)=2.634549710149978e-6_p
x(14)=20.07851622604392_p
w(14)=1.113226304561196e-8_p
x(15)=25.75083835793632_p
w(15)=3.238743517491152e-11_p
else if(N==16)then
x(1)=-19.81581571535953_p
w(1)=4.717651279650204e-1_p
x(2)=-19.03751526472961_p
w(2)=1.080128871762820_p
x(3)=-17.66963352088971_p
w(3)=1.646523279276514_p
x(4)=-15.76659591238171_p
w(4)=2.146577457092708_p
x(5)=-13.40616345455334_p
w(5)=2.557580448851670_p
x(6)=-10.68865117282492_p
w(6)=2.856748178958618_p
x(7)=-7.738638712255725_p
w(7)=3.015837096309860_p
x(8)=-4.716259379227636_p
w(8)=2.963131491971679_p
x(9)=-1.848110159332090_p
w(9)=2.341219078779753_p
x(10)=7.678546486752187e-1_p
w(10)=8.385871972101117e-1_p
x(11)=3.692191344467493_p
w(11)=7.916610662051554e-2_p
x(12)=7.280407157018053_p
w(12)=2.689047164520813e-3_p
x(13)=11.48796305666363_p
w(13)=4.618582826178908e-5_p
x(14)=16.27505550355422_p
w(14)=4.318151607217215e-7_p
x(15)=21.49642588142784_p
w(15)=2.439020077426585e-9_p
x(16)=26.32881155784556_p
w(16)=1.422847894131860e-11_p
else if(N==17)then
x(1)=-19.83338876304668_p
w(1)=4.268450842148392e-1_p
x(2)=-19.1285504112816_p
w(2)=9.790849184378306e-1_p
x(3)=-17.88653737594038_p
w(3)=1.497596456734930_p
x(4)=-16.15121679466568_p
w(4)=1.962562056460922_p
x(5)=-13.98541600693446_p
w(5)=2.355527127125594_p
x(6)=-11.47023583229811_p
w(6)=2.658182551180729_p
x(7)=-8.705825109080676_p
w(7)=2.849631890519926_p
x(8)=-5.817185308800123_p
w(8)=2.890674363440858_p
x(9)=-2.976595716941062_p
w(9)=2.608257670343100_p
x(10)=-3.781772669098847e-1_p
w(10)=1.479088242038102_p
x(11)=2.221026956636361_p
w(11)=2.758017289610629e-1_p
x(12)=5.342968676715680_p
w(12)=1.626734594212273e-2_p
x(13)=9.030146867189286_p
w(13)=4.724500794165842e-4_p
x(14)=13.21889957697869_p
w(14)=8.030246483390626e-6_p
x(15)=17.83801892774981_p
w(15)=8.563786454349876e-8_p
x(16)=22.64188779656256_p
w(16)=6.890946487146166e-10_p
x(17)=26.7217653621121_p
w(17)=7.587333942175554e-12_p
else
call GD(-20)
end if
end subroutine GF_m20

! [-19kT;28kT]
subroutine GF_m19(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.80201381314094_p
w(1)=9.919648068140798_p
x(2)=-3.526768404977062_p
w(2)=9.080351937461305_p
else if(N==3)then
x(1)=-16.6660216267025_p
w(1)=5.749160061983213_p
x(2)=-8.682923502341716_p
w(2)=9.091369949423127_p
x(3)=-9.856472868497315e-1_p
w(3)=4.159469994195764_p
else if(N==4)then
x(1)=-17.4942765882127_p
w(1)=3.770229279828799_p
x(2)=-11.85930462147137_p
w(2)=7.027560280921355_p
x(3)=-4.631462404626856_p
w(3)=6.664636520369158_p
x(4)=8.528756620976894e-1_p
w(4)=1.537573924482793_p
else if(N==5)then
x(1)=-17.93258398559634_p
w(1)=2.694564332592765_p
x(2)=-13.75863778358342_p
w(2)=5.420031930525227_p
x(3)=-7.703172176087913_p
w(3)=6.322857757227180_p
x(4)=-1.942134706633522_p
w(4)=4.225539249776992_p
x(5)=2.819883228304107_p
w(5)=3.370067354799402e-1_p
else if(N==6)then
x(1)=-18.19355740361261_p
w(1)=2.045216700971352_p
x(2)=-14.96089217884898_p
w(2)=4.290666253703864_p
x(3)=-9.959797532880399_p
w(3)=5.499454000746696_p
x(4)=-4.456957682392965_p
w(4)=5.154154510007314_p
x(5)=4.420626368968378e-2_p
w(5)=1.970908101041975_p
x(6)=5.178403409975306_p
w(6)=3.960043913090337e-2_p
else if(N==7)then
x(1)=-18.36247945281147_p
w(1)=1.621493291939184_p
x(2)=-15.76723213856652_p
w(2)=3.490754592661193_p
x(3)=-11.59494104455124_p
w(3)=4.721398099948241_p
x(4)=-6.634649597389952_p
w(4)=5.012580720343462_p
x(5)=-1.979317471701047_p
w(5)=3.602176709143565_p
x(6)=1.943511112927034_p
w(6)=5.485598732536073e-1_p
x(7)=7.862953138601792_p
w(7)=3.036718312852650e-3_p
else if(N==8)then
x(1)=-18.47881925183354_p
w(1)=1.328147913869354_p
x(2)=-16.33529212937027_p
w(2)=2.908430762740517_p
x(3)=-12.80192812238582_p
w(3)=4.070720964365091_p
x(4)=-8.400565293342032_p
w(4)=4.611762105554169_p
x(5)=-3.858205536442783_p
w(5)=4.212946140341168_p
x(6)=-1.843253889944889e-2_p
w(6)=1.786000934840173_p
x(7)=4.125111055022882_p
w(7)=8.181022015054261e-2_p
x(8)=10.7625481961442_p
w(8)=1.809637410912664e-4_p
else if(N==9)then
x(1)=-18.56295978666446_p
w(1)=1.115236671999190_p
x(2)=-16.75251716522413_p
w(2)=2.471410623892047_p
x(3)=-13.71617488671145_p
w(3)=3.540696748081247_p
x(4)=-9.815168216456897_p
w(4)=4.177868947434069_p
x(5)=-5.552701148980975_p
w(5)=4.216240841556858_p
x(6)=-1.615866393259269_p
w(6)=2.956077999669262_p
x(7)=1.859458365348263_p
w(7)=5.146077583352039e-1_p
x(8)=6.599237610046966_p
w(8)=7.851145842744271e-3_p
x(9)=13.79407668755428_p
w(9)=9.268791483414736e-6_p
else if(N==10)then
x(1)=-18.62643506185093_p
w(1)=9.542051260913235e-1_p
x(2)=-17.07078333303366_p
w(2)=2.132960505894220_p
x(3)=-14.42889837893701_p
w(3)=3.107406527666842_p
x(4)=-10.95979621344593_p
w(4)=3.770535126872035_p
x(5)=-7.025831152757490_p
w(5)=4.013963771263922_p
x(6)=-3.119586417824393_p
w(6)=3.523290142785551_p
x(7)=2.473100738664289e-1_p
w(7)=1.414203786265714_p
x(8)=3.956594956888412_p
w(8)=8.282911016755795e-2_p
x(9)=9.239469207854984_p
w(9)=6.054521548226959e-4_p
x(10)=16.84396216778894_p
w(10)=4.564401148307312e-7_p
else if(N==11)then
x(1)=-18.67619047682473_p
w(1)=8.277348532505784e-1_p
x(2)=-17.32235664468436_p
w(2)=1.862413362205228_p
x(3)=-15.00145290215278_p
w(3)=2.747448544846394_p
x(4)=-11.90423019184932_p
w(4)=3.402314944854886_p
x(5)=-8.298961858015122_p
w(5)=3.749011638073032_p
x(6)=-4.542404066666201_p
w(6)=3.639819308907734_p
x(7)=-1.119679018988748_p
w(7)=2.365361143597991_p
x(8)=2.064241469970732_p
w(8)=3.964036650639477e-1_p
x(9)=6.244102171879053_p
w(9)=9.448211869202064e-3_p
x(10)=11.90152871963903_p
w(10)=4.430668897789239e-5_p
x(11)=19.69774229059713_p
w(11)=2.624413364497824e-8_p
else if(N==12)then
x(1)=-18.71641433330681_p
w(1)=7.253375651420945e-1_p
x(2)=-17.52706813168449_p
w(2)=1.640354592185041_p
x(3)=-15.47319938121497_p
w(3)=2.443376258003100_p
x(4)=-12.69820830889233_p
w(4)=3.072828661062514_p
x(5)=-9.404746321508830_p
w(5)=3.470047087856764_p
x(6)=-5.858566599802055_p
w(6)=3.552007527806937_p
x(7)=-2.428224942340477_p
w(7)=2.958250100603876_p
x(8)=5.963649298332458e-1_p
w(8)=1.067029475822819_p
x(9)=4.021547955198614_p
w(9)=6.979222531986146e-2_p
x(10)=8.576182957841828_p
w(10)=9.729421477655199e-4_p
x(11)=14.43700038911217_p
w(11)=3.567411740803033e-6_p
x(12)=22.08417639506731_p
w(12)=2.239592943667209e-9_p
else if(N==13)then
x(1)=-18.7495976876736_p
w(1)=6.407620751387595e-1_p
x(2)=-17.69682168253564_p
w(2)=1.454968776589059_p
x(3)=-15.86823148579719_p
w(3)=2.183857773511643_p
x(4)=-13.37348419681591_p
w(4)=2.779693144614255_p
x(5)=-10.36817249787463_p
w(5)=3.197304056874034_p
x(6)=-7.054881572482445_p
w(6)=3.382355471973803_p
x(7)=-3.704885581896356_p
w(7)=3.170490526166723_p
x(8)=-6.681009372034645e-1_p
w(8)=1.880182451617005_p
x(9)=2.294012571807709_p
w(9)=3.003968857376400e-1_p
x(10)=6.065839137107355_p
w(10)=9.884599612999550e-3_p
x(11)=10.83959497883826_p
w(11)=1.038900091034304e-4_p
x(12)=16.73128185181415_p
w(12)=3.534327072041299e-7_p
x(13)=23.85858886696587_p
w(13)=3.243736072558264e-10_p
else if(N==14)then
x(1)=-18.77732370593569_p
w(1)=5.700282721908780e-1_p
x(2)=-17.83924311388144_p
w(2)=1.298597755816552_p
x(3)=-16.20224290190679_p
w(3)=1.961155379043388_p
x(4)=-13.95145240457827_p
w(4)=2.520212834214822_p
x(5)=-11.20806893835493_p
w(5)=2.940415259289496_p
x(6)=-8.129354393252783_p
w(6)=3.182747391724395_p
x(7)=-4.919210650939521_p
w(7)=3.165648737444414_p
x(8)=-1.865011714714601_p
w(8)=2.486255638667903_p
x(9)=9.032461396721729e-1_p
w(9)=8.139383585606665e-1_p
x(10)=4.082470592235369_p
w(10)=5.964341200425445e-2_p
x(11)=8.101063178539087_p
w(11)=1.344494161924517e-3_p
x(12)=12.96393521709345_p
w(12)=1.242658306431421e-5_p
x(13)=18.72307210443716_p
w(13)=4.582308888933214e-8_p
x(14)=25.07572915369384_p
w(14)=7.725823658366947e-11_p
else if(N==15)then
x(1)=-18.80071492595977_p
w(1)=5.103070730377400e-1_p
x(2)=-17.95979888708162_p
w(2)=1.165663742523651_p
x(3)=-16.48674691203805_p
w(3)=1.769226912091264_p
x(4)=-14.44855919271864_p
w(4)=2.291193048429131_p
x(5)=-11.94089494383341_p
w(5)=2.703515561384805_p
x(6)=-9.087690143343258_p
w(6)=2.976662602863704_p
x(7)=-6.046279524245643_p
w(7)=3.063636691805246_p
x(8)=-3.032629421645479_p
w(8)=2.771426352057771_p
x(9)=-2.917843046904549e-1_p
w(9)=1.502308141935659_p
x(10)=2.482523999348919_p
w(10)=2.356344988598477e-1_p
x(11)=5.914333301416407_p
w(11)=1.023196521130899e-2_p
x(12)=10.06283860047886_p
w(12)=1.916650159891683e-4_p
x(13)=14.90694017300963_p
w(13)=1.742426513924693e-6_p
x(14)=20.39580934371264_p
w(14)=7.932500692539786e-9_p
x(15)=25.88420992717854_p
w(15)=2.697405790904895e-11_p
else if(N==16)then
x(1)=-18.8206194220364_p
w(1)=4.594557290866965e-1_p
x(2)=-18.06266495740978_p
w(2)=1.051837612738617_p
x(3)=-16.73074532235756_p
w(3)=1.603064659762259_p
x(4)=-14.87825513528369_p
w(4)=2.089168157886080_p
x(5)=-12.58161612835832_p
w(5)=2.487634659809522_p
x(6)=-9.939786186540429_p
w(6)=2.775387565587903_p
x(7)=-7.076783989401573_p
w(7)=2.921571201557095_p
x(8)=-4.155601149867134_p
w(8)=2.834476180189134_p
x(9)=-1.402817810045086_p
w(9)=2.090386836397563_p
x(10)=1.164967875796467_p
w(10)=6.329730540629310e-1_p
x(11)=4.124561089916498_p
w(11)=5.228987010853274e-2_p
x(12)=7.723537538658286_p
w(12)=1.724155379085238e-3_p
x(13)=11.91081370996237_p
w(13)=3.002744422766090e-5_p
x(14)=16.6458038409943_p
w(14)=2.937640361199465e-7_p
x(15)=21.76491581891812_p
w(15)=1.816112501291120e-9_p
x(16)=26.42301682217057_p
w(16)=1.230952020909505e-11_p
else if(N==17)then
x(1)=-18.83769190867077_p
w(1)=4.158165431578566e-1_p
x(2)=-18.15109518430302_p
w(2)=9.537020558293166e-1_p
x(3)=-16.94138704816689_p
w(3)=1.458509521698033_p
x(4)=-15.2516060690262_p
w(4)=1.910754642906848_p
x(5)=-13.14348563603355_p
w(5)=2.292172026434215_p
x(6)=-10.69696056378009_p
w(6)=2.584340969387719_p
x(7)=-8.011425634708099_p
w(7)=2.765111411663783_p
x(8)=-5.213115246339013_p
w(8)=2.786436412769036_p
x(9)=-2.479194848145507_p
w(9)=2.424889379312479_p
x(10)=3.017943422349328e-2_p
w(10)=1.207390670493558_p
x(11)=2.640429332271624_p
w(11)=1.900870983140168e-1_p
x(12)=5.786350529289673_p
w(12)=1.047984789582374e-2_p
x(13)=9.465523806392950_p
w(13)=3.040466590060854e-4_p
x(14)=13.61999447163696_p
w(14)=5.318407804287301e-6_p
x(15)=18.17355378876736_p
w(15)=6.013142884331114e-8_p
x(16)=22.86588248493336_p
w(16)=5.344389023569722e-10_p
x(17)=26.7899388883625_p
w(17)=6.741401400185669e-12_p
else
call GD(-19)
end if
end subroutine GF_m19

! [-18kT;28kT]
subroutine GF_m18(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.00466036076743_p
w(1)=9.439548871458442_p
x(2)=-3.289241401650855_p
w(2)=8.560451143770846_p
else if(N==3)then
x(1)=-15.77082961351993_p
w(1)=5.490612558172426_p
x(2)=-8.150660645669841_p
w(2)=8.668234970976576_p
x(3)=-8.100978702797746e-1_p
w(3)=3.841152486080286_p
else if(N==4)then
x(1)=-16.55710073949549_p
w(1)=3.612723202046728_p
x(2)=-11.15925557689922_p
w(2)=6.728671190884912_p
x(3)=-4.252903124778604_p
w(3)=6.315427466498658_p
x(4)=1.047529317069885_p
w(4)=1.343178155798991_p
else if(N==5)then
x(1)=-16.97406834683084_p
w(1)=2.589715033067914_p
x(2)=-12.96355838333094_p
w(2)=5.206112972380899_p
x(3)=-7.153078600648622_p
w(3)=6.054182561753747_p
x(4)=-1.654996884587235_p
w(4)=3.882542778239809_p
x(5)=3.082196331201723_p
w(5)=2.674466697869191e-1_p
else if(N==6)then
x(1)=-17.22287171151637_p
w(1)=1.970784323974254_p
x(2)=-14.10854019252421_p
w(2)=4.132525015503714_p
x(3)=-9.295052066667253_p
w(3)=5.287704018665980_p
x(4)=-4.019682059943650_p
w(4)=4.886035111682956_p
x(5)=3.086767926454376e-1_p
w(5)=1.694263437238334_p
x(6)=5.514713026225588_p
w(6)=2.868810816405110e-2_p
else if(N==7)then
x(1)=-17.38425544123977_p
w(1)=1.566042839737982_p
x(2)=-14.87824853306125_p
w(2)=3.369972286705210_p
x(3)=-10.85242742775086_p
w(3)=4.552508093391635_p
x(4)=-6.077737949661904_p
w(4)=4.806909685035012_p
x(5)=-1.629578420887660_p
w(5)=3.278829944343315_p
x(6)=2.255727132739383_p
w(6)=4.236758009404097e-1_p
x(7)=8.257829352537291_p
w(7)=2.061365075724623e-3_p
else if(N==8)then
x(1)=-17.49563367468486_p
w(1)=1.285250380540883_p
x(2)=-15.42170368024752_p
w(2)=2.813452784422065_p
x(3)=-12.00519194362669_p
w(3)=3.934022273122323_p
x(4)=-7.756458376062348_p
w(4)=4.443634284054127_p
x(5)=-3.396613442187661_p
w(5)=3.972381678656730_p
x(6)=3.006958013284281e-1_p
w(6)=1.494106141902367_p
x(7)=4.506980704328091_p
w(7)=5.703536175884965e-2_p
x(8)=11.20243769371475_p
w(8)=1.171107719435500e-4_p
else if(N==9)then
x(1)=-17.57637049232706_p
w(1)=1.080978218258537_p
x(2)=-15.82181725645915_p
w(2)=2.394709198499498_p
x(3)=-12.88077409883853_p
w(3)=3.428107004829437_p
x(4)=-9.106980120338205_p
w(4)=4.036913715314965_p
x(5)=-4.998626765581144_p
w(5)=4.036244327260897_p
x(6)=-1.234579499049564_p
w(6)=2.635961229543235_p
x(7)=2.219751448643656_p
w(7)=3.819498241857541e-1_p
x(8)=7.034095636686281_p
w(8)=5.130694874942760e-3_p
x(9)=14.26505698340287_p
w(9)=5.802462022806964e-6_p
else if(N==10)then
x(1)=-17.63745430983911_p
w(1)=9.260301237311531e-1_p
x(2)=-16.12794524615359_p
w(2)=2.069387789961219_p
x(3)=-13.56558660772529_p
w(3)=3.012811226227174_p
x(4)=-10.20427812270755_p
w(4)=3.650330986218143_p
x(5)=-6.402024711627530_p
w(5)=3.867188975708715_p
x(6)=-2.654477043060983_p
w(6)=3.279686573666722_p
x(7)=6.046955852147443e-1_p
w(7)=1.138452334047831_p
x(8)=4.375196426042106_p
w(8)=5.572983588527367e-2_p
x(9)=9.704742130280096_p
w(9)=3.818866505026653e-4_p
x(10)=17.32014453575764_p
w(10)=2.831325554396661e-7_p
else if(N==11)then
x(1)=-17.68548684179355_p
w(1)=8.039497030878247e-1_p
x(2)=-16.37071288671843_p
w(2)=1.808451020129092_p
x(3)=-14.11763579616867_p
w(3)=2.666387603334448_p
x(4)=-11.1133397238206_p
w(4)=3.298165632173177_p
x(5)=-7.622478457528166_p
w(5)=3.623443381533987_p
x(6)=-4.003326324922059_p
w(6)=3.463377325082149_p
x(7)=-7.262577964797521e-1_p
w(7)=2.047018048806369_p
x(8)=2.458083361392132_p
w(8)=2.831227562086540e-1_p
x(9)=6.696834765046547_p
w(9)=6.056844148367487e-3_p
x(10)=12.37177368868572_p
w(10)=2.768394226011572e-5_p
x(11)=20.13431722610181_p
w(11)=1.678295983998441e-8_p
else if(N==12)then
x(1)=-17.72440880415874_p
w(1)=7.048736611643298e-1_p
x(2)=-16.56873567854372_p
w(2)=1.593740946778420_p
x(3)=-14.57366063129692_p
w(3)=2.372869238193250_p
x(4)=-11.87985415709447_p
w(4)=2.981484142568639_p
x(5)=-8.687002599115113_p
w(5)=3.360080564629856_p
x(6)=-5.260523618532681_p
w(6)=3.413162729253139_p
x(7)=-1.973004090295363_p
w(7)=2.700671970535687_p
x(8)=9.768200847940821e-1_p
w(8)=8.264261159890135e-1_p
x(9)=4.455824314612356_p
w(9)=4.607452451218148e-2_p
x(10)=9.038324631272758_p
w(10)=6.138588306594002e-4_p
x(11)=14.88756417712284_p
w(11)=2.261241240273419e-6_p
x(12)=22.43861318464417_p
w(12)=1.532873124561522e-9_p
else if(N==13)then
x(1)=-17.75655659455067_p
w(1)=6.229424568665276e-1_p
x(2)=-16.73314774751157_p
w(2)=1.414253148422705_p
x(3)=-14.95604958806268_p
w(3)=2.121943789056807_p
x(4)=-12.53283857270791_p
w(4)=2.698949932051857_p
x(5)=-9.616699955056401_p
w(5)=3.099861590182901_p
x(6)=-6.409057568087245_p
w(6)=3.265222019176309_p
x(7)=-3.185714914403866_p
w(7)=2.986249080304939_p
x(8)=-2.690020978315502e-1_p
w(8)=1.575358280272716_p
x(9)=2.706327184023490_p
w(9)=2.088386668913389e-1_p
x(10)=6.519213501715375_p
w(10)=6.315063058004529e-3_p
x(11)=11.29373813044314_p
w(11)=6.575749227776154e-5_p
x(12)=17.14427247157586_p
w(12)=2.312124325894892e-7_p
x(13)=24.11944514664842_p
w(13)=2.404730765364435e-10_p
else if(N==14)then
x(1)=-17.78343363843871_p
w(1)=5.543780597811766e-1_p
x(2)=-16.87117670087932_p
w(2)=1.262750963791420_p
x(3)=-15.27960810478032_p
w(3)=1.906412749753943_p
x(4)=-13.09224561638909_p
w(4)=2.448432836528768_p
x(5)=-10.42833880324853_p
w(5)=2.853466872029637_p
x(6)=-7.443764378589050_p
w(6)=3.080263370825266_p
x(7)=-4.344640399048824_p
w(7)=3.027401506935642_p
x(8)=-1.418437112296444_p
w(8)=2.217571958553450_p
x(9)=1.301074532426063_p
w(9)=6.095121854080808e-1_p
x(10)=4.524084607009788_p
w(10)=3.894958251341515e-2_p
x(11)=8.556450252210935_p
w(11)=8.519073471406261e-4_p
x(12)=13.39795761705868_p
w(12)=7.990449624679156e-6_p
x(13)=19.08834320804515_p
w(13)=3.125034356035416e-8_p
x(14)=25.25853355109333_p
w(14)=6.138140481986598e-11_p
else if(N==15)then
x(1)=-17.80611889890582_p
w(1)=4.964618551459259e-1_p
x(2)=-16.98807104508686_p
w(2)=1.133887823285176_p
x(3)=-15.5553616803922_p
w(3)=1.720532171913397_p
x(4)=-13.57372561386847_p
w(4)=2.227053198109775_p
x(5)=-11.13724353219122_p
w(5)=2.625516835430005_p
x(6)=-8.368500521802918_p
w(6)=2.885361672872885_p
x(7)=-5.425470037126875_p
w(7)=2.950983468396990_p
x(8)=-2.529282984164809_p
w(8)=2.574546523705447_p
x(9)=1.152360457223368e-1_p
w(9)=1.218580053529356_p
x(10)=2.908519963466217_p
w(10)=1.604329083256815e-1_p
x(11)=6.368078052781752_p
w(11)=6.520254215093387e-3_p
x(12)=10.50861536245474_p
w(12)=1.220964237226566e-4_p
x(13)=15.31230746550824_p
w(13)=1.148190950113134e-6_p
x(14)=20.70979286477482_p
w(14)=5.662313423225377e-9_p
x(15)=26.01138256207159_p
w(15)=2.256944918927367e-11_p
else if(N==16)then
x(1)=-17.82543093069082_p
w(1)=4.471260275414904e-1_p
x(2)=-17.08785826425035_p
w(2)=1.023493271286388_p
x(3)=-15.79197644446349_p
w(3)=1.559503724192669_p
x(4)=-13.99017390642847_p
w(4)=2.031571806931545_p
x(5)=-11.7575866297368_p
w(5)=2.417333425154646_p
x(6)=-9.191948575736404_p
w(6)=2.693227146439393_p
x(7)=-6.417126750239667_p
w(7)=2.824510607404473_p
x(8)=-3.599882309746177_p
w(8)=2.691341128522700_p
x(9)=-9.601171501699267e-1_p
w(9)=1.816740095436726_p
x(10)=1.578168017215237_p
w(10)=4.601954250494638e-1_p
x(11)=4.572266324807933_p
w(11)=3.384409550906152e-2_p
x(12)=8.176106387314400_p
w(12)=1.093656601982808e-3_p
x(13)=12.33868782273059_p
w(13)=1.940428204055124e-5_p
x(14)=17.01705774710802_p
w(14)=1.995101339476105e-7_p
x(15)=22.029244786105_p
w(15)=1.355892989295238e-9_p
x(16)=26.51293430799671_p
w(16)=1.068283754692024e-11_p
else if(N==17)then
x(1)=-17.84200203813262_p
w(1)=4.047698547298146e-1_p
x(2)=-17.17367875523604_p
w(2)=9.282723111344685e-1_p
x(3)=-15.9963416818756_p
w(3)=1.419334038518918_p
x(4)=-14.35221988894587_p
w(4)=1.858789978747729_p
x(5)=-12.30199254711715_p
w(5)=2.228531383154771_p
x(6)=-9.924520117047498_p
w(6)=2.509915726756938_p
x(7)=-7.318700931439951_p
w(7)=2.678927058594837_p
x(8)=-4.612744359852302_p
w(8)=2.674450965395122_p
x(9)=-1.987539731853691_p
w(9)=2.214016237207364_p
x(10)=4.466664043546303e-1_p
w(10)=9.488912326596824e-1_p
x(11)=3.077455546427891_p
w(11)=1.272455451552671e-1_p
x(12)=6.241410842362126_p
w(12)=6.658036465817522e-3_p
x(13)=9.907890412683022_p
w(13)=1.940960345840003e-4_p
x(14)=14.02412879966745_p
w(14)=3.508039729522225e-6_p
x(15)=18.50811047712213_p
w(15)=4.221253906170571e-8_p
x(16)=23.08558644529811_p
w(16)=4.157033343207272e-10_p
x(17)=26.85517423742025_p
w(17)=6.002008851901308e-12_p
else
call GD(-18)
end if
end subroutine GF_m18

! [-17kT;28kT]
subroutine GF_m17(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-13.20653105305636_p
w(1)=8.961195868336869_p
x(2)=-3.048806096406560_p
w(2)=8.038804173061816_p
else if(N==3)then
x(1)=-14.87507690933803_p
w(1)=5.233410362176663_p
x(2)=-7.616418694640458_p
w(2)=8.245051534955154_p
x(3)=-6.275440739858221e-1_p
w(3)=3.521538144266868_p
else if(N==4)then
x(1)=-15.61955155719807_p
w(1)=3.456131838109752_p
x(2)=-10.4576561288553_p
w(2)=6.430831879553693_p
x(3)=-3.872959961690893_p
w(3)=5.957222615955923_p
x(4)=1.255977359523668_p
w(4)=1.155813707779316_p
else if(N==5)then
x(1)=-16.01530832163702_p
w(1)=2.485470294989215_p
x(2)=-12.16740238956144_p
w(2)=4.993086316557930_p
x(3)=-6.601665821945817_p
w(3)=5.783133027645143_p
x(4)=-1.364383447867678_p
w(4)=3.530577526508946_p
x(5)=3.363791061682351_p
w(5)=2.077328756974502e-1_p
else if(N==6)then
x(1)=-16.25202637421481_p
w(1)=1.896748728730576_p
x(2)=-13.25546615265888_p
w(2)=3.975022635863800_p
x(3)=-8.629209848797915_p
w(3)=5.075519678774492_p
x(4)=-3.583011871178461_p
w(4)=4.604226324527239_p
x(5)=5.860418504120415e-1_p
w(5)=1.428126721048832_p
x(6)=5.870599483850355_p
w(6)=2.035595245374561e-2_p
else if(N==7)then
x(1)=-16.40592779107205_p
w(1)=1.510850424070181_p
x(2)=-13.9887915049981_p
w(2)=3.249618543997499_p
x(3)=-10.1091407706799_p
w(3)=4.383570098664293_p
x(4)=-5.521121094419730_p
w(4)=4.595596040339648_p
x(5)=-1.278476090410317_p
w(5)=2.940538057224494_p
x(6)=2.589209965540330_p
w(6)=3.184538374912336e-1_p
x(7)=8.671096959916266_p
w(7)=1.373039611336047e-3_p
else if(N==8)then
x(1)=-16.51238381314923_p
w(1)=1.242512721221659_p
x(2)=-14.50782302823195_p
w(2)=2.718737290842550_p
x(3)=-11.2079802857006_p
w(3)=3.797315405796552_p
x(4)=-7.112457783702427_p
w(4)=4.273209107141177_p
x(5)=-2.937858999268074_p
w(5)=3.711687467536083_p
x(6)=6.331295602121447e-1_p
w(6)=1.217642420534987_p
x(7)=4.910105124428366_p
w(7)=3.882114238040014e-2_p
x(8)=11.65929788171535_p
w(8)=7.448594527753904e-5_p
else if(N==9)then
x(1)=-16.58974877361251_p
w(1)=1.046799686393621_p
x(2)=-14.89097644149148_p
w(2)=2.318123333617474_p
x(3)=-12.045181192117_p
w(3)=3.315439264728052_p
x(4)=-8.399023240045732_p
w(4)=3.894752299191076_p
x(5)=-4.447157613550310_p
w(5)=3.845425842238668_p
x(6)=-8.520862416790914e-1_p
w(6)=2.301434973319347_p
x(7)=2.602310003752245_p
w(7)=2.747323673405432e-1_p
x(8)=7.487206024726905_p
w(8)=3.288695166510330e-3_p
x(9)=14.75027982708148_p
w(9)=3.579403393102528e-6_p
else if(N==10)then
x(1)=-16.6484678125532_p
w(1)=8.978678030461930e-1_p
x(2)=-15.18509565214001_p
w(2)=2.005800374690358_p
x(3)=-12.70234306441824_p
w(3)=2.918032159066643_p
x(4)=-9.449242283899782_p
w(4)=3.529284790531605_p
x(5)=-5.780347404786681_p
w(5)=3.715236353939743_p
x(6)=-2.194149847720718_p
w(6)=3.009782584675076_p
x(7)=9.771265193601897e-1_p
w(7)=8.871499608475529e-1_p
x(8)=4.813990263153366_p
w(8)=3.660857999218996e-2_p
x(9)=10.18432293702894_p
w(9)=2.372605689048218e-4_p
x(10)=17.80427026626857_p
w(10)=1.740404181208218e-7_p
else if(N==11)then
x(1)=-16.69479354373844_p
w(1)=7.801367151946080e-1_p
x(2)=-15.41913549760866_p
w(2)=1.754395788640768_p
x(3)=-13.23404307918202_p
w(3)=2.585079262238545_p
x(4)=-10.32308691328022_p
w(4)=3.193336134914311_p
x(5)=-6.947816444989235_p
w(5)=3.495129430022783_p
x(6)=-3.469373102296100_p
w(6)=3.269215693500169_p
x(7)=-3.297855903142134e-1_p
w(7)=1.722979072578296_p
x(8)=2.873221691109419_p
w(8)=1.958930059390241e-1_p
x(9)=7.164848210790261_p
w(9)=3.817808619128344e-3_p
x(10)=12.8514088347315_p
w(10)=1.711902715646806e-5_p
x(11)=20.56931793983553_p
w(11)=1.072389569968300e-8_p
else if(N==12)then
x(1)=-16.73241816805961_p
w(1)=6.843706311410688e-1_p
x(2)=-15.61048989447662_p
w(2)=1.547016898916139_p
x(3)=-13.67437679504836_p
w(3)=2.302120010774307_p
x(4)=-11.06212048094306_p
w(4)=2.889593405410873_p
x(5)=-7.970750091299169_p
w(5)=3.248468916473929_p
x(6)=-4.666419358555016_p
w(6)=3.265148152557019_p
x(7)=-1.522426424764124_p
w(7)=2.415758710783237_p
x(8)=1.373979894751718_p
w(8)=6.173785725729287e-1_p
x(9)=4.907812401072671_p
w(9)=2.976071382515347e-2_p
x(10)=9.511536172423263_p
w(10)=3.826029859358447e-4_p
x(11)=15.3427477034047_p
w(11)=1.424903157827825e-6_p
x(12)=22.78437054324597_p
w(12)=1.054935758066363e-9_p
else if(N==13)then
x(1)=-16.76352949581637_p
w(1)=6.050862456866907e-1_p
x(2)=-15.76955365508878_p
w(2)=1.373437988031962_p
x(3)=-14.04409472240596_p
w(3)=2.059823528245484_p
x(4)=-11.69271929708032_p
w(4)=2.617778876981781_p
x(5)=-8.866401011155338_p
w(5)=3.001339966296074_p
x(6)=-5.766075405113495_p
w(6)=3.143403646216221_p
x(7)=-2.672632369257421_p
w(7)=2.777870256399753_p
x(8)=1.365110109743294e-1_p
w(8)=1.276403918431034_p
x(9)=3.138649452612083_p
w(9)=1.408401872929923e-1_p
x(10)=6.985903915536170_p
w(10)=3.974015795135429e-3_p
x(11)=11.75548788356508_p
w(11)=4.126092577590824e-5_p
x(12)=17.55802930888166_p
w(12)=1.509162111058219e-7_p
x(13)=24.37011289650649_p
w(13)=1.795706260969548e-10_p
else if(N==14)then
x(1)=-16.78955572817559_p
w(1)=5.386961206084608e-1_p
x(2)=-15.90317905826893_p
w(2)=1.226819275226785_p
x(3)=-14.35716578337516_p
w(3)=1.851499189524801_p
x(4)=-12.23347377034182_p
w(4)=2.376315396698511_p
x(5)=-9.649536046535481_p
w(5)=2.765759982881971_p
x(6)=-6.760256797151737_p
w(6)=2.975191575165067_p
x(7)=-3.775044679764330_p
w(7)=2.874969006543946_p
x(8)=-9.744427478849366e-1_p
w(8)=1.925757146426361_p
x(9)=1.716790391217804_p
w(9)=4.395286170949498e-1_p
x(10)=4.981870693158291_p
w(10)=2.492478579589616e-2_p
x(11)=9.021738695146306_p
w(11)=5.338157245068706e-4_p
x(12)=13.83662133411019_p
w(12)=5.108337766920542e-6_p
x(13)=19.45159513175038_p
w(13)=2.132059072208792e-8_p
x(14)=25.43293139556784_p
w(14)=4.907088556505981e-11_p
else if(N==15)then
x(1)=-16.8115334877381_p
w(1)=4.825889779676154e-1_p
x(2)=-16.01640282971642_p
w(2)=1.102038895374667_p
x(3)=-14.62414115071885_p
w(3)=1.671693952986789_p
x(4)=-12.69925648411757_p
w(4)=2.162641120049478_p
x(5)=-10.3343424433416_p
w(5)=2.546955199170531_p
x(6)=-7.650893408220854_p
w(6)=2.792484412820678_p
x(7)=-4.808330619604634_p
w(7)=2.830825681715152_p
x(8)=-2.031933665437543_p
w(8)=2.349146150722710_p
x(9)=5.318410389474758e-1_p
w(9)=9.513277790693682e-1_p
x(10)=3.353350116387111_p
w(10)=1.061232236616285e-1_p
x(11)=6.834030738936702_p
w(11)=4.096745352000001e-3_p
x(12)=10.96149011618397_p
w(12)=7.714434250907676e-5_p
x(13)=15.7198037091072_p
w(13)=7.540963565459164e-7_p
x(14)=21.02006680529454_p
w(14)=4.050233292192866e-9_p
x(15)=26.13251537853836_p
w(15)=1.896895734529016e-11_p
else if(N==16)then
x(1)=-16.830251840033_p
w(1)=4.347718702875771e-1_p
x(2)=-16.11310402291665_p
w(2)=9.950851979571200e-1_p
x(3)=-14.85335069756818_p
w(3)=1.515820310210710_p
x(4)=-13.10240348270851_p
w(4)=1.973750974902232_p
x(5)=-10.9341783673239_p
w(5)=2.346596903776241_p
x(6)=-8.445356083961245_p
w(6)=2.610018594883282_p
x(7)=-5.760177914652518_p
w(7)=2.723387257928971_p
x(8)=-3.049893650171958_p
w(8)=2.528407277046500_p
x(9)=-5.173015051719135e-1_p
w(9)=1.527857812228843_p
x(10)=2.009643663048431_p
w(10)=3.221124823044088e-1_p
x(11)=5.034895993043969_p
w(11)=2.149223965684383e-2_p
x(12)=8.637828802238372_p
w(12)=6.865169139905573e-4_p
x(13)=12.77127940806858_p
w(13)=1.246696683414240e-5_p
x(14)=17.38844797264972_p
w(14)=1.353106188995868e-7_p
x(15)=22.28915078572077_p
w(15)=1.015212719178305e-9_p
x(16)=26.59870796267533_p
w(16)=9.298996348309311e-12_p
else if(N==17)then
x(1)=-16.84632056573593_p
w(1)=3.937013485635673e-1_p
x(2)=-16.19630890734145_p
w(2)=9.027863572024588e-1_p
x(3)=-15.05142205789717_p
w(3)=1.380052671295282_p
x(4)=-13.45310228055327_p
w(4)=1.806636988088276_p
x(5)=-11.46102304600706_p
w(5)=2.164543709522831_p
x(6)=-9.153086866305800_p
w(6)=2.434743923662332_p
x(7)=-6.628031473295874_p
w(7)=2.590380667495643_p
x(8)=-4.016874213297763_p
w(8)=2.551156276180338_p
x(9)=-1.501017953232757_p
w(9)=1.973482074465043_p
x(10)=8.751872791303276e-1_p
w(10)=7.153275285335290e-1_p
x(11)=3.532107951611910_p
w(11)=8.288908874532536e-2_p
x(12)=6.707771495518507_p
w(12)=4.174130942256027e-3_p
x(13)=10.3569688155341_p
w(13)=1.229416221737298e-4_p
x(14)=14.43099130143937_p
w(14)=2.305115170364685e-6_p
x(15)=18.84136979415503_p
w(15)=2.963477704071838e-8_p
x(16)=23.30085347964576_p
w(16)=3.243281038935922e-10_p
x(17)=26.91757669635059_p
w(17)=5.354015113007037e-12_p
else
call GD(-17)
end if
end subroutine GF_m17

! [-16kT;28kT]
subroutine GF_m16(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-12.40753460195703_p
w(1)=8.484775125724978_p
x(2)=-2.804962848219656_p
w(2)=7.515224986809500_p
else if(N==3)then
x(1)=-13.9787182142392_p
w(1)=4.977655047319623_p
x(2)=-7.080128268643413_p
w(2)=7.821265258603025_p
x(3)=-4.368117643368741e-1_p
w(3)=3.201079806611829_p
else if(N==4)then
x(1)=-14.68161023267251_p
w(1)=3.300497530828788_p
x(2)=-9.754470842368153_p
w(2)=6.133926331375928_p
x(3)=-3.491670944953670_p
w(3)=5.588154830916742_p
x(4)=1.480174113414314_p
w(4)=9.774214194130190e-1_p
else if(N==5)then
x(1)=-15.05629813790186_p
w(1)=2.381842065623454_p
x(2)=-11.37016808763745_p
w(2)=4.780896476879587_p
x(3)=-6.049158968076861_p
w(3)=5.508457861208090_p
x(4)=-1.069082615747287_p
w(4)=3.171146259310663_p
x(5)=3.666224297524180_p
w(5)=1.576574495126827e-1_p
else if(N==6)then
x(1)=-15.28102180540201_p
w(1)=1.823107259821887_p
x(2)=-12.40168751936688_p
w(2)=3.818111503080693_p
x(3)=-7.962431420954138_p
w(3)=4.862413472420578_p
x(4)=-3.147287394272400_p
w(4)=4.305583796816763_p
x(5)=8.788901606406951e-1_p
w(5)=1.176649778641766_p
x(6)=6.247017483810234_p
w(6)=1.413430175278960e-2_p
else if(N==7)then
x(1)=-15.42749991183626_p
w(1)=1.455906314735240_p
x(2)=-13.09888812902677_p
w(2)=3.129646885205930_p
x(3)=-9.365211187070237_p
w(3)=4.214336652029260_p
x(4)=-4.965352435699794_p
w(4)=4.376265746934819_p
x(5)=-9.243787391679413e-1_p
w(5)=2.590398739800357_p
x(6)=2.945708078186544_p
w(6)=2.325490051860427e-1_p
x(7)=9.103476186395410_p
w(7)=8.967686428287210e-4_p
else if(N==8)then
x(1)=-15.52907492121878_p
w(1)=1.199920819469023_p
x(2)=-13.59368359511283_p
w(2)=2.624236694102729_p
x(3)=-10.41041272000938_p
w(3)=3.660437059782171_p
x(4)=-6.468991077494419_p
w(4)=4.099360776149599_p
x(5)=-2.482242839832992_p
w(5)=3.427142484182930_p
x(6)=9.821472295323174e-1_p
w(6)=9.630668608389149e-1_p
x(7)=5.335103262825204_p
w(7)=2.578887989233609e-2_p
x(8)=12.13361023078497_p
w(8)=4.653811677377438e-5_p
else if(N==9)then
x(1)=-15.60310138746962_p
w(1)=1.012683327872218_p
x(2)=-13.96003393508051_p
w(2)=2.241602509090875_p
x(3)=-11.20951531854186_p
w(3)=3.202564480208657_p
x(4)=-7.691638416133805_p
w(4)=3.750806719319810_p
x(5)=-3.899157721164221_p
w(5)=3.639702749363963_p
x(6)=-4.657632525059913e-1_p
w(6)=1.959234531617730_p
x(7)=3.008591260523931_p
w(7)=1.913363457298422e-1_p
x(8)=7.958806045811489_p
w(8)=2.067273527069523e-3_p
x(9)=15.24966434689971_p
w(9)=2.175804311238150e-6_p
else if(N==10)then
x(1)=-15.65948253864256_p
w(1)=8.697000073809464e-1_p
x(2)=-14.24227361782329_p
w(2)=1.942150037418877_p
x(3)=-11.83927819011686_p
w(3)=2.822963691575010_p
x(4)=-8.694964710149350_p
w(4)=3.407056719037377_p
x(5)=-5.161544253047256_p
w(5)=3.555808973253475_p
x(6)=-1.738225824910733_p
w(6)=2.711746936403179_p
x(7)=1.368022601766570_p
w(7)=6.669387617859038e-1_p
x(8)=5.272997858704562_p
w(8)=2.348966475540727e-2_p
x(9)=10.67803294780032_p
w(9)=1.452148179267571e-4_p
x(10)=18.29524558435405_p
w(10)=1.061063762931501e-7_p
else if(N==11)then
x(1)=-15.70411601249426_p
w(1)=7.562817474925867e-1_p
x(2)=-14.46765482372069_p
w(2)=1.700210401867348_p
x(3)=-12.35075950859095_p
w(3)=2.503445057798523_p
x(4)=-9.533674832302079_p
w(4)=3.087613239606301_p
x(5)=-6.275503115675370_p
w(5)=3.362902526390834_p
x(6)=-2.941330722584017_p
w(6)=3.051950896604351_p
x(7)=7.343533332518579e-2_p
w(7)=1.403863126531237_p
x(8)=3.310409152805466_p
w(8)=1.313556883069954e-1_p
x(9)=7.647929748705693_p
w(9)=2.366940097549167e-3_p
x(10)=13.33993093047394_p
w(10)=1.048098294028445e-5_p
x(11)=21.00110756451632_p
w(11)=6.855811110932644e-9_p
else if(N==12)then
x(1)=-15.74044623092601_p
w(1)=6.638185391478844e-1_p
x(2)=-14.65235221421581_p
w(2)=1.500155914192505_p
x(3)=-12.77540826100466_p
w(3)=2.231072566547563_p
x(4)=-10.24515105976144_p
w(4)=2.797016483557961_p
x(5)=-7.256348941877399_p
w(5)=3.134595832408988_p
x(6)=-4.077117529278595_p
w(6)=3.104086876426449_p
x(7)=-1.074819492237901_p
w(7)=2.106263538039791_p
x(8)=1.790761490434198_p
w(8)=4.439292745846203e-1_p
x(9)=5.377268233141497_p
w(9)=1.882456120428707e-2_p
x(10)=9.995544811449244_p
w(10)=2.356326138557971e-4_p
x(11)=15.8019362053564_p
w(11)=8.930799213514681e-7_p
x(12)=23.12038826642818_p
w(12)=7.306517015586550e-10_p
else if(N==13)then
x(1)=-15.77051933369309_p
w(1)=5.871857552026278e-1_p
x(2)=-14.80605599493803_p
w(2)=1.332502749575346_p
x(3)=-13.13241352613051_p
w(3)=1.997454205025562_p
x(4)=-10.85323551750328_p
w(4)=2.536080968165385_p
x(5)=-8.117535314943435_p
w(5)=2.901384902003173_p
x(6)=-5.126605544120794_p
w(6)=3.014754407591072_p
x(7)=-2.165870709811896_p
w(7)=2.540425347302193_p
x(8)=5.526237081429564e-1_p
w(8)=9.954713203727080e-1_p
x(9)=3.591260909890580_p
w(9)=9.225041101822226e-2_p
x(10)=7.465643568409961_p
w(10)=2.464274699791334e-3_p
x(11)=12.22450678785365_p
w(11)=2.567310957986766e-5_p
x(12)=17.9719400632119_p
w(12)=9.833371450911256e-8_p
x(13)=24.61031599362335_p
w(13)=1.351025718295159e-10_p
else if(N==14)then
x(1)=-15.79569248194146_p
w(1)=5.229759133596460e-1_p
x(2)=-14.93526424018833_p
w(2)=1.190785412070615_p
x(3)=-13.43495493636231_p
w(3)=1.796379765629849_p
x(4)=-11.37522563037834_p
w(4)=2.303785619623211_p
x(5)=-8.871859870511724_p
w(5)=2.677071523592079_p
x(6)=-6.079324337239432_p
w(6)=2.866385508936850_p
x(7)=-3.211284783016547_p
w(7)=2.702947600662251_p
x(8)=-5.301610257023227e-1_p
w(8)=1.618664529834486_p
x(9)=2.152585569359180_p
w(9)=3.050245732099416e-1_p
x(10)=5.455464089966699_p
w(10)=1.564552017755991e-2_p
x(11)=9.496655861274849_p
w(11)=3.308828105575570e-4_p
x(12)=14.27953310249364_p
w(12)=3.248029659905436e-6_p
x(13)=19.81229568051962_p
w(13)=1.455830008752572e-8_p
x(14)=25.59901961211213_p
w(14)=3.947106443316868e-11_p
else if(N==15)then
x(1)=-15.81696089294755_p
w(1)=4.686827077276089e-1_p
x(2)=-15.04480649701032_p
w(2)=1.070102015062698_p
x(3)=-13.69311886832891_p
w(3)=1.622682910815740_p
x(4)=-11.8252261937592_p
w(4)=2.097897790208504_p
x(5)=-9.532350450103499_p
w(5)=2.467679013278184_p
x(6)=-6.935235273820394_p
w(6)=2.697391840476931_p
x(7)=-4.195690505169830_p
w(7)=2.699655914181178_p
x(8)=-1.539965190372801_p
w(8)=2.092917780549377_p
x(9)=9.621398356742943e-1_p
w(9)=7.120827454109372e-1_p
x(10)=3.816949423748012_p
w(10)=6.831933697448109e-2_p
x(11)=7.311858708323054_p
w(11)=2.539203724003736e-3_p
x(12)=11.42115791931085_p
w(12)=4.835741486917676e-5_p
x(13)=16.12901902458591_p
w(13)=4.937898561349891e-7_p
x(14)=21.32623607155741_p
w(14)=2.904097891629940e-9_p
x(15)=26.24778079058094_p
w(15)=1.601215403634109e-11_p
else if(N==16)then
x(1)=-15.83508408999013_p
w(1)=4.223882086146834e-1_p
x(2)=-15.138412978333_p
w(2)=9.666003823833274e-1_p
x(3)=-13.9148971564102_p
w(3)=1.471989478671526_p
x(4)=-12.21500699680358_p
w(4)=1.915657949159431_p
x(5)=-10.11152086221492_p
w(5)=2.275315726488536_p
x(6)=-7.700288743642736_p
w(6)=2.525381071579215_p
x(7)=-5.106590147763161_p
w(7)=2.616210363036963_p
x(8)=-2.506260373734509_p
w(8)=2.339566720059104_p
x(9)=-7.060676174782762e-2_p
w(9)=1.235829732246819_p
x(10)=2.460880409668922_p
w(10)=2.172194356082260e-1_p
x(11)=5.511989196459750_p
w(11)=1.340638265926517e-2_p
x(12)=9.108405557638415_p
w(12)=4.266037771497478e-4_p
x(13)=13.20826121760224_p
w(13)=7.965807248367789e-6_p
x(14)=17.75959252093876_p
w(14)=9.167238861544347e-8_p
x(15)=22.54438445908893_p
w(15)=7.624752169811032e-10_p
x(16)=26.68048359698593_p
w(16)=8.117606893910406e-12_p
else if(N==17)then
x(1)=-15.85064920473551_p
w(1)=3.826065702708952e-1_p
x(2)=-15.218995086522_p
w(2)=8.772328222080914e-1_p
x(3)=-14.10665349685348_p
w(3)=1.340644048548636_p
x(4)=-12.55430729889024_p
w(4)=1.754256372546843_p
x(5)=-10.62068463166261_p
w(5)=2.100126481888959_p
x(6)=-8.382880801360635_p
w(6)=2.358582163059348_p
x(7)=-5.939910716970120_p
w(7)=2.498354471713404_p
x(8)=-3.426400939615573_p
w(8)=2.411559762535838_p
x(9)=-1.017972243155969_p
w(9)=1.705347460813121_p
x(10)=1.319417761399383_p
w(10)=5.159746331262400e-1_p
x(11)=4.004080211960815_p
w(11)=5.265268754584497e-2_p
x(12)=7.185051801142870_p
w(12)=2.583821155186323e-3_p
x(13)=10.81246465150196_p
w(13)=7.728671391562038e-5_p
x(14)=14.84025472056817_p
w(14)=1.509338253534972e-6_p
x(15)=19.17300836308968_p
w(15)=2.081128415750374e-8_p
x(16)=23.51155040127395_p
w(16)=2.538310410081724e-10_p
x(17)=26.97725039092497_p
w(17)=4.784636708905694e-12_p
else
call GD(-16)
end if
end subroutine GF_m16

! [-15kT;28kT]
subroutine GF_m15(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-11.60756997364548_p
w(1)=8.010480027324853_p
x(2)=-2.557094432178236_p
w(2)=6.989520278576729_p
else if(N==3)then
x(1)=-13.08170712977044_p
w(1)=4.723446651085627_p
x(2)=-6.541749676174058_p
w(2)=7.396058998599178_p
x(3)=-2.364727650129718e-1_p
w(3)=2.880494656216777_p
else if(N==4)then
x(1)=-13.74325973229596_p
w(1)=3.145856419364479_p
x(2)=-9.049689872517900_p
w(2)=5.837742595392529_p
x(3)=-3.109009630865167_p
w(3)=5.206260978993774_p
x(4)=1.722327073076120_p
w(4)=8.101403121507995e-1_p
else if(N==5)then
x(1)=-14.09703440595202_p
w(1)=2.278835358549069_p
x(2)=-10.57187361206311_p
w(2)=4.569442481355400_p
x(3)=-5.495875297005016_p
w(3)=5.228387715308394_p
x(4)=-7.674573253512690e-1_p
w(4)=2.806613890732672_p
x(5)=3.991071481293575_p
w(5)=1.167208599560485e-1_p
else if(N==6)then
x(1)=-14.30986072494395_p
w(1)=1.749850857668493_p
x(2)=-11.54723781495878_p
w(2)=3.661715358809424_p
x(3)=-7.294951334423238_p
w(3)=4.647650124584620_p
x(4)=-2.712718057187589_p
w(4)=3.986925567493731_p
x(5)=1.190109548276251_p
w(5)=9.442632713586963e-1_p
x(6)=6.644937913643441_p
w(6)=9.595125986617372e-3_p
else if(N==7)then
x(1)=-14.44897731754269_p
w(1)=1.401195060860355_p
x(2)=-12.20857893571433_p
w(2)=3.009989866881291_p
x(3)=-8.620821831770201_p
w(3)=4.044440368530626_p
x(4)=-4.411110154433710_p
w(4)=4.145648997704238_p
x(5)=-5.649645638270026e-1_p
w(5)=2.233403766540183_p
x(6)=3.326819059823690_p
w(6)=1.647483520497098e-1_p
x(7)=9.555701995995610_p
w(7)=5.738933351789648e-4_p
else if(N==8)then
x(1)=-14.54571422959356_p
w(1)=1.157455264274385_p
x(2)=-12.67933073422428_p
w(2)=2.529886415855473_p
x(3)=-9.612649965304364_p
w(3)=3.523155061850476_p
x(4)=-5.826619640699528_p
w(4)=3.920397970068047_p
x(5)=-2.029661239600165_p
w(5)=3.115949507815367_p
x(6)=1.351198362433595_p
w(6)=7.364124381484460e-1_p
x(7)=5.782536258312907_p
w(7)=1.671509868942993e-2_p
x(8)=12.62583064191083_p
w(8)=2.854919995739911e-5_p
else if(N==9)then
x(1)=-14.61643688227306_p
w(1)=9.786066372809296e-1_p
x(2)=-13.02903939604184_p
w(2)=2.165082127773641_p
x(3)=-10.37392862527061_p
w(3)=3.089308676305855_p
x(4)=-6.985268604333577_p
w(4)=3.604203069159121_p
x(5)=-3.355541542354188_p
w(5)=3.413900903731135_p
x(6)=-7.212625063697786e-2_p
w(6)=1.618643132117672_p
x(7)=3.439693375755827_p
w(7)=1.289802607643348e-1_p
x(8)=8.449080374364302_p
w(8)=1.274195320942438e-3_p
x(9)=15.76298656772819_p
w(9)=1.303447952326109e-6_p
else if(N==10)then
x(1)=-14.67050674251388_p
w(1)=8.415051565717606e-1_p
x(2)=-13.29952571582439_p
w(2)=1.878378473003237_p
x(3)=-10.97652579915274_p
w(3)=2.727470708645242_p
x(4)=-7.941791165178162_p
w(4)=3.283149274609533_p
x(5)=-4.546519641549036_p
w(5)=3.385548826969744_p
x(6)=-1.285454093530501_p
w(6)=2.386776781399207_p
x(7)=1.780572470684817_p
w(7)=4.823537719102153e-1_p
x(8)=5.752140029831541_p
w(8)=1.472967382065704e-2_p
x(9)=11.18560967805435_p
w(9)=8.757474420153485e-5_p
x(10)=18.79174407001074_p
w(10)=6.422778469484984e-8_p
else if(N==11)then
x(1)=-14.71346050945974_p
w(1)=7.323684232039327e-1_p
x(2)=-13.51630615889627_p
w(2)=1.645850809018044_p
x(3)=-11.46788553945344_p
w(3)=2.421387023667908_p
x(4)=-8.745353018845268_p
w(4)=2.980694694680517_p
x(5)=-5.606201648947742_p
w(5)=3.224963589590048_p
x(6)=-2.419717581008513_p
w(6)=2.806007257382504_p
x(7)=4.877563598633157e-1_p
w(7)=1.101838974858226_p
x(8)=3.770000474759026_p
w(8)=8.543939658708241e-2_p
x(9)=8.145834303759528_p
w(9)=1.443776278828542e-3_p
x(10)=13.83676963136575_p
w(10)=6.356243227504777e-6_p
x(11)=21.42797014608271_p
w(11)=4.391263716932141e-9_p
else if(N==12)then
x(1)=-14.74849749339348_p
w(1)=6.432055855375187e-1_p
x(2)=-13.6943481605117_p
w(2)=1.453125945751426_p
x(3)=-11.87682801153849_p
w(3)=2.159656299151127_p
x(4)=-9.429124614509560_p
w(4)=2.703558190101460_p
x(5)=-6.544261518007947_p
w(5)=3.017498509397841_p
x(6)=-3.493566727314245_p
w(6)=2.924713933133344_p
x(7)=-6.273500554813805e-1_p
w(7)=1.779493315829995_p
x(8)=2.229516320177861_p
w(8)=3.069350052432618e-1_p
x(9)=5.863891521563383_p
w(9)=1.166953182066442e-2_p
x(10)=10.49004658653156_p
w(10)=1.434323680822448e-4_p
x(11)=16.26446918506324_p
w(11)=5.570571663470103e-7_p
x(12)=23.44569550073488_p
w(12)=5.096961089912966e-10_p
else if(N==13)then
x(1)=-14.77752969531494_p
w(1)=5.692315788670297e-1_p
x(2)=-13.84267507522788_p
w(2)=1.291422012269815_p
x(3)=-12.22106362112625_p
w(3)=1.934781276569720_p
x(4)=-10.01452466051181_p
w(4)=2.453719996293648_p
x(5)=-7.370439285625637_p
w(5)=2.799447811619415_p
x(6)=-4.491480352020352_p
w(6)=2.876025051730738_p
x(7)=-1.664962623618218_p
w(7)=2.270884315801924_p
x(8)=9.837208967158011e-1_p
w(8)=7.441913909457902e-1_p
x(9)=4.064109205132045_p
w(9)=5.877463164733970e-2_p
x(10)=7.958148823753391_p
w(10)=1.506330800828748e-3_p
x(11)=12.70042261224999_p
w(11)=1.584525843969361e-5_p
x(12)=18.38536349682298_p
w(12)=6.399446438620086e-8_p
x(13)=24.83986697575334_p
w(13)=1.024310015169657e-10_p
else if(N==14)then
x(1)=-14.80184698202051_p
w(1)=5.072093664214242e-1_p
x(2)=-13.96744957797451_p
w(2)=1.154627874315767_p
x(3)=-12.51302398751657_p
w(3)=1.741009987196197_p
x(4)=-10.51761301205568_p
w(4)=2.230742177766078_p
x(5)=-8.095567640573542_p
w(5)=2.587063579672495_p
x(6)=-5.401604510485131_p
w(6)=2.752027041028905_p
x(7)=-2.654099475231870_p
w(7)=2.504922609134130_p
x(8)=-8.159249668538891e-2_p
w(8)=1.308720076974095_p
x(9)=2.609941373057700_p
w(9)=2.038303042625308e-1_p
x(10)=5.944460827920222_p
w(10)=9.642286134954057e-3_p
x(11)=9.980904968497370_p
w(11)=2.029383182473115e-4_p
x(12)=14.72626840235989_p
w(12)=2.054691120160081e-6_p
x(13)=20.16990444678328_p
w(13)=9.953697224957012e-9_p
x(14)=25.75693444549652_p
w(14)=3.194172815891852e-11_p
else if(N==15)then
x(1)=-14.82240381658568_p
w(1)=4.547359789036414e-1_p
x(2)=-14.07329713659146_p
w(2)=1.038058628523409_p
x(3)=-12.76233638421053_p
w(3)=1.573461879014136_p
x(4)=-10.95172802478054_p
w(4)=2.032744624483761_p
x(5)=-8.731471182419435_p
w(5)=2.387464614340665_p
x(6)=-6.222005325564792_p
w(6)=2.599057433804959_p
x(7)=-3.588501113591745_p
w(7)=2.552462850038789_p
x(8)=-1.051656208802842_p
w(8)=1.807884139422311_p
x(9)=1.409973041864812_p
w(9)=5.096622342826340e-1_p
x(10)=4.298986882311542_p
w(10)=4.288427442253726e-2_p
x(11)=7.801219422664074_p
w(11)=1.553242202414062e-3_p
x(12)=11.8872887338915_p
w(12)=3.008187011438710e-5_p
x(13)=16.5395216953861_p
w(13)=3.224906575405488e-7_p
x(14)=21.62791367937422_p
w(14)=2.087980299354129e-9_p
x(15)=26.35736209875836_p
w(15)=1.357280303815362e-11_p
else if(N==16)then
x(1)=-14.83993005738829_p
w(1)=4.099688348768369e-1_p
x(2)=-14.16379832821818_p
w(2)=9.380227160921244e-1_p
x(3)=-12.97665172932461_p
w(3)=1.427979805521559_p
x(4)=-11.32806326266928_p
w(4)=1.857230032810439_p
x(5)=-9.289779035237814_p
w(5)=2.203332711209412_p
x(6)=-6.957112193656955_p
w(6)=2.438706830383861_p
x(7)=-4.457182560509806_p
w(7)=2.499883295242261_p
x(8)=-1.969134958409496_p
w(8)=2.119143041118731_p
x(9)=3.845704888690835e-1_p
w(9)=9.558616610277572e-1_p
x(10)=2.932640706016665_p
w(10)=1.413810387541515e-1_p
x(11)=6.003062434143060_p
w(11)=8.222707030203891e-3_p
x(12)=9.587521872088766_p
w(12)=2.625058927086621e-4_p
x(13)=13.64928485908607_p
w(13)=5.063297649993502e-6_p
x(14)=18.13009823747718_p
w(14)=6.206225020355854e-8_p
x(15)=22.79471100101884_p
w(15)=5.745304260714249e-10_p
x(16)=26.75840794967047_p
w(16)=7.105564329702785e-12_p
else if(N==17)then
x(1)=-14.85499005122611_p
w(1)=3.714800507080845e-1_p
x(2)=-14.24174887629264_p
w(2)=8.515976540768244e-1_p
x(3)=-13.16206720460685_p
w(3)=1.301081347690450_p
x(4)=-11.65590219626129_p
w(4)=1.701597018569355_p
x(5)=-9.781113366674335_p
w(5)=2.035163787728534_p
x(6)=-7.614187545114557_p
w(6)=2.281048899924002_p
x(7)=-5.254979024687408_p
w(7)=2.401040159523421_p
x(8)=-2.842197373202746_p
w(8)=2.249195486897887_p
x(9)=-5.354169895160265e-1_p
w(9)=1.417682312373166_p
x(10)=1.782393542288206_p
w(10)=3.558029116029791e-1_p
x(11)=4.492863481649558_p
w(11)=3.268143113732750e-2_p
x(12)=7.672869387699370_p
w(12)=1.580011395529817e-3_p
x(13)=11.27406668734955_p
w(13)=4.823436600693146e-5_p
x(14)=15.25157649303198_p
w(14)=9.850809821167027e-7_p
x(15)=19.50270030066874_p
w(15)=1.462345242620380e-8_p
x(16)=23.71755781275731_p
w(16)=1.992971008878646e-10_p
x(17)=27.03429799833867_p
w(17)=4.283053096309470e-12_p
else
call GD(-15)
end if
end subroutine GF_m15

! [-14kT;28kT]
subroutine GF_m14(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.80652726717593_p
w(1)=7.538498986085199_p
x(2)=-2.304430752409721_p
w(2)=6.461501845442482_p
else if(N==3)then
x(1)=-12.18399784097251_p
w(1)=4.470876816764496_p
x(2)=-6.001285058713262_p
w(2)=6.968250846821342_p
x(3)=-2.478265295777841e-2_p
w(3)=2.560873167941844_p
else if(N==4)then
x(1)=-12.80448623361726_p
w(1)=2.992233712467211_p
x(2)=-8.343342180221484_p
w(2)=5.541917041008978_p
x(3)=-2.724817384222278_p
w(3)=4.809655217103774_p
x(4)=1.984897178699828_p
w(4)=6.561948609477180e-1_p
else if(N==5)then
x(1)=-13.13751722269443_p
w(1)=2.176444856382019_p
x(2)=-9.772565744513493_p
w(2)=4.358552280992192_p
x(3)=-4.942239396594837_p
w(3)=4.940451651728439_p
x(4)=-4.573504984957215e-1_p
w(4)=2.440391130183142_p
x(5)=4.339912390322564_p
w(5)=8.416091224189093e-2_p
else if(N==6)then
x(1)=-13.33854901517998_p
w(1)=1.676961503723794_p
x(2)=-10.69217281043786_p
w(2)=3.505715019244349_p
x(3)=-6.627103947905166_p
w(3)=4.430108500879272_p
x(4)=-2.279232422755374_p
w(4)=3.645544352455768_p
x(5)=1.522823821959943_p
w(5)=7.353091798791018e-1_p
x(6)=7.065350408355253_p
w(6)=6.362275345397370e-3_p
else if(N==7)then
x(1)=-13.47036832260463_p
w(1)=1.346693456432247_p
x(2)=-11.31792260596336_p
w(2)=2.890549782481954_p
x(3)=-7.876228673386275_p
w(3)=3.873321401121956_p
x(4)=-3.859178822693372_p
w(4)=3.899392769366922_p
x(5)=-1.971297626828993e-1_p
w(5)=1.876576227025781_p
x(6)=3.733958623895236_p
w(6)=1.131076009400847e-1_p
x(7)=10.02852356527376_p
w(7)=3.595941587376101e-4_p
else if(N==8)then
x(1)=-13.56231153552147_p
w(1)=1.115089653226221_p
x(2)=-11.76482550489643_p
w(2)=2.435598180504632_p
x(3)=-8.814908489020450_p
w(3)=3.385128270390227_p
x(4)=-5.186070753340053_p
w(4)=3.733778449939111_p
x(5)=-1.579328219973518_p
w(5)=2.777390426542255_p
x(6)=1.743712955181886_p
w(6)=5.424309520921465e-1_p
x(7)=6.252916106148296_p
w(7)=1.056771036905412e-2_p
x(8)=13.13637654137199_p
w(8)=1.718846403492388e-5_p
else if(N==9)then
x(1)=-13.62976604403933_p
w(1)=9.445410655353659e-1_p
x(2)=-12.09805573655489_p
w(2)=2.088478724168650_p
x(3)=-9.538616619737457_p
w(3)=2.975429173004156_p
x(4)=-6.280491424586798_p
w(4)=3.453588587904737_p
x(5)=-2.817129435970624_p
w(5)=3.162036900471376_p
x(6)=3.331109047397113e-1_p
w(6)=1.290986161974994_p
x(7)=3.896358415248447_p
w(7)=8.416944420007458e-2_p
x(8)=8.958151045739877_p
w(8)=7.700045168310629e-4_p
x(9)=16.28984417696125_p
w(9)=7.697514980610663e-7_p
else if(N==10)then
x(1)=-13.68155025644637_p
w(1)=8.132573832466160e-1_p
x(2)=-12.35690789886759_p
w(2)=1.814414034901178_p
x(3)=-10.11425003789527_p
w(3)=2.631373882358577_p
x(4)=-7.190161074445337_p
w(4)=3.156803035009462_p
x(5)=-3.936327134619197_p
w(5)=3.199688311129395_p
x(6)=-8.334158014391398e-1_p
w(6)=2.040391782947099_p
x(7)=2.217485245157510_p
w(7)=3.349888772787274e-1_p
x(8)=6.251259292765432_p
w(8)=9.031432449211370e-3_p
x(9)=11.70670074579768_p
w(9)=5.205355829600365e-5_p
x(10)=19.29219374939433_p
w(10)=3.864912056058459e-8_p
else if(N==11)then
x(1)=-13.72283438304819_p
w(1)=7.083773824232591e-1_p
x(2)=-12.56513133450788_p
w(2)=1.591263549441751_p
x(3)=-10.58554285174097_p
w(3)=2.338777586177631_p
x(4)=-7.958435489331482_p
w(4)=2.872128726129094_p
x(5)=-4.940743033273217_p
w(5)=3.078535153022838_p
x(6)=-1.904452693024010_p
w(6)=2.527020707913372_p
x(7)=9.178806597801393e-1_p
w(7)=8.290541708436168e-1_p
x(8)=4.252025048443998_p
w(8)=5.397299506567115e-2_p
x(9)=8.658285261305949_p
w(9)=8.667373440047442e-4_p
x(10)=14.34128748137825_p
w(10)=3.820344407322654e-6_p
x(11)=21.84814417555849_p
w(11)=2.822037352319561e-9_p
else if(N==12)then
x(1)=-13.75657739458547_p
w(1)=6.225174047888530e-1_p
x(2)=-12.73650880619064_p
w(2)=1.405887167041082_p
x(3)=-10.97872634570881_p
w(3)=2.087778565734038_p
x(4)=-8.614268864302739_p
w(4)=2.608931217037983_p
x(5)=-5.835088028575931_p
w(5)=2.895639874790697_p
x(6)=-2.916672847646852_p
w(6)=2.720432103527095_p
x(7)=-1.759366303354894e-1_p
w(7)=1.447546120443873_p
x(8)=2.691889206458778_p
w(8)=2.040868133905984e-1_p
x(9)=6.367348019691886_p
w(9)=7.094898498896990e-3_p
x(10)=10.99470411600815_p
w(10)=8.631992300169513e-5_p
x(11)=16.72964043530341_p
w(11)=3.459931840040578e-7_p
x(12)=23.75943030558497_p
w(12)=3.583800233937117e-10_p
else if(N==13)then
x(1)=-13.78456502254061_p
w(1)=5.512119871590333e-1_p
x(2)=-12.87943616136047_p
w(2)=1.250163609501263_p
x(3)=-11.31011747252428_p
w(3)=1.871732879577265_p
x(4)=-9.176763251526973_p
w(4)=2.370498937623643_p
x(5)=-6.625555511953011_p
w(5)=2.694648299932262_p
x(6)=-3.861689369516761_p
w(6)=2.722439396171227_p
x(7)=-1.168322541682597_p
w(7)=1.970334474635996_p
x(8)=1.433955788187923_p
w(8)=5.315705368619658e-1_p
x(9)=4.556901714028167_p
w(9)=3.648297555961608e-2_p
x(10)=8.463118025569281_p
w(10)=9.079888322919305e-4_p
x(11)=13.18282665981465_p
w(11)=9.703975401425216e-6_p
x(12)=18.7976316430707_p
w(12)=4.161944909925881e-8_p
x(13)=25.05866564003422_p
w(13)=7.826849536362886e-11_p
else if(N==14)then
x(1)=-13.80802306332418_p
w(1)=4.913863683282893e-1_p
x(2)=-12.99975671564709_p
w(2)=1.118319399971517_p
x(3)=-11.59143393322876_p
w(3)=1.685331544208172_p
x(4)=-9.660779209484947_p
w(4)=2.157041454155715_p
x(5)=-7.320997580773809_p
w(5)=2.495200279281944_p
x(6)=-4.727912835799614_p
w(6)=2.629239776482273_p
x(7)=-2.103800402342540_p
w(7)=2.274561032583448_p
x(8)=3.761893445726414e-1_p
w(8)=1.011592837322838_p
x(9)=3.089618789057667_p
w(9)=1.313643606412823e-1_p
x(10)=6.448436907026220_p
w(10)=5.839283852488312e-3_p
x(11)=10.47416353778709_p
w(11)=1.231941837983824e-4_p
x(12)=15.17637146667382_p
w(12)=1.293672550052639e-6_p
x(13)=20.52387679942919_p
w(13)=6.817363966706433e-9_p
x(14)=25.90684711922979_p
w(14)=2.600185715572911e-11_p
else if(N==15)then
x(1)=-13.82786561438802_p
w(1)=4.407399563532560e-1_p
x(2)=-13.10189355258834_p
w(2)=1.005885280162475_p
x(3)=-11.83184587462454_p
w(3)=1.523982510041177_p
x(4)=-10.07888087926138_p
w(4)=1.967072336718131_p
x(5)=-7.931970581727064_p
w(5)=2.305964531574643_p
x(6)=-5.511832765669891_p
w(6)=2.495804275918415_p
x(7)=-2.987731585394203_p
w(7)=2.382579269827844_p
x(8)=-5.638596657265410e-1_p
w(8)=1.502296610178716_p
x(9)=1.878497166735085_p
w(9)=3.484251650376847e-1_p
x(10)=4.798961556799301_p
w(10)=2.629400450337230e-2_p
x(11)=8.301759965948358_p
w(11)=9.381031115043253e-4_p
x(12)=12.35952706868292_p
w(12)=1.857643980176424e-5_p
x(13)=16.95085952661682_p
w(13)=2.101433391482138e-7_p
x(14)=21.92472415687857_p
w(14)=1.505771087571280e-9_p
x(15)=26.46145122347813_p
w(15)=1.155119119495959e-11_p
else if(N==16)then
x(1)=-13.84479268830414_p
w(1)=3.975060013993785e-1_p
x(2)=-13.18927648288483_p
w(2)=9.093318926416410e-1_p
x(3)=-12.03865937415285_p
w(3)=1.383750669591829_p
x(4)=-10.44167226387071_p
w(4)=1.798381401649160_p
x(5)=-8.469166814371841_p
w(5)=2.130409304646783_p
x(6)=-6.216309771025914_p
w(6)=2.348994829071136_p
x(7)=-3.812939963464645_p
w(7)=2.369725678443052_p
x(8)=-1.437743191706296_p
w(8)=1.864239259484615_p
x(9)=8.532054892739254e-1_p
w(9)=7.034985145382037e-1_p
x(10)=3.425054882187498_p
w(10)=8.903663371998527e-2_p
x(11)=6.507626371613488_p
w(11)=4.963396258166240e-3_p
x(12)=10.07484650749889_p
w(12)=1.600050079281301e-4_p
x(13)=14.0939812855208_p
w(13)=3.202635696025763e-6_p
x(14)=18.49956276078881_p
w(14)=4.199946880151514e-8_p
x(15)=23.03991203598988_p
w(15)=4.344032616801961e-10_p
x(16)=26.83262786748036_p
w(16)=6.235648136396103e-12_p
else if(N==17)then
x(1)=-13.85934570014872_p
w(1)=3.603149717684084e-1_p
x(2)=-13.26458465868477_p
w(2)=8.258631741146713e-1_p
x(3)=-12.21770216783446_p
w(3)=1.261330064266989_p
x(4)=-10.75797197396694_p
w(4)=1.648589846363421_p
x(5)=-8.942484674043705_p
w(5)=1.969483686111442_p
x(6)=-6.847384122291156_p
w(6)=2.201519617526162_p
x(7)=-4.574056727480674_p
w(7)=2.295523896537141_p
x(8)=-2.264851498535477_p
w(8)=2.056808983845037_p
x(9)=-4.898329752209189e-2_p
w(9)=1.124943113148390_p
x(10)=2.266221251225975_p
w(10)=2.347790814985768e-1_p
x(11)=4.997836282236426_p
w(11)=1.985893245422630e-2_p
x(12)=8.170839804364554_p
w(12)=9.549186346775272e-4_p
x(13)=11.74144681991601_p
w(13)=2.989378296659286e-5_p
x(14)=15.66459976635753_p
w(14)=6.410305364547374e-7_p
x(15)=19.83011911875286_p
w(15)=1.028420325938951e-8_p
x(16)=23.91877082125852_p
w(16)=1.569941454836501e-10_p
x(17)=27.08882051729077_p
w(17)=3.840081857947922e-12_p
else
call GD(-14)
end if
end subroutine GF_m14

! [-13kT;28kT]
subroutine GF_m13(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.00429020231689_p
w(1)=7.068991848942547_p
x(2)=-2.046000738731509_p
w(2)=5.931010411383614_p
else if(N==3)then
x(1)=-11.28554791190464_p
w(1)=4.220016808176661_p
x(2)=-5.458790530335431_p
w(2)=6.536163414974117_p
x(3)=2.003952394206888e-1_p
w(3)=2.243822037175383_p
else if(N==4)then
x(1)=-11.86528127218424_p
w(1)=2.839636086314067_p
x(2)=-7.635514179465602_p
w(2)=5.245844460305308_p
x(3)=-2.338700073008856_p
w(3)=4.396806576704136_p
x(4)=2.270582478413893_p
w(4)=5.177151370026495e-1_p
else if(N==5)then
x(1)=-12.17775176313439_p
w(1)=2.074649650651644_p
x(2)=-8.972332688774948_p
w(2)=4.147939560798585_p
x(3)=-4.388786780732106_p
w(3)=4.641274448715156_p
x(4)=-1.359882059586743e-1_p
w(4)=2.077128303294792_p
x(5)=4.714320861488017_p
w(5)=5.901029686598475e-2_p
else if(N==6)then
x(1)=-12.36709693793162_p
w(1)=1.604408332842944_p
x(2)=-9.836579500858242_p
w(2)=3.349924292009505_p
x(3)=-5.959355787142831_p
w(3)=4.208067603686321_p
x(4)=-1.846262546626045_p
w(4)=3.279983443024185_p
x(5)=1.880286344273474_p
w(5)=5.535019612668975e-1_p
x(6)=7.509266895559527_p
w(6)=4.116627496308590e-3_p
else if(N==7)then
x(1)=-12.4916850226242_p
w(1)=1.292367480240596_p
x(2)=-10.42700273445547_p
w(2)=2.771183208146871_p
x(3)=-7.131788185837318_p
w(3)=3.700104181514493_p
x(4)=-3.310377448065594_p
w(4)=3.632026844142592_p
x(5)=1.830504281801550e-1_p
w(5)=1.528905535494148_p
x(6)=4.168351450928419_p
w(6)=7.519456832471282e-2_p
x(7)=10.52270378362317_p
w(7)=2.204424627478449e-4_p
else if(N==8)then
x(1)=-12.57888001934549_p
w(1)=1.072788088449081_p
x(2)=-10.85025001913512_p
w(2)=2.341249119876808_p
x(3)=-8.017481451121972_p
w(3)=3.245836194229994_p
x(4)=-4.548262074491147_p
w(4)=3.535727589300582_p
x(5)=-1.129450698845176_p
w(5)=2.414157086182998_p
x(6)=2.162876525690719_p
w(6)=3.837186982335920e-1_p
x(7)=6.746712053218898_p
w(7)=6.515331732932285e-3_p
x(8)=13.66560975471929_p
w(8)=1.015232017384569e-5_p
else if(N==9)then
x(1)=-12.64310250463265_p
w(1)=9.104501376512932e-1_p
x(2)=-11.16716304830542_p
w(2)=2.011682273843584_p
x(3)=-8.703833086046739_p
w(3)=2.860572407135319_p
x(4)=-5.578058864600187_p
w(4)=3.296838707748412_p
x(5)=-2.284375725013424_p
w(5)=2.878246409672998_p
x(6)=7.548394064497178e-1_p
w(6)=9.885548529970475e-1_p
x(7)=4.379010271606329_p
w(7)=5.320082996194449e-2_p
x(8)=9.486066247570447_p
w(8)=4.561929965938799e-4_p
x(9)=16.82961613569628_p
w(9)=4.483189682307178e-7_p
else if(N==10)then
x(1)=-12.69262491529186_p
w(1)=7.849251819416151e-1_p
x(2)=-11.41448826016879_p
w(2)=1.750166309035670_p
x(3)=-9.252655790481034_p
w(3)=2.534423145276175_p
x(4)=-6.440640697806994_p
w(4)=3.026816138979142_p
x(5)=-3.332095254606970_p
w(5)=2.991827434753783_p
x(6)=-3.783215865658596e-1_p
w(6)=1.683152162947476_p
x(7)=2.680802625204966_p
w(7)=2.232440270539728e-1_p
x(8)=6.770137275505317_p
w(8)=5.417331494937003e-3_p
x(9)=12.24085931999675_p
w(9)=3.050568953281433e-5_p
x(10)=19.79477275362201_p
w(10)=2.315385699360971e-8_p
else if(N==11)then
x(1)=-12.73224644916658_p
w(1)=6.842850906830404e-1_p
x(2)=-11.61418110206601_p
w(2)=1.536381373643487_p
x(3)=-9.703882709240791_p
w(3)=2.255441426264914_p
x(4)=-7.173327092082872_p
w(4)=2.761205127731619_p
x(5)=-4.280145002373914_p
w(5)=2.919394795367080_p
x(6)=-1.394405534431616_p
w(6)=2.214038343606235_p
x(7)=1.368437465884610_p
w(7)=5.955832814071866e-1_p
x(8)=4.756274764741556_p
w(8)=3.315828530519696e-2_p
x(9)=9.184974733437482_p
w(9)=5.122575133235107e-4_p
x(10)=14.85278046403436_p
w(10)=2.276981866049921e-6_p
x(11)=22.25986206957894_p
w(11)=1.822212432568195e-9_p
else if(N==12)then
x(1)=-12.76469265982459_p
w(1)=6.017359932686072e-1_p
x(2)=-11.77887288232433_p
w(2)=1.358388321017081_p
x(3)=-10.08121781962897_p
w(3)=2.015311615707180_p
x(4)=-7.800881197742110_p
w(4)=2.512688581275532_p
x(5)=-5.129607769583236_p
w(5)=2.766544764343834_p
x(6)=-2.347027216452127_p
w(6)=2.484086915375896_p
x(7)=2.846098541184109e-1_p
w(7)=1.126300695676523_p
x(8)=3.178794976077681_p
w(8)=1.306604005026979e-1_p
x(9)=6.887283855558900_p
w(9)=4.233382197813157e-3_p
x(10)=11.50914452676566_p
w(10)=5.137658403628884e-5_p
x(11)=17.19669858463087_p
w(11)=2.141228160919168e-7_p
x(12)=24.0608560874925_p
w(12)=2.541439967044976e-10_p
else if(N==13)then
x(1)=-12.79163090770106_p
w(1)=5.331120155533448e-1_p
x(2)=-11.91637124161694_p
w(2)=1.208685651200771_p
x(3)=-10.39966800084341_p
w(3)=1.808210176625865_p
x(4)=-8.340182871895612_p
w(4)=2.286116411669286_p
x(5)=-5.883471987670395_p
w(5)=2.585536394089263_p
x(6)=-3.238305925571984_p
w(6)=2.547373132402781_p
x(7)=-6.728557819874771e-1_p
w(7)=1.646144277316706_p
x(8)=1.906812271128204_p
w(8)=3.621805529863505e-1_p
x(9)=5.069193183888481_p
w(9)=2.209781012624036e-2_p
x(10)=8.980229886446638_p
w(10)=5.399120645710561e-4_p
x(11)=13.67127259674525_p
w(11)=5.899165441774920e-6_p
x(12)=19.20805300984352_p
w(12)=2.706526378198259e-8_p
x(13)=25.26669580330154_p
w(13)=6.027639693114733e-11_p
else if(N==14)then
x(1)=-12.81422556405106_p
w(1)=4.754939925651101e-1_p
x(2)=-12.03221308936805_p
w(2)=1.081824514142122_p
x(3)=-10.67026292082381_p
w(3)=1.629264965941953_p
x(4)=-8.804911469154060_p
w(4)=2.082468259530790_p
x(5)=-6.548600945117676_p
w(5)=2.400597634993642_p
x(6)=-4.059258417748133_p
w(6)=2.493566223031187_p
x(7)=-1.559795397020193_p
w(7)=2.007914897461260_p
x(8)=8.485711211599042e-1_p
w(8)=7.434822975964679e-1_p
x(9)=3.591755505371173_p
w(9)=8.183728543562604e-2_p
x(10)=6.966959618382044_p
w(10)=3.477330082173339e-3_p
x(11)=10.97608237651582_p
w(11)=7.404382992317696e-5_p
x(12)=15.62935592908159_p
w(12)=8.110150961785267e-7_p
x(13)=20.87366852407227_p
w(13)=4.679521521790292e-9_p
x(14)=26.04895937263214_p
w(14)=2.128847566933341e-11_p
else if(N==15)then
x(1)=-12.83335051158595_p
w(1)=4.266833665153240e-1_p
x(2)=-12.13061952393453_p
w(2)=9.735515583183391e-1_p
x(3)=-10.90171394895889_p
w(3)=1.474179528197767_p
x(4)=-9.206839243170716_p
w(4)=1.900720420960964_p
x(5)=-7.134202366986218_p
w(5)=2.222611521630979_p
x(6)=-4.805537280433520_p
w(6)=2.384885934596760_p
x(7)=-2.394115664877165_p
w(7)=2.182211282312348_p
x(8)=-7.191233159485885e-2_p
w(8)=1.191133868539523_p
x(9)=2.369896120131787_p
w(9)=2.276798553212634e-1_p
x(10)=5.316280785297687_p
w(10)=1.577375347073989e-2_p
x(11)=8.813116182802130_p
w(11)=5.596412786846324e-4_p
x(12)=12.83749215676786_p
w(12)=1.139140334044441e-5_p
x(13)=17.36256178068473_p
w(13)=1.366807398299818e-7_p
x(14)=22.2163071130795_p
w(14)=1.089520501719797e-9_p
x(15)=26.56024661980843_p
w(15)=9.868248949852012e-12_p
else if(N==16)then
x(1)=-12.84967568587164_p
w(1)=3.849898373803465e-1_p
x(2)=-12.21486815158285_p
w(2)=8.805016615760450e-1_p
x(3)=-11.10097731255318_p
w(3)=1.339247646239410_p
x(4)=-9.555963265084202_p
w(4)=1.738988193367342_p
x(5)=-7.649967258802666_p
w(5)=2.056162501706319_p
x(6)=-5.478524022615736_p
w(6)=2.254563165855875_p
x(7)=-3.174941780553459_p
w(7)=2.219065121086329_p
x(8)=-9.098559660522039e-1_p
w(8)=1.577919274307652_p
x(9)=1.340004876649184_p
w(9)=4.911091052499155e-1_p
x(10)=3.937779122817167_p
w(10)=5.440624740508191e-2_p
x(11)=7.025194932700327_p
w(11)=2.950822484068302e-3_p
x(12)=10.57003139452043_p
w(12)=9.663843154264063e-5_p
x(13)=14.54196176855555_p
w(13)=2.016480487477151e-6_p
x(14)=18.86757689999148_p
w(14)=2.842062874225710e-8_p
x(15)=23.27978745737587_p
w(15)=3.296336691500836e-10_p
x(16)=26.90328960682723_p
w(16)=5.485404678654924e-12_p
else if(N==17)then
x(1)=-12.86371940983777_p
w(1)=3.491026543934565e-1_p
x(2)=-12.28752055817242_p
w(2)=8.000065773064134e-1_p
x(3)=-11.27360789729111_p
w(3)=1.221344248568226_p
x(4)=-9.860626090604660_p
w(4)=1.595136625861818_p
x(5)=-8.105029395847890_p
w(5)=1.902815356034051_p
x(6)=-6.082974822131168_p
w(6)=2.118937033472898_p
x(7)=-3.898156196184766_p
w(7)=2.177221251616611_p
x(8)=-1.694204007754776_p
w(8)=1.828408362959154_p
x(9)=4.467658032998168e-1_p
w(9)=8.459852059451888e-1_p
x(10)=2.771991874318033_p
w(10)=1.486222578248920e-1_p
x(11)=5.518330442162186_p
w(11)=1.183320330648469e-2_p
x(12)=8.678575725501139_p
w(12)=5.706557669548112e-4_p
x(13)=12.21426056767941_p
w(13)=1.840385658178107e-5_p
x(14)=16.07895484015686_p
w(14)=4.160452918515558e-7_p
x(15)=20.15493989767113_p
w(15)=7.240606725737413e-9_p
x(16)=24.11509971008289_p
w(16)=1.240837337371024e-10_p
x(17)=27.14091709773296_p
w(17)=3.447910832842661e-12_p
else
call GD(-13)
end if
end subroutine GF_m13

! [-12kT;28kT]
subroutine GF_m12(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-9.200741236161210_p
w(1)=6.602046581334288_p
x(2)=-1.780566058680735_p
w(2)=5.397959562858499_p
else if(N==3)then
x(1)=-10.38632282903444_p
w(1)=3.970896357447296_p
x(2)=-4.914383636500208_p
w(2)=6.097468870532322_p
x(3)=4.416798772693790e-1_p
w(3)=1.931640916213169_p
else if(N==4)then
x(1)=-10.925644989777_p
w(1)=2.688038947133392_p
x(2)=-6.926375355916938_p
w(2)=4.948533204728984_p
x(3)=-1.949879198309952_p
w(3)=3.966938556791097_p
x(4)=2.582281574102894_p
w(4)=3.964954355393131e-1_p
else if(N==5)then
x(1)=-11.21775062769485_p
w(1)=1.973404649086442_p
x(2)=-8.171322711546821_p
w(2)=3.937129094333650_p
x(3)=-3.836138068831443_p
w(3)=4.326413816535432_p
x(4)=2.001066980273389e-1_p
w(4)=1.722883922724630_p
x(5)=5.115860162596931_p
w(5)=4.017466151263272e-2_p
else if(N==6)then
x(1)=-11.3955209117745_p
w(1)=1.532141358298858_p
x(2)=-8.980589361346725_p
w(2)=3.194047654061924_p
x(3)=-5.292341692044150_p
w(3)=3.978887522344122_p
x(4)=-1.412463864216527_p
w(4)=2.891035456620067_p
x(5)=2.265734882924036_p
w(5)=4.012975408753706e-1_p
x(6)=7.977726615929170_p
w(6)=2.596611992445921e-3_p
else if(N==7)then
x(1)=-11.51294471611579_p
w(1)=1.238167404351282_p
x(2)=-9.535937806131233_p
w(2)=2.651673930048719_p
x(3)=-6.387995075735072_p
w(3)=3.523388689741472_p
x(4)=-2.765390817916396_p
w(4)=3.337319708826233_p
x(5)=5.802724596218467e-1_p
w(5)=1.200943203301748_p
x(6)=4.631043746674895_p
w(6)=4.838109574365432e-2_p
x(7)=11.03901885365516_p
w(7)=1.321121796781874e-4_p
else if(N==8)then
x(1)=-11.59543740839463_p
w(1)=1.030501237413070_p
x(2)=-9.935715224873146_p
w(2)=2.246662941399985_p
x(3)=-7.220768716652636_p
w(3)=3.104453489191088_p
x(4)=-3.914294293515599_p
w(4)=3.320812444661579_p
x(5)=-6.769157454620596e-1_p
w(5)=2.033513992813959_p
x(6)=2.611414149323144_p
w(6)=2.601399487022310e-1_p
x(7)=7.264354048830241_p
w(7)=3.916209249930699e-3_p
x(8)=14.21381393195102_p
w(8)=5.880760943734970e-6_p
else if(N==9)then
x(1)=-11.65646360506123_p
w(1)=8.762864777193219e-1_p
x(2)=-10.23646429997443_p
w(2)=1.934542916566417_p
x(3)=-7.869911906858602_p
w(3)=2.744196799169554_p
x(4)=-4.878937851274816_p
w(4)=3.130612525620764_p
x(5)=-1.756937455272801_p
w(5)=2.558627844596027_p
x(6)=1.198203816977774_p
w(6)=7.228801034470671e-1_p
x(7)=4.887814118392336_p
w(7)=3.259424182461779e-2_p
x(8)=10.03278869510307_p
w(8)=2.649775613567203e-4_p
x(9)=17.3814180522395_p
w(9)=2.576876617903681e-7_p
else if(N==10)then
x(1)=-11.70374519718223_p
w(1)=7.564691425850509e-1_p
x(2)=-10.4723512368774_p
w(2)=1.685516467016120_p
x(3)=-8.392004527556857_p
w(3)=2.436248190950949_p
x(4)=-5.693966455635881_p
w(4)=2.891237662303578_p
x(5)=-2.734826846201832_p
w(5)=2.754197776725592_p
x(6)=8.499349830952839e-2_p
w(6)=1.330309426956014_p
x(7)=3.171820429600390_p
w(7)=1.428293898742092e-1_p
x(8)=7.308507846242303_p
w(8)=3.180439567133619e-3_p
x(9)=12.78754158191687_p
w(9)=1.763438200530406e-5_p
x(10)=20.29741659566219_p
w(10)=1.383213415690340e-8_p
else if(N==11)then
x(1)=-11.74170756589315_p
w(1)=6.600618461309991e-1_p
x(2)=-10.66351875849505_p
w(2)=1.481115524850058_p
x(3)=-8.823098741387536_p
w(3)=2.171121590839132_p
x(4)=-6.390561012654502_p
w(4)=2.646759414331968_p
x(5)=-3.625583831699781_p
w(5)=2.741372968308749_p
x(6)=-8.869057591779611e-1_p
w(6)=1.872054994499020_p
x(7)=1.843504222669245_p
w(7)=4.073826992141225e-1_p
x(8)=5.282388570408897_p
w(8)=1.983760146131150e-2_p
x(9)=9.725563792241633_p
w(9)=2.981567511558248e-4_p
x(10)=15.37047915265871_p
w(10)=1.346622396946528e-6_p
x(11)=22.66139405636725_p
w(11)=1.183874929270660e-9_p
else if(N==12)then
x(1)=-11.7728518086696_p
w(1)=5.808379673922487e-1_p
x(2)=-10.82148989350731_p
w(2)=1.310560439618493_p
x(3)=-9.184451659556512_p
w(3)=1.942068398218198_p
x(4)=-6.989358908240087_p
w(4)=2.414098353639387_p
x(5)=-4.428814138309607_p
w(5)=2.626261314222519_p
x(6)=-1.784436474107651_p
w(6)=2.209981527425476_p
x(7)=7.601653659440180e-1_p
w(7)=8.329850637492451e-1_p
x(8)=3.690505979862359_p
w(8)=8.070224174861418e-2_p
x(9)=7.423333819831501_p
w(9)=2.480453512332228e-3_p
x(10)=12.03295783118613_p
w(10)=3.025236404906322e-5_p
x(11)=17.66484849891073_p
w(11)=1.321203619824096e-7_p
x(12)=24.34937420807247_p
w(12)=1.818626663616942e-10_p
else if(N==13)then
x(1)=-11.79873452335747_p
w(1)=5.149119858047214e-1_p
x(2)=-10.9535216213221_p
w(2)=1.166931430123693_p
x(3)=-9.489836966745743_p
w(3)=1.744069573243769_p
x(4)=-7.505093880569437_p
w(4)=2.200084456840614_p
x(5)=-5.144969481585376_p
w(5)=2.469694593635835_p
x(6)=-2.622272175548475_p
w(6)=2.342567116738680_p
x(7)=-1.737702589679248e-1_p
w(7)=1.312926803860907_p
x(8)=2.404780779461663_p
w(8)=2.354203802119449e-1_p
x(9)=5.600456168347513_p
w(9)=1.307941394992950e-2_p
x(10)=9.509142147588488_p
w(10)=3.168109316723940e-4_p
x(11)=14.1652760644968_p
w(11)=3.561194865629913e-6_p
x(12)=19.61591699154136_p
w(12)=1.760937002682591e-8_p
x(13)=25.4640205018446_p
w(13)=4.678415842961850e-11_p
else if(N==14)then
x(1)=-11.82046069119938_p
w(1)=4.595152332898280e-1_p
x(2)=-11.06485410566534_p
w(2)=1.045095334813506_p
x(3)=-9.749613094889606_p
w(3)=1.572696140665151_p
x(4)=-7.950259724644886_p
w(4)=2.006679963607607_p
x(5)=-5.778985654440588_p
w(5)=2.301755314697559_p
x(6)=-3.396799954719531_p
w(6)=2.338421864942967_p
x(7)=-1.019992514108290_p
w(7)=1.706804175663743_p
x(8)=1.340732634212103_p
w(8)=5.175460707875277e-1_p
x(9)=4.116025716548825_p
w(9)=4.940985250466714e-2_p
x(10)=7.499593552176291_p
w(10)=2.037607386755414e-3_p
x(11)=11.48628536392218_p
w(11)=4.407613525336445e-5_p
x(12)=16.08470631905885_p
w(12)=5.064601453181460e-7_p
x(13)=21.21874115094678_p
w(13)=3.220551587966555e-9_p
x(14)=26.18349902517742_p
w(14)=1.752645068403750e-11_p
else if(N==15)then
x(1)=-11.83886391807398_p
w(1)=4.125514024997952e-1_p
x(2)=-11.15950566073198_p
w(2)=9.410165819396382e-1_p
x(3)=-9.972027340238954_p
w(3)=1.423960221371800_p
x(4)=-8.335808218367093_p
w(4)=1.833437822809561_p
x(5)=-6.338644507740832_p
w(5)=2.136440342421968_p
x(6)=-4.104155439485548_p
w(6)=2.261878942300689_p
x(7)=-1.807675249129543_p
w(7)=1.944371023575812_p
x(8)=4.300667918752956e-1_p
w(8)=8.941982313889153e-1_p
x(9)=2.885300609670973_p
w(9)=1.425429257777559e-1_p
x(10)=5.850316104913945_p
w(10)=9.271716662615248e-3_p
x(11)=9.334912134015845_p
w(11)=3.299048605580485e-4_p
x(12)=13.32077886588026_p
w(12)=6.939014008554145e-6_p
x(13)=17.77414183487162_p
w(13)=8.877003139710670e-8_p
x(14)=22.50232097272513_p
w(14)=7.911766867457978e-10_p
x(15)=26.65395140847803_p
w(15)=8.461029613597034e-12_p
else if(N==16)then
x(1)=-11.85458378452143_p
w(1)=3.724073920212591e-1_p
x(2)=-11.24059994122465_p
w(2)=8.514968458663706e-1_p
x(3)=-10.16367982493917_p
w(3)=1.294394123674310_p
x(4)=-8.671107062161667_p
w(4)=1.678859898649032_p
x(5)=-6.832562206761104_p
w(5)=1.979944797571770_p
x(6)=-4.744602852711677_p
w(6)=2.152574243116690_p
x(7)=-2.544139948088829_p
w(7)=2.039377773297834_p
x(8)=-3.813876355221866e-1_p
w(8)=1.271878945350238_p
x(9)=1.848768217489468_p
w(9)=3.249369881165550e-1_p
x(10)=4.470167696984544_p
w(10)=3.234695785873801e-2_p
x(11)=7.555289577656126_p
w(11)=1.729041065339357e-3_p
x(12)=11.07271201836922_p
w(12)=5.785384031906071e-5_p
x(13)=14.99281952301067_p
w(13)=1.264271165074339e-6_p
x(14)=19.23372753647846_p
w(14)=1.923726483994938e-8_p
x(15)=23.51415725211618_p
w(15)=2.510641633933368e-10_p
x(16)=26.97053826533181_p
w(16)=4.836253153634218e-12_p
else if(N==17)then
x(1)=-11.8681153421909_p
w(1)=3.378317166013967e-1_p
x(2)=-11.3105798292993_p
w(2)=7.739973730016273e-1_p
x(3)=-10.32984851204413_p
w(3)=1.181059686338797_p
x(4)=-8.964008586670319_p
w(4)=1.541088546015691_p
x(5)=-7.269057813260597_p
w(5)=1.834706277973138_p
x(6)=-5.321637730249187_p
w(6)=2.031474784678546_p
x(7)=-3.228424671041642_p
w(7)=2.039299470837278_p
x(8)=-1.128699265112910_p
w(8)=1.562990877373925_p
x(9)=9.576254743691450e-1_p
w(9)=5.997019497984321e-1_p
x(10)=3.299895574302692_p
w(10)=9.058266276271071e-2_p
x(11)=6.053673847058139_p
w(11)=6.923926794024177e-3_p
x(12)=9.195686460667599_p
w(12)=3.373390479098203e-4_p
x(13)=12.69214822563285_p
w(13)=1.125836536535271e-5_p
x(14)=16.49426116317614_p
w(14)=2.693977051851767e-7_p
x(15)=20.47684179944683_p
w(15)=5.104737844944711e-9_p
x(16)=24.30647060181478_p
w(16)=9.840334302165158e-11_p
x(17)=27.19068493536406_p
w(17)=3.099876653781686e-12_p
else
call GD(-12)
end if
end subroutine GF_m12

! [-11kT;28kT]
subroutine GF_m11(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-8.395770707637375_p
w(1)=6.137601896807759_p
x(2)=-1.506528839221795_p
w(2)=4.862414804752868_p
else if(N==3)then
x(1)=-9.486303272187660_p
w(1)=3.723465700286672_p
x(2)=-4.368235935046045_p
w(2)=5.649032163964742_p
x(3)=7.022737772313384e-1_p
w(3)=1.627518837309213_p
else if(N==4)then
x(1)=-9.985591114553145_p
w(1)=2.537364095520840_p
x(2)=-6.216211614884832_p
w(2)=4.648374551282284_p
x(3)=-1.556989106653319_p
w(3)=3.520555796503681_p
x(4)=2.923036613851745_p
w(4)=2.937222582538214e-1_p
else if(N==5)then
x(1)=-10.25753738785638_p
w(1)=1.872625682995348_p
x(2)=-7.369771159336550_p
w(2)=3.725325742326286_p
x(3)=-3.284912020552338_p
w(3)=3.990371756451217_p
x(4)=5.551675792098758e-1_p
w(4)=1.385174651085760_p
x(5)=5.546085423303133_p
w(5)=2.651886870201724e-2_p
else if(N==6)then
x(1)=-10.4238461817065_p
w(1)=1.460080654433122_p
x(2)=-8.124398136899620_p
w(2)=3.037603375710381_p
x(3)=-4.626894058947462_p
w(3)=3.738569176367937_p
x(4)=-9.753919954927011e-1_p
w(4)=2.482823709910514_p
x(5)=2.682227783454790_p
w(5)=2.793447812599708e-1_p
x(6)=8.471803529270858_p
w(6)=1.595003878701801e-3_p
else if(N==7)then
x(1)=-10.53417202731559_p
w(1)=1.184019413523446_p
x(2)=-8.644896196742254_p
w(2)=2.531683276334320_p
x(3)=-5.645530282501406_p
w(3)=3.340904199050553_p
x(4)=-2.224450704155429_p
w(4)=3.009358364496754_p
x(5)=9.998267441053038e-1_p
w(5)=9.038574095376850e-1_p
x(6)=5.122933277330458_p
w(6)=3.011669716377109e-2_p
x(7)=11.57825811085181_p
w(7)=7.734145409701390e-5_p
else if(N==8)then
x(1)=-10.61200769016648_p
w(1)=9.881596534056695e-1_p
x(2)=-9.021372527848323_p
w(2)=2.151575445230095_p
x(3)=-6.425318926491740_p
w(3)=2.959625596367098_p
x(4)=-3.285361954140846_p
w(4)=3.081671511832366_p
x(5)=-2.170824343032622e-1_p
w(5)=1.647846636934400_p
x(6)=3.091437044780100_p
w(6)=1.688401652166989e-1_p
x(7)=7.806233324692535_p
w(7)=2.294352666186343e-3_p
x(8)=14.78116514650149_p
w(8)=3.339908112997587e-6_p
else if(N==9)then
x(1)=-10.66987167437898_p
w(1)=8.419866846537204e-1_p
x(2)=-9.306093903634888_p
w(2)=1.856846445365451_p
x(3)=-7.037299024928732_p
w(3)=2.625429235901078_p
x(4)=-4.184330933721868_p
w(4)=2.949749003978441_p
x(5)=-1.233104224325346_p
w(5)=2.203940082757365_p
x(6)=1.668121396045283_p
w(6)=5.025415012969330e-1_p
x(7)=5.422742722242070_p
w(7)=1.937269260821958e-2_p
x(8)=10.59818470016183_p
w(8)=1.509086910720059e-4_p
x(9)=17.94405536036034_p
w(9)=1.463083472733113e-7_p
else if(N==10)then
x(1)=-10.71492922074728_p
w(1)=7.278378694094475e-1_p
x(2)=-9.530604181927748_p
w(2)=1.620299071237563_p
x(3)=-7.532638566823738_p
w(3)=2.336263870506249_p
x(4)=-4.951093730139398_p
w(4)=2.746869765057537_p
x(5)=-2.144991018496787_p
w(5)=2.479014980823933_p
x(6)=5.627874161796346e-1_p
w(6)=1.000040806182980_p
x(7)=3.691133428099400_p
w(7)=8.785192483079304e-2_p
x(8)=7.866067435844306_p
w(8)=1.828344910799655e-3_p
x(9)=13.34610670543873_p
w(9)=1.006034614013298e-5_p
x(10)=20.79783998615244_p
w(10)=8.255184894597015e-9_p
else if(N==11)then
x(1)=-10.75123151754499_p
w(1)=6.356682328454059e-1_p
x(2)=-9.713225758802592_p
w(2)=1.425341320512317_p
x(3)=-7.943446607952519_p
w(3)=2.085414132647101_p
x(4)=-5.610848824633591_p
w(4)=2.526826821229712_p
x(5)=-2.978250231949527_p
w(5)=2.536131086473369_p
x(6)=-3.773816180516137e-1_p
w(6)=1.513817062918562_p
x(7)=2.346199050661322_p
w(7)=2.650743136837478e-1_p
x(8)=5.829922525365898_p
w(8)=1.157197622767367e-2_p
x(9)=10.27968323569527_p
w(9)=1.709634659631327e-4_p
x(10)=15.89355068106391_p
w(10)=7.907818459514949e-7_p
x(11)=23.05109439958178_p
w(11)=7.749288131133098e-10_p
else if(N==12)then
x(1)=-10.78106591864219_p
w(1)=5.597915146041774e-1_p
x(2)=-9.864424846812980_p
w(2)=1.262305262738009_p
x(3)=-8.288627656840889_p
w(3)=1.867755816197792_p
x(4)=-6.180242214174650_p
w(4)=2.311911522584263_p
x(5)=-3.733909622980993_p
w(5)=2.468683606687567_p
x(6)=-1.227263312796132_p
w(6)=1.897319758474059_p
x(7)=1.256618848578288_p
w(7)=5.826027005804192e-1_p
x(8)=4.226809693507465_p
w(8)=4.820088698162364e-2_p
x(9)=7.975125989281933_p
w(9)=1.427921160792998e-3_p
x(10)=12.56569620377114_p
w(10)=1.763008419594340e-5_p
x(11)=18.13325401514458_p
w(11)=8.133635435604074e-8_p
x(12)=24.62453234299323_p
w(12)=1.313733149286886e-10_p
else if(N==13)then
x(1)=-10.8058852674012_p
w(1)=4.965849101976663e-1_p
x(2)=-9.990941853536373_p
w(2)=1.124820037569341_p
x(3)=-8.580787788469285_p
w(3)=1.679088264230945_p
x(4)=-6.671920386744971_p
w(4)=2.111571523490838_p
x(5)=-4.411064932455639_p
w(5)=2.343116760043848_p
x(6)=-2.013946282758144_p
w(6)=2.099656473770339_p
x(7)=3.352199831857370e-1_p
w(7)=9.911545921840439e-1_p
x(8)=2.929243697556306_p
w(8)=1.462640103663549e-1_p
x(9)=6.150131358211238_p
w(9)=7.574470457588512e-3_p
x(10)=10.04949121933621_p
w(10)=1.835119910103620e-4_p
x(11)=14.66431546742677_p
w(11)=2.135752480235797e-6_p
x(12)=20.02049974737171_p
w(12)=1.146957918222633e-8_p
x(13)=25.65077597962364_p
w(13)=3.659306447034025e-11_p
else if(N==14)then
x(1)=-10.82673657073432_p
w(1)=4.434267728264275e-1_p
x(2)=-10.09772644762478_p
w(2)=1.008063834772075_p
x(3)=-8.829621089773550_p
w(3)=1.515450155434996_p
x(4)=-7.097164801079974_p
w(4)=1.929097728674019_p
x(5)=-5.012969335558799_p
w(5)=2.196093426220884_p
x(6)=-2.741658940242934_p
w(6)=2.154945635782829_p
x(7)=-4.802794216965811e-1_p
w(7)=1.382047736032820_p
x(8)=1.856949820467138_p
w(8)=3.407041652558608e-1_p
x(9)=4.661811692598802_p
w(9)=2.898540092675774e-2_p
x(10)=8.045903808942759_p
w(10)=1.175533538051325e-3_p
x(11)=12.00437041043791_p
w(11)=2.599467250174903e-5_p
x(12)=16.54188070475435_p
w(12)=3.151856538960183e-7_p
x(13)=21.55856803636116_p
w(13)=2.223245505001914e-9_p
x(14)=26.31071571530701_p
w(14)=1.450626441664582e-11_p
else if(N==15)then
x(1)=-10.84441290316812_p
w(1)=3.983237827501218e-1_p
x(2)=-10.18859222209114_p
w(2)=9.082225155016933e-1_p
x(3)=-9.042901630366879_p
w(3)=1.373184048074960_p
x(4)=-7.466066415266040_p
w(4)=1.764805420893092_p
x(5)=-5.545948667446835_p
w(5)=2.045761464881748_p
x(6)=-3.408906927788550_p
w(6)=2.119974914408229_p
x(7)=-1.227007817245354_p
w(7)=1.666727820250094_p
x(8)=9.484421988540981e-1_p
w(8)=6.316791081799145e-1_p
x(9)=3.424914142901023_p
w(9)=8.579464163428674e-2_p
x(10)=6.400439152146218_p
w(10)=5.346481444713854e-3_p
x(11)=9.866760527616403_p
w(11)=1.922450754656355e-4_p
x(12)=13.80895964771325_p
w(12)=4.200289299875729e-6_p
x(13)=18.18510077788918_p
w(13)=5.759298899774095e-8_p
x(14)=22.78244691485053_p
w(14)=5.767401710157175e-10_p
x(15)=26.74277175987377_p
w(15)=7.279222646110295e-12_p
else if(N==16)then
x(1)=-10.85952316298652_p
w(1)=3.597409324491919e-1_p
x(2)=-10.26650678121662_p
w(2)=8.222678353836652e-1_p
x(3)=-9.226865597573159_p
w(3)=1.249075046612767_p
x(4)=-7.787334753138397_p
w(4)=1.617682532608926_p
x(5)=-6.017474748200594_p
w(5)=1.900616090870497_p
x(6)=-4.015629960018656_p
w(6)=2.038322797717105_p
x(7)=-1.920876648269051_p
w(7)=1.821912703549021_p
x(8)=1.535853004299791e-1_p
w(8)=9.664692250535277e-1_p
x(9)=2.381965657834969_p
w(9)=2.041361204102930e-1_p
x(10)=5.021421012859562_p
w(10)=1.875912348055838e-2_p
x(11)=8.097441305421333_p
w(11)=9.991485070589398e-4_p
x(12)=11.58250889386561_p
w(12)=3.434211020333855e-5_p
x(13)=15.44613224004806_p
w(13)=7.895824090698816e-7_p
x(14)=19.59760120345672_p
w(14)=1.302917616367563e-8_p
x(15)=23.74286336734838_p
w(15)=1.919544457011565e-10_p
x(16)=27.034517356832_p
w(16)=4.272768218698803e-12_p
else if(N==17)then
x(1)=-10.87253892422441_p
w(1)=3.264865710756361e-1_p
x(2)=-10.33379295946971_p
w(2)=7.477926577680416e-1_p
x(3)=-9.386508991186204_p
w(3)=1.140380690458423_p
x(4)=-8.068313647611248_p
w(4)=1.486203444018585_p
x(5)=-6.434995147535862_p
w(5)=1.764360901572230_p
x(6)=-4.564275166364598_p
w(6)=1.935971057494535_p
x(7)=-2.565922897667222_p
w(7)=1.872600540077502_p
x(8)=-5.647361124425478e-1_p
w(8)=1.268933708976796_p
x(9)=1.488812771065140_p
w(9)=3.997323861802539e-1_p
x(10)=3.849462328965657_p
w(10)=5.336728167521652e-2_p
x(11)=6.603215206856562_p
w(11)=3.983097456601658e-3_p
x(12)=9.721778403278654_p
w(12)=1.973413283513035e-4_p
x(13)=13.17473695353974_p
w(13)=6.845701774156041e-6_p
x(14)=16.91013009646908_p
w(14)=1.740908642192318e-7_p
x(15)=20.79551103569241_p
w(15)=3.604723040634371e-9_p
x(16)=24.49282617464027_p
w(16)=7.830228686577425e-11_p
x(17)=27.23821924087923_p
w(17)=2.790281163509895e-12_p
else
call GD(-11)
end if
end subroutine GF_m11

! [-10kT;28kT]
subroutine GF_m10(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-7.589291604980772_p
w(1)=5.675311882497774_p
x(2)=-1.221802100881366_p
w(2)=4.324733516400752_p
else if(N==3)then
x(1)=-8.585496558163063_p
w(1)=3.477526158103838_p
x(2)=-3.820530674119019_p
w(2)=5.186811693026812_p
x(3)=9.860666850563203e-1_p
w(3)=1.335707547767876_p
else if(N==4)then
x(1)=-9.045154673063317_p
w(1)=2.387438768066363_p
x(2)=-5.505463886113810_p
w(2)=4.342786653415864_p
x(3)=-1.157816663757724_p
w(3)=3.060089103658750_p
x(4)=3.295961333409870_p
w(4)=2.097308737575480e-1_p
else if(N==5)then
x(1)=-9.297152055152051_p
w(1)=1.772162142557451_p
x(2)=-6.568038496012500_p
w(2)=3.511183732408709_p
x(3)=-2.735527840537591_p
w(3)=3.627022810680955_p
x(4)=9.341676088931850e-1_p
w(4)=1.072728737167443_p
x(5)=6.006554539788670_p
w(5)=1.694797608396680e-2_p
else if(N==6)then
x(1)=-9.452110934107212_p
w(1)=1.388096438795297_p
x(2)=-7.268295293648298_p
w(2)=2.879780770173111_p
x(3)=-3.964036813755235_p
w(3)=3.481239656949201_p
x(4)=-5.311852043514225e-1_p
w(4)=2.063737021091240_p
x(5)=3.132496124297001_p
w(5)=1.862384143947484e-1_p
x(6)=8.992617678677234_p
w(6)=9.530974949270900e-4_p
else if(N==7)then
x(1)=-9.555402165922738_p
w(1)=1.129810191934168_p
x(2)=-7.754118938920019_p
w(2)=2.410655703422857_p
x(3)=-4.905312443876502_p
w(3)=3.148962572336011_p
x(4)=-1.686825674296260_p
w(4)=2.644640788700557_p
x(5)=1.447263506539813_p
w(5)=6.477989344768597e-1_p
x(6)=5.644810711283545_p
w(6)=1.813301508013893e-2_p
x(7)=12.14122431532938_p
w(7)=4.419294793397439e-5_p
else if(N==8)then
x(1)=-9.628623716263723_p
w(1)=9.456615289593222e-1_p
x(2)=-8.107431468663604_p
w(2)=2.055568326232717_p
x(3)=-5.631884800849378_p
w(3)=2.809073986199153_p
x(4)=-2.662495700291439_p
w(4)=2.809381032283858_p
x(5)=2.562082950042886e-1_p
w(5)=1.274138248677491_p
x(6)=3.604392166642968_p
w(6)=1.049105941795104e-1_p
x(7)=8.372701008154696_p
w(7)=1.309822800265511e-3_p
x(8)=15.36769433317648_p
w(8)=1.859566207389049e-6_p
else if(N==9)then
x(1)=-9.683356001635516_p
w(1)=8.074617360667901e-1_p
x(2)=-8.376230951808767_p
w(2)=1.778266528166459_p
x(3)=-6.206598027810391_p
w(3)=2.502797633082713_p
x(4)=-3.495625266218437_p
w(4)=2.746637499990636_p
x(5)=-7.092083434272261e-1_p
w(5)=1.822432463350881_p
x(6)=2.168767569922142_p
w(6)=3.311853972726547e-1_p
x(7)=5.983638853499733_p
w(7)=1.117977599945528e-2_p
x(8)=11.18201555625328_p
w(8)=8.428281363916424e-5_p
x(9)=18.5159779120225_p
w(9)=8.215529716681194e-8_p
else if(N==10)then
x(1)=-9.726200336891610_p
w(1)=6.989601202176501e-1_p
x(2)=-8.589387822195590_p
w(2)=1.554266026441348_p
x(3)=-6.675017656413385_p
w(3)=2.233487445700031_p
x(4)=-4.213230352934598_p
w(4)=2.588532672651309_p
x(5)=-1.561850168224210_p
w(5)=2.161525703991178_p
x(6)=1.061804851441898_p
w(6)=7.101864742141109e-1_p
x(7)=4.238775861912673_p
w(7)=5.205164915859509e-2_p
x(8)=8.442484589924000_p
w(8)=1.029634043533033e-3_p
x(9)=13.91581998932123_p
w(9)=5.667549191425236e-6_p
x(10)=21.2935755688005_p
w(10)=4.931578008738393e-9_p
else if(N==11)then
x(1)=-9.760836403342632_p
w(1)=6.110483641842184e-1_p
x(2)=-8.763410548537076_p
w(2)=1.368869722929250_p
x(3)=-7.065274090133469_p
w(3)=1.997639456591622_p
x(4)=-4.835137671681797_p
w(4)=2.398057831423067_p
x(5)=-2.338977112262504_p
w(5)=2.293955319520394_p
x(6)=1.406473053644409e-1_p
w(6)=1.159547834228086_p
x(7)=2.878470406650129_p
w(7)=1.642407765497921e-1_p
x(8)=6.398402157193055_p
w(8)=6.589023008626932e-3_p
x(9)=10.84693569681504_p
w(9)=9.660852091129905e-5_p
x(10)=16.42110205345696_p
w(10)=4.614308754494749e-7_p
x(11)=23.42744756180756_p
w(11)=5.116821767916497e-10_p
else if(N==12)then
x(1)=-9.789349807983061_p
w(1)=5.385506204349552e-1_p
x(2)=-8.907765613089932_p
w(2)=1.213472480880090_p
x(3)=-7.394020608423157_p
w(3)=1.791881612160272_p
x(4)=-5.374271088685838_p
w(4)=2.203940315998866_p
x(5)=-3.046183657360507_p
w(5)=2.285023973506991_p
x(6)=-6.717334458404314e-1_p
w(6)=1.554211034557690_p
x(7)=1.779088914153086_p
w(7)=3.842420449970571e-1_p
x(8)=4.787185009003360_p
w(8)=2.790509378321240e-2_p
x(9)=8.542285183615325_p
w(9)=8.080001203069617e-4_p
x(10)=13.10687487761765_p
w(10)=1.017236959015679e-5_p
x(11)=18.60104267999169_p
w(11)=4.999366916879808e-8_p
x(12)=24.88602850076942_p
w(12)=9.582713465340688e-11_p
else if(N==13)then
x(1)=-9.813095762834079_p
w(1)=4.780915504913182e-1_p
x(2)=-9.028705863510815_p
w(2)=1.082227869537947_p
x(3)=-7.672745406656124_p
w(3)=1.612894945067580_p
x(4)=-5.841249836302297_p
w(4)=2.019104112329364_p
x(5)=-3.683012195013133_p
w(5)=2.199376131376702_p
x(6)=-1.412349621080294_p
w(6)=1.813847916787032_p
x(7)=8.611984087264080e-1_p
w(7)=7.029717328891701e-1_p
x(8)=3.480585288599061_p
w(8)=8.712847189393046e-2_p
x(9)=6.717660765525496_p
w(9)=4.296417006519731e-3_p
x(10)=10.60089366593974_p
w(10)=1.049709370826870e-4_p
x(11)=15.16783453772584_p
w(11)=1.273069981785958e-6_p
x(12)=20.4210718902162_p
w(12)=7.483058508276237e-9_p
x(13)=25.82716487631722_p
w(13)=2.883873995815124e-11_p
else if(N==14)then
x(1)=-9.833064101993040_p
w(1)=4.271947070235156e-1_p
x(2)=-9.130893235731341_p
w(2)=9.706265440246590e-1_p
x(3)=-7.910474385785620_p
w(3)=1.457238323624597_p
x(4)=-6.246100037705167_p
w(4)=1.848693539530161_p
x(5)=-4.251626056571716_p
w(5)=2.079210527793596_p
x(6)=-2.094460574309843_p
w(6)=1.933206795241261_p
x(7)=6.559654892416794e-2_p
w(7)=1.054266683037311_p
x(8)=2.400099945966032_p
w(8)=2.123648315019721e-1_p
x(9)=5.228350788838256_p
w(9)=1.655999432310681e-2_p
x(10)=8.605458756165715_p
w(10)=6.680611563608191e-4_p
x(11)=12.52991217718728_p
w(11)=1.519452472904077e-5_p
x(12)=17.00031494667064_p
w(12)=1.955650928863297e-7_p
x(13)=21.89264133287972_p
w(13)=1.540095988896086e-9_p
x(14)=26.43087696549811_p
w(14)=1.206760473359258e-11_p
else if(N==15)then
x(1)=-9.850006933240055_p
w(1)=3.839710170336525e-1_p
x(2)=-9.217933516141604_p
w(2)=8.750817189403469e-1_p
x(3)=-8.114494892634164_p
w(3)=1.321621149739114_p
x(4)=-6.598000547884689_p
w(4)=1.694081075400528_p
x(5)=-4.756998375817236_p
w(5)=1.947587597673430_p
x(6)=-2.721001342013532_p
w(6)=1.949629197059180_p
x(7)=-6.485062380524708e-1_p
w(7)=1.356594447001020_p
x(8)=1.489046414109836_p
w(8)=4.185028749458440e-1_p
x(9)=3.988267545218208_p
w(9)=4.983528801066971e-2_p
x(10)=6.966043120424862_p
w(10)=3.027684913189135e-3_p
x(11)=10.40826489244136_p
w(11)=1.107829692272308e-4_p
x(12)=14.30158802154753_p
w(12)=2.527442205550651e-6_p
x(13)=18.59493228905662_p
w(13)=3.734170270298878e-8_p
x(14)=23.05639312099049_p
w(14)=4.221333587514909e-10_p
x(15)=26.82691557725486_p
w(15)=6.282455716585802e-12_p
else if(N==16)then
x(1)=-9.864502085891269_p
w(1)=3.469646566561033e-1_p
x(2)=-9.292635708733311_p
w(2)=7.927396535135831e-1_p
x(3)=-8.290669227391978_p
w(3)=1.203103734065857_p
x(4)=-6.904966523489810_p
w(4)=1.554903363555030_p
x(5)=-5.205425500612825_p
w(5)=1.816119418520511_p
x(6)=-3.292882343337471_p
w(6)=1.904385344864636_p
x(7)=-1.304074982589865_p
w(7)=1.561855753854285_p
x(8)=7.021579200993054e-1_p
w(8)=6.864960539192980e-1_p
x(9)=2.940666537019883_p
w(9)=1.222524558283113e-1_p
x(10)=5.590693506031813_p
w(10)=1.063453377038746e-2_p
x(11)=8.651192562851360_p
w(11)=5.697099665991128e-4_p
x(12)=12.09903064641578_p
w(12)=2.022001838866517e-5_p
x(13)=15.90146594359363_p
w(13)=4.913816968021187e-7_p
x(14)=19.95878859821554_p
w(14)=8.832722942300494e-9_p
x(15)=23.96577173292157_p
w(15)=1.473348735010758e-10_p
x(16)=27.09536855387407_p
w(16)=3.782102621659574e-12_p
else if(N==17)then
x(1)=-9.876997409613679_p
w(1)=3.150445122017123e-1_p
x(2)=-9.357200950251318_p
w(2)=7.213277099462417e-1_p
x(3)=-8.443704970520679_p
w(3)=1.099153072131789_p
x(4)=-7.173809693550772_p
w(4)=1.430058121541203_p
x(5)=-5.603431670280274_p
w(5)=1.690329020883623_p
x(6)=-3.812039768835759_p
w(6)=1.827075396279326_p
x(7)=-1.911097745333490_p
w(7)=1.667228918183098_p
x(8)=3.585349184412411e-3_p
w(8)=9.661366322016746e-1_p
x(9)=2.044140658483116_p
w(9)=2.508088370188987e-1_p
x(10)=4.419830058468397_p
w(10)=3.050968289815865e-2_p
x(11)=7.166337352567143_p
w(11)=2.254955302362984e-3_p
x(12)=10.25645711940554_p
w(12)=1.142865754548211e-4_p
x(13)=13.66164424013773_p
w(13)=4.138808482602900e-6_p
x(14)=17.32616878233697_p
w(14)=1.123112962807976e-7_p
x(15)=21.11064448839784_p
w(15)=2.550171668554175e-9_p
x(16)=24.67412653725939_p
w(16)=6.251799792512863e-11_p
x(17)=27.28361330269433_p
w(17)=2.514238770032915e-12_p
else
call GD(-10)
end if
end subroutine GF_m10

! [-9kT;28kT]
subroutine GF_m9(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-6.781260853042675_p
w(1)=5.214314237319654_p
x(2)=-9.236268373812587e-1_p
w(2)=3.785809164869378_p
else if(N==3)then
x(1)=-7.683954155751544_p
w(1)=3.232601250888294_p
x(2)=-3.271349668172924_p
w(2)=4.705941077486356_p
x(3)=1.297723436327779_p
w(3)=1.061581073814382_p
else if(N==4)then
x(1)=-8.104403931407129_p
w(1)=2.237917599874745_p
x(2)=-4.794760232015260_p
w(2)=4.027699695100040_p
x(3)=-7.489891255544210e-1_p
w(3)=2.590640075360428_p
x(4)=3.704166981484115_p
w(4)=1.438660318538194e-1_p
else if(N==5)then
x(1)=-8.336659619013194_p
w(1)=1.671744071153940_p
x(2)=-5.766659966053556_p
w(2)=3.292405827514381_p
x(3)=-2.187832821616222_p
w(3)=3.230798540732871_p
x(4)=1.342688654835399_p
w(4)=7.947032166031077e-1_p
x(5)=6.498849696762131_p
w(5)=1.047174618473295e-2_p
else if(N==6)then
x(1)=-8.480372754719395_p
w(1)=1.315970195944156_p
x(2)=-6.412706572391038_p
w(2)=2.719173093554830_p
x(3)=-3.304881608731786_p
w(3)=3.198787115244134_p
x(4)=-7.433284069591249e-2_p
w(4)=1.646919673945921_p
x(5)=3.618851418143164_p
w(5)=1.187199265138164e-1_p
x(6)=9.541353180136298_p
w(6)=5.533969861743230e-4_p
else if(N==7)then
x(1)=-8.576686041510783_p
w(1)=1.075356702887867_p
x(2)=-6.863953942240653_p
w(2)=2.287635430572801_p
x(3)=-4.168526427709333_p
w(3)=2.941682629254352_p
x(4)=-1.150137455104171_p
w(4)=2.245100360839927_p
x(5)=1.927921353721948_p
w(5)=4.397662108522228e-1_p
x(6)=6.197406992569134_p
w(6)=1.055744115895071e-2_p
x(7)=12.72873502041645_p
w(7)=2.462662291113449e-5_p
else if(N==8)then
x(1)=-8.645331267633839_p
w(1)=9.028485916243328e-1_p
x(2)=-7.194186700253991_p
w(2)=1.957937879810075_p
x(3)=-4.841484405531587_p
w(3)=2.648932735397338_p
x(4)=-2.046019696518250_p
w(4)=2.495276588569992_p
x(5)=7.502957748860052e-1_p
w(5)=9.319402399666031e-1_p
x(6)=4.151121921460302_p
w(6)=6.245786941085963e-2_p
x(7)=8.964066749045802_p
w(7)=7.284823912001837e-4_p
x(8)=15.97324070148604_p
w(8)=1.015018630470561e-6_p
else if(N==9)then
x(1)=-8.696955972583423_p
w(1)=7.725776914840373e-1_p
x(2)=-7.447119911355863_p
w(2)=1.698267969669349_p
x(3)=-5.378629979360509_p
w(3)=2.373742436098178_p
x(4)=-2.814163285001710_p
w(4)=2.511065659946154_p
x(5)=-1.792483506659224e-1_p
w(5)=1.431414788733783_p
x(6)=2.703180848087421_p
w(6)=2.067394943611793e-1_p
x(7)=6.570269492487083_p
w(7)=6.269142530080722e-3_p
x(8)=11.78393363207911_p
w(8)=4.617367335207703e-5_p
x(9)=19.09524162253206_p
w(9)=4.569291738704828e-8_p
else if(N==10)then
x(1)=-8.737589714904393_p
w(1)=6.697287403653053e-1_p
x(2)=-7.648892988872279_p
w(2)=1.487012491884777_p
x(3)=-5.819771404511388_p
w(3)=2.126187677674339_p
x(4)=-3.481795568083175_p
w(4)=2.408194921302404_p
x(5)=-9.825832958583076e-1_p
w(5)=1.804624543947011_p
x(6)=1.588422181700709_p
w(6)=4.740319688179881e-1_p
x(7)=4.814406841492080_p
w(7)=2.977165889089724e-2_p
x(8)=9.037411289288316_p
w(8)=5.682414060758278e-4_p
x(9)=14.49586011974903_p
w(9)=3.154945248673375e-6_p
x(10)=21.78203098618297_p
w(10)=2.954985572971983e-9_p
else if(N==11)then
x(1)=-8.770546860758348_p
w(1)=5.861161542702634e-1_p
x(2)=-7.814222595455599_p
w(2)=1.311388790186544_p
x(3)=-6.189065796324052_p
w(3)=1.906587633805662_p
x(4)=-4.064648144869794_p
w(4)=2.254823677498875_p
x(5)=-1.707513725526130_p
w(5)=2.006703674631664_p
x(6)=6.750348137461580e-1_p
w(6)=8.336310005961981e-1_p
x(7)=3.441141927102523_p
w(7)=9.715291174011009e-2_p
x(8)=6.987360047542337_p
w(8)=3.665472527295584e-3_p
x(9)=11.42690042147575_p
w(9)=5.381884336030922e-5_p
x(10)=16.95218581274085_p
w(10)=2.677478718957768e-7_p
x(11)=23.78911187358259_p
w(11)=3.411877366107430e-10_p
else if(N==12)then
x(1)=-8.797723915882507_p
w(1)=5.170433292189685e-1_p
x(2)=-7.951634586969422_p
w(2)=1.163812689395125_p
x(3)=-6.501017412085950_p
w(3)=1.713566039667936_p
x(4)=-4.572446717590553_p
w(4)=2.086331409918678_p
x(5)=-2.366631170140618_p
w(5)=2.064294667461553_p
x(6)=-1.115487743252050e-1_p
w(6)=1.199964447880081_p
x(7)=2.331280574680326_p
w(7)=2.389620085219240e-1_p
x(8)=5.370958710767751_p
w(8)=1.569335492669697e-2_p
x(9)=9.124437930035274_p
w(9)=4.496108582368928e-4_p
x(10)=13.65597584676286_p
w(10)=5.813566685506654e-6_p
x(11)=19.06731347047329_p
w(11)=3.070255593744739e-8_p
x(12)=25.13371098399186_p
w(12)=7.059099238917566e-11_p
else if(N==13)then
x(1)=-8.820383450167043_p
w(1)=4.593703066782763e-1_p
x(2)=-8.066916683369406_p
w(2)=1.038950166078044_p
x(3)=-6.766026955840299_p
w(3)=1.544827366661210_p
x(4)=-5.013896180798367_p
w(4)=1.920015657042709_p
x(5)=-2.962165172578147_p
w(5)=2.028906533410346_p
x(6)=-8.142201681856028e-1_p
w(6)=1.489530652822426_p
x(7)=1.410956728705563_p
w(7)=4.661268925172977e-1_p
x(8)=4.058453885101062_p
w(8)=4.994661687730961e-2_p
x(9)=7.302509736259207_p
w(9)=2.389135365146374e-3_p
x(10)=11.16295078633939_p
w(10)=5.931524336161094e-5_p
x(11)=15.67524764564924_p
w(11)=7.545768505214457e-7_p
x(12)=20.81690850105651_p
w(12)=4.893160121961651e-9_p
x(13)=25.99344909036563_p
w(13)=2.289462359448397e-11_p
else if(N==14)then
x(1)=-8.839458320901242_p
w(1)=4.107657469002478e-1_p
x(2)=-8.164442253646484_p
w(2)=9.326125710486475e-1_p
x(3)=-6.992436861109183_p
w(3)=1.397547941876061_p
x(4)=-5.397728850011193_p
w(4)=1.763578728633004_p
x(5)=-3.496274902105099_p
w(5)=1.943882606961292_p
x(6)=-1.454482432863780_p
w(6)=1.666138447116574_p
x(7)=6.254427886074927e-1_p
w(7)=7.501994352017726e-1_p
x(8)=2.971539850966822_p
w(8)=1.257823189737956e-1_p
x(9)=5.814843797143602_p
w(9)=9.232507779904246e-3_p
x(10)=9.177834656795715_p
w(10)=3.741697490136360e-4_p
x(11)=13.06246753435334_p
w(11)=8.805829789804143e-6_p
x(12)=17.4594293134398_p
w(12)=1.210378843135295e-7_p
x(13)=22.22048012435912_p
w(13)=1.070958475704162e-9_p
x(14)=26.5442647447278_p
w(14)=1.008720988516164e-11_p
else if(N==15)then
x(1)=-8.855659049284357_p
w(1)=3.694466832010994e-1_p
x(2)=-8.247604922858448_p
w(2)=8.414497694062874e-1_p
x(3)=-7.187029167605505_p
w(3)=1.268865200507299_p
x(4)=-5.732155614929625_p
w(4)=1.619890772773253_p
x(5)=-3.972951045199753_p
w(5)=1.836715085547837_p
x(6)=-2.041119117564389_p
w(6)=1.739772344690439_p
x(7)=-6.593785717409709e-2_p
w(7)=1.034049715562879_p
x(8)=2.056239599007894_p
w(8)=2.601434459858197e-1_p
x(9)=4.574500827627842_p
w(9)=2.804043748678875e-2_p
x(10)=7.546556293205088_p
w(10)=1.685256184490709e-3_p
x(11)=10.95902458664265_p
w(11)=6.315392706850869e-5_p
x(12)=14.79820442215816_p
w(12)=1.512394563202094e-6_p
x(13)=19.00312937084279_p
w(13)=2.420548471159578e-8_p
x(14)=23.32389956279033_p
w(14)=3.102847531763608e-10_p
x(15)=26.9065915472557_p
w(15)=5.438199896283763e-12_p
else if(N==16)then
x(1)=-8.869531928177972_p
w(1)=3.340378638029122e-1_p
x(2)=-8.319051915129323_p
w(2)=7.627889137864959e-1_p
x(3)=-7.355279426891928_p
w(3)=1.156151660971934_p
x(4)=-6.024454677036987_p
w(4)=1.489495891967528_p
x(5)=-4.397392659148533_p
w(5)=1.722734395212890_p
x(6)=-2.577587145616953_p
w(6)=1.740226973106141_p
x(7)=-6.902496674690013e-1_p
w(7)=1.264742245944621_p
x(8)=1.271345128555976_p
w(8)=4.535581463264219e-1_p
x(9)=3.524788499814981_p
w(9)=7.015087412705283e-2_p
x(10)=6.177163386046626_p
w(10)=5.903621192565173e-3_p
x(11)=9.216101118947707_p
w(11)=3.206923175267591e-4_p
x(12)=12.62187956480797_p
w(12)=1.181249129158107e-5_p
x(13)=16.35838086292937_p
w(13)=3.048294895086246e-7_p
x(14)=20.31689046467062_p
w(14)=5.995274874133462e-9_p
x(15)=24.182774652075_p
w(15)=1.135342386883655e-10_p
x(16)=27.15323164112026_p
w(16)=3.353520933709156e-12_p
else if(N==17)then
x(1)=-8.881500775421101_p
w(1)=3.034696370643230e-1_p
x(2)=-8.380860561656769_p
w(2)=6.944960941035302e-1_p
x(3)=-7.501598301496080_p
w(3)=1.057106599131155_p
x(4)=-6.280876121618596_p
w(4)=1.371866504039508_p
x(5)=-4.775185103445313_p
w(5)=1.609923885161637_p
x(6)=-3.066256459283816_p
w(6)=1.696278655779337_p
x(7)=-1.262842869524520_p
w(7)=1.417345519411586_p
x(8)=5.838909627043003e-1_p
w(8)=6.825424034661682e-1_p
x(9)=2.625633457301357_p
w(9)=1.487867512472603e-1_p
x(10)=5.009970207055017_p
w(10)=1.698187412886894e-2_p
x(11)=7.742465248571778_p
w(11)=1.257368190408607e-3_p
x(12)=10.79933205283652_p
w(12)=6.554748344192718e-5_p
x(13)=14.1524834926759_p
w(13)=2.488766539829616e-6_p
x(14)=17.74198569021017_p
w(14)=7.235509455402150e-8_p
x(15)=21.42195433177202_p
w(15)=1.807822815532614e-9_p
x(16)=24.85035044298509_p
w(16)=5.008266019300090e-11_p
x(17)=27.32695867723189_p
w(17)=2.267549052959199e-12_p
else
call GD(-9)
end if
end subroutine GF_m9

! [-8kT;28kT]
subroutine GF_m8(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.971704484911246_p
w(1)=4.752846008216403_p
x(2)=-6.083138551327502e-1_p
w(2)=3.247489398155802_p
else if(N==3)then
x(1)=-6.781797001673977_p
w(1)=2.987695800799883_p
x(2)=-2.720431292574414_p
w(2)=4.201208061542114_p
x(3)=1.642725984917740_p
w(3)=8.114315440302080e-1_p
else if(N==4)then
x(1)=-7.163458480953582_p
w(1)=2.088129908332181_p
x(2)=-4.084907082006585_p
w(2)=3.696910498076933_p
x(3)=-3.256332389369964e-1_p
w(3)=2.120785444081271_p
x(4)=4.150706108468060_p
w(4)=9.450955588181931e-2_p
else if(N==5)then
x(1)=-7.376163287586961_p
w(1)=1.570875939670370_p
x(2)=-4.966398595807835_p
w(2)=3.065075868025140_p
x(3)=-1.640499081517326_p
w(3)=2.798928930783934_p
x(4)=1.786640761523736_p
w(4)=5.592084947948532e-1_p
x(5)=7.024613696455956_p
w(5)=6.246173097907026e-3_p
else if(N==6)then
x(1)=-7.508718780038656_p
w(1)=1.243315336074636_p
x(2)=-5.558250403097690_p
w(2)=2.553284044528213_p
x(3)=-2.650310260912471_p
w(3)=2.881234937377730_p
x(4)=4.023564914280868e-1_p
w(4)=1.249897059219429_p
x(5)=4.143178328677555_p
w(5)=7.229219624937071e-2_p
x(6)=10.11928740118492_p
w(6)=3.118329228258270e-4_p
else if(N==7)then
x(1)=-7.598098343953318_p
w(1)=1.020343895162405_p
x(2)=-5.974905048459980_p
w(2)=2.160909057305748_p
x(3)=-3.436556880933731_p
w(3)=2.710144307077622_p
x(4)=-6.096393915503711e-1_p
w(4)=1.821258179667954_p
x(5)=2.446419194935952_p
w(5)=2.817244416571987e-1_p
x(6)=6.781444927663308_p
w(6)=5.942153528786247e-3_p
x(7)=13.34162645729407_p
w(7)=1.337197249136996e-5_p
else if(N==8)then
x(1)=-7.662195485188661_p
w(1)=8.594559546832810e-1_p
x(2)=-6.282058076207550_p
w(2)=1.857430746357640_p
x(3)=-4.055435022000109_p
w(3)=2.472745141649499_p
x(4)=-1.434641050230966_p
w(4)=2.135034980467352_p
x(5)=1.272977903457953_p
w(5)=6.396012847074513e-1_p
x(6)=4.732007253869818_p
w(6)=3.567213647530971e-2_p
x(7)=9.580601014758816_p
w(7)=3.946187643840493e-4_p
x(8)=16.59739656246273_p
w(8)=5.432672871533544e-7_p
else if(N==9)then
x(1)=-7.710726132444745_p
w(1)=7.371147776033238e-1_p
x(2)=-6.519102461830998_p
w(2)=1.615906909974218_p
x(3)=-4.554495024202139_p
w(3)=2.233772887784990_p
x(4)=-2.140662244740895_p
w(4)=2.231704048184418_p
x(5)=3.649831759545089e-1_p
w(5)=1.055997064508486_p
x(6)=3.273126729468152_p
w(6)=1.223966114029929e-1_p
x(7)=7.182374089836661_p
w(7)=3.418260414419561e-3_p
x(8)=12.40348678504028_p
w(8)=2.482128178544340e-5_p
x(9)=19.67948523133995_p
w(9)=2.521757081141694e-8_p
else if(N==10)then
x(1)=-7.749140566846591_p
w(1)=6.399662540653058e-1_p
x(2)=-6.709386959370991_p
w(2)=1.417821231774729_p
x(3)=-4.967765007782634_p
w(3)=2.011231828912380_p
x(4)=-2.758170396419441_p
w(4)=2.194549814095628_p
x(5)=-4.014953087160680e-1_p
w(5)=1.423264766422422_p
x(6)=2.147775537669090_p
w(6)=2.967203771259666e-1_p
x(7)=5.417494313365166_p
w(7)=1.647195436802832e-2_p
x(8)=9.650499435726156_p
w(8)=3.074411948271025e-4_p
x(9)=15.08533231897328_p
w(9)=1.736633263926838e-6_p
x(10)=22.26056438333825_p
w(10)=1.779654213036093e-9_p
else if(N==11)then
x(1)=-7.780397661509985_p
w(1)=5.607259237717493e-1_p
x(2)=-6.865874517226296_p
w(2)=1.252339574723710_p
x(3)=-5.315504249229996_p
w(3)=1.810021759432746_p
x(4)=-3.300813776039298_p
w(4)=2.088139575022763_p
x(5)=-1.081431909752206_p
w(5)=1.673615097713457_p
x(6)=1.233913538407994_p
w(6)=5.584180570776074e-1_p
x(7)=4.034165440707061_p
w(7)=5.505199591322898e-2_p
x(8)=7.596365411968490_p
w(8)=1.993700607048024e-3_p
x(9)=12.01914301872829_p
w(9)=2.956726354406118e-5_p
x(10)=17.48580991175117_p
w(10)=1.546163980344234e-7_p
x(11)=24.13495861499815_p
w(11)=2.299519100094828e-10_p
else if(N==12)then
x(1)=-7.806217337955212_p
w(1)=4.951464931404066e-1_p
x(2)=-6.996207163111523_p
w(2)=1.112876762517160_p
x(3)=-5.610170367240286_p
w(3)=1.631162378056852_p
x(4)=-3.776056650184335_p
w(4)=1.952456084501376_p
x(5)=-1.695126551939599_p
w(5)=1.796426420746047_p
x(6)=4.617778908275769e-1_p
w(6)=8.629060832310899e-1_p
x(7)=2.915222342298782_p
w(7)=1.405225029070591e-1_p
x(8)=5.977426518279038_p
w(8)=8.589252258652359e-3_p
x(9)=9.721222197369967_p
w(9)=2.461178042451329e-4_p
x(10)=14.21245637854974_p
w(10)=3.292303917747850e-6_p
x(11)=19.53114897814983_p
w(11)=1.885288185418699e-8_p
x(12)=25.36757498524491_p
w(12)=5.251627865101847e-11_p
else if(N==13)then
x(1)=-7.827773165455801_p
w(1)=4.403153257472122e-1_p
x(2)=-7.105721983414107_p
w(2)=9.946180301002147e-1_p
x(3)=-5.861087362826565_p
w(3)=1.473638265145241_p
x(4)=-4.190957659698767_p
w(4)=1.809498872113176_p
x(5)=-2.249518553459547_p
w(5)=1.819512273793345_p
x(6)=-2.132910729694942e-1_p
w(6)=1.145106221814490_p
x(7)=1.989865507795023_p
w(7)=2.886562854502658e-1_p
x(8)=4.662069285688541_p
w(8)=2.765316863301277e-2_p
x(9)=7.904184994281986_p
w(9)=1.303394405000244e-3_p
x(10)=11.7352583276612_p
w(10)=3.312099387161011e-5_p
x(11)=16.18594947137681_p
w(11)=4.449494574845939e-7_p
x(12)=21.20730231020429_p
w(12)=3.208614054496894e-9_p
x(13)=26.14994287499301_p
w(13)=1.830401545263944e-11_p
else if(N==14)then
x(1)=-7.845940611401444_p
w(1)=3.940480604129635e-1_p
x(2)=-7.198499138345040_p
w(2)=8.937141012970578e-1_p
x(3)=-6.075887666176773_p
w(3)=1.335410490581947_p
x(4)=-4.552971055650374_p
w(4)=1.670243722188179_p
x(5)=-2.748280455369154_p
w(5)=1.779279315834452_p
x(6)=-8.184845789231339e-1_p
w(6)=1.356593333217414_p
x(7)=1.207303089789687_p
w(7)=4.946578170435623e-1_p
x(8)=3.571352778640421_p
w(8)=7.114571631431603e-2_p
x(9)=6.420528381296645_p
w(9)=5.031091474158725e-3_p
x(10)=9.762624920549605_p
w(10)=2.066208664900472e-4_p
x(11)=13.60158544590656_p
w(11)=5.061627811917291e-6_p
x(12)=17.91863872373827_p
w(12)=7.475755057715762e-8_p
x(13)=22.54164026765339_p
w(13)=7.478330859919153e-10_p
x(14)=26.65117274581711_p
w(14)=8.469831626792797e-12_p
else if(N==15)then
x(1)=-7.861387779357585_p
w(1)=3.546705246353409e-1_p
x(2)=-7.277714194630621_p
w(2)=8.070664616646706e-1_p
x(3)=-6.260823664819385_p
w(3)=1.214147529494669_p
x(4)=-4.869299602432782_p
w(4)=1.539629878498515_p
x(5)=-3.195184524361529_p
w(5)=1.704551588738960_p
x(6)=-1.368400468128507_p
w(6)=1.482505868777196_p
x(7)=5.290832183034874e-1_p
w(7)=7.291424715653736e-1_p
x(8)=2.652432850661860_p
w(8)=1.523296732157860e-1_p
x(9)=5.182601479923231_p
w(9)=1.533219610179736e-2_p
x(10)=8.141454132438900_p
w(10)=9.226698720540118e-4_p
x(11)=11.51864441603555_p
w(11)=3.562757820990773e-5_p
x(12)=15.29834583847087_p
w(12)=9.003032519308810e-7_p
x(13)=19.40919391235738_p
w(13)=1.569258796979187e-8_p
x(14)=23.5847437766193_p
w(14)=2.290720410328450e-10_p
x(15)=26.98200866827069_p
w(15)=4.720137025951671e-12_p
else if(N==16)then
x(1)=-7.874628840228700_p
w(1)=3.208899365643590e-1_p
x(2)=-7.345848501149811_p
w(2)=7.321931467495414e-1_p
x(3)=-6.420967498033755_p
w(3)=1.107596968308642_p
x(4)=-5.146442901838014_p
w(4)=1.419488361866998_p
x(5)=-3.594631035505958_p
w(5)=1.613923487429813_p
x(6)=-1.870262425818950_p
w(6)=1.533911328732296_p
x(7)=-7.287393240341644e-2_p
w(7)=9.514553072730770e-1_p
x(8)=1.866704351417180_p
w(8)=2.787047572961553e-1_p
x(9)=4.133508324321697_p
w(9)=3.877292464573842e-2_p
x(10)=6.780075731956035_p
w(10)=3.213857716146795e-3_p
x(11)=9.791748287212226_p
w(11)=1.782877594943336e-4_p
x(12)=13.1506611262997_p
w(12)=6.849299934353825e-6_p
x(13)=16.81644051085595_p
w(13)=1.885636869070066e-7_p
x(14)=20.67152561157662_p
w(14)=4.075509268086906e-9_p
x(15)=24.39379394171468_p
w(15)=8.783469602450563e-11_p
x(16)=27.2082447576092_p
w(16)=2.978021488801561e-12_p
else if(N==17)then
x(1)=-7.886063180713140_p
w(1)=2.916994185464820e-1_p
x(2)=-7.404852791238866_p
w(2)=6.671056905461249e-1_p
x(3)=-6.560421599369193_p
w(3)=1.013729678455149_p
x(4)=-5.390056117782030_p
w(4)=1.310105402241627_p
x(5)=-3.951351690370132_p
w(5)=1.518222303057670_p
x(6)=-2.328064256527354_p
w(6)=1.531748938862352_p
x(7)=-6.173173004733097e-1_p
w(7)=1.129095495818699_p
x(8)=1.184061863065919_p
w(8)=4.446799617631844e-1_p
x(9)=3.233683815844499_p
w(9)=8.399075001828150e-2_p
x(10)=5.618846185206123_p
w(10)=9.227964925003418e-3_p
x(11)=8.331074274971424_p
w(11)=6.910221902274244e-4_p
x(12)=11.35002542415104_p
w(12)=3.724312575751706e-5_p
x(13)=14.64687305009265_p
w(13)=1.488932244773447e-6_p
x(14)=18.15719882450571_p
w(14)=4.656267847355414e-8_p
x(15)=21.72917427104773_p
w(15)=1.284424279301674e-9_p
x(16)=25.02149715368711_p
w(16)=4.025266706250697e-11_p
x(17)=27.36834556763742_p
w(17)=2.046589899926524e-12_p
else
call GD(-8)
end if
end subroutine GF_m8

! [-7kT;28kT]
subroutine GF_m7(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.160732875660777_p
w(1)=4.287642623456332_p
x(2)=-2.708834505866890e-1_p
w(2)=2.713268842996751_p
else if(N==3)then
x(1)=-5.879247483819326_p
w(1)=2.740849969453154_p
x(2)=-2.166717837175459_p
w(2)=3.668240035873315_p
x(3)=2.027331905811156_p
w(3)=5.918214611266142e-1_p
else if(N==4)then
x(1)=-6.222514764151245_p
w(1)=1.936777805596974_p
x(2)=-3.376757176979441_p
w(2)=3.341543675929020_p
x(3)=1.189390275114715e-1_p
w(3)=1.663299822149223_p
x(4)=4.638559440278859_p
w(4)=5.929016277786618e-2_p
else if(N==5)then
x(1)=-6.415824120065349_p
w(1)=1.468618972764882_p
x(2)=-4.168266013543921_p
w(2)=2.822653360019653_p
x(3)=-1.090191011403136_p
w(3)=2.334701122247757_p
x(4)=2.271847799846567_p
w(4)=3.713470889448460e-1_p
x(5)=7.585609461407051_p
w(5)=3.590922475945332e-3_p
else if(N==6)then
x(1)=-6.537281164307126_p
w(1)=1.169410879045986_p
x(2)=-4.705795934995288_p
w(2)=2.377657376154521_p
x(3)=-2.000274924517051_p
w(3)=2.518941119257149_p
x(4)=9.074500314062752e-1_p
w(4)=8.926992332046215e-1_p
x(5)=4.707021705048376_p
w(5)=4.203256737195239e-2_p
x(6)=10.72783923910692_p
w(6)=1.702914188529813e-4_p
else if(N==7)then
x(1)=-6.619750027952295_p
w(1)=9.641921581282912e-1_p
x(2)=-5.087693222398155_p
w(2)=2.027324645675288_p
x(3)=-2.710667744914898_p
w(3)=2.442181107000414_p
x(4)=-5.773826632032574e-2_p
w(4)=1.393938278098565_p
x(5)=3.006282811370300_p
w(5)=1.700364213184702e-1_p
x(6)=7.397698669176689_p
w(6)=3.231787643307016e-3_p
x(7)=13.98076316231049_p
w(7)=7.068588746905394e-6_p
else if(N==8)then
x(1)=-6.679310892211320_p
w(1)=8.150040076405339e-1_p
x(2)=-5.371644914240661_p
w(2)=1.751716663451071_p
x(3)=-3.275260639695718_p
w(3)=2.270302578802042_p
x(4)=-8.242686209597426e-1_p
w(4)=1.734707453975529_p
x(5)=1.831498421382111_p
w(5)=4.093999060964983e-1_p
x(6)=5.347153455874311_p
w(6)=1.957241829629907e-2_p
x(7)=10.22254755701042_p
w(7)=2.081529434417793e-4_p
x(8)=17.23944673079835_p
w(8)=2.852476682219270e-7_p
else if(N==9)then
x(1)=-6.724744242535303_p
w(1)=7.006777357476118e-1_p
x(2)=-5.592663137690028_p
w(2)=1.529418748210677_p
x(3)=-3.735582305812447_p
w(3)=2.075191119122601_p
x(4)=-1.474108402582084_p
w(4)=1.900883662215395_p
x(5)=9.330525468883828e-1_p
w(5)=7.240048696425737e-1_p
x(6)=3.879258419734896_p
w(6)=6.890899717742288e-2_p
x(7)=7.819714862755775_p
w(7)=1.813222795657587e-3_p
x(8)=13.04013670451629_p
w(8)=1.309770148943131e-5_p
x(9)=20.26593285468805_p
w(9)=1.383965350423007e-8_p
else if(N==10)then
x(1)=-6.760914926866717_p
w(1)=6.093488475109826e-1_p
x(2)=-5.771252564337710_p
w(2)=1.345334369390682_p
x(3)=-4.120151549663981_p
w(3)=1.882963796928993_p
x(4)=-2.043004303303064_p
w(4)=1.934619502154395_p
x(5)=1.901724486644296e-1_p
w(5)=1.045287362686420_p
x(6)=2.743203814625919_p
w(6)=1.743623795375446e-1_p
x(7)=6.047474016736526_p
w(7)=8.831144989712443e-3_p
x(8)=10.28142764006199_p
w(8)=1.631162435770252e-4_p
x(9)=15.68329066106969_p
w(9)=9.459313214108990e-7_p
x(10)=22.72657704139488_p
w(10)=1.079455030129178e-9_p
else if(N==11)then
x(1)=-6.790439461917937_p
w(1)=5.346072003972460e-1_p
x(2)=-5.918675461172509_p
w(2)=1.190650301169786_p
x(3)=-4.445535193172121_p
w(3)=1.703757436551426_p
x(4)=-2.544937627246068_p
w(4)=1.885238070798454_p
x(5)=-4.549817568355525e-1_p
w(5)=1.308322092785709_p
x(6)=1.824323029664953_p
w(6)=3.472698491466168e-1_p
x(7)=4.656969815867478_p
w(7)=2.998953776594226e-2_p
x(8)=8.225054973015563_p
w(8)=1.060864217422625e-3_p
x(9)=12.62323423778343_p
w(9)=1.602453595526879e-5_p
x(10)=18.02095496347821_p
w(10)=8.892776517474231e-8_p
x(11)=24.46410517442687_p
w(11)=1.567603802851890e-10_p
else if(N==12)then
x(1)=-6.814872692398304_p
w(1)=4.726294011850532e-1_p
x(2)=-6.041740027780550_p
w(2)=1.059797356176414_p
x(3)=-4.722262346043985_p
w(3)=1.541516915034173_p
x(4)=-2.986543179255424_p
w(4)=1.791685966338960_p
x(5)=-1.029088786619806_p
w(5)=1.479480704953225_p
x(6)=1.057657507570035_p
w(6)=5.725846109728279e-1_p
x(7)=3.531454297860875_p
w(7)=7.850020879241607e-2_p
x(8)=6.605943187815543_p
w(8)=4.581866993159334e-3_p
x(9)=10.33230656431945_p
w(9)=1.325760809589369e-4_p
x(10)=14.77576575803797_p
w(10)=1.848303192263514e-6_p
x(11)=19.99163437426287_p
w(11)=1.158325146488546e-8_p
x(12)=25.5877569557293_p
w(12)=3.945194061685937e-11_p
else if(N==13)then
x(1)=-6.835301290534980_p
w(1)=4.207273083826239e-1_p
x(2)=-6.145338163954691_p
w(2)=9.485161416205278e-1_p
x(3)=-4.958579645180233_p
w(3)=1.396900736303994_p
x(4)=-3.373796602121226_p
w(4)=1.679236467257052_p
x(5)=-1.544680758712422_p
w(5)=1.560377525680693_p
x(6)=3.995391026296517e-1_p
w(6)=8.121471639282412e-1_p
x(7)=2.601182237199403_p
w(7)=1.674559255456310e-1_p
x(8)=5.290495255910346_p
w(8)=1.483363796055521e-2_p
x(9)=8.522256770654323_p
w(9)=6.980149209436757e-4_p
x(10)=12.3174248159985_p
w(10)=1.828158667385285e-5_p
x(11)=16.6993317798234_p
w(11)=2.611404446349627e-7_p
x(12)=21.59158146972467_p
w(12)=2.110970925360817e-9_p
x(13)=26.29700684846301_p
w(13)=1.473208448905509e-11_p
else if(N==14)then
x(1)=-6.852542276662726_p
w(1)=3.768679717796299e-1_p
x(2)=-6.233248040843430_p
w(2)=8.533322434142715e-1_p
x(3)=-5.161375289076358_p
w(3)=1.268920095477818_p
x(4)=-3.713036153146474_p
w(4)=1.562299742540317_p
x(5)=-2.008414911623377_p
w(5)=1.572047622998365_p
x(6)=-1.797503283581671e-1_p
w(6)=1.024259850270126_p
x(7)=1.817848732483579_p
w(7)=3.017528589485917e-1_p
x(8)=4.198801677756089_p
w(8)=3.863250294388135e-2_p
x(9)=7.044731191103426_p
w(9)=2.683110179684996e-3_p
x(10)=10.35945791136718_p
w(10)=1.125346300599538e-4_p
x(11)=14.14682421641006_p
w(11)=2.886640840786917e-6_p
x(12)=18.37736876819271_p
w(12)=4.609783587394354e-8_p
x(13)=22.85572694726287_p
w(13)=5.245192899247858e-10_p
x(14)=26.75190468307969_p
w(14)=7.141489824334843e-12_p
else if(N==15)then
x(1)=-6.867220234252171_p
w(1)=3.394900497316914e-1_p
x(2)=-6.308419289999671_p
w(2)=7.714238708370729e-1_p
x(3)=-5.336342566229691_p
w(3)=1.155942845990044_p
x(4)=-4.010479637528040_p
w(4)=1.448386308905578_p
x(5)=-2.424955473889296_p
w(5)=1.538553204760963_p
x(6)=-6.990409005965517e-1_p
w(6)=1.181972393768355_p
x(7)=1.145534536890472_p
w(7)=4.718922275761882e-1_p
x(8)=3.278229416081076_p
w(8)=8.456473117339344e-2_p
x(9)=5.811576471038626_p
w(9)=8.168227274054878e-3_p
x(10)=8.750276614057636_p
w(10)=4.971668858142616e-4_p
x(11)=12.08675190793974_p
w(11)=1.989586338346942e-5_p
x(12)=15.80156171234973_p
w(12)=5.333339818644317e-7_p
x(13)=19.81265076834007_p
w(13)=1.017858360701332e-8_p
x(14)=23.83874843969386_p
w(14)=1.698715451489939e-10_p
x(15)=27.05337644105603_p
w(15)=4.106881825198666e-12_p
else if(N==16)then
x(1)=-6.879816448564727_p
w(1)=3.073860598734423e-1_p
x(2)=-6.373161964236938_p
w(2)=7.005166718707432e-1_p
x(3)=-5.488129367578057_p
w(3)=1.056197756006790_p
x(4)=-4.271829881851957_p
w(4)=1.341066820094557_p
x(5)=-2.798517777364582_p
w(5)=1.479093068305124_p
x(6)=-1.169450959649137_p
w(6)=1.278465995108610_p
x(7)=5.571212189614346e-1_p
w(7)=6.555624358913977e-1_p
x(8)=2.491483050809336_p
w(8)=1.600647251958028e-1_p
x(9)=4.765668077513611_p
w(9)=2.073835115488688e-2_p
x(10)=7.398773470163535_p
w(10)=1.717591973387698e-3_p
x(11)=10.37775490804828_p
w(11)=9.792883766441259e-5_p
x(12)=13.68500011649998_p
w(12)=3.942947239054254e-6_p
x(13)=17.27522602379603_p
w(13)=1.163472255482259e-7_p
x(14)=21.02234240072942_p
w(14)=2.775345356469099e-9_p
x(15)=24.59878548612464_p
w(15)=6.821942256502782e-11_p
x(16)=27.26054506362081_p
w(16)=2.648028242834203e-12_p
else if(N==17)then
x(1)=-6.890705336458405_p
w(1)=2.796139190852282e-1_p
x(2)=-6.429296401706996_p
w(2)=6.387790368191877e-1_p
x(3)=-5.620515169631518_p
w(3)=9.679954134465469e-1_p
x(4)=-4.502120267261118_p
w(4)=1.241773201106757_p
x(5)=-3.133259943912465_p
w(5)=1.406669553593455_p
x(6)=-1.597502002216939_p
w(6)=1.321378685157730_p
x(7)=3.275971339314503e-2_p
w(7)=8.267126993614937e-1_p
x(8)=1.810443386969290_p
w(8)=2.672554920902528e-1_p
x(9)=3.867569090402390_p
w(9)=4.543113304937248e-2_p
x(10)=6.245514106196272_p
w(10)=4.905933303847034e-3_p
x(11)=8.931704318470006_p
w(11)=3.745123871396446e-4_p
x(12)=11.90818803411961_p
w(12)=2.096969257069144e-5_p
x(13)=15.14445088202683_p
w(13)=8.864712505052473e-7_p
x(14)=18.57144830178708_p
w(14)=2.993922976406976e-8_p
x(15)=22.03206847680741_p
w(15)=9.147176574844871e-10_p
x(16)=25.18758948286981_p
w(16)=3.245525455112409e-11_p
x(17)=27.40786349654064_p
w(17)=1.848227174473141e-12_p
else
call GD(-7)
end if
end subroutine GF_m7

! [-6kT;28kT]
subroutine GF_m6(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-4.348502560497890_p
w(1)=3.813108199389121_p
x(2)=9.542185496377355e-2_p
w(2)=2.189367485747918_p
else if(N==3)then
x(1)=-4.976655288514316_p
w(1)=2.488346366463495_p
x(2)=-1.607600787512429_p
w(2)=3.105729848910731_p
x(3)=2.458422862294948_p
w(3)=4.083994697628127e-1_p
else if(N==4)then
x(1)=-5.281875320664051_p
w(1)=1.781348567508564_p
x(2)=-2.670787083664861_p
w(2)=2.950357543354942_p
x(3)=5.934066220755909e-1_p
w(3)=1.235343025308544_p
x(4)=5.170694493152699_p
w(4)=3.542654896498975e-2_p
else if(N==5)then
x(1)=-5.455886332459523_p
w(1)=1.363146589163801_p
x(2)=-3.373406333344316_p
w(2)=2.554804215950278_p
x(3)=-5.306344202714531e-1_p
w(3)=1.851007450906081_p
x(4)=2.803606129444862_p
w(4)=2.315313224128270e-1_p
x(5)=8.183818426684505_p
w(5)=1.986106704052629e-3_p
else if(N==6)then
x(1)=-5.566258246880770_p
w(1)=1.092851470204929_p
x(2)=-3.856467934676899_p
w(2)=2.184512443592963_p
x(3)=-1.352573986093949_p
w(3)=2.107808280853548_p
x(4)=1.450149080271318_p
w(4)=5.938837368632924e-1_p
x(5)=5.311760646836060_p
w(5)=2.332977239317964e-2_p
x(6)=11.36865009476469_p
w(6)=8.998122912655438e-5_p
else if(N==7)then
x(1)=-5.641805971008955_p
w(1)=9.057727463966376e-1_p
x(2)=-4.203301701839995_p
w(2)=1.881083067203689_p
x(3)=-1.991155305832708_p
w(3)=2.124580240550442_p
x(4)=5.158633451024145e-1_p
w(4)=9.926148687491867e-1_p
x(5)=3.609866298547822_p
w(5)=9.672372327039290e-2_p
x(6)=8.047072167382751_p
w(6)=1.697404916693941e-3_p
x(7)=14.64705989685727_p
w(7)=3.634049996901508e-6_p
else if(N==8)then
x(1)=-5.696815868256776_p
w(1)=7.685624954689357e-1_p
x(2)=-4.463779909443118_p
w(2)=1.636384700377044_p
x(3)=-2.502242620387839_p
w(3)=2.027374730914167_p
x(4)=-2.070081221341672e-1_p
w(4)=1.315958863672740_p
x(5)=2.431564769512298_p
w(5)=2.437589494039864e-1_p
x(6)=5.996589410553141_p
w(6)=1.032891561094366e-2_p
x(7)=10.89015725984303_p
w(7)=1.068826597339970e-4_p
x(8)=17.89831038921353_p
w(8)=1.470294882811939e-7_p
else if(N==9)then
x(1)=-5.739123210450517_p
w(1)=6.624971819105090e-1_p
x(2)=-4.668481730432959_p
w(2)=1.435396126967553_p
x(3)=-2.923371622695426_p
w(3)=1.885770196304698_p
x(4)=-8.101867124774376e-1_p
w(4)=1.523135257213743_p
x(5)=1.534378727140788_p
w(5)=4.577200483652413e-1_p
x(6)=4.521493158276606_p
w(6)=3.701404985852663e-2_p
x(7)=8.482142464519683_p
w(7)=9.360299655584147e-4_p
x(8)=13.69329994649487_p
w(8)=6.786980228110964e-6_p
x(9)=20.85143525658043_p
w(9)=7.570981837392514e-9_p
else if(N==10)then
x(1)=-5.773003810631486_p
w(1)=5.772364252640243e-1_p
x(2)=-4.835037036730057_p
w(2)=1.266877210611079_p
x(3)=-3.278312052875690_p
w(3)=1.731627980527940_p
x(4)=-1.334829750365550_p
w(4)=1.619925515307910_p
x(5)=8.033339217710390e-1_p
w(5)=7.055771320837224e-1_p
x(6)=3.376240273252087_p
w(6)=9.655200453070921e-2_p
x(7)=6.703885558460106_p
w(7)=4.594023294524004e-3_p
x(8)=10.92994662583571_p
w(8)=8.488264171140966e-5_p
x(9)=16.28877540711178_p
w(9)=5.102147613473747e-7_p
x(10)=23.1776205330157_p
w(10)=6.606579402557227e-10_p
else if(N==11)then
x(1)=-5.800747462056566_p
w(1)=5.072179233234547e-1_p
x(2)=-4.973074930466463_p
w(2)=1.124175520570398_p
x(3)=-3.580376402897708_p
w(3)=1.580163298504317_p
x(4)=-1.797245671378703_p
w(4)=1.632140288064084_p
x(5)=1.813406393341155e-1_p
w(5)=9.417557364383824e-1_p
x(6)=2.451124923481478_p
w(6)=2.007073257140187e-1_p
x(7)=5.308804318465085_p
w(7)=1.575452284510041e-2_p
x(8)=8.873177139249609_p
w(8)=5.524488198806677e-4_p
x(9)=13.23878469338624_p
w(9)=8.569769244070003e-6_p
x(10)=18.55660402433715_p
w(10)=5.098001737478899e-8_p
x(11)=24.77594204385266_p
w(11)=1.081413090376853e-10_p
else if(N==12)then
x(1)=-5.823753504415621_p
w(1)=4.490258910674894e-1_p
x(2)=-5.088609705840452_p
w(2)=1.002818883833228_p
x(3)=-3.838346980632334_p
w(3)=1.438650588557840_p
x(4)=-2.204942485561234_p
w(4)=1.589502596996412_p
x(5)=-3.620502568352126e-1_p
w(5)=1.129067955567737_p
x(6)=1.684545929695774_p
w(6)=3.490757516675730e-1_p
x(7)=4.179526401642140_p
w(7)=4.187791969556154e-2_p
x(8)=7.255998848750167_p
w(8)=2.384771209485345e-3_p
x(9)=10.95742611929933_p
w(9)=7.029037035986199e-5_p
x(10)=15.34537596536042_p
w(10)=1.029015930615720e-6_p
x(11)=20.44788673572315_p
w(11)=7.125501691440722e-9_p
x(12)=25.79452833444204_p
w(12)=2.991971757052773e-11_p
else if(N==13)then
x(1)=-5.843022097526876_p
w(1)=4.002011279062467e-1_p
x(2)=-5.186084115415811_p
w(2)=8.991844081229360e-1_p
x(3)=-4.059407761092165_p
w(3)=1.309883180767611_p
x(4)=-2.563741333670840_p
w(4)=1.516297552005618_p
x(5)=-8.442274271770326e-1_p
w(5)=1.251548549077147_p
x(6)=1.034696429528743_p
w(6)=5.256949758418493e-1_p
x(7)=3.246082843064940_p
w(7)=9.156003047887595e-2_p
x(8)=5.942850268488661_p
w(8)=7.728628740283488e-3_p
x(9)=9.156394755691942_p
w(9)=3.671011199331223e-4_p
x(10)=12.90910440523845_p
w(10)=9.977063686002143e-6_p
x(11)=17.21481183370992_p
w(11)=1.526068968276131e-7_p
x(12)=21.96913424728752_p
w(12)=1.394023275402343e-9_p
x(13)=26.43504376329824_p
w(13)=1.193184646981033e-11_p
else if(N==14)then
x(1)=-5.859310030804256_p
w(1)=3.588704385089577e-1_p
x(2)=-5.268961200491857_p
w(2)=8.102357764125728e-1_p
x(3)=-4.249673742475141_p
w(3)=1.194282258582531_p
x(4)=-2.879285642357578_p
w(4)=1.428936169125410_p
x(5)=-1.275487455235716_p
w(5)=1.312441468096296_p
x(6)=4.717054486415118e-1_p
w(6)=7.050218767182497e-1_p
x(7)=2.461251992041811_p
w(7)=1.709903372048235e-1_p
x(8)=4.852801027820177_p
w(8)=2.023354222915179e-2_p
x(9)=7.686916408383017_p
w(9)=1.401688944996273e-3_p
x(10)=10.96802951756556_p
w(10)=6.046674793978321e-5_p
x(11)=14.69778106936415_p
w(11)=1.633800665770397e-6_p
x(12)=18.83508107460628_p
w(12)=2.838980516954391e-8_p
x(13)=23.16241165781499_p
w(13)=3.695949154700314e-10_p
x(14)=26.8467740464309_p
w(14)=6.044415254107120e-12_p
else if(N==15)then
x(1)=-5.873196891376615_p
w(1)=3.235917899863568e-1_p
x(2)=-5.339954327837243_p
w(2)=7.334711005181846e-1_p
x(3)=-4.414250010695881_p
w(3)=1.091164705346730_p
x(4)=-3.156976867803098_p
w(4)=1.337343620764283_p
x(5)=-1.662429810616254_p
w(5)=1.324932556106412_p
x(6)=-2.525053992673642e-2_p
w(6)=8.625998649765362e-1_p
x(7)=1.790903111703412_p
w(7)=2.800268809257022e-1_p
x(8)=3.933005245542656_p
w(8)=4.482182341650926e-2_p
x(9)=6.460571688411748_p
w(9)=4.248256687155769e-3_p
x(10)=9.372658817362938_p
w(10)=2.637642049925125e-4_p
x(11)=12.66302741552683_p
w(11)=1.100096780539315e-5_p
x(12)=16.30744025249236_p
w(12)=3.144990614188120e-7_p
x(13)=20.21306915362094_p
w(13)=6.607193024057824e-9_p
x(14)=24.08579211190884_p
w(14)=1.265353077997504e-10_p
x(15)=27.12090601332005_p
w(15)=3.580976540008970e-12_p
else if(N==16)then
x(1)=-5.885130047070534_p
w(1)=2.932476060126014e-1_p
x(2)=-5.401195039349639_p
w(2)=6.668528265962715e-1_p
x(3)=-4.557337304503139_p
w(3)=9.994084128422059e-1_p
x(4)=-3.401775535234519_p
w(4)=1.247086948655141_p
x(5)=-2.009929787940972_p
w(5)=1.303994950018001_p
x(6)=-4.700927999971398e-1_p
w(6)=9.830784232158934e-1_p
x(7)=1.209398855013766_p
w(7)=4.104515923228968e-1_p
x(8)=3.146656011725329_p
w(8)=8.662305407434337e-2_p
x(9)=5.420089778427703_p
w(9)=1.077450543780736e-2_p
x(10)=8.032731244133574_p
w(10)=9.018798496372843e-4_p
x(11)=10.97381050985154_p
w(11)=5.315848495484396e-5_p
x(12)=14.22456780507389_p
w(12)=2.254053807021930e-6_p
x(13)=17.73435921487318_p
w(13)=7.162431627249243e-8_p
x(14)=21.36903593364825_p
w(14)=1.893616937027314e-9_p
x(15)=24.7977462909765_p
w(15)=5.318791000719936e-11_p
x(16)=27.3102700522007_p
w(16)=2.357137813787567e-12_p
else if(N==17)then
x(1)=-5.895458197070973_p
w(1)=2.669639686252172e-1_p
x(2)=-5.454368089838345_p
w(2)=6.087264274498687e-1_p
x(3)=-4.682374664256541_p
w(3)=9.177766876947819e-1_p
x(4)=-3.618100059767796_p
w(4)=1.161064533990354_p
x(5)=-2.322098728707349_p
w(5)=1.262230132397352_p
x(6)=-8.718916078324962e-1_p
w(6)=1.062087069816843_p
x(7)=6.973034672408726e-1_p
w(7)=5.480068817961019e-1_p
x(8)=2.466696621215105_p
w(8)=1.491583994455271e-1_p
x(9)=4.526043235955211_p
w(9)=2.369336154170130e-2_p
x(10)=6.889190899833809_p
w(10)=2.555729159391353e-3_p
x(11)=9.543986377172125_p
w(11)=2.002451821859219e-4_p
x(12)=12.47352658775012_p
w(12)=1.170277303967569e-5_p
x(13)=15.64489880583615_p
w(13)=5.253455797441638e-7_p
x(14)=18.98441616239_p
w(14)=1.923815792597964e-8_p
x(15)=22.33044501778521_p
w(15)=6.530195993448637e-10_p
x(16)=25.34867887735503_p
w(16)=2.624806593671156e-11_p
x(17)=27.4456024444785_p
w(17)=1.669737447181914e-12_p
else
call GD(-6)
end if
end subroutine GF_m6

! [-5kT;28kT]
subroutine GF_m5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-3.535012776121431_p
w(1)=3.320511014079707_p
x(2)=4.997493686459080e-1_p
w(2)=1.686204334408720_p
else if(N==3)then
x(1)=-4.074467857187368_p
w(1)=2.223447057626240_p
x(2)=-1.037808962219847_p
w(2)=2.518893675948210_p
x(3)=2.943265540044904_p
w(3)=2.643746149139770e-1_p
else if(N==4)then
x(1)=-4.341958417593286_p
w(1)=1.617041121057865_p
x(2)=-1.966114709404494_p
w(2)=2.512463143634053_p
x(3)=1.108295890051443_p
w(3)=8.571036589152139e-1_p
x(4)=5.750228205307868_p
w(4)=2.010742488129409e-2_p
else if(N==5)then
x(1)=-4.496695899050647_p
w(1)=1.250874993072156_p
x(2)=-2.582595170610450_p
w(2)=2.247107539176123_p
x(3)=4.809128360103181e-2_p
w(3)=1.372581617595295_p
x(4)=3.386408949897143_p
w(4)=1.350967058854679e-1_p
x(5)=8.821604286917818_p
w(5)=1.054492759384618e-3_p
else if(N==6)then
x(1)=-4.595934271379693_p
w(1)=1.010834137270351_p
x(2)=-3.011431338175348_p
w(2)=1.961216283582501_p
x(3)=-7.012097496660084e-1_p
w(3)=1.657253662346805_p
x(4)=2.039195468744472_p
w(4)=3.650087201901072e-1_p
x(5)=5.958860970905176_p
w(5)=1.235663104596663e-2_p
x(6)=12.04371920506028_p
w(6)=4.591405269562770e-5_p
else if(N==7)then
x(1)=-4.664503371497522_p
w(1)=8.428117107489347e-1_p
x(2)=-3.322897333504407_p
w(2)=1.711962324123622_p
x(3)=-1.275697473908136_p
w(3)=1.750294502829713_p
x(4)=1.123096637824959_p
w(4)=6.488434358447079e-1_p
x(5)=4.258619564397092_p
w(5)=5.194142763054774e-2_p
x(6)=8.730716455967066_p
w(6)=8.601322803224262e-4_p
x(7)=15.34152684616877_p
w(7)=1.815030578335598e-6_p
else if(N==8)then
x(1)=-4.714908677118389_p
w(1)=7.182460188186374e-1_p
x(2)=-3.559512538877863_p
w(2)=1.503265702480698_p
x(3)=-1.736217651060442_p
w(3)=1.729176641460189_p
x(4)=4.288924499432795e-1_p
w(4)=9.155678058624015e-1_p
x(5)=3.076850154290295_p
w(5)=1.351588263479218e-1_p
x(6)=6.680477048687107_p
w(6)=5.246875407252645e-3_p
x(7)=11.58376089658775_p
w(7)=5.340364146638901e-5_p
x(8)=18.57249937601323_p
w(8)=7.446985989963602e-8_p
else if(N==9)then
x(1)=-4.754024981031441_p
w(1)=6.209976733450719e-1_p
x(2)=-3.747446191215007_p
w(2)=1.327302634106589_p
x(3)=-2.118675616783804_p
w(3)=1.649306208960496_p
x(4)=-1.399023715507748e-1_p
w(4)=1.123547479050319_p
x(5)=2.176585033890705_p
w(5)=2.660605549713904e-1_p
x(6)=5.199476716080765_p
w(6)=1.902707215056591e-2_p
x(7)=9.169695755321056_p
w(7)=4.702671114373027e-4_p
x(8)=14.36242425820281_p
w(8)=3.454653609821598e-6_p
x(9)=21.43256296337735_p
w(9)=4.138946446938868e-9_p
else if(N==10)then
x(1)=-4.785539451577431_p
w(1)=5.422987319266211e-1_p
x(2)=-3.901479446718375_p
w(2)=1.177168792098827_p
x(3)=-2.443415261366030_p
w(3)=1.542356826185335_p
x(4)=-6.281051160415544e-1_p
w(4)=1.258004653563769_p
x(5)=1.449031924218182_p
w(5)=4.338836026257991e-1_p
x(6)=4.047115554958452_p
w(6)=5.063838923763656e-2_p
x(7)=7.386506950207942_p
w(7)=2.320755870375154e-3_p
x(8)=11.59595595408893_p
w(8)=4.332388960402212e-5_p
x(9)=16.90087432116544_p
w(9)=2.726818057808120e-7_p
x(10)=23.61151427601806_p
w(10)=4.086540052508639e-10_p
else if(N==11)then
x(1)=-4.811432082690748_p
w(1)=4.774182346642256e-1_p
x(2)=-4.029695707362536_p
w(2)=1.048584126861638_p
x(3)=-2.721276685747548_p
w(3)=1.426496328807599_p
x(4)=-1.055059139704509_p
w(4)=1.322754484068074_p
x(5)=8.396689199817762e-1_p
w(5)=6.148109580088917e-1_p
x(6)=3.116733944105361_p
w(6)=1.083645037470145e-1_p
x(7)=5.989033625744905_p
w(7)=8.000576252904342e-3_p
x(8)=9.540665004171451_p
w(8)=2.815839540875783e-4_p
x(9)=13.86550611334379_p
w(9)=4.522898841679206e-6_p
x(10)=19.09179215775069_p
w(10)=2.914964426544606e-8_p
x(11)=25.07015434783571_p
w(11)=7.550629167837764e-11_p
else if(N==12)then
x(1)=-4.832953503336035_p
w(1)=4.233475195677999e-1_p
x(2)=-4.137346504695602_p
w(2)=9.383372528138173e-1_p
x(3)=-2.959626919870038_p
w(3)=1.311925386523753_p
x(4)=-1.430475948704023_p
w(4)=1.332631995639514_p
x(5)=3.167567098875902e-1_p
w(5)=7.818470088428661e-1_p
x(6)=2.348336613493352_p
w(6)=1.959399538349966e-1_p
x(7)=4.858585061341244_p
w(7)=2.143711027346318e-2_p
x(8)=7.927305253404231_p
w(8)=1.211865955508278e-3_p
x(9)=11.59644602767958_p
w(9)=3.668234504402100e-5_p
x(10)=15.92083478083526_p
w(10)=5.682777020069197e-7_p
x(11)=20.89909956395469_p
w(11)=4.391065224990981e-9_p
x(12)=25.98829043427648_p
w(12)=2.289708381095677e-11_p
else if(N==13)then
x(1)=-4.851015878314977_p
w(1)=3.778717396866450e-1_p
x(2)=-4.228414148214364_p
w(2)=8.435847083503486e-1_p
x(3)=-3.164675005844142_p
w(3)=1.203769777025464_p
x(4)=-1.761104226746171_p
w(4)=1.305068128874558_p
x(5)=-1.401260188317985e-1_p
w(5)=9.153405534024636e-1_p
x(6)=1.701498459192349_p
w(6)=3.094429138347338e-1_p
x(7)=3.924296602576920_p
w(7)=4.752424941344126e-2_p
x(8)=6.618473154903380_p
w(8)=3.918167779577290e-3_p
x(9)=9.806430395453388_p
w(9)=1.896361798447071e-4_p
x(10)=13.51005327559949_p
w(10)=5.384179669634296e-6_p
x(11)=17.73187910863928_p
w(11)=8.882765370759371e-8_p
x(12)=22.33944385913511_p
w(12)=9.243068824398238e-10_p
x(13)=26.5644969454541_p
w(13)=9.719946419522638e-12_p
else if(N==14)then
x(1)=-4.866313138623038_p
w(1)=3.392924445075787e-1_p
x(2)=-4.306029919713411_p
w(2)=7.618336422683668e-1_p
x(3)=-3.341771630014520_p
w(3)=1.104177029520435_p
x(4)=-2.052586448291894_p
w(4)=1.254849068367190_p
x(5)=-5.443558570043495e-1_p
w(5)=1.007131080898731_p
x(6)=1.147132139898313_p
w(6)=4.376873646155514e-1_p
x(7)=3.139097985411161_p
w(7)=9.073494497135749e-2_p
x(8)=5.532303695873265_p
w(8)=1.025906797931364e-2_p
x(9)=8.346750239456716_p
w(9)=7.177136385487098e-4_p
x(10)=11.58815984680166_p
w(10)=3.205611581702437e-5_p
x(11)=15.25414158979884_p
w(11)=9.178715930611361e-7_p
x(12)=19.29131320747642_p
w(12)=1.746715222939571e-8_p
x(13)=23.46145602062298_p
w(13)=2.616573682502410e-10_p
x(14)=26.93610583367992_p
w(14)=5.133240197869051e-12_p
else if(N==15)then
x(1)=-4.879377890822184_p
w(1)=3.062979787138303e-1_p
x(2)=-4.372658230099108_p
w(2)=6.909749323631109e-1_p
x(3)=-3.495422293811224_p
w(3)=1.013696154327525_p
x(4)=-2.309896646908802_p
w(4)=1.192642880003190_p
x(5)=-9.048227110866964e-1_p
w(5)=1.058721646714403_p
x(6)=6.641163102336031e-1_p
w(6)=5.659404099631450e-1_p
x(7)=2.469736777366241_p
w(7)=1.533115777526687e-1_p
x(8)=4.615606445098046_p
w(8)=2.282581000292083e-2_p
x(9)=7.128969685421823_p
w(9)=2.159935608432063e-3_p
x(10)=10.00838522859988_p
w(10)=1.378106718096373e-4_p
x(11)=13.24725500902007_p
w(11)=6.023335950632991e-6_p
x(12)=16.8156514004661_p
w(12)=1.846405965336684e-7_p
x(13)=20.61009541791579_p
w(13)=4.293046079337851e-9_p
x(14)=24.32582504396046_p
w(14)=9.466955107908116e-11_p
x(15)=27.18481265365727_p
w(15)=3.128095361913742e-12_p
else if(N==16)then
x(1)=-4.890622171284408_p
w(1)=2.778687054827043e-1_p
x(2)=-4.430242935555279_p
w(2)=6.292584256676949e-1_p
x(3)=-3.629364834761553_p
w(3)=9.320743106110085e-1_p
x(4)=-2.537450238145527_p
w(4)=1.125454946441205_p
x(5)=-1.227738355580661_p
w(5)=1.077014064239584_p
x(6)=2.372739519700209e-1_p
w(6)=6.806887131311750e-1_p
x(7)=1.891676856158484_p
w(7)=2.338369802996444e-1_p
x(8)=3.831659610697071_p
w(8)=4.457146801085220e-2_p
x(9)=6.095796380810981_p
w(9)=5.452376005302418e-3_p
x(10)=8.681607610102054_p
w(10)=4.655127465467675e-4_p
x(11)=11.57972386100505_p
w(11)=2.852076273605569e-5_p
x(12)=14.76912699120127_p
w(12)=1.279753058545667e-6_p
x(13)=18.19353948656167_p
w(13)=4.399856839801239e-8_p
x(14)=21.71137416838253_p
w(14)=1.294625883807720e-9_p
x(15)=24.99072554226508_p
w(15)=4.162061046852330e-11_p
x(16)=27.35755979738063_p
w(16)=2.099909915921855e-12_p
else if(N==17)then
x(1)=-4.900367915079619_p
w(1)=2.532048567125545e-1_p
x(2)=-4.480326397852633_p
w(2)=5.752425325959584e-1_p
x(3)=-3.746682515013291_p
w(3)=8.586904069752982e-1_p
x(4)=-2.739141445237935_p
w(4)=1.057598790001892_p
x(5)=-1.517792166926496_p
w(5)=1.070492048064619_p
x(6)=-1.441551490836641e-1_p
w(6)=7.729770797117261e-1_p
x(7)=1.386306920253577_p
w(7)=3.270014830210043e-1_p
x(8)=3.153856755946475_p
w(8)=7.811762086983273e-2_p
x(9)=5.207820441060063_p
w(9)=1.197207394007189e-2_p
x(10)=7.549318203685647_p
w(10)=1.306007889297997e-3_p
x(11)=10.1676906333015_p
w(11)=1.056518473248917e-4_p
x(12)=13.04584966077038_p
w(12)=6.474083437725367e-6_p
x(13)=16.14798203624671_p
w(13)=3.099299967706041e-7_p
x(14)=19.3958576725807_p
w(14)=1.235528478454788e-8_p
x(15)=22.62417640370255_p
w(15)=4.673304254534367e-10_p
x(16)=25.50485372966055_p
w(16)=2.128846461164431e-11_p
x(17)=27.48165468582232_p
w(17)=1.508740831677975e-12_p
else
call GD(-5)
end if
end subroutine GF_m5

! [-4kT;28kT]
subroutine GF_m4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.719496190687868_p
w(1)=2.798302110728518_p
x(2)=9.542779191832571e-1_p
w(2)=1.219847817188600_p
else if(N==3)then
x(1)=-3.173001330838952_p
w(1)=1.934954870616401_p
x(2)=-4.480233525138875e-1_p
w(2)=1.923940267908953_p
x(3)=3.489291950047200_p
w(3)=1.592547893917634e-1_p
else if(N==4)then
x(1)=-3.403204213447926_p
w(1)=1.435138927810520_p
x(2)=-1.258692687112987_p
w(2)=2.024550260904910_p
x(3)=1.675324833331991_p
w(3)=5.476526880506013e-1_p
x(4)=6.380725904450326_p
w(4)=1.080805115108681e-2_p
else if(N==5)then
x(1)=-3.538659672079778_p
w(1)=1.124978885215328_p
x(2)=-1.794910658932667_p
w(2)=1.884599964085916_p
x(3)=6.595228986011469e-1_p
w(3)=9.343858449282878e-1_p
x(4)=4.024026686034306_p
w(4)=7.364932843655850e-2_p
x(5)=9.501975760952318_p
w(5)=5.359052510274645e-4_p
else if(N==6)then
x(1)=-3.626661956246358_p
w(1)=9.178561243755631e-1_p
x(2)=-2.171061382873955_p
w(2)=1.690613826943969_p
x(3)=-3.498436978487875e-2_p
w(3)=1.197074646197141_p
x(4)=2.681838905450360_p
w(4)=2.063432944297232e-1_p
x(5)=6.650206900510375_p
w(5)=6.239469240614026e-3_p
x(6)=12.75561854700017_p
w(6)=2.256673010830692e-5_p
else if(N==7)then
x(1)=-3.688145295301211_p
w(1)=7.707538226589186e-1_p
x(2)=-2.447324584699679_p
w(2)=1.504071184348565_p
x(3)=-5.570610545204657e-1_p
w(3)=1.331023452721233_p
x(4)=1.775610373441099_p
w(4)=3.854982458842715e-1_p
x(5)=4.953623074362976_p
w(5)=2.638242682502301e-2_p
x(6)=9.450209430069680_p
w(6)=4.199160110651389e-4_p
x(7)=16.06534742521835_p
w(7)=8.794680419598918e-7_p
else if(N==8)then
x(1)=-3.733845972420305_p
w(1)=6.602226263094153e-1_p
x(2)=-2.659796350600368_p
w(2)=1.338575105587618_p
x(3)=-9.733046375810606e-1_p
w(3)=1.371571953258214_p
x(4)=1.097477745540687_p
w(4)=5.751300254181183e-1_p
x(5)=3.769251969166737_p
w(5)=7.005828952260144e-2_p
x(6)=7.399349280773653_p
w(6)=2.565944351582858e-3_p
x(7)=12.30389992130766_p
w(7)=2.594636139046003e-5_p
x(8)=19.26010726419203_p
w(8)=3.710817797475918e-8_p
else if(N==9)then
x(1)=-3.769661836247071_p
w(1)=5.729289408972883e-1_p
x(2)=-2.830459225038609_p
w(2)=1.193459475130992_p
x(3)=-1.319807886688976_p
w(3)=1.352704976190394_p
x(4)=5.503265361807453e-1_p
w(4)=7.468711459335535e-1_p
x(5)=2.864551389211362_p
w(5)=1.425723879736960e-1_p
x(6)=5.913046073942406_p
w(6)=9.381414948289596e-3_p
x(7)=9.882754982544691_p
w(7)=2.298570580611675e-4_p
x(8)=15.04711163490193_p
w(8)=1.727517877689388e-6_p
x(9)=22.0057565256003_p
w(9)=2.266965564467882e-9_p
else if(N==10)then
x(1)=-3.798698268399414_p
w(1)=5.017498466821237e-1_p
x(2)=-2.971392197167670_p
w(2)=1.066353660253128_p
x(3)=-1.615074681659437_p
w(3)=1.298526710798368_p
x(4)=8.822967268886134e-2_p
w(4)=8.824370018764732e-1_p
x(5)=2.136124262517174_p
w(5)=2.426448460530494e-1_p
x(6)=4.755519567536323_p
w(6)=2.527731756813593e-2_p
x(7)=8.095515659052536_p
w(7)=1.138718539827605e-3_p
x(8)=12.27962532363474_p
w(8)=2.168142878381369e-5_p
x(9)=17.51881567424734_p
w(9)=1.444614396521443e-7_p
x(10)=24.02646473021817_p
w(10)=2.557893330166875e-10_p
else if(N==11)then
x(1)=-3.822642677351183_p
w(1)=4.427924663662362e-1_p
x(2)=-3.089261668545320_p
w(2)=9.555203720544132e-1_p
x(3)=-1.868571188964308_p
w(3)=1.225728461890409_p
x(4)=-3.105211828290303e-1_p
w(4)=9.739131648503270e-1_p
x(5)=1.532054317739127_p
w(5)=3.610715155922896e-1_p
x(6)=3.821734306149450_p
w(6)=5.504777348198633e-2_p
x(7)=6.697395188838541_p
w(7)=3.933358569487692e-3_p
x(8)=10.22775375050172_p
w(8)=1.404429447076608e-4_p
x(9)=14.50330960425367_p
w(9)=2.355481670674708e-6_p
x(10)=19.62568123577933_p
w(10)=1.663223874806722e-8_p
x(11)=25.34673735293605_p
w(11)=5.335234612261972e-11_p
else if(N==12)then
x(1)=-3.842600617228095_p
w(1)=3.934796474818264e-1_p
x(2)=-3.188591488038206_p
w(2)=8.592173809516386e-1_p
x(3)=-2.086800652042785_p
w(3)=1.145386401087459_p
x(4)=-6.581655133340482e-1_p
w(4)=1.023107824215080_p
x(5)=1.020627365139442_p
w(5)=4.837499106583003e-1_p
x(6)=3.051921945621489_p
w(6)=1.020201641306174e-1_p
x(7)=5.567897443493338_p
w(7)=1.056808163657314e-2_p
x(8)=8.619915031903210_p
w(8)=6.013648698778510e-4_p
x(9)=12.24946410398367_p
w(9)=1.883882925996550e-5_p
x(10)=16.50184921799809_p
w(10)=3.113270410756178e-7_p
x(11)=21.34460548457477_p
w(11)=2.711772824619870e-9_p
x(12)=26.16957109414761_p
w(12)=1.767178454597837e-11_p
else if(N==13)then
x(1)=-3.859392984624978_p
w(1)=3.518732628513215e-1_p
x(2)=-3.272893627182742_p
w(2)=7.755760206442918e-1_p
x(3)=-2.275234967571434_p
w(3)=1.064220937229094_p
x(4)=-9.630828046508213e-1_p
w(4)=1.037630066273574_p
x(5)=5.801313755754914e-1_p
w(5)=5.967974920485231e-1_p
x(6)=2.406158000798594_p
w(6)=1.664485187756651e-1_p
x(7)=4.634969048807490_p
w(7)=2.356971765602155e-2_p
x(8)=7.317078603971266_p
w(8)=1.934778341324089e-3_p
x(9)=10.47245808692852_p
w(9)=9.620909299055192e-5_p
x(10)=14.12021869087786_p
w(10)=2.872875158235233e-6_p
x(11)=18.25016613817406_p
w(11)=5.150576309943437e-8_p
x(12)=22.70213519704724_p
w(12)=6.154313934850423e-10_p
x(13)=26.68585156102102_p
w(13)=7.959353946902964e-12_p
else if(N==14)then
x(1)=-3.873647362908058_p
w(1)=3.164759747884833e-1_p
x(2)=-3.344952225282095_p
w(2)=7.027976759547078e-1_p
x(3)=-2.438563586808292_p
w(3)=9.859619271966528e-1_p
x(4)=-1.231621975450772_p
w(4)=1.026719618901963_p
x(5)=1.953818830377154e-1_p
w(5)=6.903187234984148e-1_p
x(6)=1.856014536679264_p
w(6)=2.449409106385774e-1_p
x(7)=3.851215053387790_p
w(7)=4.550916846411016e-2_p
x(8)=6.236595506659806_p
w(8)=5.048388570734716e-3_p
x(9)=9.024198961477515_p
w(9)=3.602520121608356e-4_p
x(10)=12.21988379591527_p
w(10)=1.676512940696552e-5_p
x(11)=15.81575635515491_p
w(11)=5.118338127650749e-7_p
x(12)=19.74573740605663_p
w(12)=1.073762082606019e-8_p
x(13)=23.75274376432506_p
w(13)=1.861013433101850e-10_p
x(14)=27.02024034504466_p
w(14)=4.372118885177475e-12_p
else if(N==15)then
x(1)=-3.885846812151967_p
w(1)=2.861259204618207e-1_p
x(2)=-3.406970155409389_p
w(2)=6.392761359615396e-1_p
x(3)=-2.580735659583175_p
w(3)=9.124757261100261e-1_p
x(4)=-1.468872202160153_p
w(4)=9.987600451304013e-1_p
x(5)=-1.442833727268888e-1_p
w(5)=7.596673703294314e-1_p
x(6)=1.380713730721065_p
w(6)=3.311950517403451e-1_p
x(7)=3.183630122617651_p
w(7)=7.827856149550172e-2_p
x(8)=5.324941600264872_p
w(8)=1.122251136348441e-2_p
x(9)=7.816497368848368_p
w(9)=1.074324393301028e-3_p
x(10)=10.65747831993703_p
w(10)=7.090474396648561e-5_p
x(11)=13.83940229203109_p
w(11)=3.265395742723705e-6_p
x(12)=17.32601230877375_p
w(12)=1.079254899355019e-7_p
x(13)=21.00350044570157_p
w(13)=2.792205590143564e-9_p
x(14)=24.5588911601551_p
w(14)=7.112557234188877e-11_p
x(15)=27.24531966176286_p
w(15)=2.736412754857289e-12_p
else if(N==16)then
x(1)=-3.896366165445695_p
w(1)=2.599157969108047e-1_p
x(2)=-3.460693782323017_p
w(2)=5.836289405366787e-1_p
x(3)=-2.705040849718222_p
w(3)=8.445308977702743e-1_p
x(4)=-1.679063698961694_p
w(4)=9.603506770308918e-1_p
x(5)=-4.464773778809280e-1_p
w(5)=8.047190585652436e-1_p
x(6)=9.648853600578364e-1_p
w(6)=4.176737320075470e-1_p
x(7)=2.608225810915918_p
w(7)=1.224103866137166e-1_p
x(8)=4.545331952461768_p
w(8)=2.197619325244952e-2_p
x(9)=6.792179959706026_p
w(9)=2.692144788530944e-3_p
x(10)=9.345329283101190_p
w(10)=2.362282584952826e-4_p
x(11)=12.19550350394486_p
w(11)=1.512272639680444e-5_p
x(12)=15.31860172039516_p
w(12)=7.215643024720882e-7_p
x(13)=18.65259930115865_p
w(13)=2.697038626703092e-8_p
x(14)=22.04923549453098_p
w(14)=8.868488225942445e-10_p
x(15)=25.17784059067002_p
w(15)=3.267966760852194e-11_p
x(16)=27.40256025763032_p
w(16)=1.871692954698698e-12_p
else if(N==17)then
x(1)=-3.905499182759955_p
w(1)=2.371308817433313e-1_p
x(2)=-3.507515362316812_p
w(2)=5.346865218001956e-1_p
x(3)=-2.814207990776343_p
w(3)=7.822758503980214e-1_p
x(4)=-1.865785632675057_p
w(4)=9.162643227270816e-1_p
x(5)=-7.168158893333690e-1_p
w(5)=8.282482149164033e-1_p
x(6)=5.971071597429475e-1_p
w(6)=4.974400016063844e-1_p
x(7)=2.106992497927252_p
w(7)=1.766980619944267e-1_p
x(8)=3.871307073783989_p
w(8)=3.881124133122220e-2_p
x(9)=5.911915168082959_p
w(9)=5.881070175927631e-3_p
x(10)=8.225646136785887_p
w(10)=6.550167688119875e-4_p
x(11)=10.8028051188328_p
w(11)=5.500426277668062e-5_p
x(12)=13.62513966983421_p
w(12)=3.549898898241552e-6_p
x(13)=16.65360974450151_p
w(13)=1.820094275599684e-7_p
x(14)=19.80564791882743_p
w(14)=7.930320087283125e-9_p
x(15)=22.91322926912291_p
w(15)=3.352162146056149e-10_p
x(16)=25.65625168348385_p
w(16)=1.731022540393256e-11_p
x(17)=27.51611743769391_p
w(17)=1.363142132665268e-12_p
else
call GD(-4)
end if
end subroutine GF_m4

! [-3kT;28kT]
subroutine GF_m3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.899025452070118_p
w(1)=2.236589552938650_p
x(2)=1.474550522977270_p
w(2)=8.119977986344002e-1_p
else if(N==3)then
x(1)=-2.271684177544302_p
w(1)=1.607697409340634_p
x(2)=1.763421426295312e-1_p
w(2)=1.352267437130488_p
x(3)=4.104040177561584_p
w(3)=8.862250510192857e-2_p
else if(N==4)then
x(1)=-2.465648227572462_p
w(1)=1.221925334685008_p
x(2)=-5.388512070692477e-1_p
w(2)=1.502930229150082_p
x(3)=2.306216786427520_p
w(3)=3.182512859138186e-1_p
x(4)=7.066622536515267_p
w(4)=5.480501824141746e-3_p
else if(N==5)then
x(1)=-2.581982712007825_p
w(1)=9.738373875691214e-1_p
x(2)=-1.005187068110960_p
w(2)=1.463835156085197_p
x(3)=1.319478021135183_p
w(3)=5.731758279729339e-1_p
x(4)=4.719979571659280_p
w(4)=3.747928721501377e-2_p
x(5)=10.2289434209434_p
w(5)=2.596927307845844e-4_p
else if(N==6)then
x(1)=-2.658688364172685_p
w(1)=8.040754811995027e-1_p
x(2)=-1.332892493929035_p
w(2)=1.358760178861687_p
x(3)=6.623975003846010e-1_p
w(3)=7.754909858465806e-1_p
x(4)=3.383440997787066_p
w(4)=1.072520952592580e-1_p
x(5)=7.388487476276300_p
w(5)=2.997963097743525e-3_p
x(6)=13.50777155287103_p
w(6)=1.064730827933038e-5_p
else if(N==7)then
x(1)=-2.712978058889889_p
w(1)=6.811774763040251e-1_p
x(2)=-1.575568838967358_p
w(2)=1.239763196870922_p
x(3)=1.785339049347503e-1_p
w(3)=9.073086806497817e-1_p
x(4)=2.482782858453713_p
w(4)=2.074506905396260e-1_p
x(5)=5.696223886313128_p
w(5)=1.268981376283968e-2_p
x(6)=10.20778423258744_p
w(6)=1.970807304009247e-4_p
x(7)=16.81995273552066_p
w(7)=4.127154553961956e-7_p
else if(N==8)then
x(1)=-2.753852336911735_p
w(1)=5.872353830237487e-1_p
x(2)=-1.764355118924684_p
w(2)=1.124313798557934_p
x(3)=-2.032085434471270e-1_p
w(3)=9.784112467631029e-1_p
x(4)=1.812108722329556_p
w(4)=3.233051188571754e-1_p
x(5)=4.509747199402132_p
w(5)=3.410232512057980e-2_p
x(6)=8.154371091921846_p
w(6)=1.207216856254063e-3_p
x(7)=13.05149798127164_p
w(7)=1.224417775716178e-5_p
x(8)=19.95880665009265_p
w(8)=1.821649896492882e-8_p
else if(N==9)then
x(1)=-2.786228294827778_p
w(1)=5.120064765351395e-1_p
x(2)=-1.917603732720712_p
w(2)=1.016927149681775_p
x(3)=-5.196541050851862e-1_p
w(3)=1.003671627470109_p
x(4)=1.276112310619541_p
w(4)=4.405462276764263e-1_p
x(5)=3.600688196175699_p
w(5)=7.088452423073588e-2_p
x(6)=6.662637473329274_p
w(6)=4.441299977732405e-3_p
x(7)=10.6222339874823_p
w(7)=1.091963343656381e-4_p
x(8)=15.74726525439089_p
w(8)=8.484198230125299e-7_p
x(9)=22.5675023743616_p
w(9)=1.246943996237769e-9_p
else if(N==10)then
x(1)=-2.812648726366030_p
w(1)=4.501052300082581e-1_p
x(2)=-2.045042165345247_p
w(2)=9.190136225244954e-1_p
x(3)=-7.886673067579358e-1_p
w(3)=9.961080432899547e-1_p
x(4)=8.297639649402581e-1_p
w(4)=5.466555397817980e-1_p
x(5)=2.870029730295381_p
w(5)=1.240992112906949e-1_p
x(6)=5.501343241322702_p
w(6)=1.205259954705237e-2_p
x(7)=8.831673805088247_p
w(7)=5.423984334230571e-4_p
x(8)=12.98154404829472_p
w(8)=1.063066266821232e-5_p
x(9)=18.14207206557396_p
w(9)=7.587256715923879e-8_p
x(10)=24.42115786379787_p
w(10)=1.621387384172526e-10_p
else if(N==11)then
x(1)=-2.834526829072903_p
w(1)=3.985149002955992e-1_p
x(2)=-2.152132438514930_p
w(2)=8.311506715532310e-1_p
x(3)=-1.019422586932029_p
w(3)=9.667244053812808e-1_p
x(4)=4.501920317950557e-1_p
w(4)=6.326395485651011e-1_p
x(5)=2.267566335623004_p
w(5)=1.911261426737508e-1_p
x(6)=4.565948204814284_p
w(6)=2.648900040493019e-2_p
x(7)=7.434228813945565_p
w(7)=1.872971652345627e-3_p
x(8)=10.93512995721358_p
w(8)=6.849164313735391e-5_p
x(9)=15.15242501496817_p
w(9)=1.209893453265954e-6_p
x(10)=20.1576418804968_p
w(10)=9.472088959479658e-9_p
x(11)=25.6059947036598_p
w(11)=3.813233829133821e-11_p
else if(N==12)then
x(1)=-2.852824702277978_p
w(1)=3.551460376958175e-1_p
x(2)=-2.242741450930988_p
w(2)=7.531184027409106e-1_p
x(3)=-1.218237111179325_p
w(3)=9.242884427427481e-1_p
x(4)=1.232273218327802e-1_p
w(4)=6.946257867359211e-1_p
x(5)=1.761755610645034_p
w(5)=2.663309633107899e-1_p
x(6)=3.796024486177382_p
w(6)=4.974836263988448e-2_p
x(7)=6.307255519475277_p
w(7)=5.028393651904774e-3_p
x(8)=9.334368440975059_p
w(8)=2.912760832204787e-4_p
x(9)=12.91693892170837_p
w(9)=9.515125051455554e-6_p
x(10)=17.08838422261022_p
w(10)=1.691545968742647e-7_p
x(11)=21.78394166750524_p
w(11)=1.678461183671446e-9_p
x(12)=26.33901674284498_p
w(12)=1.374414297351063e-11_p
else if(N==13)then
x(1)=-2.868267901231426_p
w(1)=3.183923918993997e-1_p
x(2)=-2.319924212782961_p
w(2)=6.841608968244931e-1_p
x(3)=-1.390244027088493_p
w(3)=8.751315351607117e-1_p
x(4)=-1.610974425361742e-1_p
w(4)=7.331493395214295e-1_p
x(5)=1.330486032644570_p
w(5)=3.428446140065157e-1_p
x(6)=3.151455817508908_p
w(6)=8.270553095904738e-2_p
x(7)=5.377421283962133_p
w(7)=1.122283912537217e-2_p
x(8)=8.038913905049883_p
w(8)=9.307494321723130e-4_p
x(9)=11.15496386834743_p
w(9)=4.790953172998141e-5_p
x(10)=14.73984776130302_p
w(10)=1.514947587868183e-6_p
x(11)=18.76952986806935_p
w(11)=2.974659644649785e-8_p
x(12)=23.05702130731205_p
w(12)=4.114478830070058e-10_p
x(13)=26.79963447013927_p
w(13)=6.546994700660661e-12_p
else if(N==14)then
x(1)=-2.881413880102732_p
w(1)=2.870008289705479e-1_p
x(2)=-2.386117265094547_p
w(2)=6.233123918942308e-1_p
x(3)=-1.539709452025123_p
w(3)=8.234799224884609e-1_p
x(4)=-4.101386505439193e-1_p
w(4)=7.513687538123663e-1_p
x(5)=9.578314827336609e-1_p
w(5)=4.143243221501004e-1_p
x(6)=2.604027117681297_p
w(6)=1.247515498300991e-1_p
x(7)=4.596817116451889_p
w(7)=2.174923118568883e-2_p
x(8)=6.965519101541045_p
w(8)=2.414216691482671e-3_p
x(9)=9.719653267149262_p
w(9)=1.771992690462118e-4_p
x(10)=12.86356399381045_p
w(10)=8.645347229447050e-6_p
x(11)=16.38273270561483_p
w(11)=2.832029422096728e-7_p
x(12)=20.19822632414037_p
w(12)=6.594183783663008e-9_p
x(13)=24.03631182503577_p
w(13)=1.329394247201157e-10_p
x(14)=27.09953625637452_p
w(14)=3.732564242964601e-12_p
else if(N==15)then
x(1)=-2.892693337659955_p
w(1)=2.599916542661336e-1_p
x(2)=-2.443258091841631_p
w(2)=5.695881844030007e-1_p
x(3)=-1.670166233281978_p
w(3)=7.719901847498886e-1_p
x(4)=-6.295080883184249e-1_p
w(4)=7.534603097191676e-1_p
x(5)=6.322024648937350e-1_p
w(5)=4.761043935637433e-1_p
x(6)=2.133243625307697_p
w(6)=1.738478872284703e-1_p
x(7)=3.932362175513130_p
w(7)=3.770077272941856e-2_p
x(8)=6.060398916342580_p
w(8)=5.343456199548791e-3_p
x(9)=8.523348199631188_p
w(9)=5.227839138786428e-4_p
x(10)=11.32031116707836_p
w(10)=3.590810018414745e-5_p
x(11)=14.43971827232451_p
w(11)=1.752035305879567e-6_p
x(12)=17.83856440555098_p
w(12)=6.279074822415592e-8_p
x(13)=21.39323171810724_p
w(13)=1.817525498709437e-9_p
x(14)=24.78514953478223_p
w(14)=5.364077699467135e-11_p
x(15)=27.30266186479811_p
w(15)=2.396111185640922e-12_p
else if(N==16)then
x(1)=-2.902441783870170_p
w(1)=2.365945058523698e-1_p
x(2)=-2.492890695414737_p
w(2)=5.220700743649979e-1_p
x(3)=-1.784535927968503_p
w(3)=7.222368943988506e-1_p
x(4)=-8.236260663058275e-1_p
w(4)=7.435747131467414e-1_p
x(5)=3.450577165967286e-1_p
w(5)=5.255942466338618e-1_p
x(6)=1.723871899644886_p
w(6)=2.269494162283944e-1_p
x(7)=3.360236551306058_p
w(7)=5.970163824032627e-2_p
x(8)=5.286682284290517_p
w(8)=1.044168586161612e-2_p
x(9)=7.509144337737389_p
w(9)=1.298015367638406e-3_p
x(10)=10.02419962700966_p
w(10)=1.178193399878887e-4_p
x(11)=12.82145827512001_p
w(11)=7.921125352496128e-6_p
x(12)=15.87316160101823_p
w(12)=4.038839381423091e-7_p
x(13)=19.11156852074037_p
w(13)=1.649301631149473e-8_p
x(14)=22.38264956516756_p
w(14)=6.085543604590762e-10_p
x(15)=25.35929287507657_p
w(15)=2.573622961851569e-11_p
x(16)=27.44542636540746_p
w(16)=1.668484498893234e-12_p
else if(N==17)then
x(1)=-2.910923164558058_p
w(1)=2.161986979779462e-1_p
x(2)=-2.536252266640840_p
w(2)=4.799375900746842e-1_p
x(3)=-1.885237277202762_p
w(3)=6.750826981710906e-1_p
x(4)=-9.960708875416440e-1_p
w(4)=7.253140030920000e-1_p
x(5)=8.999148015084975e-2_p
w(5)=5.620839461098924e-1_p
x(6)=1.364400559117855_p
w(6)=2.806260768375153e-1_p
x(7)=2.862714564725175_p
w(7)=8.772177422076217e-2_p
x(8)=4.617942557301046_p
w(8)=1.845570627787070e-2_p
x(9)=6.637869618834872_p
w(9)=2.814147393602256e-3_p
x(10)=8.918336394421992_p
w(10)=3.224257290321837e-4_p
x(11)=11.44963576676557_p
w(11)=2.824544202156030e-5_p
x(12)=14.21164147397708_p
w(12)=1.928539181022906e-6_p
x(13)=17.16190744612818_p
w(13)=1.063652852110110e-7_p
x(14)=20.21383525779616_p
w(14)=5.085894798414830e-9_p
x(15)=23.19769652654396_p
w(15)=2.409350948075941e-10_p
x(16)=25.80307216168673_p
w(16)=1.410590199229038e-11_p
x(17)=27.54909542214247_p
w(17)=1.231082786104584e-12_p
else
call GD(-3)
end if
end subroutine GF_m3

! [-2kT;28kT]
subroutine GF_m2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.066219023895159_p
w(1)=1.641101496153085_p
x(2)=2.078600414798994_p
w(2)=4.858265148891959e-1_p
else if(N==3)then
x(1)=-1.367356274150158_p
w(1)=1.231471460900883_p
x(2)=8.549448823174324e-1_p
w(2)=8.501893292439827e-1_p
x(3)=4.795098267272878_p
w(3)=4.526722089741556e-2_p
else if(N==4)then
x(1)=-1.527759573916547_p
w(1)=9.633808790401108e-1_p
x(2)=2.103215114010060e-1_p
w(2)=9.940882735744758e-1_p
x(3)=3.011200119113787_p
w(3)=1.668502520063998e-1_p
x(4)=7.813472459107871_p
w(4)=2.608606421294619e-3_p
else if(N==5)then
x(1)=-1.625848223671428_p
w(1)=7.833642452189959e-1_p
x(2)=-2.010528302071744e-1_p
w(2)=1.013086088449876_p
x(3)=2.043178315435759_p
w(3)=3.125742940733798e-1_p
x(4)=5.478045505612116_p
w(4)=1.778399381338331e-2_p
x(5)=11.00771075824888_p
w(5)=1.193894866459794e-4_p
else if(N==6)then
x(1)=-1.691550303309914_p
w(1)=6.563488139613267e-1_p
x(2)=-4.883863700588573e-1_p
w(2)=9.760492180649115e-1_p
x(3)=1.409424555882679_p
w(3)=4.417819464059296e-1_p
x(4)=4.147798707913458_p
w(4)=5.137673516301038e-2_p
x(5)=8.177388763141526_p
w(5)=1.366496142921156e-3_p
x(6)=14.30453643213596_p
w(6)=4.801304181766444e-6_p
else if(N==7)then
x(1)=-1.738728411039952_p
w(1)=5.621112911844864e-1_p
x(2)=-7.017938316679547e-1_p
w(2)=9.174465567282949e-1_p
x(3)=9.499513837054866e-1_p
w(3)=5.400523788502675e-1_p
x(4)=3.250675589455869_p
w(4)=1.014491194553968e-1_p
x(5)=6.488431669972071_p
w(5)=5.779814705047201e-3_p
x(6)=11.00637119128034_p
w(6)=8.866291065820669e-5_p
x(7)=17.60682849359024_p
w(7)=1.872081302096272e-7_p
else if(N==8)then
x(1)=-1.774756725972620_p
w(1)=4.885055188464281e-1_p
x(2)=-8.691522996915342e-1_p
w(2)=8.519542622484640e-1_p
x(3)=5.912310800482660e-1_p
w(3)=6.074385537244972e-1_p
x(4)=2.582498518189796_p
w(4)=1.628325294762829e-1_p
x(5)=5.299242806436445_p
w(5)=1.564601108419681e-2_p
x(6)=8.947420430533974_p
w(6)=5.455237138383167e-4_p
x(7)=13.82785726658719_p
w(7)=5.603124143276376e-6_p
x(8)=20.66565356901051_p
w(8)=8.824430564977699e-9_p
else if(N==9)then
x(1)=-1.803611440996031_p
w(1)=4.285671518511120e-1_p
x(2)=-1.006048818224130_p
w(2)=7.855179968105972e-1_p
x(3)=2.962832250887796e-1_p
w(3)=6.480648995981371e-1_p
x(4)=2.050804115955639_p
w(4)=2.297722982255658e-1_p
x(5)=4.385980546178760_p
w(5)=3.293654276632361e-2_p
x(6)=7.449453063176787_p
w(6)=2.018374438378672e-3_p
x(7)=11.38961588370693_p
w(7)=5.033769828789801e-5_p
x(8)=16.46306863902885_p
w(8)=4.089635931717128e-7_p
x(9)=23.11437549728397_p
w(9)=6.902855824619800e-10_p
else if(N==10)then
x(1)=-1.827317366991254_p
w(1)=3.786888271762620e-1_p
x(2)=-1.120435800431028_p
w(2)=7.212713598520514e-1_p
x(3)=4.746179748060238e-2_p
w(3)=6.665135371166863e-1_p
x(4)=1.612302391069708_p
w(4)=2.960787366437782e-1_p
x(5)=3.653086323091840_p
w(5)=5.861989668659117e-2_p
x(6)=6.285094100443986_p
w(6)=5.500034502031111e-3_p
x(7)=9.596364818330281_p
w(7)=2.504792078877112e-4_p
x(8)=13.70272485564853_p
w(8)=5.100255456277180e-6_p
x(9)=18.770318587718_p
w(9)=3.949742634256470e-8_p
x(10)=24.7947270629422_p
w(10)=1.041105780318081e-10_p
else if(N==11)then
x(1)=-1.847038840732153_p
w(1)=3.367713885588222e-1_p
x(2)=-1.216899410347830_p
w(2)=6.610845849885466e-1_p
x(3)=-1.647405539637964e-1_p
w(3)=6.676837712313705e-1_p
x(4)=1.243749910520723_p
w(4)=3.562088375120265e-1_p
x(5)=3.051023854400773_p
w(5)=9.214808211400492e-2_p
x(6)=5.349300168153696_p
w(6)=1.213473869638031e-2_p
x(7)=8.200535636566549_p
w(7)=8.633721201062387e-4_p
x(8)=11.66395050961729_p
w(8)=3.261799651168786e-5_p
x(9)=15.81339070978402_p
w(9)=6.124130461980342e-7_p
x(10)=20.6872187683996_p
w(10)=5.383919851941883e-9_p
x(11)=25.84846722412157_p
w(11)=2.754612618514685e-11_p
else if(N==12)then
x(1)=-1.863598956676126_p
w(1)=3.012855106349147e-1_p
x(2)=-1.298794923064681_p
w(2)=6.058170827536423e-1_p
x(3)=-3.469599515254002e-1_p
w(3)=6.563558041851382e-1_p
x(4)=9.298341625068004e-1_p
w(4)=4.064837199609452e-1_p
x(5)=2.548044259843429_p
w(5)=1.316152221055095e-1_p
x(6)=4.580454551719119_p
w(6)=2.291722121212869e-2_p
x(7)=7.077129108129977_p
w(7)=2.311075087415250e-3_p
x(8)=10.07171718009481_p
w(8)=1.375614310591449e-4_p
x(9)=13.59969870825193_p
w(9)=4.721519568292668e-6_p
x(10)=17.68064866962556_p
w(10)=9.110012737039939e-8_p
x(11)=22.21682266243122_p
w(11)=1.041070899693941e-9_p
x(12)=26.49734786019661_p
w(12)=1.076162684374339e-11_p
else if(N==13)then
x(1)=-1.877626539757568_p
w(1)=2.710263091203644e-1_p
x(2)=-1.368789353225323_p
w(2)=5.556524848126242e-1_p
x(3)=-5.043873375523478e-1_p
w(3)=6.366188060989088e-1_p
x(4)=6.595108649183976e-1_p
w(4)=4.452815544742493e-1_p
x(5)=2.121790095967045_p
w(5)=1.743142081727323e-1_p
x(6)=3.937856062395721_p
w(6)=3.842942081633501e-2_p
x(7)=6.151547445365560_p
w(7)=5.145075613060960e-3_p
x(8)=8.784786347407453_p
w(8)=4.359525869184018e-4_p
x(9)=11.85484268525603_p
w(9)=2.339308213734387e-5_p
x(10)=15.36948908284093_p
w(10)=7.888788075939885e-7_p
x(11)=19.29003696956363_p
w(11)=1.710463160181019e-8_p
x(12)=23.40407802864807_p
w(12)=2.761062167890327e-10_p
x(13)=26.90639186269183_p
w(13)=5.405056859881534e-12_p
else if(N==14)then
x(1)=-1.889607166243460_p
w(1)=2.450407066256535e-1_p
x(2)=-1.429009934367444_p
w(2)=5.104086392715312e-1_p
x(3)=-6.411682169352078e-1_p
w(3)=6.116616880036473e-1_p
x(4)=4.246010380048966e-1_p
w(4)=4.725998518652673e-1_p
x(5)=1.756049525159153_p
w(5)=2.173537261998063e-1_p
x(6)=3.393153644963413_p
w(6)=5.869094751781895e-2_p
x(7)=5.375322166373433_p
w(7)=9.960331901979801e-3_p
x(8)=7.719528279967035_p
w(8)=1.122231700753107e-3_p
x(9)=10.433946791514_p
w(9)=8.533658559950037e-5_p
x(10)=13.51990189421435_p
w(10)=4.391841628831080e-6_p
x(11)=16.95543193892825_p
w(11)=1.553860361774350e-7_p
x(12)=20.64883837390054_p
w(12)=4.044035010942553e-9_p
x(13)=24.31232718801503_p
w(13)=9.533210162890251e-11_p
x(14)=27.17435901992922_p
w(14)=3.191907164108646e-12_p
else if(N==15)then
x(1)=-1.899917711226074_p
w(1)=2.225750040053052e-1_p
x(2)=-1.481150911267414_p
w(2)=4.697311736565052e-1_p
x(3)=-7.606378699593550e-1_p
w(3)=5.838258679423345e-1_p
x(4)=2.189273467816225e-1_p
w(4)=4.894694109047491e-1_p
x(5)=1.438861108321185_p
w(5)=2.581587420921260e-1_p
x(6)=2.925903602040985_p
w(6)=8.314654399825779e-2_p
x(7)=4.715167403081786_p
w(7)=1.728601942513795e-2_p
x(8)=6.821998383525514_p
w(8)=2.467653024568843e-3_p
x(9)=9.250198486967651_p
w(9)=2.487452631705718e-4_p
x(10)=11.99762303058909_p
w(10)=1.788349244269541e-5_p
x(11)=15.04873937340233_p
w(11)=9.296693511016707e-7_p
x(12)=18.35356810904815_p
w(12)=3.634209364652177e-8_p
x(13)=21.7793990270152_p
w(13)=1.183552489676033e-9_p
x(14)=25.00485529856391_p
w(14)=4.058687649291027e-11_p
x(15)=27.35707901151831_p
w(15)=2.099045813335250e-12_p
else if(N==16)then
x(1)=-1.908853129713469_p
w(1)=2.030304032983510e-1_p
x(2)=-1.526566486744671_p
w(2)=4.332003561526995e-1_p
x(3)=-8.655014491332802e-1_p
w(3)=5.547568296087259e-1_p
x(4)=3.772106570131268e-2_p
w(4)=4.974396095518102e-1_p
x(5)=1.161252961841189_p
w(5)=2.947738556253682e-1_p
x(6)=2.520955259516912_p
w(6)=1.107725541543959e-1_p
x(7)=4.147245206638792_p
w(7)=2.748393616411373e-2_p
x(8)=6.055271325937362_p
w(8)=4.797327616968121e-3_p
x(9)=8.247125195676158_p
w(9)=6.110984651747726e-4_p
x(10)=10.71891428803981_p
w(10)=5.771034229683523e-5_p
x(11)=13.45820896816264_p
w(11)=4.095286454262718e-6_p
x(12)=16.4332241962778_p
w(12)=2.242790512726844e-7_p
x(13)=19.57066780380977_p
w(13)=1.005694657225122e-8_p
x(14)=22.71178392333992_p
w(14)=4.181202134013470e-10_p
x(15)=25.53535333311212_p
w(15)=2.031784591090421e-11_p
x(16)=27.48631794371693_p
w(16)=1.486848974398850e-12_p
else if(N==17)then
x(1)=-1.916646506905662_p
w(1)=1.859278364356831e-1_p
x(2)=-1.566345637608438_p
w(2)=4.003877785420458e-1_p
x(3)=-9.579703707237576e-1_p
w(3)=5.255685615488335e-1_p
x(4)=-1.227791347681770e-1_p
w(4)=4.982073831856813e-1_p
x(5)=9.163852151641987e-1_p
w(5)=3.259664290231002e-1_p
x(6)=2.166833106097433_p
w(6)=1.402573772003945e-1_p
x(7)=3.653912481565283_p
w(7)=4.067809544751033e-2_p
x(8)=5.392930700404975_p
w(8)=8.450722224695879e-3_p
x(9)=7.385806178160436_p
w(9)=1.312746704328139e-3_p
x(10)=9.627974383444531_p
w(10)=1.556827205336367e-4_p
x(11)=12.10882071442244_p
w(11)=1.429544016763205e-5_p
x(12)=14.80587040723624_p
w(12)=1.037305340332393e-6_p
x(13)=17.6732169556327_p
w(13)=6.182044112759068e-8_p
x(14)=20.6206341396882_p
w(14)=3.257461548172730e-9_p
x(15)=23.47778545971734_p
w(15)=1.734392374274476e-10_p
x(16)=25.94556563848112_p
w(16)=1.151381410321773e-11_p
x(17)=27.58069819276633_p
w(17)=1.110920514976531e-12_p
else
call GD(-2)
end if
end subroutine GF_m2

! [-1kT;28kT]
subroutine GF_m1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.078062677819057e-1_p
w(1)=1.057155731805890_p
x(2)=2.782863709736576_p
w(2)=2.561059557116418e-1_p
else if(N==3)then
x(1)=-4.522745892059147e-1_p
w(1)=8.263518752299819e-1_p
x(2)=1.608264055573279_p
w(2)=4.657802189931994e-1_p
x(3)=5.568718345531363_p
w(3)=2.112959329435017e-2_p
else if(N==4)then
x(1)=-5.846780457229488e-1_p
w(1)=6.659130846217483e-1_p
x(2)=1.010149595051907_p
w(2)=5.673797988240753e-1_p
x(3)=3.796845287234214_p
w(3)=7.880905821205630e-2_p
x(4)=8.626776698219871_p
w(4)=1.159745859651517e-3_p
else if(N==5)then
x(1)=-6.669709648550377e-1_p
w(1)=5.533088652487984e-1_p
x(2)=6.365660210351705e-1_p
w(2)=6.008980422339498e-1_p
x(3)=2.841062847470083_p
w(3)=1.511418706468665e-1_p
x(4)=6.301524442736383_p
w(4)=7.861103675158295e-3_p
x(5)=11.84356803799784_p
w(5)=5.180571275841341e-5_p
else if(N==6)then
x(1)=-7.228946867177031e-1_p
w(1)=4.711593306400876e-1_p
x(2)=3.783254303605711e-1_p
w(2)=5.988256837998270e-1_p
x(3)=2.220852527479318_p
w(3)=2.199145299366975e-1_p
x(4)=4.976919984639535_p
w(4)=2.277106885014876e-2_p
x(5)=9.020553111285539_p
w(5)=5.890136267335712e-4_p
x(6)=15.15002646016853_p
w(6)=2.060664036973440e-6_p
else if(N==7)then
x(1)=-7.636340810325732e-1_p
w(1)=4.084751230439210e-1_p
x(2)=1.868427812566228e-1_p
w(2)=5.793346695441710e-1_p
x(3)=1.774823068026562_p
w(3)=2.774668035921570e-1_p
x(4)=4.081562447844651_p
w(4)=4.545514705197332e-2_p
x(5)=7.332082266689318_p
w(5)=2.491727401818586e-3_p
x(6)=11.84849531713624_p
w(6)=3.813487421912924e-5_p
x(7)=18.42609155804118_p
w(7)=8.200927137588759e-8_p
else if(N==8)then
x(1)=-7.951910127236238e-1_p
w(1)=3.582926076682870e-1_p
x(2)=3.613481544701380e-2_p
w(2)=5.513088998131965e-1_p
x(3)=1.428744519254361_p
w(3)=3.223839316515998e-1_p
x(4)=3.412865963462507_p
w(4)=7.425237834995567e-2_p
x(5)=6.138234144238730_p
w(5)=6.784970874670294e-3_p
x(6)=9.780131200861643_p
w(6)=2.364112012139770e-4_p
x(7)=14.6336434265246_p
w(7)=2.483727739609199e-6_p
x(8)=21.37600877947905_p
w(8)=4.230868609773721e-9_p
else if(N==9)then
x(1)=-8.207253543627185e-1_p
w(1)=3.166609371594900e-1_p
x(2)=-8.750799874232201e-2_p
w(2)=5.191158501202568e-1_p
x(3)=1.146368537151268_p
w(3)=3.551147705406583e-1_p
x(4)=2.881594780290035_p
w(4)=1.070698828548217e-1_p
x(5)=5.220269803029601_p
w(5)=1.439749635313714e-2_p
x(6)=8.274618389268056_p
w(6)=8.800704292194755e-4_p
x(7)=12.18606574751719_p
w(7)=2.248622235610700e-5_p
x(8)=17.19410293444689_p
w(8)=1.934520325409776e-7_p
x(9)=23.64249730217967_p
w(9)=3.855594004431370e-10_p
else if(N==10)then
x(1)=-8.418319106132535e-1_p
w(1)=2.815653630293498e-1_p
x(2)=-1.909169121611519e-1_p
w(2)=4.854391224209688e-1_p
x(3)=9.103381442301566e-1_p
w(3)=3.765609686888652e-1_p
x(4)=2.446132210470862_p
w(4)=1.413272607429933e-1_p
x(5)=4.485171412342677_p
w(5)=2.584984181831294e-2_p
x(6)=7.107250536344091_p
w(6)=2.404709265378640e-3_p
x(7)=10.39077148650317_p
w(7)=1.120090811086726e-4_p
x(8)=14.44380127517699_p
w(8)=2.392017960602848e-6_p
x(9)=19.40269933905211_p
w(9)=2.038485515863014e-8_p
x(10)=25.1463410782612_p
w(10)=6.773830211709509e-11_p
else if(N==11)then
x(1)=-8.594699743977939e-1_p
w(1)=2.517698417009986e-1_p
x(2)=-2.781896530755930e-1_p
w(2)=4.520613485212229e-1_p
x(3)=7.106870184619497e-1_p
w(3)=3.881924920098230e-1_p
x(4)=2.083008272007044_p
w(4)=1.744691905455544e-1_p
x(5)=3.883188683941940_p
w(5)=4.105740845086912e-2_p
x(6)=6.171554339938257_p
w(6)=5.310923399970432e-3_p
x(7)=8.997212975532451_p
w(7)=3.850218921238762e-4_p
x(8)=12.41509972257524_p
w(8)=1.515261441779736e-5_p
x(9)=16.48635624546105_p
w(9)=3.053073173232986e-7_p
x(10)=21.21356260583586_p
w(10)=3.055136983746473e-9_p
x(11)=26.07464599668127_p
w(11)=2.009698266272253e-11_p
else if(N==12)then
x(1)=-8.743406051156989e-1_p
w(1)=2.263231729177926e-1_p
x(2)=-3.523811216898585e-1_p
w(2)=4.200464127328107e-1_p
x(3)=5.403085343679913e-1_p
w(3)=3.918455279523610e-1_p
x(4)=1.776204299171638_p
w(4)=2.045203817966650e-1_p
x(5)=3.381965839406048_p
w(5)=5.939292655938005e-2_p
x(6)=5.404409173353680_p
w(6)=1.004130786255292e-2_p
x(7)=7.877978762583906_p
w(7)=1.026323035063854e-3_p
x(8)=10.8328225222377_p
w(8)=6.328552008630635e-5_p
x(9)=14.29828087053804_p
w(9)=2.299866430341445e-6_p
x(10)=18.27850733825196_p
w(10)=4.861878946118430e-8_p
x(11)=22.64270921883377_p
w(11)=6.471234777167123e-10_p
x(12)=26.6451860335148_p
w(12)=8.475744233961196e-12_p
else if(N==13)then
x(1)=-8.869843145810923e-1_p
w(1)=2.044554652746828e-1_p
x(2)=-4.159023667383301e-1_p
w(2)=3.899502053902478e-1_p
x(3)=3.937615922041083e-1_p
w(3)=3.893634124333821e-1_p
x(4)=1.514041748883917_p
w(4)=2.302516450375936e-1_p
x(5)=2.958780925085472_p
w(5)=7.987737769966760e-2_p
x(6)=4.764341534294672_p
w(6)=1.687825635659066e-2_p
x(7)=6.957285538763328_p
w(7)=2.275024224396071e-3_p
x(8)=9.555391322243892_p
w(8)=1.986955226542266e-4_p
x(9)=12.57276730512685_p
w(9)=1.119017950676392e-5_p
x(10)=16.00941421730483_p
w(10)=4.054178754007605e-7_p
x(11)=19.81147717369867_p
w(11)=9.790518065412468e-9_p
x(12)=23.74311604235664_p
w(12)=1.859410030282124e-10_p
x(13)=27.00658414924037_p
w(13)=4.475295184301280e-12_p
else if(N==14)then
x(1)=-8.978201928014912e-1_p
w(1)=1.855469088816362e-1_p
x(2)=-4.706608058454486e-1_p
w(2)=3.620099214232820e-1_p
x(3)=2.668176495959025e-1_p
w(3)=3.823821795067373e-1_p
x(4)=1.287836975151639_p
w(4)=2.511065743132971e-1_p
x(5)=2.597197936410198_p
w(5)=1.013896169602499e-1_p
x(6)=4.222676603465461_p
w(6)=2.588898073284910e-2_p
x(7)=6.186127418558170_p
w(7)=4.387961214488559e-3_p
x(8)=8.499048126050626_p
w(8)=5.070552490082591e-4_p
x(9)=11.1677477083094_p
w(9)=4.020589875136146e-5_p
x(10)=14.18937450773142_p
w(10)=2.196284462908307e-6_p
x(11)=17.53396943878167_p
w(11)=8.450527428145214e-8_p
x(12)=21.09741920369978_p
w(12)=2.476159682137176e-9_p
x(13)=24.58083775019723_p
w(13)=6.860218834400212e-11_p
x(14)=27.24501309121001_p
w(14)=2.732432947941632e-12_p
else if(N==15)then
x(1)=-9.071749201294695e-1_p
w(1)=1.690998785391312e-1_p
x(2)=-5.181688325696046e-1_p
w(2)=3.362729657731796e-1_p
x(3)=1.561541896210443e-1_p
w(3)=3.722537057303120e-1_p
x(4)=1.091025393266233_p
w(4)=2.670429635591579e-1_p
x(5)=2.285065641596079_p
w(5)=1.228439180109009e-1_p
x(6)=3.758855106362711_p
w(6)=3.692130575470826e-2_p
x(7)=5.530979508492618_p
w(7)=7.595807839012643e-3_p
x(8)=7.609811698347556_p
w(8)=1.106218560418886e-3_p
x(9)=9.997615936096951_p
w(9)=1.156619057640351e-4_p
x(10)=12.68997136226158_p
w(10)=8.752552052569001e-6_p
x(11)=15.66679098736239_p
w(11)=4.875719850436514e-7_p
x(12)=18.87107531213022_p
w(12)=2.091746447759004e-8_p
x(13)=22.16194981866789_p
w(13)=7.708092694686446e-10_p
x(14)=25.21817061509551_p
w(14)=3.079594443956969e-11_p
x(15)=27.40876956465707_p
w(15)=1.838657442777933e-12_p
else if(N==16)then
x(1)=-9.153053337543264e-1_p
w(1)=1.547136441752624e-1_p
x(2)=-5.596330184574947e-1_p
w(2)=3.126781642247726e-1_p
x(3)=5.912872236843430e-2_p
w(3)=3.600443790751043e-1_p
x(4)=9.185553827088702e-1_p
w(4)=2.783629098451447e-1_p
x(5)=2.013220884603081_p
w(5)=1.433120227106271e-1_p
x(6)=3.357697158433899_p
w(6)=4.963932439817425e-2_p
x(7)=4.967914188684676_p
w(7)=1.206457010612082e-2_p
x(8)=6.850760572969147_p
w(8)=2.135840536744543e-3_p
x(9)=9.006513392097201_p
w(9)=2.808711167952853e-4_p
x(10)=11.43002632907558_p
w(10)=2.774289480793850e-5_p
x(11)=14.10619654307265_p
w(11)=2.088519139972804e-6_p
x(12)=16.99901732909963_p
w(12)=1.234971761988463e-7_p
x(13)=20.02994537330607_p
w(13)=6.112721438603129e-9_p
x(14)=23.03668004516231_p
w(14)=2.875440233801364e-10_p
x(15)=25.70621837363787_p
w(15)=1.607179831220556e-11_p
x(16)=27.52536681134837_p
w(16)=1.323961794675061e-12_p
else if(N==17)then
x(1)=-9.224152973746454e-1_p
w(1)=1.420637360989414e-1_p
x(2)=-5.960232479245713e-1_p
w(2)=2.911060109370537e-1_p
x(3)=-2.638478284075164e-2_p
w(3)=3.465676804916837e-1_p
x(4)=7.664718986765632e-1_p
w(4)=2.855659849341300e-1_p
x(5)=1.774629821670737_p
w(5)=1.620863279209022e-1_p
x(6)=3.007723542072589_p
w(6)=6.358192365869964e-2_p
x(7)=4.479279278812043_p
w(7)=1.787054005569666e-2_p
x(8)=6.195506640695339_p
w(8)=3.740874181469140e-3_p
x(9)=8.155873286802214_p
w(9)=5.971944958960132e-4_p
x(10)=10.35504437411367_p
w(10)=7.369850884697062e-5_p
x(11)=12.78084663742732_p
w(11)=7.126217949017170e-6_p
x(12)=15.40817305397297_p
w(12)=5.520789336008473e-7_p
x(13)=18.18771428138044_p
w(13)=3.571900797385952e-8_p
x(14)=21.02611762020982_p
w(14)=2.082914748962933e-9_p
x(15)=23.75360305367753_p
w(15)=1.249962232110215e-10_p
x(16)=26.08392282351429_p
w(16)=9.409222667975809e-12_p
x(17)=27.61101592160596_p
w(17)=1.001286119650209e-12_p
else
call GD(-1)
end if
end subroutine GF_m1

! [0kT;28kT]
subroutine GF_0(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=6.905392527813117e-1_p
w(1)=5.746633468050901e-1_p
x(2)=3.592384056238464_p
w(2)=1.184838337541638e-1_p
else if(N==3)then
x(1)=4.840533607327804e-1_p
w(1)=4.633604781957738e-1_p
x(2)=2.446744293962547_p
w(2)=2.207494743505582e-1_p
x(3)=6.424350459806287_p
w(3)=9.037228012921894e-3_p
else if(N==4)then
x(1)=3.712730905836049e-1_p
w(1)=3.825367998093542e-1_p
x(2)=1.875420059691359_p
w(2)=2.763023463475388e-1_p
x(3)=4.661435712566487_p
w(3)=3.382640783783189e-2_p
x(4)=9.507002750742693_p
w(4)=4.816265645290562e-4_p
else if(N==5)then
x(1)=3.004453867702295e-1_p
w(1)=3.237805609329419e-1_p
x(2)=1.523995217727825_p
w(2)=3.004881151032689e-1_p
x(3)=3.713291467384193_p
w(3)=6.560937885919746e-2_p
x(4)=7.189022083196221_p
w(4)=3.247922088375557e-3_p
x(5)=12.73732483309866_p
w(5)=2.120357546997399e-5_p
else if(N==6)then
x(1)=2.517958899083937e-1_p
w(1)=2.796681888921166e-1_p
x(2)=1.283207061470492_p
w(2)=3.068344499696299e-1_p
x(3)=3.100189068311912_p
w(3)=9.699160830051573e-2_p
x(4)=5.867799869125816_p
w(4)=9.411762119380995e-3_p
x(5)=9.917353927656874_p
w(5)=2.403292101675430e-4_p
x(6)=16.04367867136214_p
w(6)=8.420674430713876e-7_p
else if(N==7)then
x(1)=2.159174330665602e-1_p
w(1)=2.451214797731190e-1_p
x(2)=1.105042643236261_p
w(2)=3.033825315737047e-1_p
x(3)=2.660050525679599_p
w(3)=1.247036201533307e-1_p
x(4)=4.971626001648242_p
w(4)=1.890392514560185e-2_p
x(5)=8.225031702211718_p
w(5)=1.019881669857489e-3_p
x(6)=12.73230264152601_p
w(6)=1.570739743114204e-5_p
x(7)=19.27225625160708_p
w(7)=3.484620896867585e-8_p
else if(N==8)then
x(1)=1.877889985825848e-1_p
w(1)=2.168201600157368e-1_p
x(2)=9.646414542894132e-1_p
w(2)=2.943471016397387e-1_p
x(3)=2.319028111308147_p
w(3)=1.478821691731378e-1_p
x(4)=4.299853804522491_p
w(4)=3.120218399153108e-2_p
x(5)=7.023594028383042_p
w(5)=2.796031373647143e-3_p
x(6)=10.65036280721337_p
w(6)=9.846278930303293e-5_p
x(7)=15.46544768409479_p
w(7)=1.069553829884797e-6_p
x(8)=22.08068632750615_p
w(8)=2.022329400486511e-9_p
else if(N==9)then
x(1)=1.648561816052092e-1_p
w(1)=1.929466407436934e-1_p
x(2)=8.495448016429407e-1_p
w(2)=2.820025408093207e-1_p
x(3)=2.042208665031331_p
w(3)=1.663094859074561e-1_p
x(4)=3.766625889363424_p
w(4)=4.553992898592350e-2_p
x(5)=6.099799937022621_p
w(5)=5.969623814407030e-3_p
x(6)=9.135943520585224_p
w(6)=3.691165249638777e-4_p
x(7)=13.00930275404421_p
w(7)=9.753464659068593e-6_p
x(8)=17.93651213494104_p
w(8)=9.009049409896853e-8_p
x(9)=24.14596022538019_p
w(9)=2.183361307204492e-10_p
else if(N==10)then
x(1)=1.458235083863558e-1_p
w(1)=1.725846841113083e-1_p
x(2)=7.535256608213297e-1_p
w(2)=2.678527282991605e-1_p
x(3)=1.812581456860774_p
w(3)=1.799862035450019e-1_p
x(4)=3.331496553888770_p
w(4)=6.089388611873878e-2_p
x(5)=5.362110177536033_p
w(5)=1.076910773062497e-2_p
x(6)=7.965298153071363_p
w(6)=1.010868232627020e-3_p
x(7)=11.2129550065434_p
w(7)=4.859302541878612e-5_p
x(8)=15.20232159546544_p
w(8)=1.098989725273518e-6_p
x(9)=20.03559899153302_p
w(9)=1.046191674449051e-8_p
x(10)=25.47419309533436_p
w(10)=4.473163016592663e-11_p
else if(N==11)then
x(1)=1.298696359973635e-1_p
w(1)=1.551319491704712e-1_p
x(2)=6.726591248343932e-1_p
w(2)=2.529564810267352e-1_p
x(3)=1.619764350670389_p
w(3)=1.892473432414129e-1_p
x(4)=2.970565015179840_p
w(4)=7.622399434598841e-2_p
x(5)=4.759859568957190_p
w(5)=1.718191945090757e-2_p
x(6)=7.029708473096971_p
w(6)=2.232005334524742e-3_p
x(7)=9.822300051369057_p
w(7)=1.664575323793561e-4_p
x(8)=13.18661165727677_p
w(8)=6.878477672672810e-6_p
x(9)=17.16880530797751_p
w(9)=1.502293467376283e-7_p
x(10)=21.73375076617295_p
w(10)=1.735003213306525e-9_p
x(11)=26.28434132435124_p
w(11)=1.481186731562142e-11_p
else if(N==12)then
x(1)=1.163796227196499e-1_p
w(1)=1.401003161385571e-1_p
x(2)=6.039940308038532e-1_p
w(2)=2.380141093284688e-1_p
x(3)=1.456229892349366_p
w(3)=1.946750878147213e-1_p
x(4)=2.667217043489650_p
w(4)=9.068553155192052e-2_p
x(5)=4.259813308794602_p
w(5)=2.498540794479482e-2_p
x(6)=6.264378553608978_p
w(6)=4.215642743998188e-3_p
x(7)=8.707650740870006_p
w(7)=4.415476476731887e-4_p
x(8)=11.61588948079334_p
w(8)=2.840959856136245e-5_p
x(9)=15.01069001790744_p
w(9)=1.101616618569825e-6_p
x(10)=18.87960568504377_p
w(10)=2.576342582521821e-8_p
x(11)=23.05955944103858_p
w(11)=4.038005249403818e-10_p
x(12)=26.78266570173469_p
w(12)=6.713701950046681e-12_p
else if(N==13)then
x(1)=1.048777190981072e-1_p
w(1)=1.270853044605493e-1_p
x(2)=5.452318184096259e-1_p
w(2)=2.234610223718984e-1_p
x(3)=1.316277948870375_p
w(3)=1.969390319203898e-1_p
x(4)=2.409336041670996_p
w(4)=1.036947974567073e-1_p
x(5)=3.838761935463927_p
w(5)=3.381966864960837e-2_p
x(6)=5.626990470245092_p
w(6)=7.079961507974432e-3_p
x(7)=7.792180911538568_p
w(7)=9.736489352921813e-4_p
x(8)=10.34894386413411_p
w(8)=8.828130667360000e-5_p
x(9)=13.30700229073855_p
w(9)=5.252267519197275e-6_p
x(10)=16.65769324888819_p
w(10)=2.059652762626516e-7_p
x(11)=20.33184071503871_p
w(11)=5.587854522434826e-9_p
x(12)=24.07285092167435_p
w(12)=1.257949077078243e-10_p
x(13)=27.10033633194697_p
w(13)=3.715576213212274e-12_p
else if(N==14)then
x(1)=9.499455554636431e-2_p
w(1)=1.157558287800659e-1_p
x(2)=4.945758122392889e-1_p
w(2)=2.095520976641771e-1_p
x(3)=1.195540929656028_p
w(3)=1.966907022835851e-1_p
x(4)=2.187921478307762_p
w(4)=1.149144222163746e-1_p
x(5)=3.479999303371375_p
w(5)=4.326412201659964e-2_p
x(6)=5.088464283262637_p
w(6)=1.085864284104322e-2_p
x(7)=7.026410537260892_p
w(7)=1.868516694437913e-3_p
x(8)=9.302194690122416_p
w(8)=2.231577860443455e-4_p
x(9)=11.91943334692253_p
w(9)=1.856030520363929e-5_p
x(10)=14.87031293426468_p
w(10)=1.082783233906336e-6_p
x(11)=18.11658022750062_p
w(11)=4.562083940518922e-8_p
x(12)=21.54237453073583_p
w(12)=1.515739860859842e-9_p
x(13)=24.84107582710292_p
w(13)=4.956816887338388e-11_p
x(14)=27.31157275623312_p
w(14)=2.341149095571171e-12_p
else if(N==15)then
x(1)=8.644153536903774e-2_p
w(1)=1.058421075578359e-1_p
x(2)=4.506131036345527e-1_p
w(2)=1.964230291567963e-1_p
x(3)=1.090631415823784_p
w(3)=1.945119518736093e-1_p
x(4)=1.996171454381861_p
w(4)=1.242079004425346e-1_p
x(5)=3.171200251170241_p
w(5)=5.290098506333565e-2_p
x(6)=4.628042531221440_p
w(6)=1.550130768151078e-2_p
x(7)=6.376589556863110_p
w(7)=3.220130866094218e-3_p
x(8)=8.421772258081146_p
w(8)=4.826464903485490e-4_p
x(9)=10.76399335578793_p
w(9)=5.264049684204838e-5_p
x(10)=13.39583500801518_p
w(10)=4.215335480219282e-6_p
x(11)=16.29231135195438_p
w(11)=2.530791475130088e-7_p
x(12)=19.38955122441988_p
w(12)=1.198811898552015e-8_p
x(13)=22.53968208158462_p
w(13)=5.025501167045076e-10_p
x(14)=25.42463821496231_p
w(14)=2.343952074040662e-11_p
x(15)=27.45777094826598_p
w(15)=1.610179211579695e-12_p
else if(N==16)then
x(1)=7.899111646073138e-2_p
w(1)=9.712397408316643e-2_p
x(2)=4.122228534320497e-1_p
w(2)=1.841323284231210e-1_p
x(3)=9.988873007249823e-1_p
w(3)=1.908961784853626e-1_p
x(4)=1.828856221806237_p
w(4)=1.315864253252310e-1_p
x(5)=2.903071185903128_p
w(5)=6.235894274749507e-2_p
x(6)=4.230447283813812_p
w(6)=2.088825691321048e-2_p
x(7)=5.818686504975626_p
w(7)=5.095998837932208e-3_p
x(8)=7.670836178817036_p
w(8)=9.245936696210234e-4_p
x(9)=9.785644308679293_p
w(9)=1.262518978977496e-4_p
x(10)=12.15608318524158_p
w(10)=1.310680742671901e-5_p
x(11)=14.76399811539106_p
w(11)=1.051937279518468e-6_p
x(12)=17.56912552868582_p
w(12)=6.751218125065587e-8_p
x(13)=20.48811953221696_p
w(13)=3.707347879382665e-9_p
x(14)=23.35645797592153_p
w(14)=1.980632061532406e-10_p
x(15)=25.87160694980267_p
w(15)=1.273983231356333e-11_p
x(16)=27.56258904506525_p
w(16)=1.177831164780776e-12_p
else if(N==17)then
x(1)=7.246215629165370e-2_p
w(1)=8.942102653220464e-2_p
x(2)=3.785076845834877e-1_p
w(2)=1.726896212086210e-1_p
x(3)=9.181901054713969e-1_p
w(3)=1.862474171568447e-1_p
x(4)=1.681889859192337_p
w(4)=1.371595531183267e-1_p
x(5)=2.668470296787961_p
w(5)=7.133708851302667e-2_p
x(6)=3.884149776369070_p
w(6)=2.685239318098930e-2_p
x(7)=5.335010146842049_p
w(7)=7.528372612816410e-3_p
x(8)=7.023065810288212_p
w(8)=1.608143807173228e-3_p
x(9)=8.946289231846693_p
w(9)=2.654956727977402e-4_p
x(10)=11.09810307754031_p
w(10)=3.425260716445670e-5_p
x(11)=13.46437430071159_p
w(11)=3.503109789021405e-6_p
x(12)=16.01723887347262_p
w(12)=2.910721563631715e-7_p
x(13)=18.70415400691425_p
w(13)=2.053773561196891e-8_p
x(14)=21.42924640150501_p
w(14)=1.330778645214924e-9_p
x(15)=24.02451241533643_p
w(15)=9.022932190253454e-11_p
x(16)=26.2179618458265_p
w(16)=7.698773159167340e-12_p
x(17)=27.64005330084566_p
w(17)=9.012612189853343e-13_p
else
call GD(0)
end if
end subroutine GF_0

! [1kT;28kT]
subroutine GF_1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=1.631825451853357_p
w(1)=2.640326492213161e-1_p
x(2)=4.490327140902215_p
w(2)=4.922903829621533e-2_p
else if(N==3)then
x(1)=1.446129553820606_p
w(1)=2.168209081916324e-1_p
x(2)=3.359536119871437_p
w(2)=9.283919929684695e-2_p
x(3)=7.347307872746068_p
w(3)=3.601580029052046e-3_p
else if(N==4)then
x(1)=1.344406121649722_p
w(1)=1.816928002024815e-1_p
x(2)=2.801517989254599_p
w(2)=1.178929883765954e-1_p
x(3)=5.589681268918057_p
w(3)=1.348683859135502e-2_p
x(4)=10.44277282350792_p
w(4)=1.890603470994979e-4_p
else if(N==5)then
x(1)=1.280193558723540_p
w(1)=1.556107532706475e-1_p
x(2)=2.461064720249491_p
w(2)=1.300900030570106e-1_p
x(3)=4.645539190593140_p
w(3)=2.628141362451716e-2_p
x(4)=8.128572508686354_p
w(4)=1.271248948667883e-3_p
x(5)=13.67903329037771_p
w(5)=8.268616688245559e-6_p
else if(N==6)then
x(1)=1.235786373770071_p
w(1)=1.356528715889251e-1_p
x(2)=2.228780200239445_p
w(2)=1.346760616055430e-1_p
x(3)=4.035178212838275_p
w(3)=3.915134221337662e-2_p
x(4)=6.807611439240485_p
w(4)=3.687249158561933e-3_p
x(5)=10.85719399593158_p
w(5)=9.383174779204990e-5_p
x(6)=16.97426724516756_p
w(6)=3.312033327076609e-7_p
else if(N==7)then
x(1)=1.202723466990820_p
w(1)=1.197179483490846e-1_p
x(2)=2.056793256748005_p
w(2)=1.348497138348722e-1_p
x(3)=3.595988990587964_p
w(3)=5.084212328763135e-2_p
x(4)=5.907482915616590_p
w(4)=7.444611540141678e-3_p
x(5)=9.156107767149390_p
w(5)=4.010115820553655e-4_p
x(6)=13.64646273684361_p
w(6)=6.264352237796970e-6_p
x(7)=20.12931183132457_p
w(7)=1.457150838211016e-8_p
else if(N==8)then
x(1)=1.176579217216187_p
w(1)=1.064427944892568e-1_p
x(2)=1.921072360589055_p
w(2)=1.323326193166462e-1_p
x(3)=3.255239510264226_p
w(3)=6.096038223750872e-2_p
x(4)=5.230301959098526_p
w(4)=1.237685615247598e-2_p
x(5)=7.944170644657877_p
w(5)=1.108761913859449e-3_p
x(6)=11.54774083920516_p
w(6)=3.982002901721547e-5_p
x(7)=16.31169549491281_p
w(7)=4.524011096352736e-7_p
x(8)=22.76362412442717_p
w(8)=9.776573652486994e-10_p
else if(N==9)then
x(1)=1.155183971751338_p
w(1)=9.512359727689214e-2_p
x(2)=1.810058739959353_p
w(2)=1.281014185321827e-1_p
x(3)=2.979570618863442_p
w(3)=6.931287140214372e-2_p
x(4)=4.693511362569528_p
w(4)=1.818850596055124e-2_p
x(5)=7.013476978392925_p
w(5)=2.380718821358046e-3_p
x(6)=10.02382799822782_p
w(6)=1.503872182305503e-4_p
x(7)=13.84978262892841_p
w(7)=4.146462451831689e-6_p
x(8)=18.67986996657574_p
w(8)=4.171727970633416e-8_p
x(9)=24.61588946915759_p
w(9)=1.264414153915366e-10_p
else if(N==10)then
x(1)=1.137407931716810_p
w(1)=8.540101632987068e-2_p
x(2)=1.717803235314198_p
w(2)=1.228297823292712e-1_p
x(3)=2.752183164238509_p
w(3)=7.581585399068863e-2_p
x(4)=4.257168857074030_p
w(4)=2.447377156989190e-2_p
x(5)=6.272745156116017_p
w(5)=4.307479434290664e-3_p
x(6)=8.849935301349204_p
w(6)=4.126504368641284e-4_p
x(7)=12.05425386991459_p
w(7)=2.062916866087303e-5_p
x(8)=15.96957229652589_p
w(8)=4.988440419869135e-7_p
x(9)=20.6603646300588_p
w(9)=5.383848246227257e-9_p
x(10)=25.77492173210431_p
w(10)=3.010302847011606e-11_p
else if(N==11)then
x(1)=1.122495882386105_p
w(1)=7.701856856995011e-2_p
x(2)=1.640365386861685_p
w(2)=1.170049850175665e-1_p
x(3)=2.562279936156159_p
w(3)=8.054514923142901e-2_p
x(4)=3.896676041851865_p
w(4)=3.082520838875131e-2_p
x(5)=5.669871395528814_p
w(5)=6.883953509075954e-3_p
x(6)=7.914509564125294_p
w(6)=9.103204264847316e-4_p
x(7)=10.66756786878095_p
w(7)=7.035271731488529e-5_p
x(8)=13.97056801607289_p
w(8)=3.075138388062544e-6_p
x(9)=17.85298924902839_p
w(9)=7.351503544029213e-8_p
x(10)=22.24118167704002_p
w(10)=9.924845686371113e-10_p
x(11)=26.47631025843332_p
w(11)=1.105085034252205e-11_p
else if(N==12)then
x(1)=1.109875127963623_p
w(1)=6.976063330349283e-2_p
x(2)=1.574774894691537_p
w(2)=1.109633271608786e-1_p
x(3)=2.401972167285090_p
w(3)=8.368918562786012e-2_p
x(4)=3.594813636056769_p
w(4)=3.690996602529090e-2_p
x(5)=5.170596535909945_p
w(5)=1.002415793100603e-2_p
x(6)=7.151041433042187_p
w(6)=1.715767646507117e-3_p
x(7)=9.558136970939911_p
w(7)=1.855759156326091e-4_p
x(8)=12.41346499213097_p
w(8)=1.253745923290939e-5_p
x(9)=15.7297694709359_p
w(9)=5.225444873232181e-7_p
x(10)=19.4773363903386_p
w(10)=1.364363953541733e-8_p
x(11)=23.46268780524547_p
w(11)=2.541480709376486e-10_p
x(12)=26.90919008913029_p
w(12)=5.355352279196011e-12_p
else if(N==13)then
x(1)=1.099103583892419_p
w(1)=6.344629036186843e-2_p
x(2)=1.518746727123328_p
w(2)=1.049274886777115e-1_p
x(3)=2.265335935315797_p
w(3)=8.548367587696233e-2_p
x(4)=3.339082863904546_p
w(4)=4.249151396391404e-2_p
x(5)=4.751157952693286_p
w(5)=1.359025407718795e-2_p
x(6)=6.516372554105435_p
w(6)=2.874608957315616e-3_p
x(7)=8.648310994271597_p
w(7)=4.067982929380003e-4_p
x(8)=11.15828107064859_p
w(8)=3.851477720829578e-5_p
x(9)=14.05079024919787_p
w(9)=2.435160637261992e-6_p
x(10)=17.30799639063764_p
w(10)=1.040857868420673e-7_p
x(11)=20.84572082797896_p
w(11)=3.197118787033305e-9_p
x(12)=24.39007309656127_p
w(12)=8.578617696256048e-11_p
x(13)=27.18726829571369_p
w(13)=3.096116674477347e-12_p
else if(N==14)then
x(1)=1.089838672149456_p
w(1)=5.792603604433291e-2_p
x(2)=1.470513340609150_p
w(2)=9.903972107544112e-2_p
x(3)=2.147870400200613_p
w(3)=8.616921413773597e-2_p
x(4)=3.120234711912975_p
w(4)=4.742432104557987e-2_p
x(5)=4.394541738429839_p
w(5)=1.742201052963903e-2_p
x(6)=5.981000537806267_p
w(6)=4.398857808854575e-3_p
x(7)=7.888238826599853_p
w(7)=7.761662457064129e-4_p
x(8)=10.12197861302152_p
w(8)=9.635604334482219e-5_p
x(9)=12.68252250689112_p
w(9)=8.449597342005841e-6_p
x(10)=15.55664724151099_p
w(10)=5.294388989092082e-7_p
x(11)=18.69779567300534_p
w(11)=2.458100383739947e-8_p
x(12)=21.97941439978146_p
w(12)=9.315936375943679e-10_p
x(13)=25.09084030102123_p
w(13)=3.604917746011573e-11_p
x(14)=27.37375828874423_p
w(14)=2.009114097935773e-12_p
else if(N==15)then
x(1)=1.081812841444822_p
w(1)=5.307692815037320e-2_p
x(2)=1.428695296849322_p
w(2)=9.338672359966385e-2_p
x(3)=2.046109894493971_p
w(3)=8.596897448008581e-2_p
x(4)=2.931295819298718_p
w(4)=5.163800136835082e-2_p
x(5)=4.088235529188761_p
w(5)=2.136046215787415e-2_p
x(6)=5.523942920604390_p
w(6)=6.268054868165232e-3_p
x(7)=7.243991977276868_p
w(7)=1.330343166628097e-3_p
x(8)=9.250977163783139_p
w(8)=2.064528621067863e-4_p
x(9)=11.543039711506_p
w(9)=2.359947921217832e-5_p
x(10)=14.10935339596195_p
w(10)=2.009456992651239e-6_p
x(11)=16.91991903126701_p
w(11)=1.307067519942683e-7_p
x(12)=19.90436770517431_p
w(12)=6.872855065276099e-9_p
x(13)=22.90925104209299_p
w(13)=3.291329429282902e-10_p
x(14)=25.62271187797212_p
w(14)=1.792802307265486e-11_p
x(15)=27.5038662223489_p
w(15)=1.410581610886452e-12_p
else if(N==16)then
x(1)=1.074815078373567_p
w(1)=4.879777814061324e-2_p
x(2)=1.392204696945582_p
w(2)=8.801738230773265e-2_p
x(3)=1.957348711551800_p
w(3)=8.507883024149931e-2_p
x(4)=2.766914506603232_p
w(4)=5.511871865050686e-2_p
x(5)=3.822822322822011_p
w(5)=2.526369018490905e-2_p
x(6)=5.129797431884394_p
w(6)=8.435691597778872e-3_p
x(7)=6.691453472585283_p
w(7)=2.094919269679045e-3_p
x(8)=8.508613409145116_p
w(8)=3.921390744619612e-4_p
x(9)=10.57835156279659_p
w(9)=5.585257029755930e-5_p
x(10)=12.89138610096831_p
w(10)=6.120233834094586e-6_p
x(11)=15.42634678229719_p
w(11)=5.260330695140023e-7_p
x(12)=18.13884073484063_p
w(12)=3.681261091821625e-8_p
x(13)=20.94133332394592_p
w(13)=2.252340180870940e-9_p
x(14)=23.66852349742324_p
w(14)=1.370170657591431e-10_p
x(15)=26.03039686702371_p
w(15)=1.013369530154361e-11_p
x(16)=27.59781300745043_p
w(16)=1.047373854382689e-12_p
else if(N==17)then
x(1)=1.068677295641491_p
w(1)=4.500503332182178e-2_p
x(2)=1.360174605942987_p
w(2)=8.295521323503867e-2_p
x(3)=1.879447014890306_p
w(3)=8.366461082600789e-2_p
x(4)=2.622917552468852_p
w(4)=5.789180390651086e-2_p
x(5)=3.591073600410499_p
w(5)=2.901523207331972e-2_p
x(6)=4.786965137510771_p
w(6)=1.083795461705501e-2_p
x(7)=6.212895907788706_p
w(7)=3.081370991657167e-3_p
x(8)=7.868688701478384_p
w(8)=6.767963196540581e-4_p
x(9)=9.750958853060265_p
w(9)=1.160821156286203e-4_p
x(10)=11.85157256822615_p
w(10)=1.571771523466301e-5_p
x(11)=14.15424533589527_p
w(11)=1.706938012259855e-6_p
x(12)=16.62837224812573_p
w(12)=1.527334837392486e-7_p
x(13)=19.21846394962326_p
w(13)=1.179932163751236e-8_p
x(14)=21.82683639497771_p
w(14)=8.522829236518761e-10_p
x(15)=24.28849355655429_p
w(15)=6.537820137407319e-11_p
x(16)=26.34684153788643_p
w(16)=6.313715414519759e-12_p
x(17)=27.66767299827099_p
w(17)=8.104730645984667e-13_p
else
call GD(1)
end if
end subroutine GF_1

! [2kT;28kT]
subroutine GF_2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=2.604167172050610_p
w(1)=1.077990751273085e-1_p
x(2)=5.444196928635701_p
w(2)=1.912893591497257e-2_p
else if(N==3)then
x(1)=2.427959357124588_p
w(1)=8.929224238554175e-2_p
x(2)=4.320002277752088_p
w(2)=3.626221088797787e-2_p
x(3)=8.312528230690155_p
w(3)=1.373557768761437e-3_p
else if(N==4)then
x(1)=2.331354670663869_p
w(1)=7.536868520285446e-2_p
x(2)=3.767751059374099_p
w(2)=4.634471635687863e-2_p
x(3)=6.557378217227253_p
w(3)=5.142979527623255e-3_p
x(4)=11.41358298497705_p
w(4)=7.162995492471305e-5_p
else if(N==5)then
x(1)=2.270226230082228_p
w(1)=6.492320571466050e-2_p
x(2)=3.431922306025409_p
w(2)=5.147859044528854e-2_p
x(3)=5.614726634151210_p
w(3)=1.004181487214922e-2_p
x(4)=9.100340277118987_p
w(4)=4.812703758375201e-4_p
x(5)=14.65020688977651_p
w(5)=3.129634345286918e-6_p
else if(N==6)then
x(1)=2.227747354899121_p
w(1)=5.684068802873960e-2_p
x(2)=3.202827893838978_p
w(2)=5.363367684292465e-2_p
x(3)=5.004203616020807_p
w(3)=1.501834369013910e-2_p
x(4)=7.776616088008042_p
w(4)=1.399468522737565e-3_p
x(5)=11.82172164164058_p
w(5)=3.570611866194998e-5_p
x(6)=17.92180348774654_p
w(6)=1.278390781895087e-7_p
else if(N==7)then
x(1)=2.195874776473353_p
w(1)=5.030229692622135e-2_p
x(2)=3.032600028150775_p
w(2)=5.401571757165016e-2_p
x(3)=4.562876917821084_p
w(3)=1.961108636767242e-2_p
x(4)=6.869658015887135_p
w(4)=2.842209479127193e-3_p
x(5)=10.10748857503072_p
w(5)=1.542315463979782e-4_p
x(6)=14.57256113294696_p
w(6)=2.463022466933292e-6_p
x(7)=20.9737589803277_p
w(7)=6.128745025489551e-9_p
else if(N==8)then
x(1)=2.170535459253518_p
w(1)=4.480002278743037e-2_p
x(2)=2.898024644885623_p
w(2)=5.327770723828561e-2_p
x(3)=4.219771018514712_p
w(3)=2.364929881135134e-2_p
x(4)=6.185433854345828_p
w(4)=4.754301156168181e-3_p
x(5)=8.883189426305858_p
w(5)=4.305976609141557e-4_p
x(6)=12.45602458868033_p
w(6)=1.589178924264450e-5_p
x(7)=17.15532338116775_p
w(7)=1.911124103213816e-7_p
x(8)=23.40625308976051_p
w(8)=4.864784445391089e-10_p
else if(N==9)then
x(1)=2.149788453333626_p
w(1)=4.008707637660872e-2_p
x(2)=2.788234047393077_p
w(2)=5.180536326703361e-2_p
x(3)=3.942999319215785_p
w(3)=2.702669683741421e-2_p
x(4)=5.644262978218037_p
w(4)=7.017200781528049e-3_p
x(5)=7.945288724067634_p
w(5)=9.294833311842509e-4_p
x(6)=10.92345016039324_p
w(6)=6.041808276885942e-5_p
x(7)=14.69297595845735_p
w(7)=1.752808662137037e-6_p
x(8)=19.40979600204822_p
w(8)=1.948147988496912e-8_p
x(9)=25.04362532248185_p
w(9)=7.560133207620719e-11_p
else if(N==10)then
x(1)=2.132572812070273_p
w(1)=3.603019979530143e-2_p
x(2)=2.697351261213085_p
w(2)=4.987293923814549e-2_p
x(3)=3.715721769018472_p
w(3)=2.969547967776001e-2_p
x(4)=5.206012906630970_p
w(4)=9.469530431964007e-3_p
x(5)=7.201523371435076_p
w(5)=1.684988769518232e-3_p
x(6)=9.747139547068038_p
w(6)=1.659586601522823e-4_p
x(7)=12.90135145880637_p
w(7)=8.685063642907216e-6_p
x(8)=16.73274270559046_p
w(8)=2.265752555167822e-7_p
x(9)=21.26568833935792_p
w(9)=2.809798444689210e-9_p
x(10)=26.04540144340361_p
w(10)=2.074273651554724e-11_p
else if(N==11)then
x(1)=2.118147284962920_p
w(1)=3.252637939763429e-2_p
x(2)=2.621322778961979_p
w(2)=4.768030279632270e-2_p
x(3)=3.526685705826216_p
w(3)=3.167827704164946e-2_p
x(4)=4.845182432909694_p
w(4)=1.195330684802037e-2_p
x(5)=6.598020723740215_p
w(5)=2.693400665283068e-3_p
x(6)=8.812445549553322_p
w(6)=3.654974421314210e-4_p
x(7)=11.52045225818358_p
w(7)=2.943987579212847e-5_p
x(8)=14.75504689981706_p
w(8)=1.370218016622548e-6_p
x(9)=18.52793767593511_p
w(9)=3.617225585330877e-8_p
x(10)=22.72757917233924_p
w(10)=5.768060501093548e-10_p
x(11)=26.64928245235454_p
w(11)=8.369095191262453e-12_p
else if(N==12)then
x(1)=2.105948126196806_p
w(1)=2.948756032874516e-2_p
x(2)=2.557099666186277_p
w(2)=4.536706419474261e-2_p
x(3)=3.367669131462237_p
w(3)=3.304299387663991e-2_p
x(4)=4.543931086589311_p
w(4)=1.434070846397476e-2_p
x(5)=6.099454296005676_p
w(5)=3.919896876468535e-3_p
x(6)=8.051238737589237_p
w(6)=6.868935577853820e-4_p
x(7)=10.41740595318752_p
w(7)=7.713675885120717e-5_p
x(8)=13.21425052960931_p
w(8)=5.501466409128033e-6_p
x(9)=16.44501412908964_p
w(9)=2.480645293242014e-7_p
x(10)=20.06264071891817_p
w(10)=7.287468794374901e-9_p
x(11)=23.84633743406034_p
w(11)=1.623560763165454e-10_p
x(12)=27.02404783089542_p
w(12)=4.310169447050911e-12_p
else if(N==13)then
x(1)=2.095542588012743_p
w(1)=2.683976942702483e-2_p
x(2)=2.502360106021003_p
w(2)=4.302751510149763e-2_p
x(3)=3.232546793244853_p
w(3)=3.387671305086962e-2_p
x(4)=4.289394676786959_p
w(4)=1.654097024562130e-2_p
x(5)=5.681495334613132_p
w(5)=5.310281073064393e-3_p
x(6)=7.419585390198604_p
w(6)=1.146951194710313e-3_p
x(7)=9.514034844041161_p
w(7)=1.679484033426784e-4_p
x(8)=11.97257560939175_p
w(8)=1.668116390852762e-5_p
x(9)=14.79403856585361_p
w(9)=1.126667238765056e-6_p
x(10)=17.95124924779953_p
w(10)=5.280560730613059e-8_p
x(11)=21.34586959000024_p
w(11)=1.847562349159957e-9_p
x(12)=24.69083425829522_p
w(12)=5.924005250937766e-11_p
x(13)=27.26688098913619_p
w(13)=2.593298987159987e-12_p
else if(N==14)then
x(1)=2.086596633189087_p
w(1)=2.452177091653599e-2_p
x(2)=2.455322164100289_p
w(2)=4.072350797102814e-2_p
x(3)=3.116694721997986_p
w(3)=3.426950667494594e-2_p
x(4)=4.072098781313116_p
w(4)=1.849788842992318e-2_p
x(5)=5.326812736738500_p
w(5)=6.802552606910491e-3_p
x(6)=6.887587432566763_p
w(6)=1.749078844988470e-3_p
x(7)=8.760259326401385_p
w(7)=3.183450721420498e-4_p
x(8)=10.94793902964593_p
w(8)=4.125645709244892e-5_p
x(9)=13.44727173675926_p
w(9)=3.831063303286766e-6_p
x(10)=16.23945942811385_p
w(10)=2.590758634796577e-7_p
x(11)=19.26992432813175_p
w(11)=1.332299015818236e-8_p
x(12)=22.40285784862184_p
w(12)=5.783505613627341e-10_p
x(13)=25.32738030681497_p
w(13)=2.647776068405254e-11_p
x(14)=27.43118768358192_p
w(14)=1.729088242521856e-12_p
else if(N==15)then
x(1)=2.078849993167369_p
w(1)=2.248307545134152e-2_p
x(2)=2.414603252524825_p
w(2)=3.849415595678956e-2_p
x(3)=3.016570373488708_p
w(3)=3.430582639791848e-2_p
x(4)=3.884923025139488_p
w(4)=2.018361884845951e-2_p
x(5)=5.022703654924181_p
w(5)=8.335914906554482e-3_p
x(6)=6.434046571026123_p
w(6)=2.484119949301756e-3_p
x(7)=8.122046739501741_p
w(7)=5.422558922937249e-4_p
x(8)=10.08725310884539_p
w(8)=8.749311467064017e-5_p
x(9)=12.32530554415203_p
w(9)=1.052207173572507e-5_p
x(10)=14.82180335211852_p
w(10)=9.565507979159240e-7_p
x(11)=17.54182532616681_p
w(11)=6.770201959885506e-8_p
x(12)=20.4091032321814_p
w(12)=3.967773856907919e-9_p
x(13)=23.26624174767733_p
w(13)=2.175713947404565e-10_p
x(14)=25.81041573217805_p
w(14)=1.381543996878007e-11_p
x(15)=27.54675459319002_p
w(15)=1.237454496265813e-12_p
else if(N==16)then
x(1)=2.072097725719193_p
w(1)=2.068201315350195e-2_p
x(2)=2.379118066506769_p
w(2)=3.636284178252069e-2_p
x(3)=2.929420139955474_p
w(3)=3.406054196194605e-2_p
x(4)=3.722416733359080_p
w(4)=2.159160034602247e-2_p
x(5)=4.759630790840634_p
w(5)=9.856565886562075e-3_p
x(6)=6.043438422835905_p
w(6)=3.333151459370841e-3_p
x(7)=7.575235448744489_p
w(7)=8.489637199699985e-4_p
x(8)=9.354143982626937_p
w(8)=1.646516936023219e-4_p
x(9)=11.37543275147965_p
w(9)=2.454699363550909e-5_p
x(10)=13.62740674669204_p
w(10)=2.849177318111157e-6_p
x(11)=16.08548726800346_p
w(11)=2.632247840023913e-7_p
x(12)=18.70143124680066_p
w(12)=2.016009829443572e-8_p
x(13)=21.38427834198804_p
w(13)=1.378350758629483e-9_p
x(14)=23.96944045587631_p
w(14)=9.556106577079694e-11_p
x(15)=26.18112104787478_p
w(15)=8.105126546251060e-12_p
x(16)=27.63079894722037_p
w(16)=9.318001680355757e-13_p
else if(N==17)then
x(1)=2.066176775968770_p
w(1)=1.908408802171719e-2_p
x(2)=2.348005120594723_p
w(2)=3.434219973733120e-2_p
x(3)=2.853075046884450_p
w(3)=3.359768148098693e-2_p
x(4)=3.580339059728936_p
w(4)=2.273003832050813e-2_p
x(5)=4.530286921009383_p
w(5)=1.132062296899527e-2_p
x(6)=5.704094072876821_p
w(6)=4.271028440340905e-3_p
x(7)=7.102084675160386_p
w(7)=1.242079141150806e-3_p
x(8)=8.722601645117612_p
w(8)=2.817932116271759e-4_p
x(9)=10.56088618014611_p
w(9)=5.037937756222966e-5_p
x(10)=12.60710661711508_p
w(10)=7.181735329889447e-6_p
x(11)=14.8427905697498_p
w(11)=8.308676741718006e-7_p
x(12)=17.23472682713483_p
w(12)=8.032177636802783e-8_p
x(13)=19.72487281718301_p
w(13)=6.813961123448860e-9_p
x(14)=22.21451961281503_p
w(14)=5.496949733783215e-10_p
x(15)=24.54285009471118_p
w(15)=4.769769576841267e-11_p
x(16)=26.46943956251043_p
w(16)=5.198274560442097e-12_p
x(17)=27.69368217541309_p
w(17)=7.287215142171209e-13_p
else
call GD(2)
end if
end subroutine GF_2

! [3kT;28kT]
subroutine GF_3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=3.592777455378711_p
w(1)=4.139326895504745e-2_p
x(2)=6.425554721625841_p
w(2)=7.194082618003173e-3_p
else if(N==3)then
x(1)=3.420418643887553_p
w(1)=3.440925667241398e-2_p
x(2)=5.304007610105708_p
w(2)=1.366538809725585e-2_p
x(3)=9.298471370055026_p
w(3)=5.127068033807880e-4_p
else if(N==4)then
x(1)=3.325898280563823_p
w(1)=2.913098334185442e-2_p
x(2)=4.754014648845560_p
w(2)=1.751005643657538e-2_p
x(3)=7.544251582188077_p
w(3)=1.919638874909750e-3_p
x(4)=12.40149990759774_p
w(4)=2.667291971106883e-5_p
else if(N==5)then
x(1)=3.265996620987230_p
w(1)=2.515166664620420e-2_p
x(2)=4.419789440926160_p
w(2)=1.950267731894037e-2_p
x(3)=6.601576162602198_p
w(3)=3.752478892334123e-3_p
x(4)=10.08720308468169_p
w(4)=1.793596911233274e-4_p
x(5)=15.63409679751415_p
w(5)=1.169024448603467e-6_p
else if(N==6)then
x(1)=3.224179539603227_p
w(1)=2.204947159792615e-2_p
x(2)=4.191199433202347_p
w(2)=2.037292167427476e-2_p
x(3)=5.988944775300455_p
w(3)=5.627624377638567e-3_p
x(4)=8.758009309155096_p
w(4)=5.238229868864394e-4_p
x(5)=12.794401293754_p
w(5)=1.346161038095734e-5_p
x(6)=18.86687509380299_p
w(6)=4.932594374638929e-8_p
else if(N==7)then
x(1)=3.192587309726281_p
w(1)=1.951581767954866e-2_p
x(2)=4.020471554545172_p
w(2)=2.056381954724247e-2_p
x(3)=5.543621307020301_p
w(3)=7.376600884761809e-3_p
x(4)=7.841990555358870_p
w(4)=1.071212977338206e-3_p
x(5)=11.06370406614642_p
w(5)=5.892769004588689e-5_p
x(6)=15.49412135350774_p
w(6)=9.701500131398063e-7_p
x(7)=21.78420760047618_p
w(7)=2.644100446912895e-9_p
else if(N==8)then
x(1)=3.167397581335643_p
w(1)=1.737217034069713e-2_p
x(2)=3.885319948530928_p
w(2)=2.031587830407321e-2_p
x(3)=5.196940027507652_p
w(3)=8.924697440654227e-3_p
x(4)=7.149962880026844_p
w(4)=1.802018289694935e-3_p
x(5)=9.826541271963830_p
w(5)=1.661594355904910e-4_p
x(6)=13.36128005392655_p
w(6)=6.345731098167181e-6_p
x(7)=17.98181510786484_p
w(7)=8.177883626741374e-8_p
x(8)=23.99538163406584_p
w(8)=2.524061950246913e-10_p
else if(N==9)then
x(1)=3.146806378682516_p
w(1)=1.553519593800876e-2_p
x(2)=3.775390288464291_p
w(2)=1.977756113800079e-2_p
x(3)=4.918174996631604_p
w(3)=1.022155336976915e-2_p
x(4)=6.604316988683032_p
w(4)=2.667763742016739e-3_p
x(5)=8.882004802994658_p
w(5)=3.602837584804554e-4_p
x(6)=11.8222586673885_p
w(6)=2.423849224573633e-5_p
x(7)=15.52658491411466_p
w(7)=7.458065841012993e-7_p
x(8)=20.11465312802809_p
w(8)=9.281016471098266e-9_p
x(9)=25.42510030389386_p
w(9)=4.692841147960040e-11_p
else if(N==10)then
x(1)=3.129764179651708_p
w(1)=1.395537555331582e-2_p
x(2)=3.684734246038250_p
w(2)=1.905670686306395e-2_p
x(3)=4.690173038009347_p
w(3)=1.124677828789760e-2_p
x(4)=6.164107518579081_p
w(4)=3.604400714119708e-3_p
x(5)=8.135779075613458_p
w(5)=6.537683729186481e-4_p
x(6)=10.64515634139494_p
w(6)=6.654899374731683e-5_p
x(7)=13.74299716059884_p
w(7)=3.667198770774652e-6_p
x(8)=17.48119377857811_p
w(8)=1.040742641025372e-7_p
x(9)=21.84295068969173_p
w(9)=1.500285117168002e-9_p
x(10)=26.28504957877825_p
w(10)=1.466758789365725e-11_p
else if(N==11)then
x(1)=3.115515302676334_p
w(1)=1.259206212903265e-2_p
x(2)=3.609136571495707_p
w(2)=1.823162368682145e-2_p
x(3)=4.501186325201886_p
w(3)=1.200947338464604e-2_p
x(4)=5.802811718796995_p
w(4)=4.550908330057820e-3_p
x(5)=7.532077083011977_p
w(5)=1.044171731655922e-3_p
x(6)=9.712319933864800_p
w(6)=1.461514285832652e-4_p
x(7)=12.370390283725_p
w(7)=1.232785975284298e-5_p
x(8)=15.53007931246142_p
w(8)=6.146168236124037e-7_p
x(9)=19.18478605528198_p
w(9)=1.805650184704271e-8_p
x(10)=23.18706027715436_p
w(10)=3.427330993442270e-10_p
x(11)=26.8033082419204_p
w(11)=6.442072012593809e-12_p
else if(N==12)then
x(1)=3.103487088596597_p
w(1)=1.141046714398216e-2_p
x(2)=3.545444848914319_p
w(2)=1.735690053909615e-2_p
x(3)=4.342673289495375_p
w(3)=1.253604937570332e-2_p
x(4)=5.501971577492865_p
w(4)=5.458639357705161e-3_p
x(5)=7.034533715498393_p
w(5)=1.517101977982549e-3_p
x(6)=8.954198783169318_p
w(6)=2.736119581559558e-4_p
x(7)=11.27541030294027_p
w(7)=3.203500365279053e-5_p
x(8)=14.00879177048158_p
w(8)=2.423265107547791e-6_p
x(9)=17.14777634205969_p
w(9)=1.188878487155157e-7_p
x(10)=20.62843157409212_p
w(10)=3.954577516609837e-9_p
x(11)=24.20668464526219_p
w(11)=1.057349998948400e-10_p
x(12)=27.12726220266966_p
w(12)=3.503746686021602e-12_p
else if(N==13)then
x(1)=3.093242938749177_p
w(1)=1.038151424236208e-2_p
x(2)=3.491279038471245_p
w(2)=1.646946024435564e-2_p
x(3)=4.208319026812233_p
w(3)=1.285998804924439e-2_p
x(4)=5.248370874727020_p
w(4)=6.293482167894096e-3_p
x(5)=6.618276619110876_p
w(5)=2.050990821710951e-3_p
x(6)=8.326193500714883_p
w(6)=4.549277863219640e-4_p
x(7)=10.3797086975645_p
w(7)=6.919726909239121e-5_p
x(8)=12.782786797218_p
w(8)=7.238184475351848e-6_p
x(9)=15.5283792728636_p
w(9)=5.245838955371829e-7_p
x(10)=18.58012104050612_p
w(10)=2.709536283647492e-8_p
x(11)=21.82680104193015_p
w(11)=1.084597139629173e-9_p
x(12)=24.97265180834226_p
w(12)=4.155284000271355e-11_p
x(13)=27.33911856557815_p
w(13)=2.185398551630150e-12_p
else if(N==14)then
x(1)=3.084447399719549_p
w(1)=9.481199011507650e-3_p
x(2)=3.444823831251775_p
w(2)=1.559359837567390e-2_p
x(3)=4.093382744322568_p
w(3)=1.301574151046184e-2_p
x(4)=5.032322758965768_p
w(4)=7.034653494219950e-3_p
x(5)=6.265670017961474_p
w(5)=2.621667004052645e-3_p
x(6)=7.798066930215736_p
w(6)=6.907599067298248e-4_p
x(7)=9.633151240385084_p
w(7)=1.301806515171343e-4_p
x(8)=11.7713756941067_p
w(8)=1.767194780851728e-5_p
x(9)=14.2055841737909_p
w(9)=1.744158573420994e-6_p
x(10)=16.91144257793943_p
w(10)=1.278174827906166e-7_p
x(11)=19.82687582955014_p
w(11)=7.309528996755268e-9_p
x(12)=22.80853369231421_p
w(12)=3.643150185434901e-10_p
x(13)=25.54902616259204_p
w(13)=1.968537590261947e-11_p
x(14)=27.48376399133522_p
w(14)=1.493563630682872e-12_p
else if(N==15)then
x(1)=3.076839946131029_p
w(1)=8.689757064609971e-3_p
x(2)=3.404677291454770_p
w(2)=1.474475346232677e-2_p
x(3)=3.994247736079286_p
w(3)=1.303551626848675e-2_p
x(4)=4.846572348465913_p
w(4)=7.672161748336554e-3_p
x(5)=5.963829983149481_p
w(5)=3.205806222347396e-3_p
x(6)=7.348436794751454_p
w(6)=9.769176457858223e-4_p
x(7)=9.001695954671094_p
w(7)=2.201875047953789e-4_p
x(8)=10.92218409667605_p
w(8)=3.705285843824234e-5_p
x(9)=13.10294173029633_p
w(9)=4.702905939594919e-6_p
x(10)=15.52598992620022_p
w(10)=4.580194950966741e-7_p
x(11)=18.15173245849462_p
w(11)=3.539630158751492e-8_p
x(12)=20.89877175262398_p
w(12)=2.318673431736178e-9_p
x(13)=23.60749374430964_p
w(13)=1.456813206156291e-10_p
x(14)=25.9865686537526_p
w(14)=1.074480885669464e-11_p
x(15)=27.58632771696387_p
w(15)=1.087893280587754e-12_p
else if(N==16)then
x(1)=3.070215957535748_p
w(1)=7.990891252011125e-3_p
x(2)=3.369743122841781_p
w(2)=1.393223063777587e-2_p
x(3)=3.908112795845209_p
w(3)=1.294781123244327e-2_p
x(4)=4.685581470417882_p
w(4)=8.204013259155854e-3_p
x(5)=5.703107663046523_p
w(5)=3.783061240528150e-3_p
x(6)=6.961676198145630_p
w(6)=1.305568953873741e-3_p
x(7)=8.461192709656883_p
w(7)=3.424744669368541e-4_p
x(8)=10.19925126251633_p
w(8)=6.902290476677374e-5_p
x(9)=12.16926097531037_p
w(9)=1.080104448423475e-5_p
x(10)=14.35709137465438_p
w(10)=1.331845999429702e-6_p
x(11)=16.73508024008466_p
w(11)=1.326571435506003e-7_p
x(12)=19.25152722119755_p
w(12)=1.114988507114357e-8_p
x(13)=21.81290598677672_p
w(13)=8.533087959537715e-10_p
x(14)=24.25679572146191_p
w(14)=6.738059222216894e-11_p
x(15)=26.32290190431929_p
w(15)=6.527398509624240e-12_p
x(16)=27.66144210392081_p
w(16)=8.299097334656103e-13_p
else if(N==17)then
x(1)=3.064412985879213_p
w(1)=7.371119900107511e-3_p
x(2)=3.339153966918895_p
w(2)=1.316113792688235e-2_p
x(3)=3.832778484225146_p
w(3)=1.277697091234603e-2_p
x(4)=4.545051632950782_p
w(4)=8.633694203721887e-3_p
x(5)=5.476125739713101_p
w(5)=4.337065884140740e-3_p
x(6)=6.626059377275935_p
w(6)=1.666679867224839e-3_p
x(7)=7.993922478734729_p
w(7)=4.980215538613481e-4_p
x(8)=9.576830747908081_p
w(8)=1.170492903974569e-4_p
x(9)=11.36864202372555_p
w(9)=2.186803388928109e-5_p
x(10)=13.35779918459607_p
w(10)=3.290444131661040e-6_p
x(11)=15.52370483079991_p
w(11)=4.066084914551140e-7_p
x(12)=17.83076011472998_p
w(12)=4.257543420513332e-8_p
x(13)=20.21883656655207_p
w(13)=3.974037476925380e-9_p
x(14)=22.58901548946907_p
w(14)=3.583104803055015e-10_p
x(15)=24.78571255521586_p
w(15)=3.511671208104011e-11_p
x(16)=26.58507714154525_p
w(16)=4.301683680417247e-12_p
x(17)=27.7179856983447_p
w(17)=6.555018706556043e-13_p
else
call GD(3)
end if
end subroutine GF_3

! [4kT;28kT]
subroutine GF_4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=4.588391307784093_p
w(1)=1.548099304979377e-2_p
x(2)=7.418430070374218_p
w(2)=2.668934867324534e-3_p
else if(N==3)then
x(1)=4.417504838778783_p
w(1)=1.288663407641129e-2_p
x(2)=6.297887633245948_p
w(2)=5.073626236569973e-3_p
x(3)=10.29308252681395_p
w(3)=1.896676041370355e-4_p
else if(N==4)then
x(1)=4.323773296346896_p
w(1)=1.092226450888809e-2_p
x(2)=5.748688846207153_p
w(2)=6.507584292378945e-3_p
x(3)=8.539037298954906_p
w(3)=7.102165459014884e-4_p
x(4)=13.39632464315693_p
w(4)=9.862569949774252e-6_p
else if(N==5)then
x(1)=4.264276383560113_p
w(1)=9.436855411804784e-3_p
x(2)=5.414692447218966_p
w(2)=7.256279814734482e-3_p
x(3)=7.595300495925614_p
w(3)=1.389888953873944e-3_p
x(4)=11.07921165334812_p
w(4)=6.646833682336565e-5_p
x(5)=16.62015434715137_p
w(5)=4.353998817252462e-7_p
else if(N==6)then
x(1)=4.222524929972550_p
w(1)=8.271150021861190e-3_p
x(2)=5.185238537463398_p
w(2)=7.588222219782583e-3_p
x(3)=6.979037584278080_p
w(3)=2.090120088074191e-3_p
x(4)=9.741912441273413_p
w(4)=1.953365500601010e-4_p
x(5)=13.76469308494729_p
w(5)=5.079756079690247e-6_p
x(6)=19.79478940716129_p
w(6)=1.928126054496994e-8_p
else if(N==7)then
x(1)=4.190786513755490_p
w(1)=7.311695571552824e-3_p
x(2)=5.012923393426224_p
w(2)=7.664056739292891e-3_p
x(3)=6.528572649920101_p
w(3)=2.748639804669346e-3_p
x(4)=8.815232352147008_p
w(4)=4.025758981234301e-4_p
x(5)=12.01543200086746_p
w(5)=2.257201294249371e-5_p
x(6)=16.40051074247921_p
w(6)=3.867048851573427e-7_p
x(7)=22.54576835283752_p
w(7)=1.185652159292133e-9_p
else if(N==8)then
x(1)=4.165458307821097_p
w(1)=6.498061334640272e-3_p
x(2)=4.876493149707536_p
w(2)=7.571774941918023e-3_p
x(3)=6.177889471238318_p
w(3)=3.332538319054168e-3_p
x(4)=8.115343483072174_p
w(4)=6.807279516742109e-4_p
x(5)=10.76608152282373_p
w(5)=6.423352046391858e-5_p
x(6)=14.25519027360763_p
w(6)=2.555962964467403e-6_p
x(7)=18.78230712775307_p
w(7)=3.574904180580081e-8_p
x(8)=24.52535611770896_p
w(8)=1.373614333458818e-10_p
else if(N==9)then
x(1)=4.144813846326775_p
w(1)=5.802061192885575e-3_p
x(2)=4.765912380774603_p
w(2)=7.368352488626546e-3_p
x(3)=5.896945983163338_p
w(3)=3.819812518343398e-3_p
x(4)=7.565606119012430_p
w(4)=1.009861679282326e-3_p
x(5)=9.816120601639600_p
w(5)=1.397330789237021e-4_p
x(6)=12.7129470734652_p
w(6)=9.780696009266873e-6_p
x(7)=16.34333366724381_p
w(7)=3.216929669438812e-7_p
x(8)=20.78784589392951_p
w(8)=4.539818005324355e-9_p
x(9)=25.76103795895641_p
w(9)=3.026253742329463e-11_p
else if(N==10)then
x(1)=4.127782277763871_p
w(1)=5.204916314596489e-3_p
x(2)=4.675056152582515_p
w(2)=7.095663099294087e-3_p
x(3)=5.668039900858954_p
w(3)=4.202765708854205e-3_p
x(4)=7.123770163039278_p
w(4)=1.364648588212562e-3_p
x(5)=9.068407357389596_p
w(5)=2.535332991538485e-4_p
x(6)=11.53723310994381_p
w(6)=2.678836358673995e-5_p
x(7)=14.5726265607775_p
w(7)=1.563070117019640e-6_p
x(8)=18.20876555411053_p
w(8)=4.863944842449217e-8_p
x(9)=22.38782739262469_p
w(9)=8.232176419513235e-10_p
x(10)=26.49569771726208_p
w(10)=1.063728173840199e-11_p
else if(N==11)then
x(1)=4.113580373911970_p
w(1)=4.690673194166973e-3_p
x(2)=4.599524274434245_p
w(2)=6.783830695228856e-3_p
x(3)=5.478905309891246_p
w(3)=4.485568702884028e-3_p
x(4)=6.762245003251107_p
w(4)=1.721569004490184e-3_p
x(5)=8.465243049173985_p
w(5)=4.042189610941849e-4_p
x(6)=10.60777116306252_p
w(6)=5.858169558969258e-5_p
x(7)=13.21128650555118_p
w(7)=5.197146158991791e-6_p
x(8)=16.28990193563524_p
w(8)=2.791144469047394e-7_p
x(9)=19.81861898212651_p
w(9)=9.189238240585918e-9_p
x(10)=23.61718012727844_p
w(10)=2.087825224299363e-10_p
x(11)=26.93970411531179_p
w(11)=5.037723050072371e-12_p
else if(N==12)then
x(1)=4.101618796794170_p
w(1)=4.245774394830553e-3_p
x(2)=4.536052003433722_p
w(2)=6.453689273140569e-3_p
x(3)=5.320691460093196_p
w(3)=4.678846778975418e-3_p
x(4)=6.461975060321311_p
w(4)=2.062190299737619e-3_p
x(5)=7.969296203727819_p
w(5)=5.857931677214754e-4_p
x(6)=9.853860531047395_p
w(6)=1.091274558087216e-4_p
x(7)=12.12640651130545_p
w(7)=1.336922689989904e-5_p
x(8)=14.79165306885853_p
w(8)=1.077254719354765e-6_p
x(9)=17.83316073952889_p
w(9)=5.780364908519669e-8_p
x(10)=21.17101966648341_p
w(10)=2.188446740670493e-9_p
x(11)=24.54250598467853_p
w(11)=7.031261956237822e-11_p
x(12)=27.21959694405835_p
w(12)=2.876245333304770e-12_p
else if(N==13)then
x(1)=4.091451341996036_p
w(1)=3.858971976399376e-3_p
x(2)=4.482193147135634_p
w(2)=6.119241449034901e-3_p
x(3)=5.186901609899125_p
w(3)=4.795719243173004e-3_p
x(4)=6.209408536600229_p
w(4)=2.373828375788318e-3_p
x(5)=7.555194047818927_p
w(5)=7.896284892413823e-4_p
x(6)=9.230375377392445_p
w(6)=1.805040306379753e-4_p
x(7)=11.23986525986369_p
w(7)=2.860979372659144e-5_p
x(8)=13.58374824470702_p
w(8)=3.162792983282447e-6_p
x(9)=16.24905496665591_p
w(9)=2.469674987487501e-7_p
x(10)=19.1905901299213_p
w(10)=1.411854877561570e-8_p
x(11)=22.28587429355275_p
w(11)=6.485993132292396e-10_p
x(12)=25.23495331195905_p
w(12)=2.963370506912514e-11_p
x(13)=27.40439786033018_p
w(13)=1.852927844329314e-12_p
else if(N==14)then
x(1)=4.082736801385600_p
w(1)=3.521022183888988e-3_p
x(2)=4.436091878781646_p
w(2)=5.789639629608381e-3_p
x(3)=5.072682947913187_p
w(3)=4.849510727379817e-3_p
x(4)=5.994658542331998_p
w(4)=2.648969860463663e-3_p
x(5)=7.205022041397958_p
w(5)=1.006276815776709e-3_p
x(6)=8.706815137520827_p
w(6)=2.726676397028773e-4_p
x(7)=10.50166996262795_p
w(7)=5.336161101726889e-5_p
x(8)=12.58734617272556_p
w(8)=7.610304575353123e-6_p
x(9)=14.95285999651433_p
w(9)=8.009849497659643e-7_p
x(10)=17.5685160783828_p
w(10)=6.383760824409099e-8_p
x(11)=20.36543828398715_p
w(11)=4.072702716969089e-9_p
x(12)=23.19460095689015_p
w(12)=2.333260582280441e-10_p
x(13)=25.75550597029464_p
w(13)=1.482344059632627e-11_p
x(14)=27.53171049505979_p
w(14)=1.295017347245600e-12_p
else if(N==15)then
x(1)=4.075211127726881_p
w(1)=3.224338524003482e-3_p
x(2)=4.396320842972982_p
w(2)=5.470652966416185e-3_p
x(3)=4.974347654038586_p
w(3)=4.852566792841299e-3_p
x(4)=5.810345979519408_p
w(4)=2.884217750019700e-3_p
x(5)=6.905733076487390_p
w(5)=1.226788437474047e-3_p
x(6)=8.261659095935448_p
w(6)=3.837087961197380e-4_p
x(7)=9.877878367546165_p
w(7)=8.954062976230964e-5_p
x(8)=11.75101640259935_p
w(8)=1.575577634048580e-5_p
x(9)=13.87150086920116_p
w(9)=2.116524187809129e-6_p
x(10)=16.21786933065449_p
w(10)=2.214922020350288e-7_p
x(11)=18.74620427264633_p
w(11)=1.874426734603820e-8_p
x(12)=21.3708585599559_p
w(12)=1.375137013902843e-9_p
x(13)=23.93172908392612_p
w(13)=9.895049147921318e-11_p
x(14)=26.15102332075539_p
w(14)=8.437752205343306e-12_p
x(15)=27.62270356519484_p
w(15)=9.586065214481070e-13_p
else if(N==16)then
x(1)=4.068667549748300_p
w(1)=2.962681856122169e-3_p
x(2)=4.361767691347479_p
w(2)=5.165720682041045e-3_p
x(3)=4.889048775829490_p
w(3)=4.815734888229588e-3_p
x(4)=5.650853874929553_p
w(4)=3.079173577831247e-3_p
x(5)=6.647580362038688_p
w(5)=1.443490416717625e-3_p
x(6)=7.879207477001006_p
w(6)=5.103721032123390e-4_p
x(7)=9.344417949052344_p
w(7)=1.382505772570004e-4_p
x(8)=11.03934217358503_p
w(8)=2.902304328251548e-5_p
x(9)=12.95552942470613_p
w(9)=4.778755095786814e-6_p
x(10)=15.07646896954319_p
w(10)=6.276123222758355e-7_p
x(11)=17.37161497454699_p
w(11)=6.756959499366334e-8_p
x(12)=19.78627723783516_p
w(12)=6.245782318865656e-9_p
x(13)=22.22526749181785_p
w(13)=5.355091114080187e-10_p
x(14)=24.52968850289504_p
w(14)=4.808520611563444e-11_p
x(15)=26.45563930860046_p
w(15)=5.294956266971812e-12_p
x(16)=27.68980295850801_p
w(16)=7.401220115394156e-13_p
else if(N==17)then
x(1)=4.062942335420643_p
w(1)=2.730902786360897e-3_p
x(2)=4.331554993662978_p
w(2)=4.876696707602004e-3_p
x(3)=4.814557390399883_p
w(3)=4.748225666300692e-3_p
x(4)=5.511833340940049_p
w(4)=3.235453786848121e-3_p
x(5)=6.423127406304611_p
w(5)=1.650322143474505e-3_p
x(6)=7.547698134770891_p
w(6)=6.486394288278293e-4_p
x(7)=8.883634036749715_p
w(7)=1.996844175916596e-4_p
x(8)=10.4269208429975_p
w(8)=4.872563194461223e-5_p
x(9)=12.17004695329783_p
w(9)=9.533590741085094e-6_p
x(10)=14.09976457637858_p
w(10)=1.517569134368135e-6_p
x(11)=16.19347263824655_p
w(11)=2.007597513655974e-7_p
x(12)=18.41345689268968_p
w(12)=2.281545561287807e-8_p
x(13)=20.6980120556622_p
w(13)=2.346373900297310e-9_p
x(14)=22.94881540834167_p
w(14)=2.364304165243293e-10_p
x(15)=25.01642720032517_p
w(15)=2.611229971206526e-11_p
x(16)=26.69367082221562_p
w(16)=3.578931628181385e-12_p
x(17)=27.7406123427546_p
w(17)=5.900006625671421e-13_p
else
call GD(4)
end if
end subroutine GF_4

! [5kT;28kT]
subroutine GF_5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=5.586749175945179_p
w(1)=5.730412084626650e-3_p
x(2)=8.415770073546884_p
w(2)=9.849364037999783e-4_p
else if(N==3)then
x(1)=5.416410830192069_p
w(1)=4.772524538584106e-3_p
x(2)=7.295591677652837_p
w(2)=1.872901897888940e-3_p
x(3)=11.29103313704196_p
w(3)=6.992205195358233e-5_p
else if(N==4)then
x(1)=5.322953820741291_p
w(1)=4.046567865984549e-3_p
x(2)=6.746571309076435_p
w(2)=2.403241463040167e-3_p
x(3)=9.536708117307494_p
w(3)=2.619008086687391e-4_p
x(4)=14.39332062241504_p
w(4)=3.638350733173557e-6_p
else if(N==5)then
x(1)=5.263501891021336_p
w(1)=3.496045932807358e-3_p
x(2)=6.412060724138526_p
w(2)=2.681206675507836e-3_p
x(3)=8.590906097520747_p
w(3)=5.133178657560605e-4_p
x(4)=12.07133226956427_p
w(4)=2.461533789558777e-5_p
x(5)=17.60181994753761_p
w(5)=1.626764597863905e-7_p
else if(N==6)then
x(1)=5.221525076937265_p
w(1)=3.060940217208416e-3_p
x(2)=6.180903315038139_p
w(2)=2.805142392611612e-3_p
x(3)=7.969595646733480_p
w(3)=7.743915307796485e-4_p
x(4)=10.72321177734218_p
w(4)=7.293670060232772e-5_p
x(5)=14.72621311373544_p
w(5)=1.929935575574783e-6_p
x(6)=20.69391429395294_p
w(6)=7.711649049168045e-9_p
else if(N==7)then
x(1)=5.189449279724282_p
w(1)=2.700540045555868e-3_p
x(2)=6.006463707430601_p
w(2)=2.832845491230115e-3_p
x(3)=7.513281648424143_p
w(3)=1.021530879077847e-3_p
x(4)=9.784877090625550_p
w(4)=1.515654746357484e-4_p
x(5)=12.95768421748581_p
w(5)=8.709137049866267e-6_p
x(6)=17.28530790465248_p
w(6)=1.569038534347808e-7_p
x(7)=23.24904118253805_p
w(7)=5.570237495965631e-10_p
else if(N==8)then
x(1)=5.163875460505801_p
w(1)=2.394884517328234e-3_p
x(2)=5.868529967387188_p
w(2)=2.796656103209728e-3_p
x(3)=7.158596945693255_p
w(3)=1.240334835290612e-3_p
x(4)=9.077581156789130_p
w(4)=2.574399763586284e-4_p
x(5)=11.69777089883008_p
w(5)=2.497414397005597e-5_p
x(6)=15.13333356921186_p
w(6)=1.042796836769086e-6_p
x(7)=19.55187825628926_p
w(7)=1.603694754504262e-8_p
x(8)=24.99582036096517_p
w(8)=7.848505605213049e-11_p
else if(N==9)then
x(1)=5.143107204925794_p
w(1)=2.134193018718886e-3_p
x(2)=5.757173052814221_p
w(2)=2.718520521257996e-3_p
x(3)=6.875621730339850_p
w(3)=1.421711316985856e-3_p
x(4)=8.524419456478645_p
w(4)=3.823740535187074e-4_p
x(5)=10.7440236367153_p
w(5)=5.442228690550190e-5_p
x(6)=13.59180940541524_p
w(6)=3.983811937767924e-6_p
x(7)=17.13938195358192_p
w(7)=1.411719729821292e-7_p
x(8)=21.42620810243438_p
w(8)=2.286898489229769e-9_p
x(9)=26.05479545922919_p
w(9)=2.023044227831882e-11_p
else if(N==10)then
x(1)=5.126033099600686_p
w(1)=1.911206566106151e-3_p
x(2)=5.666016445847270_p
w(2)=2.614611400565585e-3_p
x(3)=6.645928077836254_p
w(3)=1.562975069262912e-3_p
x(4)=8.081500301829886_p
w(4)=5.163820962008488e-4_p
x(5)=9.996051102279601_p
w(5)=9.861541005727683e-5_p
x(6)=12.4200376043278_p
w(6)=1.085960828640834e-5_p
x(7)=15.38688194771637_p
w(7)=6.746684149611692e-7_p
x(8)=18.9123402889423_p
w(8)=2.319673883749094e-8_p
x(9)=22.89883601248732_p
w(9)=4.648984219097242e-10_p
x(10)=26.68027667471111_p
w(10)=7.895226438550816e-12_p
else if(N==11)then
x(1)=5.111836889768889_p
w(1)=1.719680173337086e-3_p
x(2)=5.590465510517430_p
w(2)=2.496423282139830e-3_p
x(3)=6.456726051678127_p
w(3)=1.666081967103141e-3_p
x(4)=7.720170891307590_p
w(4)=6.504119066505003e-4_p
x(5)=9.394354458904179_p
w(5)=1.567967176547766e-4_p
x(6)=11.49572612605966_p
w(6)=2.360861367280469e-5_p
x(7)=14.04010029922834_p
w(7)=2.212233053129147e-6_p
x(8)=17.03161429148154_p
w(8)=1.286822843537942e-7_p
x(9)=20.42717383206439_p
w(9)=4.778088010789218e-9_p
x(10)=24.0176775217586_p
w(10)=1.304463939405842e-10_p
x(11)=27.06031920619618_p
w(11)=3.996602875343077e-12_p
else if(N==12)then
x(1)=5.099909613816672_p
w(1)=1.554362620366845e-3_p
x(2)=5.527141214699685_p
w(2)=2.371823249247503e-3_p
x(3)=6.298866179946349_p
w(3)=1.735358657743918e-3_p
x(4)=7.420808267292299_p
w(4)=7.775031487635291e-4_p
x(5)=8.900734715120290_p
w(5)=2.264588630482376e-4_p
x(6)=10.74734592310073_p
w(6)=4.370566937512427e-5_p
x(7)=12.96758692075075_p
w(7)=5.621858327585742e-6_p
x(8)=15.56013721201578_p
w(8)=4.845591376536431e-7_p
x(9)=18.49880705346274_p
w(9)=2.857549402741497e-8_p
x(10)=21.68896116844104_p
w(10)=1.236804080031413e-9_p
x(11)=24.85416213860367_p
w(11)=4.773579665151641e-11_p
x(12)=27.30213228104561_p
w(12)=2.382327861533171e-12_p
else if(N==13)then
x(1)=5.089793265072657_p
w(1)=1.410931066113713e-3_p
x(2)=5.473529060966927_p
w(2)=2.246046309576455e-3_p
x(3)=6.165676912661240_p
w(3)=1.775984134276209e-3_p
x(4)=7.169544868246277_p
w(4)=8.929768135059017e-4_p
x(5)=8.489374683220470_p
w(5)=3.041436040629590e-4_p
x(6)=10.1294053437564_p
w(6)=7.184536575961034e-5_p
x(7)=12.09187577921125_p
w(7)=1.190039357686868e-5_p
x(8)=14.37293309881781_p
w(8)=1.395077769723676e-6_p
x(9)=16.95375563439127_p
w(9)=1.178215785292263e-7_p
x(10)=19.78084947701182_p
w(10)=7.483709131999774e-9_p
x(11)=22.72229321687446_p
w(11)=3.954389998588427e-10_p
x(12)=25.47829329299545_p
w(12)=2.147868837123915e-11_p
x(13)=27.46334882036918_p
w(13)=1.579838322919365e-12_p
else if(N==14)then
x(1)=5.081139248519694_p
w(1)=1.285851193830698e-3_p
x(2)=5.427730699482225_p
w(2)=2.122475570437956e-3_p
x(3)=6.052198261547574_p
w(3)=1.793133778176783e-3_p
x(4)=6.956307697202114_p
w(4)=9.941626850076533e-4_p
x(5)=8.142115494409618_p
w(5)=3.861567997788824e-4_p
x(6)=9.611229532021310_p
w(6)=1.078804274281166e-4_p
x(7)=11.36332844423767_p
w(7)=2.197892270957641e-5_p
x(8)=13.3934648420565_p
w(8)=3.302465285888303e-6_p
x(9)=15.68687387476362_p
w(9)=3.718387821116094e-7_p
x(10)=18.20877218510146_p
w(10)=3.233513190299362e-8_p
x(11)=20.88430539523565_p
w(11)=2.307435534609185e-9_p
x(12)=23.56070185556958_p
w(12)=1.519936160156980e-10_p
x(13)=25.94735652377423_p
w(13)=1.130113837856165e-11_p
x(14)=27.57540317007714_p
w(14)=1.126770541975285e-12_p
else if(N==15)then
x(1)=5.073678797675549_p
w(1)=1.176233857294402e-3_p
x(2)=5.388291708938594_p
w(2)=2.003213165117312e-3_p
x(3)=5.954674929824149_p
w(3)=1.791547720248668e-3_p
x(4)=6.773604201232700_p
w(4)=1.079958858649078e-3_p
x(5)=7.845770343552603_p
w(5)=4.690699670376754e-4_p
x(6)=9.171213981926677_p
w(6)=1.509502608363430e-4_p
x(7)=10.74822196437612_p
w(7)=3.655242457664027e-5_p
x(8)=12.57148233870366_p
w(8)=6.741815983867629e-6_p
x(9)=14.62884641913029_p
w(9)=9.610731115876049e-7_p
x(10)=16.89552776944879_p
w(10)=1.083729708604751e-7_p
x(11)=19.32371798261296_p
w(11)=1.006846670367614e-8_p
x(12)=21.82446672323705_p
w(12)=8.284109886285384e-10_p
x(13)=24.23884934653332_p
w(13)=6.818806495463648e-11_p
x(14)=26.30422542658457_p
w(14)=6.687981547069399e-12_p
x(15)=27.6561133339195_p
w(15)=8.464545310589861e-13_p
else if(N==16)then
x(1)=5.067202108143890_p
w(1)=1.079711052094724e-3_p
x(2)=5.354082372374865_p
w(2)=1.889486609836184e-3_p
x(3)=5.870216999230767_p
w(3)=1.775351929923894e-3_p
x(4)=6.615747190563901_p
w(4)=1.150382747340755e-3_p
x(5)=7.590511585425454_p
w(5)=5.500010238629941e-4_p
x(6)=8.793622008477968_p
w(6)=1.997027231012074e-4_p
x(7)=10.22263455959011_p
w(7)=5.597814211246585e-5_p
x(8)=11.87224847938721_p
w(8)=1.226673112555701e-5_p
x(9)=13.73218545222547_p
w(9)=2.130081750679745e-6_p
x(10)=15.78365643227465_p
w(10)=2.986813051910230e-7_p
x(11)=17.99348283451423_p
w(11)=3.483781888640138e-8_p
x(12)=20.30450102279703_p
w(12)=3.547564135200164e-9_p
x(13)=22.62077410227375_p
w(13)=3.408732923958776e-10_p
x(14)=24.78815443924091_p
w(14)=3.473069565327750e-11_p
x(15)=26.57967879858435_p
w(15)=4.325149953284195e-12_p
x(16)=27.71602796220742_p
w(16)=6.608161975495364e-13_p
else if(N==17)then
x(1)=5.061543506866998_p
w(1)=9.943342336621536e-4_p
x(2)=5.324214133253550_p
w(2)=1.781933711476483e-3_p
x(3)=5.796568174462343_p
w(3)=1.748021136045138e-3_p
x(4)=6.478344280046589_p
w(4)=1.206185975180104e-3_p
x(5)=7.368856503916239_p
w(5)=6.267215733127128e-4_p
x(6)=8.466680025753377_p
w(6)=2.525293546597579e-4_p
x(7)=9.769023521816392_p
w(7)=8.025064826765660e-5_p
x(8)=11.27078835452969_p
w(8)=2.036966155453203e-5_p
x(9)=12.96312480021308_p
w(9)=4.182292010226011e-6_p
x(10)=14.8311644695791_p
w(10)=7.057792524804428e-7_p
x(11)=16.85046090891082_p
w(11)=1.001620211530832e-7_p
x(12)=18.98149205564223_p
w(12)=1.237619949812396e-8_p
x(13)=21.16150566632599_p
w(13)=1.403667433532748e-9_p
x(14)=23.29354776744787_p
w(14)=1.579836490568764e-10_p
x(15)=25.23508714354551_p
w(15)=1.960934714194900e-11_p
x(16)=26.79547984673425_p
w(16)=2.992985401560039e-12_p
x(17)=27.76165742256057_p
w(17)=5.313175234657704e-13_p
else
call GD(5)
end if
end subroutine GF_5

end module m_gauss_fermi_28
