// //! Load and draw vector graphics.
// use crate::{Color, Hasher, Rectangle, Size};

// use std::borrow::Cow;
// use std::hash::{Hash, Hasher as _};
// use std::path::PathBuf;
// use std::sync::Arc;

// /// A handle of Svg data.
// #[derive(Debug, Clone, PartialEq, Eq)]
// pub struct Handle {
//     id: u64,
//     data: Arc<Data>,
// }

// impl Handle {
//     /// Creates an SVG [`Handle`] pointing to the vector image of the given
//     /// path.
//     pub fn from_path(path: impl Into<PathBuf>) -> Handle {
//         Self::from_data(Data::Path(path.into()))
//     }

//     /// Creates an SVG [`Handle`] from raw bytes containing either an SVG string
//     /// or gzip compressed data.
//     ///
//     /// This is useful if you already have your SVG data in-memory, maybe
//     /// because you downloaded or generated it procedurally.
//     pub fn from_memory(bytes: impl Into<Cow<'static, [u8]>>) -> Handle {
//         Self::from_data(Data::Bytes(bytes.into()))
//     }

//     fn from_data(data: Data) -> Handle {
//         let mut hasher = Hasher::default();
//         data.hash(&mut hasher);

//         Handle {
//             id: hasher.finish(),
//             data: Arc::new(data),
//         }
//     }

//     /// Returns the unique identifier of the [`Handle`].
//     pub fn id(&self) -> u64 {
//         self.id
//     }

//     /// Returns a reference to the SVG [`Data`].
//     pub fn data(&self) -> &Data {
//         &self.data
//     }
// }

// impl Hash for Handle {
//     fn hash<H: std::hash::Hasher>(&self, state: &mut H) {
//         self.id.hash(state);
//     }
// }

// /// The data of a vectorial image.
// #[derive(Clone, Hash, PartialEq, Eq)]
// pub enum Data {
//     /// File data
//     Path(PathBuf),

//     /// In-memory data
//     ///
//     /// Can contain an SVG string or a gzip compressed data.
//     Bytes(Cow<'static, [u8]>),
// }

// impl std::fmt::Debug for Data {
//     fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
//         match self {
//             Data::Path(path) => write!(f, "Path({path:?})"),
//             Data::Bytes(_) => write!(f, "Bytes(...)"),
//         }
//     }
// }

// /// A [`Renderer`] that can render vector graphics.
// ///
// /// [renderer]: crate::renderer
// pub trait Renderer: crate::Renderer {
//     /// Returns the default dimensions of an SVG for the given [`Handle`].
//     fn dimensions(&self, handle: &Handle) -> Size<u32>;

//     /// Draws an SVG with the given [`Handle`], an optional [`Color`] filter, and inside the provided `bounds`.
//     fn draw(&mut self, handle: Handle, color: Option<Color>, bounds: Rectangle);
// }