# Shortcuts

## Linux / Windows

### In the main window

- <kbd>Ctrl</kbd> + <kbd>N</kbd> creates a new note with the current date and time in the name
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>N</kbd> creates a new note in a new tab
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>F</kbd> lets you search for notes (in the name of the note and its content)
- <kbd>Alt</kbd> + <kbd>F</kbd> lets you search for notes in all tags / subfolders
- <kbd>Alt</kbd> + <kbd>⇧ Shift</kbd> + <kbd>P</kbd> switches to the previous workspace
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>E</kbd> edits an encrypted note
- <kbd>Alt</kbd> + <kbd>R</kbd> removes the current note
- <kbd>Alt</kbd> + <kbd>⇧ Shift</kbd> + <kbd>U</kbd> checks for updates
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>T</kbd> opens the todo list
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>O</kbd> opens the current note in an external editor
- <kbd>Alt</kbd> + <kbd>⇧ Shift</kbd> + <kbd>O</kbd> opens the current note in a view
- <kbd>Alt</kbd> + <kbd>⇧ Shift</kbd> + <kbd>F</kbd> shows the current note in the file manager
- <kbd>Alt</kbd> + <kbd>⇧ Shift</kbd> + <kbd>E</kbd> enables or disables editing of notes
- <kbd>Alt</kbd> + <kbd>Up</kbd> jumps to the previous visible note
- <kbd>Alt</kbd> + <kbd>Down</kbd> jumps to the next visible note
- <kbd>Alt</kbd> + <kbd>Page Up</kbd> jumps to the previous note tab
- <kbd>Alt</kbd> + <kbd>Page Down</kbd> jumps to the next note tab
- <kbd>Ctrl</kbd> + <kbd>W</kbd> closes the current note tab
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>D</kbd> toggles the distraction free mode
  - you can also close it with <kbd>Esc</kbd>
- <kbd>Ctrl</kbd> + <kbd>P</kbd> prints the current note as text
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>P</kbd> prints the current note as markdown
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>V</kbd> pastes notes, images and html from the clipboard
- <kbd>Ctrl</kbd> + <kbd>,</kbd> opens the settings
- <kbd>Alt</kbd> + <kbd>⇧ Shift</kbd> + <kbd>A</kbd> adds a new tag to a note
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>R</kbd> reloads the current note folder
- <kbd>Ctrl</kbd> + <kbd>Alt</kbd> + <kbd>F</kbd> lets you select a different note folder
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>S</kbd> reloads the scripting engine
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>M</kbd> hides or shows the main menu bar
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>A</kbd> lets you search for actions
- <kbd>Ctrl</kbd> + <kbd>S</kbd> manually saves modified notes
- <kbd>Alt</kbd> + <kbd>⇧ Shift</kbd> + <kbd>I</kbd> opens the Script repository dialog
- <kbd>F4</kbd> jumps to the note edit panel
- <kbd>F5</kbd> jumps to the note list
- <kbd>F6</kbd> jumps to the note subfolder panel
- <kbd>F7</kbd> jumps to the tags panel
- <kbd>F8</kbd> jumps to the navigation panel
- <kbd>F10</kbd> activates the context menu of the current widget
- <kbd>F11</kbd> toggles full-screen mode
- <kbd>Alt</kbd> + <kbd>⇧ Shift</kbd> + <kbd>H</kbd> copies the headline of the current note

### In the note search bar

- <kbd>Down</kbd> or <kbd>Tab</kbd> sets the focus to the note list
- <kbd>Return</kbd> creates a new note with the text from the search bar as
  headline

### In the note list

- double-click on note to open note in a new tab (keep in mind that there is a scripting hook that can override the double-click action)
- <kbd>Ctrl</kbd> + <kbd>A</kbd> selects all notes (to move, copy or remove them with a right click)
- <kbd>Tab</kbd> or <kbd>Return</kbd> lets you edit the current note

### In the note text edit panel

- <kbd>Ctrl</kbd> + <kbd>Click</kbd> on a link to open it
- <kbd>Ctrl</kbd> + <kbd>F</kbd> lets you search in the current note
  - use the <kbd>Up</kbd> and <kbd>Down</kbd> keys or <kbd>F3</kbd> and
    <kbd>⇧ Shift</kbd> + <kbd>F3</kbd> keys to jump to the previous and next matches
  - <kbd>Esc</kbd> closes the search bar
- <kbd>Ctrl</kbd> + <kbd>R</kbd> lets you search and replace in the current note
- <kbd>Ctrl</kbd> + <kbd>D</kbd> duplicates the current line or the selected text
  - <kbd>Ctrl</kbd> + <kbd>Alt</kbd> + <kbd>Down</kbd> does the same
- <kbd>Alt</kbd> + <kbd>Backspace</kbd> deletes the current line
- <kbd>Ctrl</kbd> + <kbd>Backspace</kbd> deletes the current word
- <kbd>Ctrl</kbd> + <kbd>L</kbd> opens a dialog to add a text link (also works on selected text)
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>L</kbd> opens a dialog to add note link
- <kbd>Ctrl</kbd> + <kbd>T</kbd> inserts the current date and time in a user specific format
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>I</kbd> inserts an image (the image will be copied to the `media` folder in the current notes folder)
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>X</kbd> inserts an attachment (the file will be copied to the `attachments` folder in the current notes folder)
- <kbd>Alt</kbd> + <kbd>⇧ Shift</kbd> + <kbd>T</kbd> inserts a table
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>C</kbd> inserts a code block at the current position
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>B</kbd> inserts a block quote at the current position
- <kbd>Ctrl</kbd> + <kbd>B</kbd> formats the selected text bold
- <kbd>Ctrl</kbd> + <kbd>I</kbd> formats the selected text italic
- <kbd>Ctrl</kbd> + <kbd>U</kbd> formats the selected text underline
- <kbd>Alt</kbd> + <kbd>⇧ Shift</kbd> + <kbd>S</kbd> strikes out the selected text
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>U</kbd> cycles through the cases of the selected text
- <kbd>Tab</kbd> indents the selected text (also works on multiple lines)
  - <kbd>⇧ Shift</kbd> + <kbd>Tab</kbd> un-indents the selected text
- <kbd>Tab</kbd> after an unordered list character indents the list item
  - <kbd>⇧ Shift</kbd> + <kbd>Tab</kbd> after an unordered list character
    un-indents the list item
- <kbd>Return</kbd> in lists creates a new list item
- <kbd>Alt</kbd> + <kbd>Left</kbd> jumps back in the note history
  - <kbd>Alt</kbd> + <kbd>Right</kbd> jumps forward in the note history
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>1..9</kbd> sets a note bookmark on bookmark slot 1..9
- <kbd>Ctrl</kbd> + <kbd>1..9</kbd> jumps to the note bookmark on bookmark slot 1..9
- <kbd>Ctrl</kbd> + <kbd>+</kbd> increases the note text font size by one point
- <kbd>Ctrl</kbd> + <kbd>-</kbd> decreases the note text font size by one point
- <kbd>Ctrl</kbd> + <kbd>0</kbd> resets the note text font size
- <kbd>Ctrl</kbd> + <kbd>Space</kbd> tries to solve simple equations like `(4+5)*3=` in front of the cursor, auto-completes text or opens urls
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>H</kbd> inserts a headline from the note filename at the top of the note
- <kbd>Alt</kbd> + <kbd>⇧ Shift</kbd> + <kbd>X</kbd> splits the current note into two notes at the current cursor position
- <kbd>Alt</kbd> + <kbd>⇧ Shift</kbd> + <kbd>W</kbd> searches for the selected text on the web
- <kbd>Ctrl</kbd> + <kbd>Up</kbd> scrolls the content up
- <kbd>Ctrl</kbd> + <kbd>Down</kbd> scrolls the content down
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>Down</kbd> moves the current line down
- <kbd>Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>Up</kbd> moves the current line up
- <kbd>⇧ Shift</kbd> + <kbd>Return</kbd> adds two spaces and a newline character to force a markdown newline

### In the note preview panel

- <kbd>Ctrl</kbd> + <kbd>F</kbd> lets you search in the current note
  - use the <kbd>Up</kbd> and <kbd>Down</kbd> keys or <kbd>F3</kbd> and
    <kbd>⇧ Shift</kbd> + <kbd>F3</kbd> keys to jump to the previous and next matches
  - <kbd>Esc</kbd> closes the search bar

### In the Todo list

- <kbd>Ctrl</kbd> + <kbd>S</kbd> saves the current todo item
- <kbd>Ctrl</kbd> + <kbd>I</kbd> saves the current todo item and inserts in into the current note
- <kbd>Ctrl</kbd> + <kbd>R</kbd> removes the current todo item

## macOS

### In the main window

- <kbd>⌘ Cmd</kbd> + <kbd>N</kbd> creates a new note with the current date and time in the name
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>N</kbd> creates a new note in a new tab
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>F</kbd> lets you search for notes (in the name of the note and its content)
- <kbd>⌃ Ctrl</kbd> + <kbd>F</kbd> lets you search for notes in all tags / subfolders
- <kbd>⌃ Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>P</kbd> switches to the previous workspace
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>E</kbd> edits an encrypted note
- <kbd>⌃ Ctrl</kbd> + <kbd>R</kbd> removes the current note
- <kbd>⌃ Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>U</kbd> checks for updates
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>T</kbd> opens the todo list
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>O</kbd> opens the current note in an external editor
- <kbd>⌃ Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>O</kbd> opens the current note in a view
- <kbd>⌃ Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>F</kbd> opens the folder of the current note in Finder
- <kbd>⌃ Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>E</kbd> enables or disables editing of notes
- <kbd>⌃ Ctrl</kbd> + <kbd>Up</kbd> jumps to the previous visible note
- <kbd>⌃ Ctrl</kbd> + <kbd>Down</kbd> jumps to the next visible note
- <kbd>⌥ Alt</kbd> + <kbd>Page Up</kbd> jumps to the previous note tab
- <kbd>⌥ Alt</kbd> + <kbd>Page Down</kbd> jumps to the next note tab
- <kbd>⌘ Cmd</kbd> + <kbd>W</kbd> closes the current note tab
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>D</kbd> toggles the distraction free mode
  - you can also close it with <kbd>Esc</kbd>
- <kbd>⌘ Cmd</kbd> + <kbd>P</kbd> prints the current note as text
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>P</kbd> prints the current note as markdown
- <kbd>⌘ Cmd</kbd> + <kbd>⌃ Ctrl</kbd> + <kbd>V</kbd> pastes notes, images and html from the clipboard
- <kbd>⌘ Cmd</kbd> + <kbd>,</kbd> opens the settings
- <kbd>⌃ Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>A</kbd> adds a new tag to a note
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>R</kbd> reloads the current note folder
- <kbd>⌘ Cmd</kbd> + <kbd>⌃ Ctrl</kbd> + <kbd>F</kbd> lets you select a different note folder
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>S</kbd> reloads the scripting engine
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>M</kbd> hides or shows the main menu bar
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>A</kbd> lets you search for actions
- <kbd>⌘ Cmd</kbd> + <kbd>S</kbd> manually saves modified notes
- <kbd>⌃ Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>I</kbd> opens the Script repository dialog
- <kbd>F4</kbd> jumps to the note edit panel
- <kbd>F5</kbd> jumps to the note list
- <kbd>F6</kbd> jumps to the note subfolder panel
- <kbd>F7</kbd> jumps to the tags panel
- <kbd>F8</kbd> jumps to the navigation panel
- <kbd>F10</kbd> activates the context menu of the current widget
- <kbd>⌘ Cmd</kbd> + <kbd>F11</kbd> toggles full-screen mode
- <kbd>⌃ Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>H</kbd> copies the headline of the current note

### In the note search bar

- <kbd>Down</kbd> or <kbd>Tab</kbd> sets the focus to the note list
- <kbd>Return</kbd> creates a new note with the text from the search bar as
  headline

### In the note list

- double-click on note to open note in a new tab (keep in mind that there is a scripting hook that can override the double-click action)
- <kbd>⌘ Cmd</kbd> + <kbd>A</kbd> selects all notes (to move, copy or remove them with a right click)
- <kbd>Tab</kbd> or <kbd>Return</kbd> lets you edit the current note

### In the note text edit panel

- <kbd>⌘ Cmd</kbd> + <kbd>Click</kbd> on a link to open it
- <kbd>⌘ Cmd</kbd> + <kbd>F</kbd> lets you search in the current note
  - use the <kbd>Up</kbd> and <kbd>Down</kbd> keys or <kbd>F3</kbd> and
    <kbd>⇧ Shift</kbd> + <kbd>F3</kbd> keys to jump to the previous and next matches
  - <kbd>Esc</kbd> closes the search bar
- <kbd>⌘ Cmd</kbd> + <kbd>R</kbd> lets you search and replace in the current note
- <kbd>⌘ Cmd</kbd> + <kbd>D</kbd> duplicates the current line or the selected text
  - <kbd>⌘ Cmd</kbd> + <kbd>⌃ Ctrl</kbd> + <kbd>Down</kbd> does the same
- <kbd>⌘ Cmd</kbd> + <kbd>Backspace</kbd> deletes the current line
- <kbd>⌃ Ctrl</kbd> + <kbd>Backspace</kbd> deletes the current word
- <kbd>⌘ Cmd</kbd> + <kbd>L</kbd> opens a dialog to add a text link (also works on selected text)
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>L</kbd> opens a dialog to add note link
- <kbd>⌘ Cmd</kbd> + <kbd>T</kbd> inserts the current date and time in a user specific format
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>I</kbd> inserts an image (the image will be copied to the `media` folder in the current notes folder)
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>X</kbd> inserts an attachment (the file will be copied to the `attachments` folder in the current notes folder)
- <kbd>⌃ Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>T</kbd> inserts a table
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>C</kbd> inserts a code block at the current position
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>B</kbd> inserts a block quote at the current position
- <kbd>⌘ Cmd</kbd> + <kbd>B</kbd> formats the selected text bold
- <kbd>⌘ Cmd</kbd> + <kbd>I</kbd> formats the selected text italic
- <kbd>⌘ Cmd</kbd> + <kbd>U</kbd> formats the selected text underline
- <kbd>⌃ Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>S</kbd> strikes out the selected text
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>U</kbd> cycles through the cases of the selected text
- <kbd>Tab</kbd> indents the selected text (also works on multiple lines)
  - <kbd>⇧ Shift</kbd> + <kbd>Tab</kbd> un-indents the selected text
- <kbd>Tab</kbd> after an unordered list character indents the list item
  - <kbd>⇧ Shift</kbd> + <kbd>Tab</kbd> after an unordered list character
    un-indents the list item
- <kbd>Return</kbd> in lists creates a new list item
- <kbd>⌘ Cmd</kbd> + <kbd>⌃ Ctrl</kbd> + <kbd>Left</kbd> jumps back in the note history
  - <kbd>⌘ Cmd</kbd> + <kbd>⌃ Ctrl</kbd> + <kbd>Right</kbd> jumps forward in the note history
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>1..9</kbd> sets a note bookmark on bookmark slot 1..9
- <kbd>⌘ Cmd</kbd> + <kbd>1..9</kbd> jumps to the note bookmark on bookmark slot 1..9
- <kbd>⌘ Cmd</kbd> + <kbd>+</kbd> increases the note text font size by one point
- <kbd>⌘ Cmd</kbd> + <kbd>-</kbd> decreases the note text font size by one point
- <kbd>⌘ Cmd</kbd> + <kbd>0</kbd> resets the note text font size
- <kbd>⌘ Cmd</kbd> + <kbd>Space</kbd> tries to solve simple equations like `(4+5)*3=` in the current line in front of the cursor, auto-completes text or opens urls
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>H</kbd> inserts a headline from the note filename at the top of the note
- <kbd>⌃ Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>X</kbd> splits the current note into two notes at the current cursor position
- <kbd>⌃ Ctrl</kbd> + <kbd>⇧ Shift</kbd> + <kbd>W</kbd> searches for the selected text on the web
- <kbd>⌘ Cmd</kbd> + <kbd>Up</kbd> scrolls the content up
- <kbd>⌘ Cmd</kbd> + <kbd>Down</kbd> scrolls the content down
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>Down</kbd> moves the current line down
- <kbd>⌘ Cmd</kbd> + <kbd>⇧ Shift</kbd> + <kbd>Up</kbd> moves the current line up
- <kbd>⇧ Shift</kbd> + <kbd>Return</kbd> adds two spaces and a newline character to force a markdown newline

### In the note preview panel

- <kbd>⌘ Cmd</kbd> + <kbd>F</kbd> lets you search in the current note
  - use the <kbd>Up</kbd> and <kbd>Down</kbd> keys or <kbd>F3</kbd> and
    <kbd>⇧ Shift</kbd> + <kbd>F3</kbd> keys to jump to the previous and next matches
  - <kbd>Esc</kbd> closes the search bar

### In the Todo list

- <kbd>⌘ Cmd</kbd> + <kbd>S</kbd> saves the current todo item
- <kbd>⌘ Cmd</kbd> + <kbd>I</kbd> saves the current todo item and inserts in into the current note
- <kbd>⌘ Cmd</kbd> + <kbd>R</kbd> removes the current todo item
