'''OpenGL extension AMD.depth_clamp_separate

This module customises the behaviour of the 
OpenGL.raw.GL.AMD.depth_clamp_separate to provide a more 
Python-friendly API

Overview (from the spec)
	
	The extension ARB_depth_clamp introduced the ability to control
	the clamping of the depth value for both the near and far plane.
	One limitation is that the control was for both planes at the
	same time; some applications can benefit from having clamping
	enabled for only one of the two planes, in order to save
	fillrate for the other plane by clipping the geometry.
	
	This extension provides exactly such functionality.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/AMD/depth_clamp_separate.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.AMD.depth_clamp_separate import *
from OpenGL.raw.GL.AMD.depth_clamp_separate import _EXTENSION_NAME

def glInitDepthClampSeparateAMD():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION