Pydub loves user contributions. 

We are happy to merge Pull Requests for features and bug fixes, of course. But, also spelling corrections, PEP 8 conformity, and platform-specific fixes.

Don't be shy!

### How to contribute:

1. Fork [pydub on github](https://github.com/jiaaro/pydub)
2. Commit changes
3. Send a Pull Request

you did it! 

don't forget to append your name to the AUTHORS file ;)

There _are_ a few things that will make your Pull Request more likely to be merged:

1. Maintain backward compatibility
2. Avoid new dependencies
3. Include tests (and make sure they pass)
4. Write a short description of **what** is changed and **why**
5. Keep your Pull Request small, and focused on fixing one thing. 

  Smaller is easier to review, and easier to understand. 
  
  If you want to fix spelling and PEP 8 violations, send two pull requests :)
  
  
### Want to pitch in?
  
Take a look at our issue tracker for anything tagged [`bug`][bugs] or [`todo`][todos] - these are goals of the project and your improvements are _very_ likely to be merged!

That being said, there are many possible contributions we haven't thought of already. Those are welcome too!

Here are some general topics of interest for future development:

- Make it easier to get started with pydub
- More/better audio effects
- Support more audio formats
- Improve handling of large audio files
- Make things faster and use less memory.

[bugs]: https://github.com/jiaaro/pydub/issues?q=is%3Aissue+is%3Aopen+label%3Abug
[todos]: https://github.com/jiaaro/pydub/issues?q=is%3Aissue+is%3Aopen+label%3Atodo
