#[allow(non_camel_case_types)]
#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum Opcode {
  PHI,
  INLINEASM,
  INLINEASM_BR,
  CFI_INSTRUCTION,
  EH_LABEL,
  GC_LABEL,
  ANNOTATION_LABEL,
  KILL,
  EXTRACT_SUBREG,
  INSERT_SUBREG,
  IMPLICIT_DEF,
  SUBREG_TO_REG,
  COPY_TO_REGCLASS,
  DBG_VALUE,
  DBG_VALUE_LIST,
  DBG_INSTR_REF,
  DBG_PHI,
  DBG_LABEL,
  REG_SEQUENCE,
  COPY,
  BUNDLE,
  LIFETIME_START,
  LIFETIME_END,
  PSEUDO_PROBE,
  ARITH_FENCE,
  STACKMAP,
  FENTRY_CALL,
  PATCHPOINT,
  LOAD_STACK_GUARD,
  PREALLOCATED_SETUP,
  PREALLOCATED_ARG,
  STATEPOINT,
  LOCAL_ESCAPE,
  FAULTING_OP,
  PATCHABLE_OP,
  PATCHABLE_FUNCTION_ENTER,
  PATCHABLE_RET,
  PATCHABLE_FUNCTION_EXIT,
  PATCHABLE_TAIL_CALL,
  PATCHABLE_EVENT_CALL,
  PATCHABLE_TYPED_EVENT_CALL,
  ICALL_BRANCH_FUNNEL,
  MEMBARRIER,
  JUMP_TABLE_DEBUG_INFO,
  CONVERGENCECTRL_ENTRY,
  CONVERGENCECTRL_ANCHOR,
  CONVERGENCECTRL_LOOP,
  CONVERGENCECTRL_GLUE,
  G_ASSERT_SEXT,
  G_ASSERT_ZEXT,
  G_ASSERT_ALIGN,
  G_ADD,
  G_SUB,
  G_MUL,
  G_SDIV,
  G_UDIV,
  G_SREM,
  G_UREM,
  G_SDIVREM,
  G_UDIVREM,
  G_AND,
  G_OR,
  G_XOR,
  G_IMPLICIT_DEF,
  G_PHI,
  G_FRAME_INDEX,
  G_GLOBAL_VALUE,
  G_PTRAUTH_GLOBAL_VALUE,
  G_CONSTANT_POOL,
  G_EXTRACT,
  G_UNMERGE_VALUES,
  G_INSERT,
  G_MERGE_VALUES,
  G_BUILD_VECTOR,
  G_BUILD_VECTOR_TRUNC,
  G_CONCAT_VECTORS,
  G_PTRTOINT,
  G_INTTOPTR,
  G_BITCAST,
  G_FREEZE,
  G_CONSTANT_FOLD_BARRIER,
  G_INTRINSIC_FPTRUNC_ROUND,
  G_INTRINSIC_TRUNC,
  G_INTRINSIC_ROUND,
  G_INTRINSIC_LRINT,
  G_INTRINSIC_LLRINT,
  G_INTRINSIC_ROUNDEVEN,
  G_READCYCLECOUNTER,
  G_READSTEADYCOUNTER,
  G_LOAD,
  G_SEXTLOAD,
  G_ZEXTLOAD,
  G_INDEXED_LOAD,
  G_INDEXED_SEXTLOAD,
  G_INDEXED_ZEXTLOAD,
  G_STORE,
  G_INDEXED_STORE,
  G_ATOMIC_CMPXCHG_WITH_SUCCESS,
  G_ATOMIC_CMPXCHG,
  G_ATOMICRMW_XCHG,
  G_ATOMICRMW_ADD,
  G_ATOMICRMW_SUB,
  G_ATOMICRMW_AND,
  G_ATOMICRMW_NAND,
  G_ATOMICRMW_OR,
  G_ATOMICRMW_XOR,
  G_ATOMICRMW_MAX,
  G_ATOMICRMW_MIN,
  G_ATOMICRMW_UMAX,
  G_ATOMICRMW_UMIN,
  G_ATOMICRMW_FADD,
  G_ATOMICRMW_FSUB,
  G_ATOMICRMW_FMAX,
  G_ATOMICRMW_FMIN,
  G_ATOMICRMW_UINC_WRAP,
  G_ATOMICRMW_UDEC_WRAP,
  G_FENCE,
  G_PREFETCH,
  G_BRCOND,
  G_BRINDIRECT,
  G_INVOKE_REGION_START,
  G_INTRINSIC,
  G_INTRINSIC_W_SIDE_EFFECTS,
  G_INTRINSIC_CONVERGENT,
  G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
  G_ANYEXT,
  G_TRUNC,
  G_CONSTANT,
  G_FCONSTANT,
  G_VASTART,
  G_VAARG,
  G_SEXT,
  G_SEXT_INREG,
  G_ZEXT,
  G_SHL,
  G_LSHR,
  G_ASHR,
  G_FSHL,
  G_FSHR,
  G_ROTR,
  G_ROTL,
  G_ICMP,
  G_FCMP,
  G_SCMP,
  G_UCMP,
  G_SELECT,
  G_UADDO,
  G_UADDE,
  G_USUBO,
  G_USUBE,
  G_SADDO,
  G_SADDE,
  G_SSUBO,
  G_SSUBE,
  G_UMULO,
  G_SMULO,
  G_UMULH,
  G_SMULH,
  G_UADDSAT,
  G_SADDSAT,
  G_USUBSAT,
  G_SSUBSAT,
  G_USHLSAT,
  G_SSHLSAT,
  G_SMULFIX,
  G_UMULFIX,
  G_SMULFIXSAT,
  G_UMULFIXSAT,
  G_SDIVFIX,
  G_UDIVFIX,
  G_SDIVFIXSAT,
  G_UDIVFIXSAT,
  G_FADD,
  G_FSUB,
  G_FMUL,
  G_FMA,
  G_FMAD,
  G_FDIV,
  G_FREM,
  G_FPOW,
  G_FPOWI,
  G_FEXP,
  G_FEXP2,
  G_FEXP10,
  G_FLOG,
  G_FLOG2,
  G_FLOG10,
  G_FLDEXP,
  G_FFREXP,
  G_FNEG,
  G_FPEXT,
  G_FPTRUNC,
  G_FPTOSI,
  G_FPTOUI,
  G_SITOFP,
  G_UITOFP,
  G_FABS,
  G_FCOPYSIGN,
  G_IS_FPCLASS,
  G_FCANONICALIZE,
  G_FMINNUM,
  G_FMAXNUM,
  G_FMINNUM_IEEE,
  G_FMAXNUM_IEEE,
  G_FMINIMUM,
  G_FMAXIMUM,
  G_GET_FPENV,
  G_SET_FPENV,
  G_RESET_FPENV,
  G_GET_FPMODE,
  G_SET_FPMODE,
  G_RESET_FPMODE,
  G_PTR_ADD,
  G_PTRMASK,
  G_SMIN,
  G_SMAX,
  G_UMIN,
  G_UMAX,
  G_ABS,
  G_LROUND,
  G_LLROUND,
  G_BR,
  G_BRJT,
  G_VSCALE,
  G_INSERT_SUBVECTOR,
  G_EXTRACT_SUBVECTOR,
  G_INSERT_VECTOR_ELT,
  G_EXTRACT_VECTOR_ELT,
  G_SHUFFLE_VECTOR,
  G_SPLAT_VECTOR,
  G_VECTOR_COMPRESS,
  G_CTTZ,
  G_CTTZ_ZERO_UNDEF,
  G_CTLZ,
  G_CTLZ_ZERO_UNDEF,
  G_CTPOP,
  G_BSWAP,
  G_BITREVERSE,
  G_FCEIL,
  G_FCOS,
  G_FSIN,
  G_FTAN,
  G_FACOS,
  G_FASIN,
  G_FATAN,
  G_FCOSH,
  G_FSINH,
  G_FTANH,
  G_FSQRT,
  G_FFLOOR,
  G_FRINT,
  G_FNEARBYINT,
  G_ADDRSPACE_CAST,
  G_BLOCK_ADDR,
  G_JUMP_TABLE,
  G_DYN_STACKALLOC,
  G_STACKSAVE,
  G_STACKRESTORE,
  G_STRICT_FADD,
  G_STRICT_FSUB,
  G_STRICT_FMUL,
  G_STRICT_FDIV,
  G_STRICT_FREM,
  G_STRICT_FMA,
  G_STRICT_FSQRT,
  G_STRICT_FLDEXP,
  G_READ_REGISTER,
  G_WRITE_REGISTER,
  G_MEMCPY,
  G_MEMCPY_INLINE,
  G_MEMMOVE,
  G_MEMSET,
  G_BZERO,
  G_TRAP,
  G_DEBUGTRAP,
  G_UBSANTRAP,
  G_VECREDUCE_SEQ_FADD,
  G_VECREDUCE_SEQ_FMUL,
  G_VECREDUCE_FADD,
  G_VECREDUCE_FMUL,
  G_VECREDUCE_FMAX,
  G_VECREDUCE_FMIN,
  G_VECREDUCE_FMAXIMUM,
  G_VECREDUCE_FMINIMUM,
  G_VECREDUCE_ADD,
  G_VECREDUCE_MUL,
  G_VECREDUCE_AND,
  G_VECREDUCE_OR,
  G_VECREDUCE_XOR,
  G_VECREDUCE_SMAX,
  G_VECREDUCE_SMIN,
  G_VECREDUCE_UMAX,
  G_VECREDUCE_UMIN,
  G_SBFX,
  G_UBFX,
  ADJCALLSTACKDOWN,
  ADJCALLSTACKUP,
  FI_ri,
  MEMCPY,
  Select,
  Select_32,
  Select_32_64,
  Select_64_32,
  Select_Ri,
  Select_Ri_32,
  Select_Ri_32_64,
  Select_Ri_64_32,
  ADDR_SPACE_CAST,
  ADD_ri,
  ADD_ri_32,
  ADD_rr,
  ADD_rr_32,
  AND_ri,
  AND_ri_32,
  AND_rr,
  AND_rr_32,
  BE16,
  BE32,
  BE64,
  BSWAP16,
  BSWAP32,
  BSWAP64,
  CMPXCHGD,
  CMPXCHGW32,
  CORE_LD32,
  CORE_LD64,
  CORE_SHIFT,
  CORE_ST,
  DIV_ri,
  DIV_ri_32,
  DIV_rr,
  DIV_rr_32,
  JAL,
  JALX,
  JCOND,
  JEQ_ri,
  JEQ_ri_32,
  JEQ_rr,
  JEQ_rr_32,
  JMP,
  JMPL,
  JNE_ri,
  JNE_ri_32,
  JNE_rr,
  JNE_rr_32,
  JSET_ri,
  JSET_ri_32,
  JSET_rr,
  JSET_rr_32,
  JSGE_ri,
  JSGE_ri_32,
  JSGE_rr,
  JSGE_rr_32,
  JSGT_ri,
  JSGT_ri_32,
  JSGT_rr,
  JSGT_rr_32,
  JSLE_ri,
  JSLE_ri_32,
  JSLE_rr,
  JSLE_rr_32,
  JSLT_ri,
  JSLT_ri_32,
  JSLT_rr,
  JSLT_rr_32,
  JUGE_ri,
  JUGE_ri_32,
  JUGE_rr,
  JUGE_rr_32,
  JUGT_ri,
  JUGT_ri_32,
  JUGT_rr,
  JUGT_rr_32,
  JULE_ri,
  JULE_ri_32,
  JULE_rr,
  JULE_rr_32,
  JULT_ri,
  JULT_ri_32,
  JULT_rr,
  JULT_rr_32,
  LDB,
  LDB32,
  LDBSX,
  LDD,
  LDH,
  LDH32,
  LDHSX,
  LDW,
  LDW32,
  LDWSX,
  LD_ABS_B,
  LD_ABS_H,
  LD_ABS_W,
  LD_IND_B,
  LD_IND_H,
  LD_IND_W,
  LD_imm64,
  LD_pseudo,
  LE16,
  LE32,
  LE64,
  MOD_ri,
  MOD_ri_32,
  MOD_rr,
  MOD_rr_32,
  MOVSX_rr_16,
  MOVSX_rr_32,
  MOVSX_rr_32_16,
  MOVSX_rr_32_8,
  MOVSX_rr_8,
  MOV_32_64,
  MOV_ri,
  MOV_ri_32,
  MOV_rr,
  MOV_rr_32,
  MUL_ri,
  MUL_ri_32,
  MUL_rr,
  MUL_rr_32,
  NEG_32,
  NEG_64,
  NOP,
  OR_ri,
  OR_ri_32,
  OR_rr,
  OR_rr_32,
  RET,
  SDIV_ri,
  SDIV_ri_32,
  SDIV_rr,
  SDIV_rr_32,
  SLL_ri,
  SLL_ri_32,
  SLL_rr,
  SLL_rr_32,
  SMOD_ri,
  SMOD_ri_32,
  SMOD_rr,
  SMOD_rr_32,
  SRA_ri,
  SRA_ri_32,
  SRA_rr,
  SRA_rr_32,
  SRL_ri,
  SRL_ri_32,
  SRL_rr,
  SRL_rr_32,
  STB,
  STB32,
  STB_imm,
  STD,
  STD_imm,
  STH,
  STH32,
  STH_imm,
  STW,
  STW32,
  STW_imm,
  SUB_ri,
  SUB_ri_32,
  SUB_rr,
  SUB_rr_32,
  XADDD,
  XADDW,
  XADDW32,
  XANDD,
  XANDW32,
  XCHGD,
  XCHGW32,
  XFADDD,
  XFADDW32,
  XFANDD,
  XFANDW32,
  XFORD,
  XFORW32,
  XFXORD,
  XFXORW32,
  XORD,
  XORW32,
  XOR_ri,
  XOR_ri_32,
  XOR_rr,
  XOR_rr_32,
  XXORD,
  XXORW32,
  INSTRUCTION_LIST_END,
  UNKNOWN(u64),
}

impl From<u64> for Opcode {
    fn from(value: u64) -> Self {
        match value {
          0 => Opcode::PHI,
          1 => Opcode::INLINEASM,
          2 => Opcode::INLINEASM_BR,
          3 => Opcode::CFI_INSTRUCTION,
          4 => Opcode::EH_LABEL,
          5 => Opcode::GC_LABEL,
          6 => Opcode::ANNOTATION_LABEL,
          7 => Opcode::KILL,
          8 => Opcode::EXTRACT_SUBREG,
          9 => Opcode::INSERT_SUBREG,
          10 => Opcode::IMPLICIT_DEF,
          11 => Opcode::SUBREG_TO_REG,
          12 => Opcode::COPY_TO_REGCLASS,
          13 => Opcode::DBG_VALUE,
          14 => Opcode::DBG_VALUE_LIST,
          15 => Opcode::DBG_INSTR_REF,
          16 => Opcode::DBG_PHI,
          17 => Opcode::DBG_LABEL,
          18 => Opcode::REG_SEQUENCE,
          19 => Opcode::COPY,
          20 => Opcode::BUNDLE,
          21 => Opcode::LIFETIME_START,
          22 => Opcode::LIFETIME_END,
          23 => Opcode::PSEUDO_PROBE,
          24 => Opcode::ARITH_FENCE,
          25 => Opcode::STACKMAP,
          26 => Opcode::FENTRY_CALL,
          27 => Opcode::PATCHPOINT,
          28 => Opcode::LOAD_STACK_GUARD,
          29 => Opcode::PREALLOCATED_SETUP,
          30 => Opcode::PREALLOCATED_ARG,
          31 => Opcode::STATEPOINT,
          32 => Opcode::LOCAL_ESCAPE,
          33 => Opcode::FAULTING_OP,
          34 => Opcode::PATCHABLE_OP,
          35 => Opcode::PATCHABLE_FUNCTION_ENTER,
          36 => Opcode::PATCHABLE_RET,
          37 => Opcode::PATCHABLE_FUNCTION_EXIT,
          38 => Opcode::PATCHABLE_TAIL_CALL,
          39 => Opcode::PATCHABLE_EVENT_CALL,
          40 => Opcode::PATCHABLE_TYPED_EVENT_CALL,
          41 => Opcode::ICALL_BRANCH_FUNNEL,
          42 => Opcode::MEMBARRIER,
          43 => Opcode::JUMP_TABLE_DEBUG_INFO,
          44 => Opcode::CONVERGENCECTRL_ENTRY,
          45 => Opcode::CONVERGENCECTRL_ANCHOR,
          46 => Opcode::CONVERGENCECTRL_LOOP,
          47 => Opcode::CONVERGENCECTRL_GLUE,
          48 => Opcode::G_ASSERT_SEXT,
          49 => Opcode::G_ASSERT_ZEXT,
          50 => Opcode::G_ASSERT_ALIGN,
          51 => Opcode::G_ADD,
          52 => Opcode::G_SUB,
          53 => Opcode::G_MUL,
          54 => Opcode::G_SDIV,
          55 => Opcode::G_UDIV,
          56 => Opcode::G_SREM,
          57 => Opcode::G_UREM,
          58 => Opcode::G_SDIVREM,
          59 => Opcode::G_UDIVREM,
          60 => Opcode::G_AND,
          61 => Opcode::G_OR,
          62 => Opcode::G_XOR,
          63 => Opcode::G_IMPLICIT_DEF,
          64 => Opcode::G_PHI,
          65 => Opcode::G_FRAME_INDEX,
          66 => Opcode::G_GLOBAL_VALUE,
          67 => Opcode::G_PTRAUTH_GLOBAL_VALUE,
          68 => Opcode::G_CONSTANT_POOL,
          69 => Opcode::G_EXTRACT,
          70 => Opcode::G_UNMERGE_VALUES,
          71 => Opcode::G_INSERT,
          72 => Opcode::G_MERGE_VALUES,
          73 => Opcode::G_BUILD_VECTOR,
          74 => Opcode::G_BUILD_VECTOR_TRUNC,
          75 => Opcode::G_CONCAT_VECTORS,
          76 => Opcode::G_PTRTOINT,
          77 => Opcode::G_INTTOPTR,
          78 => Opcode::G_BITCAST,
          79 => Opcode::G_FREEZE,
          80 => Opcode::G_CONSTANT_FOLD_BARRIER,
          81 => Opcode::G_INTRINSIC_FPTRUNC_ROUND,
          82 => Opcode::G_INTRINSIC_TRUNC,
          83 => Opcode::G_INTRINSIC_ROUND,
          84 => Opcode::G_INTRINSIC_LRINT,
          85 => Opcode::G_INTRINSIC_LLRINT,
          86 => Opcode::G_INTRINSIC_ROUNDEVEN,
          87 => Opcode::G_READCYCLECOUNTER,
          88 => Opcode::G_READSTEADYCOUNTER,
          89 => Opcode::G_LOAD,
          90 => Opcode::G_SEXTLOAD,
          91 => Opcode::G_ZEXTLOAD,
          92 => Opcode::G_INDEXED_LOAD,
          93 => Opcode::G_INDEXED_SEXTLOAD,
          94 => Opcode::G_INDEXED_ZEXTLOAD,
          95 => Opcode::G_STORE,
          96 => Opcode::G_INDEXED_STORE,
          97 => Opcode::G_ATOMIC_CMPXCHG_WITH_SUCCESS,
          98 => Opcode::G_ATOMIC_CMPXCHG,
          99 => Opcode::G_ATOMICRMW_XCHG,
          100 => Opcode::G_ATOMICRMW_ADD,
          101 => Opcode::G_ATOMICRMW_SUB,
          102 => Opcode::G_ATOMICRMW_AND,
          103 => Opcode::G_ATOMICRMW_NAND,
          104 => Opcode::G_ATOMICRMW_OR,
          105 => Opcode::G_ATOMICRMW_XOR,
          106 => Opcode::G_ATOMICRMW_MAX,
          107 => Opcode::G_ATOMICRMW_MIN,
          108 => Opcode::G_ATOMICRMW_UMAX,
          109 => Opcode::G_ATOMICRMW_UMIN,
          110 => Opcode::G_ATOMICRMW_FADD,
          111 => Opcode::G_ATOMICRMW_FSUB,
          112 => Opcode::G_ATOMICRMW_FMAX,
          113 => Opcode::G_ATOMICRMW_FMIN,
          114 => Opcode::G_ATOMICRMW_UINC_WRAP,
          115 => Opcode::G_ATOMICRMW_UDEC_WRAP,
          116 => Opcode::G_FENCE,
          117 => Opcode::G_PREFETCH,
          118 => Opcode::G_BRCOND,
          119 => Opcode::G_BRINDIRECT,
          120 => Opcode::G_INVOKE_REGION_START,
          121 => Opcode::G_INTRINSIC,
          122 => Opcode::G_INTRINSIC_W_SIDE_EFFECTS,
          123 => Opcode::G_INTRINSIC_CONVERGENT,
          124 => Opcode::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
          125 => Opcode::G_ANYEXT,
          126 => Opcode::G_TRUNC,
          127 => Opcode::G_CONSTANT,
          128 => Opcode::G_FCONSTANT,
          129 => Opcode::G_VASTART,
          130 => Opcode::G_VAARG,
          131 => Opcode::G_SEXT,
          132 => Opcode::G_SEXT_INREG,
          133 => Opcode::G_ZEXT,
          134 => Opcode::G_SHL,
          135 => Opcode::G_LSHR,
          136 => Opcode::G_ASHR,
          137 => Opcode::G_FSHL,
          138 => Opcode::G_FSHR,
          139 => Opcode::G_ROTR,
          140 => Opcode::G_ROTL,
          141 => Opcode::G_ICMP,
          142 => Opcode::G_FCMP,
          143 => Opcode::G_SCMP,
          144 => Opcode::G_UCMP,
          145 => Opcode::G_SELECT,
          146 => Opcode::G_UADDO,
          147 => Opcode::G_UADDE,
          148 => Opcode::G_USUBO,
          149 => Opcode::G_USUBE,
          150 => Opcode::G_SADDO,
          151 => Opcode::G_SADDE,
          152 => Opcode::G_SSUBO,
          153 => Opcode::G_SSUBE,
          154 => Opcode::G_UMULO,
          155 => Opcode::G_SMULO,
          156 => Opcode::G_UMULH,
          157 => Opcode::G_SMULH,
          158 => Opcode::G_UADDSAT,
          159 => Opcode::G_SADDSAT,
          160 => Opcode::G_USUBSAT,
          161 => Opcode::G_SSUBSAT,
          162 => Opcode::G_USHLSAT,
          163 => Opcode::G_SSHLSAT,
          164 => Opcode::G_SMULFIX,
          165 => Opcode::G_UMULFIX,
          166 => Opcode::G_SMULFIXSAT,
          167 => Opcode::G_UMULFIXSAT,
          168 => Opcode::G_SDIVFIX,
          169 => Opcode::G_UDIVFIX,
          170 => Opcode::G_SDIVFIXSAT,
          171 => Opcode::G_UDIVFIXSAT,
          172 => Opcode::G_FADD,
          173 => Opcode::G_FSUB,
          174 => Opcode::G_FMUL,
          175 => Opcode::G_FMA,
          176 => Opcode::G_FMAD,
          177 => Opcode::G_FDIV,
          178 => Opcode::G_FREM,
          179 => Opcode::G_FPOW,
          180 => Opcode::G_FPOWI,
          181 => Opcode::G_FEXP,
          182 => Opcode::G_FEXP2,
          183 => Opcode::G_FEXP10,
          184 => Opcode::G_FLOG,
          185 => Opcode::G_FLOG2,
          186 => Opcode::G_FLOG10,
          187 => Opcode::G_FLDEXP,
          188 => Opcode::G_FFREXP,
          189 => Opcode::G_FNEG,
          190 => Opcode::G_FPEXT,
          191 => Opcode::G_FPTRUNC,
          192 => Opcode::G_FPTOSI,
          193 => Opcode::G_FPTOUI,
          194 => Opcode::G_SITOFP,
          195 => Opcode::G_UITOFP,
          196 => Opcode::G_FABS,
          197 => Opcode::G_FCOPYSIGN,
          198 => Opcode::G_IS_FPCLASS,
          199 => Opcode::G_FCANONICALIZE,
          200 => Opcode::G_FMINNUM,
          201 => Opcode::G_FMAXNUM,
          202 => Opcode::G_FMINNUM_IEEE,
          203 => Opcode::G_FMAXNUM_IEEE,
          204 => Opcode::G_FMINIMUM,
          205 => Opcode::G_FMAXIMUM,
          206 => Opcode::G_GET_FPENV,
          207 => Opcode::G_SET_FPENV,
          208 => Opcode::G_RESET_FPENV,
          209 => Opcode::G_GET_FPMODE,
          210 => Opcode::G_SET_FPMODE,
          211 => Opcode::G_RESET_FPMODE,
          212 => Opcode::G_PTR_ADD,
          213 => Opcode::G_PTRMASK,
          214 => Opcode::G_SMIN,
          215 => Opcode::G_SMAX,
          216 => Opcode::G_UMIN,
          217 => Opcode::G_UMAX,
          218 => Opcode::G_ABS,
          219 => Opcode::G_LROUND,
          220 => Opcode::G_LLROUND,
          221 => Opcode::G_BR,
          222 => Opcode::G_BRJT,
          223 => Opcode::G_VSCALE,
          224 => Opcode::G_INSERT_SUBVECTOR,
          225 => Opcode::G_EXTRACT_SUBVECTOR,
          226 => Opcode::G_INSERT_VECTOR_ELT,
          227 => Opcode::G_EXTRACT_VECTOR_ELT,
          228 => Opcode::G_SHUFFLE_VECTOR,
          229 => Opcode::G_SPLAT_VECTOR,
          230 => Opcode::G_VECTOR_COMPRESS,
          231 => Opcode::G_CTTZ,
          232 => Opcode::G_CTTZ_ZERO_UNDEF,
          233 => Opcode::G_CTLZ,
          234 => Opcode::G_CTLZ_ZERO_UNDEF,
          235 => Opcode::G_CTPOP,
          236 => Opcode::G_BSWAP,
          237 => Opcode::G_BITREVERSE,
          238 => Opcode::G_FCEIL,
          239 => Opcode::G_FCOS,
          240 => Opcode::G_FSIN,
          241 => Opcode::G_FTAN,
          242 => Opcode::G_FACOS,
          243 => Opcode::G_FASIN,
          244 => Opcode::G_FATAN,
          245 => Opcode::G_FCOSH,
          246 => Opcode::G_FSINH,
          247 => Opcode::G_FTANH,
          248 => Opcode::G_FSQRT,
          249 => Opcode::G_FFLOOR,
          250 => Opcode::G_FRINT,
          251 => Opcode::G_FNEARBYINT,
          252 => Opcode::G_ADDRSPACE_CAST,
          253 => Opcode::G_BLOCK_ADDR,
          254 => Opcode::G_JUMP_TABLE,
          255 => Opcode::G_DYN_STACKALLOC,
          256 => Opcode::G_STACKSAVE,
          257 => Opcode::G_STACKRESTORE,
          258 => Opcode::G_STRICT_FADD,
          259 => Opcode::G_STRICT_FSUB,
          260 => Opcode::G_STRICT_FMUL,
          261 => Opcode::G_STRICT_FDIV,
          262 => Opcode::G_STRICT_FREM,
          263 => Opcode::G_STRICT_FMA,
          264 => Opcode::G_STRICT_FSQRT,
          265 => Opcode::G_STRICT_FLDEXP,
          266 => Opcode::G_READ_REGISTER,
          267 => Opcode::G_WRITE_REGISTER,
          268 => Opcode::G_MEMCPY,
          269 => Opcode::G_MEMCPY_INLINE,
          270 => Opcode::G_MEMMOVE,
          271 => Opcode::G_MEMSET,
          272 => Opcode::G_BZERO,
          273 => Opcode::G_TRAP,
          274 => Opcode::G_DEBUGTRAP,
          275 => Opcode::G_UBSANTRAP,
          276 => Opcode::G_VECREDUCE_SEQ_FADD,
          277 => Opcode::G_VECREDUCE_SEQ_FMUL,
          278 => Opcode::G_VECREDUCE_FADD,
          279 => Opcode::G_VECREDUCE_FMUL,
          280 => Opcode::G_VECREDUCE_FMAX,
          281 => Opcode::G_VECREDUCE_FMIN,
          282 => Opcode::G_VECREDUCE_FMAXIMUM,
          283 => Opcode::G_VECREDUCE_FMINIMUM,
          284 => Opcode::G_VECREDUCE_ADD,
          285 => Opcode::G_VECREDUCE_MUL,
          286 => Opcode::G_VECREDUCE_AND,
          287 => Opcode::G_VECREDUCE_OR,
          288 => Opcode::G_VECREDUCE_XOR,
          289 => Opcode::G_VECREDUCE_SMAX,
          290 => Opcode::G_VECREDUCE_SMIN,
          291 => Opcode::G_VECREDUCE_UMAX,
          292 => Opcode::G_VECREDUCE_UMIN,
          293 => Opcode::G_SBFX,
          294 => Opcode::G_UBFX,
          295 => Opcode::ADJCALLSTACKDOWN,
          296 => Opcode::ADJCALLSTACKUP,
          297 => Opcode::FI_ri,
          298 => Opcode::MEMCPY,
          299 => Opcode::Select,
          300 => Opcode::Select_32,
          301 => Opcode::Select_32_64,
          302 => Opcode::Select_64_32,
          303 => Opcode::Select_Ri,
          304 => Opcode::Select_Ri_32,
          305 => Opcode::Select_Ri_32_64,
          306 => Opcode::Select_Ri_64_32,
          307 => Opcode::ADDR_SPACE_CAST,
          308 => Opcode::ADD_ri,
          309 => Opcode::ADD_ri_32,
          310 => Opcode::ADD_rr,
          311 => Opcode::ADD_rr_32,
          312 => Opcode::AND_ri,
          313 => Opcode::AND_ri_32,
          314 => Opcode::AND_rr,
          315 => Opcode::AND_rr_32,
          316 => Opcode::BE16,
          317 => Opcode::BE32,
          318 => Opcode::BE64,
          319 => Opcode::BSWAP16,
          320 => Opcode::BSWAP32,
          321 => Opcode::BSWAP64,
          322 => Opcode::CMPXCHGD,
          323 => Opcode::CMPXCHGW32,
          324 => Opcode::CORE_LD32,
          325 => Opcode::CORE_LD64,
          326 => Opcode::CORE_SHIFT,
          327 => Opcode::CORE_ST,
          328 => Opcode::DIV_ri,
          329 => Opcode::DIV_ri_32,
          330 => Opcode::DIV_rr,
          331 => Opcode::DIV_rr_32,
          332 => Opcode::JAL,
          333 => Opcode::JALX,
          334 => Opcode::JCOND,
          335 => Opcode::JEQ_ri,
          336 => Opcode::JEQ_ri_32,
          337 => Opcode::JEQ_rr,
          338 => Opcode::JEQ_rr_32,
          339 => Opcode::JMP,
          340 => Opcode::JMPL,
          341 => Opcode::JNE_ri,
          342 => Opcode::JNE_ri_32,
          343 => Opcode::JNE_rr,
          344 => Opcode::JNE_rr_32,
          345 => Opcode::JSET_ri,
          346 => Opcode::JSET_ri_32,
          347 => Opcode::JSET_rr,
          348 => Opcode::JSET_rr_32,
          349 => Opcode::JSGE_ri,
          350 => Opcode::JSGE_ri_32,
          351 => Opcode::JSGE_rr,
          352 => Opcode::JSGE_rr_32,
          353 => Opcode::JSGT_ri,
          354 => Opcode::JSGT_ri_32,
          355 => Opcode::JSGT_rr,
          356 => Opcode::JSGT_rr_32,
          357 => Opcode::JSLE_ri,
          358 => Opcode::JSLE_ri_32,
          359 => Opcode::JSLE_rr,
          360 => Opcode::JSLE_rr_32,
          361 => Opcode::JSLT_ri,
          362 => Opcode::JSLT_ri_32,
          363 => Opcode::JSLT_rr,
          364 => Opcode::JSLT_rr_32,
          365 => Opcode::JUGE_ri,
          366 => Opcode::JUGE_ri_32,
          367 => Opcode::JUGE_rr,
          368 => Opcode::JUGE_rr_32,
          369 => Opcode::JUGT_ri,
          370 => Opcode::JUGT_ri_32,
          371 => Opcode::JUGT_rr,
          372 => Opcode::JUGT_rr_32,
          373 => Opcode::JULE_ri,
          374 => Opcode::JULE_ri_32,
          375 => Opcode::JULE_rr,
          376 => Opcode::JULE_rr_32,
          377 => Opcode::JULT_ri,
          378 => Opcode::JULT_ri_32,
          379 => Opcode::JULT_rr,
          380 => Opcode::JULT_rr_32,
          381 => Opcode::LDB,
          382 => Opcode::LDB32,
          383 => Opcode::LDBSX,
          384 => Opcode::LDD,
          385 => Opcode::LDH,
          386 => Opcode::LDH32,
          387 => Opcode::LDHSX,
          388 => Opcode::LDW,
          389 => Opcode::LDW32,
          390 => Opcode::LDWSX,
          391 => Opcode::LD_ABS_B,
          392 => Opcode::LD_ABS_H,
          393 => Opcode::LD_ABS_W,
          394 => Opcode::LD_IND_B,
          395 => Opcode::LD_IND_H,
          396 => Opcode::LD_IND_W,
          397 => Opcode::LD_imm64,
          398 => Opcode::LD_pseudo,
          399 => Opcode::LE16,
          400 => Opcode::LE32,
          401 => Opcode::LE64,
          402 => Opcode::MOD_ri,
          403 => Opcode::MOD_ri_32,
          404 => Opcode::MOD_rr,
          405 => Opcode::MOD_rr_32,
          406 => Opcode::MOVSX_rr_16,
          407 => Opcode::MOVSX_rr_32,
          408 => Opcode::MOVSX_rr_32_16,
          409 => Opcode::MOVSX_rr_32_8,
          410 => Opcode::MOVSX_rr_8,
          411 => Opcode::MOV_32_64,
          412 => Opcode::MOV_ri,
          413 => Opcode::MOV_ri_32,
          414 => Opcode::MOV_rr,
          415 => Opcode::MOV_rr_32,
          416 => Opcode::MUL_ri,
          417 => Opcode::MUL_ri_32,
          418 => Opcode::MUL_rr,
          419 => Opcode::MUL_rr_32,
          420 => Opcode::NEG_32,
          421 => Opcode::NEG_64,
          422 => Opcode::NOP,
          423 => Opcode::OR_ri,
          424 => Opcode::OR_ri_32,
          425 => Opcode::OR_rr,
          426 => Opcode::OR_rr_32,
          427 => Opcode::RET,
          428 => Opcode::SDIV_ri,
          429 => Opcode::SDIV_ri_32,
          430 => Opcode::SDIV_rr,
          431 => Opcode::SDIV_rr_32,
          432 => Opcode::SLL_ri,
          433 => Opcode::SLL_ri_32,
          434 => Opcode::SLL_rr,
          435 => Opcode::SLL_rr_32,
          436 => Opcode::SMOD_ri,
          437 => Opcode::SMOD_ri_32,
          438 => Opcode::SMOD_rr,
          439 => Opcode::SMOD_rr_32,
          440 => Opcode::SRA_ri,
          441 => Opcode::SRA_ri_32,
          442 => Opcode::SRA_rr,
          443 => Opcode::SRA_rr_32,
          444 => Opcode::SRL_ri,
          445 => Opcode::SRL_ri_32,
          446 => Opcode::SRL_rr,
          447 => Opcode::SRL_rr_32,
          448 => Opcode::STB,
          449 => Opcode::STB32,
          450 => Opcode::STB_imm,
          451 => Opcode::STD,
          452 => Opcode::STD_imm,
          453 => Opcode::STH,
          454 => Opcode::STH32,
          455 => Opcode::STH_imm,
          456 => Opcode::STW,
          457 => Opcode::STW32,
          458 => Opcode::STW_imm,
          459 => Opcode::SUB_ri,
          460 => Opcode::SUB_ri_32,
          461 => Opcode::SUB_rr,
          462 => Opcode::SUB_rr_32,
          463 => Opcode::XADDD,
          464 => Opcode::XADDW,
          465 => Opcode::XADDW32,
          466 => Opcode::XANDD,
          467 => Opcode::XANDW32,
          468 => Opcode::XCHGD,
          469 => Opcode::XCHGW32,
          470 => Opcode::XFADDD,
          471 => Opcode::XFADDW32,
          472 => Opcode::XFANDD,
          473 => Opcode::XFANDW32,
          474 => Opcode::XFORD,
          475 => Opcode::XFORW32,
          476 => Opcode::XFXORD,
          477 => Opcode::XFXORW32,
          478 => Opcode::XORD,
          479 => Opcode::XORW32,
          480 => Opcode::XOR_ri,
          481 => Opcode::XOR_ri_32,
          482 => Opcode::XOR_rr,
          483 => Opcode::XOR_rr_32,
          484 => Opcode::XXORD,
          485 => Opcode::XXORW32,
          486 => Opcode::INSTRUCTION_LIST_END,
          _ => Opcode::UNKNOWN(value),
        }
    }
}
