/* Copyright 2017 - 2023 R. Thomas
 * Copyright 2017 - 2023 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "pyPE.hpp"
#define LIEF_PE_FORCE_UNDEF
#include "LIEF/PE/undef.h"
#include "LIEF/PE/enums.hpp"
#include "LIEF/PE/EnumToString.hpp"
#include "enums_wrapper.hpp"

#define PY_ENUM(x) LIEF::PE::to_string(x), x

namespace LIEF {
namespace PE {


void init_enums(py::module& m) {

  LIEF::enum_<PE_TYPE>(m, "PE_TYPE")
    .value(PY_ENUM(PE_TYPE::PE32))
    .value(PY_ENUM(PE_TYPE::PE32_PLUS));

  LIEF::enum_<MACHINE_TYPES>(m, "MACHINE_TYPES")
    .value(PY_ENUM(MACHINE_TYPES::MT_Invalid))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_UNKNOWN))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_AM33))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_AMD64))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_ARM))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_ARMNT))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_ARM64))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_EBC))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_I386))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_IA64))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_M32R))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_MIPS16))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_MIPSFPU))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_MIPSFPU16))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_POWERPC))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_POWERPCFP))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_R4000))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_SH3))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_SH3DSP))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_SH4))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_SH5))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_THUMB))
    .value(PY_ENUM(MACHINE_TYPES::IMAGE_FILE_MACHINE_WCEMIPSV2));

  LIEF::enum_<HEADER_CHARACTERISTICS>(m, "HEADER_CHARACTERISTICS", py::arithmetic())
    .value(PY_ENUM(HEADER_CHARACTERISTICS::IMAGE_FILE_RELOCS_STRIPPED))
    .value(PY_ENUM(HEADER_CHARACTERISTICS::IMAGE_FILE_EXECUTABLE_IMAGE))
    .value(PY_ENUM(HEADER_CHARACTERISTICS::IMAGE_FILE_LINE_NUMS_STRIPPED))
    .value(PY_ENUM(HEADER_CHARACTERISTICS::IMAGE_FILE_LOCAL_SYMS_STRIPPED))
    .value(PY_ENUM(HEADER_CHARACTERISTICS::IMAGE_FILE_AGGRESSIVE_WS_TRIM))
    .value(PY_ENUM(HEADER_CHARACTERISTICS::IMAGE_FILE_LARGE_ADDRESS_AWARE))
    .value(PY_ENUM(HEADER_CHARACTERISTICS::IMAGE_FILE_BYTES_REVERSED_LO))
    .value(PY_ENUM(HEADER_CHARACTERISTICS::IMAGE_FILE_32BIT_MACHINE))
    .value(PY_ENUM(HEADER_CHARACTERISTICS::IMAGE_FILE_DEBUG_STRIPPED))
    .value(PY_ENUM(HEADER_CHARACTERISTICS::IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP))
    .value(PY_ENUM(HEADER_CHARACTERISTICS::IMAGE_FILE_NET_RUN_FROM_SWAP))
    .value(PY_ENUM(HEADER_CHARACTERISTICS::IMAGE_FILE_SYSTEM))
    .value(PY_ENUM(HEADER_CHARACTERISTICS::IMAGE_FILE_DLL))
    .value(PY_ENUM(HEADER_CHARACTERISTICS::IMAGE_FILE_UP_SYSTEM_ONLY))
    .value(PY_ENUM(HEADER_CHARACTERISTICS::IMAGE_FILE_BYTES_REVERSED_HI));

  LIEF::enum_<SUBSYSTEM>(m, "SUBSYSTEM")
    .value(PY_ENUM(SUBSYSTEM::IMAGE_SUBSYSTEM_UNKNOWN))
    .value(PY_ENUM(SUBSYSTEM::IMAGE_SUBSYSTEM_NATIVE))
    .value(PY_ENUM(SUBSYSTEM::IMAGE_SUBSYSTEM_WINDOWS_GUI))
    .value(PY_ENUM(SUBSYSTEM::IMAGE_SUBSYSTEM_WINDOWS_CUI))
    .value(PY_ENUM(SUBSYSTEM::IMAGE_SUBSYSTEM_OS2_CUI))
    .value(PY_ENUM(SUBSYSTEM::IMAGE_SUBSYSTEM_POSIX_CUI))
    .value(PY_ENUM(SUBSYSTEM::IMAGE_SUBSYSTEM_NATIVE_WINDOWS))
    .value(PY_ENUM(SUBSYSTEM::IMAGE_SUBSYSTEM_WINDOWS_CE_GUI))
    .value(PY_ENUM(SUBSYSTEM::IMAGE_SUBSYSTEM_EFI_APPLICATION))
    .value(PY_ENUM(SUBSYSTEM::IMAGE_SUBSYSTEM_EFI_BOOT_SERVICE_DRIVER))
    .value(PY_ENUM(SUBSYSTEM::IMAGE_SUBSYSTEM_EFI_RUNTIME_DRIVER))
    .value(PY_ENUM(SUBSYSTEM::IMAGE_SUBSYSTEM_EFI_ROM))
    .value(PY_ENUM(SUBSYSTEM::IMAGE_SUBSYSTEM_XBOX))
    .value(PY_ENUM(SUBSYSTEM::IMAGE_SUBSYSTEM_WINDOWS_BOOT_APPLICATION));

  LIEF::enum_<DATA_DIRECTORY>(m, "DATA_DIRECTORY")
    .value(PY_ENUM(DATA_DIRECTORY::EXPORT_TABLE))
    .value(PY_ENUM(DATA_DIRECTORY::IMPORT_TABLE))
    .value(PY_ENUM(DATA_DIRECTORY::RESOURCE_TABLE))
    .value(PY_ENUM(DATA_DIRECTORY::EXCEPTION_TABLE))
    .value(PY_ENUM(DATA_DIRECTORY::CERTIFICATE_TABLE))
    .value(PY_ENUM(DATA_DIRECTORY::BASE_RELOCATION_TABLE))
    .value(PY_ENUM(DATA_DIRECTORY::DEBUG))
    .value(PY_ENUM(DATA_DIRECTORY::ARCHITECTURE))
    .value(PY_ENUM(DATA_DIRECTORY::GLOBAL_PTR))
    .value(PY_ENUM(DATA_DIRECTORY::TLS_TABLE))
    .value(PY_ENUM(DATA_DIRECTORY::LOAD_CONFIG_TABLE))
    .value(PY_ENUM(DATA_DIRECTORY::BOUND_IMPORT))
    .value(PY_ENUM(DATA_DIRECTORY::IAT))
    .value(PY_ENUM(DATA_DIRECTORY::DELAY_IMPORT_DESCRIPTOR))
    .value(PY_ENUM(DATA_DIRECTORY::CLR_RUNTIME_HEADER))
    .value(PY_ENUM(DATA_DIRECTORY::RESERVED));

  LIEF::enum_<DLL_CHARACTERISTICS>(m, "DLL_CHARACTERISTICS", py::arithmetic())
    .value(PY_ENUM(DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_HIGH_ENTROPY_VA))
    .value(PY_ENUM(DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_DYNAMIC_BASE))
    .value(PY_ENUM(DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_FORCE_INTEGRITY))
    .value(PY_ENUM(DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_NX_COMPAT))
    .value(PY_ENUM(DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_NO_ISOLATION))
    .value(PY_ENUM(DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_NO_SEH))
    .value(PY_ENUM(DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_NO_BIND))
    .value(PY_ENUM(DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_APPCONTAINER))
    .value(PY_ENUM(DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_WDM_DRIVER))
    .value(PY_ENUM(DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_GUARD_CF))
    .value(PY_ENUM(DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_TERMINAL_SERVER_AWARE));


  LIEF::enum_<SECTION_CHARACTERISTICS>(m, "SECTION_CHARACTERISTICS", py::arithmetic())
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_TYPE_NO_PAD))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_CNT_CODE))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_CNT_INITIALIZED_DATA))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_CNT_UNINITIALIZED_DATA))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_LNK_OTHER))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_LNK_INFO))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_LNK_REMOVE))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_LNK_COMDAT))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_GPREL))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_PURGEABLE))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_16BIT))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_LOCKED))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_PRELOAD))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_1BYTES))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_2BYTES))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_4BYTES))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_8BYTES))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_16BYTES))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_32BYTES))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_64BYTES))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_128BYTES))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_256BYTES))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_512BYTES))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_1024BYTES))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_2048BYTES))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_4096BYTES))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_8192BYTES))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_LNK_NRELOC_OVFL))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_DISCARDABLE))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_NOT_CACHED))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_NOT_PAGED))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_SHARED))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_EXECUTE))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_READ))
    .value(PY_ENUM(SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_WRITE));

  LIEF::enum_<PE_SECTION_TYPES>(m, "SECTION_TYPES")
    .value(PY_ENUM(PE_SECTION_TYPES::TEXT))
    .value(PY_ENUM(PE_SECTION_TYPES::TLS))
    .value(PY_ENUM(PE_SECTION_TYPES::IMPORT))
    .value(PY_ENUM(PE_SECTION_TYPES::DATA))
    .value(PY_ENUM(PE_SECTION_TYPES::BSS))
    .value(PY_ENUM(PE_SECTION_TYPES::RESOURCE))
    .value(PY_ENUM(PE_SECTION_TYPES::RELOCATION))
    .value(PY_ENUM(PE_SECTION_TYPES::EXPORT))
    .value(PY_ENUM(PE_SECTION_TYPES::UNKNOWN));


  LIEF::enum_<SYMBOL_BASE_TYPES>(m, "SYMBOL_BASE_TYPES")
    .value(PY_ENUM(SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_NULL))
    .value(PY_ENUM(SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_VOID))
    .value(PY_ENUM(SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_CHAR))
    .value(PY_ENUM(SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_SHORT))
    .value(PY_ENUM(SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_INT))
    .value(PY_ENUM(SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_LONG))
    .value(PY_ENUM(SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_FLOAT))
    .value(PY_ENUM(SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_DOUBLE))
    .value(PY_ENUM(SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_STRUCT))
    .value(PY_ENUM(SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_UNION))
    .value(PY_ENUM(SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_ENUM))
    .value(PY_ENUM(SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_MOE))
    .value(PY_ENUM(SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_BYTE))
    .value(PY_ENUM(SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_WORD))
    .value(PY_ENUM(SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_UINT))
    .value(PY_ENUM(SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_DWORD));


  LIEF::enum_<SYMBOL_COMPLEX_TYPES>(m, "SYMBOL_COMPLEX_TYPES")
    .value(PY_ENUM(SYMBOL_COMPLEX_TYPES::IMAGE_SYM_DTYPE_NULL))
    .value(PY_ENUM(SYMBOL_COMPLEX_TYPES::IMAGE_SYM_DTYPE_POINTER))
    .value(PY_ENUM(SYMBOL_COMPLEX_TYPES::IMAGE_SYM_DTYPE_FUNCTION))
    .value(PY_ENUM(SYMBOL_COMPLEX_TYPES::IMAGE_SYM_DTYPE_ARRAY))
    .value(PY_ENUM(SYMBOL_COMPLEX_TYPES::SCT_COMPLEX_TYPE_SHIFT));


  LIEF::enum_<SYMBOL_SECTION_NUMBER>(m, "SYMBOL_SECTION_NUMBER")
    .value(PY_ENUM(SYMBOL_SECTION_NUMBER::IMAGE_SYM_DEBUG))
    .value(PY_ENUM(SYMBOL_SECTION_NUMBER::IMAGE_SYM_ABSOLUTE))
    .value(PY_ENUM(SYMBOL_SECTION_NUMBER::IMAGE_SYM_UNDEFINED));


  LIEF::enum_<SYMBOL_STORAGE_CLASS>(m, "SYMBOL_STORAGE_CLASS")
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_END_OF_FUNCTION))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_NULL))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_AUTOMATIC))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_EXTERNAL))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_STATIC))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_REGISTER))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_EXTERNAL_DEF))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_LABEL))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_UNDEFINED_LABEL))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_MEMBER_OF_STRUCT))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_UNION_TAG))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_TYPE_DEFINITION))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_UNDEFINED_STATIC))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_ENUM_TAG))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_MEMBER_OF_ENUM))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_REGISTER_PARAM))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_BIT_FIELD))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_BLOCK))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_FUNCTION))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_END_OF_STRUCT))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_FILE))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_SECTION))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_WEAK_EXTERNAL))
    .value(PY_ENUM(SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_CLR_TOKEN));


  LIEF::enum_<RELOCATIONS_BASE_TYPES>(m, "RELOCATIONS_BASE_TYPES")
    .value("ABSOLUTE",        RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_ABSOLUTE)
    .value("HIGH",            RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_HIGH)
    .value("LOW",             RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_LOW)
    .value("HIGHLOW",         RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_HIGHLOW)
    .value("HIGHADJ",         RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_HIGHADJ)
    .value("MIPS_JMPADDR",    RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_MIPS_JMPADDR)
    .value("ARM_MOV32A",      RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_ARM_MOV32A)
    .value("ARM_MOV32",       RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_ARM_MOV32)
    .value("RISCV_HI20",      RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_RISCV_HI20)
    .value("ARM_MOV32T",      RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_ARM_MOV32T)
    .value("THUMB_MOV32",     RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_THUMB_MOV32)
    .value("RISCV_LOW12I",    RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_RISCV_LOW12I)
    .value("RISCV_LOW12S",    RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_RISCV_LOW12S)
    .value("SECTION",         RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_SECTION)
    .value("REL",             RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_REL)
    .value("MIPS_JMPADDR16",  RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_MIPS_JMPADDR16)
    .value("IA64_IMM64",      RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_IA64_IMM64)
    .value("DIR64",           RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_DIR64)
    .value("HIGH3ADJ",        RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_HIGH3ADJ);


  LIEF::enum_<DEBUG_TYPES>(m, "DEBUG_TYPES")
    .value(PY_ENUM(DEBUG_TYPES::IMAGE_DEBUG_TYPE_UNKNOWN))
    .value(PY_ENUM(DEBUG_TYPES::IMAGE_DEBUG_TYPE_COFF))
    .value(PY_ENUM(DEBUG_TYPES::IMAGE_DEBUG_TYPE_CODEVIEW))
    .value(PY_ENUM(DEBUG_TYPES::IMAGE_DEBUG_TYPE_FPO))
    .value(PY_ENUM(DEBUG_TYPES::IMAGE_DEBUG_TYPE_MISC))
    .value(PY_ENUM(DEBUG_TYPES::IMAGE_DEBUG_TYPE_EXCEPTION))
    .value(PY_ENUM(DEBUG_TYPES::IMAGE_DEBUG_TYPE_FIXUP))
    .value(PY_ENUM(DEBUG_TYPES::IMAGE_DEBUG_TYPE_OMAP_TO_SRC))
    .value(PY_ENUM(DEBUG_TYPES::IMAGE_DEBUG_TYPE_OMAP_FROM_SRC))
    .value(PY_ENUM(DEBUG_TYPES::IMAGE_DEBUG_TYPE_BORLAND))
    .value(PY_ENUM(DEBUG_TYPES::IMAGE_DEBUG_TYPE_CLSID))
    .value(PY_ENUM(DEBUG_TYPES::IMAGE_DEBUG_TYPE_VC_FEATURE))
    .value(PY_ENUM(DEBUG_TYPES::IMAGE_DEBUG_TYPE_POGO))
    .value(PY_ENUM(DEBUG_TYPES::IMAGE_DEBUG_TYPE_ILTCG))
    .value(PY_ENUM(DEBUG_TYPES::IMAGE_DEBUG_TYPE_MPX))
    .value(PY_ENUM(DEBUG_TYPES::IMAGE_DEBUG_TYPE_REPRO))
    .value(PY_ENUM(DEBUG_TYPES::IMAGE_DEBUG_TYPE_EX_DLLCHARACTERISTICS));


  LIEF::enum_<RESOURCE_TYPES>(m, "RESOURCE_TYPES")
    .value(PY_ENUM(RESOURCE_TYPES::CURSOR))
    .value(PY_ENUM(RESOURCE_TYPES::BITMAP))
    .value(PY_ENUM(RESOURCE_TYPES::ICON))
    .value(PY_ENUM(RESOURCE_TYPES::MENU))
    .value(PY_ENUM(RESOURCE_TYPES::DIALOG))
    .value(PY_ENUM(RESOURCE_TYPES::STRING))
    .value(PY_ENUM(RESOURCE_TYPES::FONTDIR))
    .value(PY_ENUM(RESOURCE_TYPES::FONT))
    .value(PY_ENUM(RESOURCE_TYPES::ACCELERATOR))
    .value(PY_ENUM(RESOURCE_TYPES::RCDATA))
    .value(PY_ENUM(RESOURCE_TYPES::MESSAGETABLE))
    .value(PY_ENUM(RESOURCE_TYPES::GROUP_CURSOR))
    .value(PY_ENUM(RESOURCE_TYPES::GROUP_ICON))
    .value(PY_ENUM(RESOURCE_TYPES::VERSION))
    .value(PY_ENUM(RESOURCE_TYPES::DLGINCLUDE))
    .value(PY_ENUM(RESOURCE_TYPES::PLUGPLAY))
    .value(PY_ENUM(RESOURCE_TYPES::VXD))
    .value(PY_ENUM(RESOURCE_TYPES::ANICURSOR))
    .value(PY_ENUM(RESOURCE_TYPES::ANIICON))
    .value(PY_ENUM(RESOURCE_TYPES::HTML))
    .value(PY_ENUM(RESOURCE_TYPES::MANIFEST));


  LIEF::enum_<RESOURCE_LANGS>(m, "RESOURCE_LANGS")
    .value(PY_ENUM(RESOURCE_LANGS::LANG_NEUTRAL))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_INVARIANT))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_AFRIKAANS))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_ALBANIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_ARABIC))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_ARMENIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_ASSAMESE))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_AZERI))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_BASQUE))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_BELARUSIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_BANGLA))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_BULGARIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_CATALAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_CHINESE))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_CROATIAN))
    .value("BOSNIAN", RESOURCE_LANGS::LANG_BOSNIAN)
    .value(PY_ENUM(RESOURCE_LANGS::LANG_CZECH))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_DANISH))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_DIVEHI))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_DUTCH))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_ENGLISH))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_ESTONIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_FAEROESE))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_FARSI))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_FINNISH))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_FRENCH))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_GALICIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_GEORGIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_GERMAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_GREEK))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_GUJARATI))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_HEBREW))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_HINDI))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_HUNGARIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_ICELANDIC))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_INDONESIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_ITALIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_JAPANESE))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_KANNADA))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_KASHMIRI))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_KAZAK))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_KONKANI))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_KOREAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_KYRGYZ))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_LATVIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_LITHUANIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_MACEDONIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_MALAY))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_MALAYALAM))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_MANIPURI))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_MARATHI))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_MONGOLIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_NEPALI))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_NORWEGIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_ORIYA))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_POLISH))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_PORTUGUESE))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_PUNJABI))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_ROMANIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_RUSSIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_SANSKRIT))
    .value("SERBIAN", RESOURCE_LANGS::LANG_SERBIAN)
    .value(PY_ENUM(RESOURCE_LANGS::LANG_SINDHI))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_SLOVAK))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_SLOVENIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_SPANISH))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_SWAHILI))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_SWEDISH))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_SYRIAC))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_TAMIL))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_TATAR))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_TELUGU))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_THAI))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_TURKISH))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_UKRAINIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_URDU))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_UZBEK))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_VIETNAMESE))
    .value("GAELIC", RESOURCE_LANGS::LANG_GAELIC)
    .value(PY_ENUM(RESOURCE_LANGS::LANG_MALTESE))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_MAORI))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_RHAETO_ROMANCE))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_SAMI))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_SORBIAN))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_SUTU))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_TSONGA))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_TSWANA))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_VENDA))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_XHOSA))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_ZULU))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_ESPERANTO))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_WALON))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_CORNISH))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_WELSH))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_BRETON))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_INUKTITUT))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_IRISH))
    .value("LOWER_SORBIAN", RESOURCE_LANGS::LANG_LOWER_SORBIAN)
    .value(PY_ENUM(RESOURCE_LANGS::LANG_PULAR))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_QUECHUA))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_TAMAZIGHT))
    .value(PY_ENUM(RESOURCE_LANGS::LANG_TIGRINYA))
    .value("VALENCIAN", RESOURCE_LANGS::LANG_VALENCIAN);

  LIEF::enum_<RESOURCE_SUBLANGS>(m, "RESOURCE_SUBLANGS")
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_AFRIKAANS_SOUTH_AFRICA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ALBANIAN_ALBANIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ALSATIAN_FRANCE))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_AMHARIC_ETHIOPIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ARABIC_ALGERIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ARABIC_BAHRAIN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ARABIC_EGYPT))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ARABIC_IRAQ))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ARABIC_JORDAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ARABIC_KUWAIT))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ARABIC_LEBANON))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ARABIC_LIBYA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ARABIC_MOROCCO))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ARABIC_OMAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ARABIC_QATAR))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ARABIC_SAUDI_ARABIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ARABIC_SYRIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ARABIC_TUNISIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ARABIC_UAE))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ARABIC_YEMEN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ARMENIAN_ARMENIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ASSAMESE_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_AZERI_CYRILLIC))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_AZERI_LATIN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_BASHKIR_RUSSIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_BASQUE_BASQUE))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_BELARUSIAN_BELARUS))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_BANGLA_BANGLADESH))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_BANGLA_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_BOSNIAN_BOSNIA_HERZEGOVINA_CYRILLIC))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_BOSNIAN_BOSNIA_HERZEGOVINA_LATIN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_BRETON_FRANCE))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_BULGARIAN_BULGARIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_CATALAN_CATALAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_CHINESE_HONGKONG))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_CHINESE_MACAU))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_CHINESE_SIMPLIFIED))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_CHINESE_SINGAPORE))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_CHINESE_TRADITIONAL))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_CORSICAN_FRANCE))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_CROATIAN_BOSNIA_HERZEGOVINA_LATIN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_CROATIAN_CROATIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_CUSTOM_DEFAULT))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_CUSTOM_UNSPECIFIED))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_CZECH_CZECH_REPUBLIC))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_DANISH_DENMARK))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_DARI_AFGHANISTAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_DEFAULT))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_DIVEHI_MALDIVES))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_DUTCH_BELGIAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_DUTCH))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ENGLISH_AUS))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ENGLISH_BELIZE))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ENGLISH_CAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ENGLISH_CARIBBEAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ENGLISH_EIRE))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ENGLISH_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ENGLISH_JAMAICA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ENGLISH_MALAYSIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ENGLISH_NZ))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ENGLISH_PHILIPPINES))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ENGLISH_SINGAPORE))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ENGLISH_SOUTH_AFRICA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ENGLISH_TRINIDAD))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ENGLISH_UK))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ENGLISH_US))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ENGLISH_ZIMBABWE))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ENGLISH_IRELAND))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ESTONIAN_ESTONIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_FAEROESE_FAROE_ISLANDS))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_FILIPINO_PHILIPPINES))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_FINNISH_FINLAND))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_FRENCH_BELGIAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_FRENCH_CANADIAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_FRENCH_LUXEMBOURG))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_FRENCH_MONACO))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_FRENCH_SWISS))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_FRENCH))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_FRISIAN_NETHERLANDS))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_GALICIAN_GALICIAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_GEORGIAN_GEORGIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_GERMAN_AUSTRIAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_GERMAN_LIECHTENSTEIN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_GERMAN_LUXEMBOURG))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_GERMAN_SWISS))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_GERMAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_GREEK_GREECE))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_GREENLANDIC_GREENLAND))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_GUJARATI_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_HAUSA_NIGERIA_LATIN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_HEBREW_ISRAEL))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_HINDI_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_HUNGARIAN_HUNGARY))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ICELANDIC_ICELAND))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_IGBO_NIGERIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_INDONESIAN_INDONESIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_INUKTITUT_CANADA_LATIN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_INUKTITUT_CANADA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_IRISH_IRELAND))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ITALIAN_SWISS))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ITALIAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_JAPANESE_JAPAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_KANNADA_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_KASHMIRI_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_KASHMIRI_SASIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_KAZAK_KAZAKHSTAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_KHMER_CAMBODIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_KICHE_GUATEMALA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_KINYARWANDA_RWANDA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_KONKANI_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_KOREAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_KYRGYZ_KYRGYZSTAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_LAO_LAO))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_LATVIAN_LATVIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_LITHUANIAN_CLASSIC))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_LITHUANIAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_LOWER_SORBIAN_GERMANY))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_LUXEMBOURGISH_LUXEMBOURG))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_MACEDONIAN_MACEDONIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_MALAY_BRUNEI_DARUSSALAM))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_MALAY_MALAYSIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_MALAYALAM_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_MALTESE_MALTA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_MAORI_NEW_ZEALAND))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_MAPUDUNGUN_CHILE))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_MARATHI_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_MOHAWK_MOHAWK))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_MONGOLIAN_CYRILLIC_MONGOLIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_MONGOLIAN_PRC))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_NEPALI_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_NEPALI_NEPAL))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_NEUTRAL))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_NORWEGIAN_BOKMAL))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_NORWEGIAN_NYNORSK))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_OCCITAN_FRANCE))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ORIYA_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_PASHTO_AFGHANISTAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_PERSIAN_IRAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_POLISH_POLAND))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_PORTUGUESE_BRAZILIAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_PORTUGUESE))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_PUNJABI_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_QUECHUA_BOLIVIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_QUECHUA_ECUADOR))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_QUECHUA_PERU))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ROMANIAN_ROMANIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ROMANSH_SWITZERLAND))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_RUSSIAN_RUSSIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SAMI_INARI_FINLAND))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SAMI_LULE_NORWAY))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SAMI_LULE_SWEDEN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SAMI_NORTHERN_FINLAND))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SAMI_NORTHERN_NORWAY))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SAMI_NORTHERN_SWEDEN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SAMI_SKOLT_FINLAND))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SAMI_SOUTHERN_NORWAY))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SAMI_SOUTHERN_SWEDEN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SANSKRIT_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SERBIAN_BOSNIA_HERZEGOVINA_CYRILLIC))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SERBIAN_BOSNIA_HERZEGOVINA_LATIN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SERBIAN_CROATIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SERBIAN_CYRILLIC))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SERBIAN_LATIN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SINDHI_AFGHANISTAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SINDHI_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SINDHI_PAKISTAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SINHALESE_SRI_LANKA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SLOVAK_SLOVAKIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SLOVENIAN_SLOVENIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SOTHO_NORTHERN_SOUTH_AFRICA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_ARGENTINA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_BOLIVIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_CHILE))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_COLOMBIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_COSTA_RICA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_DOMINICAN_REPUBLIC))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_ECUADOR))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_EL_SALVADOR))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_GUATEMALA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_HONDURAS))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_MEXICAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_MODERN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_NICARAGUA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_PANAMA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_PARAGUAY))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_PERU))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_PUERTO_RICO))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_URUGUAY))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_US))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH_VENEZUELA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SPANISH))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SWAHILI_KENYA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SWEDISH_FINLAND))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SWEDISH))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SYRIAC_SYRIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_SYS_DEFAULT))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_TAJIK_TAJIKISTAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_TAMAZIGHT_ALGERIA_LATIN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_TAMIL_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_TATAR_RUSSIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_TELUGU_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_THAI_THAILAND))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_TIBETAN_PRC))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_TIGRIGNA_ERITREA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_TSWANA_SOUTH_AFRICA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_TURKISH_TURKEY))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_TURKMEN_TURKMENISTAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_UI_CUSTOM_DEFAULT))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_UIGHUR_PRC))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_UKRAINIAN_UKRAINE))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_UPPER_SORBIAN_GERMANY))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_URDU_INDIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_URDU_PAKISTAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_UZBEK_CYRILLIC))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_UZBEK_LATIN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_VIETNAMESE_VIETNAM))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_WELSH_UNITED_KINGDOM))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_WOLOF_SENEGAL))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_XHOSA_SOUTH_AFRICA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_YAKUT_RUSSIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_YI_PRC))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_YORUBA_NIGERIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_ZULU_SOUTH_AFRICA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_PULAR_SENEGAL))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_PUNJABI_PAKISTAN))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_TSWANA_BOTSWANA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_TAMIL_SRI_LANKA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_TIGRINYA_ETHIOPIA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_TIGRINYA_ERITREA))
    .value(PY_ENUM(RESOURCE_SUBLANGS::SUBLANG_VALENCIAN_VALENCIA));

  LIEF::enum_<EXTENDED_WINDOW_STYLES>(m, "EXTENDED_WINDOW_STYLES")
    .value(PY_ENUM(EXTENDED_WINDOW_STYLES::WS_EX_DLGMODALFRAME))
    .value(PY_ENUM(EXTENDED_WINDOW_STYLES::WS_EX_NOPARENTNOTIFY))
    .value(PY_ENUM(EXTENDED_WINDOW_STYLES::WS_EX_TOPMOST))
    .value(PY_ENUM(EXTENDED_WINDOW_STYLES::WS_EX_ACCEPTFILES))
    .value(PY_ENUM(EXTENDED_WINDOW_STYLES::WS_EX_TRANSPARENT))
    .value(PY_ENUM(EXTENDED_WINDOW_STYLES::WS_EX_MDICHILD))
    .value(PY_ENUM(EXTENDED_WINDOW_STYLES::WS_EX_TOOLWINDOW))
    .value(PY_ENUM(EXTENDED_WINDOW_STYLES::WS_EX_WINDOWEDGE))
    .value(PY_ENUM(EXTENDED_WINDOW_STYLES::WS_EX_CLIENTEDGE))
    .value(PY_ENUM(EXTENDED_WINDOW_STYLES::WS_EX_CONTEXTHELP))
    .value(PY_ENUM(EXTENDED_WINDOW_STYLES::WS_EX_RIGHT))
    .value(PY_ENUM(EXTENDED_WINDOW_STYLES::WS_EX_LEFT))
    .value(PY_ENUM(EXTENDED_WINDOW_STYLES::WS_EX_RTLREADING))
    .value("LTRREADING", EXTENDED_WINDOW_STYLES::WS_EX_LTRREADING)
    .value(PY_ENUM(EXTENDED_WINDOW_STYLES::WS_EX_LEFTSCROLLBAR))
    .value("RIGHTSCROLLBAR", EXTENDED_WINDOW_STYLES::WS_EX_RIGHTSCROLLBAR)
    .value(PY_ENUM(EXTENDED_WINDOW_STYLES::WS_EX_CONTROLPARENT))
    .value(PY_ENUM(EXTENDED_WINDOW_STYLES::WS_EX_STATICEDGE))
    .value(PY_ENUM(EXTENDED_WINDOW_STYLES::WS_EX_APPWINDOW));



  LIEF::enum_<WINDOW_STYLES>(m, "WINDOW_STYLES")
    .value(PY_ENUM(WINDOW_STYLES::WS_OVERLAPPED))
    .value(PY_ENUM(WINDOW_STYLES::WS_POPUP))
    .value(PY_ENUM(WINDOW_STYLES::WS_CHILD))
    .value(PY_ENUM(WINDOW_STYLES::WS_MINIMIZE))
    .value(PY_ENUM(WINDOW_STYLES::WS_VISIBLE))
    .value(PY_ENUM(WINDOW_STYLES::WS_DISABLED))
    .value(PY_ENUM(WINDOW_STYLES::WS_CLIPSIBLINGS))
    .value(PY_ENUM(WINDOW_STYLES::WS_CLIPCHILDREN))
    .value(PY_ENUM(WINDOW_STYLES::WS_MAXIMIZE))
    .value(PY_ENUM(WINDOW_STYLES::WS_CAPTION))
    .value(PY_ENUM(WINDOW_STYLES::WS_BORDER))
    .value(PY_ENUM(WINDOW_STYLES::WS_DLGFRAME))
    .value(PY_ENUM(WINDOW_STYLES::WS_VSCROLL))
    .value(PY_ENUM(WINDOW_STYLES::WS_HSCROLL))
    .value(PY_ENUM(WINDOW_STYLES::WS_SYSMENU))
    .value(PY_ENUM(WINDOW_STYLES::WS_THICKFRAME))
    .value("GROUP", WINDOW_STYLES::WS_GROUP)
    .value("TABSTOP", WINDOW_STYLES::WS_TABSTOP)
    .value(PY_ENUM(WINDOW_STYLES::WS_MINIMIZEBOX))
    .value(PY_ENUM(WINDOW_STYLES::WS_MAXIMIZEBOX));


  LIEF::enum_<DIALOG_BOX_STYLES>(m, "DIALOG_BOX_STYLES")
    .value(PY_ENUM(DIALOG_BOX_STYLES::DS_ABSALIGN))
    .value(PY_ENUM(DIALOG_BOX_STYLES::DS_SYSMODAL))
    .value(PY_ENUM(DIALOG_BOX_STYLES::DS_LOCALEDIT))
    .value(PY_ENUM(DIALOG_BOX_STYLES::DS_SETFONT))
    .value(PY_ENUM(DIALOG_BOX_STYLES::DS_MODALFRAME))
    .value(PY_ENUM(DIALOG_BOX_STYLES::DS_NOIDLEMSG))
    .value(PY_ENUM(DIALOG_BOX_STYLES::DS_SETFOREGROUND))
    .value(PY_ENUM(DIALOG_BOX_STYLES::DS_3DLOOK))
    .value(PY_ENUM(DIALOG_BOX_STYLES::DS_FIXEDSYS))
    .value(PY_ENUM(DIALOG_BOX_STYLES::DS_NOFAILCREATE))
    .value(PY_ENUM(DIALOG_BOX_STYLES::DS_CONTROL))
    .value(PY_ENUM(DIALOG_BOX_STYLES::DS_CENTER))
    .value(PY_ENUM(DIALOG_BOX_STYLES::DS_CENTERMOUSE))
    .value(PY_ENUM(DIALOG_BOX_STYLES::DS_CONTEXTHELP))
    .value(PY_ENUM(DIALOG_BOX_STYLES::DS_SHELLFONT));


  LIEF::enum_<FIXED_VERSION_OS>(m, "FIXED_VERSION_OS")
    .value(PY_ENUM(FIXED_VERSION_OS::VOS_UNKNOWN))
    .value(PY_ENUM(FIXED_VERSION_OS::VOS_DOS))
    .value(PY_ENUM(FIXED_VERSION_OS::VOS_NT))
    .value(PY_ENUM(FIXED_VERSION_OS::VOS__WINDOWS16))
    .value(PY_ENUM(FIXED_VERSION_OS::VOS__WINDOWS32))
    .value(PY_ENUM(FIXED_VERSION_OS::VOS_OS216))
    .value(PY_ENUM(FIXED_VERSION_OS::VOS_OS232))
    .value(PY_ENUM(FIXED_VERSION_OS::VOS__PM16))
    .value(PY_ENUM(FIXED_VERSION_OS::VOS__PM32))
    .value(PY_ENUM(FIXED_VERSION_OS::VOS_DOS_WINDOWS16))
    .value(PY_ENUM(FIXED_VERSION_OS::VOS_DOS_WINDOWS32))
    .value(PY_ENUM(FIXED_VERSION_OS::VOS_NT_WINDOWS32))
    .value(PY_ENUM(FIXED_VERSION_OS::VOS_OS216_PM16))
    .value(PY_ENUM(FIXED_VERSION_OS::VOS_OS232_PM32));

  LIEF::enum_<FIXED_VERSION_FILE_FLAGS>(m, "FIXED_VERSION_FILE_FLAGS")
    .value(PY_ENUM(FIXED_VERSION_FILE_FLAGS::VS_FF_DEBUG))
    .value(PY_ENUM(FIXED_VERSION_FILE_FLAGS::VS_FF_INFOINFERRED))
    .value(PY_ENUM(FIXED_VERSION_FILE_FLAGS::VS_FF_PATCHED))
    .value(PY_ENUM(FIXED_VERSION_FILE_FLAGS::VS_FF_PRERELEASE))
    .value(PY_ENUM(FIXED_VERSION_FILE_FLAGS::VS_FF_PRIVATEBUILD))
    .value(PY_ENUM(FIXED_VERSION_FILE_FLAGS::VS_FF_SPECIALBUILD));


  LIEF::enum_<FIXED_VERSION_FILE_TYPES>(m, "FIXED_VERSION_FILE_TYPES")
    .value(PY_ENUM(FIXED_VERSION_FILE_TYPES::VFT_APP))
    .value(PY_ENUM(FIXED_VERSION_FILE_TYPES::VFT_DLL))
    .value(PY_ENUM(FIXED_VERSION_FILE_TYPES::VFT_DRV))
    .value(PY_ENUM(FIXED_VERSION_FILE_TYPES::VFT_FONT))
    .value(PY_ENUM(FIXED_VERSION_FILE_TYPES::VFT_STATIC_LIB))
    .value(PY_ENUM(FIXED_VERSION_FILE_TYPES::VFT_UNKNOWN))
    .value(PY_ENUM(FIXED_VERSION_FILE_TYPES::VFT_VXD));


  LIEF::enum_<FIXED_VERSION_FILE_SUB_TYPES>(m, "FIXED_VERSION_FILE_SUB_TYPES")
    .value(PY_ENUM(FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_COMM))
    .value(PY_ENUM(FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_DISPLAY))
    .value(PY_ENUM(FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_INSTALLABLE))
    .value(PY_ENUM(FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_KEYBOARD))
    .value(PY_ENUM(FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_LANGUAGE))
    .value(PY_ENUM(FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_MOUSE))
    .value(PY_ENUM(FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_NETWORK))
    .value(PY_ENUM(FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_PRINTER))
    .value(PY_ENUM(FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_SOUND))
    .value(PY_ENUM(FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_SYSTEM))
    .value(PY_ENUM(FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_VERSIONED_PRINTER))
    .value("FONT_RASTER", FIXED_VERSION_FILE_SUB_TYPES::VFT2_FONT_RASTER)
    .value("FONT_TRUETYPE", FIXED_VERSION_FILE_SUB_TYPES::VFT2_FONT_TRUETYPE)
    .value("FONT_VECTOR", FIXED_VERSION_FILE_SUB_TYPES::VFT2_FONT_VECTOR)
    .value(PY_ENUM(FIXED_VERSION_FILE_SUB_TYPES::VFT2_UNKNOWN));

  LIEF::enum_<CODE_PAGES>(m, "CODE_PAGES")
    .value(PY_ENUM(CODE_PAGES::CP_IBM037))
    .value(PY_ENUM(CODE_PAGES::CP_IBM437))
    .value(PY_ENUM(CODE_PAGES::CP_IBM500))
    .value(PY_ENUM(CODE_PAGES::CP_ASMO_708))
    .value(PY_ENUM(CODE_PAGES::CP_DOS_720))
    .value(PY_ENUM(CODE_PAGES::CP_IBM737))
    .value(PY_ENUM(CODE_PAGES::CP_IBM775))
    .value(PY_ENUM(CODE_PAGES::CP_IBM850))
    .value(PY_ENUM(CODE_PAGES::CP_IBM852))
    .value(PY_ENUM(CODE_PAGES::CP_IBM855))
    .value(PY_ENUM(CODE_PAGES::CP_IBM857))
    .value(PY_ENUM(CODE_PAGES::CP_IBM00858))
    .value(PY_ENUM(CODE_PAGES::CP_IBM860))
    .value(PY_ENUM(CODE_PAGES::CP_IBM861))
    .value(PY_ENUM(CODE_PAGES::CP_DOS_862))
    .value(PY_ENUM(CODE_PAGES::CP_IBM863))
    .value(PY_ENUM(CODE_PAGES::CP_IBM864))
    .value(PY_ENUM(CODE_PAGES::CP_IBM865))
    .value(PY_ENUM(CODE_PAGES::CP_CP866))
    .value(PY_ENUM(CODE_PAGES::CP_IBM869))
    .value(PY_ENUM(CODE_PAGES::CP_IBM870))
    .value(PY_ENUM(CODE_PAGES::CP_WINDOWS_874))
    .value(PY_ENUM(CODE_PAGES::CP_CP875))
    .value(PY_ENUM(CODE_PAGES::CP_SHIFT_JIS))
    .value(PY_ENUM(CODE_PAGES::CP_GB2312))
    .value(PY_ENUM(CODE_PAGES::CP_KS_C_5601_1987))
    .value(PY_ENUM(CODE_PAGES::CP_BIG5))
    .value(PY_ENUM(CODE_PAGES::CP_IBM1026))
    .value(PY_ENUM(CODE_PAGES::CP_IBM01047))
    .value(PY_ENUM(CODE_PAGES::CP_IBM01140))
    .value(PY_ENUM(CODE_PAGES::CP_IBM01141))
    .value(PY_ENUM(CODE_PAGES::CP_IBM01142))
    .value(PY_ENUM(CODE_PAGES::CP_IBM01143))
    .value(PY_ENUM(CODE_PAGES::CP_IBM01144))
    .value(PY_ENUM(CODE_PAGES::CP_IBM01145))
    .value(PY_ENUM(CODE_PAGES::CP_IBM01146))
    .value(PY_ENUM(CODE_PAGES::CP_IBM01147))
    .value(PY_ENUM(CODE_PAGES::CP_IBM01148))
    .value(PY_ENUM(CODE_PAGES::CP_IBM01149))
    .value(PY_ENUM(CODE_PAGES::CP_UTF_16))
    .value(PY_ENUM(CODE_PAGES::CP_UNICODEFFFE))
    .value(PY_ENUM(CODE_PAGES::CP_WINDOWS_1250))
    .value(PY_ENUM(CODE_PAGES::CP_WINDOWS_1251))
    .value(PY_ENUM(CODE_PAGES::CP_WINDOWS_1252))
    .value(PY_ENUM(CODE_PAGES::CP_WINDOWS_1253))
    .value(PY_ENUM(CODE_PAGES::CP_WINDOWS_1254))
    .value(PY_ENUM(CODE_PAGES::CP_WINDOWS_1255))
    .value(PY_ENUM(CODE_PAGES::CP_WINDOWS_1256))
    .value(PY_ENUM(CODE_PAGES::CP_WINDOWS_1257))
    .value(PY_ENUM(CODE_PAGES::CP_WINDOWS_1258))
    .value(PY_ENUM(CODE_PAGES::CP_JOHAB))
    .value(PY_ENUM(CODE_PAGES::CP_MACINTOSH))
    .value(PY_ENUM(CODE_PAGES::CP_X_MAC_JAPANESE))
    .value(PY_ENUM(CODE_PAGES::CP_X_MAC_CHINESETRAD))
    .value(PY_ENUM(CODE_PAGES::CP_X_MAC_KOREAN))
    .value(PY_ENUM(CODE_PAGES::CP_X_MAC_ARABIC))
    .value(PY_ENUM(CODE_PAGES::CP_X_MAC_HEBREW))
    .value(PY_ENUM(CODE_PAGES::CP_X_MAC_GREEK))
    .value(PY_ENUM(CODE_PAGES::CP_X_MAC_CYRILLIC))
    .value(PY_ENUM(CODE_PAGES::CP_X_MAC_CHINESESIMP))
    .value(PY_ENUM(CODE_PAGES::CP_X_MAC_ROMANIAN))
    .value(PY_ENUM(CODE_PAGES::CP_X_MAC_UKRAINIAN))
    .value(PY_ENUM(CODE_PAGES::CP_X_MAC_THAI))
    .value(PY_ENUM(CODE_PAGES::CP_X_MAC_CE))
    .value(PY_ENUM(CODE_PAGES::CP_X_MAC_ICELANDIC))
    .value(PY_ENUM(CODE_PAGES::CP_X_MAC_TURKISH))
    .value(PY_ENUM(CODE_PAGES::CP_X_MAC_CROATIAN))
    .value(PY_ENUM(CODE_PAGES::CP_UTF_32))
    .value(PY_ENUM(CODE_PAGES::CP_UTF_32BE))
    .value(PY_ENUM(CODE_PAGES::CP_X_CHINESE_CNS))
    .value(PY_ENUM(CODE_PAGES::CP_X_CP20001))
    .value(PY_ENUM(CODE_PAGES::CP_X_CHINESE_ETEN))
    .value(PY_ENUM(CODE_PAGES::CP_X_CP20003))
    .value(PY_ENUM(CODE_PAGES::CP_X_CP20004))
    .value(PY_ENUM(CODE_PAGES::CP_X_CP20005))
    .value(PY_ENUM(CODE_PAGES::CP_X_IA5))
    .value(PY_ENUM(CODE_PAGES::CP_X_IA5_GERMAN))
    .value(PY_ENUM(CODE_PAGES::CP_X_IA5_SWEDISH))
    .value(PY_ENUM(CODE_PAGES::CP_X_IA5_NORWEGIAN))
    .value(PY_ENUM(CODE_PAGES::CP_US_ASCII))
    .value(PY_ENUM(CODE_PAGES::CP_X_CP20261))
    .value(PY_ENUM(CODE_PAGES::CP_X_CP20269))
    .value(PY_ENUM(CODE_PAGES::CP_IBM273))
    .value(PY_ENUM(CODE_PAGES::CP_IBM277))
    .value(PY_ENUM(CODE_PAGES::CP_IBM278))
    .value(PY_ENUM(CODE_PAGES::CP_IBM280))
    .value(PY_ENUM(CODE_PAGES::CP_IBM284))
    .value(PY_ENUM(CODE_PAGES::CP_IBM285))
    .value(PY_ENUM(CODE_PAGES::CP_IBM290))
    .value(PY_ENUM(CODE_PAGES::CP_IBM297))
    .value(PY_ENUM(CODE_PAGES::CP_IBM420))
    .value(PY_ENUM(CODE_PAGES::CP_IBM423))
    .value(PY_ENUM(CODE_PAGES::CP_IBM424))
    .value(PY_ENUM(CODE_PAGES::CP_X_EBCDIC_KOREANEXTENDED))
    .value(PY_ENUM(CODE_PAGES::CP_IBM_THAI))
    .value(PY_ENUM(CODE_PAGES::CP_KOI8_R))
    .value(PY_ENUM(CODE_PAGES::CP_IBM871))
    .value(PY_ENUM(CODE_PAGES::CP_IBM880))
    .value(PY_ENUM(CODE_PAGES::CP_IBM905))
    .value(PY_ENUM(CODE_PAGES::CP_IBM00924))
    .value(PY_ENUM(CODE_PAGES::CP_EUC_JP_JIS))
    .value(PY_ENUM(CODE_PAGES::CP_X_CP20936))
    .value(PY_ENUM(CODE_PAGES::CP_X_CP20949))
    .value(PY_ENUM(CODE_PAGES::CP_CP1025))
    .value(PY_ENUM(CODE_PAGES::CP_KOI8_U))
    .value(PY_ENUM(CODE_PAGES::CP_ISO_8859_1))
    .value(PY_ENUM(CODE_PAGES::CP_ISO_8859_2))
    .value(PY_ENUM(CODE_PAGES::CP_ISO_8859_3))
    .value(PY_ENUM(CODE_PAGES::CP_ISO_8859_4))
    .value(PY_ENUM(CODE_PAGES::CP_ISO_8859_5))
    .value(PY_ENUM(CODE_PAGES::CP_ISO_8859_6))
    .value(PY_ENUM(CODE_PAGES::CP_ISO_8859_7))
    .value(PY_ENUM(CODE_PAGES::CP_ISO_8859_8))
    .value(PY_ENUM(CODE_PAGES::CP_ISO_8859_9))
    .value(PY_ENUM(CODE_PAGES::CP_ISO_8859_13))
    .value(PY_ENUM(CODE_PAGES::CP_ISO_8859_15))
    .value(PY_ENUM(CODE_PAGES::CP_X_EUROPA))
    .value(PY_ENUM(CODE_PAGES::CP_ISO_8859_8_I))
    .value(PY_ENUM(CODE_PAGES::CP_ISO_2022_JP))
    .value(PY_ENUM(CODE_PAGES::CP_CSISO2022JP))
    .value(PY_ENUM(CODE_PAGES::CP_ISO_2022_JP_JIS))
    .value(PY_ENUM(CODE_PAGES::CP_ISO_2022_KR))
    .value(PY_ENUM(CODE_PAGES::CP_X_CP50227))
    .value(PY_ENUM(CODE_PAGES::CP_EUC_JP))
    .value(PY_ENUM(CODE_PAGES::CP_EUC_CN))
    .value(PY_ENUM(CODE_PAGES::CP_EUC_KR))
    .value(PY_ENUM(CODE_PAGES::CP_HZ_GB_2312))
    .value(PY_ENUM(CODE_PAGES::CP_GB18030))
    .value(PY_ENUM(CODE_PAGES::CP_X_ISCII_DE))
    .value(PY_ENUM(CODE_PAGES::CP_X_ISCII_BE))
    .value(PY_ENUM(CODE_PAGES::CP_X_ISCII_TA))
    .value(PY_ENUM(CODE_PAGES::CP_X_ISCII_TE))
    .value(PY_ENUM(CODE_PAGES::CP_X_ISCII_AS))
    .value(PY_ENUM(CODE_PAGES::CP_X_ISCII_OR))
    .value(PY_ENUM(CODE_PAGES::CP_X_ISCII_KA))
    .value(PY_ENUM(CODE_PAGES::CP_X_ISCII_MA))
    .value(PY_ENUM(CODE_PAGES::CP_X_ISCII_GU))
    .value(PY_ENUM(CODE_PAGES::CP_X_ISCII_PA))
    .value(PY_ENUM(CODE_PAGES::CP_UTF_7))
    .value(PY_ENUM(CODE_PAGES::CP_UTF_8));

  LIEF::enum_<WIN_VERSION>(m, "WIN_VERSION")
    .value(PY_ENUM(WIN_VERSION::WIN_UNKNOWN))
    .value(PY_ENUM(WIN_VERSION::WIN_SEH))
    .value(PY_ENUM(WIN_VERSION::WIN8_1))
    .value(PY_ENUM(WIN_VERSION::WIN10_0_9879))
    .value(PY_ENUM(WIN_VERSION::WIN10_0_14286))
    .value(PY_ENUM(WIN_VERSION::WIN10_0_14383))
    .value(PY_ENUM(WIN_VERSION::WIN10_0_14901))
    .value(PY_ENUM(WIN_VERSION::WIN10_0_15002))
    .value(PY_ENUM(WIN_VERSION::WIN10_0_16237))
    .value(PY_ENUM(WIN_VERSION::WIN10_0_18362))
    .value(PY_ENUM(WIN_VERSION::WIN10_0_19534))
    .value(PY_ENUM(WIN_VERSION::WIN10_0_MSVC_2019))
    .value(PY_ENUM(WIN_VERSION::WIN10_0_MSVC_2019_16));

  LIEF::enum_<GUARD_CF_FLAGS>(m, "GUARD_CF_FLAGS", py::arithmetic())
    .value(PY_ENUM(GUARD_CF_FLAGS::GCF_NONE))
    .value(PY_ENUM(GUARD_CF_FLAGS::GCF_INSTRUMENTED))
    .value(PY_ENUM(GUARD_CF_FLAGS::GCF_W_INSTRUMENTED))
    .value(PY_ENUM(GUARD_CF_FLAGS::GCF_FUNCTION_TABLE_PRESENT))
    .value(PY_ENUM(GUARD_CF_FLAGS::GCF_EXPORT_SUPPRESSION_INFO_PRESENT))
    .value(PY_ENUM(GUARD_CF_FLAGS::GCF_ENABLE_EXPORT_SUPPRESSION))
    .value(PY_ENUM(GUARD_CF_FLAGS::GCF_LONGJUMP_TABLE_PRESENT))
    .value(PY_ENUM(GUARD_CF_FLAGS::GRF_INSTRUMENTED))
    .value(PY_ENUM(GUARD_CF_FLAGS::GRF_ENABLE))
    .value(PY_ENUM(GUARD_CF_FLAGS::GRF_STRICT));


  LIEF::enum_<CODE_VIEW_SIGNATURES>(m, "CODE_VIEW_SIGNATURES")
    .value(PY_ENUM(CODE_VIEW_SIGNATURES::CVS_UNKNOWN))
    .value(PY_ENUM(CODE_VIEW_SIGNATURES::CVS_PDB_70))
    .value(PY_ENUM(CODE_VIEW_SIGNATURES::CVS_PDB_20))
    .value(PY_ENUM(CODE_VIEW_SIGNATURES::CVS_CV_50))
    .value(PY_ENUM(CODE_VIEW_SIGNATURES::CVS_CV_41));

  LIEF::enum_<POGO_SIGNATURES>(m, "POGO_SIGNATURES")
    .value(PY_ENUM(POGO_SIGNATURES::POGO_UNKNOWN))
    .value(PY_ENUM(POGO_SIGNATURES::POGO_LCTG))
    .value(PY_ENUM(POGO_SIGNATURES::POGO_PGI));

  LIEF::enum_<ACCELERATOR_FLAGS>(m, "ACCELERATOR_FLAGS", py::arithmetic())
    .value(PY_ENUM(ACCELERATOR_FLAGS::FVIRTKEY))
    .value(PY_ENUM(ACCELERATOR_FLAGS::FNOINVERT))
    .value(PY_ENUM(ACCELERATOR_FLAGS::FSHIFT))
    .value(PY_ENUM(ACCELERATOR_FLAGS::FCONTROL))
    .value(PY_ENUM(ACCELERATOR_FLAGS::FALT))
    .value(PY_ENUM(ACCELERATOR_FLAGS::END));

  LIEF::enum_<ACCELERATOR_VK_CODES>(m, "ACCELERATOR_VK_CODES")
    .value("VK_LBUTTON"             , ACCELERATOR_VK_CODES::VK_LBUTTON)
    .value("VK_RBUTTON"             , ACCELERATOR_VK_CODES::VK_RBUTTON)
    .value("VK_CANCEL"              , ACCELERATOR_VK_CODES::VK_CANCEL)
    .value("VK_MBUTTON"             , ACCELERATOR_VK_CODES::VK_MBUTTON)
    .value("VK_XBUTTON1"            , ACCELERATOR_VK_CODES::VK_XBUTTON1)
    .value("VK_XBUTTON2"            , ACCELERATOR_VK_CODES::VK_XBUTTON2)
    .value("VK_BACK"                , ACCELERATOR_VK_CODES::VK_BACK)
    .value("VK_TAB"                 , ACCELERATOR_VK_CODES::VK_TAB)
    .value("VK_CLEAR"               , ACCELERATOR_VK_CODES::VK_CLEAR)
    .value("VK_RETURN"              , ACCELERATOR_VK_CODES::VK_RETURN)
    .value("VK_SHIFT"               , ACCELERATOR_VK_CODES::VK_SHIFT)
    .value("VK_CONTROL"             , ACCELERATOR_VK_CODES::VK_CONTROL)
    .value("VK_MENU"                , ACCELERATOR_VK_CODES::VK_MENU)
    .value("VK_PAUSE"               , ACCELERATOR_VK_CODES::VK_PAUSE)
    .value("VK_CAPITAL"             , ACCELERATOR_VK_CODES::VK_CAPITAL)
    .value("VK_KANA"                , ACCELERATOR_VK_CODES::VK_KANA)
    .value("VK_HANGUEL"             , ACCELERATOR_VK_CODES::VK_HANGUEL)
    .value("VK_HANGUL"              , ACCELERATOR_VK_CODES::VK_HANGUL)
    .value("VK_IME_ON"              , ACCELERATOR_VK_CODES::VK_IME_ON)
    .value("VK_JUNJA"               , ACCELERATOR_VK_CODES::VK_JUNJA)
    .value("VK_FINAL"               , ACCELERATOR_VK_CODES::VK_FINAL)
    .value("VK_HANJA"               , ACCELERATOR_VK_CODES::VK_HANJA)
    .value("VK_KANJI"               , ACCELERATOR_VK_CODES::VK_KANJI)
    .value("VK_IME_OFF"             , ACCELERATOR_VK_CODES::VK_IME_OFF)
    .value("VK_ESCAPE"              , ACCELERATOR_VK_CODES::VK_ESCAPE)
    .value("VK_CONVERT"             , ACCELERATOR_VK_CODES::VK_CONVERT)
    .value("VK_NONCONVERT"          , ACCELERATOR_VK_CODES::VK_NONCONVERT)
    .value("VK_ACCEPT"              , ACCELERATOR_VK_CODES::VK_ACCEPT)
    .value("VK_MODECHANGE"          , ACCELERATOR_VK_CODES::VK_MODECHANGE)
    .value("VK_SPACE"               , ACCELERATOR_VK_CODES::VK_SPACE)
    .value("VK_PRIOR"               , ACCELERATOR_VK_CODES::VK_PRIOR)
    .value("VK_NEXT"                , ACCELERATOR_VK_CODES::VK_NEXT)
    .value("VK_END"                 , ACCELERATOR_VK_CODES::VK_END)
    .value("VK_HOME"                , ACCELERATOR_VK_CODES::VK_HOME)
    .value("VK_LEFT"                , ACCELERATOR_VK_CODES::VK_LEFT)
    .value("VK_UP"                  , ACCELERATOR_VK_CODES::VK_UP)
    .value("VK_RIGHT"               , ACCELERATOR_VK_CODES::VK_RIGHT)
    .value("VK_DOWN"                , ACCELERATOR_VK_CODES::VK_DOWN)
    .value("VK_SELECT"              , ACCELERATOR_VK_CODES::VK_SELECT)
    .value("VK_PRINT"               , ACCELERATOR_VK_CODES::VK_PRINT)
    .value("VK_EXECUTE"             , ACCELERATOR_VK_CODES::VK_EXECUTE)
    .value("VK_SNAPSHOT"            , ACCELERATOR_VK_CODES::VK_SNAPSHOT)
    .value("VK_INSERT"              , ACCELERATOR_VK_CODES::VK_INSERT)
    .value("VK_DELETE"              , ACCELERATOR_VK_CODES::VK_DELETE)
    .value("VK_HELP"                , ACCELERATOR_VK_CODES::VK_HELP)
    .value("VK_0"                   , ACCELERATOR_VK_CODES::VK_0)
    .value("VK_1"                   , ACCELERATOR_VK_CODES::VK_1)
    .value("VK_2"                   , ACCELERATOR_VK_CODES::VK_2)
    .value("VK_3"                   , ACCELERATOR_VK_CODES::VK_3)
    .value("VK_4"                   , ACCELERATOR_VK_CODES::VK_4)
    .value("VK_5"                   , ACCELERATOR_VK_CODES::VK_5)
    .value("VK_6"                   , ACCELERATOR_VK_CODES::VK_6)
    .value("VK_7"                   , ACCELERATOR_VK_CODES::VK_7)
    .value("VK_8"                   , ACCELERATOR_VK_CODES::VK_8)
    .value("VK_9"                   , ACCELERATOR_VK_CODES::VK_9)
    .value("VK_A"                   , ACCELERATOR_VK_CODES::VK_A)
    .value("VK_B"                   , ACCELERATOR_VK_CODES::VK_B)
    .value("VK_C"                   , ACCELERATOR_VK_CODES::VK_C)
    .value("VK_D"                   , ACCELERATOR_VK_CODES::VK_D)
    .value("VK_E"                   , ACCELERATOR_VK_CODES::VK_E)
    .value("VK_F"                   , ACCELERATOR_VK_CODES::VK_F)
    .value("VK_G"                   , ACCELERATOR_VK_CODES::VK_G)
    .value("VK_H"                   , ACCELERATOR_VK_CODES::VK_H)
    .value("VK_I"                   , ACCELERATOR_VK_CODES::VK_I)
    .value("VK_J"                   , ACCELERATOR_VK_CODES::VK_J)
    .value("VK_K"                   , ACCELERATOR_VK_CODES::VK_K)
    .value("VK_L"                   , ACCELERATOR_VK_CODES::VK_L)
    .value("VK_M"                   , ACCELERATOR_VK_CODES::VK_M)
    .value("VK_N"                   , ACCELERATOR_VK_CODES::VK_N)
    .value("VK_O"                   , ACCELERATOR_VK_CODES::VK_O)
    .value("VK_P"                   , ACCELERATOR_VK_CODES::VK_P)
    .value("VK_Q"                   , ACCELERATOR_VK_CODES::VK_Q)
    .value("VK_R"                   , ACCELERATOR_VK_CODES::VK_R)
    .value("VK_S"                   , ACCELERATOR_VK_CODES::VK_S)
    .value("VK_T"                   , ACCELERATOR_VK_CODES::VK_T)
    .value("VK_U"                   , ACCELERATOR_VK_CODES::VK_U)
    .value("VK_V"                   , ACCELERATOR_VK_CODES::VK_V)
    .value("VK_W"                   , ACCELERATOR_VK_CODES::VK_W)
    .value("VK_X"                   , ACCELERATOR_VK_CODES::VK_X)
    .value("VK_Y"                   , ACCELERATOR_VK_CODES::VK_Y)
    .value("VK_Z"                   , ACCELERATOR_VK_CODES::VK_Z)
    .value("VK_LWIN"                , ACCELERATOR_VK_CODES::VK_LWIN)
    .value("VK_RWIN"                , ACCELERATOR_VK_CODES::VK_RWIN)
    .value("VK_APPS"                , ACCELERATOR_VK_CODES::VK_APPS)
    .value("VK_SLEEP"               , ACCELERATOR_VK_CODES::VK_SLEEP)
    .value("VK_NUMPAD0"             , ACCELERATOR_VK_CODES::VK_NUMPAD0)
    .value("VK_NUMPAD1"             , ACCELERATOR_VK_CODES::VK_NUMPAD1)
    .value("VK_NUMPAD2"             , ACCELERATOR_VK_CODES::VK_NUMPAD2)
    .value("VK_NUMPAD3"             , ACCELERATOR_VK_CODES::VK_NUMPAD3)
    .value("VK_NUMPAD4"             , ACCELERATOR_VK_CODES::VK_NUMPAD4)
    .value("VK_NUMPAD5"             , ACCELERATOR_VK_CODES::VK_NUMPAD5)
    .value("VK_NUMPAD6"             , ACCELERATOR_VK_CODES::VK_NUMPAD6)
    .value("VK_NUMPAD7"             , ACCELERATOR_VK_CODES::VK_NUMPAD7)
    .value("VK_NUMPAD8"             , ACCELERATOR_VK_CODES::VK_NUMPAD8)
    .value("VK_NUMPAD9"             , ACCELERATOR_VK_CODES::VK_NUMPAD9)
    .value("VK_MULTIPLY"            , ACCELERATOR_VK_CODES::VK_MULTIPLY)
    .value("VK_ADD"                 , ACCELERATOR_VK_CODES::VK_ADD)
    .value("VK_SEPARATOR"           , ACCELERATOR_VK_CODES::VK_SEPARATOR)
    .value("VK_SUBTRACT"            , ACCELERATOR_VK_CODES::VK_SUBTRACT)
    .value("VK_DECIMAL"             , ACCELERATOR_VK_CODES::VK_DECIMAL)
    .value("VK_DIVIDE"              , ACCELERATOR_VK_CODES::VK_DIVIDE)
    .value("VK_F1"                  , ACCELERATOR_VK_CODES::VK_F1)
    .value("VK_F2"                  , ACCELERATOR_VK_CODES::VK_F2)
    .value("VK_F3"                  , ACCELERATOR_VK_CODES::VK_F3)
    .value("VK_F4"                  , ACCELERATOR_VK_CODES::VK_F4)
    .value("VK_F5"                  , ACCELERATOR_VK_CODES::VK_F5)
    .value("VK_F6"                  , ACCELERATOR_VK_CODES::VK_F6)
    .value("VK_F7"                  , ACCELERATOR_VK_CODES::VK_F7)
    .value("VK_F8"                  , ACCELERATOR_VK_CODES::VK_F8)
    .value("VK_F9"                  , ACCELERATOR_VK_CODES::VK_F9)
    .value("VK_F10"                 , ACCELERATOR_VK_CODES::VK_F10)
    .value("VK_F11"                 , ACCELERATOR_VK_CODES::VK_F11)
    .value("VK_F12"                 , ACCELERATOR_VK_CODES::VK_F12)
    .value("VK_F13"                 , ACCELERATOR_VK_CODES::VK_F13)
    .value("VK_F14"                 , ACCELERATOR_VK_CODES::VK_F14)
    .value("VK_F15"                 , ACCELERATOR_VK_CODES::VK_F15)
    .value("VK_F16"                 , ACCELERATOR_VK_CODES::VK_F16)
    .value("VK_F17"                 , ACCELERATOR_VK_CODES::VK_F17)
    .value("VK_F18"                 , ACCELERATOR_VK_CODES::VK_F18)
    .value("VK_F19"                 , ACCELERATOR_VK_CODES::VK_F19)
    .value("VK_F20"                 , ACCELERATOR_VK_CODES::VK_F20)
    .value("VK_F21"                 , ACCELERATOR_VK_CODES::VK_F21)
    .value("VK_F22"                 , ACCELERATOR_VK_CODES::VK_F22)
    .value("VK_F23"                 , ACCELERATOR_VK_CODES::VK_F23)
    .value("VK_F24"                 , ACCELERATOR_VK_CODES::VK_F24)
    .value("VK_NUMLOCK"             , ACCELERATOR_VK_CODES::VK_NUMLOCK)
    .value("VK_SCROLL"              , ACCELERATOR_VK_CODES::VK_SCROLL)
    .value("VK_LSHIFT"              , ACCELERATOR_VK_CODES::VK_LSHIFT)
    .value("VK_RSHIFT"              , ACCELERATOR_VK_CODES::VK_RSHIFT)
    .value("VK_LCONTROL"            , ACCELERATOR_VK_CODES::VK_LCONTROL)
    .value("VK_RCONTROL"            , ACCELERATOR_VK_CODES::VK_RCONTROL)
    .value("VK_LMENU"               , ACCELERATOR_VK_CODES::VK_LMENU)
    .value("VK_RMENU"               , ACCELERATOR_VK_CODES::VK_RMENU)
    .value("VK_BROWSER_BACK"        , ACCELERATOR_VK_CODES::VK_BROWSER_BACK)
    .value("VK_BROWSER_FORWARD"     , ACCELERATOR_VK_CODES::VK_BROWSER_FORWARD)
    .value("VK_BROWSER_REFRESH"     , ACCELERATOR_VK_CODES::VK_BROWSER_REFRESH)
    .value("VK_BROWSER_STOP"        , ACCELERATOR_VK_CODES::VK_BROWSER_STOP)
    .value("VK_BROWSER_SEARCH"      , ACCELERATOR_VK_CODES::VK_BROWSER_SEARCH)
    .value("VK_BROWSER_FAVORITES"   , ACCELERATOR_VK_CODES::VK_BROWSER_FAVORITES)
    .value("VK_BROWSER_HOME"        , ACCELERATOR_VK_CODES::VK_BROWSER_HOME)
    .value("VK_VOLUME_MUTE"         , ACCELERATOR_VK_CODES::VK_VOLUME_MUTE)
    .value("VK_VOLUME_DOWN"         , ACCELERATOR_VK_CODES::VK_VOLUME_DOWN)
    .value("VK_VOLUME_UP"           , ACCELERATOR_VK_CODES::VK_VOLUME_UP)
    .value("VK_MEDIA_NEXT_TRACK"    , ACCELERATOR_VK_CODES::VK_MEDIA_NEXT_TRACK)
    .value("VK_MEDIA_PREV_TRACK"    , ACCELERATOR_VK_CODES::VK_MEDIA_PREV_TRACK)
    .value("VK_MEDIA_STOP"          , ACCELERATOR_VK_CODES::VK_MEDIA_STOP)
    .value("VK_MEDIA_PLAY_PAUSE"    , ACCELERATOR_VK_CODES::VK_MEDIA_PLAY_PAUSE)
    .value("VK_LAUNCH_MAIL"         , ACCELERATOR_VK_CODES::VK_LAUNCH_MAIL)
    .value("VK_LAUNCH_MEDIA_SELECT" , ACCELERATOR_VK_CODES::VK_LAUNCH_MEDIA_SELECT)
    .value("VK_LAUNCH_APP1"         , ACCELERATOR_VK_CODES::VK_LAUNCH_APP1)
    .value("VK_LAUNCH_APP2"         , ACCELERATOR_VK_CODES::VK_LAUNCH_APP2)
    .value("VK_OEM_1"               , ACCELERATOR_VK_CODES::VK_OEM_1)
    .value("VK_OEM_PLUS"            , ACCELERATOR_VK_CODES::VK_OEM_PLUS)
    .value("VK_OEM_COMMA"           , ACCELERATOR_VK_CODES::VK_OEM_COMMA)
    .value("VK_OEM_MINUS"           , ACCELERATOR_VK_CODES::VK_OEM_MINUS)
    .value("VK_OEM_PERIOD"          , ACCELERATOR_VK_CODES::VK_OEM_PERIOD)
    .value("VK_OEM_2"               , ACCELERATOR_VK_CODES::VK_OEM_2)
    .value("VK_OEM_4"               , ACCELERATOR_VK_CODES::VK_OEM_4)
    .value("VK_OEM_5"               , ACCELERATOR_VK_CODES::VK_OEM_5)
    .value("VK_OEM_6"               , ACCELERATOR_VK_CODES::VK_OEM_6)
    .value("VK_OEM_7"               , ACCELERATOR_VK_CODES::VK_OEM_7)
    .value("VK_OEM_8"               , ACCELERATOR_VK_CODES::VK_OEM_8)
    .value("VK_OEM_102"             , ACCELERATOR_VK_CODES::VK_OEM_102)
    .value("VK_PROCESSKEY"          , ACCELERATOR_VK_CODES::VK_PROCESSKEY)
    .value("VK_PACKET"              , ACCELERATOR_VK_CODES::VK_PACKET)
    .value("VK_ATTN"                , ACCELERATOR_VK_CODES::VK_ATTN)
    .value("VK_CRSEL"               , ACCELERATOR_VK_CODES::VK_CRSEL)
    .value("VK_EXSEL"               , ACCELERATOR_VK_CODES::VK_EXSEL)
    .value("VK_EREOF"               , ACCELERATOR_VK_CODES::VK_EREOF)
    .value("VK_PLAY"                , ACCELERATOR_VK_CODES::VK_PLAY)
    .value("VK_ZOOM"                , ACCELERATOR_VK_CODES::VK_ZOOM)
    .value("VK_NONAME"              , ACCELERATOR_VK_CODES::VK_NONAME)
    .value("VK_PA1"                 , ACCELERATOR_VK_CODES::VK_PA1)
    .value("VK_OEM_CLEAR"           , ACCELERATOR_VK_CODES::VK_OEM_CLEAR);

  LIEF::enum_<ALGORITHMS>(m, "ALGORITHMS")
    .value(PY_ENUM(ALGORITHMS::UNKNOWN))
    .value(PY_ENUM(ALGORITHMS::SHA_512))
    .value(PY_ENUM(ALGORITHMS::SHA_384))
    .value(PY_ENUM(ALGORITHMS::SHA_256))
    .value(PY_ENUM(ALGORITHMS::SHA_1))
    .value(PY_ENUM(ALGORITHMS::MD5))
    .value(PY_ENUM(ALGORITHMS::MD4))
    .value(PY_ENUM(ALGORITHMS::MD2))
    .value(PY_ENUM(ALGORITHMS::RSA))
    .value(PY_ENUM(ALGORITHMS::EC))

    .value(PY_ENUM(ALGORITHMS::MD5_RSA))
    .value(PY_ENUM(ALGORITHMS::SHA1_DSA))
    .value(PY_ENUM(ALGORITHMS::SHA1_RSA))

    .value(PY_ENUM(ALGORITHMS::SHA_256_RSA))
    .value(PY_ENUM(ALGORITHMS::SHA_384_RSA))
    .value(PY_ENUM(ALGORITHMS::SHA_512_RSA))

    .value(PY_ENUM(ALGORITHMS::SHA1_ECDSA))
    .value(PY_ENUM(ALGORITHMS::SHA_256_ECDSA))
    .value(PY_ENUM(ALGORITHMS::SHA_384_ECDSA))
    .value(PY_ENUM(ALGORITHMS::SHA_512_ECDSA));


  LIEF::enum_<SIG_ATTRIBUTE_TYPES>(m, "SIG_ATTRIBUTE_TYPES")
    .value(PY_ENUM(SIG_ATTRIBUTE_TYPES::UNKNOWN))
    .value(PY_ENUM(SIG_ATTRIBUTE_TYPES::CONTENT_TYPE))
    .value(PY_ENUM(SIG_ATTRIBUTE_TYPES::GENERIC_TYPE))
    .value(PY_ENUM(SIG_ATTRIBUTE_TYPES::SPC_SP_OPUS_INFO))
    .value(PY_ENUM(SIG_ATTRIBUTE_TYPES::MS_COUNTER_SIGN))
    .value(PY_ENUM(SIG_ATTRIBUTE_TYPES::MS_SPC_NESTED_SIGN))
    .value(PY_ENUM(SIG_ATTRIBUTE_TYPES::MS_SPC_STATEMENT_TYPE))
    .value(PY_ENUM(SIG_ATTRIBUTE_TYPES::PKCS9_AT_SEQUENCE_NUMBER))
    .value(PY_ENUM(SIG_ATTRIBUTE_TYPES::PKCS9_COUNTER_SIGNATURE))
    .value(PY_ENUM(SIG_ATTRIBUTE_TYPES::PKCS9_MESSAGE_DIGEST))
    .value(PY_ENUM(SIG_ATTRIBUTE_TYPES::PKCS9_SIGNING_TIME));
}

}
}
