# 현재 사용자 가져오기

이전 장에서 (의존성 주입 시스템을 기반으로 한)보안 시스템은 *경로 작동 함수*에서 `str`로 `token`을 제공했습니다:

```Python hl_lines="10"
{!../../docs_src/security/tutorial001.py!}
```

그러나 아직도 유용하지 않습니다.

현재 사용자를 제공하도록 합시다.

## 유저 모델 생성하기

먼저 Pydantic 유저 모델을 만들어 보겠습니다.

Pydantic을 사용하여 본문을 선언하는 것과 같은 방식으로 다른 곳에서 사용할 수 있습니다.

//// tab | 파이썬 3.7 이상

```Python hl_lines="5  12-16"
{!> ../../docs_src/security/tutorial002.py!}
```

////

//// tab | 파이썬 3.10 이상

```Python hl_lines="3  10-14"
{!> ../../docs_src/security/tutorial002_py310.py!}
```

////

## `get_current_user` 의존성 생성하기

의존성 `get_current_user`를 만들어 봅시다.

의존성이 하위 의존성을 가질 수 있다는 것을 기억하십니까?

`get_current_user`는 이전에 생성한 것과 동일한 `oauth2_scheme`과 종속성을 갖게 됩니다.

이전에 *경로 작동*에서 직접 수행했던 것과 동일하게 새 종속성 `get_current_user`는 하위 종속성 `oauth2_scheme`에서 `str`로 `token`을 수신합니다.

//// tab | 파이썬 3.7 이상

```Python hl_lines="25"
{!> ../../docs_src/security/tutorial002.py!}
```

////

//// tab | 파이썬 3.10 이상

```Python hl_lines="23"
{!> ../../docs_src/security/tutorial002_py310.py!}
```

////

## 유저 가져오기

`get_current_user`는 토큰을 `str`로 취하고 Pydantic `User` 모델을 반환하는 우리가 만든 (가짜) 유틸리티 함수를 사용합니다.

//// tab | 파이썬 3.7 이상

```Python hl_lines="19-22  26-27"
{!> ../../docs_src/security/tutorial002.py!}
```

////

//// tab | 파이썬 3.10 이상

```Python hl_lines="17-20  24-25"
{!> ../../docs_src/security/tutorial002_py310.py!}
```

////

## 현재 유저 주입하기

이제 *경로 작동*에서 `get_current_user`와 동일한 `Depends`를 사용할 수 있습니다.

//// tab | 파이썬 3.7 이상

```Python hl_lines="31"
{!> ../../docs_src/security/tutorial002.py!}
```

////

//// tab | 파이썬 3.10 이상

```Python hl_lines="29"
{!> ../../docs_src/security/tutorial002_py310.py!}
```

////

Pydantic 모델인 `User`로 `current_user`의 타입을 선언하는 것을 알아야 합니다.

이것은 모든 완료 및 타입 검사를 통해 함수 내부에서 우리를 도울 것입니다.

/// tip | "팁"

요청 본문도 Pydantic 모델로 선언된다는 것을 기억할 것입니다.

여기서 **FastAPI**는 `Depends`를 사용하고 있기 때문에 혼동되지 않습니다.

///

/// check | "확인"

이 의존성 시스템이 설계된 방식은 모두 `User` 모델을 반환하는 다양한 의존성(다른 "의존적인")을 가질 수 있도록 합니다.

해당 타입의 데이터를 반환할 수 있는 의존성이 하나만 있는 것으로 제한되지 않습니다.

///

## 다른 모델

이제 *경로 작동 함수*에서 현재 사용자를 직접 가져올 수 있으며 `Depends`를 사용하여 **의존성 주입** 수준에서 보안 메커니즘을 처리할 수 있습니다.

그리고 보안 요구 사항에 대한 모든 모델 또는 데이터를 사용할 수 있습니다(이 경우 Pydantic 모델 `User`).

그러나 일부 특정 데이터 모델, 클래스 또는 타입을 사용하도록 제한되지 않습니다.

모델에 `id`와 `email`이 있고 `username`이 없길 원하십니까? 맞습니다. 이들은 동일한 도구를 사용할 수 있습니다.

`str`만 갖고 싶습니까? 아니면 그냥 `dict`를 갖고 싶습니까? 아니면 데이터베이스 클래스 모델 인스턴스를 직접 갖고 싶습니까? 그들은 모두 같은 방식으로 작동합니다.

실제로 애플리케이션에 로그인하는 사용자가 없지만 액세스 토큰만 있는 로봇, 봇 또는 기타 시스템이 있습니까? 다시 말하지만 모두 동일하게 작동합니다.

애플리케이션에 필요한 모든 종류의 모델, 모든 종류의 클래스, 모든 종류의 데이터베이스를 사용하십시오. **FastAPI**는 의존성 주입 시스템을 다루었습니다.

## 코드 사이즈

이 예는 장황해 보일 수 있습니다. 동일한 파일에서 보안, 데이터 모델, 유틸리티 기능 및 *경로 작동*을 혼합하고 있음을 염두에 두십시오.

그러나 이게 키포인트입니다.

보안과 종속성 주입 항목을 한 번만 작성하면 됩니다.

그리고 원하는 만큼 복잡하게 만들 수 있습니다. 그래도 유연성과 함께 한 곳에 한 번에 작성할 수 있습니다.

그러나 동일한 보안 시스템을 사용하여 수천 개의 엔드포인트(*경로 작동*)를 가질 수 있습니다.

그리고 그들 모두(또는 원하는 부분)는 이러한 의존성 또는 생성한 다른 의존성을 재사용하는 이점을 얻을 수 있습니다.

그리고 이 수천 개의 *경로 작동*은 모두 3줄 정도로 줄일 수 있습니다.

//// tab | 파이썬 3.7 이상

```Python hl_lines="30-32"
{!> ../../docs_src/security/tutorial002.py!}
```

////

//// tab | 파이썬 3.10 이상

```Python hl_lines="28-30"
{!> ../../docs_src/security/tutorial002_py310.py!}
```

////

## 요약

이제 *경로 작동 함수*에서 현재 사용자를 직접 가져올 수 있습니다.

우리는 이미 이들 사이에 있습니다.

사용자/클라이언트가 실제로 `username`과 `password`를 보내려면 *경로 작동*을 추가하기만 하면 됩니다.

다음 장을 확인해 봅시다.
