# パスパラメータと数値の検証

クエリパラメータに対して`Query`でより多くのバリデーションとメタデータを宣言できるのと同じように、パスパラメータに対しても`Path`で同じ種類のバリデーションとメタデータを宣言することができます。

## Pathのインポート

まず初めに、`fastapi`から`Path`をインポートします:

```Python hl_lines="1"
{!../../docs_src/path_params_numeric_validations/tutorial001.py!}
```

## メタデータの宣言

パラメータは`Query`と同じものを宣言することができます。

例えば、パスパラメータ`item_id`に対して`title`のメタデータを宣言するには以下のようにします:

```Python hl_lines="8"
{!../../docs_src/path_params_numeric_validations/tutorial001.py!}
```

/// note | "備考"

パスの一部でなければならないので、パスパラメータは常に必須です。

そのため、`...`を使用して必須と示す必要があります。

それでも、`None`で宣言しても、デフォルト値を設定しても、何の影響もなく、常に必要とされていることに変わりはありません。

///

## 必要に応じてパラメータを並び替える

クエリパラメータ`q`を必須の`str`として宣言したいとしましょう。

また、このパラメータには何も宣言する必要がないので、`Query`を使う必要はありません。

しかし、パスパラメータ`item_id`のために`Path`を使用する必要があります。

Pythonは「デフォルト」を持たない値の前に「デフォルト」を持つ値を置くことができません。

しかし、それらを並び替えることができ、デフォルト値を持たない値（クエリパラメータ`q`）を最初に持つことができます。

**FastAPI**では関係ありません。パラメータは名前、型、デフォルトの宣言（`Query`、`Path`など）で検出され、順番は気にしません。

そのため、以下のように関数を宣言することができます:

```Python hl_lines="8"
{!../../docs_src/path_params_numeric_validations/tutorial002.py!}
```

## 必要に応じてパラメータを並び替えるトリック

クエリパラメータ`q`を`Query`やデフォルト値なしで宣言し、パスパラメータ`item_id`を`Path`を用いて宣言し、それらを別の順番に並びたい場合、Pythonには少し特殊な構文が用意されています。

関数の最初のパラメータとして`*`を渡します。

Pythonはその`*`で何かをすることはありませんが、それ以降のすべてのパラメータがキーワード引数（キーと値のペア）として呼ばれるべきものであると知っているでしょう。それは<abbr title="From: K-ey W-ord Arg-uments"><code>kwargs</code></abbr>としても知られています。たとえデフォルト値がなくても。

```Python hl_lines="8"
{!../../docs_src/path_params_numeric_validations/tutorial003.py!}
```

## 数値の検証: 以上

`Query`と`Path`（、そして後述する他のもの）を用いて、文字列の制約を宣言することができますが、数値の制約も同様に宣言できます。

ここで、`ge=1`の場合、`item_id`は`1`「より大きい`g`か、同じ`e`」整数でなれけばなりません。

```Python hl_lines="8"
{!../../docs_src/path_params_numeric_validations/tutorial004.py!}
```

## 数値の検証: より大きいと小なりイコール

以下も同様です:

* `gt`: より大きい（`g`reater `t`han）
* `le`: 小なりイコール（`l`ess than or `e`qual）

```Python hl_lines="9"
{!../../docs_src/path_params_numeric_validations/tutorial005.py!}
```

## 数値の検証: 浮動小数点、 大なり小なり

数値のバリデーションは`float`の値に対しても有効です。

ここで重要になってくるのは<abbr title="より大きい"><code>gt</code></abbr>だけでなく<abbr title="以下"><code>ge</code></abbr>も宣言できることです。これと同様に、例えば、値が`1`より小さくても`0`より大きくなければならないことを要求することができます。

したがって、`0.5`は有効な値ですが、`0.0`や`0`はそうではありません。

これは<abbr title="未満"><code>lt</code></abbr>も同じです。

```Python hl_lines="11"
{!../../docs_src/path_params_numeric_validations/tutorial006.py!}
```

## まとめ

`Query`と`Path`（そしてまだ見たことない他のもの）では、[クエリパラメータと文字列の検証](query-params-str-validations.md){.internal-link target=_blank}と同じようにメタデータと文字列の検証を宣言することができます。

また、数値のバリデーションを宣言することもできます:

* `gt`: より大きい（`g`reater `t`han）
* `ge`: 以上（`g`reater than or `e`qual）
* `lt`: より小さい（`l`ess `t`han）
* `le`: 以下（`l`ess than or `e`qual）

/// info | "情報"

`Query`、`Path`などは後に共通の`Param`クラスのサブクラスを見ることになります。（使う必要はありません）

そして、それらすべては、これまで見てきた追加のバリデーションとメタデータと同じパラメータを共有しています。

///

/// note | "技術詳細"

`fastapi`から`Query`、`Path`などをインポートすると、これらは実際には関数です。

呼び出されると、同じ名前のクラスのインスタンスを返します。

そのため、関数である`Query`をインポートし、それを呼び出すと、`Query`という名前のクラスのインスタンスが返されます。

これらの関数は（クラスを直接使うのではなく）エディタが型についてエラーとしないようにするために存在します。

この方法によって、これらのエラーを無視するための設定を追加することなく、通常のエディタやコーディングツールを使用することができます。

///
