# 🗄 (🔗) 💽

**FastAPI** 🚫 🚚 👆 ⚙️ 🗄 (🔗) 💽.

✋️ 👆 💪 ⚙️ 🙆 🔗 💽 👈 👆 💚.

📥 👥 🔜 👀 🖼 ⚙️ <a href="https://www.sqlalchemy.org/" class="external-link" target="_blank">🇸🇲</a>.

👆 💪 💪 🛠️ ⚫️ 🙆 💽 🐕‍🦺 🇸🇲, 💖:

* ✳
* ✳
* 🗄
* 🐸
* 🤸‍♂ 🗄 💽, ♒️.

👉 🖼, 👥 🔜 ⚙️ **🗄**, ↩️ ⚫️ ⚙️ 👁 📁 &amp; 🐍 ✔️ 🛠️ 🐕‍🦺. , 👆 💪 📁 👉 🖼 &amp; 🏃 ⚫️.

⏪, 👆 🏭 🈸, 👆 💪 💚 ⚙️ 💽 💽 💖 **✳**.

!!! tip
    📤 🛂 🏗 🚂 ⏮️ **FastAPI** &amp; **✳**, 🌐 ⚓️ 🔛 **☁**, 🔌 🕸 &amp; 🌖 🧰: <a href="https://github.com/tiangolo/full-stack-fastapi-postgresql" class="external-link" target="_blank">https://github.com/tiangolo/full-stack-fastapi-postgresql</a>

!!! note
    👀 👈 📚 📟 🐩 `SQLAlchemy` 📟 👆 🔜 ⚙️ ⏮️ 🙆 🛠️.

     **FastAPI** 🎯 📟 🤪 🕧.

## 🐜

**FastAPI** 👷 ⏮️ 🙆 💽 &amp; 🙆 👗 🗃 💬 💽.

⚠ ⚓ ⚙️ "🐜": "🎚-🔗 🗺" 🗃.

🐜 ✔️ 🧰 🗜 ("*🗺*") 🖖 *🎚* 📟 &amp; 💽 🏓 ("*🔗*").

⏮️ 🐜, 👆 🛎 ✍ 🎓 👈 🎨 🏓 🗄 💽, 🔠 🔢 🎓 🎨 🏓, ⏮️ 📛 &amp; 🆎.

🖼 🎓 `Pet` 💪 🎨 🗄 🏓 `pets`.

&amp; 🔠 *👐* 🎚 👈 🎓 🎨 ⏭ 💽.

🖼 🎚 `orion_cat` (👐 `Pet`) 💪 ✔️ 🔢 `orion_cat.type`, 🏓 `type`. &amp; 💲 👈 🔢 💪, ✅ `"cat"`.

👫 🐜 ✔️ 🧰 ⚒ 🔗 ⚖️ 🔗 🖖 🏓 ⚖️ 👨‍💼.

👉 🌌, 👆 💪 ✔️ 🔢 `orion_cat.owner` &amp; 👨‍💼 🔜 🔌 💽 👉 🐶 👨‍💼, ✊ ⚪️➡️ 🏓 *👨‍💼*.

, `orion_cat.owner.name` 💪 📛 (⚪️➡️ `name` 🏓 `owners` 🏓) 👉 🐶 👨‍💼.

⚫️ 💪 ✔️ 💲 💖 `"Arquilian"`.

&amp; 🐜 🔜 🌐 👷 🤚 ℹ ⚪️➡️ 🔗 🏓 *👨‍💼* 🕐❔ 👆 🔄 🔐 ⚫️ ⚪️➡️ 👆 🐶 🎚.

⚠ 🐜 🖼: ✳-🐜 (🍕 ✳ 🛠️), 🇸🇲 🐜 (🍕 🇸🇲, 🔬 🛠️) &amp; 🏒 (🔬 🛠️), 👪 🎏.

📥 👥 🔜 👀 ❔ 👷 ⏮️ **🇸🇲 🐜**.

🎏 🌌 👆 💪 ⚙️ 🙆 🎏 🐜.

!!! tip
    📤 🌓 📄 ⚙️ 🏒 📥 🩺.

## 📁 📊

👫 🖼, ➡️ 💬 👆 ✔️ 📁 📛 `my_super_project` 👈 🔌 🎧-📁 🤙 `sql_app` ⏮️ 📊 💖 👉:

```
.
└── sql_app
    ├── __init__.py
    ├── crud.py
    ├── database.py
    ├── main.py
    ├── models.py
    └── schemas.py
```

📁 `__init__.py` 🛁 📁, ✋️ ⚫️ 💬 🐍 👈 `sql_app` ⏮️ 🌐 🚮 🕹 (🐍 📁) 📦.

🔜 ➡️ 👀 ⚫️❔ 🔠 📁/🕹 🔨.

## ❎ `SQLAlchemy`

🥇 👆 💪 ❎ `SQLAlchemy`:

<div class="termy">

```console
$ pip install sqlalchemy

---> 100%
```

</div>

## ✍ 🇸🇲 🍕

➡️ 🔗 📁 `sql_app/database.py`.

### 🗄 🇸🇲 🍕

```Python hl_lines="1-3"
{!../../../docs_src/sql_databases/sql_app/database.py!}
```

### ✍ 💽 📛 🇸🇲

```Python hl_lines="5-6"
{!../../../docs_src/sql_databases/sql_app/database.py!}
```

👉 🖼, 👥 "🔗" 🗄 💽 (📂 📁 ⏮️ 🗄 💽).

📁 🔜 🔎 🎏 📁 📁 `sql_app.db`.

👈 ⚫️❔ 🏁 🍕 `./sql_app.db`.

🚥 👆 ⚙️ **✳** 💽 ↩️, 👆 🔜 ✔️ ✍ ⏸:

```Python
SQLALCHEMY_DATABASE_URL = "postgresql://user:password@postgresserver/db"
```

...&amp; 🛠️ ⚫️ ⏮️ 👆 💽 📊 &amp; 🎓 (📊 ✳, ✳ ⚖️ 🙆 🎏).

!!! tip

    👉 👑 ⏸ 👈 👆 🔜 ✔️ 🔀 🚥 👆 💚 ⚙️ 🎏 💽.

### ✍ 🇸🇲 `engine`

🥇 🔁 ✍ 🇸🇲 "🚒".

👥 🔜 ⏪ ⚙️ 👉 `engine` 🎏 🥉.

```Python hl_lines="8-10"
{!../../../docs_src/sql_databases/sql_app/database.py!}
```

#### 🗒

❌:

```Python
connect_args={"check_same_thread": False}
```

...💪 🕴 `SQLite`. ⚫️ 🚫 💪 🎏 💽.

!!! info "📡 ℹ"

    🔢 🗄 🔜 🕴 ✔ 1️⃣ 🧵 🔗 ⏮️ ⚫️, 🤔 👈 🔠 🧵 🔜 🍵 🔬 📨.

    👉 ❎ 😫 🤝 🎏 🔗 🎏 👜 (🎏 📨).

    ✋️ FastAPI, ⚙️ 😐 🔢 (`def`) 🌅 🌘 1️⃣ 🧵 💪 🔗 ⏮️ 💽 🎏 📨, 👥 💪 ⚒ 🗄 💭 👈 ⚫️ 🔜 ✔ 👈 ⏮️ `connect_args={"check_same_thread": False}`.

    , 👥 🔜 ⚒ 💭 🔠 📨 🤚 🚮 👍 💽 🔗 🎉 🔗, 📤 🙅‍♂ 💪 👈 🔢 🛠️.

### ✍ `SessionLocal` 🎓

🔠 👐 `SessionLocal` 🎓 🔜 💽 🎉. 🎓 ⚫️ 🚫 💽 🎉.

✋️ 🕐 👥 ✍ 👐 `SessionLocal` 🎓, 👉 👐 🔜 ☑ 💽 🎉.

👥 📛 ⚫️ `SessionLocal` 🔬 ⚫️ ⚪️➡️ `Session` 👥 🏭 ⚪️➡️ 🇸🇲.

👥 🔜 ⚙️ `Session` (1️⃣ 🗄 ⚪️➡️ 🇸🇲) ⏪.

✍ `SessionLocal` 🎓, ⚙️ 🔢 `sessionmaker`:

```Python hl_lines="11"
{!../../../docs_src/sql_databases/sql_app/database.py!}
```

### ✍ `Base` 🎓

🔜 👥 🔜 ⚙️ 🔢 `declarative_base()` 👈 📨 🎓.

⏪ 👥 🔜 😖 ⚪️➡️ 👉 🎓 ✍ 🔠 💽 🏷 ⚖️ 🎓 (🐜 🏷):

```Python hl_lines="13"
{!../../../docs_src/sql_databases/sql_app/database.py!}
```

## ✍ 💽 🏷

➡️ 🔜 👀 📁 `sql_app/models.py`.

### ✍ 🇸🇲 🏷 ⚪️➡️ `Base` 🎓

👥 🔜 ⚙️ 👉 `Base` 🎓 👥 ✍ ⏭ ✍ 🇸🇲 🏷.

!!! tip
    🇸🇲 ⚙️ ⚖ "**🏷**" 🔗 👉 🎓 &amp; 👐 👈 🔗 ⏮️ 💽.

    ✋️ Pydantic ⚙️ ⚖ "**🏷**" 🔗 🕳 🎏, 💽 🔬, 🛠️, &amp; 🧾 🎓 &amp; 👐.

🗄 `Base` ⚪️➡️ `database` (📁 `database.py` ⚪️➡️ 🔛).

✍ 🎓 👈 😖 ⚪️➡️ ⚫️.

👫 🎓 🇸🇲 🏷.

```Python hl_lines="4  7-8  18-19"
{!../../../docs_src/sql_databases/sql_app/models.py!}
```

`__tablename__` 🔢 💬 🇸🇲 📛 🏓 ⚙️ 💽 🔠 👫 🏷.

### ✍ 🏷 🔢/🏓

🔜 ✍ 🌐 🏷 (🎓) 🔢.

🔠 👫 🔢 🎨 🏓 🚮 🔗 💽 🏓.

👥 ⚙️ `Column` ⚪️➡️ 🇸🇲 🔢 💲.

&amp; 👥 🚶‍♀️ 🇸🇲 🎓 "🆎", `Integer`, `String`, &amp; `Boolean`, 👈 🔬 🆎 💽, ❌.

```Python hl_lines="1  10-13  21-24"
{!../../../docs_src/sql_databases/sql_app/models.py!}
```

### ✍ 💛

🔜 ✍ 💛.

👉, 👥 ⚙️ `relationship` 🚚 🇸🇲 🐜.

👉 🔜 ▶️️, 🌅 ⚖️ 🌘, "🎱" 🔢 👈 🔜 🔌 💲 ⚪️➡️ 🎏 🏓 🔗 👉 1️⃣.

```Python hl_lines="2  15  26"
{!../../../docs_src/sql_databases/sql_app/models.py!}
```

🕐❔ 🔐 🔢 `items` `User`, `my_user.items`, ⚫️ 🔜 ✔️ 📇 `Item` 🇸🇲 🏷 (⚪️➡️ `items` 🏓) 👈 ✔️ 💱 🔑 ☝ 👉 ⏺ `users` 🏓.

🕐❔ 👆 🔐 `my_user.items`, 🇸🇲 🔜 🤙 🚶 &amp; ☕ 🏬 ⚪️➡️ 💽 `items` 🏓 &amp; 🔗 👫 📥.

&amp; 🕐❔ 🔐 🔢 `owner` `Item`, ⚫️ 🔜 🔌 `User` 🇸🇲 🏷 ⚪️➡️ `users` 🏓. ⚫️ 🔜 ⚙️ `owner_id` 🔢/🏓 ⏮️ 🚮 💱 🔑 💭 ❔ ⏺ 🤚 ⚪️➡️ `users` 🏓.

## ✍ Pydantic 🏷

🔜 ➡️ ✅ 📁 `sql_app/schemas.py`.

!!! tip
    ❎ 😨 🖖 🇸🇲 *🏷* &amp; Pydantic *🏷*, 👥 🔜 ✔️ 📁 `models.py` ⏮️ 🇸🇲 🏷, &amp; 📁 `schemas.py` ⏮️ Pydantic 🏷.

    👫 Pydantic 🏷 🔬 🌅 ⚖️ 🌘 "🔗" (☑ 📊 💠).

    👉 🔜 ℹ 👥 ❎ 😨 ⏪ ⚙️ 👯‍♂️.

### ✍ ▶️ Pydantic *🏷* / 🔗

✍ `ItemBase` &amp; `UserBase` Pydantic *🏷* (⚖️ ➡️ 💬 "🔗") ✔️ ⚠ 🔢 ⏪ 🏗 ⚖️ 👂 📊.

&amp; ✍ `ItemCreate` &amp; `UserCreate` 👈 😖 ⚪️➡️ 👫 (👫 🔜 ✔️ 🎏 🔢), ➕ 🙆 🌖 📊 (🔢) 💪 🏗.

, 👩‍💻 🔜 ✔️ `password` 🕐❔ 🏗 ⚫️.

✋️ 💂‍♂, `password` 🏆 🚫 🎏 Pydantic *🏷*, 🖼, ⚫️ 🏆 🚫 📨 ⚪️➡️ 🛠️ 🕐❔ 👂 👩‍💻.

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="3  6-8  11-12  23-24  27-28"
    {!> ../../../docs_src/sql_databases/sql_app/schemas.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="3  6-8  11-12  23-24  27-28"
    {!> ../../../docs_src/sql_databases/sql_app_py39/schemas.py!}
    ```

=== "🐍 3️⃣.1️⃣0️⃣ &amp; 🔛"

    ```Python hl_lines="1  4-6  9-10  21-22  25-26"
    {!> ../../../docs_src/sql_databases/sql_app_py310/schemas.py!}
    ```

#### 🇸🇲 👗 &amp; Pydantic 👗

👀 👈 🇸🇲 *🏷* 🔬 🔢 ⚙️ `=`, &amp; 🚶‍♀️ 🆎 🔢 `Column`, 💖:

```Python
name = Column(String)
```

⏪ Pydantic *🏷* 📣 🆎 ⚙️ `:`, 🆕 🆎 ✍ ❕/🆎 🔑:

```Python
name: str
```

✔️ ⚫️ 🤯, 👆 🚫 🤚 😕 🕐❔ ⚙️ `=` &amp; `:` ⏮️ 👫.

### ✍ Pydantic *🏷* / 🔗 👂 / 📨

🔜 ✍ Pydantic *🏷* (🔗) 👈 🔜 ⚙️ 🕐❔ 👂 💽, 🕐❔ 🛬 ⚫️ ⚪️➡️ 🛠️.

🖼, ⏭ 🏗 🏬, 👥 🚫 💭 ⚫️❔ 🔜 🆔 🛠️ ⚫️, ✋️ 🕐❔ 👂 ⚫️ (🕐❔ 🛬 ⚫️ ⚪️➡️ 🛠️) 👥 🔜 ⏪ 💭 🚮 🆔.

🎏 🌌, 🕐❔ 👂 👩‍💻, 👥 💪 🔜 📣 👈 `items` 🔜 🔌 🏬 👈 💭 👉 👩‍💻.

🚫 🕴 🆔 📚 🏬, ✋️ 🌐 💽 👈 👥 🔬 Pydantic *🏷* 👂 🏬: `Item`.

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="15-17  31-34"
    {!> ../../../docs_src/sql_databases/sql_app/schemas.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="15-17  31-34"
    {!> ../../../docs_src/sql_databases/sql_app_py39/schemas.py!}
    ```

=== "🐍 3️⃣.1️⃣0️⃣ &amp; 🔛"

    ```Python hl_lines="13-15  29-32"
    {!> ../../../docs_src/sql_databases/sql_app_py310/schemas.py!}
    ```

!!! tip
    👀 👈 `User`, Pydantic *🏷* 👈 🔜 ⚙️ 🕐❔ 👂 👩‍💻 (🛬 ⚫️ ⚪️➡️ 🛠️) 🚫 🔌 `password`.

### ⚙️ Pydantic `orm_mode`

🔜, Pydantic *🏷* 👂, `Item` &amp; `User`, 🚮 🔗 `Config` 🎓.

👉 <a href="https://docs.pydantic.dev/latest/api/config/" class="external-link" target="_blank">`Config`</a> 🎓 ⚙️ 🚚 📳 Pydantic.

`Config` 🎓, ⚒ 🔢 `orm_mode = True`.

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="15  19-20  31  36-37"
    {!> ../../../docs_src/sql_databases/sql_app/schemas.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="15  19-20  31  36-37"
    {!> ../../../docs_src/sql_databases/sql_app_py39/schemas.py!}
    ```

=== "🐍 3️⃣.1️⃣0️⃣ &amp; 🔛"

    ```Python hl_lines="13  17-18  29  34-35"
    {!> ../../../docs_src/sql_databases/sql_app_py310/schemas.py!}
    ```

!!! tip
    👀 ⚫️ ⚖ 💲 ⏮️ `=`, 💖:

    `orm_mode = True`

    ⚫️ 🚫 ⚙️ `:` 🆎 📄 ⏭.

    👉 ⚒ 📁 💲, 🚫 📣 🆎.

Pydantic `orm_mode` 🔜 💬 Pydantic *🏷* ✍ 💽 🚥 ⚫️ 🚫 `dict`, ✋️ 🐜 🏷 (⚖️ 🙆 🎏 ❌ 🎚 ⏮️ 🔢).

👉 🌌, ↩️ 🕴 🔄 🤚 `id` 💲 ⚪️➡️ `dict`,:

```Python
id = data["id"]
```

⚫️ 🔜 🔄 🤚 ⚫️ ⚪️➡️ 🔢,:

```Python
id = data.id
```

&amp; ⏮️ 👉, Pydantic *🏷* 🔗 ⏮️ 🐜, &amp; 👆 💪 📣 ⚫️ `response_model` ❌ 👆 *➡ 🛠️*.

👆 🔜 💪 📨 💽 🏷 &amp; ⚫️ 🔜 ✍ 💽 ⚪️➡️ ⚫️.

#### 📡 ℹ 🔃 🐜 📳

🇸🇲 &amp; 📚 🎏 🔢 "🙃 🚚".

👈 ⛓, 🖼, 👈 👫 🚫 ☕ 💽 💛 ⚪️➡️ 💽 🚥 👆 🔄 🔐 🔢 👈 🔜 🔌 👈 💽.

🖼, 🔐 🔢 `items`:

```Python
current_user.items
```

🔜 ⚒ 🇸🇲 🚶 `items` 🏓 &amp; 🤚 🏬 👉 👩‍💻, ✋️ 🚫 ⏭.

🍵 `orm_mode`, 🚥 👆 📨 🇸🇲 🏷 ⚪️➡️ 👆 *➡ 🛠️*, ⚫️ 🚫🔜 🔌 💛 💽.

🚥 👆 📣 📚 💛 👆 Pydantic 🏷.

✋️ ⏮️ 🐜 📳, Pydantic ⚫️ 🔜 🔄 🔐 💽 ⚫️ 💪 ⚪️➡️ 🔢 (↩️ 🤔 `dict`), 👆 💪 📣 🎯 💽 👆 💚 📨 &amp; ⚫️ 🔜 💪 🚶 &amp; 🤚 ⚫️, ⚪️➡️ 🐜.

## 💩 🇨🇻

🔜 ➡️ 👀 📁 `sql_app/crud.py`.

👉 📁 👥 🔜 ✔️ ♻ 🔢 🔗 ⏮️ 💽 💽.

**💩** 👟 ⚪️➡️: **🅱**📧, **Ⓜ**💳, **👤** = , &amp; **🇨🇮**📧.

...👐 👉 🖼 👥 🕴 🏗 &amp; 👂.

### ✍ 💽

🗄 `Session` ⚪️➡️ `sqlalchemy.orm`, 👉 🔜 ✔ 👆 📣 🆎 `db` 🔢 &amp; ✔️ 👻 🆎 ✅ &amp; 🛠️ 👆 🔢.

🗄 `models` (🇸🇲 🏷) &amp; `schemas` (Pydantic *🏷* / 🔗).

✍ 🚙 🔢:

* ✍ 👁 👩‍💻 🆔 &amp; 📧.
* ✍ 💗 👩‍💻.
* ✍ 💗 🏬.

```Python hl_lines="1  3  6-7  10-11  14-15  27-28"
{!../../../docs_src/sql_databases/sql_app/crud.py!}
```

!!! tip
    🏗 🔢 👈 🕴 💡 🔗 ⏮️ 💽 (🤚 👩‍💻 ⚖️ 🏬) 🔬 👆 *➡ 🛠️ 🔢*, 👆 💪 🌖 💪 ♻ 👫 💗 🍕 &amp; 🚮 <abbr title="Automated tests, written in code, that check if another piece of code is working correctly.">⚒ 💯</abbr> 👫.

### ✍ 💽

🔜 ✍ 🚙 🔢 ✍ 💽.

🔁:

* ✍ 🇸🇲 🏷 *👐* ⏮️ 👆 📊.
* `add` 👈 👐 🎚 👆 💽 🎉.
* `commit` 🔀 💽 (👈 👫 🖊).
* `refresh` 👆 👐 (👈 ⚫️ 🔌 🙆 🆕 📊 ⚪️➡️ 💽, 💖 🏗 🆔).

```Python hl_lines="18-24  31-36"
{!../../../docs_src/sql_databases/sql_app/crud.py!}
```

!!! tip
    🇸🇲 🏷 `User` 🔌 `hashed_password` 👈 🔜 🔌 🔐 #️⃣ ⏬ 🔐.

    ✋️ ⚫️❔ 🛠️ 👩‍💻 🚚 ⏮️ 🔐, 👆 💪 ⚗ ⚫️ &amp; 🏗 #️⃣ 🔐 👆 🈸.

     &amp; ⤴️ 🚶‍♀️ `hashed_password` ❌ ⏮️ 💲 🖊.

!!! warning
    👉 🖼 🚫 🔐, 🔐 🚫#️⃣.

    🎰 👨‍❤‍👨 🈸 👆 🔜 💪 #️⃣ 🔐 &amp; 🙅 🖊 👫 🔢.

    🌅 ℹ, 🚶 🔙 💂‍♂ 📄 🔰.

    📥 👥 🎯 🕴 🔛 🧰 &amp; 👨‍🔧 💽.

!!! tip
    ↩️ 🚶‍♀️ 🔠 🇨🇻 ❌ `Item` &amp; 👂 🔠 1️⃣ 👫 ⚪️➡️ Pydantic *🏷*, 👥 🏭 `dict` ⏮️ Pydantic *🏷*'Ⓜ 📊 ⏮️:

    `item.dict()`

     &amp; ⤴️ 👥 🚶‍♀️ `dict`'Ⓜ 🔑-💲 👫 🇨🇻 ❌ 🇸🇲 `Item`, ⏮️:

    `Item(**item.dict())`

     &amp; ⤴️ 👥 🚶‍♀️ ➕ 🇨🇻 ❌ `owner_id` 👈 🚫 🚚 Pydantic *🏷*, ⏮️:

    `Item(**item.dict(), owner_id=user_id)`

## 👑 **FastAPI** 📱

&amp; 🔜 📁 `sql_app/main.py` ➡️ 🛠️ &amp; ⚙️ 🌐 🎏 🍕 👥 ✍ ⏭.

### ✍ 💽 🏓

📶 🙃 🌌 ✍ 💽 🏓:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="9"
    {!> ../../../docs_src/sql_databases/sql_app/main.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="7"
    {!> ../../../docs_src/sql_databases/sql_app_py39/main.py!}
    ```

#### ⚗ 🗒

🛎 👆 🔜 🎲 🔢 👆 💽 (✍ 🏓, ♒️) ⏮️ <a href="https://alembic.sqlalchemy.org/en/latest/" class="external-link" target="_blank">⚗</a>.

&amp; 👆 🔜 ⚙️ ⚗ "🛠️" (👈 🚮 👑 👨‍🏭).

"🛠️" ⚒ 🔁 💪 🕐❔ 👆 🔀 📊 👆 🇸🇲 🏷, 🚮 🆕 🔢, ♒️. 🔁 👈 🔀 💽, 🚮 🆕 🏓, 🆕 🏓, ♒️.

👆 💪 🔎 🖼 ⚗ FastAPI 🏗 📄 ⚪️➡️ [🏗 ⚡ - 📄](../project-generation.md){.internal-link target=_blank}. 🎯 <a href="https://github.com/tiangolo/full-stack-fastapi-postgresql/tree/master/src/backend/app/alembic/" class="external-link" target="_blank"> `alembic` 📁 ℹ 📟</a>.

### ✍ 🔗

🔜 ⚙️ `SessionLocal` 🎓 👥 ✍ `sql_app/database.py` 📁 ✍ 🔗.

👥 💪 ✔️ 🔬 💽 🎉/🔗 (`SessionLocal`) 📍 📨, ⚙️ 🎏 🎉 🔘 🌐 📨 &amp; ⤴️ 🔐 ⚫️ ⏮️ 📨 🏁.

&amp; ⤴️ 🆕 🎉 🔜 ✍ ⏭ 📨.

👈, 👥 🔜 ✍ 🆕 🔗 ⏮️ `yield`, 🔬 ⏭ 📄 🔃 [🔗 ⏮️ `yield`](dependencies/dependencies-with-yield.md){.internal-link target=_blank}.

👆 🔗 🔜 ✍ 🆕 🇸🇲 `SessionLocal` 👈 🔜 ⚙️ 👁 📨, &amp; ⤴️ 🔐 ⚫️ 🕐 📨 🏁.

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="15-20"
    {!> ../../../docs_src/sql_databases/sql_app/main.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="13-18"
    {!> ../../../docs_src/sql_databases/sql_app_py39/main.py!}
    ```

!!! info
    👥 🚮 🏗 `SessionLocal()` &amp; 🚚 📨 `try` 🍫.

     &amp; ⤴️ 👥 🔐 ⚫️ `finally` 🍫.

    👉 🌌 👥 ⚒ 💭 💽 🎉 🕧 📪 ⏮️ 📨. 🚥 📤 ⚠ ⏪ 🏭 📨.

    ✋️ 👆 💪 🚫 🤚 ➕1️⃣ ⚠ ⚪️➡️ 🚪 📟 (⏮️ `yield`). 👀 🌖 [🔗 ⏮️ `yield` &amp; `HTTPException`](dependencies/dependencies-with-yield.md#yield-httpexception){.internal-link target=_blank}

&amp; ⤴️, 🕐❔ ⚙️ 🔗 *➡ 🛠️ 🔢*, 👥 📣 ⚫️ ⏮️ 🆎 `Session` 👥 🗄 🔗 ⚪️➡️ 🇸🇲.

👉 🔜 ⤴️ 🤝 👥 👍 👨‍🎨 🐕‍🦺 🔘 *➡ 🛠️ 🔢*, ↩️ 👨‍🎨 🔜 💭 👈 `db` 🔢 🆎 `Session`:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="24  32  38  47  53"
    {!> ../../../docs_src/sql_databases/sql_app/main.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="22  30  36  45  51"
    {!> ../../../docs_src/sql_databases/sql_app_py39/main.py!}
    ```

!!! info "📡 ℹ"
    🔢 `db` 🤙 🆎 `SessionLocal`, ✋️ 👉 🎓 (✍ ⏮️ `sessionmaker()`) "🗳" 🇸🇲 `Session`,, 👨‍🎨 🚫 🤙 💭 ⚫️❔ 👩‍🔬 🚚.

    ✋️ 📣 🆎 `Session`, 👨‍🎨 🔜 💪 💭 💪 👩‍🔬 (`.add()`, `.query()`, `.commit()`, ♒️) &amp; 💪 🚚 👍 🐕‍🦺 (💖 🛠️). 🆎 📄 🚫 📉 ☑ 🎚.

### ✍ 👆 **FastAPI** *➡ 🛠️*

🔜, 😒, 📥 🐩 **FastAPI** *➡ 🛠️* 📟.

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="23-28  31-34  37-42  45-49  52-55"
    {!> ../../../docs_src/sql_databases/sql_app/main.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="21-26  29-32  35-40  43-47  50-53"
    {!> ../../../docs_src/sql_databases/sql_app_py39/main.py!}
    ```

👥 🏗 💽 🎉 ⏭ 🔠 📨 🔗 ⏮️ `yield`, &amp; ⤴️ 📪 ⚫️ ⏮️.

&amp; ⤴️ 👥 💪 ✍ 🚚 🔗 *➡ 🛠️ 🔢*, 🤚 👈 🎉 🔗.

⏮️ 👈, 👥 💪 🤙 `crud.get_user` 🔗 ⚪️➡️ 🔘 *➡ 🛠️ 🔢* &amp; ⚙️ 👈 🎉.

!!! tip
    👀 👈 💲 👆 📨 🇸🇲 🏷, ⚖️ 📇 🇸🇲 🏷.

    ✋️ 🌐 *➡ 🛠️* ✔️ `response_model` ⏮️ Pydantic *🏷* / 🔗 ⚙️ `orm_mode`, 💽 📣 👆 Pydantic 🏷 🔜 ⚗ ⚪️➡️ 👫 &amp; 📨 👩‍💻, ⏮️ 🌐 😐 ⛽ &amp; 🔬.

!!! tip
    👀 👈 📤 `response_models` 👈 ✔️ 🐩 🐍 🆎 💖 `List[schemas.Item]`.

    ✋️ 🎚/🔢 👈 `List` Pydantic *🏷* ⏮️ `orm_mode`, 💽 🔜 🗃 &amp; 📨 👩‍💻 🛎, 🍵 ⚠.

### 🔃 `def` 🆚 `async def`

📥 👥 ⚙️ 🇸🇲 📟 🔘 *➡ 🛠️ 🔢* &amp; 🔗, &amp;, 🔄, ⚫️ 🔜 🚶 &amp; 🔗 ⏮️ 🔢 💽.

👈 💪 ⚠ 🚚 "⌛".

✋️ 🇸🇲 🚫 ✔️ 🔗 ⚙️ `await` 🔗, 🔜 ⏮️ 🕳 💖:

```Python
user = await db.query(User).first()
```

...&amp; ↩️ 👥 ⚙️:

```Python
user = db.query(User).first()
```

⤴️ 👥 🔜 📣 *➡ 🛠️ 🔢* &amp; 🔗 🍵 `async def`, ⏮️ 😐 `def`,:

```Python hl_lines="2"
@app.get("/users/{user_id}", response_model=schemas.User)
def read_user(user_id: int, db: Session = Depends(get_db)):
    db_user = crud.get_user(db, user_id=user_id)
    ...
```

!!! info
    🚥 👆 💪 🔗 👆 🔗 💽 🔁, 👀 [🔁 🗄 (🔗) 💽](../advanced/async-sql-databases.md){.internal-link target=_blank}.

!!! note "📶 📡 ℹ"
    🚥 👆 😟 &amp; ✔️ ⏬ 📡 💡, 👆 💪 ✅ 📶 📡 ℹ ❔ 👉 `async def` 🆚 `def` 🍵 [🔁](../async.md#i_2){.internal-link target=_blank} 🩺.

## 🛠️

↩️ 👥 ⚙️ 🇸🇲 🔗 &amp; 👥 🚫 🚚 🙆 😇 🔌-⚫️ 👷 ⏮️ **FastAPI**, 👥 💪 🛠️ 💽 <abbr title="Automatically updating the database to have any new column we define in our models.">🛠️</abbr> ⏮️ <a href="https://alembic.sqlalchemy.org" class="external-link" target="_blank">⚗</a> 🔗.

&amp; 📟 🔗 🇸🇲 &amp; 🇸🇲 🏷 🖖 🎏 🔬 📁, 👆 🔜 💪 🎭 🛠️ ⏮️ ⚗ 🍵 ✔️ ❎ FastAPI, Pydantic, ⚖️ 🕳 🙆.

🎏 🌌, 👆 🔜 💪 ⚙️ 🎏 🇸🇲 🏷 &amp; 🚙 🎏 🍕 👆 📟 👈 🚫 🔗 **FastAPI**.

🖼, 🖥 📋 👨‍🏭 ⏮️ <a href="https://docs.celeryq.dev" class="external-link" target="_blank">🥒</a>, <a href="https://python-rq.org/" class="external-link" target="_blank">🅿</a>, ⚖️ <a href="https://arq-docs.helpmanual.io/" class="external-link" target="_blank">📶</a>.

## 📄 🌐 📁

 💭 👆 🔜 ✔️ 📁 📛 `my_super_project` 👈 🔌 🎧-📁 🤙 `sql_app`.

`sql_app` 🔜 ✔️ 📄 📁:

* `sql_app/__init__.py`: 🛁 📁.

* `sql_app/database.py`:

```Python
{!../../../docs_src/sql_databases/sql_app/database.py!}
```

* `sql_app/models.py`:

```Python
{!../../../docs_src/sql_databases/sql_app/models.py!}
```

* `sql_app/schemas.py`:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python
    {!> ../../../docs_src/sql_databases/sql_app/schemas.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python
    {!> ../../../docs_src/sql_databases/sql_app_py39/schemas.py!}
    ```

=== "🐍 3️⃣.1️⃣0️⃣ &amp; 🔛"

    ```Python
    {!> ../../../docs_src/sql_databases/sql_app_py310/schemas.py!}
    ```

* `sql_app/crud.py`:

```Python
{!../../../docs_src/sql_databases/sql_app/crud.py!}
```

* `sql_app/main.py`:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python
    {!> ../../../docs_src/sql_databases/sql_app/main.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python
    {!> ../../../docs_src/sql_databases/sql_app_py39/main.py!}
    ```

## ✅ ⚫️

👆 💪 📁 👉 📟 &amp; ⚙️ ⚫️.

!!! info

    👐, 📟 🎦 📥 🍕 💯. 🌅 📟 👉 🩺.

⤴️ 👆 💪 🏃 ⚫️ ⏮️ Uvicorn:


<div class="termy">

```console
$ uvicorn sql_app.main:app --reload

<span style="color: green;">INFO</span>:     Uvicorn running on http://127.0.0.1:8000 (Press CTRL+C to quit)
```

</div>

&amp; ⤴️, 👆 💪 📂 👆 🖥 <a href="http://127.0.0.1:8000/docs" class="external-link" target="_blank">http://127.0.0.1:8000/docs</a>.

&amp; 👆 🔜 💪 🔗 ⏮️ 👆 **FastAPI** 🈸, 👂 📊 ⚪️➡️ 🎰 💽:

<img src="/img/tutorial/sql-databases/image01.png">

## 🔗 ⏮️ 💽 🔗

🚥 👆 💚 🔬 🗄 💽 (📁) 🔗, ➡ FastAPI, ℹ 🚮 🎚, 🚮 🏓, 🏓, ⏺, 🔀 📊, ♒️. 👆 💪 ⚙️ <a href="https://sqlitebrowser.org/" class="external-link" target="_blank">💽 🖥 🗄</a>.

⚫️ 🔜 👀 💖 👉:

<img src="/img/tutorial/sql-databases/image02.png">

👆 💪 ⚙️ 💳 🗄 🖥 💖 <a href="https://inloop.github.io/sqlite-viewer/" class="external-link" target="_blank">🗄 📋</a> ⚖️ <a href="https://extendsclass.com/sqlite-browser.html" class="external-link" target="_blank">ExtendsClass</a>.

## 🎛 💽 🎉 ⏮️ 🛠️

🚥 👆 💪 🚫 ⚙️ 🔗 ⏮️ `yield` - 🖼, 🚥 👆 🚫 ⚙️ **🐍 3️⃣.7️⃣** &amp; 💪 🚫 ❎ "🐛" 🤔 🔛 **🐍 3️⃣.6️⃣** - 👆 💪 ⚒ 🆙 🎉 "🛠️" 🎏 🌌.

"🛠️" 🌖 🔢 👈 🕧 🛠️ 🔠 📨, ⏮️ 📟 🛠️ ⏭, &amp; 📟 🛠️ ⏮️ 🔗 🔢.

### ✍ 🛠️

🛠️ 👥 🔜 🚮 (🔢) 🔜 ✍ 🆕 🇸🇲 `SessionLocal` 🔠 📨, 🚮 ⚫️ 📨 &amp; ⤴️ 🔐 ⚫️ 🕐 📨 🏁.

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="14-22"
    {!> ../../../docs_src/sql_databases/sql_app/alt_main.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="12-20"
    {!> ../../../docs_src/sql_databases/sql_app_py39/alt_main.py!}
    ```

!!! info
    👥 🚮 🏗 `SessionLocal()` &amp; 🚚 📨 `try` 🍫.

     &amp; ⤴️ 👥 🔐 ⚫️ `finally` 🍫.

    👉 🌌 👥 ⚒ 💭 💽 🎉 🕧 📪 ⏮️ 📨. 🚥 📤 ⚠ ⏪ 🏭 📨.

### 🔃 `request.state`

`request.state` 🏠 🔠 `Request` 🎚. ⚫️ 📤 🏪 ❌ 🎚 📎 📨 ⚫️, 💖 💽 🎉 👉 💼. 👆 💪 ✍ 🌅 🔃 ⚫️ <a href="https://www.starlette.io/requests/#other-state" class="external-link" target="_blank">💃 🩺 🔃 `Request` 🇵🇸</a>.

👥 👉 💼, ⚫️ ℹ 👥 🚚 👁 💽 🎉 ⚙️ 🔘 🌐 📨, &amp; ⤴️ 🔐 ⏮️ (🛠️).

### 🔗 ⏮️ `yield` ⚖️ 🛠️

❎ **🛠️** 📥 🎏 ⚫️❔ 🔗 ⏮️ `yield` 🔨, ⏮️ 🔺:

* ⚫️ 🚚 🌖 📟 &amp; 👄 🌅 🏗.
* 🛠️ ✔️ `async` 🔢.
    * 🚥 📤 📟 ⚫️ 👈 ✔️ "⌛" 🕸, ⚫️ 💪 "🍫" 👆 🈸 📤 &amp; 📉 🎭 🍖.
    * 👐 ⚫️ 🎲 🚫 📶 ⚠ 📥 ⏮️ 🌌 `SQLAlchemy` 👷.
    * ✋️ 🚥 👆 🚮 🌖 📟 🛠️ 👈 ✔️ 📚 <abbr title="input and output">👤/🅾</abbr> ⌛, ⚫️ 💪 ⤴️ ⚠.
* 🛠️ 🏃 *🔠* 📨.
    * , 🔗 🔜 ✍ 🔠 📨.
    * 🕐❔ *➡ 🛠️* 👈 🍵 👈 📨 🚫 💪 💽.

!!! tip
    ⚫️ 🎲 👍 ⚙️ 🔗 ⏮️ `yield` 🕐❔ 👫 🥃 ⚙️ 💼.

!!! info
    🔗 ⏮️ `yield` 🚮 ⏳ **FastAPI**.

    ⏮️ ⏬ 👉 🔰 🕴 ✔️ 🖼 ⏮️ 🛠️ &amp; 📤 🎲 📚 🈸 ⚙️ 🛠️ 💽 🎉 🧾.
