/* ============================================================================
 * Freetype GL - A C OpenGL Freetype engine
 * Platform:    Any
 * WWW:         http://code.google.com/p/freetype-gl/
 * ----------------------------------------------------------------------------
 * Copyright 2011,2012 Nicolas P. Rougier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY NICOLAS P. ROUGIER ''AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL NICOLAS P. ROUGIER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of Nicolas P. Rougier.
 * ===============================================================================
 */
#include <stddef.h>
#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
  wchar_t charcode;
  float kerning;
} kerning_t;

typedef struct {
  wchar_t charcode;
  int width, height;
  int offset_x, offset_y;
  float advance_x, advance_y;
  float s0, t0, s1, t1;
  size_t kerning_count;
  kerning_t kerning[1];
} texture_glyph_t;

typedef struct {
  size_t tex_width;
  size_t tex_height;
  size_t tex_depth;
  unsigned char tex_data[65536];
  float size;
  float height;
  float linegap;
  float ascender;
  float descender;
  size_t glyphs_count;
  texture_glyph_t glyphs[96];
} texture_font_t;

texture_font_t font_data = {
    256, 256, 1,
    {0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 0,   0,   3,   158, 247, 255, 255, 255, 255, 213, 49,  0,
     3,   158, 242, 177, 13,  0,   0,   0,   0,   49,  213, 235, 98,  0,   0,   0,   0,   0,   0,   3,   158, 242, 177, 13,  0,   0,   0,   0,   49,  213, 235, 98,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   95,  234, 212, 46,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  197, 253, 255, 255, 255, 250, 179, 14,  0,   0,   0,   0,   0,   0,   0,   0,
     15,  179, 241, 158, 3,   0,   0,   0,   0,   34,  153, 224, 249, 229, 165, 49,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   98,  235, 213, 49,  0,   0,   0,   0,   1,
     91,  190, 239, 235, 101, 0,   0,   3,   158, 244, 231, 167, 52,  0,   0,   0,   0,   0,   0,   0,   0,   3,   158, 242, 179, 11,  0,   0,   0,   0,   48,  214, 235, 98,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 235, 214, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   163, 247, 255, 255, 255, 255, 215, 53,  0,   0,   49,  101, 104, 104,
     104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 95,  25,  0,   0,   4,   160, 247, 255, 255, 255, 255, 214, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 0,   0,   101, 255, 255, 255, 255, 255, 255, 255, 208, 0,   101, 255, 255, 255, 132, 0,   0,   0,   0,   209, 255, 255, 251, 29,  0,   0,   0,
     0,   0,   101, 255, 255, 255, 132, 0,   0,   0,   0,   209, 255, 255, 251, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  250, 255, 255, 205, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   173, 255, 255, 255, 255, 255, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   137, 255, 255, 255, 99,  0,   0,   0,   91,  248, 255, 255, 255, 255, 255, 253, 118,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  251, 255, 255, 208, 0,   0,   0,   14,  184, 255, 255, 255, 255, 252, 33,  0,   99,  255, 255, 255, 255, 254, 124, 0,   0,   0,
     0,   0,   0,   0,   101, 255, 255, 255, 116, 0,   0,   0,   0,   192, 255, 255, 251, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  252, 255, 255, 209, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   107, 255, 255, 255, 255, 255, 255, 255, 214, 0,   92,  253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 237, 33,
     0,   102, 255, 255, 255, 255, 255, 255, 255, 210, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 0,   0,   146, 255, 255, 255, 255,
     255, 255, 255, 254, 0,   146, 255, 255, 255, 178, 0,   0,   0,   0,   254, 255, 255, 255, 70,  0,   0,   0,   0,   0,   146, 255, 255, 255, 178, 0,   0,   0,   0,   254, 255, 255, 255, 70,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   69,  255, 255, 255, 253, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   218, 255, 255, 255, 255, 255, 255, 255, 182, 0,   0,   0,
     0,   0,   0,   0,   0,   182, 255, 255, 255, 142, 0,   0,   81,  254, 255, 255, 255, 255, 255, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   70,  255, 255, 255, 254,
     0,   0,   4,   191, 255, 255, 255, 255, 255, 255, 58,  0,   127, 255, 255, 255, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   133, 255, 255, 255, 230, 7,   0,   0,   57,  255, 255, 255, 255,
     56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   70,  255, 255, 255, 254, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   147, 255, 255, 255, 255, 255, 255, 255, 255, 0,
     203, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 126, 0,   146, 255, 255, 255, 255, 255, 255, 255, 254, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   255, 255, 255,
     255, 72,  0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   17,  239, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 251, 38,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   114, 255, 255, 255, 255, 255, 255, 197, 4,   0,   34,  238, 255, 255, 255,
     255, 255, 252, 43,  0,   0,   0,   0,   0,   44,  250, 255, 255, 255, 103, 0,   0,   178, 255, 255, 255, 212, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255,
     255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 100, 0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   255,
     255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  72,  99,  104, 146, 255, 255, 255, 255, 104, 104, 104, 104, 104, 104, 95,  25,  0,   0,   220, 255, 255, 255, 255, 255, 255,
     255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   117, 255, 255, 255, 255, 198, 118, 181, 255, 255, 255, 255, 151, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     72,  255, 255, 255, 255, 0,   1,   229, 255, 255, 255, 250, 146, 85,  7,   0,   0,   0,   26,  100, 178, 255, 255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   153, 255, 255, 255, 221, 3,   44,
     254, 255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255,
     255, 255, 255, 255, 0,   33,  200, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 160, 4,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   148, 255, 255, 255, 180, 0,   0,
     0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   6,   132, 246, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 35,  0,   220, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   190, 255, 255, 255, 144, 0,   186,
     255, 255, 255, 202, 3,   0,   0,   172, 255, 255, 255, 221, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   41,  255, 255, 255, 255, 94,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   166, 255, 255, 255, 224, 0,   0,   0,   0,   0,   0,   29,  249, 255, 255, 255, 90,  164, 255, 255, 255, 202, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   146, 255, 255, 255, 178, 0,   0,   0,   0,   254, 255, 255, 255, 70,  0,   0,   0,   0,   0,   148, 255, 255, 255, 180,
     0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   10,  191, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 130, 0,   218, 255,
     255, 255, 255, 255, 255, 255, 182, 0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 255, 255, 140, 0,   213, 255, 255, 255, 118, 0,   0,   0,   83,  255, 255, 255, 249, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   70,  255, 255, 255, 254, 0,   67,  255, 255, 255, 255, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,  255, 255, 255, 250, 0,   0,   0,   0,   0,   0,   0,   149,
     255, 255, 255, 221, 251, 255, 255, 255, 74,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     148, 255, 255, 255, 255, 255, 255, 255, 249, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  181, 242, 158, 3,   0,   146, 255, 255, 255, 255, 255,
     255, 255, 254, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   101, 255,
     255, 255, 133, 0,   0,   0,   0,   209, 255, 255, 251, 29,  0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   164, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 102, 0,   173, 255, 255, 255, 255, 255, 255, 255, 137, 0,   0,   0,   0,   0,   0,   102, 255, 255, 255,
     255, 255, 81,  0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  251, 255, 255, 209, 0,   72,  255, 255, 255, 255, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   27,  247, 255, 255, 255, 255, 255, 255, 201, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 175, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 255, 98,  0,   101, 255, 255, 255, 255, 255, 255, 255, 209, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   4,   160, 242, 179, 14,  0,   0,   0,   0,   51,  214, 235, 100, 0,   0,   0,   0,   0,   0,
     148, 255, 255, 255, 180, 0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247,
     160, 4,   0,   31,  199, 253, 255, 255, 255, 251, 181, 16,  0,   0,   0,   0,   0,   94,  254, 255, 255, 255, 255, 148, 0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 235, 214, 51,  0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,
     0,   0,   0,   0,   0,   145, 255, 255, 255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 206, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 142, 0,   4,
     160, 247, 255, 255, 255, 255, 214, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255,
     255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  200, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 160,
     4,   0,   152, 255, 255, 255, 252, 98,  9,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   86,
     252, 255, 255, 255, 255, 154, 1,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,
     255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   33,  200, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     247, 160, 4,   0,   32,  198, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 158, 3,   0,   148, 255, 255, 255, 255, 255, 207, 18,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   111, 236, 212, 48,  0,   0,   0,   0,   0,
     0,   177, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   202, 255, 255, 255, 156, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  251, 255, 255, 255, 255, 160, 1,   0,   0,   0,   220, 255, 255, 255, 180, 4,   0,   0,
     148, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255,
     255, 255, 0,   177, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   175, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 99,  0,   147, 255, 255, 255, 255, 208, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255,
     255, 255, 144, 0,   0,   0,   0,   37,  155, 225, 251, 255, 255, 255, 255, 255, 255, 255, 255, 246, 209, 124, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255,
     255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   120, 255, 255, 255, 206, 0,   0,   0,   0,   0,   0,   203, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 126, 0,   213, 255, 255, 255, 121, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   72,  249, 255, 255, 255, 255, 165, 2,   0,   0,   0,   0,   205, 255, 255, 255, 255, 164, 2,   130, 255, 255, 255, 255, 241, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   203, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 126, 0,   203, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 126, 0,   106, 255, 255, 255, 209, 20,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   197, 255, 255, 255, 144, 0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 224, 43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   111, 255, 255, 255, 255, 250,
     0,   0,   0,   0,   0,   0,   94,  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 34,  0,   187, 255, 255, 255, 203, 3,   0,   0,   72,  255,
     255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   66,  247, 255, 255, 255, 255, 170, 3,   0,   0,   0,   0,   0,   106, 255, 255,
     255, 255, 255, 202, 255, 255, 255, 255, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   72,  255, 255, 255, 255, 0,   94,  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 34,  0,   94,  254, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 34,  0,   5,   163, 243, 181, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   132, 255, 255, 255, 255, 140, 0,   0,   88,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   103, 255, 255, 255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   50,  102, 104, 191, 255, 255, 255, 210, 104, 104,
     104, 104, 255, 255, 255, 255, 146, 104, 95,  25,  0,   0,   119, 255, 255, 255, 255, 198, 112, 104, 146, 255, 255, 255, 255, 104, 104, 94,  59,  3,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   60,  244, 255, 255, 255, 255, 175, 4,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 3,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   50,  102, 104, 104, 104, 104, 174, 255,
     255, 255, 255, 255, 255, 131, 104, 104, 104, 104, 95,  25,  0,   0,   0,   50,  102, 104, 104, 104, 104, 104, 146, 255, 255, 255, 255, 104, 104, 104, 104, 104, 104, 95,  25,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   123, 255, 255, 255, 255, 255, 84,  0,   20,  241, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 183, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   94,  254, 255,
     255, 255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   18,  240, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230, 97,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   54,  241, 255, 255, 255, 255, 180, 6,   0,   0,   0,   0,   0,
     0,   0,   0,   1,   156, 255, 255, 255, 255, 255, 255, 255, 173, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   3,   219, 255, 255, 255, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   113, 255, 255, 255, 255, 255, 156, 0,   0,   122, 255, 255, 255, 255, 196, 112, 104, 104, 104, 104, 104, 104, 104, 104, 123, 229, 255, 255, 255, 255, 44,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   146, 255, 255, 255, 255, 255, 255, 255, 254, 0,   53,  252, 255, 255, 255, 255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255,
     255, 255, 180, 0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   85,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   49,  238, 255, 255, 255, 255, 185, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   184, 255, 255, 255, 255, 255, 195, 5,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,
     0,   0,   97,  255, 255, 255, 253, 255, 255, 255, 248, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 255, 255, 162, 2,   0,   0,   189, 255, 255,
     255, 199, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  245, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   101, 255, 255, 255, 255, 255, 255, 255, 209,
     0,   134, 255, 255, 255, 255, 255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,
     0,   0,   95,  249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,   43,  235, 255, 255, 255, 255, 189, 9,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  244, 255, 255, 255, 255, 255, 248, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255,
     255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   4,   221, 255, 255, 255, 140, 211, 255, 255, 255, 151, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   95,  254, 255, 255, 255, 255, 168, 3,   0,   0,   0,   215, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   211, 255, 255,
     255, 138, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   160, 247, 255, 255, 255, 255, 214, 51,  0,   89,  255, 255, 255, 223, 255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   36,  154, 225, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 241, 16,  0,   0,   0,   0,   0,   0,   38,  231, 255, 255, 255, 255, 194, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,  242, 255, 255, 255, 255, 255, 255, 255,
     248, 73,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255,
     0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 248, 25,  91,  255, 255, 255, 249, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   87,  253, 255, 255, 255, 255, 174, 4,   0,   0,
     0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   164, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   1,   128, 210, 147, 84,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   33,  200, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 247, 160, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   17,  140, 255, 255, 255, 255, 90,  0,   0,   0,   0,   0,   34,  227, 255, 255, 255, 255, 198,
     12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   47,  241, 255, 255, 255, 255, 251, 255, 255, 255, 255, 248, 74,  0,   0,   0,   0,   24,  184, 242, 162, 5,   0,   0,   0,   0,   0,
     0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   9,   224, 255, 255, 255, 152, 0,   3,   222, 255, 255, 255,
     157, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   79,  251, 255, 255, 255, 255, 180, 5,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   8,
     178, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,
     0,   0,   0,   0,   177, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255,
     255, 0,   0,   0,   0,   214, 255, 255, 255, 131, 0,   0,   0,   0,   29,  223, 255, 255, 255, 255, 202, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   186, 255, 255, 255, 255,
     219, 36,  190, 255, 255, 255, 255, 248, 70,  0,   0,   24,  215, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   110, 255, 255, 255, 252, 33,  0,   0,   105, 255, 255, 255, 254, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   71,  255,
     255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   71,  249, 255, 255, 255, 255, 185,
     7,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   13,  192, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   203, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 126, 0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   214, 255, 255, 255, 131, 0,   0,   0,   25,  219, 255, 255,
     255, 255, 206, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   219, 255, 255, 255, 224, 30,  0,   10,  191, 255, 255, 255, 255, 246, 66,  23,  214, 255, 255, 255, 255, 127,
     0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   130, 255, 255, 255, 164, 0,   0,
     0,   8,   232, 255, 255, 255, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  253, 255, 255, 215, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   65,  246, 255, 255, 255, 255, 190, 9,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,
     0,   0,   20,  204, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255,
     255, 255, 252, 0,   0,   0,   0,   0,   0,   94,  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 34,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   72,  255, 255, 255, 255, 0,   0,   17,  139, 255, 255, 255, 255, 90,  0,   0,   21,  214, 255, 255, 255, 255, 210, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     220, 255, 255, 255, 109, 0,   0,   0,   10,  192, 255, 255, 255, 255, 245, 218, 255, 255, 255, 255, 230, 25,  0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   34,  238, 255, 246, 43,  0,   0,   0,   0,   110, 255, 255, 193, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   106, 236, 216, 55,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   58,  243, 255, 255,
     255, 255, 196, 11,  0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   28,  214, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   4,   160, 247, 255, 255, 255, 255, 214, 51,  0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   50,  102, 104, 191, 255, 255, 255,
     210, 104, 104, 104, 104, 255, 255, 255, 255, 146, 104, 95,  25,  0,   0,   33,  200, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 241, 16,  0,   17,
     209, 255, 255, 255, 255, 214, 22,  0,   0,   0,   0,   0,   51,  214, 255, 255, 255, 255, 247, 160, 4,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   10,  192, 255, 255, 255, 255, 255, 255,
     255, 255, 228, 38,  0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   26,
     90,  35,  0,   0,   0,   0,   0,   0,   61,  83,  6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   51,  240, 255, 255, 255, 255, 200, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108,
     0,   0,   0,   0,   0,   37,  224, 255, 255, 255, 255, 239, 221, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   102, 255, 255, 255, 255, 255, 255, 255, 210, 0,   0,
     0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   177, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 110, 0,   0,   157, 255, 255, 255, 255, 217, 24,  0,   0,   0,   0,   0,   0,   210, 255, 255, 255, 255,
     255, 255, 255, 102, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   11,  192, 255, 255, 255, 255, 255, 255, 225, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   37,  155, 225, 251, 255, 255, 255, 255, 255, 255, 255, 255, 246, 209, 124, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   46,
     237, 255, 255, 255, 255, 205, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   47,  233, 255, 255, 255, 255, 231, 46,  184, 255, 255, 255, 144,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   146, 255, 255, 255, 255, 255, 255, 255, 254, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   203, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     148, 0,   0,   0,   216, 255, 255, 255, 220, 27,  0,   0,   0,   0,   0,   0,   0,   254, 255, 255, 255, 255, 255, 255, 255, 146, 0,   216, 255, 255, 255, 115, 0,   0,   0,   0,   0,   0,   33,
     250, 255, 255, 255, 255, 255, 102, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   67,  255, 255, 255, 255, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,  255, 255, 255, 250, 0,   0,
     0,   0,   34,  153, 224, 251, 255, 255, 255, 255, 255, 255, 255, 255, 246, 208, 122, 10,  0,   0,   0,   0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 224, 43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  233, 255, 255, 255, 255, 209, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     220, 255, 255, 255, 108, 0,   0,   0,   59,  239, 255, 255, 255, 255, 223, 36,  0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255,
     255, 255, 255, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,
     0,   0,   0,   94,  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 231, 98,  0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,
     255, 255, 255, 255, 255, 255, 255, 255, 148, 0,   193, 255, 255, 255, 194, 1,   0,   0,   0,   0,   21,  212, 255, 255, 255, 255, 255, 255, 247, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     41,  255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   165, 255, 255, 255, 224, 0,   0,   0,   91,  248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     220, 38,  0,   0,   0,   0,   88,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   34,  229, 255, 255, 255, 255, 213, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   72,  245, 255, 255, 255, 255, 214, 27,  0,   0,
     184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   50,  102, 104, 104, 104, 104, 104, 146, 255, 255, 255, 255, 104,
     104, 95,  60,  3,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 255, 255, 255, 255, 148, 0,   128, 255, 255, 255, 255, 193, 111,
     104, 104, 104, 211, 255, 255, 255, 255, 255, 255, 255, 255, 243, 55,  0,   0,   0,   0,   0,   0,   0,   0,   1,   229, 255, 255, 255, 249, 145, 84,  6,   0,   0,   0,   25,  99,  176, 255, 255,
     255, 255, 156, 0,   0,   80,  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230, 25,  0,   0,   21,  242, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 183, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  224, 255, 255, 255, 255, 217, 24,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   86,  250, 255, 255, 255, 255, 202, 19,  0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148,
     255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   255, 255,
     255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,
     0,   0,   0,   0,   0,   255, 255, 255, 255, 255, 255, 255, 255, 148, 0,   25,  245, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 229, 212, 255, 255, 255, 255, 238, 31,  0,   0,
     0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 255, 255, 255, 195, 4,   0,   33,  237, 255, 255, 255, 255, 255, 253, 43,  0,   16,  238, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   124, 255, 255, 255, 255, 196, 112, 104, 104, 104, 104, 104, 104, 104, 104, 123, 229, 255, 255, 255, 255, 44,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   25,  219, 255, 255, 255, 255, 221, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 101, 253, 255, 255, 255, 255, 191,
     13,  0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   146, 255, 255, 255, 255, 255, 255, 255, 254, 0,   0,   0,   0,   0,   76,  255, 255, 255,
     252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   147, 255, 255, 255, 179, 0,   0,   0,   0,   255, 255, 255, 255, 71,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   69,
     255, 255, 255, 253, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   218, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   254, 255, 255, 255, 255, 255, 255, 255, 146, 0,   0,   96,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 43,  21,  212, 255, 255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   4,   191, 255, 255, 255, 255, 255, 255, 58,  0,   127,
     255, 255, 255, 255, 255, 255, 120, 0,   0,   116, 255, 255, 255, 255, 198, 113, 104, 104, 104, 104, 104, 104, 104, 104, 124, 231, 255, 255, 255, 255, 38,  0,   190, 255, 255, 255, 199, 3,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  246, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  213, 255, 255, 255, 255, 225, 31,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 205, 255, 255, 255, 255, 255, 177, 8,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   101, 255, 255, 255, 255, 255, 255, 255, 209, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   107, 255, 255, 255, 139, 0,
     0,   0,   0,   215, 255, 255, 253, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  250, 255, 255, 206, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255,
     255, 61,  0,   0,   0,   0,   0,   0,   0,   0,   209, 255, 255, 255, 255, 255, 255, 255, 101, 0,   0,   0,   104, 251, 255, 255, 255, 255, 255, 255, 255, 255, 242, 52,  0,   0,   22,  213, 255,
     255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  185, 255, 255, 255, 255, 252, 34,  0,   100, 255, 255, 255, 255, 254, 125, 0,   0,   0,   185, 255, 255, 255, 203, 3,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   35,  247, 255, 255, 255, 107, 0,   212, 255, 255, 255, 113, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   194, 255, 255, 255, 138, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   161, 255, 255, 255, 255, 228, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255,
     255, 255, 162, 4,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   160, 247, 255, 255, 255, 255, 214, 51,  0,   0,   0,   0,
     0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   165, 243, 183, 17,  0,   0,   0,   0,   55,  216, 236, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   98,  235, 213, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  200, 240, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   51,  214, 255, 255, 255, 255, 247,
     160, 4,   0,   0,   0,   0,   40,  157, 226, 252, 255, 255, 255, 255, 215, 57,  0,   0,   0,   0,   22,  182, 242, 160, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   91,  190, 240,
     236, 103, 0,   0,   4,   160, 245, 231, 167, 52,  0,   0,   0,   0,   212, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 255, 136, 0,   159, 255,
     255, 253, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   217, 255, 255, 255, 231, 38,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 146, 1,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   175, 255, 255,
     255, 59,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   17,  160, 200, 93,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255,
     255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255,
     255, 255, 255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   160, 247, 255, 255, 255, 255, 214, 51,
     0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   30,  197, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 158, 4,
     0,   0,   0,   0,   37,  155, 225, 251, 255, 255, 255, 255, 255, 255, 255, 255, 236, 100, 0,   0,   0,   0,   0,   0,   32,  198, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 247, 158, 3,   0,   0,   0,   0,   33,  153, 224, 251, 255, 255, 255, 255, 255, 255, 255, 255, 246, 208, 122, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   49,  213, 235, 98,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  203, 243, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255,
     255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255,
     255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 254, 111, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255,
     255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   102, 255, 255, 255, 255, 255, 255, 255, 209, 0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,
     173, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 102, 0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     252, 31,  0,   0,   0,   0,   0,   175, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 98,  0,   0,   0,   89,  247, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 38,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   209, 255, 255, 251, 29,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   46,  238, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   220, 255, 255, 255, 252, 95,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   146, 255, 255, 255,
     255, 255, 255, 255, 254, 0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   218, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 130, 0,   0,   88,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 54,  0,   0,   0,   0,   0,   203, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 142, 0,   0,   77,  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230, 25,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   254, 255, 255, 255, 70,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  233, 255, 255, 255, 255, 122, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   218, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   215, 255, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   193, 255, 255, 255, 138, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,
     0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 35,  0,   20,  241, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 196, 3,   0,   0,   0,   0,   0,   94,  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   15,  237, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 255, 137, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   35,  229, 255, 255, 255, 255, 231, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   175, 255, 255, 255, 63,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   189, 255, 255, 255, 198, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  245, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   26,  95,  104, 149, 255, 255, 255, 253, 104, 104, 84,  6,   0,   0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104,
     104, 104, 104, 104, 104, 104, 104, 95,  25,  0,   0,   122, 255, 255, 255, 255, 198, 113, 104, 104, 104, 104, 104, 104, 104, 104, 84,  7,   0,   0,   0,   0,   0,   0,   0,   50,  102, 104, 104,
     104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 213, 255, 255, 255, 144, 0,   114, 255, 255, 255, 255, 198, 113, 104, 104, 104, 104, 104, 104, 104, 104, 124, 231, 255, 255, 255, 255,
     38,  0,   0,   71,  111, 26,  0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   35,  247, 255, 255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  224, 255, 255, 255, 255, 234, 43,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   32,  199, 240, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   122, 255, 255, 255, 255, 194, 112, 104, 104,
     104, 104, 104, 104, 104, 104, 123, 228, 255, 255, 255, 255, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   35,  238, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 194, 3,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   189, 255, 255, 255, 203, 3,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144,
     0,   185, 255, 255, 255, 203, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  247, 255, 255, 255, 107, 0,   108, 255, 255, 231, 19,  0,   0,   0,   0,   0,   0,   0,   0,   255, 255,
     255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   84,  104, 104, 104, 104, 124, 230, 255, 255, 255, 255, 43,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   25,  219, 255, 255, 255, 255, 237, 47,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  242, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   146, 255, 255, 255, 255, 255, 255, 255, 254, 0,   0,   131, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 54,  0,   220, 255, 255, 255, 108, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   215, 255, 255, 255, 119, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   213, 255, 255, 255, 119, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   195, 255, 255, 255, 136, 0,   207, 255, 255, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   3,   194, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  213, 255, 255, 255, 255, 240, 51,  0,   0,
     0,   0,   0,   0,   0,   34,  153, 224, 251, 255, 255, 255, 255, 255, 255, 255, 255, 246, 209, 124, 11,  0,   0,   0,   0,   4,   160, 247, 255, 255, 255, 255, 214, 51,  0,   0,   88,  255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   102, 255, 255, 255, 255, 255, 255, 255, 209, 0,   0,
     104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 31,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220,
     255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,
     0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 32,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  208, 255, 255, 255, 255, 242, 56,  0,   0,   0,   0,   0,   0,   0,   91,  248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 224, 43,  0,   0,   0,   102, 255, 255, 255, 255, 255, 255, 255, 209, 0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 43,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   160, 247, 255, 255, 255, 255, 214, 51,  0,   0,   5,   163, 247, 255, 255, 255, 255, 255, 255, 255, 255, 236, 103, 0,   0,   220, 255,
     255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   31,  252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 49,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  201, 255, 255, 255, 255, 244,
     60,  0,   0,   0,   0,   0,   0,   0,   80,  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 29,  0,   0,   146, 255, 255, 255, 255, 255, 255, 255, 254,
     0,   0,   0,   0,   37,  155, 225, 252, 255, 255, 255, 255, 255, 255, 255, 255, 246, 210, 124, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108,
     0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   103, 236, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 218, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  194, 255, 255, 255, 255, 246, 65,  0,   0,   0,   0,   0,   0,   0,   16,  238, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 183, 0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   48,  239, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  149, 255, 255, 255, 255, 78,  0,   0,   0,   0,   0,   0,   0,   0,   7,   187, 255, 255,
     255, 255, 248, 70,  0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 255, 255, 198, 113, 104, 104, 104, 104, 104, 104, 104, 104, 124, 231, 255, 255, 255, 255, 44,  0,   148, 255, 255, 255,
     255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   58,  215, 235, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   43,  235, 255, 255, 255, 255, 122, 0,   214, 255, 255, 255, 119, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 255, 137, 0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   2,   221, 255, 255, 255, 127, 0,   0,   0,   0,   0,   0,   0,   5,   180, 255, 255, 255, 255, 249, 75,  0,   0,   0,   0,   0,   0,   0,   0,   0,   185, 255, 255, 255, 203,
     3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  247, 255, 255, 255, 112, 0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   58,  243, 255, 255, 252, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  231, 255, 255, 255, 255, 229, 21,  0,   186,
     255, 255, 255, 203, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  247, 255, 255, 255, 110, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255,
     72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   3,
     172, 255, 255, 255, 255, 251, 81,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   213, 255, 255, 255, 119, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 255, 138,
     0,   146, 255, 255, 255, 255, 255, 255, 255, 254, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  240, 255, 255, 255, 255, 55,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 168, 104, 104, 104, 104,
     104, 104, 104, 104, 104, 104, 94,  57,  2,   0,   0,   0,   0,   0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 95,  63,  6,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  226, 255, 255, 255, 255, 233, 41,  0,   0,   111, 255, 255, 255, 255, 197, 112, 104, 104, 104, 104, 104, 104, 104, 104, 124, 230, 255,
     255, 255, 255, 43,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   2,   164, 255, 255, 255, 255, 252, 86,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   102, 255, 255, 255, 255, 255, 255, 255, 209, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   46,  237, 255, 255, 255, 255, 202, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 227, 88,  0,   0,   0,   0,   220, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 118, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  221, 255, 255, 255, 255, 237,
     46,  0,   0,   0,   9,   219, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,
     0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   124, 164, 66,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,
     0,   0,   1,   155, 255, 255, 255, 255, 253, 93,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     184, 255, 255, 255, 144, 0,   4,   160, 247, 255, 255, 255, 255, 214, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   42,  234, 255, 255, 255, 255, 214, 22,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   218, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 132, 0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 182,
     6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  216, 255, 255, 255, 255, 240, 51,  0,   0,   0,   0,   0,   45,  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 236, 32,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255,
     255, 250, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   146, 255, 255, 255, 255, 254, 99,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   37,  231, 255, 255, 255, 255, 217, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   173, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 97,
     0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 145, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  210, 255, 255,
     255, 255, 243, 57,  0,   0,   0,   0,   0,   0,   173, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 49,  0,   0,   220, 255, 255, 255, 108, 0,   0,
     0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   211, 255, 255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   192, 255,
     255, 255, 140, 0,   0,   0,   137, 255, 255, 255, 255, 255, 105, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  227, 255, 255, 255, 255, 221, 27,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   160, 247, 255, 255, 255, 255, 214, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   31,  199, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235, 11,  0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 251, 26,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  204, 255, 255, 255, 255, 245, 62,  0,   0,   0,   0,   0,   0,   67,  255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 218, 6,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   193, 255, 255, 255, 194, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  243, 255, 255, 255, 116, 0,   0,   128, 255, 255, 255, 255, 255, 199, 104, 104, 104, 104, 104,
     104, 104, 104, 104, 104, 104, 95,  25,  0,   0,   214, 255, 255, 255, 119, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  223, 255, 255, 255, 255, 224, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   102, 255, 255,
     255, 255, 255, 255, 255, 210, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,
     149, 255, 255, 255, 255, 83,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  149, 255, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   12,
     197, 255, 255, 255, 255, 248, 68,  0,   0,   0,   0,   0,   0,   0,   159, 255, 255, 255, 249, 91,  8,   0,   0,   0,   0,   0,   0,   0,   0,   19,  149, 255, 255, 255, 255, 78,  0,   220, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 160, 4,   0,   0,   0,   0,   0,   130, 255, 255, 255, 255, 193, 111, 104, 104, 104, 104, 104, 104, 104,
     104, 122, 226, 255, 255, 255, 255, 52,  0,   96,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 237, 33,  0,   193, 255, 255, 255, 203, 3,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  219, 255, 255, 255, 255, 227, 34,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   146, 255, 255, 255, 255, 255, 255, 255, 254, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   221, 255, 255, 255, 128, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   2,   221, 255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   9,   190, 255, 255, 255, 255, 249, 75,  0,   0,   0,   0,   0,   0,   0,   0,   205, 255, 255,
     255, 147, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   221, 255, 255, 255, 127, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 103, 0,   0,   0,   0,   0,   26,  246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 194, 0,   0,   203, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 126, 0,   137, 255, 255, 255, 255, 197, 112, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 213, 255, 255, 255, 144, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  214, 255, 255, 255, 255, 230, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 143, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 143, 0,   0,   0,   0,   0,
     0,   0,   6,   183, 255, 255, 255, 255, 251, 81,  0,   0,   0,   0,   0,   0,   0,   0,   0,   219, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255,
     255, 143, 0,   203, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   99,  255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 37,  0,   0,   175, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   42,  253,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  209, 255, 255, 255,
     255, 233, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   4,   175, 255, 255, 255, 255, 253, 88,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   91,  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 238, 35,  0,   0,   0,   0,   0,   0,   0,   107, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 228, 50,  0,   0,   0,   32,  199, 253,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 160, 4,   0,   0,   136, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  204, 255, 255, 255, 255, 236, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144,
     0,   0,   0,   0,   0,   2,   167, 255, 255, 255, 255, 254, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   184, 255, 255, 255, 144, 0,   0,   49,  101, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 255, 255, 255, 255, 146, 104, 95,  25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   41,
     158, 226, 252, 255, 255, 255, 255, 255, 255, 255, 255, 246, 211, 127, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   1,   139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  198,
     255, 255, 255, 255, 238, 49,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   146, 255, 255, 255, 255, 255, 255, 255, 254, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   1,   159, 255, 255, 255, 255, 255, 103, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   33,  200, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 160, 4,   0,   0,   0,   0,   55,  166, 229, 252, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  193, 255, 255, 255, 255, 241, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   101, 255, 255, 255, 255, 255, 255, 255, 209, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   192, 255, 255, 255, 140, 0,   215, 255, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     192, 255, 255, 255, 140, 0,   0,   0,   0,   150, 255, 255, 255, 255, 255, 111, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 255, 115, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   192, 255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   4,   160, 242,
     181, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   177, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   5,   163, 247, 255, 255, 255, 255, 215,
     53,  0,   144, 255, 255, 255, 255, 243, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   160, 247, 255, 255,
     255, 255, 214, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  243,
     255, 255, 255, 116, 0,   189, 255, 255, 255, 194, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  243, 255, 255, 255, 116, 0,   0,   0,   141, 255, 255, 255, 255, 255, 119, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 194, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  243, 255, 255, 255, 116, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   103, 255, 255, 255, 207, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   203, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 126, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   107, 255, 255, 255, 255, 255, 255, 255, 214, 0,   208, 255, 255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   49,  101, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 122, 226, 255, 255, 255, 255, 52,  0,   122, 255, 255, 255, 255, 193, 112, 104, 104, 104, 104, 104,
     104, 104, 104, 122, 226, 255, 255, 255, 255, 52,  0,   0,   132, 255, 255, 255, 255, 255, 127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 255, 255, 255,
     193, 111, 104, 104, 104, 104, 104, 104, 104, 104, 122, 226, 255, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,
     0,   0,   132, 255, 255, 255, 255, 202, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  254, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   147, 255, 255,
     255, 255, 255, 255, 255, 255, 0,   144, 255, 255, 255, 255, 243, 57,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  155,
     225, 251, 255, 255, 255, 255, 255, 255, 255, 255, 246, 209, 124, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 193, 0,   0,   20,  242, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 193, 0,   0,   99,  255, 255, 255, 255, 255,
     136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 194, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   38,  244, 255, 255, 255, 255, 196, 11,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   50,  102, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 95,  25,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   10,  193, 255, 255, 255, 255, 240, 52,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 43,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   203, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 37,  0,   0,   0,   88,  255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 37,  0,   0,   204, 255, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   99,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255,
     255, 71,  0,   0,   0,   0,   0,   0,   66,  246, 255, 255, 255, 255, 190, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255,
     144, 0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   12,  199, 255, 255, 255, 255, 238, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   88,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 228, 50,  0,   0,   0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 228, 50,  0,   0,   0,   175,
     255, 255, 255, 151, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   107, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 228, 50,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   215, 255, 255, 253, 33,  0,   0,   0,   0,   0,   0,   0,   71,  248, 255, 255, 255, 255, 184, 7,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 0,   0,   0,   15,  204, 255,
     255, 255, 255, 235, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  242, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 183, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  200, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 211, 127, 14,  0,   0,   0,   0,   0,   0,
     0,   37,  155, 225, 252, 255, 255, 255, 255, 255, 255, 255, 255, 246, 211, 127, 14,  0,   0,   0,   0,   32,  199, 240, 136, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   41,  158, 226, 252, 255, 255, 255, 255, 255, 255, 255, 255, 246, 211, 127, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   55,  216, 236, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  249, 255, 255, 255, 255, 178, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   192, 255, 255, 255, 138, 0,   148, 255, 255, 255, 255, 255, 255, 255, 249, 0,   0,   0,   0,   18,  209, 255, 255, 255, 255, 232, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   123, 255, 255, 255, 255, 196, 112, 104, 104, 104, 104, 104, 104, 104, 104, 123, 229, 255, 255, 255, 255, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,
     251, 255, 255, 255, 255, 171, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  243, 255, 255, 255, 112, 0,   148, 255, 255, 255, 255, 255, 255, 255, 175, 0,
     0,   0,   0,   0,   22,  214, 255, 255, 255, 255, 229, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   190, 255, 255, 255, 199, 3,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   33,  246, 255, 255, 255, 112, 0,   0,   0,   0,   37,  155, 225, 251, 255, 255, 255, 255, 255, 255, 255, 255, 246, 208, 122, 10,  0,   0,   0,   0,   0,   0,   0,   37,  155,
     225, 251, 255, 255, 255, 255, 255, 255, 255, 255, 246, 209, 124, 11,  0,   0,   0,   0,   31,  198, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 208, 122, 10,  0,   0,
     0,   0,   0,   0,   0,   37,  155, 225, 251, 255, 255, 255, 255, 255, 255, 255, 255, 246, 209, 124, 11,  0,   0,   0,   0,   31,  198, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 246, 209, 124, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   86,  252, 255, 255, 255, 255, 165, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   33,  200, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 160, 4,   0,   0,   49,  101, 104, 104, 104, 104, 104, 104, 104, 104,
     104, 104, 104, 104, 122, 226, 255, 255, 255, 255, 44,  0,   148, 255, 255, 255, 255, 255, 255, 206, 18,  0,   0,   0,   0,   0,   0,   25,  219, 255, 255, 255, 255, 226, 32,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   212, 255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   194, 255, 255, 255, 138, 0,   0,   0,   97,  249, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 38,  0,   0,   0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 43,  0,   0,
     0,   175, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 38,  0,   0,   0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 224, 43,  0,   0,   0,   175, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   92,  253, 255, 255, 255, 255, 158, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   177, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   92,  253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   148, 255, 255, 255, 255,
     255, 207, 18,  0,   0,   0,   0,   0,   0,   0,   0,   29,  223, 255, 255, 255, 255, 223, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   161, 255, 255, 254, 49,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   88,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230, 26,  0,   0,
     0,   88,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 29,  0,   0,   218, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 230, 25,  0,   0,   0,   88,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 30,  0,   0,   218, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   97,  254, 255, 255, 255, 255, 150, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   203, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 126, 0,   203, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 30,  0,   0,   147, 255, 255, 255, 255, 208, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  227, 255, 255, 255,
     255, 219, 26,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  164, 204, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   20,
     241, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 177, 0,   0,   20,  241, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 183, 0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   20,  241, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 185, 0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 183, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   103, 255, 255, 255, 255, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  254, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 34,  0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 43,  0,   0,   0,
     106, 255, 255, 255, 209, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  231, 255, 255, 255, 255, 216, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   122, 255, 255, 255, 255, 196, 112, 104, 104, 104, 104, 104, 104, 104, 104, 124, 231, 255,
     255, 255, 255, 40,  0,   122, 255, 255, 255, 255, 198, 113, 104, 104, 104, 104, 104, 104, 104, 104, 124, 231, 255, 255, 255, 255, 44,  0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104,
     104, 104, 104, 104, 124, 231, 255, 255, 255, 255, 38,  0,   122, 255, 255, 255, 255, 196, 112, 104, 104, 104, 104, 104, 104, 104, 104, 123, 229, 255, 255, 255, 255, 45,  0,   220, 255, 255, 255,
     168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 123, 229, 255, 255, 255, 255, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   109, 255, 255,
     255, 255, 255, 134, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   50,  102, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 95,  25,  0,   0,   33,
     200, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 210, 124, 12,  0,   0,   0,   0,   5,   163, 243, 181, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   42,  234, 255, 255, 255, 255, 211, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   43,  237, 255,
     255, 255, 144, 0,   189, 255, 255, 255, 199, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  247, 255, 255, 255, 109, 0,   189, 255, 255, 255, 203, 3,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   35,  247, 255, 255, 255, 112, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  247, 255, 255, 255, 107, 0,   189, 255, 255, 255, 199,
     3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  245, 255, 255, 255, 112, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  245, 255, 255, 255,
     112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   115, 255, 255, 255, 255, 255, 127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   47,  237, 255, 255, 255, 255, 200, 3,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  231, 255, 255, 255, 255, 122, 0,   215, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   195, 255, 255, 255, 137, 0,   215, 255, 255, 255, 119, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 255, 138, 0,   220, 255, 255, 255, 108, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 255, 136, 0,   215, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   190, 255, 255, 255, 135,
     0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 138, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   122, 255, 255, 255, 255, 255, 67,  0,   31,  198, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 158, 4,   0,   31,  198, 253, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 158, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  241, 255, 255, 255, 255, 55,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     31,  225, 255, 255, 255, 255, 231, 23,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   123, 255, 255, 255, 85,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   190, 255, 255, 255, 255, 131, 0,   175, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 102, 0,   175, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     102, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   58,  243, 255, 255, 252, 30,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  220, 255, 255, 255, 255, 235, 43,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220,
     255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     7,   145, 206, 124, 0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   121, 255, 255, 255, 255, 255, 68,  0,   218, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 130,
     0,   218, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   58,  215, 235, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   21,  214, 255, 255, 255, 255, 238, 48,  0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   1,   90,  190, 238, 255, 255, 255, 255, 255, 255, 144, 0,   220, 255,
     255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184,
     255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 255, 255, 127, 0,   0,
     220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 35,  0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 238, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  207, 255, 255, 255, 255, 241, 54,  0,   0,   0,   0,   220, 255, 255,
     255, 108, 0,   0,   0,   0,   0,   13,  183, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255,
     255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 255, 255, 255, 135, 0,   0,   0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
     104, 104, 95,  25,  0,   0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 95,  25,  0,   0,   0,   0,   0,   37,  155, 225, 251, 255, 255, 255,
     255, 255, 255, 255, 255, 246, 208, 122, 10,  0,   0,   0,   0,   4,   160, 247, 255, 255, 255, 255, 255, 255, 255, 255, 236, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   12,  200, 255, 255, 255, 255, 244, 60,  0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   3,   188, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   195, 255, 255, 255, 137, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   102, 254, 255, 255, 255, 255,
     143, 0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 38,  0,   0,   0,   103, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 252, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   192, 255, 255, 255, 255, 246, 66,  0,   0,   0,   0,
     0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   111, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  247, 255, 255, 255, 110, 0,   220, 255, 255, 255, 108, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   96,  254, 255, 255, 255, 255, 150, 0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230, 25,  0,   0,   131, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 54,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 255, 249, 72,  0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   227, 255, 255, 255, 251, 147,
     125, 232, 255, 255, 255, 255, 144, 0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 213, 255, 255, 255, 144, 0,   220, 255, 255, 255, 168, 104, 104, 104,
     104, 104, 104, 104, 104, 104, 104, 124, 230, 255, 255, 255, 255, 43,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220,
     255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   89,  253, 255,
     255, 255, 255, 158, 1,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  241, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,
     0,   36,  240, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 196, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   48,  255, 255, 255, 255, 251, 79,  0,
     0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   40,  255, 255, 255, 255, 101, 0,   0,   37,  248, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   220, 255,
     255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184,
     255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  252, 255, 255, 255, 255, 165, 2,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     122, 255, 255, 255, 255, 196, 112, 104, 104, 104, 104, 104, 104, 104, 104, 124, 231, 255, 255, 255, 255, 39,  0,   0,   27,  95,  104, 149, 255, 255, 255, 253, 104, 104, 84,  7,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   42,  255, 255, 255, 252, 86,  0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   65,  255,
     255, 255, 255, 13,  0,   0,   0,   198, 255, 255, 255, 142, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   220, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 32,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     78,  250, 255, 255, 255, 255, 172, 3,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220,
     255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   189, 255, 255, 255, 199, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,
     247, 255, 255, 255, 108, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   141, 255,
     245, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   54,  255, 255, 255, 255, 49,  0,   0,   5,   228, 255, 255, 255, 124, 0,   220, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238,
     49,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   73,  249, 255, 255, 255, 255, 178, 5,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255,
     255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   215, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 135, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108,
     0,   0,   0,   11,  248, 255, 255, 255, 206, 42,  20,  157, 255, 255, 255, 255, 73,  0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 218, 6,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   68,  247, 255, 255, 255, 255, 184, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   135, 255, 255, 255, 98,  0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   164, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 227, 7,
     0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     19,  149, 255, 255, 255, 255, 78,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   63,  245, 255, 255, 255, 255, 190, 9,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  183, 246, 162, 4,   0,   0,   0,   0,   0,   76,  255,
     255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   32,  239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 85,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   221, 255, 255, 255, 127, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   37,  243, 255, 255, 255, 255, 196, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104,
     104, 84,  6,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 84,  6,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   66,  243, 255, 255, 255, 255, 255,
     255, 255, 125, 0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 143, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255,
     255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 255, 255, 202, 14,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 194, 3,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 194, 3,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   83,  62,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   45,  195, 255, 255, 255, 255, 226, 85,  0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255,
     108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255,
     255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   103, 255, 255, 255, 207, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 54,  0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 54,  0,   0,   0,   0,   0,   220, 255,
     255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   194, 255, 255, 126, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,
     0,   39,  88,  94,  58,  2,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   137, 198, 116,
     0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   160, 242, 181, 20,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 31,  0,   0,   0,   0,   0,   220, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 31,  0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  255, 255, 255, 238,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144,
     0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   121, 255, 255, 255, 82,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 103, 0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 103, 0,   0,   0,
     0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   62,  103, 104, 104, 104, 95,  25,  0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  252, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   215, 255, 255, 255, 117, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   192, 255, 255, 255, 140, 0,   215, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   190, 255, 255, 255, 135, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 138, 0,   31,  198, 239, 128, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   15,  179, 241, 158, 3,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   126,
     255, 255, 255, 255, 255, 255, 238, 34,  0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   103, 236, 215, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   189, 255, 255, 255, 198, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220,
     255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,
     243, 255, 255, 255, 116, 0,   189, 255, 255, 255, 198, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  245, 255, 255, 255, 112, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   31,  245, 255, 255, 255, 112, 0,   175, 255, 255, 255, 59,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   136, 255, 255, 255, 98,  0,   0,   0,   0,
     0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   239, 255, 255, 255, 255, 255, 255, 255, 129, 0,   0,   0,   0,   0,   76,  255, 255, 255,
     252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   122, 255,
     255, 255, 255, 194, 112, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 95,  25,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184,
     255, 255, 255, 144, 0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 122, 226, 255, 255, 255, 255, 52,  0,   122, 255, 255, 255, 255, 194, 112, 104, 104, 104, 104,
     104, 104, 104, 104, 123, 228, 255, 255, 255, 255, 46,  0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 123, 228, 255, 255, 255, 255, 44,  0,   218, 255, 255, 255,
     106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 142, 0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,
     0,   0,   0,   0,   212, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  181, 242, 158, 3,   0,   20,  242, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 237, 34,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 194, 0,   0,   20,  242, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 186, 0,   0,   220, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255,
     144, 0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   53,  215, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,
     0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 255,
     255, 98,  0,   0,   88,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 130, 0,   218, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   183, 255, 255, 255, 142, 0,   218, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 37,  0,   0,   0,   88,  255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235, 32,  0,   0,   218, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 30,  0,
     0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255,
     108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 142, 0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 102, 0,   175, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 255, 255, 98,  0,   175, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 228, 50,  0,   0,   0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 226, 45,  0,   0,   0,
     175, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 43,  0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255,
     144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   37,  155, 225, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 160, 4,   0,   32,  199, 240, 133, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  183, 242, 158, 3,   0,   32,  199, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 211, 127, 14,  0,   0,   0,   0,   0,
     0,   0,   37,  155, 225, 252, 255, 255, 255, 255, 255, 255, 255, 255, 246, 211, 125, 13,  0,   0,   0,   0,   32,  199, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 210,
     124, 12,  0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   31,  198, 239, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  183, 242, 158, 3,   0,   31,  198, 239,
     130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  198, 240, 136, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  183,
     242, 158, 3,   0,   31,  198, 240, 136, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  181, 242, 158, 3,   0,   0,   0,   0,   37,  155, 225, 251, 255, 255, 255, 255, 255,
     255, 255, 255, 246, 209, 124, 11,  0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   220,
     255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 95,  25,  0,   0,   220, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   175, 255, 255, 255,
     62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  210, 255, 255, 255, 101, 0,   175, 255, 255, 255, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   175, 255, 255, 255, 151, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  209, 255, 255, 255, 98,  0,   175, 255, 255, 255, 151, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   139, 255, 255, 255, 98,  0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 43,  0,   0,   0,   220, 255, 255, 255, 108, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 237, 34,  0,   220, 255, 255, 255, 101, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   218, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  206, 255, 255, 255, 255,
     131, 0,   218, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   218, 255, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   15,  204, 255, 255, 255, 255, 142, 0,   218, 255, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 142, 0,   0,   88,  255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 29,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,
     0,   0,   0,   0,   218, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 130, 0,   218, 255, 255, 255, 83,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   215, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   192, 255, 255, 255, 140, 0,   0,   0,   0,   0,   76,
     255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144,
     0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  201, 255, 255, 255, 255, 243, 36,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 135, 0,   0,   0,   0,   0,   0,   0,   12,  198, 255, 255, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 135, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   20,  241, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 183, 0,   0,   220,
     255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   175, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 102, 0,   175, 255, 255, 255, 38,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   189, 255, 255, 255, 198, 2,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  243, 255, 255, 255, 116, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   12,  197, 255,
     255, 255, 255, 245, 62,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 128, 0,
     0,   0,   0,   0,   9,   192, 255, 255, 255, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   122, 255,
     255, 255, 255, 196, 112, 104, 104, 104, 104, 104, 104, 104, 104, 123, 229, 255, 255, 255, 255, 44,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184,
     255, 255, 255, 144, 0,   0,   0,   0,   0,   32,  199, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 160, 4,   0,   32,  199, 240, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   122, 255, 255, 255, 255, 194, 112, 104, 104, 104, 104, 104, 104, 104, 104, 122, 226, 255, 255, 255, 255, 52,  0,
     0,   26,  95,  104, 149, 255, 255, 255, 253, 104, 104, 84,  6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   10,  192, 255, 255, 255, 255, 247, 67,  0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 119, 0,   0,   0,   7,   186, 255, 255, 255, 255, 255, 255, 255, 144, 0,   220, 255, 255,
     255, 255, 255, 255, 255, 118, 0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   189, 255, 255, 255, 199, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  245, 255,
     255, 255, 112, 0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 213, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,
     242, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 193, 0,   0,   35,  238, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 194, 3,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,
     8,   187, 255, 255, 255, 255, 248, 72,  0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255,
     255, 255, 255, 255, 255, 111, 0,   5,   179, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 111, 0,   0,   0,   0,   0,   0,   0,   184, 255, 255,
     255, 144, 0,   215, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 138, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   31,  198, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 208, 122, 10,  0,   0,   0,   0,   0,   0,   0,   37,  155, 225,
     251, 255, 255, 255, 255, 255, 255, 255, 255, 246, 209, 124, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 238, 37,  0,   0,   131, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   6,   182, 255, 255, 255, 255, 250, 77,  0,   0,   0,   0,   0,   220, 255, 255, 255, 108,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 228, 255, 255, 255, 255, 255, 107, 172, 255, 255, 255, 255, 247, 226, 255, 255, 255,
     144, 0,   220, 255, 255, 255, 228, 255, 255, 255, 255, 255, 103, 0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   175, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 38,  0,   0,   0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 43,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 228, 50,  0,   0,   0,   104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     252, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,
     0,   0,   0,   5,   177, 255, 255, 255, 255, 251, 82,  0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   220, 255, 255, 255, 110, 162, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 75,  184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 110, 162, 255, 255, 255, 255, 254, 95,  0,   0,   0,
     0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   218, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230, 25,  0,   0,   0,
     88,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  155, 225, 252, 255, 255, 255, 255, 255, 255,
     255, 255, 246, 211, 127, 14,  0,   0,   0,   0,   5,   163, 247, 255, 255, 255, 255, 255, 255, 255, 255, 236, 103, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   3,   171, 255, 255, 255, 255, 252, 87,  0,   0,   0,   0,   0,   0,   0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 3,   169, 255, 255, 255, 255, 255, 255, 255, 252, 85,
     0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 3,   169, 255, 255, 255, 255, 253, 88,  0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   220, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   20,  241, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 183, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220,
     255, 255, 255, 108, 0,   0,   2,   165, 255, 255, 255, 255, 253, 93,  0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   4,   175, 255, 255, 255, 255, 255, 254, 97,  0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   4,   176, 255, 255,
     255, 255, 251, 82,  0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255,
     255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 124, 231, 255, 255,
     255, 255, 39,  0,   122, 255, 255, 255, 255, 196, 112, 104, 104, 104, 104, 104, 104, 104, 104, 123, 229, 255, 255, 255, 255, 44,  0,   31,  198, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 246, 208, 122, 10,  0,   0,   0,   0,   0,   0,   0,   68,  173, 230, 252, 255, 255, 255, 255, 255, 255, 255, 255, 246, 208, 122, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   1,   159, 255, 255, 255, 255, 254, 99,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   6,   181, 255, 255,
     255, 255, 109, 0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   6,   182, 255, 255, 255, 255, 250, 75,  0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255,
     108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255,
     255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  247, 255, 255, 255, 108, 0,   189, 255, 255, 255, 199, 3,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   32,  245, 255, 255, 255, 112, 0,   175, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 38,  0,   0,   0,   0,   1,   148, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 38,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255,
     255, 255, 144, 0,   220, 255, 255, 255, 108, 1,   153, 255, 255, 255, 255, 255, 105, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   8,   179, 255, 253, 116, 0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108,
     0,   0,   0,   8,   188, 255, 255, 255, 255, 247, 68,  0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255,
     144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   195, 255, 255, 255, 137, 0,   215, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 138, 0,   218, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230, 25,  0,   0,   0,   124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230, 25,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 146, 255, 255, 255, 255, 255, 111, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,
     0,   0,   0,   1,   52,  34,  0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   10,  194, 255, 255, 255, 255, 245, 62,  184, 255, 255, 255, 144,
     0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   29,
     250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 220, 255, 255, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   13,  199, 255, 255, 255, 255, 243, 222, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255,
     255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 124, 231, 255, 255, 255, 255, 38,  0,   128, 255, 255, 255, 255, 198, 113, 104, 104, 104, 104, 104, 104, 104, 104, 124, 231, 255,
     255, 255, 255, 39,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255,
     255, 186, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220,
     255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   15,  205, 255, 255, 255, 255,
     255, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255,
     255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  247, 255,
     255, 255, 107, 0,   189, 255, 255, 255, 203, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  247, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255,
     255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184,
     255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   19,  210, 255, 255, 255, 255, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255,
     108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255,
     255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 255, 136, 0,   214, 255, 255, 255, 119, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   193, 255, 255, 255, 135, 0,   0,   0,   0,   16,  156, 195, 89,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 109, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,
     0,   22,  215, 255, 255, 255, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 255,
     137, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   135, 255, 255, 255, 98,  0,   0,   0,   0,   159, 255, 255, 253,
     47,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 198, 255, 255, 255, 255, 255, 103, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  219, 255, 255, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144,
     0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  247, 255, 255, 255, 109, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  183, 246, 162, 4,   0,   0,   0,   0,   212, 255, 255, 255, 113, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255,
     138, 0,   220, 255, 255, 255, 255, 153, 1,   126, 255, 255, 255, 255, 254, 97,  0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   30,  224, 255, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 124,
     230, 255, 255, 255, 255, 39,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   190, 255, 255, 255, 198, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  245, 255, 255, 255, 112, 0,   220, 255, 255, 255, 170, 1,   0,   0,   137, 255, 255, 255, 255, 253, 91,
     0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  232, 255, 255, 255, 144, 0,   220,
     255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   218, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     183, 255, 255, 255, 142, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255,
     255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   123, 255, 255, 255, 255, 194, 112, 104, 104, 104, 104, 104, 104, 104, 104, 123,
     228, 255, 255, 255, 255, 44,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   146, 255, 255, 255, 255, 252, 85,  0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255,
     255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184,
     255, 255, 255, 144, 0,   175, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 255, 255, 98,  0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 230, 25,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255,
     108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 255, 137, 0,   215, 255, 255, 255, 119, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   21,  243, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   1,
     155, 255, 255, 255, 255, 251, 80,  0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255,
     255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255,
     255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   32,  199, 240, 133, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   17,  183, 242, 158, 3,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 221, 39,  0,   0,   0,   220, 255, 255, 255, 108,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  247, 255, 255, 255,
     110, 0,   196, 255, 255, 255, 203, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 233, 30,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   2,   164, 255, 255, 255, 255, 249, 75,  0,   0,   0,   0,   0,   220, 255, 255, 255,
     108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255,
     255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 209, 122, 10,  0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   1,   51,  32,  0,   0,   0,   0,   0,   188, 255, 255, 255, 144,
     0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 124, 230, 255, 255, 255, 255, 43,  0,   147, 255, 255, 255, 255, 197, 112, 104, 104, 104, 104, 104, 104, 104, 104,
     94,  57,  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   101, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 43,  0,   0,   0,   220, 255, 255, 255, 108,
     0,   0,   0,   0,   0,   0,   3,   173, 255, 255, 255, 255, 248, 70,  0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   184, 255, 255, 255, 144, 0,   215, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 138, 0,   32,  198, 253, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 158, 3,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   168, 255, 253, 116, 0,   0,   0,   100, 254, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 184, 0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 227, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   39,  156, 226,
     252, 255, 255, 255, 255, 255, 255, 255, 255, 246, 210, 124, 12,  0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   6,   181, 255, 255, 255, 255, 246, 65,  0,   0,
     0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   189, 255, 255, 255, 198, 2,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   31,  245, 255, 255, 255, 112, 0,   175, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 99,  0,   220,
     255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   49,  255, 255, 255, 255, 111, 0,   94,  253,
     255, 255, 255, 255, 143, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 32,  0,   0,   0,   175, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   8,   189, 255, 255, 255, 255, 244, 59,  0,   0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
     104, 104, 104, 95,  25,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   122, 255, 255, 255, 255, 194, 112, 104, 104, 104, 104, 104, 104, 104, 104, 123, 228, 255, 255, 255, 255, 44,  0,   203, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 126, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   41,  255, 255, 255, 255, 255, 158, 252, 255, 255, 255, 255, 255, 113, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 238, 49,  0,   0,   0,   14,  188, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 97,  0,   0,   0,   0,   0,   31,
     198, 239, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  181, 242, 158, 3,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  196, 255,
     255, 255, 255, 241, 35,  0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 237, 34,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   20,  242, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   94,  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 238, 34,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   151, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 212, 12,  0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 218, 6,   0,   0,   0,   2,   91,  184,
     234, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235, 11,  0,   0,   0,   0,   175, 255, 255, 255, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   139,
     255, 255, 255, 98,  0,   218, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  203, 255, 255, 255, 255, 131, 0,   218, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 130, 0,   218, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 142, 0,   218, 255, 255, 255,
     106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 142, 0,   0,   88,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233,
     30,  0,   0,   0,   50,  102, 104, 104, 104, 104, 104, 146, 255, 255, 255, 255, 104, 104, 104, 104, 104, 104, 95,  25,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   2,   167, 255, 255, 255, 255, 255, 255, 255, 255, 213, 22,  0,   0,   220, 255, 255, 255, 108, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  152, 255, 255, 255, 255, 78,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  149, 255, 255, 255, 255, 83,
     0,   0,   0,   0,   218, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 142, 0,   175, 255, 255, 255, 62,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   18,  209, 255, 255, 255, 101, 0,   175, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 102, 0,   175, 255, 255, 255, 62,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 255, 98,  0,   175, 255, 255, 255, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 255,
     98,  0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,
     0,   0,   0,   4,   175, 255, 255, 255, 255, 255, 255, 213, 22,  0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   223, 255, 255, 255, 127, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   221, 255, 255, 255, 128, 0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   32,  199, 240, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  183, 242, 158, 3,   0,   32,  199, 253, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 160, 4,   0,   32,  199, 240, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  181, 242, 158, 3,
     0,   32,  199, 240, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  181, 242, 158, 3,   0,   0,   0,   0,   37,  155, 225, 252, 255, 255, 255, 255, 255, 255, 255, 255,
     246, 210, 124, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   215, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   34,  250, 255, 255, 255, 255, 255, 80,  0,   0,   0,   0,   220,
     255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     184, 255, 255, 255, 143, 0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,
     255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   189, 255,
     255, 255, 198, 2,   0,   0,   0,   0,   24,  218, 255, 255, 255, 255, 255, 255, 242, 57,  0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184,
     255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   31,  198, 239, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  181, 242, 158, 3,   0,   31,
     198, 239, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  180, 242, 158, 3,   0,   31,  198, 239, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     16,  181, 242, 158, 3,   0,   31,  198, 239, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  180, 242, 158, 3,   0,   32,  198, 253, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 158, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255,
     255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   122, 255, 255, 255, 255, 194, 112, 104, 104, 104, 212, 255, 255, 255, 255, 255, 255, 255, 255,
     242, 57,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   7,   124, 164, 66,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   175, 255,
     255, 255, 63,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 255, 98,  0,   175, 255, 255, 255, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   139,
     255, 255, 255, 101, 0,   175, 255, 255, 255, 63,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 255, 98,  0,   175, 255, 255, 255, 63,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   139, 255, 255, 255, 101, 0,   175, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 98,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   20,  242, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 228, 213, 255, 255, 255, 255, 241, 33,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   144, 255, 255, 250, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   220, 255, 255,
     255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   218, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255,
     255, 255, 142, 0,   218, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 146, 0,   218, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   182, 255, 255, 255, 142, 0,   218, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 146, 0,   203, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   218, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235,
     41,  22,  213, 255, 255, 255, 255, 126, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   211, 255, 255, 255, 110, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   192, 255, 255, 255, 140, 0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255,
     255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   94,  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   175, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 255, 255, 255, 242, 51,  0,   0,   22,  213, 255, 255, 255, 100, 0,   220, 255, 255, 255, 108, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   193, 255, 255, 255, 194, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  243, 255, 255, 255, 121, 0,   0,
     0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   220, 255, 255, 255, 108, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 148, 0,
     0,   50,  102, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 213, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   32,  199, 240, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  155, 225, 252, 255, 255,
     255, 255, 215, 57,  0,   0,   0,   0,   22,  183, 242, 160, 4,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   130, 255,
     255, 255, 255, 193, 111, 104, 104, 104, 104, 104, 104, 104, 104, 122, 226, 255, 255, 255, 255, 70,  0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   220, 255, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   191, 255, 255, 255, 144, 0,   220,
     255, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   191, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     198, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255,
     255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   26,  246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 225, 6,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   217, 255,
     255, 255, 240, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   113, 255, 255, 255, 255, 140, 0,   217, 255, 255, 255, 240, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   113, 255,
     255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   136, 255, 255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255,
     255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 236, 255, 255, 255, 255, 236, 101, 0,   0,   31,  198, 239, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   3,   158, 247, 255, 255, 255, 255, 214, 51,  0,   0,   0,   218, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   183, 255, 255,
     255, 143, 0,   0,   99,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 76,  0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255,
     255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   161, 255, 255, 255, 255, 237, 46,  0,   0,   0,   0,   0,   0,   0,   0,   105, 255, 255, 255,
     255, 255, 84,  0,   161, 255, 255, 255, 255, 237, 46,  0,   0,   0,   0,   0,   0,   0,   0,   105, 255, 255, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   127, 255, 255, 255, 255, 255, 85,  0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  252, 255, 255, 255,
     255, 255, 255, 252, 33,  0,   175, 255, 255, 255, 63,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   99,  255, 255, 255, 255, 255, 255, 255, 210, 0,
     0,   0,   175, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 255, 255, 101, 0,   0,   0,   107, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 244, 88,  0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255,
     108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255,
     255, 148, 0,   19,  213, 255, 255, 255, 255, 234, 41,  0,   0,   0,   0,   0,   0,   96,  254, 255, 255, 255, 255, 155, 0,   0,   19,  213, 255, 255, 255, 255, 234, 41,  0,   0,   0,   0,   0,
     0,   96,  254, 255, 255, 255, 255, 159, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   117, 255, 255, 255, 255, 255, 159, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   70,  255, 255, 255, 255, 255, 255, 255, 255, 58,  0,   218, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 255, 255, 255, 255, 255, 255, 254, 0,   0,   0,   32,  199, 240, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   17,  183, 242, 160, 4,   0,   0,   0,   0,   41,  158, 226, 252, 255, 255, 255, 255, 255, 255, 255, 255, 248, 217, 142, 29,  0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255,
     144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   24,  218, 255, 255, 255, 255, 230, 37,  0,   0,   0,   0,   89,
     253, 255, 255, 255, 255, 160, 2,   0,   0,   0,   25,  218, 255, 255, 255, 255, 230, 37,  0,   0,   0,   0,   89,  253, 255, 255, 255, 255, 164, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   108, 255, 255, 255, 255, 255, 166, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     72,  255, 255, 255, 255, 255, 255, 255, 197, 4,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  238, 255, 255, 255,
     255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144,
     0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   28,  223, 255, 255, 255, 255, 226, 32,  0,   0,   81,  251, 255, 255, 255, 255, 165, 2,   0,   0,   0,   0,   0,   29,  223, 255, 255, 255, 255,
     226, 32,  0,   0,   81,  251, 255, 255, 255, 255, 168, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   98,  254, 255, 255, 255, 255, 171, 3,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 104, 104, 84,  7,   0,   0,   220, 255, 255, 255, 108, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  95,  104, 146, 255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 236, 214,
     58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   49,  101, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 95,  25,  0,   0,   0,   0,   0,   0,   0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   33,  227, 255, 255, 255, 255,
     222, 28,  74,  249, 255, 255, 255, 255, 169, 3,   0,   0,   0,   0,   0,   0,   0,   33,  227, 255, 255, 255, 255, 222, 28,  74,  249, 255, 255, 255, 255, 173, 4,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   90,  253, 255, 255, 255, 255, 177, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 121, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 255, 243, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  253, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 237, 33,  0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   37,  230, 255, 255, 255, 255, 223, 247, 255, 255, 255, 255, 174, 4,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   37,  230, 255, 255, 255, 255, 223, 247, 255, 255, 255, 255, 177, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   82,  252, 255, 255, 255, 255, 182, 6,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   217,
     255, 255, 255, 246, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,
     122, 255, 255, 255, 255, 255, 243, 58,  0,   0,   0,   0,   0,   0,   0,   0,   203, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 126, 0,
     0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   43,  159, 138, 14,  0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,
     0,   41,  234, 255, 255, 255, 255, 255, 255, 255, 255, 179, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   42,  234, 255, 255, 255, 255, 255, 255, 255, 255, 182, 6,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   75,  250, 255, 255, 255, 255, 188, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   161, 255, 255, 255, 255, 243, 57,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   119, 255, 255, 255, 255, 255, 255, 255, 242, 56,  0,   0,   0,   0,   0,   0,   0,   176,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108,
     0,   0,   0,   14,  233, 255, 255, 176, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   0,   46,  237, 255, 255, 255, 255, 255, 255, 183, 7,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   47,  237, 255, 255, 255, 255, 255, 255, 185, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   67,  247, 255, 255, 255, 255,
     193, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,
     0,   0,   0,   0,   19,  213, 255, 255, 255, 255, 240, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,
     0,   0,   0,   115, 255, 255, 255, 255, 255, 255, 255, 255, 255, 240, 53,  0,   0,   0,   0,   0,   0,   33,  200, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 247, 160, 4,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   65,  255, 255, 255, 249, 0,   0,   0,   0,   184, 255, 255, 255, 148,
     0,   0,   0,   0,   0,   0,   0,   0,   98,  255, 255, 255, 255, 255, 241, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  240, 255, 255, 255, 255, 189, 9,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  245, 255, 255, 255, 255, 198, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   24,  217, 255, 255, 255, 255, 237, 45,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   112, 255, 255, 255, 255, 255, 127, 186, 255, 255, 255, 255, 239, 51,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,
     220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   0,   46,  237, 255, 255, 255, 255, 255, 255, 182, 6,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   90,  255, 255, 255, 255, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   54,  242, 255,
     255, 255, 255, 203, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255,
     255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   27,  221, 255, 255, 255, 255, 233, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255,
     255, 255, 0,   0,   0,   0,   109, 255, 255, 255, 255, 255, 128, 0,   9,   191, 255, 255, 255, 255, 238, 49,  0,   0,   0,   0,   0,   98,  235, 214, 55,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220,
     255, 255, 255, 113, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   189, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,
     184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   41,  234, 255, 255, 255, 255, 255, 255, 255, 255, 178, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255,
     255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   48,  238, 255, 255, 255, 255, 207, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  224, 255, 255, 255,
     255, 229, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   106, 255, 255, 255, 255, 255, 134, 0,   0,   0,   12,  196,
     255, 255, 255, 255, 237, 47,  0,   0,   0,   29,  251, 255, 255, 241, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255,
     255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 236, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   103, 255,
     255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   37,  230, 255, 255, 255, 255, 223,
     247, 255, 255, 255, 255, 174, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     42,  234, 255, 255, 255, 255, 212, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  228, 255, 255, 255, 255, 224, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   72,  255, 255, 255, 255, 0,   0,   104, 254, 255, 255, 255, 255, 140, 0,   0,   0,   0,   0,   14,  201, 255, 255, 255, 255, 236, 46,  0,   0,   57,  255, 255, 255, 255, 236, 44,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   215, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255,
     255, 255, 138, 0,   219, 255, 255, 255, 255, 232, 39,  0,   0,   0,   0,   0,   0,   0,   0,   94,  254, 255, 255, 255, 255, 143, 0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255,
     255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   33,  226, 255, 255, 255, 255, 222, 28,  74,  249, 255, 255, 255, 255, 169, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  230, 255, 255, 255, 255, 216, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   38,  231, 255, 255, 255, 255, 219, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   83,  254, 255, 255, 255, 255, 145, 0,   0,
     0,   0,   0,   0,   0,   16,  205, 255, 255, 255, 255, 234, 27,  0,   5,   211, 255, 255, 255, 255, 231, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   189, 255, 255, 255, 198, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  245, 255, 255, 255, 112, 0,   188, 255, 255, 255, 255, 255, 229, 35,  0,   0,   0,   0,   0,
     0,   87,  252, 255, 255, 255, 255, 255, 111, 0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   28,  222, 255, 255,
     255, 255, 226, 32,  0,   0,   82,  251, 255, 255, 255, 255, 164, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   31,  226, 255, 255, 255, 255, 220, 26,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   70,  255, 255, 255, 254, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   43,  234, 255, 255, 255, 255, 213, 21,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   201, 255, 255, 255, 255, 151, 0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  209, 255, 255, 255, 255, 125, 0,   0,   30,  225,
     255, 255, 255, 255, 225, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   122, 255, 255, 255, 255, 194, 112, 104, 104, 104, 104, 104, 104, 104,
     104, 123, 228, 255, 255, 255, 255, 44,  0,   51,  244, 255, 255, 255, 255, 255, 225, 31,  0,   0,   0,   0,   80,  251, 255, 255, 255, 255, 255, 209, 10,  0,   220, 255, 255, 255, 108, 0,   0,
     0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   24,  218, 255, 255, 255, 255, 230, 37,  0,   0,   0,   0,   89,  253, 255, 255, 255, 255, 160, 2,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  221, 255, 255, 255, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  252, 255, 255, 210, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   47,  237, 255, 255, 255, 255, 207, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   179, 255, 255, 255,
     156, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  213, 255, 255, 255, 103, 0,   0,   0,   36,  231, 255, 255, 255, 255, 211, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   20,  242, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 184, 0,   0,   0,   66,  247, 255, 255, 255, 255, 255,
     220, 26,  0,   0,   72,  249, 255, 255, 255, 255, 255, 214, 21,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   19,
     213, 255, 255, 255, 255, 234, 42,  0,   0,   0,   0,   0,   0,   97,  254, 255, 255, 255, 255, 155, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   21,  216, 255, 255, 255, 255, 227, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   101,
     235, 214, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   51,  240, 255, 255, 255, 255, 201,
     13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   35,  202, 241, 139, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  185, 243, 162,
     5,   0,   0,   0,   0,   43,  236, 255, 255, 255, 255, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 233, 30,  0,   0,   0,   0,   73,  249, 255, 255, 255, 255, 255, 216, 22,  66,  247, 255, 255, 255, 255, 255, 219, 26,  0,   0,   0,   220, 255,
     255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   161, 255, 255, 255, 255, 237, 47,  0,   0,   0,   0,   0,   0,   0,   0,   105, 255, 255,
     255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   161, 255, 255, 255, 255, 230, 37,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255,
     255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  242, 255, 255, 255, 255, 195, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   50,  240, 255, 255, 252, 31,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 43,  0,   0,   0,   0,   0,   0,
     79,  251, 255, 255, 255, 255, 255, 216, 244, 255, 255, 255, 255, 255, 224, 30,  0,   0,   0,   0,   215, 255, 255, 255, 117, 0,   0,   0,   82,  255, 255, 255, 255, 9,   0,   0,   0,   193, 255,
     255, 255, 142, 0,   217, 255, 255, 255, 240, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   113, 255, 255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255,
     255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   217, 255, 255, 255, 233, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,
     162, 247, 255, 255, 255, 255, 255, 255, 255, 255, 246, 209, 125, 12,  0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     60,  244, 255, 255, 255, 255, 188, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   31,  198, 239, 128, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   53,  213, 235, 101, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,
     155, 225, 252, 255, 255, 255, 255, 255, 255, 255, 255, 246, 210, 124, 12,  0,   0,   0,   0,   0,   0,   0,   0,   86,  252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 228, 34,  0,   0,
     0,   0,   0,   189, 255, 255, 255, 198, 2,   0,   0,   167, 255, 255, 255, 255, 92,  0,   0,   31,  245, 255, 255, 255, 116, 0,   220, 255, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   191, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 111, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 225, 45,  0,   0,
     0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   66,  246, 255, 255, 255, 255, 181, 5,   0,   0,   0,   0,   0,   0,   0,   0,
     72,  255, 255, 255, 255, 0,   175, 255, 255, 255, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   93,  253, 255, 255, 255, 255, 255, 255, 255, 255, 233, 39,  0,   0,   0,   0,   0,   0,   122, 255, 255, 255, 255, 195, 117, 178, 255, 255, 255, 255, 255, 249,
     144, 123, 228, 255, 255, 255, 255, 48,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 95,  25,  0,   0,
     0,   0,   0,   0,   131, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235, 32,  0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   71,  248, 255, 255, 255, 255, 173, 4,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   218, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  155, 225, 251, 255, 255, 255, 255, 255, 255, 255, 255, 246, 209, 125, 12,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  179, 241, 158, 3,   0,   0,   0,   0,   0,   0,   0,   101, 254, 255, 255, 255, 255, 255, 255, 236,
     45,  0,   0,   0,   0,   0,   0,   0,   20,  242, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 188, 0,   0,   220, 255, 255, 255, 108, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 237, 33,  0,   0,   0,   0,   0,   37,  239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 189, 0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  250, 255, 255, 255, 255, 165, 2,   0,
     0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 250, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 225, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   137, 255, 255, 255, 98,  0,   0,   0,   0,   0,   0,   0,   0,   109, 255, 255, 255, 255, 255, 240, 50,  0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235, 32,  0,   0,   218, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 142, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   70,  255, 255, 255, 254, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   218, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 126, 0,   0,   0,   0,   0,   0,   26,  95,  104, 104, 104, 104, 104, 104, 104, 104, 124, 232, 255, 255, 255, 255, 48,  0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   82,  251, 255, 255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   220, 255, 255, 255, 108, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   93,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235, 32,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   117, 255,
     255, 255, 243, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   97,  249, 255, 255, 255, 255, 255, 244, 74,  187, 255, 255, 255, 255, 255, 255, 226, 45,  0,   0,   0,   175, 255, 255,
     255, 63,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 255, 98,  0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  252, 255, 255, 210, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   175, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   37,  248, 255, 255, 255, 114, 0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   87,  252,
     255, 255, 255, 255, 84,  0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     23,  243, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 189, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 236, 215, 57,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,
     155, 225, 249, 231, 161, 35,  0,   1,   93,  191, 240, 246, 210, 126, 12,  0,   0,   0,   0,   32,  199, 240, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  183, 242,
     158, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   103, 236, 214, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  199, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 247, 160, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 255, 139, 0,   72,  255, 255, 255, 255, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  253, 255, 255, 255, 140, 0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   220,
     255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   126, 255, 255, 255, 255, 196, 112, 104, 104, 104, 104, 104, 104, 104, 104, 123, 229,
     255, 255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   187, 255, 255, 255, 144, 0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   192, 255, 255, 255, 199, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  245, 255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   38,  155, 225, 251, 255, 255, 255, 255, 255, 255, 255, 255, 246, 208, 123, 11,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   1,   90,  190, 239, 255, 255, 255, 255, 247, 158, 3,   0,   0,   0,   0,   40,  157, 225, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     247, 160, 4,   0,   31,  198, 239, 128, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 236, 212, 48,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   72,
     255, 255, 255, 255, 104, 104, 84,  6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   25,  95,  104, 146, 255,
     255, 255, 255, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   189, 255, 255, 255, 135, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,
     0,   0,   100, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 222, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  182, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 99,  0,   0,   0,   106, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 102, 0,   175, 255, 255, 255, 60,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  253, 255, 255, 207, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   40,  157, 225, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   72,  255, 255, 255, 255, 255, 255, 255, 195, 4,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   33,  237, 255, 255, 255, 255, 255, 255, 255, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 246, 209, 125, 12,  0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   118, 255, 255, 255, 78,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   93,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 232, 28,  0,   0,   0,   0,   0,   0,   0,   3,   188, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 126, 0,   0,   99,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 143, 0,   218, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   59,  255, 255,
     255, 234, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   106, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 144, 0,   70,  255, 255, 255, 255, 255, 255, 255, 255, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 142, 0,   127,
     255, 255, 255, 255, 255, 255, 255, 254, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 225, 45,  0,   0,   0,   220, 255, 255, 255, 108, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   131, 190, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184,
     255, 255, 255, 144, 0,   23,  243, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 181, 0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 238, 34,  0,   27,  246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   200, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   100, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   31,  252, 255, 255, 255, 255, 255, 255, 252, 34,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 255, 98,  0,   100, 255, 255, 255, 255, 255, 255, 255, 210, 0,   220, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235, 32,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   38,  155, 225, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   126, 255, 255, 255, 255, 199, 113, 104, 104, 104, 104, 104,
     104, 104, 104, 124, 232, 255, 255, 255, 255, 43,  0,   0,   0,   0,   0,   1,   228, 255, 255, 255, 250, 145, 104, 104, 104, 104, 95,  25,  0,   0,   130, 255, 255, 255, 255, 194, 112, 104, 104,
     104, 104, 104, 104, 104, 104, 104, 104, 213, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   8,   84,  61,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   101, 236, 255, 255, 255, 255, 236, 103, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  183,
     242, 158, 3,   0,   4,   160, 247, 255, 255, 255, 255, 214, 51,  0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 189, 0,   0,   220, 255,
     255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   192, 255, 255, 255, 205, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  248, 255, 255, 255, 111, 0,   0,   0,   0,   0,   42,  255,
     255, 255, 255, 95,  0,   0,   0,   0,   0,   0,   0,   0,   0,   194, 255, 255, 255, 196, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255,
     255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 255, 191, 112, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 213, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255,
     255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 123, 229, 255, 255, 255, 255, 48,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   93,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   216, 255, 255, 255, 119, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 255, 138, 0,   0,   0,   0,   0,   69,  255, 255, 255, 254, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 255,
     115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 255, 191, 1,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   51,  214, 235, 100, 0,   0,   4,   160, 242, 179, 14,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  245, 255, 255,
     255, 114, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  243, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,
     0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255,
     144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   214, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   211, 255, 255, 252, 31,  0,   103, 255, 255, 255, 134, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 139, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   5,   131, 190, 108, 0,   0,   0,   0,   0,   0,   0,   126, 255, 255, 255, 255, 196, 112, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 213, 255, 255, 255, 144, 0,   220, 255,
     255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   194, 255, 255, 255,
     190, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   239, 255, 255, 255, 54,  0,   146,
     255, 255, 255, 178, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   119, 255, 255, 255, 79,  0,   0,   0,   0,   0,   0,   192, 255, 255,
     255, 199, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 144, 0,   5,   163, 247, 255, 255, 255, 255, 255, 255, 255, 255, 236, 103, 0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 209, 125, 12,  0,   0,   0,   0,   5,   163, 247, 255, 255, 255, 255, 213, 51,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 255, 255, 191, 111, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 213, 255, 255, 255,
     144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 196, 3,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   215, 255, 255, 255, 117, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   189, 255, 255, 255, 135, 0,   0,   0,   0,   0,   0,   216, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255,
     255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   105, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252,
     31,  0,   0,   0,   0,   0,   219, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 225, 45,  0,   0,   0,   105, 255, 255, 255, 255, 255, 255, 255, 209, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   28,  246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   63,
     84,  7,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   191, 255, 255, 255, 197, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  245, 255, 255, 255, 114, 0,   0,   0,   0,
     0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 127, 0,   131, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 54,  0,   0,   0,   0,   0,   206, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235, 32,  0,   0,   131, 255, 255, 255,
     255, 255, 255, 255, 251, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   125, 255, 255, 255,
     255, 194, 112, 104, 104, 104, 104, 104, 104, 104, 104, 123, 228, 255, 255, 255, 255, 47,  0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 237, 32,  0,   37,  240, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 197, 3,   0,   0,   0,   0,   0,   162, 255, 255, 255, 249, 91,  7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 189, 0,   0,   37,  240, 255, 255, 255, 255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   107, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   22,  243, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 187,
     0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 168, 104, 104, 104, 104,
     104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 95,  25,  0,   0,   0,   27,  95,  104, 149, 255, 255, 255, 253, 104, 104, 84,  7,   0,   0,   0,   0,   0,   0,   70,  255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 123, 229, 255, 255, 255, 255, 48,
     0,   0,   27,  95,  104, 149, 255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   41,  158, 226, 252, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 247, 160, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144,
     0,   0,   93,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235, 32,  0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   179, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  245, 255, 255, 255, 114, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   101, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 226, 45,  0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   215, 255, 255, 255,
     114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     15,  201, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     193, 255, 255, 255, 139, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   4,   160, 247, 255, 255, 255, 255, 212, 48,  0,   0,   0,   0,   0,   0,   5,   163, 247,
     255, 255, 255, 255, 255, 255, 255, 255, 246, 209, 125, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   103, 236, 255, 255, 255, 255, 236, 103, 0,   0,   148, 255, 255,
     255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   22,  183, 242, 160, 4,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     184, 255, 255, 255, 144, 0,   0,   0,   0,   39,  156, 226, 252, 255, 255, 255, 255, 255, 255, 255, 255, 246, 211, 125, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   191, 255, 255, 255, 190, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   140, 248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,
     0,   0,   0,   0,   103, 255, 255, 255, 255, 255, 255, 255, 206, 0,   0,   0,   0,   0,   0,   105, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 225, 45,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   32,  252, 255, 255, 255, 255, 255, 255, 253, 33,  0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   20,  211, 255, 255, 255, 100, 0,   0,
     0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 139, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144,
     0,   125, 255, 255, 255, 255, 191, 112, 104, 104, 104, 104, 104, 104, 104, 104, 84,  6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   14,  74,  100, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 213, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   131, 255, 255, 255, 255, 255, 255, 255, 250, 0,   0,   0,   0,
     0,   0,   147, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  255, 255, 255, 255, 255, 255, 255, 255,
     71,  0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   18,  209, 255, 255, 255, 255, 126, 0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   30,  245, 255, 255, 255, 114, 0,   33,  200, 253, 255, 255, 255, 253, 231, 168, 54,  0,   0,   71,  186, 238, 245, 210, 126, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   22,  243, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     194, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255,
     255, 255, 252, 0,   0,   0,   0,   0,   0,   36,  240, 255, 255, 255, 255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 188, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   197, 255, 255, 255, 255, 255, 255, 255, 72,  0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   17,  206, 255, 255, 255,
     255, 240, 33,  0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 123, 228, 255, 255, 255, 255, 47,  0,   177, 255, 255, 255, 255, 255,
     255, 255, 255, 254, 131, 119, 255, 255, 255, 255, 255, 255, 227, 47,  0,   0,   0,   0,   0,   0,   0,   0,   215, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     184, 255, 255, 255, 144, 0,   0,   93,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   190, 255, 255, 255, 140, 0,   220, 255, 255, 255, 108, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   27,  95,  104, 149, 255, 255, 255,
     252, 0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 210, 104, 104, 104, 104, 104, 104, 124, 231, 255, 255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   84,  104,
     104, 255, 255, 255, 255, 72,  0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   15,  203, 255, 255, 255, 255, 242, 56,  0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 187, 0,   0,   219, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 237, 35,  0,   0,
     0,   0,   0,   0,   0,   191, 255, 255, 255, 197, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   101, 250, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 252, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   26,  242, 255, 255, 255, 117, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,
     0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,
     0,   0,   34,  246, 255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   148, 255, 255, 255, 180, 0,   0,   0,   14,  201,
     255, 255, 255, 255, 243, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   218, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235, 32,  0,   0,   220,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 192, 0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 255, 255, 194, 112, 104, 104, 104, 104, 104,
     104, 104, 104, 104, 104, 213, 255, 255, 255, 144, 0,   0,   0,   0,   39,  156, 226, 252, 255, 255, 255, 255, 255, 255, 255, 255, 236, 103, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,
     255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  95,  104, 104, 104, 104, 104, 104, 104, 104, 122, 225, 255, 255, 255, 255, 53,  0,   220, 255,
     255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   190, 255, 255, 255, 135, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   148, 255, 255, 255, 180, 0,   0,   12,  198, 255, 255, 255, 255, 244, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   175, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 226, 45,  0,   0,   0,   220, 255, 255, 255, 168, 104, 108, 180, 255, 255, 255, 255, 255, 250, 145, 124, 229, 255,
     255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   22,  243, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   35,  238, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 195, 0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255,
     255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180,
     0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   148, 255, 255, 255, 180,
     0,   11,  195, 255, 255, 255, 255, 245, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  199, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 211, 125, 13,
     0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   168, 255, 255, 255, 255, 94,  0,   0,   32,  245, 255, 255, 255, 118, 0,   0,   0,   0,   0,   0,   0,   93,  255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 142, 0,   33,  200, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 209, 125, 12,  0,   0,   0,   0,
     0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238,
     38,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   5,   135, 194, 112, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   148, 255, 255, 255, 180, 10,  192, 255, 255, 255, 255, 246, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   81,  255, 255, 255, 255,
     9,   0,   0,   0,   193, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   101, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 98,  0,   177,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 225, 45,  0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 228, 50,  0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,
     148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,
     148, 255, 255, 255, 189, 189, 255, 255, 255, 255, 246, 67,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  155, 225, 251, 255, 255, 255, 255, 255, 255, 255, 255, 246, 209, 125, 12,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   39,  156, 226, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 158, 3,   0,   219, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 235, 32,  0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   162, 247, 255, 255, 255, 255, 255, 255, 255, 255,
     246, 211, 127, 14,  0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255,
     252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 250, 70,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   100, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 225, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,
     72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 189, 0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   26,  95,  104, 149, 255, 255, 255, 253, 104, 104, 84,  6,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,
     0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255,
     255, 255, 255, 72,  0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   93,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 235, 32,  0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,
     0,   0,   0,   34,  200, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 210, 127, 14,  0,   0,   0,   0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104,
     104, 104, 123, 229, 255, 255, 255, 255, 48,  0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  157, 225, 251, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 160, 4,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   35,  238, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 194, 3,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 97,
     0,   0,   0,   0,   0,   0,   0,   23,  243, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 189, 0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255,
     255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   179, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 228, 49,  0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  245, 255, 255, 255, 114, 0,   0,   0,   0,   0,   74,  255, 255,
     255, 250, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   106, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 102, 0,   218, 255, 255, 255,
     106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 142, 0,   131, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 54,  0,   0,   0,   0,   0,   76,
     255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   148, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 88,  0,   0,   0,   0,   0,   0,   126, 255, 255, 255, 255, 196, 112, 104, 104, 104,
     104, 104, 104, 104, 104, 123, 229, 255, 255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255,
     255, 148, 0,   0,   0,   0,   0,   0,   219, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 37,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 139, 0,   0,   0,   0,   0,   35,  253, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   99,  255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 143, 0,   175, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 255,
     100, 0,   104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 31,  0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   148, 255, 255, 255, 255, 255, 116,
     184, 255, 255, 255, 255, 251, 80,  0,   0,   0,   0,   0,   192, 255, 255, 255, 199, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  245, 255, 255, 255, 114, 0,   0,   0,   0,   0,
     0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 194, 0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,
     0,   0,   0,   106, 236, 213, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144,
     0,   32,  199, 240, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  183, 242, 160, 4,   0,   5,   163, 247, 255, 255, 255, 255, 255, 255, 255, 255, 236, 103, 0,   0,
     0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   148, 255, 255, 255, 255, 117, 0,   9,   189, 255, 255, 255, 255, 249, 72,  0,   0,   0,   0,   216, 255, 255, 255, 117,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 139, 0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,
     0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 123, 228, 255, 255, 255, 255, 52,  0,   220, 255, 255,
     255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     130, 255, 255, 255, 255, 194, 112, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 213, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   148, 255,
     255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   148, 255,
     255, 255, 189, 0,   0,   0,   10,  194, 255, 255, 255, 255, 247, 65,  0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144,
     0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   220, 255, 255, 255,
     108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  244, 255, 255, 255, 116, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255,
     255, 144, 0,   0,   0,   0,   0,   0,   101, 235, 211, 46,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   194, 255, 255, 255, 196, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     184, 255, 255, 255, 144, 0,   0,   0,   0,   35,  154, 224, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 160, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   7,   124, 164, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 72,  0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   12,  198, 255, 255, 255, 255, 244, 58,  0,   0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255,
     255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   191, 255, 255, 255,
     140, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   32,  252, 255, 255, 204, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   216, 255, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   94,  248, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 103, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,
     0,   0,   0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 249, 39,  0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255,
     255, 72,  0,   148, 255, 255, 255, 180, 0,   0,   0,   0,   0,   14,  202, 255, 255, 255, 255, 240, 33,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,
     0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   74,  255, 255, 255, 250, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   85,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 130, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   146, 255, 255, 255, 178, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   211, 255, 255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   8,   255, 255, 255, 255, 68,  0,   146, 255, 255, 255, 178, 0,   0,   0,   0,   0,   0,   17,  207, 255,
     255, 255, 255, 126, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108,
     0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   18,  240, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255,
     255, 252, 0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 194, 1,   0,   0,   0,   0,   0,
     0,   91,  255, 255, 255, 255, 45,  0,   103, 255, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   20,  211, 255, 255, 255, 100, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148,
     0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   120, 255, 255, 255, 255, 199, 113, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 95,  25,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   5,   163, 243, 181, 15,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 255, 255, 255, 193, 111, 104, 104, 104, 104, 144, 249, 255, 255, 255, 234, 2,   0,   4,   160, 242, 181, 15,  0,   0,   0,   0,
     0,   0,   0,   0,   22,  183, 242, 160, 4,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,
     218, 255, 255, 255, 106, 0,   0,   0,   70,  255, 255, 255, 254, 0,   0,   0,   0,   182, 255, 255, 255, 146, 0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 143, 0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,
     76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   219, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   188,
     255, 255, 255, 205, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  246, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 123, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 64,  0,   0,   0,   31,  252, 255, 255, 212, 0,   0,   0,   0,
     140, 255, 255, 255, 102, 0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   222, 255, 255, 255, 128, 0,   220, 255, 255, 255, 108,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   206, 255,
     255, 255, 148, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   213, 255, 255, 255, 121, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   99,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 197, 7,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,
     0,   0,   0,   0,   0,   33,  200, 240, 133, 0,   0,   0,   0,   0,   103, 236, 215, 53,  0,   0,   0,   0,   17,  182, 242, 160, 4,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  149, 255, 255, 255, 255, 84,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144,
     0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   162, 255, 255, 255, 249, 91,  7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255,
     255, 255, 144, 0,   202, 255, 255, 255, 157, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   107, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 189, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   215, 255,
     255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 139, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 12,  0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   70,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   152, 255, 255, 255, 252, 97,  8,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   41,  158, 226, 252, 255, 255, 255, 255, 240, 192, 94,  1,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   191, 255, 255, 255, 197, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  245, 255,
     255, 255, 114, 0,   33,  200, 240, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  183, 242, 160, 4,   0,   0,   100, 235, 214, 51,  0,   0,   0,   0,   0,   0,   220,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     184, 255, 255, 255, 144, 0,   5,   163, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 160, 4,   0,   0,   179, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 144, 0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 210, 127, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  95,  104, 149, 255, 255, 255, 253, 104, 104, 84,  6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   125, 255, 255, 255, 255, 194, 112, 104, 104, 104, 104, 104, 104, 104, 104, 123, 228, 255, 255, 255, 255, 47,  0,   177, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   141, 255, 255, 255, 101, 0,   30,  252, 255, 255, 210, 0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 136, 0,   0,   0,   218, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 142, 0,   105, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 103, 0,   0,   15,  201, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   163, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 228, 49,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  238, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 194, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  200, 240, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   17,  183, 242, 160, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  243, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 187, 0,   0,   219, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   183, 255, 255, 255, 143, 0,   70,  255, 255, 255, 254, 0,   0,
     0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 228, 91,  0,   0,   0,   0,   176, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   140, 255, 255, 255, 100, 0,   131, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 130, 0,   0,   0,   9,   140, 248, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   10,  191, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 38,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   177, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   141, 255, 255, 255, 101, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   93,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235, 32,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 168, 104, 104, 104, 104, 104, 104, 104, 104,
     104, 104, 94,  59,  3,   0,   0,   0,   0,   0,   33,  200, 240, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  183, 242, 160, 4,   0,   37,  240, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 35,  0,   0,   0,   0,   0,   14,  74,  100, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 213, 255, 255, 255, 144, 0,   0,   0,   6,
     133, 246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 195, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 252, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   219, 255, 255, 255, 107, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   183, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   101, 250, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 226, 45,  0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   72,  255,
     255, 255, 255, 0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  95,  104, 149, 255, 255, 255, 253, 104, 104, 104, 104, 104, 104, 95,  25,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   12,  73,  100, 104, 104, 104, 104, 104, 104, 104, 104, 125, 227, 255, 255, 255,
     255, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   163, 247, 255, 255, 255, 255, 255, 255, 255, 255, 236, 103, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   39,  156, 226, 252, 255, 255, 255, 255, 255, 255, 255, 255, 246, 211, 125, 13,  0,   0,   0,   0,   220, 255, 255,
     255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  200, 240, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  182, 242, 160, 4,   0,   0,
     0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255,
     144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  242, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255,
     108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255,
     255, 144, 0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   177, 255,
     255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   141, 255, 255, 255, 104, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   197, 255, 255, 255, 137, 0,   33,  200, 240, 136, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  183, 242, 160, 4,   0,   34,  200, 240, 133, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  183, 242, 160, 4,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255,
     144, 0,   33,  200, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 160, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   87,  188, 238, 235, 101, 0,
     0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   220, 255, 255,
     255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   219, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   183, 255,
     255, 255, 147, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  242, 255, 255, 255, 117, 0,   177, 255, 255, 255, 154, 1,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   20,  211, 255, 255, 255, 100, 0,   178, 255, 255, 255, 66,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   143, 255, 255, 255, 102, 0,   0,   0,
     0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   177, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   10,  177, 255, 255, 255, 255, 252, 33,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   184, 255, 255, 255, 144, 0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   49,  101, 104, 104, 104, 104, 104, 104, 104,
     104, 104, 104, 104, 104, 122, 225, 255, 255, 255, 255, 53,  0,   203, 255, 255, 255, 255, 152, 1,   0,   0,   0,   0,   0,   0,   0,   0,   19,  209, 255, 255, 255, 255, 126, 0,   219, 255, 255,
     255, 107, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   183, 255, 255, 255, 143, 0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   184, 255, 255, 255, 144, 0,   203, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 126, 0,   0,   0,   0,   0,   0,   2,   181, 255, 255,
     255, 255, 255, 255, 58,  0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   72,  255, 255, 255, 255, 0,   0,   0,   0,
     0,   0,   219, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   28,  135, 114, 6,   0,
     0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   183, 255, 255, 255, 143, 0,   92,  253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 195, 0,   0,   94,  255, 255, 255,
     255, 255, 149, 0,   0,   0,   0,   0,   0,   0,   17,  206, 255, 255, 255, 255, 240, 33,  0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255,
     255, 144, 0,   0,   0,   0,   220, 255, 255, 255, 109, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   185, 255, 255, 255, 144, 0,   94,  254, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 240, 33,  0,   0,   0,   0,   0,   0,   103, 255, 255, 255, 255, 255, 255, 197, 4,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 67,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   11,  224, 255, 255, 164, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   76,  255, 255, 255,
     252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   143, 255, 255, 255, 105, 0,   203, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 38,  0,   0,   0,   124, 255, 255, 255, 255, 255, 145, 0,   0,   0,   0,   0,   16,  204, 255, 255, 255, 255, 242, 56,
     0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   220, 255, 255, 255, 226, 33,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   84,  252, 255, 255, 255, 144, 0,   0,   50,  102, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 123, 251, 255, 255, 255, 255, 242, 57,  0,   0,   0,   0,   0,   0,
     0,   220, 255, 255, 255, 250, 147, 85,  7,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   72,  255, 255, 255,
     255, 0,   0,   0,   0,   0,   0,   39,  204, 241, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   63,
     255, 255, 255, 247, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  185, 243, 167, 6,   0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 228, 50,  0,   0,
     0,   0,   0,   134, 255, 255, 255, 255, 255, 143, 0,   0,   0,   15,  202, 255, 255, 255, 255, 243, 58,  0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   220, 255, 255, 255, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   78,  250, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   16,  206, 255, 255, 255, 255, 244, 60,  0,   0,   0,   0,   0,   0,   0,   35,  255, 255, 255, 255, 98,  0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,
     0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     33,  200, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 211, 127, 14,  0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 255, 255, 139, 0,   13,  199, 255, 255, 255,
     255, 244, 61,  0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   193, 255, 255, 255, 255, 255,
     220, 27,  0,   0,   0,   0,   0,   0,   73,  249, 255, 255, 255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  200, 255, 255, 255, 255, 245, 63,  0,   0,   0,
     0,   0,   0,   0,   0,   64,  255, 255, 255, 255, 11,  0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144,
     0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   3,   158, 244, 230, 165, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255,
     108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   31,  150, 223, 248, 230, 165, 49,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   153, 255, 255, 255, 255, 255, 141, 196, 255, 255, 255, 255, 245, 64,  0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   60,  248, 255, 255, 255, 255, 255, 217, 24,  0,   0,   0,   0,   68,  247, 255, 255, 255, 255, 255, 218, 14,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  195, 255, 255, 255, 255, 247, 67,  0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,
     220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   99,  255, 255, 255, 255,
     252, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255,
     148, 0,   0,   0,   0,   0,   76,  255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  246, 255, 255, 255, 255, 255, 253, 118, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   162, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 246, 67,  0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,
     76,  250, 255, 255, 255, 255, 255, 213, 21,  0,   0,   63,  245, 255, 255, 255, 255, 255, 222, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   189, 255, 255, 255, 255, 248, 71,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   215, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     184, 255, 255, 255, 144, 0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   127, 255, 255, 255, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   71,  255, 255, 255, 254, 6,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   71,  253, 255, 255, 255, 255, 255, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   170, 255, 255, 255, 255, 255, 255, 255, 247, 70,  0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   82,  251, 255, 255, 255, 255, 255, 209, 19,  59,  243, 255, 255, 255, 255, 255,
     225, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   182, 255, 255, 255, 255, 249, 75,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,
     0,   0,   0,   0,   0,   191, 255, 255, 255, 197, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,
     34,  238, 255, 255, 255, 255, 255, 250, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,
     0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   47,  255, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  234, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 38,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     5,   178, 255, 255, 255, 255, 255, 248, 73,  0,   0,   0,   0,   0,   0,   0,   0,   219, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144,
     0,   0,   0,   0,   0,   0,   0,   87,  252, 255, 255, 255, 255, 255, 211, 241, 255, 255, 255, 255, 255, 229, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   176, 255, 255, 255,
     255, 250, 79,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 255, 255, 194, 112, 104, 104, 104, 104, 104,
     104, 104, 104, 104, 104, 213, 255, 255, 255, 144, 0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   26,  100, 180, 255, 255, 255, 255, 147, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   2,   234, 255, 255, 255, 248,
     143, 104, 104, 104, 104, 95,  25,  0,   0,   112, 255, 255, 255, 255, 198, 118, 180, 255, 255, 255, 255, 151, 0,   0,   0,   0,   0,   75,  137, 57,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   177, 255, 255, 255, 255, 255, 248, 73,  0,   0,   0,   0,   0,   0,   0,   0,
     206, 255, 255, 255, 149, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   94,  253, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 232, 39,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   169, 255, 255, 255, 255, 251, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  255,
     255, 255, 249, 0,   0,   0,   0,   0,   0,   0,   22,  243, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   72,  255, 255, 255, 255, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   170, 255, 255, 255, 218, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255,
     255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   122, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 237, 34,  0,   184, 255, 255, 255, 203, 3,   0,   0,
     169, 255, 255, 255, 221, 0,   0,   0,   0,   84,  255, 255, 252, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   3,   170, 255, 255, 255, 255, 255, 255, 255, 247, 69,  0,   0,   0,   0,   0,   0,   0,   162, 255, 255, 255, 250, 93,  8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 254, 255, 255, 255, 255, 255, 255, 255, 255, 235, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   162,
     255, 255, 255, 255, 252, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   170, 255, 255, 255, 221, 0,   0,   0,   0,   0,   0,   0,   0,   93,  255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 142, 0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  255, 255, 255, 247, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 108, 0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   184, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,
     6,   197, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 130, 0,   212, 255, 255, 255, 117, 0,   0,   0,   81,  255, 255, 255, 249, 1,   0,   0,   0,   174, 255, 255, 255, 135, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   161, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 66,  0,
     0,   0,   0,   0,   0,   70,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   106, 255,
     255, 255, 255, 255, 255, 255, 238, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   154, 255, 255, 255, 255, 253, 93,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     25,  98,  172, 255, 255, 255, 255, 153, 0,   0,   0,   0,   0,   0,   0,   0,   0,   101, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   72,
     255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   215, 255, 255, 255, 117, 0,
     0,   0,   81,  255, 255, 255, 255, 9,   0,   0,   0,   193, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   17,  190, 255, 255, 255, 255, 255, 255, 255, 255, 255, 102, 0,   173, 255, 255,
     255, 58,  0,   0,   0,   53,  255, 255, 255, 255, 46,  0,   0,   5,   228, 255, 255, 255, 127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 255, 254, 96,  164, 255, 255, 255, 255, 245, 63,  0,   0,   0,   0,   0,   0,   179, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 255, 255, 241, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   147, 255, 255, 255, 255, 254, 97,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  237, 255, 255, 255, 255, 255, 253, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   39,  156, 226, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 160, 4,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255,
     255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   191, 255, 255, 255, 197, 2,   0,   0,   166, 255, 255, 255, 255, 92,  0,   0,   30,  245, 255, 255, 255, 118, 0,
     0,   0,   0,   0,   0,   0,   0,   2,   94,  192, 240, 255, 255, 255, 255, 247, 160, 4,   0,   31,  199, 239, 127, 0,   0,   0,   0,   10,  247, 255, 255, 255, 204, 41,  20,  157, 255, 255, 255,
     255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   143, 255, 255, 255, 255, 255, 103, 0,   3,   172,
     255, 255, 255, 255, 244, 61,  0,   0,   0,   0,   0,   15,  201, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   118, 255, 255, 255, 243, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 255, 255, 254, 101, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   127, 255, 255, 255, 255, 255, 255, 123, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   125,
     255, 255, 255, 255, 195, 117, 178, 255, 255, 255, 255, 255, 249, 144, 123, 228, 255, 255, 255, 255, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   162, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 228, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 255, 255, 255, 255, 112, 0,   0,   0,   5,   181, 255, 255, 255, 255, 243, 58,  0,   0,   0,   0,   0,   9,   140, 248, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 236, 215, 58,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   131, 255, 255, 255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 255, 255, 255, 144, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  243, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 192, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  238, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 87,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 255, 255, 122,
     0,   0,   0,   0,   0,   8,   188, 255, 255, 255, 255, 242, 56,  0,   0,   0,   0,   0,   0,   14,  74,  100, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 213, 255, 255, 255, 144, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   122, 255, 255, 255, 255, 255, 200, 104, 104, 104, 104, 104, 104,
     104, 104, 104, 104, 104, 95,  25,  0,   0,   4,   160, 247, 255, 255, 255, 255, 255, 82,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   65,  255, 255, 255, 255, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   93,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 237, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   66,  243, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255, 255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   11,  196, 255, 255, 255, 255, 240, 33,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 237, 33,  0,   0,   0,   4,   72,  238, 255, 255, 255,
     190, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   38,  255, 255, 255, 255, 97,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   101, 250, 255, 255, 255, 255, 255, 244, 74,  187, 255,
     255, 255, 255, 255, 255, 228, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   44,  194, 255, 255, 255, 255, 226, 85,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   203, 255, 255,
     255, 255, 141, 0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  203, 255, 255, 255, 255, 126, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   190, 255,
     255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   203, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 126, 0,   0,   0,   0,   0,   113, 255, 255, 255, 239, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   225, 255, 255, 255, 249, 139, 84,  6,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  156, 226, 249, 231, 161, 35,  0,   1,   93,  191, 240, 246, 211, 127, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  88,  94,  58,  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 150, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  209, 255, 255,
     255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  242, 255, 255, 255, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0,   0,   0,   0,
     0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255,
     255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 255, 255, 255, 195, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   33,  200, 240, 136, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  183, 242, 160, 4,   0,   0,   0,   0,   0,   0,   25,  95,  104, 104, 104, 104, 104, 104, 104,
     104, 122, 225, 255, 255, 255, 255, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  200, 254, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 160, 4,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   70,  255, 255, 255, 254, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   192, 255, 255,
     255, 255, 255, 255, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  238, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 195, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   31,  252, 255, 255, 210, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  201, 255, 255, 255, 255, 255, 252, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 38,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   101, 235, 214, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   155, 255, 255, 255, 255, 255, 236, 103, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 228, 50,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   69,  255, 255, 255, 255, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  249, 255, 255, 255, 202, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     5,   162, 247, 255, 255, 255, 255, 255, 255, 255, 255, 246, 211, 127, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  255, 255, 255, 255, 88,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   235, 255, 255, 255, 248, 143, 84,  6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   71,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     126, 255, 255, 255, 255, 255, 255, 195, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   200, 255, 255, 255, 255, 255, 255, 58,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   18,  192, 255, 255, 255, 255, 252, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   95,  192, 240, 236, 103, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255,
     255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 229, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     25,  99,  174, 255, 255, 255, 255, 165, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  237, 255, 255, 255, 255, 255, 254, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   127, 255, 255, 255, 255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 255, 255, 134, 1,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   160, 245, 232, 170, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
    45.000000f, 34.290001f, 0.000001f, 30.000000f, -4.290000f, 96, {{L'\0', 0, 0, 0, 0, 0.000000f, 0.000000f, 0.011719f, 0.011719f, 0.015625f, 0.015625f, 0, {}},
                                                                    {L' ', 0, 0, 0, 0, 25.718750f, 0.000000f, 0.023438f, 0.003906f, 0.023438f, 0.003906f, 0, {}},
                                                                    {L'!', 9, 31, 6, 31, 25.718750f, 0.000000f, 0.027344f, 0.003906f, 0.062500f, 0.125000f, 0, {}},
                                                                    {L'"', 14, 9, 6, 31, 25.718750f, 0.000000f, 0.066406f, 0.003906f, 0.121094f, 0.039062f, 0, {}},
                                                                    {L'#', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.125000f, 0.003906f, 0.210938f, 0.125000f, 0, {}},
                                                                    {L'$', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.214844f, 0.003906f, 0.300781f, 0.125000f, 0, {}},
                                                                    {L'%', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.304688f, 0.003906f, 0.390625f, 0.125000f, 0, {}},
                                                                    {L'&', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.394531f, 0.003906f, 0.480469f, 0.125000f, 0, {}},
                                                                    {L'\'', 5, 9, 10, 31, 25.718750f, 0.000000f, 0.484375f, 0.003906f, 0.503906f, 0.039062f, 0, {}},
                                                                    {L'(', 10, 31, 10, 31, 25.718750f, 0.000000f, 0.507812f, 0.003906f, 0.546875f, 0.125000f, 0, {}},
                                                                    {L')', 9, 31, 6, 31, 25.718750f, 0.000000f, 0.550781f, 0.003906f, 0.585938f, 0.125000f, 0, {}},
                                                                    {L'*', 22, 23, 2, 31, 25.718750f, 0.000000f, 0.589844f, 0.003906f, 0.675781f, 0.093750f, 0, {}},
                                                                    {L'+', 22, 22, 2, 26, 25.718750f, 0.000000f, 0.679688f, 0.003906f, 0.765625f, 0.089844f, 0, {}},
                                                                    {L',', 9, 13, 6, 9, 25.718750f, 0.000000f, 0.769531f, 0.003906f, 0.804688f, 0.054688f, 0, {}},
                                                                    {L'-', 22, 5, 2, 18, 25.718750f, 0.000000f, 0.808594f, 0.003906f, 0.894531f, 0.023438f, 0, {}},
                                                                    {L'.', 9, 9, 6, 9, 25.718750f, 0.000000f, 0.898438f, 0.003906f, 0.933594f, 0.039062f, 0, {}},
                                                                    {L'/', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.808594f, 0.027344f, 0.894531f, 0.148438f, 0, {}},
                                                                    {L'0', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.898438f, 0.042969f, 0.984375f, 0.164062f, 0, {}},
                                                                    {L'1', 14, 31, 6, 31, 25.718750f, 0.000000f, 0.066406f, 0.042969f, 0.121094f, 0.164062f, 0, {}},
                                                                    {L'2', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.679688f, 0.093750f, 0.765625f, 0.214844f, 0, {}},
                                                                    {L'3', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.589844f, 0.097656f, 0.675781f, 0.218750f, 0, {}},
                                                                    {L'4', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.484375f, 0.128906f, 0.570312f, 0.250000f, 0, {}},
                                                                    {L'5', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.125000f, 0.128906f, 0.210938f, 0.250000f, 0, {}},
                                                                    {L'6', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.214844f, 0.128906f, 0.300781f, 0.250000f, 0, {}},
                                                                    {L'7', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.304688f, 0.128906f, 0.390625f, 0.250000f, 0, {}},
                                                                    {L'8', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.394531f, 0.128906f, 0.480469f, 0.250000f, 0, {}},
                                                                    {L'9', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.769531f, 0.152344f, 0.855469f, 0.273438f, 0, {}},
                                                                    {L':', 9, 26, 6, 26, 25.718750f, 0.000000f, 0.023438f, 0.128906f, 0.058594f, 0.230469f, 0, {}},
                                                                    {L';', 9, 31, 6, 27, 25.718750f, 0.000000f, 0.859375f, 0.152344f, 0.894531f, 0.273438f, 0, {}},
                                                                    {L'<', 18, 31, 2, 31, 25.718750f, 0.000000f, 0.898438f, 0.167969f, 0.968750f, 0.289062f, 0, {}},
                                                                    {L'=', 22, 14, 2, 22, 25.718750f, 0.000000f, 0.679688f, 0.218750f, 0.765625f, 0.273438f, 0, {}},
                                                                    {L'>', 18, 31, 6, 31, 25.718750f, 0.000000f, 0.574219f, 0.222656f, 0.644531f, 0.343750f, 0, {}},
                                                                    {L'?', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.003906f, 0.234375f, 0.089844f, 0.355469f, 0, {}},
                                                                    {L'@', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.093750f, 0.253906f, 0.179688f, 0.375000f, 0, {}},
                                                                    {L'A', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.183594f, 0.253906f, 0.269531f, 0.375000f, 0, {}},
                                                                    {L'B', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.273438f, 0.253906f, 0.359375f, 0.375000f, 0, {}},
                                                                    {L'C', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.363281f, 0.253906f, 0.449219f, 0.375000f, 0, {}},
                                                                    {L'D', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.453125f, 0.253906f, 0.539062f, 0.375000f, 0, {}},
                                                                    {L'E', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.648438f, 0.277344f, 0.734375f, 0.398438f, 0, {}},
                                                                    {L'F', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.738281f, 0.277344f, 0.824219f, 0.398438f, 0, {}},
                                                                    {L'G', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.828125f, 0.292969f, 0.914062f, 0.414062f, 0, {}},
                                                                    {L'H', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.542969f, 0.347656f, 0.628906f, 0.468750f, 0, {}},
                                                                    {L'I', 14, 31, 6, 31, 25.718750f, 0.000000f, 0.917969f, 0.292969f, 0.972656f, 0.414062f, 0, {}},
                                                                    {L'J', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.003906f, 0.359375f, 0.089844f, 0.480469f, 0, {}},
                                                                    {L'K', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.093750f, 0.378906f, 0.179688f, 0.500000f, 0, {}},
                                                                    {L'L', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.183594f, 0.378906f, 0.269531f, 0.500000f, 0, {}},
                                                                    {L'M', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.273438f, 0.378906f, 0.359375f, 0.500000f, 0, {}},
                                                                    {L'N', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.363281f, 0.378906f, 0.449219f, 0.500000f, 0, {}},
                                                                    {L'O', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.453125f, 0.378906f, 0.539062f, 0.500000f, 0, {}},
                                                                    {L'P', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.632812f, 0.402344f, 0.718750f, 0.523438f, 0, {}},
                                                                    {L'Q', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.722656f, 0.402344f, 0.808594f, 0.523438f, 0, {}},
                                                                    {L'R', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.812500f, 0.417969f, 0.898438f, 0.539062f, 0, {}},
                                                                    {L'S', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.902344f, 0.417969f, 0.988281f, 0.539062f, 0, {}},
                                                                    {L'T', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.542969f, 0.472656f, 0.628906f, 0.593750f, 0, {}},
                                                                    {L'U', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.003906f, 0.484375f, 0.089844f, 0.605469f, 0, {}},
                                                                    {L'V', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.093750f, 0.503906f, 0.179688f, 0.625000f, 0, {}},
                                                                    {L'W', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.183594f, 0.503906f, 0.269531f, 0.625000f, 0, {}},
                                                                    {L'X', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.273438f, 0.503906f, 0.359375f, 0.625000f, 0, {}},
                                                                    {L'Y', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.363281f, 0.503906f, 0.449219f, 0.625000f, 0, {}},
                                                                    {L'Z', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.453125f, 0.503906f, 0.539062f, 0.625000f, 0, {}},
                                                                    {L'[', 10, 31, 10, 31, 25.718750f, 0.000000f, 0.632812f, 0.527344f, 0.671875f, 0.648438f, 0, {}},
                                                                    {L'\\', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.675781f, 0.527344f, 0.761719f, 0.648438f, 0, {}},
                                                                    {L']', 9, 31, 6, 31, 25.718750f, 0.000000f, 0.765625f, 0.527344f, 0.800781f, 0.648438f, 0, {}},
                                                                    {L'^', 22, 13, 2, 31, 25.718750f, 0.000000f, 0.804688f, 0.542969f, 0.890625f, 0.593750f, 0, {}},
                                                                    {L'_', 22, 5, 2, 1, 25.718750f, 0.000000f, 0.894531f, 0.542969f, 0.980469f, 0.562500f, 0, {}},
                                                                    {L'`', 10, 9, 10, 31, 25.718750f, 0.000000f, 0.894531f, 0.566406f, 0.933594f, 0.601562f, 0, {}},
                                                                    {L'a', 22, 22, 2, 22, 25.718750f, 0.000000f, 0.542969f, 0.597656f, 0.628906f, 0.683594f, 0, {}},
                                                                    {L'b', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.804688f, 0.597656f, 0.890625f, 0.718750f, 0, {}},
                                                                    {L'c', 22, 22, 2, 22, 25.718750f, 0.000000f, 0.894531f, 0.605469f, 0.980469f, 0.691406f, 0, {}},
                                                                    {L'd', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.003906f, 0.609375f, 0.089844f, 0.730469f, 0, {}},
                                                                    {L'e', 22, 22, 2, 22, 25.718750f, 0.000000f, 0.093750f, 0.628906f, 0.179688f, 0.714844f, 0, {}},
                                                                    {L'f', 18, 31, 6, 31, 25.718750f, 0.000000f, 0.183594f, 0.628906f, 0.253906f, 0.750000f, 0, {}},
                                                                    {L'g', 22, 26, 2, 22, 25.718750f, 0.000000f, 0.257812f, 0.628906f, 0.343750f, 0.730469f, 0, {}},
                                                                    {L'h', 22, 31, 2, 31, 25.718750f, 0.000000f, 0.347656f, 0.628906f, 0.433594f, 0.750000f, 0, {}},
                                                                    {L'i', 14, 31, 6, 31, 25.718750f, 0.000000f, 0.437500f, 0.628906f, 0.492188f, 0.750000f, 0, {}},
                                                                    {L'j', 18, 35, 2, 31, 25.718750f, 0.000000f, 0.632812f, 0.652344f, 0.703125f, 0.789062f, 0, {}},
                                                                    {L'k', 18, 31, 6, 31, 25.718750f, 0.000000f, 0.707031f, 0.652344f, 0.777344f, 0.773438f, 0, {}},
                                                                    {L'l', 14, 31, 6, 31, 25.718750f, 0.000000f, 0.496094f, 0.687500f, 0.550781f, 0.808594f, 0, {}},
                                                                    {L'm', 22, 22, 2, 22, 25.718750f, 0.000000f, 0.894531f, 0.695312f, 0.980469f, 0.781250f, 0, {}},
                                                                    {L'n', 22, 22, 2, 22, 25.718750f, 0.000000f, 0.093750f, 0.718750f, 0.179688f, 0.804688f, 0, {}},
                                                                    {L'o', 22, 22, 2, 22, 25.718750f, 0.000000f, 0.781250f, 0.722656f, 0.867188f, 0.808594f, 0, {}},
                                                                    {L'p', 22, 26, 2, 22, 25.718750f, 0.000000f, 0.003906f, 0.734375f, 0.089844f, 0.835938f, 0, {}},
                                                                    {L'q', 22, 26, 2, 22, 25.718750f, 0.000000f, 0.257812f, 0.734375f, 0.343750f, 0.835938f, 0, {}},
                                                                    {L'r', 18, 22, 6, 22, 25.718750f, 0.000000f, 0.554688f, 0.687500f, 0.625000f, 0.773438f, 0, {}},
                                                                    {L's', 22, 22, 2, 22, 25.718750f, 0.000000f, 0.347656f, 0.753906f, 0.433594f, 0.839844f, 0, {}},
                                                                    {L't', 18, 31, 6, 31, 25.718750f, 0.000000f, 0.183594f, 0.753906f, 0.253906f, 0.875000f, 0, {}},
                                                                    {L'u', 22, 22, 2, 22, 25.718750f, 0.000000f, 0.871094f, 0.785156f, 0.957031f, 0.871094f, 0, {}},
                                                                    {L'v', 22, 22, 2, 22, 25.718750f, 0.000000f, 0.628906f, 0.792969f, 0.714844f, 0.878906f, 0, {}},
                                                                    {L'w', 22, 22, 2, 22, 25.718750f, 0.000000f, 0.093750f, 0.808594f, 0.179688f, 0.894531f, 0, {}},
                                                                    {L'x', 22, 22, 2, 22, 25.718750f, 0.000000f, 0.437500f, 0.812500f, 0.523438f, 0.898438f, 0, {}},
                                                                    {L'y', 22, 26, 2, 22, 25.718750f, 0.000000f, 0.527344f, 0.812500f, 0.613281f, 0.914062f, 0, {}},
                                                                    {L'z', 22, 22, 2, 22, 25.718750f, 0.000000f, 0.718750f, 0.812500f, 0.804688f, 0.898438f, 0, {}},
                                                                    {L'{', 14, 31, 6, 31, 25.718750f, 0.000000f, 0.808594f, 0.812500f, 0.863281f, 0.933594f, 0, {}},
                                                                    {L'|', 5, 31, 10, 31, 25.718750f, 0.000000f, 0.960938f, 0.785156f, 0.980469f, 0.906250f, 0, {}},
                                                                    {L'}', 14, 31, 6, 31, 25.718750f, 0.000000f, 0.003906f, 0.839844f, 0.058594f, 0.960938f, 0, {}},
                                                                    {L'~', 22, 14, 2, 31, 25.718750f, 0.000000f, 0.257812f, 0.839844f, 0.343750f, 0.894531f, 0, {}}, }};
#ifdef __cplusplus
}
#endif
