/* ============================================================================
 * Freetype GL - A C OpenGL Freetype engine
 * Platform:    Any
 * WWW:         http://code.google.com/p/freetype-gl/
 * ----------------------------------------------------------------------------
 * Copyright 2011,2012 Nicolas P. Rougier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY NICOLAS P. ROUGIER ''AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL NICOLAS P. ROUGIER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of Nicolas P. Rougier.
 * ===============================================================================
 */
#include <stddef.h>
#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
  wchar_t charcode;
  float kerning;
} kerning_t;

typedef struct {
  wchar_t charcode;
  int width, height;
  int offset_x, offset_y;
  float advance_x, advance_y;
  float s0, t0, s1, t1;
  size_t kerning_count;
  kerning_t kerning[1];
} texture_glyph_t;

typedef struct {
  size_t tex_width;
  size_t tex_height;
  size_t tex_depth;
  unsigned char tex_data[65536];
  float size;
  float height;
  float linegap;
  float ascender;
  float descender;
  size_t glyphs_count;
  texture_glyph_t glyphs[96];
} texture_font_t;

texture_font_t font_data = {
    256, 256, 1,
    {0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 0,   0,   0,   0,   3,   38,  0,   140, 255, 255, 132, 0,
     248, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   107, 117, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   113, 255, 255, 255, 197, 12,  0,   0,   0,   0,   0,   0,   0,   0,   1,   46,  113, 179, 75,  0,   0,   0,   0,   0,   114, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   114, 255, 255, 255, 255, 255, 125, 0,   38,  230, 255, 255, 255, 255, 200, 14,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   64,  0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,
     2,   28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  19,  0,   0,   0,   15,  28,  28,  14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  9,
     0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 22,  0,   0,   0,   0,   22,  0,   127, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 135, 22,  0,   0,   0,   255, 255, 255, 255, 0,   0,   0,   2,   164, 104, 0,   140, 255, 255, 132, 0,   248, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   63,  211, 27,  0,   0,   0,
     42,  213, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 98,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   54,  255, 255, 255, 255, 255, 152, 0,
     0,   0,   0,   0,   0,   0,   1,   198, 255, 255, 195, 0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   140, 255, 255,
     132, 0,   0,   0,   57,  255, 255, 255, 255, 255, 127, 0,   0,   0,   40,  232, 255, 255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   5,   176, 117, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   4,   174, 251, 81,  0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   1,   159, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 68,  0,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   76,  143, 210, 198, 1,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 143,
     82,  147, 0,   0,   0,   129, 104, 0,   0,   134, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 141, 82,  147, 0,   0,   0,   255, 255, 255, 255, 0,   0,   2,   161, 255, 104, 0,
     140, 255, 255, 132, 0,   248, 255, 255, 24,  0,   0,   0,   0,   0,   0,   24,  244, 255, 204, 0,   0,   2,   230, 255, 230, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     128, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   106, 93,  136, 255, 255, 255, 212, 49,  160, 9,   0,   0,   0,   0,   0,   96,  255, 255, 253, 50,  0,   0,   0,   0,   104, 92,
     138, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   104, 92,  138, 255, 255, 255, 130, 0,   0,   0,   0,   0,   42,  233,
     255, 255, 215, 45,  160, 12,  0,   0,   0,   0,   0,   0,   139, 255, 255, 75,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   59,  255, 255, 211, 0,   0,   0,   0,   0,   0,   0,   140,
     255, 255, 132, 0,   77,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 226, 6,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   95,
     255, 255, 254, 54,  0,   0,   140, 253, 90,  140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 150, 78,  250, 152, 0,   0,   124, 255, 104, 0,   0,   0,   140, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 147, 77,  250, 152, 0,   0,   0,   255, 255, 255, 255, 0,   0,   132, 255, 255, 104, 0,   140, 255, 255, 132, 0,   248, 255, 255, 24,  0,   0,   0,   0,   0,   0,   40,  255,
     255, 232, 0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   86,  255, 253, 77,  27,
     28,  28,  24,  220, 255, 179, 0,   0,   0,   0,   12,  230, 255, 255, 154, 0,   0,   0,   0,   83,  254, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  1,   0,   0,   0,   0,   0,
     0,   0,   140, 255, 255, 132, 0,   83,  254, 252, 76,  27,  28,  26,  0,   0,   0,   0,   0,   0,   0,   14,  28,  28,  18,  210, 255, 192, 0,   0,   0,   0,   0,   0,   164, 255, 255, 100, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 239,
     49,  0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  229, 255, 255, 161, 0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,
     28,  28,  28,  61,  248, 255, 152, 0,   108, 255, 255, 104, 0,   0,   0,   0,   27,  28,  28,  28,  28,  28,  28,  28,  28,  27,  61,  248, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     168, 255, 255, 104, 0,   140, 255, 255, 132, 0,   248, 255, 255, 24,  0,   0,   0,   0,   0,   0,   40,  255, 255, 232, 0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   36,  255, 255, 236, 0,   0,   0,   0,   136, 255, 255, 240, 21,  0,   0,
     0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   51,  156, 205, 87,  0,   163, 255, 255, 99,  12,  127, 207, 140, 28,  0,   0,   0,   0,   0,   0,   60,  255, 255, 212, 0,   0,   0,
     0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   130, 255, 255, 243, 25,  0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   168, 255, 255, 104, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   17,  28,  28,  12,  0,   0,   168, 255, 255, 104, 0,   100, 255, 255, 91,  0,   208, 255, 227, 11,  0,   0,   0,
     0,   0,   0,   40,  255, 255, 232, 0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   64,  128, 128, 72,  0,   0,   0,   0,   0,   0,   0,   0,
     140, 255, 255, 132, 0,   0,   0,   36,  255, 255, 236, 0,   0,   0,   35,  248, 255, 255, 112, 0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 91,  0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   85,  255, 255, 255, 166,
     79,  255, 244, 40,  226, 255, 255, 255, 32,  0,   0,   2,   28,  28,  28,  32,  229, 255, 152, 18,  28,  28,  19,  0,   0,   0,   140, 255, 255, 132, 0,   0,   124, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 135, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  246, 255, 255, 121, 0,   0,   0,   0,   140, 255, 255, 132, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   156,
     255, 255, 116, 0,   0,   168, 255, 255, 104, 0,   0,   126, 113, 0,   0,   22,  183, 34,  0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 232, 0,   0,   4,   255, 255, 255, 4,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 145, 0,   0,   140, 255, 255, 132, 0,   0,   0,   36,  255, 255, 236, 0,   0,   0,   176, 255, 255,
     214, 4,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   126, 113, 0,   0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   18,  245, 255, 255, 255, 76,  194, 130, 143, 255, 255, 255, 216, 0,   0,   1,   159, 255, 255, 255, 193, 50,
     145, 67,  245, 255, 255, 247, 67,  0,   0,   91,  255, 254, 83,  0,   0,   0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 143, 82,  147, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 222, 7,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   168, 255, 255, 104,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   156, 255, 255, 116, 0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   27,  28,  28,  24,  219, 255, 172, 15,  28,  14,  199, 255, 199, 14,  28,  28,  25,  0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 88,  0,   140, 255, 255, 132, 0,   0,   0,   36,  255, 255, 236, 0,   0,   67,  255, 255, 255, 70,  0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   21,  40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,
     0,   28,  162, 254, 255, 223, 57,  54,  251, 255, 247, 138, 17,  0,   0,   77,  255, 255, 255, 255, 255, 126, 6,   224, 255, 255, 255, 255, 223, 5,   0,   0,   114, 101, 0,   0,   0,   0,   0,
     140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 150, 78,  250, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  255, 255, 255, 82,  0,   0,   0,   0,   0,   140,
     255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255,
     152, 0,   0,   0,   156, 255, 255, 116, 0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   141, 255, 255, 255, 206, 46,  152, 54,  237, 255, 224, 46,  155,
     48,  226, 255, 255, 255, 116, 0,   0,   0,   104, 92,  138, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 166, 2,   0,   140, 255, 255, 132, 0,   0,   0,   36,  255, 255, 236, 0,
     3,   211, 255, 255, 177, 0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  209, 230, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132,
     255, 255, 255, 171, 59,  173, 53,  234, 255, 255, 238, 47,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  61,  248, 255, 152, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   200, 255, 255, 189, 0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152,
     0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 146, 0,   200, 255, 255, 255, 172, 0,   173, 255, 255, 255, 255, 251, 36,  0,   83,  254, 252, 76,  27,  28,  28,  28,  28,
     28,  28,  28,  28,  28,  28,  28,  3,   0,   0,   84,  254, 252, 76,  27,  28,  28,  24,  217, 255, 176, 0,   107, 255, 255, 248, 35,  0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 151, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     20,  255, 255, 252, 0,   0,   27,  161, 254, 255, 225, 59,  26,  250, 255, 247, 125, 8,   0,   0,   0,   0,   0,   0,   0,   32,  240, 255, 169, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 252, 45,  0,   0,
     0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 186, 54,  181, 48,
     225, 255, 209, 46,  184, 47,  211, 255, 255, 253, 90,  0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   91,  80,  136, 255, 255, 255,
     212, 43,  140, 6,   6,   236, 255, 255, 135, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   18,  245, 255, 255, 255, 83,  191, 134, 131, 255, 255, 255,
     200, 0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  227, 255, 255, 151, 0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   112, 255, 255, 152, 0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255,
     255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  235, 255, 193, 0,   0,   1,   219, 255, 219, 1,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   54,  255, 255, 255, 255, 255, 152, 0,   0,   0,   225, 255, 230, 12,  0,   0,   0,   0,   0,   0,   0,   0,
     140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   19,  255, 255, 252, 0,   83,  255, 255, 255, 181, 71,  255, 246, 20,  205, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   60,  255, 255, 212, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255,
     239, 20,  0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   167, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   121, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   40,  255, 255, 232, 0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   113, 255, 255, 255, 197, 12,  0,   0,   0,   158, 252, 90,  0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  27,  203, 255,
     140, 3,   0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   143, 255, 244, 0,   55,  161, 203, 95,  2,   161, 255,
     255, 99,  5,   113, 206, 148, 31,  0,   0,   0,   0,   0,   0,   58,  255, 255, 210, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   66,  255, 255, 111, 0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 223, 30,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   21,  213, 255, 145, 0,   51,  239, 255, 96,  0,   0,   0,   10,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  27,  203, 255, 140, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   144, 235, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 232, 0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,
     0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  16,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 46,  153, 49,  215, 57,  0,   0,   0,   0,   0,   0,   0,   13,  169, 32,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 73,  0,   0,   0,   0,   0,   0,   164, 255, 255, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   158, 247, 67,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   7,   244, 188, 4,   0,   0,   0,   0,   0,   0,   0,   0,   13,  169, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  170, 18,  0,   0,   54,  156, 3,   0,   0,
     21,  212, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 219, 45,  153, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   27,  28,  28,  23,  216, 255, 168, 15,  28,  14,  195, 255, 195, 14,  28,  28,  25,  0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   73,  148, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 170, 0,   186, 255, 214, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   138, 255, 255, 74,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   46,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 167, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   141, 255, 255, 255, 206, 43,  141, 53,  237, 255, 224, 44,  144, 45,  226,
     255, 255, 255, 116, 0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   209, 255, 255, 86,  0,
     0,   3,   28,  28,  28,  5,   0,   0,   0,   0,   13,  178, 49,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 44,  179, 41,  189, 39,  0,   0,   0,   0,   0,   0,   0,   10,  166,
     32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 68,  0,   0,   0,   0,   0,   0,   4,   173, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   54,  129, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  166, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  168, 15,  0,   0,
     53,  153, 2,   0,   0,   10,  194, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 43,  179, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   177, 246, 53,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 146, 0,   200, 255, 255, 255, 172, 0,   173, 255, 255, 255, 255, 251, 36,  0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 255, 255, 244, 25,  0,   5,   173, 255, 255, 255, 184, 7,   0,   0,   0,   132, 255, 228, 34,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   25,  218, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   142,
     255, 242, 0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   77,  255, 255, 243, 2,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   130, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  212, 255, 142, 0,   51,  239, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     25,  218, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 186, 51,  179, 46,  225, 255,
     209, 45,  182, 45,  211, 255, 255, 253, 90,  0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  235,
     255, 255, 124, 0,   0,   98,  255, 255, 255, 255, 255, 104, 0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   139, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   99,  150, 0,   0,   0,   0,   0,   0,   10,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  27,  203, 255,
     140, 0,   0,   0,   0,   0,   0,   0,   5,   218, 255, 255, 162, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111,
     255, 255, 152, 0,   167, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  233, 255, 189, 0,   0,   1,   216, 255, 216, 1,   0,   0,   0,   0,   0,   0,   127, 255, 214, 33,  28,  28,
     28,  28,  28,  28,  28,  28,  28,  28,  11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   145, 255, 255, 225, 8,   5,   169, 76,  146, 255, 255, 255, 160, 71,  170, 4,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   20,  255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  28,  28,  12,  0,   140, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   93,
     253, 152, 0,   0,   0,   0,   0,   21,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 46,  153, 12,  0,   0,   0,   0,   0,   0,   0,   115, 255, 255, 245, 27,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,
     255, 255, 232, 0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   7,   152, 46,  212, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 28,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   42,  251, 255, 255, 88,  0,   147, 255, 250, 53,  0,   0,   0,   40,  246, 255, 150, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   156, 255, 255, 116, 0,   140, 255, 255, 85,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  252, 255, 152, 0,   0,   0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 170, 0,   0,   0,   0,   0,   0,   0,   0,   21,  240, 255, 255, 127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 232, 0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,
     0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,   0,   0,   0,   0,   0,   0,   0,   0,   186, 255, 255, 197, 0,   0,   188, 255, 255, 88,  0,   0,   0,   72,  255,
     255, 192, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 116, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   13,  178, 49,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 16,  0,   0,   0,   0,   0,   0,   0,   0,   153, 255, 255, 227, 10,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   168, 255, 255, 104, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   40,  255, 255, 232, 0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   10,  194, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 44,  179, 18,
     0,   0,   0,   0,   0,   0,   79,  255, 255, 254, 53,  0,   0,   188, 255, 255, 88,  0,   0,   0,   72,  255, 255, 192, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   156, 255, 255, 116, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   132, 255, 228, 34,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   47,  253, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 232, 0,   0,   4,   255, 255, 255, 4,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  218, 255, 144, 0,   0,   0,   0,   0,   7,   220, 255, 255, 162, 0,   0,   0,   188, 255, 255, 88,
     0,   0,   0,   72,  255, 255, 192, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   191,
     255, 255, 201, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   168, 255, 255,
     104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  230, 255, 185, 0,   0,   1,   212, 255, 212, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   120, 255, 255, 245, 27,  0,   0,   0,   188, 255, 255, 88,  0,   0,   0,   72,  255, 255, 192, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   82,  255, 255, 255, 57,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255,
     255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   39,  175, 12,  0,   0,   0,   24,
     178, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   8,   242, 255, 255, 127, 0,   0,   0,
     0,   188, 255, 255, 88,  0,   0,   0,   72,  255, 255, 192, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140,
     255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   7,   221, 255, 255, 167, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255,
     152, 0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   159, 255, 255, 104, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   222, 255, 227, 10,  0,   0,   0,   0,   127, 255, 239, 39,  28,  28,  28,  38,  234, 255, 130, 0,   83,  254, 252, 76,
     27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  62,  249, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  254, 252, 76,  27,  28,  26,  0,   0,   0,   0,   0,   0,   0,   14,  28,
     28,  18,  210, 255, 192, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152,
     0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   103, 255, 255, 247, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  61,  249, 255, 152, 0,   108, 255, 255, 104, 0,   0,   0,   0,   27,  28,  28,  28,  28,  28,  28,
     28,  28,  27,  61,  249, 255, 152, 0,   0,   0,   17,  28,  28,  12,  0,   0,   20,  211, 255, 104, 0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  208, 255, 200, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   153, 255,
     91,  0,   0,   0,   0,   0,   1,   123, 43,  170, 255, 255, 255, 181, 48,  123, 0,   0,   0,   104, 92,  137, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 146, 81,  114, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   104, 92,  137, 255, 255, 255, 129, 0,   0,   0,   0,   0,   41,  233, 255, 255, 214, 45,  161, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   74,  255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 253, 91,  139, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 149, 78,  250, 152, 0,   0,   125, 255, 104, 0,   0,   0,   140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 146, 78,  250, 152, 0,   0,   0,   156, 255, 255, 116, 0,   0,   0,
     21,  213, 104, 0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  209, 255, 255, 200, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   84,  200, 1,   0,   0,   0,   0,   0,   0,   0,   99,  255, 255, 255, 255, 255, 105, 0,   0,
     0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 127, 0,   0,
     0,   40,  231, 255, 255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   110, 255, 255, 152, 0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  249, 230, 12,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 142, 83,  147, 0,   0,   0,   129, 104, 0,   0,   133, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 140, 83,  147, 0,   0,   0,   156, 255, 255, 116, 0,   0,   0,   0,   23,  66,  0,   140, 253, 90,  140, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 150, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  211, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,
     0,   0,   0,   17,  55,  0,   0,   0,   0,   0,   0,   0,   0,   1,   149, 255, 255, 255, 162, 2,   0,   0,   0,   0,   0,   0,   115, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   115, 255, 255, 255, 255, 255, 124, 0,   38,  230, 255, 255, 255, 255, 200, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 213, 32,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  26,  201, 255, 140, 0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   190, 97,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  124, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 22,  0,   0,   0,   0,   22,  0,   127, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 134, 22,  0,   0,   0,   156, 255,
     255, 116, 0,   0,   0,   0,   0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  212, 255, 255, 255, 108,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   152, 46,  214, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 220, 45,  153, 12,  0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  2,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 108, 0,   140, 255, 255, 132, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  213, 255, 255, 254, 105, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 152, 0,   0,   2,   28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  19,  0,   0,   0,   140, 255, 238, 50,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 0,   0,   127, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 135, 22,  0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,   0,   0,   0,   0,   140, 255, 252, 76,
     27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  124,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 22,  0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 22,  0,   0,   0,   0,
     0,   0,   0,   2,   158, 95,  0,   0,   0,   168, 255, 255, 108, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  214, 255,
     255, 254, 101, 0,   0,   0,   0,   0,   2,   28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  62,  249, 255, 94,  0,   2,   160, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247,
     70,  0,   0,   140, 255, 255, 238, 50,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   137, 94,  132, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 143, 0,   0,   0,   0,   134, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 141, 82,  147, 0,   0,   0,   0,   0,   0,   0,   0,   11,
     196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 44,  179, 18,  0,   0,   0,   140, 253, 91,  139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 149, 0,   0,   0,   0,   39,  231,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 143, 82,  147, 0,
     137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 143, 82,  147, 0,   0,   0,   0,   0,   0,   0,   132, 255, 253, 69,  0,   0,   168, 255, 255, 108, 0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  215, 255, 255, 253, 98,  0,   0,   0,   0,   0,   1,   156, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 146, 81,  114, 0,   0,   76,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 225, 6,   0,   60,  244, 255, 255, 238, 50,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 253, 90,  140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 150, 0,   0,   0,   0,   0,   0,   140, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 77,  250, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  218, 255, 144, 0,   0,
     0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 142, 0,   0,   0,   0,   41,  233, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,
     0,   0,   0,   140, 253, 90,  140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 150, 78,  250, 152, 0,   140, 253, 90,  140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 150, 78,  250,
     152, 0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     25,  216, 255, 255, 253, 95,  0,   0,   0,   0,   0,   0,   77,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,   0,   131, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 238, 47,  0,   0,   0,   62,  244, 255, 255, 238, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140,
     255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  1,   0,   0,   0,   0,   0,   0,   0,   27,  28,  28,  28,  28,  28,  28,  28,  28,  27,  61,  248, 255, 152, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     135, 0,   0,   0,   0,   43,  234, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 80,  114, 0,   0,   0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,
     61,  248, 255, 152, 0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  61,  248, 255, 152, 0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,
     0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  217, 255, 255, 252, 92,  0,   0,   0,   0,   0,   0,   0,   0,   135, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  243, 255, 255, 239, 52,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,
     61,  249, 255, 94,  0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   20,  40,  40,  40,  31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   64,  128, 128, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  243, 255, 255, 239, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255,
     152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 135, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104,
     0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  221, 255, 255, 251, 85,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  19,  0,   0,   0,   0,   0,   0,   0,
     60,  243, 255, 255, 239, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 143, 82,  147, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  219, 255, 255, 252, 87,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   0,   0,   0,
     0,   0,   1,   156, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 65,  0,   0,   0,   0,   0,   0,   0,   59,  243, 255, 255, 240, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 253, 90,  140, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 150, 78,  250, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   140, 255, 255, 132,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,
     0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  11,  0,   0,   0,   0,   0,   0,   27,  218, 255, 255, 252, 89,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   77,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 226, 6,
     0,   0,   0,   0,   0,   0,   0,   59,  242, 255, 255, 240, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  61,  248, 255, 152, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   7,   152, 46,  214, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 28,  0,   0,   0,   0,   0,   0,   26,  217, 255, 255, 252, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   82,  254, 255, 96,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   135, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 239, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  48,  48,  48,  34,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,
     0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,
     0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,   0,   0,   0,   0,   0,
     0,   25,  215, 255, 255, 253, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 113, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   49,  237, 255, 255, 245, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   156, 255, 255, 116, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255,
     255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   11,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 44,  179, 18,  0,   0,   0,   0,   0,   0,   23,  213, 255, 255, 253, 97,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   50,  238, 255, 255, 244, 63,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   156, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  247, 255,
     152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255,
     255, 152, 0,   0,   0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     110, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   167, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  218, 255,
     144, 0,   0,   0,   0,   0,   0,   0,   22,  212, 255, 255, 254, 98,  0,   0,   0,   0,   112, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 90,  22,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  238, 255, 255, 243, 61,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  213, 255, 145, 0,
     156, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   71,  248, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   0,   0,   0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,
     28,  28,  28,  27,  203, 255, 140, 0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  27,  203, 255, 140, 0,   0,   0,   0,   0,   0,   0,   51,  239, 255, 96,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   21,  210, 255, 255, 200, 0,   0,   0,
     57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 95,  120, 111, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   54,  240, 255,
     255, 242, 59,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220,
     28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  170, 18,  0,   156, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   76,  146, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   10,  28,  28,  28,  28,  28,  28,  28,
     28,  28,  28,  27,  203, 255, 140, 0,   0,   0,   0,   7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 46,  153, 12,  0,   7,   152, 46,  214, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 220, 46,  153, 12,  0,   0,   0,   0,   0,   0,   0,   0,   54,  156, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  209, 255, 200, 0,   0,   104, 92,  136, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 101,
     116, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  241, 255, 255, 241, 57,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   156, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   21,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 46,  153, 12,  0,   0,   0,   0,   0,   0,   149, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,   0,   0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   83,  254, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  23,  100, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     58,  241, 255, 255, 240, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  178, 49,  196, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 203, 44,  179, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  168, 15,  0,   156, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   149, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,   0,   0,   0,   0,   0,   13,  178, 49,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 44,  179, 18,  0,   0,   0,   11,  196,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 44,  179, 18,  0,   0,   0,   0,   0,   0,   0,   0,   53,  153, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   160, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,  242, 255, 255, 240, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 228, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  218, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   21,  212, 255, 142, 0,   106, 255, 252, 70,  0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   140, 255, 255, 130, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   0,   0,   13,  178, 50,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 16,  0,   0,   0,   0,   0,   0,   132,
     255, 228, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  218, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  218, 255, 144, 0,   0,   0,
     0,   0,   0,   0,   51,  239, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   140, 255, 255, 239, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   0,   123, 92,  0,   0,   137, 94,
     132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  27,  203, 255, 140, 0,   0,   0,   132,
     255, 229, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   167, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   158, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 238, 50,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   140, 253, 90,  140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 80,  114, 0,   0,
     7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 46,  153, 12,  0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255,
     255, 152, 0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   15,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  43,  229, 255, 99,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,
     0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  61,  249, 255, 94,  0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,
     0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132,
     0,   0,   46,  237, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 189, 49,  143, 2,   0,   0,   0,   0,   114, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 46,  0,   22,
     124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255,
     152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     112, 255, 255, 152, 0,   13,  178, 49,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 44,  179, 18,  0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  28,  28,  28,  28,  28,  28,  28,  28,  28,
     61,  249, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   197, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 119, 0,
     0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 239, 49,  0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,
     0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255,
     255, 152, 0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   132, 255, 228, 34,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   25,  218, 255, 144, 0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   168, 255, 255,
     104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 149, 78,  250, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   140, 255, 255, 132, 36,  180, 47,  224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 167, 60,  170, 6,   0,   0,   104, 92,  138, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 241,
     54,  0,   0,   0,   140, 253, 90,  140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 80,  114, 0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 142, 83,  147, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 182, 255, 204, 16,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   55,  241, 255, 106, 0,   83,  254, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  17,  0,   0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,
     28,  61,  249, 255, 94,  0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,
     0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 22,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   134, 255, 225, 31,  188, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 112, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   140, 255, 255, 132,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  179, 36,  0,   188, 255, 255, 84,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 112, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  61,  249, 255, 152, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   60,  249, 255, 152, 0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  61,  249, 255, 152, 0,   0,   0,   0,   0,   27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  61,  249, 255, 152,
     0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 46,  0,   22,  124, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 236, 46,  0,   0,   0,   0,   0,   188, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 112, 0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   140, 253,
     91,  139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 149, 78,  250, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   77,  250, 152, 0,   0,   0,   0,   0,
     0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,
     0,   0,   140, 255, 250, 69,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 253, 91,  139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 149,
     78,  250, 152, 0,   0,   0,   0,   139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 149, 78,  250, 152, 0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   137, 94,  132, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 239, 49,  0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 239, 49,  0,   0,   5,   145, 22,  0,   188, 255,
     255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 112, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 142, 83,  147, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   82,  147, 0,   0,   0,   0,   0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255,
     255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   140, 250, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 142, 83,  147, 0,   0,   0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 142, 83,  147, 0,   0,   0,   0,   0,   0,   0,   132, 255, 253, 69,  0,   140, 253, 90,  140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 241, 54,  0,   0,   0,   140, 253, 90,
     140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 241, 54,  0,   0,   0,   123, 255, 209, 18,  188, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 112, 0,
     140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,
     0,   0,   0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,
     0,   0,   0,   0,   0,   0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  27,  203, 255, 140, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     112, 255, 255, 152, 0,   0,   0,   135, 82,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 135, 22,  0,   0,   124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 22,  0,   0,   0,   0,   0,   0,   0,   2,   158, 95,  0,   0,
     140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  17,  0,   0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  17,  0,   0,   0,   0,   140,
     255, 255, 129, 188, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 112, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 220, 46,  153, 12,  0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   16,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 188, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     160, 255, 255, 112, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     19,  105, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,   0,   0,   140, 255, 255, 129, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   109, 255, 255, 152, 0,   0,   0,   68,  124, 124, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 135, 0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  10,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   140, 255, 255, 132, 126, 255, 238, 44,  28,  28,  28,  28,  28,  28,  28,  28,  28,  23,  98,  255, 255, 112, 0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   110, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   27,  116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  206, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  178, 49,  196, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 203, 44,  179, 18,  0,   140, 255, 207, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  196, 255, 152, 0,   0,   0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 143, 0,   0,   0,   116, 39,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 40,  0,   0,   1,   92,  229, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   130, 57,  183, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 254, 100, 114, 255, 112, 0,   133, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 223, 30,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   21,  213, 255, 145, 0,   140, 224, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  217, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   14,  201, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 228, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  218, 255, 144, 0,   140, 210, 19,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  201, 152, 0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 92,
     138, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 150, 0,   0,   0,   0,   140, 229, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 255, 255, 40,  0,   0,   85,  255, 255, 247,
     31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 94,  119, 111, 0,   13,  169, 32,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  169, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  170, 18,  0,   140, 255, 222, 30,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   21,  213, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140,
     255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   96,  21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  101, 0,   0,   0,
     86,  156, 156, 81,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  254, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  1,   0,   0,   0,   0,   140,
     255, 227, 34,  0,   0,   0,   0,   0,   0,   0,   126, 255, 255, 255, 203, 11,  0,   0,   3,   211, 255, 255, 168, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   1,   158,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 89,  22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   125, 255, 255, 255, 204, 16,  0,   0,
     0,   0,   69,  255, 255, 255, 58,  0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  166,
     32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  166, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  168, 15,  0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     135, 22,  0,   100, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   124, 255, 255, 255, 205, 17,  0,   0,   0,   0,   0,   0,   179, 255, 255, 163, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     130, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  212, 255, 142, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   112, 255, 255, 152, 0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 143, 82,  147, 0,   140, 214, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   124, 255, 255, 255, 206,
     17,  0,   0,   0,   0,   0,   0,   0,   39,  248, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   87,  254, 253, 79,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  27,
     0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255,
     152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 253, 90,  140, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 150, 78,  250, 152, 0,   140, 255, 212, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   123, 255, 255, 255, 206, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  81,  27,  0,   0,   0,   0,   0,
     0,   0,   0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  11,  0,   0,   0,   0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  11,  0,   0,
     0,   0,   0,   106, 94,  135, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 129, 0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 252, 76,  27,  28,  28,  28,  29,  29,  28,  28,  28,  28,  61,  248, 255, 152, 0,   140, 255, 255, 130, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   122, 255,
     255, 255, 207, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     219, 28,  0,   0,   0,   7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 219, 28,  0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 254, 49,  0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,
     0,   0,   148, 158, 2,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   121, 255, 255, 255, 208, 19,  0,   0,   0,   0,   0,   0,   0,   0,   2,   158, 95,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 167, 0,   0,   0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 167, 0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 107, 0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   104, 255, 255, 119, 0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255,
     132, 114, 255, 255, 255, 209, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 253, 69,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  178, 49,  196, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 203, 15,  0,   0,   0,   13,  178, 49,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  62,  249, 255, 94,  0,   140,
     255, 255, 132, 0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 192, 255, 255, 209, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168,
     255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 228, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 228, 34,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  0,   0,   0,   0,   0,   140, 255, 255, 132,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 130, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  213, 255, 145, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   140, 253, 91,  139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 146, 81,  114, 0,   0,   140, 255, 255, 132, 0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   112, 255, 255, 152,
     0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 214, 23,  0,   0,   0,   0,   0,   0,   3,   28,  28,  28,  11,  0,   0,
     0,   0,   140, 255, 255, 130, 189, 252, 208, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 138, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   125, 152, 0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   127, 255, 213, 32,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  26,  201, 255, 140, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  170, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     65,  0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   7,   152, 25,  0,   0,   0,   0,   0,   0,   3,   169, 255, 255, 255, 220, 28,  0,   0,   0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  11,
     0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 134, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   118, 255, 152, 0,   0,   0,   0,
     0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,
     7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 45,  153, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   128, 255, 255, 144, 0,   0,
     0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   89,  255, 255,
     255, 255, 255, 170, 0,   0,   0,   7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 28,  0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     140, 255, 255, 100, 100, 128, 80,  0,   0,   0,   0,   0,   0,   0,   81,  255, 255, 152, 0,   0,   0,   0,   0,   83,  254, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  17,  0,
     0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  62,  249, 255, 94,  0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  168, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  178, 38,  0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 203, 44,  179, 18,  0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 170, 0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 200, 255, 254, 100, 0,   0,   0,   0,   0,   0,   112, 255, 255,
     152, 0,   0,   0,   0,   0,   0,   104, 92,  137, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 241, 53,  0,   0,   0,   140, 253, 91,  139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     146, 81,  114, 0,   0,   13,  178, 49,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 44,  179, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,
     212, 255, 142, 0,   0,   0,   0,   114, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   128,
     255, 255, 144, 0,   0,   0,   111, 255, 255, 152, 0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 228, 34,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   25,  218, 255, 144, 0,   13,  178, 49,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 44,  179, 18,  0,   168, 255, 255, 104, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   140, 255, 255, 132, 187, 255, 255, 254, 103, 0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 238, 49,  0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,   132, 255, 228, 34,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   25,  218, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 223, 30,  0,   0,   0,   77,  253, 255, 90,  0,   0,   0,   21,  213, 255, 145, 0,   133, 255, 223, 30,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   132, 255, 228, 34,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  218, 255, 144, 0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 27,  217, 255, 255, 254, 106, 0,   0,
     0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   115, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 46,  0,   22,  124, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   104, 92,  138, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 80,  114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  169, 32,
     0,   0,   0,   0,   0,   101, 110, 0,   0,   0,   0,   0,   23,  170, 18,  0,   13,  169, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   168, 255, 255,
     104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   25,  215, 255, 255, 255, 109, 0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   25,  198, 50,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   83,  254, 252, 76,  27,  28,  28,  28,
     28,  28,  28,  28,  28,  28,  61,  249, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,
     140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   23,
     212, 255, 255, 255, 112, 0,   0,   112, 255, 255, 152, 0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   138, 255, 238, 50,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   10,  166, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  168, 15,  0,   10,  166, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255,
     152, 0,   167, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  17,  0,   0,   0,   0,   140, 255, 251, 71,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   21,  210, 255, 255, 255, 115, 0,   112, 255, 255, 152, 0,   137, 94,  132, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,
     212, 255, 142, 0,   130, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   51,  239, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140,
     253, 91,  139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 241, 53,  0,   0,   0,   140, 251, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   20,  207, 255, 255, 255, 116, 112, 255, 255, 152, 0,   140, 253, 90,  140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 80,  114, 0,   0,   0,   104, 92,
     138, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 80,  114, 0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,
     140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   112, 255, 255, 152, 0,   0,   54,  156, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 49,  0,
     0,   136, 87,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   18,  205, 255, 255, 212, 112, 255, 255, 152, 0,
     140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  61,  249, 255, 94,  0,   83,  254, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  61,  249, 255, 94,  0,   0,
     0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255,
     152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 46,  0,   19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   139, 255, 242, 54,  0,   0,   0,   0,   0,   0,   16,  202, 255, 212, 42,  234, 255, 151, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255,
     152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   53,  153, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  207, 57,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   45,  208, 35,  0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 152, 0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,
     28,  28,  61,  249, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 254, 84,
     8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   67,  252, 255, 104, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   51,  239, 255, 94,  0,
     0,   0,   0,   0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     145, 0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   140, 255, 255, 129, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   109, 255, 255, 152, 0,   140, 253, 91,  139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 149, 78,  250, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   121, 108, 118, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 95,  132, 0,   0,   140, 255,
     255, 129, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   109, 255, 255, 152, 0,   167, 255, 255, 104, 0,   0,   0,   0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 65,  0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   2,   126, 15,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   9,   128, 4,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   140, 255, 207, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  196, 255, 152, 0,   137, 94,  132, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 142, 83,  147, 0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   59,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 66,  0,   0,   0,   140, 255, 207, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  196, 255, 152, 0,
     168, 255, 255, 104, 0,   0,   0,   0,   0,   140, 253, 90,  140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 80,  114, 0,   0,   0,   104, 92,  138, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 166, 2,   0,   0,   0,   0,   0,   0,   116, 255, 199, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   186, 255, 129, 0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   140, 210, 19,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  201, 152, 0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 22,  0,   133, 255, 223, 30,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  213, 255, 145, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255,
     152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   142, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 151, 1,
     0,   0,   0,   140, 210, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  201, 152, 0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,
     28,  28,  28,  28,  28,  28,  61,  249, 255, 94,  0,   83,  254, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  3,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 127,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   107, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   96,  21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  101, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  169, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  170, 18,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  2,   0,   0,   0,   0,   96,  21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   16,  101, 0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   39,  231, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235, 44,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   110, 255, 255, 152, 0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,
     140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   41,  0,   0,
     0,   0,   0,   0,   41,  233, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 48,  0,   0,   11,  167, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  168,
     15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 212, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  202, 255, 152, 0,   140, 253, 91,  139, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 241, 53,  0,   0,   0,   100, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  105, 0,   100, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   19,  105, 0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140,
     255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255,
     255, 152, 0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  27,  203, 255, 140, 0,   133, 255, 224, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  214, 255,
     145, 0,   140, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   117, 151, 0,   0,   0,   0,   0,   0,   0,   43,  234, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     241, 53,  0,   0,   0,   131, 255, 224, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  212, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 214, 23,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   17,  206, 152, 0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 49,  0,   0,   140, 214, 22,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   16,  206, 152, 0,   140, 214, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  206, 152, 0,   0,   0,   168, 255, 255, 104, 0,   0,   0,
     0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     220, 46,  153, 12,  0,   13,  169, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  170, 18,  0,   140, 255, 127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     111, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   15,  28,  28,  28,  28,  40,  40,  28,  28,  28,  28,  17,  0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   111, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   101, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  105, 0,   22,  124, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 46,  0,   140, 255, 212, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  201, 255, 152, 0,   140, 255, 212, 21,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   14,  201, 255, 152, 0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   77,  255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  194,
     196, 13,  0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255,
     130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   0,   0,   168, 255,
     255, 104, 0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   13,  178, 49,  196, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 203, 16,  0,   0,   0,   11,  167, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  168, 15,  0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 133, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 152, 0,   1,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140,
     255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   168, 255, 255, 104, 0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   132, 255, 228, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 224, 31,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   21,  212, 255, 142, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 247, 34,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  244, 255, 152, 0,   109, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  118, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152,
     0,   0,   0,   132, 255, 253, 69,  0,   0,   0,   0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   140, 255, 255, 130, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 177, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 152, 0,   136, 227, 35,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  215, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   2,   158, 95,  0,   0,   0,   0,   0,   0,   127, 255, 214, 33,  28,
     28,  28,  28,  28,  28,  28,  28,  28,  28,  27,  203, 255, 140, 0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   140,
     255, 232, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  224, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,
     69,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   62,  255, 255, 255, 80,  0,   136, 255, 225, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  211, 255, 156, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 46,  153, 12,  0,   7,   152, 46,
     214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 28,  0,   0,   0,   0,   0,   0,   0,   0,   140, 234, 43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  227, 152,
     0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,
     140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,
     0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   173, 255, 255, 217, 6,   0,   0,   0,   0,   0,   0,   3,   209, 255, 255, 185,
     0,   0,   136, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   107, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,
     0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,   0,   0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,   0,   0,   0,
     0,   0,   0,   0,   119, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  126, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255,
     152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     112, 255, 255, 152, 0,   0,   31,  246, 255, 255, 119, 0,   0,   0,   0,   0,   0,   108, 255, 255, 250, 40,  0,   0,   136, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108,
     255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   13,  178, 49,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 16,  0,
     0,   0,   0,   0,   11,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 44,  179, 18,  0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   3,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140,
     0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 253, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  62,  249, 255, 94,  0,   0,   0,   125, 255, 255, 243, 26,  0,   0,   0,   0,   20,
     238, 255, 255, 139, 0,   0,   0,   136, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   224, 255, 255,
     28,  0,   0,   0,   0,   132, 255, 228, 34,  0,   20,  52,  44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,
     218, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   90,  255, 255, 130, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 93,  137, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 146, 81,  114, 0,   0,   0,   0,   7,   221, 255, 255, 165, 0,   0,   0,   0,   154, 255, 255, 231, 13,  0,   0,   0,   136, 255, 255, 136, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   140, 255, 255,
     131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   140, 255, 255, 132, 0,   100, 255, 255, 116, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   39,  231, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 145, 0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,
     0,   0,   38,  224, 224, 95,  135, 171, 4,   0,   140, 255, 255, 86,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  252, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   105, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   77,  255, 255, 255,
     61,  0,   0,   51,  253, 255, 255, 93,  0,   0,   0,   0,   136, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     133, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  213, 255, 145, 0,   133, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  213, 255, 145, 0,   0,
     0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   140, 255, 255, 132, 0,   100, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   41,  233, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   44,  255, 255, 253, 90,  2,   0,   0,   65,  247, 108, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   91,  248, 75,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 253, 85,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   115,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   181, 255, 255, 208, 3,   1,   198, 255, 255, 197, 1,   0,   0,   0,   0,   136, 255, 255, 136, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  169, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  170,
     18,  0,   13,  169, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  170, 18,  0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   140, 255, 255, 132, 0,   19,  210,
     255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   43,  234, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 166, 2,   0,   0,   0,   0,   0,   0,   140, 255, 255, 129, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 253, 76,
     27,  28,  28,  28,  28,  28,  28,  26,  223, 255, 255, 252, 86,  0,   0,   0,   29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   36,  248, 255, 255, 90,  78,  255, 255, 253, 51,  0,   0,   0,   0,   0,   136, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   22,  213, 255, 255, 254, 103, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   15,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  44,  31,  16,  0,   0,   0,   0,   0,   0,   140,
     255, 207, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 93,  137, 255, 255, 255, 255, 255, 255, 255, 199, 46,  226, 255, 255, 251, 76,  0,   0,   61,
     1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  127, 128, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 255, 112, 100, 255, 255, 153, 0,   0,   0,   0,   0,   0,
     136, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  167, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   23,  168, 15,  0,   10,  166, 32,  0,   0,   0,   0,   0,   100, 110, 0,   0,   0,   0,   0,   23,  168, 15,  0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   140, 255,
     255, 132, 0,   0,   0,   24,  216, 255, 255, 254, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  231, 255, 152, 0,   0,   0,   0,   0,   0,   140, 210, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 132, 36,  229, 255, 255, 152, 0,   81,  254, 145, 1,   0,   0,   0,   0,   0,   0,   0,   0,   19,  210, 255, 255, 97,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 249, 69,  0,   0,   0,   0,   0,   0,   0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 127, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   10,  226, 255, 112, 100, 255, 238, 20,  0,   0,   0,   0,   0,   0,   136, 255, 255, 135, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   106, 255, 255,
     156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 224, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  212, 255, 142, 0,   130, 255, 223, 30,  0,   0,   0,   77,  253, 255,
     90,  0,   0,   0,   21,  212, 255, 142, 0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   26,  219, 255, 255, 254, 96,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   196, 255, 255, 152, 0,   0,
     0,   0,   0,   0,   96,  21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   115, 255, 255, 255, 255, 255, 255, 255, 183, 7,   0,   40,  232,
     255, 152, 0,   140, 255, 255, 105, 0,   0,   0,   0,   0,   0,   0,   17,  206, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 140, 0,   0,
     0,   0,   0,   0,   0,   0,   140, 253, 90,  140, 255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  236, 103, 92,  236, 104, 0,   0,
     0,   0,   0,   0,   0,   124, 255, 216, 14,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  25,  198, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   140, 255, 255, 131, 0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   111, 255, 255, 152, 0,   0,   0,   0,   224, 255, 255, 28,  0,
     0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   28,  221, 255, 255, 253, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255,
     152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   145, 255, 255, 255, 83,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   15,  202, 255, 255,
     255, 139, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 252, 76,  27,  28,  26,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   152, 6,   212, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 221, 45,  153, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,
     0,   0,   128, 255, 255, 144, 0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   30,  224, 255, 255,
     252, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255,
     255, 140, 0,   0,   22,  9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  230, 255, 255, 255, 255, 255, 255, 212, 44,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   12,  198, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132,
     255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  236, 103,
     92,  236, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 171, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,
     224, 255, 255, 28,  0,   0,   0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   33,  226, 255, 255, 251, 84,  0,   0,   0,   2,   28,  28,  28,  28,  28,  28,  28,  28,  28,  28,
     28,  28,  62,  249, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   43,  244, 255, 255, 190, 3,   0,   0,   30,  238, 189, 121, 44,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   40,  232, 255, 255, 255, 255, 214, 45,  210, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   10,
     193, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  226, 255, 112, 100, 255, 232, 15,  0,   0,   0,   0,   0,   0,   0,   0,   10,  194, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 205, 43,  179, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,
     140, 255, 255, 132, 0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   140, 255, 212, 21,  0,   0,   0,   0,   0,
     0,   0,   0,   35,  228, 255, 255, 251, 76,  0,   1,   156, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 146, 81,  114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     14,  217, 255, 255, 227, 22,  0,   0,   0,   0,   131, 255, 255, 240, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   42,  233, 255, 255, 216, 45,  211, 252,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   9,   189, 255, 255, 255, 152, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   133, 255, 255, 112, 100, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  216, 255, 148, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   112, 255, 255,
     152, 0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   140, 214, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  231, 255, 255, 152, 0,   77,  255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   173, 255, 255, 249, 54,  0,   0,   0,   0,   0,   11,  229, 255, 255, 152, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  28,  28,  18,  209, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132,
     0,   0,   7,   185, 255, 255, 255, 156, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140,
     255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  248, 255, 255, 90,  78,  255, 255, 251, 44,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   101, 24,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   41,  233, 255, 152, 0,   0,   135, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   119, 255, 255, 255, 102, 0,   0,   0,   0,   0,   0,   0,   93,  255, 255, 252, 46,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   20,  255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   6,   180, 255, 255, 255, 160, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   180, 255, 255, 208, 3,   1,   199, 255, 255, 191, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   108, 255, 255, 124, 0,
     0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  252, 255, 255, 157, 0,   0,   0,   0,   0,   0,   0,   0,   1,
     201, 255, 255, 190, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   140, 255, 255, 132, 4,   175, 255, 255, 255, 164, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,
     0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   77,  255, 255, 255, 61,  0,   0,   51,  253, 255, 255, 88,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   1,   157, 165, 3,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   42,  42,  0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  18,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   19,  249, 220, 171, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 81,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 167, 255, 255, 255, 168, 3,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   7,   220, 255, 255, 165, 0,   0,   0,   0,   154, 255, 255, 228, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     108, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 253, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  62,  249, 255, 94,  0,   140, 255, 252, 76,  27,  28,  28,
     28,  30,  31,  28,  28,  28,  28,  61,  249, 255, 152, 0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   123, 147, 155, 116, 0,   0,   0,   0,   0,   0,
     0,   29,  221, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 244, 63,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   5,   2,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   165, 255, 255, 220, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 244, 255, 255, 172, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   96,  255, 255,
     103, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 243, 26,  0,   0,   0,   0,
     20,  238, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 93,  137,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 146, 81,  114, 0,   0,   140, 253, 91,  139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 149, 78,  250, 152, 0,   0,   0,   0,   224, 255,
     255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   119, 255, 148, 156, 255, 114, 0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 221,
     5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   177, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  245, 255, 255, 118, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 244, 255, 176, 5,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 129, 0,   0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 223, 30,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  246, 255, 255, 119, 0,   0,   0,   0,   0,   0,   108, 255, 255, 249, 38,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,   137, 94,
     132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 142, 83,  147, 0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 148, 156, 255, 255,
     112, 0,   0,   0,   0,   0,   15,  204, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 234, 42,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 255, 123, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 255, 242, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   39,  231, 225, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  169, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   173, 255, 255, 217, 6,
     0,   0,   0,   0,   0,   0,   3,   209, 255, 255, 183, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   115, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 22,  0,
     0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 255, 143, 151, 255, 255, 255, 111, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  253, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  227, 255, 255, 156,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  33,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 22,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   62,  255, 255, 255, 80,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   0,   0,   106, 255, 255, 255,
     212, 20,  23,  214, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 46,  0,   0,   0,   0,   0,   0,   32,  237, 255, 255,
     225, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   90,  255, 255, 253, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,
     255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   137, 94,  132, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 143, 82,  147, 0,   0,   0,   0,   0,   10,  166, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140,
     255, 255, 177, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 152, 0,   0,   0,   0,   0,   27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  59,  248, 255, 98,  0,   22,  124,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   0,   102, 254, 255, 255, 218, 24,  0,   0,   23,  215, 255, 255, 255, 106, 0,   0,   0,   0,   57,  255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 239, 49,  0,   0,   0,   0,   0,   0,   8,   205, 255, 255, 247, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   198, 255, 236, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   143, 255, 244, 0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 236, 46,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 253, 90,  140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 150, 78,  250, 152, 0,   0,   0,
     0,   0,   130, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 248, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  244, 255, 152,
     0,   0,   0,   0,   133, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 148, 78,  117, 0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,
     137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   84,
     254, 255, 255, 223, 29,  0,   0,   0,   0,   24,  216, 255, 255, 254, 98,  0,   0,   104, 92,  138, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 241, 54,  0,   0,   0,   0,   0,   0,   0,
     156, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  226, 167, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   140, 73,  0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 239, 49,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  61,  248, 255, 152, 0,   0,   0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   140, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 152, 0,   0,   0,   54,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 68,
     0,   0,   0,   140, 253, 90,  140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 80,  114, 0,   0,   140, 253, 90,  140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 80,  114,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   140, 255, 255, 227, 33,  0,   0,   0,   0,   0,   0,   25,  216, 255, 255, 172, 0,   83,
     254, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  17,  0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 149, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 253, 90,  140, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 241, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255,
     255, 152, 0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 126, 0,   0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,
     61,  249, 255, 94,  0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  61,  249, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 28,
     0,   0,   0,   0,   140, 255, 232, 38,  0,   0,   0,   0,   0,   0,   0,   0,   26,  217, 255, 172, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   51,  248, 255, 255, 196, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  176, 104, 29,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 68,  0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 46,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 230, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   62,  255, 255, 235, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 242, 0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 239,
     49,  0,   0,   0,   0,   0,   114, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   224, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 250, 59,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   223, 255,
     255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  255, 255, 252, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   140, 253, 90,  140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 241, 54,  0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  38,  55,  28,  28,  28,  28,  28,  28,
     28,  28,  28,  28,  28,  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   86,  255, 255, 251, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255,
     252, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,
     28,  28,  28,  17,  0,   0,   0,   0,   0,   104, 92,  138, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 150, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   156, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 149, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   196, 255, 255, 182, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,
     140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  254, 252, 76,  27,  28,  28,  28,  28,
     28,  28,  28,  28,  28,  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   77,  255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   53,  254, 255, 255, 74,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   20,  255, 255, 252, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140,
     255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   135, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   163, 255, 255, 216, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152,
     0,   0,   0,   0,   0,   140, 255, 252, 76,  27,  28,  26,  0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255,
     255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 28,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  245, 255, 255, 113, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  27,  203, 255, 140, 0,   0,   0,   0,   0,   140, 253, 91,  139, 255, 255, 255, 129, 0,   0,   0,   140,
     255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     111, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   133, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   129, 255, 255, 239, 20,  0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   140, 255, 255, 130, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 220, 46,  153, 12,  0,   0,   0,   0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 127, 0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,
     28,  28,  28,  27,  203, 255, 140, 0,   133, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  213, 255, 145, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224,
     255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  169, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   110, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,
     229, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 252, 0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  11,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,   0,   0,   0,   0,   0,   0,   22,  124, 255, 255, 255, 255, 255,
     255, 255, 124, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 46,  153, 12,  0,   13,  169, 32,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   23,  170, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 224, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   24,  217, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   95,  255, 255, 252, 30,  0,   0,   0,   0,   14,  28,  28,  18,  209, 255, 252, 0,
     7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 219, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  178, 49,  196, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 203, 44,  179, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   224, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  166, 32,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 222, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  213, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   1,   205, 255, 245, 7,   0,   0,   0,   41,  233, 255, 255, 216, 45,  212, 252, 0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 167, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 228, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  218, 255, 144, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  178, 49,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 44,  179, 18,  0,   10,  166, 32,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  168, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   63,  255, 183, 0,   0,   0,   40,  231, 255, 255, 255,
     255, 214, 45,  210, 0,   13,  178, 49,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 214, 33,  28,  28,  28,  28,
     28,  28,  28,  28,  28,  28,  11,  0,   0,   0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132,
     255, 228, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  218, 255, 144, 0,   130, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  212, 255, 142, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   173, 113, 0,   0,   38,  230, 255, 255, 255, 255, 255, 255, 212, 43,  0,   132, 255, 228, 34,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 219, 28,  0,   0,   0,   127, 255, 214, 23,  0,   0,
     0,   0,   0,   0,   3,   28,  28,  28,  11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152,
     0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  39,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 167, 0,   0,   0,   7,   152, 25,  0,   0,   0,   0,   0,   0,   3,   169, 255, 255, 255, 220, 28,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255,
     255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  178, 49,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 15,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   89,  255, 255, 255, 255, 255, 170, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  105,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   132, 255, 228, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  178, 38,  0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 203, 44,  179, 18,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  206, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   132, 255, 228, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  218, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   14,  201, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 129, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   109, 255, 255, 152, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140,
     255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  254, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  17,  0,   0,   0,   0,   127, 255, 213, 32,  28,
     28,  28,  28,  28,  28,  28,  28,  28,  28,  26,  201, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     140, 255, 207, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  196, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  62,  249, 255, 94,  0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  62,  249, 255, 94,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104,
     92,  137, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 241, 53,  0,   0,   0,   7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 45,  153, 12,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,
     28,  28,  28,  28,  28,  17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 210, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  201,
     152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 253, 91,  139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 146,
     81,  114, 0,   0,   140, 253, 91,  139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 146, 81,  114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 49,  0,   0,
     0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 253, 91,  139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 241, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   96,  21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  101, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   115, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 46,  0,   13,  178, 49,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 44,  179,
     18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   137, 94,  132, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 49,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 125, 0,   0,   0,   0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   132, 255, 228, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  218, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 46,  0,   1,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   140, 255, 251, 71,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   46,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   116, 39,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 40,  0,   0,
     140, 214, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 251, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   92,  255, 254, 84,  8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   67,  252, 255, 104, 0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 135, 22,  0,   0,   0,   0,   114, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 138, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   125, 152, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   111, 255, 255, 152, 0,   0,   0,   0,   114, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   140, 229, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 255, 255, 40,  0,   0,   140, 255, 212, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   136, 87,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   121, 108, 118, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 128, 95,  132, 0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 143, 82,  147, 0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 65,  0,   0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 134, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   118, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  213, 255, 145, 0,   0,   0,   57,  255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 227, 34,  0,   0,   0,   0,   0,   0,   0,   126, 255, 255,
     255, 203, 11,  0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   59,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 66,  0,   0,   0,   140, 253, 90,  140, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 150, 78,  250, 152, 0,   0,   104, 92,  138, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 80,  114, 0,   0,   140, 253, 90,  140, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 147, 80,  114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 100, 100, 128, 80,  0,   0,   0,   0,   0,   0,   0,   81,  255, 255, 152, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  170, 18,  0,   0,   104, 92,  138, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 80,  114, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   125, 255, 255, 255, 204, 16,  0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   142, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 151, 1,   0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  29,  29,  28,  28,  28,  28,  61,  248, 255, 152, 0,   83,  254, 252, 76,  27,  28,
     28,  28,  28,  28,  28,  28,  28,  28,  61,  249, 255, 94,  0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  61,  249, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   140, 255, 255, 132, 200, 255, 254, 100, 0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  254, 252,
     76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  61,  249, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,
     124, 255, 255, 255, 205, 17,  0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  2,   0,   0,   0,   0,   140, 255, 255,
     132, 0,   0,   0,   0,   148, 158, 2,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 187, 255, 255, 254, 103, 0,   0,   0,   0,   0,   112, 255,
     255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  168, 15,  0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   124, 255, 255, 255, 206, 17,  0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   104, 255, 255, 119, 0,   0,   0,   112, 255, 255, 152, 0,   140,
     255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 27,  217, 255, 255, 254, 106, 0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  212, 255,
     142, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132,
     0,   0,   0,   123, 255, 255, 255, 206, 18,  0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 253, 90,  140, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 80,  114, 0,   0,   0,   0,   0,   114, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 145, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   140, 255, 255, 132, 0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152,
     0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   25,  215, 255, 255, 255, 109,
     0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   122, 255, 255, 255, 207, 18,  0,   0,   0,   0,   0,   0,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  61,  249, 255, 94,  0,   0,   0,   57,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   112,
     255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255,
     255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   23,  212, 255, 255, 255, 112, 0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 129, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   109, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   140, 255, 255, 132, 0,   121, 255, 255, 255, 208, 19,  0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   104, 92,  138, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 166, 2,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,
     0,   21,  210, 255, 255, 255, 115, 0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 207, 18,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   12,  196, 255, 152, 0,   25,  198, 50,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 114, 255, 255, 255, 209, 19,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255,
     152, 0,   83,  254, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   128, 255, 255,
     144, 0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   20,  207, 255, 255, 255, 116, 112, 255, 255, 152, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 210, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  201, 152, 0,   138, 255, 238, 50,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 192, 255, 255, 209, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140,
     255, 255, 132, 0,   0,   0,   0,   0,   18,  205, 255, 255, 212, 112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   96,  21,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  101, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 130, 189, 252, 208, 20,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,
     0,   0,   128, 255, 255, 144, 0,   0,   0,   111, 255, 255, 152, 0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   140, 255, 255, 130, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 242, 54,  0,   0,   0,   0,   0,   0,   16,  202, 255, 212, 42,  234, 255, 151,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  11,  0,   0,   0,   0,   13,  169, 32,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 223, 30,  0,   0,   0,   77,  253, 255, 90,  0,   0,   0,   21,  213, 255, 145, 0,   133, 255, 223,
     30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  213, 255, 145, 0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  27,  203, 255, 140, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   29,  207, 57,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   45,  208, 35,  0,   39,  231, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     235, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,
     133, 255, 224, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  214, 255, 145, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   152, 46,  214, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 220, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     13,  169, 32,  0,   0,   0,   0,   0,   101, 110, 0,   0,   0,   0,   0,   23,  170, 18,  0,   13,  169, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  170, 18,  0,   7,
     152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 46,  153, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   1,   0,   0,   0,   41,  233, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   13,  169, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  170,
     18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,   0,   0,   10,  166, 32,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   126, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   128, 4,   0,   0,   0,   43,  234, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 241, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,
     61,  249, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,
     178, 49,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 44,  179, 18,  0,   130, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255,
     255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   10,  166, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  168, 15,  0,   11,  167, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     23,  168, 15,  0,   13,  178, 49,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 199, 13,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   8,   186, 255, 129, 0,   0,   0,   0,   15,  28,  28,  28,  28,  40,  40,  28,  28,  28,  28,  17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 253, 91,  139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 149, 78,  250, 152, 0,   11,  167, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   23,  168, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 228, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  218, 255, 144,
     0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  27,  203, 255, 140, 0,
     140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   21,  212, 255, 142, 0,   131, 255, 224, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  212, 255, 142, 0,   132, 255, 228, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   107, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,
     0,   11,  194, 196, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 142, 83,  147, 0,   131, 255, 224, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  212, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 220, 46,  153, 12,  0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   111, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 22,  0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 170, 0,   0,   0,   127, 255, 214, 33,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,
     0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   13,  178, 49,  196, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 203, 16,  0,   0,   0,   7,   152, 46,  214, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 220, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,
     0,   100, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  105, 0,   0,   0,   0,   0,   0,   0,   0,   11,  194, 255, 255, 255, 240, 51,  0,   0,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 228, 34,  0,   20,  52,  44,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 170, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 214, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,
     206, 152, 0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255, 242, 56,  0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   100, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  196, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 203, 44,  179, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,
     140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,
     0,   0,   0,   0,   0,   0,   140, 255, 212, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  201, 255, 152, 0,   0,   0,   0,   0,   0,   10,  159, 45,  210, 255, 245, 61,  0,   0,
     0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132,
     0,   100, 255, 255, 255, 112, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  218, 255, 144, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255,
     152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   110, 255, 255, 152, 0,   0,   0,   0,   0,   0,   184, 255, 214, 20,  28,  18,  0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     90,  255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140,
     255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   19,  210, 255, 255, 255, 107, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   132,
     255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   244, 255, 255, 28,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   38,  224, 224, 95,  135, 171, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 252, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  17,  0,   0,   0,
     0,   140, 255, 255, 132, 0,   0,   22,  213, 255, 255, 254, 103, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   112, 255, 255, 152, 0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   244, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,
     0,   0,   44,  255, 255, 253, 90,  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 129, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   109,
     255, 255, 152, 0,   140, 253, 91,  139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 241, 53,  0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   24,  216, 255, 255, 254, 100, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   84,  255, 253, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  62,  249, 255, 94,  0,   140, 255, 255, 129, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 232, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   30,  224, 255, 152, 0,   0,   0,   0,
     0,   0,   0,   0,   105, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,
     0,   244, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 253, 76,  27,  28,  28,  28,  28,  28,  28,  26,  223, 255, 255, 252, 86,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   140, 255, 207, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  196, 255, 152, 0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 238, 49,  0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   26,  219, 255, 255, 254, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 212, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  202, 255, 152, 0,   0,   105, 93,  137, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 146, 81,  114, 0,   0,   140, 255, 207, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     140, 234, 43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  227, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 253, 85,  0,   0,   0,   0,   0,   0,   0,   0,   140,
     255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   244, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 93,  137,
     255, 255, 255, 255, 255, 255, 255, 199, 46,  226, 255, 255, 251, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 210, 19,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   14,  201, 152, 0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 236, 46,  0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   28,  221,
     255, 255, 253, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 214, 23,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  206, 152, 0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,   140, 210, 19,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   119, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,
     126, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152,
     0,   0,   0,   0,   0,   0,   244, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 132, 36,  229, 255, 255, 152, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   96,  21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  101, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   30,  224, 255, 255, 252, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   101, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  105, 0,   0,   0,
     0,   115, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   96,  21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   244, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   115, 255, 255, 255, 255, 255, 255, 255, 183, 7,   0,   40,  232, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   41,  0,   140, 255, 255, 130, 0,   0,
     0,   0,   0,   0,   0,   33,  226, 255, 255, 251, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 249, 69,  0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   244, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   140, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 130, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   117, 151, 0,   140, 255, 212, 21,  0,   0,   0,   0,   0,   0,   0,   0,   35,  228, 255, 255, 251, 76,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   100, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  105, 0,   1,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   39,  231, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 145, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   59,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255,
     140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 152, 0,   0,   0,   0,   0,   0,   242, 255, 255, 28,  0,   0,
     0,   0,   0,   0,   36,  229, 255, 255, 255, 210, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 247, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     27,  244, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 152, 0,   140,
     214, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  231, 255, 255, 152, 0,   0,   2,   28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  62,  249, 255, 94,  0,   140, 214,
     22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  206, 152, 0,   109, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  118, 0,   0,   41,  233,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   50,  194, 255, 255, 233, 161,
     65,  0,   0,   0,   0,   0,   2,   134, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 223, 30,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   21,  213, 255, 145, 0,   0,   1,   27,  28,  25,  97,  254, 251, 20,  0,   0,   0,   0,   0,   0,   0,   39,  231, 255, 255, 255, 172, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 177, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   140, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   77,  255, 255, 152, 0,   101, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   41,  233, 255, 152,
     0,   1,   156, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 146, 81,  114, 0,   0,   140, 255, 212, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  201, 255, 152, 0,
     136, 227, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  215, 156, 0,   0,   0,   43,  234, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 166, 2,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   62,  247, 255, 255, 255, 255, 255, 255, 214, 119, 57,  37,  81,  195, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   13,  169, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  170, 18,  0,   1,   150, 255, 255, 255, 116,
     99,  85,  0,   0,   0,   0,   0,   0,   0,   0,   0,   41,  233, 255, 223, 46,  161, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   69,  255, 255, 255, 72,  0,   0,   0,   0,
     0,   0,   0,   0,   62,  255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   77,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,
     0,   0,   0,   140, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 152, 0,   136, 255, 225, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  211, 255,
     156, 0,   0,   0,   0,   15,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  44,  31,  16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   71,  255, 255, 255, 255, 252, 39,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  28,  14,  200, 255,
     200, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   173, 255, 255, 217, 6,   0,   0,   0,   0,   0,   0,   3,   209, 255, 255, 185, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   135, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     112, 255, 255, 152, 0,   136, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   107, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,
     231, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 181, 57,  10,  50,  155, 250, 255, 255, 255, 255, 255, 255, 250, 72,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   11,  167, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  168, 15,  0,   0,
     123, 255, 255, 252, 89,  125, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  246, 255,
     255, 119, 0,   0,   0,   0,   0,   0,   108, 255, 255, 250, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   136, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   196, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   139, 119, 0,   0,   0,   0,   0,   34,  141, 211, 244, 249, 225, 161, 42,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,
     0,   0,   131, 255, 224, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  212, 255, 142, 0,   0,   0,   0,   0,   0,   119, 255, 253, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 243, 26,  0,   0,   0,   0,   20,  238, 255, 255, 139, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   136, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   145, 255, 255, 255, 83,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111,
     255, 255, 152, 0,   0,   0,   0,   0,   0,   244, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   7,   221, 255, 255, 165, 0,   0,   0,   0,   154, 255, 255, 231, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   136, 255, 255, 136, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,
     0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   244, 255, 255, 28,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   77,  255, 255, 255, 61,  0,   0,   51,  253, 255, 255, 93,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   136, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   43,  244, 255, 255, 190, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   244, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   181, 255, 255, 208, 3,   1,   198, 255, 255, 197, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   136, 255,
     255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  217, 255, 255, 227, 22,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     96,  255, 255, 103, 0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   244, 255, 255,
     28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  248, 255, 255, 90,  78,  255,
     255, 253, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255,
     152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   136, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   173, 255, 255, 249, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 129, 0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   244, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 4,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 255, 112, 100, 255, 255, 153, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   140, 255, 255, 86,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  252, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 131, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255,
     255, 152, 0,   136, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   119, 255, 255, 255, 102, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,
     0,   0,   244, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,
     226, 255, 112, 100, 255, 238, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   65,  247, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   91,  248, 75,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   133, 255, 223, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  213, 255, 145, 0,   136, 255, 255, 135, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     106, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  252, 255, 255, 157, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   244, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     2,   245, 255, 112, 23,  28,  28,  3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  236, 103, 92,  236, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  169, 32,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   23,  170, 18,  0,   124, 255, 216, 14,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  25,  198, 255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  249, 220, 171,
     7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255,
     152, 0,   0,   0,   0,   0,   0,   244, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   67,  116, 98,  254, 255, 255, 168, 3,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  1,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   21,  127, 128, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   152, 6,   212, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 221, 45,  153, 13,  0,   0,   0,   0,   0,   0,   0,   0,   6,   5,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   84,  255, 253, 76,  27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  62,  249, 255, 94,  0,   0,   0,   0,   0,   0,   184, 255, 215, 20,  28,  18,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   23,  245, 255, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  236, 103, 92,  236, 94,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,  254, 145, 1,   0,   0,   0,   0,   0,   0,   0,   0,   19,  210, 255, 255, 97,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  166, 32,  0,   0,   0,
     0,   0,   100, 110, 0,   0,   0,   0,   0,   23,  168, 15,  0,   0,   0,   149, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 171, 0,   0,   0,   0,   0,   0,   0,   0,   1,   177,
     255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 93,  137, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 146, 81,  114, 0,   0,   0,   0,   0,   0,   0,   10,  160, 45,  210, 255, 245, 61,  0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  143, 75,  249, 255, 255, 143, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  226, 255, 112, 100, 255, 232, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255,
     255, 105, 0,   0,   0,   0,   0,   0,   0,   17,  206, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 223, 30,  0,   0,   0,   77,  253, 255, 90,  0,   0,   0,   21,  212, 255, 142, 0,   0,   0,   10,  194,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 205, 43,  179, 20,  0,   0,   0,   0,   0,   0,   127, 255, 255, 123, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255,
     255, 242, 56,  0,   0,   0,   0,   0,   0,   0,   3,   249, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 255, 112, 100, 255, 255, 144,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   0,   15,  202, 255, 255, 255, 139, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140,
     255, 255, 131, 0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   111, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  216, 255, 148, 0,   0,   0,
     0,   0,   72,  253, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   115, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  195, 255, 255, 255, 240, 51,  0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 4,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  248, 255, 255, 90,  78,  255, 255, 251, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   0,   12,  198, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   112, 255, 255, 152,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   0,   32,  237, 255, 255, 225, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   180, 255, 255, 208,
     3,   1,   199, 255, 255, 191, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   0,   10,  193, 255, 255, 255, 148,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255,
     255, 156, 0,   0,   0,   8,   205, 255, 255, 247, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255,
     255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   77,  255, 255, 255, 61,  0,   0,   51,  253, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   9,   189, 255, 255, 255, 152, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   128, 255, 255, 144, 0,   0,
     0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   0,   0,   156, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,
     220, 255, 255, 165, 0,   0,   0,   0,   154, 255, 255, 228, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   7,   185, 255,
     255, 255, 156, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   128, 255, 255, 144, 0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   108, 255, 255, 156, 0,   0,   100, 255, 255, 255, 149, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 243, 26,  0,   0,   0,   0,   20,  238, 255, 255, 136, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   6,   180, 255, 255, 255, 160, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   128,
     255, 255, 144, 0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   51,  248, 255, 255, 196, 5,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   30,  246, 255, 255, 119, 0,   0,   0,   0,   0,   0,   108, 255, 255, 249, 38,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132,
     4,   175, 255, 255, 255, 164, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 0,   0,   0,   108, 255, 255, 124, 0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   140, 255, 255, 230, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   173, 255, 255, 217, 6,   0,   0,   0,   0,   0,   0,   3,   209, 255,
     255, 183, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 167, 255, 255, 255, 168, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255,
     132, 0,   0,   0,   1,   157, 165, 3,   0,   0,   0,   112, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   140, 255, 250, 59,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 4,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   62,  255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   140, 255, 255, 132, 244, 255, 255, 172, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 252, 76,  27,  28,  28,  28,  30,  31,  28,  28,  28,  28,  61,  249, 255, 152, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 156, 0,   19,  38,  55,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,  1,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  28,  14,  200, 255, 200, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 177, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   166, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 132, 244, 255, 176, 5,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   140, 253, 91,  139, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 149, 78,  250, 152, 0,   0,   0,   0,   0,   27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  59,  248, 255, 98,
     0,   1,   156, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 149, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   41,  232, 255, 223, 45,  161, 16,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 248, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  244, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   39,  231, 225, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   137, 94,  132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     142, 83,  147, 0,   0,   0,   0,   133, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 148, 78,  117, 0,   0,   77,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 142,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  231, 255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 131, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  33,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   22,  124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 22,  0,   0,   0,   54,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 68,  0,   0,   0,   0,   135, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 135, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  229, 255, 255,
     255, 210, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 126, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
    45.000000f, 45.000000f, -0.009999f, 36.820000f, -8.190000f, 96, {{L'\0', 0, 0, 0, 0, 0.000000f, 0.000000f, 0.011719f, 0.011719f, 0.015625f, 0.015625f, 0, {}},
                                                                     {L' ', 0, 0, 0, 0, 10.640625f, 0.000000f, 0.023438f, 0.003906f, 0.023438f, 0.003906f, 0, {}},
                                                                     {L'!', 4, 33, 4, 29, 11.734375f, 0.000000f, 0.027344f, 0.003906f, 0.042969f, 0.132812f, 0, {}},
                                                                     {L'"', 9, 7, 2, 29, 12.515625f, 0.000000f, 0.046875f, 0.003906f, 0.082031f, 0.031250f, 0, {}},
                                                                     {L'#', 21, 25, 0, 27, 22.828125f, 0.000000f, 0.085938f, 0.003906f, 0.167969f, 0.101562f, 0, {}},
                                                                     {L'$', 18, 41, 2, 35, 22.046875f, 0.000000f, 0.171875f, 0.003906f, 0.242188f, 0.164062f, 0, {}},
                                                                     {L'%', 23, 29, 2, 29, 27.203125f, 0.000000f, 0.246094f, 0.003906f, 0.335938f, 0.117188f, 0, {}},
                                                                     {L'&', 21, 29, 2, 29, 22.046875f, 0.000000f, 0.339844f, 0.003906f, 0.421875f, 0.117188f, 0, {}},
                                                                     {L'\'', 4, 7, 2, 29, 7.937500f, 0.000000f, 0.425781f, 0.003906f, 0.441406f, 0.031250f, 0, {}},
                                                                     {L'(', 10, 29, 2, 29, 14.437500f, 0.000000f, 0.445312f, 0.003906f, 0.484375f, 0.117188f, 0, {}},
                                                                     {L')', 10, 29, 2, 29, 14.437500f, 0.000000f, 0.488281f, 0.003906f, 0.527344f, 0.117188f, 0, {}},
                                                                     {L'*', 14, 17, 2, 30, 17.796875f, 0.000000f, 0.531250f, 0.003906f, 0.585938f, 0.070312f, 0, {}},
                                                                     {L'+', 15, 15, 2, 22, 18.609375f, 0.000000f, 0.589844f, 0.003906f, 0.648438f, 0.062500f, 0, {}},
                                                                     {L',', 4, 8, 2, 3, 7.937500f, 0.000000f, 0.652344f, 0.003906f, 0.667969f, 0.035156f, 0, {}},
                                                                     {L'-', 15, 4, 2, 17, 18.609375f, 0.000000f, 0.671875f, 0.003906f, 0.730469f, 0.019531f, 0, {}},
                                                                     {L'.', 4, 4, 2, 4, 7.937500f, 0.000000f, 0.734375f, 0.003906f, 0.750000f, 0.019531f, 0, {}},
                                                                     {L'/', 19, 30, 1, 30, 20.703125f, 0.000000f, 0.753906f, 0.003906f, 0.828125f, 0.121094f, 0, {}},
                                                                     {L'0', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.832031f, 0.003906f, 0.902344f, 0.117188f, 0, {}},
                                                                     {L'1', 4, 29, 4, 29, 11.734375f, 0.000000f, 0.906250f, 0.003906f, 0.921875f, 0.117188f, 0, {}},
                                                                     {L'2', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.671875f, 0.023438f, 0.742188f, 0.136719f, 0, {}},
                                                                     {L'3', 17, 29, 3, 29, 22.046875f, 0.000000f, 0.925781f, 0.003906f, 0.992188f, 0.117188f, 0, {}},
                                                                     {L'4', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.589844f, 0.066406f, 0.660156f, 0.179688f, 0, {}},
                                                                     {L'5', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.046875f, 0.105469f, 0.117188f, 0.218750f, 0, {}},
                                                                     {L'6', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.425781f, 0.121094f, 0.496094f, 0.234375f, 0, {}},
                                                                     {L'7', 17, 29, 3, 29, 22.046875f, 0.000000f, 0.500000f, 0.121094f, 0.566406f, 0.234375f, 0, {}},
                                                                     {L'8', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.832031f, 0.121094f, 0.902344f, 0.234375f, 0, {}},
                                                                     {L'9', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.906250f, 0.121094f, 0.976562f, 0.234375f, 0, {}},
                                                                     {L':', 4, 25, 3, 25, 9.859375f, 0.000000f, 0.003906f, 0.023438f, 0.019531f, 0.121094f, 0, {}},
                                                                     {L';', 4, 30, 3, 25, 9.859375f, 0.000000f, 0.570312f, 0.074219f, 0.585938f, 0.191406f, 0, {}},
                                                                     {L'<', 12, 19, 2, 24, 16.203125f, 0.000000f, 0.121094f, 0.105469f, 0.167969f, 0.179688f, 0, {}},
                                                                     {L'=', 15, 10, 2, 20, 18.609375f, 0.000000f, 0.246094f, 0.121094f, 0.304688f, 0.160156f, 0, {}},
                                                                     {L'>', 12, 19, 2, 24, 16.203125f, 0.000000f, 0.308594f, 0.121094f, 0.355469f, 0.195312f, 0, {}},
                                                                     {L'?', 18, 33, 2, 29, 22.046875f, 0.000000f, 0.746094f, 0.125000f, 0.816406f, 0.253906f, 0, {}},
                                                                     {L'@', 22, 29, 2, 29, 25.859375f, 0.000000f, 0.171875f, 0.167969f, 0.257812f, 0.281250f, 0, {}},
                                                                     {L'A', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.664062f, 0.140625f, 0.734375f, 0.253906f, 0, {}},
                                                                     {L'B', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.589844f, 0.183594f, 0.660156f, 0.296875f, 0, {}},
                                                                     {L'C', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.261719f, 0.199219f, 0.332031f, 0.312500f, 0, {}},
                                                                     {L'D', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.335938f, 0.199219f, 0.406250f, 0.312500f, 0, {}},
                                                                     {L'E', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.023438f, 0.222656f, 0.093750f, 0.335938f, 0, {}},
                                                                     {L'F', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.097656f, 0.222656f, 0.167969f, 0.335938f, 0, {}},
                                                                     {L'G', 18, 30, 2, 29, 22.046875f, 0.000000f, 0.820312f, 0.238281f, 0.890625f, 0.355469f, 0, {}},
                                                                     {L'H', 18, 30, 2, 30, 22.046875f, 0.000000f, 0.410156f, 0.238281f, 0.480469f, 0.355469f, 0, {}},
                                                                     {L'I', 4, 29, 4, 29, 11.734375f, 0.000000f, 0.003906f, 0.125000f, 0.019531f, 0.238281f, 0, {}},
                                                                     {L'J', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.484375f, 0.238281f, 0.554688f, 0.351562f, 0, {}},
                                                                     {L'K', 18, 30, 2, 30, 22.046875f, 0.000000f, 0.894531f, 0.238281f, 0.964844f, 0.355469f, 0, {}},
                                                                     {L'L', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.738281f, 0.257812f, 0.808594f, 0.371094f, 0, {}},
                                                                     {L'M', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.664062f, 0.257812f, 0.734375f, 0.371094f, 0, {}},
                                                                     {L'N', 18, 30, 2, 29, 22.046875f, 0.000000f, 0.171875f, 0.285156f, 0.242188f, 0.402344f, 0, {}},
                                                                     {L'O', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.558594f, 0.300781f, 0.628906f, 0.414062f, 0, {}},
                                                                     {L'P', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.246094f, 0.316406f, 0.316406f, 0.429688f, 0, {}},
                                                                     {L'Q', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.320312f, 0.316406f, 0.390625f, 0.429688f, 0, {}},
                                                                     {L'R', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.003906f, 0.339844f, 0.074219f, 0.453125f, 0, {}},
                                                                     {L'S', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.078125f, 0.339844f, 0.148438f, 0.453125f, 0, {}},
                                                                     {L'T', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.484375f, 0.355469f, 0.554688f, 0.468750f, 0, {}},
                                                                     {L'U', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.812500f, 0.359375f, 0.882812f, 0.472656f, 0, {}},
                                                                     {L'V', 18, 30, 2, 30, 22.046875f, 0.000000f, 0.394531f, 0.359375f, 0.464844f, 0.476562f, 0, {}},
                                                                     {L'W', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.886719f, 0.359375f, 0.957031f, 0.472656f, 0, {}},
                                                                     {L'X', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.632812f, 0.375000f, 0.703125f, 0.488281f, 0, {}},
                                                                     {L'Y', 18, 30, 2, 30, 22.046875f, 0.000000f, 0.707031f, 0.375000f, 0.777344f, 0.492188f, 0, {}},
                                                                     {L'Z', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.152344f, 0.406250f, 0.222656f, 0.519531f, 0, {}},
                                                                     {L'[', 10, 29, 2, 29, 14.437500f, 0.000000f, 0.558594f, 0.417969f, 0.597656f, 0.531250f, 0, {}},
                                                                     {L'\\', 19, 30, 1, 30, 20.703125f, 0.000000f, 0.226562f, 0.433594f, 0.300781f, 0.550781f, 0, {}},
                                                                     {L']', 10, 29, 2, 29, 14.437500f, 0.000000f, 0.304688f, 0.433594f, 0.343750f, 0.546875f, 0, {}},
                                                                     {L'^', 16, 10, 2, 29, 20.125000f, 0.000000f, 0.003906f, 0.457031f, 0.066406f, 0.496094f, 0, {}},
                                                                     {L'_', 17, 4, 1, -4, 18.203125f, 0.000000f, 0.070312f, 0.457031f, 0.136719f, 0.472656f, 0, {}},
                                                                     {L'`', 6, 8, 2, 30, 10.187500f, 0.000000f, 0.968750f, 0.238281f, 0.992188f, 0.269531f, 0, {}},
                                                                     {L'a', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.468750f, 0.472656f, 0.539062f, 0.585938f, 0, {}},
                                                                     {L'b', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.781250f, 0.476562f, 0.851562f, 0.589844f, 0, {}},
                                                                     {L'c', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.070312f, 0.476562f, 0.140625f, 0.589844f, 0, {}},
                                                                     {L'd', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.855469f, 0.476562f, 0.925781f, 0.589844f, 0, {}},
                                                                     {L'e', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.347656f, 0.480469f, 0.417969f, 0.593750f, 0, {}},
                                                                     {L'f', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.601562f, 0.492188f, 0.671875f, 0.605469f, 0, {}},
                                                                     {L'g', 18, 30, 2, 29, 22.046875f, 0.000000f, 0.675781f, 0.496094f, 0.746094f, 0.613281f, 0, {}},
                                                                     {L'h', 18, 30, 2, 30, 22.046875f, 0.000000f, 0.144531f, 0.523438f, 0.214844f, 0.640625f, 0, {}},
                                                                     {L'i', 4, 29, 4, 29, 11.734375f, 0.000000f, 0.968750f, 0.273438f, 0.984375f, 0.386719f, 0, {}},
                                                                     {L'j', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.218750f, 0.554688f, 0.289062f, 0.667969f, 0, {}},
                                                                     {L'k', 18, 30, 2, 30, 22.046875f, 0.000000f, 0.421875f, 0.589844f, 0.492188f, 0.707031f, 0, {}},
                                                                     {L'l', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.496094f, 0.589844f, 0.566406f, 0.703125f, 0, {}},
                                                                     {L'm', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.750000f, 0.593750f, 0.820312f, 0.707031f, 0, {}},
                                                                     {L'n', 18, 30, 2, 29, 22.046875f, 0.000000f, 0.003906f, 0.593750f, 0.074219f, 0.710938f, 0, {}},
                                                                     {L'o', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.824219f, 0.593750f, 0.894531f, 0.707031f, 0, {}},
                                                                     {L'p', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.898438f, 0.593750f, 0.968750f, 0.707031f, 0, {}},
                                                                     {L'q', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.292969f, 0.597656f, 0.363281f, 0.710938f, 0, {}},
                                                                     {L'r', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.570312f, 0.609375f, 0.640625f, 0.722656f, 0, {}},
                                                                     {L's', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.644531f, 0.617188f, 0.714844f, 0.730469f, 0, {}},
                                                                     {L't', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.078125f, 0.644531f, 0.148438f, 0.757812f, 0, {}},
                                                                     {L'u', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.152344f, 0.671875f, 0.222656f, 0.785156f, 0, {}},
                                                                     {L'v', 18, 30, 2, 30, 22.046875f, 0.000000f, 0.496094f, 0.707031f, 0.566406f, 0.824219f, 0, {}},
                                                                     {L'w', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.718750f, 0.710938f, 0.789062f, 0.824219f, 0, {}},
                                                                     {L'x', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.367188f, 0.710938f, 0.437500f, 0.824219f, 0, {}},
                                                                     {L'y', 18, 30, 2, 30, 22.046875f, 0.000000f, 0.792969f, 0.710938f, 0.863281f, 0.828125f, 0, {}},
                                                                     {L'z', 18, 29, 2, 29, 22.046875f, 0.000000f, 0.867188f, 0.710938f, 0.937500f, 0.824219f, 0, {}},
                                                                     {L'{', 14, 29, 1, 29, 17.093750f, 0.000000f, 0.226562f, 0.671875f, 0.281250f, 0.785156f, 0, {}},
                                                                     {L'|', 4, 37, 4, 29, 11.203125f, 0.000000f, 0.972656f, 0.390625f, 0.988281f, 0.535156f, 0, {}},
                                                                     {L'}', 14, 29, 2, 29, 17.093750f, 0.000000f, 0.285156f, 0.714844f, 0.339844f, 0.828125f, 0, {}},
                                                                     {L'~', 16, 7, 2, 17, 20.125000f, 0.000000f, 0.003906f, 0.714844f, 0.066406f, 0.742188f, 0, {}}, }};
#ifdef __cplusplus
}
#endif
