Chrono FEA tutorials {#tutorial_table_of_content_chrono_fea}
===========================

Tutorials that teach how to use the 
[FEA module](group__chrono__fea.html).

- @subpage  tutorial_demo_FEA_basic

  Learn the very basics: create mesh container, add nodes and elements, and perform linear static analysis (on single elements).
  

- @subpage  tutorial_demo_FEA_visualize

  Learn how to visualize FEA in the realtime view, also learn to use tetrahedrons and hexahedrons for nonlinear dynamics.
  
  
- @subpage  tutorial_demo_FEA_cables

  Learn how to create cables using ChElementCableANCF, and connect some bodies 
  
  
- @subpage  tutorial_demo_FEA_beams

  Learn how to create beams using ChElementBeamEuler 
  
  
- @subpage  tutorial_demo_FEA_loads

  Here you can learn how to apply loads to elements, or how to create your custom loads.
  
  
- @subpage  tutorial_demo_FEA_ancfShell

  Learn to use ANCF shell elements
  
  
- @subpage  tutorial_demo_FEA_shells

  Learn to use Reissner 6-field shell elements
  

- @subpage  tutorial_demo_FEA_brick

  Learn to use ANCF brick elements
  
  
- @subpage  tutorial_demo_FEA_contacts

  How to perform contact between FEA meshes in three dimensional space, with automatic collision detection
  
  
- @subpage  tutorial_demo_FEA_abaqus_wheel

  Import an .INP Abaqus mesh with a 3D tetrahedral mesh
  
  
- @subpage  tutorial_demo_FEA_cosimulate_load

  Import an .INP Abaqus mesh with a 3D tetrahedral mesh and apply loads to the surface coming from an external process.
  
  
- @subpage  tutorial_demo_FEA_thermal

  Compute a simple solution for the temperature field in a solid, given boundary conditions (Poisson problem).
  
  
- @subpage  tutorial_demo_FEA_electrostatics

  Compute the electrostatic solution for a volume given boundary conditions (high voltage electrodes in air).