# Exported variables:
#  MUMPS_FOUND
#  MUMPS_INCLUDE_DIRS
#  MUMPS_LIBRARIES
#  MUMPS_CXX_COMPILE_FLAGS
#  MUMPS_CXX_LINK_FLAGS


##########################
UNSET(MUMPS_FOUND)

IF (NOT MUMPS_ROOT)
	SET(MUMPS_ROOT "C:/Program Files/Mumps" CACHE PATH "Mumps root directory" FORCE)
ENDIF()
SET(MUMPS_USE_MPI FALSE CACHE BOOL "Select if MPI is needed" FORCE)
SET(MUMPS_USE_DEFAULT_ORDERINGS TRUE CACHE BOOL "Select if default ordering library should be used" FORCE)

UNSET(MUMPS_ONLY_LIBRARY_COMMON CACHE)
UNSET(MUMPS_ONLY_LIBRARY_ARITHMETIC_SPECIFIC CACHE)
UNSET(MUMPS_ONLY_INCLUDE_DIRS CACHE)
UNSET(MUMPS_ONLY_LIBRARIES CACHE)
UNSET(MUMPS_MPI_INCLUDE_DIRS CACHE)
UNSET(MUMPS_MPI_LIBRARIES CACHE)
UNSET(MUMPS_ORDERINGS_INCLUDE_DIRS CACHE)
UNSET(MUMPS_ORDERINGS_LIBRARIES CACHE)
UNSET(MUMPS_INCLUDE_DIRS CACHE)
UNSET(MUMPS_LIBRARIES CACHE)
UNSET(MUMPS_SHARED_LIBRARIES CACHE)

set(MUMPS_CXX_COMPILE_FLAGS "")
set(MUMPS_CXX_LINK_FLAGS "")

################# Mumps library itself #####################

unset(MUMPS_ONLY_FOUND)

find_library(MUMPS_ONLY_LIBRARY_COMMON
			 NAMES "libmumps_common" "libmumps_common.a"
			 PATHS ${MUMPS_ROOT}
			 PATH_SUFFIXES "lib" "lib64" "libraries"
         )

find_library(MUMPS_ONLY_LIBRARY_ARITHMETIC_SPECIFIC
			 NAMES "lib${MUMPS_ARITH_PREFIX}mumps" "lib${MUMPS_ARITH_PREFIX}mumps.a"
			 PATHS ${MUMPS_ROOT}
			 PATH_SUFFIXES "lib" "lib64" "libraries"
         )
         
find_file (MUMPS_SHARED_LIBRARIES
          "lib${MUMPS_ARITH_PREFIX}mumps${CMAKE_SHARED_LIBRARY_SUFFIX}"
          PATHS ${MUMPS_ROOT}
	      PATH_SUFFIXES "bin"
         )

find_path(MUMPS_ONLY_INCLUDE_DIRS
          NAMES "${MUMPS_ARITH_PREFIX}mumps_c.h"
          PATHS ${MUMPS_ROOT}
          PATH_SUFFIXES "include" "inc"
         )

if(MUMPS_ONLY_LIBRARY_ARITHMETIC_SPECIFIC AND MUMPS_ONLY_INCLUDE_DIRS)
	set(MUMPS_ONLY_LIBRARIES ${MUMPS_ONLY_LIBRARY_ARITHMETIC_SPECIFIC})
	if((MUMPS_IS_SHARED_LIB AND MUMPS_SHARED_LIBRARIES) OR MUMPS_ONLY_LIBRARY_COMMON)
		set(MUMPS_ONLY_FOUND TRUE)
		if(MUMPS_ONLY_LIBRARY_COMMON)
			set(MUMPS_ONLY_LIBRARIES ${MUMPS_ONLY_LIBRARY_COMMON} ${MUMPS_ONLY_LIBRARY_ARITHMETIC_SPECIFIC})
		endif()
	endif()
endif()

################# MPI support #####################

unset(MUMPS_MPI_FOUND)

if(MUMPS_USE_MPI)
	if(NOT MPI_FOUND)
		message("MPI not available. Cannot build Chrono::Mumps with MPI support.")
		set(MUMPS_FOUND FALSE)
		return()
	endif()

    set(MUMPS_CXX_COMPILE_FLAGS "${MPI_CXX_COMPILE_FLAGS}")
    set(MUMPS_CXX_LINK_FLAGS "${MPI_CXX_LINK_FLAGS}")
    set(MUMPS_MPI_INCLUDE_DIRS "${MPI_CXX_INCLUDE_PATH}")
	set(MUMPS_MPI_LIBRARIES "${MPI_CXX_LIBRARIES}")
else()
	if(MUMPS_IS_SHARED_LIB)
	  find_path(MUMPS_MPI_INCLUDE_DIRS
				mpi.h
				PATHS ${MUMPS_ROOT}
				PATH_SUFFIXES "include" "libseq" "libseqmpi" "libseq/include" "libseqmpi/include"
				NO_DEFAULT_PATH
			    NO_SYSTEM_ENVIRONMENT_PATH)
	else()
      set(MUMPS_MPI_INCLUDE_DIRS "")
	endif()

	find_library(MUMPS_MPI_LIBRARIES
				NAMES libmpiseq libmpiseq.a
				PATHS ${MUMPS_ROOT}
				PATH_SUFFIXES "libseq" "libseqmpi" "lib" "lib64"
				NO_DEFAULT_PATH
			    NO_SYSTEM_ENVIRONMENT_PATH)
endif()

if((MUMPS_IS_SHARED_LIB AND MUMPS_MPI_INCLUDE_DIRS) OR MUMPS_MPI_LIBRARIES)
	set(MUMPS_MPI_FOUND TRUE)
endif()

################# Ordering library #####################

unset(MUMPS_ORDERINGS_FOUND)
if(MUMPS_USE_DEFAULT_ORDERINGS)
	# TODO: have they to be included?
	# find_path(MUMPS_ORDERINGS_INCLUDE_DIRS
				# protos.h
				# PATHS ${MUMPS_ROOT}
				# PATH_SUFFIXES "PORD/include" "PORD" "include"
	# )
	
	find_library(MUMPS_ORDERINGS_LIBRARIES
				NAMES libpord libpord.a
				PATHS ${MUMPS_ROOT}
				PATH_SUFFIXES "PORD/lib" "PORD" "PORD/libraries" "lib" "lib64"
	)
else()
	message("Non-default orderings is not implemented yet.")
	# SET(MUMPS_ORDERINGS_LIBRARIES "" CACHE PATH "Path to ordering library" FORCE)
endif()

if(MUMPS_ORDERINGS_LIBRARIES)
	set(MUMPS_ORDERINGS_FOUND TRUE)
endif()

################# Clean up #####################

MARK_AS_ADVANCED(FORCE MUMPS_ONLY_LIBRARY_COMMON)
MARK_AS_ADVANCED(FORCE MUMPS_ONLY_LIBRARY_ARITHMETIC_SPECIFIC)
MARK_AS_ADVANCED(FORCE MUMPS_ONLY_INCLUDE_DIRS)
MARK_AS_ADVANCED(FORCE MUMPS_ONLY_LIBRARIES)
MARK_AS_ADVANCED(FORCE MUMPS_MPI_INCLUDE_DIRS)
MARK_AS_ADVANCED(FORCE MUMPS_MPI_LIBRARIES)
MARK_AS_ADVANCED(FORCE MUMPS_ORDERINGS_INCLUDE_DIRS)
MARK_AS_ADVANCED(FORCE MUMPS_ORDERINGS_LIBRARIES)
MARK_AS_ADVANCED(FORCE MUMPS_INCLUDE_DIRS)
MARK_AS_ADVANCED(FORCE MUMPS_LIBRARIES)
MARK_AS_ADVANCED(FORCE MUMPS_SHARED_LIBRARIES)

################# Exported variables #####################

if(MUMPS_ONLY_FOUND)
	set(MUMPS_INCLUDE_DIRS ${MUMPS_ONLY_INCLUDE_DIRS} ${MUMPS_MPI_INCLUDE_DIRS} ${MUMPS_ORDERINGS_INCLUDE_DIRS})
    list(REMOVE_DUPLICATES MUMPS_INCLUDE_DIRS)

	if(MUMPS_IS_SHARED_LIB AND MUMPS_SHARED_LIBRARIES)
		set(MUMPS_LIBRARIES ${MUMPS_ONLY_LIBRARIES})
		set(MUMPS_FOUND TRUE)
		message(STATUS "Mumps found as shared library.")
	elseif(MUMPS_MPI_FOUND AND MUMPS_ORDERINGS_FOUND)
		set(MUMPS_LIBRARIES ${MUMPS_ONLY_LIBRARIES} ${MUMPS_MPI_LIBRARIES} ${MUMPS_ORDERINGS_LIBRARIES})
		set(MUMPS_FOUND TRUE)
		message(STATUS "Mumps found as static library.")
	else()
		message(STATUS "Mumps found, but other required libraries are missing.")
		set(MUMPS_FOUND FALSE)
	endif()
else()
	message(STATUS "Mumps not found.")
    set(MUMPS_FOUND FALSE)
endif()

if(MUMPS_FOUND)
	MARK_AS_ADVANCED(FORCE MUMPS_ROOT)
	MARK_AS_ADVANCED(FORCE MUMPS_USE_MPI)
	MARK_AS_ADVANCED(FORCE MUMPS_USE_DEFAULT_ORDERINGS)
endif()