# Find Graphviz (http://www.graphviz.org)
# Defines
# GRAPHVIZ_INCLUDE_DIRS
# GRAPHVIZ_LIBRARIES
# GRAPHVIZ_FOUND

# First we try to use pkg-config to find what we're looking for
# in the directory specified by the GRAPHVIZ_DIR or GRAPHVIZ_PKG_DIR
if(GRAPHVIZ_DIR)
  if(NOT G_PKG_DIR)
    set(GRAPHVIZ_PKG_DIR "${GRAPHVIZ_DIR}/lib/pkgconfig")
  endif(NOT GRAPHVIZ_PKG_DIR)
endif(GRAPHVIZ_DIR)

find_package(PkgConfig QUIET)
if(PKG_CONFIG_FOUND)
  set(ENV{PKG_CONFIG_PATH} "${GRAPHVIZ_PKG_DIR}:$ENV{PKG_CONFIG_PATH}")
  pkg_check_modules(GRAPHVIZ libgvc)
endif(PKG_CONFIG_FOUND)

FIND_PATH(Graphviz_INCLUDE_DIR NAMES graphviz/gvc.h HINTS Graphviz_INCLUDE_DIRS)

FIND_LIBRARY(GRAPHVIZ_gvc_LIBRARY NAMES gvc HINTS GRAPHVIZ_LIBRARY_DIRS)
FIND_LIBRARY(GRAPHVIZ_graph_LIBRARY NAMES cgraph HINTS GRAPHVIZ_LIBRARY_DIRS)
if( NOT GRAPHVIZ_graph_LIBRARY_FOUND )
    FIND_LIBRARY(GRAPHVIZ_graph_LIBRARY NAMES graph HINTS GRAPHVIZ_LIBRARY_DIRS)
endif( NOT GRAPHVIZ_graph_LIBRARY_FOUND )
FIND_LIBRARY(GRAPHVIZ_cdt_LIBRARY NAMES cdt HINTS GRAPHVIZ_LIBRARY_DIRS)
FIND_LIBRARY(GRAPHVIZ_pathplan_LIBRARY NAMES pathplan HINTS GRAPHVIZ_LIBRARY_DIRS)

SET(Graphviz_LIBRARY ${GRAPHVIZ_gvc_LIBRARY} ${GRAPHVIZ_graph_LIBRARY} ${GRAPHVIZ_cdt_LIBRARY} ${GRAPHVIZ_pathplan_LIBRARY})

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(Graphviz DEFAULT_MSG Graphviz_LIBRARY Graphviz_INCLUDE_DIR)

IF(Graphviz_FOUND)
    SET(Graphviz_LIBRARIES ${Graphviz_LIBRARY})
    SET(Graphviz_INCLUDE_DIRS ${Graphviz_INCLUDE_DIR} ${Graphviz_INCLUDE_DIR}/graphviz)
ELSE(Graphviz_FOUND)
    SET(Graphviz_LIBRARIES)
    SET(Graphviz_INCLUDE_DIRS)
ENDIF(Graphviz_FOUND)

MARK_AS_ADVANCED(Graphviz_INCLUDE_DIRS Graphviz_LIBRARIES)
