/*
 * This file is part of libsh4lt.
 *
 * libsh4lt is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/**
 * @file   key-val-serializer.h
 *
 * @brief serialize and deserialize an information tree
 *
 * serializing as lines with absolute key path, space(s), value and new line
 * for instance:
 * .child1.child2.vol 0.6
 * .child1.child2.freq 440
 * .child1.child2.name myoscilator
 *
 */

#ifndef SH4LT_INFORMATION_TREE_BASIC_SERIALIZER_H_
#define SH4LT_INFORMATION_TREE_BASIC_SERIALIZER_H_

#include <string>
#include "./information-tree.hpp"

namespace sh4lt::infotree::keyval {

auto serialize(InfoTree::ptrc) -> std::string;
auto deserialize(const std::string& serialized) -> InfoTree::ptr;

}  // namespace sh4lt
#endif
