/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */

#include "./unix-socket-protocol.hpp"
#include <limits>

namespace sh4lt::UnixSocketProtocol {

onConnectData::onConnectData(size_t shm_size, const std::string& user_data) : shm_size_(shm_size) {
  const auto user_data_size = user_data.size();
  const auto size = user_data_size < kUserDataMaxSize ? user_data_size : kUserDataMaxSize;
  std::copy(user_data.begin(), user_data.begin() + size, user_data_.begin());
}

}  // namespace sh4lt
