#pragma once
#include <Device/Protocol/DeviceInterface.hpp>
#include <Device/Protocol/DeviceSettings.hpp>
#include <Device/Protocol/ProtocolFactoryInterface.hpp>
#include <Device/Protocol/ProtocolSettingsWidget.hpp>

#include <Gfx/GfxDevice.hpp>
#include <Gfx/SharedOutputSettings.hpp>

#include <QLineEdit>

namespace Gfx
{
class gfx_protocol_base;
class SyphonProtocolFactory final : public SharedOutputProtocolFactory
{
  SCORE_CONCRETE("087D032D-9A42-4BC9-B3DF-AD9BA9E86C07")

public:
  QString prettyName() const noexcept override;

  Device::DeviceInterface* makeDevice(
      const Device::DeviceSettings& settings, const Explorer::DeviceDocumentPlugin& doc,
      const score::DocumentContext& ctx) override;
  const Device::DeviceSettings& defaultSettings() const noexcept override;

  Device::ProtocolSettingsWidget* makeSettingsWidget() override;
};

class SyphonDevice final : public GfxOutputDevice
{
  W_OBJECT(SyphonDevice)
public:
  using GfxOutputDevice::GfxOutputDevice;
  ~SyphonDevice();

private:
  bool reconnect() override;
  ossia::net::device_base* getDevice() const override { return m_dev.get(); }

  gfx_protocol_base* m_protocol{};
  mutable std::unique_ptr<ossia::net::device_base> m_dev;
};

class SyphonSettingsWidget final : public SharedOutputSettingsWidget
{
public:
  SyphonSettingsWidget(QWidget* parent = nullptr);

  Device::DeviceSettings getSettings() const override;
};
}
