<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

OCIO v2 WORKING GROUP MEETING  
2019-11-20  
via Zoom  

Participants:
  * Dennis Adams (Sony)
  * Sean Cooper (DNeg)
  * Bernard Lefebvre (Autodesk)
  * Thomas Mansencal (Weta)
  * Daniel Mulligan (Method)

Apologies:
  * Michael Dolan (Imageworks)
  * Kevin Wheatley (Framestore)

Hosts:
  * Doug Walker (Autodesk)
  * Patrick Hodoul (Autodesk)

Recording on Zoom cloud:  
<https://autodesk.zoom.us/rec/share/PI4dArh5XhKJqsLnzRFJwmFNvmRJ89SHasA4bsbNt0cfo4nY6QZT-JWGr86hp8hX.nyUZJi7Gtq2IAlm_>


**OPTIMIZATION UPGRADES PR #844**

   - Doug, Patrick, Bernard reviewed this PR.  This is a major upgrade to how
the OpVecs are optimized.
   - The high-level approach has been retained from v1: remove no-ops, remove
pair identities, combine ops.  But we are now able to detect and optimize more
within these categories.
   - We provide both high-level optimization levels as well as control over each
specific type of optimization.
   - Many new unit tests were added.
   - Validation: We discussed what we regarded as a flaw in OCIO v1, namely that
a pair of forward/inverse Lut1DOps would simply be removed.  The problem with
this is that the result of the optimized vector is different than the
unoptimized, since a normal Lut1DOp will clamp incoming values outside [0,1]. 
In other areas of the code, namely equalitygroup handling, there is mention that
"this may provide higher fidelity than anticipated due to internal
optimizations".  However, in the case of removing specific ops we feel the clamp
must be kept and have thus introduced a new method for ops to be able to return
their identity replacement.  Lut1D now returns a Range.  (There were no
objections to this change in behavior.)
   - Sean:  Is there a difference in optimization between CPU and GPU?  Doug:
Most of it is the same, but the CPU processor can now process integer pixel
formats and we do some additional optmization that is possible when the input is
integer.  Separable ops are combined into a Lut1D for the incoming bit-depth.
   - Thomas:  Optim PR looks great!

**VIEW/DISPLAY FIXES  (PR #875, #883)**

   - Doug, Patrick reviewed some bug fixes and improvements.
   - The active_views now filters and sorts views and now behaves as the
documentation claims it does.  ;-)
   - When no active_displays are present, the displays are now preserved in
config order.  (Previously they were resorted into alphabetical order.)
   - We've upgraded to use the latest version of Yaml (0.6.3) and cleaned up a
lot of Yaml build settings.
   - Validation: Should an exception be thrown if an active_view colorspace
doesn't exist?
   - Sean:  Env. var. and config should be handled separately.  Deal with it in
sanityCheck but don't throw.
   - Validation:  The get/setActiveDisplays do not see or override the
environment variable settings.
   - Thomas:  We would like to be able to override the environment variable from
the API.
   - Sean:  If I were writing a tool, I would want to be able to override.  It
could also be a setting in the config that sets the priority (i.e., should API
or env. var. have precedence).

**INACTIVE COLORSPACES FEATURE**

   - Doug proposed a new feature to deal with the problem that color space names
sometimes change over time or become obsolete and yet may need to stay in a
config for backwards compatibility.  
   - The new inactive_colorspaces token in the config would identify ColorSpaces
that should not be in menus but would still be available to an application (e.g.
in calls to getProcessor).  There would also be an OCIO_INACTIVE_COLORSPACES
env. var.
   - Validation: Is it ok if this filters the existing API calls that are used
for building menus?  (This way, apps would benefit from this feature with
minimal work.)
   - Sean:  Sounds fine.  Maybe improve the naming for the new "all" color space
calls since devs may assume those are the correct ones to use for menus.
   - Dennis: We've done something similar internally using the family attribute
but are glad to see a more formal way of doing it.
   - Sean:  Agreed, this looks like it will be very useful.
   - Validation:  Should env. var. or API have priority?  (Same response as
above.)

**EFFECT OF STRICTPARSING TOKEN ON GETCOLORSPACE, ETC.**

   - Doug showed what the documention says about the strictparsing token.  It
seems like it should only affect the process of associating a ColorSpace with an
incoming file.  However, in fact, it applies to any calls an application makes
to get a ColorSpace.  Do others agree this is a defect?  (Group agreed.)
   - Doug also proposed that removeColorSpace should not accept roles as
arguments (like other similar calls).  Removing the ColorSpace for a role would
result in an invalid config.
   - Thomas:  Want to continue to be able to change the role.
   - Patrick, Bernard:  There is a setRole call that is what should be used for
that.
   - Sean:  I think it make sense.
   - Patrick:  There is also the similar case where you remove a color space
that is used by a role.  Should we throw in that case?
   - Sean:  May get finicky.  May be better to handle it via sanityCheck.
   - Thomas:  Don't want to break some existing scripts.  Perhaps a warning
rather than throw.

**IMPROVING THE USER EXPERIENCE**

   - Doug reviewed some well-known weaknesses of the existing UX, for example
very long lists of color space names in menus that may overwhelm artists.
   - Doug: We have both large and small customers.  Large facilities have color
scientists and lock everything down.  But small customers need to have some
default configs that offer several options.  E.g., a few different scene-linear
working space options.
   - Thomas: +1 for thinking about the small shops and freelancers :)
   - Doug:  There have been a lot of community complaints around UX difference
between apps.  Sometimes there are good reasons for differences but in other
cases the differences are just arbitrary choices made by different developers. 
So we want to find a way to reduce those pointless differences while preserving
the ability to customize where that is justifiable.
   - Doug proposed that we will add some new optional UX-related classes to
build on our other work around color space categories and inactive color spaces
to build menus and accomplish basic tasks.  The category attribute in the
ColorSpace will allow this to be controlled via the config.
   - Dennis:  I'm all for this, the ACES config demonstrates the benefit from
this.  As long as it's optional it should work well.  OpenFX has something
similar.
Chat from Dennis:  OpenFX has a "grouping" property that allows a host to group
plug-ins (e.g., we have "Blur", "Color", "Creative", "Light", etc. groups).
kOfxImageEffectPluginPropGrouping
<https://openfx.readthedocs.io/en/doc/Guide/ofxExample1_Basics.html>
<http://openfx.sourceforge.net/Documentation/1.1/Reference/re94.html>
   - Doug:  We'd also like to facilitate hierarchical menus.  We think the
family attribute of ColorSpace could be used for this.  The ACES config already
uses a slash to separate what might be thought of as different levels of a
hierarchy (e.g. Input/ARRI).  We also are thinking of adding some helper classes
that would simplify tasks like adding a LUT to a config or making a perceptually
uniform linear slider.
   - Thomas:  Great overall, these kinds of things are much needed.  Perhaps
make the separator for hierarchies something the user could define.

**FILE RULES FEATURE**

   - Doug proposed a new feature to enhance the way file names/paths can be
mapped to a ColorSpace.  There would be the ability to define a set of rules
based on glob-style pattern matching.  Would allow, e.g. all files with
"texture" in the path to be mapped to a given ColorSpace.  Also would allow a
ColorSpace to be associated with files of a given extension (e.g. EXR, DPX).
   - Sean:  I think it would be useful.  Could be confusing for implementors if
the old method and new method need to be implemented separately.  Would also be
helpful if the rules are hierarchicial, similar to the lut search path.
   - Dennis:  Or have them in priority order.
   - Validation: Is the strictparsing option actually useful?  As an application
developer, we always need a default ColorSpace to be returned.  If the config
doesn't supply one, we will need to supply our own.  Why would anyone need
strictparsing = true?
   - Thomas:  I don't know, should validate on the forum.
   - Sean:  Could be somewhat Imageworks specific.  But if you had an automated
ingestion system, you could catch a non-match and force the user to do
something.  
   - Validation:  Should the file rules be part of the config or a separate
side-car file?  (Group seemed to think including as part of the config is
better.)
   - Doug showed a config file example showing how the original OCIO file rule
could be integrated with the new rules.
   - Thomas:  What about using RegEx rather than Glob?  For example you might
want to handle either tif and tiff or jpg and jpeg with a single rule.  Doug:
Interesting suggestion, we'll look into it.  Bernard:  Glob would not handle it
in one rule, but could make two rules.  Glob may be easier for users than RegEx.
   - Sean:  Default rule could be confusing if it can be placed anywhere.  (Use
"constant"?)  Doug: We would require that to be the last item in the list.
   - Sean:  Would be nice if the system would be extensible.  E.g., for future
usage of header info or if people have other mechanisms and want to tie into
metadata.

**UPCOMING NAMESPACE PR**

   - Doug, Patrick reviewed the recent thread/proposal on the ASWF mailing list
about improving how namespaces are declared.  Basically the problem is that the
current method hides the "namespace" keyword and this confuses a variety of
tools (clang format, text editors, etc.).
   - Given this involves a big PR that touches basically every source file we
wanted to also handle a couple of other issues.
   - PR #810 proposed how to move unit tests into separate files.  Given that we
have been adding so many new tests, some of the modules are over 5k lines, so
we'd like to split out the tests.
   - There are also a number of examples where the code is not following the
stated coding guidelines and we wanted to clean up a few instances of this.
   - Keep an eye out for a PR next week.  Note that we will want to merge this
quickly to avoid running into merge issues with other PRs, so please review
promptly if you are interested in this.
