"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.autocmd = autocmd;
const properties_1 = require("./properties");
// Example
// @autocmd('BufEnter', { pattern: '*.js', eval: 'expand("<afile>")', sync: true })
function autocmd(name, options) {
    return function (cls, methodName) {
        // const {
        // sync,
        // ...opts,
        // } = options;
        const sync = options && !!options.sync;
        const isMethod = typeof methodName === 'string';
        const f = isMethod ? cls[methodName] : cls;
        const opts = {
            pattern: '',
        };
        // @ts-expect-error changing `option: keyof …` to `option: string` causes other errors.
        ['pattern', 'eval'].forEach((option) => {
            if (options && typeof options[option] !== 'undefined') {
                opts[option] = options[option];
            }
        });
        const nameWithPattern = `${name}${(options === null || options === void 0 ? void 0 : options.pattern) ? `:${options.pattern}` : ''}`;
        Object.defineProperty(f, properties_1.NVIM_METHOD_NAME, {
            value: `autocmd:${nameWithPattern}`,
        });
        Object.defineProperty(f, properties_1.NVIM_SYNC, { value: !!sync });
        Object.defineProperty(f, properties_1.NVIM_SPEC, {
            value: {
                type: 'autocmd',
                name,
                sync: !!sync,
                opts,
            },
        });
        if (isMethod) {
            // eslint-disable-next-line no-param-reassign
            cls[methodName] = f;
        }
        return cls;
    };
}
