"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.command = void 0;
const properties_1 = require("./properties");
// Example
// @command('BufEnter', { range: '', nargs: '*' })
// @command('MyCommand', { complete: 'customlist,MyCustomCompleteListFunc' })
// @command('MyCommand', { complete: 'dir' })
function command(name, options) {
    return function (cls, methodName) {
        const sync = options && !!options.sync;
        const isMethod = typeof methodName === 'string';
        const f = isMethod ? cls[methodName] : cls;
        const opts = {};
        ['range', 'nargs', 'complete'].forEach((option) => {
            if (options && typeof options[option] !== 'undefined') {
                opts[option] = options[option];
            }
        });
        Object.defineProperty(f, properties_1.NVIM_METHOD_NAME, { value: `command:${name}` });
        Object.defineProperty(f, properties_1.NVIM_SYNC, { value: !!sync });
        Object.defineProperty(f, properties_1.NVIM_SPEC, {
            value: {
                type: 'command',
                name,
                sync: !!sync,
                opts,
            },
        });
        if (isMethod) {
            // eslint-disable-next-line no-param-reassign
            cls[methodName] = f;
        }
        return cls;
    };
}
exports.command = command;
