#include "clar.h"
#include "clar_test.h"
#include <stdio.h>
#include <string.h>

static char *fixture_tex;
static char *fixture_mml;
static char *result;

void test_mathjax__initialize(void)
{
  global_test_counter++;
}

void test_mathjax__cleanup(void)
{
  if (fixture_tex != NULL) {
    free(fixture_tex);
  }

  if (fixture_mml != NULL) {
    free(fixture_mml);
  }

  if (result != NULL) {
    free(result);
  }
}

/* EVERYTHING BELOW IS AUTOGENERATED */

void test_mathjax__abovebelowaccents1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/above-below/accents-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/above-below/accents-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__abovebelowaccents2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/above-below/accents-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/above-below/accents-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__abovebelowaccents3(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/above-below/accents-3.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/above-below/accents-3.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__abovebelowbuildrel1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/above-below/buildrel-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/above-below/buildrel-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__abovebelowissue877(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/above-below/issue877.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/above-below/issue877.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__abovebelowissue937(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/above-below/issue937.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/above-below/issue937.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__abovebelowoverbrace1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/above-below/overbrace-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/above-below/overbrace-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__abovebelowoverbracket1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/above-below/overbracket-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/above-below/overbracket-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__abovebelowoverset1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/above-below/overset-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/above-below/overset-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__abovebelowsideset1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/above-below/sideset-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/above-below/sideset-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__abovebelowstackrel1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/above-below/stackrel-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/above-below/stackrel-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__abovebelowsubarray1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/above-below/subarray-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/above-below/subarray-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__abovebelowsubstack1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/above-below/substack-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/above-below/substack-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__abovebelowunderbrace1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/above-below/underbrace-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/above-below/underbrace-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__abovebelowunderbracket1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/above-below/underbracket-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/above-below/underbracket-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__abovebelowunderset1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/above-below/underset-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/above-below/underset-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__arrowsarrows1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/arrows/arrows-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/arrows/arrows-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__arrowsarrows2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/arrows/arrows-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/arrows/arrows-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__arrowsarrows3(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/arrows/arrows-3.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/arrows/arrows-3.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__arrowsarrows4(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/arrows/arrows-4.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/arrows/arrows-4.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__arrowsarrows5(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/arrows/arrows-5.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/arrows/arrows-5.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__atomsmathinner1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/atoms/mathinner-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/atoms/mathinner-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__atomsmathop1a(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/atoms/mathop-1a.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/atoms/mathop-1a.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__atomsmathop1b(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/atoms/mathop-1b.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/atoms/mathop-1b.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__atomsmathopenclose1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/atoms/mathopenclose-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/atoms/mathopenclose-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__atomsmathord1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/atoms/mathord-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/atoms/mathord-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__atomsmathpunct1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/atoms/mathpunct-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/atoms/mathpunct-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__atomsmathrel1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/atoms/mathrel-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/atoms/mathrel-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__basicoperatorsbackslashed1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/basic-operators/backslashed-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/basic-operators/backslashed-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__basicoperatorsbasicoperators1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/basic-operators/basic-operators-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/basic-operators/basic-operators-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__basicoperatorsremap1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/basic-operators/remap-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/basic-operators/remap-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__colorscolor1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/colors/color-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/colors/color-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__colorscolorbox1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/colors/colorbox-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/colors/colorbox-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__colorsnamedcolors1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/colors/namedcolors-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/colors/namedcolors-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__delimitersbig1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/delimiters/big-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/delimiters/big-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__delimitersbig2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/delimiters/big-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/delimiters/big-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__delimitersbig3(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/delimiters/big-3.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/delimiters/big-3.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__delimitersdelimiters1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/delimiters/delimiters-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/delimiters/delimiters-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__delimitersdelimiters2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/delimiters/delimiters-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/delimiters/delimiters-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__delimitersissue775(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/delimiters/issue775.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/delimiters/issue775.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__delimitersissue7761a(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/delimiters/issue776-1a.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/delimiters/issue776-1a.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__delimitersissue7761b(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/delimiters/issue776-1b.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/delimiters/issue776-1b.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__delimitersissue7762(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/delimiters/issue776-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/delimiters/issue776-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__delimitersissue7763(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/delimiters/issue776-3.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/delimiters/issue776-3.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__delimitersissue7764(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/delimiters/issue776-4.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/delimiters/issue776-4.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__delimitersissue7765(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/delimiters/issue776-5.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/delimiters/issue776-5.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__delimitersleftright1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/delimiters/left-right-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/delimiters/left-right-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsalign1a(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/align-1a.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/align-1a.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsalign1b(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/align-1b.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/align-1b.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsalignat1a(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/alignat-1a.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/alignat-1a.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsalignat1b(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/alignat-1b.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/alignat-1b.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsaligned1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/aligned-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/aligned-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsaligned2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/aligned-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/aligned-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsalignedat1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/alignedat-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/alignedat-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentseqalign1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/eqalign-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/eqalign-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentseqalignno1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/eqalignno-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/eqalignno-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentseqnarray1a(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/eqnarray-1a.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/eqnarray-1a.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentseqnarray1b(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/eqnarray-1b.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/eqnarray-1b.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsequation1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/equation-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/equation-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsequation2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/equation-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/equation-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsgather1a(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/gather-1a.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/gather-1a.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsgather1b(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/gather-1b.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/gather-1b.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsgathered1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/gathered-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/gathered-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsgathered2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/gathered-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/gathered-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsissue9821a(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/issue982-1a.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/issue982-1a.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsissue9821b(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/issue982-1b.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/issue982-1b.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsissue9822a(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/issue982-2a.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/issue982-2a.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsissue9822b(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/issue982-2b.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/issue982-2b.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsissue9823a(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/issue982-3a.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/issue982-3a.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsissue9823b(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/issue982-3b.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/issue982-3b.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsmultline1a(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/multline-1a.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/multline-1a.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentsmultline1b(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/multline-1b.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/multline-1b.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__environmentssplit1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/environments/split-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/environments/split-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fracabove1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/above-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/above-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fracabovewithdelims1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/abovewithdelims-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/abovewithdelims-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fracatop1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/atop-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/atop-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fracatopwithdelims1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/atopwithdelims-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/atopwithdelims-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fracbinom1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/binom-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/binom-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fracbrace1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/brace-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/brace-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fracbrack1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/brack-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/brack-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fraccfrac1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/cfrac-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/cfrac-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fracchoose1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/choose-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/choose-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fracdbinom1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/dbinom-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/dbinom-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fracdfrac1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/dfrac-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/dfrac-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fracfrac1a(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/frac-1a.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/frac-1a.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fracfrac1b(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/frac-1b.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/frac-1b.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fracgenfrac1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/genfrac-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/genfrac-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fracissue969(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/issue969.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/issue969.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fracoverwithdelims1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/overwithdelims-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/overwithdelims-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fractbinom1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/tbinom-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/tbinom-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__fractfrac1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/frac/tfrac-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/frac/tfrac-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__issuesissue11522(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/issues/issue1152-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/issues/issue1152-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__issuesissue375(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/issues/issue375.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/issues/issue375.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__issuesissue856(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/issues/issue856.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/issues/issue856.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__issuesissue9011a(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/issues/issue901-1a.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/issues/issue901-1a.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__issuesissue9011b(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/issues/issue901-1b.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/issues/issue901-1b.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__issuesissue9011c(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/issues/issue901-1c.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/issues/issue901-1c.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__issuesissue9011d(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/issues/issue901-1d.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/issues/issue901-1d.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutboxes1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/boxes-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/boxes-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutkern1a(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/kern-1a.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/kern-1a.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutkern1b(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/kern-1b.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/kern-1b.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutllap1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/llap-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/llap-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutlower1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/lower-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/lower-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutmathstrut1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/mathstrut-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/mathstrut-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutmoveleft1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/moveleft-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/moveleft-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutmoveright1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/moveright-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/moveright-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutnewline1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/newline-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/newline-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutphantom1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/phantom-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/phantom-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutraise1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/raise-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/raise-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutrlap1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/rlap-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/rlap-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutskip1a(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/skip-1a.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/skip-1a.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutskip1b(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/skip-1b.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/skip-1b.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutsmash1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/smash-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/smash-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutspaces1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/spaces-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/spaces-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutstrut1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/strut-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/strut-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__layoutvcenter1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/layout/vcenter-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/layout/vcenter-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__lettersgreek1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/letters/greek-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/letters/greek-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__lettersgreek2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/letters/greek-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/letters/greek-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__lettersgreek3(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/letters/greek-3.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/letters/greek-3.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__lettersgreek4(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/letters/greek-4.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/letters/greek-4.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__lettershebrew1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/letters/hebrew-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/letters/hebrew-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantBbb1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/Bbb-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/Bbb-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantbf1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/bf-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/bf-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantboldsymbol1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/boldsymbol-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/boldsymbol-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantcal1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/cal-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/cal-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantfrak1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/frak-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/frak-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantit1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/it-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/it-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantmathbb1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/mathbb-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/mathbb-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantmathbf1a(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/mathbf-1a.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/mathbf-1a.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantmathbf1b(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/mathbf-1b.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/mathbf-1b.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantmathbf2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/mathbf-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/mathbf-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantmathcal1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/mathcal-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/mathcal-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantmathfrak1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/mathfrak-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/mathfrak-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantmathit1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/mathit-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/mathit-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantmathrm1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/mathrm-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/mathrm-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantmathscr1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/mathscr-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/mathscr-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantmathsf1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/mathsf-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/mathsf-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantmathtt1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/mathtt-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/mathtt-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantmit1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/mit-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/mit-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantpmb1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/pmb-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/pmb-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantrm1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/rm-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/rm-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantscr1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/scr-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/scr-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvariantsf1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/sf-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/sf-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvarianttext1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/text-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/text-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvarianttextbf1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/textbf-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/textbf-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvarianttextit1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/textit-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/textit-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvarianttextrm1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/textrm-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/textrm-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvarianttextsf1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/textsf-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/textsf-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvarianttexttt1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/texttt-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/texttt-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__mathvarianttt1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/mathvariant/tt-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/mathvariant/tt-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__matricesarray1a(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/matrices/array-1a.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/matrices/array-1a.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__matricesarray1b(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/matrices/array-1b.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/matrices/array-1b.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__matricesarray2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/matrices/array-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/matrices/array-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__matricesarray3(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/matrices/array-3.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/matrices/array-3.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__matricesbmatrix1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/matrices/bmatrix-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/matrices/bmatrix-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__matricesbmatrix2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/matrices/bmatrix-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/matrices/bmatrix-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__matricesmatrix1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/matrices/matrix-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/matrices/matrix-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__matricesmatrix2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/matrices/matrix-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/matrices/matrix-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__matricespmatrix1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/matrices/pmatrix-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/matrices/pmatrix-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__matricespmatrix2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/matrices/pmatrix-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/matrices/pmatrix-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__matricessmallmatrix1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/matrices/smallmatrix-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/matrices/smallmatrix-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__matricesvmatrix1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/matrices/vmatrix-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/matrices/vmatrix-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__matricesvmatrix2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/matrices/vmatrix-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/matrices/vmatrix-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__nonstandardTiny1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/non-standard/Tiny-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/non-standard/Tiny-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__otherbbox1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/bbox-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/bbox-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__otherboxed1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/boxed-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/boxed-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__othercancel1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/cancel-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/cancel-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__othercases1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/cases-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/cases-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__otherenclose1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/enclose-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/enclose-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__otherfunctions1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/functions-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/functions-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__otherLaTeX1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/LaTeX-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/LaTeX-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__otherlimits1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/limits-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/limits-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__otherlimits2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/limits-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/limits-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__otherlimits3(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/limits-3.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/limits-3.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__othermathsize1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/mathsize-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/mathsize-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__othermod1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/mod-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/mod-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__othernot1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/not-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/not-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__otherpod1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/pod-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/pod-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__otherprimes1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/primes-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/primes-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__otherprimes2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/primes-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/primes-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__otherprimes3(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/primes-3.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/primes-3.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__otherstyle1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/style-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/style-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__otherverb1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/verb-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/verb-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__otherverb2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/other/verb-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/other/verb-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__referencesnotag1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/references/notag-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/references/notag-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__rootsroot1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/roots/root-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/roots/root-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__rootsroot2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/roots/root-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/roots/root-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__rootsroot3(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/roots/root-3.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/roots/root-3.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__rootssqrt1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/roots/sqrt-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/roots/sqrt-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__rootssqrt2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/roots/sqrt-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/roots/sqrt-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__symbolsbinaryops1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/symbols/binaryops-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/symbols/binaryops-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__symbolsdots1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/symbols/dots-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/symbols/dots-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__symbolslargeops1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/symbols/largeops-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/symbols/largeops-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__symbolslargeops2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/symbols/largeops-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/symbols/largeops-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__symbolsrelations1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/symbols/relations-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/symbols/relations-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__symbolssymbols1(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/symbols/symbols-1.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/symbols/symbols-1.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__symbolssymbols2(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/symbols/symbols-2.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/symbols/symbols-2.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__symbolssymbols3(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/symbols/symbols-3.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/symbols/symbols-3.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__symbolssymbols4(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/symbols/symbols-4.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/symbols/symbols-4.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__symbolssymbols5(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/symbols/symbols-5.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/symbols/symbols-5.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}

void test_mathjax__symbolssymbols6(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/symbols/symbols-6.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/symbols/symbols-6.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}
