.TH MBCONVERT 1 "September 2006" local
.SH NAME
mbconvert \- convert between file formats supported by MOAB
.SH SYNOPSIS
.B mbconvert [-h|-l]

.B mbconvert
.B [-f
.I format
.B ] [-a
.I sat_file
.B |-A] [-t] [-g] [-o
.I option
.B ] [-O
.I option
.B ] [-I
.I dim
.B ] [-p|-P] [-v
.I vol_id_list
.B ] [-s
.I surf_id_list
.B ] [-c
.I curve_id_list
.B ] [-V
.I vert_id_list
.B ] [-m
.I block_id_list
.B ] [-d
.I nodeset_id_list
.B ] [-n
.I sideset_id_list
.B ] [-1] [-2] [-3]
.I input_file
.B [
.I input_file2
.B ...]
.I output_file
.SH DESCRIPTION
.B mbconvert
uses the MOAB library to translate between mesh file formats or
to extract subsets of mesh files.  The type of the output file
is determined from the file extension if the 
.B -f
flag is not specified.  The 
.B -l
option can be used to list the file formats supported.

The
.I id_list
passed to many of the subset options can contain either individual IDs 
or ranges of IDs, separated by  a comma (',').  Ranges of IDs are 
specified with a pair of values separated by a dash ('-').  An ID list
may not contain spaces.  

Any combination of subset options, including repetition of a singe option 
with different ID lists may be specified.  The output will contain the
union of all of the subset options.  If no subset options are specified
the entire input mesh is written to the output file.

String options for use with the 
.B -o 
and 
.B -O
flags are documented in the 
.I README.IO
file.

.SH OPTIONS
.IP -h
Print help to stdout and exit.
.IP -l
List supported file formats to stdout.
.IP "-a sat_file"
File to store extracted geometry from .cub file.
.IP -A
Do not store extracted geometry from .cub file (depricated, default).
.IP "-O option"
Specify writer option.  Specify flag multiple times to specify multiple options.
.IP "-o option"
Specify reader option.  Specify flag multiple times to specify multiple options.
.IP -t
Print timing data for read and write operations to stdout.
.IP -g
Print verbose debugging and status information to stdout.
.IP "-I dim"
Generate internal/adjacent entities of specified dimension.
.IP -P
Parallel only: append '.' and proccessor rank in world comm to output file name.
.IP -p
Parallel only: replace every occurance of '%' symbol in both input and
output file names with processor rank in world communicator.
.IP "-v idlist"
List of IDs of geometric volumes for which the corresponding mesh is to be written.
.IP "-s idlist"
List of IDs of geometric surfaces for which the corresponding mesh is to be written.
.IP "-c idlist"
List of IDs of geometric curves for which the corresponding mesh is to be written.
.IP "-V idlist"
List of IDs of geometric vertices for which the corresponding mesh is to be written.
.IP "-m idlist"
List of IDs for material sets (blocks) to write.
.IP "-d idlist"
List of IDs for Dirchlet sets (nodesets) to write.
.IP "-n idlist"
List of IDs for Neumann sets (sidesets) to write.
.IP "-1"
Write all one-dimensional mesh entities (edges.)
.IP "-2"
Write all two-dimensional mesh entities (triangles,quads,polygons)
.IP "-3"
Write all three-dimensional mesh entities (tets,hexes,etc.)
.SH FILES
.SH ENVIRONMENT
.SH DIAGNOSTICS
.SH SEE ALSO
README.IO
