/*
 * Copyright © 2012 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/**
 * \file indirect_api.cpp
 * Validate the generated code in indirect_init.c
 *
 * Tests various aspects of the dispatch table generated by
 * \c __glXNewIndirectAPI.
 *
 *    * No entry in the table should be \c NULL.
 *
 *    * Entries in the table that correspond to "known" functions with GLX
 *      protocol should point to the correct function.
 *
 *    * Entries beyond the end of the "known" part of the table (i.e., entries
 *      that can be allocated by drivers for extensions) should point to a
 *      no-op function.
 *
 *    * Entries in the table that correspond to "known" functions that lack
 *      GLX protocol should point to a no-op function.
 *
 * Very few entries in the last catogory are tests.  See \c OpenGL_20_is_nop.
 */

#include <gtest/gtest.h>
#include "util/glheader.h"
#include "../indirect_init.h"
#include "glapi/glapi.h"
#include "../../mesa/main/dispatch.h"

#ifndef GLX_USE_APPLEGL
static const void *nil = 0;
#endif

#define EXTRA_DISPATCH 111

static bool dispatch_table_size_was_queried = false;

extern "C" GLuint
_glapi_get_dispatch_table_size(void)
{
   dispatch_table_size_was_queried = true;
   return _gloffset_COUNT + EXTRA_DISPATCH;
}

/**
 * \name Indirect-rendering function stubs
 *
 * These are necessary so that indirect_init.c doesn't try to link with
 * indirect.c.  Linking with indirect.c would require linking with various X
 * libraries and a bunch of other stuff.  While this is ugly, it does simplify
 * the build quite a bit.
 */
/*@{*/
extern "C" {
void __indirect_glAccum(GLenum op, GLfloat value) { }
void __indirect_glAlphaFunc(GLenum func, GLclampf ref) { }
void __indirect_glBegin(GLenum mode) { }
void __indirect_glBitmap(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap) { }
void __indirect_glBlendFunc(GLenum sfactor, GLenum dfactor) { }
void __indirect_glCallList(GLuint list) { }
void __indirect_glCallLists(GLsizei n, GLenum type, const GLvoid *lists) { }
void __indirect_glClear(GLbitfield mask) { }
void __indirect_glClearAccum(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) { }
void __indirect_glClearColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) { }
void __indirect_glClearDepth(GLclampd depth) { }
void __indirect_glClearIndex(GLfloat c) { }
void __indirect_glClearStencil(GLint s) { }
void __indirect_glClipPlane(GLenum plane, const GLdouble *equation) { }
void __indirect_glColor3b(GLbyte red, GLbyte green, GLbyte blue) { }
void __indirect_glColor3bv(const GLbyte *v) { }
void __indirect_glColor3d(GLdouble red, GLdouble green, GLdouble blue) { }
void __indirect_glColor3dv(const GLdouble *v) { }
void __indirect_glColor3f(GLfloat red, GLfloat green, GLfloat blue) { }
void __indirect_glColor3fv(const GLfloat *v) { }
void __indirect_glColor3i(GLint red, GLint green, GLint blue) { }
void __indirect_glColor3iv(const GLint *v) { }
void __indirect_glColor3s(GLshort red, GLshort green, GLshort blue) { }
void __indirect_glColor3sv(const GLshort *v) { }
void __indirect_glColor3ub(GLubyte red, GLubyte green, GLubyte blue) { }
void __indirect_glColor3ubv(const GLubyte *v) { }
void __indirect_glColor3ui(GLuint red, GLuint green, GLuint blue) { }
void __indirect_glColor3uiv(const GLuint *v) { }
void __indirect_glColor3us(GLushort red, GLushort green, GLushort blue) { }
void __indirect_glColor3usv(const GLushort *v) { }
void __indirect_glColor4b(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha) { }
void __indirect_glColor4bv(const GLbyte *v) { }
void __indirect_glColor4d(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha) { }
void __indirect_glColor4dv(const GLdouble *v) { }
void __indirect_glColor4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) { }
void __indirect_glColor4fv(const GLfloat *v) { }
void __indirect_glColor4i(GLint red, GLint green, GLint blue, GLint alpha) { }
void __indirect_glColor4iv(const GLint *v) { }
void __indirect_glColor4s(GLshort red, GLshort green, GLshort blue, GLshort alpha) { }
void __indirect_glColor4sv(const GLshort *v) { }
void __indirect_glColor4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha) { }
void __indirect_glColor4ubv(const GLubyte *v) { }
void __indirect_glColor4ui(GLuint red, GLuint green, GLuint blue, GLuint alpha) { }
void __indirect_glColor4uiv(const GLuint *v) { }
void __indirect_glColor4us(GLushort red, GLushort green, GLushort blue, GLushort alpha) { }
void __indirect_glColor4usv(const GLushort *v) { }
void __indirect_glColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha) { }
void __indirect_glColorMaterial(GLenum face, GLenum mode) { }
void __indirect_glCopyPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type) { }
void __indirect_glCullFace(GLenum mode) { }
void __indirect_glDeleteLists(GLuint list, GLsizei range) { }
void __indirect_glDepthFunc(GLenum func) { }
void __indirect_glDepthMask(GLboolean flag) { }
void __indirect_glDepthRange(GLclampd near_val, GLclampd far_val) { }
void __indirect_glDisable(GLenum cap) { }
void __indirect_glDrawBuffer(GLenum mode) { }
void __indirect_glDrawPixels(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels) { }
void __indirect_glEdgeFlag(GLboolean flag) { }
void __indirect_glEdgeFlagv(const GLboolean *flag) { }
void __indirect_glEnable(GLenum cap) { }
void __indirect_glEnd(void) { }
void __indirect_glEndList(void) { }
void __indirect_glEvalCoord1d(GLdouble u) { }
void __indirect_glEvalCoord1dv(const GLdouble *u) { }
void __indirect_glEvalCoord1f(GLfloat u) { }
void __indirect_glEvalCoord1fv(const GLfloat *u) { }
void __indirect_glEvalCoord2d(GLdouble u, GLdouble v) { }
void __indirect_glEvalCoord2dv(const GLdouble *u) { }
void __indirect_glEvalCoord2f(GLfloat u, GLfloat v) { }
void __indirect_glEvalCoord2fv(const GLfloat *u) { }
void __indirect_glEvalMesh1(GLenum mode, GLint i1, GLint i2) { }
void __indirect_glEvalMesh2(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2) { }
void __indirect_glEvalPoint1(GLint i) { }
void __indirect_glEvalPoint2(GLint i, GLint j) { }
void __indirect_glFeedbackBuffer(GLsizei size, GLenum type, GLfloat *buffer) { }
void __indirect_glFinish(void) { }
void __indirect_glFlush(void) { }
void __indirect_glFogf(GLenum pname, GLfloat param) { }
void __indirect_glFogfv(GLenum pname, const GLfloat *params) { }
void __indirect_glFogi(GLenum pname, GLint param) { }
void __indirect_glFogiv(GLenum pname, const GLint *params) { }
void __indirect_glFrontFace(GLenum mode) { }
void __indirect_glFrustum(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble near_val, GLdouble far_val) { }
void __indirect_glGenLists(GLsizei range) { }
void __indirect_glGetBooleanv(GLenum pname, GLboolean *params) { }
void __indirect_glGetClipPlane(GLenum plane, GLdouble *equation) { }
void __indirect_glGetDoublev(GLenum pname, GLdouble *params) { }
void __indirect_glGetError(void) { }
void __indirect_glGetFloatv(GLenum pname, GLfloat *params) { }
void __indirect_glGetIntegerv(GLenum pname, GLint *params) { }
void __indirect_glGetLightfv(GLenum light, GLenum pname, GLfloat *params) { }
void __indirect_glGetLightiv(GLenum light, GLenum pname, GLint *params) { }
void __indirect_glGetMapdv(GLenum target, GLenum query, GLdouble *v) { }
void __indirect_glGetMapfv(GLenum target, GLenum query, GLfloat *v) { }
void __indirect_glGetMapiv(GLenum target, GLenum query, GLint *v) { }
void __indirect_glGetMaterialfv(GLenum face, GLenum pname, GLfloat *params) { }
void __indirect_glGetMaterialiv(GLenum face, GLenum pname, GLint *params) { }
void __indirect_glGetPixelMapfv(GLenum map, GLfloat *values) { }
void __indirect_glGetPixelMapuiv(GLenum map, GLuint *values) { }
void __indirect_glGetPixelMapusv(GLenum map, GLushort *values) { }
void __indirect_glGetPolygonStipple(GLubyte *mask) { }
void __indirect_glGetString(GLenum name) { }
void __indirect_glGetTexEnvfv(GLenum target, GLenum pname, GLfloat *params) { }
void __indirect_glGetTexEnviv(GLenum target, GLenum pname, GLint *params) { }
void __indirect_glGetTexGendv(GLenum coord, GLenum pname, GLdouble *params) { }
void __indirect_glGetTexGenfv(GLenum coord, GLenum pname, GLfloat *params) { }
void __indirect_glGetTexGeniv(GLenum coord, GLenum pname, GLint *params) { }
void __indirect_glGetTexImage(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels) { }
void __indirect_glGetTexLevelParameterfv(GLenum target, GLint level, GLenum pname, GLfloat *params) { }
void __indirect_glGetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint *params) { }
void __indirect_glGetTexParameterfv(GLenum target, GLenum pname, GLfloat *params) { }
void __indirect_glGetTexParameteriv(GLenum target, GLenum pname, GLint *params) { }
void __indirect_glHint(GLenum target, GLenum mode) { }
void __indirect_glIndexMask(GLuint mask) { }
void __indirect_glIndexd(GLdouble c) { }
void __indirect_glIndexdv(const GLdouble *c) { }
void __indirect_glIndexf(GLfloat c) { }
void __indirect_glIndexfv(const GLfloat *c) { }
void __indirect_glIndexi(GLint c) { }
void __indirect_glIndexiv(const GLint *c) { }
void __indirect_glIndexs(GLshort c) { }
void __indirect_glIndexsv(const GLshort *c) { }
void __indirect_glInitNames(void) { }
void __indirect_glIsEnabled(GLenum cap) { }
void __indirect_glIsList(GLuint list) { }
void __indirect_glLightModelf(GLenum pname, GLfloat param) { }
void __indirect_glLightModelfv(GLenum pname, const GLfloat *params) { }
void __indirect_glLightModeli(GLenum pname, GLint param) { }
void __indirect_glLightModeliv(GLenum pname, const GLint *params) { }
void __indirect_glLightf(GLenum light, GLenum pname, GLfloat param) { }
void __indirect_glLightfv(GLenum light, GLenum pname, const GLfloat *params) { }
void __indirect_glLighti(GLenum light, GLenum pname, GLint param) { }
void __indirect_glLightiv(GLenum light, GLenum pname, const GLint *params) { }
void __indirect_glLineStipple(GLint factor, GLushort pattern) { }
void __indirect_glLineWidth(GLfloat width) { }
void __indirect_glListBase(GLuint base) { }
void __indirect_glLoadIdentity(void) { }
void __indirect_glLoadMatrixd(const GLdouble *m) { }
void __indirect_glLoadMatrixf(const GLfloat *m) { }
void __indirect_glLoadName(GLuint name) { }
void __indirect_glLogicOp(GLenum opcode) { }
void __indirect_glMap1d(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points) { }
void __indirect_glMap1f(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points) { }
void __indirect_glMap2d(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points) { }
void __indirect_glMap2f(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points) { }
void __indirect_glMapGrid1d(GLint un, GLdouble u1, GLdouble u2) { }
void __indirect_glMapGrid1f(GLint un, GLfloat u1, GLfloat u2) { }
void __indirect_glMapGrid2d(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2) { }
void __indirect_glMapGrid2f(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2) { }
void __indirect_glMaterialf(GLenum face, GLenum pname, GLfloat param) { }
void __indirect_glMaterialfv(GLenum face, GLenum pname, const GLfloat *params) { }
void __indirect_glMateriali(GLenum face, GLenum pname, GLint param) { }
void __indirect_glMaterialiv(GLenum face, GLenum pname, const GLint *params) { }
void __indirect_glMatrixMode(GLenum mode) { }
void __indirect_glMultMatrixd(const GLdouble *m) { }
void __indirect_glMultMatrixf(const GLfloat *m) { }
void __indirect_glNewList(GLuint list, GLenum mode) { }
void __indirect_glNormal3b(GLbyte nx, GLbyte ny, GLbyte nz) { }
void __indirect_glNormal3bv(const GLbyte *v) { }
void __indirect_glNormal3d(GLdouble nx, GLdouble ny, GLdouble nz) { }
void __indirect_glNormal3dv(const GLdouble *v) { }
void __indirect_glNormal3f(GLfloat nx, GLfloat ny, GLfloat nz) { }
void __indirect_glNormal3fv(const GLfloat *v) { }
void __indirect_glNormal3i(GLint nx, GLint ny, GLint nz) { }
void __indirect_glNormal3iv(const GLint *v) { }
void __indirect_glNormal3s(GLshort nx, GLshort ny, GLshort nz) { }
void __indirect_glNormal3sv(const GLshort *v) { }
void __indirect_glOrtho(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble near_val, GLdouble far_val) { }
void __indirect_glPassThrough(GLfloat token) { }
void __indirect_glPixelMapfv(GLenum map, GLsizei mapsize, const GLfloat *values) { }
void __indirect_glPixelMapuiv(GLenum map, GLsizei mapsize, const GLuint *values) { }
void __indirect_glPixelMapusv(GLenum map, GLsizei mapsize, const GLushort *values) { }
void __indirect_glPixelStoref(GLenum pname, GLfloat param) { }
void __indirect_glPixelStorei(GLenum pname, GLint param) { }
void __indirect_glPixelTransferf(GLenum pname, GLfloat param) { }
void __indirect_glPixelTransferi(GLenum pname, GLint param) { }
void __indirect_glPixelZoom(GLfloat xfactor, GLfloat yfactor) { }
void __indirect_glPointSize(GLfloat size) { }
void __indirect_glPolygonMode(GLenum face, GLenum mode) { }
void __indirect_glPolygonStipple(const GLubyte *mask) { }
void __indirect_glPopAttrib(void) { }
void __indirect_glPopMatrix(void) { }
void __indirect_glPopName(void) { }
void __indirect_glPushAttrib(GLbitfield mask) { }
void __indirect_glPushMatrix(void) { }
void __indirect_glPushName(GLuint name) { }
void __indirect_glRasterPos2d(GLdouble x, GLdouble y) { }
void __indirect_glRasterPos2dv(const GLdouble *v) { }
void __indirect_glRasterPos2f(GLfloat x, GLfloat y) { }
void __indirect_glRasterPos2fv(const GLfloat *v) { }
void __indirect_glRasterPos2i(GLint x, GLint y) { }
void __indirect_glRasterPos2iv(const GLint *v) { }
void __indirect_glRasterPos2s(GLshort x, GLshort y) { }
void __indirect_glRasterPos2sv(const GLshort *v) { }
void __indirect_glRasterPos3d(GLdouble x, GLdouble y, GLdouble z) { }
void __indirect_glRasterPos3dv(const GLdouble *v) { }
void __indirect_glRasterPos3f(GLfloat x, GLfloat y, GLfloat z) { }
void __indirect_glRasterPos3fv(const GLfloat *v) { }
void __indirect_glRasterPos3i(GLint x, GLint y, GLint z) { }
void __indirect_glRasterPos3iv(const GLint *v) { }
void __indirect_glRasterPos3s(GLshort x, GLshort y, GLshort z) { }
void __indirect_glRasterPos3sv(const GLshort *v) { }
void __indirect_glRasterPos4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w) { }
void __indirect_glRasterPos4dv(const GLdouble *v) { }
void __indirect_glRasterPos4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w) { }
void __indirect_glRasterPos4fv(const GLfloat *v) { }
void __indirect_glRasterPos4i(GLint x, GLint y, GLint z, GLint w) { }
void __indirect_glRasterPos4iv(const GLint *v) { }
void __indirect_glRasterPos4s(GLshort x, GLshort y, GLshort z, GLshort w) { }
void __indirect_glRasterPos4sv(const GLshort *v) { }
void __indirect_glReadBuffer(GLenum mode) { }
void __indirect_glReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels) { }
void __indirect_glRectd(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2) { }
void __indirect_glRectdv(const GLdouble *v1, const GLdouble *v2) { }
void __indirect_glRectf(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2) { }
void __indirect_glRectfv(const GLfloat *v1, const GLfloat *v2) { }
void __indirect_glRecti(GLint x1, GLint y1, GLint x2, GLint y2) { }
void __indirect_glRectiv(const GLint *v1, const GLint *v2) { }
void __indirect_glRects(GLshort x1, GLshort y1, GLshort x2, GLshort y2) { }
void __indirect_glRectsv(const GLshort *v1, const GLshort *v2) { }
void __indirect_glRenderMode(GLenum mode) { }
void __indirect_glRotated(GLdouble angle, GLdouble x, GLdouble y, GLdouble z) { }
void __indirect_glRotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z) { }
void __indirect_glScaled(GLdouble x, GLdouble y, GLdouble z) { }
void __indirect_glScalef(GLfloat x, GLfloat y, GLfloat z) { }
void __indirect_glScissor(GLint x, GLint y, GLsizei width, GLsizei height) { }
void __indirect_glSelectBuffer(GLsizei size, GLuint *buffer) { }
void __indirect_glShadeModel(GLenum mode) { }
void __indirect_glStencilFunc(GLenum func, GLint ref, GLuint mask) { }
void __indirect_glStencilMask(GLuint mask) { }
void __indirect_glStencilOp(GLenum fail, GLenum zfail, GLenum zpass) { }
void __indirect_glTexCoord1d(GLdouble s) { }
void __indirect_glTexCoord1dv(const GLdouble *v) { }
void __indirect_glTexCoord1f(GLfloat s) { }
void __indirect_glTexCoord1fv(const GLfloat *v) { }
void __indirect_glTexCoord1i(GLint s) { }
void __indirect_glTexCoord1iv(const GLint *v) { }
void __indirect_glTexCoord1s(GLshort s) { }
void __indirect_glTexCoord1sv(const GLshort *v) { }
void __indirect_glTexCoord2d(GLdouble s, GLdouble t) { }
void __indirect_glTexCoord2dv(const GLdouble *v) { }
void __indirect_glTexCoord2f(GLfloat s, GLfloat t) { }
void __indirect_glTexCoord2fv(const GLfloat *v) { }
void __indirect_glTexCoord2i(GLint s, GLint t) { }
void __indirect_glTexCoord2iv(const GLint *v) { }
void __indirect_glTexCoord2s(GLshort s, GLshort t) { }
void __indirect_glTexCoord2sv(const GLshort *v) { }
void __indirect_glTexCoord3d(GLdouble s, GLdouble t, GLdouble r) { }
void __indirect_glTexCoord3dv(const GLdouble *v) { }
void __indirect_glTexCoord3f(GLfloat s, GLfloat t, GLfloat r) { }
void __indirect_glTexCoord3fv(const GLfloat *v) { }
void __indirect_glTexCoord3i(GLint s, GLint t, GLint r) { }
void __indirect_glTexCoord3iv(const GLint *v) { }
void __indirect_glTexCoord3s(GLshort s, GLshort t, GLshort r) { }
void __indirect_glTexCoord3sv(const GLshort *v) { }
void __indirect_glTexCoord4d(GLdouble s, GLdouble t, GLdouble r, GLdouble q) { }
void __indirect_glTexCoord4dv(const GLdouble *v) { }
void __indirect_glTexCoord4f(GLfloat s, GLfloat t, GLfloat r, GLfloat q) { }
void __indirect_glTexCoord4fv(const GLfloat *v) { }
void __indirect_glTexCoord4i(GLint s, GLint t, GLint r, GLint q) { }
void __indirect_glTexCoord4iv(const GLint *v) { }
void __indirect_glTexCoord4s(GLshort s, GLshort t, GLshort r, GLshort q) { }
void __indirect_glTexCoord4sv(const GLshort *v) { }
void __indirect_glTexEnvf(GLenum target, GLenum pname, GLfloat param) { }
void __indirect_glTexEnvfv(GLenum target, GLenum pname, const GLfloat *params) { }
void __indirect_glTexEnvi(GLenum target, GLenum pname, GLint param) { }
void __indirect_glTexEnviv(GLenum target, GLenum pname, const GLint *params) { }
void __indirect_glTexGend(GLenum coord, GLenum pname, GLdouble param) { }
void __indirect_glTexGendv(GLenum coord, GLenum pname, const GLdouble *params) { }
void __indirect_glTexGenf(GLenum coord, GLenum pname, GLfloat param) { }
void __indirect_glTexGenfv(GLenum coord, GLenum pname, const GLfloat *params) { }
void __indirect_glTexGeni(GLenum coord, GLenum pname, GLint param) { }
void __indirect_glTexGeniv(GLenum coord, GLenum pname, const GLint *params) { }
void __indirect_glTexImage1D(GLenum target, GLint level, GLint internalFormat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels) { }
void __indirect_glTexImage2D(GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels) { }
void __indirect_glTexParameterf(GLenum target, GLenum pname, GLfloat param) { }
void __indirect_glTexParameterfv(GLenum target, GLenum pname, const GLfloat *params) { }
void __indirect_glTexParameteri(GLenum target, GLenum pname, GLint param) { }
void __indirect_glTexParameteriv(GLenum target, GLenum pname, const GLint *params) { }
void __indirect_glTranslated(GLdouble x, GLdouble y, GLdouble z) { }
void __indirect_glTranslatef(GLfloat x, GLfloat y, GLfloat z) { }
void __indirect_glVertex2d(GLdouble x, GLdouble y) { }
void __indirect_glVertex2dv(const GLdouble *v) { }
void __indirect_glVertex2f(GLfloat x, GLfloat y) { }
void __indirect_glVertex2fv(const GLfloat *v) { }
void __indirect_glVertex2i(GLint x, GLint y) { }
void __indirect_glVertex2iv(const GLint *v) { }
void __indirect_glVertex2s(GLshort x, GLshort y) { }
void __indirect_glVertex2sv(const GLshort *v) { }
void __indirect_glVertex3d(GLdouble x, GLdouble y, GLdouble z) { }
void __indirect_glVertex3dv(const GLdouble *v) { }
void __indirect_glVertex3f(GLfloat x, GLfloat y, GLfloat z) { }
void __indirect_glVertex3fv(const GLfloat *v) { }
void __indirect_glVertex3i(GLint x, GLint y, GLint z) { }
void __indirect_glVertex3iv(const GLint *v) { }
void __indirect_glVertex3s(GLshort x, GLshort y, GLshort z) { }
void __indirect_glVertex3sv(const GLshort *v) { }
void __indirect_glVertex4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w) { }
void __indirect_glVertex4dv(const GLdouble *v) { }
void __indirect_glVertex4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w) { }
void __indirect_glVertex4fv(const GLfloat *v) { }
void __indirect_glVertex4i(GLint x, GLint y, GLint z, GLint w) { }
void __indirect_glVertex4iv(const GLint *v) { }
void __indirect_glVertex4s(GLshort x, GLshort y, GLshort z, GLshort w) { }
void __indirect_glVertex4sv(const GLshort *v) { }
void __indirect_glViewport(GLint x, GLint y, GLsizei width, GLsizei height) { }
void __indirect_glAreTexturesResident(GLsizei n, const GLuint *textures, GLboolean *residences) { }
void __indirect_glArrayElement(GLint i) { }
void __indirect_glBindTexture(GLenum target, GLuint texture) { }
void __indirect_glColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *ptr) { }
void __indirect_glCopyTexImage1D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border) { }
void __indirect_glCopyTexImage2D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border) { }
void __indirect_glCopyTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width) { }
void __indirect_glCopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) { }
void __indirect_glDeleteTextures(GLsizei n, const GLuint *textures) { }
void __indirect_glDisableClientState(GLenum cap) { }
void __indirect_glDrawArrays(GLenum mode, GLint first, GLsizei count) { }
void __indirect_glDrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices) { }
void __indirect_glEdgeFlagPointer(GLsizei stride, const GLvoid *ptr) { }
void __indirect_glEnableClientState(GLenum cap) { }
void __indirect_glGenTextures(GLsizei n, GLuint *textures) { }
void __indirect_glGetPointerv(GLenum pname, GLvoid **params) { }
void __indirect_glIndexPointer(GLenum type, GLsizei stride, const GLvoid *ptr) { }
void __indirect_glIndexub(GLubyte c) { }
void __indirect_glIndexubv(const GLubyte *c) { }
void __indirect_glInterleavedArrays(GLenum format, GLsizei stride, const GLvoid *pointer) { }
void __indirect_glIsTexture(GLuint texture) { }
void __indirect_glNormalPointer(GLenum type, GLsizei stride, const GLvoid *ptr) { }
void __indirect_glPolygonOffset(GLfloat factor, GLfloat units) { }
void __indirect_glPopClientAttrib(void) { }
void __indirect_glPrioritizeTextures(GLsizei n, const GLuint *textures, const GLclampf *priorities) { }
void __indirect_glPushClientAttrib(GLbitfield mask) { }
void __indirect_glTexCoordPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *ptr) { }
void __indirect_glTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels) { }
void __indirect_glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels) { }
void __indirect_glVertexPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *ptr) { }
void __indirect_glBlendColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) { }
void __indirect_glBlendEquation(GLenum mode) { }
void __indirect_glColorSubTable(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *data) { }
void __indirect_glColorTable(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *table) { }
void __indirect_glColorTableParameterfv(GLenum target, GLenum pname, const GLfloat *params) { }
void __indirect_glColorTableParameteriv(GLenum target, GLenum pname, const GLint *params) { }
void __indirect_glConvolutionFilter1D(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *image) { }
void __indirect_glConvolutionFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *image) { }
void __indirect_glConvolutionParameterf(GLenum target, GLenum pname, GLfloat params) { }
void __indirect_glConvolutionParameterfv(GLenum target, GLenum pname, const GLfloat *params) { }
void __indirect_glConvolutionParameteri(GLenum target, GLenum pname, GLint params) { }
void __indirect_glConvolutionParameteriv(GLenum target, GLenum pname, const GLint *params) { }
void __indirect_glCopyColorSubTable(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width) { }
void __indirect_glCopyColorTable(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width) { }
void __indirect_glCopyConvolutionFilter1D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width) { }
void __indirect_glCopyConvolutionFilter2D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height) { }
void __indirect_glCopyTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height) { }
void __indirect_glDrawRangeElements(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices) { }
void __indirect_glGetColorTable(GLenum target, GLenum format, GLenum type, GLvoid *table) { }
void __indirect_glGetColorTableParameterfv(GLenum target, GLenum pname, GLfloat *params) { }
void __indirect_glGetColorTableParameteriv(GLenum target, GLenum pname, GLint *params) { }
void __indirect_glGetConvolutionFilter(GLenum target, GLenum format, GLenum type, GLvoid *image) { }
void __indirect_glGetConvolutionParameterfv(GLenum target, GLenum pname, GLfloat *params) { }
void __indirect_glGetConvolutionParameteriv(GLenum target, GLenum pname, GLint *params) { }
void __indirect_glGetHistogram(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values) { }
void __indirect_glGetHistogramParameterfv(GLenum target, GLenum pname, GLfloat *params) { }
void __indirect_glGetHistogramParameteriv(GLenum target, GLenum pname, GLint *params) { }
void __indirect_glGetMinmax(GLenum target, GLboolean reset, GLenum format, GLenum types, GLvoid *values) { }
void __indirect_glGetMinmaxParameterfv(GLenum target, GLenum pname, GLfloat *params) { }
void __indirect_glGetMinmaxParameteriv(GLenum target, GLenum pname, GLint *params) { }
void __indirect_glGetSeparableFilter(GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span) { }
void __indirect_glHistogram(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink) { }
void __indirect_glMinmax(GLenum target, GLenum internalformat, GLboolean sink) { }
void __indirect_glResetHistogram(GLenum target) { }
void __indirect_glResetMinmax(GLenum target) { }
void __indirect_glSeparableFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *row, const GLvoid *column) { }
void __indirect_glTexImage3D(GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels) { }
void __indirect_glTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels) { }
void __indirect_glActiveTexture(GLenum texture) { }
void __indirect_glClientActiveTexture(GLenum texture) { }
void __indirect_glMultiTexCoord1d(GLenum target, GLdouble s) { }
void __indirect_glMultiTexCoord1dv(GLenum target, const GLdouble *v) { }
void __indirect_glMultiTexCoord1fARB(GLenum target, GLfloat s) { }
void __indirect_glMultiTexCoord1fvARB(GLenum target, const GLfloat *v) { }
void __indirect_glMultiTexCoord1i(GLenum target, GLint s) { }
void __indirect_glMultiTexCoord1iv(GLenum target, const GLint *v) { }
void __indirect_glMultiTexCoord1s(GLenum target, GLshort s) { }
void __indirect_glMultiTexCoord1sv(GLenum target, const GLshort *v) { }
void __indirect_glMultiTexCoord2d(GLenum target, GLdouble s, GLdouble t) { }
void __indirect_glMultiTexCoord2dv(GLenum target, const GLdouble *v) { }
void __indirect_glMultiTexCoord2fARB(GLenum target, GLfloat s, GLfloat t) { }
void __indirect_glMultiTexCoord2fvARB(GLenum target, const GLfloat *v) { }
void __indirect_glMultiTexCoord2i(GLenum target, GLint s, GLint t) { }
void __indirect_glMultiTexCoord2iv(GLenum target, const GLint *v) { }
void __indirect_glMultiTexCoord2s(GLenum target, GLshort s, GLshort t) { }
void __indirect_glMultiTexCoord2sv(GLenum target, const GLshort *v) { }
void __indirect_glMultiTexCoord3d(GLenum target, GLdouble s, GLdouble t, GLdouble r) { }
void __indirect_glMultiTexCoord3dv(GLenum target, const GLdouble *v) { }
void __indirect_glMultiTexCoord3fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r) { }
void __indirect_glMultiTexCoord3fvARB(GLenum target, const GLfloat *v) { }
void __indirect_glMultiTexCoord3i(GLenum target, GLint s, GLint t, GLint r) { }
void __indirect_glMultiTexCoord3iv(GLenum target, const GLint *v) { }
void __indirect_glMultiTexCoord3s(GLenum target, GLshort s, GLshort t, GLshort r) { }
void __indirect_glMultiTexCoord3sv(GLenum target, const GLshort *v) { }
void __indirect_glMultiTexCoord4d(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q) { }
void __indirect_glMultiTexCoord4dv(GLenum target, const GLdouble *v) { }
void __indirect_glMultiTexCoord4fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q) { }
void __indirect_glMultiTexCoord4fvARB(GLenum target, const GLfloat *v) { }
void __indirect_glMultiTexCoord4i(GLenum target, GLint s, GLint t, GLint r, GLint q) { }
void __indirect_glMultiTexCoord4iv(GLenum target, const GLint *v) { }
void __indirect_glMultiTexCoord4s(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q) { }
void __indirect_glMultiTexCoord4sv(GLenum target, const GLshort *v) { }
void __indirect_glLoadTransposeMatrixd(const GLdouble m[16]) { }
void __indirect_glLoadTransposeMatrixf(const GLfloat m[16]) { }
void __indirect_glMultTransposeMatrixd(const GLdouble m[16]) { }
void __indirect_glMultTransposeMatrixf(const GLfloat m[16]) { }
void __indirect_glSampleCoverage(GLclampf value, GLboolean invert) { }
void __indirect_glCompressedTexImage1D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data) { }
void __indirect_glCompressedTexImage2D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data) { }
void __indirect_glCompressedTexImage3D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data) { }
void __indirect_glCompressedTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data) { }
void __indirect_glCompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data) { }
void __indirect_glCompressedTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data) { }
void __indirect_glGetCompressedTexImage(GLenum target, GLint lod, GLvoid *img) { }
void __indirect_glDisableVertexAttribArray(GLuint index) { }
void __indirect_glEnableVertexAttribArray(GLuint index) { }
void __indirect_glGetProgramEnvParameterdvARB(GLenum target, GLuint index, GLdouble *params) { }
void __indirect_glGetProgramEnvParameterfvARB(GLenum target, GLuint index, GLfloat *params) { }
void __indirect_glGetProgramLocalParameterdvARB(GLenum target, GLuint index, GLdouble *params) { }
void __indirect_glGetProgramLocalParameterfvARB(GLenum target, GLuint index, GLfloat *params) { }
void __indirect_glGetProgramStringARB(GLenum target, GLenum pname, void *string) { }
void __indirect_glGetProgramivARB(GLenum target, GLenum pname, GLint *params) { }
void __indirect_glGetVertexAttribdv(GLuint index, GLenum pname, GLdouble *params) { }
void __indirect_glGetVertexAttribfv(GLuint index, GLenum pname, GLfloat *params) { }
void __indirect_glGetVertexAttribiv(GLuint index, GLenum pname, GLint *params) { }
void __indirect_glProgramEnvParameter4dARB(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) { }
void __indirect_glProgramEnvParameter4dvARB(GLenum target, GLuint index, const GLdouble *params) { }
void __indirect_glProgramEnvParameter4fARB(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) { }
void __indirect_glProgramEnvParameter4fvARB(GLenum target, GLuint index, const GLfloat *params) { }
void __indirect_glProgramLocalParameter4dARB(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) { }
void __indirect_glProgramLocalParameter4dvARB(GLenum target, GLuint index, const GLdouble *params) { }
void __indirect_glProgramLocalParameter4fARB(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) { }
void __indirect_glProgramLocalParameter4fvARB(GLenum target, GLuint index, const GLfloat *params) { }
void __indirect_glProgramStringARB(GLenum target, GLenum format, GLsizei len, const void *string) { }
void __indirect_glVertexAttrib1d(GLuint index, GLdouble x) { }
void __indirect_glVertexAttrib1dv(GLuint index, const GLdouble *v) { }
void __indirect_glVertexAttrib1fARB(GLuint index, GLfloat x) { }
void __indirect_glVertexAttrib1fvARB(GLuint index, const GLfloat *v) { }
void __indirect_glVertexAttrib1s(GLuint index, GLshort x) { }
void __indirect_glVertexAttrib1sv(GLuint index, const GLshort *v) { }
void __indirect_glVertexAttrib2d(GLuint index, GLdouble x, GLdouble y) { }
void __indirect_glVertexAttrib2dv(GLuint index, const GLdouble *v) { }
void __indirect_glVertexAttrib2fARB(GLuint index, GLfloat x, GLfloat y) { }
void __indirect_glVertexAttrib2fvARB(GLuint index, const GLfloat *v) { }
void __indirect_glVertexAttrib2s(GLuint index, GLshort x, GLshort y) { }
void __indirect_glVertexAttrib2sv(GLuint index, const GLshort *v) { }
void __indirect_glVertexAttrib3d(GLuint index, GLdouble x, GLdouble y, GLdouble z) { }
void __indirect_glVertexAttrib3dv(GLuint index, const GLdouble *v) { }
void __indirect_glVertexAttrib3fARB(GLuint index, GLfloat x, GLfloat y, GLfloat z) { }
void __indirect_glVertexAttrib3fvARB(GLuint index, const GLfloat *v) { }
void __indirect_glVertexAttrib3s(GLuint index, GLshort x, GLshort y, GLshort z) { }
void __indirect_glVertexAttrib3sv(GLuint index, const GLshort *v) { }
void __indirect_glVertexAttrib4Nbv(GLuint index, const GLbyte *v) { }
void __indirect_glVertexAttrib4Niv(GLuint index, const GLint *v) { }
void __indirect_glVertexAttrib4Nsv(GLuint index, const GLshort *v) { }
void __indirect_glVertexAttrib4Nub(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w) { }
void __indirect_glVertexAttrib4Nubv(GLuint index, const GLubyte *v) { }
void __indirect_glVertexAttrib4Nuiv(GLuint index, const GLuint *v) { }
void __indirect_glVertexAttrib4Nusv(GLuint index, const GLushort *v) { }
void __indirect_glVertexAttrib4bv(GLuint index, const GLbyte *v) { }
void __indirect_glVertexAttrib4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) { }
void __indirect_glVertexAttrib4dv(GLuint index, const GLdouble *v) { }
void __indirect_glVertexAttrib4fARB(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) { }
void __indirect_glVertexAttrib4fvARB(GLuint index, const GLfloat *v) { }
void __indirect_glVertexAttrib4iv(GLuint index, const GLint *v) { }
void __indirect_glVertexAttrib4s(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w) { }
void __indirect_glVertexAttrib4sv(GLuint index, const GLshort *v) { }
void __indirect_glVertexAttrib4ubv(GLuint index, const GLubyte *v) { }
void __indirect_glVertexAttrib4uiv(GLuint index, const GLuint *v) { }
void __indirect_glVertexAttrib4usv(GLuint index, const GLushort *v) { }
void __indirect_glVertexAttribPointer(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const void *pointer) { }
void __indirect_glBeginQuery(GLenum target, GLuint id) { }
void __indirect_glDeleteQueries(GLsizei n, const GLuint *ids) { }
void __indirect_glEndQuery(GLenum target) { }
void __indirect_glGenQueries(GLsizei n, GLuint *ids) { }
void __indirect_glGetQueryObjectiv(GLuint id, GLenum pname, GLint *params) { }
void __indirect_glGetQueryObjectuiv(GLuint id, GLenum pname, GLuint *params) { }
void __indirect_glGetQueryiv(GLenum target, GLenum pname, GLint *params) { }
void __indirect_glIsQuery(GLuint id) { }
void __indirect_glDrawBuffers(GLsizei n, const GLenum *bufs) { }
void __indirect_glClampColor(GLenum target, GLenum clamp) { }
void __indirect_glRenderbufferStorageMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) { }
void __indirect_glSampleMaskSGIS(GLclampf value, GLboolean invert) { }
void __indirect_glSamplePatternSGIS(GLenum pattern) { }
void __indirect_glColorPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer) { }
void __indirect_glEdgeFlagPointerEXT(GLsizei stride, GLsizei count, const GLboolean *pointer) { }
void __indirect_glIndexPointerEXT(GLenum type, GLsizei stride, GLsizei count, const void *pointer) { }
void __indirect_glNormalPointerEXT(GLenum type, GLsizei stride, GLsizei count, const void *pointer) { }
void __indirect_glTexCoordPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer) { }
void __indirect_glVertexPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer) { }
void __indirect_glPointParameterf(GLenum pname, GLfloat param) { }
void __indirect_glPointParameterfv(GLenum pname, const GLfloat *params) { }
void __indirect_glSecondaryColor3b(GLbyte red, GLbyte green, GLbyte blue) { }
void __indirect_glSecondaryColor3bv(const GLbyte *v) { }
void __indirect_glSecondaryColor3d(GLdouble red, GLdouble green, GLdouble blue) { }
void __indirect_glSecondaryColor3dv(const GLdouble *v) { }
void __indirect_glSecondaryColor3fEXT(GLfloat red, GLfloat green, GLfloat blue) { }
void __indirect_glSecondaryColor3fvEXT(const GLfloat *v) { }
void __indirect_glSecondaryColor3i(GLint red, GLint green, GLint blue) { }
void __indirect_glSecondaryColor3iv(const GLint *v) { }
void __indirect_glSecondaryColor3s(GLshort red, GLshort green, GLshort blue) { }
void __indirect_glSecondaryColor3sv(const GLshort *v) { }
void __indirect_glSecondaryColor3ub(GLubyte red, GLubyte green, GLubyte blue) { }
void __indirect_glSecondaryColor3ubv(const GLubyte *v) { }
void __indirect_glSecondaryColor3ui(GLuint red, GLuint green, GLuint blue) { }
void __indirect_glSecondaryColor3uiv(const GLuint *v) { }
void __indirect_glSecondaryColor3us(GLushort red, GLushort green, GLushort blue) { }
void __indirect_glSecondaryColor3usv(const GLushort *v) { }
void __indirect_glSecondaryColorPointer(GLint size, GLenum type, GLsizei stride, const void *pointer) { }
void __indirect_glMultiDrawArrays(GLenum mode, const GLint *first, const GLsizei *count, GLsizei drawcount) { }
void __indirect_glMultiDrawElements(GLenum mode, const GLsizei *count, GLenum type, const void *const*indices, GLsizei primcount) { }
void __indirect_glFogCoordPointer(GLenum type, GLsizei stride, const void *pointer) { }
void __indirect_glFogCoordd(GLdouble coord) { }
void __indirect_glFogCoorddv(const GLdouble *coord) { }
void __indirect_glFogCoordfEXT(GLfloat coord) { }
void __indirect_glFogCoordfvEXT(const GLfloat *coord) { }
void __indirect_glBlendFuncSeparate(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha) { }
void __indirect_glWindowPos2d(GLdouble x, GLdouble y) { }
void __indirect_glWindowPos2dv(const GLdouble *v) { }
void __indirect_glWindowPos2f(GLfloat x, GLfloat y) { }
void __indirect_glWindowPos2fv(const GLfloat *v) { }
void __indirect_glWindowPos2i(GLint x, GLint y) { }
void __indirect_glWindowPos2iv(const GLint *v) { }
void __indirect_glWindowPos2s(GLshort x, GLshort y) { }
void __indirect_glWindowPos2sv(const GLshort *v) { }
void __indirect_glWindowPos3d(GLdouble x, GLdouble y, GLdouble z) { }
void __indirect_glWindowPos3dv(const GLdouble *v) { }
void __indirect_glWindowPos3f(GLfloat x, GLfloat y, GLfloat z) { }
void __indirect_glWindowPos3fv(const GLfloat *v) { }
void __indirect_glWindowPos3i(GLint x, GLint y, GLint z) { }
void __indirect_glWindowPos3iv(const GLint *v) { }
void __indirect_glWindowPos3s(GLshort x, GLshort y, GLshort z) { }
void __indirect_glWindowPos3sv(const GLshort *v) { }
void __indirect_glAreProgramsResidentNV(GLsizei n, const GLuint *programs, GLboolean *residences) { }
void __indirect_glBindProgramARB(GLenum target, GLuint program) { }
void __indirect_glDeleteProgramsARB(GLsizei n, const GLuint *programs) { }
void __indirect_glExecuteProgramNV(GLenum target, GLuint id, const GLfloat *params) { }
void __indirect_glGenProgramsARB(GLsizei n, GLuint *programs) { }
void __indirect_glGetProgramParameterdvNV(GLenum target, GLuint index, GLenum pname, GLdouble *params) { }
void __indirect_glGetProgramParameterfvNV(GLenum target, GLuint index, GLenum pname, GLfloat *params) { }
void __indirect_glGetProgramStringNV(GLuint id, GLenum pname, GLubyte *program) { }
void __indirect_glGetProgramivNV(GLuint id, GLenum pname, GLint *params) { }
void __indirect_glGetTrackMatrixivNV(GLenum target, GLuint address, GLenum pname, GLint *params) { }
void __indirect_glGetVertexAttribPointerv(GLuint index, GLenum pname, void **pointer) { }
void __indirect_glGetVertexAttribdvNV(GLuint index, GLenum pname, GLdouble *params) { }
void __indirect_glGetVertexAttribfvNV(GLuint index, GLenum pname, GLfloat *params) { }
void __indirect_glGetVertexAttribivNV(GLuint index, GLenum pname, GLint *params) { }
void __indirect_glIsProgramARB(GLuint program) { }
void __indirect_glLoadProgramNV(GLenum target, GLuint id, GLsizei len, const GLubyte *program) { }
void __indirect_glProgramParameters4dvNV(GLenum target, GLuint index, GLsizei count, const GLdouble *v) { }
void __indirect_glProgramParameters4fvNV(GLenum target, GLuint index, GLsizei count, const GLfloat *v) { }
void __indirect_glRequestResidentProgramsNV(GLsizei n, const GLuint *programs) { }
void __indirect_glTrackMatrixNV(GLenum target, GLuint address, GLenum matrix, GLenum transform) { }
void __indirect_glVertexAttrib1dNV(GLuint index, GLdouble x) { }
void __indirect_glVertexAttrib1dvNV(GLuint index, const GLdouble *v) { }
void __indirect_glVertexAttrib1fNV(GLuint index, GLfloat x) { }
void __indirect_glVertexAttrib1fvNV(GLuint index, const GLfloat *v) { }
void __indirect_glVertexAttrib1sNV(GLuint index, GLshort x) { }
void __indirect_glVertexAttrib1svNV(GLuint index, const GLshort *v) { }
void __indirect_glVertexAttrib2dNV(GLuint index, GLdouble x, GLdouble y) { }
void __indirect_glVertexAttrib2dvNV(GLuint index, const GLdouble *v) { }
void __indirect_glVertexAttrib2fNV(GLuint index, GLfloat x, GLfloat y) { }
void __indirect_glVertexAttrib2fvNV(GLuint index, const GLfloat *v) { }
void __indirect_glVertexAttrib2sNV(GLuint index, GLshort x, GLshort y) { }
void __indirect_glVertexAttrib2svNV(GLuint index, const GLshort *v) { }
void __indirect_glVertexAttrib3dNV(GLuint index, GLdouble x, GLdouble y, GLdouble z) { }
void __indirect_glVertexAttrib3dvNV(GLuint index, const GLdouble *v) { }
void __indirect_glVertexAttrib3fNV(GLuint index, GLfloat x, GLfloat y, GLfloat z) { }
void __indirect_glVertexAttrib3fvNV(GLuint index, const GLfloat *v) { }
void __indirect_glVertexAttrib3sNV(GLuint index, GLshort x, GLshort y, GLshort z) { }
void __indirect_glVertexAttrib3svNV(GLuint index, const GLshort *v) { }
void __indirect_glVertexAttrib4dNV(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) { }
void __indirect_glVertexAttrib4dvNV(GLuint index, const GLdouble *v) { }
void __indirect_glVertexAttrib4fNV(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) { }
void __indirect_glVertexAttrib4fvNV(GLuint index, const GLfloat *v) { }
void __indirect_glVertexAttrib4sNV(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w) { }
void __indirect_glVertexAttrib4svNV(GLuint index, const GLshort *v) { }
void __indirect_glVertexAttrib4ubNV(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w) { }
void __indirect_glVertexAttrib4ubvNV(GLuint index, const GLubyte *v) { }
void __indirect_glVertexAttribPointerNV(GLuint index, GLint fsize, GLenum type, GLsizei stride, const void *pointer) { }
void __indirect_glVertexAttribs1dvNV(GLuint index, GLsizei count, const GLdouble *v) { }
void __indirect_glVertexAttribs1fvNV(GLuint index, GLsizei count, const GLfloat *v) { }
void __indirect_glVertexAttribs1svNV(GLuint index, GLsizei count, const GLshort *v) { }
void __indirect_glVertexAttribs2dvNV(GLuint index, GLsizei count, const GLdouble *v) { }
void __indirect_glVertexAttribs2fvNV(GLuint index, GLsizei count, const GLfloat *v) { }
void __indirect_glVertexAttribs2svNV(GLuint index, GLsizei count, const GLshort *v) { }
void __indirect_glVertexAttribs3dvNV(GLuint index, GLsizei count, const GLdouble *v) { }
void __indirect_glVertexAttribs3fvNV(GLuint index, GLsizei count, const GLfloat *v) { }
void __indirect_glVertexAttribs3svNV(GLuint index, GLsizei count, const GLshort *v) { }
void __indirect_glVertexAttribs4dvNV(GLuint index, GLsizei count, const GLdouble *v) { }
void __indirect_glVertexAttribs4fvNV(GLuint index, GLsizei count, const GLfloat *v) { }
void __indirect_glVertexAttribs4svNV(GLuint index, GLsizei count, const GLshort *v) { }
void __indirect_glVertexAttribs4ubvNV(GLuint index, GLsizei count, const GLubyte *v) { }
void __indirect_glPointParameteri(GLenum pname, GLint param) { }
void __indirect_glPointParameteriv(GLenum pname, const GLint *params) { }
void __indirect_glActiveStencilFaceEXT(GLenum face) { }
void __indirect_glGetProgramNamedParameterdvNV(GLuint id, GLsizei len, const GLubyte *name, GLdouble *params) { }
void __indirect_glGetProgramNamedParameterfvNV(GLuint id, GLsizei len, const GLubyte *name, GLfloat *params) { }
void __indirect_glProgramNamedParameter4dNV(GLuint id, GLsizei len, const GLubyte *name, GLdouble x, GLdouble y, GLdouble z, GLdouble w) { }
void __indirect_glProgramNamedParameter4dvNV(GLuint id, GLsizei len, const GLubyte *name, const GLdouble *v) { }
void __indirect_glProgramNamedParameter4fNV(GLuint id, GLsizei len, const GLubyte *name, GLfloat x, GLfloat y, GLfloat z, GLfloat w) { }
void __indirect_glProgramNamedParameter4fvNV(GLuint id, GLsizei len, const GLubyte *name, const GLfloat *v) { }
void __indirect_glBlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha) { }
void __indirect_glBindFramebufferEXT(GLenum target, GLuint framebuffer) { }
void __indirect_glBindRenderbufferEXT(GLenum target, GLuint renderbuffer) { }
void __indirect_glBindFramebuffer(GLenum target, GLuint framebuffer) { }
void __indirect_glBindRenderbuffer(GLenum target, GLuint renderbuffer) { }
void __indirect_glCheckFramebufferStatus(GLenum target) { }
void __indirect_glDeleteFramebuffers(GLsizei n, const GLuint *framebuffers) { }
void __indirect_glDeleteRenderbuffers(GLsizei n, const GLuint *renderbuffers) { }
void __indirect_glFramebufferRenderbuffer(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer) { }
void __indirect_glFramebufferTexture1D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) { }
void __indirect_glFramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) { }
void __indirect_glFramebufferTexture3D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset) { }
void __indirect_glGenFramebuffers(GLsizei n, GLuint *framebuffers) { }
void __indirect_glGenRenderbuffers(GLsizei n, GLuint *renderbuffers) { }
void __indirect_glGenerateMipmap(GLenum target) { }
void __indirect_glGetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint *params) { }
void __indirect_glGetRenderbufferParameteriv(GLenum target, GLenum pname, GLint *params) { }
void __indirect_glIsFramebuffer(GLuint framebuffer) { }
void __indirect_glIsRenderbuffer(GLuint renderbuffer) { }
void __indirect_glRenderbufferStorage(GLenum target, GLenum internalformat, GLsizei width, GLsizei height) { }
void __indirect_glBlitFramebuffer(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) { }
void __indirect_glFramebufferTextureLayer(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer) { }
}
/*@}*/

#ifndef GLX_USE_APPLEGL

class IndirectAPI : public ::testing::Test {
public:
   virtual void SetUp();
   virtual void TearDown();

   _glapi_proc *table;
};

void
IndirectAPI::SetUp()
{
   this->table = (_glapi_proc *) __glXNewIndirectAPI();
}

void
IndirectAPI::TearDown()
{
   free(this->table);
   this->table = NULL;
}

TEST_F(IndirectAPI, DispatchTableSizeWasQueried)
{
   dispatch_table_size_was_queried = false;

   /* __glXNewIndirectAPI determines the size of the dispatch table by calling
    * _glapi_get_dispatch_table_size.  Our stub version of this function sets
    * a flag so that we can detect that __glXNewIndirectAPI called it.
    */
   EXPECT_FALSE(dispatch_table_size_was_queried);
   _glapi_table *table = __glXNewIndirectAPI();
   EXPECT_TRUE(dispatch_table_size_was_queried);

   /* Since a second dispatch table was created, it must be freed by hand.
    */
   free(table);
}

TEST_F(IndirectAPI, NoNullEntries)
{
   const unsigned entries = _glapi_get_dispatch_table_size();

   /* There should not be any NULL entries in the dispatch table.  All entries
    * should either point to a real implementation or to a no-op function.
    */
   for (unsigned i = 0; i < entries; i++) {
      EXPECT_NE(nil, table[i]);
   }
}

TEST_F(IndirectAPI, OpenGL_10)
{
   EXPECT_EQ((_glapi_proc) __indirect_glAccum, table[_gloffset_Accum]);
   EXPECT_EQ((_glapi_proc) __indirect_glAlphaFunc, table[_gloffset_AlphaFunc]);
   EXPECT_EQ((_glapi_proc) __indirect_glBegin, table[_gloffset_Begin]);
   EXPECT_EQ((_glapi_proc) __indirect_glBitmap, table[_gloffset_Bitmap]);
   EXPECT_EQ((_glapi_proc) __indirect_glBlendFunc, table[_gloffset_BlendFunc]);
   EXPECT_EQ((_glapi_proc) __indirect_glCallList, table[_gloffset_CallList]);
   EXPECT_EQ((_glapi_proc) __indirect_glCallLists, table[_gloffset_CallLists]);
   EXPECT_EQ((_glapi_proc) __indirect_glClear, table[_gloffset_Clear]);
   EXPECT_EQ((_glapi_proc) __indirect_glClearAccum, table[_gloffset_ClearAccum]);
   EXPECT_EQ((_glapi_proc) __indirect_glClearColor, table[_gloffset_ClearColor]);
   EXPECT_EQ((_glapi_proc) __indirect_glClearDepth, table[_gloffset_ClearDepth]);
   EXPECT_EQ((_glapi_proc) __indirect_glClearIndex, table[_gloffset_ClearIndex]);
   EXPECT_EQ((_glapi_proc) __indirect_glClearStencil, table[_gloffset_ClearStencil]);
   EXPECT_EQ((_glapi_proc) __indirect_glClipPlane, table[_gloffset_ClipPlane]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor3b, table[_gloffset_Color3b]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor3bv, table[_gloffset_Color3bv]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor3d, table[_gloffset_Color3d]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor3dv, table[_gloffset_Color3dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor3f, table[_gloffset_Color3f]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor3fv, table[_gloffset_Color3fv]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor3i, table[_gloffset_Color3i]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor3iv, table[_gloffset_Color3iv]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor3s, table[_gloffset_Color3s]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor3sv, table[_gloffset_Color3sv]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor3ub, table[_gloffset_Color3ub]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor3ubv, table[_gloffset_Color3ubv]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor3ui, table[_gloffset_Color3ui]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor3uiv, table[_gloffset_Color3uiv]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor3us, table[_gloffset_Color3us]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor3usv, table[_gloffset_Color3usv]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor4b, table[_gloffset_Color4b]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor4bv, table[_gloffset_Color4bv]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor4d, table[_gloffset_Color4d]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor4dv, table[_gloffset_Color4dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor4f, table[_gloffset_Color4f]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor4fv, table[_gloffset_Color4fv]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor4i, table[_gloffset_Color4i]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor4iv, table[_gloffset_Color4iv]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor4s, table[_gloffset_Color4s]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor4sv, table[_gloffset_Color4sv]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor4ub, table[_gloffset_Color4ub]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor4ubv, table[_gloffset_Color4ubv]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor4ui, table[_gloffset_Color4ui]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor4uiv, table[_gloffset_Color4uiv]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor4us, table[_gloffset_Color4us]);
   EXPECT_EQ((_glapi_proc) __indirect_glColor4usv, table[_gloffset_Color4usv]);
   EXPECT_EQ((_glapi_proc) __indirect_glColorMask, table[_gloffset_ColorMask]);
   EXPECT_EQ((_glapi_proc) __indirect_glColorMaterial, table[_gloffset_ColorMaterial]);
   EXPECT_EQ((_glapi_proc) __indirect_glCopyPixels, table[_gloffset_CopyPixels]);
   EXPECT_EQ((_glapi_proc) __indirect_glCullFace, table[_gloffset_CullFace]);
   EXPECT_EQ((_glapi_proc) __indirect_glDeleteLists, table[_gloffset_DeleteLists]);
   EXPECT_EQ((_glapi_proc) __indirect_glDepthFunc, table[_gloffset_DepthFunc]);
   EXPECT_EQ((_glapi_proc) __indirect_glDepthMask, table[_gloffset_DepthMask]);
   EXPECT_EQ((_glapi_proc) __indirect_glDepthRange, table[_gloffset_DepthRange]);
   EXPECT_EQ((_glapi_proc) __indirect_glDisable, table[_gloffset_Disable]);
   EXPECT_EQ((_glapi_proc) __indirect_glDrawBuffer, table[_gloffset_DrawBuffer]);
   EXPECT_EQ((_glapi_proc) __indirect_glDrawPixels, table[_gloffset_DrawPixels]);
   EXPECT_EQ((_glapi_proc) __indirect_glEdgeFlag, table[_gloffset_EdgeFlag]);
   EXPECT_EQ((_glapi_proc) __indirect_glEdgeFlagv, table[_gloffset_EdgeFlagv]);
   EXPECT_EQ((_glapi_proc) __indirect_glEnable, table[_gloffset_Enable]);
   EXPECT_EQ((_glapi_proc) __indirect_glEnd, table[_gloffset_End]);
   EXPECT_EQ((_glapi_proc) __indirect_glEndList, table[_gloffset_EndList]);
   EXPECT_EQ((_glapi_proc) __indirect_glEvalCoord1d, table[_gloffset_EvalCoord1d]);
   EXPECT_EQ((_glapi_proc) __indirect_glEvalCoord1dv, table[_gloffset_EvalCoord1dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glEvalCoord1f, table[_gloffset_EvalCoord1f]);
   EXPECT_EQ((_glapi_proc) __indirect_glEvalCoord1fv, table[_gloffset_EvalCoord1fv]);
   EXPECT_EQ((_glapi_proc) __indirect_glEvalCoord2d, table[_gloffset_EvalCoord2d]);
   EXPECT_EQ((_glapi_proc) __indirect_glEvalCoord2dv, table[_gloffset_EvalCoord2dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glEvalCoord2f, table[_gloffset_EvalCoord2f]);
   EXPECT_EQ((_glapi_proc) __indirect_glEvalCoord2fv, table[_gloffset_EvalCoord2fv]);
   EXPECT_EQ((_glapi_proc) __indirect_glEvalMesh1, table[_gloffset_EvalMesh1]);
   EXPECT_EQ((_glapi_proc) __indirect_glEvalMesh2, table[_gloffset_EvalMesh2]);
   EXPECT_EQ((_glapi_proc) __indirect_glEvalPoint1, table[_gloffset_EvalPoint1]);
   EXPECT_EQ((_glapi_proc) __indirect_glEvalPoint2, table[_gloffset_EvalPoint2]);
   EXPECT_EQ((_glapi_proc) __indirect_glFeedbackBuffer, table[_gloffset_FeedbackBuffer]);
   EXPECT_EQ((_glapi_proc) __indirect_glFinish, table[_gloffset_Finish]);
   EXPECT_EQ((_glapi_proc) __indirect_glFlush, table[_gloffset_Flush]);
   EXPECT_EQ((_glapi_proc) __indirect_glFogf, table[_gloffset_Fogf]);
   EXPECT_EQ((_glapi_proc) __indirect_glFogfv, table[_gloffset_Fogfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glFogi, table[_gloffset_Fogi]);
   EXPECT_EQ((_glapi_proc) __indirect_glFogiv, table[_gloffset_Fogiv]);
   EXPECT_EQ((_glapi_proc) __indirect_glFrontFace, table[_gloffset_FrontFace]);
   EXPECT_EQ((_glapi_proc) __indirect_glFrustum, table[_gloffset_Frustum]);
   EXPECT_EQ((_glapi_proc) __indirect_glGenLists, table[_gloffset_GenLists]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetBooleanv, table[_gloffset_GetBooleanv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetClipPlane, table[_gloffset_GetClipPlane]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetDoublev, table[_gloffset_GetDoublev]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetError, table[_gloffset_GetError]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetFloatv, table[_gloffset_GetFloatv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetIntegerv, table[_gloffset_GetIntegerv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetLightfv, table[_gloffset_GetLightfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetLightiv, table[_gloffset_GetLightiv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetMapdv, table[_gloffset_GetMapdv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetMapfv, table[_gloffset_GetMapfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetMapiv, table[_gloffset_GetMapiv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetMaterialfv, table[_gloffset_GetMaterialfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetMaterialiv, table[_gloffset_GetMaterialiv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetPixelMapfv, table[_gloffset_GetPixelMapfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetPixelMapuiv, table[_gloffset_GetPixelMapuiv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetPixelMapusv, table[_gloffset_GetPixelMapusv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetPolygonStipple, table[_gloffset_GetPolygonStipple]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetString, table[_gloffset_GetString]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetTexEnvfv, table[_gloffset_GetTexEnvfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetTexEnviv, table[_gloffset_GetTexEnviv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetTexGendv, table[_gloffset_GetTexGendv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetTexGenfv, table[_gloffset_GetTexGenfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetTexGeniv, table[_gloffset_GetTexGeniv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetTexImage, table[_gloffset_GetTexImage]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetTexLevelParameterfv, table[_gloffset_GetTexLevelParameterfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetTexLevelParameteriv, table[_gloffset_GetTexLevelParameteriv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetTexParameterfv, table[_gloffset_GetTexParameterfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetTexParameteriv, table[_gloffset_GetTexParameteriv]);
   EXPECT_EQ((_glapi_proc) __indirect_glHint, table[_gloffset_Hint]);
   EXPECT_EQ((_glapi_proc) __indirect_glIndexMask, table[_gloffset_IndexMask]);
   EXPECT_EQ((_glapi_proc) __indirect_glIndexd, table[_gloffset_Indexd]);
   EXPECT_EQ((_glapi_proc) __indirect_glIndexdv, table[_gloffset_Indexdv]);
   EXPECT_EQ((_glapi_proc) __indirect_glIndexf, table[_gloffset_Indexf]);
   EXPECT_EQ((_glapi_proc) __indirect_glIndexfv, table[_gloffset_Indexfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glIndexi, table[_gloffset_Indexi]);
   EXPECT_EQ((_glapi_proc) __indirect_glIndexiv, table[_gloffset_Indexiv]);
   EXPECT_EQ((_glapi_proc) __indirect_glIndexs, table[_gloffset_Indexs]);
   EXPECT_EQ((_glapi_proc) __indirect_glIndexsv, table[_gloffset_Indexsv]);
   EXPECT_EQ((_glapi_proc) __indirect_glInitNames, table[_gloffset_InitNames]);
   EXPECT_EQ((_glapi_proc) __indirect_glIsEnabled, table[_gloffset_IsEnabled]);
   EXPECT_EQ((_glapi_proc) __indirect_glIsList, table[_gloffset_IsList]);
   EXPECT_EQ((_glapi_proc) __indirect_glLightModelf, table[_gloffset_LightModelf]);
   EXPECT_EQ((_glapi_proc) __indirect_glLightModelfv, table[_gloffset_LightModelfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glLightModeli, table[_gloffset_LightModeli]);
   EXPECT_EQ((_glapi_proc) __indirect_glLightModeliv, table[_gloffset_LightModeliv]);
   EXPECT_EQ((_glapi_proc) __indirect_glLightf, table[_gloffset_Lightf]);
   EXPECT_EQ((_glapi_proc) __indirect_glLightfv, table[_gloffset_Lightfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glLighti, table[_gloffset_Lighti]);
   EXPECT_EQ((_glapi_proc) __indirect_glLightiv, table[_gloffset_Lightiv]);
   EXPECT_EQ((_glapi_proc) __indirect_glLineStipple, table[_gloffset_LineStipple]);
   EXPECT_EQ((_glapi_proc) __indirect_glLineWidth, table[_gloffset_LineWidth]);
   EXPECT_EQ((_glapi_proc) __indirect_glListBase, table[_gloffset_ListBase]);
   EXPECT_EQ((_glapi_proc) __indirect_glLoadIdentity, table[_gloffset_LoadIdentity]);
   EXPECT_EQ((_glapi_proc) __indirect_glLoadMatrixd, table[_gloffset_LoadMatrixd]);
   EXPECT_EQ((_glapi_proc) __indirect_glLoadMatrixf, table[_gloffset_LoadMatrixf]);
   EXPECT_EQ((_glapi_proc) __indirect_glLoadName, table[_gloffset_LoadName]);
   EXPECT_EQ((_glapi_proc) __indirect_glLogicOp, table[_gloffset_LogicOp]);
   EXPECT_EQ((_glapi_proc) __indirect_glMap1d, table[_gloffset_Map1d]);
   EXPECT_EQ((_glapi_proc) __indirect_glMap1f, table[_gloffset_Map1f]);
   EXPECT_EQ((_glapi_proc) __indirect_glMap2d, table[_gloffset_Map2d]);
   EXPECT_EQ((_glapi_proc) __indirect_glMap2f, table[_gloffset_Map2f]);
   EXPECT_EQ((_glapi_proc) __indirect_glMapGrid1d, table[_gloffset_MapGrid1d]);
   EXPECT_EQ((_glapi_proc) __indirect_glMapGrid1f, table[_gloffset_MapGrid1f]);
   EXPECT_EQ((_glapi_proc) __indirect_glMapGrid2d, table[_gloffset_MapGrid2d]);
   EXPECT_EQ((_glapi_proc) __indirect_glMapGrid2f, table[_gloffset_MapGrid2f]);
   EXPECT_EQ((_glapi_proc) __indirect_glMaterialf, table[_gloffset_Materialf]);
   EXPECT_EQ((_glapi_proc) __indirect_glMaterialfv, table[_gloffset_Materialfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glMateriali, table[_gloffset_Materiali]);
   EXPECT_EQ((_glapi_proc) __indirect_glMaterialiv, table[_gloffset_Materialiv]);
   EXPECT_EQ((_glapi_proc) __indirect_glMatrixMode, table[_gloffset_MatrixMode]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultMatrixd, table[_gloffset_MultMatrixd]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultMatrixf, table[_gloffset_MultMatrixf]);
   EXPECT_EQ((_glapi_proc) __indirect_glNewList, table[_gloffset_NewList]);
   EXPECT_EQ((_glapi_proc) __indirect_glNormal3b, table[_gloffset_Normal3b]);
   EXPECT_EQ((_glapi_proc) __indirect_glNormal3bv, table[_gloffset_Normal3bv]);
   EXPECT_EQ((_glapi_proc) __indirect_glNormal3d, table[_gloffset_Normal3d]);
   EXPECT_EQ((_glapi_proc) __indirect_glNormal3dv, table[_gloffset_Normal3dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glNormal3f, table[_gloffset_Normal3f]);
   EXPECT_EQ((_glapi_proc) __indirect_glNormal3fv, table[_gloffset_Normal3fv]);
   EXPECT_EQ((_glapi_proc) __indirect_glNormal3i, table[_gloffset_Normal3i]);
   EXPECT_EQ((_glapi_proc) __indirect_glNormal3iv, table[_gloffset_Normal3iv]);
   EXPECT_EQ((_glapi_proc) __indirect_glNormal3s, table[_gloffset_Normal3s]);
   EXPECT_EQ((_glapi_proc) __indirect_glNormal3sv, table[_gloffset_Normal3sv]);
   EXPECT_EQ((_glapi_proc) __indirect_glOrtho, table[_gloffset_Ortho]);
   EXPECT_EQ((_glapi_proc) __indirect_glPassThrough, table[_gloffset_PassThrough]);
   EXPECT_EQ((_glapi_proc) __indirect_glPixelMapfv, table[_gloffset_PixelMapfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glPixelMapuiv, table[_gloffset_PixelMapuiv]);
   EXPECT_EQ((_glapi_proc) __indirect_glPixelMapusv, table[_gloffset_PixelMapusv]);
   EXPECT_EQ((_glapi_proc) __indirect_glPixelStoref, table[_gloffset_PixelStoref]);
   EXPECT_EQ((_glapi_proc) __indirect_glPixelStorei, table[_gloffset_PixelStorei]);
   EXPECT_EQ((_glapi_proc) __indirect_glPixelTransferf, table[_gloffset_PixelTransferf]);
   EXPECT_EQ((_glapi_proc) __indirect_glPixelTransferi, table[_gloffset_PixelTransferi]);
   EXPECT_EQ((_glapi_proc) __indirect_glPixelZoom, table[_gloffset_PixelZoom]);
   EXPECT_EQ((_glapi_proc) __indirect_glPointSize, table[_gloffset_PointSize]);
   EXPECT_EQ((_glapi_proc) __indirect_glPolygonMode, table[_gloffset_PolygonMode]);
   EXPECT_EQ((_glapi_proc) __indirect_glPolygonStipple, table[_gloffset_PolygonStipple]);
   EXPECT_EQ((_glapi_proc) __indirect_glPopAttrib, table[_gloffset_PopAttrib]);
   EXPECT_EQ((_glapi_proc) __indirect_glPopMatrix, table[_gloffset_PopMatrix]);
   EXPECT_EQ((_glapi_proc) __indirect_glPopName, table[_gloffset_PopName]);
   EXPECT_EQ((_glapi_proc) __indirect_glPushAttrib, table[_gloffset_PushAttrib]);
   EXPECT_EQ((_glapi_proc) __indirect_glPushMatrix, table[_gloffset_PushMatrix]);
   EXPECT_EQ((_glapi_proc) __indirect_glPushName, table[_gloffset_PushName]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos2d, table[_gloffset_RasterPos2d]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos2dv, table[_gloffset_RasterPos2dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos2f, table[_gloffset_RasterPos2f]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos2fv, table[_gloffset_RasterPos2fv]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos2i, table[_gloffset_RasterPos2i]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos2iv, table[_gloffset_RasterPos2iv]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos2s, table[_gloffset_RasterPos2s]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos2sv, table[_gloffset_RasterPos2sv]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos3d, table[_gloffset_RasterPos3d]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos3dv, table[_gloffset_RasterPos3dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos3f, table[_gloffset_RasterPos3f]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos3fv, table[_gloffset_RasterPos3fv]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos3i, table[_gloffset_RasterPos3i]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos3iv, table[_gloffset_RasterPos3iv]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos3s, table[_gloffset_RasterPos3s]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos3sv, table[_gloffset_RasterPos3sv]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos4d, table[_gloffset_RasterPos4d]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos4dv, table[_gloffset_RasterPos4dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos4f, table[_gloffset_RasterPos4f]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos4fv, table[_gloffset_RasterPos4fv]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos4i, table[_gloffset_RasterPos4i]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos4iv, table[_gloffset_RasterPos4iv]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos4s, table[_gloffset_RasterPos4s]);
   EXPECT_EQ((_glapi_proc) __indirect_glRasterPos4sv, table[_gloffset_RasterPos4sv]);
   EXPECT_EQ((_glapi_proc) __indirect_glReadBuffer, table[_gloffset_ReadBuffer]);
   EXPECT_EQ((_glapi_proc) __indirect_glReadPixels, table[_gloffset_ReadPixels]);
   EXPECT_EQ((_glapi_proc) __indirect_glRectd, table[_gloffset_Rectd]);
   EXPECT_EQ((_glapi_proc) __indirect_glRectdv, table[_gloffset_Rectdv]);
   EXPECT_EQ((_glapi_proc) __indirect_glRectf, table[_gloffset_Rectf]);
   EXPECT_EQ((_glapi_proc) __indirect_glRectfv, table[_gloffset_Rectfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glRecti, table[_gloffset_Recti]);
   EXPECT_EQ((_glapi_proc) __indirect_glRectiv, table[_gloffset_Rectiv]);
   EXPECT_EQ((_glapi_proc) __indirect_glRects, table[_gloffset_Rects]);
   EXPECT_EQ((_glapi_proc) __indirect_glRectsv, table[_gloffset_Rectsv]);
   EXPECT_EQ((_glapi_proc) __indirect_glRenderMode, table[_gloffset_RenderMode]);
   EXPECT_EQ((_glapi_proc) __indirect_glRotated, table[_gloffset_Rotated]);
   EXPECT_EQ((_glapi_proc) __indirect_glRotatef, table[_gloffset_Rotatef]);
   EXPECT_EQ((_glapi_proc) __indirect_glScaled, table[_gloffset_Scaled]);
   EXPECT_EQ((_glapi_proc) __indirect_glScalef, table[_gloffset_Scalef]);
   EXPECT_EQ((_glapi_proc) __indirect_glScissor, table[_gloffset_Scissor]);
   EXPECT_EQ((_glapi_proc) __indirect_glSelectBuffer, table[_gloffset_SelectBuffer]);
   EXPECT_EQ((_glapi_proc) __indirect_glShadeModel, table[_gloffset_ShadeModel]);
   EXPECT_EQ((_glapi_proc) __indirect_glStencilFunc, table[_gloffset_StencilFunc]);
   EXPECT_EQ((_glapi_proc) __indirect_glStencilMask, table[_gloffset_StencilMask]);
   EXPECT_EQ((_glapi_proc) __indirect_glStencilOp, table[_gloffset_StencilOp]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord1d, table[_gloffset_TexCoord1d]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord1dv, table[_gloffset_TexCoord1dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord1f, table[_gloffset_TexCoord1f]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord1fv, table[_gloffset_TexCoord1fv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord1i, table[_gloffset_TexCoord1i]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord1iv, table[_gloffset_TexCoord1iv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord1s, table[_gloffset_TexCoord1s]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord1sv, table[_gloffset_TexCoord1sv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord2d, table[_gloffset_TexCoord2d]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord2dv, table[_gloffset_TexCoord2dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord2f, table[_gloffset_TexCoord2f]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord2fv, table[_gloffset_TexCoord2fv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord2i, table[_gloffset_TexCoord2i]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord2iv, table[_gloffset_TexCoord2iv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord2s, table[_gloffset_TexCoord2s]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord2sv, table[_gloffset_TexCoord2sv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord3d, table[_gloffset_TexCoord3d]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord3dv, table[_gloffset_TexCoord3dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord3f, table[_gloffset_TexCoord3f]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord3fv, table[_gloffset_TexCoord3fv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord3i, table[_gloffset_TexCoord3i]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord3iv, table[_gloffset_TexCoord3iv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord3s, table[_gloffset_TexCoord3s]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord3sv, table[_gloffset_TexCoord3sv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord4d, table[_gloffset_TexCoord4d]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord4dv, table[_gloffset_TexCoord4dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord4f, table[_gloffset_TexCoord4f]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord4fv, table[_gloffset_TexCoord4fv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord4i, table[_gloffset_TexCoord4i]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord4iv, table[_gloffset_TexCoord4iv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord4s, table[_gloffset_TexCoord4s]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoord4sv, table[_gloffset_TexCoord4sv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexEnvf, table[_gloffset_TexEnvf]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexEnvfv, table[_gloffset_TexEnvfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexEnvi, table[_gloffset_TexEnvi]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexEnviv, table[_gloffset_TexEnviv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexGend, table[_gloffset_TexGend]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexGendv, table[_gloffset_TexGendv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexGenf, table[_gloffset_TexGenf]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexGenfv, table[_gloffset_TexGenfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexGeni, table[_gloffset_TexGeni]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexGeniv, table[_gloffset_TexGeniv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexImage1D, table[_gloffset_TexImage1D]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexImage2D, table[_gloffset_TexImage2D]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexParameterf, table[_gloffset_TexParameterf]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexParameterfv, table[_gloffset_TexParameterfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexParameteri, table[_gloffset_TexParameteri]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexParameteriv, table[_gloffset_TexParameteriv]);
   EXPECT_EQ((_glapi_proc) __indirect_glTranslated, table[_gloffset_Translated]);
   EXPECT_EQ((_glapi_proc) __indirect_glTranslatef, table[_gloffset_Translatef]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex2d, table[_gloffset_Vertex2d]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex2dv, table[_gloffset_Vertex2dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex2f, table[_gloffset_Vertex2f]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex2fv, table[_gloffset_Vertex2fv]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex2i, table[_gloffset_Vertex2i]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex2iv, table[_gloffset_Vertex2iv]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex2s, table[_gloffset_Vertex2s]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex2sv, table[_gloffset_Vertex2sv]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex3d, table[_gloffset_Vertex3d]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex3dv, table[_gloffset_Vertex3dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex3f, table[_gloffset_Vertex3f]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex3fv, table[_gloffset_Vertex3fv]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex3i, table[_gloffset_Vertex3i]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex3iv, table[_gloffset_Vertex3iv]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex3s, table[_gloffset_Vertex3s]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex3sv, table[_gloffset_Vertex3sv]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex4d, table[_gloffset_Vertex4d]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex4dv, table[_gloffset_Vertex4dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex4f, table[_gloffset_Vertex4f]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex4fv, table[_gloffset_Vertex4fv]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex4i, table[_gloffset_Vertex4i]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex4iv, table[_gloffset_Vertex4iv]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex4s, table[_gloffset_Vertex4s]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertex4sv, table[_gloffset_Vertex4sv]);
   EXPECT_EQ((_glapi_proc) __indirect_glViewport, table[_gloffset_Viewport]);
}

TEST_F(IndirectAPI, OpenGL_11)
{
   EXPECT_EQ((_glapi_proc) __indirect_glAreTexturesResident, table[_gloffset_AreTexturesResident]);
   EXPECT_EQ((_glapi_proc) __indirect_glArrayElement, table[_gloffset_ArrayElement]);
   EXPECT_EQ((_glapi_proc) __indirect_glBindTexture, table[_gloffset_BindTexture]);
   EXPECT_EQ((_glapi_proc) __indirect_glColorPointer, table[_gloffset_ColorPointer]);
   EXPECT_EQ((_glapi_proc) __indirect_glCopyTexImage1D, table[_gloffset_CopyTexImage1D]);
   EXPECT_EQ((_glapi_proc) __indirect_glCopyTexImage2D, table[_gloffset_CopyTexImage2D]);
   EXPECT_EQ((_glapi_proc) __indirect_glCopyTexSubImage1D, table[_gloffset_CopyTexSubImage1D]);
   EXPECT_EQ((_glapi_proc) __indirect_glCopyTexSubImage2D, table[_gloffset_CopyTexSubImage2D]);
   EXPECT_EQ((_glapi_proc) __indirect_glDeleteTextures, table[_gloffset_DeleteTextures]);
   EXPECT_EQ((_glapi_proc) __indirect_glDisableClientState, table[_gloffset_DisableClientState]);
   EXPECT_EQ((_glapi_proc) __indirect_glDrawArrays, table[_gloffset_DrawArrays]);
   EXPECT_EQ((_glapi_proc) __indirect_glDrawElements, table[_gloffset_DrawElements]);
   EXPECT_EQ((_glapi_proc) __indirect_glEdgeFlagPointer, table[_gloffset_EdgeFlagPointer]);
   EXPECT_EQ((_glapi_proc) __indirect_glEnableClientState, table[_gloffset_EnableClientState]);
   EXPECT_EQ((_glapi_proc) __indirect_glGenTextures, table[_gloffset_GenTextures]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetPointerv, table[_gloffset_GetPointerv]);
   EXPECT_EQ((_glapi_proc) __indirect_glIndexPointer, table[_gloffset_IndexPointer]);
   EXPECT_EQ((_glapi_proc) __indirect_glIndexub, table[_gloffset_Indexub]);
   EXPECT_EQ((_glapi_proc) __indirect_glIndexubv, table[_gloffset_Indexubv]);
   EXPECT_EQ((_glapi_proc) __indirect_glInterleavedArrays, table[_gloffset_InterleavedArrays]);
   EXPECT_EQ((_glapi_proc) __indirect_glIsTexture, table[_gloffset_IsTexture]);
   EXPECT_EQ((_glapi_proc) __indirect_glNormalPointer, table[_gloffset_NormalPointer]);
   EXPECT_EQ((_glapi_proc) __indirect_glPolygonOffset, table[_gloffset_PolygonOffset]);
   EXPECT_EQ((_glapi_proc) __indirect_glPopClientAttrib, table[_gloffset_PopClientAttrib]);
   EXPECT_EQ((_glapi_proc) __indirect_glPrioritizeTextures, table[_gloffset_PrioritizeTextures]);
   EXPECT_EQ((_glapi_proc) __indirect_glPushClientAttrib, table[_gloffset_PushClientAttrib]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoordPointer, table[_gloffset_TexCoordPointer]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexSubImage1D, table[_gloffset_TexSubImage1D]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexSubImage2D, table[_gloffset_TexSubImage2D]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexPointer, table[_gloffset_VertexPointer]);
}

TEST_F(IndirectAPI, OpenGL_12)
{
   EXPECT_EQ((_glapi_proc) __indirect_glBlendColor, table[_gloffset_BlendColor]);
   EXPECT_EQ((_glapi_proc) __indirect_glBlendEquation, table[_gloffset_BlendEquation]);
   EXPECT_EQ((_glapi_proc) __indirect_glColorSubTable, table[_gloffset_ColorSubTable]);
   EXPECT_EQ((_glapi_proc) __indirect_glColorTable, table[_gloffset_ColorTable]);
   EXPECT_EQ((_glapi_proc) __indirect_glColorTableParameterfv, table[_gloffset_ColorTableParameterfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glColorTableParameteriv, table[_gloffset_ColorTableParameteriv]);
   EXPECT_EQ((_glapi_proc) __indirect_glConvolutionFilter1D, table[_gloffset_ConvolutionFilter1D]);
   EXPECT_EQ((_glapi_proc) __indirect_glConvolutionFilter2D, table[_gloffset_ConvolutionFilter2D]);
   EXPECT_EQ((_glapi_proc) __indirect_glConvolutionParameterf, table[_gloffset_ConvolutionParameterf]);
   EXPECT_EQ((_glapi_proc) __indirect_glConvolutionParameterfv, table[_gloffset_ConvolutionParameterfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glConvolutionParameteri, table[_gloffset_ConvolutionParameteri]);
   EXPECT_EQ((_glapi_proc) __indirect_glConvolutionParameteriv, table[_gloffset_ConvolutionParameteriv]);
   EXPECT_EQ((_glapi_proc) __indirect_glCopyColorSubTable, table[_gloffset_CopyColorSubTable]);
   EXPECT_EQ((_glapi_proc) __indirect_glCopyColorTable, table[_gloffset_CopyColorTable]);
   EXPECT_EQ((_glapi_proc) __indirect_glCopyConvolutionFilter1D, table[_gloffset_CopyConvolutionFilter1D]);
   EXPECT_EQ((_glapi_proc) __indirect_glCopyConvolutionFilter2D, table[_gloffset_CopyConvolutionFilter2D]);
   EXPECT_EQ((_glapi_proc) __indirect_glCopyTexSubImage3D, table[_gloffset_CopyTexSubImage3D]);
   EXPECT_EQ((_glapi_proc) __indirect_glDrawRangeElements, table[_gloffset_DrawRangeElements]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetColorTable, table[_gloffset_GetColorTable]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetColorTableParameterfv, table[_gloffset_GetColorTableParameterfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetColorTableParameteriv, table[_gloffset_GetColorTableParameteriv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetConvolutionFilter, table[_gloffset_GetConvolutionFilter]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetConvolutionParameterfv, table[_gloffset_GetConvolutionParameterfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetConvolutionParameteriv, table[_gloffset_GetConvolutionParameteriv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetHistogram, table[_gloffset_GetHistogram]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetHistogramParameterfv, table[_gloffset_GetHistogramParameterfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetHistogramParameteriv, table[_gloffset_GetHistogramParameteriv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetMinmax, table[_gloffset_GetMinmax]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetMinmaxParameterfv, table[_gloffset_GetMinmaxParameterfv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetMinmaxParameteriv, table[_gloffset_GetMinmaxParameteriv]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetSeparableFilter, table[_gloffset_GetSeparableFilter]);
   EXPECT_EQ((_glapi_proc) __indirect_glHistogram, table[_gloffset_Histogram]);
   EXPECT_EQ((_glapi_proc) __indirect_glMinmax, table[_gloffset_Minmax]);
   EXPECT_EQ((_glapi_proc) __indirect_glResetHistogram, table[_gloffset_ResetHistogram]);
   EXPECT_EQ((_glapi_proc) __indirect_glResetMinmax, table[_gloffset_ResetMinmax]);
   EXPECT_EQ((_glapi_proc) __indirect_glSeparableFilter2D, table[_gloffset_SeparableFilter2D]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexImage3D, table[_gloffset_TexImage3D]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexSubImage3D, table[_gloffset_TexSubImage3D]);
}

TEST_F(IndirectAPI, OpenGL_20_is_nop)
{
   _glapi_proc const nop = table[_gloffset_COUNT];

   EXPECT_EQ(nop, table[_glapi_get_proc_offset("glAttachShader")]);
   EXPECT_EQ(nop, table[_glapi_get_proc_offset("glCreateProgram")]);
   EXPECT_EQ(nop, table[_glapi_get_proc_offset("glCreateShader")]);
   EXPECT_EQ(nop, table[_glapi_get_proc_offset("glDeleteProgram")]);
   EXPECT_EQ(nop, table[_glapi_get_proc_offset("glDeleteShader")]);
   EXPECT_EQ(nop, table[_glapi_get_proc_offset("glDetachShader")]);
   EXPECT_EQ(nop, table[_glapi_get_proc_offset("glGetAttachedShaders")]);
   EXPECT_EQ(nop, table[_glapi_get_proc_offset("glGetProgramInfoLog")]);
   EXPECT_EQ(nop, table[_glapi_get_proc_offset("glGetProgramiv")]);
   EXPECT_EQ(nop, table[_glapi_get_proc_offset("glGetShaderInfoLog")]);
   EXPECT_EQ(nop, table[_glapi_get_proc_offset("glGetShaderiv")]);
   EXPECT_EQ(nop, table[_glapi_get_proc_offset("glIsProgram")]);
   EXPECT_EQ(nop, table[_glapi_get_proc_offset("glIsShader")]);
   EXPECT_EQ(nop, table[_glapi_get_proc_offset("glStencilFuncSeparate")]);
   EXPECT_EQ(nop, table[_glapi_get_proc_offset("glStencilMaskSeparate")]);
   EXPECT_EQ(nop, table[_glapi_get_proc_offset("glStencilOpSeparate")]);
}

TEST_F(IndirectAPI, ARB_multitexture)
{
   EXPECT_EQ((_glapi_proc) __indirect_glActiveTexture, table[_gloffset_ActiveTexture]);
   EXPECT_EQ((_glapi_proc) __indirect_glClientActiveTexture, table[_gloffset_ClientActiveTexture]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord1d, table[_gloffset_MultiTexCoord1d]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord1dv, table[_gloffset_MultiTexCoord1dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord1fARB, table[_gloffset_MultiTexCoord1fARB]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord1fvARB, table[_gloffset_MultiTexCoord1fvARB]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord1i, table[_gloffset_MultiTexCoord1i]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord1iv, table[_gloffset_MultiTexCoord1iv]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord1s, table[_gloffset_MultiTexCoord1s]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord1sv, table[_gloffset_MultiTexCoord1sv]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord2d, table[_gloffset_MultiTexCoord2d]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord2dv, table[_gloffset_MultiTexCoord2dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord2fARB, table[_gloffset_MultiTexCoord2fARB]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord2fvARB, table[_gloffset_MultiTexCoord2fvARB]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord2i, table[_gloffset_MultiTexCoord2i]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord2iv, table[_gloffset_MultiTexCoord2iv]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord2s, table[_gloffset_MultiTexCoord2s]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord2sv, table[_gloffset_MultiTexCoord2sv]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord3d, table[_gloffset_MultiTexCoord3d]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord3dv, table[_gloffset_MultiTexCoord3dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord3fARB, table[_gloffset_MultiTexCoord3fARB]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord3fvARB, table[_gloffset_MultiTexCoord3fvARB]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord3i, table[_gloffset_MultiTexCoord3i]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord3iv, table[_gloffset_MultiTexCoord3iv]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord3s, table[_gloffset_MultiTexCoord3s]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord3sv, table[_gloffset_MultiTexCoord3sv]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord4d, table[_gloffset_MultiTexCoord4d]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord4dv, table[_gloffset_MultiTexCoord4dv]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord4fARB, table[_gloffset_MultiTexCoord4fARB]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord4fvARB, table[_gloffset_MultiTexCoord4fvARB]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord4i, table[_gloffset_MultiTexCoord4i]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord4iv, table[_gloffset_MultiTexCoord4iv]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord4s, table[_gloffset_MultiTexCoord4s]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiTexCoord4sv, table[_gloffset_MultiTexCoord4sv]);
}

TEST_F(IndirectAPI, ARB_transpose_matrix)
{
   EXPECT_EQ((_glapi_proc) __indirect_glLoadTransposeMatrixd, table[_glapi_get_proc_offset("glLoadTransposeMatrixdARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glLoadTransposeMatrixf, table[_glapi_get_proc_offset("glLoadTransposeMatrixfARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultTransposeMatrixd, table[_glapi_get_proc_offset("glMultTransposeMatrixdARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultTransposeMatrixf, table[_glapi_get_proc_offset("glMultTransposeMatrixfARB")]);
}

TEST_F(IndirectAPI, ARB_multisample)
{
   EXPECT_EQ((_glapi_proc) __indirect_glSampleCoverage, table[_glapi_get_proc_offset("glSampleCoverageARB")]);
}

TEST_F(IndirectAPI, ARB_texture_compression)
{
   EXPECT_EQ((_glapi_proc) __indirect_glCompressedTexImage1D, table[_glapi_get_proc_offset("glCompressedTexImage1DARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glCompressedTexImage2D, table[_glapi_get_proc_offset("glCompressedTexImage2DARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glCompressedTexImage3D, table[_glapi_get_proc_offset("glCompressedTexImage3DARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glCompressedTexSubImage1D, table[_glapi_get_proc_offset("glCompressedTexSubImage1DARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glCompressedTexSubImage2D, table[_glapi_get_proc_offset("glCompressedTexSubImage2DARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glCompressedTexSubImage3D, table[_glapi_get_proc_offset("glCompressedTexSubImage3DARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetCompressedTexImage, table[_glapi_get_proc_offset("glGetCompressedTexImageARB")]);
}

TEST_F(IndirectAPI, ARB_vertex_program)
{
   EXPECT_EQ((_glapi_proc) __indirect_glDisableVertexAttribArray, table[_glapi_get_proc_offset("glDisableVertexAttribArrayARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glEnableVertexAttribArray, table[_glapi_get_proc_offset("glEnableVertexAttribArrayARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetProgramEnvParameterdvARB, table[_glapi_get_proc_offset("glGetProgramEnvParameterdvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetProgramEnvParameterfvARB, table[_glapi_get_proc_offset("glGetProgramEnvParameterfvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetProgramLocalParameterdvARB, table[_glapi_get_proc_offset("glGetProgramLocalParameterdvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetProgramLocalParameterfvARB, table[_glapi_get_proc_offset("glGetProgramLocalParameterfvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetProgramStringARB, table[_glapi_get_proc_offset("glGetProgramStringARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetProgramivARB, table[_glapi_get_proc_offset("glGetProgramivARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetVertexAttribdv, table[_glapi_get_proc_offset("glGetVertexAttribdvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetVertexAttribfv, table[_glapi_get_proc_offset("glGetVertexAttribfvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetVertexAttribiv, table[_glapi_get_proc_offset("glGetVertexAttribivARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glProgramEnvParameter4dARB, table[_glapi_get_proc_offset("glProgramEnvParameter4dARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glProgramEnvParameter4dvARB, table[_glapi_get_proc_offset("glProgramEnvParameter4dvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glProgramEnvParameter4fARB, table[_glapi_get_proc_offset("glProgramEnvParameter4fARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glProgramEnvParameter4fvARB, table[_glapi_get_proc_offset("glProgramEnvParameter4fvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glProgramLocalParameter4dARB, table[_glapi_get_proc_offset("glProgramLocalParameter4dARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glProgramLocalParameter4dvARB, table[_glapi_get_proc_offset("glProgramLocalParameter4dvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glProgramLocalParameter4fARB, table[_glapi_get_proc_offset("glProgramLocalParameter4fARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glProgramLocalParameter4fvARB, table[_glapi_get_proc_offset("glProgramLocalParameter4fvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glProgramStringARB, table[_glapi_get_proc_offset("glProgramStringARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib1d, table[_glapi_get_proc_offset("glVertexAttrib1dARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib1dv, table[_glapi_get_proc_offset("glVertexAttrib1dvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib1fARB, table[_glapi_get_proc_offset("glVertexAttrib1fARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib1fvARB, table[_glapi_get_proc_offset("glVertexAttrib1fvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib1s, table[_glapi_get_proc_offset("glVertexAttrib1sARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib1sv, table[_glapi_get_proc_offset("glVertexAttrib1svARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib2d, table[_glapi_get_proc_offset("glVertexAttrib2dARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib2dv, table[_glapi_get_proc_offset("glVertexAttrib2dvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib2fARB, table[_glapi_get_proc_offset("glVertexAttrib2fARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib2fvARB, table[_glapi_get_proc_offset("glVertexAttrib2fvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib2s, table[_glapi_get_proc_offset("glVertexAttrib2sARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib2sv, table[_glapi_get_proc_offset("glVertexAttrib2svARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib3d, table[_glapi_get_proc_offset("glVertexAttrib3dARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib3dv, table[_glapi_get_proc_offset("glVertexAttrib3dvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib3fARB, table[_glapi_get_proc_offset("glVertexAttrib3fARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib3fvARB, table[_glapi_get_proc_offset("glVertexAttrib3fvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib3s, table[_glapi_get_proc_offset("glVertexAttrib3sARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib3sv, table[_glapi_get_proc_offset("glVertexAttrib3svARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4Nbv, table[_glapi_get_proc_offset("glVertexAttrib4NbvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4Niv, table[_glapi_get_proc_offset("glVertexAttrib4NivARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4Nsv, table[_glapi_get_proc_offset("glVertexAttrib4NsvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4Nub, table[_glapi_get_proc_offset("glVertexAttrib4NubARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4Nubv, table[_glapi_get_proc_offset("glVertexAttrib4NubvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4Nuiv, table[_glapi_get_proc_offset("glVertexAttrib4NuivARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4Nusv, table[_glapi_get_proc_offset("glVertexAttrib4NusvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4bv, table[_glapi_get_proc_offset("glVertexAttrib4bvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4d, table[_glapi_get_proc_offset("glVertexAttrib4dARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4dv, table[_glapi_get_proc_offset("glVertexAttrib4dvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4fARB, table[_glapi_get_proc_offset("glVertexAttrib4fARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4fvARB, table[_glapi_get_proc_offset("glVertexAttrib4fvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4iv, table[_glapi_get_proc_offset("glVertexAttrib4ivARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4s, table[_glapi_get_proc_offset("glVertexAttrib4sARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4sv, table[_glapi_get_proc_offset("glVertexAttrib4svARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4ubv, table[_glapi_get_proc_offset("glVertexAttrib4ubvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4uiv, table[_glapi_get_proc_offset("glVertexAttrib4uivARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4usv, table[_glapi_get_proc_offset("glVertexAttrib4usvARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttribPointer, table[_glapi_get_proc_offset("glVertexAttribPointerARB")]);
}

TEST_F(IndirectAPI, ARB_occlusion_query)
{
   EXPECT_EQ((_glapi_proc) __indirect_glBeginQuery, table[_glapi_get_proc_offset("glBeginQueryARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glDeleteQueries, table[_glapi_get_proc_offset("glDeleteQueriesARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glEndQuery, table[_glapi_get_proc_offset("glEndQueryARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGenQueries, table[_glapi_get_proc_offset("glGenQueriesARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetQueryObjectiv, table[_glapi_get_proc_offset("glGetQueryObjectivARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetQueryObjectuiv, table[_glapi_get_proc_offset("glGetQueryObjectuivARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetQueryiv, table[_glapi_get_proc_offset("glGetQueryivARB")]);
   EXPECT_EQ((_glapi_proc) __indirect_glIsQuery, table[_glapi_get_proc_offset("glIsQueryARB")]);
}

TEST_F(IndirectAPI, ARB_draw_buffers)
{
   EXPECT_EQ((_glapi_proc) __indirect_glDrawBuffers, table[_glapi_get_proc_offset("glDrawBuffersARB")]);
}

TEST_F(IndirectAPI, ARB_color_buffer_float)
{
   EXPECT_EQ((_glapi_proc) __indirect_glClampColor, table[_glapi_get_proc_offset("glClampColorARB")]);
}

TEST_F(IndirectAPI, ARB_framebuffer_object)
{
   EXPECT_EQ((_glapi_proc) __indirect_glRenderbufferStorageMultisample, table[_glapi_get_proc_offset("glRenderbufferStorageMultisample")]);
}

TEST_F(IndirectAPI, SGIS_multisample)
{
   EXPECT_EQ((_glapi_proc) __indirect_glSampleMaskSGIS, table[_glapi_get_proc_offset("glSampleMaskSGIS")]);
   EXPECT_EQ((_glapi_proc) __indirect_glSamplePatternSGIS, table[_glapi_get_proc_offset("glSamplePatternSGIS")]);
}

TEST_F(IndirectAPI, EXT_vertex_array)
{
   EXPECT_EQ((_glapi_proc) __indirect_glColorPointerEXT, table[_glapi_get_proc_offset("glColorPointerEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glEdgeFlagPointerEXT, table[_glapi_get_proc_offset("glEdgeFlagPointerEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glIndexPointerEXT, table[_glapi_get_proc_offset("glIndexPointerEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glNormalPointerEXT, table[_glapi_get_proc_offset("glNormalPointerEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glTexCoordPointerEXT, table[_glapi_get_proc_offset("glTexCoordPointerEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexPointerEXT, table[_glapi_get_proc_offset("glVertexPointerEXT")]);
}

TEST_F(IndirectAPI, EXT_point_parameters)
{
   EXPECT_EQ((_glapi_proc) __indirect_glPointParameterf, table[_glapi_get_proc_offset("glPointParameterfEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glPointParameterfv, table[_glapi_get_proc_offset("glPointParameterfvEXT")]);
}

TEST_F(IndirectAPI, EXT_secondary_color)
{
   EXPECT_EQ((_glapi_proc) __indirect_glSecondaryColor3b, table[_glapi_get_proc_offset("glSecondaryColor3bEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glSecondaryColor3bv, table[_glapi_get_proc_offset("glSecondaryColor3bvEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glSecondaryColor3d, table[_glapi_get_proc_offset("glSecondaryColor3dEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glSecondaryColor3dv, table[_glapi_get_proc_offset("glSecondaryColor3dvEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glSecondaryColor3fEXT, table[_glapi_get_proc_offset("glSecondaryColor3fEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glSecondaryColor3fvEXT, table[_glapi_get_proc_offset("glSecondaryColor3fvEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glSecondaryColor3i, table[_glapi_get_proc_offset("glSecondaryColor3iEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glSecondaryColor3iv, table[_glapi_get_proc_offset("glSecondaryColor3ivEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glSecondaryColor3s, table[_glapi_get_proc_offset("glSecondaryColor3sEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glSecondaryColor3sv, table[_glapi_get_proc_offset("glSecondaryColor3svEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glSecondaryColor3ub, table[_glapi_get_proc_offset("glSecondaryColor3ubEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glSecondaryColor3ubv, table[_glapi_get_proc_offset("glSecondaryColor3ubvEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glSecondaryColor3ui, table[_glapi_get_proc_offset("glSecondaryColor3uiEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glSecondaryColor3uiv, table[_glapi_get_proc_offset("glSecondaryColor3uivEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glSecondaryColor3us, table[_glapi_get_proc_offset("glSecondaryColor3usEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glSecondaryColor3usv, table[_glapi_get_proc_offset("glSecondaryColor3usvEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glSecondaryColorPointer, table[_glapi_get_proc_offset("glSecondaryColorPointerEXT")]);
}

TEST_F(IndirectAPI, EXT_multi_draw_arrays)
{
   EXPECT_EQ((_glapi_proc) __indirect_glMultiDrawArrays, table[_glapi_get_proc_offset("glMultiDrawArraysEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glMultiDrawElements, table[_glapi_get_proc_offset("glMultiDrawElementsEXT")]);
}

TEST_F(IndirectAPI, EXT_fog_coord)
{
   EXPECT_EQ((_glapi_proc) __indirect_glFogCoordPointer, table[_glapi_get_proc_offset("glFogCoordPointerEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glFogCoordd, table[_glapi_get_proc_offset("glFogCoorddEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glFogCoorddv, table[_glapi_get_proc_offset("glFogCoorddvEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glFogCoordfEXT, table[_glapi_get_proc_offset("glFogCoordfEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glFogCoordfvEXT, table[_glapi_get_proc_offset("glFogCoordfvEXT")]);
}

TEST_F(IndirectAPI, EXT_blend_func_separate)
{
   EXPECT_EQ((_glapi_proc) __indirect_glBlendFuncSeparate, table[_glapi_get_proc_offset("glBlendFuncSeparateEXT")]);
}

TEST_F(IndirectAPI, MESA_window_pos)
{
   EXPECT_EQ((_glapi_proc) __indirect_glWindowPos2d, table[_glapi_get_proc_offset("glWindowPos2dMESA")]);
   EXPECT_EQ((_glapi_proc) __indirect_glWindowPos2dv, table[_glapi_get_proc_offset("glWindowPos2dvMESA")]);
   EXPECT_EQ((_glapi_proc) __indirect_glWindowPos2f, table[_glapi_get_proc_offset("glWindowPos2fMESA")]);
   EXPECT_EQ((_glapi_proc) __indirect_glWindowPos2fv, table[_glapi_get_proc_offset("glWindowPos2fvMESA")]);
   EXPECT_EQ((_glapi_proc) __indirect_glWindowPos2i, table[_glapi_get_proc_offset("glWindowPos2iMESA")]);
   EXPECT_EQ((_glapi_proc) __indirect_glWindowPos2iv, table[_glapi_get_proc_offset("glWindowPos2ivMESA")]);
   EXPECT_EQ((_glapi_proc) __indirect_glWindowPos2s, table[_glapi_get_proc_offset("glWindowPos2sMESA")]);
   EXPECT_EQ((_glapi_proc) __indirect_glWindowPos2sv, table[_glapi_get_proc_offset("glWindowPos2svMESA")]);
   EXPECT_EQ((_glapi_proc) __indirect_glWindowPos3d, table[_glapi_get_proc_offset("glWindowPos3dMESA")]);
   EXPECT_EQ((_glapi_proc) __indirect_glWindowPos3dv, table[_glapi_get_proc_offset("glWindowPos3dvMESA")]);
   EXPECT_EQ((_glapi_proc) __indirect_glWindowPos3f, table[_glapi_get_proc_offset("glWindowPos3fMESA")]);
   EXPECT_EQ((_glapi_proc) __indirect_glWindowPos3fv, table[_glapi_get_proc_offset("glWindowPos3fvMESA")]);
   EXPECT_EQ((_glapi_proc) __indirect_glWindowPos3i, table[_glapi_get_proc_offset("glWindowPos3iMESA")]);
   EXPECT_EQ((_glapi_proc) __indirect_glWindowPos3iv, table[_glapi_get_proc_offset("glWindowPos3ivMESA")]);
   EXPECT_EQ((_glapi_proc) __indirect_glWindowPos3s, table[_glapi_get_proc_offset("glWindowPos3sMESA")]);
   EXPECT_EQ((_glapi_proc) __indirect_glWindowPos3sv, table[_glapi_get_proc_offset("glWindowPos3svMESA")]);
}

TEST_F(IndirectAPI, NV_vertex_program)
{
   EXPECT_EQ((_glapi_proc) __indirect_glAreProgramsResidentNV, table[_glapi_get_proc_offset("glAreProgramsResidentNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glBindProgramARB, table[_glapi_get_proc_offset("glBindProgramNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glDeleteProgramsARB, table[_glapi_get_proc_offset("glDeleteProgramsNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glExecuteProgramNV, table[_glapi_get_proc_offset("glExecuteProgramNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGenProgramsARB, table[_glapi_get_proc_offset("glGenProgramsNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetProgramParameterdvNV, table[_glapi_get_proc_offset("glGetProgramParameterdvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetProgramParameterfvNV, table[_glapi_get_proc_offset("glGetProgramParameterfvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetProgramStringNV, table[_glapi_get_proc_offset("glGetProgramStringNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetProgramivNV, table[_glapi_get_proc_offset("glGetProgramivNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetTrackMatrixivNV, table[_glapi_get_proc_offset("glGetTrackMatrixivNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetVertexAttribPointerv, table[_glapi_get_proc_offset("glGetVertexAttribPointervNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetVertexAttribdvNV, table[_glapi_get_proc_offset("glGetVertexAttribdvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetVertexAttribfvNV, table[_glapi_get_proc_offset("glGetVertexAttribfvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetVertexAttribivNV, table[_glapi_get_proc_offset("glGetVertexAttribivNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glIsProgramARB, table[_glapi_get_proc_offset("glIsProgramNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glLoadProgramNV, table[_glapi_get_proc_offset("glLoadProgramNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glProgramParameters4dvNV, table[_glapi_get_proc_offset("glProgramParameters4dvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glProgramParameters4fvNV, table[_glapi_get_proc_offset("glProgramParameters4fvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glRequestResidentProgramsNV, table[_glapi_get_proc_offset("glRequestResidentProgramsNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glTrackMatrixNV, table[_glapi_get_proc_offset("glTrackMatrixNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib1dNV, table[_glapi_get_proc_offset("glVertexAttrib1dNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib1dvNV, table[_glapi_get_proc_offset("glVertexAttrib1dvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib1fNV, table[_glapi_get_proc_offset("glVertexAttrib1fNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib1fvNV, table[_glapi_get_proc_offset("glVertexAttrib1fvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib1sNV, table[_glapi_get_proc_offset("glVertexAttrib1sNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib1svNV, table[_glapi_get_proc_offset("glVertexAttrib1svNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib2dNV, table[_glapi_get_proc_offset("glVertexAttrib2dNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib2dvNV, table[_glapi_get_proc_offset("glVertexAttrib2dvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib2fNV, table[_glapi_get_proc_offset("glVertexAttrib2fNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib2fvNV, table[_glapi_get_proc_offset("glVertexAttrib2fvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib2sNV, table[_glapi_get_proc_offset("glVertexAttrib2sNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib2svNV, table[_glapi_get_proc_offset("glVertexAttrib2svNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib3dNV, table[_glapi_get_proc_offset("glVertexAttrib3dNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib3dvNV, table[_glapi_get_proc_offset("glVertexAttrib3dvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib3fNV, table[_glapi_get_proc_offset("glVertexAttrib3fNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib3fvNV, table[_glapi_get_proc_offset("glVertexAttrib3fvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib3sNV, table[_glapi_get_proc_offset("glVertexAttrib3sNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib3svNV, table[_glapi_get_proc_offset("glVertexAttrib3svNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4dNV, table[_glapi_get_proc_offset("glVertexAttrib4dNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4dvNV, table[_glapi_get_proc_offset("glVertexAttrib4dvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4fNV, table[_glapi_get_proc_offset("glVertexAttrib4fNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4fvNV, table[_glapi_get_proc_offset("glVertexAttrib4fvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4sNV, table[_glapi_get_proc_offset("glVertexAttrib4sNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4svNV, table[_glapi_get_proc_offset("glVertexAttrib4svNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4ubNV, table[_glapi_get_proc_offset("glVertexAttrib4ubNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttrib4ubvNV, table[_glapi_get_proc_offset("glVertexAttrib4ubvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttribPointerNV, table[_glapi_get_proc_offset("glVertexAttribPointerNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttribs1dvNV, table[_glapi_get_proc_offset("glVertexAttribs1dvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttribs1fvNV, table[_glapi_get_proc_offset("glVertexAttribs1fvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttribs1svNV, table[_glapi_get_proc_offset("glVertexAttribs1svNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttribs2dvNV, table[_glapi_get_proc_offset("glVertexAttribs2dvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttribs2fvNV, table[_glapi_get_proc_offset("glVertexAttribs2fvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttribs2svNV, table[_glapi_get_proc_offset("glVertexAttribs2svNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttribs3dvNV, table[_glapi_get_proc_offset("glVertexAttribs3dvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttribs3fvNV, table[_glapi_get_proc_offset("glVertexAttribs3fvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttribs3svNV, table[_glapi_get_proc_offset("glVertexAttribs3svNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttribs4dvNV, table[_glapi_get_proc_offset("glVertexAttribs4dvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttribs4fvNV, table[_glapi_get_proc_offset("glVertexAttribs4fvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttribs4svNV, table[_glapi_get_proc_offset("glVertexAttribs4svNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glVertexAttribs4ubvNV, table[_glapi_get_proc_offset("glVertexAttribs4ubvNV")]);
}

TEST_F(IndirectAPI, NV_point_sprite)
{
   EXPECT_EQ((_glapi_proc) __indirect_glPointParameteri, table[_glapi_get_proc_offset("glPointParameteriNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glPointParameteriv, table[_glapi_get_proc_offset("glPointParameterivNV")]);
}

TEST_F(IndirectAPI, EXT_stencil_two_side)
{
   EXPECT_EQ((_glapi_proc) __indirect_glActiveStencilFaceEXT, table[_glapi_get_proc_offset("glActiveStencilFaceEXT")]);
}

TEST_F(IndirectAPI, NV_fragment_program)
{
   EXPECT_EQ((_glapi_proc) __indirect_glGetProgramNamedParameterdvNV, table[_glapi_get_proc_offset("glGetProgramNamedParameterdvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetProgramNamedParameterfvNV, table[_glapi_get_proc_offset("glGetProgramNamedParameterfvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glProgramNamedParameter4dNV, table[_glapi_get_proc_offset("glProgramNamedParameter4dNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glProgramNamedParameter4dvNV, table[_glapi_get_proc_offset("glProgramNamedParameter4dvNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glProgramNamedParameter4fNV, table[_glapi_get_proc_offset("glProgramNamedParameter4fNV")]);
   EXPECT_EQ((_glapi_proc) __indirect_glProgramNamedParameter4fvNV, table[_glapi_get_proc_offset("glProgramNamedParameter4fvNV")]);
}

TEST_F(IndirectAPI, EXT_blend_equation_separate)
{
   EXPECT_EQ((_glapi_proc) __indirect_glBlendEquationSeparate, table[_glapi_get_proc_offset("glBlendEquationSeparateEXT")]);
}

TEST_F(IndirectAPI, EXT_framebuffer_object)
{
   EXPECT_EQ((_glapi_proc) __indirect_glBindFramebufferEXT, table[_glapi_get_proc_offset("glBindFramebufferEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glBindRenderbufferEXT, table[_glapi_get_proc_offset("glBindRenderbufferEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glBindFramebuffer, table[_glapi_get_proc_offset("glBindFramebuffer")]);
   EXPECT_EQ((_glapi_proc) __indirect_glBindRenderbuffer, table[_glapi_get_proc_offset("glBindRenderbuffer")]);
   EXPECT_EQ((_glapi_proc) __indirect_glCheckFramebufferStatus, table[_glapi_get_proc_offset("glCheckFramebufferStatusEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glDeleteFramebuffers, table[_glapi_get_proc_offset("glDeleteFramebuffersEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glDeleteRenderbuffers, table[_glapi_get_proc_offset("glDeleteRenderbuffersEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glFramebufferRenderbuffer, table[_glapi_get_proc_offset("glFramebufferRenderbufferEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glFramebufferTexture1D, table[_glapi_get_proc_offset("glFramebufferTexture1DEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glFramebufferTexture2D, table[_glapi_get_proc_offset("glFramebufferTexture2DEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glFramebufferTexture3D, table[_glapi_get_proc_offset("glFramebufferTexture3DEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGenFramebuffers, table[_glapi_get_proc_offset("glGenFramebuffersEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGenRenderbuffers, table[_glapi_get_proc_offset("glGenRenderbuffersEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGenerateMipmap, table[_glapi_get_proc_offset("glGenerateMipmapEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetFramebufferAttachmentParameteriv, table[_glapi_get_proc_offset("glGetFramebufferAttachmentParameterivEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glGetRenderbufferParameteriv, table[_glapi_get_proc_offset("glGetRenderbufferParameterivEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glIsFramebuffer, table[_glapi_get_proc_offset("glIsFramebufferEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glIsRenderbuffer, table[_glapi_get_proc_offset("glIsRenderbufferEXT")]);
   EXPECT_EQ((_glapi_proc) __indirect_glRenderbufferStorage, table[_glapi_get_proc_offset("glRenderbufferStorageEXT")]);
}

TEST_F(IndirectAPI, EXT_framebuffer_blit)
{
   EXPECT_EQ((_glapi_proc) __indirect_glBlitFramebuffer, table[_glapi_get_proc_offset("glBlitFramebufferEXT")]);
}

TEST_F(IndirectAPI, EXT_texture_array)
{
   EXPECT_EQ((_glapi_proc) __indirect_glFramebufferTextureLayer, table[_glapi_get_proc_offset("glFramebufferTextureLayerEXT")]);
}

#endif
