"""Colors from the XKCD Color Name Survey

XKCD is a popular `web comic <https://xkcd.com/353/>`__ created by Randall Munroe.
His "`Color Name Survey <http://blog.xkcd.com/2010/05/03/color-survey-results/>`__" (with
200000 participants) resulted in a list of nearly 1000 color names.

While the ``XKCD`` module is exposed to Manim's global name space, the colors included
in it are not. This means that in order to use the colors, access them via the module name:

.. code:: pycon

    >>> from manim import XKCD
    >>> XKCD.MANGO
    ManimColor('#FFA62B')


List of Color Constants
-----------------------

These hex values are non official approximate values intended to simulate the colors in HTML,
taken from https://www.w3schools.com/colors/colors_xkcd.asp.

.. automanimcolormodule:: manim.utils.color.XKCD

"""

from .core import ManimColor

ACIDGREEN = ManimColor("#8FFE09")
ADOBE = ManimColor("#BD6C48")
ALGAE = ManimColor("#54AC68")
ALGAEGREEN = ManimColor("#21C36F")
ALMOSTBLACK = ManimColor("#070D0D")
AMBER = ManimColor("#FEB308")
AMETHYST = ManimColor("#9B5FC0")
APPLE = ManimColor("#6ECB3C")
APPLEGREEN = ManimColor("#76CD26")
APRICOT = ManimColor("#FFB16D")
AQUA = ManimColor("#13EAC9")
AQUABLUE = ManimColor("#02D8E9")
AQUAGREEN = ManimColor("#12E193")
AQUAMARINE = ManimColor("#2EE8BB")
ARMYGREEN = ManimColor("#4B5D16")
ASPARAGUS = ManimColor("#77AB56")
AUBERGINE = ManimColor("#3D0734")
AUBURN = ManimColor("#9A3001")
AVOCADO = ManimColor("#90B134")
AVOCADOGREEN = ManimColor("#87A922")
AZUL = ManimColor("#1D5DEC")
AZURE = ManimColor("#069AF3")
BABYBLUE = ManimColor("#A2CFFE")
BABYGREEN = ManimColor("#8CFF9E")
BABYPINK = ManimColor("#FFB7CE")
BABYPOO = ManimColor("#AB9004")
BABYPOOP = ManimColor("#937C00")
BABYPOOPGREEN = ManimColor("#8F9805")
BABYPUKEGREEN = ManimColor("#B6C406")
BABYPURPLE = ManimColor("#CA9BF7")
BABYSHITBROWN = ManimColor("#AD900D")
BABYSHITGREEN = ManimColor("#889717")
BANANA = ManimColor("#FFFF7E")
BANANAYELLOW = ManimColor("#FAFE4B")
BARBIEPINK = ManimColor("#FE46A5")
BARFGREEN = ManimColor("#94AC02")
BARNEY = ManimColor("#AC1DB8")
BARNEYPURPLE = ManimColor("#A00498")
BATTLESHIPGREY = ManimColor("#6B7C85")
BEIGE = ManimColor("#E6DAA6")
BERRY = ManimColor("#990F4B")
BILE = ManimColor("#B5C306")
BLACK = ManimColor("#000000")
BLAND = ManimColor("#AFA88B")
BLOOD = ManimColor("#770001")
BLOODORANGE = ManimColor("#FE4B03")
BLOODRED = ManimColor("#980002")
BLUE = ManimColor("#0343DF")
BLUEBERRY = ManimColor("#464196")
BLUEBLUE = ManimColor("#2242C7")
BLUEGREEN = ManimColor("#0F9B8E")
BLUEGREY = ManimColor("#85A3B2")
BLUEPURPLE = ManimColor("#5A06EF")
BLUEVIOLET = ManimColor("#5D06E9")
BLUEWITHAHINTOFPURPLE = ManimColor("#533CC6")
BLUEYGREEN = ManimColor("#2BB179")
BLUEYGREY = ManimColor("#89A0B0")
BLUEYPURPLE = ManimColor("#6241C7")
BLUISH = ManimColor("#2976BB")
BLUISHGREEN = ManimColor("#10A674")
BLUISHGREY = ManimColor("#748B97")
BLUISHPURPLE = ManimColor("#703BE7")
BLURPLE = ManimColor("#5539CC")
BLUSH = ManimColor("#F29E8E")
BLUSHPINK = ManimColor("#FE828C")
BOOGER = ManimColor("#9BB53C")
BOOGERGREEN = ManimColor("#96B403")
BORDEAUX = ManimColor("#7B002C")
BORINGGREEN = ManimColor("#63B365")
BOTTLEGREEN = ManimColor("#044A05")
BRICK = ManimColor("#A03623")
BRICKORANGE = ManimColor("#C14A09")
BRICKRED = ManimColor("#8F1402")
BRIGHTAQUA = ManimColor("#0BF9EA")
BRIGHTBLUE = ManimColor("#0165FC")
BRIGHTCYAN = ManimColor("#41FDFE")
BRIGHTGREEN = ManimColor("#01FF07")
BRIGHTLAVENDER = ManimColor("#C760FF")
BRIGHTLIGHTBLUE = ManimColor("#26F7FD")
BRIGHTLIGHTGREEN = ManimColor("#2DFE54")
BRIGHTLILAC = ManimColor("#C95EFB")
BRIGHTLIME = ManimColor("#87FD05")
BRIGHTLIMEGREEN = ManimColor("#65FE08")
BRIGHTMAGENTA = ManimColor("#FF08E8")
BRIGHTOLIVE = ManimColor("#9CBB04")
BRIGHTORANGE = ManimColor("#FF5B00")
BRIGHTPINK = ManimColor("#FE01B1")
BRIGHTPURPLE = ManimColor("#BE03FD")
BRIGHTRED = ManimColor("#FF000D")
BRIGHTSEAGREEN = ManimColor("#05FFA6")
BRIGHTSKYBLUE = ManimColor("#02CCFE")
BRIGHTTEAL = ManimColor("#01F9C6")
BRIGHTTURQUOISE = ManimColor("#0FFEF9")
BRIGHTVIOLET = ManimColor("#AD0AFD")
BRIGHTYELLOW = ManimColor("#FFFD01")
BRIGHTYELLOWGREEN = ManimColor("#9DFF00")
BRITISHRACINGGREEN = ManimColor("#05480D")
BRONZE = ManimColor("#A87900")
BROWN = ManimColor("#653700")
BROWNGREEN = ManimColor("#706C11")
BROWNGREY = ManimColor("#8D8468")
BROWNISH = ManimColor("#9C6D57")
BROWNISHGREEN = ManimColor("#6A6E09")
BROWNISHGREY = ManimColor("#86775F")
BROWNISHORANGE = ManimColor("#CB7723")
BROWNISHPINK = ManimColor("#C27E79")
BROWNISHPURPLE = ManimColor("#76424E")
BROWNISHRED = ManimColor("#9E3623")
BROWNISHYELLOW = ManimColor("#C9B003")
BROWNORANGE = ManimColor("#B96902")
BROWNRED = ManimColor("#922B05")
BROWNYELLOW = ManimColor("#B29705")
BROWNYGREEN = ManimColor("#6F6C0A")
BROWNYORANGE = ManimColor("#CA6B02")
BRUISE = ManimColor("#7E4071")
BUBBLEGUM = ManimColor("#FF6CB5")
BUBBLEGUMPINK = ManimColor("#FF69AF")
BUFF = ManimColor("#FEF69E")
BURGUNDY = ManimColor("#610023")
BURNTORANGE = ManimColor("#C04E01")
BURNTRED = ManimColor("#9F2305")
BURNTSIENA = ManimColor("#B75203")
BURNTSIENNA = ManimColor("#B04E0F")
BURNTUMBER = ManimColor("#A0450E")
BURNTYELLOW = ManimColor("#D5AB09")
BURPLE = ManimColor("#6832E3")
BUTTER = ManimColor("#FFFF81")
BUTTERSCOTCH = ManimColor("#FDB147")
BUTTERYELLOW = ManimColor("#FFFD74")
CADETBLUE = ManimColor("#4E7496")
CAMEL = ManimColor("#C69F59")
CAMO = ManimColor("#7F8F4E")
CAMOGREEN = ManimColor("#526525")
CAMOUFLAGEGREEN = ManimColor("#4B6113")
CANARY = ManimColor("#FDFF63")
CANARYYELLOW = ManimColor("#FFFE40")
CANDYPINK = ManimColor("#FF63E9")
CARAMEL = ManimColor("#AF6F09")
CARMINE = ManimColor("#9D0216")
CARNATION = ManimColor("#FD798F")
CARNATIONPINK = ManimColor("#FF7FA7")
CAROLINABLUE = ManimColor("#8AB8FE")
CELADON = ManimColor("#BEFDB7")
CELERY = ManimColor("#C1FD95")
CEMENT = ManimColor("#A5A391")
CERISE = ManimColor("#DE0C62")
CERULEAN = ManimColor("#0485D1")
CERULEANBLUE = ManimColor("#056EEE")
CHARCOAL = ManimColor("#343837")
CHARCOALGREY = ManimColor("#3C4142")
CHARTREUSE = ManimColor("#C1F80A")
CHERRY = ManimColor("#CF0234")
CHERRYRED = ManimColor("#F7022A")
CHESTNUT = ManimColor("#742802")
CHOCOLATE = ManimColor("#3D1C02")
CHOCOLATEBROWN = ManimColor("#411900")
CINNAMON = ManimColor("#AC4F06")
CLARET = ManimColor("#680018")
CLAY = ManimColor("#B66A50")
CLAYBROWN = ManimColor("#B2713D")
CLEARBLUE = ManimColor("#247AFD")
COBALT = ManimColor("#1E488F")
COBALTBLUE = ManimColor("#030AA7")
COCOA = ManimColor("#875F42")
COFFEE = ManimColor("#A6814C")
COOLBLUE = ManimColor("#4984B8")
COOLGREEN = ManimColor("#33B864")
COOLGREY = ManimColor("#95A3A6")
COPPER = ManimColor("#B66325")
CORAL = ManimColor("#FC5A50")
CORALPINK = ManimColor("#FF6163")
CORNFLOWER = ManimColor("#6A79F7")
CORNFLOWERBLUE = ManimColor("#5170D7")
CRANBERRY = ManimColor("#9E003A")
CREAM = ManimColor("#FFFFC2")
CREME = ManimColor("#FFFFB6")
CRIMSON = ManimColor("#8C000F")
CUSTARD = ManimColor("#FFFD78")
CYAN = ManimColor("#00FFFF")
DANDELION = ManimColor("#FEDF08")
DARK = ManimColor("#1B2431")
DARKAQUA = ManimColor("#05696B")
DARKAQUAMARINE = ManimColor("#017371")
DARKBEIGE = ManimColor("#AC9362")
DARKBLUE = ManimColor("#030764")
DARKBLUEGREEN = ManimColor("#005249")
DARKBLUEGREY = ManimColor("#1F3B4D")
DARKBROWN = ManimColor("#341C02")
DARKCORAL = ManimColor("#CF524E")
DARKCREAM = ManimColor("#FFF39A")
DARKCYAN = ManimColor("#0A888A")
DARKFORESTGREEN = ManimColor("#002D04")
DARKFUCHSIA = ManimColor("#9D0759")
DARKGOLD = ManimColor("#B59410")
DARKGRASSGREEN = ManimColor("#388004")
DARKGREEN = ManimColor("#054907")
DARKGREENBLUE = ManimColor("#1F6357")
DARKGREY = ManimColor("#363737")
DARKGREYBLUE = ManimColor("#29465B")
DARKHOTPINK = ManimColor("#D90166")
DARKINDIGO = ManimColor("#1F0954")
DARKISHBLUE = ManimColor("#014182")
DARKISHGREEN = ManimColor("#287C37")
DARKISHPINK = ManimColor("#DA467D")
DARKISHPURPLE = ManimColor("#751973")
DARKISHRED = ManimColor("#A90308")
DARKKHAKI = ManimColor("#9B8F55")
DARKLAVENDER = ManimColor("#856798")
DARKLILAC = ManimColor("#9C6DA5")
DARKLIME = ManimColor("#84B701")
DARKLIMEGREEN = ManimColor("#7EBD01")
DARKMAGENTA = ManimColor("#960056")
DARKMAROON = ManimColor("#3C0008")
DARKMAUVE = ManimColor("#874C62")
DARKMINT = ManimColor("#48C072")
DARKMINTGREEN = ManimColor("#20C073")
DARKMUSTARD = ManimColor("#A88905")
DARKNAVY = ManimColor("#000435")
DARKNAVYBLUE = ManimColor("#00022E")
DARKOLIVE = ManimColor("#373E02")
DARKOLIVEGREEN = ManimColor("#3C4D03")
DARKORANGE = ManimColor("#C65102")
DARKPASTELGREEN = ManimColor("#56AE57")
DARKPEACH = ManimColor("#DE7E5D")
DARKPERIWINKLE = ManimColor("#665FD1")
DARKPINK = ManimColor("#CB416B")
DARKPLUM = ManimColor("#3F012C")
DARKPURPLE = ManimColor("#35063E")
DARKRED = ManimColor("#840000")
DARKROSE = ManimColor("#B5485D")
DARKROYALBLUE = ManimColor("#02066F")
DARKSAGE = ManimColor("#598556")
DARKSALMON = ManimColor("#C85A53")
DARKSAND = ManimColor("#A88F59")
DARKSEAFOAM = ManimColor("#1FB57A")
DARKSEAFOAMGREEN = ManimColor("#3EAF76")
DARKSEAGREEN = ManimColor("#11875D")
DARKSKYBLUE = ManimColor("#448EE4")
DARKSLATEBLUE = ManimColor("#214761")
DARKTAN = ManimColor("#AF884A")
DARKTAUPE = ManimColor("#7F684E")
DARKTEAL = ManimColor("#014D4E")
DARKTURQUOISE = ManimColor("#045C5A")
DARKVIOLET = ManimColor("#34013F")
DARKYELLOW = ManimColor("#D5B60A")
DARKYELLOWGREEN = ManimColor("#728F02")
DEEPAQUA = ManimColor("#08787F")
DEEPBLUE = ManimColor("#040273")
DEEPBROWN = ManimColor("#410200")
DEEPGREEN = ManimColor("#02590F")
DEEPLAVENDER = ManimColor("#8D5EB7")
DEEPLILAC = ManimColor("#966EBD")
DEEPMAGENTA = ManimColor("#A0025C")
DEEPORANGE = ManimColor("#DC4D01")
DEEPPINK = ManimColor("#CB0162")
DEEPPURPLE = ManimColor("#36013F")
DEEPRED = ManimColor("#9A0200")
DEEPROSE = ManimColor("#C74767")
DEEPSEABLUE = ManimColor("#015482")
DEEPSKYBLUE = ManimColor("#0D75F8")
DEEPTEAL = ManimColor("#00555A")
DEEPTURQUOISE = ManimColor("#017374")
DEEPVIOLET = ManimColor("#490648")
DENIM = ManimColor("#3B638C")
DENIMBLUE = ManimColor("#3B5B92")
DESERT = ManimColor("#CCAD60")
DIARRHEA = ManimColor("#9F8303")
DIRT = ManimColor("#8A6E45")
DIRTBROWN = ManimColor("#836539")
DIRTYBLUE = ManimColor("#3F829D")
DIRTYGREEN = ManimColor("#667E2C")
DIRTYORANGE = ManimColor("#C87606")
DIRTYPINK = ManimColor("#CA7B80")
DIRTYPURPLE = ManimColor("#734A65")
DIRTYYELLOW = ManimColor("#CDC50A")
DODGERBLUE = ManimColor("#3E82FC")
DRAB = ManimColor("#828344")
DRABGREEN = ManimColor("#749551")
DRIEDBLOOD = ManimColor("#4B0101")
DUCKEGGBLUE = ManimColor("#C3FBF4")
DULLBLUE = ManimColor("#49759C")
DULLBROWN = ManimColor("#876E4B")
DULLGREEN = ManimColor("#74A662")
DULLORANGE = ManimColor("#D8863B")
DULLPINK = ManimColor("#D5869D")
DULLPURPLE = ManimColor("#84597E")
DULLRED = ManimColor("#BB3F3F")
DULLTEAL = ManimColor("#5F9E8F")
DULLYELLOW = ManimColor("#EEDC5B")
DUSK = ManimColor("#4E5481")
DUSKBLUE = ManimColor("#26538D")
DUSKYBLUE = ManimColor("#475F94")
DUSKYPINK = ManimColor("#CC7A8B")
DUSKYPURPLE = ManimColor("#895B7B")
DUSKYROSE = ManimColor("#BA6873")
DUST = ManimColor("#B2996E")
DUSTYBLUE = ManimColor("#5A86AD")
DUSTYGREEN = ManimColor("#76A973")
DUSTYLAVENDER = ManimColor("#AC86A8")
DUSTYORANGE = ManimColor("#F0833A")
DUSTYPINK = ManimColor("#D58A94")
DUSTYPURPLE = ManimColor("#825F87")
DUSTYRED = ManimColor("#B9484E")
DUSTYROSE = ManimColor("#C0737A")
DUSTYTEAL = ManimColor("#4C9085")
EARTH = ManimColor("#A2653E")
EASTERGREEN = ManimColor("#8CFD7E")
EASTERPURPLE = ManimColor("#C071FE")
ECRU = ManimColor("#FEFFCA")
EGGPLANT = ManimColor("#380835")
EGGPLANTPURPLE = ManimColor("#430541")
EGGSHELL = ManimColor("#FFFCC4")
EGGSHELLBLUE = ManimColor("#C4FFF7")
ELECTRICBLUE = ManimColor("#0652FF")
ELECTRICGREEN = ManimColor("#21FC0D")
ELECTRICLIME = ManimColor("#A8FF04")
ELECTRICPINK = ManimColor("#FF0490")
ELECTRICPURPLE = ManimColor("#AA23FF")
EMERALD = ManimColor("#01A049")
EMERALDGREEN = ManimColor("#028F1E")
EVERGREEN = ManimColor("#05472A")
FADEDBLUE = ManimColor("#658CBB")
FADEDGREEN = ManimColor("#7BB274")
FADEDORANGE = ManimColor("#F0944D")
FADEDPINK = ManimColor("#DE9DAC")
FADEDPURPLE = ManimColor("#916E99")
FADEDRED = ManimColor("#D3494E")
FADEDYELLOW = ManimColor("#FEFF7F")
FAWN = ManimColor("#CFAF7B")
FERN = ManimColor("#63A950")
FERNGREEN = ManimColor("#548D44")
FIREENGINERED = ManimColor("#FE0002")
FLATBLUE = ManimColor("#3C73A8")
FLATGREEN = ManimColor("#699D4C")
FLUORESCENTGREEN = ManimColor("#08FF08")
FLUROGREEN = ManimColor("#0AFF02")
FOAMGREEN = ManimColor("#90FDA9")
FOREST = ManimColor("#0B5509")
FORESTGREEN = ManimColor("#06470C")
FORRESTGREEN = ManimColor("#154406")
FRENCHBLUE = ManimColor("#436BAD")
FRESHGREEN = ManimColor("#69D84F")
FROGGREEN = ManimColor("#58BC08")
FUCHSIA = ManimColor("#ED0DD9")
GOLD = ManimColor("#DBB40C")
GOLDEN = ManimColor("#F5BF03")
GOLDENBROWN = ManimColor("#B27A01")
GOLDENROD = ManimColor("#F9BC08")
GOLDENYELLOW = ManimColor("#FEC615")
GRAPE = ManimColor("#6C3461")
GRAPEFRUIT = ManimColor("#FD5956")
GRAPEPURPLE = ManimColor("#5D1451")
GRASS = ManimColor("#5CAC2D")
GRASSGREEN = ManimColor("#3F9B0B")
GRASSYGREEN = ManimColor("#419C03")
GREEN = ManimColor("#15B01A")
GREENAPPLE = ManimColor("#5EDC1F")
GREENBLUE = ManimColor("#01C08D")
GREENBROWN = ManimColor("#544E03")
GREENGREY = ManimColor("#77926F")
GREENISH = ManimColor("#40A368")
GREENISHBEIGE = ManimColor("#C9D179")
GREENISHBLUE = ManimColor("#0B8B87")
GREENISHBROWN = ManimColor("#696112")
GREENISHCYAN = ManimColor("#2AFEB7")
GREENISHGREY = ManimColor("#96AE8D")
GREENISHTAN = ManimColor("#BCCB7A")
GREENISHTEAL = ManimColor("#32BF84")
GREENISHTURQUOISE = ManimColor("#00FBB0")
GREENISHYELLOW = ManimColor("#CDFD02")
GREENTEAL = ManimColor("#0CB577")
GREENYBLUE = ManimColor("#42B395")
GREENYBROWN = ManimColor("#696006")
GREENYELLOW = ManimColor("#B5CE08")
GREENYGREY = ManimColor("#7EA07A")
GREENYYELLOW = ManimColor("#C6F808")
GREY = ManimColor("#929591")
GREYBLUE = ManimColor("#647D8E")
GREYBROWN = ManimColor("#7F7053")
GREYGREEN = ManimColor("#86A17D")
GREYISH = ManimColor("#A8A495")
GREYISHBLUE = ManimColor("#5E819D")
GREYISHBROWN = ManimColor("#7A6A4F")
GREYISHGREEN = ManimColor("#82A67D")
GREYISHPINK = ManimColor("#C88D94")
GREYISHPURPLE = ManimColor("#887191")
GREYISHTEAL = ManimColor("#719F91")
GREYPINK = ManimColor("#C3909B")
GREYPURPLE = ManimColor("#826D8C")
GREYTEAL = ManimColor("#5E9B8A")
GROSSGREEN = ManimColor("#A0BF16")
GUNMETAL = ManimColor("#536267")
HAZEL = ManimColor("#8E7618")
HEATHER = ManimColor("#A484AC")
HELIOTROPE = ManimColor("#D94FF5")
HIGHLIGHTERGREEN = ManimColor("#1BFC06")
HOSPITALGREEN = ManimColor("#9BE5AA")
HOTGREEN = ManimColor("#25FF29")
HOTMAGENTA = ManimColor("#F504C9")
HOTPINK = ManimColor("#FF028D")
HOTPURPLE = ManimColor("#CB00F5")
HUNTERGREEN = ManimColor("#0B4008")
ICE = ManimColor("#D6FFFA")
ICEBLUE = ManimColor("#D7FFFE")
ICKYGREEN = ManimColor("#8FAE22")
INDIANRED = ManimColor("#850E04")
INDIGO = ManimColor("#380282")
INDIGOBLUE = ManimColor("#3A18B1")
IRIS = ManimColor("#6258C4")
IRISHGREEN = ManimColor("#019529")
IVORY = ManimColor("#FFFFCB")
JADE = ManimColor("#1FA774")
JADEGREEN = ManimColor("#2BAF6A")
JUNGLEGREEN = ManimColor("#048243")
KELLEYGREEN = ManimColor("#009337")
KELLYGREEN = ManimColor("#02AB2E")
KERMITGREEN = ManimColor("#5CB200")
KEYLIME = ManimColor("#AEFF6E")
KHAKI = ManimColor("#AAA662")
KHAKIGREEN = ManimColor("#728639")
KIWI = ManimColor("#9CEF43")
KIWIGREEN = ManimColor("#8EE53F")
LAVENDER = ManimColor("#C79FEF")
LAVENDERBLUE = ManimColor("#8B88F8")
LAVENDERPINK = ManimColor("#DD85D7")
LAWNGREEN = ManimColor("#4DA409")
LEAF = ManimColor("#71AA34")
LEAFGREEN = ManimColor("#5CA904")
LEAFYGREEN = ManimColor("#51B73B")
LEATHER = ManimColor("#AC7434")
LEMON = ManimColor("#FDFF52")
LEMONGREEN = ManimColor("#ADF802")
LEMONLIME = ManimColor("#BFFE28")
LEMONYELLOW = ManimColor("#FDFF38")
LICHEN = ManimColor("#8FB67B")
LIGHTAQUA = ManimColor("#8CFFDB")
LIGHTAQUAMARINE = ManimColor("#7BFDC7")
LIGHTBEIGE = ManimColor("#FFFEB6")
LIGHTBLUE = ManimColor("#7BC8F6")
LIGHTBLUEGREEN = ManimColor("#7EFBB3")
LIGHTBLUEGREY = ManimColor("#B7C9E2")
LIGHTBLUISHGREEN = ManimColor("#76FDA8")
LIGHTBRIGHTGREEN = ManimColor("#53FE5C")
LIGHTBROWN = ManimColor("#AD8150")
LIGHTBURGUNDY = ManimColor("#A8415B")
LIGHTCYAN = ManimColor("#ACFFFC")
LIGHTEGGPLANT = ManimColor("#894585")
LIGHTERGREEN = ManimColor("#75FD63")
LIGHTERPURPLE = ManimColor("#A55AF4")
LIGHTFORESTGREEN = ManimColor("#4F9153")
LIGHTGOLD = ManimColor("#FDDC5C")
LIGHTGRASSGREEN = ManimColor("#9AF764")
LIGHTGREEN = ManimColor("#76FF7B")
LIGHTGREENBLUE = ManimColor("#56FCA2")
LIGHTGREENISHBLUE = ManimColor("#63F7B4")
LIGHTGREY = ManimColor("#D8DCD6")
LIGHTGREYBLUE = ManimColor("#9DBCD4")
LIGHTGREYGREEN = ManimColor("#B7E1A1")
LIGHTINDIGO = ManimColor("#6D5ACF")
LIGHTISHBLUE = ManimColor("#3D7AFD")
LIGHTISHGREEN = ManimColor("#61E160")
LIGHTISHPURPLE = ManimColor("#A552E6")
LIGHTISHRED = ManimColor("#FE2F4A")
LIGHTKHAKI = ManimColor("#E6F2A2")
LIGHTLAVENDAR = ManimColor("#EFC0FE")
LIGHTLAVENDER = ManimColor("#DFC5FE")
LIGHTLIGHTBLUE = ManimColor("#CAFFFB")
LIGHTLIGHTGREEN = ManimColor("#C8FFB0")
LIGHTLILAC = ManimColor("#EDC8FF")
LIGHTLIME = ManimColor("#AEFD6C")
LIGHTLIMEGREEN = ManimColor("#B9FF66")
LIGHTMAGENTA = ManimColor("#FA5FF7")
LIGHTMAROON = ManimColor("#A24857")
LIGHTMAUVE = ManimColor("#C292A1")
LIGHTMINT = ManimColor("#B6FFBB")
LIGHTMINTGREEN = ManimColor("#A6FBB2")
LIGHTMOSSGREEN = ManimColor("#A6C875")
LIGHTMUSTARD = ManimColor("#F7D560")
LIGHTNAVY = ManimColor("#155084")
LIGHTNAVYBLUE = ManimColor("#2E5A88")
LIGHTNEONGREEN = ManimColor("#4EFD54")
LIGHTOLIVE = ManimColor("#ACBF69")
LIGHTOLIVEGREEN = ManimColor("#A4BE5C")
LIGHTORANGE = ManimColor("#FDAA48")
LIGHTPASTELGREEN = ManimColor("#B2FBA5")
LIGHTPEACH = ManimColor("#FFD8B1")
LIGHTPEAGREEN = ManimColor("#C4FE82")
LIGHTPERIWINKLE = ManimColor("#C1C6FC")
LIGHTPINK = ManimColor("#FFD1DF")
LIGHTPLUM = ManimColor("#9D5783")
LIGHTPURPLE = ManimColor("#BF77F6")
LIGHTRED = ManimColor("#FF474C")
LIGHTROSE = ManimColor("#FFC5CB")
LIGHTROYALBLUE = ManimColor("#3A2EFE")
LIGHTSAGE = ManimColor("#BCECAC")
LIGHTSALMON = ManimColor("#FEA993")
LIGHTSEAFOAM = ManimColor("#A0FEBF")
LIGHTSEAFOAMGREEN = ManimColor("#a7ffb5")
LIGHTSEAGREEN = ManimColor("#98F6B0")
LIGHTSKYBLUE = ManimColor("#C6FCFF")
LIGHTTAN = ManimColor("#FBEEAC")
LIGHTTEAL = ManimColor("#90E4C1")
LIGHTTURQUOISE = ManimColor("#7EF4CC")
LIGHTURPLE = ManimColor("#B36FF6")
LIGHTVIOLET = ManimColor("#D6B4FC")
LIGHTYELLOW = ManimColor("#FFFE7A")
LIGHTYELLOWGREEN = ManimColor("#CCFD7F")
LIGHTYELLOWISHGREEN = ManimColor("#C2FF89")
LILAC = ManimColor("#CEA2FD")
LILIAC = ManimColor("#C48EFD")
LIME = ManimColor("#AAFF32")
LIMEGREEN = ManimColor("#89FE05")
LIMEYELLOW = ManimColor("#D0FE1D")
LIPSTICK = ManimColor("#D5174E")
LIPSTICKRED = ManimColor("#C0022F")
MACARONIANDCHEESE = ManimColor("#EFB435")
MAGENTA = ManimColor("#C20078")
MAHOGANY = ManimColor("#4A0100")
MAIZE = ManimColor("#F4D054")
MANGO = ManimColor("#FFA62B")
MANILLA = ManimColor("#FFFA86")
MARIGOLD = ManimColor("#FCC006")
MARINE = ManimColor("#042E60")
MARINEBLUE = ManimColor("#01386A")
MAROON = ManimColor("#650021")
MAUVE = ManimColor("#AE7181")
MEDIUMBLUE = ManimColor("#2C6FBB")
MEDIUMBROWN = ManimColor("#7F5112")
MEDIUMGREEN = ManimColor("#39AD48")
MEDIUMGREY = ManimColor("#7D7F7C")
MEDIUMPINK = ManimColor("#F36196")
MEDIUMPURPLE = ManimColor("#9E43A2")
MELON = ManimColor("#FF7855")
MERLOT = ManimColor("#730039")
METALLICBLUE = ManimColor("#4F738E")
MIDBLUE = ManimColor("#276AB3")
MIDGREEN = ManimColor("#50A747")
MIDNIGHT = ManimColor("#03012D")
MIDNIGHTBLUE = ManimColor("#020035")
MIDNIGHTPURPLE = ManimColor("#280137")
MILITARYGREEN = ManimColor("#667C3E")
MILKCHOCOLATE = ManimColor("#7F4E1E")
MINT = ManimColor("#9FFEB0")
MINTGREEN = ManimColor("#8FFF9F")
MINTYGREEN = ManimColor("#0BF77D")
MOCHA = ManimColor("#9D7651")
MOSS = ManimColor("#769958")
MOSSGREEN = ManimColor("#658B38")
MOSSYGREEN = ManimColor("#638B27")
MUD = ManimColor("#735C12")
MUDBROWN = ManimColor("#60460F")
MUDDYBROWN = ManimColor("#886806")
MUDDYGREEN = ManimColor("#657432")
MUDDYYELLOW = ManimColor("#BFAC05")
MUDGREEN = ManimColor("#606602")
MULBERRY = ManimColor("#920A4E")
MURKYGREEN = ManimColor("#6C7A0E")
MUSHROOM = ManimColor("#BA9E88")
MUSTARD = ManimColor("#CEB301")
MUSTARDBROWN = ManimColor("#AC7E04")
MUSTARDGREEN = ManimColor("#A8B504")
MUSTARDYELLOW = ManimColor("#D2BD0A")
MUTEDBLUE = ManimColor("#3B719F")
MUTEDGREEN = ManimColor("#5FA052")
MUTEDPINK = ManimColor("#D1768F")
MUTEDPURPLE = ManimColor("#805B87")
NASTYGREEN = ManimColor("#70B23F")
NAVY = ManimColor("#01153E")
NAVYBLUE = ManimColor("#001146")
NAVYGREEN = ManimColor("#35530A")
NEONBLUE = ManimColor("#04D9FF")
NEONGREEN = ManimColor("#0CFF0C")
NEONPINK = ManimColor("#FE019A")
NEONPURPLE = ManimColor("#BC13FE")
NEONRED = ManimColor("#FF073A")
NEONYELLOW = ManimColor("#CFFF04")
NICEBLUE = ManimColor("#107AB0")
NIGHTBLUE = ManimColor("#040348")
OCEAN = ManimColor("#017B92")
OCEANBLUE = ManimColor("#03719C")
OCEANGREEN = ManimColor("#3D9973")
OCHER = ManimColor("#BF9B0C")
OCHRE = ManimColor("#BF9005")
OCRE = ManimColor("#C69C04")
OFFBLUE = ManimColor("#5684AE")
OFFGREEN = ManimColor("#6BA353")
OFFWHITE = ManimColor("#FFFFE4")
OFFYELLOW = ManimColor("#F1F33F")
OLDPINK = ManimColor("#C77986")
OLDROSE = ManimColor("#C87F89")
OLIVE = ManimColor("#6E750E")
OLIVEBROWN = ManimColor("#645403")
OLIVEDRAB = ManimColor("#6F7632")
OLIVEGREEN = ManimColor("#677A04")
OLIVEYELLOW = ManimColor("#C2B709")
ORANGE = ManimColor("#F97306")
ORANGEBROWN = ManimColor("#BE6400")
ORANGEISH = ManimColor("#FD8D49")
ORANGEPINK = ManimColor("#FF6F52")
ORANGERED = ManimColor("#FE420F")
ORANGEYBROWN = ManimColor("#B16002")
ORANGEYELLOW = ManimColor("#FFAD01")
ORANGEYRED = ManimColor("#FA4224")
ORANGEYYELLOW = ManimColor("#FDB915")
ORANGISH = ManimColor("#FC824A")
ORANGISHBROWN = ManimColor("#B25F03")
ORANGISHRED = ManimColor("#F43605")
ORCHID = ManimColor("#C875C4")
PALE = ManimColor("#FFF9D0")
PALEAQUA = ManimColor("#B8FFEB")
PALEBLUE = ManimColor("#D0FEFE")
PALEBROWN = ManimColor("#B1916E")
PALECYAN = ManimColor("#B7FFFA")
PALEGOLD = ManimColor("#FDDE6C")
PALEGREEN = ManimColor("#C7FDB5")
PALEGREY = ManimColor("#FDFDFE")
PALELAVENDER = ManimColor("#EECFFE")
PALELIGHTGREEN = ManimColor("#B1FC99")
PALELILAC = ManimColor("#E4CBFF")
PALELIME = ManimColor("#BEFD73")
PALELIMEGREEN = ManimColor("#B1FF65")
PALEMAGENTA = ManimColor("#D767AD")
PALEMAUVE = ManimColor("#FED0FC")
PALEOLIVE = ManimColor("#B9CC81")
PALEOLIVEGREEN = ManimColor("#B1D27B")
PALEORANGE = ManimColor("#FFA756")
PALEPEACH = ManimColor("#FFE5AD")
PALEPINK = ManimColor("#FFCFDC")
PALEPURPLE = ManimColor("#B790D4")
PALERED = ManimColor("#D9544D")
PALEROSE = ManimColor("#FDC1C5")
PALESALMON = ManimColor("#FFB19A")
PALESKYBLUE = ManimColor("#BDF6FE")
PALETEAL = ManimColor("#82CBB2")
PALETURQUOISE = ManimColor("#A5FBD5")
PALEVIOLET = ManimColor("#CEAEFA")
PALEYELLOW = ManimColor("#FFFF84")
PARCHMENT = ManimColor("#FEFCAF")
PASTELBLUE = ManimColor("#A2BFFE")
PASTELGREEN = ManimColor("#B0FF9D")
PASTELORANGE = ManimColor("#FF964F")
PASTELPINK = ManimColor("#FFBACD")
PASTELPURPLE = ManimColor("#CAA0FF")
PASTELRED = ManimColor("#DB5856")
PASTELYELLOW = ManimColor("#FFFE71")
PEA = ManimColor("#A4BF20")
PEACH = ManimColor("#FFB07C")
PEACHYPINK = ManimColor("#FF9A8A")
PEACOCKBLUE = ManimColor("#016795")
PEAGREEN = ManimColor("#8EAB12")
PEAR = ManimColor("#CBF85F")
PEASOUP = ManimColor("#929901")
PEASOUPGREEN = ManimColor("#94A617")
PERIWINKLE = ManimColor("#8E82FE")
PERIWINKLEBLUE = ManimColor("#8F99FB")
PERRYWINKLE = ManimColor("#8F8CE7")
PETROL = ManimColor("#005F6A")
PIGPINK = ManimColor("#E78EA5")
PINE = ManimColor("#2B5D34")
PINEGREEN = ManimColor("#0A481E")
PINK = ManimColor("#FF81C0")
PINKISH = ManimColor("#D46A7E")
PINKISHBROWN = ManimColor("#B17261")
PINKISHGREY = ManimColor("#C8ACA9")
PINKISHORANGE = ManimColor("#FF724C")
PINKISHPURPLE = ManimColor("#D648D7")
PINKISHRED = ManimColor("#F10C45")
PINKISHTAN = ManimColor("#D99B82")
PINKPURPLE = ManimColor("#EF1DE7")
PINKRED = ManimColor("#F5054F")
PINKY = ManimColor("#FC86AA")
PINKYPURPLE = ManimColor("#C94CBE")
PINKYRED = ManimColor("#FC2647")
PISSYELLOW = ManimColor("#DDD618")
PISTACHIO = ManimColor("#C0FA8B")
PLUM = ManimColor("#580F41")
PLUMPURPLE = ManimColor("#4E0550")
POISONGREEN = ManimColor("#40FD14")
POO = ManimColor("#8F7303")
POOBROWN = ManimColor("#885F01")
POOP = ManimColor("#7F5E00")
POOPBROWN = ManimColor("#7A5901")
POOPGREEN = ManimColor("#6F7C00")
POWDERBLUE = ManimColor("#B1D1FC")
POWDERPINK = ManimColor("#FFB2D0")
PRIMARYBLUE = ManimColor("#0804F9")
PRUSSIANBLUE = ManimColor("#004577")
PUCE = ManimColor("#A57E52")
PUKE = ManimColor("#A5A502")
PUKEBROWN = ManimColor("#947706")
PUKEGREEN = ManimColor("#9AAE07")
PUKEYELLOW = ManimColor("#C2BE0E")
PUMPKIN = ManimColor("#E17701")
PUMPKINORANGE = ManimColor("#FB7D07")
PUREBLUE = ManimColor("#0203E2")
PURPLE = ManimColor("#7E1E9C")
PURPLEBLUE = ManimColor("#5D21D0")
PURPLEBROWN = ManimColor("#673A3F")
PURPLEGREY = ManimColor("#866F85")
PURPLEISH = ManimColor("#98568D")
PURPLEISHBLUE = ManimColor("#6140EF")
PURPLEISHPINK = ManimColor("#DF4EC8")
PURPLEPINK = ManimColor("#D725DE")
PURPLERED = ManimColor("#990147")
PURPLEY = ManimColor("#8756E4")
PURPLEYBLUE = ManimColor("#5F34E7")
PURPLEYGREY = ManimColor("#947E94")
PURPLEYPINK = ManimColor("#C83CB9")
PURPLISH = ManimColor("#94568C")
PURPLISHBLUE = ManimColor("#601EF9")
PURPLISHBROWN = ManimColor("#6B4247")
PURPLISHGREY = ManimColor("#7A687F")
PURPLISHPINK = ManimColor("#CE5DAE")
PURPLISHRED = ManimColor("#B0054B")
PURPLY = ManimColor("#983FB2")
PURPLYBLUE = ManimColor("#661AEE")
PURPLYPINK = ManimColor("#F075E6")
PUTTY = ManimColor("#BEAE8A")
RACINGGREEN = ManimColor("#014600")
RADIOACTIVEGREEN = ManimColor("#2CFA1F")
RASPBERRY = ManimColor("#B00149")
RAWSIENNA = ManimColor("#9A6200")
RAWUMBER = ManimColor("#A75E09")
REALLYLIGHTBLUE = ManimColor("#D4FFFF")
RED = ManimColor("#E50000")
REDBROWN = ManimColor("#8B2E16")
REDDISH = ManimColor("#C44240")
REDDISHBROWN = ManimColor("#7F2B0A")
REDDISHGREY = ManimColor("#997570")
REDDISHORANGE = ManimColor("#F8481C")
REDDISHPINK = ManimColor("#FE2C54")
REDDISHPURPLE = ManimColor("#910951")
REDDYBROWN = ManimColor("#6E1005")
REDORANGE = ManimColor("#FD3C06")
REDPINK = ManimColor("#FA2A55")
REDPURPLE = ManimColor("#820747")
REDVIOLET = ManimColor("#9E0168")
REDWINE = ManimColor("#8C0034")
RICHBLUE = ManimColor("#021BF9")
RICHPURPLE = ManimColor("#720058")
ROBINEGGBLUE = ManimColor("#8AF1FE")
ROBINSEGG = ManimColor("#6DEDFD")
ROBINSEGGBLUE = ManimColor("#98EFF9")
ROSA = ManimColor("#FE86A4")
ROSE = ManimColor("#CF6275")
ROSEPINK = ManimColor("#F7879A")
ROSERED = ManimColor("#BE013C")
ROSYPINK = ManimColor("#F6688E")
ROGUE = ManimColor("#AB1239")
ROYAL = ManimColor("#0C1793")
ROYALBLUE = ManimColor("#0504AA")
ROYALPURPLE = ManimColor("#4B006E")
RUBY = ManimColor("#CA0147")
RUSSET = ManimColor("#A13905")
RUST = ManimColor("#A83C09")
RUSTBROWN = ManimColor("#8B3103")
RUSTORANGE = ManimColor("#C45508")
RUSTRED = ManimColor("#AA2704")
RUSTYORANGE = ManimColor("#CD5909")
RUSTYRED = ManimColor("#AF2F0D")
SAFFRON = ManimColor("#FEB209")
SAGE = ManimColor("#87AE73")
SAGEGREEN = ManimColor("#88B378")
SALMON = ManimColor("#FF796C")
SALMONPINK = ManimColor("#FE7B7C")
SAND = ManimColor("#E2CA76")
SANDBROWN = ManimColor("#CBA560")
SANDSTONE = ManimColor("#C9AE74")
SANDY = ManimColor("#F1DA7A")
SANDYBROWN = ManimColor("#C4A661")
SANDYELLOW = ManimColor("#FCE166")
SANDYYELLOW = ManimColor("#FDEE73")
SAPGREEN = ManimColor("#5C8B15")
SAPPHIRE = ManimColor("#2138AB")
SCARLET = ManimColor("#BE0119")
SEA = ManimColor("#3C9992")
SEABLUE = ManimColor("#047495")
SEAFOAM = ManimColor("#80F9AD")
SEAFOAMBLUE = ManimColor("#78D1B6")
SEAFOAMGREEN = ManimColor("#7AF9AB")
SEAGREEN = ManimColor("#53FCA1")
SEAWEED = ManimColor("#18D17B")
SEAWEEDGREEN = ManimColor("#35AD6B")
SEPIA = ManimColor("#985E2B")
SHAMROCK = ManimColor("#01B44C")
SHAMROCKGREEN = ManimColor("#02C14D")
SHIT = ManimColor("#7F5F00")
SHITBROWN = ManimColor("#7B5804")
SHITGREEN = ManimColor("#758000")
SHOCKINGPINK = ManimColor("#FE02A2")
SICKGREEN = ManimColor("#9DB92C")
SICKLYGREEN = ManimColor("#94B21C")
SICKLYYELLOW = ManimColor("#D0E429")
SIENNA = ManimColor("#A9561E")
SILVER = ManimColor("#C5C9C7")
SKY = ManimColor("#82CAFC")
SKYBLUE = ManimColor("#75BBFD")
SLATE = ManimColor("#516572")
SLATEBLUE = ManimColor("#5B7C99")
SLATEGREEN = ManimColor("#658D6D")
SLATEGREY = ManimColor("#59656D")
SLIMEGREEN = ManimColor("#99CC04")
SNOT = ManimColor("#ACBB0D")
SNOTGREEN = ManimColor("#9DC100")
SOFTBLUE = ManimColor("#6488EA")
SOFTGREEN = ManimColor("#6FC276")
SOFTPINK = ManimColor("#FDB0C0")
SOFTPURPLE = ManimColor("#A66FB5")
SPEARMINT = ManimColor("#1EF876")
SPRINGGREEN = ManimColor("#A9F971")
SPRUCE = ManimColor("#0A5F38")
SQUASH = ManimColor("#F2AB15")
STEEL = ManimColor("#738595")
STEELBLUE = ManimColor("#5A7D9A")
STEELGREY = ManimColor("#6F828A")
STONE = ManimColor("#ADA587")
STORMYBLUE = ManimColor("#507B9C")
STRAW = ManimColor("#FCF679")
STRAWBERRY = ManimColor("#FB2943")
STRONGBLUE = ManimColor("#0C06F7")
STRONGPINK = ManimColor("#FF0789")
SUNFLOWER = ManimColor("#FFC512")
SUNFLOWERYELLOW = ManimColor("#FFDA03")
SUNNYYELLOW = ManimColor("#FFF917")
SUNSHINEYELLOW = ManimColor("#FFFD37")
SUNYELLOW = ManimColor("#FFDF22")
SWAMP = ManimColor("#698339")
SWAMPGREEN = ManimColor("#748500")
TAN = ManimColor("#D1B26F")
TANBROWN = ManimColor("#AB7E4C")
TANGERINE = ManimColor("#FF9408")
TANGREEN = ManimColor("#A9BE70")
TAUPE = ManimColor("#B9A281")
TEA = ManimColor("#65AB7C")
TEAGREEN = ManimColor("#BDF8A3")
TEAL = ManimColor("#029386")
TEALBLUE = ManimColor("#01889F")
TEALGREEN = ManimColor("#25A36F")
TEALISH = ManimColor("#24BCA8")
TEALISHGREEN = ManimColor("#0CDC73")
TERRACOTA = ManimColor("#CB6843")
TERRACOTTA = ManimColor("#C9643B")
TIFFANYBLUE = ManimColor("#7BF2DA")
TOMATO = ManimColor("#EF4026")
TOMATORED = ManimColor("#EC2D01")
TOPAZ = ManimColor("#13BBAF")
TOUPE = ManimColor("#C7AC7D")
TOXICGREEN = ManimColor("#61DE2A")
TREEGREEN = ManimColor("#2A7E19")
TRUEBLUE = ManimColor("#010FCC")
TRUEGREEN = ManimColor("#089404")
TURQUOISE = ManimColor("#06C2AC")
TURQUOISEBLUE = ManimColor("#06B1C4")
TURQUOISEGREEN = ManimColor("#04F489")
TURTLEGREEN = ManimColor("#75B84F")
TWILIGHT = ManimColor("#4E518B")
TWILIGHTBLUE = ManimColor("#0A437A")
UGLYBLUE = ManimColor("#31668A")
UGLYBROWN = ManimColor("#7D7103")
UGLYGREEN = ManimColor("#7A9703")
UGLYPINK = ManimColor("#CD7584")
UGLYPURPLE = ManimColor("#A442A0")
UGLYYELLOW = ManimColor("#D0C101")
ULTRAMARINE = ManimColor("#2000B1")
ULTRAMARINEBLUE = ManimColor("#1805DB")
UMBER = ManimColor("#B26400")
VELVET = ManimColor("#750851")
VERMILION = ManimColor("#F4320C")
VERYDARKBLUE = ManimColor("#000133")
VERYDARKBROWN = ManimColor("#1D0200")
VERYDARKGREEN = ManimColor("#062E03")
VERYDARKPURPLE = ManimColor("#2A0134")
VERYLIGHTBLUE = ManimColor("#D5FFFF")
VERYLIGHTBROWN = ManimColor("#D3B683")
VERYLIGHTGREEN = ManimColor("#D1FFBD")
VERYLIGHTPINK = ManimColor("#FFF4F2")
VERYLIGHTPURPLE = ManimColor("#F6CEFC")
VERYPALEBLUE = ManimColor("#D6FFFE")
VERYPALEGREEN = ManimColor("#CFFDBC")
VIBRANTBLUE = ManimColor("#0339F8")
VIBRANTGREEN = ManimColor("#0ADD08")
VIBRANTPURPLE = ManimColor("#AD03DE")
VIOLET = ManimColor("#9A0EEA")
VIOLETBLUE = ManimColor("#510AC9")
VIOLETPINK = ManimColor("#FB5FFC")
VIOLETRED = ManimColor("#A50055")
VIRIDIAN = ManimColor("#1E9167")
VIVIDBLUE = ManimColor("#152EFF")
VIVIDGREEN = ManimColor("#2FEF10")
VIVIDPURPLE = ManimColor("#9900FA")
VOMIT = ManimColor("#A2A415")
VOMITGREEN = ManimColor("#89A203")
VOMITYELLOW = ManimColor("#C7C10C")
WARMBLUE = ManimColor("#4B57DB")
WARMBROWN = ManimColor("#964E02")
WARMGREY = ManimColor("#978A84")
WARMPINK = ManimColor("#FB5581")
WARMPURPLE = ManimColor("#952E8F")
WASHEDOUTGREEN = ManimColor("#BCF5A6")
WATERBLUE = ManimColor("#0E87CC")
WATERMELON = ManimColor("#FD4659")
WEIRDGREEN = ManimColor("#3AE57F")
WHEAT = ManimColor("#FBDD7E")
WHITE = ManimColor("#FFFFFF")
WINDOWSBLUE = ManimColor("#3778BF")
WINE = ManimColor("#80013F")
WINERED = ManimColor("#7B0323")
WINTERGREEN = ManimColor("#20F986")
WISTERIA = ManimColor("#A87DC2")
YELLOW = ManimColor("#FFFF14")
YELLOWBROWN = ManimColor("#B79400")
YELLOWGREEN = ManimColor("#BBF90F")
YELLOWISH = ManimColor("#FAEE66")
YELLOWISHBROWN = ManimColor("#9B7A01")
YELLOWISHGREEN = ManimColor("#B0DD16")
YELLOWISHORANGE = ManimColor("#FFAB0F")
YELLOWISHTAN = ManimColor("#FCFC81")
YELLOWOCHRE = ManimColor("#CB9D06")
YELLOWORANGE = ManimColor("#FCB001")
YELLOWTAN = ManimColor("#FFE36E")
YELLOWYBROWN = ManimColor("#AE8B0C")
YELLOWYGREEN = ManimColor("#BFF128")
