; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; Test calling functions with multiple return values (LLVM ABI extension)
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 -mattr=soft-float \
; RUN:   | FileCheck %s --check-prefix=SOFT-FLOAT

; Up to eight vector return values fit into VRs.
declare { <2 x double>, <2 x double>, <2 x double>, <2 x double>,
          <2 x double>, <2 x double>, <2 x double>, <2 x double> } @bar1()

define <2 x double> @f1() {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    stmg %r14, %r15, 112(%r15)
; CHECK-NEXT:    .cfi_offset %r14, -48
; CHECK-NEXT:    .cfi_offset %r15, -40
; CHECK-NEXT:    aghi %r15, -160
; CHECK-NEXT:    .cfi_def_cfa_offset 320
; CHECK-NEXT:    brasl %r14, bar1@PLT
; CHECK-NEXT:    vlr %v24, %v31
; CHECK-NEXT:    lmg %r14, %r15, 272(%r15)
; CHECK-NEXT:    br %r14
;
; SOFT-FLOAT-LABEL: f1:
; SOFT-FLOAT:       # %bb.0:
; SOFT-FLOAT-NEXT:    stmg %r14, %r15, 112(%r15)
; SOFT-FLOAT-NEXT:    .cfi_offset %r14, -48
; SOFT-FLOAT-NEXT:    .cfi_offset %r15, -40
; SOFT-FLOAT-NEXT:    aghi %r15, -288
; SOFT-FLOAT-NEXT:    .cfi_def_cfa_offset 448
; SOFT-FLOAT-NEXT:    la %r2, 160(%r15)
; SOFT-FLOAT-NEXT:    brasl %r14, bar1@PLT
; SOFT-FLOAT-NEXT:    lg %r3, 280(%r15)
; SOFT-FLOAT-NEXT:    lg %r2, 272(%r15)
; SOFT-FLOAT-NEXT:    lmg %r14, %r15, 400(%r15)
; SOFT-FLOAT-NEXT:    br %r14

  %mret = call { <2 x double>, <2 x double>,
                 <2 x double>, <2 x double>,
                 <2 x double>, <2 x double>,
                 <2 x double>, <2 x double> } @bar1()
  %ret = extractvalue { <2 x double>, <2 x double>,
                        <2 x double>, <2 x double>,
                        <2 x double>, <2 x double>,
                        <2 x double>, <2 x double> } %mret, 7
  ret <2 x double> %ret
}

; More than eight vector return values use sret.
declare { <2 x double>, <2 x double>, <2 x double>, <2 x double>,
          <2 x double>, <2 x double>, <2 x double>, <2 x double>,
          <2 x double> } @bar2()

define <2 x double> @f2() {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    stmg %r14, %r15, 112(%r15)
; CHECK-NEXT:    .cfi_offset %r14, -48
; CHECK-NEXT:    .cfi_offset %r15, -40
; CHECK-NEXT:    aghi %r15, -304
; CHECK-NEXT:    .cfi_def_cfa_offset 464
; CHECK-NEXT:    la %r2, 160(%r15)
; CHECK-NEXT:    brasl %r14, bar2@PLT
; CHECK-NEXT:    vl %v24, 288(%r15), 3
; CHECK-NEXT:    lmg %r14, %r15, 416(%r15)
; CHECK-NEXT:    br %r14
;
; SOFT-FLOAT-LABEL: f2:
; SOFT-FLOAT:       # %bb.0:
; SOFT-FLOAT-NEXT:    stmg %r14, %r15, 112(%r15)
; SOFT-FLOAT-NEXT:    .cfi_offset %r14, -48
; SOFT-FLOAT-NEXT:    .cfi_offset %r15, -40
; SOFT-FLOAT-NEXT:    aghi %r15, -304
; SOFT-FLOAT-NEXT:    .cfi_def_cfa_offset 464
; SOFT-FLOAT-NEXT:    la %r2, 160(%r15)
; SOFT-FLOAT-NEXT:    brasl %r14, bar2@PLT
; SOFT-FLOAT-NEXT:    lg %r3, 296(%r15)
; SOFT-FLOAT-NEXT:    lg %r2, 288(%r15)
; SOFT-FLOAT-NEXT:    lmg %r14, %r15, 416(%r15)
; SOFT-FLOAT-NEXT:    br %r14

  %mret = call { <2 x double>, <2 x double>,
                 <2 x double>, <2 x double>,
                 <2 x double>, <2 x double>,
                 <2 x double>, <2 x double>,
                 <2 x double> } @bar2()
  %ret = extractvalue { <2 x double>, <2 x double>,
                        <2 x double>, <2 x double>,
                        <2 x double>, <2 x double>,
                        <2 x double>, <2 x double>,
                        <2 x double> } %mret, 8
  ret <2 x double> %ret
}
