; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple powerpc-ibm-aix-xcoff -stop-after=machine-cp -mcpu=pwr4 \
; RUN:  -mattr=-altivec -verify-machineinstrs < %s | \
; RUN: FileCheck --check-prefixes=32BIT %s

; RUN: llc -mtriple powerpc64-ibm-aix-xcoff -stop-after=machine-cp -mcpu=pwr4 \
; RUN:  -mattr=-altivec -verify-machineinstrs < %s | \
; RUN: FileCheck --check-prefixes=64BIT %s

%struct.S0 = type {}

%struct.S1 = type { [1 x i8] }
@gS1 = external global %struct.S1, align 1

define void @call_test_byval_1Byte() {
  ; 32BIT-LABEL: name: call_test_byval_1Byte
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @gS1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r3 = LBZ 0, killed renamable $r3 :: (load (s8))
  ; 32BIT-NEXT:   renamable $r3 = RLWINM killed renamable $r3, 24, 0, 7
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_byval_1Byte>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r2, implicit-def $r1, implicit-def dead $r3
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_byval_1Byte
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @gS1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x3 = LBZ8 0, killed renamable $x3 :: (load (s8))
  ; 64BIT-NEXT:   renamable $x3 = RLDICR killed renamable $x3, 56, 7
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_byval_1Byte>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x2, implicit-def $r1, implicit-def dead $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %s0 = alloca %struct.S0, align 8
  %call = call zeroext i8 @test_byval_1Byte(ptr byval(%struct.S0) align 1 %s0, ptr byval(%struct.S1) align 1 @gS1)
  ret void
}

define zeroext i8 @test_byval_1Byte(ptr byval(%struct.S0) align 1 %s0, ptr byval(%struct.S1) align 1 %s) {
  ; 32BIT-LABEL: name: test_byval_1Byte
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $r3
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   renamable $r4 = COPY $r3
  ; 32BIT-NEXT:   renamable $r3 = RLWINM $r3, 8, 24, 31
  ; 32BIT-NEXT:   STW killed renamable $r4, 0, %fixed-stack.0 :: (store (s32) into %fixed-stack.0, align 8)
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3
  ;
  ; 64BIT-LABEL: name: test_byval_1Byte
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $x3
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   renamable $x4 = COPY $x3
  ; 64BIT-NEXT:   renamable $x3 = RLDICL $x3, 8, 56
  ; 64BIT-NEXT:   STD killed renamable $x4, 0, %fixed-stack.0 :: (store (s64) into %fixed-stack.0, align 16)
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  %0 = load i8, ptr %s, align 1
  ret i8 %0
}

@f = common global float 0.000000e+00, align 4

%struct.S2 = type { [2 x i8] }

@gS2 = external global %struct.S2, align 1

define void @call_test_byval_2Byte() {
  ; 32BIT-LABEL: name: call_test_byval_2Byte
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @f, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f1 = LFS 0, killed renamable $r3 :: (dereferenceable load (s32) from @f)
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @gS2, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r3 = LHZ 0, killed renamable $r3 :: (load (s16))
  ; 32BIT-NEXT:   renamable $r5 = RLWINM killed renamable $r3, 16, 0, 15
  ; 32BIT-NEXT:   $r3 = LI 42
  ; 32BIT-NEXT:   $f2 = COPY renamable $f1
  ; 32BIT-NEXT:   $r7 = LI 43
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_byval_2Byte>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $f1, implicit $r5, implicit killed $f2, implicit killed $r7, implicit $r2, implicit-def $r1, implicit-def dead $r3
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_byval_2Byte
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @f, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f1 = LFS 0, killed renamable $x3 :: (dereferenceable load (s32) from @f)
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @gS2, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x3 = LHZ8 0, killed renamable $x3 :: (load (s16))
  ; 64BIT-NEXT:   renamable $x5 = RLDICR killed renamable $x3, 48, 15
  ; 64BIT-NEXT:   $x3 = LI8 42
  ; 64BIT-NEXT:   $f2 = COPY renamable $f1
  ; 64BIT-NEXT:   $x7 = LI8 43
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_byval_2Byte>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $f1, implicit $x5, implicit killed $f2, implicit killed $x7, implicit $x2, implicit-def $r1, implicit-def dead $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %0 = load float, ptr @f, align 4
  %call = call zeroext i8 @test_byval_2Byte(i32 signext 42, float %0, ptr byval(%struct.S2) align 1 @gS2, float %0, i32 signext 43)
  ret void
}

define zeroext i8 @test_byval_2Byte(i32, float, ptr byval(%struct.S2) align 1 %s, float, i32) {
  ; 32BIT-LABEL: name: test_byval_2Byte
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $r5
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   STW killed renamable $r5, 0, %fixed-stack.0 :: (store (s32) into %fixed-stack.0, align 16)
  ; 32BIT-NEXT:   renamable $r3 = LBZ 1, %fixed-stack.0 :: (dereferenceable load (s8) from %ir.arrayidx)
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3
  ;
  ; 64BIT-LABEL: name: test_byval_2Byte
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $x5
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   STD killed renamable $x5, 0, %fixed-stack.0 :: (store (s64) into %fixed-stack.0, align 16)
  ; 64BIT-NEXT:   renamable $x3 = LBZ8 1, %fixed-stack.0 :: (dereferenceable load (s8) from %ir.arrayidx)
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  %arrayidx = getelementptr inbounds %struct.S2, ptr %s, i32 0, i32 0, i32 1
  %4 = load i8, ptr %arrayidx, align 1
  ret i8 %4
}

%struct.S3 = type <{ i8, i16 }>
@gS3 = external global %struct.S3, align 1

define void @call_test_byval_3Byte() {
  ; 32BIT-LABEL: name: call_test_byval_3Byte
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 60, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   renamable $r3 = LI 42
  ; 32BIT-NEXT:   renamable $r4 = LWZtoc @gS3, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   STW killed renamable $r3, 56, $r1 :: (store (s32) into stack + 56, align 8, basealign 16)
  ; 32BIT-NEXT:   renamable $r3 = LBZ 2, renamable $r4 :: (load (s8))
  ; 32BIT-NEXT:   renamable $r4 = LHZ 0, killed renamable $r4 :: (load (s16))
  ; 32BIT-NEXT:   renamable $r10 = RLWINM killed renamable $r3, 8, 16, 23
  ; 32BIT-NEXT:   renamable $r10 = RLWIMI killed renamable $r10, killed renamable $r4, 16, 0, 15
  ; 32BIT-NEXT:   $r3 = LI 1
  ; 32BIT-NEXT:   $r4 = LI 2
  ; 32BIT-NEXT:   $r5 = LI 3
  ; 32BIT-NEXT:   $r6 = LI 4
  ; 32BIT-NEXT:   $r7 = LI 5
  ; 32BIT-NEXT:   $r8 = LI 6
  ; 32BIT-NEXT:   $r9 = LI 7
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_byval_3Byte>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r4, implicit killed $r5, implicit killed $r6, implicit killed $r7, implicit killed $r8, implicit killed $r9, implicit $r10, implicit $r2, implicit-def $r1, implicit-def dead $r3
  ; 32BIT-NEXT:   ADJCALLSTACKUP 60, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_byval_3Byte
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 120, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   renamable $x3 = LI8 42
  ; 64BIT-NEXT:   renamable $x4 = LDtoc @gS3, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   STD killed renamable $x3, 112, $x1 :: (store (s64) into stack + 112, align 16)
  ; 64BIT-NEXT:   renamable $x3 = LBZ8 2, renamable $x4 :: (load (s8))
  ; 64BIT-NEXT:   renamable $x4 = LHZ8 0, killed renamable $x4 :: (load (s16))
  ; 64BIT-NEXT:   renamable $x10 = RLDIC killed renamable $x3, 40, 16
  ; 64BIT-NEXT:   renamable $x10 = RLDIMI killed renamable $x10, killed renamable $x4, 48, 0
  ; 64BIT-NEXT:   $x3 = LI8 1
  ; 64BIT-NEXT:   $x4 = LI8 2
  ; 64BIT-NEXT:   $x5 = LI8 3
  ; 64BIT-NEXT:   $x6 = LI8 4
  ; 64BIT-NEXT:   $x7 = LI8 5
  ; 64BIT-NEXT:   $x8 = LI8 6
  ; 64BIT-NEXT:   $x9 = LI8 7
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_byval_3Byte>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x4, implicit killed $x5, implicit killed $x6, implicit killed $x7, implicit killed $x8, implicit killed $x9, implicit $x10, implicit $x2, implicit-def $r1, implicit-def dead $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 120, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %call = call zeroext i16 @test_byval_3Byte(i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, ptr byval(%struct.S3) align 1 @gS3, i32 42)
  ret void
}

define zeroext i16 @test_byval_3Byte(i32, i32, i32, i32, i32, i32, i32, ptr byval(%struct.S3) align 1 %s, i32) {
  ; 32BIT-LABEL: name: test_byval_3Byte
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $r10
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   STW killed renamable $r10, 0, %fixed-stack.1 :: (store (s32) into %fixed-stack.1)
  ; 32BIT-NEXT:   renamable $r3 = LHZ 1, %fixed-stack.1 :: (dereferenceable load (s16) from %ir.gep, align 1)
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3
  ;
  ; 64BIT-LABEL: name: test_byval_3Byte
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $x10
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   STD killed renamable $x10, 0, %fixed-stack.1 :: (store (s64) into %fixed-stack.1)
  ; 64BIT-NEXT:   renamable $x3 = LHZ8 1, %fixed-stack.1 :: (dereferenceable load (s16) from %ir.gep, align 1)
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  %gep = getelementptr inbounds %struct.S3, ptr %s, i32 0, i32 1
  %8 = load i16, ptr %gep, align 1
  ret i16 %8
}

%struct.S4 = type { [4 x i8] }
%struct.S4A = type { i32 }

@gS4 = external global %struct.S4, align 1

define void @call_test_byval_4Byte() {
  ; 32BIT-LABEL: name: call_test_byval_4Byte
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @gS4, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r3 = LWZ 0, killed renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r4 = LWZ 0, %stack.1.s4a :: (load (s32) from %stack.1.s4a, align 8)
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_byval_4Byte>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r4, implicit $r2, implicit-def $r1, implicit-def dead $r3
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_byval_4Byte
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @gS4, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x3 = LWZ8 0, killed renamable $x3 :: (load (s32))
  ; 64BIT-NEXT:   renamable $x4 = LWZ8 0, %stack.1.s4a :: (load (s32) from %stack.1.s4a, align 8)
  ; 64BIT-NEXT:   renamable $x3 = RLDICR killed renamable $x3, 32, 31
  ; 64BIT-NEXT:   renamable $x4 = RLDICR killed renamable $x4, 32, 31
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_byval_4Byte>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x4, implicit $x2, implicit-def $r1, implicit-def dead $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %s0 = alloca %struct.S0, align 8
  %s4a = alloca %struct.S4A, align 8
  %call = call signext i32 @test_byval_4Byte(ptr byval(%struct.S4) align 1 @gS4, ptr byval(%struct.S0) align 1 %s0, ptr byval(%struct.S4A) align 4 %s4a)
  ret void
}

define signext i32 @test_byval_4Byte(ptr byval(%struct.S4) align 1 %s, ptr byval(%struct.S0) align 1, ptr byval(%struct.S4A) align 4 %s4a) {
  ; 32BIT-LABEL: name: test_byval_4Byte
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $r3, $r4
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   STW renamable $r3, 0, %fixed-stack.2 :: (store (s32) into %fixed-stack.2, align 8)
  ; 32BIT-NEXT:   renamable $r3 = RLWINM killed renamable $r3, 0, 24, 31
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 renamable $r4, killed renamable $r3
  ; 32BIT-NEXT:   STW killed renamable $r4, 0, %fixed-stack.0 :: (store (s32) into %fixed-stack.0)
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3
  ;
  ; 64BIT-LABEL: name: test_byval_4Byte
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $x3, $x4
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   STD killed renamable $x3, 0, %fixed-stack.2 :: (store (s64) into %fixed-stack.2, align 16)
  ; 64BIT-NEXT:   STD renamable $x4, 0, %fixed-stack.0 :: (store (s64) into %fixed-stack.0)
  ; 64BIT-NEXT:   renamable $r3 = LBZ 3, %fixed-stack.2 :: (dereferenceable load (s8) from %ir.arrayidx)
  ; 64BIT-NEXT:   renamable $x4 = RLDICL killed renamable $x4, 32, 32
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 renamable $r4, killed renamable $r3, implicit killed $x4
  ; 64BIT-NEXT:   renamable $x3 = EXTSW_32_64 killed renamable $r3
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  %arrayidx = getelementptr inbounds %struct.S4, ptr %s, i32 0, i32 0, i32 3
  %1 = load i8, ptr %arrayidx, align 1
  %2 = load i32, ptr %s4a, align 4
  %conv = zext i8 %1 to i32
  %add = add nsw i32 %2, %conv
  ret i32 %add
}

%struct.S5 = type { [5 x i8] }

@gS5 = external global %struct.S5, align 1

define void @call_test_byval_5Byte() {
  ; 32BIT-LABEL: name: call_test_byval_5Byte
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @gS5, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r4 = LBZ 4, renamable $r3 :: (load (s8))
  ; 32BIT-NEXT:   renamable $r3 = LWZ 0, killed renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r4 = RLWINM killed renamable $r4, 24, 0, 7
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_byval_5Byte[PR]>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r4, implicit $r2, implicit-def $r1, implicit-def dead $r3
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_byval_5Byte
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @gS5, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x4 = LBZ8 4, renamable $x3 :: (load (s8))
  ; 64BIT-NEXT:   renamable $x5 = LWZ8 0, killed renamable $x3 :: (load (s32))
  ; 64BIT-NEXT:   renamable $x3 = RLWINM8 killed renamable $x4, 24, 0, 7
  ; 64BIT-NEXT:   renamable $x3 = RLDIMI killed renamable $x3, killed renamable $x5, 32, 0
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_byval_5Byte[PR]>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x2, implicit-def $r1, implicit-def dead $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %call = call zeroext i8 @test_byval_5Byte(ptr byval(%struct.S5) align 1 @gS5)
  ret void
}

declare zeroext i8 @test_byval_5Byte(ptr byval(%struct.S5) align 1)

%struct.S6 = type { [6 x i8] }

@gS6 = external global %struct.S6, align 1

define void @call_test_byval_6Byte() {
  ; 32BIT-LABEL: name: call_test_byval_6Byte
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @gS6, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r4 = LHZ 4, renamable $r3 :: (load (s16))
  ; 32BIT-NEXT:   renamable $r3 = LWZ 0, killed renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r4 = RLWINM killed renamable $r4, 16, 0, 15
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_byval_6Byte[PR]>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r4, implicit $r2, implicit-def $r1, implicit-def dead $r3
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_byval_6Byte
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @gS6, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x4 = LHZ8 4, renamable $x3 :: (load (s16))
  ; 64BIT-NEXT:   renamable $x5 = LWZ8 0, killed renamable $x3 :: (load (s32))
  ; 64BIT-NEXT:   renamable $x3 = RLWINM8 killed renamable $x4, 16, 0, 15
  ; 64BIT-NEXT:   renamable $x3 = RLDIMI killed renamable $x3, killed renamable $x5, 32, 0
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_byval_6Byte[PR]>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x2, implicit-def $r1, implicit-def dead $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %call = call zeroext i8 @test_byval_6Byte(ptr byval(%struct.S6) align 1 @gS6)
  ret void
}

declare zeroext i8 @test_byval_6Byte(ptr byval(%struct.S6) align 1)

%struct.S7 = type { [7 x i8] }

@gS7 = external global %struct.S7, align 1

define void @call_test_byval_7Byte() {
  ; 32BIT-LABEL: name: call_test_byval_7Byte
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @gS7, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r5 = LHZ 4, renamable $r3 :: (load (s16))
  ; 32BIT-NEXT:   renamable $r4 = LBZ 6, renamable $r3 :: (load (s8))
  ; 32BIT-NEXT:   renamable $r3 = LWZ 0, killed renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r4 = RLWINM killed renamable $r4, 8, 16, 23
  ; 32BIT-NEXT:   renamable $r4 = RLWIMI killed renamable $r4, killed renamable $r5, 16, 0, 15
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_byval_7Byte[PR]>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r4, implicit $r2, implicit-def $r1, implicit-def dead $r3
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_byval_7Byte
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @gS7, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x4 = LHZ8 4, renamable $x3 :: (load (s16))
  ; 64BIT-NEXT:   renamable $x5 = LBZ8 6, renamable $x3 :: (load (s8))
  ; 64BIT-NEXT:   renamable $x6 = LWZ8 0, killed renamable $x3 :: (load (s32))
  ; 64BIT-NEXT:   renamable $x3 = RLWINM8 killed renamable $x5, 8, 16, 23
  ; 64BIT-NEXT:   renamable $x3 = RLWIMI8 killed renamable $x3, killed renamable $x4, 16, 0, 15
  ; 64BIT-NEXT:   renamable $x3 = RLDIMI killed renamable $x3, killed renamable $x6, 32, 0
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_byval_7Byte[PR]>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x2, implicit-def $r1, implicit-def dead $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %call = call zeroext i8 @test_byval_7Byte(ptr byval(%struct.S7) align 1 @gS7)
  ret void
}

declare zeroext i8 @test_byval_7Byte(ptr byval(%struct.S7) align 1)

%struct.S8 = type { [8 x i8] }

@gS8 = external global %struct.S8, align 1

define void @call_test_byval_8Byte() {
  ; 32BIT-LABEL: name: call_test_byval_8Byte
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @gS8, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r4 = LWZ 4, renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r3 = LWZ 0, killed renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_byval_8Byte[PR]>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r4, implicit $r2, implicit-def $r1, implicit-def dead $r3
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_byval_8Byte
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @gS8, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x3 = LD 0, killed renamable $x3 :: (load (s64))
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_byval_8Byte[PR]>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x2, implicit-def $r1, implicit-def dead $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %call = call zeroext i8 @test_byval_8Byte(ptr byval(%struct.S8) align 1 @gS8)
  ret void
}

declare zeroext i8 @test_byval_8Byte(ptr byval(%struct.S8) align 1)

%struct.S32 = type { [32 x i8] }

@gS32 = external global %struct.S32, align 1

define void @call_test_byval_32Byte() {
  ; 32BIT-LABEL: name: call_test_byval_32Byte
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @gS32, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r10 = LWZ 28, renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r9 = LWZ 24, renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r8 = LWZ 20, renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r7 = LWZ 16, renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r6 = LWZ 12, renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r5 = LWZ 8, renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r4 = LWZ 4, renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r3 = LWZ 0, killed renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_byval_32Byte>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r4, implicit $r5, implicit $r6, implicit $r7, implicit $r8, implicit $r9, implicit $r10, implicit $r2, implicit-def $r1, implicit-def dead $r3
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_byval_32Byte
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @gS32, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x6 = LD 24, renamable $x3 :: (load (s64))
  ; 64BIT-NEXT:   renamable $x5 = LD 16, renamable $x3 :: (load (s64))
  ; 64BIT-NEXT:   renamable $x4 = LD 8, renamable $x3 :: (load (s64))
  ; 64BIT-NEXT:   renamable $x3 = LD 0, killed renamable $x3 :: (load (s64))
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_byval_32Byte>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x4, implicit $x5, implicit $x6, implicit $x2, implicit-def $r1, implicit-def dead $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %call = call zeroext i8 @test_byval_32Byte(ptr byval(%struct.S32) align 1 @gS32)
  ret void
}

define zeroext i8 @test_byval_32Byte(ptr byval(%struct.S32) align 1 %s) {
  ; 32BIT-LABEL: name: test_byval_32Byte
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $r3, $r4, $r5, $r6, $r7, $r8, $r9, $r10
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   STW killed renamable $r8, 20, %fixed-stack.0 :: (store (s32) into %fixed-stack.0 + 20)
  ; 32BIT-NEXT:   STW killed renamable $r3, 0, %fixed-stack.0 :: (store (s32) into %fixed-stack.0, align 8)
  ; 32BIT-NEXT:   STW killed renamable $r4, 4, %fixed-stack.0 :: (store (s32) into %fixed-stack.0 + 4)
  ; 32BIT-NEXT:   STW killed renamable $r5, 8, %fixed-stack.0 :: (store (s32) into %fixed-stack.0 + 8, align 8)
  ; 32BIT-NEXT:   STW killed renamable $r6, 12, %fixed-stack.0 :: (store (s32) into %fixed-stack.0 + 12)
  ; 32BIT-NEXT:   STW killed renamable $r7, 16, %fixed-stack.0 :: (store (s32) into %fixed-stack.0 + 16, align 8)
  ; 32BIT-NEXT:   renamable $r3 = LBZ 21, %fixed-stack.0 :: (dereferenceable load (s8) from %ir.arrayidx)
  ; 32BIT-NEXT:   STW killed renamable $r9, 24, %fixed-stack.0 :: (store (s32) into %fixed-stack.0 + 24, align 8)
  ; 32BIT-NEXT:   STW killed renamable $r10, 28, %fixed-stack.0 :: (store (s32) into %fixed-stack.0 + 28)
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3
  ;
  ; 64BIT-LABEL: name: test_byval_32Byte
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $x3, $x4, $x5, $x6
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   STD killed renamable $x5, 16, %fixed-stack.0 :: (store (s64) into %fixed-stack.0 + 16, align 16)
  ; 64BIT-NEXT:   STD killed renamable $x3, 0, %fixed-stack.0 :: (store (s64) into %fixed-stack.0, align 16)
  ; 64BIT-NEXT:   renamable $x3 = LBZ8 21, %fixed-stack.0 :: (dereferenceable load (s8) from %ir.arrayidx)
  ; 64BIT-NEXT:   STD killed renamable $x4, 8, %fixed-stack.0 :: (store (s64) into %fixed-stack.0 + 8)
  ; 64BIT-NEXT:   STD killed renamable $x6, 24, %fixed-stack.0 :: (store (s64) into %fixed-stack.0 + 24)
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  %arrayidx = getelementptr inbounds %struct.S32, ptr %s, i32 0, i32 0, i32 21
  %0 = load i8, ptr %arrayidx, align 1
  ret i8 %0
}

; The ByVal handling produces dead stores. See `LowerFormalArguments_AIX` for
; details on why.

%struct.S31 = type <{ float, i32, i64, double, i32, i16, i8 }>

@gS31 = external global %struct.S31, align 1

define void @call_test_byval_31Byte() {
  ; 32BIT-LABEL: name: call_test_byval_31Byte
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @gS31, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r11 = LHZ 28, renamable $r3 :: (load (s16))
  ; 32BIT-NEXT:   renamable $r10 = LBZ 30, renamable $r3 :: (load (s8))
  ; 32BIT-NEXT:   renamable $r9 = LWZ 24, renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r8 = LWZ 20, renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r7 = LWZ 16, renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r6 = LWZ 12, renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r5 = LWZ 8, renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r4 = LWZ 4, renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r3 = LWZ 0, killed renamable $r3 :: (load (s32))
  ; 32BIT-NEXT:   renamable $r10 = RLWINM killed renamable $r10, 8, 16, 23
  ; 32BIT-NEXT:   renamable $r10 = RLWIMI killed renamable $r10, killed renamable $r11, 16, 0, 15
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_byval_31Byte>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r4, implicit $r5, implicit $r6, implicit $r7, implicit $r8, implicit $r9, implicit $r10, implicit $r2, implicit-def $r1, implicit-def dead $f1
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_byval_31Byte
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @gS31, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x7 = LHZ8 28, renamable $x3 :: (load (s16))
  ; 64BIT-NEXT:   renamable $x6 = LBZ8 30, renamable $x3 :: (load (s8))
  ; 64BIT-NEXT:   renamable $x8 = LWZ8 24, renamable $x3 :: (load (s32))
  ; 64BIT-NEXT:   renamable $x5 = LD 16, renamable $x3 :: (load (s64))
  ; 64BIT-NEXT:   renamable $x4 = LD 8, renamable $x3 :: (load (s64))
  ; 64BIT-NEXT:   renamable $x6 = RLWINM8 killed renamable $x6, 8, 16, 23
  ; 64BIT-NEXT:   renamable $x3 = LD 0, killed renamable $x3 :: (load (s64))
  ; 64BIT-NEXT:   renamable $x6 = RLWIMI8 killed renamable $x6, killed renamable $x7, 16, 0, 15
  ; 64BIT-NEXT:   renamable $x6 = RLDIMI killed renamable $x6, killed renamable $x8, 32, 0
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_byval_31Byte>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x4, implicit $x5, implicit $x6, implicit $x2, implicit-def $r1, implicit-def dead $f1
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %call = call double @test_byval_31Byte(ptr byval(%struct.S31) align 1 @gS31)
  ret void
}

define double @test_byval_31Byte(ptr byval(%struct.S31) align 1 %s) {
  ; 32BIT-LABEL: name: test_byval_31Byte
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $r3, $r4, $r5, $r6, $r7, $r8, $r9, $r10
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   STW killed renamable $r8, 20, %fixed-stack.0 :: (store (s32) into %fixed-stack.0 + 20)
  ; 32BIT-NEXT:   STW killed renamable $r7, 16, %fixed-stack.0 :: (store (s32) into %fixed-stack.0 + 16, align 8)
  ; 32BIT-NEXT:   STW killed renamable $r3, 0, %fixed-stack.0 :: (store (s32) into %fixed-stack.0, align 8)
  ; 32BIT-NEXT:   STW killed renamable $r4, 4, %fixed-stack.0 :: (store (s32) into %fixed-stack.0 + 4)
  ; 32BIT-NEXT:   STW killed renamable $r5, 8, %fixed-stack.0 :: (store (s32) into %fixed-stack.0 + 8, align 8)
  ; 32BIT-NEXT:   STW killed renamable $r6, 12, %fixed-stack.0 :: (store (s32) into %fixed-stack.0 + 12)
  ; 32BIT-NEXT:   renamable $f1 = LFD 16, %fixed-stack.0 :: (dereferenceable load (s64) from %ir.gep)
  ; 32BIT-NEXT:   STW killed renamable $r9, 24, %fixed-stack.0 :: (store (s32) into %fixed-stack.0 + 24, align 8)
  ; 32BIT-NEXT:   STW killed renamable $r10, 28, %fixed-stack.0 :: (store (s32) into %fixed-stack.0 + 28)
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $f1
  ;
  ; 64BIT-LABEL: name: test_byval_31Byte
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $x3, $x4, $x5, $x6
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   STD killed renamable $x5, 16, %fixed-stack.0 :: (store (s64) into %fixed-stack.0 + 16, align 16)
  ; 64BIT-NEXT:   STD killed renamable $x3, 0, %fixed-stack.0 :: (store (s64) into %fixed-stack.0, align 16)
  ; 64BIT-NEXT:   renamable $f1 = LFD 16, %fixed-stack.0 :: (dereferenceable load (s64) from %ir.gep, align 16)
  ; 64BIT-NEXT:   STD killed renamable $x4, 8, %fixed-stack.0 :: (store (s64) into %fixed-stack.0 + 8)
  ; 64BIT-NEXT:   STD killed renamable $x6, 24, %fixed-stack.0 :: (store (s64) into %fixed-stack.0 + 24)
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $f1
entry:
  %gep = getelementptr inbounds %struct.S31, ptr %s, i32 0, i32 3
  %load = load double, ptr %gep, align 1
  ret double %load
}

%struct.F = type { float, float, float }

define i32 @call_test_byval_homogeneous_float_struct() {
  ; 32BIT-LABEL: name: call_test_byval_homogeneous_float_struct
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   renamable $r3 = LI 0
  ; 32BIT-NEXT:   STW renamable $r3, 8, %stack.0.s :: (store (s32) into %ir.s + 8, align 8)
  ; 32BIT-NEXT:   STW renamable $r3, 4, %stack.0.s :: (store (s32) into %ir.s + 4, basealign 8)
  ; 32BIT-NEXT:   STW killed renamable $r3, 0, %stack.0.s :: (store (s32) into %ir.s, align 8)
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   renamable $r5 = LWZ 8, %stack.0.s :: (load (s32) from %stack.0.s + 8, align 8)
  ; 32BIT-NEXT:   renamable $r4 = LWZ 4, %stack.0.s :: (load (s32) from %stack.0.s + 4)
  ; 32BIT-NEXT:   $r3 = LI 0
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_byval_homogeneous_float_struct[PR]>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r4, implicit $r5, implicit $r2, implicit-def $r1, implicit-def $r3
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3
  ;
  ; 64BIT-LABEL: name: call_test_byval_homogeneous_float_struct
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   renamable $x3 = LI8 0
  ; 64BIT-NEXT:   STW8 renamable $x3, 8, %stack.0.s :: (store (s32) into %ir.s + 8, align 8)
  ; 64BIT-NEXT:   STD killed renamable $x3, 0, %stack.0.s :: (store (s64) into %ir.s)
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   renamable $x3 = LWZ8 8, %stack.0.s :: (load (s32) from %stack.0.s + 8, align 8)
  ; 64BIT-NEXT:   renamable $x4 = RLDICR killed renamable $x3, 32, 31
  ; 64BIT-NEXT:   $x3 = LI8 0
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_byval_homogeneous_float_struct[PR]>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x4, implicit $x2, implicit-def $r1, implicit-def $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  %s = alloca %struct.F, align 8
  call void @llvm.memset.p0.i32(ptr align 4 %s, i8 0, i32 12, i1 false)
  %call = call i32 @test_byval_homogeneous_float_struct(ptr byval(%struct.F) align 4 %s)
  ret i32 %call
}

declare void @llvm.memset.p0.i32(ptr nocapture writeonly, i8, i32, i1 immarg)

declare i32 @test_byval_homogeneous_float_struct(ptr byval(%struct.F) align 4)
