; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-- | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc < %s -mtriple=aarch64-- -global-isel | FileCheck %s --check-prefixes=CHECK,CHECK-GI

declare i4 @llvm.uadd.sat.i4(i4, i4)
declare i8 @llvm.uadd.sat.i8(i8, i8)
declare i16 @llvm.uadd.sat.i16(i16, i16)
declare i32 @llvm.uadd.sat.i32(i32, i32)
declare i64 @llvm.uadd.sat.i64(i64, i64)

define i32 @func32(i32 %x, i32 %y, i32 %z) nounwind {
; CHECK-SD-LABEL: func32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mul w8, w1, w2
; CHECK-SD-NEXT:    adds w8, w0, w8
; CHECK-SD-NEXT:    csinv w0, w8, wzr, lo
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: func32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mul w8, w1, w2
; CHECK-GI-NEXT:    adds w8, w0, w8
; CHECK-GI-NEXT:    cset w9, hs
; CHECK-GI-NEXT:    tst w9, #0x1
; CHECK-GI-NEXT:    csinv w0, w8, wzr, eq
; CHECK-GI-NEXT:    ret
  %a = mul i32 %y, %z
  %tmp = call i32 @llvm.uadd.sat.i32(i32 %x, i32 %a)
  ret i32 %tmp
}

define i64 @func64(i64 %x, i64 %y, i64 %z) nounwind {
; CHECK-SD-LABEL: func64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    adds x8, x0, x2
; CHECK-SD-NEXT:    csinv x0, x8, xzr, lo
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: func64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adds x8, x0, x2
; CHECK-GI-NEXT:    cset w9, hs
; CHECK-GI-NEXT:    tst w9, #0x1
; CHECK-GI-NEXT:    csinv x0, x8, xzr, eq
; CHECK-GI-NEXT:    ret
  %a = mul i64 %y, %z
  %tmp = call i64 @llvm.uadd.sat.i64(i64 %x, i64 %z)
  ret i64 %tmp
}

define i16 @func16(i16 %x, i16 %y, i16 %z) nounwind {
; CHECK-SD-LABEL: func16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mul w8, w1, w2
; CHECK-SD-NEXT:    and w9, w0, #0xffff
; CHECK-SD-NEXT:    add w8, w9, w8, uxth
; CHECK-SD-NEXT:    mov w9, #65535 // =0xffff
; CHECK-SD-NEXT:    cmp w8, w9
; CHECK-SD-NEXT:    csel w0, w8, w9, lo
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: func16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mul w8, w1, w2
; CHECK-GI-NEXT:    and w8, w8, #0xffff
; CHECK-GI-NEXT:    add w8, w8, w0, uxth
; CHECK-GI-NEXT:    cmp w8, w8, uxth
; CHECK-GI-NEXT:    csinv w0, w8, wzr, eq
; CHECK-GI-NEXT:    ret
  %a = mul i16 %y, %z
  %tmp = call i16 @llvm.uadd.sat.i16(i16 %x, i16 %a)
  ret i16 %tmp
}

define i8 @func8(i8 %x, i8 %y, i8 %z) nounwind {
; CHECK-SD-LABEL: func8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mul w8, w1, w2
; CHECK-SD-NEXT:    and w9, w0, #0xff
; CHECK-SD-NEXT:    add w8, w9, w8, uxtb
; CHECK-SD-NEXT:    mov w9, #255 // =0xff
; CHECK-SD-NEXT:    cmp w8, #255
; CHECK-SD-NEXT:    csel w0, w8, w9, lo
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: func8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mul w8, w1, w2
; CHECK-GI-NEXT:    and w8, w8, #0xff
; CHECK-GI-NEXT:    add w8, w8, w0, uxtb
; CHECK-GI-NEXT:    cmp w8, w8, uxtb
; CHECK-GI-NEXT:    csinv w0, w8, wzr, eq
; CHECK-GI-NEXT:    ret
  %a = mul i8 %y, %z
  %tmp = call i8 @llvm.uadd.sat.i8(i8 %x, i8 %a)
  ret i8 %tmp
}

define i4 @func4(i4 %x, i4 %y, i4 %z) nounwind {
; CHECK-SD-LABEL: func4:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mul w8, w1, w2
; CHECK-SD-NEXT:    and w9, w0, #0xf
; CHECK-SD-NEXT:    and w8, w8, #0xf
; CHECK-SD-NEXT:    add w8, w9, w8
; CHECK-SD-NEXT:    mov w9, #15 // =0xf
; CHECK-SD-NEXT:    cmp w8, #15
; CHECK-SD-NEXT:    csel w0, w8, w9, lo
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: func4:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mul w8, w1, w2
; CHECK-GI-NEXT:    and w9, w0, #0xf
; CHECK-GI-NEXT:    mov w10, #15 // =0xf
; CHECK-GI-NEXT:    and w8, w8, #0xf
; CHECK-GI-NEXT:    add w8, w9, w8
; CHECK-GI-NEXT:    and w9, w8, #0xf
; CHECK-GI-NEXT:    cmp w8, w9
; CHECK-GI-NEXT:    csel w0, w10, w8, ne
; CHECK-GI-NEXT:    ret
  %a = mul i4 %y, %z
  %tmp = call i4 @llvm.uadd.sat.i4(i4 %x, i4 %a)
  ret i4 %tmp
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
