; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; REQUIRES: aarch64-registered-target

; This test needs to be target specific due to the cost estimate in the output.

; RUN: opt -passes='lower-matrix-intrinsics' -S < %s | FileCheck %s
; RUN: opt -passes='lower-matrix-intrinsics' -S -o /dev/null -pass-remarks-output=%t < %s && FileCheck --input-file %t --check-prefix=REMARK %s

target datalayout = "e-m:o-i64:64-f80:128-n8:16:32:64-S128"
target triple = "aarch64-apple-ios"

define void @double_transpose(ptr %A, ptr %B) {
; REMARK:      Pass:            lower-matrix-intrinsics
; REMARK-NEXT: Name:            matrix-lowered
; REMARK-NEXT: Function:        double_transpose
; REMARK-NEXT: Args:
; REMARK-NEXT:   - String:          'Lowered with '
; REMARK-NEXT:   - NumStores:       '6'
; REMARK-NEXT:   - String:          ' stores, '
; REMARK-NEXT:   - NumLoads:        '6'
; REMARK-NEXT:   - String:          ' loads, '
; REMARK-NEXT:   - NumComputeOps:   '0'
; REMARK-NEXT:   - String:          ' compute ops, '
; REMARK-NEXT:   - NumExposedTransposes: '0'
; REMARK-NEXT:   - String:          ' exposed transposes'
; REMARK-NEXT:   - String:           |
; REMARK:            store(
; REMARK-NEXT:        load(addr %A),
; REMARK-NEXT:        addr %B)
; CHECK-LABEL: @double_transpose(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COL_LOAD:%.*]] = load <3 x double>, ptr [[A:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP:%.*]] = getelementptr double, ptr [[A]], i64 3
; CHECK-NEXT:    [[COL_LOAD1:%.*]] = load <3 x double>, ptr [[VEC_GEP]], align 8
; CHECK-NEXT:    [[VEC_GEP2:%.*]] = getelementptr double, ptr [[A]], i64 6
; CHECK-NEXT:    [[COL_LOAD3:%.*]] = load <3 x double>, ptr [[VEC_GEP2]], align 16
; CHECK-NEXT:    store <3 x double> [[COL_LOAD]], ptr [[B:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP4:%.*]] = getelementptr double, ptr [[B]], i64 3
; CHECK-NEXT:    store <3 x double> [[COL_LOAD1]], ptr [[VEC_GEP4]], align 8
; CHECK-NEXT:    [[VEC_GEP5:%.*]] = getelementptr double, ptr [[B]], i64 6
; CHECK-NEXT:    store <3 x double> [[COL_LOAD3]], ptr [[VEC_GEP5]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %a = load <9 x double>, ptr %A, align 16
  %at = call <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double> %a, i32 3, i32 3)
  %att = call <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double> %at, i32 3, i32 3)
  store <9 x double> %att, ptr %B, align 16
  ret void
}

define void @multiply_ntt(ptr %A, ptr %B, ptr %C, ptr %R) {
; REMARK:      Pass:            lower-matrix-intrinsics
; REMARK-NEXT: Name:            matrix-lowered
; REMARK-NEXT: Function:        multiply_ntt
; REMARK-NEXT: Args:
; REMARK-NEXT:   - String:          'Lowered with '
; REMARK-NEXT:   - NumStores:       '4'
; REMARK-NEXT:   - String:          ' stores, '
; REMARK-NEXT:   - NumLoads:        '10'
; REMARK-NEXT:   - String:          ' loads, '
; REMARK-NEXT:   - NumComputeOps:   '38'
; REMARK-NEXT:   - String:          ' compute ops, '
; REMARK-NEXT:   - NumExposedTransposes: '0'
; REMARK-NEXT:   - String:          ' exposed transposes'
; REMARK-NEXT:   - String:           |
; REMARK:            store(
; REMARK-NEXT:        multiply.2x3.3x4.double(
; REMARK-NEXT:         load(addr %A),
; REMARK-NEXT:         transpose.4x3.double(multiply.4x2.2x3.double(
; REMARK-NEXT:           load(addr %C),
; REMARK-NEXT:           load(addr %B)))),
; REMARK-NEXT:        addr %R)
; CHECK-LABEL: @multiply_ntt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COL_LOAD:%.*]] = load <2 x double>, ptr [[A:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP:%.*]] = getelementptr double, ptr [[A]], i64 2
; CHECK-NEXT:    [[COL_LOAD39:%.*]] = load <2 x double>, ptr [[VEC_GEP]], align 16
; CHECK-NEXT:    [[VEC_GEP40:%.*]] = getelementptr double, ptr [[A]], i64 4
; CHECK-NEXT:    [[COL_LOAD41:%.*]] = load <2 x double>, ptr [[VEC_GEP40]], align 16
; CHECK-NEXT:    [[TMP0:%.*]] = shufflevector <2 x double> [[COL_LOAD]], <2 x double> [[COL_LOAD39]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[TMP1:%.*]] = shufflevector <2 x double> [[COL_LOAD41]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP2:%.*]] = shufflevector <4 x double> [[TMP0]], <4 x double> [[TMP1]], <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
; CHECK-NEXT:    [[COL_LOAD42:%.*]] = load <2 x double>, ptr [[B:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP43:%.*]] = getelementptr double, ptr [[B]], i64 2
; CHECK-NEXT:    [[COL_LOAD44:%.*]] = load <2 x double>, ptr [[VEC_GEP43]], align 16
; CHECK-NEXT:    [[VEC_GEP45:%.*]] = getelementptr double, ptr [[B]], i64 4
; CHECK-NEXT:    [[COL_LOAD46:%.*]] = load <2 x double>, ptr [[VEC_GEP45]], align 16
; CHECK-NEXT:    [[COL_LOAD47:%.*]] = load <4 x double>, ptr [[C:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP48:%.*]] = getelementptr double, ptr [[C]], i64 4
; CHECK-NEXT:    [[COL_LOAD49:%.*]] = load <4 x double>, ptr [[VEC_GEP48]], align 16
; CHECK-NEXT:    [[BLOCK50:%.*]] = shufflevector <4 x double> [[COL_LOAD47]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <2 x double> [[COL_LOAD42]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT51:%.*]] = insertelement <2 x double> poison, double [[TMP3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT52:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT51]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP4:%.*]] = fmul <2 x double> [[BLOCK50]], [[SPLAT_SPLAT52]]
; CHECK-NEXT:    [[BLOCK53:%.*]] = shufflevector <4 x double> [[COL_LOAD49]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <2 x double> [[COL_LOAD42]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT54:%.*]] = insertelement <2 x double> poison, double [[TMP5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT55:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT54]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = fmul <2 x double> [[BLOCK53]], [[SPLAT_SPLAT55]]
; CHECK-NEXT:    [[TMP7:%.*]] = fadd <2 x double> [[TMP4]], [[TMP6]]
; CHECK-NEXT:    [[TMP8:%.*]] = shufflevector <2 x double> [[TMP7]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP9:%.*]] = shufflevector <4 x double> poison, <4 x double> [[TMP8]], <4 x i32> <i32 4, i32 5, i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK56:%.*]] = shufflevector <4 x double> [[COL_LOAD47]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP10:%.*]] = extractelement <2 x double> [[COL_LOAD42]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT57:%.*]] = insertelement <2 x double> poison, double [[TMP10]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT58:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT57]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP11:%.*]] = fmul <2 x double> [[BLOCK56]], [[SPLAT_SPLAT58]]
; CHECK-NEXT:    [[BLOCK59:%.*]] = shufflevector <4 x double> [[COL_LOAD49]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP12:%.*]] = extractelement <2 x double> [[COL_LOAD42]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT60:%.*]] = insertelement <2 x double> poison, double [[TMP12]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT61:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT60]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP13:%.*]] = fmul <2 x double> [[BLOCK59]], [[SPLAT_SPLAT61]]
; CHECK-NEXT:    [[TMP14:%.*]] = fadd <2 x double> [[TMP11]], [[TMP13]]
; CHECK-NEXT:    [[TMP15:%.*]] = shufflevector <2 x double> [[TMP14]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP16:%.*]] = shufflevector <4 x double> [[TMP9]], <4 x double> [[TMP15]], <4 x i32> <i32 0, i32 1, i32 4, i32 5>
; CHECK-NEXT:    [[BLOCK62:%.*]] = shufflevector <4 x double> [[COL_LOAD47]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <2 x double> [[COL_LOAD44]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT63:%.*]] = insertelement <2 x double> poison, double [[TMP17]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT64:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT63]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP18:%.*]] = fmul <2 x double> [[BLOCK62]], [[SPLAT_SPLAT64]]
; CHECK-NEXT:    [[BLOCK65:%.*]] = shufflevector <4 x double> [[COL_LOAD49]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP19:%.*]] = extractelement <2 x double> [[COL_LOAD44]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT66:%.*]] = insertelement <2 x double> poison, double [[TMP19]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT67:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT66]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP20:%.*]] = fmul <2 x double> [[BLOCK65]], [[SPLAT_SPLAT67]]
; CHECK-NEXT:    [[TMP21:%.*]] = fadd <2 x double> [[TMP18]], [[TMP20]]
; CHECK-NEXT:    [[TMP22:%.*]] = shufflevector <2 x double> [[TMP21]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP23:%.*]] = shufflevector <4 x double> poison, <4 x double> [[TMP22]], <4 x i32> <i32 4, i32 5, i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK68:%.*]] = shufflevector <4 x double> [[COL_LOAD47]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP24:%.*]] = extractelement <2 x double> [[COL_LOAD44]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT69:%.*]] = insertelement <2 x double> poison, double [[TMP24]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT70:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT69]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP25:%.*]] = fmul <2 x double> [[BLOCK68]], [[SPLAT_SPLAT70]]
; CHECK-NEXT:    [[BLOCK71:%.*]] = shufflevector <4 x double> [[COL_LOAD49]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP26:%.*]] = extractelement <2 x double> [[COL_LOAD44]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT72:%.*]] = insertelement <2 x double> poison, double [[TMP26]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT73:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT72]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP27:%.*]] = fmul <2 x double> [[BLOCK71]], [[SPLAT_SPLAT73]]
; CHECK-NEXT:    [[TMP28:%.*]] = fadd <2 x double> [[TMP25]], [[TMP27]]
; CHECK-NEXT:    [[TMP29:%.*]] = shufflevector <2 x double> [[TMP28]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP30:%.*]] = shufflevector <4 x double> [[TMP23]], <4 x double> [[TMP29]], <4 x i32> <i32 0, i32 1, i32 4, i32 5>
; CHECK-NEXT:    [[BLOCK74:%.*]] = shufflevector <4 x double> [[COL_LOAD47]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP31:%.*]] = extractelement <2 x double> [[COL_LOAD46]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT75:%.*]] = insertelement <2 x double> poison, double [[TMP31]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT76:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT75]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP32:%.*]] = fmul <2 x double> [[BLOCK74]], [[SPLAT_SPLAT76]]
; CHECK-NEXT:    [[BLOCK77:%.*]] = shufflevector <4 x double> [[COL_LOAD49]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP33:%.*]] = extractelement <2 x double> [[COL_LOAD46]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT78:%.*]] = insertelement <2 x double> poison, double [[TMP33]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT79:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT78]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP34:%.*]] = fmul <2 x double> [[BLOCK77]], [[SPLAT_SPLAT79]]
; CHECK-NEXT:    [[TMP35:%.*]] = fadd <2 x double> [[TMP32]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = shufflevector <2 x double> [[TMP35]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP37:%.*]] = shufflevector <4 x double> poison, <4 x double> [[TMP36]], <4 x i32> <i32 4, i32 5, i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK80:%.*]] = shufflevector <4 x double> [[COL_LOAD47]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP38:%.*]] = extractelement <2 x double> [[COL_LOAD46]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT81:%.*]] = insertelement <2 x double> poison, double [[TMP38]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT82:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT81]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP39:%.*]] = fmul <2 x double> [[BLOCK80]], [[SPLAT_SPLAT82]]
; CHECK-NEXT:    [[BLOCK83:%.*]] = shufflevector <4 x double> [[COL_LOAD49]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP40:%.*]] = extractelement <2 x double> [[COL_LOAD46]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT84:%.*]] = insertelement <2 x double> poison, double [[TMP40]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT85:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT84]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP41:%.*]] = fmul <2 x double> [[BLOCK83]], [[SPLAT_SPLAT85]]
; CHECK-NEXT:    [[TMP42:%.*]] = fadd <2 x double> [[TMP39]], [[TMP41]]
; CHECK-NEXT:    [[TMP43:%.*]] = shufflevector <2 x double> [[TMP42]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP44:%.*]] = shufflevector <4 x double> [[TMP37]], <4 x double> [[TMP43]], <4 x i32> <i32 0, i32 1, i32 4, i32 5>
; CHECK-NEXT:    [[TMP45:%.*]] = shufflevector <4 x double> [[TMP16]], <4 x double> [[TMP30]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[TMP46:%.*]] = shufflevector <4 x double> [[TMP44]], <4 x double> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 poison, i32 poison, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP47:%.*]] = shufflevector <8 x double> [[TMP45]], <8 x double> [[TMP46]], <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <6 x double> [[TMP2]], <6 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <6 x double> [[TMP2]], <6 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <6 x double> [[TMP2]], <6 x double> poison, <2 x i32> <i32 4, i32 5>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <12 x double> [[TMP47]], <12 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <12 x double> [[TMP47]], <12 x double> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[SPLIT5:%.*]] = shufflevector <12 x double> [[TMP47]], <12 x double> poison, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <2 x double> [[SPLIT]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP48:%.*]] = extractelement <4 x double> [[SPLIT3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <2 x double> poison, double [[TMP48]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP49:%.*]] = fmul <2 x double> [[BLOCK]], [[SPLAT_SPLAT]]
; CHECK-NEXT:    [[BLOCK6:%.*]] = shufflevector <2 x double> [[SPLIT1]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP50:%.*]] = extractelement <4 x double> [[SPLIT4]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT7:%.*]] = insertelement <2 x double> poison, double [[TMP50]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT8:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT7]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP51:%.*]] = fmul <2 x double> [[BLOCK6]], [[SPLAT_SPLAT8]]
; CHECK-NEXT:    [[TMP52:%.*]] = fadd <2 x double> [[TMP49]], [[TMP51]]
; CHECK-NEXT:    [[BLOCK9:%.*]] = shufflevector <2 x double> [[SPLIT2]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP53:%.*]] = extractelement <4 x double> [[SPLIT5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT10:%.*]] = insertelement <2 x double> poison, double [[TMP53]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT11:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT10]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP54:%.*]] = fmul <2 x double> [[BLOCK9]], [[SPLAT_SPLAT11]]
; CHECK-NEXT:    [[TMP55:%.*]] = fadd <2 x double> [[TMP52]], [[TMP54]]
; CHECK-NEXT:    [[TMP56:%.*]] = shufflevector <2 x double> [[TMP55]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP57:%.*]] = shufflevector <2 x double> poison, <2 x double> [[TMP56]], <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK12:%.*]] = shufflevector <2 x double> [[SPLIT]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP58:%.*]] = extractelement <4 x double> [[SPLIT3]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT13:%.*]] = insertelement <2 x double> poison, double [[TMP58]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT14:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT13]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP59:%.*]] = fmul <2 x double> [[BLOCK12]], [[SPLAT_SPLAT14]]
; CHECK-NEXT:    [[BLOCK15:%.*]] = shufflevector <2 x double> [[SPLIT1]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP60:%.*]] = extractelement <4 x double> [[SPLIT4]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT16:%.*]] = insertelement <2 x double> poison, double [[TMP60]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT17:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT16]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP61:%.*]] = fmul <2 x double> [[BLOCK15]], [[SPLAT_SPLAT17]]
; CHECK-NEXT:    [[TMP62:%.*]] = fadd <2 x double> [[TMP59]], [[TMP61]]
; CHECK-NEXT:    [[BLOCK18:%.*]] = shufflevector <2 x double> [[SPLIT2]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP63:%.*]] = extractelement <4 x double> [[SPLIT5]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT19:%.*]] = insertelement <2 x double> poison, double [[TMP63]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT20:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT19]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP64:%.*]] = fmul <2 x double> [[BLOCK18]], [[SPLAT_SPLAT20]]
; CHECK-NEXT:    [[TMP65:%.*]] = fadd <2 x double> [[TMP62]], [[TMP64]]
; CHECK-NEXT:    [[TMP66:%.*]] = shufflevector <2 x double> [[TMP65]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP67:%.*]] = shufflevector <2 x double> poison, <2 x double> [[TMP66]], <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK21:%.*]] = shufflevector <2 x double> [[SPLIT]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP68:%.*]] = extractelement <4 x double> [[SPLIT3]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT22:%.*]] = insertelement <2 x double> poison, double [[TMP68]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT23:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT22]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP69:%.*]] = fmul <2 x double> [[BLOCK21]], [[SPLAT_SPLAT23]]
; CHECK-NEXT:    [[BLOCK24:%.*]] = shufflevector <2 x double> [[SPLIT1]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP70:%.*]] = extractelement <4 x double> [[SPLIT4]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT25:%.*]] = insertelement <2 x double> poison, double [[TMP70]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT26:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT25]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP71:%.*]] = fmul <2 x double> [[BLOCK24]], [[SPLAT_SPLAT26]]
; CHECK-NEXT:    [[TMP72:%.*]] = fadd <2 x double> [[TMP69]], [[TMP71]]
; CHECK-NEXT:    [[BLOCK27:%.*]] = shufflevector <2 x double> [[SPLIT2]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP73:%.*]] = extractelement <4 x double> [[SPLIT5]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT28:%.*]] = insertelement <2 x double> poison, double [[TMP73]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT29:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT28]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP74:%.*]] = fmul <2 x double> [[BLOCK27]], [[SPLAT_SPLAT29]]
; CHECK-NEXT:    [[TMP75:%.*]] = fadd <2 x double> [[TMP72]], [[TMP74]]
; CHECK-NEXT:    [[TMP76:%.*]] = shufflevector <2 x double> [[TMP75]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP77:%.*]] = shufflevector <2 x double> poison, <2 x double> [[TMP76]], <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK30:%.*]] = shufflevector <2 x double> [[SPLIT]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP78:%.*]] = extractelement <4 x double> [[SPLIT3]], i64 3
; CHECK-NEXT:    [[SPLAT_SPLATINSERT31:%.*]] = insertelement <2 x double> poison, double [[TMP78]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT32:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT31]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP79:%.*]] = fmul <2 x double> [[BLOCK30]], [[SPLAT_SPLAT32]]
; CHECK-NEXT:    [[BLOCK33:%.*]] = shufflevector <2 x double> [[SPLIT1]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP80:%.*]] = extractelement <4 x double> [[SPLIT4]], i64 3
; CHECK-NEXT:    [[SPLAT_SPLATINSERT34:%.*]] = insertelement <2 x double> poison, double [[TMP80]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT35:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT34]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP81:%.*]] = fmul <2 x double> [[BLOCK33]], [[SPLAT_SPLAT35]]
; CHECK-NEXT:    [[TMP82:%.*]] = fadd <2 x double> [[TMP79]], [[TMP81]]
; CHECK-NEXT:    [[BLOCK36:%.*]] = shufflevector <2 x double> [[SPLIT2]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP83:%.*]] = extractelement <4 x double> [[SPLIT5]], i64 3
; CHECK-NEXT:    [[SPLAT_SPLATINSERT37:%.*]] = insertelement <2 x double> poison, double [[TMP83]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT38:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT37]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP84:%.*]] = fmul <2 x double> [[BLOCK36]], [[SPLAT_SPLAT38]]
; CHECK-NEXT:    [[TMP85:%.*]] = fadd <2 x double> [[TMP82]], [[TMP84]]
; CHECK-NEXT:    [[TMP86:%.*]] = shufflevector <2 x double> [[TMP85]], <2 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP87:%.*]] = shufflevector <2 x double> poison, <2 x double> [[TMP86]], <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    store <2 x double> [[TMP57]], ptr [[R:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP86:%.*]] = getelementptr double, ptr [[R]], i64 2
; CHECK-NEXT:    store <2 x double> [[TMP67]], ptr [[VEC_GEP86]], align 16
; CHECK-NEXT:    [[VEC_GEP87:%.*]] = getelementptr double, ptr [[R]], i64 4
; CHECK-NEXT:    store <2 x double> [[TMP77]], ptr [[VEC_GEP87]], align 16
; CHECK-NEXT:    [[VEC_GEP88:%.*]] = getelementptr double, ptr [[R]], i64 6
; CHECK-NEXT:    store <2 x double> [[TMP87]], ptr [[VEC_GEP88]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %a = load <6 x double>, ptr %A, align 16
  %b = load <6 x double>, ptr %B, align 16
  %c = load <8 x double>, ptr %C, align 16
  %b_t = call <6 x double> @llvm.matrix.transpose.v6f64.v6f64(<6 x double> %b, i32 2, i32 3)
  %c_t = call <8 x double> @llvm.matrix.transpose.v8f64.v8f64(<8 x double> %c, i32 4, i32 2)
  %m1 = call <12 x double> @llvm.matrix.multiply.v12f64.v6f64.v8f64(<6 x double> %b_t, <8 x double> %c_t, i32 3, i32 2, i32 4)
  %m2 = call <8 x double> @llvm.matrix.multiply.v8f64.v6f64.v12f64(<6 x double> %a, <12 x double> %m1, i32 2, i32 3, i32 4)
  store <8 x double> %m2, ptr %R, align 16
  ret void
}

define void @multiply_tt_t(ptr %A, ptr %B, ptr %C) {
; REMARK:      Pass:            lower-matrix-intrinsics
; REMARK-NEXT: Name:            matrix-lowered
; REMARK-NEXT: Function:        multiply_tt_t
; REMARK-NEXT: Args:
; REMARK-NEXT:   - String:          'Lowered with '
; REMARK-NEXT:   - NumStores:       '6'
; REMARK-NEXT:   - String:          ' stores, '
; REMARK-NEXT:   - NumLoads:        '12'
; REMARK-NEXT:   - String:          ' loads, '
; REMARK-NEXT:   - NumComputeOps:   '30'
; REMARK-NEXT:   - String:          ' compute ops, '
; REMARK-NEXT:   - NumExposedTransposes: '0'
; REMARK-NEXT:   - String:          ' exposed transposes'
; REMARK-NEXT:   - String:           |
; REMARK:            store(
; REMARK-NEXT:        multiply.3x3.3x3.double(
; REMARK-NEXT:         load(addr %B),
; REMARK-NEXT:         load(addr %A)),
; REMARK-NEXT:        addr %C)
; CHECK-LABEL: @multiply_tt_t(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COL_LOAD:%.*]] = load <3 x double>, ptr [[A:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP:%.*]] = getelementptr double, ptr [[A]], i64 3
; CHECK-NEXT:    [[COL_LOAD1:%.*]] = load <3 x double>, ptr [[VEC_GEP]], align 8
; CHECK-NEXT:    [[VEC_GEP2:%.*]] = getelementptr double, ptr [[A]], i64 6
; CHECK-NEXT:    [[COL_LOAD3:%.*]] = load <3 x double>, ptr [[VEC_GEP2]], align 16
; CHECK-NEXT:    [[COL_LOAD4:%.*]] = load <3 x double>, ptr [[B:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP5:%.*]] = getelementptr double, ptr [[B]], i64 3
; CHECK-NEXT:    [[COL_LOAD6:%.*]] = load <3 x double>, ptr [[VEC_GEP5]], align 8
; CHECK-NEXT:    [[VEC_GEP7:%.*]] = getelementptr double, ptr [[B]], i64 6
; CHECK-NEXT:    [[COL_LOAD8:%.*]] = load <3 x double>, ptr [[VEC_GEP7]], align 16
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <3 x double> [[COL_LOAD4]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP0:%.*]] = extractelement <3 x double> [[COL_LOAD]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <2 x double> poison, double [[TMP0]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP1:%.*]] = fmul <2 x double> [[BLOCK]], [[SPLAT_SPLAT]]
; CHECK-NEXT:    [[BLOCK9:%.*]] = shufflevector <3 x double> [[COL_LOAD6]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <3 x double> [[COL_LOAD]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT10:%.*]] = insertelement <2 x double> poison, double [[TMP2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT11:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT10]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = fmul <2 x double> [[BLOCK9]], [[SPLAT_SPLAT11]]
; CHECK-NEXT:    [[TMP4:%.*]] = fadd <2 x double> [[TMP1]], [[TMP3]]
; CHECK-NEXT:    [[BLOCK12:%.*]] = shufflevector <3 x double> [[COL_LOAD8]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <3 x double> [[COL_LOAD]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT13:%.*]] = insertelement <2 x double> poison, double [[TMP5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT14:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT13]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = fmul <2 x double> [[BLOCK12]], [[SPLAT_SPLAT14]]
; CHECK-NEXT:    [[TMP7:%.*]] = fadd <2 x double> [[TMP4]], [[TMP6]]
; CHECK-NEXT:    [[TMP8:%.*]] = shufflevector <2 x double> [[TMP7]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 poison>
; CHECK-NEXT:    [[TMP9:%.*]] = shufflevector <3 x double> poison, <3 x double> [[TMP8]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK15:%.*]] = shufflevector <3 x double> [[COL_LOAD4]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP10:%.*]] = extractelement <3 x double> [[COL_LOAD]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT16:%.*]] = insertelement <1 x double> poison, double [[TMP10]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT17:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT16]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP11:%.*]] = fmul <1 x double> [[BLOCK15]], [[SPLAT_SPLAT17]]
; CHECK-NEXT:    [[BLOCK18:%.*]] = shufflevector <3 x double> [[COL_LOAD6]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP12:%.*]] = extractelement <3 x double> [[COL_LOAD]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT19:%.*]] = insertelement <1 x double> poison, double [[TMP12]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT20:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT19]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP13:%.*]] = fmul <1 x double> [[BLOCK18]], [[SPLAT_SPLAT20]]
; CHECK-NEXT:    [[TMP14:%.*]] = fadd <1 x double> [[TMP11]], [[TMP13]]
; CHECK-NEXT:    [[BLOCK21:%.*]] = shufflevector <3 x double> [[COL_LOAD8]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP15:%.*]] = extractelement <3 x double> [[COL_LOAD]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT22:%.*]] = insertelement <1 x double> poison, double [[TMP15]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT23:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT22]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP16:%.*]] = fmul <1 x double> [[BLOCK21]], [[SPLAT_SPLAT23]]
; CHECK-NEXT:    [[TMP17:%.*]] = fadd <1 x double> [[TMP14]], [[TMP16]]
; CHECK-NEXT:    [[TMP18:%.*]] = shufflevector <1 x double> [[TMP17]], <1 x double> poison, <3 x i32> <i32 0, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP19:%.*]] = shufflevector <3 x double> [[TMP9]], <3 x double> [[TMP18]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    [[BLOCK24:%.*]] = shufflevector <3 x double> [[COL_LOAD4]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP20:%.*]] = extractelement <3 x double> [[COL_LOAD1]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT25:%.*]] = insertelement <2 x double> poison, double [[TMP20]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT26:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT25]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP21:%.*]] = fmul <2 x double> [[BLOCK24]], [[SPLAT_SPLAT26]]
; CHECK-NEXT:    [[BLOCK27:%.*]] = shufflevector <3 x double> [[COL_LOAD6]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP22:%.*]] = extractelement <3 x double> [[COL_LOAD1]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT28:%.*]] = insertelement <2 x double> poison, double [[TMP22]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT29:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT28]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP23:%.*]] = fmul <2 x double> [[BLOCK27]], [[SPLAT_SPLAT29]]
; CHECK-NEXT:    [[TMP24:%.*]] = fadd <2 x double> [[TMP21]], [[TMP23]]
; CHECK-NEXT:    [[BLOCK30:%.*]] = shufflevector <3 x double> [[COL_LOAD8]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP25:%.*]] = extractelement <3 x double> [[COL_LOAD1]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT31:%.*]] = insertelement <2 x double> poison, double [[TMP25]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT32:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT31]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP26:%.*]] = fmul <2 x double> [[BLOCK30]], [[SPLAT_SPLAT32]]
; CHECK-NEXT:    [[TMP27:%.*]] = fadd <2 x double> [[TMP24]], [[TMP26]]
; CHECK-NEXT:    [[TMP28:%.*]] = shufflevector <2 x double> [[TMP27]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 poison>
; CHECK-NEXT:    [[TMP29:%.*]] = shufflevector <3 x double> poison, <3 x double> [[TMP28]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK33:%.*]] = shufflevector <3 x double> [[COL_LOAD4]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP30:%.*]] = extractelement <3 x double> [[COL_LOAD1]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT34:%.*]] = insertelement <1 x double> poison, double [[TMP30]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT35:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT34]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP31:%.*]] = fmul <1 x double> [[BLOCK33]], [[SPLAT_SPLAT35]]
; CHECK-NEXT:    [[BLOCK36:%.*]] = shufflevector <3 x double> [[COL_LOAD6]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP32:%.*]] = extractelement <3 x double> [[COL_LOAD1]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT37:%.*]] = insertelement <1 x double> poison, double [[TMP32]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT38:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT37]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP33:%.*]] = fmul <1 x double> [[BLOCK36]], [[SPLAT_SPLAT38]]
; CHECK-NEXT:    [[TMP34:%.*]] = fadd <1 x double> [[TMP31]], [[TMP33]]
; CHECK-NEXT:    [[BLOCK39:%.*]] = shufflevector <3 x double> [[COL_LOAD8]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP35:%.*]] = extractelement <3 x double> [[COL_LOAD1]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT40:%.*]] = insertelement <1 x double> poison, double [[TMP35]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT41:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT40]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP36:%.*]] = fmul <1 x double> [[BLOCK39]], [[SPLAT_SPLAT41]]
; CHECK-NEXT:    [[TMP37:%.*]] = fadd <1 x double> [[TMP34]], [[TMP36]]
; CHECK-NEXT:    [[TMP38:%.*]] = shufflevector <1 x double> [[TMP37]], <1 x double> poison, <3 x i32> <i32 0, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP39:%.*]] = shufflevector <3 x double> [[TMP29]], <3 x double> [[TMP38]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    [[BLOCK42:%.*]] = shufflevector <3 x double> [[COL_LOAD4]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP40:%.*]] = extractelement <3 x double> [[COL_LOAD3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT43:%.*]] = insertelement <2 x double> poison, double [[TMP40]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT44:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT43]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP41:%.*]] = fmul <2 x double> [[BLOCK42]], [[SPLAT_SPLAT44]]
; CHECK-NEXT:    [[BLOCK45:%.*]] = shufflevector <3 x double> [[COL_LOAD6]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP42:%.*]] = extractelement <3 x double> [[COL_LOAD3]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT46:%.*]] = insertelement <2 x double> poison, double [[TMP42]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT47:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT46]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP43:%.*]] = fmul <2 x double> [[BLOCK45]], [[SPLAT_SPLAT47]]
; CHECK-NEXT:    [[TMP44:%.*]] = fadd <2 x double> [[TMP41]], [[TMP43]]
; CHECK-NEXT:    [[BLOCK48:%.*]] = shufflevector <3 x double> [[COL_LOAD8]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP45:%.*]] = extractelement <3 x double> [[COL_LOAD3]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT49:%.*]] = insertelement <2 x double> poison, double [[TMP45]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT50:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT49]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP46:%.*]] = fmul <2 x double> [[BLOCK48]], [[SPLAT_SPLAT50]]
; CHECK-NEXT:    [[TMP47:%.*]] = fadd <2 x double> [[TMP44]], [[TMP46]]
; CHECK-NEXT:    [[TMP48:%.*]] = shufflevector <2 x double> [[TMP47]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 poison>
; CHECK-NEXT:    [[TMP49:%.*]] = shufflevector <3 x double> poison, <3 x double> [[TMP48]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK51:%.*]] = shufflevector <3 x double> [[COL_LOAD4]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP50:%.*]] = extractelement <3 x double> [[COL_LOAD3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT52:%.*]] = insertelement <1 x double> poison, double [[TMP50]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT53:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT52]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP51:%.*]] = fmul <1 x double> [[BLOCK51]], [[SPLAT_SPLAT53]]
; CHECK-NEXT:    [[BLOCK54:%.*]] = shufflevector <3 x double> [[COL_LOAD6]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP52:%.*]] = extractelement <3 x double> [[COL_LOAD3]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT55:%.*]] = insertelement <1 x double> poison, double [[TMP52]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT56:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT55]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP53:%.*]] = fmul <1 x double> [[BLOCK54]], [[SPLAT_SPLAT56]]
; CHECK-NEXT:    [[TMP54:%.*]] = fadd <1 x double> [[TMP51]], [[TMP53]]
; CHECK-NEXT:    [[BLOCK57:%.*]] = shufflevector <3 x double> [[COL_LOAD8]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP55:%.*]] = extractelement <3 x double> [[COL_LOAD3]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT58:%.*]] = insertelement <1 x double> poison, double [[TMP55]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT59:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT58]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP56:%.*]] = fmul <1 x double> [[BLOCK57]], [[SPLAT_SPLAT59]]
; CHECK-NEXT:    [[TMP57:%.*]] = fadd <1 x double> [[TMP54]], [[TMP56]]
; CHECK-NEXT:    [[TMP58:%.*]] = shufflevector <1 x double> [[TMP57]], <1 x double> poison, <3 x i32> <i32 0, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP59:%.*]] = shufflevector <3 x double> [[TMP49]], <3 x double> [[TMP58]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    store <3 x double> [[TMP19]], ptr [[C:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP60:%.*]] = getelementptr double, ptr [[C]], i64 3
; CHECK-NEXT:    store <3 x double> [[TMP39]], ptr [[VEC_GEP60]], align 8
; CHECK-NEXT:    [[VEC_GEP61:%.*]] = getelementptr double, ptr [[C]], i64 6
; CHECK-NEXT:    store <3 x double> [[TMP59]], ptr [[VEC_GEP61]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %a = load <9 x double>, ptr %A, align 16
  %at = call <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double> %a, i32 3, i32 3)
  %b = load <9 x double>, ptr %B, align 16
  %bt = call <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double> %b, i32 3, i32 3)
  %c = call <9 x double> @llvm.matrix.multiply.v9f64.v9f64.v9f64(<9 x double> %at, <9 x double> %bt, i32 3, i32 3, i32 3)
  %ct = call <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double> %c, i32 3, i32 3)
  store <9 x double> %ct, ptr %C, align 16
  ret void
}

define void @multiply_nt_t(ptr %A, ptr %B, ptr %C) {
; REMARK:      Pass:            lower-matrix-intrinsics
; REMARK-NEXT: Name:            matrix-lowered
; REMARK-NEXT: Function:        multiply_nt_t
; REMARK-NEXT: Args:
; REMARK-NEXT:   - String:          'Lowered with '
; REMARK-NEXT:   - NumStores:       '4'
; REMARK-NEXT:   - String:          ' stores, '
; REMARK-NEXT:   - NumLoads:        '9'
; REMARK-NEXT:   - String:          ' loads, '
; REMARK-NEXT:   - NumComputeOps:   '20'
; REMARK-NEXT:   - String:          ' compute ops, '
; REMARK-NEXT:   - NumExposedTransposes: '0'
; REMARK-NEXT:   - String:          ' exposed transposes'
; REMARK-NEXT:   - String:           |
; REMARK:            store(
; REMARK-NEXT:        multiply.4x3.3x2.double(
; REMARK-NEXT:         load(addr %B),
; REMARK-NEXT:         transpose.2x3.double(load(addr %A))),
; REMARK-NEXT:        addr %C)
; CHECK-LABEL: @multiply_nt_t(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COL_LOAD:%.*]] = load <2 x double>, ptr [[A:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP:%.*]] = getelementptr double, ptr [[A]], i64 2
; CHECK-NEXT:    [[COL_LOAD39:%.*]] = load <2 x double>, ptr [[VEC_GEP]], align 16
; CHECK-NEXT:    [[VEC_GEP40:%.*]] = getelementptr double, ptr [[A]], i64 4
; CHECK-NEXT:    [[COL_LOAD41:%.*]] = load <2 x double>, ptr [[VEC_GEP40]], align 16
; CHECK-NEXT:    [[TMP0:%.*]] = shufflevector <2 x double> [[COL_LOAD]], <2 x double> [[COL_LOAD39]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[TMP1:%.*]] = shufflevector <2 x double> [[COL_LOAD41]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP2:%.*]] = shufflevector <4 x double> [[TMP0]], <4 x double> [[TMP1]], <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
; CHECK-NEXT:    [[COL_LOAD42:%.*]] = load <4 x double>, ptr [[B:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP43:%.*]] = getelementptr double, ptr [[B]], i64 4
; CHECK-NEXT:    [[COL_LOAD44:%.*]] = load <4 x double>, ptr [[VEC_GEP43]], align 16
; CHECK-NEXT:    [[VEC_GEP45:%.*]] = getelementptr double, ptr [[B]], i64 8
; CHECK-NEXT:    [[COL_LOAD46:%.*]] = load <4 x double>, ptr [[VEC_GEP45]], align 16
; CHECK-NEXT:    [[TMP3:%.*]] = shufflevector <4 x double> [[COL_LOAD42]], <4 x double> [[COL_LOAD44]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[TMP4:%.*]] = shufflevector <4 x double> [[COL_LOAD46]], <4 x double> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 poison, i32 poison, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP5:%.*]] = shufflevector <8 x double> [[TMP3]], <8 x double> [[TMP4]], <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <12 x double> [[TMP5]], <12 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <12 x double> [[TMP5]], <12 x double> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <12 x double> [[TMP5]], <12 x double> poison, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <6 x double> [[TMP2]], <6 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <6 x double> [[TMP2]], <6 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[SPLIT5:%.*]] = shufflevector <6 x double> [[TMP2]], <6 x double> poison, <2 x i32> <i32 4, i32 5>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <2 x double> [[SPLIT3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <2 x double> poison, double [[TMP6]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP7:%.*]] = fmul <2 x double> [[BLOCK]], [[SPLAT_SPLAT]]
; CHECK-NEXT:    [[BLOCK6:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <2 x double> [[SPLIT4]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT7:%.*]] = insertelement <2 x double> poison, double [[TMP8]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT8:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT7]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = fmul <2 x double> [[BLOCK6]], [[SPLAT_SPLAT8]]
; CHECK-NEXT:    [[TMP10:%.*]] = fadd <2 x double> [[TMP7]], [[TMP9]]
; CHECK-NEXT:    [[BLOCK9:%.*]] = shufflevector <4 x double> [[SPLIT2]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP11:%.*]] = extractelement <2 x double> [[SPLIT5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT10:%.*]] = insertelement <2 x double> poison, double [[TMP11]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT11:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT10]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP12:%.*]] = fmul <2 x double> [[BLOCK9]], [[SPLAT_SPLAT11]]
; CHECK-NEXT:    [[TMP13:%.*]] = fadd <2 x double> [[TMP10]], [[TMP12]]
; CHECK-NEXT:    [[TMP14:%.*]] = shufflevector <2 x double> [[TMP13]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP15:%.*]] = shufflevector <4 x double> poison, <4 x double> [[TMP14]], <4 x i32> <i32 4, i32 5, i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK12:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <2 x double> [[SPLIT3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT13:%.*]] = insertelement <2 x double> poison, double [[TMP16]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT14:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT13]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP17:%.*]] = fmul <2 x double> [[BLOCK12]], [[SPLAT_SPLAT14]]
; CHECK-NEXT:    [[BLOCK15:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP18:%.*]] = extractelement <2 x double> [[SPLIT4]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT16:%.*]] = insertelement <2 x double> poison, double [[TMP18]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT17:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT16]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP19:%.*]] = fmul <2 x double> [[BLOCK15]], [[SPLAT_SPLAT17]]
; CHECK-NEXT:    [[TMP20:%.*]] = fadd <2 x double> [[TMP17]], [[TMP19]]
; CHECK-NEXT:    [[BLOCK18:%.*]] = shufflevector <4 x double> [[SPLIT2]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP21:%.*]] = extractelement <2 x double> [[SPLIT5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT19:%.*]] = insertelement <2 x double> poison, double [[TMP21]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT20:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT19]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP22:%.*]] = fmul <2 x double> [[BLOCK18]], [[SPLAT_SPLAT20]]
; CHECK-NEXT:    [[TMP23:%.*]] = fadd <2 x double> [[TMP20]], [[TMP22]]
; CHECK-NEXT:    [[TMP24:%.*]] = shufflevector <2 x double> [[TMP23]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP25:%.*]] = shufflevector <4 x double> [[TMP15]], <4 x double> [[TMP24]], <4 x i32> <i32 0, i32 1, i32 4, i32 5>
; CHECK-NEXT:    [[BLOCK21:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP26:%.*]] = extractelement <2 x double> [[SPLIT3]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT22:%.*]] = insertelement <2 x double> poison, double [[TMP26]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT23:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT22]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP27:%.*]] = fmul <2 x double> [[BLOCK21]], [[SPLAT_SPLAT23]]
; CHECK-NEXT:    [[BLOCK24:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP28:%.*]] = extractelement <2 x double> [[SPLIT4]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT25:%.*]] = insertelement <2 x double> poison, double [[TMP28]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT26:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT25]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP29:%.*]] = fmul <2 x double> [[BLOCK24]], [[SPLAT_SPLAT26]]
; CHECK-NEXT:    [[TMP30:%.*]] = fadd <2 x double> [[TMP27]], [[TMP29]]
; CHECK-NEXT:    [[BLOCK27:%.*]] = shufflevector <4 x double> [[SPLIT2]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP31:%.*]] = extractelement <2 x double> [[SPLIT5]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT28:%.*]] = insertelement <2 x double> poison, double [[TMP31]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT29:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT28]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP32:%.*]] = fmul <2 x double> [[BLOCK27]], [[SPLAT_SPLAT29]]
; CHECK-NEXT:    [[TMP33:%.*]] = fadd <2 x double> [[TMP30]], [[TMP32]]
; CHECK-NEXT:    [[TMP34:%.*]] = shufflevector <2 x double> [[TMP33]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP35:%.*]] = shufflevector <4 x double> poison, <4 x double> [[TMP34]], <4 x i32> <i32 4, i32 5, i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK30:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP36:%.*]] = extractelement <2 x double> [[SPLIT3]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT31:%.*]] = insertelement <2 x double> poison, double [[TMP36]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT32:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT31]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP37:%.*]] = fmul <2 x double> [[BLOCK30]], [[SPLAT_SPLAT32]]
; CHECK-NEXT:    [[BLOCK33:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP38:%.*]] = extractelement <2 x double> [[SPLIT4]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT34:%.*]] = insertelement <2 x double> poison, double [[TMP38]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT35:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT34]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP39:%.*]] = fmul <2 x double> [[BLOCK33]], [[SPLAT_SPLAT35]]
; CHECK-NEXT:    [[TMP40:%.*]] = fadd <2 x double> [[TMP37]], [[TMP39]]
; CHECK-NEXT:    [[BLOCK36:%.*]] = shufflevector <4 x double> [[SPLIT2]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP41:%.*]] = extractelement <2 x double> [[SPLIT5]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT37:%.*]] = insertelement <2 x double> poison, double [[TMP41]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT38:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT37]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP42:%.*]] = fmul <2 x double> [[BLOCK36]], [[SPLAT_SPLAT38]]
; CHECK-NEXT:    [[TMP43:%.*]] = fadd <2 x double> [[TMP40]], [[TMP42]]
; CHECK-NEXT:    [[TMP44:%.*]] = shufflevector <2 x double> [[TMP43]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP45:%.*]] = shufflevector <4 x double> [[TMP35]], <4 x double> [[TMP44]], <4 x i32> <i32 0, i32 1, i32 4, i32 5>
; CHECK-NEXT:    store <4 x double> [[TMP25]], ptr [[C:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP47:%.*]] = getelementptr double, ptr [[C]], i64 4
; CHECK-NEXT:    store <4 x double> [[TMP45]], ptr [[VEC_GEP47]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %a = load <6 x double>, ptr %A, align 16
  %b = load <12 x double>, ptr %B, align 16
  %bt = call <12 x double> @llvm.matrix.transpose.v12f64.v12f64(<12 x double> %b, i32 4, i32 3)
  %c = call <8 x double> @llvm.matrix.multiply.v8f64.v6f64.v12f64(<6 x double> %a, <12 x double> %bt, i32 2, i32 3, i32 4)
  %ct = call <8 x double> @llvm.matrix.transpose.v8f64.v8f64(<8 x double> %c, i32 2, i32 4)
  store <8 x double> %ct, ptr %C, align 16
  ret void
}

define void @multiply_ntt_t(ptr %A, ptr %B, ptr %C, ptr %R) {
; REMARK:      Pass:            lower-matrix-intrinsics
; REMARK-NEXT: Name:            matrix-lowered
; REMARK-NEXT: Function:        multiply_ntt_t
; REMARK-NEXT: Args:
; REMARK-NEXT:   - String:          'Lowered with '
; REMARK-NEXT:   - NumStores:       '6'
; REMARK-NEXT:   - String:          ' stores, '
; REMARK-NEXT:   - NumLoads:        '18'
; REMARK-NEXT:   - String:          ' loads, '
; REMARK-NEXT:   - NumComputeOps:   '60'
; REMARK-NEXT:   - String:          ' compute ops, '
; REMARK-NEXT:   - NumExposedTransposes: '0'
; REMARK-NEXT:   - String:          ' exposed transposes'
; REMARK-NEXT:   - String:           |
; REMARK:            store(
; REMARK-NEXT:        multiply.3x3.3x3.double(
; REMARK-NEXT:         multiply.3x3.3x3.double(
; REMARK-NEXT:          load(addr %C),
; REMARK-NEXT:          load(addr %B)),
; REMARK-NEXT:         transpose.3x3.double(load(addr %A))),
; REMARK-NEXT:        addr %R)
; CHECK-LABEL: @multiply_ntt_t(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COL_LOAD:%.*]] = load <3 x double>, ptr [[A:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP:%.*]] = getelementptr double, ptr [[A]], i64 3
; CHECK-NEXT:    [[COL_LOAD58:%.*]] = load <3 x double>, ptr [[VEC_GEP]], align 8
; CHECK-NEXT:    [[VEC_GEP59:%.*]] = getelementptr double, ptr [[A]], i64 6
; CHECK-NEXT:    [[COL_LOAD60:%.*]] = load <3 x double>, ptr [[VEC_GEP59]], align 16
; CHECK-NEXT:    [[TMP0:%.*]] = shufflevector <3 x double> [[COL_LOAD]], <3 x double> [[COL_LOAD58]], <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
; CHECK-NEXT:    [[TMP1:%.*]] = shufflevector <3 x double> [[COL_LOAD60]], <3 x double> poison, <6 x i32> <i32 0, i32 1, i32 2, i32 poison, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP2:%.*]] = shufflevector <6 x double> [[TMP0]], <6 x double> [[TMP1]], <9 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8>
; CHECK-NEXT:    [[COL_LOAD61:%.*]] = load <3 x double>, ptr [[B:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP62:%.*]] = getelementptr double, ptr [[B]], i64 3
; CHECK-NEXT:    [[COL_LOAD63:%.*]] = load <3 x double>, ptr [[VEC_GEP62]], align 8
; CHECK-NEXT:    [[VEC_GEP64:%.*]] = getelementptr double, ptr [[B]], i64 6
; CHECK-NEXT:    [[COL_LOAD65:%.*]] = load <3 x double>, ptr [[VEC_GEP64]], align 16
; CHECK-NEXT:    [[COL_LOAD66:%.*]] = load <3 x double>, ptr [[C:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP67:%.*]] = getelementptr double, ptr [[C]], i64 3
; CHECK-NEXT:    [[COL_LOAD68:%.*]] = load <3 x double>, ptr [[VEC_GEP67]], align 8
; CHECK-NEXT:    [[VEC_GEP69:%.*]] = getelementptr double, ptr [[C]], i64 6
; CHECK-NEXT:    [[COL_LOAD70:%.*]] = load <3 x double>, ptr [[VEC_GEP69]], align 16
; CHECK-NEXT:    [[BLOCK71:%.*]] = shufflevector <3 x double> [[COL_LOAD66]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <3 x double> [[COL_LOAD61]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT72:%.*]] = insertelement <2 x double> poison, double [[TMP3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT73:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT72]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP4:%.*]] = fmul <2 x double> [[BLOCK71]], [[SPLAT_SPLAT73]]
; CHECK-NEXT:    [[BLOCK74:%.*]] = shufflevector <3 x double> [[COL_LOAD68]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <3 x double> [[COL_LOAD61]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT75:%.*]] = insertelement <2 x double> poison, double [[TMP5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT76:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT75]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = fmul <2 x double> [[BLOCK74]], [[SPLAT_SPLAT76]]
; CHECK-NEXT:    [[TMP7:%.*]] = fadd <2 x double> [[TMP4]], [[TMP6]]
; CHECK-NEXT:    [[BLOCK77:%.*]] = shufflevector <3 x double> [[COL_LOAD70]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <3 x double> [[COL_LOAD61]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT78:%.*]] = insertelement <2 x double> poison, double [[TMP8]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT79:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT78]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = fmul <2 x double> [[BLOCK77]], [[SPLAT_SPLAT79]]
; CHECK-NEXT:    [[TMP10:%.*]] = fadd <2 x double> [[TMP7]], [[TMP9]]
; CHECK-NEXT:    [[TMP11:%.*]] = shufflevector <2 x double> [[TMP10]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 poison>
; CHECK-NEXT:    [[TMP12:%.*]] = shufflevector <3 x double> poison, <3 x double> [[TMP11]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK80:%.*]] = shufflevector <3 x double> [[COL_LOAD66]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP13:%.*]] = extractelement <3 x double> [[COL_LOAD61]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT81:%.*]] = insertelement <1 x double> poison, double [[TMP13]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT82:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT81]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP14:%.*]] = fmul <1 x double> [[BLOCK80]], [[SPLAT_SPLAT82]]
; CHECK-NEXT:    [[BLOCK83:%.*]] = shufflevector <3 x double> [[COL_LOAD68]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP15:%.*]] = extractelement <3 x double> [[COL_LOAD61]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT84:%.*]] = insertelement <1 x double> poison, double [[TMP15]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT85:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT84]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP16:%.*]] = fmul <1 x double> [[BLOCK83]], [[SPLAT_SPLAT85]]
; CHECK-NEXT:    [[TMP17:%.*]] = fadd <1 x double> [[TMP14]], [[TMP16]]
; CHECK-NEXT:    [[BLOCK86:%.*]] = shufflevector <3 x double> [[COL_LOAD70]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP18:%.*]] = extractelement <3 x double> [[COL_LOAD61]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT87:%.*]] = insertelement <1 x double> poison, double [[TMP18]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT88:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT87]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP19:%.*]] = fmul <1 x double> [[BLOCK86]], [[SPLAT_SPLAT88]]
; CHECK-NEXT:    [[TMP20:%.*]] = fadd <1 x double> [[TMP17]], [[TMP19]]
; CHECK-NEXT:    [[TMP21:%.*]] = shufflevector <1 x double> [[TMP20]], <1 x double> poison, <3 x i32> <i32 0, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP22:%.*]] = shufflevector <3 x double> [[TMP12]], <3 x double> [[TMP21]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    [[BLOCK89:%.*]] = shufflevector <3 x double> [[COL_LOAD66]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP23:%.*]] = extractelement <3 x double> [[COL_LOAD63]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT90:%.*]] = insertelement <2 x double> poison, double [[TMP23]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT91:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT90]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP24:%.*]] = fmul <2 x double> [[BLOCK89]], [[SPLAT_SPLAT91]]
; CHECK-NEXT:    [[BLOCK92:%.*]] = shufflevector <3 x double> [[COL_LOAD68]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP25:%.*]] = extractelement <3 x double> [[COL_LOAD63]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT93:%.*]] = insertelement <2 x double> poison, double [[TMP25]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT94:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT93]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP26:%.*]] = fmul <2 x double> [[BLOCK92]], [[SPLAT_SPLAT94]]
; CHECK-NEXT:    [[TMP27:%.*]] = fadd <2 x double> [[TMP24]], [[TMP26]]
; CHECK-NEXT:    [[BLOCK95:%.*]] = shufflevector <3 x double> [[COL_LOAD70]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP28:%.*]] = extractelement <3 x double> [[COL_LOAD63]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT96:%.*]] = insertelement <2 x double> poison, double [[TMP28]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT97:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT96]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP29:%.*]] = fmul <2 x double> [[BLOCK95]], [[SPLAT_SPLAT97]]
; CHECK-NEXT:    [[TMP30:%.*]] = fadd <2 x double> [[TMP27]], [[TMP29]]
; CHECK-NEXT:    [[TMP31:%.*]] = shufflevector <2 x double> [[TMP30]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 poison>
; CHECK-NEXT:    [[TMP32:%.*]] = shufflevector <3 x double> poison, <3 x double> [[TMP31]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK98:%.*]] = shufflevector <3 x double> [[COL_LOAD66]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP33:%.*]] = extractelement <3 x double> [[COL_LOAD63]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT99:%.*]] = insertelement <1 x double> poison, double [[TMP33]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT100:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT99]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP34:%.*]] = fmul <1 x double> [[BLOCK98]], [[SPLAT_SPLAT100]]
; CHECK-NEXT:    [[BLOCK101:%.*]] = shufflevector <3 x double> [[COL_LOAD68]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP35:%.*]] = extractelement <3 x double> [[COL_LOAD63]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT102:%.*]] = insertelement <1 x double> poison, double [[TMP35]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT103:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT102]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP36:%.*]] = fmul <1 x double> [[BLOCK101]], [[SPLAT_SPLAT103]]
; CHECK-NEXT:    [[TMP37:%.*]] = fadd <1 x double> [[TMP34]], [[TMP36]]
; CHECK-NEXT:    [[BLOCK104:%.*]] = shufflevector <3 x double> [[COL_LOAD70]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP38:%.*]] = extractelement <3 x double> [[COL_LOAD63]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT105:%.*]] = insertelement <1 x double> poison, double [[TMP38]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT106:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT105]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP39:%.*]] = fmul <1 x double> [[BLOCK104]], [[SPLAT_SPLAT106]]
; CHECK-NEXT:    [[TMP40:%.*]] = fadd <1 x double> [[TMP37]], [[TMP39]]
; CHECK-NEXT:    [[TMP41:%.*]] = shufflevector <1 x double> [[TMP40]], <1 x double> poison, <3 x i32> <i32 0, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP42:%.*]] = shufflevector <3 x double> [[TMP32]], <3 x double> [[TMP41]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    [[BLOCK107:%.*]] = shufflevector <3 x double> [[COL_LOAD66]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP43:%.*]] = extractelement <3 x double> [[COL_LOAD65]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT108:%.*]] = insertelement <2 x double> poison, double [[TMP43]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT109:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT108]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP44:%.*]] = fmul <2 x double> [[BLOCK107]], [[SPLAT_SPLAT109]]
; CHECK-NEXT:    [[BLOCK110:%.*]] = shufflevector <3 x double> [[COL_LOAD68]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP45:%.*]] = extractelement <3 x double> [[COL_LOAD65]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT111:%.*]] = insertelement <2 x double> poison, double [[TMP45]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT112:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT111]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP46:%.*]] = fmul <2 x double> [[BLOCK110]], [[SPLAT_SPLAT112]]
; CHECK-NEXT:    [[TMP47:%.*]] = fadd <2 x double> [[TMP44]], [[TMP46]]
; CHECK-NEXT:    [[BLOCK113:%.*]] = shufflevector <3 x double> [[COL_LOAD70]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP48:%.*]] = extractelement <3 x double> [[COL_LOAD65]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT114:%.*]] = insertelement <2 x double> poison, double [[TMP48]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT115:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT114]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP49:%.*]] = fmul <2 x double> [[BLOCK113]], [[SPLAT_SPLAT115]]
; CHECK-NEXT:    [[TMP50:%.*]] = fadd <2 x double> [[TMP47]], [[TMP49]]
; CHECK-NEXT:    [[TMP51:%.*]] = shufflevector <2 x double> [[TMP50]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 poison>
; CHECK-NEXT:    [[TMP52:%.*]] = shufflevector <3 x double> poison, <3 x double> [[TMP51]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK116:%.*]] = shufflevector <3 x double> [[COL_LOAD66]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP53:%.*]] = extractelement <3 x double> [[COL_LOAD65]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT117:%.*]] = insertelement <1 x double> poison, double [[TMP53]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT118:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT117]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP54:%.*]] = fmul <1 x double> [[BLOCK116]], [[SPLAT_SPLAT118]]
; CHECK-NEXT:    [[BLOCK119:%.*]] = shufflevector <3 x double> [[COL_LOAD68]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP55:%.*]] = extractelement <3 x double> [[COL_LOAD65]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT120:%.*]] = insertelement <1 x double> poison, double [[TMP55]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT121:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT120]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP56:%.*]] = fmul <1 x double> [[BLOCK119]], [[SPLAT_SPLAT121]]
; CHECK-NEXT:    [[TMP57:%.*]] = fadd <1 x double> [[TMP54]], [[TMP56]]
; CHECK-NEXT:    [[BLOCK122:%.*]] = shufflevector <3 x double> [[COL_LOAD70]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP58:%.*]] = extractelement <3 x double> [[COL_LOAD65]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT123:%.*]] = insertelement <1 x double> poison, double [[TMP58]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT124:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT123]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP59:%.*]] = fmul <1 x double> [[BLOCK122]], [[SPLAT_SPLAT124]]
; CHECK-NEXT:    [[TMP60:%.*]] = fadd <1 x double> [[TMP57]], [[TMP59]]
; CHECK-NEXT:    [[TMP61:%.*]] = shufflevector <1 x double> [[TMP60]], <1 x double> poison, <3 x i32> <i32 0, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP62:%.*]] = shufflevector <3 x double> [[TMP52]], <3 x double> [[TMP61]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    [[TMP63:%.*]] = shufflevector <3 x double> [[TMP22]], <3 x double> [[TMP42]], <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
; CHECK-NEXT:    [[TMP64:%.*]] = shufflevector <3 x double> [[TMP62]], <3 x double> poison, <6 x i32> <i32 0, i32 1, i32 2, i32 poison, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP65:%.*]] = shufflevector <6 x double> [[TMP63]], <6 x double> [[TMP64]], <9 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8>
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <9 x double> [[TMP65]], <9 x double> poison, <3 x i32> <i32 0, i32 1, i32 2>
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <9 x double> [[TMP65]], <9 x double> poison, <3 x i32> <i32 3, i32 4, i32 5>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <9 x double> [[TMP65]], <9 x double> poison, <3 x i32> <i32 6, i32 7, i32 8>
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <9 x double> [[TMP2]], <9 x double> poison, <3 x i32> <i32 0, i32 1, i32 2>
; CHECK-NEXT:    [[SPLIT5:%.*]] = shufflevector <9 x double> [[TMP2]], <9 x double> poison, <3 x i32> <i32 3, i32 4, i32 5>
; CHECK-NEXT:    [[SPLIT6:%.*]] = shufflevector <9 x double> [[TMP2]], <9 x double> poison, <3 x i32> <i32 6, i32 7, i32 8>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <3 x double> [[SPLIT]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP66:%.*]] = extractelement <3 x double> [[SPLIT4]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <2 x double> poison, double [[TMP66]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP67:%.*]] = fmul <2 x double> [[BLOCK]], [[SPLAT_SPLAT]]
; CHECK-NEXT:    [[BLOCK7:%.*]] = shufflevector <3 x double> [[SPLIT2]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP68:%.*]] = extractelement <3 x double> [[SPLIT5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT8:%.*]] = insertelement <2 x double> poison, double [[TMP68]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT9:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT8]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP69:%.*]] = fmul <2 x double> [[BLOCK7]], [[SPLAT_SPLAT9]]
; CHECK-NEXT:    [[TMP70:%.*]] = fadd <2 x double> [[TMP67]], [[TMP69]]
; CHECK-NEXT:    [[BLOCK10:%.*]] = shufflevector <3 x double> [[SPLIT3]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP71:%.*]] = extractelement <3 x double> [[SPLIT6]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT11:%.*]] = insertelement <2 x double> poison, double [[TMP71]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT12:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT11]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP72:%.*]] = fmul <2 x double> [[BLOCK10]], [[SPLAT_SPLAT12]]
; CHECK-NEXT:    [[TMP73:%.*]] = fadd <2 x double> [[TMP70]], [[TMP72]]
; CHECK-NEXT:    [[TMP74:%.*]] = shufflevector <2 x double> [[TMP73]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 poison>
; CHECK-NEXT:    [[TMP75:%.*]] = shufflevector <3 x double> poison, <3 x double> [[TMP74]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK13:%.*]] = shufflevector <3 x double> [[SPLIT]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP76:%.*]] = extractelement <3 x double> [[SPLIT4]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT14:%.*]] = insertelement <1 x double> poison, double [[TMP76]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT15:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT14]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP77:%.*]] = fmul <1 x double> [[BLOCK13]], [[SPLAT_SPLAT15]]
; CHECK-NEXT:    [[BLOCK16:%.*]] = shufflevector <3 x double> [[SPLIT2]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP78:%.*]] = extractelement <3 x double> [[SPLIT5]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT17:%.*]] = insertelement <1 x double> poison, double [[TMP78]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT18:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT17]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP79:%.*]] = fmul <1 x double> [[BLOCK16]], [[SPLAT_SPLAT18]]
; CHECK-NEXT:    [[TMP80:%.*]] = fadd <1 x double> [[TMP77]], [[TMP79]]
; CHECK-NEXT:    [[BLOCK19:%.*]] = shufflevector <3 x double> [[SPLIT3]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP81:%.*]] = extractelement <3 x double> [[SPLIT6]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT20:%.*]] = insertelement <1 x double> poison, double [[TMP81]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT21:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT20]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP82:%.*]] = fmul <1 x double> [[BLOCK19]], [[SPLAT_SPLAT21]]
; CHECK-NEXT:    [[TMP83:%.*]] = fadd <1 x double> [[TMP80]], [[TMP82]]
; CHECK-NEXT:    [[TMP84:%.*]] = shufflevector <1 x double> [[TMP83]], <1 x double> poison, <3 x i32> <i32 0, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP85:%.*]] = shufflevector <3 x double> [[TMP75]], <3 x double> [[TMP84]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    [[BLOCK22:%.*]] = shufflevector <3 x double> [[SPLIT]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP86:%.*]] = extractelement <3 x double> [[SPLIT4]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT23:%.*]] = insertelement <2 x double> poison, double [[TMP86]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT24:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT23]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP87:%.*]] = fmul <2 x double> [[BLOCK22]], [[SPLAT_SPLAT24]]
; CHECK-NEXT:    [[BLOCK25:%.*]] = shufflevector <3 x double> [[SPLIT2]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP88:%.*]] = extractelement <3 x double> [[SPLIT5]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT26:%.*]] = insertelement <2 x double> poison, double [[TMP88]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT27:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT26]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP89:%.*]] = fmul <2 x double> [[BLOCK25]], [[SPLAT_SPLAT27]]
; CHECK-NEXT:    [[TMP90:%.*]] = fadd <2 x double> [[TMP87]], [[TMP89]]
; CHECK-NEXT:    [[BLOCK28:%.*]] = shufflevector <3 x double> [[SPLIT3]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP91:%.*]] = extractelement <3 x double> [[SPLIT6]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT29:%.*]] = insertelement <2 x double> poison, double [[TMP91]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT30:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT29]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP92:%.*]] = fmul <2 x double> [[BLOCK28]], [[SPLAT_SPLAT30]]
; CHECK-NEXT:    [[TMP93:%.*]] = fadd <2 x double> [[TMP90]], [[TMP92]]
; CHECK-NEXT:    [[TMP94:%.*]] = shufflevector <2 x double> [[TMP93]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 poison>
; CHECK-NEXT:    [[TMP95:%.*]] = shufflevector <3 x double> poison, <3 x double> [[TMP94]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK31:%.*]] = shufflevector <3 x double> [[SPLIT]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP96:%.*]] = extractelement <3 x double> [[SPLIT4]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT32:%.*]] = insertelement <1 x double> poison, double [[TMP96]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT33:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT32]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP97:%.*]] = fmul <1 x double> [[BLOCK31]], [[SPLAT_SPLAT33]]
; CHECK-NEXT:    [[BLOCK34:%.*]] = shufflevector <3 x double> [[SPLIT2]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP98:%.*]] = extractelement <3 x double> [[SPLIT5]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT35:%.*]] = insertelement <1 x double> poison, double [[TMP98]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT36:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT35]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP99:%.*]] = fmul <1 x double> [[BLOCK34]], [[SPLAT_SPLAT36]]
; CHECK-NEXT:    [[TMP100:%.*]] = fadd <1 x double> [[TMP97]], [[TMP99]]
; CHECK-NEXT:    [[BLOCK37:%.*]] = shufflevector <3 x double> [[SPLIT3]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP101:%.*]] = extractelement <3 x double> [[SPLIT6]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT38:%.*]] = insertelement <1 x double> poison, double [[TMP101]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT39:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT38]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP102:%.*]] = fmul <1 x double> [[BLOCK37]], [[SPLAT_SPLAT39]]
; CHECK-NEXT:    [[TMP103:%.*]] = fadd <1 x double> [[TMP100]], [[TMP102]]
; CHECK-NEXT:    [[TMP104:%.*]] = shufflevector <1 x double> [[TMP103]], <1 x double> poison, <3 x i32> <i32 0, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP105:%.*]] = shufflevector <3 x double> [[TMP95]], <3 x double> [[TMP104]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    [[BLOCK40:%.*]] = shufflevector <3 x double> [[SPLIT]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP106:%.*]] = extractelement <3 x double> [[SPLIT4]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT41:%.*]] = insertelement <2 x double> poison, double [[TMP106]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT42:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT41]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP107:%.*]] = fmul <2 x double> [[BLOCK40]], [[SPLAT_SPLAT42]]
; CHECK-NEXT:    [[BLOCK43:%.*]] = shufflevector <3 x double> [[SPLIT2]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP108:%.*]] = extractelement <3 x double> [[SPLIT5]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT44:%.*]] = insertelement <2 x double> poison, double [[TMP108]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT45:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT44]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP109:%.*]] = fmul <2 x double> [[BLOCK43]], [[SPLAT_SPLAT45]]
; CHECK-NEXT:    [[TMP110:%.*]] = fadd <2 x double> [[TMP107]], [[TMP109]]
; CHECK-NEXT:    [[BLOCK46:%.*]] = shufflevector <3 x double> [[SPLIT3]], <3 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP111:%.*]] = extractelement <3 x double> [[SPLIT6]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT47:%.*]] = insertelement <2 x double> poison, double [[TMP111]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT48:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT47]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP112:%.*]] = fmul <2 x double> [[BLOCK46]], [[SPLAT_SPLAT48]]
; CHECK-NEXT:    [[TMP113:%.*]] = fadd <2 x double> [[TMP110]], [[TMP112]]
; CHECK-NEXT:    [[TMP114:%.*]] = shufflevector <2 x double> [[TMP113]], <2 x double> poison, <3 x i32> <i32 0, i32 1, i32 poison>
; CHECK-NEXT:    [[TMP115:%.*]] = shufflevector <3 x double> poison, <3 x double> [[TMP114]], <3 x i32> <i32 3, i32 4, i32 2>
; CHECK-NEXT:    [[BLOCK49:%.*]] = shufflevector <3 x double> [[SPLIT]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP116:%.*]] = extractelement <3 x double> [[SPLIT4]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT50:%.*]] = insertelement <1 x double> poison, double [[TMP116]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT51:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT50]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP117:%.*]] = fmul <1 x double> [[BLOCK49]], [[SPLAT_SPLAT51]]
; CHECK-NEXT:    [[BLOCK52:%.*]] = shufflevector <3 x double> [[SPLIT2]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP118:%.*]] = extractelement <3 x double> [[SPLIT5]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT53:%.*]] = insertelement <1 x double> poison, double [[TMP118]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT54:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT53]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP119:%.*]] = fmul <1 x double> [[BLOCK52]], [[SPLAT_SPLAT54]]
; CHECK-NEXT:    [[TMP120:%.*]] = fadd <1 x double> [[TMP117]], [[TMP119]]
; CHECK-NEXT:    [[BLOCK55:%.*]] = shufflevector <3 x double> [[SPLIT3]], <3 x double> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[TMP121:%.*]] = extractelement <3 x double> [[SPLIT6]], i64 2
; CHECK-NEXT:    [[SPLAT_SPLATINSERT56:%.*]] = insertelement <1 x double> poison, double [[TMP121]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT57:%.*]] = shufflevector <1 x double> [[SPLAT_SPLATINSERT56]], <1 x double> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP122:%.*]] = fmul <1 x double> [[BLOCK55]], [[SPLAT_SPLAT57]]
; CHECK-NEXT:    [[TMP123:%.*]] = fadd <1 x double> [[TMP120]], [[TMP122]]
; CHECK-NEXT:    [[TMP124:%.*]] = shufflevector <1 x double> [[TMP123]], <1 x double> poison, <3 x i32> <i32 0, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP125:%.*]] = shufflevector <3 x double> [[TMP115]], <3 x double> [[TMP124]], <3 x i32> <i32 0, i32 1, i32 3>
; CHECK-NEXT:    store <3 x double> [[TMP85]], ptr [[R:%.*]], align 16
; CHECK-NEXT:    [[VEC_GEP125:%.*]] = getelementptr double, ptr [[R]], i64 3
; CHECK-NEXT:    store <3 x double> [[TMP105]], ptr [[VEC_GEP125]], align 8
; CHECK-NEXT:    [[VEC_GEP126:%.*]] = getelementptr double, ptr [[R]], i64 6
; CHECK-NEXT:    store <3 x double> [[TMP125]], ptr [[VEC_GEP126]], align 16
; CHECK-NEXT:    ret void
;
entry:
  %a = load <9 x double>, ptr %A, align 16
  %b = load <9 x double>, ptr %B, align 16
  %bt = call <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double> %b, i32 3, i32 3)
  %c = load <9 x double>, ptr %C, align 16
  %ct = call <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double> %c, i32 3, i32 3)
  %btct = call <9 x double> @llvm.matrix.multiply.v9f64.v9f64.v9f64(<9 x double> %bt, <9 x double> %ct, i32 3, i32 3, i32 3)
  %abtct= call <9 x double> @llvm.matrix.multiply.v9f64.v9f64.v9f64(<9 x double> %a, <9 x double> %btct, i32 3, i32 3, i32 3)
  %abtct_t = call <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double> %abtct, i32 3, i32 3)
  store <9 x double> %abtct_t, ptr %R, align 16
  ret void
}

define <4 x float> @mult_tt_same_op(<4 x float> %a) {
; CHECK-LABEL: @mult_tt_same_op(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <4 x float> [[A:%.*]], <4 x float> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <4 x float> [[A]], <4 x float> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <4 x float> [[A]], <4 x float> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <4 x float> [[A]], <4 x float> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <2 x float> [[SPLIT]], <2 x float> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP0:%.*]] = extractelement <2 x float> [[SPLIT2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <2 x float> poison, float [[TMP0]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <2 x float> [[SPLAT_SPLATINSERT]], <2 x float> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP1:%.*]] = fmul <2 x float> [[BLOCK]], [[SPLAT_SPLAT]]
; CHECK-NEXT:    [[BLOCK4:%.*]] = shufflevector <2 x float> [[SPLIT1]], <2 x float> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <2 x float> [[SPLIT2]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT5:%.*]] = insertelement <2 x float> poison, float [[TMP2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT6:%.*]] = shufflevector <2 x float> [[SPLAT_SPLATINSERT5]], <2 x float> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = fmul <2 x float> [[BLOCK4]], [[SPLAT_SPLAT6]]
; CHECK-NEXT:    [[TMP4:%.*]] = fadd <2 x float> [[TMP1]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = shufflevector <2 x float> [[TMP4]], <2 x float> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP6:%.*]] = shufflevector <2 x float> poison, <2 x float> [[TMP5]], <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK7:%.*]] = shufflevector <2 x float> [[SPLIT]], <2 x float> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP7:%.*]] = extractelement <2 x float> [[SPLIT3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT8:%.*]] = insertelement <2 x float> poison, float [[TMP7]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT9:%.*]] = shufflevector <2 x float> [[SPLAT_SPLATINSERT8]], <2 x float> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = fmul <2 x float> [[BLOCK7]], [[SPLAT_SPLAT9]]
; CHECK-NEXT:    [[BLOCK10:%.*]] = shufflevector <2 x float> [[SPLIT1]], <2 x float> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP9:%.*]] = extractelement <2 x float> [[SPLIT3]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT11:%.*]] = insertelement <2 x float> poison, float [[TMP9]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT12:%.*]] = shufflevector <2 x float> [[SPLAT_SPLATINSERT11]], <2 x float> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP10:%.*]] = fmul <2 x float> [[BLOCK10]], [[SPLAT_SPLAT12]]
; CHECK-NEXT:    [[TMP11:%.*]] = fadd <2 x float> [[TMP8]], [[TMP10]]
; CHECK-NEXT:    [[TMP12:%.*]] = shufflevector <2 x float> [[TMP11]], <2 x float> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP13:%.*]] = shufflevector <2 x float> poison, <2 x float> [[TMP12]], <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP14:%.*]] = extractelement <2 x float> [[TMP6]], i64 0
; CHECK-NEXT:    [[TMP15:%.*]] = insertelement <2 x float> poison, float [[TMP14]], i64 0
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <2 x float> [[TMP13]], i64 0
; CHECK-NEXT:    [[TMP17:%.*]] = insertelement <2 x float> [[TMP15]], float [[TMP16]], i64 1
; CHECK-NEXT:    [[TMP18:%.*]] = extractelement <2 x float> [[TMP6]], i64 1
; CHECK-NEXT:    [[TMP19:%.*]] = insertelement <2 x float> poison, float [[TMP18]], i64 0
; CHECK-NEXT:    [[TMP20:%.*]] = extractelement <2 x float> [[TMP13]], i64 1
; CHECK-NEXT:    [[TMP21:%.*]] = insertelement <2 x float> [[TMP19]], float [[TMP20]], i64 1
; CHECK-NEXT:    [[TMP22:%.*]] = shufflevector <2 x float> [[TMP17]], <2 x float> [[TMP21]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    ret <4 x float> [[TMP22]]
;
entry:
  %t = call <4 x float> @llvm.matrix.transpose.v4f32(<4 x float> %a, i32 2, i32 2)
  %m = call <4 x float> @llvm.matrix.multiply.v4f32.v4f32.v4f32(<4 x float> %t, <4 x float> %t, i32 2, i32 2, i32 2)
  ret <4 x float> %m
}

define <6 x double> @transpose_of_transpose_of_non_matrix_op(ptr %a) {
; CHECK-LABEL: @transpose_of_transpose_of_non_matrix_op(
; CHECK-NEXT:    [[COL_LOAD:%.*]] = load <2 x double>, ptr [[A:%.*]], align 8
; CHECK-NEXT:    [[VEC_GEP:%.*]] = getelementptr double, ptr [[A]], i64 4
; CHECK-NEXT:    [[COL_LOAD1:%.*]] = load <2 x double>, ptr [[VEC_GEP]], align 8
; CHECK-NEXT:    [[VEC_GEP2:%.*]] = getelementptr double, ptr [[A]], i64 8
; CHECK-NEXT:    [[COL_LOAD3:%.*]] = load <2 x double>, ptr [[VEC_GEP2]], align 8
; CHECK-NEXT:    [[VEC_GEP4:%.*]] = getelementptr double, ptr [[A]], i64 12
; CHECK-NEXT:    [[COL_LOAD5:%.*]] = load <2 x double>, ptr [[VEC_GEP4]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = shufflevector <2 x double> [[COL_LOAD]], <2 x double> [[COL_LOAD1]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[TMP2:%.*]] = shufflevector <2 x double> [[COL_LOAD3]], <2 x double> [[COL_LOAD5]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[TMP3:%.*]] = shufflevector <4 x double> [[TMP1]], <4 x double> [[TMP2]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[SHUF:%.*]] = shufflevector <8 x double> [[TMP3]], <8 x double> poison, <6 x i32> <i32 0, i32 1, i32 2, i32 4, i32 5, i32 6>
; CHECK-NEXT:    ret <6 x double> [[SHUF]]
;
  %load = call <8 x double> @llvm.matrix.column.major.load.v8f64(ptr %a, i64 4, i1 false, i32 2, i32 4)
  %shuf = shufflevector <8 x double> %load, <8 x double> poison, <6 x i32> <i32 0, i32 1, i32 2, i32 4, i32 5, i32 6>
  %t = call <6 x double> @llvm.matrix.transpose.v6f64.v6f64(<6 x double> %shuf, i32 3, i32 2)
  %tt = call <6 x double> @llvm.matrix.transpose.v6f64.v6f64(<6 x double> %t, i32 2, i32 3)
  ret <6 x double> %tt
}

define <12 x double> @factor_transpose(<6 x double> %a, <8 x double> %b) {
; CHECK-LABEL: @factor_transpose(
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <8 x double> [[B:%.*]], <8 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <8 x double> [[B]], <8 x double> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <6 x double> [[A:%.*]], <6 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <6 x double> [[A]], <6 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <6 x double> [[A]], <6 x double> poison, <2 x i32> <i32 4, i32 5>
; CHECK-NEXT:    [[BLOCK:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP1:%.*]] = extractelement <2 x double> [[SPLIT2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT:%.*]] = insertelement <2 x double> poison, double [[TMP1]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP2:%.*]] = fmul <2 x double> [[BLOCK]], [[SPLAT_SPLAT]]
; CHECK-NEXT:    [[BLOCK5:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <2 x double> [[SPLIT2]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT6:%.*]] = insertelement <2 x double> poison, double [[TMP3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT7:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT6]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP4:%.*]] = fmul <2 x double> [[BLOCK5]], [[SPLAT_SPLAT7]]
; CHECK-NEXT:    [[TMP5:%.*]] = fadd <2 x double> [[TMP2]], [[TMP4]]
; CHECK-NEXT:    [[TMP6:%.*]] = shufflevector <2 x double> [[TMP5]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP7:%.*]] = shufflevector <4 x double> poison, <4 x double> [[TMP6]], <4 x i32> <i32 4, i32 5, i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK8:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <2 x double> [[SPLIT2]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT9:%.*]] = insertelement <2 x double> poison, double [[TMP8]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT10:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT9]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = fmul <2 x double> [[BLOCK8]], [[SPLAT_SPLAT10]]
; CHECK-NEXT:    [[BLOCK11:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP10:%.*]] = extractelement <2 x double> [[SPLIT2]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT12:%.*]] = insertelement <2 x double> poison, double [[TMP10]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT13:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT12]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP11:%.*]] = fmul <2 x double> [[BLOCK11]], [[SPLAT_SPLAT13]]
; CHECK-NEXT:    [[TMP12:%.*]] = fadd <2 x double> [[TMP9]], [[TMP11]]
; CHECK-NEXT:    [[TMP13:%.*]] = shufflevector <2 x double> [[TMP12]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP14:%.*]] = shufflevector <4 x double> [[TMP7]], <4 x double> [[TMP13]], <4 x i32> <i32 0, i32 1, i32 4, i32 5>
; CHECK-NEXT:    [[BLOCK14:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP15:%.*]] = extractelement <2 x double> [[SPLIT3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT15:%.*]] = insertelement <2 x double> poison, double [[TMP15]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT16:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT15]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP16:%.*]] = fmul <2 x double> [[BLOCK14]], [[SPLAT_SPLAT16]]
; CHECK-NEXT:    [[BLOCK17:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <2 x double> [[SPLIT3]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT18:%.*]] = insertelement <2 x double> poison, double [[TMP17]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT19:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT18]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP18:%.*]] = fmul <2 x double> [[BLOCK17]], [[SPLAT_SPLAT19]]
; CHECK-NEXT:    [[TMP19:%.*]] = fadd <2 x double> [[TMP16]], [[TMP18]]
; CHECK-NEXT:    [[TMP20:%.*]] = shufflevector <2 x double> [[TMP19]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP21:%.*]] = shufflevector <4 x double> poison, <4 x double> [[TMP20]], <4 x i32> <i32 4, i32 5, i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK20:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP22:%.*]] = extractelement <2 x double> [[SPLIT3]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT21:%.*]] = insertelement <2 x double> poison, double [[TMP22]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT22:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT21]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP23:%.*]] = fmul <2 x double> [[BLOCK20]], [[SPLAT_SPLAT22]]
; CHECK-NEXT:    [[BLOCK23:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP24:%.*]] = extractelement <2 x double> [[SPLIT3]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT24:%.*]] = insertelement <2 x double> poison, double [[TMP24]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT25:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT24]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP25:%.*]] = fmul <2 x double> [[BLOCK23]], [[SPLAT_SPLAT25]]
; CHECK-NEXT:    [[TMP26:%.*]] = fadd <2 x double> [[TMP23]], [[TMP25]]
; CHECK-NEXT:    [[TMP27:%.*]] = shufflevector <2 x double> [[TMP26]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP28:%.*]] = shufflevector <4 x double> [[TMP21]], <4 x double> [[TMP27]], <4 x i32> <i32 0, i32 1, i32 4, i32 5>
; CHECK-NEXT:    [[BLOCK26:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP29:%.*]] = extractelement <2 x double> [[SPLIT4]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT27:%.*]] = insertelement <2 x double> poison, double [[TMP29]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT28:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT27]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP30:%.*]] = fmul <2 x double> [[BLOCK26]], [[SPLAT_SPLAT28]]
; CHECK-NEXT:    [[BLOCK29:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[TMP31:%.*]] = extractelement <2 x double> [[SPLIT4]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT30:%.*]] = insertelement <2 x double> poison, double [[TMP31]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT31:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT30]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP32:%.*]] = fmul <2 x double> [[BLOCK29]], [[SPLAT_SPLAT31]]
; CHECK-NEXT:    [[TMP33:%.*]] = fadd <2 x double> [[TMP30]], [[TMP32]]
; CHECK-NEXT:    [[TMP34:%.*]] = shufflevector <2 x double> [[TMP33]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP35:%.*]] = shufflevector <4 x double> poison, <4 x double> [[TMP34]], <4 x i32> <i32 4, i32 5, i32 2, i32 3>
; CHECK-NEXT:    [[BLOCK32:%.*]] = shufflevector <4 x double> [[SPLIT]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP36:%.*]] = extractelement <2 x double> [[SPLIT4]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLATINSERT33:%.*]] = insertelement <2 x double> poison, double [[TMP36]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT34:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT33]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP37:%.*]] = fmul <2 x double> [[BLOCK32]], [[SPLAT_SPLAT34]]
; CHECK-NEXT:    [[BLOCK35:%.*]] = shufflevector <4 x double> [[SPLIT1]], <4 x double> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[TMP38:%.*]] = extractelement <2 x double> [[SPLIT4]], i64 1
; CHECK-NEXT:    [[SPLAT_SPLATINSERT36:%.*]] = insertelement <2 x double> poison, double [[TMP38]], i64 0
; CHECK-NEXT:    [[SPLAT_SPLAT37:%.*]] = shufflevector <2 x double> [[SPLAT_SPLATINSERT36]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP39:%.*]] = fmul <2 x double> [[BLOCK35]], [[SPLAT_SPLAT37]]
; CHECK-NEXT:    [[TMP40:%.*]] = fadd <2 x double> [[TMP37]], [[TMP39]]
; CHECK-NEXT:    [[TMP41:%.*]] = shufflevector <2 x double> [[TMP40]], <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP42:%.*]] = shufflevector <4 x double> [[TMP35]], <4 x double> [[TMP41]], <4 x i32> <i32 0, i32 1, i32 4, i32 5>
; CHECK-NEXT:    [[TMP43:%.*]] = extractelement <4 x double> [[TMP14]], i64 0
; CHECK-NEXT:    [[TMP44:%.*]] = insertelement <3 x double> poison, double [[TMP43]], i64 0
; CHECK-NEXT:    [[TMP45:%.*]] = extractelement <4 x double> [[TMP28]], i64 0
; CHECK-NEXT:    [[TMP46:%.*]] = insertelement <3 x double> [[TMP44]], double [[TMP45]], i64 1
; CHECK-NEXT:    [[TMP47:%.*]] = extractelement <4 x double> [[TMP42]], i64 0
; CHECK-NEXT:    [[TMP48:%.*]] = insertelement <3 x double> [[TMP46]], double [[TMP47]], i64 2
; CHECK-NEXT:    [[TMP49:%.*]] = extractelement <4 x double> [[TMP14]], i64 1
; CHECK-NEXT:    [[TMP50:%.*]] = insertelement <3 x double> poison, double [[TMP49]], i64 0
; CHECK-NEXT:    [[TMP51:%.*]] = extractelement <4 x double> [[TMP28]], i64 1
; CHECK-NEXT:    [[TMP52:%.*]] = insertelement <3 x double> [[TMP50]], double [[TMP51]], i64 1
; CHECK-NEXT:    [[TMP53:%.*]] = extractelement <4 x double> [[TMP42]], i64 1
; CHECK-NEXT:    [[TMP54:%.*]] = insertelement <3 x double> [[TMP52]], double [[TMP53]], i64 2
; CHECK-NEXT:    [[TMP55:%.*]] = extractelement <4 x double> [[TMP14]], i64 2
; CHECK-NEXT:    [[TMP56:%.*]] = insertelement <3 x double> poison, double [[TMP55]], i64 0
; CHECK-NEXT:    [[TMP57:%.*]] = extractelement <4 x double> [[TMP28]], i64 2
; CHECK-NEXT:    [[TMP58:%.*]] = insertelement <3 x double> [[TMP56]], double [[TMP57]], i64 1
; CHECK-NEXT:    [[TMP59:%.*]] = extractelement <4 x double> [[TMP42]], i64 2
; CHECK-NEXT:    [[TMP60:%.*]] = insertelement <3 x double> [[TMP58]], double [[TMP59]], i64 2
; CHECK-NEXT:    [[TMP61:%.*]] = extractelement <4 x double> [[TMP14]], i64 3
; CHECK-NEXT:    [[TMP62:%.*]] = insertelement <3 x double> poison, double [[TMP61]], i64 0
; CHECK-NEXT:    [[TMP63:%.*]] = extractelement <4 x double> [[TMP28]], i64 3
; CHECK-NEXT:    [[TMP64:%.*]] = insertelement <3 x double> [[TMP62]], double [[TMP63]], i64 1
; CHECK-NEXT:    [[TMP65:%.*]] = extractelement <4 x double> [[TMP42]], i64 3
; CHECK-NEXT:    [[TMP66:%.*]] = insertelement <3 x double> [[TMP64]], double [[TMP65]], i64 2
; CHECK-NEXT:    [[TMP67:%.*]] = shufflevector <3 x double> [[TMP48]], <3 x double> [[TMP54]], <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
; CHECK-NEXT:    [[TMP68:%.*]] = shufflevector <3 x double> [[TMP60]], <3 x double> [[TMP66]], <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
; CHECK-NEXT:    [[TMP69:%.*]] = shufflevector <6 x double> [[TMP67]], <6 x double> [[TMP68]], <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
; CHECK-NEXT:    ret <12 x double> [[TMP69]]
;
  %at = call <6 x double> @llvm.matrix.transpose.v6f64.v6f64(<6 x double> %a, i32 2, i32 3)
  %bt = call <8 x double> @llvm.matrix.transpose.v8f64.v8f64(<8 x double> %b, i32 4, i32 2)
  %m = call <12 x double> @llvm.matrix.multiply.v12f64.v6f64.v8f64(<6 x double> %at, <8 x double> %bt, i32 3, i32 2, i32 4)
  ret <12 x double> %m
}

declare <9 x double> @llvm.matrix.multiply.v9f64.v9f64.v9f64(<9 x double>, <9 x double>, i32, i32, i32)
declare <12 x double> @llvm.matrix.multiply.v12f64.v6f64.v8f64(<6 x double>, <8 x double>, i32, i32, i32)
declare <8 x double> @llvm.matrix.multiply.v8f64.v6f64.v12f64(<6 x double> %a, <12 x double>, i32, i32, i32)
declare <4 x float> @llvm.matrix.multiply.v4f32.v4f32.v4f32(<4 x float>, <4 x float>, i32, i32, i32)
declare <9 x double> @llvm.matrix.transpose.v9f64.v9f64(<9 x double>, i32, i32)
declare <6 x double> @llvm.matrix.transpose.v6f64.v6f64(<6 x double>, i32, i32)
declare <8 x double> @llvm.matrix.transpose.v8f64.v8f64(<8 x double>, i32, i32)
declare <12 x double> @llvm.matrix.transpose.v12f64.v12f64(<12 x double>, i32, i32)
declare <4 x float> @llvm.matrix.transpose.v4f32(<4 x float>, i32, i32)
declare <8 x double> @llvm.matrix.column.major.load.v8f64(ptr, i64, i1, i32, i32)
