; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-- -mattr=avx2 | FileCheck %s --check-prefixes=X86
; RUN: llc < %s -mtriple=x86_64-- -mattr=avx2 | FileCheck %s --check-prefixes=X64

; Make sure this sequence doesn't hang in DAG combine.

define <8 x i32> @foo(<8 x i64> %x, <4 x i64> %y) {
; X86-LABEL: foo:
; X86:       # %bb.0:
; X86-NEXT:    vandps %ymm2, %ymm0, %ymm0
; X86-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}, %ymm1, %ymm1
; X86-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; X86-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; X86-NEXT:    retl
;
; X64-LABEL: foo:
; X64:       # %bb.0:
; X64-NEXT:    vandps %ymm2, %ymm0, %ymm0
; X64-NEXT:    vextractf128 $1, %ymm0, %xmm2
; X64-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[0,2]
; X64-NEXT:    vextractf128 $1, %ymm1, %xmm2
; X64-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,2],xmm2[0,2]
; X64-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; X64-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; X64-NEXT:    retq
  %a = shufflevector <4 x i64> %y, <4 x i64> <i64 12345, i64 67890, i64 13579, i64 24680>, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %b = and <8 x i64> %x, %a
  %c = trunc <8 x i64> %b to <8 x i32>
  ret <8 x i32> %c
}

