; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -target-abi=ilp32d -mattr=+v,+zvfh,+zvfbfmin,+f,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFH,ZVFH32
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+v,+zvfh,+zvfbfmin,+f,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFH,ZVFH64
; RUN: llc -mtriple=riscv32 -target-abi=ilp32d -mattr=+v,+zvfhmin,+zvfbfmin,+f,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFHMIN,ZVFHMIN32
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+v,+zvfhmin,+zvfbfmin,+f,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFHMIN,ZVFHMIN64

define void @si2fp_v2i32_v2f32(ptr %x, ptr %y) {
; CHECK-LABEL: si2fp_v2i32_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    vse32.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x i32>, ptr %x
  %d = sitofp <2 x i32> %a to <2 x float>
  store <2 x float> %d, ptr %y
  ret void
}

define void @ui2fp_v2i32_v2f32(ptr %x, ptr %y) {
; CHECK-LABEL: ui2fp_v2i32_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    vse32.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x i32>, ptr %x
  %d = uitofp <2 x i32> %a to <2 x float>
  store <2 x float> %d, ptr %y
  ret void
}

define <2 x float> @si2fp_v2i1_v2f32(<2 x i1> %x) {
; CHECK-LABEL: si2fp_v2i1_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %z = sitofp <2 x i1> %x to <2 x float>
  ret <2 x float> %z
}

define <2 x float> @si2fp_v2i7_v2f32(<2 x i7> %x) {
; CHECK-LABEL: si2fp_v2i7_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v8
; CHECK-NEXT:    vsra.vi v8, v8, 1
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vsext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %z = sitofp <2 x i7> %x to <2 x float>
  ret <2 x float> %z
}

define <2 x float> @ui2fp_v2i7_v2f32(<2 x i7> %x) {
; CHECK-LABEL: ui2fp_v2i7_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 127
; CHECK-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %z = uitofp <2 x i7> %x to <2 x float>
  ret <2 x float> %z
}

define <2 x float> @ui2fp_v2i1_v2f32(<2 x i1> %x) {
; CHECK-LABEL: ui2fp_v2i1_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %z = uitofp <2 x i1> %x to <2 x float>
  ret <2 x float> %z
}

define void @si2fp_v3i32_v3f32(ptr %x, ptr %y) {
; CHECK-LABEL: si2fp_v3i32_v3f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 3, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    vse32.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <3 x i32>, ptr %x
  %d = sitofp <3 x i32> %a to <3 x float>
  store <3 x float> %d, ptr %y
  ret void
}

define void @ui2fp_v3i32_v3f32(ptr %x, ptr %y) {
; CHECK-LABEL: ui2fp_v3i32_v3f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 3, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    vse32.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <3 x i32>, ptr %x
  %d = uitofp <3 x i32> %a to <3 x float>
  store <3 x float> %d, ptr %y
  ret void
}

define <3 x float> @si2fp_v3i1_v3f32(<3 x i1> %x) {
; CHECK-LABEL: si2fp_v3i1_v3f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %z = sitofp <3 x i1> %x to <3 x float>
  ret <3 x float> %z
}

; FIXME: This gets expanded instead of widened + promoted
define <3 x float> @si2fp_v3i7_v3f32(<3 x i7> %x) {
; ZVFH32-LABEL: si2fp_v3i7_v3f32:
; ZVFH32:       # %bb.0:
; ZVFH32-NEXT:    lw a1, 0(a0)
; ZVFH32-NEXT:    lw a2, 4(a0)
; ZVFH32-NEXT:    lw a0, 8(a0)
; ZVFH32-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; ZVFH32-NEXT:    vmv.v.x v8, a1
; ZVFH32-NEXT:    vslide1down.vx v8, v8, a2
; ZVFH32-NEXT:    vslide1down.vx v8, v8, a0
; ZVFH32-NEXT:    vslidedown.vi v8, v8, 1
; ZVFH32-NEXT:    vadd.vv v8, v8, v8
; ZVFH32-NEXT:    vsra.vi v8, v8, 1
; ZVFH32-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; ZVFH32-NEXT:    vsext.vf2 v9, v8
; ZVFH32-NEXT:    vfwcvt.f.x.v v8, v9
; ZVFH32-NEXT:    ret
;
; ZVFH64-LABEL: si2fp_v3i7_v3f32:
; ZVFH64:       # %bb.0:
; ZVFH64-NEXT:    ld a1, 0(a0)
; ZVFH64-NEXT:    ld a2, 8(a0)
; ZVFH64-NEXT:    ld a0, 16(a0)
; ZVFH64-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; ZVFH64-NEXT:    vmv.v.x v8, a1
; ZVFH64-NEXT:    vslide1down.vx v8, v8, a2
; ZVFH64-NEXT:    vslide1down.vx v8, v8, a0
; ZVFH64-NEXT:    vslidedown.vi v8, v8, 1
; ZVFH64-NEXT:    vadd.vv v8, v8, v8
; ZVFH64-NEXT:    vsra.vi v8, v8, 1
; ZVFH64-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; ZVFH64-NEXT:    vsext.vf2 v9, v8
; ZVFH64-NEXT:    vfwcvt.f.x.v v8, v9
; ZVFH64-NEXT:    ret
;
; ZVFHMIN32-LABEL: si2fp_v3i7_v3f32:
; ZVFHMIN32:       # %bb.0:
; ZVFHMIN32-NEXT:    lw a1, 0(a0)
; ZVFHMIN32-NEXT:    lw a2, 4(a0)
; ZVFHMIN32-NEXT:    lw a0, 8(a0)
; ZVFHMIN32-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; ZVFHMIN32-NEXT:    vmv.v.x v8, a1
; ZVFHMIN32-NEXT:    vslide1down.vx v8, v8, a2
; ZVFHMIN32-NEXT:    vslide1down.vx v8, v8, a0
; ZVFHMIN32-NEXT:    vslidedown.vi v8, v8, 1
; ZVFHMIN32-NEXT:    vadd.vv v8, v8, v8
; ZVFHMIN32-NEXT:    vsra.vi v8, v8, 1
; ZVFHMIN32-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; ZVFHMIN32-NEXT:    vsext.vf2 v9, v8
; ZVFHMIN32-NEXT:    vfwcvt.f.x.v v8, v9
; ZVFHMIN32-NEXT:    ret
;
; ZVFHMIN64-LABEL: si2fp_v3i7_v3f32:
; ZVFHMIN64:       # %bb.0:
; ZVFHMIN64-NEXT:    ld a1, 0(a0)
; ZVFHMIN64-NEXT:    ld a2, 8(a0)
; ZVFHMIN64-NEXT:    ld a0, 16(a0)
; ZVFHMIN64-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; ZVFHMIN64-NEXT:    vmv.v.x v8, a1
; ZVFHMIN64-NEXT:    vslide1down.vx v8, v8, a2
; ZVFHMIN64-NEXT:    vslide1down.vx v8, v8, a0
; ZVFHMIN64-NEXT:    vslidedown.vi v8, v8, 1
; ZVFHMIN64-NEXT:    vadd.vv v8, v8, v8
; ZVFHMIN64-NEXT:    vsra.vi v8, v8, 1
; ZVFHMIN64-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; ZVFHMIN64-NEXT:    vsext.vf2 v9, v8
; ZVFHMIN64-NEXT:    vfwcvt.f.x.v v8, v9
; ZVFHMIN64-NEXT:    ret
  %z = sitofp <3 x i7> %x to <3 x float>
  ret <3 x float> %z
}

; FIXME: This gets expanded instead of widened + promoted
define <3 x float> @ui2fp_v3i7_v3f32(<3 x i7> %x) {
; ZVFH32-LABEL: ui2fp_v3i7_v3f32:
; ZVFH32:       # %bb.0:
; ZVFH32-NEXT:    lw a1, 0(a0)
; ZVFH32-NEXT:    lw a2, 4(a0)
; ZVFH32-NEXT:    lw a0, 8(a0)
; ZVFH32-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; ZVFH32-NEXT:    vmv.v.x v8, a1
; ZVFH32-NEXT:    vslide1down.vx v8, v8, a2
; ZVFH32-NEXT:    vslide1down.vx v8, v8, a0
; ZVFH32-NEXT:    vslidedown.vi v8, v8, 1
; ZVFH32-NEXT:    li a0, 127
; ZVFH32-NEXT:    vand.vx v8, v8, a0
; ZVFH32-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; ZVFH32-NEXT:    vzext.vf2 v9, v8
; ZVFH32-NEXT:    vfwcvt.f.xu.v v8, v9
; ZVFH32-NEXT:    ret
;
; ZVFH64-LABEL: ui2fp_v3i7_v3f32:
; ZVFH64:       # %bb.0:
; ZVFH64-NEXT:    ld a1, 0(a0)
; ZVFH64-NEXT:    ld a2, 8(a0)
; ZVFH64-NEXT:    ld a0, 16(a0)
; ZVFH64-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; ZVFH64-NEXT:    vmv.v.x v8, a1
; ZVFH64-NEXT:    vslide1down.vx v8, v8, a2
; ZVFH64-NEXT:    vslide1down.vx v8, v8, a0
; ZVFH64-NEXT:    vslidedown.vi v8, v8, 1
; ZVFH64-NEXT:    li a0, 127
; ZVFH64-NEXT:    vand.vx v8, v8, a0
; ZVFH64-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; ZVFH64-NEXT:    vzext.vf2 v9, v8
; ZVFH64-NEXT:    vfwcvt.f.xu.v v8, v9
; ZVFH64-NEXT:    ret
;
; ZVFHMIN32-LABEL: ui2fp_v3i7_v3f32:
; ZVFHMIN32:       # %bb.0:
; ZVFHMIN32-NEXT:    lw a1, 0(a0)
; ZVFHMIN32-NEXT:    lw a2, 4(a0)
; ZVFHMIN32-NEXT:    lw a0, 8(a0)
; ZVFHMIN32-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; ZVFHMIN32-NEXT:    vmv.v.x v8, a1
; ZVFHMIN32-NEXT:    vslide1down.vx v8, v8, a2
; ZVFHMIN32-NEXT:    vslide1down.vx v8, v8, a0
; ZVFHMIN32-NEXT:    vslidedown.vi v8, v8, 1
; ZVFHMIN32-NEXT:    li a0, 127
; ZVFHMIN32-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN32-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; ZVFHMIN32-NEXT:    vzext.vf2 v9, v8
; ZVFHMIN32-NEXT:    vfwcvt.f.xu.v v8, v9
; ZVFHMIN32-NEXT:    ret
;
; ZVFHMIN64-LABEL: ui2fp_v3i7_v3f32:
; ZVFHMIN64:       # %bb.0:
; ZVFHMIN64-NEXT:    ld a1, 0(a0)
; ZVFHMIN64-NEXT:    ld a2, 8(a0)
; ZVFHMIN64-NEXT:    ld a0, 16(a0)
; ZVFHMIN64-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; ZVFHMIN64-NEXT:    vmv.v.x v8, a1
; ZVFHMIN64-NEXT:    vslide1down.vx v8, v8, a2
; ZVFHMIN64-NEXT:    vslide1down.vx v8, v8, a0
; ZVFHMIN64-NEXT:    vslidedown.vi v8, v8, 1
; ZVFHMIN64-NEXT:    li a0, 127
; ZVFHMIN64-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN64-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; ZVFHMIN64-NEXT:    vzext.vf2 v9, v8
; ZVFHMIN64-NEXT:    vfwcvt.f.xu.v v8, v9
; ZVFHMIN64-NEXT:    ret
  %z = uitofp <3 x i7> %x to <3 x float>
  ret <3 x float> %z
}

define <3 x float> @ui2fp_v3i1_v3f32(<3 x i1> %x) {
; CHECK-LABEL: ui2fp_v3i1_v3f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %z = uitofp <3 x i1> %x to <3 x float>
  ret <3 x float> %z
}

define void @si2fp_v8i32_v8f32(ptr %x, ptr %y) {
; CHECK-LABEL: si2fp_v8i32_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    vse32.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x i32>, ptr %x
  %d = sitofp <8 x i32> %a to <8 x float>
  store <8 x float> %d, ptr %y
  ret void
}

define void @ui2fp_v8i32_v8f32(ptr %x, ptr %y) {
; CHECK-LABEL: ui2fp_v8i32_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    vse32.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x i32>, ptr %x
  %d = uitofp <8 x i32> %a to <8 x float>
  store <8 x float> %d, ptr %y
  ret void
}

define <8 x float> @si2fp_v8i1_v8f32(<8 x i1> %x) {
; CHECK-LABEL: si2fp_v8i1_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v10, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v10
; CHECK-NEXT:    ret
  %z = sitofp <8 x i1> %x to <8 x float>
  ret <8 x float> %z
}

define <8 x float> @ui2fp_v8i1_v8f32(<8 x i1> %x) {
; CHECK-LABEL: ui2fp_v8i1_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v10, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v10
; CHECK-NEXT:    ret
  %z = uitofp <8 x i1> %x to <8 x float>
  ret <8 x float> %z
}

define void @si2fp_v2i16_v2f64(ptr %x, ptr %y) {
; CHECK-LABEL: si2fp_v2i16_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    vse64.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x i16>, ptr %x
  %d = sitofp <2 x i16> %a to <2 x double>
  store <2 x double> %d, ptr %y
  ret void
}

define void @ui2fp_v2i16_v2f64(ptr %x, ptr %y) {
; CHECK-LABEL: ui2fp_v2i16_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    vse64.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x i16>, ptr %x
  %d = uitofp <2 x i16> %a to <2 x double>
  store <2 x double> %d, ptr %y
  ret void
}

define void @si2fp_v8i16_v8f64(ptr %x, ptr %y) {
; CHECK-LABEL: si2fp_v8i16_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsext.vf2 v12, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v12
; CHECK-NEXT:    vse64.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, ptr %x
  %d = sitofp <8 x i16> %a to <8 x double>
  store <8 x double> %d, ptr %y
  ret void
}

define void @ui2fp_v8i16_v8f64(ptr %x, ptr %y) {
; CHECK-LABEL: ui2fp_v8i16_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vzext.vf2 v12, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v12
; CHECK-NEXT:    vse64.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, ptr %x
  %d = uitofp <8 x i16> %a to <8 x double>
  store <8 x double> %d, ptr %y
  ret void
}

define <8 x double> @si2fp_v8i1_v8f64(<8 x i1> %x) {
; CHECK-LABEL: si2fp_v8i1_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v12, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v12
; CHECK-NEXT:    ret
  %z = sitofp <8 x i1> %x to <8 x double>
  ret <8 x double> %z
}

define <8 x double> @ui2fp_v8i1_v8f64(<8 x i1> %x) {
; CHECK-LABEL: ui2fp_v8i1_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v12, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v12
; CHECK-NEXT:    ret
  %z = uitofp <8 x i1> %x to <8 x double>
  ret <8 x double> %z
}

define void @si2fp_v2i64_v2bf16(ptr %x, ptr %y) {
; CHECK-LABEL: si2fp_v2i64_v2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfncvt.f.x.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    vse16.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, ptr %x
  %d = sitofp <2 x i64> %a to <2 x bfloat>
  store <2 x bfloat> %d, ptr %y
  ret void
}

define void @ui2fp_v2i64_v2bf16(ptr %x, ptr %y) {
; CHECK-LABEL: ui2fp_v2i64_v2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    vse16.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, ptr %x
  %d = uitofp <2 x i64> %a to <2 x bfloat>
  store <2 x bfloat> %d, ptr %y
  ret void
}

define <2 x bfloat> @si2fp_v2i1_v2bf16(<2 x i1> %x) {
; CHECK-LABEL: si2fp_v2i1_v2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %z = sitofp <2 x i1> %x to <2 x bfloat>
  ret <2 x bfloat> %z
}

define <2 x bfloat> @ui2fp_v2i1_v2bf16(<2 x i1> %x) {
; CHECK-LABEL: ui2fp_v2i1_v2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %z = uitofp <2 x i1> %x to <2 x bfloat>
  ret <2 x bfloat> %z
}

define void @si2fp_v8i64_v8bf16(ptr %x, ptr %y) {
; CHECK-LABEL: si2fp_v8i64_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfncvt.f.x.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    vse16.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x i64>, ptr %x
  %d = sitofp <8 x i64> %a to <8 x bfloat>
  store <8 x bfloat> %d, ptr %y
  ret void
}

define void @ui2fp_v8i64_v8bf16(ptr %x, ptr %y) {
; CHECK-LABEL: ui2fp_v8i64_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfncvt.f.xu.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    vse16.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x i64>, ptr %x
  %d = uitofp <8 x i64> %a to <8 x bfloat>
  store <8 x bfloat> %d, ptr %y
  ret void
}

define <8 x bfloat> @si2fp_v8i1_v8bf16(<8 x i1> %x) {
; CHECK-LABEL: si2fp_v8i1_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v10, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %z = sitofp <8 x i1> %x to <8 x bfloat>
  ret <8 x bfloat> %z
}

define <8 x bfloat> @ui2fp_v8i1_v8bf16(<8 x i1> %x) {
; CHECK-LABEL: ui2fp_v8i1_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %z = uitofp <8 x i1> %x to <8 x bfloat>
  ret <8 x bfloat> %z
}

define void @si2fp_v2i64_v2f16(ptr %x, ptr %y) {
; CHECK-LABEL: si2fp_v2i64_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfncvt.f.x.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v9
; CHECK-NEXT:    vse16.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, ptr %x
  %d = sitofp <2 x i64> %a to <2 x half>
  store <2 x half> %d, ptr %y
  ret void
}

define void @ui2fp_v2i64_v2f16(ptr %x, ptr %y) {
; CHECK-LABEL: ui2fp_v2i64_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v9
; CHECK-NEXT:    vse16.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, ptr %x
  %d = uitofp <2 x i64> %a to <2 x half>
  store <2 x half> %d, ptr %y
  ret void
}

define <2 x half> @si2fp_v2i1_v2f16(<2 x i1> %x) {
; ZVFH-LABEL: si2fp_v2i1_v2f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; ZVFH-NEXT:    vmv.v.i v8, 0
; ZVFH-NEXT:    vmerge.vim v9, v8, -1, v0
; ZVFH-NEXT:    vfwcvt.f.x.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: si2fp_v2i1_v2f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vmv.v.i v8, 0
; ZVFHMIN-NEXT:    vmerge.vim v8, v8, -1, v0
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %z = sitofp <2 x i1> %x to <2 x half>
  ret <2 x half> %z
}

define <2 x half> @ui2fp_v2i1_v2f16(<2 x i1> %x) {
; ZVFH-LABEL: ui2fp_v2i1_v2f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; ZVFH-NEXT:    vmv.v.i v8, 0
; ZVFH-NEXT:    vmerge.vim v9, v8, 1, v0
; ZVFH-NEXT:    vfwcvt.f.xu.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: ui2fp_v2i1_v2f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vmv.v.i v8, 0
; ZVFHMIN-NEXT:    vmerge.vim v8, v8, 1, v0
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %z = uitofp <2 x i1> %x to <2 x half>
  ret <2 x half> %z
}

define void @si2fp_v8i64_v8f16(ptr %x, ptr %y) {
; CHECK-LABEL: si2fp_v8i64_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfncvt.f.x.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v12
; CHECK-NEXT:    vse16.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x i64>, ptr %x
  %d = sitofp <8 x i64> %a to <8 x half>
  store <8 x half> %d, ptr %y
  ret void
}

define void @ui2fp_v8i64_v8f16(ptr %x, ptr %y) {
; CHECK-LABEL: ui2fp_v8i64_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfncvt.f.xu.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v12
; CHECK-NEXT:    vse16.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x i64>, ptr %x
  %d = uitofp <8 x i64> %a to <8 x half>
  store <8 x half> %d, ptr %y
  ret void
}

define <8 x half> @si2fp_v8i1_v8f16(<8 x i1> %x) {
; ZVFH-LABEL: si2fp_v8i1_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; ZVFH-NEXT:    vmv.v.i v8, 0
; ZVFH-NEXT:    vmerge.vim v9, v8, -1, v0
; ZVFH-NEXT:    vfwcvt.f.x.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: si2fp_v8i1_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vmv.v.i v8, 0
; ZVFHMIN-NEXT:    vmerge.vim v8, v8, -1, v0
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v10, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %z = sitofp <8 x i1> %x to <8 x half>
  ret <8 x half> %z
}

define <8 x half> @ui2fp_v8i1_v8f16(<8 x i1> %x) {
; ZVFH-LABEL: ui2fp_v8i1_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; ZVFH-NEXT:    vmv.v.i v8, 0
; ZVFH-NEXT:    vmerge.vim v9, v8, 1, v0
; ZVFH-NEXT:    vfwcvt.f.xu.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: ui2fp_v8i1_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vmv.v.i v8, 0
; ZVFHMIN-NEXT:    vmerge.vim v8, v8, 1, v0
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v10, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %z = uitofp <8 x i1> %x to <8 x half>
  ret <8 x half> %z
}
