; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc < %s -frame-pointer=all -mtriple=arm64-windows | FileCheck %s

; Test generated from C code:
; #include <stdarg.h>
; ptr foo() {
;   return _AddressOfReturnAddress();
; }
; int bar(int x(va_list, ptr), ...) {
;   va_list y;
;   va_start(y, x);
;   return x(y, _AddressOfReturnAddress()) + 1;
; }

declare void @llvm.va_start(ptr)
declare ptr @llvm.addressofreturnaddress()

define dso_local ptr @"foo"() {
; CHECK-LABEL: foo:
; CHECK:       .seh_proc foo
; CHECK-NEXT:  // %bb.0: // %entry
; CHECK-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_fplr_x 16
; CHECK-NEXT:    mov x29, sp
; CHECK-NEXT:    .seh_set_fp
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    add x0, x29, #8
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_fplr_x 16
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
entry:
  %0 = call ptr @llvm.addressofreturnaddress()
  ret ptr %0
}

define dso_local i32 @"bar"(ptr %x, ...) {
; CHECK-LABEL: bar:
; CHECK:       .seh_proc bar
; CHECK-NEXT:  // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #96
; CHECK-NEXT:    .seh_stackalloc 96
; CHECK-NEXT:    stp x29, x30, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    .seh_save_fplr 16
; CHECK-NEXT:    add x29, sp, #16
; CHECK-NEXT:    .seh_add_fp 16
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    add x9, x29, #24
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    stp x1, x2, [x29, #24]
; CHECK-NEXT:    stp x9, x0, [sp]
; CHECK-NEXT:    add x0, x29, #24
; CHECK-NEXT:    add x1, x29, #8
; CHECK-NEXT:    stp x3, x4, [x29, #40]
; CHECK-NEXT:    stp x5, x6, [x29, #56]
; CHECK-NEXT:    str x7, [x29, #72]
; CHECK-NEXT:    blr x8
; CHECK-NEXT:    add w0, w0, #1
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    ldp x29, x30, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    .seh_save_fplr 16
; CHECK-NEXT:    add sp, sp, #96
; CHECK-NEXT:    .seh_stackalloc 96
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
entry:
  %x.addr = alloca ptr, align 8
  %y = alloca ptr, align 8
  store ptr %x, ptr %x.addr, align 8
  call void @llvm.va_start(ptr %y)
  %0 = load ptr, ptr %x.addr, align 8
  %1 = call ptr @llvm.addressofreturnaddress()
  %2 = load ptr, ptr %y, align 8
  %call = call i32 %0(ptr %2, ptr %1)
  %add = add nsw i32 %call, 1
  ret i32 %add
}
