; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple arm64e-apple-darwin -global-isel=0                    -verify-machineinstrs \
; RUN:   -aarch64-ptrauth-auth-checks=none | FileCheck %s -DL="L" --check-prefixes=UNCHECKED,UNCHECKED-DARWIN
; RUN: llc < %s -mtriple arm64e-apple-darwin -global-isel -global-isel-abort=1 -verify-machineinstrs \
; RUN:   -aarch64-ptrauth-auth-checks=none | FileCheck %s -DL="L" --check-prefixes=UNCHECKED,UNCHECKED-DARWIN

; RUN: llc < %s -mtriple arm64e-apple-darwin -global-isel=0                    -verify-machineinstrs \
; RUN:                                     | FileCheck %s -DL="L" --check-prefixes=CHECKED,CHECKED-DARWIN
; RUN: llc < %s -mtriple arm64e-apple-darwin -global-isel -global-isel-abort=1 -verify-machineinstrs \
; RUN:                                     | FileCheck %s -DL="L" --check-prefixes=CHECKED,CHECKED-DARWIN

; RUN: llc < %s -mtriple arm64e-apple-darwin -global-isel=0                    -verify-machineinstrs \
; RUN:   -aarch64-ptrauth-auth-checks=trap | FileCheck %s -DL="L" --check-prefixes=TRAP,TRAP-DARWIN
; RUN: llc < %s -mtriple arm64e-apple-darwin -global-isel -global-isel-abort=1 -verify-machineinstrs \
; RUN:   -aarch64-ptrauth-auth-checks=trap | FileCheck %s -DL="L" --check-prefixes=TRAP,TRAP-DARWIN

; RUN: llc < %s -mtriple aarch64-linux-gnu -mattr=+pauth -global-isel=0                    -verify-machineinstrs \
; RUN:   -aarch64-ptrauth-auth-checks=none | FileCheck %s -DL=".L" --check-prefixes=UNCHECKED,UNCHECKED-ELF
; RUN: llc < %s -mtriple aarch64-linux-gnu -mattr=+pauth -global-isel -global-isel-abort=1 -verify-machineinstrs \
; RUN:   -aarch64-ptrauth-auth-checks=none | FileCheck %s -DL=".L" --check-prefixes=UNCHECKED,UNCHECKED-ELF

; RUN: llc < %s -mtriple aarch64-linux-gnu -mattr=+pauth -global-isel=0                    -verify-machineinstrs \
; RUN:                                     | FileCheck %s -DL=".L" --check-prefixes=CHECKED,CHECKED-ELF
; RUN: llc < %s -mtriple aarch64-linux-gnu -mattr=+pauth -global-isel -global-isel-abort=1 -verify-machineinstrs \
; RUN:                                     | FileCheck %s -DL=".L" --check-prefixes=CHECKED,CHECKED-ELF

; RUN: llc < %s -mtriple aarch64-linux-gnu -mattr=+pauth -global-isel=0                    -verify-machineinstrs \
; RUN:   -aarch64-ptrauth-auth-checks=trap | FileCheck %s -DL=".L" --check-prefixes=TRAP,TRAP-ELF
; RUN: llc < %s -mtriple aarch64-linux-gnu -mattr=+pauth -global-isel -global-isel-abort=1 -verify-machineinstrs \
; RUN:   -aarch64-ptrauth-auth-checks=trap | FileCheck %s -DL=".L" --check-prefixes=TRAP,TRAP-ELF

target datalayout = "e-m:o-i64:64-i128:128-n32:64-S128"

define i64 @test_auth_blend(i64 %arg, i64 %arg1) {
; UNCHECKED-LABEL: test_auth_blend:
; UNCHECKED:          %bb.0:
; UNCHECKED-DARWIN-NEXT: mov x16, x0
; UNCHECKED-DARWIN-NEXT: mov x17, x1
; UNCHECKED-DARWIN-NEXT: movk x17, #65535, lsl #48
; UNCHECKED-DARWIN-NEXT: autda x16, x17
; UNCHECKED-DARWIN-NEXT: mov x0, x16
; UNCHECKED-ELF-NEXT:    movk x1, #65535, lsl #48
; UNCHECKED-ELF-NEXT:    autda x0, x1
; UNCHECKED-NEXT:        ret
;
; CHECKED-LABEL: test_auth_blend:
; CHECKED:           %bb.0:
; CHECKED-DARWIN-NEXT: mov x16, x0
; CHECKED-DARWIN-NEXT: mov x17, x1
; CHECKED-DARWIN-NEXT: movk x17, #65535, lsl #48
; CHECKED-DARWIN-NEXT: autda x16, x17
; CHECKED-DARWIN-NEXT: mov x0, x16
; CHECKED-ELF-NEXT:    movk x1, #65535, lsl #48
; CHECKED-ELF-NEXT:    autda x0, x1
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_auth_blend:
; TRAP:       %bb.0:
; TRAP-DARWIN-NEXT: mov x16, x0
; TRAP-DARWIN-NEXT: mov x17, x1
; TRAP-DARWIN-NEXT: movk x17, #65535, lsl #48
; TRAP-DARWIN-NEXT: autda x16, x17
; TRAP-DARWIN-NEXT: mov x17, x16
; TRAP-DARWIN-NEXT: xpacd x17
; TRAP-DARWIN-NEXT: cmp x16, x17
; TRAP-ELF-NEXT: movk x1, #65535, lsl #48
; TRAP-ELF-NEXT: autda x0, x1
; TRAP-ELF-NEXT: mov x8, x0
; TRAP-ELF-NEXT: xpacd x8
; TRAP-ELF-NEXT: cmp x0, x8
; TRAP-NEXT:    b.eq [[L]]auth_success_0
; TRAP-NEXT:    brk #0xc472
; TRAP-NEXT:  Lauth_success_0:
; TRAP-DARWIN-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp0 = call i64 @llvm.ptrauth.blend(i64 %arg1, i64 65535)
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %arg, i32 2, i64 %tmp0)
  ret i64 %tmp1
}

define i64 @test_resign_blend(i64 %arg, i64 %arg1, i64 %arg2) {
; UNCHECKED-LABEL: test_resign_blend:
; UNCHECKED:       %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-ELF-NEXT:    movk x1, #12345, lsl #48
; UNCHECKED-ELF-NEXT:    autda x16, x1
; UNCHECKED-DARWIN-NEXT: mov x17, x1
; UNCHECKED-DARWIN-NEXT: movk x17, #12345, lsl #48
; UNCHECKED-DARWIN-NEXT: autda x16, x17
; UNCHECKED-NEXT:    mov x17, x2
; UNCHECKED-NEXT:    movk x17, #56789, lsl #48
; UNCHECKED-NEXT:    pacdb x16, x17
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_resign_blend:
; CHECKED:       %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-ELF-NEXT:    movk x1, #12345, lsl #48
; CHECKED-ELF-NEXT:    autda x16, x1
; CHECKED-DARWIN-NEXT: mov x17, x1
; CHECKED-DARWIN-NEXT: movk x17, #12345, lsl #48
; CHECKED-DARWIN-NEXT: autda x16, x17
; CHECKED-NEXT:    mov x17, x16
; CHECKED-NEXT:    xpacd x17
; CHECKED-NEXT:    cmp x16, x17
; CHECKED-NEXT:    b.eq [[L]]auth_success_0
; CHECKED-NEXT:    mov x16, x17
; CHECKED-NEXT:    b [[L]]resign_end_0
; CHECKED-NEXT:  Lauth_success_0:
; CHECKED-NEXT:    mov x17, x2
; CHECKED-NEXT:    movk x17, #56789, lsl #48
; CHECKED-NEXT:    pacdb x16, x17
; CHECKED-NEXT:  Lresign_end_0:
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_resign_blend:
; TRAP:       %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-ELF-NEXT:    movk x1, #12345, lsl #48
; TRAP-ELF-NEXT:    autda x16, x1
; TRAP-DARWIN-NEXT: mov x17, x1
; TRAP-DARWIN-NEXT: movk x17, #12345, lsl #48
; TRAP-DARWIN-NEXT: autda x16, x17
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    xpacd x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq [[L]]auth_success_1
; TRAP-NEXT:    brk #0xc472
; TRAP-NEXT:  Lauth_success_1:
; TRAP-NEXT:    mov x17, x2
; TRAP-NEXT:    movk x17, #56789, lsl #48
; TRAP-NEXT:    pacdb x16, x17
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp0 = call i64 @llvm.ptrauth.blend(i64 %arg1, i64 12345)
  %tmp1 = call i64 @llvm.ptrauth.blend(i64 %arg2, i64 56789)
  %tmp2 = call i64 @llvm.ptrauth.resign(i64 %arg, i32 2, i64 %tmp0, i32 3, i64 %tmp1)
  ret i64 %tmp2
}

define i64 @test_resign_blend_and_const(i64 %arg, i64 %arg1) {
; UNCHECKED-LABEL: test_resign_blend_and_const:
; UNCHECKED:       %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-ELF-NEXT:    movk x1, #12345, lsl #48
; UNCHECKED-ELF-NEXT:    autda x16, x1
; UNCHECKED-DARWIN-NEXT: mov x17, x1
; UNCHECKED-DARWIN-NEXT: movk x17, #12345, lsl #48
; UNCHECKED-DARWIN-NEXT: autda x16, x17
; UNCHECKED-NEXT:    mov x17, #56789
; UNCHECKED-NEXT:    pacdb x16, x17
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_resign_blend_and_const:
; CHECKED:       %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-ELF-NEXT:    movk x1, #12345, lsl #48
; CHECKED-ELF-NEXT:    autda x16, x1
; CHECKED-DARWIN-NEXT: mov x17, x1
; CHECKED-DARWIN-NEXT: movk x17, #12345, lsl #48
; CHECKED-DARWIN-NEXT: autda x16, x17
; CHECKED-NEXT:    mov x17, x16
; CHECKED-NEXT:    xpacd x17
; CHECKED-NEXT:    cmp x16, x17
; CHECKED-NEXT:    b.eq [[L]]auth_success_1
; CHECKED-NEXT:    mov x16, x17
; CHECKED-NEXT:    b [[L]]resign_end_1
; CHECKED-NEXT:  Lauth_success_1:
; CHECKED-NEXT:    mov x17, #56789
; CHECKED-NEXT:    pacdb x16, x17
; CHECKED-NEXT:  Lresign_end_1:
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_resign_blend_and_const:
; TRAP:       %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-ELF-NEXT:    movk x1, #12345, lsl #48
; TRAP-ELF-NEXT:    autda x16, x1
; TRAP-DARWIN-NEXT: mov x17, x1
; TRAP-DARWIN-NEXT: movk x17, #12345, lsl #48
; TRAP-DARWIN-NEXT: autda x16, x17
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    xpacd x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq [[L]]auth_success_2
; TRAP-NEXT:    brk #0xc472
; TRAP-NEXT:  Lauth_success_2:
; TRAP-NEXT:    mov x17, #56789
; TRAP-NEXT:    pacdb x16, x17
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp0 = call i64 @llvm.ptrauth.blend(i64 %arg1, i64 12345)
  %tmp1 = call i64 @llvm.ptrauth.resign(i64 %arg, i32 2, i64 %tmp0, i32 3, i64 56789)
  ret i64 %tmp1
}

define i64 @test_resign_blend_and_addr(i64 %arg, i64 %arg1, i64 %arg2) {
; UNCHECKED-LABEL: test_resign_blend_and_addr:
; UNCHECKED:       %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-ELF-NEXT:    movk x1, #12345, lsl #48
; UNCHECKED-ELF-NEXT:    autda x16, x1
; UNCHECKED-DARWIN-NEXT: mov x17, x1
; UNCHECKED-DARWIN-NEXT: movk x17, #12345, lsl #48
; UNCHECKED-DARWIN-NEXT: autda x16, x17
; UNCHECKED-NEXT:    pacdb x16, x2
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_resign_blend_and_addr:
; CHECKED:       %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-ELF-NEXT:    movk x1, #12345, lsl #48
; CHECKED-ELF-NEXT:    autda x16, x1
; CHECKED-DARWIN-NEXT: mov x17, x1
; CHECKED-DARWIN-NEXT: movk x17, #12345, lsl #48
; CHECKED-DARWIN-NEXT: autda x16, x17
; CHECKED-NEXT:    mov x17, x16
; CHECKED-NEXT:    xpacd x17
; CHECKED-NEXT:    cmp x16, x17
; CHECKED-NEXT:    b.eq [[L]]auth_success_2
; CHECKED-NEXT:    mov x16, x17
; CHECKED-NEXT:    b [[L]]resign_end_2
; CHECKED-NEXT:  Lauth_success_2:
; CHECKED-NEXT:    pacdb x16, x2
; CHECKED-NEXT:  Lresign_end_2:
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_resign_blend_and_addr:
; TRAP:       %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-ELF-NEXT:    movk x1, #12345, lsl #48
; TRAP-ELF-NEXT:    autda x16, x1
; TRAP-DARWIN-NEXT: mov x17, x1
; TRAP-DARWIN-NEXT: movk x17, #12345, lsl #48
; TRAP-DARWIN-NEXT: autda x16, x17
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    xpacd x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq [[L]]auth_success_3
; TRAP-NEXT:    brk #0xc472
; TRAP-NEXT:  Lauth_success_3:
; TRAP-NEXT:    pacdb x16, x2
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp0 = call i64 @llvm.ptrauth.blend(i64 %arg1, i64 12345)
  %tmp1 = call i64 @llvm.ptrauth.resign(i64 %arg, i32 2, i64 %tmp0, i32 3, i64 %arg2)
  ret i64 %tmp1
}

define i64 @test_auth_too_large_discriminator(i64 %arg, i64 %arg1) {
; UNCHECKED-LABEL:     test_auth_too_large_discriminator:
; UNCHECKED:           %bb.0:
; UNCHECKED-NEXT:        mov w8, #65536
; UNCHECKED-DARWIN-NEXT: bfi x1, x8, #48, #16
; UNCHECKED-DARWIN-NEXT: mov x16, x0
; UNCHECKED-DARWIN-NEXT: autda x16, x1
; UNCHECKED-DARWIN-NEXT: mov x0, x16
; UNCHECKED-ELF-NEXT:    bfi x1, x8, #48, #16
; UNCHECKED-ELF-NEXT:    autda x0, x1
; UNCHECKED-NEXT:        ret
;
; CHECKED-LABEL: test_auth_too_large_discriminator:
; CHECKED:           %bb.0:
; CHECKED-NEXT:        mov w8, #65536
; CHECKED-DARWIN-NEXT: bfi x1, x8, #48, #16
; CHECKED-DARWIN-NEXT: mov x16, x0
; CHECKED-DARWIN-NEXT: autda x16, x1
; CHECKED-DARWIN-NEXT: mov x0, x16
; CHECKED-ELF-NEXT:    bfi x1, x8, #48, #16
; CHECKED-ELF-NEXT:    autda x0, x1
; CHECKED-NEXT:        ret
;
; TRAP-LABEL: test_auth_too_large_discriminator:
; TRAP:           %bb.0:
; TRAP-NEXT:        mov w8, #65536
; TRAP-NEXT:        bfi x1, x8, #48, #16
; TRAP-DARWIN-NEXT: mov x16, x0
; TRAP-DARWIN-NEXT: autda x16, x1
; TRAP-DARWIN-NEXT: mov x17, x16
; TRAP-DARWIN-NEXT: xpacd x17
; TRAP-DARWIN-NEXT: cmp x16, x17
; TRAP-ELF-NEXT:    autda x0, x1
; TRAP-ELF-NEXT:    mov x8, x0
; TRAP-ELF-NEXT:    xpacd x8
; TRAP-ELF-NEXT:    cmp x0, x8
; TRAP-NEXT:        b.eq [[L]]auth_success_4
; TRAP-NEXT:        brk #0xc472
; TRAP-NEXT:      Lauth_success_4:
; TRAP-DARWIN-NEXT: mov x0, x16
; TRAP-NEXT:        ret
  %tmp0 = call i64 @llvm.ptrauth.blend(i64 %arg1, i64 65536)
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %arg, i32 2, i64 %tmp0)
  ret i64 %tmp1
}

declare i64 @llvm.ptrauth.auth(i64, i32, i64)
declare i64 @llvm.ptrauth.resign(i64, i32, i64, i32, i64)
declare i64 @llvm.ptrauth.blend(i64, i64)
